/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogHandler;
import org.postgresql.pljava.internal.ObjectPoolImpl;
import org.postgresql.pljava.internal.SubXactListener;
import org.postgresql.pljava.internal.TransactionalMap;
import org.postgresql.pljava.internal.XactListener;

public class Session
implements org.postgresql.pljava.Session {
    private final TransactionalMap m_attributes = new TransactionalMap((Map)new HashMap());

    public void addTransactionListener(TransactionListener transactionListener) {
        XactListener.addListener(transactionListener);
    }

    public void addSavepointListener(SavepointListener savepointListener) {
        SubXactListener.addListener(savepointListener);
    }

    public Object getAttribute(String string) {
        return this.m_attributes.get(string);
    }

    public ObjectPool getObjectPool(Class clazz) {
        return ObjectPoolImpl.getObjectPool(clazz);
    }

    public String getUserName() {
        return AclId.getUser().getName();
    }

    public String getSessionUserName() {
        return AclId.getSessionUser().getName();
    }

    public void removeAttribute(String string) {
        this.m_attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object);
    }

    public void removeTransactionListener(TransactionListener transactionListener) {
        XactListener.removeListener(transactionListener);
    }

    public void removeSavepointListener(SavepointListener savepointListener) {
        SubXactListener.removeListener(savepointListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeAsSessionUser(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            boolean bl;
            AclId aclId = AclId.getSessionUser();
            AclId aclId2 = AclId.getUser();
            if (aclId.equals(aclId2)) {
                return statement.execute(string);
            }
            try {
                Session._setUser(aclId);
                bl = statement.execute(string);
            }
            catch (Throwable throwable) {
                Session._setUser(aclId2);
                throw throwable;
            }
            Session._setUser(aclId2);
            return bl;
        }
    }

    static long init() throws SQLException {
        ELogHandler.init();
        return System.identityHashCode(Thread.currentThread());
    }

    private static native void _setUser(AclId var0);
}

