/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class ResultSetTest {
    private ArrayList m_results;

    public static Iterator executeSelect(String string) throws SQLException {
        if (!string.toUpperCase().trim().startsWith("SELECT ")) {
            throw new SQLException("Not a SELECT statement");
        }
        return new ResultSetTest(string).iterator();
    }

    public ResultSetTest(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        this.m_results = new ArrayList();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append((resultSetMetaData.getColumnName(i) + "(" + resultSetMetaData.getColumnClassName(i) + ")").replaceAll("(\\\\|;)", "\\$1") + ";");
        }
        this.m_results.add(stringBuffer.toString());
        while (resultSet.next()) {
            stringBuffer = new StringBuffer();
            Object object = null;
            for (int i = 1; i <= n; ++i) {
                object = resultSet.getObject(i);
                if (object == null) {
                    object = "<NULL>";
                }
                stringBuffer.append(object.toString().replaceAll("(\\\\|;)", "\\$1") + ";");
            }
            this.m_results.add(stringBuffer.toString());
        }
        resultSet.close();
    }

    private Iterator iterator() {
        return this.m_results.iterator();
    }

    public void close() {
    }
}

