/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.HashMap;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.Backend;

class XactListener {
    private static final HashMap s_listeners = new HashMap();

    XactListener() {
    }

    static void onAbort(long l) throws SQLException {
        TransactionListener transactionListener = (TransactionListener)s_listeners.get(new Long(l));
        if (transactionListener != null) {
            transactionListener.onAbort(Backend.getSession());
        }
    }

    static void onCommit(long l) throws SQLException {
        TransactionListener transactionListener = (TransactionListener)s_listeners.get(new Long(l));
        if (transactionListener != null) {
            transactionListener.onCommit(Backend.getSession());
        }
    }

    static void onPrepare(long l) throws SQLException {
        TransactionListener transactionListener = (TransactionListener)s_listeners.get(new Long(l));
        if (transactionListener != null) {
            transactionListener.onPrepare(Backend.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(TransactionListener transactionListener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long l = System.identityHashCode(transactionListener);
            if (s_listeners.put(new Long(l), transactionListener) != transactionListener) {
                XactListener._register(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(TransactionListener transactionListener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long l = System.identityHashCode(transactionListener);
            if (s_listeners.remove(new Long(l)) == transactionListener) {
                XactListener._unregister(l);
            }
        }
    }

    private static native void _register(long var0);

    private static native void _unregister(long var0);
}

