/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.util.HashMap;
import org.postgresql.pljava.internal.Backend;

public class Oid {
    private static final HashMap s_class2typeId = new HashMap();
    private final int m_native;

    static {
        System.loadLibrary("pljava");
        try {
            Class.forName("org.postgresql.pljava.jdbc.SPIDriver");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public Oid(int value) {
        this.m_native = value;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Oid && ((Oid)o).m_native == this.m_native;
    }

    public int hashCode() {
        return this.m_native;
    }

    public static void registerType(Class clazz, Oid typeId) {
        s_class2typeId.put(clazz, typeId);
    }

    public static Oid forJavaClass(Class clazz) {
        return (Oid)s_class2typeId.get(clazz);
    }

    public static Oid forSqlType(int sqlType) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Oid._forSqlType(sqlType);
        }
    }

    public static Oid getTypeId() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Oid._getTypeId();
        }
    }

    public String toString() {
        return "OID(" + this.m_native + ')';
    }

    private static native Oid _forSqlType(int var0);

    private static native Oid _getTypeId();
}

