/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;

public class SQLDeploymentDescriptor {
    private final ArrayList m_installCommands = new ArrayList();
    private final ArrayList m_removeCommands = new ArrayList();
    private final StringBuffer m_buffer = new StringBuffer();
    private final char[] m_image;
    private final String m_implementorName;
    private int m_position = 0;

    public SQLDeploymentDescriptor(String descImage, String implementorName) throws ParseException {
        this.m_image = descImage.toCharArray();
        this.m_implementorName = implementorName;
        this.readDescriptor();
    }

    public void install(Connection conn) throws SQLException {
        this.executeArray(this.m_installCommands, conn);
    }

    public void remove(Connection conn) throws SQLException {
        this.executeArray(this.m_removeCommands, conn);
    }

    public String toString() {
        return new String(this.m_image);
    }

    private void executeArray(ArrayList array, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        int top = array.size();
        int idx = 0;
        while (idx < top) {
            String cmd = (String)array.get(idx);
            stmt.execute(cmd);
            ++idx;
        }
        stmt.close();
    }

    private ParseException parseError(String msg) {
        return new ParseException(msg, this.m_position);
    }

    private void readDescriptor() throws ParseException {
        if (!"SQLACTIONS".equals(this.readIdentifier())) {
            throw this.parseError("Excpected keyword 'SQLActions'");
        }
        this.readToken('[');
        this.readToken(']');
        this.readToken('=');
        this.readToken('{');
        do {
            this.readActionGroup();
        } while (this.readToken("},") != '}');
        int c = this.skipWhite();
        if (c >= 0) {
            throw this.parseError("Extraneous characters at end of descriptor");
        }
    }

    private void readActionGroup() throws ParseException {
        ArrayList commands;
        this.readToken('\"');
        if (!"BEGIN".equals(this.readIdentifier())) {
            throw this.parseError("Excpected keyword 'BEGIN'");
        }
        String actionType = this.readIdentifier();
        if ("INSTALL".equals(actionType)) {
            commands = this.m_installCommands;
        } else if ("REMOVE".equals(actionType)) {
            commands = this.m_removeCommands;
        } else {
            throw this.parseError("Excpected keyword 'INSTALL' or 'REMOVE'");
        }
        while (true) {
            String cmd;
            int top;
            if ((top = (cmd = this.readCommand()).length()) >= 15 && "BEGIN ".equalsIgnoreCase(cmd.substring(0, 6)) && Character.isJavaIdentifierStart(cmd.charAt(6))) {
                int pos = 7;
                while (pos < top) {
                    if (!Character.isJavaIdentifierPart(cmd.charAt(pos))) break;
                    ++pos;
                }
                if (cmd.charAt(pos) != ' ') {
                    throw this.parseError("Expected whitespace after <implementor name>");
                }
                String implementorName = cmd.substring(6, pos);
                int iLen = implementorName.length();
                int endNamePos = top - iLen;
                int endPos = endNamePos - 4;
                if (!implementorName.equalsIgnoreCase(cmd.substring(endNamePos)) || !"END ".equalsIgnoreCase(cmd.substring(endPos, endNamePos))) {
                    throw this.parseError("Implementor block must end with END <implementor name>");
                }
                cmd = implementorName.equalsIgnoreCase(this.m_implementorName) ? cmd.substring(pos + 1, endPos) : null;
            }
            if (cmd != null) {
                commands.add(cmd.trim());
            }
            int savePos = this.m_position;
            try {
                String tmp = this.readIdentifier();
                if ("END".equals(tmp) && actionType.equals(tmp = this.readIdentifier())) break;
                this.m_position = savePos;
            }
            catch (ParseException e) {
                this.m_position = savePos;
            }
        }
        this.readToken('\"');
    }

    private String readCommand() throws ParseException {
        int startQuotePos = -1;
        int inQuote = 0;
        int c = this.skipWhite();
        this.m_buffer.setLength(0);
        block6: while (c != -1) {
            switch (c) {
                case 92: {
                    this.m_buffer.append((char)c);
                    c = this.read();
                    if (c == -1) continue block6;
                    this.m_buffer.append((char)c);
                    c = this.read();
                    break;
                }
                case 34: {
                    if (inQuote == 0) {
                        throw this.parseError("Unexpected double qoute in SQL command");
                    }
                    this.m_buffer.append((char)c);
                    c = this.read();
                    break;
                }
                case 39: {
                    if (inQuote == 0) {
                        startQuotePos = this.m_position;
                        inQuote = c;
                    } else if (inQuote == c) {
                        startQuotePos = -1;
                        inQuote = 0;
                    }
                    this.m_buffer.append((char)c);
                    c = this.read();
                    break;
                }
                case 59: {
                    if (inQuote == 0) {
                        return this.m_buffer.toString();
                    }
                    this.m_buffer.append((char)c);
                    c = this.read();
                    break;
                }
                default: {
                    if (inQuote == 0 && Character.isWhitespace((char)c)) {
                        this.m_buffer.append(' ');
                        c = this.skipWhite();
                        break;
                    }
                    this.m_buffer.append((char)c);
                    c = this.read();
                }
            }
        }
        if (inQuote != 0) {
            throw this.parseError("Untermintated " + (char)inQuote + " starting at position " + startQuotePos);
        }
        throw this.parseError("Unexpected EOF. Expecting ';' to end command");
    }

    /*
     * WARNING - void declaration
     */
    private int skipWhite() throws ParseException {
        void var1_1;
        block11: while (true) {
            int c;
            if ((c = this.read()) >= 0 && Character.isWhitespace((char)c)) {
                continue;
            }
            if (c != 47) break;
            switch (this.peek()) {
                case 47: {
                    this.skip();
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case -1: 
                            case 10: 
                            case 13: {
                                continue block11;
                            }
                        }
                    }
                }
                case 42: {
                    this.skip();
                    block13: while (true) {
                        c = this.read();
                        switch (c) {
                            case -1: {
                                throw this.parseError("Unexpected EOF when expecting end of multi line comment");
                            }
                            case 42: {
                                if (this.peek() != 47) continue block13;
                                this.skip();
                                continue block11;
                            }
                        }
                    }
                }
            }
            break;
        }
        return (int)var1_1;
    }

    private String readIdentifier() throws ParseException {
        int c = this.skipWhite();
        if (c < 0) {
            throw this.parseError("Unexpected EOF when expecting start of identifier");
        }
        char ch = (char)c;
        if (!Character.isJavaIdentifierStart(ch)) {
            throw this.parseError("Syntax error at '" + ch + "', expected identifier");
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(ch);
        while ((c = this.peek()) >= 0 && Character.isJavaIdentifierPart(ch = (char)c)) {
            this.m_buffer.append(ch);
            this.skip();
        }
        return this.m_buffer.toString().toUpperCase();
    }

    private char readToken(String tokens) throws ParseException {
        int c = this.skipWhite();
        if (c < 0) {
            throw this.parseError("Unexpected EOF when expecting one of \"" + tokens + '\"');
        }
        char ch = (char)c;
        if (tokens.indexOf(ch) < 0) {
            throw this.parseError("Syntax error at '" + ch + "', expected one of '" + tokens + "'");
        }
        return ch;
    }

    private char readToken(char token) throws ParseException {
        int c = this.skipWhite();
        if (c < 0) {
            throw this.parseError("Unexpected EOF when expecting token '" + token + '\'');
        }
        char ch = (char)c;
        if (ch != token) {
            throw this.parseError("Syntax error at '" + ch + "', expected '" + token + "'");
        }
        return ch;
    }

    private int peek() {
        return this.m_position >= this.m_image.length ? -1 : this.m_image[this.m_position];
    }

    private void skip() {
        ++this.m_position;
    }

    private int read() {
        int pos;
        return (pos = this.m_position++) >= this.m_image.length ? -1 : this.m_image[pos];
    }
}

