/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilDataProvider;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTempBuffer;
import com.microsoft.util.UtilTempBufferBlock;
import com.microsoft.util.UtilTempBufferInputStream;
import com.microsoft.util.UtilTempBufferOutputStream;
import com.microsoft.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class UtilPagedTempBuffer
implements UtilTempBuffer {
    private static String footprint = "$Revision:   1.8  $";
    private UtilTempBufferBlock[] blocks;
    protected byte[] staticByteArray;
    private int blockSize;
    private int blockShift;
    private File tmpFileInfo;
    private RandomAccessFile tmpFile;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    long nextAvail;
    static final int DEFAULT_NUM_BLOCKS = 128;
    static final int DEFAULT_BLOCK_SIZE = 16;
    static final int DEFAULT_BLOCK_SHIFT = 14;
    static final String TEMP_FILE_PREFIX = "ddtb";

    public UtilPagedTempBuffer() {
        this(128, 16);
    }

    public UtilPagedTempBuffer(int n) {
        this(n, 16);
    }

    public UtilPagedTempBuffer(int n, int n2) {
        this.blocks = new UtilTempBufferBlock[n];
        this.setBlockSize(n2);
        this.tmpFileInfo = null;
        this.tmpFile = null;
        this.nextAvail = 0L;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.staticByteArray = new byte[256];
    }

    private void closeInputStream() {
        block2: {
            if (this.lastInputStream == null) break block2;
            try {
                this.lastInputStream.close();
                this.lastInputStream = null;
            }
            catch (IOException iOException) {}
        }
    }

    private void closeOutputStream() {
        block2: {
            if (this.lastOutputStream == null) break block2;
            try {
                this.lastOutputStream.close();
                this.lastOutputStream = null;
            }
            catch (IOException iOException) {}
        }
    }

    private void compressBlockList() {
        UtilTempBufferBlock[] utilTempBufferBlockArray = this.blocks;
        UtilTempBufferBlock[] utilTempBufferBlockArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < utilTempBufferBlockArray.length) {
            if (utilTempBufferBlockArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            throw new OutOfMemoryError();
        }
        utilTempBufferBlockArray2 = new UtilTempBufferBlock[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < utilTempBufferBlockArray.length) {
            if (utilTempBufferBlockArray[n4] != null) {
                utilTempBufferBlockArray2[n3] = utilTempBufferBlockArray[n4];
                utilTempBufferBlockArray[n4] = null;
                if (++n3 == n) break;
            }
            ++n4;
        }
        this.blocks = utilTempBufferBlockArray2;
    }

    protected void finalize() throws Throwable {
        this.truncate(true);
    }

    private UtilTempBufferBlock getBlock(int n, boolean bl) throws UtilException {
        int n2 = n % this.blocks.length;
        if (this.blocks[n2] == null) {
            try {
                this.blocks[n2] = new UtilTempBufferBlock(this.blockSize);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.compressBlockList();
                n2 = n % this.blocks.length;
            }
        }
        UtilTempBufferBlock utilTempBufferBlock = this.blocks[n2];
        if (utilTempBufferBlock.blockNum != n) {
            if (utilTempBufferBlock.blockDirty) {
                this.writeTmpFile(utilTempBufferBlock);
            }
            utilTempBufferBlock.blockNum = n;
            utilTempBufferBlock.blockDirty = false;
            if (bl) {
                this.readTmpFile(utilTempBufferBlock);
                utilTempBufferBlock.blockDirty = false;
            }
        }
        return this.blocks[n2];
    }

    public InputStream getInputStream() {
        this.closeInputStream();
        this.lastInputStream = new UtilTempBufferInputStream(this);
        return this.lastInputStream;
    }

    public OutputStream getOutputStream() {
        this.closeOutputStream();
        this.lastOutputStream = new UtilTempBufferOutputStream(this);
        return this.lastOutputStream;
    }

    public long getSize() {
        return this.nextAvail;
    }

    private RandomAccessFile getTempFile() throws UtilException {
        if (this.tmpFile == null) {
            try {
                this.tmpFileInfo = UtilTempFile.createTempFile(TEMP_FILE_PREFIX);
                this.tmpFile = new RandomAccessFile(this.tmpFileInfo, "rw");
            }
            catch (IOException iOException) {
                throw new UtilException(1012, iOException.getMessage());
            }
        }
        return this.tmpFile;
    }

    public byte read(long l) throws UtilException {
        byte[] byArray = new byte[1];
        int n = this.read(l, byArray, 0, 1);
        if (n != 1) {
            throw new UtilException(1016);
        }
        return byArray[0];
    }

    public byte[] read(long l, int n) throws UtilException {
        byte[] byArray;
        int n2;
        if (l + (long)n > this.nextAvail) {
            n = (int)(this.nextAvail - l);
        }
        if ((n2 = this.read(l, byArray = new byte[n], 0, n)) != n) {
            throw new UtilException(1016);
        }
        return byArray;
    }

    public int read(long l, UtilDataConsumer utilDataConsumer, int n) throws UtilException {
        UtilDebug.assert("offset can not be negative", l >= 0L);
        UtilDebug.assert("dataConsumer can not be null", utilDataConsumer != null);
        UtilDebug.assert("length can not be negative", n >= 0);
        UtilDebug.assert("Attempting to read past end of file", l + (long)n <= this.nextAvail);
        if (l + (long)n > this.nextAvail) {
            n = (int)(this.nextAvail - l);
        }
        int n2 = (int)(l >> this.blockShift);
        int n3 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.blockSize - (n4 = (int)(l & (long)(this.blockSize - 1)))) > n) {
                n5 = n;
            }
            utilTempBufferBlock = this.getBlock(n2, true);
            utilDataConsumer.putArrayOfBytes(utilTempBufferBlock.data, n4, n5);
            n3 += n5;
            if ((n -= n5) == 0) break;
            l += (long)n5;
            ++n2;
        }
        return n3;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws UtilException {
        UtilDebug.assert("offset can not be negative", l >= 0L);
        UtilDebug.assert("buffer can not be null", byArray != null);
        UtilDebug.assert("bufferOffset can not be negative", n >= 0);
        UtilDebug.assert("length can not be negative", n2 >= 0);
        if (l + (long)n2 > this.nextAvail) {
            n2 = (int)(this.nextAvail - l);
        }
        int n3 = (int)(l >> this.blockShift);
        int n4 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            utilTempBufferBlock = this.getBlock(n3, true);
            System.arraycopy(utilTempBufferBlock.data, n5, byArray, n, n6);
            n4 += n6;
            if ((n2 -= n6) == 0) break;
            n += n6;
            l += (long)n6;
            ++n3;
        }
        return n4;
    }

    public int readInt(long l) throws UtilException {
        this.read(l, this.staticByteArray, 0, 2);
        int n = ((this.staticByteArray[0] & 0xFF) << 8) + (this.staticByteArray[1] & 0xFF);
        return n;
    }

    public long readLong(long l) throws UtilException {
        this.read(l, this.staticByteArray, 0, 8);
        long l2 = (((long)this.staticByteArray[0] & 0xFFL) << 56) + (((long)this.staticByteArray[1] & 0xFFL) << 48) + (((long)this.staticByteArray[2] & 0xFFL) << 40) + (((long)this.staticByteArray[3] & 0xFFL) << 32) + (((long)this.staticByteArray[4] & 0xFFL) << 24) + (((long)this.staticByteArray[5] & 0xFFL) << 16) + (((long)this.staticByteArray[6] & 0xFFL) << 8) + ((long)this.staticByteArray[7] & 0xFFL);
        return l2;
    }

    private void readTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n);
            randomAccessFile.read(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1014, iOException.getMessage());
        }
    }

    private void setBlockSize(int n) {
        if (n == 16) {
            this.blockSize = 16384;
            this.blockShift = 14;
        } else {
            int n2 = 1;
            while (n2 < 22) {
                int n3 = n >> n2;
                if (n >> n2 == 0) {
                    this.blockShift = n2 - 1 + 10;
                    break;
                }
                ++n2;
            }
            if (n2 == 22) {
                UtilDebug.assert("Invalid block size specified.  Block size is in KBytes and must be a power of 2", false);
                this.blockShift = 14;
            }
            this.blockSize = 1 << this.blockShift;
            UtilDebug.assert("Blocksize should be a power of two", this.blockSize == n * 1024);
        }
    }

    public void truncate() throws UtilException {
        this.nextAvail = 0L;
        this.closeInputStream();
        this.closeOutputStream();
        int n = 0;
        while (n < this.blocks.length) {
            UtilTempBufferBlock utilTempBufferBlock = this.blocks[n];
            if (utilTempBufferBlock != null) {
                utilTempBufferBlock.reset();
            }
            ++n;
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.setLength(0L);
            }
            catch (IOException iOException) {
                throw new UtilException(1015, iOException.getMessage());
            }
        }
    }

    public void truncate(boolean bl) throws UtilException {
        if (!bl) {
            this.truncate();
        } else {
            this.nextAvail = 0L;
            this.closeInputStream();
            this.closeOutputStream();
            if (this.tmpFile != null) {
                try {
                    this.tmpFile.close();
                    this.tmpFile = null;
                    this.tmpFileInfo.delete();
                    this.tmpFile = null;
                }
                catch (IOException iOException) {}
            }
            if (this.blocks != null) {
                int n = 0;
                while (n < this.blocks.length) {
                    this.blocks[n] = null;
                    ++n;
                }
            }
        }
    }

    public void write(long l, byte by) throws UtilException {
        byte[] byArray = new byte[]{by};
        this.write(l, byArray, 0, 1);
    }

    public int write(long l, UtilDataProvider utilDataProvider, int n) throws UtilException {
        UtilDebug.assert("offset can not be negative", l >= 0L);
        UtilDebug.assert("dataProvider can not be null", utilDataProvider != null);
        UtilDebug.assert("length can not be negative", n >= 0);
        UtilDebug.assert("Holes in temp file", l <= (this.nextAvail + 3L & 0xFFFFFFFFFFFFFFFCL));
        int n2 = (int)(l >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.blockSize - (n4 = (int)(l & (long)(this.blockSize - 1)))) > n) {
                n5 = n;
            }
            boolean bl = true;
            if (n5 == this.blockSize || l >= this.nextAvail) {
                bl = false;
            }
            utilTempBufferBlock = this.getBlock(n2, bl);
            utilTempBufferBlock.blockDirty = true;
            int n6 = n5;
            while (n6 > 0) {
                try {
                    int n7 = utilDataProvider.getArrayOfBytes(utilTempBufferBlock.data, n4, n6);
                    n6 -= n7;
                    n4 += n7;
                    n3 += n7;
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() == 1001) {
                        if ((l += (long)(n5 - n6)) > this.nextAvail) {
                            this.nextAvail = l;
                        }
                        return n3;
                    }
                    throw utilException;
                }
            }
            l += (long)n5;
            if ((n -= n5) == 0) break;
            ++n2;
        }
        if (l > this.nextAvail) {
            this.nextAvail = l;
        }
        return n3;
    }

    public void write(long l, byte[] byArray) throws UtilException {
        this.write(l, byArray, 0, byArray.length);
    }

    public void write(long l, byte[] byArray, int n, int n2) throws UtilException {
        UtilDebug.assert("offset can not be negative", l >= 0L);
        UtilDebug.assert("buffer can not be null", byArray != null);
        UtilDebug.assert("bufferOffset can not be negative", n >= 0);
        UtilDebug.assert("length can not be negative", n2 >= 0);
        UtilDebug.assert("Holes in temp file", l <= (this.nextAvail + 3L & 0xFFFFFFFFFFFFFFFCL));
        int n3 = (int)(l >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.blockSize - (n4 = (int)(l & (long)(this.blockSize - 1)))) > n2) {
                n5 = n2;
            }
            boolean bl = true;
            if (n5 == this.blockSize || l >= this.nextAvail) {
                bl = false;
            }
            utilTempBufferBlock = this.getBlock(n3, bl);
            utilTempBufferBlock.blockDirty = true;
            System.arraycopy(byArray, n, utilTempBufferBlock.data, n4, n5);
            l += (long)n5;
            if ((n2 -= n5) == 0) break;
            n += n5;
            ++n3;
        }
        if (l > this.nextAvail) {
            this.nextAvail = l;
        }
    }

    public int write(UtilDataProvider utilDataProvider) throws UtilException {
        return this.write(0L, utilDataProvider, Integer.MAX_VALUE);
    }

    public void writeInt(int n) throws UtilException {
        this.staticByteArray[0] = (byte)(n >>> 8 & 0xFF);
        this.staticByteArray[1] = (byte)(n & 0xFF);
        this.write(this.nextAvail, this.staticByteArray, 0, 2);
    }

    public void writeLong(long l) throws UtilException {
        this.staticByteArray[0] = (byte)(l >>> 56 & 0xFFL);
        this.staticByteArray[1] = (byte)(l >>> 48 & 0xFFL);
        this.staticByteArray[2] = (byte)(l >>> 40 & 0xFFL);
        this.staticByteArray[3] = (byte)(l >>> 32 & 0xFFL);
        this.staticByteArray[4] = (byte)(l >>> 24 & 0xFFL);
        this.staticByteArray[5] = (byte)(l >>> 16 & 0xFFL);
        this.staticByteArray[6] = (byte)(l >>> 8 & 0xFFL);
        this.staticByteArray[7] = (byte)(l & 0xFFL);
        this.write(this.nextAvail, this.staticByteArray, 0, 8);
    }

    private void writeTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n);
            randomAccessFile.write(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1013, iOException.getMessage());
        }
    }
}

