/* $Id: ci.h,v 1.3 2005/06/29 23:40:12 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * C Interface
 */
#ifndef PyPg_ci_H
#define PyPg_ci_H 0
#ifdef __cplusplus
extern "C" {
#endif

#include <pypg/cis.h>

/*
 * Call PyPgCI_Root() in a global context to give it visibility.
 */
#define PyPgCI_Define() struct PyPgCI_Root *PyPgCI_Root_;

/*
 * Initialize the root
 */
#define PyPgCI_Initialize(W) PyPgCI_Root_ = ((struct PyPgCI_Root *) W)

/*
 * If you don't have the module object, use this.
 */
#define PyPgCI_Import(M) \
	PyPgCI_Initialize(PyCObject_Import(M, PyPgCI_CObjectName))

/*
 * Use this to access the object. eg, PyPgCI.Type.Object
 */
#define PyPgCI (*(PyPgCI_Root_))

/*
 * Macro interfaces to types to allow dependencies to work. (PyPgXXX_New, etc)
 */
#define PyPgObject_Type (*((PyTypeObject *) (PyPgCI.Object.Type)))
#define PyPgType_Type (*((PyTypeObject *) (PyPgCI.Type.Type)))
#define PyPgRelation_Type (*((PyTypeObject *) (PyPgCI.Relation.Type)))
#define PyPgNamespace_Type (*((PyTypeObject *) (PyPgCI.Namespace.Type)))
#define PyPgFunction_Type (*((PyTypeObject *) (PyPgCI.Function.Type)))
#define PyPgHeapTuple_Type (*((PyTypeObject *) (PyPgCI.HeapTuple.Type)))
#define PyPgSavepoint_Type (*((PyTypeObject *) (PyPgCI.Savepoint.Type)))
#define PyPgTransaction_Type (*((PyTypeObject *) (PyPgCI.Transaction.Type)))
#define PyPgQuery_Type (*((PyTypeObject *) (PyPgCI.Query.Type)))
#define PyPgCall_Type (*((PyTypeObject *) (PyPgCI.Call.Type)))
#define PyPgPortal_Type (*((PyTypeObject *) (PyPgCI.Portal.Type)))
#define PyPgFunctionCall_Type (*((PyTypeObject *) (PyPgCI.FunctionCall.Type)))
#define PyPgProceduralCall_Type \
	(*((PyTypeObject *) (PyPgCI.ProceduralCall.Type)))
#define PyPgTriggerPull_Type (*((PyTypeObject *) (PyPgCI.TriggerPull.Type)))

#define PyPgObject_Initialize(...) PyPgCI.Object.Initialize(__VA_ARGS__)
#define PyPgRelation_Initialize(...) PyPgCI.Relation.Initialize(__VA_ARGS__)
#define PyPgNamespace_Initialize(...) PyPgCI.Namespace.Initialize(__VA_ARGS__)
#define PyPgFunction_Initialize(...) PyPgCI.Function.Initialize(__VA_ARGS__)
#define PyPgHeapTuple_Initialize(...) PyPgCI.HeapTuple.Initialize(__VA_ARGS__)
#define PyPgTupleDesc_Initialize(...) PyPgCI.TupleDesc.Initialize(__VA_ARGS__)
#define PyPgQuery_Initialize(...) PyPgCI.Query.Initialize(__VA_ARGS__)
#define PyPgCall_Initialize(...) PyPgCI.Call.Initialize(__VA_ARGS__)
#define PyPgPortal_Initialize(...) PyPgCI.Portal.Initialize(__VA_ARGS__)
#define PyPgFunctionCall_Initialize(...) \
	PyPgCI.FunctionCall.Initialize(__VA_ARGS__)
#define PyPgProceduralCall_Initialize(...) \
	PyPgCI.ProceduralCall.Initialize(__VA_ARGS__)
#define PyPgTriggerPull_Initialize(...) \
	PyPgCI.TriggerPull.Initialize(__VA_ARGS__)

#define PyPgFunction_FromOid(...) PyPgCI.Function.FromOid(__VA_ARGS__)
#define PyErr_SetPgError(...) PyPgCI.Error.SetPgError(__VA_ARGS__)
#define PyPgProceduralCall_InitializeParameters(...) \
	PyPgCI.ProceduralCall.InitializeParameters(__VA_ARGS__)

#define PyEncoding_FromPgEncoding(pgenc) \
	PyPgCI.Encoding.Lookup(pgenc)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_ci_H */
/*
 * vim: ts=3:sw=3:noet:
 */
