---
title: PostgreSQL JDBC Driver 42.2.11 Released
date: 2020-03-10 00:00:00 +0300
categories:
  - new_release
version: 42.2.11
---
**Notable changes**

We have released 42.2.12 to correct regressions in this version: Specifically
- [PR 1729](https://github.com/pgjdbc/pgjdbc/pull/1729) was reverted as this is a breaking change 
- [PR 1719](https://github.com/pgjdbc/pgjdbc/pull/1719) has been reverted as it introduced errors in the PgType Cache

We recommend that this version 42.2.11 not be used.


### Changed
 - Reverted [PR 1641](https://github.com/pgjdbc/pgjdbc/pull/1252). The driver will now wait for EOF when sending cancel signals. 
 - `DatabaseMetaData#getProcedures` returns only procedures (not functions) for PostgreSQL 11+ [PR 1723](https://github.com/pgjdbc/pgjdbc/pull/1723)
 - Convert silent rollbacks into exception if application sends `commit` or `xa.prepare` command [PR 1729](https://github.com/pgjdbc/pgjdbc/pull/1729)

### Added
 - Convert silent rollbacks into exception if application sends `commit` or `xa.prepare` command [PR 1729](https://github.com/pgjdbc/pgjdbc/pull/1729)
 - feat: Expose `ByteStreamWriter` in CopyManager [PR 1702](https://github.com/pgjdbc/pgjdbc/pull/1702)
 - feat: add way to distinguish base and partitioned tables in PgDatabaseMetaData.getTables [PR 1708](https://github.com/pgjdbc/pgjdbc/pull/1708)
 - refactor: introduce tuple abstraction (rebased) [PR 1701](https://github.com/pgjdbc/pgjdbc/pull/1701)
 - refactor: make PSQLState enum consts for integrity constraint violations [PR 1699](https://github.com/pgjdbc/pgjdbc/pull/1699)
 - test: add makefile to create ssl certs [PR 1706](https://github.com/pgjdbc/pgjdbc/pull/1706)

### Fixed
 - fix: Always use `.` as decimal separator in PGInterval [PR 1705](https://github.com/pgjdbc/pgjdbc/pull/1705)
 - fix: allow DatabaseMetaData.getColumns to describe an unset scale [PR 1716](https://github.com/pgjdbc/pgjdbc/pull/1716)


<!--more-->

**Commits by author**

Dave Cramer (4):

* remove the user of the word master internally  [PR 1713](https://github.com/pgjdbc/pgjdbc/pull/1713) [9a3e0f0c](https://github.com/pgjdbc/pgjdbc/commit/9a3e0f0ce92cc0a7addb369127b7790c5199cea3)
* Revert "feat: implementation of adaptive fetching [PR 1707](https://github.com/pgjdbc/pgjdbc/pull/1707)" (#1717) [13a644b4](https://github.com/pgjdbc/pgjdbc/commit/13a644b4945996dff5274e45741313380d4a47e6)
* document copy out not closing output stream [PR 1721](https://github.com/pgjdbc/pgjdbc/pull/1721) [0faf9ce2](https://github.com/pgjdbc/pgjdbc/commit/0faf9ce23a6c5f323545e374f0781b9c1d3cedcd)
* Update changelog for 42.2.11 [PR 1720](https://github.com/pgjdbc/pgjdbc/pull/1720)

Lőrinc Pap (2):

* refactor: introduce tuple abstraction (rebased) [PR 1701](https://github.com/pgjdbc/pgjdbc/pull/1701) [ed09fd11](https://github.com/pgjdbc/pgjdbc/commit/ed09fd1165f046ae956bf21b6c7882f1267fb8d7)
* Expose ByteStreamWriter in CopyManager [PR 1702](https://github.com/pgjdbc/pgjdbc/pull/1702) [1e4f4758](https://github.com/pgjdbc/pgjdbc/commit/1e4f4758544f494e997688b28a4fa94fb5782265)

Magnus Reftel (1):

* docs: document SocketFactory(Properties) [PR 1696](https://github.com/pgjdbc/pgjdbc/pull/1696) [8a8e8ff0](https://github.com/pgjdbc/pgjdbc/commit/8a8e8ff0a4360985373c98fa1ef16d5bf21968e0)

Markus Winand (1):

* Typo in documentation (case instead of cast) [PR 1715](https://github.com/pgjdbc/pgjdbc/pull/1715) [630692d6](https://github.com/pgjdbc/pgjdbc/commit/630692d6823d9ca65059c59ab01d184b33d8ea9c)

Mike Goodman (4):

* refactor: make PSQLState enum consts for integrity constraint violations [PR 1699](https://github.com/pgjdbc/pgjdbc/pull/1699) [cc31c13f](https://github.com/pgjdbc/pgjdbc/commit/cc31c13f7810e171c54729a29f494d69b7f1550a)
* feat: add way to distinguish base and partitioned tables in PgDatabaseMetaData.getTables [PR 1708](https://github.com/pgjdbc/pgjdbc/pull/1708) [25eb32c8](https://github.com/pgjdbc/pgjdbc/commit/25eb32c8681eaa4aaac801808b6028e9f5dfbea8)
* fix: add support for full names of data types [PR 1719](https://github.com/pgjdbc/pgjdbc/pull/1719) [f554118a](https://github.com/pgjdbc/pgjdbc/commit/f554118a95cda1470fc7ac8b67b8ae7c18b25826)
* fix: getProcedures returns only procedures (not functions) for psql11+ [PR 1723](https://github.com/pgjdbc/pgjdbc/pull/1723) [5fbe0462](https://github.com/pgjdbc/pgjdbc/commit/5fbe04626c64b7c46a22a0cea108921305b14074)

Nick Mancuso (1):

* perf: upgrade maven-checkstyle-plugin to 3.1.1 [PR 1726](https://github.com/pgjdbc/pgjdbc/pull/1726) [7da60074](https://github.com/pgjdbc/pgjdbc/commit/7da60074916c063c18d6c91e92e5cb360de69cd3)

Sehrope Sarkuni (2):

* fix: Correct sort order of PGProperty.ASSUME_MIN_SERVER_VERSION [3ea08125](https://github.com/pgjdbc/pgjdbc/commit/3ea0812572e013dbad6b67a730255d17b467fb71)
* test: Add test to check sort order of PGProperty values [aa1b93f1](https://github.com/pgjdbc/pgjdbc/commit/aa1b93f1286a308d632e3fcdf53a773cf428a18c)

Toddy69 (1):

* fix: Always use . as decimal separator in PGInterval. [PR 1705](https://github.com/pgjdbc/pgjdbc/pull/1705) [94641ef0](https://github.com/pgjdbc/pgjdbc/commit/94641ef08922d77ac021f70af91cafe85866d854)

Vladimir Sitnikov (11):

* test: skip PKCS12KeyTest when enable_ssl_tests is not set [6730f3fe](https://github.com/pgjdbc/pgjdbc/commit/6730f3febda64891ee445fd53a858ce0d9b56ac3)
* test: add makefile for creating test certificates [202f88e1](https://github.com/pgjdbc/pgjdbc/commit/202f88e13c11fef11994c8f38456f36b3beec714)
* Revert "fix: remove receiving EOF from backend after cancel since according to protocol the server closes the connection once cancel is sent (connection reset exception is always thrown) [PR 1641](https://github.com/pgjdbc/pgjdbc/pull/1641)" [ca1f60ff](https://github.com/pgjdbc/pgjdbc/commit/ca1f60ffb414891101b72a226ed4f36f97bf82e2)
* Revert "fix unstable test. Originally this would loop creating many statements, now it should timeout properly [PR 1650](https://github.com/pgjdbc/pgjdbc/pull/1650)" [5eabe1ae](https://github.com/pgjdbc/pgjdbc/commit/5eabe1ae5e0b637944d77ca3df96e1b36d6efda7)
* style: compute nanoseconds with TimeUnit.SECONDS.toNanos [b004c706](https://github.com/pgjdbc/pgjdbc/commit/b004c706fd7fdb2e05f53eb2cdd4826671c379a4)
* revert: use simple executor.shutdown() in testFastCloses [fc5467c6](https://github.com/pgjdbc/pgjdbc/commit/fc5467c67cbd22de7afd909f8a5dd928072a6c49)
* Move CopyBothResponseTest to replication folder [2509b663](https://github.com/pgjdbc/pgjdbc/commit/2509b66370839a73d2b19e3b16c466192ba0bed1)
* doc: fix HTML5 errors in javadoc [161ea249](https://github.com/pgjdbc/pgjdbc/commit/161ea24965b3d11067f96b9765cda10f8b59e08b)
* fix: convert silent rollbacks into exception if application sends commit command [PR 1729](https://github.com/pgjdbc/pgjdbc/pull/1729) [adcb194e](https://github.com/pgjdbc/pgjdbc/commit/adcb194e7279e67cedd66f0535bb2b875c599459)
* chore: add continuation_indent_size = 4 to .editorconfig for *.java [45d5831e](https://github.com/pgjdbc/pgjdbc/commit/45d5831ed6d65c13c8e5cf23f7367b570ec2fbc4)
* chore: remove end_of_line = lf from .editorconfig for .java [7ce254d2](https://github.com/pgjdbc/pgjdbc/commit/7ce254d2b45e036f537a1c04d3ef5d4ad19c4fed)

adrklos (1):

* (reverted) feat: implementation of adaptive fetching [PR 1707](https://github.com/pgjdbc/pgjdbc/pull/1707) [5bb5f409](https://github.com/pgjdbc/pgjdbc/commit/5bb5f409b8372e4be86c14a00309ab60b8e17ed8)

crwr45 (1):

* fix: allow DatabaseMetaData.getColumns to describe an unset scale [PR 1716](https://github.com/pgjdbc/pgjdbc/pull/1716) [30843e45](https://github.com/pgjdbc/pgjdbc/commit/30843e45edc1e2bac499df2d1576c2db4d3d3309)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[adrklos](https://github.com/adrklos)  
[crwr45](https://github.com/crwr45)  
[Dave Cramer](davec@postgresintl.com)  
[Lőrinc Pap](https://github.com/paplorinc)  
[Magnus Reftel](https://github.com/reftel)  
[Markus Winand](https://github.com/fatalmind)  
[Mike Goodman](https://github.com/MSGoodman)  
[Nick Mancuso](https://github.com/nmancus1)  
[Sehrope Sarkuni](https://github.com/sehrope)  
[Toddy69](https://github.com/Toddy69)  
[Vladimir Sitnikov](https://github.com/vlsi)  
