# frozen_string_literal: true

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/serialize.rb.erb
if you are looking to modify the template
=end

require "stringio"
require_relative "polyfill/unpack1"

module Prism
  # A module responsible for deserializing parse results.
  module Serialize
    # The major version of prism that we are expecting to find in the serialized
    # strings.
    MAJOR_VERSION = 1

    # The minor version of prism that we are expecting to find in the serialized
    # strings.
    MINOR_VERSION = 0

    # The patch version of prism that we are expecting to find in the serialized
    # strings.
    PATCH_VERSION = 0

    # Deserialize the AST represented by the given string into a parse result.
    def self.load(input, serialized)
      input = input.dup
      source = Source.for(input)
      loader = Loader.new(source, serialized)
      result = loader.load_result

      input.force_encoding(loader.encoding)
      result
    end

    # Deserialize the tokens represented by the given string into a parse
    # result.
    def self.load_tokens(source, serialized)
      Loader.new(source, serialized).load_tokens_result
    end

    class Loader # :nodoc:
      if RUBY_ENGINE == "truffleruby"
        # StringIO is synchronized and that adds a high overhead on TruffleRuby.
        class FastStringIO # :nodoc:
          attr_accessor :pos

          def initialize(string)
            @string = string
            @pos = 0
          end

          def getbyte
            byte = @string.getbyte(@pos)
            @pos += 1
            byte
          end

          def read(n)
            slice = @string.byteslice(@pos, n)
            @pos += n
            slice
          end

          def eof?
            @pos >= @string.bytesize
          end
        end
      else
        FastStringIO = ::StringIO
      end
      private_constant :FastStringIO

      attr_reader :encoding, :input, :serialized, :io
      attr_reader :constant_pool_offset, :constant_pool, :source
      attr_reader :start_line

      def initialize(source, serialized)
        @encoding = Encoding::UTF_8

        @input = source.source.dup
        raise unless serialized.encoding == Encoding::BINARY
        @serialized = serialized
        @io = FastStringIO.new(serialized)

        @constant_pool_offset = nil
        @constant_pool = nil

        @source = source
        define_load_node_lambdas unless RUBY_ENGINE == "ruby"
      end

      def load_header
        raise "Invalid serialization" if io.read(5) != "PRISM"
        raise "Invalid serialization" if io.read(3).unpack("C3") != [MAJOR_VERSION, MINOR_VERSION, PATCH_VERSION]
        only_semantic_fields = io.getbyte
        unless only_semantic_fields == 0
          raise "Invalid serialization (location fields must be included but are not)"
        end
      end

      def load_encoding
        @encoding = Encoding.find(io.read(load_varuint))
        @input = input.force_encoding(@encoding).freeze
        @encoding
      end

      def load_start_line
        source.instance_variable_set :@start_line, load_varsint
      end

      def load_line_offsets
        source.instance_variable_set :@offsets, Array.new(load_varuint) { load_varuint }
      end

      def load_comments
        Array.new(load_varuint) do
          case load_varuint
          when 0 then InlineComment.new(load_location_object)
          when 1 then EmbDocComment.new(load_location_object)
          end
        end
      end

      DIAGNOSTIC_TYPES = [
        :alias_argument,
        :alias_argument_numbered_reference,
        :ampampeq_multi_assign,
        :argument_after_block,
        :argument_after_forwarding_ellipses,
        :argument_bare_hash,
        :argument_block_forwarding,
        :argument_block_multi,
        :argument_conflict_ampersand,
        :argument_conflict_star,
        :argument_conflict_star_star,
        :argument_formal_class,
        :argument_formal_constant,
        :argument_formal_global,
        :argument_formal_ivar,
        :argument_forwarding_unbound,
        :argument_no_forwarding_ampersand,
        :argument_no_forwarding_ellipses,
        :argument_no_forwarding_star,
        :argument_no_forwarding_star_star,
        :argument_splat_after_assoc_splat,
        :argument_splat_after_splat,
        :argument_term_paren,
        :argument_unexpected_block,
        :array_element,
        :array_expression,
        :array_expression_after_star,
        :array_separator,
        :array_term,
        :begin_lonely_else,
        :begin_term,
        :begin_upcase_brace,
        :begin_upcase_term,
        :begin_upcase_toplevel,
        :block_param_local_variable,
        :block_param_pipe_term,
        :block_term_brace,
        :block_term_end,
        :cannot_parse_expression,
        :cannot_parse_string_part,
        :case_expression_after_case,
        :case_expression_after_when,
        :case_match_missing_predicate,
        :case_missing_conditions,
        :case_term,
        :class_in_method,
        :class_name,
        :class_superclass,
        :class_term,
        :class_unexpected_end,
        :class_variable_bare,
        :conditional_elsif_predicate,
        :conditional_if_predicate,
        :conditional_predicate_term,
        :conditional_term,
        :conditional_term_else,
        :conditional_unless_predicate,
        :conditional_until_predicate,
        :conditional_while_predicate,
        :constant_path_colon_colon_constant,
        :def_endless,
        :def_endless_setter,
        :def_name,
        :def_params_term,
        :def_params_term_paren,
        :def_receiver,
        :def_receiver_term,
        :def_term,
        :defined_expression,
        :embdoc_term,
        :embexpr_end,
        :embvar_invalid,
        :end_upcase_brace,
        :end_upcase_term,
        :escape_invalid_control,
        :escape_invalid_control_repeat,
        :escape_invalid_hexadecimal,
        :escape_invalid_meta,
        :escape_invalid_meta_repeat,
        :escape_invalid_unicode,
        :escape_invalid_unicode_cm_flags,
        :escape_invalid_unicode_list,
        :escape_invalid_unicode_literal,
        :escape_invalid_unicode_long,
        :escape_invalid_unicode_short,
        :escape_invalid_unicode_term,
        :expect_argument,
        :expect_eol_after_statement,
        :expect_expression_after_ampampeq,
        :expect_expression_after_comma,
        :expect_expression_after_equal,
        :expect_expression_after_less_less,
        :expect_expression_after_lparen,
        :expect_expression_after_operator,
        :expect_expression_after_pipepipeeq,
        :expect_expression_after_question,
        :expect_expression_after_splat,
        :expect_expression_after_splat_hash,
        :expect_expression_after_star,
        :expect_for_delimiter,
        :expect_ident_req_parameter,
        :expect_in_delimiter,
        :expect_lparen_req_parameter,
        :expect_message,
        :expect_rbracket,
        :expect_rparen,
        :expect_rparen_after_multi,
        :expect_rparen_req_parameter,
        :expect_singleton_class_delimiter,
        :expect_string_content,
        :expect_when_delimiter,
        :expression_bare_hash,
        :expression_not_writable,
        :expression_not_writable_encoding,
        :expression_not_writable_false,
        :expression_not_writable_file,
        :expression_not_writable_line,
        :expression_not_writable_nil,
        :expression_not_writable_numbered,
        :expression_not_writable_self,
        :expression_not_writable_true,
        :float_parse,
        :for_collection,
        :for_in,
        :for_index,
        :for_term,
        :global_variable_bare,
        :hash_expression_after_label,
        :hash_key,
        :hash_rocket,
        :hash_term,
        :hash_value,
        :heredoc_identifier,
        :heredoc_term,
        :incomplete_question_mark,
        :incomplete_variable_class,
        :incomplete_variable_class_3_3,
        :incomplete_variable_instance,
        :incomplete_variable_instance_3_3,
        :instance_variable_bare,
        :invalid_block_exit,
        :invalid_character,
        :invalid_encoding_magic_comment,
        :invalid_escape_character,
        :invalid_float_exponent,
        :invalid_local_variable_read,
        :invalid_local_variable_write,
        :invalid_multibyte_char,
        :invalid_multibyte_character,
        :invalid_multibyte_escape,
        :invalid_number_binary,
        :invalid_number_decimal,
        :invalid_number_fraction,
        :invalid_number_hexadecimal,
        :invalid_number_octal,
        :invalid_number_underscore_inner,
        :invalid_number_underscore_trailing,
        :invalid_percent,
        :invalid_percent_eof,
        :invalid_printable_character,
        :invalid_retry_after_else,
        :invalid_retry_after_ensure,
        :invalid_retry_without_rescue,
        :invalid_symbol,
        :invalid_variable_global,
        :invalid_variable_global_3_3,
        :invalid_yield,
        :it_not_allowed_numbered,
        :it_not_allowed_ordinary,
        :lambda_open,
        :lambda_term_brace,
        :lambda_term_end,
        :list_i_lower_element,
        :list_i_lower_term,
        :list_i_upper_element,
        :list_i_upper_term,
        :list_w_lower_element,
        :list_w_lower_term,
        :list_w_upper_element,
        :list_w_upper_term,
        :malloc_failed,
        :mixed_encoding,
        :module_in_method,
        :module_name,
        :module_term,
        :multi_assign_multi_splats,
        :multi_assign_unexpected_rest,
        :nesting_too_deep,
        :no_local_variable,
        :non_associative_operator,
        :not_expression,
        :number_literal_underscore,
        :numbered_parameter_inner_block,
        :numbered_parameter_it,
        :numbered_parameter_ordinary,
        :numbered_parameter_outer_block,
        :operator_multi_assign,
        :operator_write_arguments,
        :operator_write_block,
        :parameter_assoc_splat_multi,
        :parameter_block_multi,
        :parameter_circular,
        :parameter_forwarding_after_rest,
        :parameter_method_name,
        :parameter_name_duplicated,
        :parameter_no_default,
        :parameter_no_default_kw,
        :parameter_numbered_reserved,
        :parameter_order,
        :parameter_splat_multi,
        :parameter_star,
        :parameter_unexpected_fwd,
        :parameter_unexpected_no_kw,
        :parameter_wild_loose_comma,
        :pattern_array_multiple_rests,
        :pattern_capture_duplicate,
        :pattern_expression_after_bracket,
        :pattern_expression_after_comma,
        :pattern_expression_after_hrocket,
        :pattern_expression_after_in,
        :pattern_expression_after_key,
        :pattern_expression_after_paren,
        :pattern_expression_after_pin,
        :pattern_expression_after_pipe,
        :pattern_expression_after_range,
        :pattern_expression_after_rest,
        :pattern_find_missing_inner,
        :pattern_hash_implicit,
        :pattern_hash_key,
        :pattern_hash_key_duplicate,
        :pattern_hash_key_interpolated,
        :pattern_hash_key_label,
        :pattern_hash_key_locals,
        :pattern_ident_after_hrocket,
        :pattern_label_after_comma,
        :pattern_rest,
        :pattern_term_brace,
        :pattern_term_bracket,
        :pattern_term_paren,
        :pipepipeeq_multi_assign,
        :regexp_encoding_option_mismatch,
        :regexp_incompat_char_encoding,
        :regexp_invalid_unicode_range,
        :regexp_non_escaped_mbc,
        :regexp_parse_error,
        :regexp_term,
        :regexp_unknown_options,
        :regexp_utf8_char_non_utf8_regexp,
        :rescue_expression,
        :rescue_modifier_value,
        :rescue_term,
        :rescue_variable,
        :return_invalid,
        :script_not_found,
        :singleton_for_literals,
        :statement_alias,
        :statement_postexe_end,
        :statement_preexe_begin,
        :statement_undef,
        :string_concatenation,
        :string_interpolated_term,
        :string_literal_eof,
        :string_literal_term,
        :symbol_invalid,
        :symbol_term_dynamic,
        :symbol_term_interpolated,
        :ternary_colon,
        :ternary_expression_false,
        :ternary_expression_true,
        :unary_disallowed,
        :unary_receiver,
        :undef_argument,
        :unexpected_block_argument,
        :unexpected_index_block,
        :unexpected_index_keywords,
        :unexpected_label,
        :unexpected_multi_write,
        :unexpected_range_operator,
        :unexpected_safe_navigation,
        :unexpected_token_close_context,
        :unexpected_token_ignore,
        :until_term,
        :void_expression,
        :while_term,
        :write_target_in_method,
        :write_target_readonly,
        :write_target_unexpected,
        :xstring_term,
        :ambiguous_binary_operator,
        :ambiguous_first_argument_minus,
        :ambiguous_first_argument_plus,
        :ambiguous_prefix_ampersand,
        :ambiguous_prefix_star,
        :ambiguous_prefix_star_star,
        :ambiguous_slash,
        :comparison_after_comparison,
        :dot_dot_dot_eol,
        :equal_in_conditional,
        :equal_in_conditional_3_3,
        :end_in_method,
        :duplicated_hash_key,
        :duplicated_when_clause,
        :float_out_of_range,
        :ignored_frozen_string_literal,
        :indentation_mismatch,
        :integer_in_flip_flop,
        :invalid_character,
        :invalid_magic_comment_value,
        :invalid_numbered_reference,
        :keyword_eol,
        :literal_in_condition_default,
        :literal_in_condition_verbose,
        :shareable_constant_value_line,
        :shebang_carriage_return,
        :unexpected_carriage_return,
        :unreachable_statement,
        :unused_local_variable,
        :void_statement,
      ].freeze

      private_constant :DIAGNOSTIC_TYPES

      def load_metadata
        comments = load_comments
        magic_comments = Array.new(load_varuint) { MagicComment.new(load_location_object, load_location_object) }
        data_loc = load_optional_location_object
        errors = Array.new(load_varuint) { ParseError.new(DIAGNOSTIC_TYPES.fetch(load_varuint), load_embedded_string, load_location_object, load_error_level) }
        warnings = Array.new(load_varuint) { ParseWarning.new(DIAGNOSTIC_TYPES.fetch(load_varuint), load_embedded_string, load_location_object, load_warning_level) }
        [comments, magic_comments, data_loc, errors, warnings]
      end

      def load_tokens
        tokens = []
        while type = TOKEN_TYPES.fetch(load_varuint)
          start = load_varuint
          length = load_varuint
          lex_state = load_varuint
          location = Location.new(@source, start, length)
          tokens << [Token.new(source, type, location.slice, location), lex_state]
        end

        tokens
      end

      def load_tokens_result
        tokens = load_tokens
        encoding = load_encoding
        load_start_line
        load_line_offsets
        comments, magic_comments, data_loc, errors, warnings = load_metadata
        tokens.each { |token,| token.value.force_encoding(encoding) }

        raise "Expected to consume all bytes while deserializing" unless @io.eof?
        LexResult.new(tokens, comments, magic_comments, data_loc, errors, warnings, @source)
      end

      def load_nodes
        load_header
        load_encoding
        load_start_line
        load_line_offsets

        comments, magic_comments, data_loc, errors, warnings = load_metadata

        @constant_pool_offset = load_uint32
        @constant_pool = Array.new(load_varuint, nil)

        [load_node, comments, magic_comments, data_loc, errors, warnings]
      end

      def load_result
        node, comments, magic_comments, data_loc, errors, warnings = load_nodes
        ParseResult.new(node, comments, magic_comments, data_loc, errors, warnings, @source)
      end

      private

      # variable-length integer using https://en.wikipedia.org/wiki/LEB128
      # This is also what protobuf uses: https://protobuf.dev/programming-guides/encoding/#varints
      def load_varuint
        n = io.getbyte
        if n < 128
          n
        else
          n -= 128
          shift = 0
          while (b = io.getbyte) >= 128
            n += (b - 128) << (shift += 7)
          end
          n + (b << (shift + 7))
        end
      end

      def load_varsint
        n = load_varuint
        (n >> 1) ^ (-(n & 1))
      end

      def load_integer
        negative = io.getbyte != 0
        length = load_varuint

        value = 0
        length.times { |index| value |= (load_varuint << (index * 32)) }

        value = -value if negative
        value
      end

      def load_double
        io.read(8).unpack1("D")
      end

      def load_uint32
        io.read(4).unpack1("L")
      end

      def load_optional_node
        if io.getbyte != 0
          io.pos -= 1
          load_node
        end
      end

      def load_embedded_string
        io.read(load_varuint).force_encoding(encoding)
      end

      def load_string
        type = io.getbyte
        case type
        when 1
          input.byteslice(load_varuint, load_varuint).force_encoding(encoding)
        when 2
          load_embedded_string
        else
          raise "Unknown serialized string type: #{type}"
        end
      end

      def load_location
        (load_varuint << 32) | load_varuint
      end

      def load_location_object
        Location.new(source, load_varuint, load_varuint)
      end

      def load_optional_location
        load_location if io.getbyte != 0
      end

      def load_optional_location_object
        load_location_object if io.getbyte != 0
      end

      def load_constant(index)
        constant = constant_pool[index]

        unless constant
          offset = constant_pool_offset + index * 8
          start = @serialized.unpack1("L", offset: offset)
          length = @serialized.unpack1("L", offset: offset + 4)

          constant =
            if start.nobits?(1 << 31)
              input.byteslice(start, length).force_encoding(@encoding).to_sym
            else
              @serialized.byteslice(start & ((1 << 31) - 1), length).force_encoding(@encoding).to_sym
            end

          constant_pool[index] = constant
        end

        constant
      end

      def load_required_constant
        load_constant(load_varuint - 1)
      end

      def load_optional_constant
        index = load_varuint
        load_constant(index - 1) if index != 0
      end

      def load_error_level
        level = io.getbyte

        case level
        when 0
          :syntax
        when 1
          :argument
        when 2
          :load
        else
          raise "Unknown level: #{level}"
        end
      end

      def load_warning_level
        level = io.getbyte

        case level
        when 0
          :default
        when 1
          :verbose
        else
          raise "Unknown level: #{level}"
        end
      end

      if RUBY_ENGINE == "ruby"
        def load_node
          type = io.getbyte
          node_id = load_varuint
          location = load_location

          case type
          when 1 then
            AliasGlobalVariableNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 2 then
            AliasMethodNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 3 then
            AlternationPatternNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 4 then
            AndNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 5 then
            ArgumentsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node })
          when 6 then
            ArrayNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
          when 7 then
            ArrayPatternNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
          when 8 then
            AssocNode.new(source, node_id, location, load_varuint, load_node, load_node, load_optional_location)
          when 9 then
            AssocSplatNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
          when 10 then
            BackReferenceReadNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 11 then
            BeginNode.new(source, node_id, location, load_varuint, load_optional_location, load_optional_node, load_optional_node, load_optional_node, load_optional_node, load_optional_location)
          when 12 then
            BlockArgumentNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
          when 13 then
            BlockLocalVariableNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 14 then
            BlockNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_optional_node, load_optional_node, load_location, load_location)
          when 15 then
            BlockParameterNode.new(source, node_id, location, load_varuint, load_optional_constant, load_optional_location, load_location)
          when 16 then
            BlockParametersNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
          when 17 then
            BreakNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
          when 18 then
            CallAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_optional_location, load_required_constant, load_required_constant, load_location, load_node)
          when 19 then
            CallNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_required_constant, load_optional_location, load_optional_location, load_optional_node, load_optional_location, load_optional_node)
          when 20 then
            CallOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_optional_location, load_required_constant, load_required_constant, load_required_constant, load_location, load_node)
          when 21 then
            CallOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_optional_location, load_required_constant, load_required_constant, load_location, load_node)
          when 22 then
            CallTargetNode.new(source, node_id, location, load_varuint, load_node, load_location, load_required_constant, load_location)
          when 23 then
            CapturePatternNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 24 then
            CaseMatchNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, load_location, load_location)
          when 25 then
            CaseNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, load_location, load_location)
          when 26 then
            ClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_node, load_optional_location, load_optional_node, load_optional_node, load_location, load_required_constant)
          when 27 then
            ClassVariableAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 28 then
            ClassVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
          when 29 then
            ClassVariableOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 30 then
            ClassVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 31 then
            ClassVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 32 then
            ClassVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
          when 33 then
            ConstantAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 34 then
            ConstantOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
          when 35 then
            ConstantOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 36 then
            ConstantPathAndWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
          when 37 then
            ConstantPathNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_constant, load_location, load_location)
          when 38 then
            ConstantPathOperatorWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node, load_required_constant)
          when 39 then
            ConstantPathOrWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
          when 40 then
            ConstantPathTargetNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_constant, load_location, load_location)
          when 41 then
            ConstantPathWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
          when 42 then
            ConstantReadNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 43 then
            ConstantTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 44 then
            ConstantWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
          when 45 then
            load_uint32
            DefNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_optional_node, load_optional_node, load_optional_node, Array.new(load_varuint) { load_required_constant }, load_location, load_optional_location, load_optional_location, load_optional_location, load_optional_location, load_optional_location)
          when 46 then
            DefinedNode.new(source, node_id, location, load_varuint, load_optional_location, load_node, load_optional_location, load_location)
          when 47 then
            ElseNode.new(source, node_id, location, load_varuint, load_location, load_optional_node, load_optional_location)
          when 48 then
            EmbeddedStatementsNode.new(source, node_id, location, load_varuint, load_location, load_optional_node, load_location)
          when 49 then
            EmbeddedVariableNode.new(source, node_id, location, load_varuint, load_location, load_node)
          when 50 then
            EnsureNode.new(source, node_id, location, load_varuint, load_location, load_optional_node, load_location)
          when 51 then
            FalseNode.new(source, node_id, location, load_varuint)
          when 52 then
            FindPatternNode.new(source, node_id, location, load_varuint, load_optional_node, load_node, Array.new(load_varuint) { load_node }, load_node, load_optional_location, load_optional_location)
          when 53 then
            FlipFlopNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_node, load_location)
          when 54 then
            FloatNode.new(source, node_id, location, load_varuint, load_double)
          when 55 then
            ForNode.new(source, node_id, location, load_varuint, load_node, load_node, load_optional_node, load_location, load_location, load_optional_location, load_location)
          when 56 then
            ForwardingArgumentsNode.new(source, node_id, location, load_varuint)
          when 57 then
            ForwardingParameterNode.new(source, node_id, location, load_varuint)
          when 58 then
            ForwardingSuperNode.new(source, node_id, location, load_varuint, load_optional_node)
          when 59 then
            GlobalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 60 then
            GlobalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
          when 61 then
            GlobalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 62 then
            GlobalVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 63 then
            GlobalVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 64 then
            GlobalVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
          when 65 then
            HashNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
          when 66 then
            HashPatternNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, load_optional_location, load_optional_location)
          when 67 then
            IfNode.new(source, node_id, location, load_varuint, load_optional_location, load_node, load_optional_location, load_optional_node, load_optional_node, load_optional_location)
          when 68 then
            ImaginaryNode.new(source, node_id, location, load_varuint, load_node)
          when 69 then
            ImplicitNode.new(source, node_id, location, load_varuint, load_node)
          when 70 then
            ImplicitRestNode.new(source, node_id, location, load_varuint)
          when 71 then
            InNode.new(source, node_id, location, load_varuint, load_node, load_optional_node, load_location, load_optional_location)
          when 72 then
            IndexAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_location, load_optional_node, load_location, load_optional_node, load_location, load_node)
          when 73 then
            IndexOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_location, load_optional_node, load_location, load_optional_node, load_required_constant, load_location, load_node)
          when 74 then
            IndexOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_location, load_optional_node, load_location, load_optional_node, load_location, load_node)
          when 75 then
            IndexTargetNode.new(source, node_id, location, load_varuint, load_node, load_location, load_optional_node, load_location, load_optional_node)
          when 76 then
            InstanceVariableAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 77 then
            InstanceVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
          when 78 then
            InstanceVariableOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 79 then
            InstanceVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 80 then
            InstanceVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 81 then
            InstanceVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
          when 82 then
            IntegerNode.new(source, node_id, location, load_varuint, load_integer)
          when 83 then
            InterpolatedMatchLastLineNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
          when 84 then
            InterpolatedRegularExpressionNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
          when 85 then
            InterpolatedStringNode.new(source, node_id, location, load_varuint, load_optional_location, Array.new(load_varuint) { load_node }, load_optional_location)
          when 86 then
            InterpolatedSymbolNode.new(source, node_id, location, load_varuint, load_optional_location, Array.new(load_varuint) { load_node }, load_optional_location)
          when 87 then
            InterpolatedXStringNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
          when 88 then
            ItLocalVariableReadNode.new(source, node_id, location, load_varuint)
          when 89 then
            ItParametersNode.new(source, node_id, location, load_varuint)
          when 90 then
            KeywordHashNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node })
          when 91 then
            KeywordRestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant, load_optional_location, load_location)
          when 92 then
            LambdaNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_location, load_location, load_optional_node, load_optional_node)
          when 93 then
            LocalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_location, load_location, load_node, load_required_constant, load_varuint)
          when 94 then
            LocalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_location, load_location, load_node, load_required_constant, load_required_constant, load_varuint)
          when 95 then
            LocalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_location, load_location, load_node, load_required_constant, load_varuint)
          when 96 then
            LocalVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant, load_varuint)
          when 97 then
            LocalVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant, load_varuint)
          when 98 then
            LocalVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_varuint, load_location, load_node, load_location)
          when 99 then
            MatchLastLineNode.new(source, node_id, location, load_varuint, load_location, load_location, load_location, load_string)
          when 100 then
            MatchPredicateNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 101 then
            MatchRequiredNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 102 then
            MatchWriteNode.new(source, node_id, location, load_varuint, load_node, Array.new(load_varuint) { load_node })
          when 103 then
            MissingNode.new(source, node_id, location, load_varuint)
          when 104 then
            ModuleNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_node, load_optional_node, load_location, load_required_constant)
          when 105 then
            MultiTargetNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
          when 106 then
            MultiWriteNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location, load_location, load_node)
          when 107 then
            NextNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
          when 108 then
            NilNode.new(source, node_id, location, load_varuint)
          when 109 then
            NoKeywordsParameterNode.new(source, node_id, location, load_varuint, load_location, load_location)
          when 110 then
            NumberedParametersNode.new(source, node_id, location, load_varuint, io.getbyte)
          when 111 then
            NumberedReferenceReadNode.new(source, node_id, location, load_varuint, load_varuint)
          when 112 then
            OptionalKeywordParameterNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node)
          when 113 then
            OptionalParameterNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
          when 114 then
            OrNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
          when 115 then
            ParametersNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, Array.new(load_varuint) { load_node }, load_optional_node, load_optional_node)
          when 116 then
            ParenthesesNode.new(source, node_id, location, load_varuint, load_optional_node, load_location, load_location)
          when 117 then
            PinnedExpressionNode.new(source, node_id, location, load_varuint, load_node, load_location, load_location, load_location)
          when 118 then
            PinnedVariableNode.new(source, node_id, location, load_varuint, load_node, load_location)
          when 119 then
            PostExecutionNode.new(source, node_id, location, load_varuint, load_optional_node, load_location, load_location, load_location)
          when 120 then
            PreExecutionNode.new(source, node_id, location, load_varuint, load_optional_node, load_location, load_location, load_location)
          when 121 then
            ProgramNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_node)
          when 122 then
            RangeNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_node, load_location)
          when 123 then
            RationalNode.new(source, node_id, location, load_varuint, load_integer, load_integer)
          when 124 then
            RedoNode.new(source, node_id, location, load_varuint)
          when 125 then
            RegularExpressionNode.new(source, node_id, location, load_varuint, load_location, load_location, load_location, load_string)
          when 126 then
            RequiredKeywordParameterNode.new(source, node_id, location, load_varuint, load_required_constant, load_location)
          when 127 then
            RequiredParameterNode.new(source, node_id, location, load_varuint, load_required_constant)
          when 128 then
            RescueModifierNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
          when 129 then
            RescueNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_node, load_optional_node, load_optional_node)
          when 130 then
            RestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant, load_optional_location, load_location)
          when 131 then
            RetryNode.new(source, node_id, location, load_varuint)
          when 132 then
            ReturnNode.new(source, node_id, location, load_varuint, load_location, load_optional_node)
          when 133 then
            SelfNode.new(source, node_id, location, load_varuint)
          when 134 then
            ShareableConstantNode.new(source, node_id, location, load_varuint, load_node)
          when 135 then
            SingletonClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_location, load_node, load_optional_node, load_location)
          when 136 then
            SourceEncodingNode.new(source, node_id, location, load_varuint)
          when 137 then
            SourceFileNode.new(source, node_id, location, load_varuint, load_string)
          when 138 then
            SourceLineNode.new(source, node_id, location, load_varuint)
          when 139 then
            SplatNode.new(source, node_id, location, load_varuint, load_location, load_optional_node)
          when 140 then
            StatementsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node })
          when 141 then
            StringNode.new(source, node_id, location, load_varuint, load_optional_location, load_location, load_optional_location, load_string)
          when 142 then
            SuperNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_optional_node, load_optional_location, load_optional_node)
          when 143 then
            SymbolNode.new(source, node_id, location, load_varuint, load_optional_location, load_optional_location, load_optional_location, load_string)
          when 144 then
            TrueNode.new(source, node_id, location, load_varuint)
          when 145 then
            UndefNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_location)
          when 146 then
            UnlessNode.new(source, node_id, location, load_varuint, load_location, load_node, load_optional_location, load_optional_node, load_optional_node, load_optional_location)
          when 147 then
            UntilNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_node, load_optional_node)
          when 148 then
            WhenNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_node)
          when 149 then
            WhileNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_node, load_optional_node)
          when 150 then
            XStringNode.new(source, node_id, location, load_varuint, load_location, load_location, load_location, load_string)
          when 151 then
            YieldNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_optional_node, load_optional_location)
          end
        end
      else
        def load_node
          type = io.getbyte
          @load_node_lambdas[type].call
        end

        def define_load_node_lambdas
          @load_node_lambdas = [
            nil,
            -> {
              node_id = load_varuint
              location = load_location
              AliasGlobalVariableNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              AliasMethodNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              AlternationPatternNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              AndNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ArgumentsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node })
            },
            -> {
              node_id = load_varuint
              location = load_location
              ArrayNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ArrayPatternNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              AssocNode.new(source, node_id, location, load_varuint, load_node, load_node, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              AssocSplatNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BackReferenceReadNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BeginNode.new(source, node_id, location, load_varuint, load_optional_location, load_optional_node, load_optional_node, load_optional_node, load_optional_node, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BlockArgumentNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BlockLocalVariableNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BlockNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_optional_node, load_optional_node, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BlockParameterNode.new(source, node_id, location, load_varuint, load_optional_constant, load_optional_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BlockParametersNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              BreakNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CallAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_optional_location, load_required_constant, load_required_constant, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CallNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_required_constant, load_optional_location, load_optional_location, load_optional_node, load_optional_location, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CallOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_optional_location, load_required_constant, load_required_constant, load_required_constant, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CallOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_optional_location, load_required_constant, load_required_constant, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CallTargetNode.new(source, node_id, location, load_varuint, load_node, load_location, load_required_constant, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CapturePatternNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CaseMatchNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              CaseNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_node, load_optional_location, load_optional_node, load_optional_node, load_location, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassVariableAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassVariableOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ClassVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantPathAndWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantPathNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_constant, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantPathOperatorWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantPathOrWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantPathTargetNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_constant, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantPathWriteNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantReadNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ConstantWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              load_uint32
              DefNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_optional_node, load_optional_node, load_optional_node, Array.new(load_varuint) { load_required_constant }, load_location, load_optional_location, load_optional_location, load_optional_location, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              DefinedNode.new(source, node_id, location, load_varuint, load_optional_location, load_node, load_optional_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ElseNode.new(source, node_id, location, load_varuint, load_location, load_optional_node, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              EmbeddedStatementsNode.new(source, node_id, location, load_varuint, load_location, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              EmbeddedVariableNode.new(source, node_id, location, load_varuint, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              EnsureNode.new(source, node_id, location, load_varuint, load_location, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              FalseNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              FindPatternNode.new(source, node_id, location, load_varuint, load_optional_node, load_node, Array.new(load_varuint) { load_node }, load_node, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              FlipFlopNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              FloatNode.new(source, node_id, location, load_varuint, load_double)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ForNode.new(source, node_id, location, load_varuint, load_node, load_node, load_optional_node, load_location, load_location, load_optional_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ForwardingArgumentsNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ForwardingParameterNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ForwardingSuperNode.new(source, node_id, location, load_varuint, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              GlobalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              GlobalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              GlobalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              GlobalVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              GlobalVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              GlobalVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              HashNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              HashPatternNode.new(source, node_id, location, load_varuint, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_node, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              IfNode.new(source, node_id, location, load_varuint, load_optional_location, load_node, load_optional_location, load_optional_node, load_optional_node, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ImaginaryNode.new(source, node_id, location, load_varuint, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ImplicitNode.new(source, node_id, location, load_varuint, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ImplicitRestNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InNode.new(source, node_id, location, load_varuint, load_node, load_optional_node, load_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              IndexAndWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_location, load_optional_node, load_location, load_optional_node, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              IndexOperatorWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_location, load_optional_node, load_location, load_optional_node, load_required_constant, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              IndexOrWriteNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_location, load_location, load_optional_node, load_location, load_optional_node, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              IndexTargetNode.new(source, node_id, location, load_varuint, load_node, load_location, load_optional_node, load_location, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InstanceVariableAndWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InstanceVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InstanceVariableOrWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InstanceVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InstanceVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InstanceVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              IntegerNode.new(source, node_id, location, load_varuint, load_integer)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InterpolatedMatchLastLineNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InterpolatedRegularExpressionNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InterpolatedStringNode.new(source, node_id, location, load_varuint, load_optional_location, Array.new(load_varuint) { load_node }, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InterpolatedSymbolNode.new(source, node_id, location, load_varuint, load_optional_location, Array.new(load_varuint) { load_node }, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              InterpolatedXStringNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ItLocalVariableReadNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ItParametersNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              KeywordHashNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node })
            },
            -> {
              node_id = load_varuint
              location = load_location
              KeywordRestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant, load_optional_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LambdaNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_location, load_location, load_optional_node, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LocalVariableAndWriteNode.new(source, node_id, location, load_varuint, load_location, load_location, load_node, load_required_constant, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LocalVariableOperatorWriteNode.new(source, node_id, location, load_varuint, load_location, load_location, load_node, load_required_constant, load_required_constant, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LocalVariableOrWriteNode.new(source, node_id, location, load_varuint, load_location, load_location, load_node, load_required_constant, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LocalVariableReadNode.new(source, node_id, location, load_varuint, load_required_constant, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LocalVariableTargetNode.new(source, node_id, location, load_varuint, load_required_constant, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              LocalVariableWriteNode.new(source, node_id, location, load_varuint, load_required_constant, load_varuint, load_location, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              MatchLastLineNode.new(source, node_id, location, load_varuint, load_location, load_location, load_location, load_string)
            },
            -> {
              node_id = load_varuint
              location = load_location
              MatchPredicateNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              MatchRequiredNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              MatchWriteNode.new(source, node_id, location, load_varuint, load_node, Array.new(load_varuint) { load_node })
            },
            -> {
              node_id = load_varuint
              location = load_location
              MissingNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ModuleNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_node, load_optional_node, load_location, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              MultiTargetNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              MultiWriteNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              NextNode.new(source, node_id, location, load_varuint, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              NilNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              NoKeywordsParameterNode.new(source, node_id, location, load_varuint, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              NumberedParametersNode.new(source, node_id, location, load_varuint, io.getbyte)
            },
            -> {
              node_id = load_varuint
              location = load_location
              NumberedReferenceReadNode.new(source, node_id, location, load_varuint, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              OptionalKeywordParameterNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              OptionalParameterNode.new(source, node_id, location, load_varuint, load_required_constant, load_location, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              OrNode.new(source, node_id, location, load_varuint, load_node, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ParametersNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, Array.new(load_varuint) { load_node }, load_optional_node, Array.new(load_varuint) { load_node }, Array.new(load_varuint) { load_node }, load_optional_node, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ParenthesesNode.new(source, node_id, location, load_varuint, load_optional_node, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              PinnedExpressionNode.new(source, node_id, location, load_varuint, load_node, load_location, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              PinnedVariableNode.new(source, node_id, location, load_varuint, load_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              PostExecutionNode.new(source, node_id, location, load_varuint, load_optional_node, load_location, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              PreExecutionNode.new(source, node_id, location, load_varuint, load_optional_node, load_location, load_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ProgramNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RangeNode.new(source, node_id, location, load_varuint, load_optional_node, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RationalNode.new(source, node_id, location, load_varuint, load_integer, load_integer)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RedoNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RegularExpressionNode.new(source, node_id, location, load_varuint, load_location, load_location, load_location, load_string)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RequiredKeywordParameterNode.new(source, node_id, location, load_varuint, load_required_constant, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RequiredParameterNode.new(source, node_id, location, load_varuint, load_required_constant)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RescueModifierNode.new(source, node_id, location, load_varuint, load_node, load_location, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RescueNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_node, load_optional_node, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RestParameterNode.new(source, node_id, location, load_varuint, load_optional_constant, load_optional_location, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              RetryNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ReturnNode.new(source, node_id, location, load_varuint, load_location, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SelfNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              ShareableConstantNode.new(source, node_id, location, load_varuint, load_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SingletonClassNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_required_constant }, load_location, load_location, load_node, load_optional_node, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SourceEncodingNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SourceFileNode.new(source, node_id, location, load_varuint, load_string)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SourceLineNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SplatNode.new(source, node_id, location, load_varuint, load_location, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              StatementsNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node })
            },
            -> {
              node_id = load_varuint
              location = load_location
              StringNode.new(source, node_id, location, load_varuint, load_optional_location, load_location, load_optional_location, load_string)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SuperNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_optional_node, load_optional_location, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              SymbolNode.new(source, node_id, location, load_varuint, load_optional_location, load_optional_location, load_optional_location, load_string)
            },
            -> {
              node_id = load_varuint
              location = load_location
              TrueNode.new(source, node_id, location, load_varuint)
            },
            -> {
              node_id = load_varuint
              location = load_location
              UndefNode.new(source, node_id, location, load_varuint, Array.new(load_varuint) { load_node }, load_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              UnlessNode.new(source, node_id, location, load_varuint, load_location, load_node, load_optional_location, load_optional_node, load_optional_node, load_optional_location)
            },
            -> {
              node_id = load_varuint
              location = load_location
              UntilNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_node, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              WhenNode.new(source, node_id, location, load_varuint, load_location, Array.new(load_varuint) { load_node }, load_optional_location, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              WhileNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_node, load_optional_node)
            },
            -> {
              node_id = load_varuint
              location = load_location
              XStringNode.new(source, node_id, location, load_varuint, load_location, load_location, load_location, load_string)
            },
            -> {
              node_id = load_varuint
              location = load_location
              YieldNode.new(source, node_id, location, load_varuint, load_location, load_optional_location, load_optional_node, load_optional_location)
            },
          ]
        end
      end
    end

    # The token types that can be indexed by their enum values.
    TOKEN_TYPES = [
      nil,
      :EOF,
      :MISSING,
      :NOT_PROVIDED,
      :AMPERSAND,
      :AMPERSAND_AMPERSAND,
      :AMPERSAND_AMPERSAND_EQUAL,
      :AMPERSAND_DOT,
      :AMPERSAND_EQUAL,
      :BACKTICK,
      :BACK_REFERENCE,
      :BANG,
      :BANG_EQUAL,
      :BANG_TILDE,
      :BRACE_LEFT,
      :BRACE_RIGHT,
      :BRACKET_LEFT,
      :BRACKET_LEFT_ARRAY,
      :BRACKET_LEFT_RIGHT,
      :BRACKET_LEFT_RIGHT_EQUAL,
      :BRACKET_RIGHT,
      :CARET,
      :CARET_EQUAL,
      :CHARACTER_LITERAL,
      :CLASS_VARIABLE,
      :COLON,
      :COLON_COLON,
      :COMMA,
      :COMMENT,
      :CONSTANT,
      :DOT,
      :DOT_DOT,
      :DOT_DOT_DOT,
      :EMBDOC_BEGIN,
      :EMBDOC_END,
      :EMBDOC_LINE,
      :EMBEXPR_BEGIN,
      :EMBEXPR_END,
      :EMBVAR,
      :EQUAL,
      :EQUAL_EQUAL,
      :EQUAL_EQUAL_EQUAL,
      :EQUAL_GREATER,
      :EQUAL_TILDE,
      :FLOAT,
      :FLOAT_IMAGINARY,
      :FLOAT_RATIONAL,
      :FLOAT_RATIONAL_IMAGINARY,
      :GLOBAL_VARIABLE,
      :GREATER,
      :GREATER_EQUAL,
      :GREATER_GREATER,
      :GREATER_GREATER_EQUAL,
      :HEREDOC_END,
      :HEREDOC_START,
      :IDENTIFIER,
      :IGNORED_NEWLINE,
      :INSTANCE_VARIABLE,
      :INTEGER,
      :INTEGER_IMAGINARY,
      :INTEGER_RATIONAL,
      :INTEGER_RATIONAL_IMAGINARY,
      :KEYWORD_ALIAS,
      :KEYWORD_AND,
      :KEYWORD_BEGIN,
      :KEYWORD_BEGIN_UPCASE,
      :KEYWORD_BREAK,
      :KEYWORD_CASE,
      :KEYWORD_CLASS,
      :KEYWORD_DEF,
      :KEYWORD_DEFINED,
      :KEYWORD_DO,
      :KEYWORD_DO_LOOP,
      :KEYWORD_ELSE,
      :KEYWORD_ELSIF,
      :KEYWORD_END,
      :KEYWORD_END_UPCASE,
      :KEYWORD_ENSURE,
      :KEYWORD_FALSE,
      :KEYWORD_FOR,
      :KEYWORD_IF,
      :KEYWORD_IF_MODIFIER,
      :KEYWORD_IN,
      :KEYWORD_MODULE,
      :KEYWORD_NEXT,
      :KEYWORD_NIL,
      :KEYWORD_NOT,
      :KEYWORD_OR,
      :KEYWORD_REDO,
      :KEYWORD_RESCUE,
      :KEYWORD_RESCUE_MODIFIER,
      :KEYWORD_RETRY,
      :KEYWORD_RETURN,
      :KEYWORD_SELF,
      :KEYWORD_SUPER,
      :KEYWORD_THEN,
      :KEYWORD_TRUE,
      :KEYWORD_UNDEF,
      :KEYWORD_UNLESS,
      :KEYWORD_UNLESS_MODIFIER,
      :KEYWORD_UNTIL,
      :KEYWORD_UNTIL_MODIFIER,
      :KEYWORD_WHEN,
      :KEYWORD_WHILE,
      :KEYWORD_WHILE_MODIFIER,
      :KEYWORD_YIELD,
      :KEYWORD___ENCODING__,
      :KEYWORD___FILE__,
      :KEYWORD___LINE__,
      :LABEL,
      :LABEL_END,
      :LAMBDA_BEGIN,
      :LESS,
      :LESS_EQUAL,
      :LESS_EQUAL_GREATER,
      :LESS_LESS,
      :LESS_LESS_EQUAL,
      :METHOD_NAME,
      :MINUS,
      :MINUS_EQUAL,
      :MINUS_GREATER,
      :NEWLINE,
      :NUMBERED_REFERENCE,
      :PARENTHESIS_LEFT,
      :PARENTHESIS_LEFT_PARENTHESES,
      :PARENTHESIS_RIGHT,
      :PERCENT,
      :PERCENT_EQUAL,
      :PERCENT_LOWER_I,
      :PERCENT_LOWER_W,
      :PERCENT_LOWER_X,
      :PERCENT_UPPER_I,
      :PERCENT_UPPER_W,
      :PIPE,
      :PIPE_EQUAL,
      :PIPE_PIPE,
      :PIPE_PIPE_EQUAL,
      :PLUS,
      :PLUS_EQUAL,
      :QUESTION_MARK,
      :REGEXP_BEGIN,
      :REGEXP_END,
      :SEMICOLON,
      :SLASH,
      :SLASH_EQUAL,
      :STAR,
      :STAR_EQUAL,
      :STAR_STAR,
      :STAR_STAR_EQUAL,
      :STRING_BEGIN,
      :STRING_CONTENT,
      :STRING_END,
      :SYMBOL_BEGIN,
      :TILDE,
      :UAMPERSAND,
      :UCOLON_COLON,
      :UDOT_DOT,
      :UDOT_DOT_DOT,
      :UMINUS,
      :UMINUS_NUM,
      :UPLUS,
      :USTAR,
      :USTAR_STAR,
      :WORDS_SEP,
      :__END__,
    ]
  end
end
