= BasicSocket

ソケットを表す抽象クラス。具体的なソケット操作はサブクラスで
定義されます。
例えばインターネットドメインストリームソケットの場合は
((<TCPSocket>))を用います。

== スーパークラス:

* ((<IO>))

== クラスメソッド:

--- BasicSocket.do_not_reverse_lookup
--- BasicSocket.do_not_reverse_lookup = bool
    この値が真ならアドレスからホスト名への逆引きを行わなくなります。
    デフォルトは false です。この設定は大域的に作用します。

    以下のメソッドの動作に影響します。

    ((<BasicSocket#recv|BasicSocket/recv>)),
    ((<IPSocket#recvfrom|IPSocket/recvfrom>)),
    ((<UNIXSocket#recvfrom|UNIXSocket/recvfrom>)),
    ((<Socket#recvfrom|Socket/recvfrom>)),
    ((<IPSocket#addr|IPSocket/addr>)),
    ((<IPSocket#peeraddr|IPSocket/peeraddr>)),
    ((<Socket/Socket.getaddrinfo>))

    例:

        require 'socket'

        p TCPSocket.new('localhost', 'telnet').addr
        TCPSocket.do_not_reverse_lookup = true
        p TCPSocket.new('localhost', 'telnet').addr

        => ["AF_INET", 2253, "localhost", "127.0.0.1"]
           ["AF_INET", 2254, "127.0.0.1", "127.0.0.1"]

--- BasicSocket.for_fd(fd)           ((<ruby 1.7 feature>))

    ファイルディスクリプタ ((|fd|)) に対する新しいソケットを生成します。

    ((<ruby 1.7 feature>)):
    このメソッドは ((<Socket>)) クラスからこのクラスに移動しました。
    これにより、任意のソケットである fd から対応するソケッ
    トクラスを作ることができます。

== メソッド:

--- getpeername
    接続の相手先のソケットの情報を取得します。sockaddr構造体をパッ
    クした文字列を返します。(({getpeername(2)}))を参照の
    こと。

--- getsockname
    ソケットの情報を取得します。sockaddr構造体をパックした
    文字列を返します。(({getsockname(2)}))を参照のこと。

--- getsockopt(level, optname)
    ソケットのオプションを取得します。(({getsockopt(2)}))
    を参照のこと。取得したオプションのデータをパックした文字列を
    返します。

--- recv(len[, flags])
    ソケットからデータを受け取り、文字列として返します。
    ((|len|))は受け取る最大の長さを指定します。
    ((|flags|))についてはrecv(2)を参照。((|flags|))の
    デフォルト値は0です。((|flags|))の指定に必要な定数は
    Socketクラスで定義されています。(例: Socket::SO_LINGER)

--- send(mesg, flags[, to])

    ソケットを介してデータを送ります。((|flags|)) に関しては 
    (({send(2)})) を参照してください。(({connect})) していないソケット
    に対しては送り先である ((|to|)) を指定する必要があります。実際に送っ
    たデータの長さを返します。

    ((|to|)) には((<socket.so/ソケットアドレス構造体を pack した文字列>))
    を指定します。

    データの送信に失敗した場合は例外 ((<Errno::EXXX>)) が発生します。

--- setsockopt(level, optname, optval)
    ソケットのオプションを設定します。((<setsockopt(2)|manual page>))
    を参照のこと。((-より高レベルなものとして((<RAA:Sockopt>))があります-))

--- shutdown([how])
    ソケットの以降の接続を終了させます。((|how|))が0である
    時、以降の受信が、1である時は、以降の送信が拒否されます。
    ((|how|))が2の時には、それ以降の送信、受信ともに拒否さ
    れます。((|how|))を省略すると2を指定したことになります。
    (({shutdown(2)}))を参照。
