= Syslog

UNIXのsyslogのラッパーモジュール。

        require 'syslog'

        Syslog.open("syslogtest")
        Syslog.log(Syslog::LOG_WARNING, "the sky is falling in %d seconds!", 100)
        Syslog.close

== インクルードしているモジュール

* ((<Syslog::Constants>))

== モジュール関数:

--- Syslog.open(ident=$0, options=Syslog::LOG_PID|Syslog::LOG_CONS, facility=Syslog::LOG_USER)
--- Syslog.open(ident=$0, options=Syslog::LOG_PID|Syslog::LOG_CONS, facility=Syslog::LOG_USER) { |syslog| ... }

    与えられた引数でsyslogを開く。以降、他の Syslog モジュール関数が使
    用可能となる。

    ブロック付きで呼ばれた場合は、self を引数としてブロックを実行し、
    最後に Syslog.close を行う。

    syslogを既に開いていた場合は((<RuntimeError>))が発生する。

    (({ident})) はすべてのログにつく識別子で、どのプログラムから送られ
    たログなのかを識別するために使われる。通常プログラム名が使われる。

    (({options})) には、Syslog.open や Syslog.log の動作を制御するフラ
    グを指定する。

    ((|facility|)) には、ログ出力を行うプログラムの種別を指定する。
    syslog はこの値にしたがって出力先となるログファイルを決める。
    (((<syslog.conf(5)|manual page>)) 参照)

    (({options})) と (({facility})) に指定できる値については
    ((<Syslog::Constants>)) を参照。

      例:
        Syslog.open('ftpd', Syslog::LOG_PID | Syslog::LOG_NDELAY,
                    Syslog::LOG_FTP)

    (({self})) を返す。

    syslog の詳細については ((<syslog(3)|manual page>)) を参照。

--- Syslog.open!(ident=$0, options=Syslog::LOG_PID|Syslog::LOG_CONS, facility=Syslog::LOG_USER) { |syslog| ... }
--- Syslog.reopen(ident=$0, options=Syslog::LOG_PID|Syslog::LOG_CONS, facility=Syslog::LOG_USER) { |syslog| ... }

    開いていた syslog を最初にクローズする点を除いて Syslog.open と同じ。

--- Syslog.opened?

    syslog をオープンしていれば真を返す。

--- Syslog.ident
--- Syslog.options
--- Syslog.facility

    最後のopenで与えられた対応する引数を返す。

--- Syslog.log(priority, format, ...)

    syslogにメッセージを書き込む。

    priority は優先度を示す定数(((<Syslog::Constants>))参照)。
    また、((|facility|))(((<Syslog::Constants>))参照)を論理和で指定す
    ることで open で指定した ((|facility|)) を切替えることもできる。

    format 以降は ((<組み込み関数/sprintf>)) と同じ形式の引数を指定する。
    メッセージに改行を含める必要はない。

       例:
         Syslog.log(Syslog::LOG_CRIT, "the sky is falling in %d seconds!", 10)

    注： ((<syslog(3)|manual page>)) のように format に %m は使用できない。

--- Syslog.emerg(message, ...)
--- Syslog.alert(message, ...)
--- Syslog.crit(message, ...)
--- Syslog.err(message, ...)
--- Syslog.warning(message, ...)
--- Syslog.notice(message, ...)
--- Syslog.info(message, ...)
--- Syslog.debug(message, ...)

    (({Syslog#log()}))のショートカットメソッド。
    システムによっては定義されていないものもある。

       例:
         Syslog.crit("the sky is falling in %d seconds!",5)

--- Syslog.mask
--- Syslog.mask=(mask)

    ログの優先度のマスクを取得または設定する。
    マスクは永続的であり、
    (({Syslog::open}))や(({Syslog.close}))
    ではリセットされない。
       例:
         Syslog.mask = Syslog::LOG_UPTO(Syslog::LOG_ERR)

--- Syslog.close

    syslogを閉じる。

--- Syslog.instance

    selfを返す。(旧版との互換性のため)

--- Syslog.LOG_MASK(priority)

    1つの優先度に対するマスクを作成する。

--- Syslog.LOG_UPTO(priority)

    (({priority}))までのすべての優先度のマスクを作成する。
