/* A Bison parser, made by Lrama 0.6.11.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* First part of user prologue.  */
#line 12 "parse.y"


#if !YYPURE
# error needs pure parser
#endif
#define YYDEBUG 1
#define YYERROR_VERBOSE 1
#define YYSTACK_USE_ALLOCA 0

/* For Ripper */
#ifdef RUBY_EXTCONF_H
# include RUBY_EXTCONF_H
#endif

#include "ruby/internal/config.h"

#include <errno.h>

#ifdef UNIVERSAL_PARSER

#include "internal/ruby_parser.h"
#include "parser_node.h"
#include "universal_parser.c"

#ifdef RIPPER
#define STATIC_ID2SYM p->config->static_id2sym
#define rb_str_coderange_scan_restartable p->config->str_coderange_scan_restartable
#endif

#else

#include "internal.h"
#include "internal/compile.h"
#include "internal/compilers.h"
#include "internal/complex.h"
#include "internal/encoding.h"
#include "internal/error.h"
#include "internal/hash.h"
#include "internal/io.h"
#include "internal/numeric.h"
#include "internal/parse.h"
#include "internal/rational.h"
#include "internal/re.h"
#include "internal/ruby_parser.h"
#include "internal/symbol.h"
#include "internal/thread.h"
#include "internal/variable.h"
#include "node.h"
#include "parser_node.h"
#include "probes.h"
#include "regenc.h"
#include "ruby/encoding.h"
#include "ruby/regex.h"
#include "ruby/ruby.h"
#include "ruby/st.h"
#include "ruby/util.h"
#include "ruby/ractor.h"
#include "symbol.h"

#ifndef RIPPER
static VALUE
syntax_error_new(void)
{
    return rb_class_new_instance(0, 0, rb_eSyntaxError);
}
#endif

static NODE *reg_named_capture_assign(struct parser_params* p, VALUE regexp, const YYLTYPE *loc, rb_parser_assignable_func assignable);

#define compile_callback rb_suppress_tracing
#endif /* !UNIVERSAL_PARSER */

#define NODE_SPECIAL_EMPTY_ARGS ((NODE *)-1)
#define NODE_EMPTY_ARGS_P(node) ((node) == NODE_SPECIAL_EMPTY_ARGS)

static int rb_parser_string_hash_cmp(rb_parser_string_t *str1, rb_parser_string_t *str2);

#ifndef RIPPER
static rb_parser_string_t *rb_parser_string_deep_copy(struct parser_params *p, const rb_parser_string_t *original);
#endif

static int
node_integer_cmp(rb_node_integer_t *n1, rb_node_integer_t *n2)
{
    return (n1->minus != n2->minus ||
            n1->base != n2->base ||
            strcmp(n1->val, n2->val));
}

static int
node_float_cmp(rb_node_float_t *n1, rb_node_float_t *n2)
{
    return (n1->minus != n2->minus ||
            strcmp(n1->val, n2->val));
}

static int
node_rational_cmp(rb_node_rational_t *n1, rb_node_rational_t *n2)
{
    return (n1->minus != n2->minus ||
            n1->base != n2->base ||
            n1->seen_point != n2->seen_point ||
            strcmp(n1->val, n2->val));
}

static int
node_imaginary_cmp(rb_node_imaginary_t *n1, rb_node_imaginary_t *n2)
{
    return (n1->minus != n2->minus ||
            n1->base != n2->base ||
            n1->seen_point != n2->seen_point ||
            n1->type != n2->type ||
            strcmp(n1->val, n2->val));
}

static int
rb_parser_regx_hash_cmp(rb_node_regx_t *n1, rb_node_regx_t *n2)
{
    return (n1->options != n2->options ||
            rb_parser_string_hash_cmp(n1->string, n2->string));
}

static st_index_t rb_parser_str_hash(rb_parser_string_t *str);
static st_index_t rb_char_p_hash(const char *c);

static int
literal_cmp(st_data_t val, st_data_t lit)
{
    if (val == lit) return 0;

    NODE *node_val = RNODE(val);
    NODE *node_lit = RNODE(lit);
    enum node_type type_val = nd_type(node_val);
    enum node_type type_lit = nd_type(node_lit);

    if (type_val != type_lit) {
        return -1;
    }

    switch (type_lit) {
      case NODE_INTEGER:
        return node_integer_cmp(RNODE_INTEGER(node_val), RNODE_INTEGER(node_lit));
      case NODE_FLOAT:
        return node_float_cmp(RNODE_FLOAT(node_val), RNODE_FLOAT(node_lit));
      case NODE_RATIONAL:
        return node_rational_cmp(RNODE_RATIONAL(node_val), RNODE_RATIONAL(node_lit));
      case NODE_IMAGINARY:
        return node_imaginary_cmp(RNODE_IMAGINARY(node_val), RNODE_IMAGINARY(node_lit));
      case NODE_STR:
        return rb_parser_string_hash_cmp(RNODE_STR(node_val)->string, RNODE_STR(node_lit)->string);
      case NODE_SYM:
        return rb_parser_string_hash_cmp(RNODE_SYM(node_val)->string, RNODE_SYM(node_lit)->string);
      case NODE_REGX:
        return rb_parser_regx_hash_cmp(RNODE_REGX(node_val), RNODE_REGX(node_lit));
      case NODE_LINE:
        return node_val->nd_loc.beg_pos.lineno != node_lit->nd_loc.beg_pos.lineno;
      case NODE_FILE:
        return rb_parser_string_hash_cmp(RNODE_FILE(node_val)->path, RNODE_FILE(node_lit)->path);
      case NODE_ENCODING:
        return RNODE_ENCODING(node_val)->enc != RNODE_ENCODING(node_lit)->enc;
      default:
#ifdef UNIVERSAL_PARSER
        abort();
#else
        rb_bug("unexpected node: %s, %s", ruby_node_name(type_val), ruby_node_name(type_lit));
#endif
    }
}

static st_index_t
literal_hash(st_data_t a)
{
    NODE *node = (NODE *)a;
    enum node_type type = nd_type(node);

    switch (type) {
      case NODE_INTEGER:
        return rb_char_p_hash(RNODE_INTEGER(node)->val);
      case NODE_FLOAT:
        return rb_char_p_hash(RNODE_FLOAT(node)->val);
      case NODE_RATIONAL:
        return rb_char_p_hash(RNODE_RATIONAL(node)->val);
      case NODE_IMAGINARY:
        return rb_char_p_hash(RNODE_IMAGINARY(node)->val);
      case NODE_STR:
        return rb_parser_str_hash(RNODE_STR(node)->string);
      case NODE_SYM:
        return rb_parser_str_hash(RNODE_SYM(node)->string);
      case NODE_REGX:
        return rb_parser_str_hash(RNODE_REGX(node)->string);
      case NODE_LINE:
        return (st_index_t)node->nd_loc.beg_pos.lineno;
      case NODE_FILE:
        return rb_parser_str_hash(RNODE_FILE(node)->path);
      case NODE_ENCODING:
        return (st_index_t)RNODE_ENCODING(node)->enc;
      default:
#ifdef UNIVERSAL_PARSER
        abort();
#else
        rb_bug("unexpected node: %s", ruby_node_name(type));
#endif
    }
}

static inline int
parse_isascii(int c)
{
    return '\0' <= c && c <= '\x7f';
}

#undef ISASCII
#define ISASCII parse_isascii

static inline int
parse_isspace(int c)
{
    return c == ' ' || ('\t' <= c && c <= '\r');
}

#undef ISSPACE
#define ISSPACE parse_isspace

static inline int
parse_iscntrl(int c)
{
    return ('\0' <= c && c < ' ') || c == '\x7f';
}

#undef ISCNTRL
#define ISCNTRL(c) parse_iscntrl(c)

static inline int
parse_isupper(int c)
{
    return 'A' <= c && c <= 'Z';
}

static inline int
parse_islower(int c)
{
    return 'a' <= c && c <= 'z';
}

static inline int
parse_isalpha(int c)
{
    return parse_isupper(c) || parse_islower(c);
}

#undef ISALPHA
#define ISALPHA(c) parse_isalpha(c)

static inline int
parse_isdigit(int c)
{
    return '0' <= c && c <= '9';
}

#undef ISDIGIT
#define ISDIGIT(c) parse_isdigit(c)

static inline int
parse_isalnum(int c)
{
    return parse_isalpha(c) || parse_isdigit(c);
}

#undef ISALNUM
#define ISALNUM(c) parse_isalnum(c)

static inline int
parse_isxdigit(int c)
{
    return parse_isdigit(c) || ('A' <= c && c <= 'F') || ('a' <= c && c <= 'f');
}

#undef ISXDIGIT
#define ISXDIGIT(c) parse_isxdigit(c)

#include "parser_st.h"

#undef STRCASECMP
#define STRCASECMP rb_parser_st_locale_insensitive_strcasecmp

#undef STRNCASECMP
#define STRNCASECMP rb_parser_st_locale_insensitive_strncasecmp

#ifdef RIPPER
#include "ripper_init.h"
#endif

enum rescue_context {
    before_rescue,
    after_rescue,
    after_else,
    after_ensure,
};

struct lex_context {
    unsigned int in_defined: 1;
    unsigned int in_kwarg: 1;
    unsigned int in_argdef: 1;
    unsigned int in_def: 1;
    unsigned int in_class: 1;
    BITFIELD(enum rb_parser_shareability, shareable_constant_value, 2);
    BITFIELD(enum rescue_context, in_rescue, 2);
    unsigned int cant_return: 1;
};

typedef struct RNode_DEF_TEMP rb_node_def_temp_t;

#if defined(__GNUC__) && !defined(__clang__)
// Suppress "parameter passing for argument of type 'struct
// lex_context' changed" notes.  `struct lex_context` is file scope,
// and has no ABI compatibility issue.
RBIMPL_WARNING_PUSH()
RBIMPL_WARNING_IGNORED(-Wpsabi)
RBIMPL_WARNING_POP()
// Not sure why effective even after popped.
#endif

#include "parse.h"

#define NO_LEX_CTXT (struct lex_context){0}

#ifndef WARN_PAST_SCOPE
# define WARN_PAST_SCOPE 0
#endif

#define TAB_WIDTH 8

#define yydebug (p->debug)	/* disable the global variable definition */

#define YYFPRINTF(out, ...)	rb_parser_printf(p, __VA_ARGS__)
#define YY_LOCATION_PRINT(File, loc, p) \
     rb_parser_printf(p, "%d.%d-%d.%d", \
                      (loc).beg_pos.lineno, (loc).beg_pos.column,\
                      (loc).end_pos.lineno, (loc).end_pos.column)
#define YYLLOC_DEFAULT(Current, Rhs, N)					\
    do									\
      if (N)								\
        {								\
          (Current).beg_pos = YYRHSLOC(Rhs, 1).beg_pos;			\
          (Current).end_pos = YYRHSLOC(Rhs, N).end_pos;			\
        }								\
      else								\
        {                                                               \
          (Current).beg_pos = YYRHSLOC(Rhs, 0).end_pos;                 \
          (Current).end_pos = YYRHSLOC(Rhs, 0).end_pos;                 \
        }                                                               \
    while (0)
#define YY_(Msgid) \
    (((Msgid)[0] == 'm') && (strcmp((Msgid), "memory exhausted") == 0) ? \
     "nesting too deep" : (Msgid))

#define RUBY_SET_YYLLOC_FROM_STRTERM_HEREDOC(Current)			\
    rb_parser_set_location_from_strterm_heredoc(p, &p->lex.strterm->u.heredoc, &(Current))
#define RUBY_SET_YYLLOC_OF_DELAYED_TOKEN(Current)			\
    rb_parser_set_location_of_delayed_token(p, &(Current))
#define RUBY_SET_YYLLOC_OF_HEREDOC_END(Current)				\
    rb_parser_set_location_of_heredoc_end(p, &(Current))
#define RUBY_SET_YYLLOC_OF_DUMMY_END(Current)				\
    rb_parser_set_location_of_dummy_end(p, &(Current))
#define RUBY_SET_YYLLOC_OF_NONE(Current)				\
    rb_parser_set_location_of_none(p, &(Current))
#define RUBY_SET_YYLLOC(Current)					\
    rb_parser_set_location(p, &(Current))
#define RUBY_INIT_YYLLOC() \
    { \
        {p->ruby_sourceline, (int)(p->lex.ptok - p->lex.pbeg)}, \
        {p->ruby_sourceline, (int)(p->lex.pcur - p->lex.pbeg)}, \
    }

#define IS_lex_state_for(x, ls)	((x) & (ls))
#define IS_lex_state_all_for(x, ls) (((x) & (ls)) == (ls))
#define IS_lex_state(ls)	IS_lex_state_for(p->lex.state, (ls))
#define IS_lex_state_all(ls)	IS_lex_state_all_for(p->lex.state, (ls))

# define SET_LEX_STATE(ls) \
    parser_set_lex_state(p, ls, __LINE__)
static inline enum lex_state_e parser_set_lex_state(struct parser_params *p, enum lex_state_e ls, int line);

typedef VALUE stack_type;

static const rb_code_location_t NULL_LOC = { {0, -1}, {0, -1} };

# define SHOW_BITSTACK(stack, name) (p->debug ? rb_parser_show_bitstack(p, stack, name, __LINE__) : (void)0)
# define BITSTACK_PUSH(stack, n) (((p->stack) = ((p->stack)<<1)|((n)&1)), SHOW_BITSTACK(p->stack, #stack"(push)"))
# define BITSTACK_POP(stack)	 (((p->stack) = (p->stack) >> 1), SHOW_BITSTACK(p->stack, #stack"(pop)"))
# define BITSTACK_SET_P(stack)	 (SHOW_BITSTACK(p->stack, #stack), (p->stack)&1)
# define BITSTACK_SET(stack, n)	 ((p->stack)=(n), SHOW_BITSTACK(p->stack, #stack"(set)"))

/* A flag to identify keyword_do_cond, "do" keyword after condition expression.
   Examples: `while ... do`, `until ... do`, and `for ... in ... do` */
#define COND_PUSH(n)	BITSTACK_PUSH(cond_stack, (n))
#define COND_POP()	BITSTACK_POP(cond_stack)
#define COND_P()	BITSTACK_SET_P(cond_stack)
#define COND_SET(n)	BITSTACK_SET(cond_stack, (n))

/* A flag to identify keyword_do_block; "do" keyword after command_call.
   Example: `foo 1, 2 do`. */
#define CMDARG_PUSH(n)	BITSTACK_PUSH(cmdarg_stack, (n))
#define CMDARG_POP()	BITSTACK_POP(cmdarg_stack)
#define CMDARG_P()	BITSTACK_SET_P(cmdarg_stack)
#define CMDARG_SET(n)	BITSTACK_SET(cmdarg_stack, (n))

struct vtable {
    ID *tbl;
    int pos;
    int capa;
    struct vtable *prev;
};

struct local_vars {
    struct vtable *args;
    struct vtable *vars;
    struct vtable *used;
# if WARN_PAST_SCOPE
    struct vtable *past;
# endif
    struct local_vars *prev;
    struct {
        NODE *outer, *inner, *current;
    } numparam;
    NODE *it;
};

enum {
    ORDINAL_PARAM = -1,
    NO_PARAM = 0,
    NUMPARAM_MAX = 9,
};

#define DVARS_INHERIT ((void*)1)
#define DVARS_TOPSCOPE NULL
#define DVARS_TERMINAL_P(tbl) ((tbl) == DVARS_INHERIT || (tbl) == DVARS_TOPSCOPE)

typedef struct token_info {
    const char *token;
    rb_code_position_t beg;
    int indent;
    int nonspc;
    struct token_info *next;
} token_info;

typedef struct end_expect_token_locations {
    const rb_code_position_t *pos;
    struct end_expect_token_locations *prev;
} end_expect_token_locations_t;

typedef struct parser_string_buffer_elem {
    struct parser_string_buffer_elem *next;
    long len;  /* Total length of allocated buf */
    long used; /* Current usage of buf */
    rb_parser_string_t *buf[FLEX_ARY_LEN];
} parser_string_buffer_elem_t;

typedef struct parser_string_buffer {
    parser_string_buffer_elem_t *head;
    parser_string_buffer_elem_t *last;
} parser_string_buffer_t;

#define AFTER_HEREDOC_WITHOUT_TERMINTOR ((rb_parser_string_t *)1)

/*
    Structure of Lexer Buffer:

 lex.pbeg     lex.ptok     lex.pcur     lex.pend
    |            |            |            |
    |------------+------------+------------|
                 |<---------->|
                     token
*/
struct parser_params {
    YYSTYPE *lval;
    YYLTYPE *yylloc;

    struct {
        rb_strterm_t *strterm;
        rb_parser_lex_gets_func *gets;
        rb_parser_input_data input;
        parser_string_buffer_t string_buffer;
        rb_parser_string_t *lastline;
        rb_parser_string_t *nextline;
        const char *pbeg;
        const char *pcur;
        const char *pend;
        const char *ptok;
        enum lex_state_e state;
        /* track the nest level of any parens "()[]{}" */
        int paren_nest;
        /* keep p->lex.paren_nest at the beginning of lambda "->" to detect tLAMBEG and keyword_do_LAMBDA */
        int lpar_beg;
        /* track the nest level of only braces "{}" */
        int brace_nest;
    } lex;
    stack_type cond_stack;
    stack_type cmdarg_stack;
    int tokidx;
    int toksiz;
    int heredoc_end;
    int heredoc_indent;
    int heredoc_line_indent;
    char *tokenbuf;
    struct local_vars *lvtbl;
    st_table *pvtbl;
    st_table *pktbl;
    int line_count;
    int ruby_sourceline;	/* current line no. */
    const char *ruby_sourcefile; /* current source file */
    VALUE ruby_sourcefile_string;
    rb_encoding *enc;
    token_info *token_info;
    st_table *case_labels;
    rb_node_exits_t *exits;

    VALUE debug_buffer;
    VALUE debug_output;

    struct {
        rb_parser_string_t *token;
        int beg_line;
        int beg_col;
        int end_line;
        int end_col;
    } delayed;

    rb_ast_t *ast;
    int node_id;

    st_table *warn_duplicate_keys_table;

    int max_numparam;
    ID it_id;

    struct lex_context ctxt;

    NODE *eval_tree_begin;
    NODE *eval_tree;
    const struct rb_iseq_struct *parent_iseq;

#ifdef UNIVERSAL_PARSER
    const rb_parser_config_t *config;
#endif
    /* compile_option */
    signed int frozen_string_literal:2; /* -1: not specified, 0: false, 1: true */

    unsigned int command_start:1;
    unsigned int eofp: 1;
    unsigned int ruby__end__seen: 1;
    unsigned int debug: 1;
    unsigned int has_shebang: 1;
    unsigned int token_seen: 1;
    unsigned int token_info_enabled: 1;
# if WARN_PAST_SCOPE
    unsigned int past_scope_enabled: 1;
# endif
    unsigned int error_p: 1;
    unsigned int cr_seen: 1;

#ifndef RIPPER
    /* Ruby core only */

    unsigned int do_print: 1;
    unsigned int do_loop: 1;
    unsigned int do_chomp: 1;
    unsigned int do_split: 1;
    unsigned int error_tolerant: 1;
    unsigned int keep_tokens: 1;

    VALUE error_buffer;
    rb_parser_ary_t *debug_lines;
    /*
     * Store specific keyword locations to generate dummy end token.
     * Refer to the tail of list element.
     */
    end_expect_token_locations_t *end_expect_token_locations;
    /* id for terms */
    int token_id;
    /* Array for term tokens */
    rb_parser_ary_t *tokens;
#else
    /* Ripper only */

    VALUE value;
    VALUE result;
    VALUE parsing_thread;
    VALUE s_value; /* Token VALUE */
    VALUE s_lvalue; /* VALUE generated by rule action (reduce) */
    VALUE s_value_stack;
#endif
};

#define NUMPARAM_ID_P(id) numparam_id_p(p, id)
#define NUMPARAM_ID_TO_IDX(id) (unsigned int)(((id) >> ID_SCOPE_SHIFT) - (tNUMPARAM_1 - 1))
#define NUMPARAM_IDX_TO_ID(idx) TOKEN2LOCALID((tNUMPARAM_1 - 1 + (idx)))
static int
numparam_id_p(struct parser_params *p, ID id)
{
    if (!is_local_id(id) || id < (tNUMPARAM_1 << ID_SCOPE_SHIFT)) return 0;
    unsigned int idx = NUMPARAM_ID_TO_IDX(id);
    return idx > 0 && idx <= NUMPARAM_MAX;
}
static void numparam_name(struct parser_params *p, ID id);

#ifdef RIPPER
static void
after_shift(struct parser_params *p)
{
    if (p->debug) {
        rb_parser_printf(p, "after-shift: %+"PRIsVALUE"\n", p->s_value);
    }
    rb_ary_push(p->s_value_stack, p->s_value);
    p->s_value = Qnil;
}

static void
before_reduce(int len, struct parser_params *p)
{
    // Initialize $$ with $1.
    if (len) p->s_lvalue = rb_ary_entry(p->s_value_stack, -len);
}

static void
after_reduce(int len, struct parser_params *p)
{
    for (int i = 0; i < len; i++) {
        VALUE tos = rb_ary_pop(p->s_value_stack);
        if (p->debug) {
            rb_parser_printf(p, "after-reduce pop: %+"PRIsVALUE"\n", tos);
        }
    }
    if (p->debug) {
        rb_parser_printf(p, "after-reduce push: %+"PRIsVALUE"\n", p->s_lvalue);
    }
    rb_ary_push(p->s_value_stack, p->s_lvalue);
    p->s_lvalue = Qnil;
}

static void
after_shift_error_token(struct parser_params *p)
{
    if (p->debug) {
        rb_parser_printf(p, "after-shift-error-token:\n");
    }
    rb_ary_push(p->s_value_stack, Qnil);
}

static void
after_pop_stack(int len, struct parser_params *p)
{
    for (int i = 0; i < len; i++) {
        VALUE tos = rb_ary_pop(p->s_value_stack);
        if (p->debug) {
            rb_parser_printf(p, "after-pop-stack pop: %+"PRIsVALUE"\n", tos);
        }
    }
}
#else
static void
after_shift(struct parser_params *p)
{
}

static void
before_reduce(int len, struct parser_params *p)
{
}

static void
after_reduce(int len, struct parser_params *p)
{
}

static void
after_shift_error_token(struct parser_params *p)
{
}

static void
after_pop_stack(int len, struct parser_params *p)
{
}
#endif

#define intern_cstr(n,l,en) rb_intern3(n,l,en)

#define STRING_NEW0() rb_parser_encoding_string_new(p,0,0,p->enc)

#define STR_NEW(ptr,len) rb_enc_str_new((ptr),(len),p->enc)
#define STR_NEW0() rb_enc_str_new(0,0,p->enc)
#define STR_NEW2(ptr) rb_enc_str_new((ptr),strlen(ptr),p->enc)
#define STR_NEW3(ptr,len,e,func) parser_str_new(p, (ptr),(len),(e),(func),p->enc)
#define TOK_INTERN() intern_cstr(tok(p), toklen(p), p->enc)
#define VALID_SYMNAME_P(s, l, enc, type) (rb_enc_symname_type(s, l, enc, (1U<<(type))) == (int)(type))

#ifndef RIPPER
static inline int
char_at_end(struct parser_params *p, VALUE str, int when_empty)
{
    long len = RSTRING_LEN(str);
    return len > 0 ? (unsigned char)RSTRING_PTR(str)[len-1] : when_empty;
}
#endif

static void
pop_pvtbl(struct parser_params *p, st_table *tbl)
{
    st_free_table(p->pvtbl);
    p->pvtbl = tbl;
}

static void
pop_pktbl(struct parser_params *p, st_table *tbl)
{
    if (p->pktbl) st_free_table(p->pktbl);
    p->pktbl = tbl;
}

#define STRING_BUF_DEFAULT_LEN 16

static void
string_buffer_init(struct parser_params *p)
{
    parser_string_buffer_t *buf = &p->lex.string_buffer;
    const size_t size = offsetof(parser_string_buffer_elem_t, buf) + sizeof(rb_parser_string_t *) * STRING_BUF_DEFAULT_LEN;

    buf->head = buf->last = xmalloc(size);
    buf->head->len = STRING_BUF_DEFAULT_LEN;
    buf->head->used = 0;
    buf->head->next = NULL;
}

static void
string_buffer_append(struct parser_params *p, rb_parser_string_t *str)
{
    parser_string_buffer_t *buf = &p->lex.string_buffer;

    if (buf->head->used >= buf->head->len) {
        parser_string_buffer_elem_t *elem;
        long n = buf->head->len * 2;
        const size_t size = offsetof(parser_string_buffer_elem_t, buf) + sizeof(rb_parser_string_t *) * n;

        elem = xmalloc(size);
        elem->len = n;
        elem->used = 0;
        elem->next = NULL;
        buf->last->next = elem;
        buf->last = elem;
    }
    buf->last->buf[buf->last->used++] = str;
}

static void
string_buffer_free(struct parser_params *p)
{
    parser_string_buffer_elem_t *elem = p->lex.string_buffer.head;

    while (elem) {
        parser_string_buffer_elem_t *next_elem = elem->next;

        for (long i = 0; i < elem->used; i++) {
            rb_parser_string_free(p, elem->buf[i]);
        }

        xfree(elem);
        elem = next_elem;
    }
}

#ifndef RIPPER
static void flush_debug_buffer(struct parser_params *p, VALUE out, VALUE str);

static void
debug_end_expect_token_locations(struct parser_params *p, const char *name)
{
    if(p->debug) {
        VALUE mesg = rb_sprintf("%s: [", name);
        int i = 0;
        for (end_expect_token_locations_t *loc = p->end_expect_token_locations; loc; loc = loc->prev) {
            if (i > 0)
                rb_str_cat_cstr(mesg, ", ");
            rb_str_catf(mesg, "[%d, %d]", loc->pos->lineno, loc->pos->column);
            i++;
        }
        rb_str_cat_cstr(mesg, "]\n");
        flush_debug_buffer(p, p->debug_output, mesg);
    }
}

static void
push_end_expect_token_locations(struct parser_params *p, const rb_code_position_t *pos)
{
    if(!p->error_tolerant) return;

    end_expect_token_locations_t *locations;
    locations = ALLOC(end_expect_token_locations_t);
    locations->pos = pos;
    locations->prev = p->end_expect_token_locations;
    p->end_expect_token_locations = locations;

    debug_end_expect_token_locations(p, "push_end_expect_token_locations");
}

static void
pop_end_expect_token_locations(struct parser_params *p)
{
    if(!p->end_expect_token_locations) return;

    end_expect_token_locations_t *locations = p->end_expect_token_locations->prev;
    ruby_sized_xfree(p->end_expect_token_locations, sizeof(end_expect_token_locations_t));
    p->end_expect_token_locations = locations;

    debug_end_expect_token_locations(p, "pop_end_expect_token_locations");
}

static end_expect_token_locations_t *
peek_end_expect_token_locations(struct parser_params *p)
{
    return p->end_expect_token_locations;
}

static const char *
parser_token2char(struct parser_params *p, enum yytokentype tok)
{
    switch ((int) tok) {
#define TOKEN2CHAR(tok) case tok: return (#tok);
#define TOKEN2CHAR2(tok, name) case tok: return (name);
      TOKEN2CHAR2(' ', "word_sep");
      TOKEN2CHAR2('!', "!")
      TOKEN2CHAR2('%', "%");
      TOKEN2CHAR2('&', "&");
      TOKEN2CHAR2('*', "*");
      TOKEN2CHAR2('+', "+");
      TOKEN2CHAR2('-', "-");
      TOKEN2CHAR2('/', "/");
      TOKEN2CHAR2('<', "<");
      TOKEN2CHAR2('=', "=");
      TOKEN2CHAR2('>', ">");
      TOKEN2CHAR2('?', "?");
      TOKEN2CHAR2('^', "^");
      TOKEN2CHAR2('|', "|");
      TOKEN2CHAR2('~', "~");
      TOKEN2CHAR2(':', ":");
      TOKEN2CHAR2(',', ",");
      TOKEN2CHAR2('.', ".");
      TOKEN2CHAR2(';', ";");
      TOKEN2CHAR2('`', "`");
      TOKEN2CHAR2('\n', "nl");
      TOKEN2CHAR2('{', "\"{\"");
      TOKEN2CHAR2('}', "\"}\"");
      TOKEN2CHAR2('[', "\"[\"");
      TOKEN2CHAR2(']', "\"]\"");
      TOKEN2CHAR2('(', "\"(\"");
      TOKEN2CHAR2(')', "\")\"");
      TOKEN2CHAR2('\\', "backslash");
      TOKEN2CHAR(keyword_class);
      TOKEN2CHAR(keyword_module);
      TOKEN2CHAR(keyword_def);
      TOKEN2CHAR(keyword_undef);
      TOKEN2CHAR(keyword_begin);
      TOKEN2CHAR(keyword_rescue);
      TOKEN2CHAR(keyword_ensure);
      TOKEN2CHAR(keyword_end);
      TOKEN2CHAR(keyword_if);
      TOKEN2CHAR(keyword_unless);
      TOKEN2CHAR(keyword_then);
      TOKEN2CHAR(keyword_elsif);
      TOKEN2CHAR(keyword_else);
      TOKEN2CHAR(keyword_case);
      TOKEN2CHAR(keyword_when);
      TOKEN2CHAR(keyword_while);
      TOKEN2CHAR(keyword_until);
      TOKEN2CHAR(keyword_for);
      TOKEN2CHAR(keyword_break);
      TOKEN2CHAR(keyword_next);
      TOKEN2CHAR(keyword_redo);
      TOKEN2CHAR(keyword_retry);
      TOKEN2CHAR(keyword_in);
      TOKEN2CHAR(keyword_do);
      TOKEN2CHAR(keyword_do_cond);
      TOKEN2CHAR(keyword_do_block);
      TOKEN2CHAR(keyword_do_LAMBDA);
      TOKEN2CHAR(keyword_return);
      TOKEN2CHAR(keyword_yield);
      TOKEN2CHAR(keyword_super);
      TOKEN2CHAR(keyword_self);
      TOKEN2CHAR(keyword_nil);
      TOKEN2CHAR(keyword_true);
      TOKEN2CHAR(keyword_false);
      TOKEN2CHAR(keyword_and);
      TOKEN2CHAR(keyword_or);
      TOKEN2CHAR(keyword_not);
      TOKEN2CHAR(modifier_if);
      TOKEN2CHAR(modifier_unless);
      TOKEN2CHAR(modifier_while);
      TOKEN2CHAR(modifier_until);
      TOKEN2CHAR(modifier_rescue);
      TOKEN2CHAR(keyword_alias);
      TOKEN2CHAR(keyword_defined);
      TOKEN2CHAR(keyword_BEGIN);
      TOKEN2CHAR(keyword_END);
      TOKEN2CHAR(keyword__LINE__);
      TOKEN2CHAR(keyword__FILE__);
      TOKEN2CHAR(keyword__ENCODING__);
      TOKEN2CHAR(tIDENTIFIER);
      TOKEN2CHAR(tFID);
      TOKEN2CHAR(tGVAR);
      TOKEN2CHAR(tIVAR);
      TOKEN2CHAR(tCONSTANT);
      TOKEN2CHAR(tCVAR);
      TOKEN2CHAR(tLABEL);
      TOKEN2CHAR(tINTEGER);
      TOKEN2CHAR(tFLOAT);
      TOKEN2CHAR(tRATIONAL);
      TOKEN2CHAR(tIMAGINARY);
      TOKEN2CHAR(tCHAR);
      TOKEN2CHAR(tNTH_REF);
      TOKEN2CHAR(tBACK_REF);
      TOKEN2CHAR(tSTRING_CONTENT);
      TOKEN2CHAR(tREGEXP_END);
      TOKEN2CHAR(tDUMNY_END);
      TOKEN2CHAR(tSP);
      TOKEN2CHAR(tUPLUS);
      TOKEN2CHAR(tUMINUS);
      TOKEN2CHAR(tPOW);
      TOKEN2CHAR(tCMP);
      TOKEN2CHAR(tEQ);
      TOKEN2CHAR(tEQQ);
      TOKEN2CHAR(tNEQ);
      TOKEN2CHAR(tGEQ);
      TOKEN2CHAR(tLEQ);
      TOKEN2CHAR(tANDOP);
      TOKEN2CHAR(tOROP);
      TOKEN2CHAR(tMATCH);
      TOKEN2CHAR(tNMATCH);
      TOKEN2CHAR(tDOT2);
      TOKEN2CHAR(tDOT3);
      TOKEN2CHAR(tBDOT2);
      TOKEN2CHAR(tBDOT3);
      TOKEN2CHAR(tAREF);
      TOKEN2CHAR(tASET);
      TOKEN2CHAR(tLSHFT);
      TOKEN2CHAR(tRSHFT);
      TOKEN2CHAR(tANDDOT);
      TOKEN2CHAR(tCOLON2);
      TOKEN2CHAR(tCOLON3);
      TOKEN2CHAR(tOP_ASGN);
      TOKEN2CHAR(tASSOC);
      TOKEN2CHAR(tLPAREN);
      TOKEN2CHAR(tLPAREN_ARG);
      TOKEN2CHAR(tRPAREN);
      TOKEN2CHAR(tLBRACK);
      TOKEN2CHAR(tLBRACE);
      TOKEN2CHAR(tLBRACE_ARG);
      TOKEN2CHAR(tSTAR);
      TOKEN2CHAR(tDSTAR);
      TOKEN2CHAR(tAMPER);
      TOKEN2CHAR(tLAMBDA);
      TOKEN2CHAR(tSYMBEG);
      TOKEN2CHAR(tSTRING_BEG);
      TOKEN2CHAR(tXSTRING_BEG);
      TOKEN2CHAR(tREGEXP_BEG);
      TOKEN2CHAR(tWORDS_BEG);
      TOKEN2CHAR(tQWORDS_BEG);
      TOKEN2CHAR(tSYMBOLS_BEG);
      TOKEN2CHAR(tQSYMBOLS_BEG);
      TOKEN2CHAR(tSTRING_END);
      TOKEN2CHAR(tSTRING_DEND);
      TOKEN2CHAR(tSTRING_DBEG);
      TOKEN2CHAR(tSTRING_DVAR);
      TOKEN2CHAR(tLAMBEG);
      TOKEN2CHAR(tLABEL_END);
      TOKEN2CHAR(tIGNORED_NL);
      TOKEN2CHAR(tCOMMENT);
      TOKEN2CHAR(tEMBDOC_BEG);
      TOKEN2CHAR(tEMBDOC);
      TOKEN2CHAR(tEMBDOC_END);
      TOKEN2CHAR(tHEREDOC_BEG);
      TOKEN2CHAR(tHEREDOC_END);
      TOKEN2CHAR(k__END__);
      TOKEN2CHAR(tLOWEST);
      TOKEN2CHAR(tUMINUS_NUM);
      TOKEN2CHAR(tLAST_TOKEN);
#undef TOKEN2CHAR
#undef TOKEN2CHAR2
    }

    rb_bug("parser_token2id: unknown token %d", tok);

    UNREACHABLE_RETURN(0);
}
#else
static void
push_end_expect_token_locations(struct parser_params *p, const rb_code_position_t *pos)
{
}

static void
pop_end_expect_token_locations(struct parser_params *p)
{
}
#endif

RBIMPL_ATTR_NONNULL((1, 2, 3))
static int parser_yyerror(struct parser_params*, const YYLTYPE *yylloc, const char*);
RBIMPL_ATTR_NONNULL((1, 2))
static int parser_yyerror0(struct parser_params*, const char*);
#define yyerror0(msg) parser_yyerror0(p, (msg))
#define yyerror1(loc, msg) parser_yyerror(p, (loc), (msg))
#define yyerror(yylloc, p, msg) parser_yyerror(p, yylloc, msg)
#define token_flush(ptr) ((ptr)->lex.ptok = (ptr)->lex.pcur)
#define lex_goto_eol(p) ((p)->lex.pcur = (p)->lex.pend)
#define lex_eol_p(p) lex_eol_n_p(p, 0)
#define lex_eol_n_p(p,n) lex_eol_ptr_n_p(p, (p)->lex.pcur, n)
#define lex_eol_ptr_p(p,ptr) lex_eol_ptr_n_p(p,ptr,0)
#define lex_eol_ptr_n_p(p,ptr,n) ((ptr)+(n) >= (p)->lex.pend)

static void token_info_setup(token_info *ptinfo, const char *ptr, const rb_code_location_t *loc);
static void token_info_push(struct parser_params*, const char *token, const rb_code_location_t *loc);
static void token_info_pop(struct parser_params*, const char *token, const rb_code_location_t *loc);
static void token_info_warn(struct parser_params *p, const char *token, token_info *ptinfo_beg, int same, const rb_code_location_t *loc);
static void token_info_drop(struct parser_params *p, const char *token, rb_code_position_t beg_pos);

#ifdef RIPPER
#define compile_for_eval	(0)
#else
#define compile_for_eval	(p->parent_iseq != 0)
#endif

#define token_column		((int)(p->lex.ptok - p->lex.pbeg))

#define CALL_Q_P(q) ((q) == tANDDOT)
#define NEW_QCALL(q,r,m,a,loc) (CALL_Q_P(q) ? NEW_QCALL0(r,m,a,loc) : NEW_CALL(r,m,a,loc))

#define lambda_beginning_p() (p->lex.lpar_beg == p->lex.paren_nest)

static enum yytokentype yylex(YYSTYPE*, YYLTYPE*, struct parser_params*);

static inline void
rb_discard_node(struct parser_params *p, NODE *n)
{
    rb_ast_delete_node(p->ast, n);
}

static rb_node_scope_t *rb_node_scope_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc);
static rb_node_scope_t *rb_node_scope_new2(struct parser_params *p, rb_ast_id_table_t *nd_tbl, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc);
static rb_node_block_t *rb_node_block_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_if_t *rb_node_if_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc);
static rb_node_unless_t *rb_node_unless_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_case_t *rb_node_case_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_case2_t *rb_node_case2_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_case3_t *rb_node_case3_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_when_t *rb_node_when_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc);
static rb_node_in_t *rb_node_in_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc);
static rb_node_while_t *rb_node_while_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc);
static rb_node_until_t *rb_node_until_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc);
static rb_node_iter_t *rb_node_iter_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc);
static rb_node_for_t *rb_node_for_new(struct parser_params *p, NODE *nd_iter, NODE *nd_body, const YYLTYPE *loc);
static rb_node_for_masgn_t *rb_node_for_masgn_new(struct parser_params *p, NODE *nd_var, const YYLTYPE *loc);
static rb_node_retry_t *rb_node_retry_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_begin_t *rb_node_begin_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_rescue_t *rb_node_rescue_new(struct parser_params *p, NODE *nd_head, NODE *nd_resq, NODE *nd_else, const YYLTYPE *loc);
static rb_node_resbody_t *rb_node_resbody_new(struct parser_params *p, NODE *nd_args, NODE *nd_exc_var, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc);
static rb_node_ensure_t *rb_node_ensure_new(struct parser_params *p, NODE *nd_head, NODE *nd_ensr, const YYLTYPE *loc);
static rb_node_and_t *rb_node_and_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_or_t *rb_node_or_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_masgn_t *rb_node_masgn_new(struct parser_params *p, NODE *nd_head, NODE *nd_args, const YYLTYPE *loc);
static rb_node_lasgn_t *rb_node_lasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_dasgn_t *rb_node_dasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_gasgn_t *rb_node_gasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_iasgn_t *rb_node_iasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_cdecl_t *rb_node_cdecl_new(struct parser_params *p, ID nd_vid, NODE *nd_value, NODE *nd_else, enum rb_parser_shareability shareability, const YYLTYPE *loc);
static rb_node_cvasgn_t *rb_node_cvasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_op_asgn1_t *rb_node_op_asgn1_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *index, NODE *rvalue, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc);
static rb_node_op_asgn2_t *rb_node_op_asgn2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, ID nd_vid, ID nd_mid, bool nd_aid, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc);
static rb_node_op_asgn_or_t *rb_node_op_asgn_or_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc);
static rb_node_op_asgn_and_t *rb_node_op_asgn_and_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc);
static rb_node_op_cdecl_t *rb_node_op_cdecl_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, ID nd_aid, enum rb_parser_shareability shareability, const YYLTYPE *loc);
static rb_node_call_t *rb_node_call_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_opcall_t *rb_node_opcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_fcall_t *rb_node_fcall_new(struct parser_params *p, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_vcall_t *rb_node_vcall_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc);
static rb_node_qcall_t *rb_node_qcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_super_t *rb_node_super_new(struct parser_params *p, NODE *nd_args, const YYLTYPE *loc);
static rb_node_zsuper_t * rb_node_zsuper_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_list_t *rb_node_list_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_list_t *rb_node_list_new2(struct parser_params *p, NODE *nd_head, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_zlist_t *rb_node_zlist_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_hash_t *rb_node_hash_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_return_t *rb_node_return_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_yield_t *rb_node_yield_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_lvar_t *rb_node_lvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_dvar_t *rb_node_dvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_gvar_t *rb_node_gvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_ivar_t *rb_node_ivar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_const_t *rb_node_const_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_cvar_t *rb_node_cvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_nth_ref_t *rb_node_nth_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc);
static rb_node_back_ref_t *rb_node_back_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc);
static rb_node_match2_t *rb_node_match2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc);
static rb_node_match3_t *rb_node_match3_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc);
static rb_node_integer_t * rb_node_integer_new(struct parser_params *p, char* val, int base, const YYLTYPE *loc);
static rb_node_float_t * rb_node_float_new(struct parser_params *p, char* val, const YYLTYPE *loc);
static rb_node_rational_t * rb_node_rational_new(struct parser_params *p, char* val, int base, int seen_point, const YYLTYPE *loc);
static rb_node_imaginary_t * rb_node_imaginary_new(struct parser_params *p, char* val, int base, int seen_point, enum rb_numeric_type, const YYLTYPE *loc);
static rb_node_str_t *rb_node_str_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc);
static rb_node_dstr_t *rb_node_dstr_new0(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_dstr_t *rb_node_dstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc);
static rb_node_xstr_t *rb_node_xstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc);
static rb_node_dxstr_t *rb_node_dxstr_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_evstr_t *rb_node_evstr_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_regx_t *rb_node_regx_new(struct parser_params *p, rb_parser_string_t *string, int options, const YYLTYPE *loc);
static rb_node_once_t *rb_node_once_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_args_t *rb_node_args_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_args_aux_t *rb_node_args_aux_new(struct parser_params *p, ID nd_pid, int nd_plen, const YYLTYPE *loc);
static rb_node_opt_arg_t *rb_node_opt_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_kw_arg_t *rb_node_kw_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_postarg_t *rb_node_postarg_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc);
static rb_node_argscat_t *rb_node_argscat_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc);
static rb_node_argspush_t *rb_node_argspush_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc);
static rb_node_splat_t *rb_node_splat_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_block_pass_t *rb_node_block_pass_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_defn_t *rb_node_defn_new(struct parser_params *p, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc);
static rb_node_defs_t *rb_node_defs_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc);
static rb_node_alias_t *rb_node_alias_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_valias_t *rb_node_valias_new(struct parser_params *p, ID nd_alias, ID nd_orig, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_undef_t *rb_node_undef_new(struct parser_params *p, NODE *nd_undef, const YYLTYPE *loc);
static rb_node_class_t *rb_node_class_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, NODE *nd_super, const YYLTYPE *loc);
static rb_node_module_t *rb_node_module_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, const YYLTYPE *loc);
static rb_node_sclass_t *rb_node_sclass_new(struct parser_params *p, NODE *nd_recv, NODE *nd_body, const YYLTYPE *loc);
static rb_node_colon2_t *rb_node_colon2_new(struct parser_params *p, NODE *nd_head, ID nd_mid, const YYLTYPE *loc);
static rb_node_colon3_t *rb_node_colon3_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc);
static rb_node_dot2_t *rb_node_dot2_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc);
static rb_node_dot3_t *rb_node_dot3_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc);
static rb_node_self_t *rb_node_self_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_nil_t *rb_node_nil_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_true_t *rb_node_true_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_false_t *rb_node_false_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_errinfo_t *rb_node_errinfo_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_defined_t *rb_node_defined_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_postexe_t *rb_node_postexe_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_sym_t *rb_node_sym_new(struct parser_params *p, VALUE str, const YYLTYPE *loc);
static rb_node_dsym_t *rb_node_dsym_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_attrasgn_t *rb_node_attrasgn_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_lambda_t *rb_node_lambda_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc);
static rb_node_aryptn_t *rb_node_aryptn_new(struct parser_params *p, NODE *pre_args, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc);
static rb_node_hshptn_t *rb_node_hshptn_new(struct parser_params *p, NODE *nd_pconst, NODE *nd_pkwargs, NODE *nd_pkwrestarg, const YYLTYPE *loc);
static rb_node_fndptn_t *rb_node_fndptn_new(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc);
static rb_node_line_t *rb_node_line_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_file_t *rb_node_file_new(struct parser_params *p, VALUE str, const YYLTYPE *loc);
static rb_node_error_t *rb_node_error_new(struct parser_params *p, const YYLTYPE *loc);

#define NEW_SCOPE(a,b,loc) (NODE *)rb_node_scope_new(p,a,b,loc)
#define NEW_SCOPE2(t,a,b,loc) (NODE *)rb_node_scope_new2(p,t,a,b,loc)
#define NEW_BLOCK(a,loc) (NODE *)rb_node_block_new(p,a,loc)
#define NEW_IF(c,t,e,loc) (NODE *)rb_node_if_new(p,c,t,e,loc)
#define NEW_UNLESS(c,t,e,loc,k_loc,t_loc,e_loc) (NODE *)rb_node_unless_new(p,c,t,e,loc,k_loc,t_loc,e_loc)
#define NEW_CASE(h,b,loc,ck_loc,ek_loc) (NODE *)rb_node_case_new(p,h,b,loc,ck_loc,ek_loc)
#define NEW_CASE2(b,loc,ck_loc,ek_loc) (NODE *)rb_node_case2_new(p,b,loc,ck_loc,ek_loc)
#define NEW_CASE3(h,b,loc,ck_loc,ek_loc) (NODE *)rb_node_case3_new(p,h,b,loc,ck_loc,ek_loc)
#define NEW_WHEN(c,t,e,loc,k_loc,t_loc) (NODE *)rb_node_when_new(p,c,t,e,loc,k_loc,t_loc)
#define NEW_IN(c,t,e,loc) (NODE *)rb_node_in_new(p,c,t,e,loc)
#define NEW_WHILE(c,b,n,loc,k_loc,c_loc) (NODE *)rb_node_while_new(p,c,b,n,loc,k_loc,c_loc)
#define NEW_UNTIL(c,b,n,loc,k_loc,c_loc) (NODE *)rb_node_until_new(p,c,b,n,loc,k_loc,c_loc)
#define NEW_ITER(a,b,loc) (NODE *)rb_node_iter_new(p,a,b,loc)
#define NEW_FOR(i,b,loc) (NODE *)rb_node_for_new(p,i,b,loc)
#define NEW_FOR_MASGN(v,loc) (NODE *)rb_node_for_masgn_new(p,v,loc)
#define NEW_RETRY(loc) (NODE *)rb_node_retry_new(p,loc)
#define NEW_BEGIN(b,loc) (NODE *)rb_node_begin_new(p,b,loc)
#define NEW_RESCUE(b,res,e,loc) (NODE *)rb_node_rescue_new(p,b,res,e,loc)
#define NEW_RESBODY(a,v,ex,n,loc) (NODE *)rb_node_resbody_new(p,a,v,ex,n,loc)
#define NEW_ENSURE(b,en,loc) (NODE *)rb_node_ensure_new(p,b,en,loc)
#define NEW_AND(f,s,loc,op_loc) (NODE *)rb_node_and_new(p,f,s,loc,op_loc)
#define NEW_OR(f,s,loc,op_loc) (NODE *)rb_node_or_new(p,f,s,loc,op_loc)
#define NEW_MASGN(l,r,loc)   rb_node_masgn_new(p,l,r,loc)
#define NEW_LASGN(v,val,loc) (NODE *)rb_node_lasgn_new(p,v,val,loc)
#define NEW_DASGN(v,val,loc) (NODE *)rb_node_dasgn_new(p,v,val,loc)
#define NEW_GASGN(v,val,loc) (NODE *)rb_node_gasgn_new(p,v,val,loc)
#define NEW_IASGN(v,val,loc) (NODE *)rb_node_iasgn_new(p,v,val,loc)
#define NEW_CDECL(v,val,path,share,loc) (NODE *)rb_node_cdecl_new(p,v,val,path,share,loc)
#define NEW_CVASGN(v,val,loc) (NODE *)rb_node_cvasgn_new(p,v,val,loc)
#define NEW_OP_ASGN1(r,id,idx,rval,loc,c_op_loc,o_loc,c_loc,b_op_loc) (NODE *)rb_node_op_asgn1_new(p,r,id,idx,rval,loc,c_op_loc,o_loc,c_loc,b_op_loc)
#define NEW_OP_ASGN2(r,t,i,o,val,loc,c_op_loc,m_loc,b_op_loc) (NODE *)rb_node_op_asgn2_new(p,r,val,i,o,t,loc,c_op_loc,m_loc,b_op_loc)
#define NEW_OP_ASGN_OR(i,val,loc) (NODE *)rb_node_op_asgn_or_new(p,i,val,loc)
#define NEW_OP_ASGN_AND(i,val,loc) (NODE *)rb_node_op_asgn_and_new(p,i,val,loc)
#define NEW_OP_CDECL(v,op,val,share,loc) (NODE *)rb_node_op_cdecl_new(p,v,val,op,share,loc)
#define NEW_CALL(r,m,a,loc) (NODE *)rb_node_call_new(p,r,m,a,loc)
#define NEW_OPCALL(r,m,a,loc) (NODE *)rb_node_opcall_new(p,r,m,a,loc)
#define NEW_FCALL(m,a,loc) rb_node_fcall_new(p,m,a,loc)
#define NEW_VCALL(m,loc) (NODE *)rb_node_vcall_new(p,m,loc)
#define NEW_QCALL0(r,m,a,loc) (NODE *)rb_node_qcall_new(p,r,m,a,loc)
#define NEW_SUPER(a,loc) (NODE *)rb_node_super_new(p,a,loc)
#define NEW_ZSUPER(loc) (NODE *)rb_node_zsuper_new(p,loc)
#define NEW_LIST(a,loc) (NODE *)rb_node_list_new(p,a,loc)
#define NEW_LIST2(h,l,n,loc) (NODE *)rb_node_list_new2(p,h,l,n,loc)
#define NEW_ZLIST(loc) (NODE *)rb_node_zlist_new(p,loc)
#define NEW_HASH(a,loc) (NODE *)rb_node_hash_new(p,a,loc)
#define NEW_RETURN(s,loc,k_loc) (NODE *)rb_node_return_new(p,s,loc,k_loc)
#define NEW_YIELD(a,loc) (NODE *)rb_node_yield_new(p,a,loc)
#define NEW_LVAR(v,loc) (NODE *)rb_node_lvar_new(p,v,loc)
#define NEW_DVAR(v,loc) (NODE *)rb_node_dvar_new(p,v,loc)
#define NEW_GVAR(v,loc) (NODE *)rb_node_gvar_new(p,v,loc)
#define NEW_IVAR(v,loc) (NODE *)rb_node_ivar_new(p,v,loc)
#define NEW_CONST(v,loc) (NODE *)rb_node_const_new(p,v,loc)
#define NEW_CVAR(v,loc) (NODE *)rb_node_cvar_new(p,v,loc)
#define NEW_NTH_REF(n,loc)  (NODE *)rb_node_nth_ref_new(p,n,loc)
#define NEW_BACK_REF(n,loc) (NODE *)rb_node_back_ref_new(p,n,loc)
#define NEW_MATCH2(n1,n2,loc) (NODE *)rb_node_match2_new(p,n1,n2,loc)
#define NEW_MATCH3(r,n2,loc) (NODE *)rb_node_match3_new(p,r,n2,loc)
#define NEW_INTEGER(val, base,loc) (NODE *)rb_node_integer_new(p,val,base,loc)
#define NEW_FLOAT(val,loc) (NODE *)rb_node_float_new(p,val,loc)
#define NEW_RATIONAL(val,base,seen_point,loc) (NODE *)rb_node_rational_new(p,val,base,seen_point,loc)
#define NEW_IMAGINARY(val,base,seen_point,numeric_type,loc) (NODE *)rb_node_imaginary_new(p,val,base,seen_point,numeric_type,loc)
#define NEW_STR(s,loc) (NODE *)rb_node_str_new(p,s,loc)
#define NEW_DSTR0(s,l,n,loc) (NODE *)rb_node_dstr_new0(p,s,l,n,loc)
#define NEW_DSTR(s,loc) (NODE *)rb_node_dstr_new(p,s,loc)
#define NEW_XSTR(s,loc) (NODE *)rb_node_xstr_new(p,s,loc)
#define NEW_DXSTR(s,l,n,loc) (NODE *)rb_node_dxstr_new(p,s,l,n,loc)
#define NEW_EVSTR(n,loc) (NODE *)rb_node_evstr_new(p,n,loc)
#define NEW_REGX(str,opts,loc) (NODE *)rb_node_regx_new(p,str,opts,loc)
#define NEW_ONCE(b,loc) (NODE *)rb_node_once_new(p,b,loc)
#define NEW_ARGS(loc) rb_node_args_new(p,loc)
#define NEW_ARGS_AUX(r,b,loc) rb_node_args_aux_new(p,r,b,loc)
#define NEW_OPT_ARG(v,loc) rb_node_opt_arg_new(p,v,loc)
#define NEW_KW_ARG(v,loc) rb_node_kw_arg_new(p,v,loc)
#define NEW_POSTARG(i,v,loc) (NODE *)rb_node_postarg_new(p,i,v,loc)
#define NEW_ARGSCAT(a,b,loc) (NODE *)rb_node_argscat_new(p,a,b,loc)
#define NEW_ARGSPUSH(a,b,loc) (NODE *)rb_node_argspush_new(p,a,b,loc)
#define NEW_SPLAT(a,loc,op_loc) (NODE *)rb_node_splat_new(p,a,loc,op_loc)
#define NEW_BLOCK_PASS(b,loc,o_loc) rb_node_block_pass_new(p,b,loc,o_loc)
#define NEW_DEFN(i,s,loc) (NODE *)rb_node_defn_new(p,i,s,loc)
#define NEW_DEFS(r,i,s,loc) (NODE *)rb_node_defs_new(p,r,i,s,loc)
#define NEW_ALIAS(n,o,loc,k_loc) (NODE *)rb_node_alias_new(p,n,o,loc,k_loc)
#define NEW_VALIAS(n,o,loc,k_loc) (NODE *)rb_node_valias_new(p,n,o,loc,k_loc)
#define NEW_UNDEF(i,loc) (NODE *)rb_node_undef_new(p,i,loc)
#define NEW_CLASS(n,b,s,loc) (NODE *)rb_node_class_new(p,n,b,s,loc)
#define NEW_MODULE(n,b,loc) (NODE *)rb_node_module_new(p,n,b,loc)
#define NEW_SCLASS(r,b,loc) (NODE *)rb_node_sclass_new(p,r,b,loc)
#define NEW_COLON2(c,i,loc) (NODE *)rb_node_colon2_new(p,c,i,loc)
#define NEW_COLON3(i,loc) (NODE *)rb_node_colon3_new(p,i,loc)
#define NEW_DOT2(b,e,loc) (NODE *)rb_node_dot2_new(p,b,e,loc)
#define NEW_DOT3(b,e,loc) (NODE *)rb_node_dot3_new(p,b,e,loc)
#define NEW_SELF(loc) (NODE *)rb_node_self_new(p,loc)
#define NEW_NIL(loc) (NODE *)rb_node_nil_new(p,loc)
#define NEW_TRUE(loc) (NODE *)rb_node_true_new(p,loc)
#define NEW_FALSE(loc) (NODE *)rb_node_false_new(p,loc)
#define NEW_ERRINFO(loc) (NODE *)rb_node_errinfo_new(p,loc)
#define NEW_DEFINED(e,loc) (NODE *)rb_node_defined_new(p,e,loc)
#define NEW_POSTEXE(b,loc) (NODE *)rb_node_postexe_new(p,b,loc)
#define NEW_SYM(str,loc) (NODE *)rb_node_sym_new(p,str,loc)
#define NEW_DSYM(s,l,n,loc) (NODE *)rb_node_dsym_new(p,s,l,n,loc)
#define NEW_ATTRASGN(r,m,a,loc) (NODE *)rb_node_attrasgn_new(p,r,m,a,loc)
#define NEW_LAMBDA(a,b,loc) (NODE *)rb_node_lambda_new(p,a,b,loc)
#define NEW_ARYPTN(pre,r,post,loc) (NODE *)rb_node_aryptn_new(p,pre,r,post,loc)
#define NEW_HSHPTN(c,kw,kwrest,loc) (NODE *)rb_node_hshptn_new(p,c,kw,kwrest,loc)
#define NEW_FNDPTN(pre,a,post,loc) (NODE *)rb_node_fndptn_new(p,pre,a,post,loc)
#define NEW_LINE(loc) (NODE *)rb_node_line_new(p,loc)
#define NEW_FILE(str,loc) (NODE *)rb_node_file_new(p,str,loc)
#define NEW_ENCODING(loc) (NODE *)rb_node_encoding_new(p,loc)
#define NEW_ERROR(loc) (NODE *)rb_node_error_new(p,loc)

enum internal_node_type {
    NODE_INTERNAL_ONLY = NODE_LAST,
    NODE_DEF_TEMP,
    NODE_EXITS,
    NODE_INTERNAL_LAST
};

static const char *
parser_node_name(int node)
{
    switch (node) {
      case NODE_DEF_TEMP:
        return "NODE_DEF_TEMP";
      case NODE_EXITS:
        return "NODE_EXITS";
      default:
        return ruby_node_name(node);
    }
}

/* This node is parse.y internal */
struct RNode_DEF_TEMP {
    NODE node;

    /* for NODE_DEFN/NODE_DEFS */

    struct RNode *nd_def;
    ID nd_mid;

    struct {
        int max_numparam;
        NODE *numparam_save;
        struct lex_context ctxt;
    } save;
};

#define RNODE_DEF_TEMP(node) ((struct RNode_DEF_TEMP *)(node))

static rb_node_break_t *rb_node_break_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_next_t *rb_node_next_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_redo_t *rb_node_redo_new(struct parser_params *p, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_def_temp_t *rb_node_def_temp_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_def_temp_t *def_head_save(struct parser_params *p, rb_node_def_temp_t *n);

#define NEW_BREAK(s,loc,k_loc) (NODE *)rb_node_break_new(p,s,loc,k_loc)
#define NEW_NEXT(s,loc,k_loc) (NODE *)rb_node_next_new(p,s,loc,k_loc)
#define NEW_REDO(loc,k_loc) (NODE *)rb_node_redo_new(p,loc,k_loc)
#define NEW_DEF_TEMP(loc) rb_node_def_temp_new(p,loc)

/* Make a new internal node, which should not be appeared in the
 * result AST and does not have node_id and location. */
static NODE* node_new_internal(struct parser_params *p, enum node_type type, size_t size, size_t alignment);
#define NODE_NEW_INTERNAL(ndtype, type) (type *)node_new_internal(p, (enum node_type)(ndtype), sizeof(type), RUBY_ALIGNOF(type))

static NODE *nd_set_loc(NODE *nd, const YYLTYPE *loc);

static int
parser_get_node_id(struct parser_params *p)
{
    int node_id = p->node_id;
    p->node_id++;
    return node_id;
}

static void
anddot_multiple_assignment_check(struct parser_params* p, const YYLTYPE *loc, ID id)
{
    if (id == tANDDOT) {
        yyerror1(loc, "&. inside multiple assignment destination");
    }
}

static inline void
set_line_body(NODE *body, int line)
{
    if (!body) return;
    switch (nd_type(body)) {
      case NODE_RESCUE:
      case NODE_ENSURE:
        nd_set_line(body, line);
    }
}

static void
set_embraced_location(NODE *node, const rb_code_location_t *beg, const rb_code_location_t *end)
{
    RNODE_ITER(node)->nd_body->nd_loc = code_loc_gen(beg, end);
    nd_set_line(node, beg->end_pos.lineno);
}

static NODE *
last_expr_node(NODE *expr)
{
    while (expr) {
        if (nd_type_p(expr, NODE_BLOCK)) {
            expr = RNODE_BLOCK(RNODE_BLOCK(expr)->nd_end)->nd_head;
        }
        else if (nd_type_p(expr, NODE_BEGIN) && RNODE_BEGIN(expr)->nd_body) {
            expr = RNODE_BEGIN(expr)->nd_body;
        }
        else {
            break;
        }
    }
    return expr;
}

#ifndef RIPPER
#define yyparse ruby_yyparse
#endif

static NODE* cond(struct parser_params *p, NODE *node, const YYLTYPE *loc);
static NODE* method_cond(struct parser_params *p, NODE *node, const YYLTYPE *loc);
#define new_nil(loc) NEW_NIL(loc)
static NODE *new_nil_at(struct parser_params *p, const rb_code_position_t *pos);
static NODE *new_if(struct parser_params*,NODE*,NODE*,NODE*,const YYLTYPE*);
static NODE *new_unless(struct parser_params*,NODE*,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*);
static NODE *logop(struct parser_params*,ID,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*);

static NODE *newline_node(NODE*);
static void fixpos(NODE*,NODE*);

static int value_expr_gen(struct parser_params*,NODE*);
static void void_expr(struct parser_params*,NODE*);
static NODE *remove_begin(NODE*);
#define value_expr(node) value_expr_gen(p, (node))
static NODE *void_stmts(struct parser_params*,NODE*);
static void reduce_nodes(struct parser_params*,NODE**);
static void block_dup_check(struct parser_params*,NODE*,NODE*);

static NODE *block_append(struct parser_params*,NODE*,NODE*);
static NODE *list_append(struct parser_params*,NODE*,NODE*);
static NODE *list_concat(NODE*,NODE*);
static NODE *arg_append(struct parser_params*,NODE*,NODE*,const YYLTYPE*);
static NODE *last_arg_append(struct parser_params *p, NODE *args, NODE *last_arg, const YYLTYPE *loc);
static NODE *rest_arg_append(struct parser_params *p, NODE *args, NODE *rest_arg, const YYLTYPE *loc);
static NODE *literal_concat(struct parser_params*,NODE*,NODE*,const YYLTYPE*);
static NODE *new_evstr(struct parser_params*,NODE*,const YYLTYPE*);
static NODE *new_dstr(struct parser_params*,NODE*,const YYLTYPE*);
static NODE *str2dstr(struct parser_params*,NODE*);
static NODE *evstr2dstr(struct parser_params*,NODE*);
static NODE *splat_array(NODE*);
static void mark_lvar_used(struct parser_params *p, NODE *rhs);

static NODE *call_bin_op(struct parser_params*,NODE*,ID,NODE*,const YYLTYPE*,const YYLTYPE*);
static NODE *call_uni_op(struct parser_params*,NODE*,ID,const YYLTYPE*,const YYLTYPE*);
static NODE *new_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, const YYLTYPE *op_loc, const YYLTYPE *loc);
static NODE *new_command_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, NODE *block, const YYLTYPE *op_loc, const YYLTYPE *loc);
static NODE *method_add_block(struct parser_params*p, NODE *m, NODE *b, const YYLTYPE *loc) {RNODE_ITER(b)->nd_iter = m; b->nd_loc = *loc; return b;}

static bool args_info_empty_p(struct rb_args_info *args);
static rb_node_args_t *new_args(struct parser_params*,rb_node_args_aux_t*,rb_node_opt_arg_t*,ID,rb_node_args_aux_t*,rb_node_args_t*,const YYLTYPE*);
static rb_node_args_t *new_args_tail(struct parser_params*,rb_node_kw_arg_t*,ID,ID,const YYLTYPE*);
static NODE *new_array_pattern(struct parser_params *p, NODE *constant, NODE *pre_arg, NODE *aryptn, const YYLTYPE *loc);
static NODE *new_array_pattern_tail(struct parser_params *p, NODE *pre_args, int has_rest, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc);
static NODE *new_find_pattern(struct parser_params *p, NODE *constant, NODE *fndptn, const YYLTYPE *loc);
static NODE *new_find_pattern_tail(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc);
static NODE *new_hash_pattern(struct parser_params *p, NODE *constant, NODE *hshptn, const YYLTYPE *loc);
static NODE *new_hash_pattern_tail(struct parser_params *p, NODE *kw_args, ID kw_rest_arg, const YYLTYPE *loc);

static rb_node_kw_arg_t *new_kw_arg(struct parser_params *p, NODE *k, const YYLTYPE *loc);
static rb_node_args_t *args_with_numbered(struct parser_params*,rb_node_args_t*,int,ID);

static NODE* negate_lit(struct parser_params*, NODE*);
static NODE *ret_args(struct parser_params*,NODE*);
static NODE *arg_blk_pass(NODE*,rb_node_block_pass_t*);
static NODE *new_yield(struct parser_params*,NODE*,const YYLTYPE*);
static NODE *dsym_node(struct parser_params*,NODE*,const YYLTYPE*);

static NODE *gettable(struct parser_params*,ID,const YYLTYPE*);
static NODE *assignable(struct parser_params*,ID,NODE*,const YYLTYPE*);

static NODE *aryset(struct parser_params*,NODE*,NODE*,const YYLTYPE*);
static NODE *attrset(struct parser_params*,NODE*,ID,ID,const YYLTYPE*);

static VALUE rb_backref_error(struct parser_params*,NODE*);
static NODE *node_assign(struct parser_params*,NODE*,NODE*,struct lex_context,const YYLTYPE*);

static NODE *new_op_assign(struct parser_params *p, NODE *lhs, ID op, NODE *rhs, struct lex_context, const YYLTYPE *loc);
static NODE *new_ary_op_assign(struct parser_params *p, NODE *ary, NODE *args, ID op, NODE *rhs, const YYLTYPE *args_loc, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc);
static NODE *new_attr_op_assign(struct parser_params *p, NODE *lhs, ID atype, ID attr, ID op, NODE *rhs, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc);
static NODE *new_const_op_assign(struct parser_params *p, NODE *lhs, ID op, NODE *rhs, struct lex_context, const YYLTYPE *loc);
static NODE *new_bodystmt(struct parser_params *p, NODE *head, NODE *rescue, NODE *rescue_else, NODE *ensure, const YYLTYPE *loc);

static NODE *const_decl(struct parser_params *p, NODE* path, const YYLTYPE *loc);

static rb_node_opt_arg_t *opt_arg_append(rb_node_opt_arg_t*, rb_node_opt_arg_t*);
static rb_node_kw_arg_t *kwd_append(rb_node_kw_arg_t*, rb_node_kw_arg_t*);

static NODE *new_hash(struct parser_params *p, NODE *hash, const YYLTYPE *loc);
static NODE *new_unique_key_hash(struct parser_params *p, NODE *hash, const YYLTYPE *loc);

static NODE *new_defined(struct parser_params *p, NODE *expr, const YYLTYPE *loc);

static NODE *new_regexp(struct parser_params *, NODE *, int, const YYLTYPE *);

#define make_list(list, loc) ((list) ? (nd_set_loc(list, loc), list) : NEW_ZLIST(loc))

static NODE *new_xstring(struct parser_params *, NODE *, const YYLTYPE *loc);

static NODE *symbol_append(struct parser_params *p, NODE *symbols, NODE *symbol);

static NODE *match_op(struct parser_params*,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*);

static rb_ast_id_table_t *local_tbl(struct parser_params*);

static VALUE reg_compile(struct parser_params*, rb_parser_string_t*, int);
static void reg_fragment_setenc(struct parser_params*, rb_parser_string_t*, int);
int rb_parser_reg_fragment_check(struct parser_params*, rb_parser_string_t*, int, rb_parser_reg_fragment_error_func);
static void reg_fragment_error(struct parser_params *, VALUE);
#define reg_fragment_check(p, str, option) rb_parser_reg_fragment_check(p, str, option, reg_fragment_error)

static int literal_concat0(struct parser_params *p, rb_parser_string_t *head, rb_parser_string_t *tail);
static NODE *heredoc_dedent(struct parser_params*,NODE*);

static void check_literal_when(struct parser_params *p, NODE *args, const YYLTYPE *loc);

#ifdef RIPPER
#define get_value(idx) (rb_ary_entry(p->s_value_stack, idx))
#define set_value(val) (p->s_lvalue = val)
static VALUE assign_error(struct parser_params *p, const char *mesg, VALUE a);
static int id_is_var(struct parser_params *p, ID id);
#endif

RUBY_SYMBOL_EXPORT_BEGIN
VALUE rb_parser_reg_compile(struct parser_params* p, VALUE str, int options);
int rb_reg_fragment_setenc(struct parser_params*, rb_parser_string_t *, int);
enum lex_state_e rb_parser_trace_lex_state(struct parser_params *, enum lex_state_e, enum lex_state_e, int);
VALUE rb_parser_lex_state_name(struct parser_params *p, enum lex_state_e state);
void rb_parser_show_bitstack(struct parser_params *, stack_type, const char *, int);
PRINTF_ARGS(void rb_parser_fatal(struct parser_params *p, const char *fmt, ...), 2, 3);
YYLTYPE *rb_parser_set_location_from_strterm_heredoc(struct parser_params *p, rb_strterm_heredoc_t *here, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_delayed_token(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_heredoc_end(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_dummy_end(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_none(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location(struct parser_params *p, YYLTYPE *yylloc);
void ruby_show_error_line(struct parser_params *p, VALUE errbuf, const YYLTYPE *yylloc, int lineno, rb_parser_string_t *str);
RUBY_SYMBOL_EXPORT_END

static void flush_string_content(struct parser_params *p, rb_encoding *enc, size_t back);
static void error_duplicate_pattern_variable(struct parser_params *p, ID id, const YYLTYPE *loc);
static void error_duplicate_pattern_key(struct parser_params *p, ID id, const YYLTYPE *loc);
static VALUE formal_argument_error(struct parser_params*, ID);
static ID shadowing_lvar(struct parser_params*,ID);
static void new_bv(struct parser_params*,ID);

static void local_push(struct parser_params*,int);
static void local_pop(struct parser_params*);
static void local_var(struct parser_params*, ID);
static void arg_var(struct parser_params*, ID);
static int  local_id(struct parser_params *p, ID id);
static int  local_id_ref(struct parser_params*, ID, ID **);
#define internal_id rb_parser_internal_id
ID internal_id(struct parser_params*);
static NODE *new_args_forward_call(struct parser_params*, NODE*, const YYLTYPE*, const YYLTYPE*);
static int check_forwarding_args(struct parser_params*);
static void add_forwarding_args(struct parser_params *p);
static void forwarding_arg_check(struct parser_params *p, ID arg, ID all, const char *var);

static const struct vtable *dyna_push(struct parser_params *);
static void dyna_pop(struct parser_params*, const struct vtable *);
static int dyna_in_block(struct parser_params*);
#define dyna_var(p, id) local_var(p, id)
static int dvar_defined(struct parser_params*, ID);
#define dvar_defined_ref rb_parser_dvar_defined_ref
int dvar_defined_ref(struct parser_params*, ID, ID**);
static int dvar_curr(struct parser_params*,ID);

static int lvar_defined(struct parser_params*, ID);

static NODE *numparam_push(struct parser_params *p);
static void numparam_pop(struct parser_params *p, NODE *prev_inner);

#define METHOD_NOT '!'

#define idFWD_REST   '*'
#define idFWD_KWREST idPow /* Use simple "**", as tDSTAR is "**arg" */
#define idFWD_BLOCK  '&'
#define idFWD_ALL    idDot3
#define arg_FWD_BLOCK idFWD_BLOCK

#define RE_ONIG_OPTION_IGNORECASE 1
#define RE_ONIG_OPTION_EXTEND     (RE_ONIG_OPTION_IGNORECASE<<1)
#define RE_ONIG_OPTION_MULTILINE  (RE_ONIG_OPTION_EXTEND<<1)
#define RE_OPTION_ONCE (1<<16)
#define RE_OPTION_ENCODING_SHIFT 8
#define RE_OPTION_ENCODING(e) (((e)&0xff)<<RE_OPTION_ENCODING_SHIFT)
#define RE_OPTION_ENCODING_IDX(o) (((o)>>RE_OPTION_ENCODING_SHIFT)&0xff)
#define RE_OPTION_ENCODING_NONE(o) ((o)&RE_OPTION_ARG_ENCODING_NONE)
#define RE_OPTION_MASK  0xff
#define RE_OPTION_ARG_ENCODING_NONE 32

#define CHECK_LITERAL_WHEN (st_table *)1
#define CASE_LABELS_ENABLED_P(case_labels) (case_labels && case_labels != CHECK_LITERAL_WHEN)

#define yytnamerr(yyres, yystr) (YYSIZE_T)rb_yytnamerr(p, yyres, yystr)
RUBY_FUNC_EXPORTED size_t rb_yytnamerr(struct parser_params *p, char *yyres, const char *yystr);

#define TOKEN2ID(tok) ( \
    tTOKEN_LOCAL_BEGIN<(tok)&&(tok)<tTOKEN_LOCAL_END ? TOKEN2LOCALID(tok) : \
    tTOKEN_INSTANCE_BEGIN<(tok)&&(tok)<tTOKEN_INSTANCE_END ? TOKEN2INSTANCEID(tok) : \
    tTOKEN_GLOBAL_BEGIN<(tok)&&(tok)<tTOKEN_GLOBAL_END ? TOKEN2GLOBALID(tok) : \
    tTOKEN_CONST_BEGIN<(tok)&&(tok)<tTOKEN_CONST_END ? TOKEN2CONSTID(tok) : \
    tTOKEN_CLASS_BEGIN<(tok)&&(tok)<tTOKEN_CLASS_END ? TOKEN2CLASSID(tok) : \
    tTOKEN_ATTRSET_BEGIN<(tok)&&(tok)<tTOKEN_ATTRSET_END ? TOKEN2ATTRSETID(tok) : \
    ((tok) / ((tok)<tPRESERVED_ID_END && ((tok)>=128 || rb_ispunct(tok)))))

/****** Ripper *******/

#ifdef RIPPER

#include "eventids1.h"
#include "eventids2.h"

extern const struct ripper_parser_ids ripper_parser_ids;

static VALUE ripper_dispatch0(struct parser_params*,ID);
static VALUE ripper_dispatch1(struct parser_params*,ID,VALUE);
static VALUE ripper_dispatch2(struct parser_params*,ID,VALUE,VALUE);
static VALUE ripper_dispatch3(struct parser_params*,ID,VALUE,VALUE,VALUE);
static VALUE ripper_dispatch4(struct parser_params*,ID,VALUE,VALUE,VALUE,VALUE);
static VALUE ripper_dispatch5(struct parser_params*,ID,VALUE,VALUE,VALUE,VALUE,VALUE);
static VALUE ripper_dispatch7(struct parser_params*,ID,VALUE,VALUE,VALUE,VALUE,VALUE,VALUE,VALUE);
void ripper_error(struct parser_params *p);

#define dispatch0(n)            ripper_dispatch0(p, RIPPER_ID(n))
#define dispatch1(n,a)          ripper_dispatch1(p, RIPPER_ID(n), (a))
#define dispatch2(n,a,b)        ripper_dispatch2(p, RIPPER_ID(n), (a), (b))
#define dispatch3(n,a,b,c)      ripper_dispatch3(p, RIPPER_ID(n), (a), (b), (c))
#define dispatch4(n,a,b,c,d)    ripper_dispatch4(p, RIPPER_ID(n), (a), (b), (c), (d))
#define dispatch5(n,a,b,c,d,e)  ripper_dispatch5(p, RIPPER_ID(n), (a), (b), (c), (d), (e))
#define dispatch7(n,a,b,c,d,e,f,g) ripper_dispatch7(p, RIPPER_ID(n), (a), (b), (c), (d), (e), (f), (g))

#define yyparse ripper_yyparse

static VALUE
aryptn_pre_args(struct parser_params *p, VALUE pre_arg, VALUE pre_args)
{
    if (!NIL_P(pre_arg)) {
        if (!NIL_P(pre_args)) {
            rb_ary_unshift(pre_args, pre_arg);
        }
        else {
            pre_args = rb_ary_new_from_args(1, pre_arg);
        }
    }
    return pre_args;
}

#define ID2VAL(id) STATIC_ID2SYM(id)
#define TOKEN2VAL(t) ID2VAL(TOKEN2ID(t))
#endif /* RIPPER */

#define KWD2EID(t, v) keyword_##t

static NODE *
new_scope_body(struct parser_params *p, rb_node_args_t *args, NODE *body, const YYLTYPE *loc)
{
    body = remove_begin(body);
    reduce_nodes(p, &body);
    NODE *n = NEW_SCOPE(args, body, loc);
    nd_set_line(n, loc->end_pos.lineno);
    set_line_body(body, loc->beg_pos.lineno);
    return n;
}

static NODE *
rescued_expr(struct parser_params *p, NODE *arg, NODE *rescue,
             const YYLTYPE *arg_loc, const YYLTYPE *mod_loc, const YYLTYPE *res_loc)
{
    YYLTYPE loc = code_loc_gen(mod_loc, res_loc);
    rescue = NEW_RESBODY(0, 0, remove_begin(rescue), 0, &loc);
    loc.beg_pos = arg_loc->beg_pos;
    return NEW_RESCUE(arg, rescue, 0, &loc);
}

static NODE *add_block_exit(struct parser_params *p, NODE *node);
static rb_node_exits_t *init_block_exit(struct parser_params *p);
static rb_node_exits_t *allow_block_exit(struct parser_params *p);
static void restore_block_exit(struct parser_params *p, rb_node_exits_t *exits);
static void clear_block_exit(struct parser_params *p, bool error);

static void
next_rescue_context(struct lex_context *next, const struct lex_context *outer, enum rescue_context def)
{
    next->in_rescue = outer->in_rescue == after_rescue ? after_rescue : def;
}

static void
restore_defun(struct parser_params *p, rb_node_def_temp_t *temp)
{
    /* See: def_name action */
    struct lex_context ctxt = temp->save.ctxt;
    p->ctxt.in_def = ctxt.in_def;
    p->ctxt.shareable_constant_value = ctxt.shareable_constant_value;
    p->ctxt.in_rescue = ctxt.in_rescue;
    p->max_numparam = temp->save.max_numparam;
    numparam_pop(p, temp->save.numparam_save);
    clear_block_exit(p, true);
}

static void
endless_method_name(struct parser_params *p, ID mid, const YYLTYPE *loc)
{
    if (is_attrset_id(mid)) {
        yyerror1(loc, "setter method cannot be defined in an endless method definition");
    }
    token_info_drop(p, "def", loc->beg_pos);
}

#define debug_token_line(p, name, line) do { \
        if (p->debug) { \
            const char *const pcur = p->lex.pcur; \
            const char *const ptok = p->lex.ptok; \
            rb_parser_printf(p, name ":%d (%d: %"PRIdPTRDIFF"|%"PRIdPTRDIFF"|%"PRIdPTRDIFF")\n", \
                             line, p->ruby_sourceline, \
                             ptok - p->lex.pbeg, pcur - ptok, p->lex.pend - pcur); \
        } \
    } while (0)

#define begin_definition(k, loc_beg, loc_end) \
    do { \
        if (!(p->ctxt.in_class = (k)[0] != 0)) { \
            /* singleton class */ \
            p->ctxt.cant_return = !p->ctxt.in_def; \
            p->ctxt.in_def = 0; \
        } \
        else if (p->ctxt.in_def) { \
            YYLTYPE loc = code_loc_gen(loc_beg, loc_end); \
            yyerror1(&loc, k " definition in method body"); \
        } \
        else { \
            p->ctxt.cant_return = 1; \
        } \
        local_push(p, 0); \
    } while (0)

#ifndef RIPPER
# define ifndef_ripper(x) (x)
# define ifdef_ripper(r,x) (x)
#else
# define ifndef_ripper(x)
# define ifdef_ripper(r,x) (r)
#endif

# define rb_warn0(fmt)         WARN_CALL(WARN_ARGS(fmt, 1))
# define rb_warn1(fmt,a)       WARN_CALL(WARN_ARGS(fmt, 2), (a))
# define rb_warn2(fmt,a,b)     WARN_CALL(WARN_ARGS(fmt, 3), (a), (b))
# define rb_warn3(fmt,a,b,c)   WARN_CALL(WARN_ARGS(fmt, 4), (a), (b), (c))
# define rb_warn4(fmt,a,b,c,d) WARN_CALL(WARN_ARGS(fmt, 5), (a), (b), (c), (d))
# define rb_warning0(fmt)         WARNING_CALL(WARNING_ARGS(fmt, 1))
# define rb_warning1(fmt,a)       WARNING_CALL(WARNING_ARGS(fmt, 2), (a))
# define rb_warning2(fmt,a,b)     WARNING_CALL(WARNING_ARGS(fmt, 3), (a), (b))
# define rb_warning3(fmt,a,b,c)   WARNING_CALL(WARNING_ARGS(fmt, 4), (a), (b), (c))
# define rb_warning4(fmt,a,b,c,d) WARNING_CALL(WARNING_ARGS(fmt, 5), (a), (b), (c), (d))
# define rb_warn0L(l,fmt)         WARN_CALL(WARN_ARGS_L(l, fmt, 1))
# define rb_warn1L(l,fmt,a)       WARN_CALL(WARN_ARGS_L(l, fmt, 2), (a))
# define rb_warn2L(l,fmt,a,b)     WARN_CALL(WARN_ARGS_L(l, fmt, 3), (a), (b))
# define rb_warn3L(l,fmt,a,b,c)   WARN_CALL(WARN_ARGS_L(l, fmt, 4), (a), (b), (c))
# define rb_warn4L(l,fmt,a,b,c,d) WARN_CALL(WARN_ARGS_L(l, fmt, 5), (a), (b), (c), (d))
# define rb_warning0L(l,fmt)         WARNING_CALL(WARNING_ARGS_L(l, fmt, 1))
# define rb_warning1L(l,fmt,a)       WARNING_CALL(WARNING_ARGS_L(l, fmt, 2), (a))
# define rb_warning2L(l,fmt,a,b)     WARNING_CALL(WARNING_ARGS_L(l, fmt, 3), (a), (b))
# define rb_warning3L(l,fmt,a,b,c)   WARNING_CALL(WARNING_ARGS_L(l, fmt, 4), (a), (b), (c))
# define rb_warning4L(l,fmt,a,b,c,d) WARNING_CALL(WARNING_ARGS_L(l, fmt, 5), (a), (b), (c), (d))
#ifdef RIPPER
extern const ID id_warn, id_warning, id_gets, id_assoc;
# define ERR_MESG() STR_NEW2(mesg) /* to bypass Ripper DSL */
# define WARN_S_L(s,l) STR_NEW(s,l)
# define WARN_S(s) STR_NEW2(s)
# define WARN_I(i) INT2NUM(i)
# define WARN_ID(i) rb_id2str(i)
# define PRIsWARN PRIsVALUE
# define WARN_ARGS(fmt,n) p->value, id_warn, n, rb_usascii_str_new_lit(fmt)
# define WARN_ARGS_L(l,fmt,n) WARN_ARGS(fmt,n)
# ifdef HAVE_VA_ARGS_MACRO
# define WARN_CALL(...) rb_funcall(__VA_ARGS__)
# else
# define WARN_CALL rb_funcall
# endif
# define WARNING_ARGS(fmt,n) p->value, id_warning, n, rb_usascii_str_new_lit(fmt)
# define WARNING_ARGS_L(l, fmt,n) WARNING_ARGS(fmt,n)
# ifdef HAVE_VA_ARGS_MACRO
# define WARNING_CALL(...) rb_funcall(__VA_ARGS__)
# else
# define WARNING_CALL rb_funcall
# endif
# define compile_error ripper_compile_error
#else
# define WARN_S_L(s,l) s
# define WARN_S(s) s
# define WARN_I(i) i
# define WARN_ID(i) rb_id2name(i)
# define PRIsWARN PRIsVALUE
# define WARN_ARGS(fmt,n) WARN_ARGS_L(p->ruby_sourceline,fmt,n)
# define WARN_ARGS_L(l,fmt,n) p->ruby_sourcefile, (l), (fmt)
# define WARN_CALL rb_compile_warn
# define WARNING_ARGS(fmt,n) WARN_ARGS(fmt,n)
# define WARNING_ARGS_L(l,fmt,n) WARN_ARGS_L(l,fmt,n)
# define WARNING_CALL rb_compile_warning
PRINTF_ARGS(static void parser_compile_error(struct parser_params*, const rb_code_location_t *loc, const char *fmt, ...), 3, 4);
# define compile_error(p, ...) parser_compile_error(p, NULL, __VA_ARGS__)
#endif

#define RNODE_EXITS(node) ((rb_node_exits_t*)(node))

static NODE *
add_block_exit(struct parser_params *p, NODE *node)
{
    if (!node) {
        compile_error(p, "unexpected null node");
        return 0;
    }
    switch (nd_type(node)) {
      case NODE_BREAK: case NODE_NEXT: case NODE_REDO: break;
      default:
        compile_error(p, "add_block_exit: unexpected node: %s", parser_node_name(nd_type(node)));
        return node;
    }
    if (!p->ctxt.in_defined) {
        rb_node_exits_t *exits = p->exits;
        if (exits) {
            RNODE_EXITS(exits->nd_stts)->nd_chain = node;
            exits->nd_stts = node;
        }
    }
    return node;
}

static rb_node_exits_t *
init_block_exit(struct parser_params *p)
{
    rb_node_exits_t *old = p->exits;
    rb_node_exits_t *exits = NODE_NEW_INTERNAL(NODE_EXITS, rb_node_exits_t);
    exits->nd_chain = 0;
    exits->nd_stts = RNODE(exits);
    p->exits = exits;
    return old;
}

static rb_node_exits_t *
allow_block_exit(struct parser_params *p)
{
    rb_node_exits_t *exits = p->exits;
    p->exits = 0;
    return exits;
}

static void
restore_block_exit(struct parser_params *p, rb_node_exits_t *exits)
{
    p->exits = exits;
}

static void
clear_block_exit(struct parser_params *p, bool error)
{
    rb_node_exits_t *exits = p->exits;
    if (!exits) return;
    if (error) {
        for (NODE *e = RNODE(exits); (e = RNODE_EXITS(e)->nd_chain) != 0; ) {
            switch (nd_type(e)) {
              case NODE_BREAK:
                yyerror1(&e->nd_loc, "Invalid break");
                break;
              case NODE_NEXT:
                yyerror1(&e->nd_loc, "Invalid next");
                break;
              case NODE_REDO:
                yyerror1(&e->nd_loc, "Invalid redo");
                break;
              default:
                yyerror1(&e->nd_loc, "unexpected node");
                goto end_checks; /* no nd_chain */
            }
        }
      end_checks:;
    }
    exits->nd_stts = RNODE(exits);
    exits->nd_chain = 0;
}

#define WARN_EOL(tok) \
    (looking_at_eol_p(p) ? \
     (void)rb_warning0("'" tok "' at the end of line without an expression") : \
     (void)0)
static int looking_at_eol_p(struct parser_params *p);

static NODE *
get_nd_value(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_GASGN:
        return RNODE_GASGN(node)->nd_value;
      case NODE_IASGN:
        return RNODE_IASGN(node)->nd_value;
      case NODE_LASGN:
        return RNODE_LASGN(node)->nd_value;
      case NODE_DASGN:
        return RNODE_DASGN(node)->nd_value;
      case NODE_MASGN:
        return RNODE_MASGN(node)->nd_value;
      case NODE_CVASGN:
        return RNODE_CVASGN(node)->nd_value;
      case NODE_CDECL:
        return RNODE_CDECL(node)->nd_value;
      default:
        compile_error(p, "get_nd_value: unexpected node: %s", parser_node_name(nd_type(node)));
        return 0;
    }
}

static void
set_nd_value(struct parser_params *p, NODE *node, NODE *rhs)
{
    switch (nd_type(node)) {
      case NODE_CDECL:
        RNODE_CDECL(node)->nd_value = rhs;
        break;
      case NODE_GASGN:
        RNODE_GASGN(node)->nd_value = rhs;
        break;
      case NODE_IASGN:
        RNODE_IASGN(node)->nd_value = rhs;
        break;
      case NODE_LASGN:
        RNODE_LASGN(node)->nd_value = rhs;
        break;
      case NODE_DASGN:
        RNODE_DASGN(node)->nd_value = rhs;
        break;
      case NODE_MASGN:
        RNODE_MASGN(node)->nd_value = rhs;
        break;
      case NODE_CVASGN:
        RNODE_CVASGN(node)->nd_value = rhs;
        break;
      default:
        compile_error(p, "set_nd_value: unexpected node: %s", parser_node_name(nd_type(node)));
        break;
    }
}

static ID
get_nd_vid(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_CDECL:
        return RNODE_CDECL(node)->nd_vid;
      case NODE_GASGN:
        return RNODE_GASGN(node)->nd_vid;
      case NODE_IASGN:
        return RNODE_IASGN(node)->nd_vid;
      case NODE_LASGN:
        return RNODE_LASGN(node)->nd_vid;
      case NODE_DASGN:
        return RNODE_DASGN(node)->nd_vid;
      case NODE_CVASGN:
        return RNODE_CVASGN(node)->nd_vid;
      default:
        compile_error(p, "get_nd_vid: unexpected node: %s", parser_node_name(nd_type(node)));
        return 0;
    }
}

static NODE *
get_nd_args(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_CALL:
        return RNODE_CALL(node)->nd_args;
      case NODE_OPCALL:
        return RNODE_OPCALL(node)->nd_args;
      case NODE_FCALL:
        return RNODE_FCALL(node)->nd_args;
      case NODE_QCALL:
        return RNODE_QCALL(node)->nd_args;
      case NODE_SUPER:
        return RNODE_SUPER(node)->nd_args;
      case NODE_VCALL:
      case NODE_ZSUPER:
      case NODE_YIELD:
      case NODE_RETURN:
      case NODE_BREAK:
      case NODE_NEXT:
        return 0;
      default:
        compile_error(p, "get_nd_args: unexpected node: %s", parser_node_name(nd_type(node)));
        return 0;
    }
}

static st_index_t
djb2(const uint8_t *str, size_t len)
{
    st_index_t hash = 5381;

    for (size_t i = 0; i < len; i++) {
        hash = ((hash << 5) + hash) + str[i];
    }

    return hash;
}

static st_index_t
parser_memhash(const void *ptr, long len)
{
    return djb2(ptr, len);
}

#define PARSER_STRING_PTR(str) (str->ptr)
#define PARSER_STRING_LEN(str) (str->len)
#define PARSER_STRING_END(str) (&str->ptr[str->len])
#define STRING_SIZE(str) ((size_t)str->len + 1)
#define STRING_TERM_LEN(str) (1)
#define STRING_TERM_FILL(str) (str->ptr[str->len] = '\0')
#define PARSER_STRING_RESIZE_CAPA_TERM(p,str,capacity,termlen) do {\
    SIZED_REALLOC_N(str->ptr, char, (size_t)total + termlen, STRING_SIZE(str)); \
    str->len = total; \
} while (0)
#define STRING_SET_LEN(str, n) do { \
    (str)->len = (n); \
} while (0)
#define PARSER_STRING_GETMEM(str, ptrvar, lenvar) \
    ((ptrvar) = str->ptr,                            \
     (lenvar) = str->len)

static inline int
parser_string_char_at_end(struct parser_params *p, rb_parser_string_t *str, int when_empty)
{
    return PARSER_STRING_LEN(str) > 0 ? (unsigned char)PARSER_STRING_END(str)[-1] : when_empty;
}

static rb_parser_string_t *
rb_parser_string_new(rb_parser_t *p, const char *ptr, long len)
{
    rb_parser_string_t *str;

    if (len < 0) {
        rb_bug("negative string size (or size too big): %ld", len);
    }

    str = xcalloc(1, sizeof(rb_parser_string_t));
    str->ptr = xcalloc(len + 1, sizeof(char));

    if (ptr) {
        memcpy(PARSER_STRING_PTR(str), ptr, len);
    }
    STRING_SET_LEN(str, len);
    STRING_TERM_FILL(str);
    return str;
}

static rb_parser_string_t *
rb_parser_encoding_string_new(rb_parser_t *p, const char *ptr, long len, rb_encoding *enc)
{
    rb_parser_string_t *str = rb_parser_string_new(p, ptr, len);
    str->coderange = RB_PARSER_ENC_CODERANGE_UNKNOWN;
    str->enc = enc;
    return str;
}

#ifndef RIPPER
rb_parser_string_t *
rb_str_to_parser_string(rb_parser_t *p, VALUE str)
{
    /* Type check */
    rb_parser_string_t *ret = rb_parser_encoding_string_new(p, RSTRING_PTR(str), RSTRING_LEN(str), rb_enc_get(str));
    RB_GC_GUARD(str);
    return ret;
}

void
rb_parser_string_free(rb_parser_t *p, rb_parser_string_t *str)
{
    if (!str) return;
    xfree(PARSER_STRING_PTR(str));
    xfree(str);
}
#endif

static st_index_t
rb_parser_str_hash(rb_parser_string_t *str)
{
    return parser_memhash((const void *)PARSER_STRING_PTR(str), PARSER_STRING_LEN(str));
}

static st_index_t
rb_char_p_hash(const char *c)
{
    return parser_memhash((const void *)c, strlen(c));
}

static size_t
rb_parser_str_capacity(rb_parser_string_t *str, const int termlen)
{
    return PARSER_STRING_LEN(str);
}

#ifndef RIPPER
static char *
rb_parser_string_end(rb_parser_string_t *str)
{
    return &str->ptr[str->len];
}
#endif

static void
rb_parser_string_set_encoding(rb_parser_string_t *str, rb_encoding *enc)
{
    str->enc = enc;
}

static rb_encoding *
rb_parser_str_get_encoding(rb_parser_string_t *str)
{
    return str->enc;
}

#ifndef RIPPER
static bool
PARSER_ENCODING_IS_ASCII8BIT(struct parser_params *p, rb_parser_string_t *str)
{
    return rb_parser_str_get_encoding(str) == rb_ascii8bit_encoding();
}
#endif

static int
PARSER_ENC_CODERANGE(rb_parser_string_t *str)
{
    return str->coderange;
}

static void
PARSER_ENC_CODERANGE_SET(rb_parser_string_t *str, int coderange)
{
    str->coderange = coderange;
}

static void
PARSER_ENCODING_CODERANGE_SET(rb_parser_string_t *str, rb_encoding *enc, enum rb_parser_string_coderange_type cr)
{
    rb_parser_string_set_encoding(str, enc);
    PARSER_ENC_CODERANGE_SET(str, cr);
}

static void
PARSER_ENC_CODERANGE_CLEAR(rb_parser_string_t *str)
{
    str->coderange = RB_PARSER_ENC_CODERANGE_UNKNOWN;
}

static bool
PARSER_ENC_CODERANGE_ASCIIONLY(rb_parser_string_t *str)
{
    return PARSER_ENC_CODERANGE(str) == RB_PARSER_ENC_CODERANGE_7BIT;
}

static bool
PARSER_ENC_CODERANGE_CLEAN_P(int cr)
{
    return cr == RB_PARSER_ENC_CODERANGE_7BIT || cr == RB_PARSER_ENC_CODERANGE_VALID;
}

static const char *
rb_parser_search_nonascii(const char *p, const char *e)
{
    const char *s = p;

    for (; s < e; s++) {
        if (*s & 0x80) return s;
    }

    return NULL;
}

static int
rb_parser_coderange_scan(struct parser_params *p, const char *ptr, long len, rb_encoding *enc)
{
    const char *e = ptr + len;

    if (enc == rb_ascii8bit_encoding()) {
        /* enc is ASCII-8BIT.  ASCII-8BIT string never be broken. */
        ptr = rb_parser_search_nonascii(ptr, e);
        return ptr ? RB_PARSER_ENC_CODERANGE_VALID : RB_PARSER_ENC_CODERANGE_7BIT;
    }

    /* parser string encoding is always asciicompat */
    ptr = rb_parser_search_nonascii(ptr, e);
    if (!ptr) return RB_PARSER_ENC_CODERANGE_7BIT;
    for (;;) {
        int ret = rb_enc_precise_mbclen(ptr, e, enc);
        if (!MBCLEN_CHARFOUND_P(ret)) return RB_PARSER_ENC_CODERANGE_BROKEN;
        ptr += MBCLEN_CHARFOUND_LEN(ret);
        if (ptr == e) break;
        ptr = rb_parser_search_nonascii(ptr, e);
        if (!ptr) break;
    }

    return RB_PARSER_ENC_CODERANGE_VALID;
}

static int
rb_parser_enc_coderange_scan(struct parser_params *p, rb_parser_string_t *str, rb_encoding *enc)
{
    return rb_parser_coderange_scan(p, PARSER_STRING_PTR(str), PARSER_STRING_LEN(str), enc);
}

static int
rb_parser_enc_str_coderange(struct parser_params *p, rb_parser_string_t *str)
{
    int cr = PARSER_ENC_CODERANGE(str);

    if (cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
        cr = rb_parser_enc_coderange_scan(p, str, rb_parser_str_get_encoding(str));
        PARSER_ENC_CODERANGE_SET(str, cr);
    }

    return cr;
}

static rb_parser_string_t *
rb_parser_enc_associate(struct parser_params *p, rb_parser_string_t *str, rb_encoding *enc)
{
    if (rb_parser_str_get_encoding(str) == enc)
        return str;
    if (!PARSER_ENC_CODERANGE_ASCIIONLY(str)) {
        PARSER_ENC_CODERANGE_CLEAR(str);
    }
    rb_parser_string_set_encoding(str, enc);
    return str;
}

static bool
rb_parser_is_ascii_string(struct parser_params *p, rb_parser_string_t *str)
{
    return rb_parser_enc_str_coderange(p, str) == RB_PARSER_ENC_CODERANGE_7BIT;
}

static rb_encoding *
rb_parser_enc_compatible(struct parser_params *p, rb_parser_string_t *str1, rb_parser_string_t *str2)
{
    rb_encoding *enc1 = rb_parser_str_get_encoding(str1);
    rb_encoding *enc2 = rb_parser_str_get_encoding(str2);

    if (enc1 == NULL || enc2 == NULL)
        return 0;

    if (enc1 == enc2) {
        return enc1;
    }

    if (PARSER_STRING_LEN(str2) == 0)
        return enc1;
    if (PARSER_STRING_LEN(str1) == 0)
        return rb_parser_is_ascii_string(p, str2) ? enc1 : enc2;

    int cr1, cr2;

    cr1 = rb_parser_enc_str_coderange(p, str1);
    cr2 = rb_parser_enc_str_coderange(p, str2);

    if (cr1 != cr2) {
        if (cr1 == RB_PARSER_ENC_CODERANGE_7BIT) return enc2;
        if (cr2 == RB_PARSER_ENC_CODERANGE_7BIT) return enc1;
    }

    if (cr2 == RB_PARSER_ENC_CODERANGE_7BIT) {
        return enc1;
    }

    if (cr1 == RB_PARSER_ENC_CODERANGE_7BIT) {
        return enc2;
    }

    return 0;
}

static void
rb_parser_str_modify(rb_parser_string_t *str)
{
    PARSER_ENC_CODERANGE_CLEAR(str);
}

static void
rb_parser_str_set_len(struct parser_params *p, rb_parser_string_t *str, long len)
{
    long capa;
    const int termlen = STRING_TERM_LEN(str);

    if (len > (capa = (long)(rb_parser_str_capacity(str, termlen))) || len < 0) {
        rb_bug("probable buffer overflow: %ld for %ld", len, capa);
    }

    int cr = PARSER_ENC_CODERANGE(str);
    if (cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
        /* Leave unknown. */
    }
    else if (len > PARSER_STRING_LEN(str)) {
        PARSER_ENC_CODERANGE_SET(str, RB_PARSER_ENC_CODERANGE_UNKNOWN);
    }
    else if (len < PARSER_STRING_LEN(str)) {
        if (cr != RB_PARSER_ENC_CODERANGE_7BIT) {
            /* ASCII-only string is keeping after truncated.  Valid
             * and broken may be invalid or valid, leave unknown. */
            PARSER_ENC_CODERANGE_SET(str, RB_PARSER_ENC_CODERANGE_UNKNOWN);
        }
    }

    STRING_SET_LEN(str, len);
    STRING_TERM_FILL(str);
}

static rb_parser_string_t *
rb_parser_str_buf_cat(struct parser_params *p, rb_parser_string_t *str, const char *ptr, long len)
{
    rb_parser_str_modify(str);
    if (len == 0) return 0;

    long total, olen, off = -1;
    char *sptr;
    const int termlen = STRING_TERM_LEN(str);

    PARSER_STRING_GETMEM(str, sptr, olen);
    if (ptr >= sptr && ptr <= sptr + olen) {
        off = ptr - sptr;
    }

    if (olen > LONG_MAX - len) {
        compile_error(p, "string sizes too big");
        return 0;
    }
    total = olen + len;
    PARSER_STRING_RESIZE_CAPA_TERM(p, str, total, termlen);
    sptr = PARSER_STRING_PTR(str);
    if (off != -1) {
        ptr = sptr + off;
    }
    memcpy(sptr + olen, ptr, len);
    STRING_SET_LEN(str, total);
    STRING_TERM_FILL(str);

    return str;
}

#define parser_str_cat(str, ptr, len) rb_parser_str_buf_cat(p, str, ptr, len)
#define parser_str_cat_cstr(str, lit) rb_parser_str_buf_cat(p, str, lit, strlen(lit))

static rb_parser_string_t *
rb_parser_enc_cr_str_buf_cat(struct parser_params *p, rb_parser_string_t *str, const char *ptr, long len,
    rb_encoding *ptr_enc, int ptr_cr, int *ptr_cr_ret)
{
    int str_cr, res_cr;
    rb_encoding *str_enc, *res_enc;

    str_enc = rb_parser_str_get_encoding(str);
    str_cr = PARSER_STRING_LEN(str) ? PARSER_ENC_CODERANGE(str) : RB_PARSER_ENC_CODERANGE_7BIT;

    if (str_enc == ptr_enc) {
        if (str_cr != RB_PARSER_ENC_CODERANGE_UNKNOWN && ptr_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
            ptr_cr = rb_parser_coderange_scan(p, ptr, len, ptr_enc);
        }
    }
    else {
        /* parser string encoding is always asciicompat */
        if (ptr_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
            ptr_cr = rb_parser_coderange_scan(p, ptr, len, ptr_enc);
        }
        if (str_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
            if (str_enc == rb_ascii8bit_encoding() || ptr_cr != RB_PARSER_ENC_CODERANGE_7BIT) {
                str_cr = rb_parser_enc_str_coderange(p, str);
            }
        }
    }
    if (ptr_cr_ret)
        *ptr_cr_ret = ptr_cr;

    if (str_enc != ptr_enc &&
        str_cr != RB_PARSER_ENC_CODERANGE_7BIT &&
        ptr_cr != RB_PARSER_ENC_CODERANGE_7BIT) {
        goto incompatible;
    }

    if (str_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
        res_enc = str_enc;
        res_cr = RB_PARSER_ENC_CODERANGE_UNKNOWN;
    }
    else if (str_cr == RB_PARSER_ENC_CODERANGE_7BIT) {
        if (ptr_cr == RB_PARSER_ENC_CODERANGE_7BIT) {
            res_enc = str_enc;
            res_cr = RB_PARSER_ENC_CODERANGE_7BIT;
        }
        else {
            res_enc = ptr_enc;
            res_cr = ptr_cr;
        }
    }
    else if (str_cr == RB_PARSER_ENC_CODERANGE_VALID) {
        res_enc = str_enc;
        if (PARSER_ENC_CODERANGE_CLEAN_P(ptr_cr))
            res_cr = str_cr;
        else
            res_cr = ptr_cr;
    }
    else { /* str_cr == RB_PARSER_ENC_CODERANGE_BROKEN */
        res_enc = str_enc;
        res_cr = str_cr;
        if (0 < len) res_cr = RB_PARSER_ENC_CODERANGE_UNKNOWN;
    }

    if (len < 0) {
        compile_error(p, "negative string size (or size too big)");
    }
    parser_str_cat(str, ptr, len);
    PARSER_ENCODING_CODERANGE_SET(str, res_enc, res_cr);
    return str;

  incompatible:
    compile_error(p, "incompatible character encodings: %s and %s",
                  rb_enc_name(str_enc), rb_enc_name(ptr_enc));
    UNREACHABLE_RETURN(0);

}

static rb_parser_string_t *
rb_parser_enc_str_buf_cat(struct parser_params *p, rb_parser_string_t *str, const char *ptr, long len,
    rb_encoding *ptr_enc)
{
    return rb_parser_enc_cr_str_buf_cat(p, str, ptr, len, ptr_enc, RB_PARSER_ENC_CODERANGE_UNKNOWN, NULL);
}

static rb_parser_string_t *
rb_parser_str_buf_append(struct parser_params *p, rb_parser_string_t *str, rb_parser_string_t *str2)
{
    int str2_cr = rb_parser_enc_str_coderange(p, str2);

    rb_parser_enc_cr_str_buf_cat(p, str, PARSER_STRING_PTR(str2), PARSER_STRING_LEN(str2),
        rb_parser_str_get_encoding(str2), str2_cr, &str2_cr);

    PARSER_ENC_CODERANGE_SET(str2, str2_cr);

    return str;
}

static rb_parser_string_t *
rb_parser_str_resize(struct parser_params *p, rb_parser_string_t *str, long len)
{
    if (len < 0) {
        rb_bug("negative string size (or size too big)");
    }

    long slen = PARSER_STRING_LEN(str);

    if (slen > len && PARSER_ENC_CODERANGE(str) != RB_PARSER_ENC_CODERANGE_7BIT) {
        PARSER_ENC_CODERANGE_CLEAR(str);
    }

    {
        long capa;
        const int termlen = STRING_TERM_LEN(str);

        if ((capa = slen) < len) {
            SIZED_REALLOC_N(str->ptr, char, (size_t)len + termlen, STRING_SIZE(str));
        }
        else if (len == slen) return str;
        STRING_SET_LEN(str, len);
        STRING_TERM_FILL(str);
    }
    return str;
}

# define PARSER_ENC_STRING_GETMEM(str, ptrvar, lenvar, encvar) \
    ((ptrvar) = str->ptr,                            \
     (lenvar) = str->len,                            \
     (encvar) = str->enc)

static int
rb_parser_string_hash_cmp(rb_parser_string_t *str1, rb_parser_string_t *str2)
{
    long len1, len2;
    const char *ptr1, *ptr2;
    rb_encoding *enc1, *enc2;

    PARSER_ENC_STRING_GETMEM(str1, ptr1, len1, enc1);
    PARSER_ENC_STRING_GETMEM(str2, ptr2, len2, enc2);

    return (len1 != len2 ||
            enc1 != enc2 ||
            memcmp(ptr1, ptr2, len1) != 0);
}

static void
rb_parser_ary_extend(rb_parser_t *p, rb_parser_ary_t *ary, long len)
{
    long i;
    if (ary->capa < len) {
        ary->capa = len;
        ary->data = (rb_parser_ary_data *)xrealloc(ary->data, sizeof(rb_parser_ary_data) * len);
        for (i = ary->len; i < len; i++) {
            ary->data[i] = 0;
        }
    }
}

/*
 * Do not call this directly.
 * Use rb_parser_ary_new_capa_for_XXX() instead.
 */
static rb_parser_ary_t *
parser_ary_new_capa(rb_parser_t *p, long len)
{
    if (len < 0) {
        rb_bug("negative array size (or size too big): %ld", len);
    }
    rb_parser_ary_t *ary = xcalloc(1, sizeof(rb_parser_ary_t));
    ary->data_type = 0;
    ary->len = 0;
    ary->capa = len;
    if (0 < len) {
        ary->data = (rb_parser_ary_data *)xcalloc(len, sizeof(rb_parser_ary_data));
    }
    else {
        ary->data = NULL;
    }
    return ary;
}

#ifndef RIPPER
static rb_parser_ary_t *
rb_parser_ary_new_capa_for_script_line(rb_parser_t *p, long len)
{
    rb_parser_ary_t *ary = parser_ary_new_capa(p, len);
    ary->data_type = PARSER_ARY_DATA_SCRIPT_LINE;
    return ary;
}

static rb_parser_ary_t *
rb_parser_ary_new_capa_for_ast_token(rb_parser_t *p, long len)
{
    rb_parser_ary_t *ary = parser_ary_new_capa(p, len);
    ary->data_type = PARSER_ARY_DATA_AST_TOKEN;
    return ary;
}
#endif

static rb_parser_ary_t *
rb_parser_ary_new_capa_for_node(rb_parser_t *p, long len)
{
    rb_parser_ary_t *ary = parser_ary_new_capa(p, len);
    ary->data_type = PARSER_ARY_DATA_NODE;
    return ary;
}

/*
 * Do not call this directly.
 * Use rb_parser_ary_push_XXX() instead.
 */
static rb_parser_ary_t *
parser_ary_push(rb_parser_t *p, rb_parser_ary_t *ary, rb_parser_ary_data val)
{
    if (ary->len == ary->capa) {
        rb_parser_ary_extend(p, ary, ary->len == 0 ? 1 : ary->len * 2);
    }
    ary->data[ary->len++] = val;
    return ary;
}

#ifndef RIPPER
static rb_parser_ary_t *
rb_parser_ary_push_ast_token(rb_parser_t *p, rb_parser_ary_t *ary, rb_parser_ast_token_t *val)
{
    if (ary->data_type != PARSER_ARY_DATA_AST_TOKEN) {
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
    }
    return parser_ary_push(p, ary, val);
}

static rb_parser_ary_t *
rb_parser_ary_push_script_line(rb_parser_t *p, rb_parser_ary_t *ary, rb_parser_string_t *val)
{
    if (ary->data_type != PARSER_ARY_DATA_SCRIPT_LINE) {
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
    }
    return parser_ary_push(p, ary, val);
}
#endif

static rb_parser_ary_t *
rb_parser_ary_push_node(rb_parser_t *p, rb_parser_ary_t *ary, NODE *val)
{
    if (ary->data_type != PARSER_ARY_DATA_NODE) {
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
    }
    return parser_ary_push(p, ary, val);
}

#ifndef RIPPER
static void
rb_parser_ast_token_free(rb_parser_t *p, rb_parser_ast_token_t *token)
{
    if (!token) return;
    rb_parser_string_free(p, token->str);
    xfree(token);
}

static void
rb_parser_ary_free(rb_parser_t *p, rb_parser_ary_t *ary)
{
# define foreach_ary(ptr) \
    for (rb_parser_ary_data *ptr = ary->data, *const end_ary_data = ptr + ary->len; \
         ptr < end_ary_data; ptr++)
    switch (ary->data_type) {
      case PARSER_ARY_DATA_AST_TOKEN:
        foreach_ary(data) {rb_parser_ast_token_free(p, *data);}
        break;
      case PARSER_ARY_DATA_SCRIPT_LINE:
        foreach_ary(data) {rb_parser_string_free(p, *data);}
        break;
      case PARSER_ARY_DATA_NODE:
        /* Do nothing because nodes are freed when rb_ast_t is freed */
        break;
      default:
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
        break;
    }
# undef foreach_ary
    xfree(ary->data);
    xfree(ary);
}

#endif /* !RIPPER */

#line 2666 "parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parse.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end-of-input"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_keyword_class = 3,              /* "'class'"  */
  YYSYMBOL_keyword_module = 4,             /* "'module'"  */
  YYSYMBOL_keyword_def = 5,                /* "'def'"  */
  YYSYMBOL_keyword_undef = 6,              /* "'undef'"  */
  YYSYMBOL_keyword_begin = 7,              /* "'begin'"  */
  YYSYMBOL_keyword_rescue = 8,             /* "'rescue'"  */
  YYSYMBOL_keyword_ensure = 9,             /* "'ensure'"  */
  YYSYMBOL_keyword_end = 10,               /* "'end'"  */
  YYSYMBOL_keyword_if = 11,                /* "'if'"  */
  YYSYMBOL_keyword_unless = 12,            /* "'unless'"  */
  YYSYMBOL_keyword_then = 13,              /* "'then'"  */
  YYSYMBOL_keyword_elsif = 14,             /* "'elsif'"  */
  YYSYMBOL_keyword_else = 15,              /* "'else'"  */
  YYSYMBOL_keyword_case = 16,              /* "'case'"  */
  YYSYMBOL_keyword_when = 17,              /* "'when'"  */
  YYSYMBOL_keyword_while = 18,             /* "'while'"  */
  YYSYMBOL_keyword_until = 19,             /* "'until'"  */
  YYSYMBOL_keyword_for = 20,               /* "'for'"  */
  YYSYMBOL_keyword_break = 21,             /* "'break'"  */
  YYSYMBOL_keyword_next = 22,              /* "'next'"  */
  YYSYMBOL_keyword_redo = 23,              /* "'redo'"  */
  YYSYMBOL_keyword_retry = 24,             /* "'retry'"  */
  YYSYMBOL_keyword_in = 25,                /* "'in'"  */
  YYSYMBOL_keyword_do = 26,                /* "'do'"  */
  YYSYMBOL_keyword_do_cond = 27,           /* "'do' for condition"  */
  YYSYMBOL_keyword_do_block = 28,          /* "'do' for block"  */
  YYSYMBOL_keyword_do_LAMBDA = 29,         /* "'do' for lambda"  */
  YYSYMBOL_keyword_return = 30,            /* "'return'"  */
  YYSYMBOL_keyword_yield = 31,             /* "'yield'"  */
  YYSYMBOL_keyword_super = 32,             /* "'super'"  */
  YYSYMBOL_keyword_self = 33,              /* "'self'"  */
  YYSYMBOL_keyword_nil = 34,               /* "'nil'"  */
  YYSYMBOL_keyword_true = 35,              /* "'true'"  */
  YYSYMBOL_keyword_false = 36,             /* "'false'"  */
  YYSYMBOL_keyword_and = 37,               /* "'and'"  */
  YYSYMBOL_keyword_or = 38,                /* "'or'"  */
  YYSYMBOL_keyword_not = 39,               /* "'not'"  */
  YYSYMBOL_modifier_if = 40,               /* "'if' modifier"  */
  YYSYMBOL_modifier_unless = 41,           /* "'unless' modifier"  */
  YYSYMBOL_modifier_while = 42,            /* "'while' modifier"  */
  YYSYMBOL_modifier_until = 43,            /* "'until' modifier"  */
  YYSYMBOL_modifier_rescue = 44,           /* "'rescue' modifier"  */
  YYSYMBOL_keyword_alias = 45,             /* "'alias'"  */
  YYSYMBOL_keyword_defined = 46,           /* "'defined?'"  */
  YYSYMBOL_keyword_BEGIN = 47,             /* "'BEGIN'"  */
  YYSYMBOL_keyword_END = 48,               /* "'END'"  */
  YYSYMBOL_keyword__LINE__ = 49,           /* "'__LINE__'"  */
  YYSYMBOL_keyword__FILE__ = 50,           /* "'__FILE__'"  */
  YYSYMBOL_keyword__ENCODING__ = 51,       /* "'__ENCODING__'"  */
  YYSYMBOL_tIDENTIFIER = 52,               /* "local variable or method"  */
  YYSYMBOL_tFID = 53,                      /* "method"  */
  YYSYMBOL_tGVAR = 54,                     /* "global variable"  */
  YYSYMBOL_tIVAR = 55,                     /* "instance variable"  */
  YYSYMBOL_tCONSTANT = 56,                 /* "constant"  */
  YYSYMBOL_tCVAR = 57,                     /* "class variable"  */
  YYSYMBOL_tLABEL = 58,                    /* "label"  */
  YYSYMBOL_tINTEGER = 59,                  /* "integer literal"  */
  YYSYMBOL_tFLOAT = 60,                    /* "float literal"  */
  YYSYMBOL_tRATIONAL = 61,                 /* "rational literal"  */
  YYSYMBOL_tIMAGINARY = 62,                /* "imaginary literal"  */
  YYSYMBOL_tCHAR = 63,                     /* "char literal"  */
  YYSYMBOL_tNTH_REF = 64,                  /* "numbered reference"  */
  YYSYMBOL_tBACK_REF = 65,                 /* "back reference"  */
  YYSYMBOL_tSTRING_CONTENT = 66,           /* "literal content"  */
  YYSYMBOL_tREGEXP_END = 67,               /* tREGEXP_END  */
  YYSYMBOL_tDUMNY_END = 68,                /* "dummy end"  */
  YYSYMBOL_69_ = 69,                       /* '.'  */
  YYSYMBOL_70_backslash_ = 70,             /* "backslash"  */
  YYSYMBOL_tSP = 71,                       /* "escaped space"  */
  YYSYMBOL_72_escaped_horizontal_tab_ = 72, /* "escaped horizontal tab"  */
  YYSYMBOL_73_escaped_form_feed_ = 73,     /* "escaped form feed"  */
  YYSYMBOL_74_escaped_carriage_return_ = 74, /* "escaped carriage return"  */
  YYSYMBOL_75_escaped_vertical_tab_ = 75,  /* "escaped vertical tab"  */
  YYSYMBOL_tUPLUS = 76,                    /* "unary+"  */
  YYSYMBOL_tUMINUS = 77,                   /* "unary-"  */
  YYSYMBOL_tPOW = 78,                      /* "**"  */
  YYSYMBOL_tCMP = 79,                      /* "<=>"  */
  YYSYMBOL_tEQ = 80,                       /* "=="  */
  YYSYMBOL_tEQQ = 81,                      /* "==="  */
  YYSYMBOL_tNEQ = 82,                      /* "!="  */
  YYSYMBOL_tGEQ = 83,                      /* ">="  */
  YYSYMBOL_tLEQ = 84,                      /* "<="  */
  YYSYMBOL_tANDOP = 85,                    /* "&&"  */
  YYSYMBOL_tOROP = 86,                     /* "||"  */
  YYSYMBOL_tMATCH = 87,                    /* "=~"  */
  YYSYMBOL_tNMATCH = 88,                   /* "!~"  */
  YYSYMBOL_tDOT2 = 89,                     /* ".."  */
  YYSYMBOL_tDOT3 = 90,                     /* "..."  */
  YYSYMBOL_tBDOT2 = 91,                    /* "(.."  */
  YYSYMBOL_tBDOT3 = 92,                    /* "(..."  */
  YYSYMBOL_tAREF = 93,                     /* "[]"  */
  YYSYMBOL_tASET = 94,                     /* "[]="  */
  YYSYMBOL_tLSHFT = 95,                    /* "<<"  */
  YYSYMBOL_tRSHFT = 96,                    /* ">>"  */
  YYSYMBOL_tANDDOT = 97,                   /* "&."  */
  YYSYMBOL_tCOLON2 = 98,                   /* "::"  */
  YYSYMBOL_tCOLON3 = 99,                   /* ":: at EXPR_BEG"  */
  YYSYMBOL_tOP_ASGN = 100,                 /* "operator-assignment"  */
  YYSYMBOL_tASSOC = 101,                   /* "=>"  */
  YYSYMBOL_tLPAREN = 102,                  /* "("  */
  YYSYMBOL_tLPAREN_ARG = 103,              /* "( arg"  */
  YYSYMBOL_tRPAREN = 104,                  /* ")"  */
  YYSYMBOL_tLBRACK = 105,                  /* "["  */
  YYSYMBOL_tLBRACE = 106,                  /* "{"  */
  YYSYMBOL_tLBRACE_ARG = 107,              /* "{ arg"  */
  YYSYMBOL_tSTAR = 108,                    /* "*"  */
  YYSYMBOL_tDSTAR = 109,                   /* "**arg"  */
  YYSYMBOL_tAMPER = 110,                   /* "&"  */
  YYSYMBOL_tLAMBDA = 111,                  /* "->"  */
  YYSYMBOL_tSYMBEG = 112,                  /* "symbol literal"  */
  YYSYMBOL_tSTRING_BEG = 113,              /* "string literal"  */
  YYSYMBOL_tXSTRING_BEG = 114,             /* "backtick literal"  */
  YYSYMBOL_tREGEXP_BEG = 115,              /* "regexp literal"  */
  YYSYMBOL_tWORDS_BEG = 116,               /* "word list"  */
  YYSYMBOL_tQWORDS_BEG = 117,              /* "verbatim word list"  */
  YYSYMBOL_tSYMBOLS_BEG = 118,             /* "symbol list"  */
  YYSYMBOL_tQSYMBOLS_BEG = 119,            /* "verbatim symbol list"  */
  YYSYMBOL_tSTRING_END = 120,              /* "terminator"  */
  YYSYMBOL_tSTRING_DEND = 121,             /* "'}'"  */
  YYSYMBOL_tSTRING_DBEG = 122,             /* "'#{'"  */
  YYSYMBOL_tSTRING_DVAR = 123,             /* tSTRING_DVAR  */
  YYSYMBOL_tLAMBEG = 124,                  /* tLAMBEG  */
  YYSYMBOL_tLABEL_END = 125,               /* tLABEL_END  */
  YYSYMBOL_tIGNORED_NL = 126,              /* tIGNORED_NL  */
  YYSYMBOL_tCOMMENT = 127,                 /* tCOMMENT  */
  YYSYMBOL_tEMBDOC_BEG = 128,              /* tEMBDOC_BEG  */
  YYSYMBOL_tEMBDOC = 129,                  /* tEMBDOC  */
  YYSYMBOL_tEMBDOC_END = 130,              /* tEMBDOC_END  */
  YYSYMBOL_tHEREDOC_BEG = 131,             /* tHEREDOC_BEG  */
  YYSYMBOL_tHEREDOC_END = 132,             /* tHEREDOC_END  */
  YYSYMBOL_k__END__ = 133,                 /* k__END__  */
  YYSYMBOL_tLOWEST = 134,                  /* tLOWEST  */
  YYSYMBOL_135_ = 135,                     /* '='  */
  YYSYMBOL_136_ = 136,                     /* '?'  */
  YYSYMBOL_137_ = 137,                     /* ':'  */
  YYSYMBOL_138_ = 138,                     /* '>'  */
  YYSYMBOL_139_ = 139,                     /* '<'  */
  YYSYMBOL_140_ = 140,                     /* '|'  */
  YYSYMBOL_141_ = 141,                     /* '^'  */
  YYSYMBOL_142_ = 142,                     /* '&'  */
  YYSYMBOL_143_ = 143,                     /* '+'  */
  YYSYMBOL_144_ = 144,                     /* '-'  */
  YYSYMBOL_145_ = 145,                     /* '*'  */
  YYSYMBOL_146_ = 146,                     /* '/'  */
  YYSYMBOL_147_ = 147,                     /* '%'  */
  YYSYMBOL_tUMINUS_NUM = 148,              /* tUMINUS_NUM  */
  YYSYMBOL_149_ = 149,                     /* '!'  */
  YYSYMBOL_150_ = 150,                     /* '~'  */
  YYSYMBOL_tLAST_TOKEN = 151,              /* tLAST_TOKEN  */
  YYSYMBOL_152_ = 152,                     /* '{'  */
  YYSYMBOL_153_ = 153,                     /* '}'  */
  YYSYMBOL_154_ = 154,                     /* '['  */
  YYSYMBOL_155_n_ = 155,                   /* '\n'  */
  YYSYMBOL_156_ = 156,                     /* ','  */
  YYSYMBOL_157_ = 157,                     /* '`'  */
  YYSYMBOL_158_ = 158,                     /* '('  */
  YYSYMBOL_159_ = 159,                     /* ')'  */
  YYSYMBOL_160_ = 160,                     /* ']'  */
  YYSYMBOL_161_ = 161,                     /* ';'  */
  YYSYMBOL_162_ = 162,                     /* ' '  */
  YYSYMBOL_YYACCEPT = 163,                 /* $accept  */
  YYSYMBOL_164_1 = 164,                    /* $@1  */
  YYSYMBOL_program = 165,                  /* program  */
  YYSYMBOL_option_terms = 166,             /* option_terms  */
  YYSYMBOL_top_compstmt = 167,             /* top_compstmt  */
  YYSYMBOL_top_stmts = 168,                /* top_stmts  */
  YYSYMBOL_top_stmt = 169,                 /* top_stmt  */
  YYSYMBOL_block_open = 170,               /* block_open  */
  YYSYMBOL_begin_block = 171,              /* begin_block  */
  YYSYMBOL_172_2 = 172,                    /* $@2  */
  YYSYMBOL_173_3 = 173,                    /* $@3  */
  YYSYMBOL_bodystmt = 174,                 /* bodystmt  */
  YYSYMBOL_175_4 = 175,                    /* $@4  */
  YYSYMBOL_compstmt = 176,                 /* compstmt  */
  YYSYMBOL_stmts = 177,                    /* stmts  */
  YYSYMBOL_stmt_or_begin = 178,            /* stmt_or_begin  */
  YYSYMBOL_179_5 = 179,                    /* $@5  */
  YYSYMBOL_allow_exits = 180,              /* allow_exits  */
  YYSYMBOL_k_END = 181,                    /* k_END  */
  YYSYMBOL_182_6 = 182,                    /* $@6  */
  YYSYMBOL_stmt = 183,                     /* stmt  */
  YYSYMBOL_command_asgn = 184,             /* command_asgn  */
  YYSYMBOL_endless_command = 185,          /* endless_command  */
  YYSYMBOL_option__n_ = 186,               /* option_'\n'  */
  YYSYMBOL_command_rhs = 187,              /* command_rhs  */
  YYSYMBOL_expr = 188,                     /* expr  */
  YYSYMBOL_189_7 = 189,                    /* $@7  */
  YYSYMBOL_190_8 = 190,                    /* $@8  */
  YYSYMBOL_def_name = 191,                 /* def_name  */
  YYSYMBOL_defn_head = 192,                /* defn_head  */
  YYSYMBOL_193_9 = 193,                    /* $@9  */
  YYSYMBOL_defs_head = 194,                /* defs_head  */
  YYSYMBOL_expr_value = 195,               /* expr_value  */
  YYSYMBOL_196_10 = 196,                   /* $@10  */
  YYSYMBOL_197_11 = 197,                   /* $@11  */
  YYSYMBOL_expr_value_do = 198,            /* expr_value_do  */
  YYSYMBOL_command_call = 199,             /* command_call  */
  YYSYMBOL_block_command = 200,            /* block_command  */
  YYSYMBOL_cmd_brace_block = 201,          /* cmd_brace_block  */
  YYSYMBOL_fcall = 202,                    /* fcall  */
  YYSYMBOL_command = 203,                  /* command  */
  YYSYMBOL_mlhs = 204,                     /* mlhs  */
  YYSYMBOL_mlhs_inner = 205,               /* mlhs_inner  */
  YYSYMBOL_mlhs_basic = 206,               /* mlhs_basic  */
  YYSYMBOL_mlhs_item = 207,                /* mlhs_item  */
  YYSYMBOL_mlhs_head = 208,                /* mlhs_head  */
  YYSYMBOL_mlhs_post = 209,                /* mlhs_post  */
  YYSYMBOL_mlhs_node = 210,                /* mlhs_node  */
  YYSYMBOL_lhs = 211,                      /* lhs  */
  YYSYMBOL_cname = 212,                    /* cname  */
  YYSYMBOL_cpath = 213,                    /* cpath  */
  YYSYMBOL_fname = 214,                    /* fname  */
  YYSYMBOL_fitem = 215,                    /* fitem  */
  YYSYMBOL_undef_list = 216,               /* undef_list  */
  YYSYMBOL_217_12 = 217,                   /* $@12  */
  YYSYMBOL_op = 218,                       /* op  */
  YYSYMBOL_reswords = 219,                 /* reswords  */
  YYSYMBOL_arg = 220,                      /* arg  */
  YYSYMBOL_endless_arg = 221,              /* endless_arg  */
  YYSYMBOL_relop = 222,                    /* relop  */
  YYSYMBOL_rel_expr = 223,                 /* rel_expr  */
  YYSYMBOL_lex_ctxt = 224,                 /* lex_ctxt  */
  YYSYMBOL_begin_defined = 225,            /* begin_defined  */
  YYSYMBOL_after_rescue = 226,             /* after_rescue  */
  YYSYMBOL_arg_value = 227,                /* arg_value  */
  YYSYMBOL_aref_args = 228,                /* aref_args  */
  YYSYMBOL_arg_rhs = 229,                  /* arg_rhs  */
  YYSYMBOL_paren_args = 230,               /* paren_args  */
  YYSYMBOL_opt_paren_args = 231,           /* opt_paren_args  */
  YYSYMBOL_opt_call_args = 232,            /* opt_call_args  */
  YYSYMBOL_call_args = 233,                /* call_args  */
  YYSYMBOL_234_13 = 234,                   /* $@13  */
  YYSYMBOL_command_args = 235,             /* command_args  */
  YYSYMBOL_block_arg = 236,                /* block_arg  */
  YYSYMBOL_opt_block_arg = 237,            /* opt_block_arg  */
  YYSYMBOL_args = 238,                     /* args  */
  YYSYMBOL_arg_splat = 239,                /* arg_splat  */
  YYSYMBOL_mrhs_arg = 240,                 /* mrhs_arg  */
  YYSYMBOL_mrhs = 241,                     /* mrhs  */
  YYSYMBOL_primary = 242,                  /* primary  */
  YYSYMBOL_243_14 = 243,                   /* $@14  */
  YYSYMBOL_244_15 = 244,                   /* $@15  */
  YYSYMBOL_245_16 = 245,                   /* @16  */
  YYSYMBOL_246_17 = 246,                   /* @17  */
  YYSYMBOL_247_18 = 247,                   /* $@18  */
  YYSYMBOL_248_19 = 248,                   /* $@19  */
  YYSYMBOL_249_20 = 249,                   /* $@20  */
  YYSYMBOL_250_21 = 250,                   /* $@21  */
  YYSYMBOL_251_22 = 251,                   /* $@22  */
  YYSYMBOL_primary_value = 252,            /* primary_value  */
  YYSYMBOL_k_begin = 253,                  /* k_begin  */
  YYSYMBOL_k_if = 254,                     /* k_if  */
  YYSYMBOL_k_unless = 255,                 /* k_unless  */
  YYSYMBOL_k_while = 256,                  /* k_while  */
  YYSYMBOL_k_until = 257,                  /* k_until  */
  YYSYMBOL_k_case = 258,                   /* k_case  */
  YYSYMBOL_k_for = 259,                    /* k_for  */
  YYSYMBOL_k_class = 260,                  /* k_class  */
  YYSYMBOL_k_module = 261,                 /* k_module  */
  YYSYMBOL_k_def = 262,                    /* k_def  */
  YYSYMBOL_k_do = 263,                     /* k_do  */
  YYSYMBOL_k_do_block = 264,               /* k_do_block  */
  YYSYMBOL_k_rescue = 265,                 /* k_rescue  */
  YYSYMBOL_k_ensure = 266,                 /* k_ensure  */
  YYSYMBOL_k_when = 267,                   /* k_when  */
  YYSYMBOL_k_else = 268,                   /* k_else  */
  YYSYMBOL_k_elsif = 269,                  /* k_elsif  */
  YYSYMBOL_k_end = 270,                    /* k_end  */
  YYSYMBOL_k_return = 271,                 /* k_return  */
  YYSYMBOL_k_yield = 272,                  /* k_yield  */
  YYSYMBOL_then = 273,                     /* then  */
  YYSYMBOL_do = 274,                       /* do  */
  YYSYMBOL_if_tail = 275,                  /* if_tail  */
  YYSYMBOL_opt_else = 276,                 /* opt_else  */
  YYSYMBOL_for_var = 277,                  /* for_var  */
  YYSYMBOL_f_marg = 278,                   /* f_marg  */
  YYSYMBOL_f_marg_list = 279,              /* f_marg_list  */
  YYSYMBOL_f_margs = 280,                  /* f_margs  */
  YYSYMBOL_f_rest_marg = 281,              /* f_rest_marg  */
  YYSYMBOL_f_any_kwrest = 282,             /* f_any_kwrest  */
  YYSYMBOL_283_23 = 283,                   /* $@23  */
  YYSYMBOL_f_eq = 284,                     /* f_eq  */
  YYSYMBOL_f_kwarg_f_block_kw = 285,       /* f_kwarg_f_block_kw  */
  YYSYMBOL_block_args_tail = 286,          /* block_args_tail  */
  YYSYMBOL_excessed_comma = 287,           /* excessed_comma  */
  YYSYMBOL_f_opt_primary_value = 288,      /* f_opt_primary_value  */
  YYSYMBOL_f_optarg_primary_value = 289,   /* f_optarg_primary_value  */
  YYSYMBOL_opt_args_tail_block_args_tail = 290, /* opt_args_tail_block_args_tail  */
  YYSYMBOL_block_param = 291,              /* block_param  */
  YYSYMBOL_opt_block_param = 292,          /* opt_block_param  */
  YYSYMBOL_block_param_def = 293,          /* block_param_def  */
  YYSYMBOL_opt_bv_decl = 294,              /* opt_bv_decl  */
  YYSYMBOL_bv_decls = 295,                 /* bv_decls  */
  YYSYMBOL_bvar = 296,                     /* bvar  */
  YYSYMBOL_max_numparam = 297,             /* max_numparam  */
  YYSYMBOL_numparam = 298,                 /* numparam  */
  YYSYMBOL_it_id = 299,                    /* it_id  */
  YYSYMBOL_300_24 = 300,                   /* @24  */
  YYSYMBOL_301_25 = 301,                   /* $@25  */
  YYSYMBOL_lambda = 302,                   /* lambda  */
  YYSYMBOL_f_larglist = 303,               /* f_larglist  */
  YYSYMBOL_lambda_body = 304,              /* lambda_body  */
  YYSYMBOL_305_26 = 305,                   /* $@26  */
  YYSYMBOL_do_block = 306,                 /* do_block  */
  YYSYMBOL_block_call = 307,               /* block_call  */
  YYSYMBOL_method_call = 308,              /* method_call  */
  YYSYMBOL_brace_block = 309,              /* brace_block  */
  YYSYMBOL_310_27 = 310,                   /* @27  */
  YYSYMBOL_brace_body = 311,               /* brace_body  */
  YYSYMBOL_312_28 = 312,                   /* @28  */
  YYSYMBOL_do_body = 313,                  /* do_body  */
  YYSYMBOL_case_args = 314,                /* case_args  */
  YYSYMBOL_case_body = 315,                /* case_body  */
  YYSYMBOL_cases = 316,                    /* cases  */
  YYSYMBOL_p_pvtbl = 317,                  /* p_pvtbl  */
  YYSYMBOL_p_pktbl = 318,                  /* p_pktbl  */
  YYSYMBOL_p_in_kwarg = 319,               /* p_in_kwarg  */
  YYSYMBOL_320_29 = 320,                   /* $@29  */
  YYSYMBOL_p_case_body = 321,              /* p_case_body  */
  YYSYMBOL_p_cases = 322,                  /* p_cases  */
  YYSYMBOL_p_top_expr = 323,               /* p_top_expr  */
  YYSYMBOL_p_top_expr_body = 324,          /* p_top_expr_body  */
  YYSYMBOL_p_expr = 325,                   /* p_expr  */
  YYSYMBOL_p_as = 326,                     /* p_as  */
  YYSYMBOL_p_alt = 327,                    /* p_alt  */
  YYSYMBOL_p_lparen = 328,                 /* p_lparen  */
  YYSYMBOL_p_lbracket = 329,               /* p_lbracket  */
  YYSYMBOL_p_expr_basic = 330,             /* p_expr_basic  */
  YYSYMBOL_331_30 = 331,                   /* $@30  */
  YYSYMBOL_p_args = 332,                   /* p_args  */
  YYSYMBOL_p_args_head = 333,              /* p_args_head  */
  YYSYMBOL_p_args_tail = 334,              /* p_args_tail  */
  YYSYMBOL_p_find = 335,                   /* p_find  */
  YYSYMBOL_p_rest = 336,                   /* p_rest  */
  YYSYMBOL_p_args_post = 337,              /* p_args_post  */
  YYSYMBOL_p_arg = 338,                    /* p_arg  */
  YYSYMBOL_p_kwargs = 339,                 /* p_kwargs  */
  YYSYMBOL_p_kwarg = 340,                  /* p_kwarg  */
  YYSYMBOL_p_kw = 341,                     /* p_kw  */
  YYSYMBOL_p_kw_label = 342,               /* p_kw_label  */
  YYSYMBOL_p_kwrest = 343,                 /* p_kwrest  */
  YYSYMBOL_p_kwnorest = 344,               /* p_kwnorest  */
  YYSYMBOL_p_any_kwrest = 345,             /* p_any_kwrest  */
  YYSYMBOL_p_value = 346,                  /* p_value  */
  YYSYMBOL_p_primitive = 347,              /* p_primitive  */
  YYSYMBOL_p_variable = 348,               /* p_variable  */
  YYSYMBOL_p_var_ref = 349,                /* p_var_ref  */
  YYSYMBOL_p_expr_ref = 350,               /* p_expr_ref  */
  YYSYMBOL_p_const = 351,                  /* p_const  */
  YYSYMBOL_opt_rescue = 352,               /* opt_rescue  */
  YYSYMBOL_exc_list = 353,                 /* exc_list  */
  YYSYMBOL_exc_var = 354,                  /* exc_var  */
  YYSYMBOL_opt_ensure = 355,               /* opt_ensure  */
  YYSYMBOL_literal = 356,                  /* literal  */
  YYSYMBOL_strings = 357,                  /* strings  */
  YYSYMBOL_string = 358,                   /* string  */
  YYSYMBOL_string1 = 359,                  /* string1  */
  YYSYMBOL_xstring = 360,                  /* xstring  */
  YYSYMBOL_regexp = 361,                   /* regexp  */
  YYSYMBOL_nonempty_list__ = 362,          /* nonempty_list_' '  */
  YYSYMBOL_words_tWORDS_BEG_word_list = 363, /* words_tWORDS_BEG_word_list  */
  YYSYMBOL_words = 364,                    /* words  */
  YYSYMBOL_word_list = 365,                /* word_list  */
  YYSYMBOL_word = 366,                     /* word  */
  YYSYMBOL_words_tSYMBOLS_BEG_symbol_list = 367, /* words_tSYMBOLS_BEG_symbol_list  */
  YYSYMBOL_symbols = 368,                  /* symbols  */
  YYSYMBOL_symbol_list = 369,              /* symbol_list  */
  YYSYMBOL_words_tQWORDS_BEG_qword_list = 370, /* words_tQWORDS_BEG_qword_list  */
  YYSYMBOL_qwords = 371,                   /* qwords  */
  YYSYMBOL_words_tQSYMBOLS_BEG_qsym_list = 372, /* words_tQSYMBOLS_BEG_qsym_list  */
  YYSYMBOL_qsymbols = 373,                 /* qsymbols  */
  YYSYMBOL_qword_list = 374,               /* qword_list  */
  YYSYMBOL_qsym_list = 375,                /* qsym_list  */
  YYSYMBOL_string_contents = 376,          /* string_contents  */
  YYSYMBOL_xstring_contents = 377,         /* xstring_contents  */
  YYSYMBOL_regexp_contents = 378,          /* regexp_contents  */
  YYSYMBOL_string_content = 379,           /* string_content  */
  YYSYMBOL_380_31 = 380,                   /* @31  */
  YYSYMBOL_381_32 = 381,                   /* @32  */
  YYSYMBOL_382_33 = 382,                   /* @33  */
  YYSYMBOL_383_34 = 383,                   /* @34  */
  YYSYMBOL_string_dend = 384,              /* string_dend  */
  YYSYMBOL_string_dvar = 385,              /* string_dvar  */
  YYSYMBOL_symbol = 386,                   /* symbol  */
  YYSYMBOL_ssym = 387,                     /* ssym  */
  YYSYMBOL_sym = 388,                      /* sym  */
  YYSYMBOL_dsym = 389,                     /* dsym  */
  YYSYMBOL_numeric = 390,                  /* numeric  */
  YYSYMBOL_simple_numeric = 391,           /* simple_numeric  */
  YYSYMBOL_nonlocal_var = 392,             /* nonlocal_var  */
  YYSYMBOL_user_variable = 393,            /* user_variable  */
  YYSYMBOL_keyword_variable = 394,         /* keyword_variable  */
  YYSYMBOL_var_ref = 395,                  /* var_ref  */
  YYSYMBOL_var_lhs = 396,                  /* var_lhs  */
  YYSYMBOL_backref = 397,                  /* backref  */
  YYSYMBOL_398_35 = 398,                   /* $@35  */
  YYSYMBOL_superclass = 399,               /* superclass  */
  YYSYMBOL_f_opt_paren_args = 400,         /* f_opt_paren_args  */
  YYSYMBOL_f_paren_args = 401,             /* f_paren_args  */
  YYSYMBOL_f_arglist = 402,                /* f_arglist  */
  YYSYMBOL_403_36 = 403,                   /* @36  */
  YYSYMBOL_f_kwarg_f_kw = 404,             /* f_kwarg_f_kw  */
  YYSYMBOL_args_tail = 405,                /* args_tail  */
  YYSYMBOL_f_opt_arg_value = 406,          /* f_opt_arg_value  */
  YYSYMBOL_f_optarg_arg_value = 407,       /* f_optarg_arg_value  */
  YYSYMBOL_opt_args_tail_args_tail = 408,  /* opt_args_tail_args_tail  */
  YYSYMBOL_f_args = 409,                   /* f_args  */
  YYSYMBOL_args_forward = 410,             /* args_forward  */
  YYSYMBOL_f_bad_arg = 411,                /* f_bad_arg  */
  YYSYMBOL_f_norm_arg = 412,               /* f_norm_arg  */
  YYSYMBOL_f_arg_asgn = 413,               /* f_arg_asgn  */
  YYSYMBOL_f_arg_item = 414,               /* f_arg_item  */
  YYSYMBOL_f_arg = 415,                    /* f_arg  */
  YYSYMBOL_f_label = 416,                  /* f_label  */
  YYSYMBOL_f_kw = 417,                     /* f_kw  */
  YYSYMBOL_f_block_kw = 418,               /* f_block_kw  */
  YYSYMBOL_kwrest_mark = 419,              /* kwrest_mark  */
  YYSYMBOL_f_no_kwarg = 420,               /* f_no_kwarg  */
  YYSYMBOL_f_kwrest = 421,                 /* f_kwrest  */
  YYSYMBOL_restarg_mark = 422,             /* restarg_mark  */
  YYSYMBOL_f_rest_arg = 423,               /* f_rest_arg  */
  YYSYMBOL_blkarg_mark = 424,              /* blkarg_mark  */
  YYSYMBOL_f_block_arg = 425,              /* f_block_arg  */
  YYSYMBOL_opt_f_block_arg = 426,          /* opt_f_block_arg  */
  YYSYMBOL_singleton = 427,                /* singleton  */
  YYSYMBOL_428_37 = 428,                   /* $@37  */
  YYSYMBOL_assoc_list = 429,               /* assoc_list  */
  YYSYMBOL_assocs = 430,                   /* assocs  */
  YYSYMBOL_assoc = 431,                    /* assoc  */
  YYSYMBOL_operation = 432,                /* operation  */
  YYSYMBOL_operation2 = 433,               /* operation2  */
  YYSYMBOL_operation3 = 434,               /* operation3  */
  YYSYMBOL_dot_or_colon = 435,             /* dot_or_colon  */
  YYSYMBOL_call_op = 436,                  /* call_op  */
  YYSYMBOL_call_op2 = 437,                 /* call_op2  */
  YYSYMBOL_rparen = 438,                   /* rparen  */
  YYSYMBOL_rbracket = 439,                 /* rbracket  */
  YYSYMBOL_rbrace = 440,                   /* rbrace  */
  YYSYMBOL_trailer = 441,                  /* trailer  */
  YYSYMBOL_term = 442,                     /* term  */
  YYSYMBOL_terms = 443,                    /* terms  */
  YYSYMBOL_none = 444                      /* none  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  134
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   15976

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  163
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  282
/* YYNRULES -- Number of rules.  */
#define YYNRULES  789
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1354

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   362


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,    72,
     155,    75,    73,    74,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,   162,   149,     2,     2,     2,   147,   142,     2,
     158,   159,   145,   143,   156,   144,    69,   146,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   137,   161,
     139,   135,   138,   136,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   154,    70,   160,   141,     2,   157,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   152,   140,   153,   150,     2,    89,    90,
      91,    92,    76,    77,    78,    79,    95,    96,    84,    83,
      80,    81,    82,    87,    88,    93,    94,    98,    85,    86,
      97,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    71,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   148,   151
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  2968,  2968,  2968,  2994,  2994,  2994,  3000,  3005,  3010,
    3017,  3022,  3029,  3031,  3045,  3050,  3041,  3061,  3058,  3071,
    3077,  3082,  3087,  3094,  3099,  3098,  3108,  3110,  3117,  3117,
    3122,  3127,  3135,  3144,  3151,  3157,  3163,  3174,  3185,  3194,
    3207,  3208,  3214,  3219,  3230,  3235,  3236,  3243,  3248,  3253,
    3259,  3259,  3264,  3270,  3275,  3281,  3292,  3303,  3311,  3312,
    3318,  3318,  3318,  3325,  3330,  3338,  3341,  3342,  3347,  3352,
    3357,  3363,  3362,  3376,  3375,  3388,  3391,  3403,  3413,  3412,
    3426,  3431,  3437,  3437,  3437,  3444,  3445,  3448,  3449,  3456,
    3464,  3471,  3478,  3487,  3492,  3497,  3502,  3507,  3513,  3519,
    3525,  3530,  3537,  3546,  3547,  3554,  3555,  3562,  3567,  3572,
    3577,  3582,  3587,  3592,  3597,  3602,  3607,  3614,  3615,  3622,
    3627,  3634,  3639,  3646,  3646,  3651,  3656,  3662,  3667,  3673,
    3678,  3683,  3691,  3691,  3696,  3701,  3706,  3711,  3716,  3721,
    3726,  3734,  3742,  3745,  3750,  3755,  3762,  3762,  3763,  3764,
    3769,  3772,  3777,  3780,  3785,  3785,  3793,  3794,  3795,  3796,
    3797,  3798,  3799,  3800,  3801,  3802,  3803,  3804,  3805,  3806,
    3807,  3808,  3809,  3810,  3811,  3812,  3813,  3814,  3815,  3816,
    3817,  3818,  3819,  3820,  3821,  3822,  3825,  3825,  3825,  3826,
    3826,  3827,  3827,  3827,  3828,  3828,  3828,  3828,  3829,  3829,
    3829,  3829,  3830,  3830,  3830,  3831,  3831,  3831,  3831,  3832,
    3832,  3832,  3832,  3833,  3833,  3833,  3833,  3834,  3834,  3834,
    3834,  3835,  3835,  3835,  3835,  3836,  3836,  3839,  3844,  3849,
    3854,  3859,  3864,  3869,  3875,  3881,  3887,  3894,  3901,  3907,
    3913,  3919,  3925,  3930,  3935,  3940,  3945,  3950,  3955,  3960,
    3965,  3970,  3975,  3980,  3985,  3990,  3991,  3996,  4001,  4006,
    4011,  4016,  4021,  4026,  4031,  4036,  4041,  4046,  4052,  4059,
    4070,  4081,  4087,  4088,  4094,  4101,  4102,  4103,  4104,  4107,
    4112,  4120,  4126,  4133,  4140,  4147,  4148,  4152,  4157,  4164,
    4169,  4178,  4183,  4193,  4205,  4206,  4212,  4213,  4214,  4218,
    4223,  4230,  4236,  4241,  4247,  4253,  4257,  4257,  4295,  4300,
    4308,  4313,  4321,  4326,  4331,  4336,  4344,  4349,  4358,  4359,
    4363,  4368,  4373,  4391,  4391,  4391,  4391,  4391,  4391,  4391,
    4391,  4392,  4393,  4394,  4400,  4399,  4412,  4412,  4418,  4424,
    4429,  4434,  4439,  4445,  4450,  4455,  4460,  4465,  4471,  4476,
    4481,  4486,  4487,  4493,  4494,  4503,  4512,  4521,  4531,  4530,
    4545,  4544,  4557,  4564,  4607,  4606,  4624,  4623,  4643,  4642,
    4661,  4659,  4676,  4674,  4689,  4694,  4699,  4704,  4719,  4726,
    4733,  4751,  4758,  4766,  4774,  4781,  4789,  4798,  4807,  4815,
    4822,  4829,  4837,  4844,  4850,  4865,  4872,  4877,  4883,  4890,
    4897,  4898,  4899,  4902,  4903,  4906,  4907,  4917,  4918,  4925,
    4926,  4929,  4934,  4941,  4946,  4953,  4958,  4963,  4968,  4973,
    4980,  4986,  4993,  4994,  5001,  5001,  5003,  5003,  5003,  5008,
    5013,  5018,  5025,  5033,  5033,  5033,  5033,  5033,  5033,  5038,
    5043,  5048,  5053,  5058,  5064,  5069,  5074,  5079,  5084,  5089,
    5094,  5099,  5104,  5111,  5112,  5118,  5125,  5135,  5140,  5147,
    5149,  5153,  5158,  5164,  5170,  5175,  5182,  5188,  5181,  5214,
    5221,  5230,  5237,  5236,  5247,  5255,  5267,  5277,  5286,  5293,
    5300,  5311,  5317,  5322,  5328,  5334,  5339,  5344,  5352,  5358,
    5366,  5366,  5383,  5383,  5404,  5410,  5415,  5421,  5428,  5438,
    5439,  5442,  5443,  5445,  5456,  5453,  5469,  5470,  5473,  5474,
    5480,  5488,  5489,  5495,  5501,  5506,  5511,  5518,  5521,  5528,
    5531,  5536,  5539,  5546,  5553,  5554,  5555,  5562,  5569,  5576,
    5582,  5589,  5596,  5603,  5609,  5614,  5619,  5626,  5625,  5636,
    5642,  5650,  5656,  5661,  5666,  5671,  5676,  5679,  5683,  5690,
    5695,  5702,  5710,  5716,  5723,  5724,  5731,  5738,  5743,  5748,
    5753,  5760,  5762,  5769,  5775,  5787,  5788,  5803,  5808,  5815,
    5821,  5822,  5829,  5830,  5837,  5844,  5850,  5856,  5857,  5858,
    5859,  5865,  5873,  5873,  5873,  5873,  5873,  5873,  5873,  5873,
    5874,  5879,  5882,  5890,  5902,  5909,  5916,  5921,  5926,  5933,
    5954,  5957,  5962,  5966,  5969,  5974,  5977,  5984,  5987,  5988,
    5991,  6005,  6006,  6007,  6014,  6027,  6039,  6046,  6046,  6046,
    6046,  6050,  6054,  6061,  6063,  6070,  6070,  6074,  6078,  6085,
    6085,  6088,  6088,  6092,  6096,  6104,  6108,  6116,  6120,  6128,
    6132,  6140,  6144,  6170,  6173,  6172,  6187,  6195,  6199,  6186,
    6218,  6219,  6222,  6227,  6230,  6231,  6234,  6250,  6251,  6254,
    6262,  6263,  6271,  6272,  6273,  6274,  6277,  6278,  6279,  6282,
    6282,  6283,  6286,  6287,  6288,  6289,  6290,  6291,  6292,  6295,
    6305,  6312,  6312,  6319,  6320,  6324,  6323,  6334,  6340,  6341,
    6350,  6360,  6361,  6361,  6378,  6378,  6378,  6383,  6388,  6393,
    6398,  6415,  6415,  6415,  6415,  6415,  6415,  6420,  6425,  6430,
    6435,  6440,  6445,  6450,  6455,  6460,  6465,  6470,  6475,  6480,
    6486,  6493,  6504,  6513,  6522,  6531,  6542,  6543,  6553,  6561,
    6566,  6585,  6587,  6598,  6618,  6624,  6632,  6638,  6646,  6647,
    6650,  6656,  6662,  6670,  6671,  6674,  6680,  6688,  6689,  6692,
    6698,  6706,  6711,  6718,  6724,  6723,  6761,  6762,  6769,  6771,
    6796,  6801,  6806,  6813,  6819,  6824,  6833,  6833,  6834,  6837,
    6838,  6841,  6842,  6843,  6846,  6847,  6850,  6851,  6854,  6855,
    6858,  6861,  6864,  6867,  6868,  6871,  6872,  6879,  6880,  6884
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end-of-input\"", "error", "\"invalid token\"", "\"'class'\"",
  "\"'module'\"", "\"'def'\"", "\"'undef'\"", "\"'begin'\"",
  "\"'rescue'\"", "\"'ensure'\"", "\"'end'\"", "\"'if'\"", "\"'unless'\"",
  "\"'then'\"", "\"'elsif'\"", "\"'else'\"", "\"'case'\"", "\"'when'\"",
  "\"'while'\"", "\"'until'\"", "\"'for'\"", "\"'break'\"", "\"'next'\"",
  "\"'redo'\"", "\"'retry'\"", "\"'in'\"", "\"'do'\"",
  "\"'do' for condition\"", "\"'do' for block\"", "\"'do' for lambda\"",
  "\"'return'\"", "\"'yield'\"", "\"'super'\"", "\"'self'\"", "\"'nil'\"",
  "\"'true'\"", "\"'false'\"", "\"'and'\"", "\"'or'\"", "\"'not'\"",
  "\"'if' modifier\"", "\"'unless' modifier\"", "\"'while' modifier\"",
  "\"'until' modifier\"", "\"'rescue' modifier\"", "\"'alias'\"",
  "\"'defined?'\"", "\"'BEGIN'\"", "\"'END'\"", "\"'__LINE__'\"",
  "\"'__FILE__'\"", "\"'__ENCODING__'\"", "\"local variable or method\"",
  "\"method\"", "\"global variable\"", "\"instance variable\"",
  "\"constant\"", "\"class variable\"", "\"label\"", "\"integer literal\"",
  "\"float literal\"", "\"rational literal\"", "\"imaginary literal\"",
  "\"char literal\"", "\"numbered reference\"", "\"back reference\"",
  "\"literal content\"", "tREGEXP_END", "\"dummy end\"", "'.'",
  "\"backslash\"", "\"escaped space\"", "\"escaped horizontal tab\"",
  "\"escaped form feed\"", "\"escaped carriage return\"",
  "\"escaped vertical tab\"", "\"unary+\"", "\"unary-\"", "\"**\"",
  "\"<=>\"", "\"==\"", "\"===\"", "\"!=\"", "\">=\"", "\"<=\"", "\"&&\"",
  "\"||\"", "\"=~\"", "\"!~\"", "\"..\"", "\"...\"", "\"(..\"", "\"(...\"",
  "\"[]\"", "\"[]=\"", "\"<<\"", "\">>\"", "\"&.\"", "\"::\"",
  "\":: at EXPR_BEG\"", "\"operator-assignment\"", "\"=>\"", "\"(\"",
  "\"( arg\"", "\")\"", "\"[\"", "\"{\"", "\"{ arg\"", "\"*\"",
  "\"**arg\"", "\"&\"", "\"->\"", "\"symbol literal\"",
  "\"string literal\"", "\"backtick literal\"", "\"regexp literal\"",
  "\"word list\"", "\"verbatim word list\"", "\"symbol list\"",
  "\"verbatim symbol list\"", "\"terminator\"", "\"'}'\"", "\"'#{'\"",
  "tSTRING_DVAR", "tLAMBEG", "tLABEL_END", "tIGNORED_NL", "tCOMMENT",
  "tEMBDOC_BEG", "tEMBDOC", "tEMBDOC_END", "tHEREDOC_BEG", "tHEREDOC_END",
  "k__END__", "tLOWEST", "'='", "'?'", "':'", "'>'", "'<'", "'|'", "'^'",
  "'&'", "'+'", "'-'", "'*'", "'/'", "'%'", "tUMINUS_NUM", "'!'", "'~'",
  "tLAST_TOKEN", "'{'", "'}'", "'['", "'\\n'", "','", "'`'", "'('", "')'",
  "']'", "';'", "' '", "$accept", "$@1", "program", "option_terms",
  "top_compstmt", "top_stmts", "top_stmt", "block_open", "begin_block",
  "$@2", "$@3", "bodystmt", "$@4", "compstmt", "stmts", "stmt_or_begin",
  "$@5", "allow_exits", "k_END", "$@6", "stmt", "command_asgn",
  "endless_command", "option_'\\n'", "command_rhs", "expr", "$@7", "$@8",
  "def_name", "defn_head", "$@9", "defs_head", "expr_value", "$@10",
  "$@11", "expr_value_do", "command_call", "block_command",
  "cmd_brace_block", "fcall", "command", "mlhs", "mlhs_inner",
  "mlhs_basic", "mlhs_item", "mlhs_head", "mlhs_post", "mlhs_node", "lhs",
  "cname", "cpath", "fname", "fitem", "undef_list", "$@12", "op",
  "reswords", "arg", "endless_arg", "relop", "rel_expr", "lex_ctxt",
  "begin_defined", "after_rescue", "arg_value", "aref_args", "arg_rhs",
  "paren_args", "opt_paren_args", "opt_call_args", "call_args", "$@13",
  "command_args", "block_arg", "opt_block_arg", "args", "arg_splat",
  "mrhs_arg", "mrhs", "primary", "$@14", "$@15", "@16", "@17", "$@18",
  "$@19", "$@20", "$@21", "$@22", "primary_value", "k_begin", "k_if",
  "k_unless", "k_while", "k_until", "k_case", "k_for", "k_class",
  "k_module", "k_def", "k_do", "k_do_block", "k_rescue", "k_ensure",
  "k_when", "k_else", "k_elsif", "k_end", "k_return", "k_yield", "then",
  "do", "if_tail", "opt_else", "for_var", "f_marg", "f_marg_list",
  "f_margs", "f_rest_marg", "f_any_kwrest", "$@23", "f_eq",
  "f_kwarg_f_block_kw", "block_args_tail", "excessed_comma",
  "f_opt_primary_value", "f_optarg_primary_value",
  "opt_args_tail_block_args_tail", "block_param", "opt_block_param",
  "block_param_def", "opt_bv_decl", "bv_decls", "bvar", "max_numparam",
  "numparam", "it_id", "@24", "$@25", "lambda", "f_larglist",
  "lambda_body", "$@26", "do_block", "block_call", "method_call",
  "brace_block", "@27", "brace_body", "@28", "do_body", "case_args",
  "case_body", "cases", "p_pvtbl", "p_pktbl", "p_in_kwarg", "$@29",
  "p_case_body", "p_cases", "p_top_expr", "p_top_expr_body", "p_expr",
  "p_as", "p_alt", "p_lparen", "p_lbracket", "p_expr_basic", "$@30",
  "p_args", "p_args_head", "p_args_tail", "p_find", "p_rest",
  "p_args_post", "p_arg", "p_kwargs", "p_kwarg", "p_kw", "p_kw_label",
  "p_kwrest", "p_kwnorest", "p_any_kwrest", "p_value", "p_primitive",
  "p_variable", "p_var_ref", "p_expr_ref", "p_const", "opt_rescue",
  "exc_list", "exc_var", "opt_ensure", "literal", "strings", "string",
  "string1", "xstring", "regexp", "nonempty_list_' '",
  "words_tWORDS_BEG_word_list", "words", "word_list", "word",
  "words_tSYMBOLS_BEG_symbol_list", "symbols", "symbol_list",
  "words_tQWORDS_BEG_qword_list", "qwords",
  "words_tQSYMBOLS_BEG_qsym_list", "qsymbols", "qword_list", "qsym_list",
  "string_contents", "xstring_contents", "regexp_contents",
  "string_content", "@31", "@32", "@33", "@34", "string_dend",
  "string_dvar", "symbol", "ssym", "sym", "dsym", "numeric",
  "simple_numeric", "nonlocal_var", "user_variable", "keyword_variable",
  "var_ref", "var_lhs", "backref", "$@35", "superclass",
  "f_opt_paren_args", "f_paren_args", "f_arglist", "@36", "f_kwarg_f_kw",
  "args_tail", "f_opt_arg_value", "f_optarg_arg_value",
  "opt_args_tail_args_tail", "f_args", "args_forward", "f_bad_arg",
  "f_norm_arg", "f_arg_asgn", "f_arg_item", "f_arg", "f_label", "f_kw",
  "f_block_kw", "kwrest_mark", "f_no_kwarg", "f_kwrest", "restarg_mark",
  "f_rest_arg", "blkarg_mark", "f_block_arg", "opt_f_block_arg",
  "singleton", "$@37", "assoc_list", "assocs", "assoc", "operation",
  "operation2", "operation3", "dot_or_colon", "call_op", "call_op2",
  "rparen", "rbracket", "rbrace", "trailer", "term", "terms", "none", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1131)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-790)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -1131,  5518,   148, -1131, -1131, -1131, -1131, 10004, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, 11067, 11067, -1131, -1131, -1131,
   -1131,  4490, -1131, -1131, -1131, -1131,   189,  9849,     6,    36,
   -1131, -1131, -1131, -1131,  5798,  6426, -1131, -1131,  5955, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, 12640, 12640, 12640,
   12640,   145,  8755,  8914, 11551, 11793, 10307, -1131,  9694, -1131,
   -1131, -1131,    59,    59,    59,    59,  1284, 12761, 12640, -1131,
     396, -1131, -1131,  1608, -1131,   587,    45,    45, -1131, -1131,
     343,   250,   269, -1131,   258, 13366, -1131,   296,  5117,  1173,
     486,   680, -1131, 10946, 10946, -1131, -1131,  9379, 13485, 13604,
   13723,  9538, 11067,  6897, -1131,   702,   144, -1131, -1131,   313,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131,   318,   386, -1131,
     342,   517, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131,   317, -1131, -1131, -1131, -1131, -1131, -1131,   332, 12640,
     476,  8914, 12640, 12640, 12640, -1131, 12640,    45,    45, -1131,
     414,  5925,   478, -1131, -1131,   432, -1131,   693,    42,    60,
     498,    84,   474, -1131, -1131, 11188, -1131, 11067, -1131, -1131,
   10685, 12882,   648, -1131,   491, -1131,  9073, -1131, -1131, -1131,
   -1131, -1131,   524,   343, -1131,   700, -1131,   529,   593,  6082,
    6082,   845, -1131,  8755,   531,   396, -1131,  1608,     6,   585,
   -1131, -1131,   590,   747,   767, -1131,   478,   614,   767, -1131,
       6,   718,  1284, 13842,   628,   628,   639, -1131,   715,   745,
     798,   880, -1131, -1131,   439, -1131, -1131,   717,   841,   722,
   -1131,   653,   653,   653,   653,   755, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131,  5671,   670, 10946, 10946, 10946, 10946, -1131,
   12882, 12882,  1693,   690,   713, -1131,  1693, -1131,   723, -1131,
   -1131, -1131, -1131,   758, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131,  8755, 10426,   707, -1131, -1131, 12640, 12640, 12640, 12640,
   12640, -1131, -1131, 12640, 12640, 12640, 12640, 12640, 12640, 12640,
   12640, -1131, 12640, -1131, -1131, 12640, 12640, 12640, 12640, 12640,
   12640, 12640, 12640, 12640, 12640, -1131, -1131, 14235, 11067, 14334,
    7684, -1131,   587,   124,   124, 10946,  8602,  8602, -1131,   396,
     709,   837, -1131, -1131,   948,   890,    78,    89,   100,   792,
     984, 10946,   135, -1131,   791,  1006, -1131, -1131, -1131, -1131,
     113,   565,   655,   659,   678,   694,   712,   784,   788, -1131,
   -1131, -1131, -1131,   815, -1131, 10545, -1131, -1131, -1131, 15819,
   -1131, -1131, -1131, -1131, -1131, -1131,   311, -1131, -1131, -1131,
     927,   797,   799, -1131, 12640, 11309, -1131, -1131, 14433, 11067,
   14532, -1131, -1131, 11672, -1131, 12640,     6, -1131,   771,     6,
     782, -1131, -1131,   796,    67, -1131, -1131, -1131, -1131, -1131,
   10004, -1131, -1131, 12640,   829, 14631, 14532, -1131,    36,     6,
   -1131, -1131,  5356,   785,   825, -1131, 11551, -1131, -1131, 11793,
   -1131, -1131, -1131,   491,  1080, -1131, -1131,   849, -1131, 13842,
   14730, 11067, 14829, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131,   915,    90,   938,    97, 12640,
   -1131, -1131,  9226, -1131, -1131, -1131, -1131, -1131, 10825, -1131,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,  1332,
   -1131, -1131, -1131, -1131, -1131,   866, -1131,   873, -1131, -1131,
     886,     6, -1131, -1131, -1131,   816, -1131,   888, 12640, -1131,
     652, -1131, -1131,  1003,   908,  1013, -1131, 13003,  7684,   396,
   13003,  7684, -1131,   883, -1131, -1131, -1131,   147,   147, 11914,
       6, 13842,   913, -1131, 12035, -1131,   593,  5509,  5509,  5509,
    5509,  6239,  2169,  5509,  5509,  6082,  6082,  1097,  1097, -1131,
    5768,  1579,  1579,  1352,   294,   294,   593,   593,   593,  1479,
    1479,  7054,  6112,  7368,  6269, -1131, -1131,   524, -1131,     6,
     914,   862, -1131,   895, -1131, -1131,  6583,   147, -1131, -1131,
    7837,  1064,  8296,   179,   147,   147,  1062,  1066,   111, 14928,
   11067, 15027, -1131, -1131, -1131,  1080, -1131, -1131, -1131, 15126,
   11067, 15225,  7684, 12882, -1131, -1131, -1131,     6, -1131, -1131,
   -1131,  3269, 13124, 13124, 10004, -1131, 12640, 13245, 13245, 12640,
   -1131,   478, -1131, -1131,   474,  4782,  6740,     6,   333,   337,
   12640, 12640, -1131, -1131, 11430, -1131, 11672, -1131, -1131, -1131,
   12882,  5925, -1131,   336,   524,   524, 13124, -1131,   214, -1131,
   -1131,   767, 13842,   849,   473,   610,     6,   488,   668, -1131,
   -1131,   795, -1131,   326, -1131,    59, -1131, -1131,   326,    59,
   -1131,   593,   934, -1131,  1332,  1662, -1131,   940,     6,   942,
   -1131,   568, -1131, -1131,  1207, -1131,  1693, -1131, -1131,   959,
   12640,  1693, -1131, -1131, -1131, -1131, -1131,   931, -1131, -1131,
     189,  1055, -1131,  5925,  1061,   147, -1131,  1055,  1061,   147,
   -1131, -1131,   958, -1131, -1131, -1131, -1131, -1131, 12640, -1131,
     956,   960,  1085, -1131, -1131,   849, 13842,  1075, -1131, -1131,
    1093,  1004,  7021, -1131, -1131, -1131,  1110,   380, -1131, -1131,
    1007, -1131, -1131, -1131, -1131,   758,   981,   939, 11309, -1131,
   -1131, -1131, -1131,   758, -1131, -1131,  1143,   928, -1131,  1139,
   -1131, -1131, -1131, -1131, -1131, -1131, 12156,   147, -1131,  1062,
     147,   137,   161,     6,   130,   156,  8602,   396, 10946,  7684,
    1058,   610, -1131,     6,   147,    67, 10159, -1131,   144,   250,
   -1131,  2589, -1131, -1131, -1131, -1131, 12640, -1131,   189, -1131,
   -1131, -1131,   404, -1131, -1131,     6,  1008,    67, -1131, -1131,
   -1131, -1131,   673, -1131, -1131, -1131, -1131, -1131,   653, -1131,
     653,   653,   653, -1131,     6, -1131,  1332, -1131,  1539, -1131,
   -1131,  1119,   866, -1131, -1131,  1016,  1024, -1131, -1131,  1025,
   -1131,  1030, -1131,  1016, 13003, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131,  1031, 12277, -1131,   849,   410, -1131, -1131, -1131,
   15324, 11067, 15423, -1131, -1131, 12640, 13124, 13124,  1037, -1131,
   -1131, -1131, 13124, 13124, -1131, -1131, 12398,  1139, -1131, -1131,
   -1131,  8602, 10946,   147, -1131, -1131,   147, -1131, 12640, -1131,
      81, -1131, -1131,   147, -1131,   165,   147,  7684,   396,   147,
   -1131, -1131, -1131, -1131, -1131, -1131, 13245, 12640, 12640, -1131,
   12640, 12640, -1131, 11672, -1131,  1232,  4999, -1131, -1131,  1036,
    1038, -1131,   931, -1131,   931, -1131,  1693, -1131,   931, -1131,
   -1131,  1055,  1061, 12640, 12640, -1131, -1131, 12640,  1040, 10825,
   10825, 13124, 12640,  7211,  7525,     6,   454,   519, 14154, 14154,
    5925, -1131, -1131, -1131, -1131, -1131, 13124, -1131, -1131, -1131,
   -1131,   956, -1131,  1103, -1131,  1196, -1131, -1131,   124, -1131,
   -1131, -1131, 12519,  7990, -1131, -1131, -1131,   147, -1131, -1131,
   12640,  1693, -1131, -1131,    92,  1539,  1539,  1016,  1016,  1050,
    1016,  5925,  5925,  1069,  1069,  1031, -1131, -1131,  5925,   542,
   -1131, -1131, -1131,  1358,  1358,   431, -1131,  1554,   421,  1159,
   -1131,  1249, -1131, -1131,    49, -1131,  1073, -1131, -1131, -1131,
    1063, -1131,  1074, -1131, 14247, -1131, -1131, -1131, -1131,   878,
   -1131, -1131, -1131,    40, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131,   675, -1131, -1131, -1131, 13961,   124, -1131,
   -1131,  8602, -1131, -1131,  8449,  7837, 12640, -1131,   744, 14154,
   -1131,     6,   291, -1131, -1131, -1131,  1038, -1131, -1131,   931,
   -1131, -1131,  1431,  9226, -1131, -1131,  7684, -1131, -1131, -1131,
   -1131, 14247,   229,     6,  1939, -1131,     6,  1077, -1131,  1076,
   -1131, -1131, -1131,  1095, -1131, 10946, -1131,  1186,  1939, 14247,
   14247,   513,  1145,  1358,  1358,   431,   228,   426, 14154, 14154,
   -1131,  1198, -1131,  1124,   126,   180,   219,  7684,   396, -1131,
     928, -1131, -1131, -1131, -1131,   124,   975,  1091,  1096, -1131,
    9226, -1131,  1016,   866,  1114, -1131, -1131,  1115,     6,  1126,
     816,  1117, 14080, -1131,  1118, -1131, -1131, -1131,   238, -1131,
    1145,  1123,  1137, -1131, -1131, -1131, -1131, -1131,     6, -1131,
   -1131,  1140, -1131,  1152, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131,     6,     6,     6,     6,     6,
       6,   226, 15522, 11067, 15621,  1143, -1131,  1196, -1131, -1131,
   10946, 10946,  1677, -1131,  7684,  1106, -1131, -1131,  1207, -1131,
    1754, -1131,  1142, -1131, 14080,  1754, -1131, -1131,  1224,  1228,
    1628, -1131, -1131, 14247, -1131,   513, -1131, 14247,  1939,   335,
   -1131, -1131, -1131, -1131, -1131, -1131,   210,   369,     6,   236,
     373, -1131, -1131,  8143, -1131, -1131, -1131,   865, -1131, -1131,
     147, -1131, -1131,   866, -1131, -1131,  1158,  1162, -1131,  1228,
    1174,  1179, -1131, 15720,  1158,  1181,     6,  1181, -1131, -1131,
     389,   129,  1677, -1131, -1131, -1131,  1628, -1131,  1628, -1131,
    1754, -1131,  1628, -1131,  1141,  1157, -1131, 14247, -1131, -1131,
   -1131, -1131, -1131,  1158,  1158,  1203,  1158, -1131, -1131,  1628,
   -1131, -1131,  1158, -1131
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     0,    46,   386,   387,   388,     0,   379,   380,
     381,   384,    26,    26,    26,   374,   375,   376,   377,   398,
     399,   306,   673,   672,   674,   675,    60,     0,    60,     0,
     789,   677,   676,   678,   766,   768,   667,   666,   767,   668,
     662,   663,   664,   665,   611,   683,   684,     0,     0,     0,
       0,     0,     0,     0,   789,   789,   115,   466,   637,   637,
     639,   641,     0,     0,     0,     0,     0,     0,     0,     3,
       4,     8,    26,    10,    40,    45,   692,   692,    66,    86,
     306,    85,     0,   103,     0,   107,   117,     0,    75,   255,
     271,     0,   334,     0,     0,    82,    82,     0,     0,     0,
       0,     0,   343,   306,   353,    87,   351,   323,   324,   610,
     612,   325,   326,   620,   327,   626,   329,   630,   328,   632,
     330,   609,   654,   655,   608,   660,   671,   679,   680,   331,
       0,   332,    90,     7,     1,   196,   207,   197,   220,   193,
     213,   203,   202,   223,   224,   218,   201,   200,   195,   221,
     225,   226,   205,   194,   208,   212,   214,   206,   199,   215,
     222,   217,   216,   209,   219,   204,   192,   211,   210,   191,
     198,   189,   190,   186,   187,   188,   146,   148,   147,   181,
     182,   177,   159,   160,   161,   168,   165,   167,   162,   163,
     183,   184,   169,   170,   174,   178,   164,   166,   156,   157,
     158,   171,   172,   173,   175,   176,   179,   180,   185,   151,
     153,    33,   149,   150,   152,   382,   383,   385,     0,   762,
       0,     0,   317,   765,   309,   637,     0,   692,   692,   301,
       0,   284,   312,   101,   305,   789,   313,     0,   679,   680,
       0,   332,   789,   758,   102,   789,   485,     0,    98,    61,
      60,     0,     0,    28,   789,    12,     0,    11,    27,   281,
     374,   375,   486,     0,   249,     0,   343,   346,   250,   240,
     241,   340,    24,     0,     0,     4,    21,    23,    60,   105,
      20,   336,     0,    60,    60,   285,     0,     0,    60,   756,
      60,     0,     0,     0,   692,   692,   113,   378,     0,   123,
     124,   131,   463,   657,     0,   656,   658,     0,     0,     0,
     617,   621,   633,   627,   635,   661,    70,   261,   262,   786,
     785,     6,   787,     0,     0,     0,     0,     0,     0,   789,
       0,     0,   720,     0,   691,   370,   720,   689,     0,   372,
     389,   490,   479,    91,   492,   350,   390,   492,   475,   789,
     119,     0,   111,   108,   789,    73,     0,     0,     0,     0,
       0,   277,   278,     0,     0,     0,     0,   238,   239,     0,
       0,    71,     0,   275,   276,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   776,   777,     0,   789,     0,
       0,    81,    80,     0,     0,     0,     0,     0,   360,     4,
       5,     0,   410,   409,     0,     0,   679,   680,   332,   141,
     142,     0,     0,   144,   687,     0,   679,   680,   332,   368,
     216,   209,   219,   204,   186,   187,   188,   146,   147,   754,
      77,    76,   753,     0,   100,    60,    99,   779,   778,     0,
     352,   613,   789,   789,   154,   761,   340,   316,   764,   308,
       0,     0,     0,   789,     0,     0,   302,   311,     0,   789,
       0,   789,   789,     0,   303,   721,    60,   297,   789,    60,
     789,   296,   307,     0,    60,   349,    69,    30,    32,    31,
       0,   789,   282,     0,     0,     0,     0,   789,     0,    60,
     338,    19,     0,   104,     0,   341,   784,   783,   286,   784,
     288,   342,   757,     0,   130,   661,   121,   116,   691,     0,
       0,   789,     0,   464,   643,   659,   646,   644,   638,   614,
     615,   640,   616,   642,   618,     0,     0,     0,     0,     0,
     788,     9,     0,    34,    35,    36,    37,   283,     0,    67,
      68,   727,   724,   723,   722,   725,   733,   738,   721,     0,
     744,   739,   748,   747,   743,   789,   740,   789,   719,   702,
     705,    60,   700,   726,   728,   729,   731,   705,   735,   694,
     742,   423,   422,   746,   705,   750,   699,     0,     0,     0,
       0,     0,   463,     0,   490,    92,   463,     0,     0,     0,
      60,     0,   109,   120,     0,   503,   247,   254,   256,   257,
     258,   265,   266,   259,   260,   236,   237,   263,   264,   503,
      60,   251,   252,   253,   242,   243,   244,   245,   246,   279,
     280,   766,   768,   767,   770,   484,   769,   306,   482,    60,
     789,   766,   768,   767,   770,   483,   306,     0,   789,   401,
       0,   400,     0,     0,     0,     0,     0,   358,   340,     0,
     789,     0,    82,   366,   141,   142,   143,   685,   364,     0,
     789,     0,     0,     0,   774,   775,    78,    60,   345,   766,
     767,   306,     0,     0,     0,   789,     0,     0,     0,     0,
     760,   314,   310,   315,   789,   766,   767,    60,   766,   767,
       0,     0,   759,   291,   298,   293,   300,   780,   348,    29,
       0,   267,    13,   339,     0,   789,     0,    25,   106,    22,
     337,    60,     0,   114,   771,   129,    60,   766,   767,   465,
     647,     0,   619,     0,   623,     0,   629,   625,     0,     0,
     631,   248,     0,    38,     0,   421,   413,   415,    60,   418,
     411,     0,   698,   752,     0,   697,     0,   715,   690,     0,
       0,     0,   712,   734,   569,   741,   745,     0,   717,   749,
      60,    55,    58,   272,   269,     0,   693,    56,   270,     0,
     464,   488,     0,   464,   396,   397,   489,   474,   317,    41,
     319,     0,    44,   318,   118,   112,     0,     0,    65,    47,
      63,     0,   289,   312,   227,    42,     0,   332,   501,   501,
       0,   789,   789,   490,   481,    95,     0,   487,   298,   789,
     789,   295,   480,    93,   294,   335,   789,   789,   402,   789,
     404,    83,   403,   356,   357,   393,     0,     0,   503,     0,
       0,   771,   339,    60,   766,   767,     0,     0,     0,     0,
     141,   142,   145,    60,     0,    60,     0,   344,   476,    88,
      48,   289,   228,    57,   235,   155,     0,   763,    60,   304,
     789,   789,   487,   789,   789,    60,   789,    60,    54,   234,
     287,   122,   487,    26,   648,   645,   652,   653,   622,   624,
     634,   628,   636,    39,    60,   420,     0,   730,     0,   751,
     695,   742,   789,   704,   703,   705,   705,   425,   701,   705,
     732,   705,   729,   705,     0,   789,   789,   371,   373,   465,
      89,   465,   322,     0,   789,   110,   340,   789,   789,   789,
       0,   789,     0,   502,   502,     0,     0,     0,     0,    96,
     781,   789,     0,     0,    94,   391,   789,    17,   600,   395,
     394,     0,     0,     0,   405,   407,     0,    84,     0,   494,
       0,   361,   501,     0,   362,   487,     0,     0,     0,     0,
     487,   369,   755,    79,   477,   478,     0,     0,     0,   789,
       0,     0,   292,   299,   347,   720,     0,   412,   414,   416,
     419,   696,     0,   716,     0,   713,     0,   708,     0,   710,
     718,    62,   274,     0,     0,    26,    26,   317,   320,     0,
       0,     0,     0,   766,   767,    60,   766,   767,     0,     0,
     268,    53,   232,    52,   233,    97,     0,    50,   230,    51,
     231,   601,   602,   789,   603,   789,    14,   408,     0,   354,
     355,   495,     0,     0,   502,   359,   363,     0,   686,   365,
       0,   720,   467,   470,     0,     0,     0,   705,   705,   705,
     705,    59,   273,   789,   789,   321,    43,    64,   290,   487,
     592,   598,   565,     0,     0,     0,   502,    60,   502,   553,
     637,     0,   591,    74,   511,   517,   519,   521,   515,   514,
     549,   516,   558,   561,   564,   570,   571,   560,   524,   572,
     525,   577,   578,   579,   582,   583,   584,   585,   586,   588,
     587,   589,   590,   568,    72,    49,   229,     0,     0,   605,
     392,     0,    18,   607,     0,     0,     0,   496,   789,     0,
     367,    60,     0,   651,   650,   649,   417,   714,   709,     0,
     706,   711,    60,     0,   454,   453,     0,   580,   581,   142,
     596,     0,   541,    60,   542,   546,    60,     0,   536,     0,
     789,   539,   552,     0,   593,     0,   594,     0,   512,     0,
       0,   559,   563,   575,   576,     0,   502,   502,     0,     0,
     567,     0,   604,     0,   679,   680,   332,     0,     4,    15,
     789,   497,   499,   500,   498,     0,   508,   457,     0,   472,
       0,   468,   705,   789,   789,   452,   434,   437,    60,     0,
     729,   437,   737,   426,   437,   431,   491,   493,    60,   534,
     556,   544,   543,   535,   547,   782,   537,   566,    60,   518,
     513,   549,   520,   550,   554,   637,   562,   557,   573,   574,
     597,   523,   533,   522,   529,    60,    60,    60,    60,    60,
      60,   340,     0,   789,     0,   789,   606,   789,   406,   504,
       0,     0,     0,   469,     0,     0,   707,   430,     0,   429,
       0,   448,     0,   455,     0,   432,   443,   445,     0,   736,
       0,   450,   540,     0,   548,     0,   595,     0,     0,     0,
     526,   527,   528,   530,   531,   532,   771,   339,    60,   766,
     767,   599,    16,     0,   509,   510,   461,    60,   459,   462,
       0,   471,   427,   789,   436,   435,   437,   437,   456,   433,
     437,   437,   340,     0,   437,   545,    60,   550,   551,   555,
     487,   789,     0,   458,   473,   428,     0,   449,     0,   446,
       0,   440,     0,   442,   771,   339,   451,     0,   538,   506,
     507,   505,   460,   437,   437,   437,   437,   447,   441,     0,
     438,   444,   437,   439
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1131, -1131, -1131,   -86,  1039, -1131,  1044, -1131,   882, -1131,
   -1131,  -540, -1131,   -43,   218,   868, -1131,     7, -1131, -1131,
      14,    27,  -514,   115,  -415,    82, -1131, -1131,   515,  2393,
   -1131,  2978,   -66, -1131, -1131,   -60,   -22, -1131,  -386,  1304,
     -12,  1274,  -155,    16,   -55, -1131,  -420,     4,  3359,  -395,
    1273,   -42,    -2, -1131, -1131,    -5, -1131,  4318,  -510,  1286,
   -1131,  1293,   897,   433,  2909, -1131,   395,   -16,   708,  -346,
     105, -1131,   -34,  -378,  -199,   112,  -384, -1131,  -536,   -50,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,   872,
   -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131, -1131,
   -1131, -1131, -1131, -1131, -1131,   443, -1131,  -521,  1689,  2188,
    -368, -1131,   205,  -775, -1131,  -795,  -805,   661,   510,  -414,
   -1131,   199, -1131,   268, -1131, -1130,   140,   255, -1131,   348,
   -1131, -1013, -1131,    91,    18,  -264,  -104, -1131, -1131,   360,
   -1131, -1131, -1131,   566, -1131, -1131,  -105, -1131,  -519, -1131,
    1067, -1131,  -757, -1131,  -726,  -508,  -503, -1131,    95, -1131,
   -1131,  -892,  -403, -1131, -1131, -1131, -1131,   266, -1131,  -232,
   -1131,  -856,  -916,  -975,  -581, -1049, -1034, -1131,   265, -1131,
   -1131,  -740,   267, -1131,  -600,   272, -1131, -1131, -1131,   188,
   -1131, -1131,   190,   756,  1209, -1131,  1327,  1695,  1878,    23,
   -1131,  2079, -1131,   911, -1131,  2666, -1131, -1131,  2885, -1131,
    2972, -1131, -1131,   -51, -1131, -1131,  -150, -1131, -1131, -1131,
   -1131, -1131, -1131,    20, -1131, -1131, -1131, -1131,    15,   -46,
    3161,    -1,  1338,  3481,  2519, -1131, -1131,    38,   732,     3,
   -1131, -1131,  -299,  -671,   691,  -434,  -322,  -191, -1106,  -526,
    -254,  -732,   162,  -449,   697,   185,  -439, -1131,  -720, -1131,
    -712, -1131,  -464,  -528, -1131, -1131, -1131,    47,  -370,  -313,
    -185, -1131, -1131,   -73, -1131,  -111,   -13,   138,  -227,   -57,
     -63,    55
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,   321,    69,    70,    71,   256,   257,  1114,
    1247,   637,  1025,   638,   275,   276,   488,   215,    72,   480,
     277,    74,   761,   473,   789,    75,   609,   595,   430,   227,
     846,   228,   393,   395,   947,   396,    78,    79,   585,   263,
      81,    82,   278,    83,    84,    85,   507,    86,   230,   413,
     414,   209,   210,   211,   674,   624,   213,    88,   764,   383,
      89,   537,   483,   538,   232,   282,   794,   625,   812,   466,
     467,   247,   248,   234,   456,   630,   236,   782,   783,    90,
     390,   494,   829,   646,   839,   837,   662,   578,   581,   265,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     344,   347,   936,  1111,   826,   941,   942,   776,   266,   267,
     640,   821,   943,   944,   405,   736,   737,   738,   739,   555,
     749,   750,  1194,  1304,  1266,  1196,  1197,  1261,  1198,  1133,
    1134,  1188,  1297,  1298,   513,   719,   873,   302,  1122,   104,
    1042,  1191,  1254,   348,   105,   106,   345,   582,   583,   586,
     587,   950,   827,  1184,   923,  1008,   798,  1293,   830,  1341,
    1185,  1073,  1210,  1075,  1076,  1168,  1169,  1077,  1275,  1143,
    1144,  1145,  1079,  1080,  1223,  1147,  1081,  1082,  1083,  1084,
    1085,   556,  1087,  1088,  1089,  1090,  1091,  1092,  1093,   937,
    1023,  1108,  1112,   107,   108,   109,   110,   111,   112,   311,
     113,   114,   525,   723,   115,   116,   527,   117,   118,   119,
     120,   526,   528,   304,   308,   309,   518,   721,   720,   874,
     976,  1125,   875,   121,   122,   305,   123,   124,   125,   126,
     238,   239,   129,   240,   241,   838,   658,   333,   334,   335,
     336,   557,   893,   559,   560,   747,   561,   562,   563,   564,
     902,   566,   567,   568,   569,  1203,   570,   571,   572,   573,
     574,   575,   576,   742,   433,   663,   287,   470,   243,   132,
     704,   628,   666,   661,   439,   475,   807,  1151,   498,   641,
     400,   259
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     128,   440,   212,   229,   229,   246,   297,   323,   307,   274,
     281,   398,   306,   322,   579,    73,   303,   656,   389,   900,
     216,   217,   212,   740,   892,   253,   642,   214,   394,   745,
     353,   399,   438,   558,   896,   297,   397,   558,   765,   901,
     322,   769,   629,   464,   946,   316,   343,   214,   297,   297,
     297,   128,   128,   212,   469,   300,   133,   500,   795,   431,
     296,   502,   242,   242,   342,   772,   767,   777,   279,   436,
     768,   683,   953,   924,   626,   894,   626,   682,   565,   324,
     339,   315,   565,   980,   300,   682,   312,   313,   314,   713,
     229,   978,  1123,   692,   639,  1212,   212,   407,   417,   417,
     417,   284,   288,  -132,   330,   331,   799,   280,   280,   285,
     289,  1224,   683,   687,  -133,   338,   815,  1104,   489,  1199,
     233,   244,   844,   823,   824,  -140,   626,   235,   235,   692,
    1305,   337,   337,   752,  1237,  1240,  -139,   639,  1165,  -132,
     758,   251,  -681,   254,   940,   626,  1299,   626,   134,   242,
    1157,  1146,  1078,  1078,   828,  -135,   725,   774,   521,   523,
    -682,   249,  -136,   729,   460,   716,   283,   493,   768,  1211,
     340,   785,   626,   626,   450,   392,   392,  -132,   274,   392,
    -789,  -137,  -673,  1221,   462,  1262,  -138,   654,   255,   491,
    -134,   655,   486,  -133,  1166,  -133,   590,   626,  1167,   626,
    1305,   271,   627,   332,   636,  1158,   820,   434,   740,   885,
     726,  -673,   492,  1124,   235,   775,  1299,   730,   322,  -140,
     128,   310,   249,  -136,  1224,   512,  1034,  1186,  1224,  1319,
     274,   339,  -140,   229,  -123,   229,   319,  1032,   506,  -139,
    1126,  1316,   320,   297,   907,  -124,   246,   342,   908,  -135,
     900,   978,  1236,  1239,   671,   128,  -131,   850,   853,   533,
     534,   535,   536,  1078,   842,   451,   452,  -130,  1086,  1086,
      73,   464,   128,   627,  1049,   636,   280,   889,   346,   319,
     889,  -132,   337,   337,   928,   320,  -126,  -132,  1319,   279,
     457,   868,   300,  -127,   242,  -766,   341,   457,   339,   959,
     471,   705,   297,  1318,   833,   891,   951,   505,   274,   954,
     683,   133,  -128,   647,   843,   894,   682,  -129,   682,  -767,
    1189,  -125,   128,   961,   668,   952,   692,   705,   280,   643,
    1157,   651,   474,   476,   319,  -133,   626,    73,   626,  1157,
     320,  -133,   322,  1182,   249,   653,   626,   250,   626,  -104,
     128,   300,   472,   644,   645,   693,   592,   468,   695,   235,
     740,  1183,   740,   698,   981,  -136,   915,   279,  -766,   340,
    -118,  -136,   356,   635,  -140,   724,   229,   724,   708,  1086,
    -140,  -139,  -138,   249,   634,  -556,  -137,  -139,   -60,   128,
     991,  -135,   514,   249,   992,   128,   128,  -135,   497,   497,
    1022,   514,  -134,   497,   349,   503,   280,   392,   392,   392,
     392,   675,   539,   540,   350,  1190,  1009,  1037,  -681,   929,
    1204,  1086,  1029,   229,   683,  1030,    59,   934,  1086,  1086,
     682,   354,  1035,   863,   634,  1036,   861,   864,  1039,   380,
     381,   382,   442,   471,   635,   280,  -139,   229,   516,   517,
     748,   280,   280,  -132,   506,   634,   992,   516,   517,   297,
    1217,   983,   985,  1137,  1138,   987,   705,   989,  -135,   990,
     635,  -138,  -137,   444,  -123,   212,   705,   392,   699,   784,
     443,   634,   242,   654,   870,   859,  -682,  1139,   310,   732,
     250,   128,   565,   392,  -767,   341,   635,   565,  -127,   229,
     214,   245,   684,   865,   969,   514,   909,   634,   300,   911,
     487,  1011,  1013,  -126,   471,  -140,  1120,  1017,  1019,   740,
     740,  -133,   766,   457,  -138,   457,  1119,  -767,  -137,   683,
    -138,   128,   446,   900,  -137,  1086,   506,   128,  1303,  -134,
     667,   297,  -124,   711,  -134,  -139,  1339,   235,  1307,   453,
    -134,   319,   733,  1311,   809,  -378,   847,   320,  1141,   515,
    1150,   516,   517,  1228,  1229,   762,   471,   779,   762,  1103,
    1103,  1062,   790,   879,   -60,  1005,   249,   128,   879,   454,
     128,   249,  1033,  -378,  -378,   -60,   822,   280,   455,  -135,
     300,   547,   836,   805,   900,   682,  1207,   817,   461,   819,
     770,  1105,   813,   692,   773,  1074,  1074,   626,  -127,   626,
     743,   804,   743,  1127,  1128,  1130,  1131,   443,  1345,   810,
     811,   788,   551,  -126,   330,   331,  1225,   887,  -127,  -127,
     463,  -766,  -127,   280,  -672,   635,   280,   849,   229,   128,
    -378,   128,   931,  -126,  -126,   635,   634,  -126,   229,   481,
     790,   790,  -140,  1043,  -137,   811,   634,   871,  1231,  1233,
    1115,   128,   297,  -672,  1142,  1257,  1259,   859,  1205,   212,
    1140,   356,   855,  -131,   862,   876,   558,  -134,   552,  -339,
    1103,  1162,   245,  1202,   790,   457,   754,   435,   804,   811,
     490,   814,  1315,  -128,   214,   280,  1317,   280,  -125,   788,
     788,   781,   477,   872,   755,   471,   781,  -339,  -339,   754,
     553,   300,   478,   479,  1300,   471,  1074,   280,  1193,  1121,
    -103,   565,  1103,   922,  -674,   800,   814,  1170,  -675,  1103,
    1103,   506,   565,   788,   962,   627,   297,   636,  1208,   457,
    1177,   866,   558,   964,   806,   845,   878,  -677,   880,   385,
     495,   881,   882,  -674,   972,  1142,   974,  -675,  1256,   940,
     814,   825,   385,  -676,  -339,  1142,  1142,   501,  -767,   385,
    1230,   385,   958,   977,   504,  1325,  -677,   386,   387,  1324,
     957,  -678,   867,   514,   385,   300,   332,   565,   514,   522,
     386,   458,  -676,   956,   889,   509,  1205,   386,   485,   386,
     437,  1205,   806,  -128,   431,   995,  1205,   996,  -125,  1202,
    -678,  1202,   386,   510,  -679,   524,  1202,  1249,  -766,   891,
     955,  1202,   532,  -128,  -128,   577,   497,  -128,  -125,  -125,
     960,   806,  -125,   529,   388,   128,  1103,   519,   128,   516,
     517,   212,  -679,  -679,   516,   517,  1193,   459,  -688,    36,
      37,  1193,    39,  -669,   459,   866,  1193,  -670,   580,    45,
      46,  -669,  1205,   593,  1205,   584,  1205,  -680,  1205,   511,
     530,   938,   945,    91,   945,   904,  1028,  1202,  1200,  1202,
     975,  1202,  -669,  1202,   664,  1205,  -670,   237,   237,  -669,
    -669,   280,   762,   648,   280,  -680,  -680,  1288,  1027,  -679,
    1202,  1038,   249,   496,   790,   790,   635,   514,   895,   229,
     790,   790,  1193,   665,  1193,   652,  1193,   634,  1193,   903,
     392,   457,   249,   499,    91,    91,  1220,   694,   298,   626,
     657,   626,   677,  1044,   678,  1193,  1235,  1238,   696,   237,
     128,  -118,   939,   940,  -766,   487,  -669,   743,   806,  -332,
    -766,  -424,  -680,   788,   788,   697,   128,   298,   806,   788,
     788,   520,   809,   516,   517,   237,   237,  1163,  1164,   237,
     404,   415,   415,   966,   237,   128,   471,  -332,  -332,   790,
    -139,   514,   702,   541,   710,   542,   543,   544,   545,   546,
    1118,  1024,  1059,   514,   790,   810,   280,  -135,   128,   128,
     626,  -130,  1053,  1054,   514,   712,  1200,  1102,  1102,   547,
    -767,  1200,   280,  1056,  1057,  1250,  1251,   385,  -126,  1153,
     249,  1322,   741,   548,   392,  1156,   508,   508,   788,   744,
    -137,   280,   128,   549,  -332,   722,   771,   516,   517,   931,
     551,   552,   746,   788,   751,   386,   649,   519,   781,   516,
     517,  -128,   676,  -670,  1148,   756,  1234,   297,   727,   705,
     516,   517,  1102,  1102,   757,   759,  1102,   852,   854,   786,
     808,  1179,  1180,   553,  -134,   385,  1200,   818,  1109,   825,
    1113,  -670,  -670,  1102,  -771,   852,   854,   883,   280,  1218,
    1206,   828,  1246,    91,   897,  -125,   886,  1272,   888,   905,
    1244,   869,   650,   386,   659,   906,  1175,  1276,  1135,  1135,
     128,   910,  -312,   128,   128,   492,   913,   237,  1102,   237,
     806,   322,   237,   237,  1280,  1281,  1282,  -771,    91,   914,
    1209,   916,   128,  1213,  1245,   128,  -767,   917,  -670,   918,
    1102,   930,  -767,  1102,   925,    91,  1047,  1255,  1048,  -340,
    1050,   935,   297,  1232,   940,  -771,  -771,  1102,  1102,  1102,
     660,   514,  1102,  1102,   973,   298,   280,  1102,  1102,   280,
     280,   755,   982,   945,  1279,   356,   128,  -340,  -340,   385,
     984,   986,   806,  1149,  1294,  1295,   988,  -316,   280,   128,
    1015,   280,  1045,   385,  1046,    91,  -314,   237,   237,   237,
     237,   417,   237,   237,  1107,  1110,  1129,   386,   920,  1132,
    -771,  1152,  -771,  1159,   297,   519,  -766,   516,   517,  1160,
    1217,   386,  1242,    91,   298,  1283,  1284,  1285,   635,  1215,
    1161,   229,   280,  1214,  -340,   945,  1187,   392,  1060,   634,
     378,   379,   380,   381,   382,   280,  1157,  1187,   743,   743,
    1321,   869,  1252,   128,  1241,  1253,   361,   362,   806,  1301,
     237,   806,    91,   417,   921,   546,  1263,   237,    91,    91,
    1258,  1260,  1102,  1265,  1270,  1320,  1102,  1102,  1243,  1273,
    1312,   806,  1308,   237,   541,   547,   542,   543,   544,   545,
     546,  1192,   128,  1274,  1201,   484,  1277,   385,   471,  -766,
     938,  1154,  1113,    36,    37,    80,    39,   237,  1278,   280,
     547,   373,   374,  1187,  1326,  -767,   551,   552,  1328,    80,
      80,  1012,  1014,   258,   548,   386,  1313,  1018,  1020,  1178,
    1330,   237,   392,   392,   549,  1332,  1102,  1337,   993,   994,
     550,   551,   552,    40,    41,    42,    43,   999,   280,   553,
    1000,  1155,  1002,   806,   806,   806,    80,    80,   743,  1349,
     709,   963,  1012,  1014,    91,  1018,  1020,   531,  1072,  1072,
     707,    80,   402,   419,   553,   384,   945,   554,   700,   848,
    1026,   298,   660,   237,   541,  1248,   542,   543,   544,   545,
    1041,    22,    23,    24,    25,   884,   979,    80,    80,  1264,
    1195,    80,  1136,   806,    91,  1310,    80,    31,    32,    33,
      91,  1106,  1323,  1342,   588,   965,  1340,    40,    41,    42,
      43,    44,  1306,  1072,  1072,  1222,  1226,  1072,  1227,  1219,
     356,  1149,  1314,  1291,   734,  1106,   441,  1292,   728,   432,
     735,   890,   899,  1302,  1072,     0,     0,   369,   370,   237,
      91,     0,   237,    91,  1338,     0,  1267,     0,     0,  1271,
       0,   237,     0,   298,     0,     0,   796,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,  1072,
       0,     0,     0,   541,     0,   542,   543,   544,   545,   546,
    1343,     0,  1344,     0,  1346,   378,   379,   380,   381,   382,
       0,  1072,     0,     0,  1072,     0,   292,     0,     0,   547,
       0,  1352,    91,     0,    91,     0,     0,     0,  1072,  1072,
    1072,     0,   237,  1072,  1072,    80,     0,     0,  1072,  1072,
       0,     0,   237,   549,    91,   237,     0,     0,     0,   550,
     551,   552,     0,     0,   796,   796,     0,   482,     0,    80,
       0,    80,     0,     0,    80,    80,     0,   356,     0,     0,
      80,  1327,  1329,     0,     0,  1331,  1333,     0,     0,  1336,
       0,     0,   237,   553,   369,   370,   554,    80,   796,     0,
       0,     0,     0,     0,   298,     0,   249,    22,    23,    24,
      25,   541,     0,   542,   543,   544,   545,     0,  1347,  1348,
    1350,  1351,     0,    31,    32,    33,  1060,  1353,     0,     0,
    1061,     0,     0,    40,    41,    42,    43,    44,     0,   375,
     376,   377,   378,   379,   380,   381,   382,    80,     0,    80,
      80,    80,    80,  1072,    80,    80,     0,  1072,  1072,     0,
       0,   734,   589,     0,     0,  1063,  1064,   594,   325,   326,
     327,   328,   329,  1065,     0,    80,  1066,   356,   298,  1067,
    1068,     0,  1069,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,   369,   370,     0,     0,     0,     0,
     541,     0,   542,   543,   544,   545,   546,     0,     0,     0,
     102,     0,    80,     0,    80,  1071,     0,  1072,     0,    80,
      80,    80,   292,     0,   102,   102,   547,     0,    91,   249,
     237,    91,     0,     0,   541,    80,   542,   543,   544,   545,
       0,   377,   378,   379,   380,   381,   382,     0,     0,  1296,
     549,   542,   543,   544,   545,   672,   673,   551,   552,    80,
       0,   102,   102,     0,     0,   541,   679,   542,   543,   544,
     545,   546,     0,     0,   690,   691,   102,     0,     0,     0,
       0,     0,     0,    80,  1094,  1094,     0,     0,     0,     0,
     553,   547,     0,     0,   482,     0,   237,     0,     0,     0,
     706,     0,   102,   102,     0,   548,   102,     0,     0,     0,
       0,   102,     0,   237,     0,   549,    80,     0,   796,   796,
       0,   550,   551,   552,   796,   796,   541,     0,   542,   543,
     544,   545,   546,    91,   237,    80,     0,     0,     0,  1094,
    1094,     0,     0,  1094,     0,     0,     0,     0,     0,    91,
       0,     0,   547,     0,     0,   553,    80,     0,   554,     0,
    1094,     0,    80,     0,     0,     0,     0,     0,    91,     0,
       0,     0,     0,     0,     0,     0,   549,     0,     0,     0,
       0,     0,   550,   551,   552,     0,     0,     0,     0,     0,
       0,    91,    91,   796,     0,  1094,     0,     0,     0,     0,
       0,    80,    80,     0,    80,    80,     0,     0,   796,     0,
       0,     0,     0,    80,     0,     0,   553,  1094,    80,   554,
    1094,     0,     0,     0,     0,    91,     0,     0,     0,     0,
     102,     0,     0,     0,  1094,  1094,  1094,     0,     0,  1094,
    1094,     0,     0,     0,  1094,  1094,     0,     0,     0,     0,
       0,   816,     0,     0,   102,     0,   102,     0,     0,   102,
     102,     0,     0,     0,    80,   102,    80,     0,     0,     0,
       0,     0,     0,     0,    80,     0,     0,     0,     0,     0,
       0,     0,   102,     0,    80,     0,    80,    80,   856,     0,
       0,     0,    22,    23,    24,    25,    80,    80,     0,  1173,
       0,     0,     0,    91,     0,     0,    91,    91,    31,    32,
      33,  1060,     0,     0,     0,  1061,     0,     0,    40,    41,
      42,    43,    44,     0,    80,    91,     0,     0,    91,     0,
      80,     0,   102,     0,   102,   102,   102,   102,     0,   102,
     102,     0,     0,     0,     0,     0,     0,   237,     0,  1094,
    1063,  1064,     0,  1094,  1094,     0,     0,     0,  1065,     0,
     102,  1066,     0,     0,  1067,  1068,     0,  1069,     0,    91,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
       0,     0,    91,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1269,     0,     0,   102,     0,   102,
    1071,     0,     0,     0,   102,   102,   102,   292,     0,     0,
       0,     0,     0,  1094,   926,   927,     0,     0,     0,     0,
     102,     0,   932,   933,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   237,     0,     0,     0,     0,
       0,     0,   237,   237,   102,     0,    91,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1309,     0,     0,     0,
      80,     0,    80,    80,     0,     0,     0,     0,   102,     0,
       0,     0,     0,   967,   968,     0,   970,   971,     0,     0,
       0,     0,     0,     0,     0,    91,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   102,     0,     0,     0,     0,     0,     0,     0,   103,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     102,     0,     0,   103,   103,     0,     0,     0,    80,     0,
       0,  1001,     0,     0,     0,     0,     0,  1095,  1095,     0,
       0,   102,     0,     0,  1016,    80,     0,   102,     0,     0,
      80,    80,     0,     0,     0,     0,    80,    80,     0,     0,
     103,   103,     0,     0,     0,    80,    80,   356,   357,   358,
     359,   360,   361,   362,   363,   103,   365,   366,     0,     0,
       0,    80,  1040,     0,   369,   370,   102,   102,     0,   102,
     102,     0,  1095,  1095,     0,     0,  1095,     0,   102,     0,
      80,   103,   103,   102,     0,   103,     0,     0,     0,     0,
     103,     0,     0,  1095,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    80,    80,    80,     0,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,     0,     0,     0,
      80,     0,     0,     0,     0,     0,     0,     0,  1095,   102,
       0,   102,     0,     0,     0,     0,     0,    80,     0,   102,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   102,
    1095,   102,   102,  1095,     0,     0,     0,     0,     0,     0,
       0,   102,   102,     0,     0,     0,     0,  1095,  1095,  1095,
       0,     0,  1095,  1095,     0,     0,     0,  1095,  1095,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   102,
       0,     0,     0,     0,    76,   102,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   103,
       0,     0,     0,     0,     0,    80,     0,     0,    80,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   103,     0,   103,     0,    80,   103,   103,
      80,     0,     0,  1216,   103,    76,    76,     0,     0,   294,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    80,
       0,   103,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   294,     0,
       0,    80,  1095,     0,     0,     0,  1095,  1095,     0,     0,
       0,   294,   294,   294,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   103,     0,   103,   103,   103,   103,     0,   103,   103,
     131,     0,     0,     0,     0,   102,     0,   102,   102,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   103,
       0,     0,     0,     0,     0,     0,  1095,    80,     0,     0,
       0,     0,     0,     0,    80,    80,     0,     0,    80,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   131,   131,     0,     0,   301,   103,     0,   103,     0,
       0,     0,     0,   103,   103,   103,     0,     0,     0,     0,
       0,     0,     0,   102,     0,     0,     0,    80,     0,   103,
       0,     0,     0,     0,   301,     0,     0,     0,     0,     0,
     102,     0,     0,     0,    76,   102,   102,   408,   418,   418,
       0,   102,   102,   103,     0,     0,     0,     0,     0,     0,
     102,   102,     0,   919,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   102,   103,     0,    76,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   102,    76,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     103,     0,     0,     0,   369,   370,   294,     0,   102,   102,
     102,     0,     0,     0,     0,     0,     0,     0,     0,   103,
       0,     0,     0,  1096,  1096,   102,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,     0,     0,     0,
     103,     0,   102,     0,     0,   372,   103,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,     0,     0,     0,
     131,     0,     0,     0,    76,   294,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1096,  1096,
       0,     0,  1096,     0,     0,   103,   103,     0,   103,   103,
       0,     0,     0,     0,     0,   131,     0,   103,     0,  1096,
       0,     0,   103,    76,     0,     0,     0,     0,     0,    76,
      76,     0,   131,     0,     0,     0,     0,     0,     0,     0,
     102,     0,     0,   102,   102,     0,     0,     0,     0,     0,
       0,     0,   301,     0,  1096,     0,     0,     0,     0,     0,
       0,     0,   102,     0,     0,   102,     0,     0,   103,     0,
     103,     0,     0,     0,     0,     0,  1096,     0,   103,  1096,
       0,     0,   131,     0,   102,     0,     0,     0,   103,     0,
     103,   103,     0,  1096,  1096,  1096,     0,     0,  1096,  1096,
     103,   103,     0,  1096,  1096,     0,   102,     0,     0,     0,
     131,   301,     0,     0,     0,     0,     0,     0,     0,   102,
       0,     0,     0,     0,     0,    76,  1097,  1097,   103,     0,
       0,     0,     0,     0,   103,     0,     0,     0,     0,     0,
       0,     0,   294,     0,     0,     0,     0,     0,     0,   131,
       0,     0,     0,     0,     0,   131,   131,     0,     0,     0,
       0,     0,     0,     0,     0,    76,     0,     0,     0,     0,
       0,    76,   102,     0,     0,     0,     0,     0,     0,   102,
     102,  1097,  1097,   102,     0,  1097,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1097,     0,   286,     0,     0,     0,  1096,     0,
       0,    76,  1096,  1096,    76,     0,     0,     0,     0,    77,
       0,     0,   102,     0,   294,     0,     0,    76,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1097,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   131,     0,     0,     0,     0,     0,     0,     0,  1097,
       0,     0,  1097,     0,   103,     0,   103,   103,   301,     0,
      77,    77,  1096,    76,   295,    76,  1097,  1097,  1097,     0,
       0,  1097,  1097,     0,     0,     0,  1097,  1097,     0,     0,
       0,   131,     0,     0,     0,    76,     0,   131,     0,     0,
       0,     0,     0,   295,     0,    76,    76,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   295,   295,   295,     0,
       0,     0,     0,     0,     0,     0,     0,  1098,  1098,     0,
       0,     0,   103,     0,     0,     0,     0,   131,     0,    76,
     131,     0,     0,     0,     0,   294,     0,     0,     0,   103,
     301,     0,     0,   797,   103,   103,     0,     0,     0,     0,
     103,   103,     0,     0,     0,     0,     0,     0,   445,   103,
     103,   447,   448,   449,     0,     0,     0,     0,     0,     0,
       0,     0,  1098,  1098,     0,   103,  1098,     0,     0,     0,
       0,  1097,     0,     0,     0,  1097,  1097,     0,     0,   131,
       0,   131,   127,  1098,   103,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   294,
       0,   131,     0,     0,     0,     0,     0,   103,   103,   103,
       0,   797,   797,     0,     0,     0,     0,     0,  1098,    77,
       0,     0,     0,     0,   103,     0,     0,     0,     0,     0,
       0,     0,     0,   127,   127,  1097,     0,   299,     0,     0,
    1098,   103,     0,  1098,     0,   797,     0,     0,     0,    76,
       0,   301,    76,     0,    77,     0,     0,  1098,  1098,  1098,
     877,     0,  1098,  1098,     0,     0,   299,  1098,  1098,     0,
       0,    77,     0,     0,     0,     0,     0,     0,     0,   406,
     416,   416,   416,     0,     0,     0,     0,     0,     0,  -789,
       0,   295,     0,     0,     0,     0,     0,  -789,  -789,  -789,
       0,     0,  -789,  -789,  -789,     0,  -789,     0,     0,     0,
       0,     0,     0,     0,  -789,  -789,  -789,     0,     0,   103,
       0,    77,   103,   103,     0,   301,  -789,  -789,     0,  -789,
    -789,  -789,  -789,  -789,     0,     0,     0,     0,     0,    76,
      76,   103,     0,     0,   103,    76,    76,     0,     0,    77,
     295,     0,     0,     0,    76,     0,     0,  -789,  -789,     0,
       0,     0,     0,   103,     0,     0,     0,     0,     0,     0,
      76,     0,  1098,     0,     0,   131,  1098,  1098,   131,     0,
      87,     0,     0,   680,   681,   103,  -789,  -789,    77,    76,
       0,     0,   286,     0,    77,    77,     0,     0,   103,     0,
       0,     0,   127,     0,     0,     0,     0,     0,     0,     0,
    -789,     0,    76,    76,    76,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   681,     0,     0,   286,    76,
       0,    87,    87,     0,     0,     0,  1098,   127,     0,     0,
       0,  -789,  -789,     0,  -789,     0,    76,   245,  -789,     0,
    -789,   103,     0,     0,   127,     0,     0,     0,   103,   103,
       0,     0,   103,     0,     0,   797,   797,     0,     0,     0,
       0,   797,   797,     0,   299,     0,     0,   403,     0,     0,
     131,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      77,     0,     0,     0,     0,     0,   131,   753,     0,     0,
       0,   103,   130,     0,   127,     0,     0,   295,     0,     0,
       0,     0,     0,     0,     0,   131,     0,     0,   780,     0,
     294,     0,     0,   793,    76,     0,     0,    76,    76,     0,
      77,     0,   127,   299,     0,     0,    77,     0,   131,   131,
     797,     0,     0,     0,     0,     0,    76,     0,     0,    76,
       0,     0,     0,   130,   130,   797,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   127,   131,     0,     0,     0,    77,   127,   127,    77,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   295,
      76,     0,    77,     0,     0,     0,     0,     0,     0,     0,
      87,     0,     0,    76,     0,   857,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   294,     0,     0,     0,     0,
       0,     0,     0,   681,     0,   286,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    87,     0,     0,    77,     0,
      77,     0,     0,     0,     0,     0,  1176,     0,     0,     0,
     131,     0,    87,   131,   131,     0,     0,     0,     0,     0,
      77,     0,     0,     0,     0,     0,     0,    76,     0,     0,
      77,    77,   131,   127,     0,   131,     0,   294,     0,   898,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     299,     0,     0,     0,  1099,  1099,     0,     0,     0,     0,
       0,     0,    87,     0,    77,     0,    76,   912,     0,     0,
     295,     0,     0,   127,     0,     0,   131,     0,     0,   127,
       0,     0,   130,     0,     0,     0,     0,     0,     0,   131,
      87,     0,     0,     0,     0,     0,     0,   681,     0,     0,
       0,   418,     0,     0,     0,     0,     0,     0,     0,  1099,
    1099,     0,     0,  1099,     0,   949,     0,   130,     0,   127,
       0,     0,   127,     0,     0,     0,     0,     0,     0,    87,
    1099,     0,   299,     0,   130,    87,    87,     0,     0,     0,
       0,     0,     0,     0,   295,     0,     0,     0,     0,     0,
       0,     0,     0,   131,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,     0,  1099,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   127,     0,   127,   130,     0,     0,  1099,     0,     0,
    1099,     0,   131,     0,    77,     0,     0,    77,     0,     0,
       0,     0,   998,   127,  1099,  1099,  1099,     0,     0,  1099,
    1099,     0,   130,     0,  1099,  1099,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1021,     0,     0,     0,     0,
       0,    87,     0,     0,     0,     0,     0,  1031,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   130,     0,   299,     0,     0,     0,   130,   130,     0,
       0,     0,   286,     0,     0,     0,     0,     0,     0,     0,
       0,    87,     0,  1100,  1100,     0,     0,    87,     0,     0,
       0,     0,     0,     0,    77,    77,  1055,     0,     0,     0,
      77,    77,     0,     0,     0,     0,     0,     0,     0,    77,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    77,     0,    87,     0,  1099,
      87,  1117,     0,  1099,  1099,     0,     0,   299,  1100,  1100,
       0,     0,  1100,   791,    77,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1100,
       0,     0,     0,   130,     0,     0,     0,    77,    77,    77,
    1101,  1101,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    77,     0,     0,   127,     0,    87,
     127,    87,     0,  1099,  1100,     0,     0,     0,     0,     0,
       0,    77,     0,   130,     0,     0,     0,     0,     0,   130,
       0,    87,     0,     0,     0,  1181,  1100,     0,     0,  1100,
       0,   791,   791,     0,     0,  1101,  1101,     0,     0,  1101,
       0,     0,     0,  1100,  1100,  1100,     0,     0,  1100,  1100,
       0,     0,     0,  1100,  1100,     0,  1101,     0,     0,   130,
       0,     0,   130,     0,     0,   791,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   295,     0,     0,     0,    77,
       0,  1101,    77,    77,     0,     0,     0,     0,     0,     0,
       0,     0,   127,     0,     0,     0,     0,     0,     0,     0,
       0,    77,     0,  1101,    77,     0,  1101,     0,   127,     0,
       0,   130,     0,   130,     0,     0,     0,     0,     0,     0,
    1101,  1101,  1101,     0,     0,  1101,  1101,   127,     0,     0,
    1101,  1101,     0,   130,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   130,   130,    77,     0,     0,  1100,     0,
     127,   127,  1100,  1100,     0,     0,     0,     0,    77,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     295,     0,     0,     0,     0,     0,     0,   130,     0,     0,
       0,     0,     0,     0,   127,    87,     0,     0,    87,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1100,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    77,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   295,     0,     0,  1101,     0,     0,     0,  1101,
    1101,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1174,     0,
       0,    77,   127,     0,     0,   127,   127,     0,     0,     0,
       0,     0,     0,     0,     0,   791,   791,     0,     0,     0,
       0,   791,   791,     0,   127,     0,     0,   127,     0,     0,
      87,     0,     0,     0,     0,     0,     0,     0,     0,  1101,
       0,     0,     0,     0,     0,     0,    87,   130,     0,     0,
     130,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   231,   231,    87,     0,     0,   127,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   127,     0,     0,     0,     0,     0,     0,    87,    87,
     791,     0,     0,   416,     0,   264,   268,   269,   270,     0,
       0,     0,   231,   231,     0,   791,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   317,   318,     0,     0,     0,
       0,     0,    87,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   130,   130,     0,
       0,     0,     0,   130,   130,   127,     0,     0,     0,     0,
     231,     0,   130,     0,     0,   416,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   127,     0,     0,   130,     0,     0,
       0,     0,     0,     0,     0,     0,  1172,     0,     0,     0,
      87,     0,     0,    87,    87,     0,     0,     0,     0,     0,
     130,   130,   130,     0,     0,     0,     0,     0,     0,     0,
    -486,     0,    87,     0,     0,    87,     0,   130,  -486,  -486,
    -486,     0,     0,  -486,  -486,  -486,     0,  -486,     0,     0,
       0,     0,     0,     0,   130,  -486,  -486,  -486,  -486,     0,
       0,     0,     0,     0,     0,     0,     0,  -486,  -486,     0,
    -486,  -486,  -486,  -486,  -486,     0,    87,   231,     0,     0,
     231,   231,   231,     0,   317,     0,     0,     0,     0,    87,
       0,     0,     0,     0,     0,     0,     0,     0,  -486,  -486,
       0,     0,     0,   231,     0,   231,     0,     0,  -486,  -486,
    -486,  -486,  -486,  -486,  -486,  -486,  -486,  -486,  -486,  -486,
    -486,     0,     0,     0,     0,  -486,  -486,  -486,  -486,     0,
       0,  -486,   130,     0,     0,   130,   130,  -486,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -486,     0,    87,   130,     0,     0,   130,     0,     0,
       0,     0,     0,     0,     0,     0,  -486,     0,  -486,  -486,
    -486,  -486,  -486,  -486,  -486,  -486,  -486,  -486,     0,     0,
       0,     0,  -486,  -486,  -486,  -486,  -486,     0,   245,  -486,
    -486,  -486,    87,     0,     0,     0,     0,     0,   130,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   130,     0,     0,   596,   597,   598,   599,   600,     0,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     610,     0,     0,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,     0,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   231,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   231,   231,   130,     0,     0,   231,     0,     0,
       0,   231,  -771,   270,     0,     0,     0,     0,     0,     0,
    -771,  -771,  -771,     0,     0,  -771,  -771,  -771,     0,  -771,
       0,   701,     0,     0,     0,     0,     0,  -771,  -771,  -771,
    -771,  -771,     0,     0,   231,     0,     0,   231,     0,  -771,
    -771,     0,  -771,  -771,  -771,  -771,  -771,     0,     0,   231,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   731,     0,     0,
    -771,  -771,     0,     0,     0,     0,     0,     0,     0,     0,
    -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,
    -771,  -771,  -771,     0,     0,     0,     0,  -771,  -771,  -771,
    -771,     0,   860,  -771,     0,     0,   231,     0,     0,  -771,
       0,     0,     0,     0,     0,   763,     0,     0,   763,     0,
       0,     0,     0,  -771,     0,     0,  -771,   231,     0,     0,
       0,     0,   792,     0,     0,     0,     0,  -136,  -771,  -771,
    -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,
       0,     0,     0,     0,  -771,  -771,  -771,  -771,  -771,     0,
       0,  -771,  -771,  -771,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     851,   851,     0,     0,   231,   763,   763,   851,     0,  -789,
       3,     0,     4,     5,     6,     7,     8,     0,   851,   851,
       9,    10,   231,     0,   231,    11,     0,    12,    13,    14,
      15,    16,    17,    18,   851,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,   272,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,   231,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,   231,     0,    51,     0,
       0,    52,    53,     0,    54,    55,     0,    56,     0,     0,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
    -789,     0,     0,     0,     0,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   355,     0,   231,     0,     0,    66,    67,    68,
       0,     0,     0,     0,  -789,     0,     0,     0,     0,     0,
    -789,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   851,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,     0,     0,
       0,     0,   369,   370,     0,     0,     0,     0,   371,     0,
       0,     0,   763,     0,     0,     0,     0,     0,     0,     0,
       0,   231,     0,     0,     0,     0,     0,     0,     0,   231,
       0,     0,     0,  1010,   851,   851,     0,     0,     0,     0,
     851,   851,     0,   372,   231,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   763,   851,   851,     0,   851,   851,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1051,  1052,     0,     0,   231,     0,     0,     0,   851,
    1058,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   851,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     231,     0,     0,     0,     0,     0,    -5,     3,   851,     4,
       5,     6,     7,     8,    -5,    -5,    -5,     9,    10,     0,
      -5,    -5,    11,    -5,    12,    13,    14,    15,    16,    17,
      18,    -5,     0,     0,     0,     0,    19,    20,    21,    22,
      23,    24,    25,     0,     0,    26,     0,     0,     0,     0,
       0,    27,    28,   272,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,    -5,     0,     0,     0,     0,     0,
       0,     0,    47,    48,   231,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,    50,     0,
       0,     0,     0,     0,     0,    51,     0,     0,    52,    53,
       0,    54,    55,     0,    56,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,    -5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    66,    67,    68,     0,     0,    -5,
       0,     0,     0,     0,     0,    -5,     0,   530,  -789,     3,
       0,     4,     5,     6,     7,     8,     0,     0,     0,     9,
      10,     0,     0,     0,    11,     0,    12,    13,    14,    15,
      16,    17,    18,     0,     0,     0,     0,     0,    19,    20,
      21,    22,    23,    24,    25,     0,     0,    26,     0,     0,
       0,   231,     0,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,     0,    40,    41,    42,
      43,    44,    45,    46,     0,     0,     0,   356,  -790,  -790,
    -790,  -790,   361,   362,    47,    48,  -790,  -790,     0,     0,
       0,     0,     0,     0,   369,   370,     0,     0,     0,    49,
      50,     0,     0,     0,     0,     0,     0,    51,     0,     0,
      52,    53,     0,    54,    55,     0,    56,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    66,    67,    68,     0,
       0,    -5,     3,  -789,     4,     5,     6,     7,     8,  -789,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,     0,     0,     0,     0,     0,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,    53,     0,    54,    55,     0,    56,
       0,     0,    57,    58,    59,    60,    61,    62,    63,    64,
      65,     0,     0,     0,     0,     0,     0,     0,  -669,     0,
       0,     0,     0,     0,     0,     0,  -669,  -669,  -669,     0,
       0,  -669,  -669,  -669,     0,  -669,     0,     0,     0,    66,
      67,    68,     0,  -669,    -5,  -669,  -669,  -669,     0,     0,
       0,     0,   530,     0,     0,  -669,  -669,     0,  -669,  -669,
    -669,  -669,  -669,     0,     0,     0,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,     0,
       0,     0,     0,   369,   370,     0,  -669,  -669,     0,     0,
       0,     0,     0,     0,     0,     0,  -669,  -669,  -669,  -669,
    -669,  -669,  -669,  -669,  -669,  -669,  -669,  -669,  -669,     0,
       0,     0,     0,  -669,  -669,  -669,  -669,     0,  -669,  -669,
       0,     0,     0,     0,   372,  -669,   373,   374,   375,   376,
     377,   378,   379,   380,   381,   382,     0,     0,     0,  -669,
       0,     0,  -669,   249,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -669,  -669,  -669,  -669,  -669,  -669,  -669,
    -669,  -669,  -669,  -669,  -669,  -669,     0,     0,     0,     0,
       0,  -669,  -669,  -669,  -669,  -670,     0,  -669,  -669,  -669,
       0,     0,     0,  -670,  -670,  -670,     0,     0,  -670,  -670,
    -670,     0,  -670,     0,     0,     0,     0,     0,     0,     0,
    -670,     0,  -670,  -670,  -670,     0,     0,     0,     0,     0,
       0,     0,  -670,  -670,     0,  -670,  -670,  -670,  -670,  -670,
       0,     0,     0,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,     0,     0,     0,     0,
     369,   370,     0,  -670,  -670,     0,     0,     0,     0,     0,
       0,     0,     0,  -670,  -670,  -670,  -670,  -670,  -670,  -670,
    -670,  -670,  -670,  -670,  -670,  -670,     0,     0,     0,     0,
    -670,  -670,  -670,  -670,     0,  -670,  -670,     0,     0,     0,
       0,   372,  -670,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,     0,     0,     0,  -670,     0,     0,  -670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -670,  -670,  -670,  -670,  -670,  -670,  -670,  -670,  -670,  -670,
    -670,  -670,  -670,     0,     0,     0,     0,     0,  -670,  -670,
    -670,  -670,  -772,     0,  -670,  -670,  -670,     0,     0,     0,
    -772,  -772,  -772,     0,     0,  -772,  -772,  -772,     0,  -772,
       0,     0,     0,     0,     0,     0,     0,  -772,  -772,  -772,
    -772,  -772,     0,     0,     0,     0,     0,     0,     0,  -772,
    -772,     0,  -772,  -772,  -772,  -772,  -772,     0,     0,     0,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,  -790,  -790,     0,     0,     0,     0,   369,   370,     0,
    -772,  -772,     0,     0,     0,     0,     0,     0,     0,     0,
    -772,  -772,  -772,  -772,  -772,  -772,  -772,  -772,  -772,  -772,
    -772,  -772,  -772,     0,     0,     0,     0,  -772,  -772,  -772,
    -772,     0,     0,  -772,     0,     0,     0,     0,     0,  -772,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
       0,     0,     0,  -772,     0,     0,  -772,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -772,  -772,
    -772,  -772,  -772,  -772,  -772,  -772,  -772,  -772,  -772,  -772,
       0,     0,     0,     0,  -772,  -772,  -772,  -772,  -772,  -773,
       0,  -772,  -772,  -772,     0,     0,     0,  -773,  -773,  -773,
       0,     0,  -773,  -773,  -773,     0,  -773,     0,     0,     0,
       0,     0,     0,     0,  -773,  -773,  -773,  -773,  -773,     0,
       0,     0,     0,     0,     0,     0,  -773,  -773,     0,  -773,
    -773,  -773,  -773,  -773,     0,     0,     0,   356,   357,   358,
     359,   360,   361,   362,     0,     0,   365,   366,     0,     0,
       0,     0,     0,     0,   369,   370,     0,  -773,  -773,     0,
       0,     0,     0,     0,     0,     0,     0,  -773,  -773,  -773,
    -773,  -773,  -773,  -773,  -773,  -773,  -773,  -773,  -773,  -773,
       0,     0,     0,     0,  -773,  -773,  -773,  -773,     0,     0,
    -773,     0,     0,     0,     0,     0,  -773,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,     0,     0,     0,
    -773,     0,     0,  -773,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -773,  -773,  -773,  -773,  -773,
    -773,  -773,  -773,  -773,  -773,  -773,  -773,     0,     0,     0,
       0,  -773,  -773,  -773,  -773,  -773,  -333,     0,  -773,  -773,
    -773,     0,     0,     0,  -333,  -333,  -333,     0,     0,  -333,
    -333,  -333,     0,  -333,     0,     0,     0,     0,     0,     0,
       0,  -333,     0,  -333,  -333,  -333,     0,     0,     0,     0,
       0,     0,     0,  -333,  -333,     0,  -333,  -333,  -333,  -333,
    -333,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -333,  -333,     0,     0,     0,     0,
       0,     0,     0,     0,  -333,  -333,  -333,  -333,  -333,  -333,
    -333,  -333,  -333,  -333,  -333,  -333,  -333,     0,     0,     0,
       0,  -333,  -333,  -333,  -333,     0,     0,  -333,     0,     0,
       0,     0,     0,  -333,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -333,     0,     0,
    -333,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -333,  -333,  -333,  -333,  -333,  -333,  -333,  -333,
    -333,  -333,  -333,  -333,     0,     0,     0,     0,     0,  -333,
    -333,  -333,  -333,  -789,     0,  -333,  -333,  -333,     0,     0,
       0,  -789,  -789,  -789,     0,     0,  -789,  -789,  -789,     0,
    -789,     0,     0,     0,     0,     0,     0,     0,  -789,  -789,
    -789,  -789,     0,     0,     0,     0,     0,     0,     0,     0,
    -789,  -789,     0,  -789,  -789,  -789,  -789,  -789,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -789,  -789,     0,     0,     0,     0,     0,     0,     0,
       0,  -789,  -789,  -789,  -789,  -789,  -789,  -789,  -789,  -789,
    -789,  -789,  -789,  -789,     0,     0,     0,     0,  -789,  -789,
    -789,  -789,     0,     0,  -789,     0,     0,     0,     0,     0,
    -789,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -789,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -789,
       0,  -789,  -789,  -789,  -789,  -789,  -789,  -789,  -789,  -789,
    -789,     0,     0,     0,     0,  -789,  -789,  -789,  -789,  -789,
    -339,   245,  -789,  -789,  -789,     0,     0,     0,  -339,  -339,
    -339,     0,     0,  -339,  -339,  -339,     0,  -339,     0,     0,
       0,     0,     0,     0,     0,  -339,     0,  -339,  -339,     0,
       0,     0,     0,     0,     0,     0,     0,  -339,  -339,     0,
    -339,  -339,  -339,  -339,  -339,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -339,  -339,
       0,     0,     0,     0,     0,     0,     0,     0,  -339,  -339,
    -339,  -339,  -339,  -339,  -339,  -339,  -339,  -339,  -339,  -339,
    -339,     0,     0,     0,     0,  -339,  -339,  -339,  -339,     0,
     861,  -339,     0,     0,     0,     0,     0,  -339,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -339,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -138,  -339,     0,  -339,  -339,
    -339,  -339,  -339,  -339,  -339,  -339,  -339,  -339,     0,     0,
       0,     0,   803,  -339,  -339,  -339,  -339,  -346,     0,  -339,
    -339,  -339,     0,     0,     0,  -346,  -346,  -346,     0,     0,
    -346,  -346,  -346,     0,  -346,     0,     0,     0,     0,     0,
       0,     0,  -346,     0,  -346,  -346,     0,     0,     0,     0,
       0,     0,     0,     0,  -346,  -346,     0,  -346,  -346,  -346,
    -346,  -346,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -346,  -346,     0,     0,     0,
       0,     0,     0,     0,     0,  -346,  -346,  -346,  -346,  -346,
    -346,  -346,  -346,  -346,  -346,  -346,  -346,  -346,     0,     0,
       0,     0,  -346,  -346,  -346,  -346,     0,     0,  -346,     0,
       0,     0,     0,     0,  -346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -346,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -346,     0,  -346,  -346,  -346,  -346,  -346,
    -346,  -346,  -346,  -346,  -346,     0,     0,     0,     0,     0,
    -346,  -346,  -346,  -346,  -771,   435,  -346,  -346,  -346,     0,
       0,     0,  -771,  -771,  -771,   919,     0,     0,  -771,  -771,
       0,  -771,     0,     0,     0,     0,     0,     0,     0,  -771,
    -771,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -771,  -771,     0,  -771,  -771,  -771,  -771,  -771,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,     0,     0,     0,     0,   369,   370,     0,     0,
       0,     0,  -771,  -771,     0,     0,     0,     0,     0,     0,
       0,     0,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,
    -771,  -771,  -771,  -771,  -771,     0,     0,     0,     0,  -771,
    -771,  -771,  -771,     0,   801,  -771,     0,   372,     0,   373,
     374,   375,   376,   377,   378,   379,   380,   381,   382,     0,
       0,     0,     0,     0,     0,  -771,     0,  -284,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -136,
    -771,     0,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,
    -771,  -771,     0,     0,     0,     0,  -771,  -771,  -771,  -771,
    -127,  -771,     0,  -771,     0,  -771,     0,     0,     0,  -771,
    -771,  -771,     0,     0,     0,  -771,  -771,     0,  -771,     0,
       0,     0,     0,     0,     0,     0,  -771,  -771,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -771,  -771,
       0,  -771,  -771,  -771,  -771,  -771,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -771,
    -771,     0,     0,     0,     0,     0,     0,     0,     0,  -771,
    -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,
    -771,  -771,     0,     0,     0,     0,  -771,  -771,  -771,  -771,
       0,   801,  -771,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -771,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -136,  -771,     0,  -771,
    -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,  -771,     0,
       0,     0,     0,  -771,  -771,  -771,  -771,  -771,  -339,     0,
    -771,     0,  -771,     0,     0,     0,  -339,  -339,  -339,     0,
       0,     0,  -339,  -339,     0,  -339,     0,     0,     0,     0,
       0,     0,     0,  -339,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -339,  -339,     0,  -339,  -339,
    -339,  -339,  -339,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -339,  -339,     0,     0,
       0,     0,     0,     0,     0,     0,  -339,  -339,  -339,  -339,
    -339,  -339,  -339,  -339,  -339,  -339,  -339,  -339,  -339,     0,
       0,     0,     0,  -339,  -339,  -339,  -339,     0,   802,  -339,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -339,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -138,  -339,     0,  -339,  -339,  -339,  -339,
    -339,  -339,  -339,  -339,  -339,  -339,     0,     0,     0,     0,
     803,  -339,  -339,  -339,  -129,  -339,     0,  -339,     0,  -339,
       0,     0,     0,  -339,  -339,  -339,     0,     0,     0,  -339,
    -339,     0,  -339,     0,     0,     0,     0,     0,     0,     0,
    -339,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -339,  -339,     0,  -339,  -339,  -339,  -339,  -339,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -339,  -339,     0,     0,     0,     0,     0,
       0,     0,     0,  -339,  -339,  -339,  -339,  -339,  -339,  -339,
    -339,  -339,  -339,  -339,  -339,  -339,     0,     0,     0,     0,
    -339,  -339,  -339,  -339,     0,   802,  -339,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -339,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -138,  -339,     0,  -339,  -339,  -339,  -339,  -339,  -339,  -339,
    -339,  -339,  -339,     0,     0,     0,     0,   803,  -339,  -339,
    -339,  -339,     0,     0,  -339,     3,  -339,     4,     5,     6,
       7,     8,  -789,  -789,  -789,     9,    10,     0,     0,  -789,
      11,     0,    12,    13,    14,    15,    16,    17,    18,     0,
       0,     0,     0,     0,    19,    20,    21,    22,    23,    24,
      25,     0,     0,    26,     0,     0,     0,     0,     0,    27,
      28,   272,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     0,    40,    41,    42,    43,    44,    45,    46,
       0,     0,  -789,     0,     0,     0,     0,     0,     0,     0,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,    50,     0,     0,     0,
       0,     0,     0,    51,     0,     0,    52,    53,     0,    54,
      55,     0,    56,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    66,    67,    68,     0,     0,     0,     3,  -789,
       4,     5,     6,     7,     8,  -789,     0,  -789,     9,    10,
       0,  -789,  -789,    11,     0,    12,    13,    14,    15,    16,
      17,    18,     0,     0,     0,     0,     0,    19,    20,    21,
      22,    23,    24,    25,     0,     0,    26,     0,     0,     0,
       0,     0,    27,    28,   272,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,    43,
      44,    45,    46,     0,     0,  -789,     0,     0,     0,     0,
       0,     0,     0,    47,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,    50,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
      53,     0,    54,    55,     0,    56,     0,     0,    57,    58,
      59,    60,    61,    62,    63,    64,    65,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    66,    67,    68,     0,     0,
       0,     3,  -789,     4,     5,     6,     7,     8,  -789,     0,
    -789,     9,    10,     0,     0,  -789,    11,  -789,    12,    13,
      14,    15,    16,    17,    18,     0,     0,     0,     0,     0,
      19,    20,    21,    22,    23,    24,    25,     0,     0,    26,
       0,     0,     0,     0,     0,    27,    28,   272,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,     0,    40,
      41,    42,    43,    44,    45,    46,     0,     0,  -789,     0,
       0,     0,     0,     0,     0,     0,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,    50,     0,     0,     0,     0,     0,     0,    51,
       0,     0,    52,    53,     0,    54,    55,     0,    56,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    66,    67,
      68,     0,     0,     0,     3,  -789,     4,     5,     6,     7,
       8,  -789,     0,  -789,     9,    10,     0,     0,  -789,    11,
       0,    12,    13,    14,    15,    16,    17,    18,  -789,     0,
       0,     0,     0,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,     0,     0,     0,     0,     0,    27,    28,
     272,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,  -789,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,    51,     0,     0,    52,    53,     0,    54,    55,
       0,    56,     0,     0,    57,    58,    59,    60,    61,    62,
      63,    64,    65,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    66,    67,    68,     0,     0,     0,     3,  -789,     4,
       5,     6,     7,     8,  -789,     0,  -789,     9,    10,     0,
       0,  -789,    11,     0,    12,    13,    14,    15,    16,    17,
      18,     0,     0,     0,     0,     0,    19,    20,    21,    22,
      23,    24,    25,     0,     0,    26,     0,     0,     0,     0,
       0,    27,    28,   272,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,  -789,     0,     0,     0,     0,     0,
       0,     0,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,    50,     0,
       0,     0,     0,     0,     0,    51,     0,     0,    52,    53,
       0,    54,    55,     0,    56,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    66,    67,    68,     0,     0,     0,
       3,  -789,     4,     5,     6,     7,     8,  -789,  -789,  -789,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,   272,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,  -789,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,    51,     0,
       0,    52,    53,     0,    54,    55,     0,    56,     0,     0,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    66,    67,    68,
       0,     0,     0,     3,  -789,     4,     5,     6,     7,     8,
    -789,     0,  -789,     9,    10,     0,     0,     0,    11,     0,
      12,    13,    14,    15,    16,    17,    18,     0,     0,     0,
       0,     0,    19,    20,    21,    22,    23,    24,    25,     0,
       0,    26,     0,     0,     0,     0,     0,    27,    28,   272,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,    40,    41,    42,    43,    44,    45,    46,     0,     0,
    -789,     0,     0,     0,     0,     0,     0,     0,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,    50,     0,     0,     0,     0,     0,
       0,    51,     0,     0,    52,    53,     0,    54,    55,     0,
      56,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      66,    67,    68,     0,     0,     0,     3,  -789,     4,     5,
       6,     7,     8,  -789,     0,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,    15,    16,    17,    18,
       0,     0,     0,     0,     0,    19,    20,    21,    22,    23,
      24,    25,     0,     0,    26,     0,     0,     0,     0,     0,
      27,    28,   272,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,    51,     0,     0,   273,    53,     0,
      54,    55,     0,    56,     0,     0,    57,    58,    59,    60,
      61,    62,    63,    64,    65,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    66,    67,    68,     0,     0,     0,     0,
    -789,     0,     0,     0,  -789,     3,  -789,     4,     5,     6,
       7,     8,     0,     0,     0,     9,    10,     0,     0,     0,
      11,     0,    12,    13,    14,    15,    16,    17,    18,     0,
       0,     0,     0,     0,    19,    20,    21,    22,    23,    24,
      25,     0,     0,    26,     0,     0,     0,     0,     0,    27,
      28,   272,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     0,    40,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,    50,     0,     0,     0,
       0,     0,     0,    51,     0,     0,    52,    53,     0,    54,
      55,     0,    56,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    66,    67,    68,     0,     0,     0,     0,  -789,
       0,     0,     0,  -789,     3,  -789,     4,     5,     6,     7,
       8,     0,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,     0,     0,     0,     0,     0,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,    51,     0,     0,    52,    53,     0,    54,    55,
       0,    56,     0,     0,    57,    58,    59,    60,    61,    62,
      63,    64,    65,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    66,    67,    68,     0,     0,  -789,     3,  -789,     4,
       5,     6,     7,     8,  -789,     0,     0,     9,    10,     0,
       0,     0,    11,     0,    12,    13,    14,    15,    16,    17,
      18,     0,     0,     0,     0,     0,    19,    20,    21,    22,
      23,    24,    25,     0,     0,    26,     0,     0,     0,     0,
       0,    27,    28,   272,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,    50,     0,
       0,     0,     0,     0,     0,    51,     0,     0,    52,    53,
       0,    54,    55,     0,    56,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    66,    67,    68,     0,     0,  -789,
     391,  -789,     4,     5,     6,     0,     8,  -789,     0,     0,
       9,    10,     0,     0,     0,    11,    -4,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   220,     0,
       0,   221,    53,     0,    54,    55,     0,     0,     0,     0,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    66,    67,    68,
       0,     0,     0,     0,   319,     0,     0,     0,     0,     0,
     320,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,     0,     0,     0,   159,   160,
     161,   420,   421,   422,   423,   166,   167,   168,     0,     0,
       0,     0,     0,   169,   170,   171,   172,   424,   425,   426,
     427,   177,    36,    37,   428,    39,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   179,   180,   181,   182,   183,   184,
     185,   186,   187,     0,     0,   188,   189,     0,     0,     0,
       0,   190,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,     0,   206,   207,     0,
       0,     0,     0,     0,     0,   208,   429,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,     0,     0,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,     0,     0,     0,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,    36,    37,
     178,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,   180,   181,   182,   183,   184,   185,   186,   187,     0,
       0,   188,   189,     0,     0,     0,     0,   190,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   194,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,     0,   206,   207,     0,     0,     0,     0,     0,
       0,   208,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,     0,     0,     0,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,     0,
       0,     0,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   252,     0,   178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,   182,   183,
     184,   185,   186,   187,     0,     0,   188,   189,     0,     0,
       0,     0,   190,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,   195,     0,
       0,    58,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,     0,   206,   207,
       0,     0,     0,     0,     0,     0,   208,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,     0,     0,     0,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,     0,     0,     0,     0,     0,   169,
     170,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,   180,   181,   182,   183,   184,   185,   186,   187,     0,
       0,   188,   189,     0,     0,     0,     0,   190,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   194,   195,     0,     0,    58,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,     0,   206,   207,     0,     0,     0,     0,     0,
       0,   208,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,     0,     0,     0,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,     0,
       0,     0,     0,     0,   169,   170,   171,   172,   173,   174,
     175,   176,   177,     0,     0,   178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,   182,   183,
     184,   185,   186,   187,     0,     0,   188,   189,     0,     0,
       0,     0,   190,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,     0,   206,   207,
       4,     5,     6,     0,     8,     0,   208,     0,     9,    10,
       0,     0,     0,    11,     0,    12,    13,    14,   260,   261,
      17,    18,     0,     0,     0,     0,     0,    19,    20,   262,
      22,    23,    24,    25,     0,     0,   218,     0,     0,     0,
       0,     0,     0,   290,     0,     0,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   291,     0,     0,   221,
      53,     0,    54,    55,     0,     0,     0,     0,    57,    58,
      59,    60,    61,    62,    63,    64,    65,     0,     0,     4,
       5,     6,     0,     8,     0,     0,     0,     9,    10,     0,
       0,     0,    11,     0,    12,    13,    14,   260,   261,    17,
      18,     0,     0,     0,     0,   292,    19,    20,   262,    22,
      23,    24,    25,   293,     0,   218,     0,     0,     0,     0,
       0,     0,   290,     0,     0,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   291,     0,     0,   221,    53,
       0,    54,    55,     0,     0,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     4,     5,
       6,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,    15,    16,    17,    18,
       0,     0,     0,     0,   292,    19,    20,    21,    22,    23,
      24,    25,   591,     0,   218,     0,     0,     0,     0,     0,
       0,    28,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,   219,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,   220,     0,     0,   221,    53,     0,
      54,    55,     0,   222,   223,   224,    57,    58,   225,    60,
      61,    62,    63,    64,    65,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     5,
       6,     0,     8,    66,   226,    68,     9,    10,     0,     0,
     249,    11,     0,    12,    13,    14,    15,    16,    17,    18,
       0,     0,     0,     0,     0,    19,    20,    21,    22,    23,
      24,    25,     0,     0,    26,     0,     0,     0,     0,     0,
       0,    28,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,   220,     0,     0,   221,    53,     0,
      54,    55,     0,     0,     0,     0,    57,    58,    59,    60,
      61,    62,    63,    64,    65,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     3,     0,     4,     5,
       6,     7,     8,    66,    67,    68,     9,    10,     0,     0,
     249,    11,     0,    12,    13,    14,    15,    16,    17,    18,
       0,     0,     0,     0,     0,    19,    20,    21,    22,    23,
      24,    25,     0,     0,    26,     0,     0,     0,     0,     0,
      27,    28,     0,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,    51,     0,     0,    52,    53,     0,
      54,    55,     0,    56,     0,     0,    57,    58,    59,    60,
      61,    62,    63,    64,    65,     0,     0,   391,     0,     4,
       5,     6,     0,     8,     0,     0,     0,     9,    10,     0,
       0,     0,    11,     0,    12,    13,    14,    15,    16,    17,
      18,     0,     0,    66,    67,    68,    19,    20,    21,    22,
      23,    24,    25,     0,     0,    26,     0,     0,     0,     0,
       0,     0,    28,     0,     0,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,    50,     0,
       0,     0,     0,     0,     0,   220,     0,     0,   221,    53,
       0,    54,    55,     0,     0,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     0,     0,
       4,     5,     6,     0,     8,     0,     0,     0,     9,    10,
       0,     0,     0,    11,     0,    12,    13,    14,    15,    16,
      17,    18,     0,     0,    66,    67,    68,    19,    20,    21,
      22,    23,    24,    25,     0,     0,   218,     0,     0,     0,
       0,     0,     0,    28,     0,     0,    31,    32,    33,    34,
      35,    36,    37,    38,    39,   219,    40,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,    50,
       0,     0,     0,     0,     0,     0,   220,     0,     0,   221,
      53,     0,    54,    55,     0,   222,   223,   224,    57,    58,
     225,    60,    61,    62,    63,    64,    65,     0,     0,     0,
       0,     4,     5,     6,     0,     8,     0,     0,     0,     9,
      10,     0,     0,     0,    11,     0,    12,    13,    14,    15,
      16,    17,    18,     0,     0,    66,   226,    68,    19,    20,
      21,    22,    23,    24,    25,     0,     0,   218,     0,     0,
       0,     0,     0,     0,    28,     0,     0,    31,    32,    33,
      34,    35,    36,    37,    38,    39,   219,    40,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
     465,     0,     0,     0,     0,     0,     0,   220,     0,     0,
     221,    53,     0,    54,    55,     0,   222,   223,   224,    57,
      58,   225,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     260,   261,    17,    18,     0,     0,    66,   226,    68,    19,
      20,   262,    22,    23,    24,    25,     0,     0,   218,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   219,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   220,     0,
       0,   221,    53,     0,    54,    55,     0,   222,   223,   224,
      57,    58,   225,    60,    61,    62,    63,    64,    65,     0,
       0,     0,     0,     4,     5,     6,     0,     8,     0,     0,
       0,     9,    10,     0,     0,     0,    11,     0,    12,    13,
      14,   260,   261,    17,    18,     0,     0,    66,   226,    68,
      19,    20,   262,    22,    23,    24,    25,     0,     0,   218,
       0,     0,     0,     0,     0,     0,    28,     0,     0,    31,
      32,    33,    34,    35,    36,    37,    38,    39,   219,    40,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,   465,     0,     0,     0,     0,     0,     0,   220,
       0,     0,   221,    53,     0,    54,    55,     0,   222,   223,
     224,    57,    58,   225,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     4,     5,     6,     0,     8,     0,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,   260,   261,    17,    18,     0,     0,    66,   226,
      68,    19,    20,   262,    22,    23,    24,    25,     0,     0,
     218,     0,     0,     0,     0,     0,     0,    28,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,   219,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
     220,     0,     0,   221,    53,     0,    54,    55,     0,   222,
     223,     0,    57,    58,   225,    60,    61,    62,    63,    64,
      65,     0,     0,     0,     0,     4,     5,     6,     0,     8,
       0,     0,     0,     9,    10,     0,     0,     0,    11,     0,
      12,    13,    14,   260,   261,    17,    18,     0,     0,    66,
     226,    68,    19,    20,   262,    22,    23,    24,    25,     0,
       0,   218,     0,     0,     0,     0,     0,     0,    28,     0,
       0,    31,    32,    33,    34,    35,    36,    37,    38,    39,
     219,    40,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,    50,     0,     0,     0,     0,     0,
       0,   220,     0,     0,   221,    53,     0,    54,    55,     0,
       0,   223,   224,    57,    58,   225,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     4,     5,     6,     0,
       8,     0,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,   260,   261,    17,    18,     0,     0,
      66,   226,    68,    19,    20,   262,    22,    23,    24,    25,
       0,     0,   218,     0,     0,     0,     0,     0,     0,    28,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,   219,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,   220,     0,     0,   221,    53,     0,    54,    55,
       0,     0,   223,     0,    57,    58,   225,    60,    61,    62,
      63,    64,    65,     0,     0,     0,     0,     4,     5,     6,
       0,     8,     0,     0,     0,     9,    10,     0,     0,     0,
      11,     0,    12,    13,    14,    15,    16,    17,    18,     0,
       0,    66,   226,    68,    19,    20,    21,    22,    23,    24,
      25,     0,     0,   218,     0,     0,     0,     0,     0,     0,
      28,     0,     0,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     0,    40,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,    50,     0,     0,     0,
       0,     0,     0,   220,     0,     0,   221,    53,     0,    54,
      55,     0,   778,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     0,     0,     4,     5,
       6,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,    15,    16,    17,    18,
       0,     0,    66,   226,    68,    19,    20,    21,    22,    23,
      24,    25,     0,     0,   218,     0,     0,     0,     0,     0,
       0,    28,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,   787,     0,     0,   221,    53,     0,
      54,    55,     0,   778,     0,     0,    57,    58,    59,    60,
      61,    62,    63,    64,    65,     0,     0,     0,     0,     4,
       5,     6,     0,     8,     0,     0,     0,     9,    10,     0,
       0,     0,    11,     0,    12,    13,    14,   260,   261,    17,
      18,     0,     0,    66,   226,    68,    19,    20,   262,    22,
      23,    24,    25,     0,     0,   218,     0,     0,     0,     0,
       0,     0,    28,     0,     0,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,    50,     0,
       0,     0,     0,     0,     0,   220,     0,     0,   221,    53,
       0,    54,    55,     0,   948,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     0,     0,
       4,     5,     6,     0,     8,     0,     0,     0,     9,    10,
       0,     0,     0,    11,     0,    12,    13,    14,   260,   261,
      17,    18,     0,     0,    66,   226,    68,    19,    20,   262,
      22,    23,    24,    25,     0,     0,   218,     0,     0,     0,
       0,     0,     0,    28,     0,     0,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,    50,
       0,     0,     0,     0,     0,     0,   220,     0,     0,   221,
      53,     0,    54,    55,     0,   997,     0,     0,    57,    58,
      59,    60,    61,    62,    63,    64,    65,     0,     0,     0,
       0,     4,     5,     6,     0,     8,     0,     0,     0,     9,
      10,     0,     0,     0,    11,     0,    12,    13,    14,   260,
     261,    17,    18,     0,     0,    66,   226,    68,    19,    20,
     262,    22,    23,    24,    25,     0,     0,   218,     0,     0,
       0,     0,     0,     0,    28,     0,     0,    31,    32,    33,
      34,    35,    36,    37,    38,    39,     0,    40,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
      50,     0,     0,     0,     0,     0,     0,   220,     0,     0,
     221,    53,     0,    54,    55,     0,   778,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     260,   261,    17,    18,     0,     0,    66,   226,    68,    19,
      20,   262,    22,    23,    24,    25,     0,     0,   218,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   220,     0,
       0,   221,    53,     0,    54,    55,     0,  1116,     0,     0,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
       0,     0,     0,     4,     5,     6,     0,     8,     0,     0,
       0,     9,    10,     0,     0,     0,    11,     0,    12,    13,
      14,   260,   261,    17,    18,     0,     0,    66,   226,    68,
      19,    20,   262,    22,    23,    24,    25,     0,     0,   218,
       0,     0,     0,     0,     0,     0,    28,     0,     0,    31,
      32,    33,    34,    35,    36,    37,    38,    39,     0,    40,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,    50,     0,     0,     0,     0,     0,     0,   220,
       0,     0,   221,    53,     0,    54,    55,     0,     0,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     4,     5,     6,     0,     8,     0,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,    66,   226,
      68,    19,    20,    21,    22,    23,    24,    25,     0,     0,
     218,     0,     0,     0,     0,     0,     0,    28,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
     220,     0,     0,   221,    53,     0,    54,    55,     0,     0,
       0,     0,    57,    58,    59,    60,    61,    62,    63,    64,
      65,     0,     0,     0,     0,     4,     5,     6,     0,     8,
       0,     0,     0,     9,    10,     0,     0,     0,    11,     0,
      12,    13,    14,    15,    16,    17,    18,     0,     0,    66,
     226,    68,    19,    20,    21,    22,    23,    24,    25,     0,
       0,    26,     0,     0,     0,     0,     0,     0,    28,     0,
       0,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,    40,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,    48,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,    50,     0,     0,     0,     0,     0,
       0,   220,     0,     0,   221,    53,     0,    54,    55,     0,
       0,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     4,     5,     6,     0,
       8,     0,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,    15,    16,    17,    18,     0,     0,
      66,    67,    68,    19,    20,    21,    22,    23,    24,    25,
       0,     0,   760,     0,     0,     0,     0,     0,     0,    28,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,   220,     0,     0,   221,    53,     0,    54,    55,
       0,     0,     0,     0,    57,    58,    59,    60,    61,    62,
      63,    64,    65,     0,     0,     0,     0,     4,     5,     6,
       0,     8,     0,     0,     0,     9,    10,     0,     0,     0,
      11,     0,    12,    13,    14,    15,    16,    17,    18,     0,
       0,    66,   226,    68,    19,    20,    21,    22,    23,    24,
      25,     0,     0,   218,     0,     0,     0,     0,     0,     0,
      28,     0,     0,    31,    32,    33,    34,    35,    36,    37,
      38,    39,     0,    40,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,    50,     0,     0,     0,
       0,     0,     0,   787,     0,     0,   221,    53,     0,    54,
      55,     0,     0,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     0,     0,     4,     5,
       6,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,   260,   261,    17,    18,
       0,     0,    66,   226,    68,    19,    20,   262,    22,    23,
      24,    25,     0,     0,   858,     0,     0,     0,     0,     0,
       0,    28,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,   220,     0,     0,   221,    53,     0,
      54,    55,     0,     0,     0,     0,    57,    58,    59,    60,
      61,    62,    63,    64,    65,     0,     0,     0,     0,     4,
       5,     6,     0,     8,     0,     0,     0,     9,    10,     0,
       0,     0,    11,     0,    12,    13,    14,   260,   261,    17,
      18,     0,     0,    66,   226,    68,    19,    20,   262,    22,
      23,    24,    25,     0,     0,   218,     0,     0,     0,     0,
       0,     0,   290,     0,     0,    31,    32,    33,    34,    35,
      36,    37,    38,    39,     0,    40,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   291,     0,     0,   351,    53,
       0,    54,    55,     0,   352,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     4,     5,
       6,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,   260,   261,    17,    18,
       0,     0,     0,     0,   292,    19,    20,   262,    22,    23,
      24,    25,     0,     0,   218,     0,     0,     0,     0,     0,
       0,   290,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   401,     0,     0,    52,    53,     0,
      54,    55,     0,    56,     0,     0,    57,    58,    59,    60,
      61,    62,    63,    64,    65,     0,     0,     4,     5,     6,
       0,     8,     0,     0,     0,     9,    10,     0,     0,     0,
      11,     0,    12,    13,    14,   260,   261,    17,    18,     0,
       0,     0,     0,   292,    19,    20,   262,    22,    23,    24,
      25,     0,     0,   218,     0,     0,     0,     0,     0,     0,
     290,     0,     0,    31,    32,    33,   409,    35,    36,    37,
     410,    39,     0,    40,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   411,
       0,     0,     0,   412,     0,     0,   221,    53,     0,    54,
      55,     0,     0,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     4,     5,     6,     0,
       8,     0,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,   260,   261,    17,    18,     0,     0,
       0,     0,   292,    19,    20,   262,    22,    23,    24,    25,
       0,     0,   218,     0,     0,     0,     0,     0,     0,   290,
       0,     0,    31,    32,    33,   409,    35,    36,    37,   410,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,     0,   221,    53,     0,    54,    55,
       0,     0,     0,     0,    57,    58,    59,    60,    61,    62,
      63,    64,    65,     0,     0,     4,     5,     6,     0,     8,
       0,     0,     0,     9,    10,     0,     0,     0,    11,     0,
      12,    13,    14,   260,   261,    17,    18,     0,     0,     0,
       0,   292,    19,    20,   262,    22,    23,    24,    25,     0,
       0,   218,     0,     0,     0,     0,     0,     0,   290,     0,
       0,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,    40,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   291,     0,     0,   351,    53,     0,    54,    55,     0,
       0,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     4,     5,     6,     0,     8,     0,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,   260,   261,    17,    18,     0,     0,     0,     0,
     292,    19,    20,   262,    22,    23,    24,    25,     0,     0,
     218,     0,     0,     0,     0,     0,     0,   290,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1171,     0,     0,   221,    53,     0,    54,    55,     0,     0,
       0,     0,    57,    58,    59,    60,    61,    62,    63,    64,
      65,     0,     0,     4,     5,     6,     0,     8,     0,     0,
       0,     9,    10,     0,     0,     0,    11,     0,    12,    13,
      14,   260,   261,    17,    18,     0,     0,     0,     0,   292,
      19,    20,   262,    22,    23,    24,    25,     0,     0,   218,
       0,     0,     0,     0,     0,     0,   290,     0,     0,    31,
      32,    33,    34,    35,    36,    37,    38,    39,     0,    40,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1268,
       0,     0,   221,    53,     0,    54,    55,    22,    23,    24,
      25,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,    31,    32,    33,  1060,     0,     0,     0,
    1061,     0,  1062,    40,    41,    42,    43,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   292,     0,
       0,     0,   547,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1063,  1064,     0,     0,     0,
       0,     0,     0,  1065,     0,     0,  1066,     0,     0,  1067,
    1068,     0,  1069,   551,     0,    57,    58,  1070,    60,    61,
      62,    63,    64,    65,     0,     0,     0,     0,     0,     0,
      22,    23,    24,    25,     0,     0,     0,   621,   622,     0,
       0,   623,     0,     0,     0,  1071,    31,    32,    33,  1060,
       0,     0,   292,  1061,     0,     0,    40,    41,    42,    43,
      44,   179,   180,   181,   182,   183,   184,   185,   186,   187,
       0,     0,   188,   189,     0,     0,     0,     0,   190,   191,
     192,   193,     0,     0,     0,     0,     0,     0,  1063,  1064,
       0,     0,     0,   194,   195,     0,  1065,     0,     0,  1066,
       0,     0,  1067,  1068,     0,     0,     0,     0,    57,    58,
      59,    60,    61,    62,    63,    64,    65,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,     0,   206,   207,   631,   632,  1071,     0,
     633,     0,   208,   245,     0,   292,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,   180,   181,   182,   183,   184,   185,   186,   187,     0,
       0,   188,   189,     0,     0,     0,     0,   190,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   194,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,     0,   206,   207,   685,   622,     0,     0,   686,
       0,   208,   245,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,   182,   183,   184,   185,   186,   187,     0,     0,
     188,   189,     0,     0,     0,     0,   190,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,     0,   206,   207,   688,   632,     0,     0,   689,     0,
     208,   245,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   179,   180,
     181,   182,   183,   184,   185,   186,   187,     0,     0,   188,
     189,     0,     0,     0,     0,   190,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     194,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
       0,   206,   207,   685,   622,     0,     0,   703,     0,   208,
     245,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   179,   180,   181,
     182,   183,   184,   185,   186,   187,     0,     0,   188,   189,
       0,     0,     0,     0,   190,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,     0,
     206,   207,   714,   622,     0,     0,   715,     0,   208,   245,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,   182,
     183,   184,   185,   186,   187,     0,     0,   188,   189,     0,
       0,     0,     0,   190,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   194,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,     0,   206,
     207,   717,   632,     0,     0,   718,     0,   208,   245,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,   182,   183,
     184,   185,   186,   187,     0,     0,   188,   189,     0,     0,
       0,     0,   190,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,     0,   206,   207,
     831,   622,     0,     0,   832,     0,   208,   245,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   179,   180,   181,   182,   183,   184,
     185,   186,   187,     0,     0,   188,   189,     0,     0,     0,
       0,   190,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,     0,   206,   207,   834,
     632,     0,     0,   835,     0,   208,   245,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   179,   180,   181,   182,   183,   184,   185,
     186,   187,     0,     0,   188,   189,     0,     0,     0,     0,
     190,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   194,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,     0,   206,   207,   840,   622,
       0,     0,   841,     0,   208,   245,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   179,   180,   181,   182,   183,   184,   185,   186,
     187,     0,     0,   188,   189,     0,     0,     0,     0,   190,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   194,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,     0,   206,   207,   669,   632,     0,
       0,   670,     0,   208,   245,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,   181,   182,   183,   184,   185,   186,   187,
       0,     0,   188,   189,     0,     0,     0,     0,   190,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   194,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,     0,   206,   207,  1003,   622,     0,     0,
    1004,     0,   208,   245,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,   180,   181,   182,   183,   184,   185,   186,   187,     0,
       0,   188,   189,     0,     0,     0,     0,   190,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   194,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,   201,   202,   203,
     204,   205,     0,   206,   207,  1006,   632,     0,     0,  1007,
       0,   208,   245,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   179,
     180,   181,   182,   183,   184,   185,   186,   187,     0,     0,
     188,   189,     0,     0,     0,     0,   190,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,     0,   206,   207,  1286,   622,     0,     0,  1287,     0,
     208,   245,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   179,   180,
     181,   182,   183,   184,   185,   186,   187,     0,     0,   188,
     189,     0,     0,     0,     0,   190,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     194,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
       0,   206,   207,  1289,   632,     0,     0,  1290,     0,   208,
     245,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   179,   180,   181,
     182,   183,   184,   185,   186,   187,     0,     0,   188,   189,
       0,     0,     0,     0,   190,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   194,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,     0,
     206,   207,  1334,   622,     0,     0,  1335,     0,   208,   245,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,   181,   182,
     183,   184,   185,   186,   187,     0,     0,   188,   189,     0,
       0,     0,     0,   190,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   194,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,     0,   206,
     207,   669,   632,     0,     0,   670,     0,   208,   245,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   179,   180,   181,   182,   183,
     184,   185,   186,   187,     0,     0,   188,   189,     0,     0,
       0,     0,   190,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   194,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,     0,   206,   207,
       0,     0,     0,     0,     0,     0,   208
};

static const yytype_int16 yycheck[] =
{
       1,   106,     7,    15,    16,    21,    56,    70,    59,    52,
      53,    97,    58,    70,   336,     1,    58,   412,    91,   751,
      13,    14,    27,   549,   744,    27,   394,     7,    94,   557,
      85,    97,   105,   332,   746,    85,    96,   336,   578,   751,
      97,   581,   388,   242,   819,    67,    80,    27,    98,    99,
     100,    52,    53,    58,   245,    56,     1,   284,   594,   101,
      56,   288,    15,    16,    80,   584,   580,   588,    52,   103,
     580,   455,   829,   799,   387,   746,   389,   455,   332,    72,
      77,    66,   336,   888,    85,   463,    63,    64,    65,   509,
     102,   886,     0,   463,    13,  1144,   101,    98,    99,   100,
     101,    54,    55,    25,    37,    38,   609,    52,    53,    54,
      55,  1160,   496,   459,    25,    77,   637,  1009,   273,  1132,
      15,    16,   662,   644,   645,    25,   439,    15,    16,   499,
    1260,    76,    77,   567,  1168,  1169,    25,    13,    98,    13,
     574,    26,   100,    28,    15,   458,  1252,   460,     0,   102,
     101,  1067,  1008,  1009,    25,    25,    66,    10,   308,   309,
     100,   155,    25,    66,   237,   511,    54,   278,   678,  1144,
      26,   591,   485,   486,   225,    93,    94,   135,   221,    97,
     135,    25,    69,  1158,   100,  1198,    25,    52,   152,   275,
      25,    56,   265,    13,   154,   135,   351,   510,   158,   512,
    1330,    56,   387,   158,   389,   156,    27,   102,   734,   735,
     120,    98,   275,   121,   102,    68,  1322,   120,   275,   135,
     221,   162,   155,    13,  1273,   298,   952,  1119,  1277,  1278,
     273,   228,    13,   245,   156,   247,   155,   156,   293,    13,
    1045,  1275,   161,   293,   765,   156,   262,   263,   769,    13,
     982,  1046,  1168,  1169,   439,   256,   156,   672,   673,   325,
     326,   327,   328,  1119,   659,   227,   228,   156,  1008,  1009,
     256,   470,   273,   458,   986,   460,   221,   741,    28,   155,
     744,   155,   227,   228,   803,   161,   156,   161,  1337,   273,
     235,   706,   293,   156,   247,   158,   152,   242,   295,   839,
     245,   486,   352,  1278,   650,   744,   827,   292,   351,   830,
     694,   256,   156,   399,   660,   986,   694,   156,   696,   158,
      29,   156,   323,   844,   435,   828,   696,   512,   273,   395,
     101,   404,   250,   251,   155,   155,   649,   323,   651,   101,
     161,   161,   399,  1118,   155,   411,   659,   158,   661,   135,
     351,   352,   247,   396,   397,   466,   352,   245,   469,   247,
     886,  1118,   888,   474,   892,   155,   786,   351,   158,    26,
     156,   161,    78,   389,   155,   525,   388,   527,   489,  1119,
     161,   155,    13,   155,   389,   156,    13,   161,   160,   390,
     904,   155,    66,   155,   904,   396,   397,   161,   283,   284,
     936,    66,    13,   288,   135,   290,   351,   325,   326,   327,
     328,   100,   330,   331,   156,   124,   924,   957,   100,   805,
    1132,  1161,   943,   435,   808,   946,   113,   813,  1168,  1169,
     808,   135,   953,   100,   439,   956,   100,   100,   959,   145,
     146,   147,   100,   388,   460,   390,   135,   459,   122,   123,
     561,   396,   397,   135,   509,   460,   966,   122,   123,   509,
     125,   895,   896,  1063,  1064,   899,   651,   901,   135,   903,
     486,   135,   135,   156,   156,   480,   661,   395,   480,   590,
     100,   486,   435,    52,   711,   684,   100,    56,   162,   532,
     158,   492,   746,   411,   158,   152,   512,   751,    25,   511,
     480,   158,   455,   694,   100,    66,   770,   512,   509,   773,
     100,   926,   927,    25,   459,   135,  1037,   932,   933,  1045,
    1046,   135,   579,   468,   155,   470,  1034,   158,   155,   913,
     161,   532,    56,  1265,   161,  1275,   591,   538,  1258,   135,
     435,   591,   156,   496,   155,   135,  1321,   435,  1260,   135,
     161,   155,   538,  1265,   100,    69,   667,   161,  1066,   120,
    1068,   122,   123,  1163,  1164,   577,   511,   589,   580,  1008,
    1009,    58,   594,   723,   153,   921,   155,   578,   728,   101,
     581,   155,   950,    97,    98,   159,   643,   532,   156,   135,
     591,    78,   652,   627,  1326,   973,  1136,   640,   100,   642,
     582,  1016,   636,   973,   586,  1008,  1009,   920,   135,   922,
     555,   627,   557,  1047,  1048,  1049,  1050,   100,  1330,   100,
     636,   594,   109,   135,    37,    38,   113,   738,   155,   156,
     156,   158,   159,   578,    69,   651,   581,   671,   650,   640,
     154,   642,   100,   155,   156,   661,   651,   159,   660,   158,
     672,   673,   135,   975,   135,   671,   661,   712,  1166,  1167,
    1028,   662,   712,    98,  1067,  1193,  1194,   866,  1132,   674,
    1065,    78,   674,   156,   687,   721,   975,   135,   110,    69,
    1119,  1084,   158,  1132,   706,   630,    34,   158,   704,   705,
     159,   636,  1273,    25,   674,   640,  1277,   642,    25,   672,
     673,   589,    54,   716,    52,   650,   594,    97,    98,    34,
     142,   712,    64,    65,  1254,   660,  1119,   662,  1132,  1041,
     135,   975,  1161,   796,    69,   610,   671,    52,    69,  1168,
    1169,   786,   986,   706,   845,   920,   786,   922,  1141,   684,
    1108,   694,  1041,   848,   629,   663,   723,    69,   725,    69,
     160,   728,   729,    98,   865,  1158,   867,    98,  1192,    15,
     705,    17,    69,    69,   154,  1168,  1169,   153,   158,    69,
    1165,    69,   838,   884,    56,  1303,    98,    97,    98,  1300,
     837,    69,   700,    66,    69,   786,   158,  1041,    66,    67,
      97,    98,    98,   836,  1258,   156,  1260,    97,    98,    97,
      98,  1265,   687,   135,   846,   909,  1270,   911,   135,  1258,
      98,  1260,    97,    98,    69,   162,  1265,  1185,    26,  1258,
     833,  1270,   152,   155,   156,   135,   711,   159,   155,   156,
     843,   716,   159,    78,   154,   836,  1275,   120,   839,   122,
     123,   846,    97,    98,   122,   123,  1260,   154,   135,    54,
      55,  1265,    57,    69,   154,   808,  1270,    69,   135,    64,
      65,    69,  1326,   156,  1328,   107,  1330,    69,  1332,   154,
     161,   816,   817,     1,   819,   760,   942,  1326,  1132,  1328,
     873,  1330,    98,  1332,    69,  1349,    98,    15,    16,    97,
      98,   836,   904,    56,   839,    97,    98,  1243,   941,   154,
    1349,   958,   155,   156,   926,   927,   922,    66,   746,   921,
     932,   933,  1326,    98,  1328,    25,  1330,   922,  1332,   757,
     838,   866,   155,   156,    52,    53,  1158,   156,    56,  1242,
     139,  1244,   135,   976,   135,  1349,  1168,  1169,   156,    67,
     941,   156,    14,    15,   152,   100,   154,   892,   833,    69,
     158,   135,   154,   926,   927,   159,   957,    85,   843,   932,
     933,   120,   100,   122,   123,    93,    94,    89,    90,    97,
      98,    99,   100,   858,   102,   976,   921,    97,    98,  1001,
     135,    66,   153,    52,   159,    54,    55,    56,    57,    58,
    1033,   936,  1005,    66,  1016,   100,   941,   135,   999,  1000,
    1313,   156,   995,   996,    66,   156,  1260,  1008,  1009,    78,
      26,  1265,   957,   999,  1000,    40,    41,    69,   156,  1070,
     155,   156,   156,    92,   942,  1071,   294,   295,  1001,   156,
     135,   976,  1033,   102,   154,   120,   153,   122,   123,   100,
     109,   110,   156,  1016,   156,    97,    98,   120,   936,   122,
     123,   156,   125,    69,  1067,    52,  1167,  1107,   120,  1244,
     122,   123,  1063,  1064,   156,    52,  1067,   672,   673,   156,
     156,  1114,  1115,   142,   135,    69,  1330,    13,  1023,    17,
    1025,    97,    98,  1084,    26,   690,   691,   153,  1033,  1155,
    1133,    25,  1178,   221,   135,   156,   156,  1208,   156,    44,
    1173,   706,   154,    97,    98,    44,  1107,  1218,  1053,  1054,
    1111,   153,   156,  1114,  1115,  1178,   156,   245,  1119,   247,
    1005,  1178,   250,   251,  1235,  1236,  1237,    69,   256,    44,
    1143,    56,  1133,  1146,  1177,  1136,   152,    44,   154,   135,
    1141,   160,   158,  1144,   137,   273,   984,  1190,   986,    69,
     988,     8,  1202,  1166,    15,    97,    98,  1158,  1159,  1160,
     154,    66,  1163,  1164,   156,   293,  1111,  1168,  1169,  1114,
    1115,    52,   156,  1118,  1225,    78,  1177,    97,    98,    69,
     156,   156,  1067,  1068,  1250,  1251,   156,   156,  1133,  1190,
     153,  1136,   156,    69,   156,   323,   156,   325,   326,   327,
     328,  1202,   330,   331,   101,     9,   156,    97,    98,   140,
     152,    52,   154,   140,  1264,   120,   158,   122,   123,   156,
     125,    97,    98,   351,   352,  1238,  1239,  1240,  1244,   153,
     156,  1243,  1177,   156,   154,  1180,  1121,  1155,    52,  1244,
     143,   144,   145,   146,   147,  1190,   101,  1132,  1193,  1194,
    1293,   856,   161,  1254,    56,   159,    83,    84,  1143,   153,
     388,  1146,   390,  1264,   154,    58,   140,   395,   396,   397,
     156,   156,  1273,   156,   156,  1288,  1277,  1278,   154,   156,
      56,  1166,   140,   411,    52,    78,    54,    55,    56,    57,
      58,  1129,  1293,   156,  1132,   256,   156,    69,  1243,   158,
    1245,    52,  1247,    54,    55,     1,    57,   435,   156,  1254,
      78,   138,   139,  1198,   156,   158,   109,   110,   156,    15,
      16,   926,   927,    30,    92,    97,    98,   932,   933,  1111,
     156,   459,  1250,  1251,   102,   156,  1337,   156,   905,   906,
     108,   109,   110,    59,    60,    61,    62,   914,  1293,   142,
     917,   102,   919,  1238,  1239,  1240,    52,    53,  1303,   156,
     492,   846,   967,   968,   492,   970,   971,   323,  1008,  1009,
     488,    67,    98,   100,   142,    89,  1321,   145,   481,   671,
     937,   509,   154,   511,    52,  1180,    54,    55,    56,    57,
     158,    33,    34,    35,    36,   734,   886,    93,    94,  1200,
    1132,    97,  1054,  1288,   532,  1265,   102,    49,    50,    51,
     538,  1016,  1297,  1322,   347,   849,  1321,    59,    60,    61,
      62,    63,  1260,  1063,  1064,  1159,  1161,  1067,  1161,  1157,
      78,  1316,  1270,  1245,   102,  1040,   109,  1247,   527,   101,
     108,   744,   751,  1258,  1084,    -1,    -1,    95,    96,   577,
     578,    -1,   580,   581,  1316,    -1,  1201,    -1,    -1,  1204,
      -1,   589,    -1,   591,    -1,    -1,   594,    -1,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,  1119,
      -1,    -1,    -1,    52,    -1,    54,    55,    56,    57,    58,
    1328,    -1,  1330,    -1,  1332,   143,   144,   145,   146,   147,
      -1,  1141,    -1,    -1,  1144,    -1,   148,    -1,    -1,    78,
      -1,  1349,   640,    -1,   642,    -1,    -1,    -1,  1158,  1159,
    1160,    -1,   650,  1163,  1164,   221,    -1,    -1,  1168,  1169,
      -1,    -1,   660,   102,   662,   663,    -1,    -1,    -1,   108,
     109,   110,    -1,    -1,   672,   673,    -1,   254,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,    -1,    78,    -1,    -1,
     256,  1306,  1307,    -1,    -1,  1310,  1311,    -1,    -1,  1314,
      -1,    -1,   700,   142,    95,    96,   145,   273,   706,    -1,
      -1,    -1,    -1,    -1,   712,    -1,   155,    33,    34,    35,
      36,    52,    -1,    54,    55,    56,    57,    -1,  1343,  1344,
    1345,  1346,    -1,    49,    50,    51,    52,  1352,    -1,    -1,
      56,    -1,    -1,    59,    60,    61,    62,    63,    -1,   140,
     141,   142,   143,   144,   145,   146,   147,   323,    -1,   325,
     326,   327,   328,  1273,   330,   331,    -1,  1277,  1278,    -1,
      -1,   102,   349,    -1,    -1,    91,    92,   354,    40,    41,
      42,    43,    44,    99,    -1,   351,   102,    78,   786,   105,
     106,    -1,   108,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    95,    96,    -1,    -1,    -1,    -1,
      52,    -1,    54,    55,    56,    57,    58,    -1,    -1,    -1,
       1,    -1,   388,    -1,   390,   141,    -1,  1337,    -1,   395,
     396,   397,   148,    -1,    15,    16,    78,    -1,   836,   155,
     838,   839,    -1,    -1,    52,   411,    54,    55,    56,    57,
      -1,   142,   143,   144,   145,   146,   147,    -1,    -1,    52,
     102,    54,    55,    56,    57,   442,   443,   109,   110,   435,
      -1,    52,    53,    -1,    -1,    52,   453,    54,    55,    56,
      57,    58,    -1,    -1,   461,   462,    67,    -1,    -1,    -1,
      -1,    -1,    -1,   459,  1008,  1009,    -1,    -1,    -1,    -1,
     142,    78,    -1,    -1,   481,    -1,   904,    -1,    -1,    -1,
     487,    -1,    93,    94,    -1,    92,    97,    -1,    -1,    -1,
      -1,   102,    -1,   921,    -1,   102,   492,    -1,   926,   927,
      -1,   108,   109,   110,   932,   933,    52,    -1,    54,    55,
      56,    57,    58,   941,   942,   511,    -1,    -1,    -1,  1063,
    1064,    -1,    -1,  1067,    -1,    -1,    -1,    -1,    -1,   957,
      -1,    -1,    78,    -1,    -1,   142,   532,    -1,   145,    -1,
    1084,    -1,   538,    -1,    -1,    -1,    -1,    -1,   976,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,   999,  1000,  1001,    -1,  1119,    -1,    -1,    -1,    -1,
      -1,   577,   578,    -1,   580,   581,    -1,    -1,  1016,    -1,
      -1,    -1,    -1,   589,    -1,    -1,   142,  1141,   594,   145,
    1144,    -1,    -1,    -1,    -1,  1033,    -1,    -1,    -1,    -1,
     221,    -1,    -1,    -1,  1158,  1159,  1160,    -1,    -1,  1163,
    1164,    -1,    -1,    -1,  1168,  1169,    -1,    -1,    -1,    -1,
      -1,   638,    -1,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,   640,   256,   642,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   650,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,   660,    -1,   662,   663,   675,    -1,
      -1,    -1,    33,    34,    35,    36,   672,   673,    -1,  1107,
      -1,    -1,    -1,  1111,    -1,    -1,  1114,  1115,    49,    50,
      51,    52,    -1,    -1,    -1,    56,    -1,    -1,    59,    60,
      61,    62,    63,    -1,   700,  1133,    -1,    -1,  1136,    -1,
     706,    -1,   323,    -1,   325,   326,   327,   328,    -1,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,  1155,    -1,  1273,
      91,    92,    -1,  1277,  1278,    -1,    -1,    -1,    99,    -1,
     351,   102,    -1,    -1,   105,   106,    -1,   108,    -1,  1177,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
      -1,    -1,  1190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1202,    -1,    -1,   388,    -1,   390,
     141,    -1,    -1,    -1,   395,   396,   397,   148,    -1,    -1,
      -1,    -1,    -1,  1337,   801,   802,    -1,    -1,    -1,    -1,
     411,    -1,   809,   810,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1243,    -1,    -1,    -1,    -1,
      -1,    -1,  1250,  1251,   435,    -1,  1254,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1264,    -1,    -1,    -1,
     836,    -1,   838,   839,    -1,    -1,    -1,    -1,   459,    -1,
      -1,    -1,    -1,   860,   861,    -1,   863,   864,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1293,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     511,    -1,    -1,    15,    16,    -1,    -1,    -1,   904,    -1,
      -1,   918,    -1,    -1,    -1,    -1,    -1,  1008,  1009,    -1,
      -1,   532,    -1,    -1,   931,   921,    -1,   538,    -1,    -1,
     926,   927,    -1,    -1,    -1,    -1,   932,   933,    -1,    -1,
      52,    53,    -1,    -1,    -1,   941,   942,    78,    79,    80,
      81,    82,    83,    84,    85,    67,    87,    88,    -1,    -1,
      -1,   957,   969,    -1,    95,    96,   577,   578,    -1,   580,
     581,    -1,  1063,  1064,    -1,    -1,  1067,    -1,   589,    -1,
     976,    93,    94,   594,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,  1084,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   999,  1000,  1001,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
    1016,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1119,   640,
      -1,   642,    -1,    -1,    -1,    -1,    -1,  1033,    -1,   650,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,
    1141,   662,   663,  1144,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   672,   673,    -1,    -1,    -1,    -1,  1158,  1159,  1160,
      -1,    -1,  1163,  1164,    -1,    -1,    -1,  1168,  1169,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   700,
      -1,    -1,    -1,    -1,     1,   706,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   221,
      -1,    -1,    -1,    -1,    -1,  1111,    -1,    -1,  1114,  1115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,   247,    -1,  1133,   250,   251,
    1136,    -1,    -1,  1150,   256,    52,    53,    -1,    -1,    56,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1155,
      -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,
      -1,  1177,  1273,    -1,    -1,    -1,  1277,  1278,    -1,    -1,
      -1,    98,    99,   100,  1190,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   323,    -1,   325,   326,   327,   328,    -1,   330,   331,
       1,    -1,    -1,    -1,    -1,   836,    -1,   838,   839,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
      -1,    -1,    -1,    -1,    -1,    -1,  1337,  1243,    -1,    -1,
      -1,    -1,    -1,    -1,  1250,  1251,    -1,    -1,  1254,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    53,    -1,    -1,    56,   388,    -1,   390,    -1,
      -1,    -1,    -1,   395,   396,   397,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   904,    -1,    -1,    -1,  1293,    -1,   411,
      -1,    -1,    -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,
     921,    -1,    -1,    -1,   221,   926,   927,    98,    99,   100,
      -1,   932,   933,   435,    -1,    -1,    -1,    -1,    -1,    -1,
     941,   942,    -1,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   957,   459,    -1,   256,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   976,   273,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
     492,    -1,    -1,    -1,    95,    96,   293,    -1,   999,  1000,
    1001,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,
      -1,    -1,    -1,  1008,  1009,  1016,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,    -1,    -1,
     532,    -1,  1033,    -1,    -1,   136,   538,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
     221,    -1,    -1,    -1,   351,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1063,  1064,
      -1,    -1,  1067,    -1,    -1,   577,   578,    -1,   580,   581,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   589,    -1,  1084,
      -1,    -1,   594,   390,    -1,    -1,    -1,    -1,    -1,   396,
     397,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1111,    -1,    -1,  1114,  1115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   293,    -1,  1119,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1133,    -1,    -1,  1136,    -1,    -1,   640,    -1,
     642,    -1,    -1,    -1,    -1,    -1,  1141,    -1,   650,  1144,
      -1,    -1,   323,    -1,  1155,    -1,    -1,    -1,   660,    -1,
     662,   663,    -1,  1158,  1159,  1160,    -1,    -1,  1163,  1164,
     672,   673,    -1,  1168,  1169,    -1,  1177,    -1,    -1,    -1,
     351,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1190,
      -1,    -1,    -1,    -1,    -1,   492,  1008,  1009,   700,    -1,
      -1,    -1,    -1,    -1,   706,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   509,    -1,    -1,    -1,    -1,    -1,    -1,   390,
      -1,    -1,    -1,    -1,    -1,   396,   397,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,    -1,    -1,
      -1,   538,  1243,    -1,    -1,    -1,    -1,    -1,    -1,  1250,
    1251,  1063,  1064,  1254,    -1,  1067,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1084,    -1,    55,    -1,    -1,    -1,  1273,    -1,
      -1,   578,  1277,  1278,   581,    -1,    -1,    -1,    -1,     1,
      -1,    -1,  1293,    -1,   591,    -1,    -1,   594,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1119,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1141,
      -1,    -1,  1144,    -1,   836,    -1,   838,   839,   509,    -1,
      52,    53,  1337,   640,    56,   642,  1158,  1159,  1160,    -1,
      -1,  1163,  1164,    -1,    -1,    -1,  1168,  1169,    -1,    -1,
      -1,   532,    -1,    -1,    -1,   662,    -1,   538,    -1,    -1,
      -1,    -1,    -1,    85,    -1,   672,   673,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    99,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1008,  1009,    -1,
      -1,    -1,   904,    -1,    -1,    -1,    -1,   578,    -1,   706,
     581,    -1,    -1,    -1,    -1,   712,    -1,    -1,    -1,   921,
     591,    -1,    -1,   594,   926,   927,    -1,    -1,    -1,    -1,
     932,   933,    -1,    -1,    -1,    -1,    -1,    -1,   219,   941,
     942,   222,   223,   224,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1063,  1064,    -1,   957,  1067,    -1,    -1,    -1,
      -1,  1273,    -1,    -1,    -1,  1277,  1278,    -1,    -1,   640,
      -1,   642,     1,  1084,   976,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   786,
      -1,   662,    -1,    -1,    -1,    -1,    -1,   999,  1000,  1001,
      -1,   672,   673,    -1,    -1,    -1,    -1,    -1,  1119,   221,
      -1,    -1,    -1,    -1,  1016,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    53,  1337,    -1,    56,    -1,    -1,
    1141,  1033,    -1,  1144,    -1,   706,    -1,    -1,    -1,   836,
      -1,   712,   839,    -1,   256,    -1,    -1,  1158,  1159,  1160,
     721,    -1,  1163,  1164,    -1,    -1,    85,  1168,  1169,    -1,
      -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      99,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,     0,
      -1,   293,    -1,    -1,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    -1,    -1,  1111,
      -1,   323,  1114,  1115,    -1,   786,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,   926,
     927,  1133,    -1,    -1,  1136,   932,   933,    -1,    -1,   351,
     352,    -1,    -1,    -1,   941,    -1,    -1,    68,    69,    -1,
      -1,    -1,    -1,  1155,    -1,    -1,    -1,    -1,    -1,    -1,
     957,    -1,  1273,    -1,    -1,   836,  1277,  1278,   839,    -1,
       1,    -1,    -1,   454,   455,  1177,    97,    98,   390,   976,
      -1,    -1,   463,    -1,   396,   397,    -1,    -1,  1190,    -1,
      -1,    -1,   221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     121,    -1,   999,  1000,  1001,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   496,    -1,    -1,   499,  1016,
      -1,    52,    53,    -1,    -1,    -1,  1337,   256,    -1,    -1,
      -1,   152,   153,    -1,   155,    -1,  1033,   158,   159,    -1,
     161,  1243,    -1,    -1,   273,    -1,    -1,    -1,  1250,  1251,
      -1,    -1,  1254,    -1,    -1,   926,   927,    -1,    -1,    -1,
      -1,   932,   933,    -1,   293,    -1,    -1,    98,    -1,    -1,
     941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     492,    -1,    -1,    -1,    -1,    -1,   957,   568,    -1,    -1,
      -1,  1293,     1,    -1,   323,    -1,    -1,   509,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   976,    -1,    -1,   589,    -1,
    1107,    -1,    -1,   594,  1111,    -1,    -1,  1114,  1115,    -1,
     532,    -1,   351,   352,    -1,    -1,   538,    -1,   999,  1000,
    1001,    -1,    -1,    -1,    -1,    -1,  1133,    -1,    -1,  1136,
      -1,    -1,    -1,    52,    53,  1016,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,  1033,    -1,    -1,    -1,   578,   396,   397,   581,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   591,
    1177,    -1,   594,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,    -1,    -1,  1190,    -1,   676,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1202,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   694,    -1,   696,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,   640,    -1,
     642,    -1,    -1,    -1,    -1,    -1,  1107,    -1,    -1,    -1,
    1111,    -1,   273,  1114,  1115,    -1,    -1,    -1,    -1,    -1,
     662,    -1,    -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,
     672,   673,  1133,   492,    -1,  1136,    -1,  1264,    -1,   750,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     509,    -1,    -1,    -1,  1008,  1009,    -1,    -1,    -1,    -1,
      -1,    -1,   323,    -1,   706,    -1,  1293,   778,    -1,    -1,
     712,    -1,    -1,   532,    -1,    -1,  1177,    -1,    -1,   538,
      -1,    -1,   221,    -1,    -1,    -1,    -1,    -1,    -1,  1190,
     351,    -1,    -1,    -1,    -1,    -1,    -1,   808,    -1,    -1,
      -1,  1202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1063,
    1064,    -1,    -1,  1067,    -1,   826,    -1,   256,    -1,   578,
      -1,    -1,   581,    -1,    -1,    -1,    -1,    -1,    -1,   390,
    1084,    -1,   591,    -1,   273,   396,   397,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   786,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1254,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1264,    -1,  1119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   640,    -1,   642,   323,    -1,    -1,  1141,    -1,    -1,
    1144,    -1,  1293,    -1,   836,    -1,    -1,   839,    -1,    -1,
      -1,    -1,   913,   662,  1158,  1159,  1160,    -1,    -1,  1163,
    1164,    -1,   351,    -1,  1168,  1169,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   936,    -1,    -1,    -1,    -1,
      -1,   492,    -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   390,    -1,   712,    -1,    -1,    -1,   396,   397,    -1,
      -1,    -1,   973,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   532,    -1,  1008,  1009,    -1,    -1,   538,    -1,    -1,
      -1,    -1,    -1,    -1,   926,   927,   997,    -1,    -1,    -1,
     932,   933,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   941,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   957,    -1,   578,    -1,  1273,
     581,  1032,    -1,  1277,  1278,    -1,    -1,   786,  1063,  1064,
      -1,    -1,  1067,   594,   976,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1084,
      -1,    -1,    -1,   492,    -1,    -1,    -1,   999,  1000,  1001,
    1008,  1009,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1016,    -1,    -1,   836,    -1,   640,
     839,   642,    -1,  1337,  1119,    -1,    -1,    -1,    -1,    -1,
      -1,  1033,    -1,   532,    -1,    -1,    -1,    -1,    -1,   538,
      -1,   662,    -1,    -1,    -1,  1116,  1141,    -1,    -1,  1144,
      -1,   672,   673,    -1,    -1,  1063,  1064,    -1,    -1,  1067,
      -1,    -1,    -1,  1158,  1159,  1160,    -1,    -1,  1163,  1164,
      -1,    -1,    -1,  1168,  1169,    -1,  1084,    -1,    -1,   578,
      -1,    -1,   581,    -1,    -1,   706,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   594,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1107,    -1,    -1,    -1,  1111,
      -1,  1119,  1114,  1115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1133,    -1,  1141,  1136,    -1,  1144,    -1,   957,    -1,
      -1,   640,    -1,   642,    -1,    -1,    -1,    -1,    -1,    -1,
    1158,  1159,  1160,    -1,    -1,  1163,  1164,   976,    -1,    -1,
    1168,  1169,    -1,   662,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   672,   673,  1177,    -1,    -1,  1273,    -1,
     999,  1000,  1277,  1278,    -1,    -1,    -1,    -1,  1190,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1202,    -1,    -1,    -1,    -1,    -1,    -1,   706,    -1,    -1,
      -1,    -1,    -1,    -1,  1033,   836,    -1,    -1,   839,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1254,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1264,    -1,    -1,  1273,    -1,    -1,    -1,  1277,
    1278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1107,    -1,
      -1,  1293,  1111,    -1,    -1,  1114,  1115,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   926,   927,    -1,    -1,    -1,
      -1,   932,   933,    -1,  1133,    -1,    -1,  1136,    -1,    -1,
     941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1337,
      -1,    -1,    -1,    -1,    -1,    -1,   957,   836,    -1,    -1,
     839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    15,    16,   976,    -1,    -1,  1177,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1190,    -1,    -1,    -1,    -1,    -1,    -1,   999,  1000,
    1001,    -1,    -1,  1202,    -1,    47,    48,    49,    50,    -1,
      -1,    -1,    54,    55,    -1,  1016,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    68,    -1,    -1,    -1,
      -1,    -1,  1033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   926,   927,    -1,
      -1,    -1,    -1,   932,   933,  1254,    -1,    -1,    -1,    -1,
     102,    -1,   941,    -1,    -1,  1264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   957,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1293,    -1,    -1,   976,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1107,    -1,    -1,    -1,
    1111,    -1,    -1,  1114,  1115,    -1,    -1,    -1,    -1,    -1,
     999,  1000,  1001,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0,    -1,  1133,    -1,    -1,  1136,    -1,  1016,     8,     9,
      10,    -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,  1033,    25,    26,    27,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,
      40,    41,    42,    43,    44,    -1,  1177,   219,    -1,    -1,
     222,   223,   224,    -1,   226,    -1,    -1,    -1,    -1,  1190,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      -1,    -1,    -1,   245,    -1,   247,    -1,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    -1,
      -1,   101,  1111,    -1,    -1,  1114,  1115,   107,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   121,    -1,  1254,  1133,    -1,    -1,  1136,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,    -1,    -1,
      -1,    -1,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,  1293,    -1,    -1,    -1,    -1,    -1,  1177,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1190,    -1,    -1,   356,   357,   358,   359,   360,    -1,
      -1,   363,   364,   365,   366,   367,   368,   369,   370,    -1,
     372,    -1,    -1,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,    -1,    -1,    -1,   388,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1254,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   454,   455,  1293,    -1,    -1,   459,    -1,    -1,
      -1,   463,     0,   465,    -1,    -1,    -1,    -1,    -1,    -1,
       8,     9,    10,    -1,    -1,    13,    14,    15,    -1,    17,
      -1,   483,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,
      28,    29,    -1,    -1,   496,    -1,    -1,   499,    -1,    37,
      38,    -1,    40,    41,    42,    43,    44,    -1,    -1,   511,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   529,    -1,    -1,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    -1,    -1,    -1,    -1,    95,    96,    97,
      98,    -1,   100,   101,    -1,    -1,   568,    -1,    -1,   107,
      -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,   580,    -1,
      -1,    -1,    -1,   121,    -1,    -1,   124,   589,    -1,    -1,
      -1,    -1,   594,    -1,    -1,    -1,    -1,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   650,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     672,   673,    -1,    -1,   676,   677,   678,   679,    -1,     0,
       1,    -1,     3,     4,     5,     6,     7,    -1,   690,   691,
      11,    12,   694,    -1,   696,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,   706,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,   750,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,   778,    -1,    99,    -1,
      -1,   102,   103,    -1,   105,   106,    -1,   108,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,    -1,    -1,    -1,    -1,    -1,   808,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    -1,   826,    -1,    -1,   148,   149,   150,
      -1,    -1,    -1,    -1,   155,    -1,    -1,    -1,    -1,    -1,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   856,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    -1,    -1,
      -1,    -1,    95,    96,    -1,    -1,    -1,    -1,   101,    -1,
      -1,    -1,   904,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   921,
      -1,    -1,    -1,   925,   926,   927,    -1,    -1,    -1,    -1,
     932,   933,    -1,   136,   936,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,   948,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   966,   967,   968,    -1,   970,   971,
      -1,   973,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   993,   994,    -1,    -1,   997,    -1,    -1,    -1,  1001,
    1002,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1016,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1032,    -1,    -1,    -1,    -1,    -1,     0,     1,  1040,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    -1,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,  1116,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,   121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,    -1,    -1,   153,
      -1,    -1,    -1,    -1,    -1,   159,    -1,   161,     0,     1,
      -1,     3,     4,     5,     6,     7,    -1,    -1,    -1,    11,
      12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,  1243,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    76,    77,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
     102,   103,    -1,   105,   106,    -1,   108,    -1,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,    -1,
      -1,     0,     1,   155,     3,     4,     5,     6,     7,   161,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,   108,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     8,     9,    10,    -1,
      -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,   148,
     149,   150,    -1,    25,   153,    27,    28,    29,    -1,    -1,
      -1,    -1,   161,    -1,    -1,    37,    38,    -1,    40,    41,
      42,    43,    44,    -1,    -1,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    -1,
      -1,    -1,    -1,    95,    96,    -1,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    -1,
      -1,    -1,    -1,    95,    96,    97,    98,    -1,   100,   101,
      -1,    -1,    -1,    -1,   136,   107,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,   121,
      -1,    -1,   124,   155,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
      -1,   153,   154,   155,   156,     0,    -1,   159,   160,   161,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    -1,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      95,    96,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    -1,   100,   101,    -1,    -1,    -1,
      -1,   136,   107,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,   121,    -1,    -1,   124,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,   154,
     155,   156,     0,    -1,   159,   160,   161,    -1,    -1,    -1,
       8,     9,    10,    -1,    -1,    13,    14,    15,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,
      28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      38,    -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,
      68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    -1,    -1,    -1,    -1,    95,    96,    97,
      98,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,   107,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
      -1,    -1,    -1,   121,    -1,    -1,   124,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
      -1,    -1,    -1,    -1,   152,   153,   154,   155,   156,     0,
      -1,   159,   160,   161,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    -1,    -1,
     101,    -1,    -1,    -1,    -1,    -1,   107,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
     121,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,   156,     0,    -1,   159,   160,
     161,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,
      14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    -1,    27,    28,    29,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,    43,
      44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    -1,    -1,    -1,
      -1,    95,    96,    97,    98,    -1,    -1,   101,    -1,    -1,
      -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,    -1,
     124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,   153,
     154,   155,   156,     0,    -1,   159,   160,   161,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    13,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,    -1,    -1,    -1,   152,   153,   154,   155,   156,
       0,   158,   159,   160,   161,    -1,    -1,    -1,     8,     9,
      10,    -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    25,    -1,    27,    28,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,
      40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    -1,    -1,    -1,    -1,    95,    96,    97,    98,    -1,
     100,   101,    -1,    -1,    -1,    -1,    -1,   107,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   135,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,    -1,    -1,
      -1,    -1,   152,   153,   154,   155,   156,     0,    -1,   159,
     160,   161,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    -1,    27,    28,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    -1,    -1,   101,    -1,
      -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   136,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,    -1,
     153,   154,   155,   156,     0,   158,   159,   160,   161,    -1,
      -1,    -1,     8,     9,    10,    44,    -1,    -1,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    37,    38,    -1,    40,    41,    42,    43,    44,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,    -1,
      -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,    95,
      96,    97,    98,    -1,   100,   101,    -1,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,    -1,    -1,   121,    -1,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   135,
     136,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,    -1,    -1,    -1,   152,   153,   154,   155,
     156,     0,    -1,   159,    -1,   161,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    -1,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    95,    96,    97,    98,
      -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   135,   136,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
      -1,    -1,    -1,   152,   153,   154,   155,   156,     0,    -1,
     159,    -1,   161,    -1,    -1,    -1,     8,     9,    10,    -1,
      -1,    -1,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    25,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,
      42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    -1,
      -1,    -1,    -1,    95,    96,    97,    98,    -1,   100,   101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   121,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   135,   136,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,    -1,    -1,    -1,
     152,   153,   154,   155,   156,     0,    -1,   159,    -1,   161,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    -1,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    -1,   100,   101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,   136,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,   156,    -1,    -1,   159,     1,   161,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,
     106,    -1,   108,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,    -1,    -1,    -1,     1,   155,
       3,     4,     5,     6,     7,   161,    -1,    10,    11,    12,
      -1,    14,    15,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,    -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   148,   149,   150,    -1,    -1,
      -1,     1,   155,     3,     4,     5,     6,     7,   161,    -1,
      10,    11,    12,    -1,    -1,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,   102,   103,    -1,   105,   106,    -1,   108,    -1,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,
     150,    -1,    -1,    -1,     1,   155,     3,     4,     5,     6,
       7,   161,    -1,    10,    11,    12,    -1,    -1,    15,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    25,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,
      -1,   108,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,   150,    -1,    -1,    -1,     1,   155,     3,
       4,     5,     6,     7,   161,    -1,    10,    11,    12,    -1,
      -1,    15,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,    -1,    -1,    -1,
       1,   155,     3,     4,     5,     6,     7,   161,     9,    10,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,    -1,   105,   106,    -1,   108,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
      -1,    -1,    -1,     1,   155,     3,     4,     5,     6,     7,
     161,    -1,    10,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,    -1,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,
     108,    -1,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   149,   150,    -1,    -1,    -1,     1,   155,     3,     4,
       5,     6,     7,   161,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,   108,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   148,   149,   150,    -1,    -1,    -1,    -1,
     155,    -1,    -1,    -1,   159,     1,   161,     3,     4,     5,
       6,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,
     106,    -1,   108,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,    -1,    -1,    -1,    -1,   155,
      -1,    -1,    -1,   159,     1,   161,     3,     4,     5,     6,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,
      -1,   108,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,   150,    -1,    -1,   153,     1,   155,     3,
       4,     5,     6,     7,   161,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,   149,   150,    -1,    -1,   153,
       1,   155,     3,     4,     5,    -1,     7,   161,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,    -1,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,
      -1,    -1,    -1,    -1,   155,    -1,    -1,    -1,    -1,    -1,
     161,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,   149,   150,    -1,
      -1,    -1,    -1,    -1,    -1,   157,   158,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,
      -1,   157,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    -1,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,
      -1,   112,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,   149,   150,
      -1,    -1,    -1,    -1,    -1,    -1,   157,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    -1,    -1,
      56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   108,   109,    -1,    -1,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,
      -1,   157,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    -1,    -1,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,   149,   150,
       3,     4,     5,    -1,     7,    -1,   157,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,    -1,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,   148,    30,    31,    32,    33,
      34,    35,    36,   156,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,   148,    30,    31,    32,    33,    34,
      35,    36,   156,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,   148,   149,   150,    11,    12,    -1,    -1,
     155,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,     3,     4,
       5,     6,     7,   148,   149,   150,    11,    12,    -1,    -1,
     155,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,   108,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,     1,    -1,     3,
       4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,   148,   149,   150,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,   148,   149,   150,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,    -1,   105,   106,    -1,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,
      12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,   148,   149,   150,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
     102,   103,    -1,   105,   106,    -1,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   148,   149,   150,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,    -1,   105,   106,    -1,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,
      -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,   148,   149,   150,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,   102,   103,    -1,   105,   106,    -1,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,   148,   149,
     150,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,   148,
     149,   150,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
     148,   149,   150,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,
      -1,    -1,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,   148,   149,   150,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,
     106,    -1,   108,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,   148,   149,   150,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,   108,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,   148,   149,   150,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,   148,   149,   150,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,    -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,    -1,    -1,
      -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,
      12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,
      22,    23,    24,    -1,    -1,   148,   149,   150,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
     102,   103,    -1,   105,   106,    -1,   108,    -1,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   148,   149,   150,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,    -1,   105,   106,    -1,   108,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,
      -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,   148,   149,   150,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,   102,   103,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,   148,   149,
     150,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,   148,
     149,   150,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,    -1,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
     148,   149,   150,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,    -1,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,   148,   149,   150,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,   148,   149,   150,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,     3,
       4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,
      -1,    -1,    16,    -1,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,   148,   149,   150,    30,    31,    32,    33,
      34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,
      -1,   105,   106,    -1,   108,    -1,    -1,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,   148,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,
     105,   106,    -1,   108,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,     3,     4,     5,
      -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,
      16,    -1,    18,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,   148,    30,    31,    32,    33,    34,    35,
      36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,    -1,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,   148,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    -1,    -1,     3,     4,     5,    -1,     7,
      -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      -1,   148,    30,    31,    32,    33,    34,    35,    36,    -1,
      -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,
      -1,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
     148,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,    -1,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,
      -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,   148,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,   102,   103,    -1,   105,   106,    33,    34,    35,
      36,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    -1,    58,    59,    60,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,
      -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
     106,    -1,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,    -1,    -1,    -1,    -1,
      33,    34,    35,    36,    -1,    -1,    -1,    52,    53,    -1,
      -1,    56,    -1,    -1,    -1,   141,    49,    50,    51,    52,
      -1,    -1,   148,    56,    -1,    -1,    59,    60,    61,    62,
      63,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,
      -1,    -1,    -1,   108,   109,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,    -1,    -1,
      -1,    -1,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,   149,   150,    52,    53,   141,    -1,
      56,    -1,   157,   158,    -1,   148,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,   149,   150,    52,    53,    -1,    -1,    56,
      -1,   157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    -1,
      87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,   149,   150,    52,    53,    -1,    -1,    56,    -1,
     157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
      -1,   149,   150,    52,    53,    -1,    -1,    56,    -1,   157,
     158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    87,    88,
      -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
     149,   150,    52,    53,    -1,    -1,    56,    -1,   157,   158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,    -1,   149,
     150,    52,    53,    -1,    -1,    56,    -1,   157,   158,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,   149,   150,
      52,    53,    -1,    -1,    56,    -1,   157,   158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,    -1,   149,   150,    52,
      53,    -1,    -1,    56,    -1,   157,   158,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   108,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,    -1,   149,   150,    52,    53,
      -1,    -1,    56,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   108,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,    -1,   149,   150,    52,    53,    -1,
      -1,    56,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   108,   109,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,    -1,   149,   150,    52,    53,    -1,    -1,
      56,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,    -1,   149,   150,    52,    53,    -1,    -1,    56,
      -1,   157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    -1,
      87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,    -1,   149,   150,    52,    53,    -1,    -1,    56,    -1,
     157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     108,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
      -1,   149,   150,    52,    53,    -1,    -1,    56,    -1,   157,
     158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    87,    88,
      -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,    -1,
     149,   150,    52,    53,    -1,    -1,    56,    -1,   157,   158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,    -1,   149,
     150,    52,    53,    -1,    -1,    56,    -1,   157,   158,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,    -1,   149,   150,
      -1,    -1,    -1,    -1,    -1,    -1,   157
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   164,   165,     1,     3,     4,     5,     6,     7,    11,
      12,    16,    18,    19,    20,    21,    22,    23,    24,    30,
      31,    32,    33,    34,    35,    36,    39,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      59,    60,    61,    62,    63,    64,    65,    76,    77,    91,
      92,    99,   102,   103,   105,   106,   108,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   148,   149,   150,   167,
     168,   169,   181,   183,   184,   188,   192,   194,   199,   200,
     202,   203,   204,   206,   207,   208,   210,   211,   220,   223,
     242,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   271,   272,   302,   307,   308,   356,   357,   358,
     359,   360,   361,   363,   364,   367,   368,   370,   371,   372,
     373,   386,   387,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   432,   444,     0,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    56,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    87,    88,
      93,    94,    95,    96,   108,   109,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   149,   150,   157,   214,
     215,   216,   218,   219,   386,   180,   180,   180,    39,    58,
      99,   102,   108,   109,   110,   113,   149,   192,   194,   203,
     211,   220,   227,   233,   236,   238,   239,   252,   393,   394,
     396,   397,   430,   431,   233,   158,   230,   234,   235,   155,
     158,   186,    54,   215,   186,   152,   170,   171,   224,   444,
      21,    22,    32,   202,   220,   252,   271,   272,   220,   220,
     220,    56,    47,   102,   176,   177,   178,   183,   205,   206,
     444,   176,   228,   238,   430,   444,   227,   429,   430,   444,
      46,    99,   148,   156,   192,   194,   210,   242,   252,   393,
     394,   397,   300,   214,   376,   388,   392,   376,   377,   378,
     162,   362,   362,   362,   362,   391,   199,   220,   220,   155,
     161,   166,   442,   443,   180,    40,    41,    42,    43,    44,
      37,    38,   158,   400,   401,   402,   403,   444,   400,   402,
      26,   152,   230,   235,   263,   309,    28,   264,   306,   135,
     156,   102,   108,   207,   135,    25,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    95,
      96,   101,   136,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   222,   222,    69,    97,    98,   154,   436,
     243,     1,   188,   195,   195,   196,   198,   198,   166,   195,
     443,    99,   204,   211,   252,   277,   393,   394,   397,    52,
      56,    95,    99,   212,   213,   252,   393,   394,   397,   213,
      33,    34,    35,    36,    49,    50,    51,    52,    56,   158,
     191,   214,   395,   427,   233,   158,   235,    98,   436,   437,
     309,   359,   100,   100,   156,   227,    56,   227,   227,   227,
     376,   400,   400,   135,   101,   156,   237,   444,    98,   154,
     436,   100,   100,   156,   237,    92,   232,   233,   238,   410,
     430,   444,   233,   186,   188,   438,   188,    54,    64,    65,
     182,   158,   224,   225,   167,    98,   436,   100,   179,   205,
     159,   166,   443,   438,   244,   160,   156,   186,   441,   156,
     441,   153,   441,   186,    56,   391,   207,   209,   401,   156,
      98,   154,   436,   297,    66,   120,   122,   123,   379,   120,
     120,   379,    67,   379,   162,   365,   374,   369,   375,    78,
     161,   169,   152,   195,   195,   195,   195,   224,   226,   188,
     188,    52,    54,    55,    56,    57,    58,    78,    92,   102,
     108,   109,   110,   142,   145,   282,   344,   404,   405,   406,
     407,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     419,   420,   421,   422,   423,   424,   425,   135,   250,   409,
     135,   251,   310,   311,   107,   201,   312,   313,   313,   224,
     205,   156,   210,   156,   224,   190,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   189,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,    52,    53,    56,   218,   230,   432,   433,   434,   232,
     238,    52,    53,    56,   218,   230,   433,   174,   176,    13,
     273,   442,   273,   195,   176,   176,   246,   166,    56,    98,
     154,   436,    25,   195,    52,    56,   212,   139,   399,    98,
     154,   436,   249,   428,    69,    98,   435,   233,   438,    52,
      56,   433,   224,   224,   217,   100,   125,   135,   135,   224,
     227,   227,   236,   239,   430,    52,    56,   232,    52,    56,
     224,   224,   431,   438,   156,   438,   156,   159,   438,   215,
     225,   220,   153,    56,   433,   433,   224,   171,   438,   178,
     159,   430,   156,   209,    52,    56,   232,    52,    56,   298,
     381,   380,   120,   366,   379,    66,   120,   120,   366,    66,
     120,   220,   176,   183,   102,   108,   278,   279,   280,   281,
     412,   156,   426,   444,   156,   426,   156,   408,   438,   283,
     284,   156,   408,   227,    34,    52,    52,   156,   408,    52,
      39,   185,   203,   220,   221,   174,   442,   185,   221,   174,
     297,   153,   311,   297,    10,    68,   270,   270,   108,   199,
     227,   238,   240,   241,   438,   209,   156,    99,   184,   187,
     199,   211,   220,   227,   229,   241,   252,   397,   319,   319,
     186,   100,   100,   152,   230,   235,   186,   439,   156,   100,
     100,   230,   231,   235,   444,   270,   224,   176,    13,   176,
      27,   274,   442,   270,   270,    17,   267,   315,    25,   245,
     321,    52,    56,   232,    52,    56,   198,   248,   398,   247,
      52,    56,   212,   232,   174,   188,   193,   438,   231,   235,
     187,   220,   229,   187,   229,   215,   224,   227,    39,   237,
     100,   100,   439,   100,   100,   410,   430,   188,   187,   229,
     441,   207,   439,   299,   382,   385,   392,   397,   362,   379,
     362,   362,   362,   153,   280,   412,   156,   438,   156,   425,
     417,   419,   421,   405,   406,   415,   423,   135,   227,   407,
     414,   423,   413,   415,   186,    44,    44,   270,   270,   298,
     153,   298,   227,   156,    44,   209,    56,    44,   135,    44,
      98,   154,   436,   317,   317,   137,   224,   224,   311,   201,
     160,   100,   224,   224,   201,     8,   265,   352,   444,    14,
      15,   268,   269,   275,   276,   444,   276,   197,   108,   227,
     314,   270,   319,   315,   270,   439,   176,   442,   195,   174,
     439,   270,   438,   191,   309,   306,   186,   224,   224,   100,
     224,   224,   438,   156,   438,   180,   383,   438,   278,   281,
     279,   426,   156,   408,   156,   408,   156,   408,   156,   408,
     408,   185,   221,   226,   226,   299,   299,   108,   227,   226,
     226,   224,   226,    52,    56,   232,    52,    56,   318,   318,
     220,   187,   229,   187,   229,   153,   224,   187,   229,   187,
     229,   227,   241,   353,   444,   175,   268,   176,   195,   270,
     270,   227,   156,   273,   317,   270,   270,   174,   442,   270,
     224,   158,   303,   409,   176,   156,   156,   415,   415,   423,
     415,   220,   220,   180,   180,   227,   183,   183,   220,   439,
      52,    56,    58,    91,    92,    99,   102,   105,   106,   108,
     113,   141,   302,   324,   325,   326,   327,   330,   334,   335,
     336,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   356,   357,   360,   361,   364,   368,
     371,   373,   394,   419,   324,   187,   229,   101,   354,   444,
       9,   266,   355,   444,   172,   273,   108,   227,   176,   318,
     270,   409,   301,     0,   121,   384,   279,   408,   408,   156,
     408,   408,   140,   292,   293,   444,   292,   347,   347,    56,
     212,   318,   325,   332,   333,   334,   335,   338,   439,   186,
     318,   440,    52,   376,    52,   102,   392,   101,   156,   140,
     156,   156,   325,    89,    90,    98,   154,   158,   328,   329,
      52,    99,   211,   252,   393,   394,   397,   273,   177,   176,
     176,   227,   276,   315,   316,   323,   324,   186,   294,    29,
     124,   304,   415,   282,   285,   286,   288,   289,   291,   294,
     413,   415,   416,   418,   423,   425,   176,   174,   325,   439,
     325,   336,   338,   439,   156,   153,   224,   125,   195,   348,
     332,   336,   330,   337,   338,   113,   341,   345,   347,   347,
     212,   318,   439,   318,   438,   332,   335,   339,   332,   335,
     339,    56,    98,   154,   436,   176,   166,   173,   275,   273,
      40,    41,   161,   159,   305,   176,   408,   426,   156,   426,
     156,   290,   294,   140,   284,   156,   287,   290,    99,   252,
     156,   290,   438,   156,   156,   331,   438,   156,   156,   376,
     438,   438,   438,   439,   439,   439,    52,    56,   232,    52,
      56,   352,   355,   320,   195,   195,    52,   295,   296,   411,
     174,   153,   418,   421,   286,   288,   415,   423,   140,   252,
     289,   423,    56,    98,   415,   337,   339,   337,   336,   338,
     439,   176,   156,   186,   270,   426,   156,   290,   156,   290,
     156,   290,   156,   290,    52,    56,   290,   156,   440,   276,
     321,   322,   296,   415,   415,   423,   415,   290,   290,   156,
     290,   290,   415,   290
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   163,   164,   165,   166,   166,   167,   168,   168,   168,
     169,   169,   170,   171,   172,   173,   174,   175,   174,   176,
     177,   177,   177,   178,   179,   178,   180,   181,   182,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   185,   185,
     186,   186,   185,   187,   187,   187,   188,   188,   188,   188,
     188,   189,   188,   190,   188,   188,   191,   192,   193,   194,
     195,   195,   196,   197,   198,   199,   199,   200,   200,   201,
     202,   203,   203,   203,   203,   203,   203,   203,   203,   203,
     203,   203,   203,   204,   204,   205,   205,   206,   206,   206,
     206,   206,   206,   206,   206,   206,   206,   207,   207,   208,
     208,   209,   209,   210,   210,   210,   210,   210,   210,   210,
     210,   210,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   212,   212,   213,   213,   213,   214,   214,   214,   214,
     214,   215,   215,   216,   217,   216,   218,   218,   218,   218,
     218,   218,   218,   218,   218,   218,   218,   218,   218,   218,
     218,   218,   218,   218,   218,   218,   218,   218,   218,   218,
     218,   218,   218,   218,   218,   218,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   220,   220,   220,   220,   220,   220,   220,   220,
     220,   220,   221,   221,   221,   222,   222,   222,   222,   223,
     223,   224,   225,   226,   227,   228,   228,   228,   228,   229,
     229,   230,   230,   230,   231,   231,   232,   232,   232,   232,
     232,   233,   233,   233,   233,   233,   234,   235,   236,   236,
     237,   237,   238,   238,   238,   238,   239,   239,   240,   240,
     241,   241,   241,   242,   242,   242,   242,   242,   242,   242,
     242,   242,   242,   242,   243,   242,   244,   242,   242,   242,
     242,   242,   242,   242,   242,   242,   242,   242,   242,   242,
     242,   242,   242,   242,   242,   242,   242,   242,   245,   242,
     246,   242,   242,   242,   247,   242,   248,   242,   249,   242,
     250,   242,   251,   242,   242,   242,   242,   242,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   270,   271,   272,
     273,   273,   273,   274,   274,   275,   275,   276,   276,   277,
     277,   278,   278,   279,   279,   280,   280,   280,   280,   280,
     281,   281,   282,   282,   283,   284,   285,   285,   286,   286,
     286,   286,   287,   288,   289,   289,   290,   290,   291,   291,
     291,   291,   291,   291,   291,   291,   291,   291,   291,   291,
     291,   291,   291,   292,   292,   293,   293,   294,   294,   295,
     295,   296,   296,   297,   298,   299,   300,   301,   302,   303,
     303,   304,   305,   304,   306,   307,   307,   307,   307,   308,
     308,   308,   308,   308,   308,   308,   308,   308,   309,   309,
     310,   311,   312,   313,   314,   314,   314,   314,   315,   316,
     316,   317,   318,   319,   320,   321,   322,   322,   323,   323,
     323,   324,   324,   324,   324,   324,   324,   325,   326,   326,
     327,   327,   328,   329,   330,   330,   330,   330,   330,   330,
     330,   330,   330,   330,   330,   330,   330,   331,   330,   330,
     330,   332,   332,   332,   332,   332,   332,   333,   333,   334,
     334,   335,   336,   336,   337,   337,   338,   339,   339,   339,
     339,   340,   340,   341,   341,   342,   342,   343,   343,   344,
     345,   345,   346,   346,   346,   346,   346,   346,   346,   346,
     346,   346,   347,   347,   347,   347,   347,   347,   347,   347,
     347,   347,   348,   349,   349,   350,   351,   351,   351,   352,
     352,   353,   353,   353,   354,   354,   355,   355,   356,   356,
     357,   358,   358,   358,   359,   360,   361,   362,   362,   363,
     364,   365,   365,   366,   366,   367,   368,   369,   369,   370,
     371,   372,   373,   374,   374,   375,   375,   376,   376,   377,
     377,   378,   378,   379,   380,   379,   381,   382,   383,   379,
     384,   384,   385,   385,   386,   386,   387,   388,   388,   389,
     390,   390,   391,   391,   391,   391,   392,   392,   392,   393,
     393,   393,   394,   394,   394,   394,   394,   394,   394,   395,
     395,   396,   396,   397,   397,   398,   399,   399,   400,   400,
     401,   402,   403,   402,   404,   404,   405,   405,   405,   405,
     405,   406,   407,   407,   408,   408,   409,   409,   409,   409,
     409,   409,   409,   409,   409,   409,   409,   409,   409,   409,
     409,   410,   411,   411,   411,   411,   412,   412,   413,   414,
     414,   415,   415,   416,   417,   417,   418,   418,   419,   419,
     420,   421,   421,   422,   422,   423,   423,   424,   424,   425,
     425,   426,   426,   427,   428,   427,   429,   429,   430,   430,
     431,   431,   431,   431,   431,   431,   432,   432,   432,   433,
     433,   434,   434,   434,   435,   435,   436,   436,   437,   437,
     438,   439,   440,   441,   441,   442,   442,   443,   443,   444
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     0,     1,     2,     1,     1,     3,
       1,     2,     1,     3,     0,     0,     8,     0,     5,     2,
       1,     1,     3,     1,     0,     3,     0,     2,     0,     4,
       3,     3,     3,     2,     3,     3,     3,     3,     4,     5,
       1,     4,     4,     7,     4,     1,     1,     4,     4,     7,
       6,     6,     6,     6,     5,     4,     4,     4,     1,     4,
       0,     1,     3,     1,     4,     1,     1,     3,     3,     3,
       2,     0,     7,     0,     7,     1,     1,     2,     0,     5,
       1,     1,     0,     0,     4,     1,     1,     1,     4,     3,
       1,     2,     3,     4,     5,     4,     5,     6,     2,     2,
       2,     2,     2,     1,     3,     1,     3,     1,     2,     3,
       5,     2,     4,     2,     4,     1,     3,     1,     3,     2,
       3,     1,     3,     1,     1,     4,     3,     3,     3,     3,
       2,     1,     1,     1,     4,     3,     3,     3,     3,     2,
       1,     1,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     4,     7,
       6,     6,     6,     6,     5,     4,     3,     3,     2,     2,
       2,     2,     3,     3,     3,     3,     3,     3,     4,     2,
       2,     3,     3,     3,     3,     1,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     3,     3,     4,     6,     4,
       4,     1,     1,     4,     3,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     2,     4,     2,     1,
       4,     3,     5,     3,     1,     1,     1,     1,     2,     4,
       2,     1,     2,     2,     4,     1,     0,     2,     2,     1,
       2,     1,     1,     1,     3,     3,     2,     1,     1,     1,
       3,     4,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     0,     4,     3,     3,
       2,     3,     3,     1,     4,     3,     1,     6,     4,     3,
       2,     1,     2,     1,     6,     6,     4,     4,     0,     6,
       0,     5,     5,     6,     0,     6,     0,     7,     0,     5,
       0,     5,     0,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     5,     1,     2,     1,
       1,     1,     3,     1,     3,     1,     3,     5,     1,     3,
       2,     1,     1,     1,     0,     2,     1,     3,     4,     2,
       2,     1,     1,     3,     1,     3,     2,     0,     6,     8,
       4,     6,     4,     2,     6,     2,     4,     6,     2,     4,
       2,     4,     1,     1,     1,     3,     4,     1,     4,     1,
       3,     1,     1,     0,     0,     0,     0,     0,     9,     4,
       1,     3,     0,     4,     3,     2,     4,     5,     5,     2,
       4,     4,     3,     3,     3,     2,     1,     4,     3,     3,
       0,     7,     0,     7,     1,     2,     3,     4,     5,     1,
       1,     0,     0,     0,     0,     9,     1,     1,     1,     3,
       3,     1,     2,     3,     1,     1,     1,     1,     3,     1,
       3,     1,     2,     2,     1,     1,     4,     4,     4,     3,
       4,     4,     4,     3,     3,     3,     2,     0,     6,     2,
       4,     1,     1,     2,     2,     4,     1,     2,     3,     1,
       3,     5,     2,     1,     1,     3,     1,     3,     1,     2,
       1,     1,     3,     2,     1,     1,     3,     2,     1,     2,
       1,     1,     1,     3,     3,     2,     2,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     4,     2,     3,     1,     6,
       1,     1,     1,     1,     2,     1,     3,     1,     1,     1,
       1,     1,     1,     2,     3,     3,     3,     1,     2,     4,
       1,     0,     3,     1,     2,     4,     1,     0,     3,     4,
       1,     4,     1,     0,     3,     0,     3,     0,     2,     0,
       2,     0,     2,     1,     0,     3,     0,     0,     0,     6,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     3,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     0,     1,     1,
       3,     1,     0,     3,     1,     3,     4,     2,     2,     1,
       1,     3,     1,     3,     2,     0,     6,     8,     4,     6,
       4,     6,     2,     4,     6,     2,     4,     2,     4,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     1,     2,     1,     2,     1,     1,     1,
       1,     2,     1,     1,     1,     2,     1,     1,     1,     2,
       1,     2,     1,     1,     0,     4,     1,     2,     1,     3,
       3,     2,     1,     4,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     1,     2,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, p, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc, p)  YY_LOCATION_PRINT(File, *(Loc), p)

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc, p)  YYLOCATION_PRINT(File, &(Loc), p)

#  else

#   define YYLOCATION_PRINT(File, Loc, p) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location, p) \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, p);          \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct parser_params *p)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (p);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
switch (yykind)
    {
    case YYSYMBOL_keyword_class: /* "'class'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7781 "parse.c"
        break;

    case YYSYMBOL_keyword_module: /* "'module'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7789 "parse.c"
        break;

    case YYSYMBOL_keyword_def: /* "'def'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7797 "parse.c"
        break;

    case YYSYMBOL_keyword_undef: /* "'undef'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7805 "parse.c"
        break;

    case YYSYMBOL_keyword_begin: /* "'begin'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7813 "parse.c"
        break;

    case YYSYMBOL_keyword_rescue: /* "'rescue'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7821 "parse.c"
        break;

    case YYSYMBOL_keyword_ensure: /* "'ensure'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7829 "parse.c"
        break;

    case YYSYMBOL_keyword_end: /* "'end'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7837 "parse.c"
        break;

    case YYSYMBOL_keyword_if: /* "'if'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7845 "parse.c"
        break;

    case YYSYMBOL_keyword_unless: /* "'unless'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7853 "parse.c"
        break;

    case YYSYMBOL_keyword_then: /* "'then'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7861 "parse.c"
        break;

    case YYSYMBOL_keyword_elsif: /* "'elsif'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7869 "parse.c"
        break;

    case YYSYMBOL_keyword_else: /* "'else'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7877 "parse.c"
        break;

    case YYSYMBOL_keyword_case: /* "'case'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7885 "parse.c"
        break;

    case YYSYMBOL_keyword_when: /* "'when'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7893 "parse.c"
        break;

    case YYSYMBOL_keyword_while: /* "'while'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7901 "parse.c"
        break;

    case YYSYMBOL_keyword_until: /* "'until'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7909 "parse.c"
        break;

    case YYSYMBOL_keyword_for: /* "'for'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7917 "parse.c"
        break;

    case YYSYMBOL_keyword_break: /* "'break'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7925 "parse.c"
        break;

    case YYSYMBOL_keyword_next: /* "'next'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7933 "parse.c"
        break;

    case YYSYMBOL_keyword_redo: /* "'redo'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7941 "parse.c"
        break;

    case YYSYMBOL_keyword_retry: /* "'retry'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7949 "parse.c"
        break;

    case YYSYMBOL_keyword_in: /* "'in'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7957 "parse.c"
        break;

    case YYSYMBOL_keyword_do: /* "'do'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7965 "parse.c"
        break;

    case YYSYMBOL_keyword_do_cond: /* "'do' for condition"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7973 "parse.c"
        break;

    case YYSYMBOL_keyword_do_block: /* "'do' for block"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7981 "parse.c"
        break;

    case YYSYMBOL_keyword_do_LAMBDA: /* "'do' for lambda"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7989 "parse.c"
        break;

    case YYSYMBOL_keyword_return: /* "'return'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7997 "parse.c"
        break;

    case YYSYMBOL_keyword_yield: /* "'yield'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8005 "parse.c"
        break;

    case YYSYMBOL_keyword_super: /* "'super'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8013 "parse.c"
        break;

    case YYSYMBOL_keyword_self: /* "'self'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8021 "parse.c"
        break;

    case YYSYMBOL_keyword_nil: /* "'nil'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8029 "parse.c"
        break;

    case YYSYMBOL_keyword_true: /* "'true'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8037 "parse.c"
        break;

    case YYSYMBOL_keyword_false: /* "'false'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8045 "parse.c"
        break;

    case YYSYMBOL_keyword_and: /* "'and'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8053 "parse.c"
        break;

    case YYSYMBOL_keyword_or: /* "'or'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8061 "parse.c"
        break;

    case YYSYMBOL_keyword_not: /* "'not'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8069 "parse.c"
        break;

    case YYSYMBOL_modifier_if: /* "'if' modifier"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8077 "parse.c"
        break;

    case YYSYMBOL_modifier_unless: /* "'unless' modifier"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8085 "parse.c"
        break;

    case YYSYMBOL_modifier_while: /* "'while' modifier"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8093 "parse.c"
        break;

    case YYSYMBOL_modifier_until: /* "'until' modifier"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8101 "parse.c"
        break;

    case YYSYMBOL_modifier_rescue: /* "'rescue' modifier"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8109 "parse.c"
        break;

    case YYSYMBOL_keyword_alias: /* "'alias'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8117 "parse.c"
        break;

    case YYSYMBOL_keyword_defined: /* "'defined?'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8125 "parse.c"
        break;

    case YYSYMBOL_keyword_BEGIN: /* "'BEGIN'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8133 "parse.c"
        break;

    case YYSYMBOL_keyword_END: /* "'END'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8141 "parse.c"
        break;

    case YYSYMBOL_keyword__LINE__: /* "'__LINE__'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8149 "parse.c"
        break;

    case YYSYMBOL_keyword__FILE__: /* "'__FILE__'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8157 "parse.c"
        break;

    case YYSYMBOL_keyword__ENCODING__: /* "'__ENCODING__'"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8165 "parse.c"
        break;

    case YYSYMBOL_tIDENTIFIER: /* "local variable or method"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8173 "parse.c"
        break;

    case YYSYMBOL_tFID: /* "method"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8181 "parse.c"
        break;

    case YYSYMBOL_tGVAR: /* "global variable"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8189 "parse.c"
        break;

    case YYSYMBOL_tIVAR: /* "instance variable"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8197 "parse.c"
        break;

    case YYSYMBOL_tCONSTANT: /* "constant"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8205 "parse.c"
        break;

    case YYSYMBOL_tCVAR: /* "class variable"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8213 "parse.c"
        break;

    case YYSYMBOL_tLABEL: /* "label"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8221 "parse.c"
        break;

    case YYSYMBOL_tINTEGER: /* "integer literal"  */
#line 2624 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8244 "parse.c"
        break;

    case YYSYMBOL_tFLOAT: /* "float literal"  */
#line 2624 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8267 "parse.c"
        break;

    case YYSYMBOL_tRATIONAL: /* "rational literal"  */
#line 2624 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8290 "parse.c"
        break;

    case YYSYMBOL_tIMAGINARY: /* "imaginary literal"  */
#line 2624 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8313 "parse.c"
        break;

    case YYSYMBOL_tCHAR: /* "char literal"  */
#line 2624 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8336 "parse.c"
        break;

    case YYSYMBOL_tNTH_REF: /* "numbered reference"  */
#line 2642 "parse.y"
         {
    rb_parser_printf(p, "$%ld", RNODE_NTH_REF(((*yyvaluep).node))->nd_nth);
}
#line 8344 "parse.c"
        break;

    case YYSYMBOL_tBACK_REF: /* "back reference"  */
#line 2645 "parse.y"
         {
    rb_parser_printf(p, "$%c", (int)RNODE_BACK_REF(((*yyvaluep).node))->nd_nth);
}
#line 8352 "parse.c"
        break;

    case YYSYMBOL_tSTRING_CONTENT: /* "literal content"  */
#line 2624 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8375 "parse.c"
        break;

    case YYSYMBOL_69_: /* '.'  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8383 "parse.c"
        break;

    case YYSYMBOL_70_backslash_: /* "backslash"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8391 "parse.c"
        break;

    case YYSYMBOL_72_escaped_horizontal_tab_: /* "escaped horizontal tab"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8399 "parse.c"
        break;

    case YYSYMBOL_73_escaped_form_feed_: /* "escaped form feed"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8407 "parse.c"
        break;

    case YYSYMBOL_74_escaped_carriage_return_: /* "escaped carriage return"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8415 "parse.c"
        break;

    case YYSYMBOL_75_escaped_vertical_tab_: /* "escaped vertical tab"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8423 "parse.c"
        break;

    case YYSYMBOL_tANDDOT: /* "&."  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8431 "parse.c"
        break;

    case YYSYMBOL_tCOLON2: /* "::"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8439 "parse.c"
        break;

    case YYSYMBOL_tOP_ASGN: /* "operator-assignment"  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8447 "parse.c"
        break;

    case YYSYMBOL_top_compstmt: /* top_compstmt  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8460 "parse.c"
        break;

    case YYSYMBOL_top_stmts: /* top_stmts  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8473 "parse.c"
        break;

    case YYSYMBOL_top_stmt: /* top_stmt  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8486 "parse.c"
        break;

    case YYSYMBOL_block_open: /* block_open  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 8499 "parse.c"
        break;

    case YYSYMBOL_begin_block: /* begin_block  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8512 "parse.c"
        break;

    case YYSYMBOL_bodystmt: /* bodystmt  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8525 "parse.c"
        break;

    case YYSYMBOL_compstmt: /* compstmt  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8538 "parse.c"
        break;

    case YYSYMBOL_stmts: /* stmts  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8551 "parse.c"
        break;

    case YYSYMBOL_stmt_or_begin: /* stmt_or_begin  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8564 "parse.c"
        break;

    case YYSYMBOL_allow_exits: /* allow_exits  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 8577 "parse.c"
        break;

    case YYSYMBOL_stmt: /* stmt  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8590 "parse.c"
        break;

    case YYSYMBOL_command_asgn: /* command_asgn  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8603 "parse.c"
        break;

    case YYSYMBOL_endless_command: /* endless_command  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8616 "parse.c"
        break;

    case YYSYMBOL_command_rhs: /* command_rhs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8629 "parse.c"
        break;

    case YYSYMBOL_expr: /* expr  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8642 "parse.c"
        break;

    case YYSYMBOL_def_name: /* def_name  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8650 "parse.c"
        break;

    case YYSYMBOL_defn_head: /* defn_head  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_def_temp) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_def_temp)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_def_temp)))));
    }
}
#line 8663 "parse.c"
        break;

    case YYSYMBOL_defs_head: /* defs_head  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_def_temp) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_def_temp)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_def_temp)))));
    }
}
#line 8676 "parse.c"
        break;

    case YYSYMBOL_expr_value: /* expr_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8689 "parse.c"
        break;

    case YYSYMBOL_expr_value_do: /* expr_value_do  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8702 "parse.c"
        break;

    case YYSYMBOL_command_call: /* command_call  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8715 "parse.c"
        break;

    case YYSYMBOL_block_command: /* block_command  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8728 "parse.c"
        break;

    case YYSYMBOL_cmd_brace_block: /* cmd_brace_block  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8741 "parse.c"
        break;

    case YYSYMBOL_fcall: /* fcall  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_fcall) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_fcall)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_fcall)))));
    }
}
#line 8754 "parse.c"
        break;

    case YYSYMBOL_command: /* command  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8767 "parse.c"
        break;

    case YYSYMBOL_mlhs: /* mlhs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 8780 "parse.c"
        break;

    case YYSYMBOL_mlhs_inner: /* mlhs_inner  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 8793 "parse.c"
        break;

    case YYSYMBOL_mlhs_basic: /* mlhs_basic  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 8806 "parse.c"
        break;

    case YYSYMBOL_mlhs_item: /* mlhs_item  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8819 "parse.c"
        break;

    case YYSYMBOL_mlhs_head: /* mlhs_head  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8832 "parse.c"
        break;

    case YYSYMBOL_mlhs_post: /* mlhs_post  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8845 "parse.c"
        break;

    case YYSYMBOL_mlhs_node: /* mlhs_node  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8858 "parse.c"
        break;

    case YYSYMBOL_lhs: /* lhs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8871 "parse.c"
        break;

    case YYSYMBOL_cname: /* cname  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8879 "parse.c"
        break;

    case YYSYMBOL_cpath: /* cpath  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8892 "parse.c"
        break;

    case YYSYMBOL_fname: /* fname  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8900 "parse.c"
        break;

    case YYSYMBOL_fitem: /* fitem  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8913 "parse.c"
        break;

    case YYSYMBOL_undef_list: /* undef_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8926 "parse.c"
        break;

    case YYSYMBOL_op: /* op  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8934 "parse.c"
        break;

    case YYSYMBOL_reswords: /* reswords  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8942 "parse.c"
        break;

    case YYSYMBOL_arg: /* arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8955 "parse.c"
        break;

    case YYSYMBOL_endless_arg: /* endless_arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8968 "parse.c"
        break;

    case YYSYMBOL_relop: /* relop  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8976 "parse.c"
        break;

    case YYSYMBOL_rel_expr: /* rel_expr  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8989 "parse.c"
        break;

    case YYSYMBOL_arg_value: /* arg_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9002 "parse.c"
        break;

    case YYSYMBOL_aref_args: /* aref_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9015 "parse.c"
        break;

    case YYSYMBOL_arg_rhs: /* arg_rhs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9028 "parse.c"
        break;

    case YYSYMBOL_paren_args: /* paren_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9041 "parse.c"
        break;

    case YYSYMBOL_opt_paren_args: /* opt_paren_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9054 "parse.c"
        break;

    case YYSYMBOL_opt_call_args: /* opt_call_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9067 "parse.c"
        break;

    case YYSYMBOL_call_args: /* call_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9080 "parse.c"
        break;

    case YYSYMBOL_command_args: /* command_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9093 "parse.c"
        break;

    case YYSYMBOL_block_arg: /* block_arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_block_pass) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_block_pass)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_block_pass)))));
    }
}
#line 9106 "parse.c"
        break;

    case YYSYMBOL_opt_block_arg: /* opt_block_arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_block_pass) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_block_pass)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_block_pass)))));
    }
}
#line 9119 "parse.c"
        break;

    case YYSYMBOL_args: /* args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9132 "parse.c"
        break;

    case YYSYMBOL_arg_splat: /* arg_splat  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9145 "parse.c"
        break;

    case YYSYMBOL_mrhs_arg: /* mrhs_arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9158 "parse.c"
        break;

    case YYSYMBOL_mrhs: /* mrhs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9171 "parse.c"
        break;

    case YYSYMBOL_primary: /* primary  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9184 "parse.c"
        break;

    case YYSYMBOL_primary_value: /* primary_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9197 "parse.c"
        break;

    case YYSYMBOL_k_while: /* k_while  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 9210 "parse.c"
        break;

    case YYSYMBOL_k_until: /* k_until  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 9223 "parse.c"
        break;

    case YYSYMBOL_k_for: /* k_for  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 9236 "parse.c"
        break;

    case YYSYMBOL_k_def: /* k_def  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_def_temp) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_def_temp)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_def_temp)))));
    }
}
#line 9249 "parse.c"
        break;

    case YYSYMBOL_if_tail: /* if_tail  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9262 "parse.c"
        break;

    case YYSYMBOL_opt_else: /* opt_else  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9275 "parse.c"
        break;

    case YYSYMBOL_for_var: /* for_var  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9288 "parse.c"
        break;

    case YYSYMBOL_f_marg: /* f_marg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9301 "parse.c"
        break;

    case YYSYMBOL_f_marg_list: /* f_marg_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9314 "parse.c"
        break;

    case YYSYMBOL_f_margs: /* f_margs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 9327 "parse.c"
        break;

    case YYSYMBOL_f_rest_marg: /* f_rest_marg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9340 "parse.c"
        break;

    case YYSYMBOL_f_any_kwrest: /* f_any_kwrest  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9348 "parse.c"
        break;

    case YYSYMBOL_f_kwarg_f_block_kw: /* f_kwarg_f_block_kw  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 9361 "parse.c"
        break;

    case YYSYMBOL_block_args_tail: /* block_args_tail  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9374 "parse.c"
        break;

    case YYSYMBOL_excessed_comma: /* excessed_comma  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9382 "parse.c"
        break;

    case YYSYMBOL_f_opt_primary_value: /* f_opt_primary_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 9395 "parse.c"
        break;

    case YYSYMBOL_f_optarg_primary_value: /* f_optarg_primary_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 9408 "parse.c"
        break;

    case YYSYMBOL_opt_args_tail_block_args_tail: /* opt_args_tail_block_args_tail  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9421 "parse.c"
        break;

    case YYSYMBOL_block_param: /* block_param  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9434 "parse.c"
        break;

    case YYSYMBOL_opt_block_param: /* opt_block_param  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9447 "parse.c"
        break;

    case YYSYMBOL_block_param_def: /* block_param_def  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9460 "parse.c"
        break;

    case YYSYMBOL_opt_bv_decl: /* opt_bv_decl  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9468 "parse.c"
        break;

    case YYSYMBOL_bv_decls: /* bv_decls  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9476 "parse.c"
        break;

    case YYSYMBOL_bvar: /* bvar  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9484 "parse.c"
        break;

    case YYSYMBOL_numparam: /* numparam  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9497 "parse.c"
        break;

    case YYSYMBOL_it_id: /* it_id  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9505 "parse.c"
        break;

    case YYSYMBOL_lambda: /* lambda  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9518 "parse.c"
        break;

    case YYSYMBOL_f_larglist: /* f_larglist  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9531 "parse.c"
        break;

    case YYSYMBOL_lambda_body: /* lambda_body  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9544 "parse.c"
        break;

    case YYSYMBOL_do_block: /* do_block  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9557 "parse.c"
        break;

    case YYSYMBOL_block_call: /* block_call  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9570 "parse.c"
        break;

    case YYSYMBOL_method_call: /* method_call  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9583 "parse.c"
        break;

    case YYSYMBOL_brace_block: /* brace_block  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9596 "parse.c"
        break;

    case YYSYMBOL_brace_body: /* brace_body  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9609 "parse.c"
        break;

    case YYSYMBOL_do_body: /* do_body  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9622 "parse.c"
        break;

    case YYSYMBOL_case_args: /* case_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9635 "parse.c"
        break;

    case YYSYMBOL_case_body: /* case_body  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9648 "parse.c"
        break;

    case YYSYMBOL_cases: /* cases  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9661 "parse.c"
        break;

    case YYSYMBOL_p_case_body: /* p_case_body  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9674 "parse.c"
        break;

    case YYSYMBOL_p_cases: /* p_cases  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9687 "parse.c"
        break;

    case YYSYMBOL_p_top_expr: /* p_top_expr  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9700 "parse.c"
        break;

    case YYSYMBOL_p_top_expr_body: /* p_top_expr_body  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9713 "parse.c"
        break;

    case YYSYMBOL_p_expr: /* p_expr  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9726 "parse.c"
        break;

    case YYSYMBOL_p_as: /* p_as  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9739 "parse.c"
        break;

    case YYSYMBOL_p_alt: /* p_alt  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9752 "parse.c"
        break;

    case YYSYMBOL_p_expr_basic: /* p_expr_basic  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9765 "parse.c"
        break;

    case YYSYMBOL_p_args: /* p_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9778 "parse.c"
        break;

    case YYSYMBOL_p_args_head: /* p_args_head  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9791 "parse.c"
        break;

    case YYSYMBOL_p_args_tail: /* p_args_tail  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9804 "parse.c"
        break;

    case YYSYMBOL_p_find: /* p_find  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9817 "parse.c"
        break;

    case YYSYMBOL_p_rest: /* p_rest  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9830 "parse.c"
        break;

    case YYSYMBOL_p_args_post: /* p_args_post  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9843 "parse.c"
        break;

    case YYSYMBOL_p_arg: /* p_arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9856 "parse.c"
        break;

    case YYSYMBOL_p_kwargs: /* p_kwargs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9869 "parse.c"
        break;

    case YYSYMBOL_p_kwarg: /* p_kwarg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9882 "parse.c"
        break;

    case YYSYMBOL_p_kw: /* p_kw  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9895 "parse.c"
        break;

    case YYSYMBOL_p_kw_label: /* p_kw_label  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9903 "parse.c"
        break;

    case YYSYMBOL_p_kwrest: /* p_kwrest  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9911 "parse.c"
        break;

    case YYSYMBOL_p_kwnorest: /* p_kwnorest  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9919 "parse.c"
        break;

    case YYSYMBOL_p_any_kwrest: /* p_any_kwrest  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9927 "parse.c"
        break;

    case YYSYMBOL_p_value: /* p_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9940 "parse.c"
        break;

    case YYSYMBOL_p_primitive: /* p_primitive  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9953 "parse.c"
        break;

    case YYSYMBOL_p_variable: /* p_variable  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9966 "parse.c"
        break;

    case YYSYMBOL_p_var_ref: /* p_var_ref  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9979 "parse.c"
        break;

    case YYSYMBOL_p_expr_ref: /* p_expr_ref  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9992 "parse.c"
        break;

    case YYSYMBOL_p_const: /* p_const  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10005 "parse.c"
        break;

    case YYSYMBOL_opt_rescue: /* opt_rescue  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10018 "parse.c"
        break;

    case YYSYMBOL_exc_list: /* exc_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10031 "parse.c"
        break;

    case YYSYMBOL_exc_var: /* exc_var  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10044 "parse.c"
        break;

    case YYSYMBOL_opt_ensure: /* opt_ensure  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10057 "parse.c"
        break;

    case YYSYMBOL_literal: /* literal  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10070 "parse.c"
        break;

    case YYSYMBOL_strings: /* strings  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10083 "parse.c"
        break;

    case YYSYMBOL_string: /* string  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10096 "parse.c"
        break;

    case YYSYMBOL_string1: /* string1  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10109 "parse.c"
        break;

    case YYSYMBOL_xstring: /* xstring  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10122 "parse.c"
        break;

    case YYSYMBOL_regexp: /* regexp  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10135 "parse.c"
        break;

    case YYSYMBOL_words_tWORDS_BEG_word_list: /* words_tWORDS_BEG_word_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10148 "parse.c"
        break;

    case YYSYMBOL_words: /* words  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10161 "parse.c"
        break;

    case YYSYMBOL_word_list: /* word_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10174 "parse.c"
        break;

    case YYSYMBOL_word: /* word  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10187 "parse.c"
        break;

    case YYSYMBOL_words_tSYMBOLS_BEG_symbol_list: /* words_tSYMBOLS_BEG_symbol_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10200 "parse.c"
        break;

    case YYSYMBOL_symbols: /* symbols  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10213 "parse.c"
        break;

    case YYSYMBOL_symbol_list: /* symbol_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10226 "parse.c"
        break;

    case YYSYMBOL_words_tQWORDS_BEG_qword_list: /* words_tQWORDS_BEG_qword_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10239 "parse.c"
        break;

    case YYSYMBOL_qwords: /* qwords  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10252 "parse.c"
        break;

    case YYSYMBOL_words_tQSYMBOLS_BEG_qsym_list: /* words_tQSYMBOLS_BEG_qsym_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10265 "parse.c"
        break;

    case YYSYMBOL_qsymbols: /* qsymbols  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10278 "parse.c"
        break;

    case YYSYMBOL_qword_list: /* qword_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10291 "parse.c"
        break;

    case YYSYMBOL_qsym_list: /* qsym_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10304 "parse.c"
        break;

    case YYSYMBOL_string_contents: /* string_contents  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10317 "parse.c"
        break;

    case YYSYMBOL_xstring_contents: /* xstring_contents  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10330 "parse.c"
        break;

    case YYSYMBOL_regexp_contents: /* regexp_contents  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10343 "parse.c"
        break;

    case YYSYMBOL_string_content: /* string_content  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10356 "parse.c"
        break;

    case YYSYMBOL_string_dvar: /* string_dvar  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10369 "parse.c"
        break;

    case YYSYMBOL_symbol: /* symbol  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10382 "parse.c"
        break;

    case YYSYMBOL_ssym: /* ssym  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10395 "parse.c"
        break;

    case YYSYMBOL_sym: /* sym  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10403 "parse.c"
        break;

    case YYSYMBOL_dsym: /* dsym  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10416 "parse.c"
        break;

    case YYSYMBOL_numeric: /* numeric  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10429 "parse.c"
        break;

    case YYSYMBOL_simple_numeric: /* simple_numeric  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10442 "parse.c"
        break;

    case YYSYMBOL_nonlocal_var: /* nonlocal_var  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10450 "parse.c"
        break;

    case YYSYMBOL_user_variable: /* user_variable  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10458 "parse.c"
        break;

    case YYSYMBOL_keyword_variable: /* keyword_variable  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10466 "parse.c"
        break;

    case YYSYMBOL_var_ref: /* var_ref  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10479 "parse.c"
        break;

    case YYSYMBOL_var_lhs: /* var_lhs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10492 "parse.c"
        break;

    case YYSYMBOL_backref: /* backref  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10505 "parse.c"
        break;

    case YYSYMBOL_superclass: /* superclass  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10518 "parse.c"
        break;

    case YYSYMBOL_f_opt_paren_args: /* f_opt_paren_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10531 "parse.c"
        break;

    case YYSYMBOL_f_paren_args: /* f_paren_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10544 "parse.c"
        break;

    case YYSYMBOL_f_arglist: /* f_arglist  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10557 "parse.c"
        break;

    case YYSYMBOL_f_kwarg_f_kw: /* f_kwarg_f_kw  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 10570 "parse.c"
        break;

    case YYSYMBOL_args_tail: /* args_tail  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10583 "parse.c"
        break;

    case YYSYMBOL_f_opt_arg_value: /* f_opt_arg_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 10596 "parse.c"
        break;

    case YYSYMBOL_f_optarg_arg_value: /* f_optarg_arg_value  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 10609 "parse.c"
        break;

    case YYSYMBOL_opt_args_tail_args_tail: /* opt_args_tail_args_tail  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10622 "parse.c"
        break;

    case YYSYMBOL_f_args: /* f_args  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10635 "parse.c"
        break;

    case YYSYMBOL_args_forward: /* args_forward  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10643 "parse.c"
        break;

    case YYSYMBOL_f_bad_arg: /* f_bad_arg  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10651 "parse.c"
        break;

    case YYSYMBOL_f_norm_arg: /* f_norm_arg  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10659 "parse.c"
        break;

    case YYSYMBOL_f_arg_asgn: /* f_arg_asgn  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10667 "parse.c"
        break;

    case YYSYMBOL_f_arg_item: /* f_arg_item  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args_aux) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args_aux)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args_aux)))));
    }
}
#line 10680 "parse.c"
        break;

    case YYSYMBOL_f_arg: /* f_arg  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args_aux) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args_aux)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args_aux)))));
    }
}
#line 10693 "parse.c"
        break;

    case YYSYMBOL_f_label: /* f_label  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10701 "parse.c"
        break;

    case YYSYMBOL_f_kw: /* f_kw  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 10714 "parse.c"
        break;

    case YYSYMBOL_f_block_kw: /* f_block_kw  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 10727 "parse.c"
        break;

    case YYSYMBOL_f_no_kwarg: /* f_no_kwarg  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10735 "parse.c"
        break;

    case YYSYMBOL_f_kwrest: /* f_kwrest  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10743 "parse.c"
        break;

    case YYSYMBOL_f_rest_arg: /* f_rest_arg  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10751 "parse.c"
        break;

    case YYSYMBOL_f_block_arg: /* f_block_arg  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10759 "parse.c"
        break;

    case YYSYMBOL_opt_f_block_arg: /* opt_f_block_arg  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10767 "parse.c"
        break;

    case YYSYMBOL_singleton: /* singleton  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10780 "parse.c"
        break;

    case YYSYMBOL_assoc_list: /* assoc_list  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10793 "parse.c"
        break;

    case YYSYMBOL_assocs: /* assocs  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10806 "parse.c"
        break;

    case YYSYMBOL_assoc: /* assoc  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10819 "parse.c"
        break;

    case YYSYMBOL_operation: /* operation  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10827 "parse.c"
        break;

    case YYSYMBOL_operation2: /* operation2  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10835 "parse.c"
        break;

    case YYSYMBOL_operation3: /* operation3  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10843 "parse.c"
        break;

    case YYSYMBOL_dot_or_colon: /* dot_or_colon  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10851 "parse.c"
        break;

    case YYSYMBOL_call_op: /* call_op  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10859 "parse.c"
        break;

    case YYSYMBOL_call_op2: /* call_op2  */
#line 2621 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10867 "parse.c"
        break;

    case YYSYMBOL_none: /* none  */
#line 2612 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10880 "parse.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct parser_params *p)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp, p);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, p);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop, struct parser_params *p)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top, p)     \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top), p);    \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct parser_params *p)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), p);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule, p) \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, p); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
#ifndef yydebug
int yydebug;
#endif
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location, p)
# define YY_STACK_PRINT(Bottom, Top, p)
# define YY_REDUCE_PRINT(Rule, p)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx, struct parser_params *p)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct parser_params *p)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (p);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp, p);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_245_16: /* @16  */
#line 2649 "parse.y"
         {
    if (CASE_LABELS_ENABLED_P(((*yyvaluep).labels))) st_free_table(((*yyvaluep).labels));
}
#line 11287 "parse.c"
        break;

    case YYSYMBOL_246_17: /* @17  */
#line 2649 "parse.y"
         {
    if (CASE_LABELS_ENABLED_P(((*yyvaluep).labels))) st_free_table(((*yyvaluep).labels));
}
#line 11295 "parse.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct parser_params *p)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
#ifdef __cplusplus
static const YYSTYPE yyval_default = {};
(void) yyval_default;
#else
YY_INITIAL_VALUE (static const YYSTYPE yyval_default;)
#endif
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static const YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;
    YY_USE (yynerrs); /* Silence compiler warning.  */

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */


        /* User initialization code.  */
#line 2656 "parse.y"
        {
    RUBY_SET_YYLLOC_OF_NONE(yylloc);
}

#line 11403 "parse.c"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp, p);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, p);
    }

  if (yychar <= END_OF_INPUT)
    {
      yychar = END_OF_INPUT;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc, p);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc, p);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
        /* %after-shift code. */
#line 2659 "parse.y"
        {after_shift(p);}
#line 11577 "parse.c"


  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];
        /* %before-reduce function. */
#line 2660 "parse.y"
        {before_reduce(yylen, p);}
#line 11614 "parse.c"


  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn, p);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 2968 "parse.y"
            {
                        SET_LEX_STATE(EXPR_BEG);
                        local_push(p, ifndef_ripper(1)+0);
                        /* jumps are possible in the top-level loop. */
                        if (!ifndef_ripper(p->do_loop) + 0) init_block_exit(p);
                    }
#line 11631 "parse.c"
    break;

  case 3: /* program: $@1 top_compstmt  */
#line 2975 "parse.y"
                    {
                        if ((yyvsp[0].node) && !compile_for_eval) {
                            NODE *node = (yyvsp[0].node);
                            /* last expression should not be void */
                            if (nd_type_p(node, NODE_BLOCK)) {
                                while (RNODE_BLOCK(node)->nd_next) {
                                    node = RNODE_BLOCK(node)->nd_next;
                                }
                                node = RNODE_BLOCK(node)->nd_head;
                            }
                            node = remove_begin(node);
                            void_expr(p, node);
                        }
                        p->eval_tree = NEW_SCOPE(0, block_append(p, p->eval_tree, (yyvsp[0].node)), &(yyloc));
                    /*% ripper[final]: program!($:2) %*/
                        local_pop(p);
                    }
#line 11653 "parse.c"
    break;

  case 6: /* top_compstmt: top_stmts option_terms  */
#line 2995 "parse.y"
                    {
                        void_stmts(p, (yyval.node) = (yyvsp[-1].node));
                    }
#line 11661 "parse.c"
    break;

  case 7: /* top_stmts: none  */
#line 3001 "parse.y"
                    {
                        (yyval.node) = NEW_BEGIN(0, &(yyloc));
                    /*% ripper: stmts_add!(stmts_new!, void_stmt!) %*/
                    }
#line 11670 "parse.c"
    break;

  case 8: /* top_stmts: top_stmt  */
#line 3006 "parse.y"
                    {
                        (yyval.node) = newline_node((yyvsp[0].node));
                    /*% ripper: stmts_add!(stmts_new!, $:1) %*/
                    }
#line 11679 "parse.c"
    break;

  case 9: /* top_stmts: top_stmts terms top_stmt  */
#line 3011 "parse.y"
                    {
                        (yyval.node) = block_append(p, (yyvsp[-2].node), newline_node((yyvsp[0].node)));
                    /*% ripper: stmts_add!($:1, $:3) %*/
                    }
#line 11688 "parse.c"
    break;

  case 10: /* top_stmt: stmt  */
#line 3018 "parse.y"
                    {
                        clear_block_exit(p, true);
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 11697 "parse.c"
    break;

  case 11: /* top_stmt: "'BEGIN'" begin_block  */
#line 3023 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: $:2 %*/
                    }
#line 11706 "parse.c"
    break;

  case 12: /* block_open: '{'  */
#line 3029 "parse.y"
                 {(yyval.node_exits) = init_block_exit(p);}
#line 11712 "parse.c"
    break;

  case 13: /* begin_block: block_open top_compstmt '}'  */
#line 3032 "parse.y"
                    {
                        restore_block_exit(p, (yyvsp[-2].node_exits));
                        p->eval_tree_begin = block_append(p, p->eval_tree_begin,
                                                          NEW_BEGIN((yyvsp[-1].node), &(yyloc)));
                        (yyval.node) = NEW_BEGIN(0, &(yyloc));
                    /*% ripper: BEGIN!($:2) %*/
                    }
#line 11724 "parse.c"
    break;

  case 14: /* $@2: %empty  */
#line 3045 "parse.y"
                    {
                        if (!(yyvsp[-1].node)) yyerror1(&(yylsp[0]), "else without rescue is useless");
                        next_rescue_context(&p->ctxt, &(yyvsp[-2].ctxt), after_else);
                    }
#line 11733 "parse.c"
    break;

  case 15: /* $@3: %empty  */
#line 3050 "parse.y"
                    {
                        next_rescue_context(&p->ctxt, &(yyvsp[-4].ctxt), after_ensure);
                    }
#line 11741 "parse.c"
    break;

  case 16: /* bodystmt: compstmt lex_ctxt opt_rescue k_else $@2 compstmt $@3 opt_ensure  */
#line 3054 "parse.y"
                    {
                        (yyval.node) = new_bodystmt(p, (yyvsp[-7].node), (yyvsp[-5].node), (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: bodystmt!($:body, $:opt_rescue, $:elsebody, $:opt_ensure) %*/
                    }
#line 11750 "parse.c"
    break;

  case 17: /* $@4: %empty  */
#line 3061 "parse.y"
                    {
                        next_rescue_context(&p->ctxt, &(yyvsp[-1].ctxt), after_ensure);
                    }
#line 11758 "parse.c"
    break;

  case 18: /* bodystmt: compstmt lex_ctxt opt_rescue $@4 opt_ensure  */
#line 3065 "parse.y"
                    {
                        (yyval.node) = new_bodystmt(p, (yyvsp[-4].node), (yyvsp[-2].node), 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: bodystmt!($:body, $:opt_rescue, Qnil, $:opt_ensure) %*/
                    }
#line 11767 "parse.c"
    break;

  case 19: /* compstmt: stmts option_terms  */
#line 3072 "parse.y"
                    {
                        void_stmts(p, (yyval.node) = (yyvsp[-1].node));
                    }
#line 11775 "parse.c"
    break;

  case 20: /* stmts: none  */
#line 3078 "parse.y"
                    {
                        (yyval.node) = NEW_BEGIN(0, &(yyloc));
                    /*% ripper: stmts_add!(stmts_new!, void_stmt!) %*/
                    }
#line 11784 "parse.c"
    break;

  case 21: /* stmts: stmt_or_begin  */
#line 3083 "parse.y"
                    {
                        (yyval.node) = newline_node((yyvsp[0].node));
                    /*% ripper: stmts_add!(stmts_new!, $:1) %*/
                    }
#line 11793 "parse.c"
    break;

  case 22: /* stmts: stmts terms stmt_or_begin  */
#line 3088 "parse.y"
                    {
                        (yyval.node) = block_append(p, (yyvsp[-2].node), newline_node((yyvsp[0].node)));
                    /*% ripper: stmts_add!($:1, $:3) %*/
                    }
#line 11802 "parse.c"
    break;

  case 23: /* stmt_or_begin: stmt  */
#line 3095 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 11810 "parse.c"
    break;

  case 24: /* $@5: %empty  */
#line 3099 "parse.y"
                    {
                        yyerror1(&(yylsp[0]), "BEGIN is permitted only at toplevel");
                    }
#line 11818 "parse.c"
    break;

  case 25: /* stmt_or_begin: "'BEGIN'" $@5 begin_block  */
#line 3103 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 11826 "parse.c"
    break;

  case 26: /* allow_exits: %empty  */
#line 3108 "parse.y"
              {(yyval.node_exits) = allow_block_exit(p);}
#line 11832 "parse.c"
    break;

  case 27: /* k_END: "'END'" lex_ctxt  */
#line 3111 "parse.y"
                    {
                        (yyval.ctxt) = (yyvsp[0].ctxt);
                        p->ctxt.in_rescue = before_rescue;
                    /*% ripper: $:2 %*/
                    }
#line 11842 "parse.c"
    break;

  case 28: /* $@6: %empty  */
#line 3117 "parse.y"
                            {SET_LEX_STATE(EXPR_FNAME|EXPR_FITEM);}
#line 11848 "parse.c"
    break;

  case 29: /* stmt: "'alias'" fitem $@6 fitem  */
#line 3118 "parse.y"
                    {
                        (yyval.node) = NEW_ALIAS((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-3]));
                    /*% ripper: alias!($:2, $:4) %*/
                    }
#line 11857 "parse.c"
    break;

  case 30: /* stmt: "'alias'" "global variable" "global variable"  */
#line 3123 "parse.y"
                    {
                        (yyval.node) = NEW_VALIAS((yyvsp[-1].id), (yyvsp[0].id), &(yyloc), &(yylsp[-2]));
                    /*% ripper: var_alias!($:2, $:3) %*/
                    }
#line 11866 "parse.c"
    break;

  case 31: /* stmt: "'alias'" "global variable" "back reference"  */
#line 3128 "parse.y"
                    {
                        char buf[2];
                        buf[0] = '$';
                        buf[1] = (char)RNODE_BACK_REF((yyvsp[0].node))->nd_nth;
                        (yyval.node) = NEW_VALIAS((yyvsp[-1].id), rb_intern2(buf, 2), &(yyloc), &(yylsp[-2]));
                    /*% ripper: var_alias!($:2, $:3) %*/
                    }
#line 11878 "parse.c"
    break;

  case 32: /* stmt: "'alias'" "global variable" "numbered reference"  */
#line 3136 "parse.y"
                    {
                        static const char mesg[] = "can't make alias for the number variables";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: alias_error!(ERR_MESG(), $:3) %*/
                    }
#line 11891 "parse.c"
    break;

  case 33: /* stmt: "'undef'" undef_list  */
#line 3145 "parse.y"
                    {
                        nd_set_first_loc((yyvsp[0].node), (yylsp[-1]).beg_pos);
                        RNODE_UNDEF((yyvsp[0].node))->keyword_loc = (yylsp[-1]);
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: undef!($:2) %*/
                    }
#line 11902 "parse.c"
    break;

  case 34: /* stmt: stmt "'if' modifier" expr_value  */
#line 3152 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[0].node), remove_begin((yyvsp[-2].node)), 0, &(yyloc));
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: if_mod!($:3, $:1) %*/
                    }
#line 11912 "parse.c"
    break;

  case 35: /* stmt: stmt "'unless' modifier" expr_value  */
#line 3158 "parse.y"
                    {
                        (yyval.node) = new_unless(p, (yyvsp[0].node), remove_begin((yyvsp[-2].node)), 0, &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: unless_mod!($:3, $:1) %*/
                    }
#line 11922 "parse.c"
    break;

  case 36: /* stmt: stmt "'while' modifier" expr_value  */
#line 3164 "parse.y"
                    {
                        clear_block_exit(p, false);
                        if ((yyvsp[-2].node) && nd_type_p((yyvsp[-2].node), NODE_BEGIN)) {
                            (yyval.node) = NEW_WHILE(cond(p, (yyvsp[0].node), &(yylsp[0])), RNODE_BEGIN((yyvsp[-2].node))->nd_body, 0, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                        else {
                            (yyval.node) = NEW_WHILE(cond(p, (yyvsp[0].node), &(yylsp[0])), (yyvsp[-2].node), 1, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                    /*% ripper: while_mod!($:3, $:1) %*/
                    }
#line 11937 "parse.c"
    break;

  case 37: /* stmt: stmt "'until' modifier" expr_value  */
#line 3175 "parse.y"
                    {
                        clear_block_exit(p, false);
                        if ((yyvsp[-2].node) && nd_type_p((yyvsp[-2].node), NODE_BEGIN)) {
                            (yyval.node) = NEW_UNTIL(cond(p, (yyvsp[0].node), &(yylsp[0])), RNODE_BEGIN((yyvsp[-2].node))->nd_body, 0, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                        else {
                            (yyval.node) = NEW_UNTIL(cond(p, (yyvsp[0].node), &(yylsp[0])), (yyvsp[-2].node), 1, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                    /*% ripper: until_mod!($:3, $:1) %*/
                    }
#line 11952 "parse.c"
    break;

  case 38: /* stmt: stmt "'rescue' modifier" after_rescue stmt  */
#line 3186 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        NODE *resq;
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        resq = NEW_RESBODY(0, 0, remove_begin((yyvsp[0].node)), 0, &loc);
                        (yyval.node) = NEW_RESCUE(remove_begin((yyvsp[-3].node)), resq, 0, &(yyloc));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 11965 "parse.c"
    break;

  case 39: /* stmt: k_END allow_exits '{' compstmt '}'  */
#line 3195 "parse.y"
                    {
                        if (p->ctxt.in_def) {
                            rb_warn0("END in method; use at_exit");
                        }
                        restore_block_exit(p, (yyvsp[-3].node_exits));
                        p->ctxt = (yyvsp[-4].ctxt);
                        {
                            NODE *scope = NEW_SCOPE2(0 /* tbl */, 0 /* args */, (yyvsp[-1].node) /* body */, &(yyloc));
                            (yyval.node) = NEW_POSTEXE(scope, &(yyloc));
                        }
                    /*% ripper: END!($:compstmt) %*/
                    }
#line 11982 "parse.c"
    break;

  case 41: /* stmt: mlhs '=' lex_ctxt command_call  */
#line 3209 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node_masgn), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: massign!($:1, $:4) %*/
                    }
#line 11992 "parse.c"
    break;

  case 42: /* stmt: lhs '=' lex_ctxt mrhs  */
#line 3215 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: assign!($:1, $:4) %*/
                    }
#line 12001 "parse.c"
    break;

  case 43: /* stmt: mlhs '=' lex_ctxt mrhs_arg "'rescue' modifier" after_rescue stmt  */
#line 3221 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-4].ctxt).in_rescue;
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        (yyvsp[0].node) = NEW_RESBODY(0, 0, remove_begin((yyvsp[0].node)), 0, &loc);
                        loc.beg_pos = (yylsp[-3]).beg_pos;
                        (yyvsp[-3].node) = NEW_RESCUE((yyvsp[-3].node), (yyvsp[0].node), 0, &loc);
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-6].node_masgn), (yyvsp[-3].node), (yyvsp[-4].ctxt), &(yyloc));
                    /*% ripper: massign!($:1, rescue_mod!($:4, $:7)) %*/
                    }
#line 12015 "parse.c"
    break;

  case 44: /* stmt: mlhs '=' lex_ctxt mrhs_arg  */
#line 3231 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node_masgn), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: massign!($:1, $:4) %*/
                    }
#line 12024 "parse.c"
    break;

  case 46: /* stmt: error  */
#line 3237 "parse.y"
                    {
                        (void)yynerrs;
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    }
#line 12033 "parse.c"
    break;

  case 47: /* command_asgn: lhs '=' lex_ctxt command_rhs  */
#line 3244 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: assign!($:1, $:4) %*/
                    }
#line 12042 "parse.c"
    break;

  case 48: /* command_asgn: var_lhs "operator-assignment" lex_ctxt command_rhs  */
#line 3249 "parse.y"
                    {
                        (yyval.node) = new_op_assign(p, (yyvsp[-3].node), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!($:1, $:2, $:4) %*/
                    }
#line 12051 "parse.c"
    break;

  case 49: /* command_asgn: primary_value '[' opt_call_args rbracket "operator-assignment" lex_ctxt command_rhs  */
#line 3254 "parse.y"
                    {
                        (yyval.node) = new_ary_op_assign(p, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[0].node), &(yylsp[-4]), &(yyloc), &NULL_LOC, &(yylsp[-5]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(aref_field!($:1, $:3), $:5, $:7) %*/

                    }
#line 12061 "parse.c"
    break;

  case 50: /* command_asgn: primary_value call_op "local variable or method" "operator-assignment" lex_ctxt command_rhs  */
#line 3260 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 12070 "parse.c"
    break;

  case 51: /* command_asgn: primary_value call_op "constant" "operator-assignment" lex_ctxt command_rhs  */
#line 3260 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 12079 "parse.c"
    break;

  case 52: /* command_asgn: primary_value "::" "constant" "operator-assignment" lex_ctxt command_rhs  */
#line 3265 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-5]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON2((yyvsp[-5].node), (yyvsp[-3].id), &loc), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(const_path_field!($:1, $:3), $:4, $:6) %*/
                    }
#line 12089 "parse.c"
    break;

  case 53: /* command_asgn: primary_value "::" "local variable or method" "operator-assignment" lex_ctxt command_rhs  */
#line 3271 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), idCOLON2, (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 12098 "parse.c"
    break;

  case 54: /* command_asgn: ":: at EXPR_BEG" "constant" "operator-assignment" lex_ctxt command_rhs  */
#line 3276 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-4]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON3((yyvsp[-3].id), &loc), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(top_const_field!($:2), $:3, $:5) %*/
                    }
#line 12108 "parse.c"
    break;

  case 55: /* command_asgn: defn_head f_opt_paren_args '=' endless_command  */
#line 3282 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), &(yyloc));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        RNODE_DEFN((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: def!($:head, $:args, $:$) %*/
                        local_pop(p);
                    }
#line 12123 "parse.c"
    break;

  case 56: /* command_asgn: defs_head f_opt_paren_args '=' endless_command  */
#line 3293 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), &(yyloc));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        RNODE_DEFS((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: defs!(*$:head[0..2], $:args, $:$) %*/
                        local_pop(p);
                    }
#line 12138 "parse.c"
    break;

  case 57: /* command_asgn: backref "operator-assignment" lex_ctxt command_rhs  */
#line 3304 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[-3].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, opassign!(var_field!($:1), $:2, $:4)) %*/
                    }
#line 12148 "parse.c"
    break;

  case 59: /* endless_command: endless_command "'rescue' modifier" after_rescue arg  */
#line 3313 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        (yyval.node) = rescued_expr(p, (yyvsp[-3].node), (yyvsp[0].node), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 12158 "parse.c"
    break;

  case 62: /* endless_command: "'not'" option_'\n' endless_command  */
#line 3319 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 12167 "parse.c"
    break;

  case 63: /* command_rhs: command_call  */
#line 3326 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 12176 "parse.c"
    break;

  case 64: /* command_rhs: command_call "'rescue' modifier" after_rescue stmt  */
#line 3331 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        value_expr((yyvsp[-3].node));
                        (yyval.node) = NEW_RESCUE((yyvsp[-3].node), NEW_RESBODY(0, 0, remove_begin((yyvsp[0].node)), 0, &loc), 0, &(yyloc));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 12188 "parse.c"
    break;

  case 67: /* expr: expr "'and'" expr  */
#line 3343 "parse.y"
                    {
                        (yyval.node) = logop(p, idAND, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idAND), $:3) %*/
                    }
#line 12197 "parse.c"
    break;

  case 68: /* expr: expr "'or'" expr  */
#line 3348 "parse.y"
                    {
                        (yyval.node) = logop(p, idOR, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idOR), $:3) %*/
                    }
#line 12206 "parse.c"
    break;

  case 69: /* expr: "'not'" option_'\n' expr  */
#line 3353 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 12215 "parse.c"
    break;

  case 70: /* expr: '!' command_call  */
#line 3358 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), '!', &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL('\'!\''), $:2) %*/
                    }
#line 12224 "parse.c"
    break;

  case 71: /* $@7: %empty  */
#line 3363 "parse.y"
                    {
                        value_expr((yyvsp[-1].node));
                    }
#line 12232 "parse.c"
    break;

  case 72: /* expr: arg "=>" $@7 p_in_kwarg p_pvtbl p_pktbl p_top_expr_body  */
#line 3368 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-1].tbl));
                        pop_pvtbl(p, (yyvsp[-2].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-3].ctxt).in_kwarg;
                        (yyval.node) = NEW_CASE3((yyvsp[-6].node), NEW_IN((yyvsp[0].node), 0, 0, &(yylsp[0])), &(yyloc), &NULL_LOC, &NULL_LOC);
                    /*% ripper: case!($:arg, in!($:body, Qnil, Qnil)) %*/
                    }
#line 12244 "parse.c"
    break;

  case 73: /* $@8: %empty  */
#line 3376 "parse.y"
                    {
                        value_expr((yyvsp[-1].node));
                    }
#line 12252 "parse.c"
    break;

  case 74: /* expr: arg "'in'" $@8 p_in_kwarg p_pvtbl p_pktbl p_top_expr_body  */
#line 3381 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-1].tbl));
                        pop_pvtbl(p, (yyvsp[-2].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-3].ctxt).in_kwarg;
                        (yyval.node) = NEW_CASE3((yyvsp[-6].node), NEW_IN((yyvsp[0].node), NEW_TRUE(&(yylsp[0])), NEW_FALSE(&(yylsp[0])), &(yylsp[0])), &(yyloc), &NULL_LOC, &NULL_LOC);
                    /*% ripper: case!($:arg, in!($:body, Qnil, Qnil)) %*/
                    }
#line 12264 "parse.c"
    break;

  case 76: /* def_name: fname  */
#line 3392 "parse.y"
                    {
                        ID fname = (yyvsp[0].id);
                        numparam_name(p, fname);
                        local_push(p, 0);
                        p->ctxt.in_def = 1;
                        p->ctxt.in_rescue = before_rescue;
                        p->ctxt.cant_return = 0;
                        (yyval.id) = (yyvsp[0].id);
                    }
#line 12278 "parse.c"
    break;

  case 77: /* defn_head: k_def def_name  */
#line 3404 "parse.y"
                    {
                        (yyval.node_def_temp) = def_head_save(p, (yyvsp[-1].node_def_temp));
                        (yyval.node_def_temp)->nd_mid = (yyvsp[0].id);
                        (yyval.node_def_temp)->nd_def = NEW_DEFN((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: $:def_name %*/
                    }
#line 12289 "parse.c"
    break;

  case 78: /* $@9: %empty  */
#line 3413 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_FNAME);
                    }
#line 12297 "parse.c"
    break;

  case 79: /* defs_head: k_def singleton dot_or_colon $@9 def_name  */
#line 3417 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_ENDFN|EXPR_LABEL); /* force for args */
                        (yyval.node_def_temp) = def_head_save(p, (yyvsp[-4].node_def_temp));
                        (yyval.node_def_temp)->nd_mid = (yyvsp[0].id);
                        (yyval.node_def_temp)->nd_def = NEW_DEFS((yyvsp[-3].node), (yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: [$:singleton, $:dot_or_colon, $:def_name] %*/
                    }
#line 12309 "parse.c"
    break;

  case 80: /* expr_value: expr  */
#line 3427 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 12318 "parse.c"
    break;

  case 81: /* expr_value: error  */
#line 3432 "parse.y"
                    {
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    }
#line 12326 "parse.c"
    break;

  case 82: /* $@10: %empty  */
#line 3437 "parse.y"
                {COND_PUSH(1);}
#line 12332 "parse.c"
    break;

  case 83: /* $@11: %empty  */
#line 3437 "parse.y"
                                              {COND_POP();}
#line 12338 "parse.c"
    break;

  case 84: /* expr_value_do: $@10 expr_value do $@11  */
#line 3438 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-2].node);
                    /*% ripper: $:2 %*/
                    }
#line 12347 "parse.c"
    break;

  case 88: /* block_command: block_call call_op2 operation2 command_args  */
#line 3450 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: method_add_arg!(call!($:1, $:2, $:3), $:4) %*/
                    }
#line 12356 "parse.c"
    break;

  case 89: /* cmd_brace_block: "{ arg" brace_body '}'  */
#line 3457 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 12366 "parse.c"
    break;

  case 90: /* fcall: operation  */
#line 3465 "parse.y"
                    {
                        (yyval.node_fcall) = NEW_FCALL((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 12375 "parse.c"
    break;

  case 91: /* command: fcall command_args  */
#line 3472 "parse.y"
                    {
                        (yyvsp[-1].node_fcall)->nd_args = (yyvsp[0].node);
                        nd_set_last_loc((yyvsp[-1].node_fcall), (yylsp[0]).end_pos);
                        (yyval.node) = (NODE *)(yyvsp[-1].node_fcall);
                    /*% ripper: command!($:1, $:2) %*/
                    }
#line 12386 "parse.c"
    break;

  case 92: /* command: fcall command_args cmd_brace_block  */
#line 3479 "parse.y"
                    {
                        block_dup_check(p, (yyvsp[-1].node), (yyvsp[0].node));
                        (yyvsp[-2].node_fcall)->nd_args = (yyvsp[-1].node);
                        (yyval.node) = method_add_block(p, (NODE *)(yyvsp[-2].node_fcall), (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), RNODE((yyvsp[-2].node_fcall)));
                        nd_set_last_loc((yyvsp[-2].node_fcall), (yylsp[-1]).end_pos);
                    /*% ripper: method_add_block!(command!($:1, $:2), $:3) %*/
                    }
#line 12399 "parse.c"
    break;

  case 93: /* command: primary_value call_op operation2 command_args  */
#line 3488 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), 0, &(yylsp[-1]), &(yyloc));
                    /*% ripper: command_call!($:1, $:2, $:3, $:4) %*/
                    }
#line 12408 "parse.c"
    break;

  case 94: /* command: primary_value call_op operation2 command_args cmd_brace_block  */
#line 3493 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, (yyvsp[-3].id), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                    }
#line 12417 "parse.c"
    break;

  case 95: /* command: primary_value "::" operation2 command_args  */
#line 3498 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, idCOLON2, (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), 0, &(yylsp[-1]), &(yyloc));
                    /*% ripper: command_call!($:1, $:2, $:3, $:4) %*/
                    }
#line 12426 "parse.c"
    break;

  case 96: /* command: primary_value "::" operation2 command_args cmd_brace_block  */
#line 3503 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, idCOLON2, (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                   }
#line 12435 "parse.c"
    break;

  case 97: /* command: primary_value "::" "constant" '{' brace_body '}'  */
#line 3508 "parse.y"
                    {
                        set_embraced_location((yyvsp[-1].node), &(yylsp[-2]), &(yylsp[0]));
                        (yyval.node) = new_command_qcall(p, idCOLON2, (yyvsp[-5].node), (yyvsp[-3].id), 0, (yyvsp[-1].node), &(yylsp[-3]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, Qnil), $:5) %*/
                   }
#line 12445 "parse.c"
    break;

  case 98: /* command: "'super'" command_args  */
#line 3514 "parse.y"
                    {
                        (yyval.node) = NEW_SUPER((yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: super!($:2) %*/
                    }
#line 12455 "parse.c"
    break;

  case 99: /* command: k_yield command_args  */
#line 3520 "parse.y"
                    {
                        (yyval.node) = new_yield(p, (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: yield!($:2) %*/
                    }
#line 12465 "parse.c"
    break;

  case 100: /* command: k_return call_args  */
#line 3526 "parse.y"
                    {
                        (yyval.node) = NEW_RETURN(ret_args(p, (yyvsp[0].node)), &(yyloc), &(yylsp[-1]));
                    /*% ripper: return!($:2) %*/
                    }
#line 12474 "parse.c"
    break;

  case 101: /* command: "'break'" call_args  */
#line 3531 "parse.y"
                    {
                        NODE *args = 0;
                        args = ret_args(p, (yyvsp[0].node));
                        (yyval.node) = add_block_exit(p, NEW_BREAK(args, &(yyloc), &(yylsp[-1])));
                    /*% ripper: break!($:2) %*/
                    }
#line 12485 "parse.c"
    break;

  case 102: /* command: "'next'" call_args  */
#line 3538 "parse.y"
                    {
                        NODE *args = 0;
                        args = ret_args(p, (yyvsp[0].node));
                        (yyval.node) = add_block_exit(p, NEW_NEXT(args, &(yyloc), &(yylsp[-1])));
                    /*% ripper: next!($:2) %*/
                    }
#line 12496 "parse.c"
    break;

  case 104: /* mlhs: "(" mlhs_inner rparen  */
#line 3548 "parse.y"
                    {
                        (yyval.node_masgn) = (yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 12505 "parse.c"
    break;

  case 106: /* mlhs_inner: "(" mlhs_inner rparen  */
#line 3556 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(NEW_LIST((NODE *)(yyvsp[-1].node_masgn), &(yyloc)), 0, &(yyloc));
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 12514 "parse.c"
    break;

  case 107: /* mlhs_basic: mlhs_head  */
#line 3563 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 12523 "parse.c"
    break;

  case 108: /* mlhs_basic: mlhs_head mlhs_item  */
#line 3568 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(list_append(p, (yyvsp[-1].node), (yyvsp[0].node)), 0, &(yyloc));
                    /*% ripper: mlhs_add!($:1, $:2) %*/
                    }
#line 12532 "parse.c"
    break;

  case 109: /* mlhs_basic: mlhs_head "*" mlhs_node  */
#line 3573 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!($:1, $:3) %*/
                    }
#line 12541 "parse.c"
    break;

  case 110: /* mlhs_basic: mlhs_head "*" mlhs_node ',' mlhs_post  */
#line 3578 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-4].node), NEW_POSTARG((yyvsp[-2].node),(yyvsp[0].node),&(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!($:1, $:3), $:5) %*/
                    }
#line 12550 "parse.c"
    break;

  case 111: /* mlhs_basic: mlhs_head "*"  */
#line 3583 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-1].node), NODE_SPECIAL_NO_NAME_REST, &(yyloc));
                    /*% ripper: mlhs_add_star!($:1, Qnil) %*/
                    }
#line 12559 "parse.c"
    break;

  case 112: /* mlhs_basic: mlhs_head "*" ',' mlhs_post  */
#line 3588 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-3].node), NEW_POSTARG(NODE_SPECIAL_NO_NAME_REST, (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!($:1, Qnil), $:4) %*/
                    }
#line 12568 "parse.c"
    break;

  case 113: /* mlhs_basic: "*" mlhs_node  */
#line 3593 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!(mlhs_new!, $:2) %*/
                    }
#line 12577 "parse.c"
    break;

  case 114: /* mlhs_basic: "*" mlhs_node ',' mlhs_post  */
#line 3598 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NEW_POSTARG((yyvsp[-2].node),(yyvsp[0].node),&(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!(mlhs_new!, $:2), $:4) %*/
                    }
#line 12586 "parse.c"
    break;

  case 115: /* mlhs_basic: "*"  */
#line 3603 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NODE_SPECIAL_NO_NAME_REST, &(yyloc));
                    /*% ripper: mlhs_add_star!(mlhs_new!, Qnil) %*/
                    }
#line 12595 "parse.c"
    break;

  case 116: /* mlhs_basic: "*" ',' mlhs_post  */
#line 3608 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NEW_POSTARG(NODE_SPECIAL_NO_NAME_REST, (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!(mlhs_new!, Qnil), $:3) %*/
                    }
#line 12604 "parse.c"
    break;

  case 118: /* mlhs_item: "(" mlhs_inner rparen  */
#line 3616 "parse.y"
                    {
                        (yyval.node) = (NODE *)(yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 12613 "parse.c"
    break;

  case 119: /* mlhs_head: mlhs_item ','  */
#line 3623 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[-1].node), &(yylsp[-1]));
                    /*% ripper: mlhs_add!(mlhs_new!, $:1) %*/
                    }
#line 12622 "parse.c"
    break;

  case 120: /* mlhs_head: mlhs_head mlhs_item ','  */
#line 3628 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: mlhs_add!($:1, $:2) %*/
                    }
#line 12631 "parse.c"
    break;

  case 121: /* mlhs_post: mlhs_item  */
#line 3635 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add!(mlhs_new!, $:1) %*/
                    }
#line 12640 "parse.c"
    break;

  case 122: /* mlhs_post: mlhs_post ',' mlhs_item  */
#line 3640 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: mlhs_add!($:1, $:3) %*/
                    }
#line 12649 "parse.c"
    break;

  case 123: /* mlhs_node: user_variable  */
#line 3647 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 12658 "parse.c"
    break;

  case 124: /* mlhs_node: keyword_variable  */
#line 3647 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 12667 "parse.c"
    break;

  case 125: /* mlhs_node: primary_value '[' opt_call_args rbracket  */
#line 3652 "parse.y"
                    {
                        (yyval.node) = aryset(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                    /*% ripper: aref_field!($:1, $:3) %*/
                    }
#line 12676 "parse.c"
    break;

  case 126: /* mlhs_node: primary_value call_op "local variable or method"  */
#line 3657 "parse.y"
                    {
                        anddot_multiple_assignment_check(p, &(yylsp[-1]), (yyvsp[-1].id));
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 12686 "parse.c"
    break;

  case 127: /* mlhs_node: primary_value "::" "local variable or method"  */
#line 3663 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), idCOLON2, (yyvsp[0].id), &(yyloc));
                    /*% ripper: const_path_field!($:1, $:3) %*/
                    }
#line 12695 "parse.c"
    break;

  case 128: /* mlhs_node: primary_value call_op "constant"  */
#line 3668 "parse.y"
                    {
                        anddot_multiple_assignment_check(p, &(yylsp[-1]), (yyvsp[-1].id));
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 12705 "parse.c"
    break;

  case 129: /* mlhs_node: primary_value "::" "constant"  */
#line 3674 "parse.y"
                    {
                    /*% ripper: const_path_field!($:1, $:3) %*/
                        (yyval.node) = const_decl(p, NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc)), &(yyloc));
                    }
#line 12714 "parse.c"
    break;

  case 130: /* mlhs_node: ":: at EXPR_BEG" "constant"  */
#line 3679 "parse.y"
                    {
                    /*% ripper: top_const_field!($:2) %*/
                        (yyval.node) = const_decl(p, NEW_COLON3((yyvsp[0].id), &(yyloc)), &(yyloc));
                    }
#line 12723 "parse.c"
    break;

  case 131: /* mlhs_node: backref  */
#line 3684 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[0].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, var_field!($:1)) %*/
                    }
#line 12733 "parse.c"
    break;

  case 132: /* lhs: user_variable  */
#line 3692 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 12742 "parse.c"
    break;

  case 133: /* lhs: keyword_variable  */
#line 3692 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 12751 "parse.c"
    break;

  case 134: /* lhs: primary_value '[' opt_call_args rbracket  */
#line 3697 "parse.y"
                    {
                        (yyval.node) = aryset(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                    /*% ripper: aref_field!($:1, $:3) %*/
                    }
#line 12760 "parse.c"
    break;

  case 135: /* lhs: primary_value call_op "local variable or method"  */
#line 3702 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 12769 "parse.c"
    break;

  case 136: /* lhs: primary_value "::" "local variable or method"  */
#line 3707 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), idCOLON2, (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 12778 "parse.c"
    break;

  case 137: /* lhs: primary_value call_op "constant"  */
#line 3712 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 12787 "parse.c"
    break;

  case 138: /* lhs: primary_value "::" "constant"  */
#line 3717 "parse.y"
                    {
                    /*% ripper: const_path_field!($:1, $:3) %*/
                        (yyval.node) = const_decl(p, NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc)), &(yyloc));
                    }
#line 12796 "parse.c"
    break;

  case 139: /* lhs: ":: at EXPR_BEG" "constant"  */
#line 3722 "parse.y"
                    {
                    /*% ripper: top_const_field!($:2) %*/
                        (yyval.node) = const_decl(p, NEW_COLON3((yyvsp[0].id), &(yyloc)), &(yyloc));
                    }
#line 12805 "parse.c"
    break;

  case 140: /* lhs: backref  */
#line 3727 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[0].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, var_field!($:1)) %*/
                    }
#line 12815 "parse.c"
    break;

  case 141: /* cname: "local variable or method"  */
#line 3735 "parse.y"
                    {
                        static const char mesg[] = "class/module name must be CONSTANT";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                    /*% ripper[error]: class_name_error!(ERR_MESG(), $:1) %*/
                    }
#line 12827 "parse.c"
    break;

  case 143: /* cpath: ":: at EXPR_BEG" cname  */
#line 3746 "parse.y"
                    {
                        (yyval.node) = NEW_COLON3((yyvsp[0].id), &(yyloc));
                    /*% ripper: top_const_ref!($:2) %*/
                    }
#line 12836 "parse.c"
    break;

  case 144: /* cpath: cname  */
#line 3751 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2(0, (yyvsp[0].id), &(yyloc));
                    /*% ripper: const_ref!($:1) %*/
                    }
#line 12845 "parse.c"
    break;

  case 145: /* cpath: primary_value "::" cname  */
#line 3756 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc));
                    /*% ripper: const_path_ref!($:1, $:3) %*/
                    }
#line 12854 "parse.c"
    break;

  case 149: /* fname: op  */
#line 3765 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_ENDFN);
                        (yyval.id) = (yyvsp[0].id);
                    }
#line 12863 "parse.c"
    break;

  case 151: /* fitem: fname  */
#line 3773 "parse.y"
                    {
                        (yyval.node) = NEW_SYM(rb_id2str((yyvsp[0].id)), &(yyloc));
                    /*% ripper: symbol_literal!($:1) %*/
                    }
#line 12872 "parse.c"
    break;

  case 153: /* undef_list: fitem  */
#line 3781 "parse.y"
                    {
                        (yyval.node) = NEW_UNDEF((yyvsp[0].node), &(yyloc));
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 12881 "parse.c"
    break;

  case 154: /* $@12: %empty  */
#line 3785 "parse.y"
                                 {SET_LEX_STATE(EXPR_FNAME|EXPR_FITEM);}
#line 12887 "parse.c"
    break;

  case 155: /* undef_list: undef_list ',' $@12 fitem  */
#line 3786 "parse.y"
                    {
                        nd_set_last_loc((yyvsp[-3].node), (yylsp[0]).end_pos);
                        rb_parser_ary_push_node(p, RNODE_UNDEF((yyvsp[-3].node))->nd_undefs, (yyvsp[0].node));
                    /*% ripper: rb_ary_push($:1, $:4) %*/
                    }
#line 12897 "parse.c"
    break;

  case 156: /* op: '|'  */
#line 3793 "parse.y"
           { (yyval.id) = '|'; }
#line 12903 "parse.c"
    break;

  case 157: /* op: '^'  */
#line 3794 "parse.y"
                       { (yyval.id) = '^'; }
#line 12909 "parse.c"
    break;

  case 158: /* op: '&'  */
#line 3795 "parse.y"
                       { (yyval.id) = '&'; }
#line 12915 "parse.c"
    break;

  case 159: /* op: "<=>"  */
#line 3796 "parse.y"
                        { (yyval.id) = tCMP; }
#line 12921 "parse.c"
    break;

  case 160: /* op: "=="  */
#line 3797 "parse.y"
                       { (yyval.id) = tEQ; }
#line 12927 "parse.c"
    break;

  case 161: /* op: "==="  */
#line 3798 "parse.y"
                        { (yyval.id) = tEQQ; }
#line 12933 "parse.c"
    break;

  case 162: /* op: "=~"  */
#line 3799 "parse.y"
                         { (yyval.id) = tMATCH; }
#line 12939 "parse.c"
    break;

  case 163: /* op: "!~"  */
#line 3800 "parse.y"
                          { (yyval.id) = tNMATCH; }
#line 12945 "parse.c"
    break;

  case 164: /* op: '>'  */
#line 3801 "parse.y"
                       { (yyval.id) = '>'; }
#line 12951 "parse.c"
    break;

  case 165: /* op: ">="  */
#line 3802 "parse.y"
                        { (yyval.id) = tGEQ; }
#line 12957 "parse.c"
    break;

  case 166: /* op: '<'  */
#line 3803 "parse.y"
                       { (yyval.id) = '<'; }
#line 12963 "parse.c"
    break;

  case 167: /* op: "<="  */
#line 3804 "parse.y"
                        { (yyval.id) = tLEQ; }
#line 12969 "parse.c"
    break;

  case 168: /* op: "!="  */
#line 3805 "parse.y"
                        { (yyval.id) = tNEQ; }
#line 12975 "parse.c"
    break;

  case 169: /* op: "<<"  */
#line 3806 "parse.y"
                         { (yyval.id) = tLSHFT; }
#line 12981 "parse.c"
    break;

  case 170: /* op: ">>"  */
#line 3807 "parse.y"
                         { (yyval.id) = tRSHFT; }
#line 12987 "parse.c"
    break;

  case 171: /* op: '+'  */
#line 3808 "parse.y"
                       { (yyval.id) = '+'; }
#line 12993 "parse.c"
    break;

  case 172: /* op: '-'  */
#line 3809 "parse.y"
                       { (yyval.id) = '-'; }
#line 12999 "parse.c"
    break;

  case 173: /* op: '*'  */
#line 3810 "parse.y"
                       { (yyval.id) = '*'; }
#line 13005 "parse.c"
    break;

  case 174: /* op: "*"  */
#line 3811 "parse.y"
                         { (yyval.id) = '*'; }
#line 13011 "parse.c"
    break;

  case 175: /* op: '/'  */
#line 3812 "parse.y"
                       { (yyval.id) = '/'; }
#line 13017 "parse.c"
    break;

  case 176: /* op: '%'  */
#line 3813 "parse.y"
                       { (yyval.id) = '%'; }
#line 13023 "parse.c"
    break;

  case 177: /* op: "**"  */
#line 3814 "parse.y"
                        { (yyval.id) = tPOW; }
#line 13029 "parse.c"
    break;

  case 178: /* op: "**arg"  */
#line 3815 "parse.y"
                         { (yyval.id) = tDSTAR; }
#line 13035 "parse.c"
    break;

  case 179: /* op: '!'  */
#line 3816 "parse.y"
                       { (yyval.id) = '!'; }
#line 13041 "parse.c"
    break;

  case 180: /* op: '~'  */
#line 3817 "parse.y"
                       { (yyval.id) = '~'; }
#line 13047 "parse.c"
    break;

  case 181: /* op: "unary+"  */
#line 3818 "parse.y"
                         { (yyval.id) = tUPLUS; }
#line 13053 "parse.c"
    break;

  case 182: /* op: "unary-"  */
#line 3819 "parse.y"
                          { (yyval.id) = tUMINUS; }
#line 13059 "parse.c"
    break;

  case 183: /* op: "[]"  */
#line 3820 "parse.y"
                         { (yyval.id) = tAREF; }
#line 13065 "parse.c"
    break;

  case 184: /* op: "[]="  */
#line 3821 "parse.y"
                         { (yyval.id) = tASET; }
#line 13071 "parse.c"
    break;

  case 185: /* op: '`'  */
#line 3822 "parse.y"
                       { (yyval.id) = '`'; }
#line 13077 "parse.c"
    break;

  case 227: /* arg: lhs '=' lex_ctxt arg_rhs  */
#line 3840 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: assign!($:1, $:4) %*/
                    }
#line 13086 "parse.c"
    break;

  case 228: /* arg: var_lhs "operator-assignment" lex_ctxt arg_rhs  */
#line 3845 "parse.y"
                    {
                        (yyval.node) = new_op_assign(p, (yyvsp[-3].node), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!($:1, $:2, $:4) %*/
                    }
#line 13095 "parse.c"
    break;

  case 229: /* arg: primary_value '[' opt_call_args rbracket "operator-assignment" lex_ctxt arg_rhs  */
#line 3850 "parse.y"
                    {
                        (yyval.node) = new_ary_op_assign(p, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[0].node), &(yylsp[-4]), &(yyloc), &NULL_LOC, &(yylsp[-5]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(aref_field!($:1, $:3), $:5, $:7) %*/
                    }
#line 13104 "parse.c"
    break;

  case 230: /* arg: primary_value call_op "local variable or method" "operator-assignment" lex_ctxt arg_rhs  */
#line 3855 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 13113 "parse.c"
    break;

  case 231: /* arg: primary_value call_op "constant" "operator-assignment" lex_ctxt arg_rhs  */
#line 3860 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 13122 "parse.c"
    break;

  case 232: /* arg: primary_value "::" "local variable or method" "operator-assignment" lex_ctxt arg_rhs  */
#line 3865 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), idCOLON2, (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 13131 "parse.c"
    break;

  case 233: /* arg: primary_value "::" "constant" "operator-assignment" lex_ctxt arg_rhs  */
#line 3870 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-5]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON2((yyvsp[-5].node), (yyvsp[-3].id), &loc), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(const_path_field!($:1, $:3), $:4, $:6) %*/
                    }
#line 13141 "parse.c"
    break;

  case 234: /* arg: ":: at EXPR_BEG" "constant" "operator-assignment" lex_ctxt arg_rhs  */
#line 3876 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-4]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON3((yyvsp[-3].id), &loc), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(top_const_field!($:2), $:3, $:5) %*/
                    }
#line 13151 "parse.c"
    break;

  case 235: /* arg: backref "operator-assignment" lex_ctxt arg_rhs  */
#line 3882 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[-3].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, opassign!(var_field!($:1), $:2, $:4)) %*/
                    }
#line 13161 "parse.c"
    break;

  case 236: /* arg: arg ".." arg  */
#line 3888 "parse.y"
                    {
                        value_expr((yyvsp[-2].node));
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot2!($:1, $:3) %*/
                    }
#line 13172 "parse.c"
    break;

  case 237: /* arg: arg "..." arg  */
#line 3895 "parse.y"
                    {
                        value_expr((yyvsp[-2].node));
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot3!($:1, $:3) %*/
                    }
#line 13183 "parse.c"
    break;

  case 238: /* arg: arg ".."  */
#line 3902 "parse.y"
                    {
                        value_expr((yyvsp[-1].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc));
                    /*% ripper: dot2!($:1, Qnil) %*/
                    }
#line 13193 "parse.c"
    break;

  case 239: /* arg: arg "..."  */
#line 3908 "parse.y"
                    {
                        value_expr((yyvsp[-1].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc));
                    /*% ripper: dot3!($:1, Qnil) %*/
                    }
#line 13203 "parse.c"
    break;

  case 240: /* arg: "(.." arg  */
#line 3914 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT2(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot2!(Qnil, $:2) %*/
                    }
#line 13213 "parse.c"
    break;

  case 241: /* arg: "(..." arg  */
#line 3920 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT3(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot3!(Qnil, $:2) %*/
                    }
#line 13223 "parse.c"
    break;

  case 242: /* arg: arg '+' arg  */
#line 3926 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '+', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'+\''), $:3) %*/
                    }
#line 13232 "parse.c"
    break;

  case 243: /* arg: arg '-' arg  */
#line 3931 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '-', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'-\''), $:3) %*/
                    }
#line 13241 "parse.c"
    break;

  case 244: /* arg: arg '*' arg  */
#line 3936 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '*', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'*\''), $:3) %*/
                    }
#line 13250 "parse.c"
    break;

  case 245: /* arg: arg '/' arg  */
#line 3941 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '/', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'/\''), $:3) %*/
                    }
#line 13259 "parse.c"
    break;

  case 246: /* arg: arg '%' arg  */
#line 3946 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '%', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'%\''), $:3) %*/
                    }
#line 13268 "parse.c"
    break;

  case 247: /* arg: arg "**" arg  */
#line 3951 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idPow, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idPow), $:3) %*/
                    }
#line 13277 "parse.c"
    break;

  case 248: /* arg: tUMINUS_NUM simple_numeric "**" arg  */
#line 3956 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, call_bin_op(p, (yyvsp[-2].node), idPow, (yyvsp[0].node), &(yylsp[-2]), &(yyloc)), idUMinus, &(yylsp[-3]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idUMinus), binary!($:2, ID2VAL(idPow), $:4)) %*/
                    }
#line 13286 "parse.c"
    break;

  case 249: /* arg: "unary+" arg  */
#line 3961 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, (yyvsp[0].node), idUPlus, &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idUPlus), $:2) %*/
                    }
#line 13295 "parse.c"
    break;

  case 250: /* arg: "unary-" arg  */
#line 3966 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, (yyvsp[0].node), idUMinus, &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idUMinus), $:2) %*/
                    }
#line 13304 "parse.c"
    break;

  case 251: /* arg: arg '|' arg  */
#line 3971 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '|', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'|\''), $:3) %*/
                    }
#line 13313 "parse.c"
    break;

  case 252: /* arg: arg '^' arg  */
#line 3976 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '^', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'^\''), $:3) %*/
                    }
#line 13322 "parse.c"
    break;

  case 253: /* arg: arg '&' arg  */
#line 3981 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '&', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'&\''), $:3) %*/
                    }
#line 13331 "parse.c"
    break;

  case 254: /* arg: arg "<=>" arg  */
#line 3986 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idCmp, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idCmp), $:3) %*/
                    }
#line 13340 "parse.c"
    break;

  case 256: /* arg: arg "==" arg  */
#line 3992 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idEq, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idEq), $:3) %*/
                    }
#line 13349 "parse.c"
    break;

  case 257: /* arg: arg "===" arg  */
#line 3997 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idEqq, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idEqq), $:3) %*/
                    }
#line 13358 "parse.c"
    break;

  case 258: /* arg: arg "!=" arg  */
#line 4002 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idNeq, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idNeq), $:3) %*/
                    }
#line 13367 "parse.c"
    break;

  case 259: /* arg: arg "=~" arg  */
#line 4007 "parse.y"
                    {
                        (yyval.node) = match_op(p, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idEqTilde), $:3) %*/
                    }
#line 13376 "parse.c"
    break;

  case 260: /* arg: arg "!~" arg  */
#line 4012 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idNeqTilde, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idNeqTilde), $:3) %*/
                    }
#line 13385 "parse.c"
    break;

  case 261: /* arg: '!' arg  */
#line 4017 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), '!', &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL('\'!\''), $:2) %*/
                    }
#line 13394 "parse.c"
    break;

  case 262: /* arg: '~' arg  */
#line 4022 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, (yyvsp[0].node), '~', &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL('\'~\''), $:2) %*/
                    }
#line 13403 "parse.c"
    break;

  case 263: /* arg: arg "<<" arg  */
#line 4027 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idLTLT, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idLTLT), $:3) %*/
                    }
#line 13412 "parse.c"
    break;

  case 264: /* arg: arg ">>" arg  */
#line 4032 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idGTGT, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idGTGT), $:3) %*/
                    }
#line 13421 "parse.c"
    break;

  case 265: /* arg: arg "&&" arg  */
#line 4037 "parse.y"
                    {
                        (yyval.node) = logop(p, idANDOP, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idANDOP), $:3) %*/
                    }
#line 13430 "parse.c"
    break;

  case 266: /* arg: arg "||" arg  */
#line 4042 "parse.y"
                    {
                        (yyval.node) = logop(p, idOROP, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idOROP), $:3) %*/
                    }
#line 13439 "parse.c"
    break;

  case 267: /* arg: "'defined?'" option_'\n' begin_defined arg  */
#line 4047 "parse.y"
                    {
                        p->ctxt.in_defined = (yyvsp[-1].ctxt).in_defined;
                        (yyval.node) = new_defined(p, (yyvsp[0].node), &(yyloc));
                    /*% ripper: defined!($:4) %*/
                    }
#line 13449 "parse.c"
    break;

  case 268: /* arg: arg '?' arg option_'\n' ':' arg  */
#line 4053 "parse.y"
                    {
                        value_expr((yyvsp[-5].node));
                        (yyval.node) = new_if(p, (yyvsp[-5].node), (yyvsp[-3].node), (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-5].node));
                    /*% ripper: ifop!($:1, $:3, $:6) %*/
                    }
#line 13460 "parse.c"
    break;

  case 269: /* arg: defn_head f_opt_paren_args '=' endless_arg  */
#line 4060 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), &(yyloc));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        RNODE_DEFN((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: def!($:head, $:args, $:$) %*/
                        local_pop(p);
                    }
#line 13475 "parse.c"
    break;

  case 270: /* arg: defs_head f_opt_paren_args '=' endless_arg  */
#line 4071 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), &(yyloc));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        RNODE_DEFS((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: defs!(*$:head[0..2], $:args, $:$) %*/
                        local_pop(p);
                    }
#line 13490 "parse.c"
    break;

  case 271: /* arg: primary  */
#line 4082 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 13498 "parse.c"
    break;

  case 273: /* endless_arg: endless_arg "'rescue' modifier" after_rescue arg  */
#line 4089 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        (yyval.node) = rescued_expr(p, (yyvsp[-3].node), (yyvsp[0].node), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 13508 "parse.c"
    break;

  case 274: /* endless_arg: "'not'" option_'\n' endless_arg  */
#line 4095 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 13517 "parse.c"
    break;

  case 275: /* relop: '>'  */
#line 4101 "parse.y"
              {(yyval.id) = '>';}
#line 13523 "parse.c"
    break;

  case 276: /* relop: '<'  */
#line 4102 "parse.y"
                       {(yyval.id) = '<';}
#line 13529 "parse.c"
    break;

  case 277: /* relop: ">="  */
#line 4103 "parse.y"
                       {(yyval.id) = idGE;}
#line 13535 "parse.c"
    break;

  case 278: /* relop: "<="  */
#line 4104 "parse.y"
                       {(yyval.id) = idLE;}
#line 13541 "parse.c"
    break;

  case 279: /* rel_expr: arg relop arg  */
#line 4108 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL($2), $:3) %*/
                    }
#line 13550 "parse.c"
    break;

  case 280: /* rel_expr: rel_expr relop arg  */
#line 4113 "parse.y"
                    {
                        rb_warning1("comparison '%s' after comparison", WARN_ID((yyvsp[-1].id)));
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL($2), $:3) %*/
                    }
#line 13560 "parse.c"
    break;

  case 281: /* lex_ctxt: none  */
#line 4121 "parse.y"
                    {
                        (yyval.ctxt) = p->ctxt;
                    }
#line 13568 "parse.c"
    break;

  case 282: /* begin_defined: lex_ctxt  */
#line 4127 "parse.y"
                    {
                        p->ctxt.in_defined = 1;
                        (yyval.ctxt) = (yyvsp[0].ctxt);
                    }
#line 13577 "parse.c"
    break;

  case 283: /* after_rescue: lex_ctxt  */
#line 4134 "parse.y"
                    {
                        p->ctxt.in_rescue = after_rescue;
                        (yyval.ctxt) = (yyvsp[0].ctxt);
                    }
#line 13586 "parse.c"
    break;

  case 284: /* arg_value: arg  */
#line 4141 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 13595 "parse.c"
    break;

  case 286: /* aref_args: args trailer  */
#line 4149 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    }
#line 13603 "parse.c"
    break;

  case 287: /* aref_args: args ',' assocs trailer  */
#line 4153 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? arg_append(p, (yyvsp[-3].node), new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : (yyvsp[-3].node);
                    /*% ripper: args_add!($:1, bare_assoc_hash!($:3)) %*/
                    }
#line 13612 "parse.c"
    break;

  case 288: /* aref_args: assocs trailer  */
#line 4158 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? NEW_LIST(new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : 0;
                    /*% ripper: args_add!(args_new!, bare_assoc_hash!($:1)) %*/
                    }
#line 13621 "parse.c"
    break;

  case 289: /* arg_rhs: arg  */
#line 4165 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 13630 "parse.c"
    break;

  case 290: /* arg_rhs: arg "'rescue' modifier" after_rescue arg  */
#line 4170 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        value_expr((yyvsp[-3].node));
                        (yyval.node) = rescued_expr(p, (yyvsp[-3].node), (yyvsp[0].node), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 13641 "parse.c"
    break;

  case 291: /* paren_args: '(' opt_call_args rparen  */
#line 4179 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: arg_paren!($:2) %*/
                    }
#line 13650 "parse.c"
    break;

  case 292: /* paren_args: '(' args ',' args_forward rparen  */
#line 4184 "parse.y"
                    {
                        if (!check_forwarding_args(p)) {
                            (yyval.node) = 0;
                        }
                        else {
                            (yyval.node) = new_args_forward_call(p, (yyvsp[-3].node), &(yylsp[-1]), &(yyloc));
                        /*% ripper: arg_paren!(args_add!($:2, $:4)) %*/
                        }
                    }
#line 13664 "parse.c"
    break;

  case 293: /* paren_args: '(' args_forward rparen  */
#line 4194 "parse.y"
                    {
                        if (!check_forwarding_args(p)) {
                            (yyval.node) = 0;
                        }
                        else {
                            (yyval.node) = new_args_forward_call(p, 0, &(yylsp[-1]), &(yyloc));
                        /*% ripper: arg_paren!($:2) %*/
                        }
                    }
#line 13678 "parse.c"
    break;

  case 295: /* opt_paren_args: paren_args  */
#line 4207 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node) ? (yyvsp[0].node) : NODE_SPECIAL_EMPTY_ARGS;
                    }
#line 13686 "parse.c"
    break;

  case 298: /* opt_call_args: args ','  */
#line 4215 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    }
#line 13694 "parse.c"
    break;

  case 299: /* opt_call_args: args ',' assocs ','  */
#line 4219 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? arg_append(p, (yyvsp[-3].node), new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : (yyvsp[-3].node);
                    /*% ripper: args_add!($:1, bare_assoc_hash!($:3)) %*/
                    }
#line 13703 "parse.c"
    break;

  case 300: /* opt_call_args: assocs ','  */
#line 4224 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? NEW_LIST(new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yylsp[-1])) : 0;
                    /*% ripper: args_add!(args_new!, bare_assoc_hash!($:1)) %*/
                    }
#line 13712 "parse.c"
    break;

  case 301: /* call_args: command  */
#line 4231 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:1) %*/
                    }
#line 13722 "parse.c"
    break;

  case 302: /* call_args: args opt_block_arg  */
#line 4237 "parse.y"
                    {
                        (yyval.node) = arg_blk_pass((yyvsp[-1].node), (yyvsp[0].node_block_pass));
                    /*% ripper: args_add_block!($:1, $:2) %*/
                    }
#line 13731 "parse.c"
    break;

  case 303: /* call_args: assocs opt_block_arg  */
#line 4242 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? NEW_LIST(new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yylsp[-1])) : 0;
                        (yyval.node) = arg_blk_pass((yyval.node), (yyvsp[0].node_block_pass));
                    /*% ripper: args_add_block!(args_add!(args_new!, bare_assoc_hash!($:1)), $:2) %*/
                    }
#line 13741 "parse.c"
    break;

  case 304: /* call_args: args ',' assocs opt_block_arg  */
#line 4248 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? arg_append(p, (yyvsp[-3].node), new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : (yyvsp[-3].node);
                        (yyval.node) = arg_blk_pass((yyval.node), (yyvsp[0].node_block_pass));
                    /*% ripper: args_add_block!(args_add!($:1, bare_assoc_hash!($:3)), $:4) %*/
                    }
#line 13751 "parse.c"
    break;

  case 306: /* $@13: %empty  */
#line 4257 "parse.y"
                 {
                        /* If call_args starts with a open paren '(' or '[',
                         * look-ahead reading of the letters calls CMDARG_PUSH(0),
                         * but the push must be done after CMDARG_PUSH(1).
                         * So this code makes them consistent by first cancelling
                         * the premature CMDARG_PUSH(0), doing CMDARG_PUSH(1),
                         * and finally redoing CMDARG_PUSH(0).
                         */
                        int lookahead = 0;
                        switch (yychar) {
                          case '(': case tLPAREN: case tLPAREN_ARG: case '[': case tLBRACK:
                            lookahead = 1;
                        }
                        if (lookahead) CMDARG_POP();
                        CMDARG_PUSH(1);
                        if (lookahead) CMDARG_PUSH(0);
                    }
#line 13773 "parse.c"
    break;

  case 307: /* command_args: $@13 call_args  */
#line 4275 "parse.y"
                    {
                        /* call_args can be followed by tLBRACE_ARG (that does CMDARG_PUSH(0) in the lexer)
                         * but the push must be done after CMDARG_POP() in the parser.
                         * So this code does CMDARG_POP() to pop 0 pushed by tLBRACE_ARG,
                         * CMDARG_POP() to pop 1 pushed by command_args,
                         * and CMDARG_PUSH(0) to restore back the flag set by tLBRACE_ARG.
                         */
                        int lookahead = 0;
                        switch (yychar) {
                          case tLBRACE_ARG:
                            lookahead = 1;
                        }
                        if (lookahead) CMDARG_POP();
                        CMDARG_POP();
                        if (lookahead) CMDARG_PUSH(0);
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: $:2 %*/
                    }
#line 13796 "parse.c"
    break;

  case 308: /* block_arg: "&" arg_value  */
#line 4296 "parse.y"
                    {
                        (yyval.node_block_pass) = NEW_BLOCK_PASS((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: $:2 %*/
                    }
#line 13805 "parse.c"
    break;

  case 309: /* block_arg: "&"  */
#line 4301 "parse.y"
                    {
                        forwarding_arg_check(p, idFWD_BLOCK, idFWD_ALL, "block");
                        (yyval.node_block_pass) = NEW_BLOCK_PASS(NEW_LVAR(idFWD_BLOCK, &(yylsp[0])), &(yyloc), &(yylsp[0]));
                    /*% ripper: Qnil %*/
                    }
#line 13815 "parse.c"
    break;

  case 310: /* opt_block_arg: ',' block_arg  */
#line 4309 "parse.y"
                    {
                        (yyval.node_block_pass) = (yyvsp[0].node_block_pass);
                    /*% ripper: $:2 %*/
                    }
#line 13824 "parse.c"
    break;

  case 311: /* opt_block_arg: none  */
#line 4314 "parse.y"
                    {
                        (yyval.node_block_pass) = 0;
                    /*% ripper: Qfalse %*/
                    }
#line 13833 "parse.c"
    break;

  case 312: /* args: arg_value  */
#line 4322 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:arg_value) %*/
                    }
#line 13842 "parse.c"
    break;

  case 313: /* args: arg_splat  */
#line 4327 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: args_add_star!(args_new!, $:arg_splat) %*/
                    }
#line 13851 "parse.c"
    break;

  case 314: /* args: args ',' arg_value  */
#line 4332 "parse.y"
                    {
                        (yyval.node) = last_arg_append(p, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!($:non_last_args, $:arg_value) %*/
                    }
#line 13860 "parse.c"
    break;

  case 315: /* args: args ',' arg_splat  */
#line 4337 "parse.y"
                    {
                        (yyval.node) = rest_arg_append(p, (yyvsp[-2].node), RNODE_SPLAT((yyvsp[0].node))->nd_head, &(yyloc));
                    /*% ripper: args_add_star!($:non_last_args, $:arg_splat) %*/
                    }
#line 13869 "parse.c"
    break;

  case 316: /* arg_splat: "*" arg_value  */
#line 4345 "parse.y"
                    {
                        (yyval.node) = NEW_SPLAT((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: $:arg_value %*/
                    }
#line 13878 "parse.c"
    break;

  case 317: /* arg_splat: "*"  */
#line 4350 "parse.y"
                    {
                        forwarding_arg_check(p, idFWD_REST, idFWD_ALL, "rest");
                        (yyval.node) = NEW_SPLAT(NEW_LVAR(idFWD_REST, &(yylsp[0])), &(yyloc), &(yylsp[0]));
                    /*% ripper: Qnil %*/
                    }
#line 13888 "parse.c"
    break;

  case 320: /* mrhs: args ',' arg_value  */
#line 4364 "parse.y"
                    {
                        (yyval.node) = last_arg_append(p, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mrhs_add!(mrhs_new_from_args!($:args), $:arg_value) %*/
                    }
#line 13897 "parse.c"
    break;

  case 321: /* mrhs: args ',' "*" arg_value  */
#line 4369 "parse.y"
                    {
                        (yyval.node) = rest_arg_append(p, (yyvsp[-3].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mrhs_add_star!(mrhs_new_from_args!($:args), $:arg_value) %*/
                    }
#line 13906 "parse.c"
    break;

  case 322: /* mrhs: "*" arg_value  */
#line 4374 "parse.y"
                    {
                        (yyval.node) = NEW_SPLAT((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: mrhs_add_star!(mrhs_new!, $:arg_value) %*/
                    }
#line 13915 "parse.c"
    break;

  case 333: /* primary: "method"  */
#line 4395 "parse.y"
                    {
                        (yyval.node) = (NODE *)NEW_FCALL((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: method_add_arg!(fcall!($:1), args_new!) %*/
                    }
#line 13924 "parse.c"
    break;

  case 334: /* $@14: %empty  */
#line 4400 "parse.y"
                    {
                        CMDARG_PUSH(0);
                    }
#line 13932 "parse.c"
    break;

  case 335: /* primary: k_begin $@14 bodystmt k_end  */
#line 4405 "parse.y"
                    {
                        CMDARG_POP();
                        set_line_body((yyvsp[-1].node), (yylsp[-3]).end_pos.lineno);
                        (yyval.node) = NEW_BEGIN((yyvsp[-1].node), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-3]).end_pos.lineno);
                    /*% ripper: begin!($:3) %*/
                    }
#line 13944 "parse.c"
    break;

  case 336: /* $@15: %empty  */
#line 4412 "parse.y"
                                       {SET_LEX_STATE(EXPR_ENDARG);}
#line 13950 "parse.c"
    break;

  case 337: /* primary: "( arg" compstmt $@15 ')'  */
#line 4413 "parse.y"
                    {
                        if (nd_type_p((yyvsp[-2].node), NODE_SELF)) RNODE_SELF((yyvsp[-2].node))->nd_state = 0;
                        (yyval.node) = (yyvsp[-2].node);
                    /*% ripper: paren!($:2) %*/
                    }
#line 13960 "parse.c"
    break;

  case 338: /* primary: "(" compstmt ')'  */
#line 4419 "parse.y"
                    {
                        if (nd_type_p((yyvsp[-1].node), NODE_SELF)) RNODE_SELF((yyvsp[-1].node))->nd_state = 0;
                        (yyval.node) = NEW_BLOCK((yyvsp[-1].node), &(yyloc));
                    /*% ripper: paren!($:2) %*/
                    }
#line 13970 "parse.c"
    break;

  case 339: /* primary: primary_value "::" "constant"  */
#line 4425 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc));
                    /*% ripper: const_path_ref!($:1, $:3) %*/
                    }
#line 13979 "parse.c"
    break;

  case 340: /* primary: ":: at EXPR_BEG" "constant"  */
#line 4430 "parse.y"
                    {
                        (yyval.node) = NEW_COLON3((yyvsp[0].id), &(yyloc));
                    /*% ripper: top_const_ref!($:2) %*/
                    }
#line 13988 "parse.c"
    break;

  case 341: /* primary: "[" aref_args ']'  */
#line 4435 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:2) %*/
                    }
#line 13997 "parse.c"
    break;

  case 342: /* primary: "{" assoc_list '}'  */
#line 4440 "parse.y"
                    {
                        (yyval.node) = new_hash(p, (yyvsp[-1].node), &(yyloc));
                        RNODE_HASH((yyval.node))->nd_brace = TRUE;
                    /*% ripper: hash!($:2) %*/
                    }
#line 14007 "parse.c"
    break;

  case 343: /* primary: k_return  */
#line 4446 "parse.y"
                    {
                        (yyval.node) = NEW_RETURN(0, &(yyloc), &(yylsp[0]));
                    /*% ripper: return0! %*/
                    }
#line 14016 "parse.c"
    break;

  case 344: /* primary: k_yield '(' call_args rparen  */
#line 4451 "parse.y"
                    {
                        (yyval.node) = new_yield(p, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: yield!(paren!($:3)) %*/
                    }
#line 14025 "parse.c"
    break;

  case 345: /* primary: k_yield '(' rparen  */
#line 4456 "parse.y"
                    {
                        (yyval.node) = NEW_YIELD(0, &(yyloc));
                    /*% ripper: yield!(paren!(args_new!)) %*/
                    }
#line 14034 "parse.c"
    break;

  case 346: /* primary: k_yield  */
#line 4461 "parse.y"
                    {
                        (yyval.node) = NEW_YIELD(0, &(yyloc));
                    /*% ripper: yield0! %*/
                    }
#line 14043 "parse.c"
    break;

  case 347: /* primary: "'defined?'" option_'\n' '(' begin_defined expr rparen  */
#line 4466 "parse.y"
                    {
                        p->ctxt.in_defined = (yyvsp[-2].ctxt).in_defined;
                        (yyval.node) = new_defined(p, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: defined!($:5) %*/
                    }
#line 14053 "parse.c"
    break;

  case 348: /* primary: "'not'" '(' expr rparen  */
#line 4472 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[-1].node), &(yylsp[-1])), METHOD_NOT, &(yylsp[-3]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 14062 "parse.c"
    break;

  case 349: /* primary: "'not'" '(' rparen  */
#line 4477 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, new_nil(&(yylsp[-1])), &(yylsp[-1])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), Qnil) %*/
                    }
#line 14071 "parse.c"
    break;

  case 350: /* primary: fcall brace_block  */
#line 4482 "parse.y"
                    {
                        (yyval.node) = method_add_block(p, (NODE *)(yyvsp[-1].node_fcall), (yyvsp[0].node), &(yyloc));
                    /*% ripper: method_add_block!(method_add_arg!(fcall!($:1), args_new!), $:2) %*/
                    }
#line 14080 "parse.c"
    break;

  case 352: /* primary: method_call brace_block  */
#line 4488 "parse.y"
                    {
                        block_dup_check(p, get_nd_args(p, (yyvsp[-1].node)), (yyvsp[0].node));
                        (yyval.node) = method_add_block(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: method_add_block!($:1, $:2) %*/
                    }
#line 14090 "parse.c"
    break;

  case 354: /* primary: k_if expr_value then compstmt if_tail k_end  */
#line 4498 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-4].node));
                    /*% ripper: if!($:2, $:4, $:5) %*/
                    }
#line 14100 "parse.c"
    break;

  case 355: /* primary: k_unless expr_value then compstmt opt_else k_end  */
#line 4507 "parse.y"
                    {
                        (yyval.node) = new_unless(p, (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-5]), &(yylsp[-3]), &(yylsp[0]));
                        fixpos((yyval.node), (yyvsp[-4].node));
                    /*% ripper: unless!($:2, $:4, $:5) %*/
                    }
#line 14110 "parse.c"
    break;

  case 356: /* primary: k_while expr_value_do compstmt k_end  */
#line 4515 "parse.y"
                    {
                        restore_block_exit(p, (yyvsp[-3].node_exits));
                        (yyval.node) = NEW_WHILE(cond(p, (yyvsp[-2].node), &(yylsp[-2])), (yyvsp[-1].node), 1, &(yyloc), &(yylsp[-3]), &(yylsp[0]));
                        fixpos((yyval.node), (yyvsp[-2].node));
                    /*% ripper: while!($:2, $:3) %*/
                    }
#line 14121 "parse.c"
    break;

  case 357: /* primary: k_until expr_value_do compstmt k_end  */
#line 4524 "parse.y"
                    {
                        restore_block_exit(p, (yyvsp[-3].node_exits));
                        (yyval.node) = NEW_UNTIL(cond(p, (yyvsp[-2].node), &(yylsp[-2])), (yyvsp[-1].node), 1, &(yyloc), &(yylsp[-3]), &(yylsp[0]));
                        fixpos((yyval.node), (yyvsp[-2].node));
                    /*% ripper: until!($:2, $:3) %*/
                    }
#line 14132 "parse.c"
    break;

  case 358: /* @16: %empty  */
#line 4531 "parse.y"
                    {
                        (yyval.labels) = p->case_labels;
                        p->case_labels = CHECK_LITERAL_WHEN;
                    }
#line 14141 "parse.c"
    break;

  case 359: /* primary: k_case expr_value option_terms @16 case_body k_end  */
#line 4537 "parse.y"
                    {
                        if (CASE_LABELS_ENABLED_P(p->case_labels)) st_free_table(p->case_labels);
                        p->case_labels = (yyvsp[-2].labels);
                        (yyval.node) = NEW_CASE((yyvsp[-4].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-5]), &(yylsp[0]));
                        fixpos((yyval.node), (yyvsp[-4].node));
                    /*% ripper: case!($:2, $:5) %*/
                    }
#line 14153 "parse.c"
    break;

  case 360: /* @17: %empty  */
#line 4545 "parse.y"
                    {
                        (yyval.labels) = p->case_labels;
                        p->case_labels = 0;
                    }
#line 14162 "parse.c"
    break;

  case 361: /* primary: k_case option_terms @17 case_body k_end  */
#line 4551 "parse.y"
                    {
                        if (p->case_labels) st_free_table(p->case_labels);
                        p->case_labels = (yyvsp[-2].labels);
                        (yyval.node) = NEW_CASE2((yyvsp[-1].node), &(yyloc), &(yylsp[-4]), &(yylsp[0]));
                    /*% ripper: case!(Qnil, $:4) %*/
                    }
#line 14173 "parse.c"
    break;

  case 362: /* primary: k_case expr_value option_terms p_case_body k_end  */
#line 4560 "parse.y"
                    {
                        (yyval.node) = NEW_CASE3((yyvsp[-3].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-4]), &(yylsp[0]));
                    /*% ripper: case!($:2, $:4) %*/
                    }
#line 14182 "parse.c"
    break;

  case 363: /* primary: k_for for_var "'in'" expr_value_do compstmt k_end  */
#line 4567 "parse.y"
                    {
                        restore_block_exit(p, (yyvsp[-5].node_exits));
                        /*
                         *  for a, b, c in e
                         *  #=>
                         *  e.each{|*x| a, b, c = x}
                         *
                         *  for a in e
                         *  #=>
                         *  e.each{|x| a, = x}
                         */
                        ID id = internal_id(p);
                        rb_node_args_aux_t *m = NEW_ARGS_AUX(0, 0, &NULL_LOC);
                        rb_node_args_t *args;
                        NODE *scope, *internal_var = NEW_DVAR(id, &(yylsp[-4]));
                        rb_ast_id_table_t *tbl = rb_ast_new_local_table(p->ast, 1);
                        tbl->ids[0] = id; /* internal id */

                        switch (nd_type((yyvsp[-4].node))) {
                          case NODE_LASGN:
                          case NODE_DASGN: /* e.each {|internal_var| a = internal_var; ... } */
                            set_nd_value(p, (yyvsp[-4].node), internal_var);
                            id = 0;
                            m->nd_plen = 1;
                            m->nd_next = (yyvsp[-4].node);
                            break;
                          case NODE_MASGN: /* e.each {|*internal_var| a, b, c = (internal_var.length == 1 && Array === (tmp = internal_var[0]) ? tmp : internal_var); ... } */
                            m->nd_next = node_assign(p, (yyvsp[-4].node), NEW_FOR_MASGN(internal_var, &(yylsp[-4])), NO_LEX_CTXT, &(yylsp[-4]));
                            break;
                          default: /* e.each {|*internal_var| @a, B, c[1], d.attr = internal_val; ... } */
                            m->nd_next = node_assign(p, (NODE *)NEW_MASGN(NEW_LIST((yyvsp[-4].node), &(yylsp[-4])), 0, &(yylsp[-4])), internal_var, NO_LEX_CTXT, &(yylsp[-4]));
                        }
                        /* {|*internal_id| <m> = internal_id; ... } */
                        args = new_args(p, m, 0, id, 0, new_args_tail(p, 0, 0, 0, &(yylsp[-4])), &(yylsp[-4]));
                        scope = NEW_SCOPE2(tbl, args, (yyvsp[-1].node), &(yyloc));
                        (yyval.node) = NEW_FOR((yyvsp[-2].node), scope, &(yyloc));
                        fixpos((yyval.node), (yyvsp[-4].node));
                    /*% ripper: for!($:2, $:4, $:5) %*/
                    }
#line 14226 "parse.c"
    break;

  case 364: /* $@18: %empty  */
#line 4607 "parse.y"
                    {
                        begin_definition("class", &(yylsp[-2]), &(yylsp[-1]));
                    }
#line 14234 "parse.c"
    break;

  case 365: /* primary: k_class cpath superclass $@18 bodystmt k_end  */
#line 4612 "parse.y"
                    {
                        (yyval.node) = NEW_CLASS((yyvsp[-4].node), (yyvsp[-1].node), (yyvsp[-3].node), &(yyloc));
                        nd_set_line(RNODE_CLASS((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                        set_line_body((yyvsp[-1].node), (yylsp[-3]).end_pos.lineno);
                        nd_set_line((yyval.node), (yylsp[-3]).end_pos.lineno);
                    /*% ripper: class!($:cpath, $:superclass, $:bodystmt) %*/
                        local_pop(p);
                        p->ctxt.in_class = (yyvsp[-5].ctxt).in_class;
                        p->ctxt.cant_return = (yyvsp[-5].ctxt).cant_return;
                        p->ctxt.shareable_constant_value = (yyvsp[-5].ctxt).shareable_constant_value;
                    }
#line 14250 "parse.c"
    break;

  case 366: /* $@19: %empty  */
#line 4624 "parse.y"
                    {
                        begin_definition("", &(yylsp[-2]), &(yylsp[-1]));
                    }
#line 14258 "parse.c"
    break;

  case 367: /* primary: k_class "<<" expr_value $@19 term bodystmt k_end  */
#line 4630 "parse.y"
                    {
                        (yyval.node) = NEW_SCLASS((yyvsp[-4].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_line(RNODE_SCLASS((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                        set_line_body((yyvsp[-1].node), nd_line((yyvsp[-4].node)));
                        fixpos((yyval.node), (yyvsp[-4].node));
                    /*% ripper: sclass!($:expr_value, $:bodystmt) %*/
                        local_pop(p);
                        p->ctxt.in_def = (yyvsp[-6].ctxt).in_def;
                        p->ctxt.in_class = (yyvsp[-6].ctxt).in_class;
                        p->ctxt.cant_return = (yyvsp[-6].ctxt).cant_return;
                        p->ctxt.shareable_constant_value = (yyvsp[-6].ctxt).shareable_constant_value;
                    }
#line 14275 "parse.c"
    break;

  case 368: /* $@20: %empty  */
#line 4643 "parse.y"
                    {
                        begin_definition("module", &(yylsp[-1]), &(yylsp[0]));
                    }
#line 14283 "parse.c"
    break;

  case 369: /* primary: k_module cpath $@20 bodystmt k_end  */
#line 4648 "parse.y"
                    {
                        (yyval.node) = NEW_MODULE((yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_line(RNODE_MODULE((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                        set_line_body((yyvsp[-1].node), (yylsp[-3]).end_pos.lineno);
                        nd_set_line((yyval.node), (yylsp[-3]).end_pos.lineno);
                    /*% ripper: module!($:cpath, $:bodystmt) %*/
                        local_pop(p);
                        p->ctxt.in_class = (yyvsp[-4].ctxt).in_class;
                        p->ctxt.cant_return = (yyvsp[-4].ctxt).cant_return;
                        p->ctxt.shareable_constant_value = (yyvsp[-4].ctxt).shareable_constant_value;
                    }
#line 14299 "parse.c"
    break;

  case 370: /* $@21: %empty  */
#line 4661 "parse.y"
                    {
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14307 "parse.c"
    break;

  case 371: /* primary: defn_head f_arglist $@21 bodystmt k_end  */
#line 4666 "parse.y"
                    {
                        restore_defun(p, (yyvsp[-4].node_def_temp));
                        (yyvsp[-1].node) = new_scope_body(p, (yyvsp[-3].node_args), (yyvsp[-1].node), &(yyloc));
                        ((yyval.node) = (yyvsp[-4].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        RNODE_DEFN((yyval.node))->nd_defn = (yyvsp[-1].node);
                    /*% ripper: def!($:head, $:args, $:bodystmt) %*/
                        local_pop(p);
                    }
#line 14320 "parse.c"
    break;

  case 372: /* $@22: %empty  */
#line 4676 "parse.y"
                    {
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14328 "parse.c"
    break;

  case 373: /* primary: defs_head f_arglist $@22 bodystmt k_end  */
#line 4681 "parse.y"
                    {
                        restore_defun(p, (yyvsp[-4].node_def_temp));
                        (yyvsp[-1].node) = new_scope_body(p, (yyvsp[-3].node_args), (yyvsp[-1].node), &(yyloc));
                        ((yyval.node) = (yyvsp[-4].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        RNODE_DEFS((yyval.node))->nd_defn = (yyvsp[-1].node);
                    /*% ripper: defs!(*$:head[0..2], $:args, $:bodystmt) %*/
                        local_pop(p);
                    }
#line 14341 "parse.c"
    break;

  case 374: /* primary: "'break'"  */
#line 4690 "parse.y"
                    {
                        (yyval.node) = add_block_exit(p, NEW_BREAK(0, &(yyloc), &(yylsp[0])));
                    /*% ripper: break!(args_new!) %*/
                    }
#line 14350 "parse.c"
    break;

  case 375: /* primary: "'next'"  */
#line 4695 "parse.y"
                    {
                        (yyval.node) = add_block_exit(p, NEW_NEXT(0, &(yyloc), &(yylsp[0])));
                    /*% ripper: next!(args_new!) %*/
                    }
#line 14359 "parse.c"
    break;

  case 376: /* primary: "'redo'"  */
#line 4700 "parse.y"
                    {
                        (yyval.node) = add_block_exit(p, NEW_REDO(&(yyloc), &(yylsp[0])));
                    /*% ripper: redo! %*/
                    }
#line 14368 "parse.c"
    break;

  case 377: /* primary: "'retry'"  */
#line 4705 "parse.y"
                    {
                        if (!p->ctxt.in_defined) {
                            switch (p->ctxt.in_rescue) {
                              case before_rescue: yyerror1(&(yylsp[0]), "Invalid retry without rescue"); break;
                              case after_rescue: /* ok */ break;
                              case after_else: yyerror1(&(yylsp[0]), "Invalid retry after else"); break;
                              case after_ensure: yyerror1(&(yylsp[0]), "Invalid retry after ensure"); break;
                            }
                        }
                        (yyval.node) = NEW_RETRY(&(yyloc));
                    /*% ripper: retry! %*/
                    }
#line 14385 "parse.c"
    break;

  case 378: /* primary_value: primary  */
#line 4720 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 14394 "parse.c"
    break;

  case 379: /* k_begin: "'begin'"  */
#line 4727 "parse.y"
                    {
                        token_info_push(p, "begin", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14403 "parse.c"
    break;

  case 380: /* k_if: "'if'"  */
#line 4734 "parse.y"
                    {
                        WARN_EOL("if");
                        token_info_push(p, "if", &(yyloc));
                        if (p->token_info && p->token_info->nonspc &&
                            p->token_info->next && !strcmp(p->token_info->next->token, "else")) {
                            const char *tok = p->lex.ptok - rb_strlen_lit("if");
                            const char *beg = p->lex.pbeg + p->token_info->next->beg.column;
                            beg += rb_strlen_lit("else");
                            while (beg < tok && ISSPACE(*beg)) beg++;
                            if (beg == tok) {
                                p->token_info->nonspc = 0;
                            }
                        }
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14423 "parse.c"
    break;

  case 381: /* k_unless: "'unless'"  */
#line 4752 "parse.y"
                    {
                        token_info_push(p, "unless", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14432 "parse.c"
    break;

  case 382: /* k_while: "'while'" allow_exits  */
#line 4759 "parse.y"
                    {
                        (yyval.node_exits) = (yyvsp[0].node_exits);
                        token_info_push(p, "while", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14442 "parse.c"
    break;

  case 383: /* k_until: "'until'" allow_exits  */
#line 4767 "parse.y"
                    {
                        (yyval.node_exits) = (yyvsp[0].node_exits);
                        token_info_push(p, "until", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14452 "parse.c"
    break;

  case 384: /* k_case: "'case'"  */
#line 4775 "parse.y"
                    {
                        token_info_push(p, "case", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14461 "parse.c"
    break;

  case 385: /* k_for: "'for'" allow_exits  */
#line 4782 "parse.y"
                    {
                        (yyval.node_exits) = (yyvsp[0].node_exits);
                        token_info_push(p, "for", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14471 "parse.c"
    break;

  case 386: /* k_class: "'class'"  */
#line 4790 "parse.y"
                    {
                        token_info_push(p, "class", &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_rescue = before_rescue;
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14482 "parse.c"
    break;

  case 387: /* k_module: "'module'"  */
#line 4799 "parse.y"
                    {
                        token_info_push(p, "module", &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_rescue = before_rescue;
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14493 "parse.c"
    break;

  case 388: /* k_def: "'def'"  */
#line 4808 "parse.y"
                    {
                        token_info_push(p, "def", &(yyloc));
                        (yyval.node_def_temp) = NEW_DEF_TEMP(&(yyloc));
                        p->ctxt.in_argdef = 1;
                    }
#line 14503 "parse.c"
    break;

  case 389: /* k_do: "'do'"  */
#line 4816 "parse.y"
                    {
                        token_info_push(p, "do", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14512 "parse.c"
    break;

  case 390: /* k_do_block: "'do' for block"  */
#line 4823 "parse.y"
                    {
                        token_info_push(p, "do", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14521 "parse.c"
    break;

  case 391: /* k_rescue: "'rescue'"  */
#line 4830 "parse.y"
                    {
                        token_info_warn(p, "rescue", p->token_info, 1, &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_rescue = after_rescue;
                    }
#line 14531 "parse.c"
    break;

  case 392: /* k_ensure: "'ensure'"  */
#line 4838 "parse.y"
                    {
                        token_info_warn(p, "ensure", p->token_info, 1, &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                    }
#line 14540 "parse.c"
    break;

  case 393: /* k_when: "'when'"  */
#line 4845 "parse.y"
                    {
                        token_info_warn(p, "when", p->token_info, 0, &(yyloc));
                    }
#line 14548 "parse.c"
    break;

  case 394: /* k_else: "'else'"  */
#line 4851 "parse.y"
                    {
                        token_info *ptinfo_beg = p->token_info;
                        int same = ptinfo_beg && strcmp(ptinfo_beg->token, "case") != 0;
                        token_info_warn(p, "else", p->token_info, same, &(yyloc));
                        if (same) {
                            token_info e;
                            e.next = ptinfo_beg->next;
                            e.token = "else";
                            token_info_setup(&e, p->lex.pbeg, &(yyloc));
                            if (!e.nonspc) *ptinfo_beg = e;
                        }
                    }
#line 14565 "parse.c"
    break;

  case 395: /* k_elsif: "'elsif'"  */
#line 4866 "parse.y"
                    {
                        WARN_EOL("elsif");
                        token_info_warn(p, "elsif", p->token_info, 1, &(yyloc));
                    }
#line 14574 "parse.c"
    break;

  case 396: /* k_end: "'end'"  */
#line 4873 "parse.y"
                    {
                        token_info_pop(p, "end", &(yyloc));
                        pop_end_expect_token_locations(p);
                    }
#line 14583 "parse.c"
    break;

  case 397: /* k_end: "dummy end"  */
#line 4878 "parse.y"
                    {
                        compile_error(p, "syntax error, unexpected end-of-input");
                    }
#line 14591 "parse.c"
    break;

  case 398: /* k_return: "'return'"  */
#line 4884 "parse.y"
                    {
                        if (p->ctxt.cant_return && !dyna_in_block(p))
                            yyerror1(&(yylsp[0]), "Invalid return in class/module body");
                    }
#line 14600 "parse.c"
    break;

  case 399: /* k_yield: "'yield'"  */
#line 4891 "parse.y"
                    {
                        if (!p->ctxt.in_defined && !p->ctxt.in_def && !compile_for_eval)
                            yyerror1(&(yylsp[0]), "Invalid yield");
                    }
#line 14609 "parse.c"
    break;

  case 406: /* if_tail: k_elsif expr_value then compstmt if_tail  */
#line 4910 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[-3].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-3].node));
                    /*% ripper: elsif!($:2, $:4, $:5) %*/
                    }
#line 14619 "parse.c"
    break;

  case 408: /* opt_else: k_else compstmt  */
#line 4919 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: else!($:2) %*/
                    }
#line 14628 "parse.c"
    break;

  case 411: /* f_marg: f_norm_arg  */
#line 4930 "parse.y"
                    {
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                        mark_lvar_used(p, (yyval.node));
                    }
#line 14637 "parse.c"
    break;

  case 412: /* f_marg: "(" f_margs rparen  */
#line 4935 "parse.y"
                    {
                        (yyval.node) = (NODE *)(yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 14646 "parse.c"
    break;

  case 413: /* f_marg_list: f_marg  */
#line 4942 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add!(mlhs_new!, $:1) %*/
                    }
#line 14655 "parse.c"
    break;

  case 414: /* f_marg_list: f_marg_list ',' f_marg  */
#line 4947 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: mlhs_add!($:1, $:3) %*/
                    }
#line 14664 "parse.c"
    break;

  case 415: /* f_margs: f_marg_list  */
#line 4954 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 14673 "parse.c"
    break;

  case 416: /* f_margs: f_marg_list ',' f_rest_marg  */
#line 4959 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!($:1, $:3) %*/
                    }
#line 14682 "parse.c"
    break;

  case 417: /* f_margs: f_marg_list ',' f_rest_marg ',' f_marg_list  */
#line 4964 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-4].node), NEW_POSTARG((yyvsp[-2].node), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!($:1, $:3), $:5) %*/
                    }
#line 14691 "parse.c"
    break;

  case 418: /* f_margs: f_rest_marg  */
#line 4969 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!(mlhs_new!, $:1) %*/
                    }
#line 14700 "parse.c"
    break;

  case 419: /* f_margs: f_rest_marg ',' f_marg_list  */
#line 4974 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NEW_POSTARG((yyvsp[-2].node), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!(mlhs_new!, $:1), $:3) %*/
                    }
#line 14709 "parse.c"
    break;

  case 420: /* f_rest_marg: "*" f_norm_arg  */
#line 4981 "parse.y"
                    {
                    /*% ripper: $:2 %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                        mark_lvar_used(p, (yyval.node));
                    }
#line 14719 "parse.c"
    break;

  case 421: /* f_rest_marg: "*"  */
#line 4987 "parse.y"
                    {
                        (yyval.node) = NODE_SPECIAL_NO_NAME_REST;
                    /*% ripper: Qnil %*/
                    }
#line 14728 "parse.c"
    break;

  case 423: /* f_any_kwrest: f_no_kwarg  */
#line 4995 "parse.y"
                    {
                        (yyval.id) = idNil;
                    /*% ripper: ID2VAL(idNil) %*/
                    }
#line 14737 "parse.c"
    break;

  case 424: /* $@23: %empty  */
#line 5001 "parse.y"
        {p->ctxt.in_argdef = 0;}
#line 14743 "parse.c"
    break;

  case 426: /* f_kwarg_f_block_kw: f_block_kw  */
#line 2935 "parse.y"
                    {
                        (yyval.node_kw_arg) = (yyvsp[0].node_kw_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 14752 "parse.c"
    break;

  case 427: /* f_kwarg_f_block_kw: f_kwarg_f_block_kw ',' f_block_kw  */
#line 2940 "parse.y"
                    {
                        (yyval.node_kw_arg) = kwd_append((yyvsp[-2].node_kw_arg), (yyvsp[0].node_kw_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 14761 "parse.c"
    break;

  case 428: /* block_args_tail: f_kwarg_f_block_kw ',' f_kwrest opt_f_block_arg  */
#line 5004 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-3].node_kw_arg), (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, $:3, $:4] %*/
                    }
#line 14770 "parse.c"
    break;

  case 429: /* block_args_tail: f_kwarg_f_block_kw opt_f_block_arg  */
#line 5009 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-1].node_kw_arg), 0, (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, Qnil, $:2] %*/
                    }
#line 14779 "parse.c"
    break;

  case 430: /* block_args_tail: f_any_kwrest opt_f_block_arg  */
#line 5014 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [Qnil, $:1, $:2] %*/
                    }
#line 14788 "parse.c"
    break;

  case 431: /* block_args_tail: f_block_arg  */
#line 5019 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, $:1] %*/
                    }
#line 14797 "parse.c"
    break;

  case 432: /* excessed_comma: ','  */
#line 5026 "parse.y"
                    {
                        /* magic number for rest_id in iseq_set_arguments() */
                        (yyval.id) = NODE_SPECIAL_EXCESSIVE_COMMA;
                    /*% ripper: excessed_comma! %*/
                    }
#line 14807 "parse.c"
    break;

  case 433: /* f_opt_primary_value: f_arg_asgn f_eq primary_value  */
#line 2913 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_opt_arg) = NEW_OPT_ARG(assignable(p, (yyvsp[-2].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:3] %*/
                    }
#line 14817 "parse.c"
    break;

  case 434: /* f_optarg_primary_value: f_opt_primary_value  */
#line 2922 "parse.y"
                    {
                        (yyval.node_opt_arg) = (yyvsp[0].node_opt_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 14826 "parse.c"
    break;

  case 435: /* f_optarg_primary_value: f_optarg_primary_value ',' f_opt_primary_value  */
#line 2927 "parse.y"
                    {
                        (yyval.node_opt_arg) = opt_arg_append((yyvsp[-2].node_opt_arg), (yyvsp[0].node_opt_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 14835 "parse.c"
    break;

  case 436: /* opt_args_tail_block_args_tail: ',' block_args_tail  */
#line 2948 "parse.y"
                    {
                        (yyval.node_args) = (yyvsp[0].node_args);
                    /*% ripper: $:2 %*/
                    }
#line 14844 "parse.c"
    break;

  case 437: /* opt_args_tail_block_args_tail: %empty  */
#line 2953 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, Qnil] %*/
                    }
#line 14853 "parse.c"
    break;

  case 438: /* block_param: f_arg ',' f_optarg_primary_value ',' f_rest_arg opt_args_tail_block_args_tail  */
#line 5034 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, Qnil, *$:6[0..2]) %*/
                    }
#line 14862 "parse.c"
    break;

  case 439: /* block_param: f_arg ',' f_optarg_primary_value ',' f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5039 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-7].node_args_aux), (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, $:7, *$:8[0..2]) %*/
                    }
#line 14871 "parse.c"
    break;

  case 440: /* block_param: f_arg ',' f_optarg_primary_value opt_args_tail_block_args_tail  */
#line 5044 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, Qnil, *$:4[0..2]) %*/
                    }
#line 14880 "parse.c"
    break;

  case 441: /* block_param: f_arg ',' f_optarg_primary_value ',' f_arg opt_args_tail_block_args_tail  */
#line 5049 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, $:5, *$:6[0..2]) %*/
                    }
#line 14889 "parse.c"
    break;

  case 442: /* block_param: f_arg ',' f_rest_arg opt_args_tail_block_args_tail  */
#line 5054 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 14898 "parse.c"
    break;

  case 443: /* block_param: f_arg excessed_comma  */
#line 5059 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                        (yyval.node_args) = new_args(p, (yyvsp[-1].node_args_aux), 0, (yyvsp[0].id), 0, (yyval.node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:2, Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 14908 "parse.c"
    break;

  case 444: /* block_param: f_arg ',' f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5065 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 14917 "parse.c"
    break;

  case 445: /* block_param: f_arg opt_args_tail_block_args_tail  */
#line 5070 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-1].node_args_aux), 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 14926 "parse.c"
    break;

  case 446: /* block_param: f_optarg_primary_value ',' f_rest_arg opt_args_tail_block_args_tail  */
#line 5075 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 14935 "parse.c"
    break;

  case 447: /* block_param: f_optarg_primary_value ',' f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5080 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 14944 "parse.c"
    break;

  case 448: /* block_param: f_optarg_primary_value opt_args_tail_block_args_tail  */
#line 5085 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 14953 "parse.c"
    break;

  case 449: /* block_param: f_optarg_primary_value ',' f_arg opt_args_tail_block_args_tail  */
#line 5090 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, $:3, *$:4[0..2]) %*/
                    }
#line 14962 "parse.c"
    break;

  case 450: /* block_param: f_rest_arg opt_args_tail_block_args_tail  */
#line 5095 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, Qnil, *$:2[0..2]) %*/
                    }
#line 14971 "parse.c"
    break;

  case 451: /* block_param: f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5100 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, $:3, *$:4[0..2]) %*/
                    }
#line 14980 "parse.c"
    break;

  case 452: /* block_param: block_args_tail  */
#line 5105 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, *$:1[0..2]) %*/
                    }
#line 14989 "parse.c"
    break;

  case 454: /* opt_block_param: block_param_def  */
#line 5113 "parse.y"
                    {
                        p->command_start = TRUE;
                    }
#line 14997 "parse.c"
    break;

  case 455: /* block_param_def: '|' opt_bv_decl '|'  */
#line 5119 "parse.y"
                    {
                        p->max_numparam = ORDINAL_PARAM;
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = 0;
                    /*% ripper: block_var!(params!(Qnil,Qnil,Qnil,Qnil,Qnil,Qnil,Qnil), $:2) %*/
                    }
#line 15008 "parse.c"
    break;

  case 456: /* block_param_def: '|' block_param opt_bv_decl '|'  */
#line 5126 "parse.y"
                    {
                        p->max_numparam = ORDINAL_PARAM;
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = (yyvsp[-2].node_args);
                    /*% ripper: block_var!($:2, $:3) %*/
                    }
#line 15019 "parse.c"
    break;

  case 457: /* opt_bv_decl: option_'\n'  */
#line 5136 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: Qfalse %*/
                    }
#line 15028 "parse.c"
    break;

  case 458: /* opt_bv_decl: option_'\n' ';' bv_decls option_'\n'  */
#line 5141 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: $:3 %*/
                    }
#line 15037 "parse.c"
    break;

  case 461: /* bvar: "local variable or method"  */
#line 5154 "parse.y"
                    {
                        new_bv(p, (yyvsp[0].id));
                    /*% ripper: $:1 %*/
                    }
#line 15046 "parse.c"
    break;

  case 462: /* bvar: f_bad_arg  */
#line 5159 "parse.y"
                    {
                        (yyval.id) = 0;
                    }
#line 15054 "parse.c"
    break;

  case 463: /* max_numparam: %empty  */
#line 5164 "parse.y"
                 {
                        (yyval.num) = p->max_numparam;
                        p->max_numparam = 0;
                    }
#line 15063 "parse.c"
    break;

  case 464: /* numparam: %empty  */
#line 5170 "parse.y"
             {
                        (yyval.node) = numparam_push(p);
                    }
#line 15071 "parse.c"
    break;

  case 465: /* it_id: %empty  */
#line 5175 "parse.y"
                    {
                        (yyval.id) = p->it_id;
                        p->it_id = 0;
                    }
#line 15080 "parse.c"
    break;

  case 466: /* @24: %empty  */
#line 5182 "parse.y"
                    {
                        token_info_push(p, "->", &(yylsp[0]));
                        (yyval.vars) = dyna_push(p);
                    }
#line 15089 "parse.c"
    break;

  case 467: /* $@25: %empty  */
#line 5188 "parse.y"
                    {
                        CMDARG_PUSH(0);
                    }
#line 15097 "parse.c"
    break;

  case 468: /* lambda: "->" @24 max_numparam numparam it_id allow_exits f_larglist $@25 lambda_body  */
#line 5192 "parse.y"
                    {
                        int max_numparam = p->max_numparam;
                        ID it_id = p->it_id;
                        p->lex.lpar_beg = (yyvsp[-8].num);
                        p->max_numparam = (yyvsp[-6].num);
                        p->it_id = (yyvsp[-4].id);
                        restore_block_exit(p, (yyvsp[-3].node_exits));
                        CMDARG_POP();
                        (yyvsp[-2].node_args) = args_with_numbered(p, (yyvsp[-2].node_args), max_numparam, it_id);
                        {
                            YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                            (yyval.node) = NEW_LAMBDA((yyvsp[-2].node_args), (yyvsp[0].node), &loc);
                            nd_set_line(RNODE_LAMBDA((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                            nd_set_line((yyval.node), (yylsp[-2]).end_pos.lineno);
                            nd_set_first_loc((yyval.node), (yylsp[-8]).beg_pos);
                        }
                    /*% ripper: lambda!($:args, $:body) %*/
                        numparam_pop(p, (yyvsp[-5].node));
                        dyna_pop(p, (yyvsp[-7].vars));
                    }
#line 15122 "parse.c"
    break;

  case 469: /* f_larglist: '(' f_args opt_bv_decl ')'  */
#line 5215 "parse.y"
                    {
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = (yyvsp[-2].node_args);
                        p->max_numparam = ORDINAL_PARAM;
                    /*% ripper: paren!($:2) %*/
                    }
#line 15133 "parse.c"
    break;

  case 470: /* f_larglist: f_args  */
#line 5222 "parse.y"
                    {
                        p->ctxt.in_argdef = 0;
                        if (!args_info_empty_p(&(yyvsp[0].node_args)->nd_ainfo))
                            p->max_numparam = ORDINAL_PARAM;
                        (yyval.node_args) = (yyvsp[0].node_args);
                    }
#line 15144 "parse.c"
    break;

  case 471: /* lambda_body: tLAMBEG compstmt '}'  */
#line 5231 "parse.y"
                    {
                        token_info_pop(p, "}", &(yylsp[0]));
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: $:2 %*/
                    }
#line 15154 "parse.c"
    break;

  case 472: /* $@26: %empty  */
#line 5237 "parse.y"
                    {
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 15162 "parse.c"
    break;

  case 473: /* lambda_body: "'do' for lambda" $@26 bodystmt k_end  */
#line 5241 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: $:3 %*/
                    }
#line 15171 "parse.c"
    break;

  case 474: /* do_block: k_do_block do_body k_end  */
#line 5248 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15181 "parse.c"
    break;

  case 475: /* block_call: command do_block  */
#line 5256 "parse.y"
                    {
                        if (nd_type_p((yyvsp[-1].node), NODE_YIELD)) {
                            compile_error(p, "block given to yield");
                        }
                        else {
                            block_dup_check(p, get_nd_args(p, (yyvsp[-1].node)), (yyvsp[0].node));
                        }
                        (yyval.node) = method_add_block(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-1].node));
                    /*% ripper: method_add_block!($:1, $:2) %*/
                    }
#line 15197 "parse.c"
    break;

  case 476: /* block_call: block_call call_op2 operation2 opt_paren_args  */
#line 5268 "parse.y"
                    {
                        bool has_args = (yyvsp[0].node) != 0;
                        if (NODE_EMPTY_ARGS_P((yyvsp[0].node))) (yyvsp[0].node) = 0;
                        (yyval.node) = new_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: call!($:1, $:2, $:3) %*/
                        if (has_args) {
                        /*% ripper: method_add_arg!($:$, $:4) %*/
                        }
                    }
#line 15211 "parse.c"
    break;

  case 477: /* block_call: block_call call_op2 operation2 opt_paren_args brace_block  */
#line 5278 "parse.y"
                    {
                        if (NODE_EMPTY_ARGS_P((yyvsp[-1].node))) (yyvsp[-1].node) = 0;
                        (yyval.node) = new_command_qcall(p, (yyvsp[-3].id), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: command_call!($:1, $:2, $:3, $:4) %*/
                        if ((yyvsp[0].node)) {
                        /*% ripper: method_add_block!($:$, $:5) %*/
                        }
                    }
#line 15224 "parse.c"
    break;

  case 478: /* block_call: block_call call_op2 operation2 command_args do_block  */
#line 5287 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, (yyvsp[-3].id), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                    }
#line 15233 "parse.c"
    break;

  case 479: /* method_call: fcall paren_args  */
#line 5294 "parse.y"
                    {
                        (yyvsp[-1].node_fcall)->nd_args = (yyvsp[0].node);
                        (yyval.node) = (NODE *)(yyvsp[-1].node_fcall);
                        nd_set_last_loc((yyvsp[-1].node_fcall), (yylsp[0]).end_pos);
                    /*% ripper: method_add_arg!(fcall!($:1), $:2) %*/
                    }
#line 15244 "parse.c"
    break;

  case 480: /* method_call: primary_value call_op operation2 opt_paren_args  */
#line 5301 "parse.y"
                    {
                        bool has_args = (yyvsp[0].node) != 0;
                        if (NODE_EMPTY_ARGS_P((yyvsp[0].node))) (yyvsp[0].node) = 0;
                        (yyval.node) = new_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: call!($:1, $:2, $:3) %*/
                        if (has_args) {
                        /*% ripper: method_add_arg!($:$, $:4) %*/
                        }
                    }
#line 15259 "parse.c"
    break;

  case 481: /* method_call: primary_value "::" operation2 paren_args  */
#line 5312 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, idCOLON2, (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: method_add_arg!(call!($:1, $:2, $:3), $:4) %*/
                    }
#line 15269 "parse.c"
    break;

  case 482: /* method_call: primary_value "::" operation3  */
#line 5318 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, idCOLON2, (yyvsp[-2].node), (yyvsp[0].id), 0, &(yylsp[0]), &(yyloc));
                    /*% ripper: call!($:1, $:2, $:3) %*/
                    }
#line 15278 "parse.c"
    break;

  case 483: /* method_call: primary_value call_op paren_args  */
#line 5323 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, (yyvsp[-1].id), (yyvsp[-2].node), idCall, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: method_add_arg!(call!($:1, $:2, ID2VAL(idCall)), $:3) %*/
                    }
#line 15288 "parse.c"
    break;

  case 484: /* method_call: primary_value "::" paren_args  */
#line 5329 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, idCOLON2, (yyvsp[-2].node), idCall, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: method_add_arg!(call!($:1, $:2, ID2VAL(idCall)), $:3) %*/
                    }
#line 15298 "parse.c"
    break;

  case 485: /* method_call: "'super'" paren_args  */
#line 5335 "parse.y"
                    {
                        (yyval.node) = NEW_SUPER((yyvsp[0].node), &(yyloc));
                    /*% ripper: super!($:2) %*/
                    }
#line 15307 "parse.c"
    break;

  case 486: /* method_call: "'super'"  */
#line 5340 "parse.y"
                    {
                        (yyval.node) = NEW_ZSUPER(&(yyloc));
                    /*% ripper: zsuper! %*/
                    }
#line 15316 "parse.c"
    break;

  case 487: /* method_call: primary_value '[' opt_call_args rbracket  */
#line 5345 "parse.y"
                    {
                        (yyval.node) = NEW_CALL((yyvsp[-3].node), tAREF, (yyvsp[-1].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-3].node));
                    /*% ripper: aref!($:1, $:3) %*/
                    }
#line 15326 "parse.c"
    break;

  case 488: /* brace_block: '{' brace_body '}'  */
#line 5353 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15336 "parse.c"
    break;

  case 489: /* brace_block: k_do do_body k_end  */
#line 5359 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15346 "parse.c"
    break;

  case 490: /* @27: %empty  */
#line 5366 "parse.y"
             {(yyval.vars) = dyna_push(p);}
#line 15352 "parse.c"
    break;

  case 491: /* brace_body: @27 max_numparam numparam it_id allow_exits opt_block_param compstmt  */
#line 5369 "parse.y"
                    {
                        int max_numparam = p->max_numparam;
                        ID it_id = p->it_id;
                        p->max_numparam = (yyvsp[-5].num);
                        p->it_id = (yyvsp[-3].id);
                        (yyvsp[-1].node_args) = args_with_numbered(p, (yyvsp[-1].node_args), max_numparam, it_id);
                        (yyval.node) = NEW_ITER((yyvsp[-1].node_args), (yyvsp[0].node), &(yyloc));
                    /*% ripper: brace_block!($:args, $:compstmt) %*/
                        restore_block_exit(p, (yyvsp[-2].node_exits));
                        numparam_pop(p, (yyvsp[-4].node));
                        dyna_pop(p, (yyvsp[-6].vars));
                    }
#line 15369 "parse.c"
    break;

  case 492: /* @28: %empty  */
#line 5383 "parse.y"
             {
                        (yyval.vars) = dyna_push(p);
                        CMDARG_PUSH(0);
                    }
#line 15378 "parse.c"
    break;

  case 493: /* do_body: @28 max_numparam numparam it_id allow_exits opt_block_param bodystmt  */
#line 5389 "parse.y"
                    {
                        int max_numparam = p->max_numparam;
                        ID it_id = p->it_id;
                        p->max_numparam = (yyvsp[-5].num);
                        p->it_id = (yyvsp[-3].id);
                        (yyvsp[-1].node_args) = args_with_numbered(p, (yyvsp[-1].node_args), max_numparam, it_id);
                        (yyval.node) = NEW_ITER((yyvsp[-1].node_args), (yyvsp[0].node), &(yyloc));
                    /*% ripper: do_block!($:args, $:bodystmt) %*/
                        CMDARG_POP();
                        restore_block_exit(p, (yyvsp[-2].node_exits));
                        numparam_pop(p, (yyvsp[-4].node));
                        dyna_pop(p, (yyvsp[-6].vars));
                    }
#line 15396 "parse.c"
    break;

  case 494: /* case_args: arg_value  */
#line 5405 "parse.y"
                    {
                        check_literal_when(p, (yyvsp[0].node), &(yylsp[0]));
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:arg_value) %*/
                    }
#line 15406 "parse.c"
    break;

  case 495: /* case_args: "*" arg_value  */
#line 5411 "parse.y"
                    {
                        (yyval.node) = NEW_SPLAT((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: args_add_star!(args_new!, $:arg_value) %*/
                    }
#line 15415 "parse.c"
    break;

  case 496: /* case_args: case_args ',' arg_value  */
#line 5416 "parse.y"
                    {
                        check_literal_when(p, (yyvsp[0].node), &(yylsp[0]));
                        (yyval.node) = last_arg_append(p, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!($:non_last_args, $:arg_value) %*/
                    }
#line 15425 "parse.c"
    break;

  case 497: /* case_args: case_args ',' "*" arg_value  */
#line 5422 "parse.y"
                    {
                        (yyval.node) = rest_arg_append(p, (yyvsp[-3].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add_star!($:non_last_args, $:arg_value) %*/
                    }
#line 15434 "parse.c"
    break;

  case 498: /* case_body: k_when case_args then compstmt cases  */
#line 5431 "parse.y"
                    {
                        (yyval.node) = NEW_WHEN((yyvsp[-3].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-2]));
                        fixpos((yyval.node), (yyvsp[-3].node));
                    /*% ripper: when!($:2, $:4, $:5) %*/
                    }
#line 15444 "parse.c"
    break;

  case 501: /* p_pvtbl: %empty  */
#line 5442 "parse.y"
           {(yyval.tbl) = p->pvtbl; p->pvtbl = st_init_numtable();}
#line 15450 "parse.c"
    break;

  case 502: /* p_pktbl: %empty  */
#line 5443 "parse.y"
           {(yyval.tbl) = p->pktbl; p->pktbl = 0;}
#line 15456 "parse.c"
    break;

  case 503: /* p_in_kwarg: %empty  */
#line 5445 "parse.y"
               {
                        (yyval.ctxt) = p->ctxt;
                        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
                        p->command_start = FALSE;
                        p->ctxt.in_kwarg = 1;
                    }
#line 15467 "parse.c"
    break;

  case 504: /* $@29: %empty  */
#line 5456 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        pop_pvtbl(p, (yyvsp[-3].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-4].ctxt).in_kwarg;
                    }
#line 15477 "parse.c"
    break;

  case 505: /* p_case_body: "'in'" p_in_kwarg p_pvtbl p_pktbl p_top_expr then $@29 compstmt p_cases  */
#line 5463 "parse.y"
                    {
                        (yyval.node) = NEW_IN((yyvsp[-4].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: in!($:expr, $:compstmt, $:cases) %*/
                    }
#line 15486 "parse.c"
    break;

  case 509: /* p_top_expr: p_top_expr_body "'if' modifier" expr_value  */
#line 5475 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[0].node), (yyvsp[-2].node), 0, &(yyloc));
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: if_mod!($:3, $:1) %*/
                    }
#line 15496 "parse.c"
    break;

  case 510: /* p_top_expr: p_top_expr_body "'unless' modifier" expr_value  */
#line 5481 "parse.y"
                    {
                        (yyval.node) = new_unless(p, (yyvsp[0].node), (yyvsp[-2].node), 0, &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: unless_mod!($:3, $:1) %*/
                    }
#line 15506 "parse.c"
    break;

  case 512: /* p_top_expr_body: p_expr ','  */
#line 5490 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 1, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, 0, (yyvsp[-1].node), (yyval.node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, [$:1], Qnil, Qnil) %*/
                    }
#line 15516 "parse.c"
    break;

  case 513: /* p_top_expr_body: p_expr ',' p_args  */
#line 5496 "parse.y"
                    {
                        (yyval.node) = new_array_pattern(p, 0, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-2]).beg_pos);
                    /*% ripper: aryptn!(Qnil, aryptn_pre_args(p, $:1, $:3[0]), *$:3[1..2]) %*/
                    }
#line 15526 "parse.c"
    break;

  case 514: /* p_top_expr_body: p_find  */
#line 5502 "parse.y"
                    {
                        (yyval.node) = new_find_pattern(p, 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: fndptn!(Qnil, *$:1[0..2]) %*/
                    }
#line 15535 "parse.c"
    break;

  case 515: /* p_top_expr_body: p_args_tail  */
#line 5507 "parse.y"
                    {
                        (yyval.node) = new_array_pattern(p, 0, 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, *$:1[0..2]) %*/
                    }
#line 15544 "parse.c"
    break;

  case 516: /* p_top_expr_body: p_kwargs  */
#line 5512 "parse.y"
                    {
                        (yyval.node) = new_hash_pattern(p, 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: hshptn!(Qnil, *$:1[0..1]) %*/
                    }
#line 15553 "parse.c"
    break;

  case 518: /* p_as: p_expr "=>" p_variable  */
#line 5522 "parse.y"
                    {
                        NODE *n = NEW_LIST((yyvsp[-2].node), &(yyloc));
                        n = list_append(p, n, (yyvsp[0].node));
                        (yyval.node) = new_hash(p, n, &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL((id_assoc)), $:3) %*/
                    }
#line 15564 "parse.c"
    break;

  case 520: /* p_alt: p_alt '|' p_expr_basic  */
#line 5532 "parse.y"
                    {
                        (yyval.node) = NEW_OR((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: binary!($:1, ID2VAL(idOr), $:3) %*/
                    }
#line 15573 "parse.c"
    break;

  case 522: /* p_lparen: '(' p_pktbl  */
#line 5540 "parse.y"
                    {
                        (yyval.tbl) = (yyvsp[0].tbl);
                    /*% ripper: $:2 %*/
                    }
#line 15582 "parse.c"
    break;

  case 523: /* p_lbracket: '[' p_pktbl  */
#line 5547 "parse.y"
                    {
                        (yyval.tbl) = (yyvsp[0].tbl);
                    /*% ripper: $:2 %*/
                    }
#line 15591 "parse.c"
    break;

  case 526: /* p_expr_basic: p_const p_lparen p_args rparen  */
#line 5556 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-3].node), 0, (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: aryptn!($:p_const, *$:p_args[0..2]) %*/
                    }
#line 15602 "parse.c"
    break;

  case 527: /* p_expr_basic: p_const p_lparen p_find rparen  */
#line 5563 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_find_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: fndptn!($:p_const, *$:p_find[0..2]) %*/
                    }
#line 15613 "parse.c"
    break;

  case 528: /* p_expr_basic: p_const p_lparen p_kwargs rparen  */
#line 5570 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_hash_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: hshptn!($:p_const, *$:p_kwargs[0..1]) %*/
                    }
#line 15624 "parse.c"
    break;

  case 529: /* p_expr_basic: p_const '(' rparen  */
#line 5577 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 0, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-2].node), 0, (yyval.node), &(yyloc));
                        /*% ripper: aryptn!($:p_const, Qnil, Qnil, Qnil) %*/
                    }
#line 15634 "parse.c"
    break;

  case 530: /* p_expr_basic: p_const p_lbracket p_args rbracket  */
#line 5583 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-3].node), 0, (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: aryptn!($:p_const, *$:p_args[0..2]) %*/
                    }
#line 15645 "parse.c"
    break;

  case 531: /* p_expr_basic: p_const p_lbracket p_find rbracket  */
#line 5590 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_find_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: fndptn!($:p_const, *$:p_find[0..2]) %*/
                    }
#line 15656 "parse.c"
    break;

  case 532: /* p_expr_basic: p_const p_lbracket p_kwargs rbracket  */
#line 5597 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_hash_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: hshptn!($:p_const, *$:p_kwargs[0..1]) %*/
                    }
#line 15667 "parse.c"
    break;

  case 533: /* p_expr_basic: p_const '[' rbracket  */
#line 5604 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 0, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-2].node), 0, (yyval.node), &(yyloc));
                    /*% ripper: aryptn!($:1, Qnil, Qnil, Qnil) %*/
                    }
#line 15677 "parse.c"
    break;

  case 534: /* p_expr_basic: "[" p_args rbracket  */
#line 5610 "parse.y"
                    {
                        (yyval.node) = new_array_pattern(p, 0, 0, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, *$:p_args[0..2]) %*/
                    }
#line 15686 "parse.c"
    break;

  case 535: /* p_expr_basic: "[" p_find rbracket  */
#line 5615 "parse.y"
                    {
                        (yyval.node) = new_find_pattern(p, 0, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: fndptn!(Qnil, *$:p_find[0..2]) %*/
                    }
#line 15695 "parse.c"
    break;

  case 536: /* p_expr_basic: "[" rbracket  */
#line 5620 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 0, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, 0, 0, (yyval.node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 15705 "parse.c"
    break;

  case 537: /* $@30: %empty  */
#line 5626 "parse.y"
                    {
                        p->ctxt.in_kwarg = 0;
                    }
#line 15713 "parse.c"
    break;

  case 538: /* p_expr_basic: "{" p_pktbl lex_ctxt $@30 p_kwargs rbrace  */
#line 5630 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-4].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-3].ctxt).in_kwarg;
                        (yyval.node) = new_hash_pattern(p, 0, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: hshptn!(Qnil, *$:p_kwargs[0..1]) %*/
                    }
#line 15724 "parse.c"
    break;

  case 539: /* p_expr_basic: "{" rbrace  */
#line 5637 "parse.y"
                    {
                        (yyval.node) = new_hash_pattern_tail(p, 0, 0, &(yyloc));
                        (yyval.node) = new_hash_pattern(p, 0, (yyval.node), &(yyloc));
                    /*% ripper: hshptn!(Qnil, Qnil, Qnil) %*/
                    }
#line 15734 "parse.c"
    break;

  case 540: /* p_expr_basic: "(" p_pktbl p_expr rparen  */
#line 5643 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: $:p_expr %*/
                    }
#line 15744 "parse.c"
    break;

  case 541: /* p_args: p_expr  */
#line 5651 "parse.y"
                    {
                        NODE *pre_args = NEW_LIST((yyvsp[0].node), &(yyloc));
                        (yyval.node) = new_array_pattern_tail(p, pre_args, 0, 0, 0, &(yyloc));
                    /*% ripper: [[$:1], Qnil, Qnil] %*/
                    }
#line 15754 "parse.c"
    break;

  case 542: /* p_args: p_args_head  */
#line 5657 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, (yyvsp[0].node), 1, 0, 0, &(yyloc));
                    /*% ripper: [$:1, Qnil, Qnil] %*/
                    }
#line 15763 "parse.c"
    break;

  case 543: /* p_args: p_args_head p_arg  */
#line 5662 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, list_concat((yyvsp[-1].node), (yyvsp[0].node)), 0, 0, 0, &(yyloc));
                    /*% ripper: [rb_ary_concat($:1, $:2), Qnil, Qnil] %*/
                    }
#line 15772 "parse.c"
    break;

  case 544: /* p_args: p_args_head p_rest  */
#line 5667 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, (yyvsp[-1].node), 1, (yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: [$:1, $:2, Qnil] %*/
                    }
#line 15781 "parse.c"
    break;

  case 545: /* p_args: p_args_head p_rest ',' p_args_post  */
#line 5672 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, (yyvsp[-3].node), 1, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: [$:1, $:2, $:4] %*/
                    }
#line 15790 "parse.c"
    break;

  case 547: /* p_args_head: p_arg ','  */
#line 5680 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    }
#line 15798 "parse.c"
    break;

  case 548: /* p_args_head: p_args_head p_arg ','  */
#line 5684 "parse.y"
                    {
                        (yyval.node) = list_concat((yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: rb_ary_concat($:1, $:2) %*/
                    }
#line 15807 "parse.c"
    break;

  case 549: /* p_args_tail: p_rest  */
#line 5691 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 1, (yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: [Qnil, $:1, Qnil] %*/
                    }
#line 15816 "parse.c"
    break;

  case 550: /* p_args_tail: p_rest ',' p_args_post  */
#line 5696 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 1, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: [Qnil, $:1, $:3] %*/
                    }
#line 15825 "parse.c"
    break;

  case 551: /* p_find: p_rest ',' p_args_post ',' p_rest  */
#line 5703 "parse.y"
                    {
                        (yyval.node) = new_find_pattern_tail(p, (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: [$:1, $:3, $:5] %*/
                    }
#line 15834 "parse.c"
    break;

  case 552: /* p_rest: "*" "local variable or method"  */
#line 5711 "parse.y"
                    {
                        error_duplicate_pattern_variable(p, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: var_field!($:2) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 15844 "parse.c"
    break;

  case 553: /* p_rest: "*"  */
#line 5717 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: var_field!(Qnil) %*/
                    }
#line 15853 "parse.c"
    break;

  case 555: /* p_args_post: p_args_post ',' p_arg  */
#line 5725 "parse.y"
                    {
                        (yyval.node) = list_concat((yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: rb_ary_concat($:1, $:3) %*/
                    }
#line 15862 "parse.c"
    break;

  case 556: /* p_arg: p_expr  */
#line 5732 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: [$:1] %*/
                    }
#line 15871 "parse.c"
    break;

  case 557: /* p_kwargs: p_kwarg ',' p_any_kwrest  */
#line 5739 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_unique_key_hash(p, (yyvsp[-2].node), &(yyloc)), (yyvsp[0].id), &(yyloc));
                    /*% ripper: [$:1, $:3] %*/
                    }
#line 15880 "parse.c"
    break;

  case 558: /* p_kwargs: p_kwarg  */
#line 5744 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_unique_key_hash(p, (yyvsp[0].node), &(yyloc)), 0, &(yyloc));
                    /*% ripper: [$:1, Qnil] %*/
                    }
#line 15889 "parse.c"
    break;

  case 559: /* p_kwargs: p_kwarg ','  */
#line 5749 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_unique_key_hash(p, (yyvsp[-1].node), &(yyloc)), 0, &(yyloc));
                    /*% ripper: [$:1, Qnil] %*/
                    }
#line 15898 "parse.c"
    break;

  case 560: /* p_kwargs: p_any_kwrest  */
#line 5754 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_hash(p, 0, &(yyloc)), (yyvsp[0].id), &(yyloc));
                    /*% ripper: [[], $:1] %*/
                    }
#line 15907 "parse.c"
    break;

  case 562: /* p_kwarg: p_kwarg ',' p_kw  */
#line 5763 "parse.y"
                    {
                        (yyval.node) = list_concat((yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 15916 "parse.c"
    break;

  case 563: /* p_kw: p_kw_label p_expr  */
#line 5770 "parse.y"
                    {
                        error_duplicate_pattern_key(p, (yyvsp[-1].id), &(yylsp[-1]));
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[-1].id)), &(yylsp[-1])), &(yyloc)), (yyvsp[0].node));
                    /*% ripper: [$:1, $:2] %*/
                    }
#line 15926 "parse.c"
    break;

  case 564: /* p_kw: p_kw_label  */
#line 5776 "parse.y"
                    {
                        error_duplicate_pattern_key(p, (yyvsp[0].id), &(yylsp[0]));
                        if ((yyvsp[0].id) && !is_local_id((yyvsp[0].id))) {
                            yyerror1(&(yylsp[0]), "key must be valid as local variables");
                        }
                        error_duplicate_pattern_variable(p, (yyvsp[0].id), &(yylsp[0]));
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[0].id)), &(yyloc)), &(yyloc)), assignable(p, (yyvsp[0].id), 0, &(yyloc)));
                    /*% ripper: [$:1, Qnil] %*/
                    }
#line 15940 "parse.c"
    break;

  case 566: /* p_kw_label: "string literal" string_contents tLABEL_END  */
#line 5789 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        if (!(yyvsp[-1].node) || nd_type_p((yyvsp[-1].node), NODE_STR)) {
                            NODE *node = dsym_node(p, (yyvsp[-1].node), &loc);
                            (yyval.id) = rb_sym2id(rb_node_sym_string_val(node));
                        }
                        else {
                            yyerror1(&loc, "symbol literal with interpolation is not allowed");
                            (yyval.id) = rb_intern_str(STR_NEW0());
                        }
                    /*% ripper: $:2 %*/
                    }
#line 15957 "parse.c"
    break;

  case 567: /* p_kwrest: kwrest_mark "local variable or method"  */
#line 5804 "parse.y"
                    {
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: var_field!($:2) %*/
                    }
#line 15966 "parse.c"
    break;

  case 568: /* p_kwrest: kwrest_mark  */
#line 5809 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: Qnil %*/
                    }
#line 15975 "parse.c"
    break;

  case 569: /* p_kwnorest: kwrest_mark "'nil'"  */
#line 5816 "parse.y"
                    {
                        (yyval.id) = 0;
                    }
#line 15983 "parse.c"
    break;

  case 571: /* p_any_kwrest: p_kwnorest  */
#line 5823 "parse.y"
                    {
                        (yyval.id) = idNil;
                    /*% ripper: var_field!(ID2VAL(idNil)) %*/
                    }
#line 15992 "parse.c"
    break;

  case 573: /* p_value: p_primitive ".." p_primitive  */
#line 5831 "parse.y"
                    {
                        value_expr((yyvsp[-2].node));
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot2!($:1, $:3) %*/
                    }
#line 16003 "parse.c"
    break;

  case 574: /* p_value: p_primitive "..." p_primitive  */
#line 5838 "parse.y"
                    {
                        value_expr((yyvsp[-2].node));
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot3!($:1, $:3) %*/
                    }
#line 16014 "parse.c"
    break;

  case 575: /* p_value: p_primitive ".."  */
#line 5845 "parse.y"
                    {
                        value_expr((yyvsp[-1].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc));
                    /*% ripper: dot2!($:1, Qnil) %*/
                    }
#line 16024 "parse.c"
    break;

  case 576: /* p_value: p_primitive "..."  */
#line 5851 "parse.y"
                    {
                        value_expr((yyvsp[-1].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc));
                    /*% ripper: dot3!($:1, Qnil) %*/
                    }
#line 16034 "parse.c"
    break;

  case 580: /* p_value: "(.." p_primitive  */
#line 5860 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT2(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot2!(Qnil, $:2) %*/
                    }
#line 16044 "parse.c"
    break;

  case 581: /* p_value: "(..." p_primitive  */
#line 5866 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = NEW_DOT3(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc));
                    /*% ripper: dot3!(Qnil, $:2) %*/
                    }
#line 16054 "parse.c"
    break;

  case 590: /* p_primitive: keyword_variable  */
#line 5875 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                    }
#line 16063 "parse.c"
    break;

  case 592: /* p_variable: "local variable or method"  */
#line 5883 "parse.y"
                    {
                        error_duplicate_pattern_variable(p, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 16073 "parse.c"
    break;

  case 593: /* p_var_ref: '^' "local variable or method"  */
#line 5891 "parse.y"
                    {
                        NODE *n = gettable(p, (yyvsp[0].id), &(yyloc));
                        if (!n) {
                            n = NEW_ERROR(&(yyloc));
                        }
                        else if (!(nd_type_p(n, NODE_LVAR) || nd_type_p(n, NODE_DVAR))) {
                            compile_error(p, "%"PRIsVALUE": no such local variable", rb_id2str((yyvsp[0].id)));
                        }
                        (yyval.node) = n;
                    /*% ripper: var_ref!($:2) %*/
                    }
#line 16089 "parse.c"
    break;

  case 594: /* p_var_ref: '^' nonlocal_var  */
#line 5903 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:2) %*/
                    }
#line 16098 "parse.c"
    break;

  case 595: /* p_expr_ref: '^' "(" expr_value rparen  */
#line 5910 "parse.y"
                    {
                        (yyval.node) = NEW_BLOCK((yyvsp[-1].node), &(yyloc));
                    /*% ripper: begin!($:3) %*/
                    }
#line 16107 "parse.c"
    break;

  case 596: /* p_const: ":: at EXPR_BEG" cname  */
#line 5917 "parse.y"
                    {
                        (yyval.node) = NEW_COLON3((yyvsp[0].id), &(yyloc));
                    /*% ripper: top_const_ref!($:2) %*/
                    }
#line 16116 "parse.c"
    break;

  case 597: /* p_const: p_const "::" cname  */
#line 5922 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc));
                    /*% ripper: const_path_ref!($:1, $:3) %*/
                    }
#line 16125 "parse.c"
    break;

  case 598: /* p_const: "constant"  */
#line 5927 "parse.y"
                   {
                        (yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                   }
#line 16134 "parse.c"
    break;

  case 599: /* opt_rescue: k_rescue exc_list exc_var then compstmt opt_rescue  */
#line 5936 "parse.y"
                    {
                        NODE *err = (yyvsp[-3].node);
                        if ((yyvsp[-3].node)) {
                            err = NEW_ERRINFO(&(yylsp[-3]));
                            err = node_assign(p, (yyvsp[-3].node), err, NO_LEX_CTXT, &(yylsp[-3]));
                        }
                        (yyval.node) = NEW_RESBODY((yyvsp[-4].node), (yyvsp[-3].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                        if ((yyvsp[-4].node)) {
                            fixpos((yyval.node), (yyvsp[-4].node));
                        }
                        else if ((yyvsp[-3].node)) {
                            fixpos((yyval.node), (yyvsp[-3].node));
                        }
                        else {
                            fixpos((yyval.node), (yyvsp[-1].node));
                        }
                    /*% ripper: rescue!($:2, $:3, $:5, $:6) %*/
                    }
#line 16157 "parse.c"
    break;

  case 601: /* exc_list: arg_value  */
#line 5958 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 16166 "parse.c"
    break;

  case 602: /* exc_list: mrhs  */
#line 5963 "parse.y"
                    {
                        if (!((yyval.node) = splat_array((yyvsp[0].node)))) (yyval.node) = (yyvsp[0].node);
                    }
#line 16174 "parse.c"
    break;

  case 604: /* exc_var: "=>" lhs  */
#line 5970 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: $:2 %*/
                    }
#line 16183 "parse.c"
    break;

  case 606: /* opt_ensure: k_ensure stmts option_terms  */
#line 5978 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-2].ctxt).in_rescue;
                        (yyval.node) = (yyvsp[-1].node);
                        void_expr(p, void_stmts(p, (yyval.node)));
                    /*% ripper: ensure!($:2) %*/
                    }
#line 16194 "parse.c"
    break;

  case 610: /* strings: string  */
#line 5992 "parse.y"
                    {
                        NODE *node = (yyvsp[0].node);
                        if (!node) {
                            node = NEW_STR(STRING_NEW0(), &(yyloc));
                        }
                        else {
                            node = evstr2dstr(p, node);
                        }
                        (yyval.node) = node;
                    /*% ripper: $:1 %*/
                    }
#line 16210 "parse.c"
    break;

  case 613: /* string: string string1  */
#line 6008 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: string_concat!($:1, $:2) %*/
                    }
#line 16219 "parse.c"
    break;

  case 614: /* string1: "string literal" string_contents "terminator"  */
#line 6015 "parse.y"
                    {
                        (yyval.node) = heredoc_dedent(p, (yyvsp[-1].node));
                        if ((yyval.node)) nd_set_loc((yyval.node), &(yyloc));
                    /*% ripper: $:2 %*/
                        if (p->heredoc_indent > 0) {
                        /*% ripper: heredoc_dedent!($:$, INT2NUM(%{p->heredoc_indent})) %*/
                            p->heredoc_indent = 0;
                        }
                    /*% ripper: string_literal!($:$) %*/
                    }
#line 16234 "parse.c"
    break;

  case 615: /* xstring: "backtick literal" xstring_contents "terminator"  */
#line 6028 "parse.y"
                    {
                        (yyval.node) = new_xstring(p, heredoc_dedent(p, (yyvsp[-1].node)), &(yyloc));
                    /*% ripper: $:2 %*/
                        if (p->heredoc_indent > 0) {
                        /*% ripper: heredoc_dedent!($:$, INT2NUM(%{p->heredoc_indent})) %*/
                            p->heredoc_indent = 0;
                        }
                    /*% ripper: xstring_literal!($:$) %*/
                    }
#line 16248 "parse.c"
    break;

  case 616: /* regexp: "regexp literal" regexp_contents tREGEXP_END  */
#line 6040 "parse.y"
                    {
                        (yyval.node) = new_regexp(p, (yyvsp[-1].node), (yyvsp[0].num), &(yyloc));
                    /*% ripper: regexp_literal!($:2, $:3) %*/
                    }
#line 16257 "parse.c"
    break;

  case 619: /* words_tWORDS_BEG_word_list: "word list" nonempty_list_' ' word_list "terminator"  */
#line 2961 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16266 "parse.c"
    break;

  case 621: /* word_list: %empty  */
#line 6050 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: words_new! %*/
                    }
#line 16275 "parse.c"
    break;

  case 622: /* word_list: word_list word nonempty_list_' '  */
#line 6055 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), evstr2dstr(p, (yyvsp[-1].node)));
                    /*% ripper: words_add!($:1, $:2) %*/
                    }
#line 16284 "parse.c"
    break;

  case 624: /* word: word string_content  */
#line 6064 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: word_add!($:1, $:2) %*/
                    }
#line 16293 "parse.c"
    break;

  case 625: /* words_tSYMBOLS_BEG_symbol_list: "symbol list" nonempty_list_' ' symbol_list "terminator"  */
#line 2961 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16302 "parse.c"
    break;

  case 627: /* symbol_list: %empty  */
#line 6074 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: symbols_new! %*/
                    }
#line 16311 "parse.c"
    break;

  case 628: /* symbol_list: symbol_list word nonempty_list_' '  */
#line 6079 "parse.y"
                    {
                        (yyval.node) = symbol_append(p, (yyvsp[-2].node), evstr2dstr(p, (yyvsp[-1].node)));
                    /*% ripper: symbols_add!($:1, $:2) %*/
                    }
#line 16320 "parse.c"
    break;

  case 629: /* words_tQWORDS_BEG_qword_list: "verbatim word list" nonempty_list_' ' qword_list "terminator"  */
#line 2961 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16329 "parse.c"
    break;

  case 631: /* words_tQSYMBOLS_BEG_qsym_list: "verbatim symbol list" nonempty_list_' ' qsym_list "terminator"  */
#line 2961 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16338 "parse.c"
    break;

  case 633: /* qword_list: %empty  */
#line 6092 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: qwords_new! %*/
                    }
#line 16347 "parse.c"
    break;

  case 634: /* qword_list: qword_list "literal content" nonempty_list_' '  */
#line 6097 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: qwords_add!($:1, $:2) %*/
                    }
#line 16356 "parse.c"
    break;

  case 635: /* qsym_list: %empty  */
#line 6104 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: qsymbols_new! %*/
                    }
#line 16365 "parse.c"
    break;

  case 636: /* qsym_list: qsym_list "literal content" nonempty_list_' '  */
#line 6109 "parse.y"
                    {
                        (yyval.node) = symbol_append(p, (yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: qsymbols_add!($:1, $:2) %*/
                    }
#line 16374 "parse.c"
    break;

  case 637: /* string_contents: %empty  */
#line 6116 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: string_content! %*/
                    }
#line 16383 "parse.c"
    break;

  case 638: /* string_contents: string_contents string_content  */
#line 6121 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: string_add!($:1, $:2) %*/
                    }
#line 16392 "parse.c"
    break;

  case 639: /* xstring_contents: %empty  */
#line 6128 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: xstring_new! %*/
                    }
#line 16401 "parse.c"
    break;

  case 640: /* xstring_contents: xstring_contents string_content  */
#line 6133 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: xstring_add!($:1, $:2) %*/
                    }
#line 16410 "parse.c"
    break;

  case 641: /* regexp_contents: %empty  */
#line 6140 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: regexp_new! %*/
                    }
#line 16419 "parse.c"
    break;

  case 642: /* regexp_contents: regexp_contents string_content  */
#line 6145 "parse.y"
                    {
                        NODE *head = (yyvsp[-1].node), *tail = (yyvsp[0].node);
                        if (!head) {
                            (yyval.node) = tail;
                        }
                        else if (!tail) {
                            (yyval.node) = head;
                        }
                        else {
                            switch (nd_type(head)) {
                              case NODE_STR:
                                head = str2dstr(p, head);
                                break;
                              case NODE_DSTR:
                                break;
                              default:
                                head = list_append(p, NEW_DSTR(0, &(yyloc)), head);
                                break;
                            }
                            (yyval.node) = list_append(p, head, tail);
                        }
                    /*% ripper: regexp_add!($:1, $:2) %*/
                    }
#line 16447 "parse.c"
    break;

  case 644: /* @31: %empty  */
#line 6173 "parse.y"
                    {
                        /* need to backup p->lex.strterm so that a string literal `%&foo,#$&,bar&` can be parsed */
                        (yyval.strterm) = p->lex.strterm;
                        p->lex.strterm = 0;
                        SET_LEX_STATE(EXPR_BEG);
                    }
#line 16458 "parse.c"
    break;

  case 645: /* string_content: tSTRING_DVAR @31 string_dvar  */
#line 6180 "parse.y"
                    {
                        p->lex.strterm = (yyvsp[-1].strterm);
                        (yyval.node) = NEW_EVSTR((yyvsp[0].node), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[0]).end_pos.lineno);
                    /*% ripper: string_dvar!($:3) %*/
                    }
#line 16469 "parse.c"
    break;

  case 646: /* @32: %empty  */
#line 6187 "parse.y"
                    {
                        CMDARG_PUSH(0);
                        COND_PUSH(0);
                        /* need to backup p->lex.strterm so that a string literal `%!foo,#{ !0 },bar!` can be parsed */
                        (yyval.strterm) = p->lex.strterm;
                        p->lex.strterm = 0;
                        SET_LEX_STATE(EXPR_BEG);
                    }
#line 16482 "parse.c"
    break;

  case 647: /* @33: %empty  */
#line 6195 "parse.y"
                    {
                        (yyval.num) = p->lex.brace_nest;
                        p->lex.brace_nest = 0;
                    }
#line 16491 "parse.c"
    break;

  case 648: /* @34: %empty  */
#line 6199 "parse.y"
                    {
                        (yyval.num) = p->heredoc_indent;
                        p->heredoc_indent = 0;
                    }
#line 16500 "parse.c"
    break;

  case 649: /* string_content: "'#{'" @32 @33 @34 compstmt string_dend  */
#line 6204 "parse.y"
                    {
                        COND_POP();
                        CMDARG_POP();
                        p->lex.strterm = (yyvsp[-4].strterm);
                        SET_LEX_STATE((yyvsp[-5].state));
                        p->lex.brace_nest = (yyvsp[-3].num);
                        p->heredoc_indent = (yyvsp[-2].num);
                        p->heredoc_line_indent = -1;
                        if ((yyvsp[-1].node)) nd_unset_fl_newline((yyvsp[-1].node));
                        (yyval.node) = new_evstr(p, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: string_embexpr!($:compstmt) %*/
                    }
#line 16517 "parse.c"
    break;

  case 652: /* string_dvar: nonlocal_var  */
#line 6223 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                    }
#line 16526 "parse.c"
    break;

  case 656: /* ssym: "symbol literal" sym  */
#line 6235 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_END);
                        VALUE str = rb_id2str((yyvsp[0].id));
                        /*
                         * TODO:
                         *   set_yylval_noname sets invalid id to yylval.
                         *   This branch can be removed once yylval is changed to
                         *   hold lexed string.
                         */
                        if (!str) str = STR_NEW0();
                        (yyval.node) = NEW_SYM(str, &(yyloc));
                    /*% ripper: symbol_literal!(symbol!($:2)) %*/
                    }
#line 16544 "parse.c"
    break;

  case 659: /* dsym: "symbol literal" string_contents "terminator"  */
#line 6255 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_END);
                        (yyval.node) = dsym_node(p, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: dyna_symbol!($:2) %*/
                    }
#line 16554 "parse.c"
    break;

  case 661: /* numeric: tUMINUS_NUM simple_numeric  */
#line 6264 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                        negate_lit(p, (yyval.node));
                    /*% ripper: unary!(ID2VAL(idUMinus), $:2) %*/
                    }
#line 16564 "parse.c"
    break;

  case 672: /* keyword_variable: "'nil'"  */
#line 6286 "parse.y"
                              {(yyval.id) = KWD2EID(nil, (yyvsp[0].id));}
#line 16570 "parse.c"
    break;

  case 673: /* keyword_variable: "'self'"  */
#line 6287 "parse.y"
                               {(yyval.id) = KWD2EID(self, (yyvsp[0].id));}
#line 16576 "parse.c"
    break;

  case 674: /* keyword_variable: "'true'"  */
#line 6288 "parse.y"
                               {(yyval.id) = KWD2EID(true, (yyvsp[0].id));}
#line 16582 "parse.c"
    break;

  case 675: /* keyword_variable: "'false'"  */
#line 6289 "parse.y"
                                {(yyval.id) = KWD2EID(false, (yyvsp[0].id));}
#line 16588 "parse.c"
    break;

  case 676: /* keyword_variable: "'__FILE__'"  */
#line 6290 "parse.y"
                                  {(yyval.id) = KWD2EID(_FILE__, (yyvsp[0].id));}
#line 16594 "parse.c"
    break;

  case 677: /* keyword_variable: "'__LINE__'"  */
#line 6291 "parse.y"
                                  {(yyval.id) = KWD2EID(_LINE__, (yyvsp[0].id));}
#line 16600 "parse.c"
    break;

  case 678: /* keyword_variable: "'__ENCODING__'"  */
#line 6292 "parse.y"
                                      {(yyval.id) = KWD2EID(_ENCODING__, (yyvsp[0].id));}
#line 16606 "parse.c"
    break;

  case 679: /* var_ref: user_variable  */
#line 6296 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                        if (ifdef_ripper(id_is_var(p, (yyvsp[0].id)), false)) {
                        /*% ripper: var_ref!($:1) %*/
                        }
                        else {
                        /*% ripper: vcall!($:1) %*/
                        }
                    }
#line 16620 "parse.c"
    break;

  case 680: /* var_ref: keyword_variable  */
#line 6306 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                    }
#line 16629 "parse.c"
    break;

  case 681: /* var_lhs: user_variable  */
#line 6313 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 16638 "parse.c"
    break;

  case 682: /* var_lhs: keyword_variable  */
#line 6313 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 16647 "parse.c"
    break;

  case 685: /* $@35: %empty  */
#line 6324 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_BEG);
                        p->command_start = TRUE;
                    }
#line 16656 "parse.c"
    break;

  case 686: /* superclass: '<' $@35 expr_value term  */
#line 6329 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: $:3 %*/
                    }
#line 16665 "parse.c"
    break;

  case 687: /* superclass: %empty  */
#line 6334 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: Qnil %*/
                    }
#line 16674 "parse.c"
    break;

  case 689: /* f_opt_paren_args: none  */
#line 6342 "parse.y"
                    {
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[-1]));
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyval.node_args), &(yylsp[-1]));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 16685 "parse.c"
    break;

  case 690: /* f_paren_args: '(' f_args rparen  */
#line 6351 "parse.y"
                    {
                        (yyval.node_args) = (yyvsp[-1].node_args);
                    /*% ripper: paren!($:2) %*/
                        SET_LEX_STATE(EXPR_BEG);
                        p->command_start = TRUE;
                        p->ctxt.in_argdef = 0;
                    }
#line 16697 "parse.c"
    break;

  case 692: /* @36: %empty  */
#line 6361 "parse.y"
                    {
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_kwarg = 1;
                        p->ctxt.in_argdef = 1;
                        SET_LEX_STATE(p->lex.state|EXPR_LABEL); /* force for args */
                    }
#line 16708 "parse.c"
    break;

  case 693: /* f_arglist: @36 f_args term  */
#line 6368 "parse.y"
                    {
                        p->ctxt.in_kwarg = (yyvsp[-2].ctxt).in_kwarg;
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = (yyvsp[-1].node_args);
                        SET_LEX_STATE(EXPR_BEG);
                        p->command_start = TRUE;
                    /*% ripper: $:2 %*/
                    }
#line 16721 "parse.c"
    break;

  case 694: /* f_kwarg_f_kw: f_kw  */
#line 2935 "parse.y"
                    {
                        (yyval.node_kw_arg) = (yyvsp[0].node_kw_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 16730 "parse.c"
    break;

  case 695: /* f_kwarg_f_kw: f_kwarg_f_kw ',' f_kw  */
#line 2940 "parse.y"
                    {
                        (yyval.node_kw_arg) = kwd_append((yyvsp[-2].node_kw_arg), (yyvsp[0].node_kw_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 16739 "parse.c"
    break;

  case 696: /* args_tail: f_kwarg_f_kw ',' f_kwrest opt_f_block_arg  */
#line 6379 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-3].node_kw_arg), (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, $:3, $:4] %*/
                    }
#line 16748 "parse.c"
    break;

  case 697: /* args_tail: f_kwarg_f_kw opt_f_block_arg  */
#line 6384 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-1].node_kw_arg), 0, (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, Qnil, $:2] %*/
                    }
#line 16757 "parse.c"
    break;

  case 698: /* args_tail: f_any_kwrest opt_f_block_arg  */
#line 6389 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [Qnil, $:1, $:2] %*/
                    }
#line 16766 "parse.c"
    break;

  case 699: /* args_tail: f_block_arg  */
#line 6394 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, $:1] %*/
                    }
#line 16775 "parse.c"
    break;

  case 700: /* args_tail: args_forward  */
#line 6399 "parse.y"
                    {
                        ID fwd = (yyvsp[0].id);
                        if (lambda_beginning_p() ||
                            (p->lex.lpar_beg >= 0 && p->lex.lpar_beg+1 == p->lex.paren_nest)) {
                            yyerror0("unexpected ... in lambda argument");
                            fwd = 0;
                        }
                        else {
                            add_forwarding_args(p);
                        }
                        (yyval.node_args) = new_args_tail(p, 0, fwd, arg_FWD_BLOCK, &(yylsp[0]));
                        (yyval.node_args)->nd_ainfo.forwarding = 1;
                    /*% ripper: [Qnil, $:1, Qnil] %*/
                    }
#line 16794 "parse.c"
    break;

  case 701: /* f_opt_arg_value: f_arg_asgn f_eq arg_value  */
#line 2913 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_opt_arg) = NEW_OPT_ARG(assignable(p, (yyvsp[-2].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:3] %*/
                    }
#line 16804 "parse.c"
    break;

  case 702: /* f_optarg_arg_value: f_opt_arg_value  */
#line 2922 "parse.y"
                    {
                        (yyval.node_opt_arg) = (yyvsp[0].node_opt_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 16813 "parse.c"
    break;

  case 703: /* f_optarg_arg_value: f_optarg_arg_value ',' f_opt_arg_value  */
#line 2927 "parse.y"
                    {
                        (yyval.node_opt_arg) = opt_arg_append((yyvsp[-2].node_opt_arg), (yyvsp[0].node_opt_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 16822 "parse.c"
    break;

  case 704: /* opt_args_tail_args_tail: ',' args_tail  */
#line 2948 "parse.y"
                    {
                        (yyval.node_args) = (yyvsp[0].node_args);
                    /*% ripper: $:2 %*/
                    }
#line 16831 "parse.c"
    break;

  case 705: /* opt_args_tail_args_tail: %empty  */
#line 2953 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, Qnil] %*/
                    }
#line 16840 "parse.c"
    break;

  case 706: /* f_args: f_arg ',' f_optarg_arg_value ',' f_rest_arg opt_args_tail_args_tail  */
#line 6416 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, Qnil, *$:6[0..2]) %*/
                    }
#line 16849 "parse.c"
    break;

  case 707: /* f_args: f_arg ',' f_optarg_arg_value ',' f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6421 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-7].node_args_aux), (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, $:7, *$:8[0..2]) %*/
                    }
#line 16858 "parse.c"
    break;

  case 708: /* f_args: f_arg ',' f_optarg_arg_value opt_args_tail_args_tail  */
#line 6426 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, Qnil, *$:4[0..2]) %*/
                    }
#line 16867 "parse.c"
    break;

  case 709: /* f_args: f_arg ',' f_optarg_arg_value ',' f_arg opt_args_tail_args_tail  */
#line 6431 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, $:5, *$:6[0..2]) %*/
                    }
#line 16876 "parse.c"
    break;

  case 710: /* f_args: f_arg ',' f_rest_arg opt_args_tail_args_tail  */
#line 6436 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 16885 "parse.c"
    break;

  case 711: /* f_args: f_arg ',' f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6441 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 16894 "parse.c"
    break;

  case 712: /* f_args: f_arg opt_args_tail_args_tail  */
#line 6446 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-1].node_args_aux), 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 16903 "parse.c"
    break;

  case 713: /* f_args: f_optarg_arg_value ',' f_rest_arg opt_args_tail_args_tail  */
#line 6451 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 16912 "parse.c"
    break;

  case 714: /* f_args: f_optarg_arg_value ',' f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6456 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 16921 "parse.c"
    break;

  case 715: /* f_args: f_optarg_arg_value opt_args_tail_args_tail  */
#line 6461 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 16930 "parse.c"
    break;

  case 716: /* f_args: f_optarg_arg_value ',' f_arg opt_args_tail_args_tail  */
#line 6466 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, $:3, *$:4[0..2]) %*/
                    }
#line 16939 "parse.c"
    break;

  case 717: /* f_args: f_rest_arg opt_args_tail_args_tail  */
#line 6471 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, Qnil, *$:2[0..2]) %*/
                    }
#line 16948 "parse.c"
    break;

  case 718: /* f_args: f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6476 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, $:3, *$:4[0..2]) %*/
                    }
#line 16957 "parse.c"
    break;

  case 719: /* f_args: args_tail  */
#line 6481 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, *$:1[0..2]) %*/
                    }
#line 16966 "parse.c"
    break;

  case 720: /* f_args: %empty  */
#line 6486 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyval.node_args), &(yylsp[0]));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 16976 "parse.c"
    break;

  case 721: /* args_forward: "(..."  */
#line 6494 "parse.y"
                    {
#ifdef FORWARD_ARGS_WITH_RUBY2_KEYWORDS
                        (yyval.id) = 0;
#else
                        (yyval.id) = idFWD_KWREST;
#endif
                    /*% ripper: args_forward! %*/
                    }
#line 16989 "parse.c"
    break;

  case 722: /* f_bad_arg: "constant"  */
#line 6505 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be a constant";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17002 "parse.c"
    break;

  case 723: /* f_bad_arg: "instance variable"  */
#line 6514 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be an instance variable";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17015 "parse.c"
    break;

  case 724: /* f_bad_arg: "global variable"  */
#line 6523 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be a global variable";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17028 "parse.c"
    break;

  case 725: /* f_bad_arg: "class variable"  */
#line 6532 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be a class variable";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17041 "parse.c"
    break;

  case 727: /* f_norm_arg: "local variable or method"  */
#line 6544 "parse.y"
                    {
                        VALUE e = formal_argument_error(p, (yyval.id) = (yyvsp[0].id));
                        if (e) {
                            /*% ripper[error]: param_error!(?e, $:1) %*/
                        }
                        p->max_numparam = ORDINAL_PARAM;
                    }
#line 17053 "parse.c"
    break;

  case 728: /* f_arg_asgn: f_norm_arg  */
#line 6554 "parse.y"
                    {
                        ID id = (yyvsp[0].id);
                        arg_var(p, id);
                        (yyval.id) = (yyvsp[0].id);
                    }
#line 17063 "parse.c"
    break;

  case 729: /* f_arg_item: f_arg_asgn  */
#line 6562 "parse.y"
                    {
                        (yyval.node_args_aux) = NEW_ARGS_AUX((yyvsp[0].id), 1, &NULL_LOC);
                    /*% ripper: $:1 %*/
                    }
#line 17072 "parse.c"
    break;

  case 730: /* f_arg_item: "(" f_margs rparen  */
#line 6567 "parse.y"
                    {
                        ID tid = internal_id(p);
                        YYLTYPE loc;
                        loc.beg_pos = (yylsp[-1]).beg_pos;
                        loc.end_pos = (yylsp[-1]).beg_pos;
                        arg_var(p, tid);
                        if (dyna_in_block(p)) {
                            (yyvsp[-1].node_masgn)->nd_value = NEW_DVAR(tid, &loc);
                        }
                        else {
                            (yyvsp[-1].node_masgn)->nd_value = NEW_LVAR(tid, &loc);
                        }
                        (yyval.node_args_aux) = NEW_ARGS_AUX(tid, 1, &NULL_LOC);
                        (yyval.node_args_aux)->nd_next = (NODE *)(yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 17093 "parse.c"
    break;

  case 732: /* f_arg: f_arg ',' f_arg_item  */
#line 6588 "parse.y"
                    {
                        (yyval.node_args_aux) = (yyvsp[-2].node_args_aux);
                        (yyval.node_args_aux)->nd_plen++;
                        (yyval.node_args_aux)->nd_next = block_append(p, (yyval.node_args_aux)->nd_next, (yyvsp[0].node_args_aux)->nd_next);
                        rb_discard_node(p, (NODE *)(yyvsp[0].node_args_aux));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 17105 "parse.c"
    break;

  case 733: /* f_label: "label"  */
#line 6599 "parse.y"
                    {
                        VALUE e = formal_argument_error(p, (yyval.id) = (yyvsp[0].id));
                        if (e) {
                            (yyval.id) = 0;
                            /*% ripper[error]: param_error!(?e, $:1) %*/
                        }
                        /*
                         * Workaround for Prism::ParseTest#test_filepath for
                         * "unparser/corpus/literal/def.txt"
                         *
                         * See the discussion on https://github.com/ruby/ruby/pull/9923
                         */
                        arg_var(p, ifdef_ripper(0, (yyvsp[0].id)));
                        /*% ripper: $:1 %*/
                        p->max_numparam = ORDINAL_PARAM;
                        p->ctxt.in_argdef = 0;
                    }
#line 17127 "parse.c"
    break;

  case 734: /* f_kw: f_label arg_value  */
#line 6619 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[-1].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:2] %*/
                    }
#line 17137 "parse.c"
    break;

  case 735: /* f_kw: f_label  */
#line 6625 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[0].id), NODE_SPECIAL_REQUIRED_KEYWORD, &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, 0] %*/
                    }
#line 17147 "parse.c"
    break;

  case 736: /* f_block_kw: f_label primary_value  */
#line 6633 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[-1].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:2] %*/
                    }
#line 17157 "parse.c"
    break;

  case 737: /* f_block_kw: f_label  */
#line 6639 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[0].id), NODE_SPECIAL_REQUIRED_KEYWORD, &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, 0] %*/
                    }
#line 17167 "parse.c"
    break;

  case 740: /* f_no_kwarg: p_kwnorest  */
#line 6651 "parse.y"
                    {
                    /*% ripper: nokw_param!(Qnil) %*/
                    }
#line 17175 "parse.c"
    break;

  case 741: /* f_kwrest: kwrest_mark "local variable or method"  */
#line 6657 "parse.y"
                    {
                        arg_var(p, shadowing_lvar(p, (yyvsp[0].id)));
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: kwrest_param!($:2) %*/
                    }
#line 17185 "parse.c"
    break;

  case 742: /* f_kwrest: kwrest_mark  */
#line 6663 "parse.y"
                    {
                        arg_var(p, idFWD_KWREST);
                        (yyval.id) = idFWD_KWREST;
                    /*% ripper: kwrest_param!(Qnil) %*/
                    }
#line 17195 "parse.c"
    break;

  case 745: /* f_rest_arg: restarg_mark "local variable or method"  */
#line 6675 "parse.y"
                    {
                        arg_var(p, shadowing_lvar(p, (yyvsp[0].id)));
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: rest_param!($:2) %*/
                    }
#line 17205 "parse.c"
    break;

  case 746: /* f_rest_arg: restarg_mark  */
#line 6681 "parse.y"
                    {
                        arg_var(p, idFWD_REST);
                        (yyval.id) = idFWD_REST;
                    /*% ripper: rest_param!(Qnil) %*/
                    }
#line 17215 "parse.c"
    break;

  case 749: /* f_block_arg: blkarg_mark "local variable or method"  */
#line 6693 "parse.y"
                    {
                        arg_var(p, shadowing_lvar(p, (yyvsp[0].id)));
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: blockarg!($:2) %*/
                    }
#line 17225 "parse.c"
    break;

  case 750: /* f_block_arg: blkarg_mark  */
#line 6699 "parse.y"
                    {
                        arg_var(p, idFWD_BLOCK);
                        (yyval.id) = idFWD_BLOCK;
                    /*% ripper: blockarg!(Qnil) %*/
                    }
#line 17235 "parse.c"
    break;

  case 751: /* opt_f_block_arg: ',' f_block_arg  */
#line 6707 "parse.y"
                    {
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: $:2 %*/
                    }
#line 17244 "parse.c"
    break;

  case 752: /* opt_f_block_arg: none  */
#line 6712 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: Qnil %*/
                    }
#line 17253 "parse.c"
    break;

  case 753: /* singleton: var_ref  */
#line 6719 "parse.y"
                    {
                        value_expr((yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 17262 "parse.c"
    break;

  case 754: /* $@37: %empty  */
#line 6724 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_BEG);
                        p->ctxt.in_argdef = 0;
                    }
#line 17271 "parse.c"
    break;

  case 755: /* singleton: '(' $@37 expr rparen  */
#line 6729 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        NODE *expr = last_expr_node((yyvsp[-1].node));
                        switch (nd_type(expr)) {
                          case NODE_STR:
                          case NODE_DSTR:
                          case NODE_XSTR:
                          case NODE_DXSTR:
                          case NODE_REGX:
                          case NODE_DREGX:
                          case NODE_SYM:
                          case NODE_LINE:
                          case NODE_FILE:
                          case NODE_ENCODING:
                          case NODE_INTEGER:
                          case NODE_FLOAT:
                          case NODE_RATIONAL:
                          case NODE_IMAGINARY:
                          case NODE_DSYM:
                          case NODE_LIST:
                          case NODE_ZLIST:
                            yyerror1(&expr->nd_loc, "can't define singleton method for literals");
                            break;
                          default:
                            value_expr((yyvsp[-1].node));
                            break;
                        }
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: paren!($:3) %*/
                    }
#line 17306 "parse.c"
    break;

  case 757: /* assoc_list: assocs trailer  */
#line 6763 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: assoclist_from_args!($:1) %*/
                    }
#line 17315 "parse.c"
    break;

  case 759: /* assocs: assocs ',' assoc  */
#line 6772 "parse.y"
                    {
                        NODE *assocs = (yyvsp[-2].node);
                        NODE *tail = (yyvsp[0].node);
                        if (!assocs) {
                            assocs = tail;
                        }
                        else if (tail) {
                            if (RNODE_LIST(assocs)->nd_head) {
                                NODE *n = RNODE_LIST(tail)->nd_next;
                                if (!RNODE_LIST(tail)->nd_head && nd_type_p(n, NODE_LIST) &&
                                    nd_type_p((n = RNODE_LIST(n)->nd_head), NODE_HASH)) {
                                    /* DSTAR */
                                    tail = RNODE_HASH(n)->nd_head;
                                }
                            }
                            if (tail) {
                                assocs = list_concat(assocs, tail);
                            }
                        }
                        (yyval.node) = assocs;
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 17342 "parse.c"
    break;

  case 760: /* assoc: arg_value "=>" arg_value  */
#line 6797 "parse.y"
                    {
                        (yyval.node) = list_append(p, NEW_LIST((yyvsp[-2].node), &(yyloc)), (yyvsp[0].node));
                    /*% ripper: assoc_new!($:1, $:3) %*/
                    }
#line 17351 "parse.c"
    break;

  case 761: /* assoc: "label" arg_value  */
#line 6802 "parse.y"
                    {
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[-1].id)), &(yylsp[-1])), &(yyloc)), (yyvsp[0].node));
                    /*% ripper: assoc_new!($:1, $:2) %*/
                    }
#line 17360 "parse.c"
    break;

  case 762: /* assoc: "label"  */
#line 6807 "parse.y"
                    {
                        NODE *val = gettable(p, (yyvsp[0].id), &(yyloc));
                        if (!val) val = NEW_ERROR(&(yyloc));
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[0].id)), &(yylsp[0])), &(yyloc)), val);
                    /*% ripper: assoc_new!($:1, Qnil) %*/
                    }
#line 17371 "parse.c"
    break;

  case 763: /* assoc: "string literal" string_contents tLABEL_END arg_value  */
#line 6814 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-3]), &(yylsp[-1]));
                        (yyval.node) = list_append(p, NEW_LIST(dsym_node(p, (yyvsp[-2].node), &loc), &loc), (yyvsp[0].node));
                    /*% ripper: assoc_new!(dyna_symbol!($:2), $:4) %*/
                    }
#line 17381 "parse.c"
    break;

  case 764: /* assoc: "**arg" arg_value  */
#line 6820 "parse.y"
                    {
                        (yyval.node) = list_append(p, NEW_LIST(0, &(yyloc)), (yyvsp[0].node));
                    /*% ripper: assoc_splat!($:2) %*/
                    }
#line 17390 "parse.c"
    break;

  case 765: /* assoc: "**arg"  */
#line 6825 "parse.y"
                    {
                        forwarding_arg_check(p, idFWD_KWREST, idFWD_ALL, "keyword rest");
                        (yyval.node) = list_append(p, NEW_LIST(0, &(yyloc)),
                                         NEW_LVAR(idFWD_KWREST, &(yyloc)));
                    /*% ripper: assoc_splat!(Qnil) %*/
                    }
#line 17401 "parse.c"
    break;

  case 785: /* term: ';'  */
#line 6871 "parse.y"
            {yyerrok;token_flush(p);}
#line 17407 "parse.c"
    break;

  case 786: /* term: '\n'  */
#line 6873 "parse.y"
                    {
                        (yyloc).end_pos = (yyloc).beg_pos;
                        token_flush(p);
                    }
#line 17416 "parse.c"
    break;

  case 788: /* terms: terms ';'  */
#line 6880 "parse.y"
                            {yyerrok;}
#line 17422 "parse.c"
    break;

  case 789: /* none: %empty  */
#line 6884 "parse.y"
                    {
                        (yyval.node) = 0;
                    }
#line 17430 "parse.c"
    break;


#line 17434 "parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc, p);

  YYPOPSTACK (yylen);
        /* %after-reduce function. */
#line 2661 "parse.y"
        {after_reduce(yylen, p);}
#line 17455 "parse.c"

  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx, p);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx, p);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, p, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= END_OF_INPUT)
        {
          /* Return failure if at end of input.  */
          if (yychar == END_OF_INPUT)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, p);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
        /* %after-pop-stack function. */
#line 2663 "parse.y"
        {after_pop_stack(yylen, p);}
#line 17561 "parse.c"

  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp, p);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, p);
      YYPOPSTACK (1);
        /* %after-pop-stack function. */
#line 2663 "parse.y"
        {after_pop_stack(1, p);}
#line 17601 "parse.c"

      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp, p);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp, p);
        /* %after-shift-error-token code. */
#line 2662 "parse.y"
        {after_shift_error_token(p);}
#line 17620 "parse.c"


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, p, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, p);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp, p);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, p);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 6888 "parse.y"

# undef p
# undef yylex
# undef yylval
# define yylval  (*p->lval)

static int regx_options(struct parser_params*);
static int tokadd_string(struct parser_params*,int,int,int,long*,rb_encoding**,rb_encoding**);
static void tokaddmbc(struct parser_params *p, int c, rb_encoding *enc);
static enum yytokentype parse_string(struct parser_params*,rb_strterm_literal_t*);
static enum yytokentype here_document(struct parser_params*,rb_strterm_heredoc_t*);

#define set_parser_s_value(x) (ifdef_ripper(p->s_value = (x), (void)0))

# define set_yylval_node(x) {				\
  YYLTYPE _cur_loc;					\
  rb_parser_set_location(p, &_cur_loc);			\
  yylval.node = (x);					\
  set_parser_s_value(STR_NEW(p->lex.ptok, p->lex.pcur-p->lex.ptok)); \
}
# define set_yylval_str(x) \
do { \
  set_yylval_node(NEW_STR(x, &_cur_loc)); \
  set_parser_s_value(rb_str_new_mutable_parser_string(x)); \
} while(0)
# define set_yylval_num(x) { \
  yylval.num = (x); \
  set_parser_s_value(x); \
}
# define set_yylval_id(x) (yylval.id = (x))
# define set_yylval_name(x) { \
  (yylval.id = (x)); \
  set_parser_s_value(ID2SYM(x)); \
}
# define yylval_id() (yylval.id)

#define set_yylval_noname() set_yylval_id(keyword_nil)
#define has_delayed_token(p) (p->delayed.token != NULL)

#ifndef RIPPER
#define literal_flush(p, ptr) ((p)->lex.ptok = (ptr))
#define dispatch_scan_event(p, t) parser_dispatch_scan_event(p, t, __LINE__)

static bool
parser_has_token(struct parser_params *p)
{
    const char *const pcur = p->lex.pcur;
    const char *const ptok = p->lex.ptok;
    if (p->keep_tokens && (pcur < ptok)) {
        rb_bug("lex.pcur < lex.ptok. (line: %d) %"PRIdPTRDIFF"|%"PRIdPTRDIFF"|%"PRIdPTRDIFF"",
               p->ruby_sourceline, ptok - p->lex.pbeg, pcur - ptok, p->lex.pend - pcur);
    }
    return pcur > ptok;
}

static const char *
escaped_char(int c)
{
    switch (c) {
      case '"': return "\\\"";
      case '\\': return "\\\\";
      case '\0': return "\\0";
      case '\n': return "\\n";
      case '\r': return "\\r";
      case '\t': return "\\t";
      case '\f': return "\\f";
      case '\013': return "\\v";
      case '\010': return "\\b";
      case '\007': return "\\a";
      case '\033': return "\\e";
      case '\x7f': return "\\c?";
    }
    return NULL;
}

static rb_parser_string_t *
rb_parser_str_escape(struct parser_params *p, rb_parser_string_t *str)
{
    rb_encoding *enc = p->enc;
    const char *ptr = str->ptr;
    const char *pend = ptr + str->len;
    const char *prev = ptr;
    char charbuf[5] = {'\\', 'x', 0, 0, 0};
    rb_parser_string_t * result = rb_parser_string_new(p, 0, 0);

    while (ptr < pend) {
        unsigned int c;
        const char *cc;
        int n = rb_enc_precise_mbclen(ptr, pend, enc);
        if (!MBCLEN_CHARFOUND_P(n)) {
            if (ptr > prev) parser_str_cat(result, prev, ptr - prev);
            n = rb_enc_mbminlen(enc);
            if (pend < ptr + n)
                n = (int)(pend - ptr);
            while (n--) {
                c = *ptr & 0xf0 >> 4;
                charbuf[2] = (c < 10) ? '0' + c : 'A' + c - 10;
                c = *ptr & 0x0f;
                charbuf[3] = (c < 10) ? '0' + c : 'A' + c - 10;
                parser_str_cat(result, charbuf, 4);
                prev = ++ptr;
            }
            continue;
        }
        n = MBCLEN_CHARFOUND_LEN(n);
        c = rb_enc_mbc_to_codepoint(ptr, pend, enc);
        ptr += n;
        cc = escaped_char(c);
        if (cc) {
            if (ptr - n > prev) parser_str_cat(result, prev, ptr - n - prev);
            parser_str_cat_cstr(result, cc);
            prev = ptr;
        }
        else if (rb_enc_isascii(c, enc) && ISPRINT(c)) {
        }
        else {
            if (ptr - n > prev) {
                parser_str_cat(result, prev, ptr - n - prev);
                prev = ptr - n;
            }
            parser_str_cat(result, prev, ptr - prev);
            prev = ptr;
        }
    }
    if (ptr > prev) parser_str_cat(result, prev, ptr - prev);

    return result;
}

static void
parser_append_tokens(struct parser_params *p, rb_parser_string_t *str, enum yytokentype t, int line)
{
    rb_parser_ast_token_t *token = xcalloc(1, sizeof(rb_parser_ast_token_t));
    token->id = p->token_id;
    token->type_name = parser_token2char(p, t);
    token->str = str;
    token->loc.beg_pos = p->yylloc->beg_pos;
    token->loc.end_pos = p->yylloc->end_pos;
    rb_parser_ary_push_ast_token(p, p->tokens, token);
    p->token_id++;

    if (p->debug) {
        rb_parser_string_t *str_escaped = rb_parser_str_escape(p, str);
        rb_parser_printf(p, "Append tokens (line: %d) [%d, :%s, \"%s\", [%d, %d, %d, %d]]\n",
                            line, token->id, token->type_name, str_escaped->ptr,
                            token->loc.beg_pos.lineno, token->loc.beg_pos.column,
                            token->loc.end_pos.lineno, token->loc.end_pos.column);
        rb_parser_string_free(p, str_escaped);
    }
}

static void
parser_dispatch_scan_event(struct parser_params *p, enum yytokentype t, int line)
{
    debug_token_line(p, "parser_dispatch_scan_event", line);

    if (!parser_has_token(p)) return;

    RUBY_SET_YYLLOC(*p->yylloc);

    if (p->keep_tokens) {
        rb_parser_string_t *str = rb_parser_encoding_string_new(p, p->lex.ptok, p->lex.pcur - p->lex.ptok, p->enc);
        parser_append_tokens(p, str, t, line);
    }

    token_flush(p);
}

#define dispatch_delayed_token(p, t) parser_dispatch_delayed_token(p, t, __LINE__)
static void
parser_dispatch_delayed_token(struct parser_params *p, enum yytokentype t, int line)
{
    debug_token_line(p, "parser_dispatch_delayed_token", line);

    if (!has_delayed_token(p)) return;

    RUBY_SET_YYLLOC_OF_DELAYED_TOKEN(*p->yylloc);

    if (p->keep_tokens) {
        /* p->delayed.token is freed by rb_parser_tokens_free */
        parser_append_tokens(p, p->delayed.token, t, line);
    } else {
        rb_parser_string_free(p, p->delayed.token);
    }

    p->delayed.token = NULL;
}
#else
#define literal_flush(p, ptr) ((void)(ptr))

static int
ripper_has_scan_event(struct parser_params *p)
{
    if (p->lex.pcur < p->lex.ptok) rb_raise(rb_eRuntimeError, "lex.pcur < lex.ptok");
    return p->lex.pcur > p->lex.ptok;
}

static VALUE
ripper_scan_event_val(struct parser_params *p, enum yytokentype t)
{
    VALUE str = STR_NEW(p->lex.ptok, p->lex.pcur - p->lex.ptok);
    VALUE rval = ripper_dispatch1(p, ripper_token2eventid(t), str);
    RUBY_SET_YYLLOC(*p->yylloc);
    token_flush(p);
    return rval;
}

static void
ripper_dispatch_scan_event(struct parser_params *p, enum yytokentype t)
{
    if (!ripper_has_scan_event(p)) return;

    set_parser_s_value(ripper_scan_event_val(p, t));
}
#define dispatch_scan_event(p, t) ripper_dispatch_scan_event(p, t)

static void
ripper_dispatch_delayed_token(struct parser_params *p, enum yytokentype t)
{
    /* save and adjust the location to delayed token for callbacks */
    int saved_line = p->ruby_sourceline;
    const char *saved_tokp = p->lex.ptok;
    VALUE s_value, str;

    if (!has_delayed_token(p)) return;
    p->ruby_sourceline = p->delayed.beg_line;
    p->lex.ptok = p->lex.pbeg + p->delayed.beg_col;
    str = rb_str_new_mutable_parser_string(p->delayed.token);
    rb_parser_string_free(p, p->delayed.token);
    s_value = ripper_dispatch1(p, ripper_token2eventid(t), str);
    set_parser_s_value(s_value);
    p->delayed.token = NULL;
    p->ruby_sourceline = saved_line;
    p->lex.ptok = saved_tokp;
}
#define dispatch_delayed_token(p, t) ripper_dispatch_delayed_token(p, t)
#endif /* RIPPER */

static inline int
is_identchar(struct parser_params *p, const char *ptr, const char *MAYBE_UNUSED(ptr_end), rb_encoding *enc)
{
    return rb_enc_isalnum((unsigned char)*ptr, enc) || *ptr == '_' || !ISASCII(*ptr);
}

static inline int
parser_is_identchar(struct parser_params *p)
{
    return !(p)->eofp && is_identchar(p, p->lex.pcur-1, p->lex.pend, p->enc);
}

static inline int
parser_isascii(struct parser_params *p)
{
    return ISASCII(*(p->lex.pcur-1));
}

static void
token_info_setup(token_info *ptinfo, const char *ptr, const rb_code_location_t *loc)
{
    int column = 1, nonspc = 0, i;
    for (i = 0; i < loc->beg_pos.column; i++, ptr++) {
        if (*ptr == '\t') {
            column = (((column - 1) / TAB_WIDTH) + 1) * TAB_WIDTH;
        }
        column++;
        if (*ptr != ' ' && *ptr != '\t') {
            nonspc = 1;
        }
    }

    ptinfo->beg = loc->beg_pos;
    ptinfo->indent = column;
    ptinfo->nonspc = nonspc;
}

static void
token_info_push(struct parser_params *p, const char *token, const rb_code_location_t *loc)
{
    token_info *ptinfo;

    if (!p->token_info_enabled) return;
    ptinfo = ALLOC(token_info);
    ptinfo->token = token;
    ptinfo->next = p->token_info;
    token_info_setup(ptinfo, p->lex.pbeg, loc);

    p->token_info = ptinfo;
}

static void
token_info_pop(struct parser_params *p, const char *token, const rb_code_location_t *loc)
{
    token_info *ptinfo_beg = p->token_info;

    if (!ptinfo_beg) return;

    /* indentation check of matched keywords (begin..end, if..end, etc.) */
    token_info_warn(p, token, ptinfo_beg, 1, loc);

    p->token_info = ptinfo_beg->next;
    ruby_sized_xfree(ptinfo_beg, sizeof(*ptinfo_beg));
}

static void
token_info_drop(struct parser_params *p, const char *token, rb_code_position_t beg_pos)
{
    token_info *ptinfo_beg = p->token_info;

    if (!ptinfo_beg) return;
    p->token_info = ptinfo_beg->next;

    if (ptinfo_beg->beg.lineno != beg_pos.lineno ||
        ptinfo_beg->beg.column != beg_pos.column ||
        strcmp(ptinfo_beg->token, token)) {
        compile_error(p, "token position mismatch: %d:%d:%s expected but %d:%d:%s",
                      beg_pos.lineno, beg_pos.column, token,
                      ptinfo_beg->beg.lineno, ptinfo_beg->beg.column,
                      ptinfo_beg->token);
    }

    ruby_sized_xfree(ptinfo_beg, sizeof(*ptinfo_beg));
}

static void
token_info_warn(struct parser_params *p, const char *token, token_info *ptinfo_beg, int same, const rb_code_location_t *loc)
{
    token_info ptinfo_end_body, *ptinfo_end = &ptinfo_end_body;
    if (!p->token_info_enabled) return;
    if (!ptinfo_beg) return;
    token_info_setup(ptinfo_end, p->lex.pbeg, loc);
    if (ptinfo_beg->beg.lineno == ptinfo_end->beg.lineno) return; /* ignore one-line block */
    if (ptinfo_beg->nonspc || ptinfo_end->nonspc) return; /* ignore keyword in the middle of a line */
    if (ptinfo_beg->indent == ptinfo_end->indent) return; /* the indents are matched */
    if (!same && ptinfo_beg->indent < ptinfo_end->indent) return;
    rb_warn3L(ptinfo_end->beg.lineno,
              "mismatched indentations at '%s' with '%s' at %d",
              WARN_S(token), WARN_S(ptinfo_beg->token), WARN_I(ptinfo_beg->beg.lineno));
}

static int
parser_precise_mbclen(struct parser_params *p, const char *ptr)
{
    int len = rb_enc_precise_mbclen(ptr, p->lex.pend, p->enc);
    if (!MBCLEN_CHARFOUND_P(len)) {
        compile_error(p, "invalid multibyte char (%s)", rb_enc_name(p->enc));
        return -1;
    }
    return len;
}

#ifndef RIPPER
static inline void
parser_show_error_line(struct parser_params *p, const YYLTYPE *yylloc)
{
    rb_parser_string_t *str;
    int lineno = p->ruby_sourceline;
    if (!yylloc) {
        return;
    }
    else if (yylloc->beg_pos.lineno == lineno) {
        str = p->lex.lastline;
    }
    else {
        return;
    }
    ruby_show_error_line(p, p->error_buffer, yylloc, lineno, str);
}

static int
parser_yyerror(struct parser_params *p, const rb_code_location_t *yylloc, const char *msg)
{
#if 0
    YYLTYPE current;

    if (!yylloc) {
        yylloc = RUBY_SET_YYLLOC(current);
    }
    else if ((p->ruby_sourceline != yylloc->beg_pos.lineno &&
              p->ruby_sourceline != yylloc->end_pos.lineno)) {
        yylloc = 0;
    }
#endif
    parser_compile_error(p, yylloc, "%s", msg);
    parser_show_error_line(p, yylloc);
    return 0;
}

static int
parser_yyerror0(struct parser_params *p, const char *msg)
{
    YYLTYPE current;
    return parser_yyerror(p, RUBY_SET_YYLLOC(current), msg);
}

void
ruby_show_error_line(struct parser_params *p, VALUE errbuf, const YYLTYPE *yylloc, int lineno, rb_parser_string_t *str)
{
    VALUE mesg;
    const int max_line_margin = 30;
    const char *ptr, *ptr_end, *pt, *pb;
    const char *pre = "", *post = "", *pend;
    const char *code = "", *caret = "";
    const char *lim;
    const char *const pbeg = PARSER_STRING_PTR(str);
    char *buf;
    long len;
    int i;

    if (!yylloc) return;
    pend = rb_parser_string_end(str);
    if (pend > pbeg && pend[-1] == '\n') {
        if (--pend > pbeg && pend[-1] == '\r') --pend;
    }

    pt = pend;
    if (lineno == yylloc->end_pos.lineno &&
        (pend - pbeg) > yylloc->end_pos.column) {
        pt = pbeg + yylloc->end_pos.column;
    }

    ptr = ptr_end = pt;
    lim = ptr - pbeg > max_line_margin ? ptr - max_line_margin : pbeg;
    while ((lim < ptr) && (*(ptr-1) != '\n')) ptr--;

    lim = pend - ptr_end > max_line_margin ? ptr_end + max_line_margin : pend;
    while ((ptr_end < lim) && (*ptr_end != '\n') && (*ptr_end != '\r')) ptr_end++;

    len = ptr_end - ptr;
    if (len > 4) {
        if (ptr > pbeg) {
            ptr = rb_enc_prev_char(pbeg, ptr, pt, rb_parser_str_get_encoding(str));
            if (ptr > pbeg) pre = "...";
        }
        if (ptr_end < pend) {
            ptr_end = rb_enc_prev_char(pt, ptr_end, pend, rb_parser_str_get_encoding(str));
            if (ptr_end < pend) post = "...";
        }
    }
    pb = pbeg;
    if (lineno == yylloc->beg_pos.lineno) {
        pb += yylloc->beg_pos.column;
        if (pb > pt) pb = pt;
    }
    if (pb < ptr) pb = ptr;
    if (len <= 4 && yylloc->beg_pos.lineno == yylloc->end_pos.lineno) {
        return;
    }
    if (RTEST(errbuf)) {
        mesg = rb_attr_get(errbuf, idMesg);
        if (char_at_end(p, mesg, '\n') != '\n')
            rb_str_cat_cstr(mesg, "\n");
    }
    else {
        mesg = rb_enc_str_new(0, 0, rb_parser_str_get_encoding(str));
    }
    if (!errbuf && rb_stderr_tty_p()) {
#define CSI_BEGIN "\033["
#define CSI_SGR "m"
        rb_str_catf(mesg,
                    CSI_BEGIN""CSI_SGR"%s" /* pre */
                    CSI_BEGIN"1"CSI_SGR"%.*s"
                    CSI_BEGIN"1;4"CSI_SGR"%.*s"
                    CSI_BEGIN";1"CSI_SGR"%.*s"
                    CSI_BEGIN""CSI_SGR"%s" /* post */
                    "\n",
                    pre,
                    (int)(pb - ptr), ptr,
                    (int)(pt - pb), pb,
                    (int)(ptr_end - pt), pt,
                    post);
    }
    else {
        char *p2;

        len = ptr_end - ptr;
        lim = pt < pend ? pt : pend;
        i = (int)(lim - ptr);
        buf = ALLOCA_N(char, i+2);
        code = ptr;
        caret = p2 = buf;
        if (ptr <= pb) {
            while (ptr < pb) {
                *p2++ = *ptr++ == '\t' ? '\t' : ' ';
            }
            *p2++ = '^';
            ptr++;
        }
        if (lim > ptr) {
            memset(p2, '~', (lim - ptr));
            p2 += (lim - ptr);
        }
        *p2 = '\0';
        rb_str_catf(mesg, "%s%.*s%s\n""%s%s\n",
                    pre, (int)len, code, post,
                    pre, caret);
    }
    if (!errbuf) rb_write_error_str(mesg);
}
#else

static int
parser_yyerror(struct parser_params *p, const YYLTYPE *yylloc, const char *msg)
{
    const char *pcur = 0, *ptok = 0;
    if (p->ruby_sourceline == yylloc->beg_pos.lineno &&
        p->ruby_sourceline == yylloc->end_pos.lineno) {
        pcur = p->lex.pcur;
        ptok = p->lex.ptok;
        p->lex.ptok = p->lex.pbeg + yylloc->beg_pos.column;
        p->lex.pcur = p->lex.pbeg + yylloc->end_pos.column;
    }
    parser_yyerror0(p, msg);
    if (pcur) {
        p->lex.ptok = ptok;
        p->lex.pcur = pcur;
    }
    return 0;
}

static int
parser_yyerror0(struct parser_params *p, const char *msg)
{
    dispatch1(parse_error, STR_NEW2(msg));
    ripper_error(p);
    return 0;
}

static inline void
parser_show_error_line(struct parser_params *p, const YYLTYPE *yylloc)
{
}
#endif /* !RIPPER */

static int
vtable_size(const struct vtable *tbl)
{
    if (!DVARS_TERMINAL_P(tbl)) {
        return tbl->pos;
    }
    else {
        return 0;
    }
}

static struct vtable *
vtable_alloc_gen(struct parser_params *p, int line, struct vtable *prev)
{
    struct vtable *tbl = ALLOC(struct vtable);
    tbl->pos = 0;
    tbl->capa = 8;
    tbl->tbl = ALLOC_N(ID, tbl->capa);
    tbl->prev = prev;
#ifndef RIPPER
    if (p->debug) {
        rb_parser_printf(p, "vtable_alloc:%d: %p\n", line, (void *)tbl);
    }
#endif
    return tbl;
}
#define vtable_alloc(prev) vtable_alloc_gen(p, __LINE__, prev)

static void
vtable_free_gen(struct parser_params *p, int line, const char *name,
                struct vtable *tbl)
{
#ifndef RIPPER
    if (p->debug) {
        rb_parser_printf(p, "vtable_free:%d: %s(%p)\n", line, name, (void *)tbl);
    }
#endif
    if (!DVARS_TERMINAL_P(tbl)) {
        if (tbl->tbl) {
            ruby_sized_xfree(tbl->tbl, tbl->capa * sizeof(ID));
        }
        ruby_sized_xfree(tbl, sizeof(*tbl));
    }
}
#define vtable_free(tbl) vtable_free_gen(p, __LINE__, #tbl, tbl)

static void
vtable_add_gen(struct parser_params *p, int line, const char *name,
               struct vtable *tbl, ID id)
{
#ifndef RIPPER
    if (p->debug) {
        rb_parser_printf(p, "vtable_add:%d: %s(%p), %s\n",
                         line, name, (void *)tbl, rb_id2name(id));
    }
#endif
    if (DVARS_TERMINAL_P(tbl)) {
        rb_parser_fatal(p, "vtable_add: vtable is not allocated (%p)", (void *)tbl);
        return;
    }
    if (tbl->pos == tbl->capa) {
        tbl->capa = tbl->capa * 2;
        SIZED_REALLOC_N(tbl->tbl, ID, tbl->capa, tbl->pos);
    }
    tbl->tbl[tbl->pos++] = id;
}
#define vtable_add(tbl, id) vtable_add_gen(p, __LINE__, #tbl, tbl, id)

static void
vtable_pop_gen(struct parser_params *p, int line, const char *name,
               struct vtable *tbl, int n)
{
    if (p->debug) {
        rb_parser_printf(p, "vtable_pop:%d: %s(%p), %d\n",
                         line, name, (void *)tbl, n);
    }
    if (tbl->pos < n) {
        rb_parser_fatal(p, "vtable_pop: unreachable (%d < %d)", tbl->pos, n);
        return;
    }
    tbl->pos -= n;
}
#define vtable_pop(tbl, n) vtable_pop_gen(p, __LINE__, #tbl, tbl, n)

static int
vtable_included(const struct vtable * tbl, ID id)
{
    int i;

    if (!DVARS_TERMINAL_P(tbl)) {
        for (i = 0; i < tbl->pos; i++) {
            if (tbl->tbl[i] == id) {
                return i+1;
            }
        }
    }
    return 0;
}

static void parser_prepare(struct parser_params *p);

static int
e_option_supplied(struct parser_params *p)
{
    return strcmp(p->ruby_sourcefile, "-e") == 0;
}

#ifndef RIPPER
static NODE *parser_append_options(struct parser_params *p, NODE *node);

static VALUE
yycompile0(VALUE arg)
{
    int n;
    NODE *tree;
    struct parser_params *p = (struct parser_params *)arg;
    int cov = FALSE;

    if (!compile_for_eval && !NIL_P(p->ruby_sourcefile_string) && !e_option_supplied(p)) {
        cov = TRUE;
    }

    if (p->debug_lines) {
        p->ast->body.script_lines = p->debug_lines;
    }

    parser_prepare(p);
#define RUBY_DTRACE_PARSE_HOOK(name) \
    if (RUBY_DTRACE_PARSE_##name##_ENABLED()) { \
        RUBY_DTRACE_PARSE_##name(p->ruby_sourcefile, p->ruby_sourceline); \
    }
    RUBY_DTRACE_PARSE_HOOK(BEGIN);
    n = yyparse(p);
    RUBY_DTRACE_PARSE_HOOK(END);

    p->debug_lines = 0;

    xfree(p->lex.strterm);
    p->lex.strterm = 0;
    p->lex.pcur = p->lex.pbeg = p->lex.pend = 0;
    if (n || p->error_p) {
        VALUE mesg = p->error_buffer;
        if (!mesg) {
            mesg = syntax_error_new();
        }
        if (!p->error_tolerant) {
            rb_set_errinfo(mesg);
            return FALSE;
        }
    }
    tree = p->eval_tree;
    if (!tree) {
        tree = NEW_NIL(&NULL_LOC);
    }
    else {
        rb_parser_ary_t *tokens = p->tokens;
        NODE *prelude;
        NODE *body = parser_append_options(p, RNODE_SCOPE(tree)->nd_body);
        prelude = block_append(p, p->eval_tree_begin, body);
        RNODE_SCOPE(tree)->nd_body = prelude;
        p->ast->body.frozen_string_literal = p->frozen_string_literal;
        p->ast->body.coverage_enabled = cov;
        if (p->keep_tokens) {
            p->ast->node_buffer->tokens = tokens;
            p->tokens = NULL;
        }
    }
    p->ast->body.root = tree;
    p->ast->body.line_count = p->line_count;
    return TRUE;
}

static rb_ast_t *
yycompile(struct parser_params *p, VALUE fname, int line)
{
    rb_ast_t *ast;
    if (NIL_P(fname)) {
        p->ruby_sourcefile_string = Qnil;
        p->ruby_sourcefile = "(none)";
    }
    else {
        p->ruby_sourcefile_string = rb_str_to_interned_str(fname);
        p->ruby_sourcefile = StringValueCStr(fname);
    }
    p->ruby_sourceline = line - 1;

    p->lvtbl = NULL;

    p->ast = ast = rb_ast_new();
    compile_callback(yycompile0, (VALUE)p);
    p->ast = 0;

    while (p->lvtbl) {
        local_pop(p);
    }

    return ast;
}
#endif /* !RIPPER */

static rb_encoding *
must_be_ascii_compatible(struct parser_params *p, rb_parser_string_t *s)
{
    rb_encoding *enc = rb_parser_str_get_encoding(s);
    if (!rb_enc_asciicompat(enc)) {
        rb_raise(rb_eArgError, "invalid source encoding");
    }
    return enc;
}

static rb_parser_string_t *
lex_getline(struct parser_params *p)
{
    rb_parser_string_t *line = (*p->lex.gets)(p, p->lex.input, p->line_count);
    if (!line) return 0;
    p->line_count++;
    string_buffer_append(p, line);
    must_be_ascii_compatible(p, line);
    return line;
}

#ifndef RIPPER
rb_ast_t*
rb_parser_compile(rb_parser_t *p, rb_parser_lex_gets_func *gets, VALUE fname, rb_parser_input_data input, int line)
{
    p->lex.gets = gets;
    p->lex.input = input;
    p->lex.pbeg = p->lex.pcur = p->lex.pend = 0;

    return yycompile(p, fname, line);
}
#endif  /* !RIPPER */

#define STR_FUNC_ESCAPE 0x01
#define STR_FUNC_EXPAND 0x02
#define STR_FUNC_REGEXP 0x04
#define STR_FUNC_QWORDS 0x08
#define STR_FUNC_SYMBOL 0x10
#define STR_FUNC_INDENT 0x20
#define STR_FUNC_LABEL  0x40
#define STR_FUNC_LIST   0x4000
#define STR_FUNC_TERM   0x8000

enum string_type {
    str_label  = STR_FUNC_LABEL,
    str_squote = (0),
    str_dquote = (STR_FUNC_EXPAND),
    str_xquote = (STR_FUNC_EXPAND),
    str_regexp = (STR_FUNC_REGEXP|STR_FUNC_ESCAPE|STR_FUNC_EXPAND),
    str_sword  = (STR_FUNC_QWORDS|STR_FUNC_LIST),
    str_dword  = (STR_FUNC_QWORDS|STR_FUNC_EXPAND|STR_FUNC_LIST),
    str_ssym   = (STR_FUNC_SYMBOL),
    str_dsym   = (STR_FUNC_SYMBOL|STR_FUNC_EXPAND)
};

static rb_parser_string_t *
parser_str_new(struct parser_params *p, const char *ptr, long len, rb_encoding *enc, int func, rb_encoding *enc0)
{
    rb_parser_string_t *pstr;

    pstr = rb_parser_encoding_string_new(p, ptr, len, enc);

    if (!(func & STR_FUNC_REGEXP)) {
        if (rb_parser_is_ascii_string(p, pstr)) {
        }
        else if (rb_is_usascii_enc((void *)enc0) && enc != rb_utf8_encoding()) {
            /* everything is valid in ASCII-8BIT */
            enc = rb_ascii8bit_encoding();
            PARSER_ENCODING_CODERANGE_SET(pstr, enc, RB_PARSER_ENC_CODERANGE_VALID);
        }
    }

    return pstr;
}

static int
strterm_is_heredoc(rb_strterm_t *strterm)
{
    return strterm->heredoc;
}

static rb_strterm_t *
new_strterm(struct parser_params *p, int func, int term, int paren)
{
    rb_strterm_t *strterm = ZALLOC(rb_strterm_t);
    strterm->u.literal.func = func;
    strterm->u.literal.term = term;
    strterm->u.literal.paren = paren;
    return strterm;
}

static rb_strterm_t *
new_heredoc(struct parser_params *p)
{
    rb_strterm_t *strterm = ZALLOC(rb_strterm_t);
    strterm->heredoc = true;
    return strterm;
}

#define peek(p,c) peek_n(p, (c), 0)
#define peek_n(p,c,n) (!lex_eol_n_p(p, n) && (c) == (unsigned char)(p)->lex.pcur[n])
#define peekc(p) peekc_n(p, 0)
#define peekc_n(p,n) (lex_eol_n_p(p, n) ? -1 : (unsigned char)(p)->lex.pcur[n])

#define add_delayed_token(p, tok, end) parser_add_delayed_token(p, tok, end, __LINE__)
static void
parser_add_delayed_token(struct parser_params *p, const char *tok, const char *end, int line)
{
    debug_token_line(p, "add_delayed_token", line);

    if (tok < end) {
        if (has_delayed_token(p)) {
            bool next_line = parser_string_char_at_end(p, p->delayed.token, 0) == '\n';
            int end_line = (next_line ? 1 : 0) + p->delayed.end_line;
            int end_col = (next_line ? 0 : p->delayed.end_col);
            if (end_line != p->ruby_sourceline || end_col != tok - p->lex.pbeg) {
                dispatch_delayed_token(p, tSTRING_CONTENT);
            }
        }
        if (!has_delayed_token(p)) {
            p->delayed.token = rb_parser_string_new(p, 0, 0);
            rb_parser_enc_associate(p, p->delayed.token, p->enc);
            p->delayed.beg_line = p->ruby_sourceline;
            p->delayed.beg_col = rb_long2int(tok - p->lex.pbeg);
        }
        parser_str_cat(p->delayed.token, tok, end - tok);
        p->delayed.end_line = p->ruby_sourceline;
        p->delayed.end_col = rb_long2int(end - p->lex.pbeg);
        p->lex.ptok = end;
    }
}

static void
set_lastline(struct parser_params *p, rb_parser_string_t *str)
{
    p->lex.pbeg = p->lex.pcur = PARSER_STRING_PTR(str);
    p->lex.pend = p->lex.pcur + PARSER_STRING_LEN(str);
    p->lex.lastline = str;
}

static int
nextline(struct parser_params *p, int set_encoding)
{
    rb_parser_string_t *str = p->lex.nextline;
    p->lex.nextline = 0;
    if (!str) {
        if (p->eofp)
            return -1;

        if (!lex_eol_ptr_p(p, p->lex.pbeg) && *(p->lex.pend-1) != '\n') {
            goto end_of_input;
        }

        if (!p->lex.input || !(str = lex_getline(p))) {
          end_of_input:
            p->eofp = 1;
            lex_goto_eol(p);
            return -1;
        }
#ifndef RIPPER
        if (p->debug_lines) {
            if (set_encoding) rb_parser_enc_associate(p, str, p->enc);
            rb_parser_string_t *copy = rb_parser_string_deep_copy(p, str);
            rb_parser_ary_push_script_line(p, p->debug_lines, copy);
        }
#endif
        p->cr_seen = FALSE;
    }
    else if (str == AFTER_HEREDOC_WITHOUT_TERMINTOR) {
        /* after here-document without terminator */
        goto end_of_input;
    }
    add_delayed_token(p, p->lex.ptok, p->lex.pend);
    if (p->heredoc_end > 0) {
        p->ruby_sourceline = p->heredoc_end;
        p->heredoc_end = 0;
    }
    p->ruby_sourceline++;
    set_lastline(p, str);
    token_flush(p);
    return 0;
}

static int
parser_cr(struct parser_params *p, int c)
{
    if (peek(p, '\n')) {
        p->lex.pcur++;
        c = '\n';
    }
    return c;
}

static inline int
nextc0(struct parser_params *p, int set_encoding)
{
    int c;

    if (UNLIKELY(lex_eol_p(p) || p->eofp || p->lex.nextline > AFTER_HEREDOC_WITHOUT_TERMINTOR)) {
        if (nextline(p, set_encoding)) return -1;
    }
    c = (unsigned char)*p->lex.pcur++;
    if (UNLIKELY(c == '\r')) {
        c = parser_cr(p, c);
    }

    return c;
}
#define nextc(p) nextc0(p, TRUE)

static void
pushback(struct parser_params *p, int c)
{
    if (c == -1) return;
    p->eofp = 0;
    p->lex.pcur--;
    if (p->lex.pcur > p->lex.pbeg && p->lex.pcur[0] == '\n' && p->lex.pcur[-1] == '\r') {
        p->lex.pcur--;
    }
}

#define was_bol(p) ((p)->lex.pcur == (p)->lex.pbeg + 1)

#define tokfix(p) ((p)->tokenbuf[(p)->tokidx]='\0')
#define tok(p) (p)->tokenbuf
#define toklen(p) (p)->tokidx

static int
looking_at_eol_p(struct parser_params *p)
{
    const char *ptr = p->lex.pcur;
    while (!lex_eol_ptr_p(p, ptr)) {
        int c = (unsigned char)*ptr++;
        int eol = (c == '\n' || c == '#');
        if (eol || !ISSPACE(c)) {
            return eol;
        }
    }
    return TRUE;
}

static char*
newtok(struct parser_params *p)
{
    p->tokidx = 0;
    if (!p->tokenbuf) {
        p->toksiz = 60;
        p->tokenbuf = ALLOC_N(char, 60);
    }
    if (p->toksiz > 4096) {
        p->toksiz = 60;
        REALLOC_N(p->tokenbuf, char, 60);
    }
    return p->tokenbuf;
}

static char *
tokspace(struct parser_params *p, int n)
{
    p->tokidx += n;

    if (p->tokidx >= p->toksiz) {
        do {p->toksiz *= 2;} while (p->toksiz < p->tokidx);
        REALLOC_N(p->tokenbuf, char, p->toksiz);
    }
    return &p->tokenbuf[p->tokidx-n];
}

static void
tokadd(struct parser_params *p, int c)
{
    p->tokenbuf[p->tokidx++] = (char)c;
    if (p->tokidx >= p->toksiz) {
        p->toksiz *= 2;
        REALLOC_N(p->tokenbuf, char, p->toksiz);
    }
}

static int
tok_hex(struct parser_params *p, size_t *numlen)
{
    int c;

    c = (int)ruby_scan_hex(p->lex.pcur, 2, numlen);
    if (!*numlen) {
        flush_string_content(p, p->enc, rb_strlen_lit("\\x"));
        yyerror0("invalid hex escape");
        dispatch_scan_event(p, tSTRING_CONTENT);
        return 0;
    }
    p->lex.pcur += *numlen;
    return c;
}

#define tokcopy(p, n) memcpy(tokspace(p, n), (p)->lex.pcur - (n), (n))

static int
escaped_control_code(int c)
{
    int c2 = 0;
    switch (c) {
      case ' ':
        c2 = 's';
        break;
      case '\n':
        c2 = 'n';
        break;
      case '\t':
        c2 = 't';
        break;
      case '\v':
        c2 = 'v';
        break;
      case '\r':
        c2 = 'r';
        break;
      case '\f':
        c2 = 'f';
        break;
    }
    return c2;
}

#define WARN_SPACE_CHAR(c, prefix) \
    rb_warn1("invalid character syntax; use "prefix"\\%c", WARN_I(c))

static int
tokadd_codepoint(struct parser_params *p, rb_encoding **encp,
                 int regexp_literal, const char *begin)
{
    const int wide = !begin;
    size_t numlen;
    int codepoint = (int)ruby_scan_hex(p->lex.pcur, wide ? p->lex.pend - p->lex.pcur : 4, &numlen);

    p->lex.pcur += numlen;
    if (p->lex.strterm == NULL ||
        strterm_is_heredoc(p->lex.strterm) ||
        (p->lex.strterm->u.literal.func != str_regexp)) {
        if (!begin) begin = p->lex.pcur;
        if (wide ? (numlen == 0 || numlen > 6) : (numlen < 4))  {
            flush_string_content(p, rb_utf8_encoding(), p->lex.pcur - begin);
            yyerror0("invalid Unicode escape");
            dispatch_scan_event(p, tSTRING_CONTENT);
            return wide && numlen > 0;
        }
        if (codepoint > 0x10ffff) {
            flush_string_content(p, rb_utf8_encoding(), p->lex.pcur - begin);
            yyerror0("invalid Unicode codepoint (too large)");
            dispatch_scan_event(p, tSTRING_CONTENT);
            return wide;
        }
        if ((codepoint & 0xfffff800) == 0xd800) {
            flush_string_content(p, rb_utf8_encoding(), p->lex.pcur - begin);
            yyerror0("invalid Unicode codepoint");
            dispatch_scan_event(p, tSTRING_CONTENT);
            return wide;
        }
    }
    if (regexp_literal) {
        tokcopy(p, (int)numlen);
    }
    else if (codepoint >= 0x80) {
        rb_encoding *utf8 = rb_utf8_encoding();
        if (*encp && utf8 != *encp) {
            YYLTYPE loc = RUBY_INIT_YYLLOC();
            compile_error(p, "UTF-8 mixed within %s source", rb_enc_name(*encp));
            parser_show_error_line(p, &loc);
            return wide;
        }
        *encp = utf8;
        tokaddmbc(p, codepoint, *encp);
    }
    else {
        tokadd(p, codepoint);
    }
    return TRUE;
}

static int tokadd_mbchar(struct parser_params *p, int c);

static int
tokskip_mbchar(struct parser_params *p)
{
    int len = parser_precise_mbclen(p, p->lex.pcur-1);
    if (len > 0) {
        p->lex.pcur += len - 1;
    }
    return len;
}

/* return value is for ?\u3042 */
static void
tokadd_utf8(struct parser_params *p, rb_encoding **encp,
            int term, int symbol_literal, int regexp_literal)
{
    /*
     * If `term` is not -1, then we allow multiple codepoints in \u{}
     * upto `term` byte, otherwise we're parsing a character literal.
     * And then add the codepoints to the current token.
     */
    static const char multiple_codepoints[] = "Multiple codepoints at single character literal";

    const int open_brace = '{', close_brace = '}';

    if (regexp_literal) { tokadd(p, '\\'); tokadd(p, 'u'); }

    if (peek(p, open_brace)) {  /* handle \u{...} form */
        if (regexp_literal && p->lex.strterm->u.literal.func == str_regexp) {
            /*
             * Skip parsing validation code and copy bytes as-is until term or
             * closing brace, in order to correctly handle extended regexps where
             * invalid unicode escapes are allowed in comments. The regexp parser
             * does its own validation and will catch any issues.
             */
            tokadd(p, open_brace);
            while (!lex_eol_ptr_p(p, ++p->lex.pcur)) {
                int c = peekc(p);
                if (c == close_brace) {
                    tokadd(p, c);
                    ++p->lex.pcur;
                    break;
                }
                else if (c == term) {
                    break;
                }
                if (c == '\\' && !lex_eol_n_p(p, 1)) {
                    tokadd(p, c);
                    c = *++p->lex.pcur;
                }
                tokadd_mbchar(p, c);
            }
        }
        else {
            const char *second = NULL;
            int c, last = nextc(p);
            if (lex_eol_p(p)) goto unterminated;
            while (ISSPACE(c = peekc(p)) && !lex_eol_ptr_p(p, ++p->lex.pcur));
            while (c != close_brace) {
                if (c == term) goto unterminated;
                if (second == multiple_codepoints)
                    second = p->lex.pcur;
                if (regexp_literal) tokadd(p, last);
                if (!tokadd_codepoint(p, encp, regexp_literal, NULL)) {
                    break;
                }
                while (ISSPACE(c = peekc(p))) {
                    if (lex_eol_ptr_p(p, ++p->lex.pcur)) goto unterminated;
                    last = c;
                }
                if (term == -1 && !second)
                    second = multiple_codepoints;
            }

            if (c != close_brace) {
              unterminated:
                flush_string_content(p, rb_utf8_encoding(), 0);
                yyerror0("unterminated Unicode escape");
                dispatch_scan_event(p, tSTRING_CONTENT);
                return;
            }
            if (second && second != multiple_codepoints) {
                const char *pcur = p->lex.pcur;
                p->lex.pcur = second;
                dispatch_scan_event(p, tSTRING_CONTENT);
                token_flush(p);
                p->lex.pcur = pcur;
                yyerror0(multiple_codepoints);
                token_flush(p);
            }

            if (regexp_literal) tokadd(p, close_brace);
            nextc(p);
        }
    }
    else {			/* handle \uxxxx form */
        if (!tokadd_codepoint(p, encp, regexp_literal, p->lex.pcur - rb_strlen_lit("\\u"))) {
            token_flush(p);
            return;
        }
    }
}

#define ESCAPE_CONTROL 1
#define ESCAPE_META    2

static int
read_escape(struct parser_params *p, int flags, const char *begin)
{
    int c;
    size_t numlen;

    switch (c = nextc(p)) {
      case '\\':	/* Backslash */
        return c;

      case 'n':	/* newline */
        return '\n';

      case 't':	/* horizontal tab */
        return '\t';

      case 'r':	/* carriage-return */
        return '\r';

      case 'f':	/* form-feed */
        return '\f';

      case 'v':	/* vertical tab */
        return '\13';

      case 'a':	/* alarm(bell) */
        return '\007';

      case 'e':	/* escape */
        return 033;

      case '0': case '1': case '2': case '3': /* octal constant */
      case '4': case '5': case '6': case '7':
        pushback(p, c);
        c = (int)ruby_scan_oct(p->lex.pcur, 3, &numlen);
        p->lex.pcur += numlen;
        return c;

      case 'x':	/* hex constant */
        c = tok_hex(p, &numlen);
        if (numlen == 0) return 0;
        return c;

      case 'b':	/* backspace */
        return '\010';

      case 's':	/* space */
        return ' ';

      case 'M':
        if (flags & ESCAPE_META) goto eof;
        if ((c = nextc(p)) != '-') {
            goto eof;
        }
        if ((c = nextc(p)) == '\\') {
            switch (peekc(p)) {
              case 'u': case 'U':
                nextc(p);
                goto eof;
            }
            return read_escape(p, flags|ESCAPE_META, begin) | 0x80;
        }
        else if (c == -1) goto eof;
        else if (!ISASCII(c)) {
            tokskip_mbchar(p);
            goto eof;
        }
        else {
            int c2 = escaped_control_code(c);
            if (c2) {
                if (ISCNTRL(c) || !(flags & ESCAPE_CONTROL)) {
                    WARN_SPACE_CHAR(c2, "\\M-");
                }
                else {
                    WARN_SPACE_CHAR(c2, "\\C-\\M-");
                }
            }
            else if (ISCNTRL(c)) goto eof;
            return ((c & 0xff) | 0x80);
        }

      case 'C':
        if ((c = nextc(p)) != '-') {
            goto eof;
        }
      case 'c':
        if (flags & ESCAPE_CONTROL) goto eof;
        if ((c = nextc(p))== '\\') {
            switch (peekc(p)) {
              case 'u': case 'U':
                nextc(p);
                goto eof;
            }
            c = read_escape(p, flags|ESCAPE_CONTROL, begin);
        }
        else if (c == '?')
            return 0177;
        else if (c == -1) goto eof;
        else if (!ISASCII(c)) {
            tokskip_mbchar(p);
            goto eof;
        }
        else {
            int c2 = escaped_control_code(c);
            if (c2) {
                if (ISCNTRL(c)) {
                    if (flags & ESCAPE_META) {
                        WARN_SPACE_CHAR(c2, "\\M-");
                    }
                    else {
                        WARN_SPACE_CHAR(c2, "");
                    }
                }
                else {
                    if (flags & ESCAPE_META) {
                        WARN_SPACE_CHAR(c2, "\\M-\\C-");
                    }
                    else {
                        WARN_SPACE_CHAR(c2, "\\C-");
                    }
                }
            }
            else if (ISCNTRL(c)) goto eof;
        }
        return c & 0x9f;

      eof:
      case -1:
        flush_string_content(p, p->enc, p->lex.pcur - begin);
        yyerror0("Invalid escape character syntax");
        dispatch_scan_event(p, tSTRING_CONTENT);
        return '\0';

      default:
        return c;
    }
}

static void
tokaddmbc(struct parser_params *p, int c, rb_encoding *enc)
{
    int len = rb_enc_codelen(c, enc);
    rb_enc_mbcput(c, tokspace(p, len), enc);
}

static int
tokadd_escape(struct parser_params *p)
{
    int c;
    size_t numlen;
    const char *begin = p->lex.pcur;

    switch (c = nextc(p)) {
      case '\n':
        return 0;		/* just ignore */

      case '0': case '1': case '2': case '3': /* octal constant */
      case '4': case '5': case '6': case '7':
        {
            ruby_scan_oct(--p->lex.pcur, 3, &numlen);
            if (numlen == 0) goto eof;
            p->lex.pcur += numlen;
            tokcopy(p, (int)numlen + 1);
        }
        return 0;

      case 'x':	/* hex constant */
        {
            tok_hex(p, &numlen);
            if (numlen == 0) return -1;
            tokcopy(p, (int)numlen + 2);
        }
        return 0;

      eof:
      case -1:
        flush_string_content(p, p->enc, p->lex.pcur - begin);
        yyerror0("Invalid escape character syntax");
        token_flush(p);
        return -1;

      default:
        tokadd(p, '\\');
        tokadd(p, c);
    }
    return 0;
}

static int
char_to_option(int c)
{
    int val;

    switch (c) {
      case 'i':
        val = RE_ONIG_OPTION_IGNORECASE;
        break;
      case 'x':
        val = RE_ONIG_OPTION_EXTEND;
        break;
      case 'm':
        val = RE_ONIG_OPTION_MULTILINE;
        break;
      default:
        val = 0;
        break;
    }
    return val;
}

#define ARG_ENCODING_FIXED   16
#define ARG_ENCODING_NONE    32
#define ENC_ASCII8BIT   1
#define ENC_EUC_JP      2
#define ENC_Windows_31J 3
#define ENC_UTF8        4

static int
char_to_option_kcode(int c, int *option, int *kcode)
{
    *option = 0;

    switch (c) {
      case 'n':
        *kcode = ENC_ASCII8BIT;
        return (*option = ARG_ENCODING_NONE);
      case 'e':
        *kcode = ENC_EUC_JP;
        break;
      case 's':
        *kcode = ENC_Windows_31J;
        break;
      case 'u':
        *kcode = ENC_UTF8;
        break;
      default:
        *kcode = -1;
        return (*option = char_to_option(c));
    }
    *option = ARG_ENCODING_FIXED;
    return 1;
}

static int
regx_options(struct parser_params *p)
{
    int kcode = 0;
    int kopt = 0;
    int options = 0;
    int c, opt, kc;

    newtok(p);
    while (c = nextc(p), ISALPHA(c)) {
        if (c == 'o') {
            options |= RE_OPTION_ONCE;
        }
        else if (char_to_option_kcode(c, &opt, &kc)) {
            if (kc >= 0) {
                if (kc != ENC_ASCII8BIT) kcode = c;
                kopt = opt;
            }
            else {
                options |= opt;
            }
        }
        else {
            tokadd(p, c);
        }
    }
    options |= kopt;
    pushback(p, c);
    if (toklen(p)) {
        YYLTYPE loc = RUBY_INIT_YYLLOC();
        tokfix(p);
        compile_error(p, "unknown regexp option%s - %*s",
                      toklen(p) > 1 ? "s" : "", toklen(p), tok(p));
        parser_show_error_line(p, &loc);
    }
    return options | RE_OPTION_ENCODING(kcode);
}

static int
tokadd_mbchar(struct parser_params *p, int c)
{
    int len = parser_precise_mbclen(p, p->lex.pcur-1);
    if (len < 0) return -1;
    tokadd(p, c);
    p->lex.pcur += --len;
    if (len > 0) tokcopy(p, len);
    return c;
}

static inline int
simple_re_meta(int c)
{
    switch (c) {
      case '$': case '*': case '+': case '.':
      case '?': case '^': case '|':
      case ')': case ']': case '}': case '>':
        return TRUE;
      default:
        return FALSE;
    }
}

static int
parser_update_heredoc_indent(struct parser_params *p, int c)
{
    if (p->heredoc_line_indent == -1) {
        if (c == '\n') p->heredoc_line_indent = 0;
    }
    else {
        if (c == ' ') {
            p->heredoc_line_indent++;
            return TRUE;
        }
        else if (c == '\t') {
            int w = (p->heredoc_line_indent / TAB_WIDTH) + 1;
            p->heredoc_line_indent = w * TAB_WIDTH;
            return TRUE;
        }
        else if (c != '\n') {
            if (p->heredoc_indent > p->heredoc_line_indent) {
                p->heredoc_indent = p->heredoc_line_indent;
            }
            p->heredoc_line_indent = -1;
        }
        else {
            /* Whitespace only line has no indentation */
            p->heredoc_line_indent = 0;
        }
    }
    return FALSE;
}

static void
parser_mixed_error(struct parser_params *p, rb_encoding *enc1, rb_encoding *enc2)
{
    YYLTYPE loc = RUBY_INIT_YYLLOC();
    const char *n1 = rb_enc_name(enc1), *n2 = rb_enc_name(enc2);
    compile_error(p, "%s mixed within %s source", n1, n2);
    parser_show_error_line(p, &loc);
}

static void
parser_mixed_escape(struct parser_params *p, const char *beg, rb_encoding *enc1, rb_encoding *enc2)
{
    const char *pos = p->lex.pcur;
    p->lex.pcur = beg;
    parser_mixed_error(p, enc1, enc2);
    p->lex.pcur = pos;
}

static inline char
nibble_char_upper(unsigned int c)
{
    c &= 0xf;
    return c + (c < 10 ? '0' : 'A' - 10);
}

static int
tokadd_string(struct parser_params *p,
              int func, int term, int paren, long *nest,
              rb_encoding **encp, rb_encoding **enc)
{
    int c;
    bool erred = false;
#ifdef RIPPER
    const int heredoc_end = (p->heredoc_end ? p->heredoc_end + 1 : 0);
    int top_of_line = FALSE;
#endif

#define mixed_error(enc1, enc2) \
    (void)(erred || (parser_mixed_error(p, enc1, enc2), erred = true))
#define mixed_escape(beg, enc1, enc2) \
    (void)(erred || (parser_mixed_escape(p, beg, enc1, enc2), erred = true))

    while ((c = nextc(p)) != -1) {
        if (p->heredoc_indent > 0) {
            parser_update_heredoc_indent(p, c);
        }
#ifdef RIPPER
        if (top_of_line && heredoc_end == p->ruby_sourceline) {
            pushback(p, c);
            break;
        }
#endif

        if (paren && c == paren) {
            ++*nest;
        }
        else if (c == term) {
            if (!nest || !*nest) {
                pushback(p, c);
                break;
            }
            --*nest;
        }
        else if ((func & STR_FUNC_EXPAND) && c == '#' && !lex_eol_p(p)) {
            unsigned char c2 = *p->lex.pcur;
            if (c2 == '$' || c2 == '@' || c2 == '{') {
                pushback(p, c);
                break;
            }
        }
        else if (c == '\\') {
            c = nextc(p);
            switch (c) {
              case '\n':
                if (func & STR_FUNC_QWORDS) break;
                if (func & STR_FUNC_EXPAND) {
                    if (!(func & STR_FUNC_INDENT) || (p->heredoc_indent < 0))
                        continue;
                    if (c == term) {
                        c = '\\';
                        goto terminate;
                    }
                }
                tokadd(p, '\\');
                break;

              case '\\':
                if (func & STR_FUNC_ESCAPE) tokadd(p, c);
                break;

              case 'u':
                if ((func & STR_FUNC_EXPAND) == 0) {
                    tokadd(p, '\\');
                    break;
                }
                tokadd_utf8(p, enc, term,
                            func & STR_FUNC_SYMBOL,
                            func & STR_FUNC_REGEXP);
                continue;

              default:
                if (c == -1) return -1;
                if (!ISASCII(c)) {
                    if ((func & STR_FUNC_EXPAND) == 0) tokadd(p, '\\');
                    goto non_ascii;
                }
                if (func & STR_FUNC_REGEXP) {
                    switch (c) {
                      case 'c':
                      case 'C':
                      case 'M': {
                        pushback(p, c);
                        c = read_escape(p, 0, p->lex.pcur - 1);

                        char *t = tokspace(p, rb_strlen_lit("\\x00"));
                        *t++ = '\\';
                        *t++ = 'x';
                        *t++ = nibble_char_upper(c >> 4);
                        *t++ = nibble_char_upper(c);
                        continue;
                      }
                    }

                    if (c == term && !simple_re_meta(c)) {
                        tokadd(p, c);
                        continue;
                    }
                    pushback(p, c);
                    if ((c = tokadd_escape(p)) < 0)
                        return -1;
                    if (*enc && *enc != *encp) {
                        mixed_escape(p->lex.ptok+2, *enc, *encp);
                    }
                    continue;
                }
                else if (func & STR_FUNC_EXPAND) {
                    pushback(p, c);
                    if (func & STR_FUNC_ESCAPE) tokadd(p, '\\');
                    c = read_escape(p, 0, p->lex.pcur - 1);
                }
                else if ((func & STR_FUNC_QWORDS) && ISSPACE(c)) {
                    /* ignore backslashed spaces in %w */
                }
                else if (c != term && !(paren && c == paren)) {
                    tokadd(p, '\\');
                    pushback(p, c);
                    continue;
                }
            }
        }
        else if (!parser_isascii(p)) {
          non_ascii:
            if (!*enc) {
                *enc = *encp;
            }
            else if (*enc != *encp) {
                mixed_error(*enc, *encp);
                continue;
            }
            if (tokadd_mbchar(p, c) == -1) return -1;
            continue;
        }
        else if ((func & STR_FUNC_QWORDS) && ISSPACE(c)) {
            pushback(p, c);
            break;
        }
        if (c & 0x80) {
            if (!*enc) {
                *enc = *encp;
            }
            else if (*enc != *encp) {
                mixed_error(*enc, *encp);
                continue;
            }
        }
        tokadd(p, c);
#ifdef RIPPER
        top_of_line = (c == '\n');
#endif
    }
  terminate:
    if (*enc) *encp = *enc;
    return c;
}

#define NEW_STRTERM(func, term, paren) new_strterm(p, func, term, paren)

static void
flush_string_content(struct parser_params *p, rb_encoding *enc, size_t back)
{
    p->lex.pcur -= back;
    if (has_delayed_token(p)) {
        ptrdiff_t len = p->lex.pcur - p->lex.ptok;
        if (len > 0) {
            rb_parser_enc_str_buf_cat(p, p->delayed.token, p->lex.ptok, len, enc);
            p->delayed.end_line = p->ruby_sourceline;
            p->delayed.end_col = rb_long2int(p->lex.pcur - p->lex.pbeg);
        }
        dispatch_delayed_token(p, tSTRING_CONTENT);
        p->lex.ptok = p->lex.pcur;
    }
    dispatch_scan_event(p, tSTRING_CONTENT);
    p->lex.pcur += back;
}

/* this can be shared with ripper, since it's independent from struct
 * parser_params. */
#ifndef RIPPER
#define BIT(c, idx) (((c) / 32 - 1 == idx) ? (1U << ((c) % 32)) : 0)
#define SPECIAL_PUNCT(idx) ( \
        BIT('~', idx) | BIT('*', idx) | BIT('$', idx) | BIT('?', idx) | \
        BIT('!', idx) | BIT('@', idx) | BIT('/', idx) | BIT('\\', idx) | \
        BIT(';', idx) | BIT(',', idx) | BIT('.', idx) | BIT('=', idx) | \
        BIT(':', idx) | BIT('<', idx) | BIT('>', idx) | BIT('\"', idx) | \
        BIT('&', idx) | BIT('`', idx) | BIT('\'', idx) | BIT('+', idx) | \
        BIT('0', idx))
const uint_least32_t ruby_global_name_punct_bits[] = {
    SPECIAL_PUNCT(0),
    SPECIAL_PUNCT(1),
    SPECIAL_PUNCT(2),
};
#undef BIT
#undef SPECIAL_PUNCT
#endif

static enum yytokentype
parser_peek_variable_name(struct parser_params *p)
{
    int c;
    const char *ptr = p->lex.pcur;

    if (lex_eol_ptr_n_p(p, ptr, 1)) return 0;
    c = *ptr++;
    switch (c) {
      case '$':
        if ((c = *ptr) == '-') {
            if (lex_eol_ptr_p(p, ++ptr)) return 0;
            c = *ptr;
        }
        else if (is_global_name_punct(c) || ISDIGIT(c)) {
            return tSTRING_DVAR;
        }
        break;
      case '@':
        if ((c = *ptr) == '@') {
            if (lex_eol_ptr_p(p, ++ptr)) return 0;
            c = *ptr;
        }
        break;
      case '{':
        p->lex.pcur = ptr;
        p->command_start = TRUE;
        yylval.state = p->lex.state;
        return tSTRING_DBEG;
      default:
        return 0;
    }
    if (!ISASCII(c) || c == '_' || ISALPHA(c))
        return tSTRING_DVAR;
    return 0;
}

#define IS_ARG() IS_lex_state(EXPR_ARG_ANY)
#define IS_END() IS_lex_state(EXPR_END_ANY)
#define IS_BEG() (IS_lex_state(EXPR_BEG_ANY) || IS_lex_state_all(EXPR_ARG|EXPR_LABELED))
#define IS_SPCARG(c) (IS_ARG() && space_seen && !ISSPACE(c))
#define IS_LABEL_POSSIBLE() (\
        (IS_lex_state(EXPR_LABEL|EXPR_ENDFN) && !cmd_state) || \
        IS_ARG())
#define IS_LABEL_SUFFIX(n) (peek_n(p, ':',(n)) && !peek_n(p, ':', (n)+1))
#define IS_AFTER_OPERATOR() IS_lex_state(EXPR_FNAME | EXPR_DOT)

static inline enum yytokentype
parser_string_term(struct parser_params *p, int func)
{
    xfree(p->lex.strterm);
    p->lex.strterm = 0;
    if (func & STR_FUNC_REGEXP) {
        set_yylval_num(regx_options(p));
        dispatch_scan_event(p, tREGEXP_END);
        SET_LEX_STATE(EXPR_END);
        return tREGEXP_END;
    }
    if ((func & STR_FUNC_LABEL) && IS_LABEL_SUFFIX(0)) {
        nextc(p);
        SET_LEX_STATE(EXPR_ARG|EXPR_LABELED);
        return tLABEL_END;
    }
    SET_LEX_STATE(EXPR_END);
    return tSTRING_END;
}

static enum yytokentype
parse_string(struct parser_params *p, rb_strterm_literal_t *quote)
{
    int func = quote->func;
    int term = quote->term;
    int paren = quote->paren;
    int c, space = 0;
    rb_encoding *enc = p->enc;
    rb_encoding *base_enc = 0;
    rb_parser_string_t *lit;

    if (func & STR_FUNC_TERM) {
        if (func & STR_FUNC_QWORDS) nextc(p); /* delayed term */
        SET_LEX_STATE(EXPR_END);
        xfree(p->lex.strterm);
        p->lex.strterm = 0;
        return func & STR_FUNC_REGEXP ? tREGEXP_END : tSTRING_END;
    }
    c = nextc(p);
    if ((func & STR_FUNC_QWORDS) && ISSPACE(c)) {
        while (c != '\n' && ISSPACE(c = nextc(p)));
        space = 1;
    }
    if (func & STR_FUNC_LIST) {
        quote->func &= ~STR_FUNC_LIST;
        space = 1;
    }
    if (c == term && !quote->nest) {
        if (func & STR_FUNC_QWORDS) {
            quote->func |= STR_FUNC_TERM;
            pushback(p, c); /* dispatch the term at tSTRING_END */
            add_delayed_token(p, p->lex.ptok, p->lex.pcur);
            return ' ';
        }
        return parser_string_term(p, func);
    }
    if (space) {
        if (!ISSPACE(c)) pushback(p, c);
        add_delayed_token(p, p->lex.ptok, p->lex.pcur);
        return ' ';
    }
    newtok(p);
    if ((func & STR_FUNC_EXPAND) && c == '#') {
        enum yytokentype t = parser_peek_variable_name(p);
        if (t) return t;
        tokadd(p, '#');
        c = nextc(p);
    }
    pushback(p, c);
    if (tokadd_string(p, func, term, paren, &quote->nest,
                      &enc, &base_enc) == -1) {
        if (p->eofp) {
#ifndef RIPPER
# define unterminated_literal(mesg) yyerror0(mesg)
#else
# define unterminated_literal(mesg) compile_error(p, mesg)
#endif
            literal_flush(p, p->lex.pcur);
            if (func & STR_FUNC_QWORDS) {
                /* no content to add, bailing out here */
                unterminated_literal("unterminated list meets end of file");
                xfree(p->lex.strterm);
                p->lex.strterm = 0;
                return tSTRING_END;
            }
            if (func & STR_FUNC_REGEXP) {
                unterminated_literal("unterminated regexp meets end of file");
            }
            else {
                unterminated_literal("unterminated string meets end of file");
            }
            quote->func |= STR_FUNC_TERM;
        }
    }

    tokfix(p);
    lit = STR_NEW3(tok(p), toklen(p), enc, func);
    set_yylval_str(lit);
    flush_string_content(p, enc, 0);

    return tSTRING_CONTENT;
}

static enum yytokentype
heredoc_identifier(struct parser_params *p)
{
    /*
     * term_len is length of `<<"END"` except `END`,
     * in this case term_len is 4 (<, <, " and ").
     */
    long len, offset = p->lex.pcur - p->lex.pbeg;
    int c = nextc(p), term, func = 0, quote = 0;
    enum yytokentype token = tSTRING_BEG;
    int indent = 0;

    if (c == '-') {
        c = nextc(p);
        func = STR_FUNC_INDENT;
        offset++;
    }
    else if (c == '~') {
        c = nextc(p);
        func = STR_FUNC_INDENT;
        offset++;
        indent = INT_MAX;
    }
    switch (c) {
      case '\'':
        func |= str_squote; goto quoted;
      case '"':
        func |= str_dquote; goto quoted;
      case '`':
        token = tXSTRING_BEG;
        func |= str_xquote; goto quoted;

      quoted:
        quote++;
        offset++;
        term = c;
        len = 0;
        while ((c = nextc(p)) != term) {
            if (c == -1 || c == '\r' || c == '\n') {
                yyerror0("unterminated here document identifier");
                return -1;
            }
        }
        break;

      default:
        if (!parser_is_identchar(p)) {
            pushback(p, c);
            if (func & STR_FUNC_INDENT) {
                pushback(p, indent > 0 ? '~' : '-');
            }
            return 0;
        }
        func |= str_dquote;
        do {
            int n = parser_precise_mbclen(p, p->lex.pcur-1);
            if (n < 0) return 0;
            p->lex.pcur += --n;
        } while ((c = nextc(p)) != -1 && parser_is_identchar(p));
        pushback(p, c);
        break;
    }

    len = p->lex.pcur - (p->lex.pbeg + offset) - quote;
    if ((unsigned long)len >= HERETERM_LENGTH_MAX)
        yyerror0("too long here document identifier");
    dispatch_scan_event(p, tHEREDOC_BEG);
    lex_goto_eol(p);

    p->lex.strterm = new_heredoc(p);
    rb_strterm_heredoc_t *here = &p->lex.strterm->u.heredoc;
    here->offset = offset;
    here->sourceline = p->ruby_sourceline;
    here->length = (unsigned)len;
    here->quote = quote;
    here->func = func;
    here->lastline = p->lex.lastline;

    token_flush(p);
    p->heredoc_indent = indent;
    p->heredoc_line_indent = 0;
    return token;
}

static void
heredoc_restore(struct parser_params *p, rb_strterm_heredoc_t *here)
{
    rb_parser_string_t *line;
    rb_strterm_t *term = p->lex.strterm;

    p->lex.strterm = 0;
    line = here->lastline;
    p->lex.lastline = line;
    p->lex.pbeg = PARSER_STRING_PTR(line);
    p->lex.pend = p->lex.pbeg + PARSER_STRING_LEN(line);
    p->lex.pcur = p->lex.pbeg + here->offset + here->length + here->quote;
    p->lex.ptok = p->lex.pbeg + here->offset - here->quote;
    p->heredoc_end = p->ruby_sourceline;
    p->ruby_sourceline = (int)here->sourceline;
    if (p->eofp) p->lex.nextline = AFTER_HEREDOC_WITHOUT_TERMINTOR;
    p->eofp = 0;
    xfree(term);
}

static int
dedent_string_column(const char *str, long len, int width)
{
    int i, col = 0;

    for (i = 0; i < len && col < width; i++) {
        if (str[i] == ' ') {
            col++;
        }
        else if (str[i] == '\t') {
            int n = TAB_WIDTH * (col / TAB_WIDTH + 1);
            if (n > width) break;
            col = n;
        }
        else {
            break;
        }
    }

    return i;
}

static int
dedent_string(struct parser_params *p, rb_parser_string_t *string, int width)
{
    char *str;
    long len;
    int i;

    len = PARSER_STRING_LEN(string);
    str = PARSER_STRING_PTR(string);

    i = dedent_string_column(str, len, width);
    if (!i) return 0;

    rb_parser_str_modify(string);
    str = PARSER_STRING_PTR(string);
    if (PARSER_STRING_LEN(string) != len)
        rb_fatal("literal string changed: %s", PARSER_STRING_PTR(string));
    MEMMOVE(str, str + i, char, len - i);
    rb_parser_str_set_len(p, string, len - i);
    return i;
}

static NODE *
heredoc_dedent(struct parser_params *p, NODE *root)
{
    NODE *node, *str_node, *prev_node;
    int indent = p->heredoc_indent;
    rb_parser_string_t *prev_lit = 0;

    if (indent <= 0) return root;
    if (!root) return root;

    prev_node = node = str_node = root;
    if (nd_type_p(root, NODE_LIST)) str_node = RNODE_LIST(root)->nd_head;

    while (str_node) {
        rb_parser_string_t *lit = RNODE_STR(str_node)->string;
        if (nd_fl_newline(str_node)) {
            dedent_string(p, lit, indent);
        }
        if (!prev_lit) {
            prev_lit = lit;
        }
        else if (!literal_concat0(p, prev_lit, lit)) {
            return 0;
        }
        else {
            NODE *end = RNODE_LIST(node)->as.nd_end;
            node = RNODE_LIST(prev_node)->nd_next = RNODE_LIST(node)->nd_next;
            if (!node) {
                if (nd_type_p(prev_node, NODE_DSTR))
                    nd_set_type(prev_node, NODE_STR);
                break;
            }
            RNODE_LIST(node)->as.nd_end = end;
            goto next_str;
        }

        str_node = 0;
        while ((nd_type_p(node, NODE_LIST) || nd_type_p(node, NODE_DSTR)) && (node = RNODE_LIST(prev_node = node)->nd_next) != 0) {
          next_str:
            if (!nd_type_p(node, NODE_LIST)) break;
            if ((str_node = RNODE_LIST(node)->nd_head) != 0) {
                enum node_type type = nd_type(str_node);
                if (type == NODE_STR || type == NODE_DSTR) break;
                prev_lit = 0;
                str_node = 0;
            }
        }
    }
    return root;
}

static int
whole_match_p(struct parser_params *p, const char *eos, long len, int indent)
{
    const char *beg = p->lex.pbeg;
    const char *ptr = p->lex.pend;

    if (ptr - beg < len) return FALSE;
    if (ptr > beg && ptr[-1] == '\n') {
        if (--ptr > beg && ptr[-1] == '\r') --ptr;
        if (ptr - beg < len) return FALSE;
    }
    if (strncmp(eos, ptr -= len, len)) return FALSE;
    if (indent) {
        while (beg < ptr && ISSPACE(*beg)) beg++;
    }
    return beg == ptr;
}

static int
word_match_p(struct parser_params *p, const char *word, long len)
{
    if (strncmp(p->lex.pcur, word, len)) return 0;
    if (lex_eol_n_p(p, len)) return 1;
    int c = (unsigned char)p->lex.pcur[len];
    if (ISSPACE(c)) return 1;
    switch (c) {
      case '\0': case '\004': case '\032': return 1;
    }
    return 0;
}

#define NUM_SUFFIX_R   (1<<0)
#define NUM_SUFFIX_I   (1<<1)
#define NUM_SUFFIX_ALL 3

static int
number_literal_suffix(struct parser_params *p, int mask)
{
    int c, result = 0;
    const char *lastp = p->lex.pcur;

    while ((c = nextc(p)) != -1) {
        if ((mask & NUM_SUFFIX_I) && c == 'i') {
            result |= (mask & NUM_SUFFIX_I);
            mask &= ~NUM_SUFFIX_I;
            /* r after i, rational of complex is disallowed */
            mask &= ~NUM_SUFFIX_R;
            continue;
        }
        if ((mask & NUM_SUFFIX_R) && c == 'r') {
            result |= (mask & NUM_SUFFIX_R);
            mask &= ~NUM_SUFFIX_R;
            continue;
        }
        if (!ISASCII(c) || ISALPHA(c) || c == '_') {
            p->lex.pcur = lastp;
            literal_flush(p, p->lex.pcur);
            return 0;
        }
        pushback(p, c);
        break;
    }
    return result;
}

static enum yytokentype
set_number_literal(struct parser_params *p, enum yytokentype type, int suffix, int base, int seen_point)
{
    enum rb_numeric_type numeric_type = integer_literal;

    if (type == tFLOAT) {
        numeric_type = float_literal;
    }

    if (suffix & NUM_SUFFIX_R) {
        type = tRATIONAL;
        numeric_type = rational_literal;
    }
    if (suffix & NUM_SUFFIX_I) {
        type = tIMAGINARY;
    }

    switch (type) {
      case tINTEGER:
        set_yylval_node(NEW_INTEGER(strdup(tok(p)), base, &_cur_loc));
        break;
      case tFLOAT:
        set_yylval_node(NEW_FLOAT(strdup(tok(p)), &_cur_loc));
        break;
      case tRATIONAL:
        set_yylval_node(NEW_RATIONAL(strdup(tok(p)), base, seen_point, &_cur_loc));
        break;
      case tIMAGINARY:
        set_yylval_node(NEW_IMAGINARY(strdup(tok(p)), base, seen_point, numeric_type, &_cur_loc));
        (void)numeric_type;     /* for ripper */
        break;
      default:
        rb_bug("unexpected token: %d", type);
    }
    SET_LEX_STATE(EXPR_END);
    return type;
}

#define dispatch_heredoc_end(p) parser_dispatch_heredoc_end(p, __LINE__)
static void
parser_dispatch_heredoc_end(struct parser_params *p, int line)
{
    if (has_delayed_token(p))
        dispatch_delayed_token(p, tSTRING_CONTENT);

#ifdef RIPPER
    VALUE str = STR_NEW(p->lex.ptok, p->lex.pend - p->lex.ptok);
    ripper_dispatch1(p, ripper_token2eventid(tHEREDOC_END), str);
#else
    if (p->keep_tokens) {
        rb_parser_string_t *str = rb_parser_encoding_string_new(p, p->lex.ptok, p->lex.pend - p->lex.ptok, p->enc);
        RUBY_SET_YYLLOC_OF_HEREDOC_END(*p->yylloc);
        parser_append_tokens(p, str, tHEREDOC_END, line);
    }
#endif

    RUBY_SET_YYLLOC_FROM_STRTERM_HEREDOC(*p->yylloc);
    lex_goto_eol(p);
    token_flush(p);
}

static enum yytokentype
here_document(struct parser_params *p, rb_strterm_heredoc_t *here)
{
    int c, func, indent = 0;
    const char *eos, *ptr, *ptr_end;
    long len;
    rb_parser_string_t *str = 0;
    rb_encoding *enc = p->enc;
    rb_encoding *base_enc = 0;
    int bol;
#ifdef RIPPER
    VALUE s_value;
#endif

    eos = PARSER_STRING_PTR(here->lastline) + here->offset;
    len = here->length;
    indent = (func = here->func) & STR_FUNC_INDENT;

    if ((c = nextc(p)) == -1) {
      error:
#ifdef RIPPER
        if (!has_delayed_token(p)) {
            dispatch_scan_event(p, tSTRING_CONTENT);
        }
        else {
            if ((len = p->lex.pcur - p->lex.ptok) > 0) {
                if (!(func & STR_FUNC_REGEXP)) {
                    int cr = ENC_CODERANGE_UNKNOWN;
                    rb_str_coderange_scan_restartable(p->lex.ptok, p->lex.pcur, enc, &cr);
                    if (cr != ENC_CODERANGE_7BIT &&
                        rb_is_usascii_enc(p->enc) &&
                        enc != rb_utf8_encoding()) {
                        enc = rb_ascii8bit_encoding();
                    }
                }
                rb_parser_enc_str_buf_cat(p, p->delayed.token, p->lex.ptok, len, enc);
            }
            dispatch_delayed_token(p, tSTRING_CONTENT);
        }
        lex_goto_eol(p);
#endif
        heredoc_restore(p, &p->lex.strterm->u.heredoc);
        compile_error(p, "can't find string \"%.*s\" anywhere before EOF",
                      (int)len, eos);
        token_flush(p);
        SET_LEX_STATE(EXPR_END);
        return tSTRING_END;
    }
    bol = was_bol(p);
    if (!bol) {
        /* not beginning of line, cannot be the terminator */
    }
    else if (p->heredoc_line_indent == -1) {
        /* `heredoc_line_indent == -1` means
         * - "after an interpolation in the same line", or
         * - "in a continuing line"
         */
        p->heredoc_line_indent = 0;
    }
    else if (whole_match_p(p, eos, len, indent)) {
        dispatch_heredoc_end(p);
      restore:
        heredoc_restore(p, &p->lex.strterm->u.heredoc);
        token_flush(p);
        SET_LEX_STATE(EXPR_END);
        return tSTRING_END;
    }

    if (!(func & STR_FUNC_EXPAND)) {
        do {
            ptr = PARSER_STRING_PTR(p->lex.lastline);
            ptr_end = p->lex.pend;
            if (ptr_end > ptr) {
                switch (ptr_end[-1]) {
                  case '\n':
                    if (--ptr_end == ptr || ptr_end[-1] != '\r') {
                        ptr_end++;
                        break;
                    }
                  case '\r':
                    --ptr_end;
                }
            }

            if (p->heredoc_indent > 0) {
                long i = 0;
                while (ptr + i < ptr_end && parser_update_heredoc_indent(p, ptr[i]))
                    i++;
                p->heredoc_line_indent = 0;
            }

            if (str)
                parser_str_cat(str, ptr, ptr_end - ptr);
            else
                str = rb_parser_encoding_string_new(p, ptr, ptr_end - ptr, enc);
            if (!lex_eol_ptr_p(p, ptr_end)) parser_str_cat_cstr(str, "\n");
            lex_goto_eol(p);
            if (p->heredoc_indent > 0) {
                goto flush_str;
            }
            if (nextc(p) == -1) {
                if (str) {
                    rb_parser_string_free(p, str);
                    str = 0;
                }
                goto error;
            }
        } while (!whole_match_p(p, eos, len, indent));
    }
    else {
        /*	int mb = ENC_CODERANGE_7BIT, *mbp = &mb;*/
        newtok(p);
        if (c == '#') {
            enum yytokentype t = parser_peek_variable_name(p);
            if (p->heredoc_line_indent != -1) {
                if (p->heredoc_indent > p->heredoc_line_indent) {
                    p->heredoc_indent = p->heredoc_line_indent;
                }
                p->heredoc_line_indent = -1;
            }
            if (t) return t;
            tokadd(p, '#');
            c = nextc(p);
        }
        do {
            pushback(p, c);
            enc = p->enc;
            if ((c = tokadd_string(p, func, '\n', 0, NULL, &enc, &base_enc)) == -1) {
                if (p->eofp) goto error;
                goto restore;
            }
            if (c != '\n') {
                if (c == '\\') p->heredoc_line_indent = -1;
              flush:
                str = STR_NEW3(tok(p), toklen(p), enc, func);
              flush_str:
                set_yylval_str(str);
#ifndef RIPPER
                if (bol) nd_set_fl_newline(yylval.node);
#endif
                flush_string_content(p, enc, 0);
                return tSTRING_CONTENT;
            }
            tokadd(p, nextc(p));
            if (p->heredoc_indent > 0) {
                lex_goto_eol(p);
                goto flush;
            }
            /*	    if (mbp && mb == ENC_CODERANGE_UNKNOWN) mbp = 0;*/
            if ((c = nextc(p)) == -1) goto error;
        } while (!whole_match_p(p, eos, len, indent));
        str = STR_NEW3(tok(p), toklen(p), enc, func);
    }
    dispatch_heredoc_end(p);
    heredoc_restore(p, &p->lex.strterm->u.heredoc);
    token_flush(p);
    p->lex.strterm = NEW_STRTERM(func | STR_FUNC_TERM, 0, 0);
#ifdef RIPPER
    /* Preserve s_value for set_yylval_str */
    s_value = p->s_value;
#endif
    set_yylval_str(str);
#ifdef RIPPER
    set_parser_s_value(s_value);
#endif

#ifndef RIPPER
    if (bol) nd_set_fl_newline(yylval.node);
#endif
    return tSTRING_CONTENT;
}

#include "lex.c"

static int
arg_ambiguous(struct parser_params *p, char c)
{
#ifndef RIPPER
    if (c == '/') {
        rb_warning1("ambiguity between regexp and two divisions: wrap regexp in parentheses or add a space after '%c' operator", WARN_I(c));
    }
    else {
        rb_warning1("ambiguous first argument; put parentheses or a space even after '%c' operator", WARN_I(c));
    }
#else
    dispatch1(arg_ambiguous, rb_usascii_str_new(&c, 1));
#endif
    return TRUE;
}

/* returns true value if formal argument error;
 * Qtrue, or error message if ripper */
static VALUE
formal_argument_error(struct parser_params *p, ID id)
{
    switch (id_type(id)) {
      case ID_LOCAL:
        break;
#ifndef RIPPER
# define ERR(mesg) (yyerror0(mesg), Qtrue)
#else
# define ERR(mesg) WARN_S(mesg)
#endif
      case ID_CONST:
        return ERR("formal argument cannot be a constant");
      case ID_INSTANCE:
        return ERR("formal argument cannot be an instance variable");
      case ID_GLOBAL:
        return ERR("formal argument cannot be a global variable");
      case ID_CLASS:
        return ERR("formal argument cannot be a class variable");
      default:
        return ERR("formal argument must be local variable");
#undef ERR
    }
    shadowing_lvar(p, id);

    return Qfalse;
}

static int
lvar_defined(struct parser_params *p, ID id)
{
    return (dyna_in_block(p) && dvar_defined(p, id)) || local_id(p, id);
}

/* emacsen -*- hack */
static long
parser_encode_length(struct parser_params *p, const char *name, long len)
{
    long nlen;

    if (len > 5 && name[nlen = len - 5] == '-') {
        if (rb_memcicmp(name + nlen + 1, "unix", 4) == 0)
            return nlen;
    }
    if (len > 4 && name[nlen = len - 4] == '-') {
        if (rb_memcicmp(name + nlen + 1, "dos", 3) == 0)
            return nlen;
        if (rb_memcicmp(name + nlen + 1, "mac", 3) == 0 &&
            !(len == 8 && rb_memcicmp(name, "utf8-mac", len) == 0))
            /* exclude UTF8-MAC because the encoding named "UTF8" doesn't exist in Ruby */
            return nlen;
    }
    return len;
}

static void
parser_set_encode(struct parser_params *p, const char *name)
{
    rb_encoding *enc;
    VALUE excargs[3];
    int idx = 0;

    const char *wrong = 0;
    switch (*name) {
      case 'e': case 'E': wrong = "external"; break;
      case 'i': case 'I': wrong = "internal"; break;
      case 'f': case 'F': wrong = "filesystem"; break;
      case 'l': case 'L': wrong = "locale"; break;
    }
    if (wrong && STRCASECMP(name, wrong) == 0) goto unknown;
    idx = rb_enc_find_index(name);
    if (idx < 0) {
      unknown:
        excargs[1] = rb_sprintf("unknown encoding name: %s", name);
      error:
        excargs[0] = rb_eArgError;
        excargs[2] = rb_make_backtrace();
        rb_ary_unshift(excargs[2], rb_sprintf("%"PRIsVALUE":%d", p->ruby_sourcefile_string, p->ruby_sourceline));
        VALUE exc = rb_make_exception(3, excargs);
        ruby_show_error_line(p, exc, &(YYLTYPE)RUBY_INIT_YYLLOC(), p->ruby_sourceline, p->lex.lastline);

        rb_ast_free(p->ast);
        p->ast = NULL;

        rb_exc_raise(exc);
    }
    enc = rb_enc_from_index(idx);
    if (!rb_enc_asciicompat(enc)) {
        excargs[1] = rb_sprintf("%s is not ASCII compatible", rb_enc_name(enc));
        goto error;
    }
    p->enc = enc;
#ifndef RIPPER
    if (p->debug_lines) {
        long i;
        for (i = 0; i < p->debug_lines->len; i++) {
            rb_parser_enc_associate(p, p->debug_lines->data[i], enc);
        }
    }
#endif
}

static bool
comment_at_top(struct parser_params *p)
{
    if (p->token_seen) return false;
    return (p->line_count == (p->has_shebang ? 2 : 1));
}

typedef long (*rb_magic_comment_length_t)(struct parser_params *p, const char *name, long len);
typedef void (*rb_magic_comment_setter_t)(struct parser_params *p, const char *name, const char *val);

static int parser_invalid_pragma_value(struct parser_params *p, const char *name, const char *val);

static void
magic_comment_encoding(struct parser_params *p, const char *name, const char *val)
{
    if (!comment_at_top(p)) {
        return;
    }
    parser_set_encode(p, val);
}

static int
parser_get_bool(struct parser_params *p, const char *name, const char *val)
{
    switch (*val) {
      case 't': case 'T':
        if (STRCASECMP(val, "true") == 0) {
            return TRUE;
        }
        break;
      case 'f': case 'F':
        if (STRCASECMP(val, "false") == 0) {
            return FALSE;
        }
        break;
    }
    return parser_invalid_pragma_value(p, name, val);
}

static int
parser_invalid_pragma_value(struct parser_params *p, const char *name, const char *val)
{
    rb_warning2("invalid value for %s: %s", WARN_S(name), WARN_S(val));
    return -1;
}

static void
parser_set_token_info(struct parser_params *p, const char *name, const char *val)
{
    int b = parser_get_bool(p, name, val);
    if (b >= 0) p->token_info_enabled = b;
}

static void
parser_set_frozen_string_literal(struct parser_params *p, const char *name, const char *val)
{
    int b;

    if (p->token_seen) {
        rb_warning1("'%s' is ignored after any tokens", WARN_S(name));
        return;
    }

    b = parser_get_bool(p, name, val);
    if (b < 0) return;

    p->frozen_string_literal = b;
}

static void
parser_set_shareable_constant_value(struct parser_params *p, const char *name, const char *val)
{
    for (const char *s = p->lex.pbeg, *e = p->lex.pcur; s < e; ++s) {
        if (*s == ' ' || *s == '\t') continue;
        if (*s == '#') break;
        rb_warning1("'%s' is ignored unless in comment-only line", WARN_S(name));
        return;
    }

    switch (*val) {
      case 'n': case 'N':
        if (STRCASECMP(val, "none") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_none;
            return;
        }
        break;
      case 'l': case 'L':
        if (STRCASECMP(val, "literal") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_literal;
            return;
        }
        break;
      case 'e': case 'E':
        if (STRCASECMP(val, "experimental_copy") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_copy;
            return;
        }
        if (STRCASECMP(val, "experimental_everything") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_everything;
            return;
        }
        break;
    }
    parser_invalid_pragma_value(p, name, val);
}

# if WARN_PAST_SCOPE
static void
parser_set_past_scope(struct parser_params *p, const char *name, const char *val)
{
    int b = parser_get_bool(p, name, val);
    if (b >= 0) p->past_scope_enabled = b;
}
# endif

struct magic_comment {
    const char *name;
    rb_magic_comment_setter_t func;
    rb_magic_comment_length_t length;
};

static const struct magic_comment magic_comments[] = {
    {"coding", magic_comment_encoding, parser_encode_length},
    {"encoding", magic_comment_encoding, parser_encode_length},
    {"frozen_string_literal", parser_set_frozen_string_literal},
    {"shareable_constant_value", parser_set_shareable_constant_value},
    {"warn_indent", parser_set_token_info},
# if WARN_PAST_SCOPE
    {"warn_past_scope", parser_set_past_scope},
# endif
};

static const char *
magic_comment_marker(const char *str, long len)
{
    long i = 2;

    while (i < len) {
        switch (str[i]) {
          case '-':
            if (str[i-1] == '*' && str[i-2] == '-') {
                return str + i + 1;
            }
            i += 2;
            break;
          case '*':
            if (i + 1 >= len) return 0;
            if (str[i+1] != '-') {
                i += 4;
            }
            else if (str[i-1] != '-') {
                i += 2;
            }
            else {
                return str + i + 2;
            }
            break;
          default:
            i += 3;
            break;
        }
    }
    return 0;
}

static int
parser_magic_comment(struct parser_params *p, const char *str, long len)
{
    int indicator = 0;
    VALUE name = 0, val = 0;
    const char *beg, *end, *vbeg, *vend;
#define str_copy(_s, _p, _n) ((_s) \
        ? (void)(rb_str_resize((_s), (_n)), \
           MEMCPY(RSTRING_PTR(_s), (_p), char, (_n)), (_s)) \
        : (void)((_s) = STR_NEW((_p), (_n))))

    if (len <= 7) return FALSE;
    if (!!(beg = magic_comment_marker(str, len))) {
        if (!(end = magic_comment_marker(beg, str + len - beg)))
            return FALSE;
        indicator = TRUE;
        str = beg;
        len = end - beg - 3;
    }

    /* %r"([^\\s\'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*" */
    while (len > 0) {
        const struct magic_comment *mc = magic_comments;
        char *s;
        int i;
        long n = 0;

        for (; len > 0 && *str; str++, --len) {
            switch (*str) {
              case '\'': case '"': case ':': case ';':
                continue;
            }
            if (!ISSPACE(*str)) break;
        }
        for (beg = str; len > 0; str++, --len) {
            switch (*str) {
              case '\'': case '"': case ':': case ';':
                break;
              default:
                if (ISSPACE(*str)) break;
                continue;
            }
            break;
        }
        for (end = str; len > 0 && ISSPACE(*str); str++, --len);
        if (!len) break;
        if (*str != ':') {
            if (!indicator) return FALSE;
            continue;
        }

        do str++; while (--len > 0 && ISSPACE(*str));
        if (!len) break;
        const char *tok_beg = str;
        if (*str == '"') {
            for (vbeg = ++str; --len > 0 && *str != '"'; str++) {
                if (*str == '\\') {
                    --len;
                    ++str;
                }
            }
            vend = str;
            if (len) {
                --len;
                ++str;
            }
        }
        else {
            for (vbeg = str; len > 0 && *str != '"' && *str != ';' && !ISSPACE(*str); --len, str++);
            vend = str;
        }
        const char *tok_end = str;
        if (indicator) {
            while (len > 0 && (*str == ';' || ISSPACE(*str))) --len, str++;
        }
        else {
            while (len > 0 && (ISSPACE(*str))) --len, str++;
            if (len) return FALSE;
        }

        n = end - beg;
        str_copy(name, beg, n);
        s = RSTRING_PTR(name);
        for (i = 0; i < n; ++i) {
            if (s[i] == '-') s[i] = '_';
        }
        do {
            if (STRNCASECMP(mc->name, s, n) == 0 && !mc->name[n]) {
                n = vend - vbeg;
                if (mc->length) {
                    n = (*mc->length)(p, vbeg, n);
                }
                str_copy(val, vbeg, n);
                p->lex.ptok = tok_beg;
                p->lex.pcur = tok_end;
                (*mc->func)(p, mc->name, RSTRING_PTR(val));
                break;
            }
        } while (++mc < magic_comments + numberof(magic_comments));
#ifdef RIPPER
        str_copy(val, vbeg, vend - vbeg);
        dispatch2(magic_comment, name, val);
#endif
    }

    return TRUE;
}

static void
set_file_encoding(struct parser_params *p, const char *str, const char *send)
{
    int sep = 0;
    const char *beg = str;
    VALUE s;

    for (;;) {
        if (send - str <= 6) return;
        switch (str[6]) {
          case 'C': case 'c': str += 6; continue;
          case 'O': case 'o': str += 5; continue;
          case 'D': case 'd': str += 4; continue;
          case 'I': case 'i': str += 3; continue;
          case 'N': case 'n': str += 2; continue;
          case 'G': case 'g': str += 1; continue;
          case '=': case ':':
            sep = 1;
            str += 6;
            break;
          default:
            str += 6;
            if (ISSPACE(*str)) break;
            continue;
        }
        if (STRNCASECMP(str-6, "coding", 6) == 0) break;
        sep = 0;
    }
    for (;;) {
        do {
            if (++str >= send) return;
        } while (ISSPACE(*str));
        if (sep) break;
        if (*str != '=' && *str != ':') return;
        sep = 1;
        str++;
    }
    beg = str;
    while ((*str == '-' || *str == '_' || ISALNUM(*str)) && ++str < send);
    s = rb_str_new(beg, parser_encode_length(p, beg, str - beg));
    p->lex.ptok = beg;
    p->lex.pcur = str;
    parser_set_encode(p, RSTRING_PTR(s));
    rb_str_resize(s, 0);
}

static void
parser_prepare(struct parser_params *p)
{
    int c = nextc0(p, FALSE);
    p->token_info_enabled = !compile_for_eval && RTEST(ruby_verbose);
    switch (c) {
      case '#':
        if (peek(p, '!')) p->has_shebang = 1;
        break;
      case 0xef:		/* UTF-8 BOM marker */
        if (!lex_eol_n_p(p, 2) &&
            (unsigned char)p->lex.pcur[0] == 0xbb &&
            (unsigned char)p->lex.pcur[1] == 0xbf) {
            p->enc = rb_utf8_encoding();
            p->lex.pcur += 2;
#ifndef RIPPER
            if (p->debug_lines) {
                rb_parser_string_set_encoding(p->lex.lastline, p->enc);
            }
#endif
            p->lex.pbeg = p->lex.pcur;
            token_flush(p);
            return;
        }
        break;
      case -1:   /* end of script. */
        return;
    }
    pushback(p, c);
    p->enc = rb_parser_str_get_encoding(p->lex.lastline);
}

#ifndef RIPPER
#define ambiguous_operator(tok, op, syn) ( \
    rb_warning0("'"op"' after local variable or literal is interpreted as binary operator"), \
    rb_warning0("even though it seems like "syn""))
#else
#define ambiguous_operator(tok, op, syn) \
    dispatch2(operator_ambiguous, TOKEN2VAL(tok), rb_str_new_cstr(syn))
#endif
#define warn_balanced(tok, op, syn) ((void) \
    (!IS_lex_state_for(last_state, EXPR_CLASS|EXPR_DOT|EXPR_FNAME|EXPR_ENDFN) && \
     space_seen && !ISSPACE(c) && \
     (ambiguous_operator(tok, op, syn), 0)), \
     (enum yytokentype)(tok))

static enum yytokentype
no_digits(struct parser_params *p)
{
    yyerror0("numeric literal without digits");
    if (peek(p, '_')) nextc(p);
    /* dummy 0, for tUMINUS_NUM at numeric */
    return set_number_literal(p, tINTEGER, 0, 10, 0);
}

static enum yytokentype
parse_numeric(struct parser_params *p, int c)
{
    int is_float, seen_point, seen_e, nondigit;
    int suffix;

    is_float = seen_point = seen_e = nondigit = 0;
    SET_LEX_STATE(EXPR_END);
    newtok(p);
    if (c == '-' || c == '+') {
        tokadd(p, c);
        c = nextc(p);
    }
    if (c == '0') {
        int start = toklen(p);
        c = nextc(p);
        if (c == 'x' || c == 'X') {
            /* hexadecimal */
            c = nextc(p);
            if (c != -1 && ISXDIGIT(c)) {
                do {
                    if (c == '_') {
                        if (nondigit) break;
                        nondigit = c;
                        continue;
                    }
                    if (!ISXDIGIT(c)) break;
                    nondigit = 0;
                    tokadd(p, c);
                } while ((c = nextc(p)) != -1);
            }
            pushback(p, c);
            tokfix(p);
            if (toklen(p) == start) {
                return no_digits(p);
            }
            else if (nondigit) goto trailing_uc;
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 16, 0);
        }
        if (c == 'b' || c == 'B') {
            /* binary */
            c = nextc(p);
            if (c == '0' || c == '1') {
                do {
                    if (c == '_') {
                        if (nondigit) break;
                        nondigit = c;
                        continue;
                    }
                    if (c != '0' && c != '1') break;
                    nondigit = 0;
                    tokadd(p, c);
                } while ((c = nextc(p)) != -1);
            }
            pushback(p, c);
            tokfix(p);
            if (toklen(p) == start) {
                return no_digits(p);
            }
            else if (nondigit) goto trailing_uc;
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 2, 0);
        }
        if (c == 'd' || c == 'D') {
            /* decimal */
            c = nextc(p);
            if (c != -1 && ISDIGIT(c)) {
                do {
                    if (c == '_') {
                        if (nondigit) break;
                        nondigit = c;
                        continue;
                    }
                    if (!ISDIGIT(c)) break;
                    nondigit = 0;
                    tokadd(p, c);
                } while ((c = nextc(p)) != -1);
            }
            pushback(p, c);
            tokfix(p);
            if (toklen(p) == start) {
                return no_digits(p);
            }
            else if (nondigit) goto trailing_uc;
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 10, 0);
        }
        if (c == '_') {
            /* 0_0 */
            goto octal_number;
        }
        if (c == 'o' || c == 'O') {
            /* prefixed octal */
            c = nextc(p);
            if (c == -1 || c == '_' || !ISDIGIT(c)) {
                tokfix(p);
                return no_digits(p);
            }
        }
        if (c >= '0' && c <= '7') {
            /* octal */
          octal_number:
            do {
                if (c == '_') {
                    if (nondigit) break;
                    nondigit = c;
                    continue;
                }
                if (c < '0' || c > '9') break;
                if (c > '7') goto invalid_octal;
                nondigit = 0;
                tokadd(p, c);
            } while ((c = nextc(p)) != -1);
            if (toklen(p) > start) {
                pushback(p, c);
                tokfix(p);
                if (nondigit) goto trailing_uc;
                suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
                return set_number_literal(p, tINTEGER, suffix, 8, 0);
            }
            if (nondigit) {
                pushback(p, c);
                goto trailing_uc;
            }
        }
        if (c > '7' && c <= '9') {
          invalid_octal:
            yyerror0("Invalid octal digit");
        }
        else if (c == '.' || c == 'e' || c == 'E') {
            tokadd(p, '0');
        }
        else {
            pushback(p, c);
            tokfix(p);
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 10, 0);
        }
    }

    for (;;) {
        switch (c) {
          case '0': case '1': case '2': case '3': case '4':
          case '5': case '6': case '7': case '8': case '9':
            nondigit = 0;
            tokadd(p, c);
            break;

          case '.':
            if (nondigit) goto trailing_uc;
            if (seen_point || seen_e) {
                goto decode_num;
            }
            else {
                int c0 = nextc(p);
                if (c0 == -1 || !ISDIGIT(c0)) {
                    pushback(p, c0);
                    goto decode_num;
                }
                c = c0;
            }
            seen_point = toklen(p);
            tokadd(p, '.');
            tokadd(p, c);
            is_float++;
            nondigit = 0;
            break;

          case 'e':
          case 'E':
            if (nondigit) {
                pushback(p, c);
                c = nondigit;
                goto decode_num;
            }
            if (seen_e) {
                goto decode_num;
            }
            nondigit = c;
            c = nextc(p);
            if (c != '-' && c != '+' && !ISDIGIT(c)) {
                pushback(p, c);
                c = nondigit;
                nondigit = 0;
                goto decode_num;
            }
            tokadd(p, nondigit);
            seen_e++;
            is_float++;
            tokadd(p, c);
            nondigit = (c == '-' || c == '+') ? c : 0;
            break;

          case '_':	/* `_' in number just ignored */
            if (nondigit) goto decode_num;
            nondigit = c;
            break;

          default:
            goto decode_num;
        }
        c = nextc(p);
    }

  decode_num:
    pushback(p, c);
    if (nondigit) {
      trailing_uc:
        literal_flush(p, p->lex.pcur - 1);
        YYLTYPE loc = RUBY_INIT_YYLLOC();
        compile_error(p, "trailing '%c' in number", nondigit);
        parser_show_error_line(p, &loc);
    }
    tokfix(p);
    if (is_float) {
        enum yytokentype type = tFLOAT;

        suffix = number_literal_suffix(p, seen_e ? NUM_SUFFIX_I : NUM_SUFFIX_ALL);
        if (suffix & NUM_SUFFIX_R) {
            type = tRATIONAL;
        }
        else {
            strtod(tok(p), 0);
            if (errno == ERANGE) {
                rb_warning1("Float %s out of range", WARN_S(tok(p)));
                errno = 0;
            }
        }
        return set_number_literal(p, type, suffix, 0, seen_point);
    }
    suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
    return set_number_literal(p, tINTEGER, suffix, 10, 0);
}

static enum yytokentype
parse_qmark(struct parser_params *p, int space_seen)
{
    rb_encoding *enc;
    register int c;
    rb_parser_string_t *lit;

    if (IS_END()) {
        SET_LEX_STATE(EXPR_VALUE);
        return '?';
    }
    c = nextc(p);
    if (c == -1) {
        compile_error(p, "incomplete character syntax");
        return 0;
    }
    if (rb_enc_isspace(c, p->enc)) {
        if (!IS_ARG()) {
            int c2 = escaped_control_code(c);
            if (c2) {
                WARN_SPACE_CHAR(c2, "?");
            }
        }
      ternary:
        pushback(p, c);
        SET_LEX_STATE(EXPR_VALUE);
        return '?';
    }
    newtok(p);
    enc = p->enc;
    if (!parser_isascii(p)) {
        if (tokadd_mbchar(p, c) == -1) return 0;
    }
    else if ((rb_enc_isalnum(c, p->enc) || c == '_') &&
             !lex_eol_p(p) && is_identchar(p, p->lex.pcur, p->lex.pend, p->enc)) {
        if (space_seen) {
            const char *start = p->lex.pcur - 1, *ptr = start;
            do {
                int n = parser_precise_mbclen(p, ptr);
                if (n < 0) return -1;
                ptr += n;
            } while (!lex_eol_ptr_p(p, ptr) && is_identchar(p, ptr, p->lex.pend, p->enc));
            rb_warn2("'?' just followed by '%.*s' is interpreted as" \
                     " a conditional operator, put a space after '?'",
                     WARN_I((int)(ptr - start)), WARN_S_L(start, (ptr - start)));
        }
        goto ternary;
    }
    else if (c == '\\') {
        if (peek(p, 'u')) {
            nextc(p);
            enc = rb_utf8_encoding();
            tokadd_utf8(p, &enc, -1, 0, 0);
        }
        else if (!ISASCII(c = peekc(p)) && c != -1) {
            nextc(p);
            if (tokadd_mbchar(p, c) == -1) return 0;
        }
        else {
            c = read_escape(p, 0, p->lex.pcur - rb_strlen_lit("?\\"));
            tokadd(p, c);
        }
    }
    else {
        tokadd(p, c);
    }
    tokfix(p);
    lit = STR_NEW3(tok(p), toklen(p), enc, 0);
    set_yylval_str(lit);
    SET_LEX_STATE(EXPR_END);
    return tCHAR;
}

static enum yytokentype
parse_percent(struct parser_params *p, const int space_seen, const enum lex_state_e last_state)
{
    register int c;
    const char *ptok = p->lex.pcur;

    if (IS_BEG()) {
        int term;
        int paren;

        c = nextc(p);
      quotation:
        if (c == -1) goto unterminated;
        if (!ISALNUM(c)) {
            term = c;
            if (!ISASCII(c)) goto unknown;
            c = 'Q';
        }
        else {
            term = nextc(p);
            if (rb_enc_isalnum(term, p->enc) || !parser_isascii(p)) {
              unknown:
                pushback(p, term);
                c = parser_precise_mbclen(p, p->lex.pcur);
                if (c < 0) return 0;
                p->lex.pcur += c;
                yyerror0("unknown type of %string");
                return 0;
            }
        }
        if (term == -1) {
          unterminated:
            compile_error(p, "unterminated quoted string meets end of file");
            return 0;
        }
        paren = term;
        if (term == '(') term = ')';
        else if (term == '[') term = ']';
        else if (term == '{') term = '}';
        else if (term == '<') term = '>';
        else paren = 0;

        p->lex.ptok = ptok-1;
        switch (c) {
          case 'Q':
            p->lex.strterm = NEW_STRTERM(str_dquote, term, paren);
            return tSTRING_BEG;

          case 'q':
            p->lex.strterm = NEW_STRTERM(str_squote, term, paren);
            return tSTRING_BEG;

          case 'W':
            p->lex.strterm = NEW_STRTERM(str_dword, term, paren);
            return tWORDS_BEG;

          case 'w':
            p->lex.strterm = NEW_STRTERM(str_sword, term, paren);
            return tQWORDS_BEG;

          case 'I':
            p->lex.strterm = NEW_STRTERM(str_dword, term, paren);
            return tSYMBOLS_BEG;

          case 'i':
            p->lex.strterm = NEW_STRTERM(str_sword, term, paren);
            return tQSYMBOLS_BEG;

          case 'x':
            p->lex.strterm = NEW_STRTERM(str_xquote, term, paren);
            return tXSTRING_BEG;

          case 'r':
            p->lex.strterm = NEW_STRTERM(str_regexp, term, paren);
            return tREGEXP_BEG;

          case 's':
            p->lex.strterm = NEW_STRTERM(str_ssym, term, paren);
            SET_LEX_STATE(EXPR_FNAME|EXPR_FITEM);
            return tSYMBEG;

          default:
            yyerror0("unknown type of %string");
            return 0;
        }
    }
    if ((c = nextc(p)) == '=') {
        set_yylval_id('%');
        SET_LEX_STATE(EXPR_BEG);
        return tOP_ASGN;
    }
    if (IS_SPCARG(c) || (IS_lex_state(EXPR_FITEM) && c == 's')) {
        goto quotation;
    }
    SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
    pushback(p, c);
    return warn_balanced('%', "%%", "string literal");
}

static int
tokadd_ident(struct parser_params *p, int c)
{
    do {
        if (tokadd_mbchar(p, c) == -1) return -1;
        c = nextc(p);
    } while (parser_is_identchar(p));
    pushback(p, c);
    return 0;
}

static ID
tokenize_ident(struct parser_params *p)
{
    ID ident = TOK_INTERN();

    set_yylval_name(ident);

    return ident;
}

static int
parse_numvar(struct parser_params *p)
{
    size_t len;
    int overflow;
    unsigned long n = ruby_scan_digits(tok(p)+1, toklen(p)-1, 10, &len, &overflow);
    const unsigned long nth_ref_max =
        ((FIXNUM_MAX < INT_MAX) ? FIXNUM_MAX : INT_MAX) >> 1;
    /* NTH_REF is left-shifted to be ORed with back-ref flag and
     * turned into a Fixnum, in compile.c */

    if (overflow || n > nth_ref_max) {
        /* compile_error()? */
        rb_warn1("'%s' is too big for a number variable, always nil", WARN_S(tok(p)));
        return 0;		/* $0 is $PROGRAM_NAME, not NTH_REF */
    }
    else {
        return (int)n;
    }
}

static enum yytokentype
parse_gvar(struct parser_params *p, const enum lex_state_e last_state)
{
    const char *ptr = p->lex.pcur;
    register int c;

    SET_LEX_STATE(EXPR_END);
    p->lex.ptok = ptr - 1; /* from '$' */
    newtok(p);
    c = nextc(p);
    switch (c) {
      case '_':		/* $_: last read line string */
        c = nextc(p);
        if (parser_is_identchar(p)) {
            tokadd(p, '$');
            tokadd(p, '_');
            break;
        }
        pushback(p, c);
        c = '_';
        /* fall through */
      case '~': 	/* $~: match-data */
      case '*': 	/* $*: argv */
      case '$': 	/* $$: pid */
      case '?': 	/* $?: last status */
      case '!': 	/* $!: error string */
      case '@': 	/* $@: error position */
      case '/': 	/* $/: input record separator */
      case '\\':	/* $\: output record separator */
      case ';': 	/* $;: field separator */
      case ',': 	/* $,: output field separator */
      case '.': 	/* $.: last read line number */
      case '=': 	/* $=: ignorecase */
      case ':': 	/* $:: load path */
      case '<': 	/* $<: default input handle */
      case '>': 	/* $>: default output handle */
      case '\"':	/* $": already loaded files */
        tokadd(p, '$');
        tokadd(p, c);
        goto gvar;

      case '-':
        tokadd(p, '$');
        tokadd(p, c);
        c = nextc(p);
        if (parser_is_identchar(p)) {
            if (tokadd_mbchar(p, c) == -1) return 0;
        }
        else {
            pushback(p, c);
            pushback(p, '-');
            return '$';
        }
      gvar:
        tokenize_ident(p);
        return tGVAR;

      case '&': 	/* $&: last match */
      case '`': 	/* $`: string before last match */
      case '\'':	/* $': string after last match */
      case '+': 	/* $+: string matches last paren. */
        if (IS_lex_state_for(last_state, EXPR_FNAME)) {
            tokadd(p, '$');
            tokadd(p, c);
            goto gvar;
        }
        set_yylval_node(NEW_BACK_REF(c, &_cur_loc));
        return tBACK_REF;

      case '1': case '2': case '3':
      case '4': case '5': case '6':
      case '7': case '8': case '9':
        tokadd(p, '$');
        do {
            tokadd(p, c);
            c = nextc(p);
        } while (c != -1 && ISDIGIT(c));
        pushback(p, c);
        if (IS_lex_state_for(last_state, EXPR_FNAME)) goto gvar;
        tokfix(p);
        c = parse_numvar(p);
        set_yylval_node(NEW_NTH_REF(c, &_cur_loc));
        return tNTH_REF;

      default:
        if (!parser_is_identchar(p)) {
            YYLTYPE loc = RUBY_INIT_YYLLOC();
            if (c == -1 || ISSPACE(c)) {
                compile_error(p, "'$' without identifiers is not allowed as a global variable name");
            }
            else {
                pushback(p, c);
                compile_error(p, "'$%c' is not allowed as a global variable name", c);
            }
            parser_show_error_line(p, &loc);
            set_yylval_noname();
            return tGVAR;
        }
        /* fall through */
      case '0':
        tokadd(p, '$');
    }

    if (tokadd_ident(p, c)) return 0;
    SET_LEX_STATE(EXPR_END);
    if (VALID_SYMNAME_P(tok(p), toklen(p), p->enc, ID_GLOBAL)) {
        tokenize_ident(p);
    }
    else {
        compile_error(p, "'%.*s' is not allowed as a global variable name", toklen(p), tok(p));
        set_yylval_noname();
    }
    return tGVAR;
}

static bool
parser_numbered_param(struct parser_params *p, int n)
{
    if (n < 0) return false;

    if (DVARS_TERMINAL_P(p->lvtbl->args) || DVARS_TERMINAL_P(p->lvtbl->args->prev)) {
        return false;
    }
    if (p->max_numparam == ORDINAL_PARAM) {
        compile_error(p, "ordinary parameter is defined");
        return false;
    }
    struct vtable *args = p->lvtbl->args;
    if (p->max_numparam < n) {
        p->max_numparam = n;
    }
    while (n > args->pos) {
        vtable_add(args, NUMPARAM_IDX_TO_ID(args->pos+1));
    }
    return true;
}

static enum yytokentype
parse_atmark(struct parser_params *p, const enum lex_state_e last_state)
{
    const char *ptr = p->lex.pcur;
    enum yytokentype result = tIVAR;
    register int c = nextc(p);
    YYLTYPE loc;

    p->lex.ptok = ptr - 1; /* from '@' */
    newtok(p);
    tokadd(p, '@');
    if (c == '@') {
        result = tCVAR;
        tokadd(p, '@');
        c = nextc(p);
    }
    SET_LEX_STATE(IS_lex_state_for(last_state, EXPR_FNAME) ? EXPR_ENDFN : EXPR_END);
    if (c == -1 || !parser_is_identchar(p)) {
        pushback(p, c);
        RUBY_SET_YYLLOC(loc);
        if (result == tIVAR) {
            compile_error(p, "'@' without identifiers is not allowed as an instance variable name");
        }
        else {
            compile_error(p, "'@@' without identifiers is not allowed as a class variable name");
        }
        parser_show_error_line(p, &loc);
        set_yylval_noname();
        SET_LEX_STATE(EXPR_END);
        return result;
    }
    else if (ISDIGIT(c)) {
        pushback(p, c);
        RUBY_SET_YYLLOC(loc);
        if (result == tIVAR) {
            compile_error(p, "'@%c' is not allowed as an instance variable name", c);
        }
        else {
            compile_error(p, "'@@%c' is not allowed as a class variable name", c);
        }
        parser_show_error_line(p, &loc);
        set_yylval_noname();
        SET_LEX_STATE(EXPR_END);
        return result;
    }

    if (tokadd_ident(p, c)) return 0;
    tokenize_ident(p);
    return result;
}

static enum yytokentype
parse_ident(struct parser_params *p, int c, int cmd_state)
{
    enum yytokentype result;
    bool is_ascii = true;
    const enum lex_state_e last_state = p->lex.state;
    ID ident;
    int enforce_keyword_end = 0;

    do {
        if (!ISASCII(c)) is_ascii = false;
        if (tokadd_mbchar(p, c) == -1) return 0;
        c = nextc(p);
    } while (parser_is_identchar(p));
    if ((c == '!' || c == '?') && !peek(p, '=')) {
        result = tFID;
        tokadd(p, c);
    }
    else if (c == '=' && IS_lex_state(EXPR_FNAME) &&
             (!peek(p, '~') && !peek(p, '>') && (!peek(p, '=') || (peek_n(p, '>', 1))))) {
        result = tIDENTIFIER;
        tokadd(p, c);
    }
    else {
        result = tCONSTANT;	/* assume provisionally */
        pushback(p, c);
    }
    tokfix(p);

    if (IS_LABEL_POSSIBLE()) {
        if (IS_LABEL_SUFFIX(0)) {
            SET_LEX_STATE(EXPR_ARG|EXPR_LABELED);
            nextc(p);
            tokenize_ident(p);
            return tLABEL;
        }
    }

#ifndef RIPPER
    if (peek_end_expect_token_locations(p)) {
        const rb_code_position_t *end_pos;
        int lineno, column;
        int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);

        end_pos = peek_end_expect_token_locations(p)->pos;
        lineno = end_pos->lineno;
        column = end_pos->column;

        if (p->debug) {
            rb_parser_printf(p, "enforce_keyword_end check. current: (%d, %d), peek: (%d, %d)\n",
                                p->ruby_sourceline, beg_pos, lineno, column);
        }

        if ((p->ruby_sourceline > lineno) && (beg_pos <= column)) {
            const struct kwtable *kw;

            if ((IS_lex_state(EXPR_DOT)) && (kw = rb_reserved_word(tok(p), toklen(p))) && (kw && kw->id[0] == keyword_end)) {
                if (p->debug) rb_parser_printf(p, "enforce_keyword_end is enabled\n");
                enforce_keyword_end = 1;
            }
        }
    }
#endif

    if (is_ascii && (!IS_lex_state(EXPR_DOT) || enforce_keyword_end)) {
        const struct kwtable *kw;

        /* See if it is a reserved word.  */
        kw = rb_reserved_word(tok(p), toklen(p));
        if (kw) {
            enum lex_state_e state = p->lex.state;
            if (IS_lex_state_for(state, EXPR_FNAME)) {
                SET_LEX_STATE(EXPR_ENDFN);
                set_yylval_name(rb_intern2(tok(p), toklen(p)));
                return kw->id[0];
            }
            SET_LEX_STATE(kw->state);
            if (IS_lex_state(EXPR_BEG)) {
                p->command_start = TRUE;
            }
            if (kw->id[0] == keyword_do) {
                if (lambda_beginning_p()) {
                    p->lex.lpar_beg = -1; /* make lambda_beginning_p() == FALSE in the body of "-> do ... end" */
                    return keyword_do_LAMBDA;
                }
                if (COND_P()) return keyword_do_cond;
                if (CMDARG_P() && !IS_lex_state_for(state, EXPR_CMDARG))
                    return keyword_do_block;
                return keyword_do;
            }
            if (IS_lex_state_for(state, (EXPR_BEG | EXPR_LABELED | EXPR_CLASS)))
                return kw->id[0];
            else {
                if (kw->id[0] != kw->id[1])
                    SET_LEX_STATE(EXPR_BEG | EXPR_LABEL);
                return kw->id[1];
            }
        }
    }

    if (IS_lex_state(EXPR_BEG_ANY | EXPR_ARG_ANY | EXPR_DOT)) {
        if (cmd_state) {
            SET_LEX_STATE(EXPR_CMDARG);
        }
        else {
            SET_LEX_STATE(EXPR_ARG);
        }
    }
    else if (p->lex.state == EXPR_FNAME) {
        SET_LEX_STATE(EXPR_ENDFN);
    }
    else {
        SET_LEX_STATE(EXPR_END);
    }

    ident = tokenize_ident(p);
    if (result == tCONSTANT && is_local_id(ident)) result = tIDENTIFIER;
    if (!IS_lex_state_for(last_state, EXPR_DOT|EXPR_FNAME) &&
        (result == tIDENTIFIER) && /* not EXPR_FNAME, not attrasgn */
        (lvar_defined(p, ident) || NUMPARAM_ID_P(ident))) {
        SET_LEX_STATE(EXPR_END|EXPR_LABEL);
    }
    return result;
}

static void
warn_cr(struct parser_params *p)
{
    if (!p->cr_seen) {
        p->cr_seen = TRUE;
        /* carried over with p->lex.nextline for nextc() */
        rb_warn0("encountered \\r in middle of line, treated as a mere space");
    }
}

static enum yytokentype
parser_yylex(struct parser_params *p)
{
    register int c;
    int space_seen = 0;
    int cmd_state;
    int label;
    enum lex_state_e last_state;
    int fallthru = FALSE;
    int token_seen = p->token_seen;

    if (p->lex.strterm) {
        if (strterm_is_heredoc(p->lex.strterm)) {
            token_flush(p);
            return here_document(p, &p->lex.strterm->u.heredoc);
        }
        else {
            token_flush(p);
            return parse_string(p, &p->lex.strterm->u.literal);
        }
    }
    cmd_state = p->command_start;
    p->command_start = FALSE;
    p->token_seen = TRUE;
#ifndef RIPPER
    token_flush(p);
#endif
  retry:
    last_state = p->lex.state;
    switch (c = nextc(p)) {
      case '\0':		/* NUL */
      case '\004':		/* ^D */
      case '\032':		/* ^Z */
      case -1:			/* end of script. */
        p->eofp = 1;
#ifndef RIPPER
        if (p->end_expect_token_locations) {
            pop_end_expect_token_locations(p);
            RUBY_SET_YYLLOC_OF_DUMMY_END(*p->yylloc);
            return tDUMNY_END;
        }
#endif
        /* Set location for end-of-input because dispatch_scan_event is not called. */
        RUBY_SET_YYLLOC(*p->yylloc);
        return END_OF_INPUT;

        /* white spaces */
      case '\r':
        warn_cr(p);
        /* fall through */
      case ' ': case '\t': case '\f':
      case '\13': /* '\v' */
        space_seen = 1;
        while ((c = nextc(p))) {
            switch (c) {
              case '\r':
                warn_cr(p);
                /* fall through */
              case ' ': case '\t': case '\f':
              case '\13': /* '\v' */
                break;
              default:
                goto outofloop;
            }
        }
      outofloop:
        pushback(p, c);
        dispatch_scan_event(p, tSP);
#ifndef RIPPER
        token_flush(p);
#endif
        goto retry;

      case '#':		/* it's a comment */
        p->token_seen = token_seen;
        const char *const pcur = p->lex.pcur, *const ptok = p->lex.ptok;
        /* no magic_comment in shebang line */
        if (!parser_magic_comment(p, p->lex.pcur, p->lex.pend - p->lex.pcur)) {
            if (comment_at_top(p)) {
                set_file_encoding(p, p->lex.pcur, p->lex.pend);
            }
        }
        p->lex.pcur = pcur, p->lex.ptok = ptok;
        lex_goto_eol(p);
        dispatch_scan_event(p, tCOMMENT);
        fallthru = TRUE;
        /* fall through */
      case '\n':
        p->token_seen = token_seen;
        rb_parser_string_t *prevline = p->lex.lastline;
        c = (IS_lex_state(EXPR_BEG|EXPR_CLASS|EXPR_FNAME|EXPR_DOT) &&
             !IS_lex_state(EXPR_LABELED));
        if (c || IS_lex_state_all(EXPR_ARG|EXPR_LABELED)) {
            if (!fallthru) {
                dispatch_scan_event(p, tIGNORED_NL);
            }
            fallthru = FALSE;
            if (!c && p->ctxt.in_kwarg) {
                goto normal_newline;
            }
            goto retry;
        }
        while (1) {
            switch (c = nextc(p)) {
              case ' ': case '\t': case '\f': case '\r':
              case '\13': /* '\v' */
                space_seen = 1;
                break;
              case '#':
                pushback(p, c);
                if (space_seen) {
                    dispatch_scan_event(p, tSP);
                    token_flush(p);
                }
                goto retry;
              case '&':
              case '.': {
                dispatch_delayed_token(p, tIGNORED_NL);
                if (peek(p, '.') == (c == '&')) {
                    pushback(p, c);
                    dispatch_scan_event(p, tSP);
                    goto retry;
                }
              }
              default:
                p->ruby_sourceline--;
                p->lex.nextline = p->lex.lastline;
                set_lastline(p, prevline);
              case -1:		/* EOF no decrement*/
                if (c == -1 && space_seen) {
                    dispatch_scan_event(p, tSP);
                }
                lex_goto_eol(p);
                if (c != -1) {
                    token_flush(p);
                    RUBY_SET_YYLLOC(*p->yylloc);
                }
                goto normal_newline;
            }
        }
      normal_newline:
        p->command_start = TRUE;
        SET_LEX_STATE(EXPR_BEG);
        return '\n';

      case '*':
        if ((c = nextc(p)) == '*') {
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idPow);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            if (IS_SPCARG(c)) {
                rb_warning0("'**' interpreted as argument prefix");
                c = tDSTAR;
            }
            else if (IS_BEG()) {
                c = tDSTAR;
            }
            else {
                c = warn_balanced((enum ruby_method_ids)tPOW, "**", "argument prefix");
            }
        }
        else {
            if (c == '=') {
                set_yylval_id('*');
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            if (IS_SPCARG(c)) {
                rb_warning0("'*' interpreted as argument prefix");
                c = tSTAR;
            }
            else if (IS_BEG()) {
                c = tSTAR;
            }
            else {
                c = warn_balanced('*', "*", "argument prefix");
            }
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        return c;

      case '!':
        c = nextc(p);
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
            if (c == '@') {
                return '!';
            }
        }
        else {
            SET_LEX_STATE(EXPR_BEG);
        }
        if (c == '=') {
            return tNEQ;
        }
        if (c == '~') {
            return tNMATCH;
        }
        pushback(p, c);
        return '!';

      case '=':
        if (was_bol(p)) {
            /* skip embedded rd document */
            if (word_match_p(p, "begin", 5)) {
                int first_p = TRUE;

                lex_goto_eol(p);
                dispatch_scan_event(p, tEMBDOC_BEG);
                for (;;) {
                    lex_goto_eol(p);
                    if (!first_p) {
                        dispatch_scan_event(p, tEMBDOC);
                    }
                    first_p = FALSE;
                    c = nextc(p);
                    if (c == -1) {
                        compile_error(p, "embedded document meets end of file");
                        return END_OF_INPUT;
                    }
                    if (c == '=' && word_match_p(p, "end", 3)) {
                        break;
                    }
                    pushback(p, c);
                }
                lex_goto_eol(p);
                dispatch_scan_event(p, tEMBDOC_END);
                goto retry;
            }
        }

        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        if ((c = nextc(p)) == '=') {
            if ((c = nextc(p)) == '=') {
                return tEQQ;
            }
            pushback(p, c);
            return tEQ;
        }
        if (c == '~') {
            return tMATCH;
        }
        else if (c == '>') {
            return tASSOC;
        }
        pushback(p, c);
        return '=';

      case '<':
        c = nextc(p);
        if (c == '<' &&
            !IS_lex_state(EXPR_DOT | EXPR_CLASS) &&
            !IS_END() &&
            (!IS_ARG() || IS_lex_state(EXPR_LABELED) || space_seen)) {
            enum  yytokentype token = heredoc_identifier(p);
            if (token) return token < 0 ? 0 : token;
        }
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
        }
        else {
            if (IS_lex_state(EXPR_CLASS))
                p->command_start = TRUE;
            SET_LEX_STATE(EXPR_BEG);
        }
        if (c == '=') {
            if ((c = nextc(p)) == '>') {
                return tCMP;
            }
            pushback(p, c);
            return tLEQ;
        }
        if (c == '<') {
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idLTLT);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            return warn_balanced((enum ruby_method_ids)tLSHFT, "<<", "here document");
        }
        pushback(p, c);
        return '<';

      case '>':
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        if ((c = nextc(p)) == '=') {
            return tGEQ;
        }
        if (c == '>') {
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idGTGT);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            return tRSHFT;
        }
        pushback(p, c);
        return '>';

      case '"':
        label = (IS_LABEL_POSSIBLE() ? str_label : 0);
        p->lex.strterm = NEW_STRTERM(str_dquote | label, '"', 0);
        p->lex.ptok = p->lex.pcur-1;
        return tSTRING_BEG;

      case '`':
        if (IS_lex_state(EXPR_FNAME)) {
            SET_LEX_STATE(EXPR_ENDFN);
            return c;
        }
        if (IS_lex_state(EXPR_DOT)) {
            if (cmd_state)
                SET_LEX_STATE(EXPR_CMDARG);
            else
                SET_LEX_STATE(EXPR_ARG);
            return c;
        }
        p->lex.strterm = NEW_STRTERM(str_xquote, '`', 0);
        return tXSTRING_BEG;

      case '\'':
        label = (IS_LABEL_POSSIBLE() ? str_label : 0);
        p->lex.strterm = NEW_STRTERM(str_squote | label, '\'', 0);
        p->lex.ptok = p->lex.pcur-1;
        return tSTRING_BEG;

      case '?':
        return parse_qmark(p, space_seen);

      case '&':
        if ((c = nextc(p)) == '&') {
            SET_LEX_STATE(EXPR_BEG);
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idANDOP);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            return tANDOP;
        }
        else if (c == '=') {
            set_yylval_id('&');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        else if (c == '.') {
            set_yylval_id(idANDDOT);
            SET_LEX_STATE(EXPR_DOT);
            return tANDDOT;
        }
        pushback(p, c);
        if (IS_SPCARG(c)) {
            if ((c != ':') ||
                (c = peekc_n(p, 1)) == -1 ||
                !(c == '\'' || c == '"' ||
                  is_identchar(p, (p->lex.pcur+1), p->lex.pend, p->enc))) {
                rb_warning0("'&' interpreted as argument prefix");
            }
            c = tAMPER;
        }
        else if (IS_BEG()) {
            c = tAMPER;
        }
        else {
            c = warn_balanced('&', "&", "argument prefix");
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        return c;

      case '|':
        if ((c = nextc(p)) == '|') {
            SET_LEX_STATE(EXPR_BEG);
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idOROP);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            if (IS_lex_state_for(last_state, EXPR_BEG)) {
                c = '|';
                pushback(p, '|');
                return c;
            }
            return tOROP;
        }
        if (c == '=') {
            set_yylval_id('|');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG|EXPR_LABEL);
        pushback(p, c);
        return '|';

      case '+':
        c = nextc(p);
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
            if (c == '@') {
                return tUPLUS;
            }
            pushback(p, c);
            return '+';
        }
        if (c == '=') {
            set_yylval_id('+');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        if (IS_BEG() || (IS_SPCARG(c) && arg_ambiguous(p, '+'))) {
            SET_LEX_STATE(EXPR_BEG);
            pushback(p, c);
            if (c != -1 && ISDIGIT(c)) {
                return parse_numeric(p, '+');
            }
            return tUPLUS;
        }
        SET_LEX_STATE(EXPR_BEG);
        pushback(p, c);
        return warn_balanced('+', "+", "unary operator");

      case '-':
        c = nextc(p);
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
            if (c == '@') {
                return tUMINUS;
            }
            pushback(p, c);
            return '-';
        }
        if (c == '=') {
            set_yylval_id('-');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        if (c == '>') {
            SET_LEX_STATE(EXPR_ENDFN);
            yylval.num = p->lex.lpar_beg;
            p->lex.lpar_beg = p->lex.paren_nest;
            return tLAMBDA;
        }
        if (IS_BEG() || (IS_SPCARG(c) && arg_ambiguous(p, '-'))) {
            SET_LEX_STATE(EXPR_BEG);
            pushback(p, c);
            if (c != -1 && ISDIGIT(c)) {
                return tUMINUS_NUM;
            }
            return tUMINUS;
        }
        SET_LEX_STATE(EXPR_BEG);
        pushback(p, c);
        return warn_balanced('-', "-", "unary operator");

      case '.': {
        int is_beg = IS_BEG();
        SET_LEX_STATE(EXPR_BEG);
        if ((c = nextc(p)) == '.') {
            if ((c = nextc(p)) == '.') {
                if (p->ctxt.in_argdef || IS_LABEL_POSSIBLE()) {
                    SET_LEX_STATE(EXPR_ENDARG);
                    return tBDOT3;
                }
                if (p->lex.paren_nest == 0 && looking_at_eol_p(p)) {
                    rb_warn0("... at EOL, should be parenthesized?");
                }
                return is_beg ? tBDOT3 : tDOT3;
            }
            pushback(p, c);
            return is_beg ? tBDOT2 : tDOT2;
        }
        pushback(p, c);
        if (c != -1 && ISDIGIT(c)) {
            char prev = p->lex.pcur-1 > p->lex.pbeg ? *(p->lex.pcur-2) : 0;
            parse_numeric(p, '.');
            if (ISDIGIT(prev)) {
                yyerror0("unexpected fraction part after numeric literal");
            }
            else {
                yyerror0("no .<digit> floating literal anymore; put 0 before dot");
            }
            SET_LEX_STATE(EXPR_END);
            p->lex.ptok = p->lex.pcur;
            goto retry;
        }
        set_yylval_id('.');
        SET_LEX_STATE(EXPR_DOT);
        return '.';
      }

      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
        return parse_numeric(p, c);

      case ')':
        COND_POP();
        CMDARG_POP();
        SET_LEX_STATE(EXPR_ENDFN);
        p->lex.paren_nest--;
        return c;

      case ']':
        COND_POP();
        CMDARG_POP();
        SET_LEX_STATE(EXPR_END);
        p->lex.paren_nest--;
        return c;

      case '}':
        /* tSTRING_DEND does COND_POP and CMDARG_POP in the yacc's rule */
        if (!p->lex.brace_nest--) return tSTRING_DEND;
        COND_POP();
        CMDARG_POP();
        SET_LEX_STATE(EXPR_END);
        p->lex.paren_nest--;
        return c;

      case ':':
        c = nextc(p);
        if (c == ':') {
            if (IS_BEG() || IS_lex_state(EXPR_CLASS) || IS_SPCARG(-1)) {
                SET_LEX_STATE(EXPR_BEG);
                return tCOLON3;
            }
            set_yylval_id(idCOLON2);
            SET_LEX_STATE(EXPR_DOT);
            return tCOLON2;
        }
        if (IS_END() || ISSPACE(c) || c == '#') {
            pushback(p, c);
            c = warn_balanced(':', ":", "symbol literal");
            SET_LEX_STATE(EXPR_BEG);
            return c;
        }
        switch (c) {
          case '\'':
            p->lex.strterm = NEW_STRTERM(str_ssym, c, 0);
            break;
          case '"':
            p->lex.strterm = NEW_STRTERM(str_dsym, c, 0);
            break;
          default:
            pushback(p, c);
            break;
        }
        SET_LEX_STATE(EXPR_FNAME);
        return tSYMBEG;

      case '/':
        if (IS_BEG()) {
            p->lex.strterm = NEW_STRTERM(str_regexp, '/', 0);
            return tREGEXP_BEG;
        }
        if ((c = nextc(p)) == '=') {
            set_yylval_id('/');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        pushback(p, c);
        if (IS_SPCARG(c)) {
            arg_ambiguous(p, '/');
            p->lex.strterm = NEW_STRTERM(str_regexp, '/', 0);
            return tREGEXP_BEG;
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        return warn_balanced('/', "/", "regexp literal");

      case '^':
        if ((c = nextc(p)) == '=') {
            set_yylval_id('^');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        pushback(p, c);
        return '^';

      case ';':
        SET_LEX_STATE(EXPR_BEG);
        p->command_start = TRUE;
        return ';';

      case ',':
        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        return ',';

      case '~':
        if (IS_AFTER_OPERATOR()) {
            if ((c = nextc(p)) != '@') {
                pushback(p, c);
            }
            SET_LEX_STATE(EXPR_ARG);
        }
        else {
            SET_LEX_STATE(EXPR_BEG);
        }
        return '~';

      case '(':
        if (IS_BEG()) {
            c = tLPAREN;
        }
        else if (!space_seen) {
            /* foo( ... ) => method call, no ambiguity */
        }
        else if (IS_ARG() || IS_lex_state_all(EXPR_END|EXPR_LABEL)) {
            c = tLPAREN_ARG;
        }
        else if (IS_lex_state(EXPR_ENDFN) && !lambda_beginning_p()) {
            rb_warning0("parentheses after method name is interpreted as "
                        "an argument list, not a decomposed argument");
        }
        p->lex.paren_nest++;
        COND_PUSH(0);
        CMDARG_PUSH(0);
        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        return c;

      case '[':
        p->lex.paren_nest++;
        if (IS_AFTER_OPERATOR()) {
            if ((c = nextc(p)) == ']') {
                p->lex.paren_nest--;
                SET_LEX_STATE(EXPR_ARG);
                if ((c = nextc(p)) == '=') {
                    return tASET;
                }
                pushback(p, c);
                return tAREF;
            }
            pushback(p, c);
            SET_LEX_STATE(EXPR_ARG|EXPR_LABEL);
            return '[';
        }
        else if (IS_BEG()) {
            c = tLBRACK;
        }
        else if (IS_ARG() && (space_seen || IS_lex_state(EXPR_LABELED))) {
            c = tLBRACK;
        }
        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        COND_PUSH(0);
        CMDARG_PUSH(0);
        return c;

      case '{':
        ++p->lex.brace_nest;
        if (lambda_beginning_p())
            c = tLAMBEG;
        else if (IS_lex_state(EXPR_LABELED))
            c = tLBRACE;      /* hash */
        else if (IS_lex_state(EXPR_ARG_ANY | EXPR_END | EXPR_ENDFN))
            c = '{';          /* block (primary) */
        else if (IS_lex_state(EXPR_ENDARG))
            c = tLBRACE_ARG;  /* block (expr) */
        else
            c = tLBRACE;      /* hash */
        if (c != tLBRACE) {
            p->command_start = TRUE;
            SET_LEX_STATE(EXPR_BEG);
        }
        else {
            SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        }
        ++p->lex.paren_nest;  /* after lambda_beginning_p() */
        COND_PUSH(0);
        CMDARG_PUSH(0);
        return c;

      case '\\':
        c = nextc(p);
        if (c == '\n') {
            space_seen = 1;
            dispatch_scan_event(p, tSP);
            goto retry; /* skip \\n */
        }
        if (c == ' ') return tSP;
        if (ISSPACE(c)) return c;
        pushback(p, c);
        return '\\';

      case '%':
        return parse_percent(p, space_seen, last_state);

      case '$':
        return parse_gvar(p, last_state);

      case '@':
        return parse_atmark(p, last_state);

      case '_':
        if (was_bol(p) && whole_match_p(p, "__END__", 7, 0)) {
            p->ruby__end__seen = 1;
            p->eofp = 1;
#ifdef RIPPER
            lex_goto_eol(p);
            dispatch_scan_event(p, k__END__);
#endif
            return END_OF_INPUT;
        }
        newtok(p);
        break;

      default:
        if (!parser_is_identchar(p)) {
            compile_error(p, "Invalid char '\\x%02X' in expression", c);
            token_flush(p);
            goto retry;
        }

        newtok(p);
        break;
    }

    return parse_ident(p, c, cmd_state);
}

static enum yytokentype
yylex(YYSTYPE *lval, YYLTYPE *yylloc, struct parser_params *p)
{
    enum yytokentype t;

    p->lval = lval;
    lval->node = 0;
    p->yylloc = yylloc;

    t = parser_yylex(p);

    if (has_delayed_token(p))
        dispatch_delayed_token(p, t);
    else if (t != END_OF_INPUT)
        dispatch_scan_event(p, t);

    return t;
}

#define LVAR_USED ((ID)1 << (sizeof(ID) * CHAR_BIT - 1))

static NODE*
node_new_internal(struct parser_params *p, enum node_type type, size_t size, size_t alignment)
{
    NODE *n = rb_ast_newnode(p->ast, type, size, alignment);

    rb_node_init(n, type);
    return n;
}

static NODE *
nd_set_loc(NODE *nd, const YYLTYPE *loc)
{
    nd->nd_loc = *loc;
    nd_set_line(nd, loc->beg_pos.lineno);
    return nd;
}

static NODE*
node_newnode(struct parser_params *p, enum node_type type, size_t size, size_t alignment, const rb_code_location_t *loc)
{
    NODE *n = node_new_internal(p, type, size, alignment);

    nd_set_loc(n, loc);
    nd_set_node_id(n, parser_get_node_id(p));
    return n;
}

#define NODE_NEWNODE(node_type, type, loc) (type *)(node_newnode(p, node_type, sizeof(type), RUBY_ALIGNOF(type), loc))

static rb_node_scope_t *
rb_node_scope_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc)
{
    rb_ast_id_table_t *nd_tbl;
    nd_tbl = local_tbl(p);
    rb_node_scope_t *n = NODE_NEWNODE(NODE_SCOPE, rb_node_scope_t, loc);
    n->nd_tbl = nd_tbl;
    n->nd_body = nd_body;
    n->nd_args = nd_args;

    return n;
}

static rb_node_scope_t *
rb_node_scope_new2(struct parser_params *p, rb_ast_id_table_t *nd_tbl, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_scope_t *n = NODE_NEWNODE(NODE_SCOPE, rb_node_scope_t, loc);
    n->nd_tbl = nd_tbl;
    n->nd_body = nd_body;
    n->nd_args = nd_args;

    return n;
}

static rb_node_defn_t *
rb_node_defn_new(struct parser_params *p, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc)
{
    rb_node_defn_t *n = NODE_NEWNODE(NODE_DEFN, rb_node_defn_t, loc);
    n->nd_mid = nd_mid;
    n->nd_defn = nd_defn;

    return n;
}

static rb_node_defs_t *
rb_node_defs_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc)
{
    rb_node_defs_t *n = NODE_NEWNODE(NODE_DEFS, rb_node_defs_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_defn = nd_defn;

    return n;
}

static rb_node_block_t *
rb_node_block_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_block_t *n = NODE_NEWNODE(NODE_BLOCK, rb_node_block_t, loc);
    n->nd_head = nd_head;
    n->nd_end = (NODE *)n;
    n->nd_next = 0;

    return n;
}

static rb_node_for_t *
rb_node_for_new(struct parser_params *p, NODE *nd_iter, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_for_t *n = NODE_NEWNODE(NODE_FOR, rb_node_for_t, loc);
    n->nd_body = nd_body;
    n->nd_iter = nd_iter;

    return n;
}

static rb_node_for_masgn_t *
rb_node_for_masgn_new(struct parser_params *p, NODE *nd_var, const YYLTYPE *loc)
{
    rb_node_for_masgn_t *n = NODE_NEWNODE(NODE_FOR_MASGN, rb_node_for_masgn_t, loc);
    n->nd_var = nd_var;

    return n;
}

static rb_node_retry_t *
rb_node_retry_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_retry_t *n = NODE_NEWNODE(NODE_RETRY, rb_node_retry_t, loc);

    return n;
}

static rb_node_begin_t *
rb_node_begin_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_begin_t *n = NODE_NEWNODE(NODE_BEGIN, rb_node_begin_t, loc);
    n->nd_body = nd_body;

    return n;
}

static rb_node_rescue_t *
rb_node_rescue_new(struct parser_params *p, NODE *nd_head, NODE *nd_resq, NODE *nd_else, const YYLTYPE *loc)
{
    rb_node_rescue_t *n = NODE_NEWNODE(NODE_RESCUE, rb_node_rescue_t, loc);
    n->nd_head = nd_head;
    n->nd_resq = nd_resq;
    n->nd_else = nd_else;

    return n;
}

static rb_node_resbody_t *
rb_node_resbody_new(struct parser_params *p, NODE *nd_args, NODE *nd_exc_var, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_resbody_t *n = NODE_NEWNODE(NODE_RESBODY, rb_node_resbody_t, loc);
    n->nd_args = nd_args;
    n->nd_exc_var = nd_exc_var;
    n->nd_body = nd_body;
    n->nd_next = nd_next;

    return n;
}

static rb_node_ensure_t *
rb_node_ensure_new(struct parser_params *p, NODE *nd_head, NODE *nd_ensr, const YYLTYPE *loc)
{
    rb_node_ensure_t *n = NODE_NEWNODE(NODE_ENSURE, rb_node_ensure_t, loc);
    n->nd_head = nd_head;
    n->nd_ensr = nd_ensr;

    return n;
}

static rb_node_and_t *
rb_node_and_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_and_t *n = NODE_NEWNODE(NODE_AND, rb_node_and_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_or_t *
rb_node_or_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_or_t *n = NODE_NEWNODE(NODE_OR, rb_node_or_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_return_t *
rb_node_return_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_return_t *n = NODE_NEWNODE(NODE_RETURN, rb_node_return_t, loc);
    n->nd_stts = nd_stts;
    n->keyword_loc = *keyword_loc;
    return n;
}

static rb_node_yield_t *
rb_node_yield_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_yield_t *n = NODE_NEWNODE(NODE_YIELD, rb_node_yield_t, loc);
    n->nd_head = nd_head;

    return n;
}

static rb_node_if_t *
rb_node_if_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc)
{
    rb_node_if_t *n = NODE_NEWNODE(NODE_IF, rb_node_if_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_else = nd_else;

    return n;
}

static rb_node_unless_t *
rb_node_unless_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_unless_t *n = NODE_NEWNODE(NODE_UNLESS, rb_node_unless_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_else = nd_else;
    n->keyword_loc = *keyword_loc;
    n->then_keyword_loc = *then_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_class_t *
rb_node_class_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, NODE *nd_super, const YYLTYPE *loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(0, nd_body, loc);
    rb_node_class_t *n = NODE_NEWNODE(NODE_CLASS, rb_node_class_t, loc);
    n->nd_cpath = nd_cpath;
    n->nd_body = scope;
    n->nd_super = nd_super;

    return n;
}

static rb_node_sclass_t *
rb_node_sclass_new(struct parser_params *p, NODE *nd_recv, NODE *nd_body, const YYLTYPE *loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(0, nd_body, loc);
    rb_node_sclass_t *n = NODE_NEWNODE(NODE_SCLASS, rb_node_sclass_t, loc);
    n->nd_recv = nd_recv;
    n->nd_body = scope;

    return n;
}

static rb_node_module_t *
rb_node_module_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, const YYLTYPE *loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(0, nd_body, loc);
    rb_node_module_t *n = NODE_NEWNODE(NODE_MODULE, rb_node_module_t, loc);
    n->nd_cpath = nd_cpath;
    n->nd_body = scope;

    return n;
}

static rb_node_iter_t *
rb_node_iter_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(nd_args, nd_body, loc);
    rb_node_iter_t *n = NODE_NEWNODE(NODE_ITER, rb_node_iter_t, loc);
    n->nd_body = scope;
    n->nd_iter = 0;

    return n;
}

static rb_node_lambda_t *
rb_node_lambda_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(nd_args, nd_body, loc);
    rb_node_lambda_t *n = NODE_NEWNODE(NODE_LAMBDA, rb_node_lambda_t, loc);
    n->nd_body = scope;

    return n;
}

static rb_node_case_t *
rb_node_case_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_case_t *n = NODE_NEWNODE(NODE_CASE, rb_node_case_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->case_keyword_loc = *case_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_case2_t *
rb_node_case2_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_case2_t *n = NODE_NEWNODE(NODE_CASE2, rb_node_case2_t, loc);
    n->nd_head = 0;
    n->nd_body = nd_body;
    n->case_keyword_loc = *case_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_case3_t *
rb_node_case3_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_case3_t *n = NODE_NEWNODE(NODE_CASE3, rb_node_case3_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->case_keyword_loc = *case_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_when_t *
rb_node_when_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc)
{
    rb_node_when_t *n = NODE_NEWNODE(NODE_WHEN, rb_node_when_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->nd_next = nd_next;
    n->keyword_loc = *keyword_loc;
    n->then_keyword_loc = *then_keyword_loc;

    return n;
}

static rb_node_in_t *
rb_node_in_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_in_t *n = NODE_NEWNODE(NODE_IN, rb_node_in_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->nd_next = nd_next;

    return n;
}

static rb_node_while_t *
rb_node_while_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc)
{
    rb_node_while_t *n = NODE_NEWNODE(NODE_WHILE, rb_node_while_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_state = nd_state;
    n->keyword_loc = *keyword_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_until_t *
rb_node_until_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc)
{
    rb_node_until_t *n = NODE_NEWNODE(NODE_UNTIL, rb_node_until_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_state = nd_state;
    n->keyword_loc = *keyword_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_colon2_t *
rb_node_colon2_new(struct parser_params *p, NODE *nd_head, ID nd_mid, const YYLTYPE *loc)
{
    rb_node_colon2_t *n = NODE_NEWNODE(NODE_COLON2, rb_node_colon2_t, loc);
    n->nd_head = nd_head;
    n->nd_mid = nd_mid;

    return n;
}

static rb_node_colon3_t *
rb_node_colon3_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc)
{
    rb_node_colon3_t *n = NODE_NEWNODE(NODE_COLON3, rb_node_colon3_t, loc);
    n->nd_mid = nd_mid;

    return n;
}

static rb_node_dot2_t *
rb_node_dot2_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc)
{
    rb_node_dot2_t *n = NODE_NEWNODE(NODE_DOT2, rb_node_dot2_t, loc);
    n->nd_beg = nd_beg;
    n->nd_end = nd_end;

    return n;
}

static rb_node_dot3_t *
rb_node_dot3_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc)
{
    rb_node_dot3_t *n = NODE_NEWNODE(NODE_DOT3, rb_node_dot3_t, loc);
    n->nd_beg = nd_beg;
    n->nd_end = nd_end;

    return n;
}

static rb_node_self_t *
rb_node_self_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_self_t *n = NODE_NEWNODE(NODE_SELF, rb_node_self_t, loc);
    n->nd_state = 1;

    return n;
}

static rb_node_nil_t *
rb_node_nil_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_nil_t *n = NODE_NEWNODE(NODE_NIL, rb_node_nil_t, loc);

    return n;
}

static rb_node_true_t *
rb_node_true_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_true_t *n = NODE_NEWNODE(NODE_TRUE, rb_node_true_t, loc);

    return n;
}

static rb_node_false_t *
rb_node_false_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_false_t *n = NODE_NEWNODE(NODE_FALSE, rb_node_false_t, loc);

    return n;
}

static rb_node_super_t *
rb_node_super_new(struct parser_params *p, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_super_t *n = NODE_NEWNODE(NODE_SUPER, rb_node_super_t, loc);
    n->nd_args = nd_args;

    return n;
}

static rb_node_zsuper_t *
rb_node_zsuper_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_zsuper_t *n = NODE_NEWNODE(NODE_ZSUPER, rb_node_zsuper_t, loc);

    return n;
}

static rb_node_match2_t *
rb_node_match2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_match2_t *n = NODE_NEWNODE(NODE_MATCH2, rb_node_match2_t, loc);
    n->nd_recv = nd_recv;
    n->nd_value = nd_value;
    n->nd_args = 0;

    return n;
}

static rb_node_match3_t *
rb_node_match3_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_match3_t *n = NODE_NEWNODE(NODE_MATCH3, rb_node_match3_t, loc);
    n->nd_recv = nd_recv;
    n->nd_value = nd_value;

    return n;
}

/* TODO: Use union for NODE_LIST2 */
static rb_node_list_t *
rb_node_list_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_list_t *n = NODE_NEWNODE(NODE_LIST, rb_node_list_t, loc);
    n->nd_head = nd_head;
    n->as.nd_alen = 1;
    n->nd_next = 0;

    return n;
}

static rb_node_list_t *
rb_node_list_new2(struct parser_params *p, NODE *nd_head, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_list_t *n = NODE_NEWNODE(NODE_LIST, rb_node_list_t, loc);
    n->nd_head = nd_head;
    n->as.nd_alen = nd_alen;
    n->nd_next = nd_next;

    return n;
}

static rb_node_zlist_t *
rb_node_zlist_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_zlist_t *n = NODE_NEWNODE(NODE_ZLIST, rb_node_zlist_t, loc);

    return n;
}

static rb_node_hash_t *
rb_node_hash_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_hash_t *n = NODE_NEWNODE(NODE_HASH, rb_node_hash_t, loc);
    n->nd_head = nd_head;
    n->nd_brace = 0;

    return n;
}

static rb_node_masgn_t *
rb_node_masgn_new(struct parser_params *p, NODE *nd_head, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_masgn_t *n = NODE_NEWNODE(NODE_MASGN, rb_node_masgn_t, loc);
    n->nd_head = nd_head;
    n->nd_value = 0;
    n->nd_args = nd_args;

    return n;
}

static rb_node_gasgn_t *
rb_node_gasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_gasgn_t *n = NODE_NEWNODE(NODE_GASGN, rb_node_gasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_lasgn_t *
rb_node_lasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_lasgn_t *n = NODE_NEWNODE(NODE_LASGN, rb_node_lasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_dasgn_t *
rb_node_dasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_dasgn_t *n = NODE_NEWNODE(NODE_DASGN, rb_node_dasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_iasgn_t *
rb_node_iasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_iasgn_t *n = NODE_NEWNODE(NODE_IASGN, rb_node_iasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_cvasgn_t *
rb_node_cvasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_cvasgn_t *n = NODE_NEWNODE(NODE_CVASGN, rb_node_cvasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_op_asgn1_t *
rb_node_op_asgn1_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *index, NODE *rvalue, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc)
{
    rb_node_op_asgn1_t *n = NODE_NEWNODE(NODE_OP_ASGN1, rb_node_op_asgn1_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_index = index;
    n->nd_rvalue = rvalue;
    n->call_operator_loc = *call_operator_loc;
    n->opening_loc = *opening_loc;
    n->closing_loc = *closing_loc;
    n->binary_operator_loc = *binary_operator_loc;

    return n;
}

static rb_node_op_asgn2_t *
rb_node_op_asgn2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, ID nd_vid, ID nd_mid, bool nd_aid, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc)
{
    rb_node_op_asgn2_t *n = NODE_NEWNODE(NODE_OP_ASGN2, rb_node_op_asgn2_t, loc);
    n->nd_recv = nd_recv;
    n->nd_value = nd_value;
    n->nd_vid = nd_vid;
    n->nd_mid = nd_mid;
    n->nd_aid = nd_aid;
    n->call_operator_loc = *call_operator_loc;
    n->message_loc = *message_loc;
    n->binary_operator_loc = *binary_operator_loc;

    return n;
}

static rb_node_op_asgn_or_t *
rb_node_op_asgn_or_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_op_asgn_or_t *n = NODE_NEWNODE(NODE_OP_ASGN_OR, rb_node_op_asgn_or_t, loc);
    n->nd_head = nd_head;
    n->nd_value = nd_value;

    return n;
}

static rb_node_op_asgn_and_t *
rb_node_op_asgn_and_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_op_asgn_and_t *n = NODE_NEWNODE(NODE_OP_ASGN_AND, rb_node_op_asgn_and_t, loc);
    n->nd_head = nd_head;
    n->nd_value = nd_value;

    return n;
}

static rb_node_gvar_t *
rb_node_gvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_gvar_t *n = NODE_NEWNODE(NODE_GVAR, rb_node_gvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_lvar_t *
rb_node_lvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_lvar_t *n = NODE_NEWNODE(NODE_LVAR, rb_node_lvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_dvar_t *
rb_node_dvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_dvar_t *n = NODE_NEWNODE(NODE_DVAR, rb_node_dvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_ivar_t *
rb_node_ivar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_ivar_t *n = NODE_NEWNODE(NODE_IVAR, rb_node_ivar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_const_t *
rb_node_const_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_const_t *n = NODE_NEWNODE(NODE_CONST, rb_node_const_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_cvar_t *
rb_node_cvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_cvar_t *n = NODE_NEWNODE(NODE_CVAR, rb_node_cvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_nth_ref_t *
rb_node_nth_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc)
{
    rb_node_nth_ref_t *n = NODE_NEWNODE(NODE_NTH_REF, rb_node_nth_ref_t, loc);
    n->nd_nth = nd_nth;

    return n;
}

static rb_node_back_ref_t *
rb_node_back_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc)
{
    rb_node_back_ref_t *n = NODE_NEWNODE(NODE_BACK_REF, rb_node_back_ref_t, loc);
    n->nd_nth = nd_nth;

    return n;
}

static rb_node_integer_t *
rb_node_integer_new(struct parser_params *p, char* val, int base, const YYLTYPE *loc)
{
    rb_node_integer_t *n = NODE_NEWNODE(NODE_INTEGER, rb_node_integer_t, loc);
    n->val = val;
    n->minus = FALSE;
    n->base = base;

    return n;
}

static rb_node_float_t *
rb_node_float_new(struct parser_params *p, char* val, const YYLTYPE *loc)
{
    rb_node_float_t *n = NODE_NEWNODE(NODE_FLOAT, rb_node_float_t, loc);
    n->val = val;
    n->minus = FALSE;

    return n;
}

static rb_node_rational_t *
rb_node_rational_new(struct parser_params *p, char* val, int base, int seen_point, const YYLTYPE *loc)
{
    rb_node_rational_t *n = NODE_NEWNODE(NODE_RATIONAL, rb_node_rational_t, loc);
    n->val = val;
    n->minus = FALSE;
    n->base = base;
    n->seen_point = seen_point;

    return n;
}

static rb_node_imaginary_t *
rb_node_imaginary_new(struct parser_params *p, char* val, int base, int seen_point, enum rb_numeric_type numeric_type, const YYLTYPE *loc)
{
    rb_node_imaginary_t *n = NODE_NEWNODE(NODE_IMAGINARY, rb_node_imaginary_t, loc);
    n->val = val;
    n->minus = FALSE;
    n->base = base;
    n->seen_point = seen_point;
    n->type = numeric_type;

    return n;
}

static rb_node_str_t *
rb_node_str_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc)
{
    rb_node_str_t *n = NODE_NEWNODE(NODE_STR, rb_node_str_t, loc);
    n->string = string;

    return n;
}

/* TODO; Use union for NODE_DSTR2 */
static rb_node_dstr_t *
rb_node_dstr_new0(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_dstr_t *n = NODE_NEWNODE(NODE_DSTR, rb_node_dstr_t, loc);
    n->string = string;
    n->as.nd_alen = nd_alen;
    n->nd_next = (rb_node_list_t *)nd_next;

    return n;
}

static rb_node_dstr_t *
rb_node_dstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc)
{
    return rb_node_dstr_new0(p, string, 1, 0, loc);
}

static rb_node_xstr_t *
rb_node_xstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc)
{
    rb_node_xstr_t *n = NODE_NEWNODE(NODE_XSTR, rb_node_xstr_t, loc);
    n->string = string;

    return n;
}

static rb_node_dxstr_t *
rb_node_dxstr_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_dxstr_t *n = NODE_NEWNODE(NODE_DXSTR, rb_node_dxstr_t, loc);
    n->string = string;
    n->as.nd_alen = nd_alen;
    n->nd_next = (rb_node_list_t *)nd_next;

    return n;
}

static rb_node_sym_t *
rb_node_sym_new(struct parser_params *p, VALUE str, const YYLTYPE *loc)
{
    rb_node_sym_t *n = NODE_NEWNODE(NODE_SYM, rb_node_sym_t, loc);
    n->string = rb_str_to_parser_string(p, str);

    return n;
}

static rb_node_dsym_t *
rb_node_dsym_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_dsym_t *n = NODE_NEWNODE(NODE_DSYM, rb_node_dsym_t, loc);
    n->string = string;
    n->as.nd_alen = nd_alen;
    n->nd_next = (rb_node_list_t *)nd_next;

    return n;
}

static rb_node_evstr_t *
rb_node_evstr_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_evstr_t *n = NODE_NEWNODE(NODE_EVSTR, rb_node_evstr_t, loc);
    n->nd_body = nd_body;

    return n;
}

static rb_node_regx_t *
rb_node_regx_new(struct parser_params *p, rb_parser_string_t *string, int options, const YYLTYPE *loc)
{
    rb_node_regx_t *n = NODE_NEWNODE(NODE_REGX, rb_node_regx_t, loc);
    n->string = string;
    n->options = options & RE_OPTION_MASK;

    return n;
}

static rb_node_call_t *
rb_node_call_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_call_t *n = NODE_NEWNODE(NODE_CALL, rb_node_call_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_opcall_t *
rb_node_opcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_opcall_t *n = NODE_NEWNODE(NODE_OPCALL, rb_node_opcall_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_fcall_t *
rb_node_fcall_new(struct parser_params *p, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_fcall_t *n = NODE_NEWNODE(NODE_FCALL, rb_node_fcall_t, loc);
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_qcall_t *
rb_node_qcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_qcall_t *n = NODE_NEWNODE(NODE_QCALL, rb_node_qcall_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_vcall_t *
rb_node_vcall_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc)
{
    rb_node_vcall_t *n = NODE_NEWNODE(NODE_VCALL, rb_node_vcall_t, loc);
    n->nd_mid = nd_mid;

    return n;
}

static rb_node_once_t *
rb_node_once_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_once_t *n = NODE_NEWNODE(NODE_ONCE, rb_node_once_t, loc);
    n->nd_body = nd_body;

    return n;
}

static rb_node_args_t *
rb_node_args_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_args_t *n = NODE_NEWNODE(NODE_ARGS, rb_node_args_t, loc);
    MEMZERO(&n->nd_ainfo, struct rb_args_info, 1);

    return n;
}

static rb_node_args_aux_t *
rb_node_args_aux_new(struct parser_params *p, ID nd_pid, int nd_plen, const YYLTYPE *loc)
{
    rb_node_args_aux_t *n = NODE_NEWNODE(NODE_ARGS_AUX, rb_node_args_aux_t, loc);
    n->nd_pid = nd_pid;
    n->nd_plen = nd_plen;
    n->nd_next = 0;

    return n;
}

static rb_node_opt_arg_t *
rb_node_opt_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_opt_arg_t *n = NODE_NEWNODE(NODE_OPT_ARG, rb_node_opt_arg_t, loc);
    n->nd_body = nd_body;
    n->nd_next = 0;

    return n;
}

static rb_node_kw_arg_t *
rb_node_kw_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_kw_arg_t *n = NODE_NEWNODE(NODE_KW_ARG, rb_node_kw_arg_t, loc);
    n->nd_body = nd_body;
    n->nd_next = 0;

    return n;
}

static rb_node_postarg_t *
rb_node_postarg_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc)
{
    rb_node_postarg_t *n = NODE_NEWNODE(NODE_POSTARG, rb_node_postarg_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;

    return n;
}

static rb_node_argscat_t *
rb_node_argscat_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_argscat_t *n = NODE_NEWNODE(NODE_ARGSCAT, rb_node_argscat_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;

    return n;
}

static rb_node_argspush_t *
rb_node_argspush_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_argspush_t *n = NODE_NEWNODE(NODE_ARGSPUSH, rb_node_argspush_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;

    return n;
}

static rb_node_splat_t *
rb_node_splat_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_splat_t *n = NODE_NEWNODE(NODE_SPLAT, rb_node_splat_t, loc);
    n->nd_head = nd_head;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_block_pass_t *
rb_node_block_pass_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_block_pass_t *n = NODE_NEWNODE(NODE_BLOCK_PASS, rb_node_block_pass_t, loc);
    n->forwarding = 0;
    n->nd_head = 0;
    n->nd_body = nd_body;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_alias_t *
rb_node_alias_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_alias_t *n = NODE_NEWNODE(NODE_ALIAS, rb_node_alias_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_valias_t *
rb_node_valias_new(struct parser_params *p, ID nd_alias, ID nd_orig, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_valias_t *n = NODE_NEWNODE(NODE_VALIAS, rb_node_valias_t, loc);
    n->nd_alias = nd_alias;
    n->nd_orig = nd_orig;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_undef_t *
rb_node_undef_new(struct parser_params *p, NODE *nd_undef, const YYLTYPE *loc)
{
    rb_node_undef_t *n = NODE_NEWNODE(NODE_UNDEF, rb_node_undef_t, loc);
    n->nd_undefs = rb_parser_ary_new_capa_for_node(p, 1);
    n->keyword_loc = NULL_LOC;
    rb_parser_ary_push_node(p, n->nd_undefs, nd_undef);

    return n;
}

static rb_node_errinfo_t *
rb_node_errinfo_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_errinfo_t *n = NODE_NEWNODE(NODE_ERRINFO, rb_node_errinfo_t, loc);

    return n;
}

static rb_node_defined_t *
rb_node_defined_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_defined_t *n = NODE_NEWNODE(NODE_DEFINED, rb_node_defined_t, loc);
    n->nd_head = nd_head;

    return n;
}

static rb_node_postexe_t *
rb_node_postexe_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_postexe_t *n = NODE_NEWNODE(NODE_POSTEXE, rb_node_postexe_t, loc);
    n->nd_body = nd_body;

    return n;
}

static rb_node_attrasgn_t *
rb_node_attrasgn_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_attrasgn_t *n = NODE_NEWNODE(NODE_ATTRASGN, rb_node_attrasgn_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_aryptn_t *
rb_node_aryptn_new(struct parser_params *p, NODE *pre_args, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc)
{
    rb_node_aryptn_t *n = NODE_NEWNODE(NODE_ARYPTN, rb_node_aryptn_t, loc);
    n->nd_pconst = 0;
    n->pre_args = pre_args;
    n->rest_arg = rest_arg;
    n->post_args = post_args;

    return n;
}

static rb_node_hshptn_t *
rb_node_hshptn_new(struct parser_params *p, NODE *nd_pconst, NODE *nd_pkwargs, NODE *nd_pkwrestarg, const YYLTYPE *loc)
{
    rb_node_hshptn_t *n = NODE_NEWNODE(NODE_HSHPTN, rb_node_hshptn_t, loc);
    n->nd_pconst = nd_pconst;
    n->nd_pkwargs = nd_pkwargs;
    n->nd_pkwrestarg = nd_pkwrestarg;

    return n;
}

static rb_node_fndptn_t *
rb_node_fndptn_new(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc)
{
    rb_node_fndptn_t *n = NODE_NEWNODE(NODE_FNDPTN, rb_node_fndptn_t, loc);
    n->nd_pconst = 0;
    n->pre_rest_arg = pre_rest_arg;
    n->args = args;
    n->post_rest_arg = post_rest_arg;

    return n;
}

static rb_node_line_t *
rb_node_line_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_line_t *n = NODE_NEWNODE(NODE_LINE, rb_node_line_t, loc);

    return n;
}

static rb_node_file_t *
rb_node_file_new(struct parser_params *p, VALUE str, const YYLTYPE *loc)
{
    rb_node_file_t *n = NODE_NEWNODE(NODE_FILE, rb_node_file_t, loc);
    n->path = rb_str_to_parser_string(p, str);

    return n;
}

static rb_node_encoding_t *
rb_node_encoding_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_encoding_t *n = NODE_NEWNODE(NODE_ENCODING, rb_node_encoding_t, loc);
    n->enc = p->enc;

    return n;
}

static rb_node_cdecl_t *
rb_node_cdecl_new(struct parser_params *p, ID nd_vid, NODE *nd_value, NODE *nd_else, enum rb_parser_shareability shareability, const YYLTYPE *loc)
{
    rb_node_cdecl_t *n = NODE_NEWNODE(NODE_CDECL, rb_node_cdecl_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;
    n->nd_else = nd_else;
    n->shareability = shareability;

    return n;
}

static rb_node_op_cdecl_t *
rb_node_op_cdecl_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, ID nd_aid, enum rb_parser_shareability shareability, const YYLTYPE *loc)
{
    rb_node_op_cdecl_t *n = NODE_NEWNODE(NODE_OP_CDECL, rb_node_op_cdecl_t, loc);
    n->nd_head = nd_head;
    n->nd_value = nd_value;
    n->nd_aid = nd_aid;
    n->shareability = shareability;

    return n;
}

static rb_node_error_t *
rb_node_error_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_error_t *n = NODE_NEWNODE(NODE_ERROR, rb_node_error_t, loc);

    return n;
}

static rb_node_break_t *
rb_node_break_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_break_t *n = NODE_NEWNODE(NODE_BREAK, rb_node_break_t, loc);
    n->nd_stts = nd_stts;
    n->nd_chain = 0;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_next_t *
rb_node_next_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_next_t *n = NODE_NEWNODE(NODE_NEXT, rb_node_next_t, loc);
    n->nd_stts = nd_stts;
    n->nd_chain = 0;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_redo_t *
rb_node_redo_new(struct parser_params *p, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_redo_t *n = NODE_NEWNODE(NODE_REDO, rb_node_redo_t, loc);
    n->nd_chain = 0;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_def_temp_t *
rb_node_def_temp_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_def_temp_t *n = NODE_NEWNODE((enum node_type)NODE_DEF_TEMP, rb_node_def_temp_t, loc);
    n->save.numparam_save = 0;
    n->save.max_numparam = 0;
    n->save.ctxt = p->ctxt;
    n->nd_def = 0;
    n->nd_mid = 0;

    return n;
}

static rb_node_def_temp_t *
def_head_save(struct parser_params *p, rb_node_def_temp_t *n)
{
    n->save.numparam_save = numparam_push(p);
    n->save.max_numparam = p->max_numparam;
    return n;
}

#ifndef RIPPER
static enum node_type
nodetype(NODE *node)			/* for debug */
{
    return (enum node_type)nd_type(node);
}

static int
nodeline(NODE *node)
{
    return nd_line(node);
}
#endif

static NODE*
newline_node(NODE *node)
{
    if (node) {
        node = remove_begin(node);
        nd_set_fl_newline(node);
    }
    return node;
}

static void
fixpos(NODE *node, NODE *orig)
{
    if (!node) return;
    if (!orig) return;
    nd_set_line(node, nd_line(orig));
}

static NODE*
block_append(struct parser_params *p, NODE *head, NODE *tail)
{
    NODE *end, *h = head, *nd;

    if (tail == 0) return head;

    if (h == 0) return tail;
    switch (nd_type(h)) {
      default:
        h = end = NEW_BLOCK(head, &head->nd_loc);
        head = end;
        break;
      case NODE_BLOCK:
        end = RNODE_BLOCK(h)->nd_end;
        break;
    }

    nd = RNODE_BLOCK(end)->nd_head;
    switch (nd_type(nd)) {
      case NODE_RETURN:
      case NODE_BREAK:
      case NODE_NEXT:
      case NODE_REDO:
      case NODE_RETRY:
        rb_warning0L(nd_line(tail), "statement not reached");
        break;

      default:
        break;
    }

    if (!nd_type_p(tail, NODE_BLOCK)) {
        tail = NEW_BLOCK(tail, &tail->nd_loc);
    }
    RNODE_BLOCK(end)->nd_next = tail;
    RNODE_BLOCK(h)->nd_end = RNODE_BLOCK(tail)->nd_end;
    nd_set_last_loc(head, nd_last_loc(tail));
    return head;
}

/* append item to the list */
static NODE*
list_append(struct parser_params *p, NODE *list, NODE *item)
{
    NODE *last;

    if (list == 0) return NEW_LIST(item, &item->nd_loc);
    if (RNODE_LIST(list)->nd_next) {
        last = RNODE_LIST(RNODE_LIST(list)->nd_next)->as.nd_end;
    }
    else {
        last = list;
    }

    RNODE_LIST(list)->as.nd_alen += 1;
    RNODE_LIST(last)->nd_next = NEW_LIST(item, &item->nd_loc);
    RNODE_LIST(RNODE_LIST(list)->nd_next)->as.nd_end = RNODE_LIST(last)->nd_next;

    nd_set_last_loc(list, nd_last_loc(item));

    return list;
}

/* concat two lists */
static NODE*
list_concat(NODE *head, NODE *tail)
{
    NODE *last;

    if (RNODE_LIST(head)->nd_next) {
        last = RNODE_LIST(RNODE_LIST(head)->nd_next)->as.nd_end;
    }
    else {
        last = head;
    }

    RNODE_LIST(head)->as.nd_alen += RNODE_LIST(tail)->as.nd_alen;
    RNODE_LIST(last)->nd_next = tail;
    if (RNODE_LIST(tail)->nd_next) {
        RNODE_LIST(RNODE_LIST(head)->nd_next)->as.nd_end = RNODE_LIST(RNODE_LIST(tail)->nd_next)->as.nd_end;
    }
    else {
        RNODE_LIST(RNODE_LIST(head)->nd_next)->as.nd_end = tail;
    }

    nd_set_last_loc(head, nd_last_loc(tail));

    return head;
}

static int
literal_concat0(struct parser_params *p, rb_parser_string_t *head, rb_parser_string_t *tail)
{
    if (!tail) return 1;
    if (!rb_parser_enc_compatible(p, head, tail)) {
        compile_error(p, "string literal encodings differ (%s / %s)",
                      rb_enc_name(rb_parser_str_get_encoding(head)),
                      rb_enc_name(rb_parser_str_get_encoding(tail)));
        rb_parser_str_resize(p, head, 0);
        rb_parser_str_resize(p, tail, 0);
        return 0;
    }
    rb_parser_str_buf_append(p, head, tail);
    return 1;
}

static rb_parser_string_t *
string_literal_head(struct parser_params *p, enum node_type htype, NODE *head)
{
    if (htype != NODE_DSTR) return NULL;
    if (RNODE_DSTR(head)->nd_next) {
        head = RNODE_LIST(RNODE_LIST(RNODE_DSTR(head)->nd_next)->as.nd_end)->nd_head;
        if (!head || !nd_type_p(head, NODE_STR)) return NULL;
    }
    rb_parser_string_t *lit = RNODE_DSTR(head)->string;
    ASSUME(lit);
    return lit;
}

#ifndef RIPPER
static rb_parser_string_t *
rb_parser_string_deep_copy(struct parser_params *p, const rb_parser_string_t *orig)
{
    rb_parser_string_t *copy;
    if (!orig) return NULL;
    copy = rb_parser_string_new(p, PARSER_STRING_PTR(orig), PARSER_STRING_LEN(orig));
    copy->coderange = orig->coderange;
    copy->enc = orig->enc;
    return copy;
}
#endif

/* concat two string literals */
static NODE *
literal_concat(struct parser_params *p, NODE *head, NODE *tail, const YYLTYPE *loc)
{
    enum node_type htype;
    rb_parser_string_t *lit;

    if (!head) return tail;
    if (!tail) return head;

    htype = nd_type(head);
    if (htype == NODE_EVSTR) {
        head = new_dstr(p, head, loc);
        htype = NODE_DSTR;
    }
    if (p->heredoc_indent > 0) {
        switch (htype) {
          case NODE_STR:
            head = str2dstr(p, head);
          case NODE_DSTR:
            return list_append(p, head, tail);
          default:
            break;
        }
    }
    switch (nd_type(tail)) {
      case NODE_STR:
        if ((lit = string_literal_head(p, htype, head)) != false) {
            htype = NODE_STR;
        }
        else {
            lit = RNODE_DSTR(head)->string;
        }
        if (htype == NODE_STR) {
            if (!literal_concat0(p, lit, RNODE_STR(tail)->string)) {
              error:
                rb_discard_node(p, head);
                rb_discard_node(p, tail);
                return 0;
            }
            rb_discard_node(p, tail);
        }
        else {
            list_append(p, head, tail);
        }
        break;

      case NODE_DSTR:
        if (htype == NODE_STR) {
            if (!literal_concat0(p, RNODE_STR(head)->string, RNODE_DSTR(tail)->string))
                goto error;
            rb_parser_string_free(p, RNODE_DSTR(tail)->string);
            RNODE_DSTR(tail)->string = RNODE_STR(head)->string;
            RNODE_STR(head)->string = NULL;
            rb_discard_node(p, head);
            head = tail;
        }
        else if (!RNODE_DSTR(tail)->string) {
          append:
            RNODE_DSTR(head)->as.nd_alen += RNODE_DSTR(tail)->as.nd_alen - 1;
            if (!RNODE_DSTR(head)->nd_next) {
                RNODE_DSTR(head)->nd_next = RNODE_DSTR(tail)->nd_next;
            }
            else if (RNODE_DSTR(tail)->nd_next) {
                RNODE_DSTR(RNODE_DSTR(RNODE_DSTR(head)->nd_next)->as.nd_end)->nd_next = RNODE_DSTR(tail)->nd_next;
                RNODE_DSTR(RNODE_DSTR(head)->nd_next)->as.nd_end = RNODE_DSTR(RNODE_DSTR(tail)->nd_next)->as.nd_end;
            }
            rb_discard_node(p, tail);
        }
        else if ((lit = string_literal_head(p, htype, head)) != false) {
            if (!literal_concat0(p, lit, RNODE_DSTR(tail)->string))
                goto error;
            rb_parser_string_free(p, RNODE_DSTR(tail)->string);
            RNODE_DSTR(tail)->string = 0;
            goto append;
        }
        else {
            list_concat(head, NEW_LIST2(NEW_STR(RNODE_DSTR(tail)->string, loc), RNODE_DSTR(tail)->as.nd_alen, (NODE *)RNODE_DSTR(tail)->nd_next, loc));
            RNODE_DSTR(tail)->string = 0;
        }
        break;

      case NODE_EVSTR:
        if (htype == NODE_STR) {
            head = str2dstr(p, head);
            RNODE_DSTR(head)->as.nd_alen = 1;
        }
        list_append(p, head, tail);
        break;
    }
    return head;
}

static void
nd_copy_flag(NODE *new_node, NODE *old_node)
{
    if (nd_fl_newline(old_node)) nd_set_fl_newline(new_node);
    nd_set_line(new_node, nd_line(old_node));
    new_node->nd_loc = old_node->nd_loc;
    new_node->node_id = old_node->node_id;
}

static NODE *
str2dstr(struct parser_params *p, NODE *node)
{
    NODE *new_node = (NODE *)NODE_NEW_INTERNAL(NODE_DSTR, rb_node_dstr_t);
    nd_copy_flag(new_node, node);
    RNODE_DSTR(new_node)->string = RNODE_STR(node)->string;
    RNODE_DSTR(new_node)->as.nd_alen = 0;
    RNODE_DSTR(new_node)->nd_next = 0;
    RNODE_STR(node)->string = 0;

    return new_node;
}

static NODE *
str2regx(struct parser_params *p, NODE *node, int options)
{
    NODE *new_node = (NODE *)NODE_NEW_INTERNAL(NODE_REGX, rb_node_regx_t);
    nd_copy_flag(new_node, node);
    RNODE_REGX(new_node)->string = RNODE_STR(node)->string;
    RNODE_REGX(new_node)->options = options;
    RNODE_STR(node)->string = 0;

    return new_node;
}

static NODE *
evstr2dstr(struct parser_params *p, NODE *node)
{
    if (nd_type_p(node, NODE_EVSTR)) {
        node = new_dstr(p, node, &node->nd_loc);
    }
    return node;
}

static NODE *
new_evstr(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    NODE *head = node;

    if (node) {
        switch (nd_type(node)) {
          case NODE_STR:
            return str2dstr(p, node);
          case NODE_DSTR:
            break;
          case NODE_EVSTR:
            return node;
        }
    }
    return NEW_EVSTR(head, loc);
}

static NODE *
new_dstr(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    NODE *dstr = NEW_DSTR(STRING_NEW0(), loc);
    return list_append(p, dstr, node);
}

static NODE *
call_bin_op(struct parser_params *p, NODE *recv, ID id, NODE *arg1,
                const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *expr;
    value_expr(recv);
    value_expr(arg1);
    expr = NEW_OPCALL(recv, id, NEW_LIST(arg1, &arg1->nd_loc), loc);
    nd_set_line(expr, op_loc->beg_pos.lineno);
    return expr;
}

static NODE *
call_uni_op(struct parser_params *p, NODE *recv, ID id, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *opcall;
    value_expr(recv);
    opcall = NEW_OPCALL(recv, id, 0, loc);
    nd_set_line(opcall, op_loc->beg_pos.lineno);
    return opcall;
}

static NODE *
new_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *qcall = NEW_QCALL(atype, recv, mid, args, loc);
    nd_set_line(qcall, op_loc->beg_pos.lineno);
    return qcall;
}

static NODE*
new_command_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, NODE *block, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *ret;
    if (block) block_dup_check(p, args, block);
    ret = new_qcall(p, atype, recv, mid, args, op_loc, loc);
    if (block) ret = method_add_block(p, ret, block, loc);
    fixpos(ret, recv);
    return ret;
}

#define nd_once_body(node) (nd_type_p((node), NODE_ONCE) ? RNODE_ONCE(node)->nd_body : node)

static NODE*
last_expr_once_body(NODE *node)
{
    if (!node) return 0;
    return nd_once_body(node);
}

static NODE*
match_op(struct parser_params *p, NODE *node1, NODE *node2, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *n;
    int line = op_loc->beg_pos.lineno;

    value_expr(node1);
    value_expr(node2);

    if ((n = last_expr_once_body(node1)) != 0) {
        switch (nd_type(n)) {
          case NODE_DREGX:
            {
                NODE *match = NEW_MATCH2(node1, node2, loc);
                nd_set_line(match, line);
                return match;
            }

          case NODE_REGX:
            {
                const VALUE lit = rb_node_regx_string_val(n);
                if (!NIL_P(lit)) {
                    NODE *match = NEW_MATCH2(node1, node2, loc);
                    RNODE_MATCH2(match)->nd_args = reg_named_capture_assign(p, lit, loc, assignable);
                    nd_set_line(match, line);
                    return match;
                }
            }
        }
    }

    if ((n = last_expr_once_body(node2)) != 0) {
        NODE *match3;

        switch (nd_type(n)) {
          case NODE_DREGX:
            match3 = NEW_MATCH3(node2, node1, loc);
            return match3;
        }
    }

    n = NEW_CALL(node1, tMATCH, NEW_LIST(node2, &node2->nd_loc), loc);
    nd_set_line(n, line);
    return n;
}

# if WARN_PAST_SCOPE
static int
past_dvar_p(struct parser_params *p, ID id)
{
    struct vtable *past = p->lvtbl->past;
    while (past) {
        if (vtable_included(past, id)) return 1;
        past = past->prev;
    }
    return 0;
}
# endif

static int
numparam_nested_p(struct parser_params *p)
{
    struct local_vars *local = p->lvtbl;
    NODE *outer = local->numparam.outer;
    NODE *inner = local->numparam.inner;
    if (outer || inner) {
        NODE *used = outer ? outer : inner;
        compile_error(p, "numbered parameter is already used in\n"
                      "%s:%d: %s block here",
                      p->ruby_sourcefile, nd_line(used),
                      outer ? "outer" : "inner");
        parser_show_error_line(p, &used->nd_loc);
        return 1;
    }
    return 0;
}

static int
numparam_used_p(struct parser_params *p)
{
    NODE *numparam = p->lvtbl->numparam.current;
    if (numparam) {
        compile_error(p, "numbered parameter is already used in\n"
                      "%s:%d: current block here",
                      p->ruby_sourcefile, nd_line(numparam));
        parser_show_error_line(p, &numparam->nd_loc);
        return 1;
    }
    return 0;
}

static int
it_used_p(struct parser_params *p)
{
    NODE *it = p->lvtbl->it;
    if (it) {
        compile_error(p, "'it' is already used in\n"
                      "%s:%d: current block here",
                      p->ruby_sourcefile, nd_line(it));
        parser_show_error_line(p, &it->nd_loc);
        return 1;
    }
    return 0;
}

static NODE*
gettable(struct parser_params *p, ID id, const YYLTYPE *loc)
{
    ID *vidp = NULL;
    NODE *node;
    switch (id) {
      case keyword_self:
        return NEW_SELF(loc);
      case keyword_nil:
        return NEW_NIL(loc);
      case keyword_true:
        return NEW_TRUE(loc);
      case keyword_false:
        return NEW_FALSE(loc);
      case keyword__FILE__:
        {
            VALUE file = p->ruby_sourcefile_string;
            if (NIL_P(file))
                file = rb_str_new(0, 0);
            node = NEW_FILE(file, loc);
        }
        return node;
      case keyword__LINE__:
        return NEW_LINE(loc);
      case keyword__ENCODING__:
        return NEW_ENCODING(loc);

    }
    switch (id_type(id)) {
      case ID_LOCAL:
        if (dyna_in_block(p) && dvar_defined_ref(p, id, &vidp)) {
            if (NUMPARAM_ID_P(id) && (numparam_nested_p(p) || it_used_p(p))) return 0;
            if (vidp) *vidp |= LVAR_USED;
            node = NEW_DVAR(id, loc);
            return node;
        }
        if (local_id_ref(p, id, &vidp)) {
            if (vidp) *vidp |= LVAR_USED;
            node = NEW_LVAR(id, loc);
            return node;
        }
        if (dyna_in_block(p) && NUMPARAM_ID_P(id) &&
            parser_numbered_param(p, NUMPARAM_ID_TO_IDX(id))) {
            if (numparam_nested_p(p) || it_used_p(p)) return 0;
            node = NEW_DVAR(id, loc);
            struct local_vars *local = p->lvtbl;
            if (!local->numparam.current) local->numparam.current = node;
            return node;
        }
# if WARN_PAST_SCOPE
        if (!p->ctxt.in_defined && RTEST(ruby_verbose) && past_dvar_p(p, id)) {
            rb_warning1("possible reference to past scope - %"PRIsWARN, rb_id2str(id));
        }
# endif
        /* method call without arguments */
        if (dyna_in_block(p) && id == rb_intern("it") && !(DVARS_TERMINAL_P(p->lvtbl->args) || DVARS_TERMINAL_P(p->lvtbl->args->prev))) {
            if (numparam_used_p(p)) return 0;
            if (p->max_numparam == ORDINAL_PARAM) {
                compile_error(p, "ordinary parameter is defined");
                return 0;
            }
            if (!p->it_id) {
                p->it_id = internal_id(p);
                vtable_add(p->lvtbl->args, p->it_id);
            }
            NODE *node = NEW_DVAR(p->it_id, loc);
            if (!p->lvtbl->it) p->lvtbl->it = node;
            return node;
        }
        return NEW_VCALL(id, loc);
      case ID_GLOBAL:
        return NEW_GVAR(id, loc);
      case ID_INSTANCE:
        return NEW_IVAR(id, loc);
      case ID_CONST:
        return NEW_CONST(id, loc);
      case ID_CLASS:
        return NEW_CVAR(id, loc);
    }
    compile_error(p, "identifier %"PRIsVALUE" is not valid to get", rb_id2str(id));
    return 0;
}

static rb_node_opt_arg_t *
opt_arg_append(rb_node_opt_arg_t *opt_list, rb_node_opt_arg_t *opt)
{
    rb_node_opt_arg_t *opts = opt_list;
    RNODE(opts)->nd_loc.end_pos = RNODE(opt)->nd_loc.end_pos;

    while (opts->nd_next) {
        opts = opts->nd_next;
        RNODE(opts)->nd_loc.end_pos = RNODE(opt)->nd_loc.end_pos;
    }
    opts->nd_next = opt;

    return opt_list;
}

static rb_node_kw_arg_t *
kwd_append(rb_node_kw_arg_t *kwlist, rb_node_kw_arg_t *kw)
{
    if (kwlist) {
        /* Assume rb_node_kw_arg_t and rb_node_opt_arg_t has same structure */
        opt_arg_append(RNODE_OPT_ARG(kwlist), RNODE_OPT_ARG(kw));
    }
    return kwlist;
}

static NODE *
new_defined(struct parser_params *p, NODE *expr, const YYLTYPE *loc)
{
    NODE *n = expr;
    while (n) {
        if (nd_type_p(n, NODE_BEGIN)) {
            n = RNODE_BEGIN(n)->nd_body;
        }
        else if (nd_type_p(n, NODE_BLOCK) && RNODE_BLOCK(n)->nd_end == n) {
            n = RNODE_BLOCK(n)->nd_head;
        }
        else {
            break;
        }
    }
    return NEW_DEFINED(n, loc);
}

static NODE*
str_to_sym_node(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    VALUE lit;
    rb_parser_string_t *str = RNODE_STR(node)->string;
    if (rb_parser_enc_str_coderange(p, str) == RB_PARSER_ENC_CODERANGE_BROKEN) {
        yyerror1(loc, "invalid symbol");
        lit = STR_NEW0();
    }
    else {
        lit = rb_str_new_parser_string(str);
    }
    return NEW_SYM(lit, loc);
}

static NODE*
symbol_append(struct parser_params *p, NODE *symbols, NODE *symbol)
{
    enum node_type type = nd_type(symbol);
    switch (type) {
      case NODE_DSTR:
        nd_set_type(symbol, NODE_DSYM);
        break;
      case NODE_STR:
        symbol = str_to_sym_node(p, symbol, &RNODE(symbol)->nd_loc);
        break;
      default:
        compile_error(p, "unexpected node as symbol: %s", parser_node_name(type));
    }
    return list_append(p, symbols, symbol);
}

static NODE *
new_regexp(struct parser_params *p, NODE *node, int options, const YYLTYPE *loc)
{
    struct RNode_LIST *list;
    NODE *prev;

    if (!node) {
        /* Check string is valid regex */
        rb_parser_string_t *str = STRING_NEW0();
        reg_compile(p, str, options);
        node = NEW_REGX(str, options, loc);
        return node;
    }
    switch (nd_type(node)) {
      case NODE_STR:
        {
            /* Check string is valid regex */
            reg_compile(p, RNODE_STR(node)->string, options);
            node = str2regx(p, node, options);
        }
        break;
      default:
        node = NEW_DSTR0(STRING_NEW0(), 1, NEW_LIST(node, loc), loc);
        /* fall through */
      case NODE_DSTR:
        nd_set_type(node, NODE_DREGX);
        nd_set_loc(node, loc);
        rb_node_dregx_t *const dreg = RNODE_DREGX(node);
        dreg->as.nd_cflag = options & RE_OPTION_MASK;
        if (dreg->string) reg_fragment_check(p, dreg->string, options);
        prev = node;
        for (list = dreg->nd_next; list; list = RNODE_LIST(list->nd_next)) {
            NODE *frag = list->nd_head;
            enum node_type type = nd_type(frag);
            if (type == NODE_STR || (type == NODE_DSTR && !RNODE_DSTR(frag)->nd_next)) {
                rb_parser_string_t *tail = RNODE_STR(frag)->string;
                if (reg_fragment_check(p, tail, options) && prev && RNODE_DREGX(prev)->string) {
                    rb_parser_string_t *lit = prev == node ? dreg->string : RNODE_STR(RNODE_LIST(prev)->nd_head)->string;
                    if (!literal_concat0(p, lit, tail)) {
                        return NEW_NIL(loc); /* dummy node on error */
                    }
                    rb_parser_str_resize(p, tail, 0);
                    RNODE_LIST(prev)->nd_next = list->nd_next;
                    rb_discard_node(p, list->nd_head);
                    rb_discard_node(p, (NODE *)list);
                    list = RNODE_LIST(prev);
                }
                else {
                    prev = (NODE *)list;
                }
            }
            else {
                prev = 0;
            }
        }
        if (!dreg->nd_next) {
            /* Check string is valid regex */
            reg_compile(p, dreg->string, options);
        }
        if (options & RE_OPTION_ONCE) {
            node = NEW_ONCE(node, loc);
        }
        break;
    }
    return node;
}

static rb_node_kw_arg_t *
new_kw_arg(struct parser_params *p, NODE *k, const YYLTYPE *loc)
{
    if (!k) return 0;
    return NEW_KW_ARG((k), loc);
}

static NODE *
new_xstring(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (!node) {
        NODE *xstr = NEW_XSTR(STRING_NEW0(), loc);
        return xstr;
    }
    switch (nd_type(node)) {
      case NODE_STR:
        nd_set_type(node, NODE_XSTR);
        nd_set_loc(node, loc);
        break;
      case NODE_DSTR:
        nd_set_type(node, NODE_DXSTR);
        nd_set_loc(node, loc);
        break;
      default:
        node = NEW_DXSTR(0, 1, NEW_LIST(node, loc), loc);
        break;
    }
    return node;
}

static const
struct st_hash_type literal_type = {
    literal_cmp,
    literal_hash,
};

static int nd_type_st_key_enable_p(NODE *node);

static void
check_literal_when(struct parser_params *p, NODE *arg, const YYLTYPE *loc)
{
    /* See https://bugs.ruby-lang.org/issues/20331 for discussion about what is warned. */
    if (!arg || !p->case_labels) return;
    if (!nd_type_st_key_enable_p(arg)) return;

    if (p->case_labels == CHECK_LITERAL_WHEN) {
        p->case_labels = st_init_table(&literal_type);
    }
    else {
        st_data_t line;
        if (st_lookup(p->case_labels, (st_data_t)arg, &line)) {
            rb_warning2("'when' clause on line %d duplicates 'when' clause on line %d and is ignored",
                        WARN_I((int)nd_line(arg)), WARN_I((int)line));
            return;
        }
    }
    st_insert(p->case_labels, (st_data_t)arg, (st_data_t)p->ruby_sourceline);
}

#ifdef RIPPER
static int
id_is_var(struct parser_params *p, ID id)
{
    if (is_notop_id(id)) {
        switch (id & ID_SCOPE_MASK) {
          case ID_GLOBAL: case ID_INSTANCE: case ID_CONST: case ID_CLASS:
            return 1;
          case ID_LOCAL:
            if (dyna_in_block(p)) {
                if (NUMPARAM_ID_P(id) || dvar_defined(p, id)) return 1;
            }
            if (local_id(p, id)) return 1;
            /* method call without arguments */
            return 0;
        }
    }
    compile_error(p, "identifier %"PRIsVALUE" is not valid to get", rb_id2str(id));
    return 0;
}
#endif

static inline enum lex_state_e
parser_set_lex_state(struct parser_params *p, enum lex_state_e ls, int line)
{
    if (p->debug) {
        ls = rb_parser_trace_lex_state(p, p->lex.state, ls, line);
    }
    return p->lex.state = ls;
}

#ifndef RIPPER
static void
flush_debug_buffer(struct parser_params *p, VALUE out, VALUE str)
{
    VALUE mesg = p->debug_buffer;

    if (!NIL_P(mesg) && RSTRING_LEN(mesg)) {
        p->debug_buffer = Qnil;
        rb_io_puts(1, &mesg, out);
    }
    if (!NIL_P(str) && RSTRING_LEN(str)) {
        rb_io_write(p->debug_output, str);
    }
}

static const char rb_parser_lex_state_names[][8] = {
    "BEG",    "END",    "ENDARG", "ENDFN",  "ARG",
    "CMDARG", "MID",    "FNAME",  "DOT",    "CLASS",
    "LABEL",  "LABELED","FITEM",
};

static VALUE
append_lex_state_name(struct parser_params *p, enum lex_state_e state, VALUE buf)
{
    int i, sep = 0;
    unsigned int mask = 1;
    static const char none[] = "NONE";

    for (i = 0; i < EXPR_MAX_STATE; ++i, mask <<= 1) {
        if ((unsigned)state & mask) {
            if (sep) {
                rb_str_cat(buf, "|", 1);
            }
            sep = 1;
            rb_str_cat_cstr(buf, rb_parser_lex_state_names[i]);
        }
    }
    if (!sep) {
        rb_str_cat(buf, none, sizeof(none)-1);
    }
    return buf;
}

enum lex_state_e
rb_parser_trace_lex_state(struct parser_params *p, enum lex_state_e from,
                          enum lex_state_e to, int line)
{
    VALUE mesg;
    mesg = rb_str_new_cstr("lex_state: ");
    append_lex_state_name(p, from, mesg);
    rb_str_cat_cstr(mesg, " -> ");
    append_lex_state_name(p, to, mesg);
    rb_str_catf(mesg, " at line %d\n", line);
    flush_debug_buffer(p, p->debug_output, mesg);
    return to;
}

VALUE
rb_parser_lex_state_name(struct parser_params *p, enum lex_state_e state)
{
    return rb_str_to_interned_str(append_lex_state_name(p, state, rb_str_new(0, 0)));
}

static void
append_bitstack_value(struct parser_params *p, stack_type stack, VALUE mesg)
{
    if (stack == 0) {
        rb_str_cat_cstr(mesg, "0");
    }
    else {
        stack_type mask = (stack_type)1U << (CHAR_BIT * sizeof(stack_type) - 1);
        for (; mask && !(stack & mask); mask >>= 1) continue;
        for (; mask; mask >>= 1) rb_str_cat(mesg, stack & mask ? "1" : "0", 1);
    }
}

void
rb_parser_show_bitstack(struct parser_params *p, stack_type stack,
                        const char *name, int line)
{
    VALUE mesg = rb_sprintf("%s: ", name);
    append_bitstack_value(p, stack, mesg);
    rb_str_catf(mesg, " at line %d\n", line);
    flush_debug_buffer(p, p->debug_output, mesg);
}

void
rb_parser_fatal(struct parser_params *p, const char *fmt, ...)
{
    va_list ap;
    VALUE mesg = rb_str_new_cstr("internal parser error: ");

    va_start(ap, fmt);
    rb_str_vcatf(mesg, fmt, ap);
    va_end(ap);
    yyerror0(RSTRING_PTR(mesg));
    RB_GC_GUARD(mesg);

    mesg = rb_str_new(0, 0);
    append_lex_state_name(p, p->lex.state, mesg);
    compile_error(p, "lex.state: %"PRIsVALUE, mesg);
    rb_str_resize(mesg, 0);
    append_bitstack_value(p, p->cond_stack, mesg);
    compile_error(p, "cond_stack: %"PRIsVALUE, mesg);
    rb_str_resize(mesg, 0);
    append_bitstack_value(p, p->cmdarg_stack, mesg);
    compile_error(p, "cmdarg_stack: %"PRIsVALUE, mesg);
    if (p->debug_output == rb_ractor_stdout())
        p->debug_output = rb_ractor_stderr();
    p->debug = TRUE;
}

static YYLTYPE *
rb_parser_set_pos(YYLTYPE *yylloc, int sourceline, int beg_pos, int end_pos)
{
    yylloc->beg_pos.lineno = sourceline;
    yylloc->beg_pos.column = beg_pos;
    yylloc->end_pos.lineno = sourceline;
    yylloc->end_pos.column = end_pos;
    return yylloc;
}

YYLTYPE *
rb_parser_set_location_from_strterm_heredoc(struct parser_params *p, rb_strterm_heredoc_t *here, YYLTYPE *yylloc)
{
    int sourceline = here->sourceline;
    int beg_pos = (int)here->offset - here->quote
        - (rb_strlen_lit("<<-") - !(here->func & STR_FUNC_INDENT));
    int end_pos = (int)here->offset + here->length + here->quote;

    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}

YYLTYPE *
rb_parser_set_location_of_delayed_token(struct parser_params *p, YYLTYPE *yylloc)
{
    yylloc->beg_pos.lineno = p->delayed.beg_line;
    yylloc->beg_pos.column = p->delayed.beg_col;
    yylloc->end_pos.lineno = p->delayed.end_line;
    yylloc->end_pos.column = p->delayed.end_col;

    return yylloc;
}

YYLTYPE *
rb_parser_set_location_of_heredoc_end(struct parser_params *p, YYLTYPE *yylloc)
{
    int sourceline = p->ruby_sourceline;
    int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);
    int end_pos = (int)(p->lex.pend - p->lex.pbeg);
    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}

YYLTYPE *
rb_parser_set_location_of_dummy_end(struct parser_params *p, YYLTYPE *yylloc)
{
    yylloc->end_pos = yylloc->beg_pos;

    return yylloc;
}

YYLTYPE *
rb_parser_set_location_of_none(struct parser_params *p, YYLTYPE *yylloc)
{
    int sourceline = p->ruby_sourceline;
    int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);
    int end_pos = (int)(p->lex.ptok - p->lex.pbeg);
    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}

YYLTYPE *
rb_parser_set_location(struct parser_params *p, YYLTYPE *yylloc)
{
    int sourceline = p->ruby_sourceline;
    int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);
    int end_pos = (int)(p->lex.pcur - p->lex.pbeg);
    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}
#endif /* !RIPPER */

static int
assignable0(struct parser_params *p, ID id, const char **err)
{
    if (!id) return -1;
    switch (id) {
      case keyword_self:
        *err = "Can't change the value of self";
        return -1;
      case keyword_nil:
        *err = "Can't assign to nil";
        return -1;
      case keyword_true:
        *err = "Can't assign to true";
        return -1;
      case keyword_false:
        *err = "Can't assign to false";
        return -1;
      case keyword__FILE__:
        *err = "Can't assign to __FILE__";
        return -1;
      case keyword__LINE__:
        *err = "Can't assign to __LINE__";
        return -1;
      case keyword__ENCODING__:
        *err = "Can't assign to __ENCODING__";
        return -1;
    }
    switch (id_type(id)) {
      case ID_LOCAL:
        if (dyna_in_block(p)) {
            if (p->max_numparam > NO_PARAM && NUMPARAM_ID_P(id)) {
                compile_error(p, "Can't assign to numbered parameter _%d",
                              NUMPARAM_ID_TO_IDX(id));
                return -1;
            }
            if (dvar_curr(p, id)) return NODE_DASGN;
            if (dvar_defined(p, id)) return NODE_DASGN;
            if (local_id(p, id)) return NODE_LASGN;
            dyna_var(p, id);
            return NODE_DASGN;
        }
        else {
            if (!local_id(p, id)) local_var(p, id);
            return NODE_LASGN;
        }
        break;
      case ID_GLOBAL: return NODE_GASGN;
      case ID_INSTANCE: return NODE_IASGN;
      case ID_CONST:
        if (!p->ctxt.in_def) return NODE_CDECL;
        *err = "dynamic constant assignment";
        return -1;
      case ID_CLASS: return NODE_CVASGN;
      default:
        compile_error(p, "identifier %"PRIsVALUE" is not valid to set", rb_id2str(id));
    }
    return -1;
}

static NODE*
assignable(struct parser_params *p, ID id, NODE *val, const YYLTYPE *loc)
{
    const char *err = 0;
    int node_type = assignable0(p, id, &err);
    switch (node_type) {
      case NODE_DASGN: return NEW_DASGN(id, val, loc);
      case NODE_LASGN: return NEW_LASGN(id, val, loc);
      case NODE_GASGN: return NEW_GASGN(id, val, loc);
      case NODE_IASGN: return NEW_IASGN(id, val, loc);
      case NODE_CDECL: return NEW_CDECL(id, val, 0, p->ctxt.shareable_constant_value, loc);
      case NODE_CVASGN: return NEW_CVASGN(id, val, loc);
    }
/* TODO: FIXME */
#ifndef RIPPER
    if (err) yyerror1(loc, err);
#else
    if (err) set_value(assign_error(p, err, p->s_lvalue));
#endif
    return NEW_ERROR(loc);
}

static int
is_private_local_id(struct parser_params *p, ID name)
{
    VALUE s;
    if (name == idUScore) return 1;
    if (!is_local_id(name)) return 0;
    s = rb_id2str(name);
    if (!s) return 0;
    return RSTRING_PTR(s)[0] == '_';
}

static int
shadowing_lvar_0(struct parser_params *p, ID name)
{
    if (dyna_in_block(p)) {
        if (dvar_curr(p, name)) {
            if (is_private_local_id(p, name)) return 1;
            yyerror0("duplicated argument name");
        }
        else if (dvar_defined(p, name) || local_id(p, name)) {
            vtable_add(p->lvtbl->vars, name);
            if (p->lvtbl->used) {
                vtable_add(p->lvtbl->used, (ID)p->ruby_sourceline | LVAR_USED);
            }
            return 0;
        }
    }
    else {
        if (local_id(p, name)) {
            if (is_private_local_id(p, name)) return 1;
            yyerror0("duplicated argument name");
        }
    }
    return 1;
}

static ID
shadowing_lvar(struct parser_params *p, ID name)
{
    shadowing_lvar_0(p, name);
    return name;
}

static void
new_bv(struct parser_params *p, ID name)
{
    if (!name) return;
    if (!is_local_id(name)) {
        compile_error(p, "invalid local variable - %"PRIsVALUE,
                      rb_id2str(name));
        return;
    }
    if (!shadowing_lvar_0(p, name)) return;
    dyna_var(p, name);
    ID *vidp = 0;
    if (dvar_defined_ref(p, name, &vidp)) {
        if (vidp) *vidp |= LVAR_USED;
    }
}

static void
aryset_check(struct parser_params *p, NODE *args)
{
    NODE *block = 0, *kwds = 0;
    if (args && nd_type_p(args, NODE_BLOCK_PASS)) {
        block = RNODE_BLOCK_PASS(args)->nd_body;
        args = RNODE_BLOCK_PASS(args)->nd_head;
    }
    if (args && nd_type_p(args, NODE_ARGSCAT)) {
        args = RNODE_ARGSCAT(args)->nd_body;
    }
    if (args && nd_type_p(args, NODE_ARGSPUSH)) {
        kwds = RNODE_ARGSPUSH(args)->nd_body;
    }
    else {
        for (NODE *next = args; next && nd_type_p(next, NODE_LIST);
             next = RNODE_LIST(next)->nd_next) {
            kwds = RNODE_LIST(next)->nd_head;
        }
    }
    if (kwds && nd_type_p(kwds, NODE_HASH) && !RNODE_HASH(kwds)->nd_brace) {
        yyerror1(&kwds->nd_loc, "keyword arg given in index assignment");
    }
    if (block) {
        yyerror1(&block->nd_loc, "block arg given in index assignment");
    }
}

static NODE *
aryset(struct parser_params *p, NODE *recv, NODE *idx, const YYLTYPE *loc)
{
    aryset_check(p, idx);
    return NEW_ATTRASGN(recv, tASET, idx, loc);
}

static void
block_dup_check(struct parser_params *p, NODE *node1, NODE *node2)
{
    if (node2 && node1 && nd_type_p(node1, NODE_BLOCK_PASS)) {
        compile_error(p, "both block arg and actual block given");
    }
}

static NODE *
attrset(struct parser_params *p, NODE *recv, ID atype, ID id, const YYLTYPE *loc)
{
    if (!CALL_Q_P(atype)) id = rb_id_attrset(id);
    return NEW_ATTRASGN(recv, id, 0, loc);
}

static VALUE
rb_backref_error(struct parser_params *p, NODE *node)
{
#ifndef RIPPER
# define ERR(...) (compile_error(p, __VA_ARGS__), Qtrue)
#else
# define ERR(...) rb_sprintf(__VA_ARGS__)
#endif
    switch (nd_type(node)) {
      case NODE_NTH_REF:
        return ERR("Can't set variable $%ld", RNODE_NTH_REF(node)->nd_nth);
      case NODE_BACK_REF:
        return ERR("Can't set variable $%c", (int)RNODE_BACK_REF(node)->nd_nth);
    }
#undef ERR
    UNREACHABLE_RETURN(Qfalse); /* only called on syntax error */
}

static NODE *
arg_append(struct parser_params *p, NODE *node1, NODE *node2, const YYLTYPE *loc)
{
    if (!node1) return NEW_LIST(node2, &node2->nd_loc);
    switch (nd_type(node1))  {
      case NODE_LIST:
        return list_append(p, node1, node2);
      case NODE_BLOCK_PASS:
        RNODE_BLOCK_PASS(node1)->nd_head = arg_append(p, RNODE_BLOCK_PASS(node1)->nd_head, node2, loc);
        node1->nd_loc.end_pos = RNODE_BLOCK_PASS(node1)->nd_head->nd_loc.end_pos;
        return node1;
      case NODE_ARGSPUSH:
        RNODE_ARGSPUSH(node1)->nd_body = list_append(p, NEW_LIST(RNODE_ARGSPUSH(node1)->nd_body, &RNODE_ARGSPUSH(node1)->nd_body->nd_loc), node2);
        node1->nd_loc.end_pos = RNODE_ARGSPUSH(node1)->nd_body->nd_loc.end_pos;
        nd_set_type(node1, NODE_ARGSCAT);
        return node1;
      case NODE_ARGSCAT:
        if (!nd_type_p(RNODE_ARGSCAT(node1)->nd_body, NODE_LIST)) break;
        RNODE_ARGSCAT(node1)->nd_body = list_append(p, RNODE_ARGSCAT(node1)->nd_body, node2);
        node1->nd_loc.end_pos = RNODE_ARGSCAT(node1)->nd_body->nd_loc.end_pos;
        return node1;
    }
    return NEW_ARGSPUSH(node1, node2, loc);
}

static NODE *
arg_concat(struct parser_params *p, NODE *node1, NODE *node2, const YYLTYPE *loc)
{
    if (!node2) return node1;
    switch (nd_type(node1)) {
      case NODE_BLOCK_PASS:
        if (RNODE_BLOCK_PASS(node1)->nd_head)
            RNODE_BLOCK_PASS(node1)->nd_head = arg_concat(p, RNODE_BLOCK_PASS(node1)->nd_head, node2, loc);
        else
            RNODE_LIST(node1)->nd_head = NEW_LIST(node2, loc);
        return node1;
      case NODE_ARGSPUSH:
        if (!nd_type_p(node2, NODE_LIST)) break;
        RNODE_ARGSPUSH(node1)->nd_body = list_concat(NEW_LIST(RNODE_ARGSPUSH(node1)->nd_body, loc), node2);
        nd_set_type(node1, NODE_ARGSCAT);
        return node1;
      case NODE_ARGSCAT:
        if (!nd_type_p(node2, NODE_LIST) ||
            !nd_type_p(RNODE_ARGSCAT(node1)->nd_body, NODE_LIST)) break;
        RNODE_ARGSCAT(node1)->nd_body = list_concat(RNODE_ARGSCAT(node1)->nd_body, node2);
        return node1;
    }
    return NEW_ARGSCAT(node1, node2, loc);
}

static NODE *
last_arg_append(struct parser_params *p, NODE *args, NODE *last_arg, const YYLTYPE *loc)
{
    NODE *n1;
    if ((n1 = splat_array(args)) != 0) {
        return list_append(p, n1, last_arg);
    }
    return arg_append(p, args, last_arg, loc);
}

static NODE *
rest_arg_append(struct parser_params *p, NODE *args, NODE *rest_arg, const YYLTYPE *loc)
{
    NODE *n1;
    if ((nd_type_p(rest_arg, NODE_LIST)) && (n1 = splat_array(args)) != 0) {
        return list_concat(n1, rest_arg);
    }
    return arg_concat(p, args, rest_arg, loc);
}

static NODE *
splat_array(NODE* node)
{
    if (nd_type_p(node, NODE_SPLAT)) node = RNODE_SPLAT(node)->nd_head;
    if (nd_type_p(node, NODE_LIST)) return node;
    return 0;
}

static void
mark_lvar_used(struct parser_params *p, NODE *rhs)
{
    ID *vidp = NULL;
    if (!rhs) return;
    switch (nd_type(rhs)) {
      case NODE_LASGN:
        if (local_id_ref(p, RNODE_LASGN(rhs)->nd_vid, &vidp)) {
            if (vidp) *vidp |= LVAR_USED;
        }
        break;
      case NODE_DASGN:
        if (dvar_defined_ref(p, RNODE_DASGN(rhs)->nd_vid, &vidp)) {
            if (vidp) *vidp |= LVAR_USED;
        }
        break;
#if 0
      case NODE_MASGN:
        for (rhs = rhs->nd_head; rhs; rhs = rhs->nd_next) {
            mark_lvar_used(p, rhs->nd_head);
        }
        break;
#endif
    }
}

static int is_static_content(NODE *node);

static NODE *
node_assign(struct parser_params *p, NODE *lhs, NODE *rhs, struct lex_context ctxt, const YYLTYPE *loc)
{
    if (!lhs) return 0;

    switch (nd_type(lhs)) {
      case NODE_CDECL:
      case NODE_GASGN:
      case NODE_IASGN:
      case NODE_LASGN:
      case NODE_DASGN:
      case NODE_MASGN:
      case NODE_CVASGN:
        set_nd_value(p, lhs, rhs);
        nd_set_loc(lhs, loc);
        break;

      case NODE_ATTRASGN:
        RNODE_ATTRASGN(lhs)->nd_args = arg_append(p, RNODE_ATTRASGN(lhs)->nd_args, rhs, loc);
        nd_set_loc(lhs, loc);
        break;

      default:
        /* should not happen */
        break;
    }

    return lhs;
}

static NODE *
value_expr_check(struct parser_params *p, NODE *node)
{
    NODE *void_node = 0, *vn;

    if (!node) {
        rb_warning0("empty expression");
    }
    while (node) {
        switch (nd_type(node)) {
          case NODE_ENSURE:
            vn = RNODE_ENSURE(node)->nd_head;
            node = RNODE_ENSURE(node)->nd_ensr;
            /* nd_ensr should not be NULL, check it out next */
            if (vn && (vn = value_expr_check(p, vn))) {
                goto found;
            }
            break;

          case NODE_RESCUE:
            /* void only if all children are void */
            vn = RNODE_RESCUE(node)->nd_head;
            if (!vn || !(vn = value_expr_check(p, vn))) return NULL;
            if (!void_node) void_node = vn;
            for (NODE *r = RNODE_RESCUE(node)->nd_resq; r; r = RNODE_RESBODY(r)->nd_next) {
                if (!nd_type_p(r, NODE_RESBODY)) {
                    compile_error(p, "unexpected node");
                    return NULL;
                }
                if (!(vn = value_expr_check(p, RNODE_RESBODY(r)->nd_body))) {
                    void_node = 0;
                    break;
                }
                if (!void_node) void_node = vn;
            }
            node = RNODE_RESCUE(node)->nd_else;
            if (!node) return void_node;
            break;

          case NODE_RETURN:
          case NODE_BREAK:
          case NODE_NEXT:
          case NODE_REDO:
          case NODE_RETRY:
            goto found;

          case NODE_CASE3:
            if (!RNODE_CASE3(node)->nd_body || !nd_type_p(RNODE_CASE3(node)->nd_body, NODE_IN)) {
                compile_error(p, "unexpected node");
                return NULL;
            }
            if (RNODE_IN(RNODE_CASE3(node)->nd_body)->nd_body) {
                return NULL;
            }
            /* single line pattern matching with "=>" operator */
            goto found;

          case NODE_BLOCK:
            while (RNODE_BLOCK(node)->nd_next) {
                node = RNODE_BLOCK(node)->nd_next;
            }
            node = RNODE_BLOCK(node)->nd_head;
            break;

          case NODE_BEGIN:
            node = RNODE_BEGIN(node)->nd_body;
            break;

          case NODE_IF:
          case NODE_UNLESS:
            if (!RNODE_IF(node)->nd_body) {
                return NULL;
            }
            else if (!RNODE_IF(node)->nd_else) {
                return NULL;
            }
            vn = value_expr_check(p, RNODE_IF(node)->nd_body);
            if (!vn) return NULL;
            if (!void_node) void_node = vn;
            node = RNODE_IF(node)->nd_else;
            break;

          case NODE_AND:
          case NODE_OR:
            node = RNODE_AND(node)->nd_1st;
            break;

          case NODE_LASGN:
          case NODE_DASGN:
          case NODE_MASGN:
            mark_lvar_used(p, node);
            return NULL;

          default:
            return NULL;
        }
    }

    return NULL;

  found:
    /* return the first found node */
    return void_node ? void_node : node;
}

static int
value_expr_gen(struct parser_params *p, NODE *node)
{
    NODE *void_node = value_expr_check(p, node);
    if (void_node) {
        yyerror1(&void_node->nd_loc, "void value expression");
        /* or "control never reach"? */
        return FALSE;
    }
    return TRUE;
}

static void
void_expr(struct parser_params *p, NODE *node)
{
    const char *useless = 0;

    if (!RTEST(ruby_verbose)) return;

    if (!node || !(node = nd_once_body(node))) return;
    switch (nd_type(node)) {
      case NODE_OPCALL:
        switch (RNODE_OPCALL(node)->nd_mid) {
          case '+':
          case '-':
          case '*':
          case '/':
          case '%':
          case tPOW:
          case tUPLUS:
          case tUMINUS:
          case '|':
          case '^':
          case '&':
          case tCMP:
          case '>':
          case tGEQ:
          case '<':
          case tLEQ:
          case tEQ:
          case tNEQ:
            useless = rb_id2name(RNODE_OPCALL(node)->nd_mid);
            break;
        }
        break;

      case NODE_LVAR:
      case NODE_DVAR:
      case NODE_GVAR:
      case NODE_IVAR:
      case NODE_CVAR:
      case NODE_NTH_REF:
      case NODE_BACK_REF:
        useless = "a variable";
        break;
      case NODE_CONST:
        useless = "a constant";
        break;
      case NODE_SYM:
      case NODE_LINE:
      case NODE_FILE:
      case NODE_ENCODING:
      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
      case NODE_STR:
      case NODE_DSTR:
      case NODE_REGX:
      case NODE_DREGX:
        useless = "a literal";
        break;
      case NODE_COLON2:
      case NODE_COLON3:
        useless = "::";
        break;
      case NODE_DOT2:
        useless = "..";
        break;
      case NODE_DOT3:
        useless = "...";
        break;
      case NODE_SELF:
        useless = "self";
        break;
      case NODE_NIL:
        useless = "nil";
        break;
      case NODE_TRUE:
        useless = "true";
        break;
      case NODE_FALSE:
        useless = "false";
        break;
      case NODE_DEFINED:
        useless = "defined?";
        break;
    }

    if (useless) {
        rb_warn1L(nd_line(node), "possibly useless use of %s in void context", WARN_S(useless));
    }
}

/* warns useless use of block and returns the last statement node */
static NODE *
void_stmts(struct parser_params *p, NODE *node)
{
    NODE *const n = node;
    if (!RTEST(ruby_verbose)) return n;
    if (!node) return n;
    if (!nd_type_p(node, NODE_BLOCK)) return n;

    while (RNODE_BLOCK(node)->nd_next) {
        void_expr(p, RNODE_BLOCK(node)->nd_head);
        node = RNODE_BLOCK(node)->nd_next;
    }
    return RNODE_BLOCK(node)->nd_head;
}

static NODE *
remove_begin(NODE *node)
{
    NODE **n = &node, *n1 = node;
    while (n1 && nd_type_p(n1, NODE_BEGIN) && RNODE_BEGIN(n1)->nd_body) {
        *n = n1 = RNODE_BEGIN(n1)->nd_body;
    }
    return node;
}

static void
reduce_nodes(struct parser_params *p, NODE **body)
{
    NODE *node = *body;

    if (!node) {
        *body = NEW_NIL(&NULL_LOC);
        return;
    }
#define subnodes(type, n1, n2) \
    ((!type(node)->n1) ? (type(node)->n2 ? (body = &type(node)->n2, 1) : 0) : \
     (!type(node)->n2) ? (body = &type(node)->n1, 1) : \
     (reduce_nodes(p, &type(node)->n1), body = &type(node)->n2, 1))

    while (node) {
        int newline = (int)nd_fl_newline(node);
        switch (nd_type(node)) {
          end:
          case NODE_NIL:
            *body = 0;
            return;
          case NODE_BEGIN:
            *body = node = RNODE_BEGIN(node)->nd_body;
            if (newline && node) nd_set_fl_newline(node);
            continue;
          case NODE_BLOCK:
            body = &RNODE_BLOCK(RNODE_BLOCK(node)->nd_end)->nd_head;
            break;
          case NODE_IF:
          case NODE_UNLESS:
            if (subnodes(RNODE_IF, nd_body, nd_else)) break;
            return;
          case NODE_CASE:
            body = &RNODE_CASE(node)->nd_body;
            break;
          case NODE_WHEN:
            if (!subnodes(RNODE_WHEN, nd_body, nd_next)) goto end;
            break;
          case NODE_ENSURE:
            body = &RNODE_ENSURE(node)->nd_head;
            break;
          case NODE_RESCUE:
            newline = 0; // RESBODY should not be a NEWLINE
            if (RNODE_RESCUE(node)->nd_else) {
                body = &RNODE_RESCUE(node)->nd_resq;
                break;
            }
            if (!subnodes(RNODE_RESCUE, nd_head, nd_resq)) goto end;
            break;
          default:
            return;
        }
        node = *body;
        if (newline && node) nd_set_fl_newline(node);
    }

#undef subnodes
}

static int
is_static_content(NODE *node)
{
    if (!node) return 1;
    switch (nd_type(node)) {
      case NODE_HASH:
        if (!(node = RNODE_HASH(node)->nd_head)) break;
      case NODE_LIST:
        do {
            if (!is_static_content(RNODE_LIST(node)->nd_head)) return 0;
        } while ((node = RNODE_LIST(node)->nd_next) != 0);
      case NODE_SYM:
      case NODE_REGX:
      case NODE_LINE:
      case NODE_FILE:
      case NODE_ENCODING:
      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
      case NODE_STR:
      case NODE_NIL:
      case NODE_TRUE:
      case NODE_FALSE:
      case NODE_ZLIST:
        break;
      default:
        return 0;
    }
    return 1;
}

static int
assign_in_cond(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_MASGN:
      case NODE_LASGN:
      case NODE_DASGN:
      case NODE_GASGN:
      case NODE_IASGN:
      case NODE_CVASGN:
      case NODE_CDECL:
        break;

      default:
        return 0;
    }

    if (!get_nd_value(p, node)) return 1;
    if (is_static_content(get_nd_value(p, node))) {
        /* reports always */
        rb_warn0L(nd_line(get_nd_value(p, node)), "found '= literal' in conditional, should be ==");
    }
    return 1;
}

enum cond_type {
    COND_IN_OP,
    COND_IN_COND,
    COND_IN_FF
};

#define SWITCH_BY_COND_TYPE(t, w, arg) do { \
    switch (t) { \
      case COND_IN_OP: break; \
      case COND_IN_COND: rb_##w##0(arg "literal in condition"); break; \
      case COND_IN_FF: rb_##w##0(arg "literal in flip-flop"); break; \
    } \
} while (0)

static NODE *cond0(struct parser_params*,NODE*,enum cond_type,const YYLTYPE*,bool);

static NODE*
range_op(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    enum node_type type;

    if (node == 0) return 0;

    type = nd_type(node);
    value_expr(node);
    if (type == NODE_INTEGER) {
        if (!e_option_supplied(p)) rb_warn0L(nd_line(node), "integer literal in flip-flop");
        ID lineno = rb_intern("$.");
        return NEW_CALL(node, tEQ, NEW_LIST(NEW_GVAR(lineno, loc), loc), loc);
    }
    return cond0(p, node, COND_IN_FF, loc, true);
}

static NODE*
cond0(struct parser_params *p, NODE *node, enum cond_type type, const YYLTYPE *loc, bool top)
{
    if (node == 0) return 0;
    if (!(node = nd_once_body(node))) return 0;
    assign_in_cond(p, node);

    switch (nd_type(node)) {
      case NODE_BEGIN:
        RNODE_BEGIN(node)->nd_body = cond0(p, RNODE_BEGIN(node)->nd_body, type, loc, top);
        break;

      case NODE_DSTR:
      case NODE_EVSTR:
      case NODE_STR:
      case NODE_FILE:
        SWITCH_BY_COND_TYPE(type, warn, "string ");
        break;

      case NODE_REGX:
        if (!e_option_supplied(p)) SWITCH_BY_COND_TYPE(type, warn, "regex ");
        nd_set_type(node, NODE_MATCH);
        break;

      case NODE_DREGX:
        if (!e_option_supplied(p)) SWITCH_BY_COND_TYPE(type, warning, "regex ");

        return NEW_MATCH2(node, NEW_GVAR(idLASTLINE, loc), loc);

      case NODE_BLOCK:
        {
            NODE *end = RNODE_BLOCK(node)->nd_end;
            NODE **expr = &RNODE_BLOCK(end)->nd_head;
            if (top) top = node == end;
            *expr = cond0(p, *expr, type, loc, top);
        }
        break;

      case NODE_AND:
      case NODE_OR:
        RNODE_AND(node)->nd_1st = cond0(p, RNODE_AND(node)->nd_1st, COND_IN_COND, loc, true);
        RNODE_AND(node)->nd_2nd = cond0(p, RNODE_AND(node)->nd_2nd, COND_IN_COND, loc, true);
        break;

      case NODE_DOT2:
      case NODE_DOT3:
        if (!top) break;
        RNODE_DOT2(node)->nd_beg = range_op(p, RNODE_DOT2(node)->nd_beg, loc);
        RNODE_DOT2(node)->nd_end = range_op(p, RNODE_DOT2(node)->nd_end, loc);
        switch (nd_type(node)) {
          case NODE_DOT2:
            nd_set_type(node,NODE_FLIP2);
            rb_node_flip2_t *flip2 = RNODE_FLIP2(node); /* for debug info */
            (void)flip2;
            break;
          case NODE_DOT3:
            nd_set_type(node, NODE_FLIP3);
            rb_node_flip3_t *flip3 = RNODE_FLIP3(node); /* for debug info */
            (void)flip3;
            break;
        }
        break;

      case NODE_SYM:
      case NODE_DSYM:
        SWITCH_BY_COND_TYPE(type, warning, "symbol ");
        break;

      case NODE_LINE:
        SWITCH_BY_COND_TYPE(type, warning, "");
        break;

      case NODE_ENCODING:
        SWITCH_BY_COND_TYPE(type, warning, "");
        break;

      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
        SWITCH_BY_COND_TYPE(type, warning, "");
        break;

      default:
        break;
    }
    return node;
}

static NODE*
cond(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (node == 0) return 0;
    return cond0(p, node, COND_IN_COND, loc, true);
}

static NODE*
method_cond(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (node == 0) return 0;
    return cond0(p, node, COND_IN_OP, loc, true);
}

static NODE*
new_nil_at(struct parser_params *p, const rb_code_position_t *pos)
{
    YYLTYPE loc = {*pos, *pos};
    return NEW_NIL(&loc);
}

static NODE*
new_if(struct parser_params *p, NODE *cc, NODE *left, NODE *right, const YYLTYPE *loc)
{
    if (!cc) return right;
    cc = cond0(p, cc, COND_IN_COND, loc, true);
    return newline_node(NEW_IF(cc, left, right, loc));
}

static NODE*
new_unless(struct parser_params *p, NODE *cc, NODE *left, NODE *right, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    if (!cc) return right;
    cc = cond0(p, cc, COND_IN_COND, loc, true);
    return newline_node(NEW_UNLESS(cc, left, right, loc, keyword_loc, then_keyword_loc, end_keyword_loc));
}

#define NEW_AND_OR(type, f, s, loc, op_loc) (type == NODE_AND ? NEW_AND(f,s,loc,op_loc) : NEW_OR(f,s,loc,op_loc))

static NODE*
logop(struct parser_params *p, ID id, NODE *left, NODE *right,
          const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    enum node_type type = id == idAND || id == idANDOP ? NODE_AND : NODE_OR;
    NODE *op;
    value_expr(left);
    if (left && nd_type_p(left, type)) {
        NODE *node = left, *second;
        while ((second = RNODE_AND(node)->nd_2nd) != 0 && nd_type_p(second, type)) {
            node = second;
        }
        RNODE_AND(node)->nd_2nd = NEW_AND_OR(type, second, right, loc, op_loc);
        nd_set_line(RNODE_AND(node)->nd_2nd, op_loc->beg_pos.lineno);
        left->nd_loc.end_pos = loc->end_pos;
        return left;
    }
    op = NEW_AND_OR(type, left, right, loc, op_loc);
    nd_set_line(op, op_loc->beg_pos.lineno);
    return op;
}

#undef NEW_AND_OR

static void
no_blockarg(struct parser_params *p, NODE *node)
{
    if (nd_type_p(node, NODE_BLOCK_PASS)) {
        compile_error(p, "block argument should not be given");
    }
}

static NODE *
ret_args(struct parser_params *p, NODE *node)
{
    if (node) {
        no_blockarg(p, node);
        if (nd_type_p(node, NODE_LIST) && !RNODE_LIST(node)->nd_next) {
            node = RNODE_LIST(node)->nd_head;
        }
    }
    return node;
}

static NODE *
new_yield(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (node) no_blockarg(p, node);

    return NEW_YIELD(node, loc);
}

static NODE*
negate_lit(struct parser_params *p, NODE* node)
{
    switch (nd_type(node)) {
      case NODE_INTEGER:
        RNODE_INTEGER(node)->minus = TRUE;
        break;
      case NODE_FLOAT:
        RNODE_FLOAT(node)->minus = TRUE;
        break;
      case NODE_RATIONAL:
        RNODE_RATIONAL(node)->minus = TRUE;
        break;
      case NODE_IMAGINARY:
        RNODE_IMAGINARY(node)->minus = TRUE;
        break;
    }
    return node;
}

static NODE *
arg_blk_pass(NODE *node1, rb_node_block_pass_t *node2)
{
    if (node2) {
        if (!node1) return (NODE *)node2;
        node2->nd_head = node1;
        nd_set_first_lineno(node2, nd_first_lineno(node1));
        nd_set_first_column(node2, nd_first_column(node1));
        return (NODE *)node2;
    }
    return node1;
}

static bool
args_info_empty_p(struct rb_args_info *args)
{
    if (args->pre_args_num) return false;
    if (args->post_args_num) return false;
    if (args->rest_arg) return false;
    if (args->opt_args) return false;
    if (args->block_arg) return false;
    if (args->kw_args) return false;
    if (args->kw_rest_arg) return false;
    return true;
}

static rb_node_args_t *
new_args(struct parser_params *p, rb_node_args_aux_t *pre_args, rb_node_opt_arg_t *opt_args, ID rest_arg, rb_node_args_aux_t *post_args, rb_node_args_t *tail, const YYLTYPE *loc)
{
    struct rb_args_info *args = &tail->nd_ainfo;

    if (args->forwarding) {
        if (rest_arg) {
            yyerror1(&RNODE(tail)->nd_loc, "... after rest argument");
            return tail;
        }
        rest_arg = idFWD_REST;
    }

    args->pre_args_num   = pre_args ? pre_args->nd_plen : 0;
    args->pre_init       = pre_args ? pre_args->nd_next : 0;

    args->post_args_num  = post_args ? post_args->nd_plen : 0;
    args->post_init      = post_args ? post_args->nd_next : 0;
    args->first_post_arg = post_args ? post_args->nd_pid : 0;

    args->rest_arg       = rest_arg;

    args->opt_args       = opt_args;

#ifdef FORWARD_ARGS_WITH_RUBY2_KEYWORDS
    args->ruby2_keywords = args->forwarding;
#else
    args->ruby2_keywords = 0;
#endif

    nd_set_loc(RNODE(tail), loc);

    return tail;
}

static rb_node_args_t *
new_args_tail(struct parser_params *p, rb_node_kw_arg_t *kw_args, ID kw_rest_arg, ID block, const YYLTYPE *kw_rest_loc)
{
    rb_node_args_t *node = NEW_ARGS(&NULL_LOC);
    struct rb_args_info *args = &node->nd_ainfo;
    if (p->error_p) return node;

    args->block_arg      = block;
    args->kw_args        = kw_args;

    if (kw_args) {
        /*
         * def foo(k1: 1, kr1:, k2: 2, **krest, &b)
         * variable order: k1, kr1, k2, &b, internal_id, krest
         * #=> <reorder>
         * variable order: kr1, k1, k2, internal_id, krest, &b
         */
        ID kw_bits = internal_id(p), *required_kw_vars, *kw_vars;
        struct vtable *vtargs = p->lvtbl->args;
        rb_node_kw_arg_t *kwn = kw_args;

        if (block) block = vtargs->tbl[vtargs->pos-1];
        vtable_pop(vtargs, !!block + !!kw_rest_arg);
        required_kw_vars = kw_vars = &vtargs->tbl[vtargs->pos];
        while (kwn) {
            if (!NODE_REQUIRED_KEYWORD_P(get_nd_value(p, kwn->nd_body)))
                --kw_vars;
            --required_kw_vars;
            kwn = kwn->nd_next;
        }

        for (kwn = kw_args; kwn; kwn = kwn->nd_next) {
            ID vid = get_nd_vid(p, kwn->nd_body);
            if (NODE_REQUIRED_KEYWORD_P(get_nd_value(p, kwn->nd_body))) {
                *required_kw_vars++ = vid;
            }
            else {
                *kw_vars++ = vid;
            }
        }

        arg_var(p, kw_bits);
        if (kw_rest_arg) arg_var(p, kw_rest_arg);
        if (block) arg_var(p, block);

        args->kw_rest_arg = NEW_DVAR(kw_rest_arg, kw_rest_loc);
    }
    else if (kw_rest_arg == idNil) {
        args->no_kwarg = 1;
    }
    else if (kw_rest_arg) {
        args->kw_rest_arg = NEW_DVAR(kw_rest_arg, kw_rest_loc);
    }

    return node;
}

static rb_node_args_t *
args_with_numbered(struct parser_params *p, rb_node_args_t *args, int max_numparam, ID it_id)
{
    if (max_numparam > NO_PARAM || it_id) {
        if (!args) {
            YYLTYPE loc = RUBY_INIT_YYLLOC();
            args = new_args_tail(p, 0, 0, 0, 0);
            nd_set_loc(RNODE(args), &loc);
        }
        args->nd_ainfo.pre_args_num = it_id ? 1 : max_numparam;
    }
    return args;
}

static NODE*
new_array_pattern(struct parser_params *p, NODE *constant, NODE *pre_arg, NODE *aryptn, const YYLTYPE *loc)
{
    RNODE_ARYPTN(aryptn)->nd_pconst = constant;

    if (pre_arg) {
        NODE *pre_args = NEW_LIST(pre_arg, loc);
        if (RNODE_ARYPTN(aryptn)->pre_args) {
            RNODE_ARYPTN(aryptn)->pre_args = list_concat(pre_args, RNODE_ARYPTN(aryptn)->pre_args);
        }
        else {
            RNODE_ARYPTN(aryptn)->pre_args = pre_args;
        }
    }
    return aryptn;
}

static NODE*
new_array_pattern_tail(struct parser_params *p, NODE *pre_args, int has_rest, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc)
{
    if (has_rest) {
        rest_arg = rest_arg ? rest_arg : NODE_SPECIAL_NO_NAME_REST;
    }
    else {
        rest_arg = NULL;
    }
    NODE *node = NEW_ARYPTN(pre_args, rest_arg, post_args, loc);

    return node;
}

static NODE*
new_find_pattern(struct parser_params *p, NODE *constant, NODE *fndptn, const YYLTYPE *loc)
{
    RNODE_FNDPTN(fndptn)->nd_pconst = constant;

    return fndptn;
}

static NODE*
new_find_pattern_tail(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc)
{
    pre_rest_arg = pre_rest_arg ? pre_rest_arg : NODE_SPECIAL_NO_NAME_REST;
    post_rest_arg = post_rest_arg ? post_rest_arg : NODE_SPECIAL_NO_NAME_REST;
    NODE *node = NEW_FNDPTN(pre_rest_arg, args, post_rest_arg, loc);

    return node;
}

static NODE*
new_hash_pattern(struct parser_params *p, NODE *constant, NODE *hshptn, const YYLTYPE *loc)
{
    RNODE_HSHPTN(hshptn)->nd_pconst = constant;
    return hshptn;
}

static NODE*
new_hash_pattern_tail(struct parser_params *p, NODE *kw_args, ID kw_rest_arg, const YYLTYPE *loc)
{
    NODE *node, *kw_rest_arg_node;

    if (kw_rest_arg == idNil) {
        kw_rest_arg_node = NODE_SPECIAL_NO_REST_KEYWORD;
    }
    else if (kw_rest_arg) {
        kw_rest_arg_node = assignable(p, kw_rest_arg, 0, loc);
    }
    else {
        kw_rest_arg_node = NULL;
    }

    node = NEW_HSHPTN(0, kw_args, kw_rest_arg_node, loc);

    return node;
}

static NODE*
dsym_node(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (!node) {
        return NEW_SYM(STR_NEW0(), loc);
    }

    switch (nd_type(node)) {
      case NODE_DSTR:
        nd_set_type(node, NODE_DSYM);
        nd_set_loc(node, loc);
        break;
      case NODE_STR:
        node = str_to_sym_node(p, node, loc);
        break;
      default:
        node = NEW_DSYM(0, 1, NEW_LIST(node, loc), loc);
        break;
    }
    return node;
}

static int
nd_type_st_key_enable_p(NODE *node)
{
    switch (nd_type(node)) {
      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
      case NODE_STR:
      case NODE_SYM:
      case NODE_REGX:
      case NODE_LINE:
      case NODE_FILE:
      case NODE_ENCODING:
        return true;
      default:
        return false;
    }
}

static VALUE
nd_value(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_STR:
        return rb_node_str_string_val(node);
      case NODE_INTEGER:
        return rb_node_integer_literal_val(node);
      case NODE_FLOAT:
        return rb_node_float_literal_val(node);
      case NODE_RATIONAL:
        return rb_node_rational_literal_val(node);
      case NODE_IMAGINARY:
        return rb_node_imaginary_literal_val(node);
      case NODE_SYM:
        return rb_node_sym_string_val(node);
      case NODE_REGX:
        return rb_node_regx_string_val(node);
      case NODE_LINE:
        return rb_node_line_lineno_val(node);
      case NODE_ENCODING:
        return rb_node_encoding_val(node);
      case NODE_FILE:
        return rb_node_file_path_val(node);
      default:
        rb_bug("unexpected node: %s", ruby_node_name(nd_type(node)));
        UNREACHABLE_RETURN(0);
    }
}

static void
warn_duplicate_keys(struct parser_params *p, NODE *hash)
{
    /* See https://bugs.ruby-lang.org/issues/20331 for discussion about what is warned. */
    p->warn_duplicate_keys_table = st_init_table_with_size(&literal_type, RNODE_LIST(hash)->as.nd_alen / 2);
    while (hash && RNODE_LIST(hash)->nd_next) {
        NODE *head = RNODE_LIST(hash)->nd_head;
        NODE *value = RNODE_LIST(hash)->nd_next;
        NODE *next = RNODE_LIST(value)->nd_next;
        st_data_t key;
        st_data_t data;

        /* keyword splat, e.g. {k: 1, **z, k: 2} */
        if (!head) {
            head = value;
        }

        if (nd_type_st_key_enable_p(head)) {
            key = (st_data_t)head;

            if (st_delete(p->warn_duplicate_keys_table, &key, &data)) {
                rb_warn2L(nd_line((NODE *)data),
                          "key %+"PRIsWARN" is duplicated and overwritten on line %d",
                          nd_value(p, head), WARN_I(nd_line(head)));
            }
            st_insert(p->warn_duplicate_keys_table, (st_data_t)key, (st_data_t)hash);
        }
        hash = next;
    }
    st_free_table(p->warn_duplicate_keys_table);
    p->warn_duplicate_keys_table = NULL;
}

static NODE *
new_hash(struct parser_params *p, NODE *hash, const YYLTYPE *loc)
{
    if (hash) warn_duplicate_keys(p, hash);
    return NEW_HASH(hash, loc);
}

static void
error_duplicate_pattern_variable(struct parser_params *p, ID id, const YYLTYPE *loc)
{
    if (is_private_local_id(p, id)) {
        return;
    }
    if (st_is_member(p->pvtbl, id)) {
        yyerror1(loc, "duplicated variable name");
    }
    else {
        st_insert(p->pvtbl, (st_data_t)id, 0);
    }
}

static void
error_duplicate_pattern_key(struct parser_params *p, VALUE key, const YYLTYPE *loc)
{
    if (!p->pktbl) {
        p->pktbl = st_init_numtable();
    }
    else if (st_is_member(p->pktbl, key)) {
        yyerror1(loc, "duplicated key name");
        return;
    }
    st_insert(p->pktbl, (st_data_t)key, 0);
}

static NODE *
new_unique_key_hash(struct parser_params *p, NODE *hash, const YYLTYPE *loc)
{
    return NEW_HASH(hash, loc);
}

static NODE *
new_op_assign(struct parser_params *p, NODE *lhs, ID op, NODE *rhs, struct lex_context ctxt, const YYLTYPE *loc)
{
    NODE *asgn;

    if (lhs) {
        ID vid = get_nd_vid(p, lhs);
        YYLTYPE lhs_loc = lhs->nd_loc;
        if (op == tOROP) {
            set_nd_value(p, lhs, rhs);
            nd_set_loc(lhs, loc);
            asgn = NEW_OP_ASGN_OR(gettable(p, vid, &lhs_loc), lhs, loc);
        }
        else if (op == tANDOP) {
            set_nd_value(p, lhs, rhs);
            nd_set_loc(lhs, loc);
            asgn = NEW_OP_ASGN_AND(gettable(p, vid, &lhs_loc), lhs, loc);
        }
        else {
            asgn = lhs;
            rhs = NEW_CALL(gettable(p, vid, &lhs_loc), op, NEW_LIST(rhs, &rhs->nd_loc), loc);
            set_nd_value(p, asgn, rhs);
            nd_set_loc(asgn, loc);
        }
    }
    else {
        asgn = NEW_ERROR(loc);
    }
    return asgn;
}

static NODE *
new_ary_op_assign(struct parser_params *p, NODE *ary,
                  NODE *args, ID op, NODE *rhs, const YYLTYPE *args_loc, const YYLTYPE *loc,
                  const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc)
{
    NODE *asgn;

    aryset_check(p, args);
    args = make_list(args, args_loc);
    asgn = NEW_OP_ASGN1(ary, op, args, rhs, loc, call_operator_loc, opening_loc, closing_loc, binary_operator_loc);
    fixpos(asgn, ary);
    return asgn;
}

static NODE *
new_attr_op_assign(struct parser_params *p, NODE *lhs,
                   ID atype, ID attr, ID op, NODE *rhs, const YYLTYPE *loc,
                   const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc)
{
    NODE *asgn;

    asgn = NEW_OP_ASGN2(lhs, CALL_Q_P(atype), attr, op, rhs, loc, call_operator_loc, message_loc, binary_operator_loc);
    fixpos(asgn, lhs);
    return asgn;
}

static NODE *
new_const_op_assign(struct parser_params *p, NODE *lhs, ID op, NODE *rhs, struct lex_context ctxt, const YYLTYPE *loc)
{
    NODE *asgn;

    if (lhs) {
        asgn = NEW_OP_CDECL(lhs, op, rhs, ctxt.shareable_constant_value, loc);
    }
    else {
        asgn = NEW_ERROR(loc);
    }
    fixpos(asgn, lhs);
    return asgn;
}

static NODE *
const_decl(struct parser_params *p, NODE *path, const YYLTYPE *loc)
{
    if (p->ctxt.in_def) {
#ifndef RIPPER
        yyerror1(loc, "dynamic constant assignment");
#else
        set_value(assign_error(p, "dynamic constant assignment", p->s_lvalue));
#endif
    }
    return NEW_CDECL(0, 0, (path), p->ctxt.shareable_constant_value, loc);
}

#ifdef RIPPER
static VALUE
assign_error(struct parser_params *p, const char *mesg, VALUE a)
{
    a = dispatch2(assign_error, ERR_MESG(), a);
    ripper_error(p);
    return a;
}
#endif

static NODE *
new_bodystmt(struct parser_params *p, NODE *head, NODE *rescue, NODE *rescue_else, NODE *ensure, const YYLTYPE *loc)
{
    NODE *result = head;
    if (rescue) {
        NODE *tmp = rescue_else ? rescue_else : rescue;
        YYLTYPE rescue_loc = code_loc_gen(&head->nd_loc, &tmp->nd_loc);

        result = NEW_RESCUE(head, rescue, rescue_else, &rescue_loc);
        nd_set_line(result, rescue->nd_loc.beg_pos.lineno);
    }
    if (ensure) {
        result = NEW_ENSURE(result, ensure, loc);
    }
    fixpos(result, head);
    return result;
}

static void
warn_unused_var(struct parser_params *p, struct local_vars *local)
{
    int cnt;

    if (!local->used) return;
    cnt = local->used->pos;
    if (cnt != local->vars->pos) {
        rb_parser_fatal(p, "local->used->pos != local->vars->pos");
    }
#ifndef RIPPER
    ID *v = local->vars->tbl;
    ID *u = local->used->tbl;
    for (int i = 0; i < cnt; ++i) {
        if (!v[i] || (u[i] & LVAR_USED)) continue;
        if (is_private_local_id(p, v[i])) continue;
        rb_warn1L((int)u[i], "assigned but unused variable - %"PRIsWARN, rb_id2str(v[i]));
    }
#endif
}

static void
local_push(struct parser_params *p, int toplevel_scope)
{
    struct local_vars *local;
    int inherits_dvars = toplevel_scope && compile_for_eval;
    int warn_unused_vars = RTEST(ruby_verbose);

    local = ALLOC(struct local_vars);
    local->prev = p->lvtbl;
    local->args = vtable_alloc(0);
    local->vars = vtable_alloc(inherits_dvars ? DVARS_INHERIT : DVARS_TOPSCOPE);
#ifndef RIPPER
    if (toplevel_scope && compile_for_eval) warn_unused_vars = 0;
    if (toplevel_scope && e_option_supplied(p)) warn_unused_vars = 0;
#endif
    local->numparam.outer = 0;
    local->numparam.inner = 0;
    local->numparam.current = 0;
    local->it = 0;
    local->used = warn_unused_vars ? vtable_alloc(0) : 0;

# if WARN_PAST_SCOPE
    local->past = 0;
# endif
    CMDARG_PUSH(0);
    COND_PUSH(0);
    p->lvtbl = local;
}

static void
vtable_chain_free(struct parser_params *p, struct vtable *table)
{
    while (!DVARS_TERMINAL_P(table)) {
        struct vtable *cur_table = table;
        table = cur_table->prev;
        vtable_free(cur_table);
    }
}

static void
local_free(struct parser_params *p, struct local_vars *local)
{
    vtable_chain_free(p, local->used);

# if WARN_PAST_SCOPE
    vtable_chain_free(p, local->past);
# endif

    vtable_chain_free(p, local->args);
    vtable_chain_free(p, local->vars);

    ruby_sized_xfree(local, sizeof(struct local_vars));
}

static void
local_pop(struct parser_params *p)
{
    struct local_vars *local = p->lvtbl->prev;
    if (p->lvtbl->used) {
        warn_unused_var(p, p->lvtbl);
    }

    local_free(p, p->lvtbl);
    p->lvtbl = local;

    CMDARG_POP();
    COND_POP();
}

static rb_ast_id_table_t *
local_tbl(struct parser_params *p)
{
    int cnt_args = vtable_size(p->lvtbl->args);
    int cnt_vars = vtable_size(p->lvtbl->vars);
    int cnt = cnt_args + cnt_vars;
    int i, j;
    rb_ast_id_table_t *tbl;

    if (cnt <= 0) return 0;
    tbl = rb_ast_new_local_table(p->ast, cnt);
    MEMCPY(tbl->ids, p->lvtbl->args->tbl, ID, cnt_args);
    /* remove IDs duplicated to warn shadowing */
    for (i = 0, j = cnt_args; i < cnt_vars; ++i) {
        ID id = p->lvtbl->vars->tbl[i];
        if (!vtable_included(p->lvtbl->args, id)) {
            tbl->ids[j++] = id;
        }
    }
    if (j < cnt) {
        tbl = rb_ast_resize_latest_local_table(p->ast, j);
    }

    return tbl;
}

static void
numparam_name(struct parser_params *p, ID id)
{
    if (!NUMPARAM_ID_P(id)) return;
    compile_error(p, "_%d is reserved for numbered parameter",
        NUMPARAM_ID_TO_IDX(id));
}

static void
arg_var(struct parser_params *p, ID id)
{
    numparam_name(p, id);
    vtable_add(p->lvtbl->args, id);
}

static void
local_var(struct parser_params *p, ID id)
{
    numparam_name(p, id);
    vtable_add(p->lvtbl->vars, id);
    if (p->lvtbl->used) {
        vtable_add(p->lvtbl->used, (ID)p->ruby_sourceline);
    }
}

#ifndef RIPPER
int
rb_parser_local_defined(struct parser_params *p, ID id, const struct rb_iseq_struct *iseq)
{
    return rb_local_defined(id, iseq);
}
#endif

static int
local_id_ref(struct parser_params *p, ID id, ID **vidrefp)
{
    struct vtable *vars, *args, *used;

    vars = p->lvtbl->vars;
    args = p->lvtbl->args;
    used = p->lvtbl->used;

    while (vars && !DVARS_TERMINAL_P(vars->prev)) {
        vars = vars->prev;
        args = args->prev;
        if (used) used = used->prev;
    }

    if (vars && vars->prev == DVARS_INHERIT) {
        return rb_parser_local_defined(p, id, p->parent_iseq);
    }
    else if (vtable_included(args, id)) {
        return 1;
    }
    else {
        int i = vtable_included(vars, id);
        if (i && used && vidrefp) *vidrefp = &used->tbl[i-1];
        return i != 0;
    }
}

static int
local_id(struct parser_params *p, ID id)
{
    return local_id_ref(p, id, NULL);
}

static int
check_forwarding_args(struct parser_params *p)
{
    if (local_id(p, idFWD_ALL)) return TRUE;
    compile_error(p, "unexpected ...");
    return FALSE;
}

static void
add_forwarding_args(struct parser_params *p)
{
    arg_var(p, idFWD_REST);
#ifndef FORWARD_ARGS_WITH_RUBY2_KEYWORDS
    arg_var(p, idFWD_KWREST);
#endif
    arg_var(p, idFWD_BLOCK);
    arg_var(p, idFWD_ALL);
}

static void
forwarding_arg_check(struct parser_params *p, ID arg, ID all, const char *var)
{
    bool conflict = false;

    struct vtable *vars, *args;

    vars = p->lvtbl->vars;
    args = p->lvtbl->args;

    while (vars && !DVARS_TERMINAL_P(vars->prev)) {
        conflict |= (vtable_included(args, arg) && !(all && vtable_included(args, all)));
        vars = vars->prev;
        args = args->prev;
    }

    bool found = false;
    if (vars && vars->prev == DVARS_INHERIT && !found) {
        found = (rb_parser_local_defined(p, arg, p->parent_iseq) &&
                 !(all && rb_parser_local_defined(p, all, p->parent_iseq)));
    }
    else {
        found = (vtable_included(args, arg) &&
                 !(all && vtable_included(args, all)));
    }

    if (!found) {
        compile_error(p, "no anonymous %s parameter", var);
    }
    else if (conflict) {
        compile_error(p, "anonymous %s parameter is also used within block", var);
    }
}

static NODE *
new_args_forward_call(struct parser_params *p, NODE *leading, const YYLTYPE *loc, const YYLTYPE *argsloc)
{
    NODE *rest = NEW_LVAR(idFWD_REST, loc);
#ifndef FORWARD_ARGS_WITH_RUBY2_KEYWORDS
    NODE *kwrest = list_append(p, NEW_LIST(0, loc), NEW_LVAR(idFWD_KWREST, loc));
#endif
    rb_node_block_pass_t *block = NEW_BLOCK_PASS(NEW_LVAR(idFWD_BLOCK, loc), argsloc, &NULL_LOC);
    NODE *args = leading ? rest_arg_append(p, leading, rest, argsloc) : NEW_SPLAT(rest, loc, &NULL_LOC);
    block->forwarding = TRUE;
#ifndef FORWARD_ARGS_WITH_RUBY2_KEYWORDS
    args = arg_append(p, args, new_hash(p, kwrest, loc), argsloc);
#endif
    return arg_blk_pass(args, block);
}

static NODE *
numparam_push(struct parser_params *p)
{
    struct local_vars *local = p->lvtbl;
    NODE *inner = local->numparam.inner;
    if (!local->numparam.outer) {
        local->numparam.outer = local->numparam.current;
    }
    local->numparam.inner = 0;
    local->numparam.current = 0;
    local->it = 0;
    return inner;
}

static void
numparam_pop(struct parser_params *p, NODE *prev_inner)
{
    struct local_vars *local = p->lvtbl;
    if (prev_inner) {
        /* prefer first one */
        local->numparam.inner = prev_inner;
    }
    else if (local->numparam.current) {
        /* current and inner are exclusive */
        local->numparam.inner = local->numparam.current;
    }
    if (p->max_numparam > NO_PARAM) {
        /* current and outer are exclusive */
        local->numparam.current = local->numparam.outer;
        local->numparam.outer = 0;
    }
    else {
        /* no numbered parameter */
        local->numparam.current = 0;
    }
    local->it = 0;
}

static const struct vtable *
dyna_push(struct parser_params *p)
{
    p->lvtbl->args = vtable_alloc(p->lvtbl->args);
    p->lvtbl->vars = vtable_alloc(p->lvtbl->vars);
    if (p->lvtbl->used) {
        p->lvtbl->used = vtable_alloc(p->lvtbl->used);
    }
    return p->lvtbl->args;
}

static void
dyna_pop_vtable(struct parser_params *p, struct vtable **vtblp)
{
    struct vtable *tmp = *vtblp;
    *vtblp = tmp->prev;
# if WARN_PAST_SCOPE
    if (p->past_scope_enabled) {
        tmp->prev = p->lvtbl->past;
        p->lvtbl->past = tmp;
        return;
    }
# endif
    vtable_free(tmp);
}

static void
dyna_pop_1(struct parser_params *p)
{
    struct vtable *tmp;

    if ((tmp = p->lvtbl->used) != 0) {
        warn_unused_var(p, p->lvtbl);
        p->lvtbl->used = p->lvtbl->used->prev;
        vtable_free(tmp);
    }
    dyna_pop_vtable(p, &p->lvtbl->args);
    dyna_pop_vtable(p, &p->lvtbl->vars);
}

static void
dyna_po