#!/bin/bash

# Douglas Hofstadter   "Q-޼"(Q-series):

# Q(1) = Q(2) = 1
# Q(n) = Q(n - Q(n-1)) + Q(n - Q(n-2)), for n&gt;2

# "" Q-޼ ̻ϰ    ൿ Դϴ.
#  ޼ ó 20   ϴ:
# 1 1 2 3 3 4 5 5 6 6 6 8 8 8 10 9 10 11 11 12 

# Hofstadter  å, "Goedel, Escher, Bach: An Eternal Golden Braid",
# p. 137, ff.  ϼ.


LIMIT=100     #   
LINEWIDTH=20  #  ٿ   

Q[1]=1        # ó   1.
Q[2]=1

echo
echo "Q-޼ [$LIMIT ]:"
echo -n "${Q[1]} "             # ó   
echo -n "${Q[2]} "

for ((n=3; n <= $LIMIT; n++))  # C   .
do   # Q[n] = Q[n - Q[n-1]] + Q[n - Q[n-2]]  for n&gt;2
# Bash   迭   ó   
#   ѹ  ʰ ߰ ٸ  ξ  ʿ䰡 ֽϴ.

  let "n1 = $n - 1"        # n-1
  let "n2 = $n - 2"        # n-2
  
  t0=`expr $n - ${Q[n1]}`  # n - Q[n-1]
  t1=`expr $n - ${Q[n2]}`  # n - Q[n-2]
  
  T0=${Q[t0]}              # Q[n - Q[n-1]]
  T1=${Q[t1]}              # Q[n - Q[n-2]]

Q[n]=`expr $T0 + $T1`      # Q[n - Q[n-1]] + Q[n - ![n-2]]
echo -n "${Q[n]} "

if [ `expr $n % $LINEWIDTH` -eq 0 ]    #  
then   #    
  echo #   еǵ  .
fi

done

echo

exit 0

# ⼭ Q-޼ ݺ ߽ϴ.
#      ڵ   ڽϴ.
# :  ޼  ϸ ""  ð ɸϴ.
