/*****************************************************************************
  Module: auddev.cpp - Implements the MMDeviceCap and MMDeviceList classes
  Copyright (C) 1999  Andrew L. Sandoval

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/
/* Module: auddev.cpp                                                        */
/* Developer: Andrew L. Sandoval                                             */
/* Purpose: Implements the MMDeviceCap and MMDeviceList classes which show   */
/* available waveIn devices.                                                 */
/*****************************************************************************/
#pragma warning(disable:4786)

#include "auddev.h"
#include <string>
using namespace std;

MMDeviceCap::MMDeviceCap(UINT dev_id, const LPWAVEINCAPS const in) : 
	id(dev_id)
{
		if(in) memcpy(&caps, in, sizeof(caps));
		else waveInGetDevCaps(id, &caps, sizeof(caps));
}

MMDeviceCap::MMDeviceCap(UINT dev_id) : id(dev_id)
{
	waveInGetDevCaps(id, &caps, sizeof(caps));
}

MMDeviceCap& MMDeviceCap::operator=(const MMDeviceCap &mdc)
{
 id = mdc.getId();
 LPWAVEINCAPS cps = mdc.getCaps();
 if(cps) memcpy(&caps, cps, sizeof(caps));
 else waveInGetDevCaps(id, &caps, sizeof(caps));
 return *this;
}

bool MMDeviceCap::operator==(const MMDeviceCap &mdc)
{
 if(mdc.wMid() != caps.wMid) return FALSE;
 if(mdc.wPid() != caps.wPid) return FALSE;
 if(mdc.dwFormats() != caps.dwFormats) return FALSE;
 if(mdc.vDriverVersion() != caps.vDriverVersion) return FALSE;
 if(mdc.wChannels() != caps.wChannels) return FALSE;
 if(mdc.wReserved1() != caps.wReserved1) return FALSE;
 if(string(mdc.szPname()) != string(caps.szPname)) return FALSE;
 return TRUE;
}

bool MMDeviceCap::operator==(const WAVEINCAPS &wic)
{
 if(wic.wMid != caps.wMid) return FALSE;
 if(wic.wPid != caps.wPid) return FALSE;
 if(wic.dwFormats != caps.dwFormats) return FALSE;
 if(wic.vDriverVersion != caps.vDriverVersion) return FALSE;
 if(wic.wChannels != caps.wChannels) return FALSE;
 if(wic.wReserved1 != caps.wReserved1) return FALSE;
 if(string(wic.szPname) != string(caps.szPname)) return FALSE;
 return TRUE;
}

MMDeviceList::~MMDeviceList()
{
	for(int i=0; i < this->numDevs; i++)
	{
		MMDeviceCap *x = index[i];
		delete x;
	}
}

MMDeviceList::MMDeviceList() :
	  numDevs(waveInGetNumDevs())
{
		  for(int i=0; i < this->numDevs; i++)
		  {
			  index[i] = new MMDeviceCap(i);
		  }
}

const MMDeviceCap* const MMDeviceList::getCaps(unsigned int id)
{
	MMDeviceCap *x;
	if(id>-1 && id < this->numDevs) x = index[id];
	else return NULL;
	return const_cast<const MMDeviceCap* const>(x);
}

ostream& MMDeviceList::print(ostream &o)
{
	for(int i=0; i < this->numDevs; i++)
	{
		MMDeviceCap *x = index[i];		
		o << i << ": " << x->szPname() << endl;
	}
	
	return o;
}

ostream& operator<<(ostream &o, MMDeviceList &l) { return l.print(o); };

