/* 
 * vim: set sw=8 ts=8 si et :
 * Copyright Guido Socher */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "i2c_m.h"


void help(){
	printf("i2ctalk_linux -- send and receive strings over I2C\n");
	printf("Usage: i2ctalk_linux [-h][-p device] commandstring\n");
	printf("Options: -h this help\n");
	printf("         -p set the port, default device is /dev/ttyS0\n");
	printf("\n");
	printf("commandstring is the string that will be sent to \n");
	printf("the microcontroller.");
	printf("The program prints any results on stdout.\n");
	exit(1);
}

int main(int argc, char **argv)
{
	/* The following things are used for getopt: */
	extern char *optarg;
	extern int optind;
	extern int opterr;
	char *port="/dev/ttyS0";
	int ch;
	char data[MAX_BUF_LEN+1];

	opterr = 0;
	while ((ch = getopt(argc, argv, "hp:")) != -1) {
		switch (ch) {
			case 'p':
				port = optarg;
				break;
			case 'h':
				help();
			case '?':
				fprintf(stderr, "ERROR: No such option. -h for help.\n");
				exit(1);
			/*no default action for case */
			}
	}
	if (optind != argc -1){
		/* exactly one argument must be given */
		help();
	}

	/* open device */
	open_tty(port);
	// indoor sensor:
	if (!address_slave(3,0)){
		printf("ERROR: address_slave for write failed\n");
		i2cstop();
		close_tty();
		exit(1);
	}
	i2c_tx_string(argv[optind]);
	i2cstop();
	if (!address_slave(3,1)){
		printf("ERROR: address_slave for read failed\n");
		i2cstop();
		close_tty();
		exit(1);
	}
	i2c_rx_string(data);
	printf("%s\n",data);
	i2cstop();
	close_tty();
	return(0);
}

