/* sw-backend.c generated by valac 0.14.1.19-bc3a, the Vala compiler
 * generated from sw-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks/folks-libsocialweb.h>


#define FOLKS_BACKENDS_SW_TYPE_BACKEND (folks_backends_sw_backend_get_type ())
#define FOLKS_BACKENDS_SW_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend))
#define FOLKS_BACKENDS_SW_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))
#define FOLKS_BACKENDS_SW_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))

typedef struct _FolksBackendsSwBackend FolksBackendsSwBackend;
typedef struct _FolksBackendsSwBackendClass FolksBackendsSwBackendClass;
typedef struct _FolksBackendsSwBackendPrivate FolksBackendsSwBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsSwBackendPrepareData FolksBackendsSwBackendPrepareData;
typedef struct _FolksBackendsSwBackendUnprepareData FolksBackendsSwBackendUnprepareData;

struct _FolksBackendsSwBackend {
	FolksBackend parent_instance;
	FolksBackendsSwBackendPrivate * priv;
};

struct _FolksBackendsSwBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsSwBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	SwClient* _client;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
};

struct _FolksBackendsSwBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	SwClient* _tmp5_;
	SwClient* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_;
};

struct _FolksBackendsSwBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GeeHashMap* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_;
	GeeIterator* _tmp11_;
	GeeIterator* _store_it;
	GeeIterator* _tmp12_;
	gboolean _tmp13_;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	FolksPersonaStore* store;
	FolksPersonaStore* _tmp16_;
	guint _tmp17_;
	FolksPersonaStore* _tmp18_;
	GeeHashMap* _tmp19_;
	gboolean _tmp20_;
	GError * _inner_error_;
};


static gpointer folks_backends_sw_backend_parent_class = NULL;

GType folks_backends_sw_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendPrivate))
enum  {
	FOLKS_BACKENDS_SW_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_SW_BACKEND_NAME,
	FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT
};
FolksBackendsSwBackend* folks_backends_sw_backend_new (void);
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type);
static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* _data_);
static void _____lambda0_ (FolksBackendsSwBackend* self, SwClient* client, GList* services);
static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name);
static void ______lambda0__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self);
static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* _data_);
static void folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store);
static void _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static GObject * folks_backends_sw_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_sw_backend_finalize (GObject* obj);
static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type) {
	FolksBackendsSwBackend * self = NULL;
	self = (FolksBackendsSwBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksBackendsSwBackend* folks_backends_sw_backend_new (void) {
	return folks_backends_sw_backend_construct (FOLKS_BACKENDS_SW_TYPE_BACKEND);
}


static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsSwBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsSwBackendPrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendPrepareData* _data_;
	FolksBackendsSwBackend* _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsSwBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_sw_backend_real_prepare_co (_data_);
}


static void folks_backends_sw_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void _____lambda0_ (FolksBackendsSwBackend* self, SwClient* client, GList* services) {
	GList* _tmp0_;
	g_return_if_fail (client != NULL);
	_tmp0_ = services;
	{
		GList* service_name_collection = NULL;
		GList* service_name_it = NULL;
		service_name_collection = _tmp0_;
		for (service_name_it = service_name_collection; service_name_it != NULL; service_name_it = service_name_it->next) {
			const gchar* service_name = NULL;
			service_name = (const gchar*) service_name_it->data;
			{
				const gchar* _tmp1_;
				_tmp1_ = service_name;
				folks_backends_sw_backend_add_service (self, _tmp1_);
			}
		}
	}
	self->priv->_is_prepared = TRUE;
	self->priv->_prepare_pending = FALSE;
	g_object_notify ((GObject*) self, "is-prepared");
	self->priv->_is_quiescent = TRUE;
	g_object_notify ((GObject*) self, "is-quiescent");
	g_object_unref ((GObject*) self);
}


static void ______lambda0__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self) {
	_____lambda0_ (self, client, services);
}


static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp2_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp2_) {
				_data_->_tmp3_ = _data_->self->priv->_prepare_pending;
				_data_->_tmp1_ = !_data_->_tmp3_;
			} else {
				_data_->_tmp1_ = FALSE;
			}
			_data_->_tmp4_ = _data_->_tmp1_;
			if (_data_->_tmp4_) {
				_data_->self->priv->_prepare_pending = TRUE;
				g_object_ref ((GObject*) _data_->self);
				_data_->_tmp5_ = sw_client_new ();
				_g_object_unref0 (_data_->self->priv->_client);
				_data_->self->priv->_client = _data_->_tmp5_;
				_data_->_tmp6_ = _data_->self->priv->_client;
				sw_client_get_services (_data_->_tmp6_, ______lambda0__sw_client_get_services_callback, _data_->self);
			}
		}
		__finally0:
		{
			_data_->_tmp7_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsSwBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsSwBackendUnprepareData, _data_);
}


static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendUnprepareData* _data_;
	FolksBackendsSwBackend* _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsSwBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_sw_backend_real_unprepare_co (_data_);
}


static void folks_backends_sw_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_backends_sw_backend_store_removed_cb (self, _sender);
}


static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp2_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp2_) {
				_data_->_tmp1_ = TRUE;
			} else {
				_data_->_tmp3_ = _data_->self->priv->_prepare_pending;
				_data_->_tmp1_ = _data_->_tmp3_;
			}
			_data_->_tmp4_ = _data_->_tmp1_;
			if (_data_->_tmp4_) {
				{
					_data_->_tmp5_ = _data_->self->priv->_is_prepared;
					g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
				}
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->self->priv->_prepare_pending = TRUE;
			{
				_data_->_tmp6_ = _data_->self->priv->_persona_stores;
				_data_->_tmp7_ = gee_map_get_values ((GeeMap*) _data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = _data_->_tmp8_;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp9_);
				_data_->_tmp11_ = _data_->_tmp10_;
				_g_object_unref0 (_data_->_tmp9_);
				_data_->_store_it = _data_->_tmp11_;
				while (TRUE) {
					_data_->_tmp12_ = _data_->_store_it;
					_data_->_tmp13_ = FALSE;
					_data_->_tmp13_ = gee_iterator_next (_data_->_tmp12_);
					if (!_data_->_tmp13_) {
						break;
					}
					_data_->_tmp14_ = _data_->_store_it;
					_data_->_tmp15_ = NULL;
					_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
					_data_->store = (FolksPersonaStore*) _data_->_tmp15_;
					_data_->_tmp16_ = _data_->store;
					_data_->_tmp17_ = 0U;
					g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_data_->_tmp17_, NULL, FALSE);
					g_signal_handlers_disconnect_matched (_data_->_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp17_, 0, NULL, (GCallback) _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, _data_->self);
					_data_->_tmp18_ = _data_->store;
					g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", _data_->_tmp18_);
					_g_object_unref0 (_data_->store);
				}
				_g_object_unref0 (_data_->_store_it);
			}
			_g_object_unref0 (_data_->self->priv->_client);
			_data_->self->priv->_client = NULL;
			_data_->_tmp19_ = _data_->self->priv->_persona_stores;
			gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp19_);
			g_object_notify ((GObject*) _data_->self, "persona-stores");
			_data_->self->priv->_is_quiescent = FALSE;
			g_object_notify ((GObject*) _data_->self, "is-quiescent");
			_data_->self->priv->_is_prepared = FALSE;
			_data_->self->priv->_prepare_pending = FALSE;
			g_object_notify ((GObject*) _data_->self, "is-prepared");
		}
		__finally1:
		{
			_data_->_tmp20_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
	SwClient* _tmp5_;
	const gchar* _tmp6_;
	SwClientService* _tmp7_ = NULL;
	SwClientService* _tmp8_;
	SwfPersonaStore* _tmp9_;
	SwfPersonaStore* _tmp10_;
	SwfPersonaStore* store;
	GeeHashMap* _tmp11_;
	SwfPersonaStore* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	SwfPersonaStore* _tmp15_;
	SwfPersonaStore* _tmp16_;
	SwfPersonaStore* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = service_name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	_tmp3_ = (FolksPersonaStore*) _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->_client;
	_tmp6_ = service_name;
	_tmp7_ = sw_client_get_service (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = swf_persona_store_new (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	store = _tmp10_;
	_tmp11_ = self->priv->_persona_stores;
	_tmp12_ = store;
	_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp14_, (FolksPersonaStore*) _tmp15_);
	_tmp16_ = store;
	g_signal_connect_object ((FolksPersonaStore*) _tmp16_, "removed", (GCallback) _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp17_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp17_);
	_g_object_unref0 (store);
}


static void folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	GeeHashMap* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp0_);
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _tmp4_, NULL);
}


static const gchar* folks_backends_sw_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsSwBackend* self;
	self = (FolksBackendsSwBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_sw_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsSwBackend* self;
	GeeMap* _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_sw_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_sw_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	gboolean _tmp0_;
	self = (FolksBackendsSwBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GObject * folks_backends_sw_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsSwBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (folks_backends_sw_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = FOLKS_BACKENDS_SW_BACKEND (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return obj;
}


static void folks_backends_sw_backend_class_init (FolksBackendsSwBackendClass * klass) {
	folks_backends_sw_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsSwBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_sw_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_sw_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_sw_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_sw_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_sw_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_sw_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_sw_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_sw_backend_real_get_is_quiescent;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_sw_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_sw_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_sw_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES, "persona-stores");
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED, "is-prepared");
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT, "is-quiescent");
}


static void folks_backends_sw_backend_instance_init (FolksBackendsSwBackend * self) {
	self->priv = FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_sw_backend_finalize (GObject* obj) {
	FolksBackendsSwBackend * self;
	self = FOLKS_BACKENDS_SW_BACKEND (obj);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_client);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	G_OBJECT_CLASS (folks_backends_sw_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to libsocialweb and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_sw_backend_get_type (void) {
	static volatile gsize folks_backends_sw_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_sw_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsSwBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_sw_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsSwBackend), 0, (GInstanceInitFunc) folks_backends_sw_backend_instance_init, NULL };
		GType folks_backends_sw_backend_type_id;
		folks_backends_sw_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsSwBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_sw_backend_type_id__volatile, folks_backends_sw_backend_type_id);
	}
	return folks_backends_sw_backend_type_id__volatile;
}


static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsSwBackend * self;
	self = FOLKS_BACKENDS_SW_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_SW_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



