#include "grail-fixture.h"

class SingleTouchGestureTest : public GrailTest
{
};

/*
 Regression test for bug https://bugs.launchpad.net/grail/+bug/1020315
 */
TEST_F(SingleTouchGestureTest, QuickTapEndsWithConstructionFinished)
{
  UGStatus status;
  struct UFHandle_ frame_handle_struct;
  UFWindowId fake_window_id = 321;
  uint64_t time = 1234;

  status = grail_new(&frame_handle_struct, &grail_handle);
  ASSERT_EQ(UGStatusSuccess, status);

  SendDeviceAddedEvent(time);

  UGSubscription subscription =
    CreateSubscription(1, UGGestureTypeTouch, device_ptr.get(), fake_window_id);
  if (!subscription) return;

  time += 10;
  struct UFTouch_ touch_struct;
  touch_struct.id = 1;
  touch_struct.state = UFTouchStateBegin;
  touch_struct.window_x = 10.0f;
  touch_struct.window_y = 10.0f;
  touch_struct.device_x = 100.0f;
  touch_struct.device_y = 100.0f;
  touch_struct.time = time;
  touch_struct.start_time = touch_struct.time;
  touch_struct.owned = 0;
  touch_struct.pending_end = 0;

  SendFrameEvent(time, fake_window_id, touch_struct);

  time += 10;
  touch_struct.state = UFTouchStateUpdate;
  touch_struct.owned = 1; // ownership will trigger delivery of grail events.
  touch_struct.time = time;

  SendFrameEvent(time, fake_window_id, touch_struct);

  // There should now be two grail events, corresponding to the frame
  // event that were sent, waiting to be processed.

  // Check first event. A gesture begin.
  UGEvent grail_event;
  status = grail_get_event(grail_handle, &grail_event);
  ASSERT_EQ(UGStatusSuccess, status);

  ASSERT_EQ(UGEventTypeSlice, grail_event_get_type(grail_event));

  UGSlice slice;
  status = grail_event_get_property(grail_event, UGEventPropertySlice, &slice);
  ASSERT_EQ(UGStatusSuccess, status);

  ASSERT_EQ(UGGestureStateBegin, grail_slice_get_state(slice));
  ASSERT_FALSE(grail_slice_get_construction_finished(slice));

  grail_event_unref(grail_event);

  // Check the second event. A gesture update.
  status = grail_get_event(grail_handle, &grail_event);
  ASSERT_EQ(UGStatusSuccess, status);

  ASSERT_EQ(UGEventTypeSlice, grail_event_get_type(grail_event));

  status = grail_event_get_property(grail_event, UGEventPropertySlice, &slice);
  ASSERT_EQ(UGStatusSuccess, status);

  ASSERT_EQ(UGGestureStateUpdate, grail_slice_get_state(slice));
  ASSERT_FALSE(grail_slice_get_construction_finished(slice));

  grail_event_unref(grail_event);

  // now end the touch

  time += 10;
  touch_struct.state = UFTouchStateEnd;
  touch_struct.time = time;

  SendFrameEvent(time, fake_window_id, touch_struct);

  // An end event should come and its "construction finished" property should be true

  UGStatus get_event_status;
  do
  {
    get_event_status = grail_get_event(grail_handle, &grail_event);
    if (get_event_status != UGStatusSuccess)
      break;

    ASSERT_EQ(UGEventTypeSlice, grail_event_get_type(grail_event));

    status = grail_event_get_property(grail_event, UGEventPropertySlice, &slice);
    ASSERT_EQ(UGStatusSuccess, status);

    // We ignore any intermediate updates
    if (grail_slice_get_state(slice) == UGGestureStateUpdate)
      continue;

    ASSERT_EQ(UGGestureStateEnd, grail_slice_get_state(slice));
    ASSERT_TRUE(grail_slice_get_construction_finished(slice));

    grail_event_unref(grail_event);
  } while (get_event_status == UGStatusSuccess);
  ASSERT_EQ(UGStatusErrorNoEvent, get_event_status);

  grail_subscription_delete(subscription);
}
