/* accounts.c generated by valac 0.15.2, the Vala compiler
 * generated from accounts.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "gwibber.h"
#include <json-glib/json-glib.h>


#define TYPE_ACCOUNTS_INTERFACE (accounts_interface_get_type ())
#define ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterface))
#define IS_ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_INTERFACE))
#define ACCOUNTS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterfaceIface))

typedef struct _AccountsInterface AccountsInterface;
typedef struct _AccountsInterfaceIface AccountsInterfaceIface;

#define TYPE_ACCOUNTS_INTERFACE_PROXY (accounts_interface_proxy_get_type ())
typedef GDBusProxy AccountsInterfaceProxy;
typedef GDBusProxyClass AccountsInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))

struct _AccountsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*List) (AccountsInterface* self, GError** error);
	gchar* (*Get) (AccountsInterface* self, const gchar* id, GError** error);
	void (*SendEnabled) (AccountsInterface* self, const gchar* id, GError** error);
};

struct _GwibberAccountsPrivate {
	AccountsInterface* accounts_service;
	GwibberUtils* utils;
};


static gpointer gwibber_accounts_parent_class = NULL;

GType accounts_interface_proxy_get_type (void) G_GNUC_CONST;
guint accounts_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType accounts_interface_get_type (void) G_GNUC_CONST;
gchar* accounts_interface_List (AccountsInterface* self, GError** error);
gchar* accounts_interface_Get (AccountsInterface* self, const gchar* id, GError** error);
void accounts_interface_SendEnabled (AccountsInterface* self, const gchar* id, GError** error);
static void accounts_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_accounts_interface_updated (AccountsInterface* self, GVariant* parameters);
static void _dbus_handle_accounts_interface_created (AccountsInterface* self, GVariant* parameters);
static void _dbus_handle_accounts_interface_deleted (AccountsInterface* self, GVariant* parameters);
static gchar* accounts_interface_proxy_List (AccountsInterface* self, GError** error);
static gchar* accounts_interface_proxy_Get (AccountsInterface* self, const gchar* id, GError** error);
static void accounts_interface_proxy_SendEnabled (AccountsInterface* self, const gchar* id, GError** error);
static void accounts_interface_proxy_accounts_interface_interface_init (AccountsInterfaceIface* iface);
static void _dbus_accounts_interface_List (AccountsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_accounts_interface_Get (AccountsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_accounts_interface_SendEnabled (AccountsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void accounts_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* accounts_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean accounts_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_accounts_interface_updated (GObject* _sender, const gchar* account, gpointer* _data);
static void _dbus_accounts_interface_created (GObject* _sender, const gchar* account, gpointer* _data);
static void _dbus_accounts_interface_deleted (GObject* _sender, const gchar* account, gpointer* _data);
static void _accounts_interface_unregister_object (gpointer user_data);
#define GWIBBER_ACCOUNTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_ACCOUNTS, GwibberAccountsPrivate))
enum  {
	GWIBBER_ACCOUNTS_DUMMY_PROPERTY
};
#define GWIBBER_ACCOUNTS_accounts_name "com.Gwibber.Accounts"
#define GWIBBER_ACCOUNTS_accounts_path "/com/gwibber/Accounts"
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_accounts_accounts_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void ___lambda2_ (GwibberAccounts* self, const gchar* source);
static void ____lambda2__accounts_interface_updated (AccountsInterface* _sender, const gchar* account, gpointer self);
static void ___lambda3_ (GwibberAccounts* self, const gchar* source);
static void ____lambda3__accounts_interface_created (AccountsInterface* _sender, const gchar* account, gpointer self);
static void ___lambda4_ (GwibberAccounts* self, const gchar* source);
static void ____lambda4__accounts_interface_deleted (AccountsInterface* _sender, const gchar* account, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static void _vala_JsonObject_free (JsonObject* self);
static void gwibber_accounts_finalize (GObject* obj);

static const GDBusArgInfo _accounts_interface_dbus_arg_info_List_result = {-1, "result", "s"};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_List_in[] = {NULL};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_List_out[] = {&_accounts_interface_dbus_arg_info_List_result, NULL};
static const GDBusMethodInfo _accounts_interface_dbus_method_info_List = {-1, "List", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_List_in), (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_List_out)};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_Get_id = {-1, "id", "s"};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_Get_result = {-1, "result", "s"};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_Get_in[] = {&_accounts_interface_dbus_arg_info_Get_id, NULL};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_Get_out[] = {&_accounts_interface_dbus_arg_info_Get_result, NULL};
static const GDBusMethodInfo _accounts_interface_dbus_method_info_Get = {-1, "Get", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_Get_in), (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_Get_out)};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_SendEnabled_id = {-1, "id", "s"};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_SendEnabled_in[] = {&_accounts_interface_dbus_arg_info_SendEnabled_id, NULL};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_SendEnabled_out[] = {NULL};
static const GDBusMethodInfo _accounts_interface_dbus_method_info_SendEnabled = {-1, "SendEnabled", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_SendEnabled_in), (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_SendEnabled_out)};
static const GDBusMethodInfo * const _accounts_interface_dbus_method_info[] = {&_accounts_interface_dbus_method_info_List, &_accounts_interface_dbus_method_info_Get, &_accounts_interface_dbus_method_info_SendEnabled, NULL};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_updated_account = {-1, "account", "s"};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_updated[] = {&_accounts_interface_dbus_arg_info_updated_account, NULL};
static const GDBusSignalInfo _accounts_interface_dbus_signal_info_updated = {-1, "Updated", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_updated)};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_created_account = {-1, "account", "s"};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_created[] = {&_accounts_interface_dbus_arg_info_created_account, NULL};
static const GDBusSignalInfo _accounts_interface_dbus_signal_info_created = {-1, "Created", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_created)};
static const GDBusArgInfo _accounts_interface_dbus_arg_info_deleted_account = {-1, "account", "s"};
static const GDBusArgInfo * const _accounts_interface_dbus_arg_info_deleted[] = {&_accounts_interface_dbus_arg_info_deleted_account, NULL};
static const GDBusSignalInfo _accounts_interface_dbus_signal_info_deleted = {-1, "Deleted", (GDBusArgInfo **) (&_accounts_interface_dbus_arg_info_deleted)};
static const GDBusSignalInfo * const _accounts_interface_dbus_signal_info[] = {&_accounts_interface_dbus_signal_info_updated, &_accounts_interface_dbus_signal_info_created, &_accounts_interface_dbus_signal_info_deleted, NULL};
static const GDBusPropertyInfo * const _accounts_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _accounts_interface_dbus_interface_info = {-1, "com.Gwibber.Accounts", (GDBusMethodInfo **) (&_accounts_interface_dbus_method_info), (GDBusSignalInfo **) (&_accounts_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_accounts_interface_dbus_property_info)};
static const GDBusInterfaceVTable _accounts_interface_dbus_interface_vtable = {accounts_interface_dbus_interface_method_call, accounts_interface_dbus_interface_get_property, accounts_interface_dbus_interface_set_property};

gchar* accounts_interface_List (AccountsInterface* self, GError** error) {
#line 27 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 27 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return ACCOUNTS_INTERFACE_GET_INTERFACE (self)->List (self, error);
#line 147 "accounts.c"
}


gchar* accounts_interface_Get (AccountsInterface* self, const gchar* id, GError** error) {
#line 28 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return ACCOUNTS_INTERFACE_GET_INTERFACE (self)->Get (self, id, error);
#line 156 "accounts.c"
}


void accounts_interface_SendEnabled (AccountsInterface* self, const gchar* id, GError** error) {
#line 29 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (self != NULL);
#line 29 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	ACCOUNTS_INTERFACE_GET_INTERFACE (self)->SendEnabled (self, id, error);
#line 165 "accounts.c"
}


static void accounts_interface_base_init (AccountsInterfaceIface * iface) {
#line 23 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	static gboolean initialized = FALSE;
#line 23 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (!initialized) {
#line 23 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		initialized = TRUE;
#line 23 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_new ("updated", TYPE_ACCOUNTS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 23 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_new ("created", TYPE_ACCOUNTS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 23 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_new ("deleted", TYPE_ACCOUNTS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 182 "accounts.c"
	}
}


GType accounts_interface_get_type (void) {
	static volatile gsize accounts_interface_type_id__volatile = 0;
	if (g_once_init_enter (&accounts_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountsInterfaceIface), (GBaseInitFunc) accounts_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType accounts_interface_type_id;
		accounts_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (accounts_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) accounts_interface_proxy_get_type);
		g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.Gwibber.Accounts");
		g_type_set_qdata (accounts_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) accounts_interface_register_object);
		g_once_init_leave (&accounts_interface_type_id__volatile, accounts_interface_type_id);
	}
	return accounts_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (AccountsInterfaceProxy, accounts_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_ACCOUNTS_INTERFACE, accounts_interface_proxy_accounts_interface_interface_init) )
static void accounts_interface_proxy_class_init (AccountsInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = accounts_interface_proxy_g_signal;
}


static void _dbus_handle_accounts_interface_updated (AccountsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "updated", account);
	_g_free0 (account);
}


static void _dbus_handle_accounts_interface_created (AccountsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "created", account);
	_g_free0 (account);
}


static void _dbus_handle_accounts_interface_deleted (AccountsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* account = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	g_signal_emit_by_name (self, "deleted", account);
	_g_free0 (account);
}


static void accounts_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Updated") == 0) {
		_dbus_handle_accounts_interface_updated ((AccountsInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Created") == 0) {
		_dbus_handle_accounts_interface_created ((AccountsInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Deleted") == 0) {
		_dbus_handle_accounts_interface_deleted ((AccountsInterface*) proxy, parameters);
	}
}


static void accounts_interface_proxy_init (AccountsInterfaceProxy* self) {
}


static gchar* accounts_interface_proxy_List (AccountsInterface* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp3_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Accounts", "List");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* accounts_interface_proxy_Get (AccountsInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp4_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Accounts", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp4_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	g_object_unref (_reply_message);
	return _result;
}


static void accounts_interface_proxy_SendEnabled (AccountsInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Accounts", "SendEnabled");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void accounts_interface_proxy_accounts_interface_interface_init (AccountsInterfaceIface* iface) {
	iface->List = accounts_interface_proxy_List;
	iface->Get = accounts_interface_proxy_Get;
	iface->SendEnabled = accounts_interface_proxy_SendEnabled;
}


static void _dbus_accounts_interface_List (AccountsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = accounts_interface_List (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_accounts_interface_Get (AccountsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	result = accounts_interface_Get (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_accounts_interface_SendEnabled (AccountsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	accounts_interface_SendEnabled (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void accounts_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "List") == 0) {
		_dbus_accounts_interface_List (object, parameters, invocation);
	} else if (strcmp (method_name, "Get") == 0) {
		_dbus_accounts_interface_Get (object, parameters, invocation);
	} else if (strcmp (method_name, "SendEnabled") == 0) {
		_dbus_accounts_interface_SendEnabled (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* accounts_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean accounts_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_accounts_interface_updated (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Accounts", "Updated", _arguments, NULL);
}


static void _dbus_accounts_interface_created (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Accounts", "Created", _arguments, NULL);
}


static void _dbus_accounts_interface_deleted (GObject* _sender, const gchar* account, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Accounts", "Deleted", _arguments, NULL);
}


guint accounts_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_accounts_interface_dbus_interface_info), &_accounts_interface_dbus_interface_vtable, data, _accounts_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_accounts_interface_updated, data);
	g_signal_connect (object, "created", (GCallback) _dbus_accounts_interface_created, data);
	g_signal_connect (object, "deleted", (GCallback) _dbus_accounts_interface_deleted, data);
	return result;
}


static void _accounts_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_accounts_interface_updated, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_accounts_interface_created, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_accounts_interface_deleted, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _gwibber_accounts_accounts_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
#line 86 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	gwibber_accounts_accounts_available (self, up);
#line 556 "accounts.c"
}


static void ___lambda2_ (GwibberAccounts* self, const gchar* source) {
	const gchar* _tmp0_;
#line 88 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (source != NULL);
#line 89 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = source;
#line 89 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	gwibber_accounts_account_updated (self, _tmp0_);
#line 568 "accounts.c"
}


static void ____lambda2__accounts_interface_updated (AccountsInterface* _sender, const gchar* account, gpointer self) {
#line 88 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	___lambda2_ (self, account);
#line 575 "accounts.c"
}


static void ___lambda3_ (GwibberAccounts* self, const gchar* source) {
	const gchar* _tmp0_;
#line 92 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (source != NULL);
#line 93 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = source;
#line 93 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	gwibber_accounts_account_created (self, _tmp0_);
#line 587 "accounts.c"
}


static void ____lambda3__accounts_interface_created (AccountsInterface* _sender, const gchar* account, gpointer self) {
#line 92 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	___lambda3_ (self, account);
#line 594 "accounts.c"
}


static void ___lambda4_ (GwibberAccounts* self, const gchar* source) {
	const gchar* _tmp0_;
#line 96 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (source != NULL);
#line 97 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = source;
#line 97 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	gwibber_accounts_account_deleted (self, _tmp0_);
#line 606 "accounts.c"
}


static void ____lambda4__accounts_interface_deleted (AccountsInterface* _sender, const gchar* account, gpointer self) {
#line 96 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	___lambda4_ (self, account);
#line 613 "accounts.c"
}


GwibberAccounts* gwibber_accounts_construct (GType object_type) {
	GwibberAccounts * self = NULL;
	GError * _inner_error_ = NULL;
#line 76 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	self = (GwibberAccounts*) g_object_new (object_type, NULL);
#line 622 "accounts.c"
	{
		AccountsInterface* _tmp0_ = NULL;
		AccountsInterface* _tmp1_;
		GwibberUtils* _tmp2_;
		GwibberUtils* _tmp3_;
		GwibberUtils* _tmp4_;
		AccountsInterface* _tmp5_;
		AccountsInterface* _tmp6_;
		AccountsInterface* _tmp7_;
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp0_ = g_initable_new (TYPE_ACCOUNTS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", GWIBBER_ACCOUNTS_accounts_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GWIBBER_ACCOUNTS_accounts_path, "g-interface-name", "com.Gwibber.Accounts", NULL);
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp1_ = (AccountsInterface*) _tmp0_;
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 640 "accounts.c"
				goto __catch1_g_io_error;
			}
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_clear_error (&_inner_error_);
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			return NULL;
#line 649 "accounts.c"
		}
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (self->priv->accounts_service);
#line 80 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		self->priv->accounts_service = _tmp1_;
#line 84 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = gwibber_utils_new ();
#line 84 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (self->priv->utils);
#line 84 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		self->priv->utils = _tmp2_;
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp3_ = self->priv->utils;
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		gwibber_utils_setup (_tmp3_, GWIBBER_ACCOUNTS_accounts_name, &_inner_error_);
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 669 "accounts.c"
				goto __catch1_g_io_error;
			}
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_clear_error (&_inner_error_);
#line 85 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			return NULL;
#line 678 "accounts.c"
		}
#line 86 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp4_ = self->priv->utils;
#line 86 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_connect_object (_tmp4_, "available", (GCallback) _gwibber_accounts_accounts_available_gwibber_utils_available, self, 0);
#line 88 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp5_ = self->priv->accounts_service;
#line 88 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_connect_object (_tmp5_, "updated", (GCallback) ____lambda2__accounts_interface_updated, self, 0);
#line 92 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp6_ = self->priv->accounts_service;
#line 92 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_connect_object (_tmp6_, "created", (GCallback) ____lambda3__accounts_interface_created, self, 0);
#line 96 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp7_ = self->priv->accounts_service;
#line 96 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_connect_object (_tmp7_, "deleted", (GCallback) ____lambda4__accounts_interface_deleted, self, 0);
#line 696 "accounts.c"
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 102 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp8_ = e;
#line 102 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp9_ = _tmp8_->message;
#line 102 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp10_ = g_strconcat ("Unable to get Gwibber accounts: ", _tmp9_, NULL);
#line 102 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp11_ = _tmp10_;
#line 102 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:102: %s", _tmp11_);
#line 102 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (_tmp11_);
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 724 "accounts.c"
	}
	__finally1:
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (_inner_error_ != NULL) {
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_clear_error (&_inner_error_);
#line 78 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return NULL;
#line 735 "accounts.c"
	}
#line 76 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return self;
#line 739 "accounts.c"
}


GwibberAccounts* gwibber_accounts_new (void) {
#line 76 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return gwibber_accounts_construct (GWIBBER_TYPE_ACCOUNTS);
#line 746 "accounts.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 753 "accounts.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_list_free (self);
#line 762 "accounts.c"
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return g_boxed_copy (json_array_get_type (), self);
#line 769 "accounts.c"
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return self ? _vala_JsonArray_copy (self) : NULL;
#line 776 "accounts.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 118 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return self ? g_object_ref (self) : NULL;
#line 783 "accounts.c"
}


static void _vala_JsonArray_free (JsonArray* self) {
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_boxed_free (json_array_get_type (), self);
#line 790 "accounts.c"
}


GList* gwibber_accounts_list (GwibberAccounts* self) {
	GList* result = NULL;
	GList* accounts;
	GError * _inner_error_ = NULL;
#line 106 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	accounts = NULL;
#line 802 "accounts.c"
	{
		AccountsInterface* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* accounts_string;
		JsonParser* _tmp2_;
		JsonParser* parser;
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp0_ = self->priv->accounts_service;
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp1_ = accounts_interface_List (_tmp0_, &_inner_error_);
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		accounts_string = _tmp1_;
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 819 "accounts.c"
				goto __catch2_g_io_error;
			}
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			__g_list_free__g_object_unref0_0 (accounts);
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_clear_error (&_inner_error_);
#line 110 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			return NULL;
#line 830 "accounts.c"
		}
#line 111 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = json_parser_new ();
#line 111 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		parser = _tmp2_;
#line 836 "accounts.c"
		{
			JsonParser* _tmp3_;
			const gchar* _tmp4_;
			JsonParser* _tmp5_;
			JsonNode* _tmp6_ = NULL;
			JsonArray* _tmp7_ = NULL;
			JsonArray* _tmp8_;
			JsonArray* nodeArray;
#line 113 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp3_ = parser;
#line 113 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp4_ = accounts_string;
#line 113 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			json_parser_load_from_data (_tmp3_, _tmp4_, (gssize) (-1), &_inner_error_);
#line 113 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_ != NULL) {
#line 853 "accounts.c"
				goto __catch3_g_error;
			}
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp5_ = parser;
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp6_ = json_parser_get_root (_tmp5_);
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp7_ = json_node_get_array (_tmp6_);
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp8_ = __vala_JsonArray_copy0 (_tmp7_);
#line 114 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			nodeArray = _tmp8_;
#line 866 "accounts.c"
			{
				gint i;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
				i = 0;
#line 871 "accounts.c"
				{
					gboolean _tmp9_;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
					_tmp9_ = TRUE;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
					while (TRUE) {
#line 878 "accounts.c"
						gboolean _tmp10_;
						gint _tmp12_;
						JsonArray* _tmp13_;
						guint _tmp14_ = 0U;
						JsonArray* _tmp15_;
						gint _tmp16_;
						JsonNode* _tmp17_ = NULL;
						JsonObject* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						gchar* id;
						const gchar* _tmp21_;
						GwibberAccount* _tmp22_;
						GwibberAccount* account;
						GwibberAccount* _tmp23_;
						GwibberAccount* _tmp24_;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp10_ = _tmp9_;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						if (!_tmp10_) {
#line 899 "accounts.c"
							gint _tmp11_;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
							_tmp11_ = i;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
							i = _tmp11_ + 1;
#line 905 "accounts.c"
						}
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp9_ = FALSE;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp12_ = i;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp13_ = nodeArray;
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp14_ = json_array_get_length (_tmp13_);
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						if (!(((guint) _tmp12_) < _tmp14_)) {
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
							break;
#line 919 "accounts.c"
						}
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp15_ = nodeArray;
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp16_ = i;
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp17_ = json_array_get_element (_tmp15_, (guint) _tmp16_);
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp18_ = json_node_get_object (_tmp17_);
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp19_ = json_object_get_string_member (_tmp18_, "id");
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp20_ = g_strdup (_tmp19_);
#line 116 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						id = _tmp20_;
#line 117 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp21_ = id;
#line 117 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp22_ = gwibber_account_new (_tmp21_);
#line 117 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						account = _tmp22_;
#line 118 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp23_ = account;
#line 118 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_tmp24_ = _g_object_ref0 (_tmp23_);
#line 118 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						accounts = g_list_append (accounts, _tmp24_);
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_g_object_unref0 (account);
#line 115 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
						_g_free0 (id);
#line 951 "accounts.c"
					}
				}
			}
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			__vala_JsonArray_free0 (nodeArray);
#line 957 "accounts.c"
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			e = _inner_error_;
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_inner_error_ = NULL;
#line 121 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp25_ = e;
#line 121 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_tmp26_ = _tmp25_->message;
#line 121 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_warning ("accounts.vala:121: %s", _tmp26_);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_error_free0 (e);
#line 977 "accounts.c"
		}
		__finally3:
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_object_unref0 (parser);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_free0 (accounts_string);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 988 "accounts.c"
				goto __catch2_g_io_error;
			}
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_object_unref0 (parser);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_free0 (accounts_string);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			__g_list_free__g_object_unref0_0 (accounts);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_clear_error (&_inner_error_);
#line 112 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			return NULL;
#line 1003 "accounts.c"
		}
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (parser);
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (accounts_string);
#line 1009 "accounts.c"
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 124 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp27_ = e;
#line 124 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp28_ = _tmp27_->message;
#line 124 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:124: %s", _tmp28_);
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 1029 "accounts.c"
	}
	__finally2:
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (_inner_error_ != NULL) {
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		__g_list_free__g_object_unref0_0 (accounts);
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_clear_error (&_inner_error_);
#line 109 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return NULL;
#line 1042 "accounts.c"
	}
#line 126 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	result = accounts;
#line 126 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return result;
#line 1048 "accounts.c"
}


gchar* gwibber_accounts_lookup_str_by_id (GwibberAccounts* self, const gchar* id) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 129 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 129 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1059 "accounts.c"
	{
		AccountsInterface* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* account;
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp0_ = self->priv->accounts_service;
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp1_ = id;
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = accounts_interface_Get (_tmp0_, _tmp1_, &_inner_error_);
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		account = _tmp2_;
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1077 "accounts.c"
				goto __catch4_g_io_error;
			}
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_clear_error (&_inner_error_);
#line 132 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			return NULL;
#line 1086 "accounts.c"
		}
#line 133 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		result = account;
#line 133 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return result;
#line 1092 "accounts.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 131 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 131 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 135 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp3_ = e;
#line 135 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp4_ = _tmp3_->message;
#line 135 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:135: %s", _tmp4_);
#line 136 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp5_ = g_strdup ("");
#line 136 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		result = _tmp5_;
#line 136 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 136 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return result;
#line 1119 "accounts.c"
	}
	__finally4:
#line 131 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_clear_error (&_inner_error_);
#line 131 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return NULL;
#line 1128 "accounts.c"
}


GwibberAccount* gwibber_accounts_lookup_by_id (GwibberAccounts* self, const gchar* id) {
	GwibberAccount* result = NULL;
	const gchar* _tmp0_;
	GwibberAccount* _tmp1_;
	GwibberAccount* acct;
#line 140 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 140 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 142 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = id;
#line 142 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp1_ = gwibber_account_new (_tmp0_);
#line 142 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	acct = _tmp1_;
#line 143 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	result = acct;
#line 143 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return result;
#line 1151 "accounts.c"
}


/**
            send_enabled:

            Toggle the value of send_enabled for an account.
        */
void gwibber_accounts_send_enabled (GwibberAccounts* self, const gchar* id) {
	GError * _inner_error_ = NULL;
#line 152 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (self != NULL);
#line 152 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (id != NULL);
#line 1166 "accounts.c"
	{
		AccountsInterface* _tmp0_;
		const gchar* _tmp1_;
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp0_ = self->priv->accounts_service;
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp1_ = id;
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		accounts_interface_SendEnabled (_tmp0_, _tmp1_, &_inner_error_);
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1180 "accounts.c"
				goto __catch5_g_io_error;
			}
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			g_clear_error (&_inner_error_);
#line 155 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			return;
#line 1189 "accounts.c"
		}
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 157 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = e;
#line 157 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp3_ = _tmp2_->message;
#line 157 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:157: %s", _tmp3_);
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 1210 "accounts.c"
	}
	__finally5:
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (_inner_error_ != NULL) {
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_clear_error (&_inner_error_);
#line 154 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return;
#line 1221 "accounts.c"
	}
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
#line 167 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return g_boxed_copy (json_object_get_type (), self);
#line 1229 "accounts.c"
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
#line 167 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	return self ? _vala_JsonObject_copy (self) : NULL;
#line 1236 "accounts.c"
}


static void _vala_JsonObject_free (JsonObject* self) {
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_boxed_free (json_object_get_type (), self);
#line 1243 "accounts.c"
}


void gwibber_accounts_account_updated (GwibberAccounts* self, const gchar* account_in) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* account_string;
	GError * _inner_error_ = NULL;
#line 161 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (self != NULL);
#line 161 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (account_in != NULL);
#line 163 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = account_in;
#line 163 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 163 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	account_string = _tmp1_;
#line 1262 "accounts.c"
	{
		JsonParser* _tmp2_;
		JsonParser* parser;
		JsonNode* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_;
		JsonObject* root_object;
		JsonObject* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* id;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GwibberAccount* _tmp11_;
		GwibberAccount* account;
		GwibberAccount* _tmp12_;
#line 165 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = json_parser_new ();
#line 165 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		parser = _tmp2_;
#line 166 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		json_parser_load_from_data (parser, account_string, (gssize) (-1), &_inner_error_);
#line 166 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 166 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_object_unref0 (parser);
#line 1289 "accounts.c"
			goto __catch6_g_error;
		}
#line 167 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp3_ = json_parser_get_root (parser);
#line 167 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp4_ = json_node_get_object (_tmp3_);
#line 167 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp5_ = __vala_JsonObject_copy0 (_tmp4_);
#line 167 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		root_object = _tmp5_;
#line 168 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp6_ = root_object;
#line 168 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp7_ = json_object_get_string_member (_tmp6_, "id");
#line 168 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 168 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		id = _tmp8_;
#line 169 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp9_ = id;
#line 169 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_debug ("accounts.vala:169: ID is %s", _tmp9_);
#line 170 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp10_ = id;
#line 170 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp11_ = gwibber_account_new (_tmp10_);
#line 170 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		account = _tmp11_;
#line 171 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp12_ = account;
#line 171 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_emit_by_name (self, "updated", _tmp12_);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (account);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (id);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		__vala_JsonObject_free0 (root_object);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (parser);
#line 1330 "accounts.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 173 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp13_ = e;
#line 173 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp14_ = _tmp13_->message;
#line 173 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:173: %s", _tmp14_);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 1350 "accounts.c"
	}
	__finally6:
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (_inner_error_ != NULL) {
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (account_string);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_clear_error (&_inner_error_);
#line 164 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return;
#line 1363 "accounts.c"
	}
#line 161 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_g_free0 (account_string);
#line 1367 "accounts.c"
}


void gwibber_accounts_account_created (GwibberAccounts* self, const gchar* account_in) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* account_string;
	GError * _inner_error_ = NULL;
#line 177 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (self != NULL);
#line 177 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (account_in != NULL);
#line 179 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = account_in;
#line 179 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 179 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	account_string = _tmp1_;
#line 1386 "accounts.c"
	{
		JsonParser* _tmp2_;
		JsonParser* parser;
		JsonNode* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_;
		JsonObject* root_object;
		JsonObject* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* id;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GwibberAccount* _tmp11_;
		GwibberAccount* account;
		GwibberAccount* _tmp12_;
#line 181 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = json_parser_new ();
#line 181 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		parser = _tmp2_;
#line 182 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		json_parser_load_from_data (parser, account_string, (gssize) (-1), &_inner_error_);
#line 182 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 182 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_object_unref0 (parser);
#line 1413 "accounts.c"
			goto __catch7_g_error;
		}
#line 183 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp3_ = json_parser_get_root (parser);
#line 183 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp4_ = json_node_get_object (_tmp3_);
#line 183 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp5_ = __vala_JsonObject_copy0 (_tmp4_);
#line 183 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		root_object = _tmp5_;
#line 184 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp6_ = root_object;
#line 184 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp7_ = json_object_get_string_member (_tmp6_, "id");
#line 184 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 184 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		id = _tmp8_;
#line 185 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp9_ = id;
#line 185 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_debug ("accounts.vala:185: ID is %s", _tmp9_);
#line 186 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp10_ = id;
#line 186 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp11_ = gwibber_account_new (_tmp10_);
#line 186 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		account = _tmp11_;
#line 187 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp12_ = account;
#line 187 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_emit_by_name (self, "created", _tmp12_);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (account);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (id);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		__vala_JsonObject_free0 (root_object);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (parser);
#line 1454 "accounts.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 189 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp13_ = e;
#line 189 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp14_ = _tmp13_->message;
#line 189 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:189: %s", _tmp14_);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 1474 "accounts.c"
	}
	__finally7:
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (_inner_error_ != NULL) {
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (account_string);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_clear_error (&_inner_error_);
#line 180 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return;
#line 1487 "accounts.c"
	}
#line 177 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_g_free0 (account_string);
#line 1491 "accounts.c"
}


void gwibber_accounts_account_deleted (GwibberAccounts* self, const gchar* account_in) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* account_string;
	GError * _inner_error_ = NULL;
#line 192 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (self != NULL);
#line 192 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (account_in != NULL);
#line 195 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = account_in;
#line 195 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 195 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	account_string = _tmp1_;
#line 1510 "accounts.c"
	{
		JsonParser* _tmp2_;
		JsonParser* parser;
		JsonNode* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_;
		JsonObject* root_object;
		JsonObject* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* id;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 197 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp2_ = json_parser_new ();
#line 197 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		parser = _tmp2_;
#line 198 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		json_parser_load_from_data (parser, account_string, (gssize) (-1), &_inner_error_);
#line 198 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		if (_inner_error_ != NULL) {
#line 198 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
			_g_object_unref0 (parser);
#line 1534 "accounts.c"
			goto __catch8_g_error;
		}
#line 199 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp3_ = json_parser_get_root (parser);
#line 199 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp4_ = json_node_get_object (_tmp3_);
#line 199 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp5_ = __vala_JsonObject_copy0 (_tmp4_);
#line 199 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		root_object = _tmp5_;
#line 200 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp6_ = root_object;
#line 200 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp7_ = json_object_get_string_member (_tmp6_, "id");
#line 200 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 200 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		id = _tmp8_;
#line 201 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp9_ = id;
#line 201 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_debug ("accounts.vala:201: ID is %s", _tmp9_);
#line 202 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp10_ = id;
#line 202 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_signal_emit_by_name (self, "deleted", _tmp10_);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (id);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		__vala_JsonObject_free0 (root_object);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_object_unref0 (parser);
#line 1567 "accounts.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		e = _inner_error_;
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_inner_error_ = NULL;
#line 204 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp11_ = e;
#line 204 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_tmp12_ = _tmp11_->message;
#line 204 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_warning ("accounts.vala:204: %s", _tmp12_);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_error_free0 (e);
#line 1587 "accounts.c"
	}
	__finally8:
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	if (_inner_error_ != NULL) {
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		_g_free0 (account_string);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		g_clear_error (&_inner_error_);
#line 196 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
		return;
#line 1600 "accounts.c"
	}
#line 192 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_g_free0 (account_string);
#line 1604 "accounts.c"
}


void gwibber_accounts_accounts_available (GwibberAccounts* self, gboolean is_up) {
	gboolean _tmp0_;
#line 209 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_return_if_fail (self != NULL);
#line 211 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_tmp0_ = is_up;
#line 211 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_signal_emit_by_name (self, "is-available", _tmp0_);
#line 1616 "accounts.c"
}


static void gwibber_accounts_class_init (GwibberAccountsClass * klass) {
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	gwibber_accounts_parent_class = g_type_class_peek_parent (klass);
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_type_class_add_private (klass, sizeof (GwibberAccountsPrivate));
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	G_OBJECT_CLASS (klass)->finalize = gwibber_accounts_finalize;
#line 1627 "accounts.c"
	/** 
	            Accounts::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Accounts availability state changes
	*/
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_signal_new ("is_available", GWIBBER_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 1636 "accounts.c"
	/** 
	            Accounts::updated:
	            @arg0: HashTable of an account
	
	            Emitted when an account has changed
	        */
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_signal_new ("updated", GWIBBER_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GWIBBER_TYPE_ACCOUNT);
#line 1645 "accounts.c"
	/** 
	            Accounts::created:
	            @arg0: HashTable of an account
	
	            Emitted when an account has changed
	        */
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_signal_new ("created", GWIBBER_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GWIBBER_TYPE_ACCOUNT);
#line 1654 "accounts.c"
	/** 
	            Accounts::deleted:
	            @arg0: account id as a string
	
	            Emitted when an account has changed
	        */
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	g_signal_new ("deleted", GWIBBER_TYPE_ACCOUNTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1663 "accounts.c"
}


static void gwibber_accounts_instance_init (GwibberAccounts * self) {
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	self->priv = GWIBBER_ACCOUNTS_GET_PRIVATE (self);
#line 1670 "accounts.c"
}


static void gwibber_accounts_finalize (GObject* obj) {
	GwibberAccounts * self;
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	self = GWIBBER_ACCOUNTS (obj);
#line 41 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_g_object_unref0 (self->priv->accounts_service);
#line 42 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	_g_object_unref0 (self->priv->utils);
#line 36 "/storage/1/src/gwibber/trunk/libgwibber/accounts.vala"
	G_OBJECT_CLASS (gwibber_accounts_parent_class)->finalize (obj);
#line 1684 "accounts.c"
}


GType gwibber_accounts_get_type (void) {
	static volatile gsize gwibber_accounts_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_accounts_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberAccountsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_accounts_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberAccounts), 0, (GInstanceInitFunc) gwibber_accounts_instance_init, NULL };
		GType gwibber_accounts_type_id;
		gwibber_accounts_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberAccounts", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_accounts_type_id__volatile, gwibber_accounts_type_id);
	}
	return gwibber_accounts_type_id__volatile;
}



