/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */


[DBus (name = "com.Gwibber.Messages")]
private interface MessagesInterface : Object {
	public signal void Message (string change, string data);
        public abstract string Get (string mid) throws GLib.IOError;
}

namespace Gwibber
{
    public class Messages : Object
    {
        private const string messages_name  = "com.Gwibber.Messages";
        private const string messages_path  = "/com/gwibber/Messages";

        private MessagesInterface messages_service;
	private Gwibber.Utils utils;

	/** 
            Messages::is_available:
            @arg0: The current state

            Emitted when com.Gwibber.Messages availability state changes
	*/
	public signal void is_available(bool is_up);

        /**
            Messages::message:
            @arg0: change
            @arg1: message

            Emitted when there is a new message
        */
        public signal void message(string change, string data);

	public Messages ()
	{
            try
            {
                messages_service = Bus.get_proxy_sync(BusType.SESSION,
                                                           messages_name,
                                                           messages_path);
                utils = new Gwibber.Utils();
                utils.setup(messages_name);
                utils.available.connect(messages_available);
                messages_service.Message.connect((change, data) => {
                    on_new_message (change, data);
                });
            }
            catch (GLib.IOError e)
            {
                warning ("Unable to get Gwibber Messages "+e.message);
            }
        }


        /**
         * com.Gwibber.Messages
         **/
	/*
        public GLib.Array stream(string stream, string account, int time, string transient, string recipient, string orderby, string order, int limit)
        {
            try
            {
                return messages_service.Stream(stream, account, time, transient, recipient, orderby, order, limit);
            }
            catch (GLib.IOError e)
            {
                warning (e.message);
                return null;
            }
          
        }   
	*/

        public string get_message (string mid)
        {
            try
            {
                return messages_service.Get(mid);
            }
            catch (GLib.IOError e)
            {
                warning (e.message);
                return "";
            }
          
        }

	public void on_new_message(string change, string data)
	{
                message(change, data);
	}
        
	private void messages_available(bool is_up)
	{
		is_available(is_up);
	}
    }
}
