/* urlshorten.c generated by valac 0.16.0, the Vala compiler
 * generated from urlshorten.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "gwibber.h"


#define TYPE_URL_SHORTEN_INTERFACE (url_shorten_interface_get_type ())
#define URL_SHORTEN_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_SHORTEN_INTERFACE, URLShortenInterface))
#define IS_URL_SHORTEN_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_SHORTEN_INTERFACE))
#define URL_SHORTEN_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_URL_SHORTEN_INTERFACE, URLShortenInterfaceIface))

typedef struct _URLShortenInterface URLShortenInterface;
typedef struct _URLShortenInterfaceIface URLShortenInterfaceIface;

#define TYPE_URL_SHORTEN_INTERFACE_PROXY (url_shorten_interface_proxy_get_type ())
typedef GDBusProxy URLShortenInterfaceProxy;
typedef GDBusProxyClass URLShortenInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _URLShortenInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Shorten) (URLShortenInterface* self, const gchar* url, GError** error);
};

struct _GwibberURLShortenPrivate {
	URLShortenInterface* url_service;
	GwibberUtils* utils;
};


static gpointer gwibber_url_shorten_parent_class = NULL;

GType url_shorten_interface_proxy_get_type (void) G_GNUC_CONST;
guint url_shorten_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType url_shorten_interface_get_type (void) G_GNUC_CONST;
gchar* url_shorten_interface_Shorten (URLShortenInterface* self, const gchar* url, GError** error);
static void url_shorten_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* url_shorten_interface_proxy_Shorten (URLShortenInterface* self, const gchar* url, GError** error);
static void url_shorten_interface_proxy_url_shorten_interface_interface_init (URLShortenInterfaceIface* iface);
static void _dbus_url_shorten_interface_Shorten (URLShortenInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void url_shorten_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* url_shorten_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean url_shorten_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _url_shorten_interface_unregister_object (gpointer user_data);
#define GWIBBER_URL_SHORTEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_URL_SHORTEN, GwibberURLShortenPrivate))
enum  {
	GWIBBER_URL_SHORTEN_DUMMY_PROPERTY
};
#define GWIBBER_URL_SHORTEN_url_name "com.Gwibber.URLShorten"
#define GWIBBER_URL_SHORTEN_url_path "/com/gwibber/URLShorten"
static GObject * gwibber_url_shorten_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_url_shorten_url_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void gwibber_url_shorten_finalize (GObject* obj);

static const GDBusArgInfo _url_shorten_interface_dbus_arg_info_Shorten_url = {-1, "url", "s"};
static const GDBusArgInfo _url_shorten_interface_dbus_arg_info_Shorten_result = {-1, "result", "s"};
static const GDBusArgInfo * const _url_shorten_interface_dbus_arg_info_Shorten_in[] = {&_url_shorten_interface_dbus_arg_info_Shorten_url, NULL};
static const GDBusArgInfo * const _url_shorten_interface_dbus_arg_info_Shorten_out[] = {&_url_shorten_interface_dbus_arg_info_Shorten_result, NULL};
static const GDBusMethodInfo _url_shorten_interface_dbus_method_info_Shorten = {-1, "Shorten", (GDBusArgInfo **) (&_url_shorten_interface_dbus_arg_info_Shorten_in), (GDBusArgInfo **) (&_url_shorten_interface_dbus_arg_info_Shorten_out)};
static const GDBusMethodInfo * const _url_shorten_interface_dbus_method_info[] = {&_url_shorten_interface_dbus_method_info_Shorten, NULL};
static const GDBusSignalInfo * const _url_shorten_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _url_shorten_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _url_shorten_interface_dbus_interface_info = {-1, "com.Gwibber.URLShorten", (GDBusMethodInfo **) (&_url_shorten_interface_dbus_method_info), (GDBusSignalInfo **) (&_url_shorten_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_url_shorten_interface_dbus_property_info)};
static const GDBusInterfaceVTable _url_shorten_interface_dbus_interface_vtable = {url_shorten_interface_dbus_interface_method_call, url_shorten_interface_dbus_interface_get_property, url_shorten_interface_dbus_interface_set_property};

gchar* url_shorten_interface_Shorten (URLShortenInterface* self, const gchar* url, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return URL_SHORTEN_INTERFACE_GET_INTERFACE (self)->Shorten (self, url, error);
}


static void url_shorten_interface_base_init (URLShortenInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType url_shorten_interface_get_type (void) {
	static volatile gsize url_shorten_interface_type_id__volatile = 0;
	if (g_once_init_enter (&url_shorten_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (URLShortenInterfaceIface), (GBaseInitFunc) url_shorten_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType url_shorten_interface_type_id;
		url_shorten_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "URLShortenInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (url_shorten_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (url_shorten_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) url_shorten_interface_proxy_get_type);
		g_type_set_qdata (url_shorten_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.Gwibber.URLShorten");
		g_type_set_qdata (url_shorten_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) url_shorten_interface_register_object);
		g_once_init_leave (&url_shorten_interface_type_id__volatile, url_shorten_interface_type_id);
	}
	return url_shorten_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (URLShortenInterfaceProxy, url_shorten_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_URL_SHORTEN_INTERFACE, url_shorten_interface_proxy_url_shorten_interface_interface_init) )
static void url_shorten_interface_proxy_class_init (URLShortenInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = url_shorten_interface_proxy_g_signal;
}


static void url_shorten_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void url_shorten_interface_proxy_init (URLShortenInterfaceProxy* self) {
}


static gchar* url_shorten_interface_proxy_Shorten (URLShortenInterface* self, const gchar* url, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp55_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.URLShorten", "Shorten");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp55_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp55_, NULL);
	g_variant_unref (_tmp55_);
	g_object_unref (_reply_message);
	return _result;
}


static void url_shorten_interface_proxy_url_shorten_interface_interface_init (URLShortenInterfaceIface* iface) {
	iface->Shorten = url_shorten_interface_proxy_Shorten;
}


static void _dbus_url_shorten_interface_Shorten (URLShortenInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp56_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp56_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp56_, NULL);
	g_variant_unref (_tmp56_);
	result = url_shorten_interface_Shorten (self, url, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (url);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void url_shorten_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Shorten") == 0) {
		_dbus_url_shorten_interface_Shorten (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* url_shorten_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean url_shorten_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint url_shorten_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_url_shorten_interface_dbus_interface_info), &_url_shorten_interface_dbus_interface_vtable, data, _url_shorten_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _url_shorten_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
         * com.Gwibber.URLShorten
         **/
gchar* gwibber_url_shorten_shorten (GwibberURLShorten* self, const gchar* url) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	{
		URLShortenInterface* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = self->priv->url_service;
		_tmp1_ = url;
		_tmp2_ = url_shorten_interface_Shorten (_tmp0_, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch61_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp3_;
		return result;
	}
	goto __finally61;
	__catch61_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("urlshorten.vala:74: %s", _tmp5_);
		_tmp6_ = g_strdup ("Failed");
		result = _tmp6_;
		_g_error_free0 (e);
		return result;
	}
	__finally61:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void gwibber_url_shorten_url_available (GwibberURLShorten* self, gboolean is_up) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_up;
	g_signal_emit_by_name (self, "is-available", _tmp0_);
}


GwibberURLShorten* gwibber_url_shorten_construct (GType object_type) {
	GwibberURLShorten * self = NULL;
	self = (GwibberURLShorten*) g_object_new (object_type, NULL);
	return self;
}


GwibberURLShorten* gwibber_url_shorten_new (void) {
	return gwibber_url_shorten_construct (GWIBBER_TYPE_URL_SHORTEN);
}


static void _gwibber_url_shorten_url_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_url_shorten_url_available (self, up);
}


static GObject * gwibber_url_shorten_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberURLShorten * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_url_shorten_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_URL_SHORTEN (obj);
	{
		URLShortenInterface* _tmp0_ = NULL;
		URLShortenInterface* _tmp1_;
		GwibberUtils* _tmp2_;
		GwibberUtils* _tmp3_;
		GwibberUtils* _tmp4_;
		_tmp0_ = g_initable_new (TYPE_URL_SHORTEN_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", GWIBBER_URL_SHORTEN_url_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GWIBBER_URL_SHORTEN_url_path, "g-interface-name", "com.Gwibber.URLShorten", NULL);
		_tmp1_ = (URLShortenInterface*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch62_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->url_service);
		self->priv->url_service = _tmp1_;
		_tmp2_ = gwibber_utils_new ();
		_g_object_unref0 (self->priv->utils);
		self->priv->utils = _tmp2_;
		_tmp3_ = self->priv->utils;
		gwibber_utils_setup (_tmp3_, GWIBBER_URL_SHORTEN_url_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch62_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp4_ = self->priv->utils;
		g_signal_connect_object (_tmp4_, "available", (GCallback) _gwibber_url_shorten_url_available_gwibber_utils_available, self, 0);
	}
	goto __finally62;
	__catch62_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strconcat ("Unable to get Gwibber URLShorten: ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		g_warning ("urlshorten.vala:58: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally62:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void gwibber_url_shorten_class_init (GwibberURLShortenClass * klass) {
	gwibber_url_shorten_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberURLShortenPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_url_shorten_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_url_shorten_finalize;
	/** 
	            URLShorten::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.URLShorten availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_URL_SHORTEN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_url_shorten_instance_init (GwibberURLShorten * self) {
	self->priv = GWIBBER_URL_SHORTEN_GET_PRIVATE (self);
}


static void gwibber_url_shorten_finalize (GObject* obj) {
	GwibberURLShorten * self;
	self = GWIBBER_URL_SHORTEN (obj);
	_g_object_unref0 (self->priv->url_service);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_url_shorten_parent_class)->finalize (obj);
}


GType gwibber_url_shorten_get_type (void) {
	static volatile gsize gwibber_url_shorten_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_url_shorten_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberURLShortenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_url_shorten_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberURLShorten), 0, (GInstanceInitFunc) gwibber_url_shorten_instance_init, NULL };
		GType gwibber_url_shorten_type_id;
		gwibber_url_shorten_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberURLShorten", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_url_shorten_type_id__volatile, gwibber_url_shorten_type_id);
	}
	return gwibber_url_shorten_type_id__volatile;
}



