/***************************************************************************
                          kgpglibrary.h  -  description
                             -------------------
    begin                : Mon Jul 8 2002
    copyright          : (C) 2002 by Jean-Baptiste Mardelle
    email                : bj@altern.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGPGLIBRARY_H
#define KGPGLIBRARY_H

#include <QObject>

#include <KShortcut>
#include <KUrl>

#include <QStringList>
#include <QString>

class KPassivePopup;
class KGpgTextInterface;
class KGpgItemModel;

class KgpgLibrary : public QObject
{
    Q_OBJECT

public:
    /**
     * Initialize the class
     */
    explicit KgpgLibrary(QWidget *parent = 0);

    void slotFileEnc(const KUrl::List &urls, const QStringList &opts, KGpgItemModel *model, const KShortcut &goDefaultKey, const QString &defaultKey = QString());

signals:
    void encryptionOver();
    void systemMessage(QString message);

private slots:
    void processEnc(const KUrl &);
    void processEncError(const QString &mssge);

private:
    void fastEncode(const KUrl &filetocrypt, const QStringList &encryptkeys, const QStringList &encryptoptions, const bool symetric);
    QWidget *m_panel;
    const QString m_extension;
    QStringList m_encryptkeys;
    QStringList m_encryptoptions;

    KUrl::List m_urlselecteds;
    KUrl m_urlselected;
    KPassivePopup *m_pop;

    bool m_popisactive;
    bool m_symetric;
};

#endif // KGPGLIBRARY_H
