/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.CellCoverInfo;
import org.odftoolkit.odfdom.doc.table.DomNodeList;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableCellRange;
import org.odftoolkit.odfdom.doc.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.attribute.table.TableAlignAttribute;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedRangeElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableProperties;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.PositiveLength;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfTable {
    TableTableElement mTableElement;
    protected OdfDocument mDocument;
    protected boolean mIsSpreadsheet;
    protected boolean mIsCellStyleInheritance = true;
    private static final int DEFAULT_ROW_COUNT = 2;
    private static final int DEFAULT_COLUMN_COUNT = 5;
    private static final double DEFAULT_TABLE_WIDTH = 6.0;
    private static final int DEFAULT_REL_TABLE_WIDTH = 65535;
    private static final String DEFAULT_TABLE_ALIGN = "margins";
    static IdentityHashMap<TableTableElement, OdfTable> mTableRepository = new IdentityHashMap();
    IdentityHashMap<TableTableCellElementBase, Vector<OdfTableCell>> mCellRepository = new IdentityHashMap();
    IdentityHashMap<TableTableRowElement, Vector<OdfTableRow>> mRowRepository = new IdentityHashMap();
    IdentityHashMap<TableTableColumnElement, Vector<OdfTableColumn>> mColumnRepository = new IdentityHashMap();

    private OdfTable(TableTableElement table) {
        this.mTableElement = table;
        this.mDocument = (OdfDocument)((OdfFileDom)table.getOwnerDocument()).getDocument();
        this.mIsSpreadsheet = this.mDocument instanceof OdfSpreadsheetDocument;
    }

    public static synchronized OdfTable getInstance(TableTableElement odfElement) {
        if (mTableRepository.containsKey(odfElement)) {
            return mTableRepository.get(odfElement);
        }
        OdfTable newTable = new OdfTable(odfElement);
        mTableRepository.put(odfElement, newTable);
        return newTable;
    }

    OdfTableCell getCellInstance(TableTableCellElementBase cell, int repeatedColIndex, int repeatedRowIndex) {
        if (this.mCellRepository.containsKey(cell)) {
            Vector<OdfTableCell> list = this.mCellRepository.get(cell);
            OdfTableCell fCell = null;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getOdfElement() != cell || list.get((int)i).mnRepeatedColIndex != repeatedColIndex || list.get((int)i).mnRepeatedRowIndex != repeatedRowIndex) continue;
                fCell = list.get(i);
                break;
            }
            if (fCell == null) {
                fCell = new OdfTableCell(cell, repeatedColIndex, repeatedRowIndex);
                list.add(fCell);
            }
            return fCell;
        }
        OdfTableCell newCell = new OdfTableCell(cell, repeatedColIndex, repeatedRowIndex);
        Vector<OdfTableCell> list = new Vector<OdfTableCell>();
        list.add(newCell);
        this.mCellRepository.put(cell, list);
        return newCell;
    }

    OdfTableRow getRowInstance(TableTableRowElement row, int repeatedRowIndex) {
        if (this.mRowRepository.containsKey(row)) {
            OdfTableRow fCell;
            Vector<OdfTableRow> list = this.mRowRepository.get(row);
            if (list.size() <= repeatedRowIndex) {
                list.setSize(repeatedRowIndex + 1);
            }
            if ((fCell = list.get(repeatedRowIndex)) == null) {
                fCell = new OdfTableRow(row, repeatedRowIndex);
                list.set(repeatedRowIndex, fCell);
            }
            return fCell;
        }
        OdfTableRow newCell = new OdfTableRow(row, repeatedRowIndex);
        int size = repeatedRowIndex > 7 ? repeatedRowIndex + 1 : 8;
        Vector<OdfTableRow> list = new Vector<OdfTableRow>(size);
        list.setSize(repeatedRowIndex + 1);
        list.set(repeatedRowIndex, newCell);
        this.mRowRepository.put(row, list);
        return newCell;
    }

    OdfTableColumn getColumnInstance(TableTableColumnElement col, int repeatedColIndex) {
        if (this.mColumnRepository.containsKey(col)) {
            OdfTableColumn fClm;
            Vector<OdfTableColumn> list = this.mColumnRepository.get(col);
            if (list.size() <= repeatedColIndex) {
                list.setSize(repeatedColIndex + 1);
            }
            if ((fClm = list.get(repeatedColIndex)) == null) {
                fClm = new OdfTableColumn(col, repeatedColIndex);
                list.set(repeatedColIndex, fClm);
            }
            return fClm;
        }
        OdfTableColumn newCell = new OdfTableColumn(col, repeatedColIndex);
        int size = repeatedColIndex > 7 ? repeatedColIndex + 1 : 8;
        Vector<OdfTableColumn> list = new Vector<OdfTableColumn>(size);
        list.setSize(repeatedColIndex + 1);
        list.set(repeatedColIndex, newCell);
        this.mColumnRepository.put(col, list);
        return newCell;
    }

    TableTableColumnElement getColumnElementByIndex(int colIndex) {
        int result = 0;
        TableTableColumnElement columnEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                TableTableHeaderColumnsElement headers = (TableTableHeaderColumnsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (m instanceof TableTableColumnElement) {
                        columnEle = (TableTableColumnElement)m;
                        result = columnEle.getTableNumberColumnsRepeatedAttribute() == null ? ++result : (result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue());
                    }
                    if (result <= colIndex) continue;
                    break;
                }
            }
            if (n instanceof TableTableColumnElement) {
                columnEle = (TableTableColumnElement)n;
                result = columnEle.getTableNumberColumnsRepeatedAttribute() == null ? ++result : (result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue());
            }
            if (result <= colIndex) continue;
            break;
        }
        return columnEle;
    }

    TableTableRowElement getRowElementByIndex(int rowIndex) {
        int result = 0;
        TableTableRowElement rowEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (m instanceof TableTableRowElement) {
                        rowEle = (TableTableRowElement)m;
                        result += rowEle.getTableNumberRowsRepeatedAttribute().intValue();
                    }
                    if (result <= rowIndex) continue;
                    break;
                }
            }
            if (n instanceof TableTableRowElement) {
                rowEle = (TableTableRowElement)n;
                result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
            }
            if (result <= rowIndex) continue;
            break;
        }
        return rowEle;
    }

    public long getWidth() {
        if (!this.mIsSpreadsheet) {
            String sWidth = this.mTableElement.getProperty(OdfTableProperties.Width);
            if (sWidth == null) {
                int colCount = this.getColumnCount();
                int tableWidth = 0;
                for (int i = 0; i < colCount; ++i) {
                    OdfTableColumn col = this.getColumnByIndex(i);
                    tableWidth = (int)((long)tableWidth + col.getWidth());
                }
                return tableWidth;
            }
            return PositiveLength.parseLong(sWidth, Length.Unit.MILLIMETER);
        }
        throw new UnsupportedOperationException();
    }

    public void setWidth(long width) {
        if (!this.mIsSpreadsheet) {
            String sWidthMM = String.valueOf(width) + Length.Unit.MILLIMETER.abbr();
            String sWidthIN = PositiveLength.mapToUnit(sWidthMM, Length.Unit.INCH);
            this.mTableElement.setProperty(OdfTableProperties.Width, sWidthIN);
            String alineStyle = this.mTableElement.getProperty(StyleTablePropertiesElement.Align);
            if (TableAlignAttribute.Value.MARGINS.toString().equals(alineStyle)) {
                this.mTableElement.setProperty(StyleTablePropertiesElement.Align, TableAlignAttribute.Value.LEFT.toString());
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static void setLeftTopBorderStyleProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.BorderLeft, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderRight, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderTop, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderBottom, "0.0007in solid #000000");
    }

    static void setRightTopBorderStyleProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.Border, "0.0007in solid #000000");
    }

    static void setLeftBottomBorderStylesProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.BorderLeft, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderRight, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderTop, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderBottom, "0.0007in solid #000000");
    }

    static void setRightBottomBorderStylesProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.Border, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderTop, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderBottom, "0.0007in solid #000000");
    }

    private static TableTableElement createTable(OdfElement parent, int numRows, int numCols, int headerRowNumber, int headerColumnNumber) throws Exception {
        if (numRows < 1 || numCols < 1 || headerRowNumber < 0 || headerColumnNumber < 0 || headerRowNumber > numRows || headerColumnNumber > numCols) {
            throw new IllegalArgumentException("Can not create table with the given parameters:\nRows " + numRows + ", Columns " + numCols + ", HeaderRows " + headerRowNumber + ", HeaderColumns " + headerColumnNumber);
        }
        OdfFileDom dom = (OdfFileDom)parent.getOwnerDocument();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        TableTableElement newTEle = (TableTableElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table"));
        String tablename = OdfTable.getUniqueTableName(parent);
        newTEle.setTableNameAttribute(tablename);
        OdfStyle tableStyle = styles.newStyle(OdfStyleFamily.Table);
        String stylename = tableStyle.getStyleNameAttribute();
        tableStyle.setProperty(StyleTablePropertiesElement.Width, "6.0in");
        tableStyle.setProperty(StyleTablePropertiesElement.Align, DEFAULT_TABLE_ALIGN);
        newTEle.setStyleName(stylename);
        OdfStyle columnStyle = styles.newStyle(OdfStyleFamily.TableColumn);
        String columnStylename = columnStyle.getStyleNameAttribute();
        columnStyle.setProperty(StyleTableColumnPropertiesElement.ColumnWidth, new DecimalFormat("000.0000").format(6.0 / (double)numCols) + "in");
        columnStyle.setProperty(StyleTableColumnPropertiesElement.RelColumnWidth, Math.round(65535 / numCols) + "*");
        if (headerColumnNumber > 0) {
            TableTableHeaderColumnsElement headercolumns = (TableTableHeaderColumnsElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-header-columns"));
            TableTableColumnElement headercolumn = (TableTableColumnElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
            headercolumn.setTableNumberColumnsRepeatedAttribute(headerColumnNumber);
            headercolumns.appendChild(headercolumn);
            newTEle.appendChild(headercolumns);
            headercolumn.setStyleName(columnStylename);
        }
        TableTableColumnElement columns = (TableTableColumnElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
        columns.setTableNumberColumnsRepeatedAttribute(numCols - headerColumnNumber);
        columns.setStyleName(columnStylename);
        newTEle.appendChild(columns);
        OdfStyle lefttopStyle = null;
        OdfStyle leftbottomStyle = null;
        OdfStyle righttopStyle = null;
        OdfStyle rightbottomStyle = null;
        OdfPackageDocument document = dom.getDocument();
        if (!document.getMediaTypeString().equals(OdfDocument.OdfMediaType.SPREADSHEET.getMediaTypeString())) {
            lefttopStyle = styles.newStyle(OdfStyleFamily.TableCell);
            OdfTable.setLeftTopBorderStyleProperties(lefttopStyle);
            leftbottomStyle = styles.newStyle(OdfStyleFamily.TableCell);
            OdfTable.setLeftBottomBorderStylesProperties(leftbottomStyle);
            righttopStyle = styles.newStyle(OdfStyleFamily.TableCell);
            OdfTable.setRightTopBorderStyleProperties(righttopStyle);
            rightbottomStyle = styles.newStyle(OdfStyleFamily.TableCell);
            OdfTable.setRightBottomBorderStylesProperties(rightbottomStyle);
        }
        if (headerRowNumber > 0) {
            TableTableHeaderRowsElement headerrows = (TableTableHeaderRowsElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-header-rows"));
            for (int i = 0; i < headerRowNumber; ++i) {
                TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
                for (int j = 0; j < numCols; ++j) {
                    TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
                    TextPElement aParagraph = (TextPElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TEXT, "p"));
                    aCell.appendChild(aParagraph);
                    if (!(document instanceof OdfSpreadsheetDocument)) {
                        if (j + 1 == numCols && i == 0) {
                            aCell.setStyleName(righttopStyle.getStyleNameAttribute());
                        } else if (i == 0) {
                            aCell.setStyleName(lefttopStyle.getStyleNameAttribute());
                        } else if (j + 1 == numCols && i > 0) {
                            aCell.setStyleName(rightbottomStyle.getStyleNameAttribute());
                        } else {
                            aCell.setStyleName(leftbottomStyle.getStyleNameAttribute());
                        }
                    }
                    aRow.appendChild(aCell);
                }
                headerrows.appendChild(aRow);
            }
            newTEle.appendChild(headerrows);
        }
        for (int i = headerRowNumber; i < numRows; ++i) {
            TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
            for (int j = 0; j < numCols; ++j) {
                TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
                TextPElement aParagraph = (TextPElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TEXT, "p"));
                aCell.appendChild(aParagraph);
                if (!(document instanceof OdfSpreadsheetDocument)) {
                    if (j + 1 == numCols && i == 0) {
                        aCell.setStyleName(righttopStyle.getStyleNameAttribute());
                    } else if (i == 0) {
                        aCell.setStyleName(lefttopStyle.getStyleNameAttribute());
                    } else if (j + 1 == numCols && i > 0) {
                        aCell.setStyleName(rightbottomStyle.getStyleNameAttribute());
                    } else {
                        aCell.setStyleName(leftbottomStyle.getStyleNameAttribute());
                    }
                }
                aRow.appendChild(aCell);
            }
            newTEle.appendChild(aRow);
        }
        return newTEle;
    }

    public static OdfTable newTable(OdfElement tableParent) {
        try {
            TableTableElement newTEle = OdfTable.createTable(tableParent, 2, 5, 0, 0);
            tableParent.appendChild(newTEle);
            return OdfTable.getInstance(newTEle);
        }
        catch (DOMException e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public static OdfTable newTable(OdfDocument document) {
        OdfTable table = null;
        try {
            table = OdfTable.newTable(document.getContentRoot());
        }
        catch (Exception ex) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table;
    }

    private static String getUniqueTableName(OdfElement tableParent) {
        OdfFileDom dom = (OdfFileDom)tableParent.getOwnerDocument();
        List<TableTableElement> tableList = ((OdfSchemaDocument)dom.getDocument()).getTables();
        boolean notUnique = true;
        String tablename = "Table" + (tableList.size() + 1);
        while (notUnique) {
            notUnique = false;
            for (int i = 0; i < tableList.size(); ++i) {
                if (!tableList.get(i).getTableNameAttribute().equalsIgnoreCase(tablename)) continue;
                notUnique = true;
                break;
            }
            if (!notUnique) continue;
            tablename = tablename + Math.round(Math.random() * 10.0);
        }
        return tablename;
    }

    public static OdfTable newTable(OdfElement tableParent, int numRows, int numCols) {
        try {
            TableTableElement newTEle = OdfTable.createTable(tableParent, numRows, numCols, 0, 0);
            tableParent.appendChild(newTEle);
            return OdfTable.getInstance(newTEle);
        }
        catch (Exception e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static OdfTable newTable(OdfDocument document, int numRows, int numCols) {
        OdfTable table = null;
        try {
            table = OdfTable.newTable(document.getContentRoot(), numRows, numCols);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table;
    }

    public static OdfTable newTable(OdfElement tableParent, int numRows, int numCols, int headerRowNumber, int headerColumnNumber) {
        try {
            TableTableElement newTEle = OdfTable.createTable(tableParent, numRows, numCols, headerRowNumber, headerColumnNumber);
            tableParent.appendChild(newTEle);
            return OdfTable.getInstance(newTEle);
        }
        catch (DOMException e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public static OdfTable newTable(OdfDocument document, int numRows, int numCols, int headerRowNumber, int headerColumnNumber) {
        OdfTable table = null;
        try {
            table = OdfTable.newTable(document.getContentRoot(), numRows, numCols, headerRowNumber, headerColumnNumber);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table;
    }

    public static OdfTable newTable(OdfElement tableParent, String[] rowLabel, String[] columnLabel, double[][] data) {
        int rowNumber = 2;
        int columnNumber = 5;
        if (data != null) {
            rowNumber = data.length;
            columnNumber = data[0].length;
        }
        int rowHeaders = 0;
        int columnHeaders = 0;
        if (rowLabel != null) {
            rowHeaders = 1;
        }
        if (columnLabel != null) {
            columnHeaders = 1;
        }
        try {
            TableTableElement newTEle = OdfTable.createTable(tableParent, rowNumber + rowHeaders, columnNumber + columnHeaders, rowHeaders, columnHeaders);
            tableParent.appendChild(newTEle);
            OdfTable table = OdfTable.getInstance(newTEle);
            List<OdfTableRow> rowList = table.getRowList();
            for (int i = 0; i < rowNumber + rowHeaders; ++i) {
                OdfTableRow row = rowList.get(i);
                for (int j = 0; j < columnNumber + columnHeaders; ++j) {
                    if (i == 0 && j == 0) continue;
                    OdfTableCell cell = row.getCellByIndex(j);
                    if (i == 0 && columnLabel != null) {
                        if (j <= columnLabel.length) {
                            cell.setStringValue(columnLabel[j - 1]);
                            continue;
                        }
                        cell.setStringValue("");
                        continue;
                    }
                    if (j == 0 && rowLabel != null) {
                        if (i <= rowLabel.length) {
                            cell.setStringValue(rowLabel[i - 1]);
                            continue;
                        }
                        cell.setStringValue("");
                        continue;
                    }
                    if (data == null || i < rowHeaders || j < columnHeaders) continue;
                    cell.setDoubleValue(data[i - rowHeaders][j - columnHeaders]);
                }
            }
            return table;
        }
        catch (DOMException e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public static OdfTable newTable(OdfDocument document, String[] rowLabel, String[] columnLabel, double[][] data) {
        OdfTable table = null;
        try {
            table = OdfTable.newTable(document.getContentRoot(), rowLabel, columnLabel, data);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table;
    }

    public static OdfTable newTable(OdfElement tableParent, String[] rowLabel, String[] columnLabel, String[][] data) {
        int rowNumber = 2;
        int columnNumber = 5;
        if (data != null) {
            rowNumber = data.length;
            columnNumber = data[0].length;
        }
        int rowHeaders = 0;
        int columnHeaders = 0;
        if (rowLabel != null) {
            rowHeaders = 1;
        }
        if (columnLabel != null) {
            columnHeaders = 1;
        }
        try {
            TableTableElement newTEle = OdfTable.createTable(tableParent, rowNumber + rowHeaders, columnNumber + columnHeaders, rowHeaders, columnHeaders);
            tableParent.appendChild(newTEle);
            OdfTable table = OdfTable.getInstance(newTEle);
            List<OdfTableRow> rowList = table.getRowList();
            for (int i = 0; i < rowNumber + rowHeaders; ++i) {
                OdfTableRow row = rowList.get(i);
                for (int j = 0; j < columnNumber + columnHeaders; ++j) {
                    if (i == 0 && j == 0) continue;
                    OdfTableCell cell = row.getCellByIndex(j);
                    if (i == 0 && columnLabel != null) {
                        if (j <= columnLabel.length) {
                            cell.setStringValue(columnLabel[j - 1]);
                            continue;
                        }
                        cell.setStringValue("");
                        continue;
                    }
                    if (j == 0 && rowLabel != null) {
                        if (i <= rowLabel.length) {
                            cell.setStringValue(rowLabel[i - 1]);
                            continue;
                        }
                        cell.setStringValue("");
                        continue;
                    }
                    if (data == null || i < rowHeaders || j < columnHeaders) continue;
                    cell.setStringValue(data[i - rowHeaders][j - columnHeaders]);
                }
            }
            return table;
        }
        catch (DOMException e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public static OdfTable newTable(OdfDocument document, String[] rowLabel, String[] columnLabel, String[][] data) {
        OdfTable table = null;
        try {
            table = OdfTable.newTable(document.getContentRoot(), rowLabel, columnLabel, data);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table;
    }

    public int getRowCount() {
        int result = 0;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                result += this.getHeaderRowCount((TableTableHeaderRowsElement)n);
            }
            if (!(n instanceof TableTableRowElement)) continue;
            result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
        }
        return result;
    }

    public int getColumnCount() {
        int result = 0;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                result += this.getHeaderColumnCount((TableTableHeaderColumnsElement)n);
            }
            if (!(n instanceof TableTableColumnElement)) continue;
            result += this.getColumnInstance((TableTableColumnElement)n, 0).getColumnsRepeatedNumber();
        }
        return result;
    }

    private TableTableRowElement createDefaultRow(int columnCount) {
        OdfFileDom dom = (OdfFileDom)this.mTableElement.getOwnerDocument();
        OdfStyle lefttopStyle = null;
        OdfStyle righttopStyle = null;
        if (!this.mIsSpreadsheet) {
            lefttopStyle = this.mTableElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableCell);
            OdfTable.setLeftTopBorderStyleProperties(lefttopStyle);
            righttopStyle = this.mTableElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableCell);
            OdfTable.setRightTopBorderStyleProperties(righttopStyle);
        }
        TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
        for (int j = 0; j < columnCount; ++j) {
            TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
            TextPElement aParagraph = (TextPElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TEXT, "p"));
            aCell.appendChild(aParagraph);
            if (!this.mIsSpreadsheet) {
                if (j + 1 == columnCount) {
                    aCell.setStyleName(righttopStyle.getStyleNameAttribute());
                } else {
                    aCell.setStyleName(lefttopStyle.getStyleNameAttribute());
                }
            }
            aRow.appendChild(aCell);
        }
        return aRow;
    }

    public OdfTableRow appendRow() {
        int columnCount = this.getColumnCount();
        List<OdfTableRow> rowList = this.getRowList();
        if (rowList.size() == 0) {
            TableTableRowElement newRow = this.createDefaultRow(columnCount);
            this.mTableElement.appendChild(newRow);
            return this.getRowInstance(newRow, 0);
        }
        OdfTableRow refRow = rowList.get(rowList.size() - 1);
        OdfTableRow newRow = this.insertRowBefore(refRow, null);
        return newRow;
    }

    public List<OdfTableRow> appendRows(int rowCount) {
        return this.appendRows(rowCount, false);
    }

    List<OdfTableRow> appendRows(int rowCount, boolean isCleanStyle) {
        ArrayList<OdfTableRow> resultList = new ArrayList<OdfTableRow>();
        if (rowCount <= 0) {
            return resultList;
        }
        OdfTableRow firstRow = this.appendRow();
        resultList.add(firstRow);
        if (rowCount == 1) {
            return resultList;
        }
        List<OdfTableRow> list = this.insertRowsBefore(this.getRowCount() - 1, rowCount - 1);
        resultList.addAll(list);
        if (isCleanStyle) {
            for (OdfTableRow row : resultList) {
                for (int i = 0; i < row.getCellCount(); ++i) {
                    TableTableCellElement cellElement = (TableTableCellElement)row.getCellByIndex((int)i).mCellElement;
                    cellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
                }
            }
        }
        return resultList;
    }

    public OdfTableColumn appendColumn() {
        TableTableColumnElement newColumn;
        OdfTableRow row1;
        List<OdfTableColumn> columnList = this.getColumnList();
        int columnCount = columnList.size();
        OdfElement positonElement = this.getRowElementByIndex(0);
        if (positonElement.getParentNode() instanceof TableTableHeaderRowsElement) {
            positonElement = (OdfElement)positonElement.getParentNode();
        }
        List<OdfTableRow> rowList = this.getRowList();
        for (int i = 0; i < rowList.size(); i += row1.getRowsRepeatedNumber()) {
            row1 = rowList.get(i);
            row1.insertCellBefore(row1.getCellByIndex(columnCount - 1), null);
        }
        if (columnList.size() == 0) {
            OdfStyle columnStyle = this.mTableElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableColumn);
            String columnStylename = columnStyle.getStyleNameAttribute();
            columnStyle.setProperty(StyleTableColumnPropertiesElement.ColumnWidth, "6.0in");
            columnStyle.setProperty(StyleTableColumnPropertiesElement.RelColumnWidth, "65535*");
            newColumn = (TableTableColumnElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
            newColumn.setStyleName(columnStylename);
            this.mTableElement.insertBefore(newColumn, positonElement);
        } else {
            TableTableColumnElement refColumn = columnList.get(columnList.size() - 1).getOdfElement();
            newColumn = (TableTableColumnElement)refColumn.cloneNode(true);
            newColumn.setTableNumberColumnsRepeatedAttribute(1);
            this.mTableElement.insertBefore(newColumn, positonElement);
        }
        return this.getColumnInstance(newColumn, 0);
    }

    public List<OdfTableColumn> appendColumns(int columnCount) {
        return this.appendColumns(columnCount, false);
    }

    List<OdfTableColumn> appendColumns(int columnCount, boolean isCleanStyle) {
        ArrayList<OdfTableColumn> resultList = new ArrayList<OdfTableColumn>();
        if (columnCount <= 0) {
            return resultList;
        }
        OdfTableColumn firstClm = this.appendColumn();
        resultList.add(firstClm);
        if (columnCount == 1) {
            return resultList;
        }
        List<OdfTableColumn> list = this.insertColumnsBefore(this.getColumnCount() - 1, columnCount - 1);
        resultList.addAll(list);
        if (isCleanStyle) {
            for (OdfTableColumn column : resultList) {
                for (int i = 0; i < column.getCellCount(); ++i) {
                    TableTableCellElement cellElement = (TableTableCellElement)column.getCellByIndex((int)i).mCellElement;
                    cellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
                }
            }
        }
        return resultList;
    }

    private List<OdfTableRow> insertMultipleRowBefore(OdfTableRow refRow, OdfTableRow positionRow, int count) {
        OdfTableCell refCell;
        ArrayList<OdfTableRow> resultList = new ArrayList<OdfTableRow>();
        int j = 1;
        if (count <= 0) {
            return resultList;
        }
        OdfTableRow firstRow = this.insertRowBefore(refRow, positionRow);
        resultList.add(firstRow);
        if (count == 1) {
            return resultList;
        }
        TableTableRowElement rowEle = firstRow.getOdfElement();
        for (int i = 0; i < this.getColumnCount(); i += refCell.getColumnsRepeatedNumber()) {
            int coveredHeigth;
            refCell = refRow.getCellByIndex(i);
            if (refCell.isCoveredElement() || (coveredHeigth = refCell.getRowSpannedNumber()) <= 1) continue;
            refCell.setRowSpannedNumber(coveredHeigth + 1);
        }
        firstRow.setRowsRepeatedNumber(count);
        while (j < count) {
            resultList.add(this.getRowInstance(rowEle, j));
            ++j;
        }
        return resultList;
    }

    private OdfTableRow insertRowBefore(OdfTableRow refRow, OdfTableRow positionRow) {
        int columnCount = this.getColumnCount();
        TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
        int coveredLength = 0;
        int coveredHeigth = 0;
        int i = 0;
        while (i < columnCount) {
            TableTableCellElementBase newCellEle;
            TableTableCellElementBase aCellEle;
            OdfTableCell refCell = refRow.getCellByIndex(i);
            if (!refCell.isCoveredElement()) {
                aCellEle = (TableTableCellElement)refCell.getOdfElement();
                coveredHeigth = ((TableTableCellElement)aCellEle).getTableNumberRowsSpannedAttribute();
                if (coveredHeigth == 1) {
                    newCellEle = (TableTableCellElement)aCellEle.cloneNode(true);
                    this.cleanCell((TableTableCellElement)newCellEle);
                    aRow.appendChild(newCellEle);
                } else {
                    ((TableTableCellElement)aCellEle).setTableNumberRowsSpannedAttribute(coveredHeigth + 1);
                    newCellEle = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                    newCellEle.setTableNumberColumnsRepeatedAttribute(refCell.getColumnsRepeatedNumber());
                    aRow.appendChild(newCellEle);
                }
                coveredLength = ((TableTableCellElement)aCellEle).getTableNumberColumnsSpannedAttribute() - refCell.getColumnsRepeatedNumber();
                i += refCell.getColumnsRepeatedNumber();
                continue;
            }
            aCellEle = (TableCoveredTableCellElement)refCell.getOdfElement();
            if (coveredLength >= 1) {
                newCellEle = (TableCoveredTableCellElement)aCellEle.cloneNode(true);
                aRow.appendChild(newCellEle);
                coveredLength -= newCellEle.getTableNumberColumnsRepeatedAttribute().intValue();
            } else {
                TableTableCellElement coveredCell = (TableTableCellElement)refCell.getCoverCell().getOdfElement();
                TableTableCellElement newCellEle2 = (TableTableCellElement)coveredCell.cloneNode(true);
                this.cleanCell(newCellEle2);
                newCellEle2.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                aRow.appendChild(newCellEle2);
                coveredLength = coveredCell.getTableNumberColumnsSpannedAttribute() - refCell.getColumnsRepeatedNumber();
            }
            i += refCell.getColumnsRepeatedNumber();
        }
        if (positionRow == null) {
            this.mTableElement.appendChild(aRow);
        } else {
            this.mTableElement.insertBefore(aRow, positionRow.getOdfElement());
        }
        return this.getRowInstance(aRow, 0);
    }

    void cleanCell(TableTableCellElement newCellEle) {
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "date-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "time-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "boolean-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "string-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "formula");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value-type");
        if (!this.isCellStyleInheritance()) {
            newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
        }
        Node n = newCellEle.getFirstChild();
        while (n != null) {
            Node m = n.getNextSibling();
            if (n instanceof TextPElement || n instanceof TextHElement || n instanceof TextListElement) {
                newCellEle.removeChild(n);
            }
            n = m;
        }
    }

    public TableTableElement getOdfElement() {
        return this.mTableElement;
    }

    public List<OdfTableColumn> insertColumnsBefore(int index, int columnCount) {
        OdfTableRow row;
        ArrayList<OdfTableColumn> list = new ArrayList<OdfTableColumn>();
        int columncount = this.getColumnCount();
        if (index >= columncount) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            OdfTableColumn refColumn;
            int iRowCount = this.getRowCount();
            for (int i = 0; i < iRowCount; ++i) {
                OdfTableRow row2 = this.getRowByIndex(i);
                row2.insertCellByIndex(index, columnCount);
            }
            OdfTableColumn positionCol = refColumn = this.getColumnByIndex(index);
            TableTableColumnElement newColumnEle = (TableTableColumnElement)refColumn.getOdfElement().cloneNode(true);
            newColumnEle.setTableNumberColumnsRepeatedAttribute(new Integer(columnCount));
            this.mTableElement.insertBefore(newColumnEle, positionCol.getOdfElement());
            for (int i = 0; i < columnCount; ++i) {
                list.add(this.getColumnInstance(newColumnEle, i));
            }
            return list;
        }
        int iRowCount = this.getRowCount();
        for (int i = iRowCount - 1; i >= 0; i -= row.getRowsRepeatedNumber()) {
            row = this.getRowByIndex(i);
            OdfTableCell refCell = row.getCellByIndex(index - 1);
            OdfTableCell positionCell = null;
            positionCell = row.getCellByIndex(index);
            row.insertCellBefore(refCell, positionCell, columnCount);
        }
        OdfTableColumn refColumn = this.getColumnByIndex(index - 1);
        OdfTableColumn positionCol = this.getColumnByIndex(index);
        if (refColumn.getOdfElement() == positionCol.getOdfElement()) {
            int i;
            TableTableColumnElement column = refColumn.getOdfElement();
            int repeatedCount = this.getColumnInstance(column, 0).getColumnsRepeatedNumber();
            this.getColumnInstance(column, 0).setColumnsRepeatedNumber(repeatedCount + columnCount);
            TableTableColumnElement columnEle = positionCol.getOdfElement();
            OdfTableColumn startCol = this.getColumnInstance(positionCol.getOdfElement(), 0);
            for (i = repeatedCount + columnCount - 1; i >= columnCount + (index - startCol.getColumnIndex()); --i) {
                this.updateColumnRepository(columnEle, i - columnCount, columnEle, i);
            }
            for (i = 0; i < columnCount; ++i) {
                list.add(this.getColumnInstance(column, refColumn.mnRepeatedIndex + 1 + i));
            }
        } else {
            TableTableColumnElement newColumnEle = (TableTableColumnElement)refColumn.getOdfElement().cloneNode(true);
            newColumnEle.setTableNumberColumnsRepeatedAttribute(new Integer(columnCount));
            this.mTableElement.insertBefore(newColumnEle, positionCol.getOdfElement());
            for (int i = 0; i < columnCount; ++i) {
                list.add(this.getColumnInstance(newColumnEle, i));
            }
        }
        return list;
    }

    public void removeColumnsByIndex(int startIndex, int deleteColCount) {
        if (deleteColCount <= 0) {
            return;
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex of the deleted columns should not be negative");
        }
        int colCount = this.getColumnCount();
        if (startIndex >= colCount) {
            throw new IndexOutOfBoundsException("Start column index is out of bound");
        }
        if (startIndex + deleteColCount >= colCount) {
            deleteColCount = colCount - startIndex;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            OdfTableRow aRow = this.getRowByIndex(i);
            aRow.removeCellByIndex(startIndex, deleteColCount);
        }
        for (int i = 0; i < deleteColCount; ++i) {
            OdfTableColumn firstColumn = this.getColumnByIndex(startIndex);
            int repeatedAttr = firstColumn.getColumnsRepeatedNumber();
            if (repeatedAttr == 1) {
                TableTableColumnElement columnEle = OdfElement.findNextChildNode(TableTableColumnElement.class, firstColumn.getOdfElement());
                this.mTableElement.removeChild(firstColumn.getOdfElement());
                if (i >= deleteColCount - 1) continue;
                firstColumn = this.getColumnInstance(columnEle, 0);
                continue;
            }
            if (repeatedAttr <= firstColumn.mnRepeatedIndex) continue;
            firstColumn.setColumnsRepeatedNumber(repeatedAttr - 1);
            OdfTableColumn startCol = this.getColumnInstance(firstColumn.getOdfElement(), 0);
            this.updateColumnRepository(firstColumn.getOdfElement(), startIndex - startCol.getColumnIndex(), null, 0);
        }
    }

    private void reviseStyleFromTopRowToMediumRow(OdfTableRow oldTopRow) {
        if (this.mIsSpreadsheet) {
            return;
        }
        int length = this.getColumnCount();
        int i = 0;
        while (i < length) {
            OdfTableCell cell = oldTopRow.getCellByIndex(i);
            if (cell.isCoveredElement()) {
                i += cell.getColumnsRepeatedNumber();
                continue;
            }
            OdfStyle styleEle = cell.getCellStyleElementForWrite();
            if (i < length - 1) {
                OdfTable.setLeftBottomBorderStylesProperties(styleEle);
            } else {
                OdfTable.setRightBottomBorderStylesProperties(styleEle);
            }
            i += cell.getColumnsRepeatedNumber();
        }
    }

    private void reviseStyleFromMediumRowToTopRow(OdfTableRow newTopRow) {
        if (this.mIsSpreadsheet) {
            return;
        }
        int length = this.getColumnCount();
        int i = 0;
        while (i < length) {
            OdfTableCell cell = newTopRow.getCellByIndex(i);
            if (cell.isCoveredElement()) {
                i += cell.getColumnsRepeatedNumber();
                continue;
            }
            OdfStyle styleEle = cell.getCellStyleElementForWrite();
            if (i < length - 1) {
                OdfTable.setLeftTopBorderStyleProperties(styleEle);
            } else {
                OdfTable.setRightTopBorderStyleProperties(styleEle);
            }
            i += cell.getColumnsRepeatedNumber();
        }
    }

    public List<OdfTableRow> insertRowsBefore(int index, int rowCount) {
        if (index >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<OdfTableRow> list = new ArrayList<OdfTableRow>();
        if (index == 0) {
            OdfTableRow refRow;
            OdfTableRow positionRow = refRow = this.getRowByIndex(index);
            OdfTableRow newFirstRow = this.insertRowBefore(refRow, positionRow);
            this.reviseStyleFromTopRowToMediumRow(refRow);
            list.add(newFirstRow);
            List<OdfTableRow> rowList = this.insertMultipleRowBefore(refRow, refRow, rowCount - 1);
            for (int i = 0; i < rowList.size(); ++i) {
                list.add(rowList.get(i));
            }
            return list;
        }
        OdfTableRow refRow = this.getRowByIndex(index - 1);
        OdfTableRow positionRow = this.getRowByIndex(index);
        if (refRow.getOdfElement() == positionRow.getOdfElement()) {
            int i;
            TableTableRowElement row = refRow.getOdfElement();
            int repeatedCount = refRow.getRowsRepeatedNumber();
            refRow.setRowsRepeatedNumber(repeatedCount + rowCount);
            TableTableRowElement rowEle = positionRow.getOdfElement();
            OdfTableRow startRow = this.getRowInstance(positionRow.getOdfElement(), 0);
            for (i = repeatedCount + rowCount - 1; i >= rowCount + (index - startRow.getRowIndex()); --i) {
                this.updateRowRepository(rowEle, i - rowCount, rowEle, i);
            }
            for (i = 0; i < rowCount; ++i) {
                list.add(this.getRowInstance(row, refRow.mnRepeatedIndex + 1 + i));
            }
        } else {
            List<OdfTableRow> newRowList = this.insertMultipleRowBefore(refRow, positionRow, rowCount);
            if (index - 1 == 0) {
                this.reviseStyleFromTopRowToMediumRow(newRowList.get(0));
            }
            for (int i = 0; i < newRowList.size(); ++i) {
                list.add(newRowList.get(i));
            }
        }
        return list;
    }

    public List<OdfTableColumn> getColumnList() {
        ArrayList<OdfTableColumn> list = new ArrayList<OdfTableColumn>();
        TableTableColumnElement colEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                TableTableHeaderColumnsElement headers = (TableTableHeaderColumnsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableColumnElement)) continue;
                    colEle = (TableTableColumnElement)m;
                    for (int i = 0; i < this.getColumnInstance(colEle, 0).getColumnsRepeatedNumber(); ++i) {
                        list.add(this.getColumnInstance(colEle, i));
                    }
                }
            }
            if (!(n instanceof TableTableColumnElement)) continue;
            colEle = (TableTableColumnElement)n;
            for (int i = 0; i < this.getColumnInstance(colEle, 0).getColumnsRepeatedNumber(); ++i) {
                list.add(this.getColumnInstance(colEle, i));
            }
        }
        return list;
    }

    public List<OdfTableRow> getRowList() {
        ArrayList<OdfTableRow> list = new ArrayList<OdfTableRow>();
        TableTableRowElement rowEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableRowElement)) continue;
                    rowEle = (TableTableRowElement)m;
                    for (int i = 0; i < rowEle.getTableNumberRowsRepeatedAttribute(); ++i) {
                        list.add(this.getRowInstance(rowEle, i));
                    }
                }
            }
            if (!(n instanceof TableTableRowElement)) continue;
            rowEle = (TableTableRowElement)n;
            for (int i = 0; i < rowEle.getTableNumberRowsRepeatedAttribute(); ++i) {
                list.add(this.getRowInstance(rowEle, i));
            }
        }
        return list;
    }

    public OdfTableColumn getColumnByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index should be nonnegative integer.");
        }
        int lastIndex = this.getColumnCount() - 1;
        if (index > lastIndex) {
            this.appendColumns(index - lastIndex);
        }
        int result = 0;
        OdfTableColumn col = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                col = this.getHeaderColumnByIndex((TableTableHeaderColumnsElement)n, index);
                if (col != null) {
                    return col;
                }
                result += this.getHeaderColumnCount((TableTableHeaderColumnsElement)n);
            }
            if (n instanceof TableTableColumnElement) {
                col = this.getColumnInstance((TableTableColumnElement)n, 0);
                result += col.getColumnsRepeatedNumber();
            }
            if (result <= index || col == null) continue;
            return this.getColumnInstance(col.getOdfElement(), index - (result - col.getColumnsRepeatedNumber()));
        }
        return null;
    }

    private OdfTableRow getHeaderRowByIndex(TableTableHeaderRowsElement headers, int nIndex) {
        int result = 0;
        OdfTableRow row = null;
        for (Node n : new DomNodeList(headers.getChildNodes())) {
            if (n instanceof TableTableRowElement) {
                row = this.getRowInstance((TableTableRowElement)n, 0);
                result += row.getRowsRepeatedNumber();
            }
            if (result <= nIndex || row == null) continue;
            return this.getRowInstance(row.getOdfElement(), nIndex - (result - row.getRowsRepeatedNumber()));
        }
        return null;
    }

    private OdfTableColumn getHeaderColumnByIndex(TableTableHeaderColumnsElement headers, int nIndex) {
        int result = 0;
        OdfTableColumn col = null;
        for (Node n : new DomNodeList(headers.getChildNodes())) {
            if (n instanceof TableTableColumnElement) {
                col = this.getColumnInstance((TableTableColumnElement)n, 0);
                result += col.getColumnsRepeatedNumber();
            }
            if (result <= nIndex) continue;
            return this.getColumnInstance(col.getOdfElement(), nIndex - (result - col.getColumnsRepeatedNumber()));
        }
        return null;
    }

    public OdfTableRow getRowByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index should be nonnegative integer.");
        }
        int lastIndex = this.getRowCount() - 1;
        if (index > lastIndex) {
            this.appendRows(index - lastIndex);
        }
        int result = 0;
        OdfTableRow row = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                row = this.getHeaderRowByIndex((TableTableHeaderRowsElement)n, index);
                if (row != null) {
                    return row;
                }
                result += this.getHeaderRowCount((TableTableHeaderRowsElement)n);
            }
            if (n instanceof TableTableRowElement) {
                row = this.getRowInstance((TableTableRowElement)n, 0);
                result += row.getRowsRepeatedNumber();
            }
            if (result <= index) continue;
            return this.getRowInstance(row.getOdfElement(), index - (result - row.getRowsRepeatedNumber()));
        }
        return null;
    }

    public void removeRowsByIndex(int startIndex, int deleteRowCount) {
        boolean deleted = false;
        if (deleteRowCount <= 0) {
            return;
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex of the deleted rows should not be negative");
        }
        int rowCount = this.getRowCount();
        if (startIndex >= rowCount) {
            throw new IndexOutOfBoundsException("Start index out of bound");
        }
        if (startIndex + deleteRowCount >= rowCount) {
            deleteRowCount = rowCount - startIndex;
        }
        OdfTableRow firstRow = this.getRowByIndex(startIndex);
        for (int i = startIndex; i < startIndex + deleteRowCount; ++i) {
            int repeatedAttr = firstRow.getRowsRepeatedNumber();
            if (repeatedAttr == 1) {
                TableTableRowElement rowEle = OdfElement.findNextChildNode(TableTableRowElement.class, firstRow.getOdfElement());
                firstRow.removeAllCellsRelationship();
                firstRow.getOdfElement().getParentNode().removeChild(firstRow.getOdfElement());
                this.updateRowRepository(firstRow.getOdfElement(), firstRow.mnRepeatedIndex, null, 0);
                if (i < startIndex + deleteRowCount - 1) {
                    firstRow = this.getRowInstance(rowEle, 0);
                }
                deleted = true;
                continue;
            }
            if (repeatedAttr <= firstRow.mnRepeatedIndex) continue;
            firstRow.setRowsRepeatedNumber(repeatedAttr - 1);
            OdfTableRow startRow = this.getRowInstance(firstRow.getOdfElement(), 0);
            this.updateRowRepository(firstRow.getOdfElement(), i - startRow.getRowIndex(), null, 0);
        }
        if (deleted && startIndex == 0) {
            OdfTableRow aRow = this.getRowByIndex(0);
            this.reviseStyleFromMediumRowToTopRow(aRow);
        }
    }

    public void remove() {
        this.mTableElement.getParentNode().removeChild(this.mTableElement);
    }

    private int getHeaderRowCount(TableTableHeaderRowsElement headers) {
        int result = 0;
        if (headers != null) {
            for (Node n : new DomNodeList(headers.getChildNodes())) {
                if (!(n instanceof TableTableRowElement)) continue;
                result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
            }
        }
        return result;
    }

    public int getHeaderRowCount() {
        TableTableHeaderRowsElement headers = OdfElement.findFirstChildNode(TableTableHeaderRowsElement.class, this.mTableElement);
        return this.getHeaderRowCount(headers);
    }

    private int getHeaderColumnCount(TableTableHeaderColumnsElement headers) {
        int result = 0;
        if (headers != null) {
            for (Node n : new DomNodeList(headers.getChildNodes())) {
                if (!(n instanceof TableTableColumnElement)) continue;
                result += this.getColumnInstance((TableTableColumnElement)n, 0).getColumnsRepeatedNumber();
            }
        }
        return result;
    }

    public int getHeaderColumnCount() {
        TableTableHeaderColumnsElement headers = OdfElement.findFirstChildNode(TableTableHeaderColumnsElement.class, this.mTableElement);
        return this.getHeaderColumnCount(headers);
    }

    public String getTableName() {
        return this.mTableElement.getTableNameAttribute();
    }

    public void setTableName(String tableName) {
        List<OdfTable> tableList = this.mDocument.getTableList();
        for (int i = 0; i < tableList.size(); ++i) {
            OdfTable table = tableList.get(i);
            if (!tableName.equals(table.getTableName()) || table == this) continue;
            throw new IllegalArgumentException("The table name is duplicate with one of tables in the current document.");
        }
        this.mTableElement.setTableNameAttribute(tableName);
    }

    public boolean isProtected() {
        if (this.mTableElement.getTableProtectedAttribute() != null) {
            return this.mTableElement.getTableProtectedAttribute();
        }
        return false;
    }

    public void setProtected(boolean isProtected) {
        this.mTableElement.setTableProtectedAttribute(isProtected);
    }

    protected boolean isCellStyleInheritance() {
        return this.mIsCellStyleInheritance;
    }

    protected void setCellStyleInheritance(boolean isEnabled) {
        this.mIsCellStyleInheritance = isEnabled;
    }

    public OdfTableCellRange getCellRangeByPosition(int startCol, int startRow, int endCol, int endRow) {
        this.getCellByPosition(startCol, startRow);
        this.getCellByPosition(endCol, endRow);
        return new OdfTableCellRange(this, startCol, startRow, endCol, endRow);
    }

    public OdfTableCellRange getCellRangeByPosition(String startAddress, String endAddress) {
        return this.getCellRangeByPosition(this.getColIndexFromCellAddress(startAddress), this.getRowIndexFromCellAddress(startAddress), this.getColIndexFromCellAddress(endAddress), this.getRowIndexFromCellAddress(endAddress));
    }

    public OdfTableCellRange getCellRangeByName(String name) {
        try {
            NodeList nameRanges = this.mTableElement.getOwnerDocument().getElementsByTagNameNS(OdfDocumentNamespace.TABLE.getUri(), "named-range");
            for (int i = 0; i < nameRanges.getLength(); ++i) {
                TableNamedRangeElement nameRange = (TableNamedRangeElement)nameRanges.item(i);
                if (!nameRange.getTableNameAttribute().equals(name)) continue;
                String cellRange = nameRange.getTableCellRangeAddressAttribute();
                String[] addresses = cellRange.split(":");
                return this.getCellRangeByPosition(addresses[0], addresses[1]);
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfTable.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public OdfTableCell getCellByPosition(int colIndex, int rowIndex) {
        int lastColumnIndex;
        if (colIndex < 0 || rowIndex < 0) {
            throw new IllegalArgumentException("colIndex and rowIndex should be nonnegative integer.");
        }
        int lastRowIndex = this.getRowCount() - 1;
        if (rowIndex > lastRowIndex) {
            this.appendRows(rowIndex - lastRowIndex, true);
        }
        if (colIndex > (lastColumnIndex = this.getColumnCount() - 1)) {
            this.appendColumns(colIndex - lastColumnIndex, true);
        }
        OdfTableRow row = this.getRowByIndex(rowIndex);
        return row.getCellByIndex(colIndex);
    }

    String[] splitCellAddress(String cellAddress) {
        StringTokenizer stDollar;
        String[] returnArray = new String[3];
        StringTokenizer stDot = new StringTokenizer(cellAddress, ".");
        String cell = "";
        if (stDot.countTokens() >= 2) {
            stDollar = new StringTokenizer(stDot.nextToken(), "$");
            returnArray[0] = stDollar.nextToken();
            cell = stDot.nextToken();
        } else {
            returnArray[0] = this.getTableName();
            cell = stDot.nextToken();
        }
        stDollar = new StringTokenizer(cell, "$");
        if (stDollar.countTokens() >= 2) {
            returnArray[1] = stDollar.nextToken();
            returnArray[2] = stDollar.nextToken();
        } else {
            cell = stDollar.nextToken();
            for (int i = 0; i < cell.length(); ++i) {
                if (Character.isLetter(cell.charAt(i))) continue;
                returnArray[1] = cell.substring(0, i);
                returnArray[2] = cell.substring(i);
                break;
            }
        }
        return returnArray;
    }

    public OdfTableCell getCellByPosition(String address) {
        return this.getCellByPosition(this.getColIndexFromCellAddress(address), this.getRowIndexFromCellAddress(address));
    }

    int getColIndexFromCellAddress(String cellAddress) {
        String[] returnArray = this.splitCellAddress(cellAddress);
        String colNum = returnArray[1];
        int colIndex = 0;
        for (int i = 0; i < colNum.length(); ++i) {
            colIndex = 26 * colIndex;
            colIndex += colNum.charAt(i) - 65 + 1;
        }
        return colIndex - 1;
    }

    int getRowIndexFromCellAddress(String cellAddress) {
        String[] returnArray = this.splitCellAddress(cellAddress);
        return Integer.parseInt(returnArray[2]) - 1;
    }

    String getAbsoluteCellAddress(int colIndex, int rowIndex) {
        int remainder = 0;
        int multiple = colIndex;
        String cellRange = "";
        while (multiple != 0) {
            multiple = colIndex / 26;
            remainder = colIndex % 26;
            char c = multiple == 0 ? (char)(65 + remainder) : (char)(65 + multiple - 1);
            cellRange = cellRange + String.valueOf(c);
            colIndex = remainder;
        }
        cellRange = "$" + cellRange + "$" + (rowIndex + 1);
        return cellRange;
    }

    OdfTableCell getOwnerCellByPosition(List<CellCoverInfo> coverList, int nCol, int nRow) {
        if (!this.isCoveredCellInOwnerTable(coverList, nCol, nRow)) {
            OdfTableCell cell = this.getCellByPosition(nCol, nRow);
            return cell;
        }
        for (int m = 0; m < coverList.size(); ++m) {
            CellCoverInfo info = coverList.get(m);
            if (!(nCol > info.nStartCol && nCol <= info.nEndCol && nRow == info.nStartRow && nRow == info.nEndRow || nCol == info.nStartCol && nCol == info.nEndCol && nRow > info.nStartRow && nRow <= info.nEndRow) && (nCol <= info.nStartCol || nCol > info.nEndCol || nRow <= info.nStartRow || nRow > info.nEndRow)) continue;
            OdfTableCell cell = this.getCellByPosition(info.nStartCol, info.nStartRow);
            return cell;
        }
        return null;
    }

    boolean isCoveredCellInOwnerTable(List<CellCoverInfo> coverList, int nCol, int nRow) {
        for (int m = 0; m < coverList.size(); ++m) {
            CellCoverInfo info = coverList.get(m);
            if (!(nCol > info.nStartCol && nCol <= info.nEndCol && nRow == info.nStartRow && nRow == info.nEndRow || nCol == info.nStartCol && nCol == info.nEndCol && nRow > info.nStartRow && nRow <= info.nEndRow) && (nCol <= info.nStartCol || nCol > info.nEndCol || nRow <= info.nStartRow || nRow > info.nEndRow)) continue;
            return true;
        }
        return false;
    }

    List<CellCoverInfo> getCellCoverInfos(int nStartCol, int nStartRow, int nEndCol, int nEndRow) {
        ArrayList<CellCoverInfo> coverList = new ArrayList<CellCoverInfo>();
        for (int i = nStartCol; i < nEndCol + 1; ++i) {
            for (int j = nStartRow; j < nEndRow + 1; ++j) {
                OdfTableCell cell = this.getCellByPosition(i, j);
                if (cell == null) continue;
                int nColSpan = cell.getColumnSpannedNumber();
                int nRowSpan = cell.getRowSpannedNumber();
                if (nColSpan <= 1 && nRowSpan <= 1) continue;
                coverList.add(new CellCoverInfo(i, j, nColSpan, nRowSpan));
            }
        }
        return coverList;
    }

    void updateColumnRepository(TableTableColumnElement oldElement, int oldRepeatIndex, TableTableColumnElement newElement, int newRepeatIndex) {
        Vector<OdfTableColumn> oldList;
        if (this.mColumnRepository.containsKey(oldElement) && oldRepeatIndex < (oldList = this.mColumnRepository.get(oldElement)).size()) {
            if (oldElement != newElement) {
                OdfTableColumn oldColumn = oldList.get(oldRepeatIndex);
                if (oldColumn != null) {
                    for (int i = oldRepeatIndex + 1; i < oldList.size(); ++i) {
                        OdfTableColumn column = oldList.get(i);
                        if (column == null) continue;
                        column.mnRepeatedIndex = i - 1;
                    }
                    oldList.remove(oldColumn);
                    if (newElement != null) {
                        oldColumn.maColumnElement = newElement;
                        oldColumn.mnRepeatedIndex = newRepeatIndex;
                        int size = newRepeatIndex > 7 ? newRepeatIndex + 1 : 8;
                        Vector<OdfTableColumn> list = new Vector<OdfTableColumn>(size);
                        list.setSize(newRepeatIndex + 1);
                        list.set(newRepeatIndex, oldColumn);
                        this.mColumnRepository.put(newElement, list);
                    } else {
                        oldColumn.maColumnElement = null;
                    }
                }
            } else {
                OdfTableColumn oldColumn = oldList.get(oldRepeatIndex);
                if (oldColumn != null) {
                    oldList.remove(oldColumn);
                    oldList.add(oldRepeatIndex, null);
                    oldColumn.mnRepeatedIndex = newRepeatIndex;
                    if (newRepeatIndex >= oldList.size()) {
                        oldList.setSize(newRepeatIndex + 1);
                    }
                    oldList.set(newRepeatIndex, oldColumn);
                } else {
                    this.getColumnInstance(newElement, newRepeatIndex);
                }
            }
        }
    }

    void updateRowRepository(TableTableRowElement oldElement, int oldRepeatIndex, TableTableRowElement newElement, int newRepeatIndex) {
        Vector<OdfTableRow> oldList;
        if (this.mRowRepository.containsKey(oldElement) && oldRepeatIndex < (oldList = this.mRowRepository.get(oldElement)).size()) {
            if (oldElement != newElement) {
                OdfTableRow oldRow = oldList.get(oldRepeatIndex);
                Vector<OdfTableCell> updateCellList = new Vector<OdfTableCell>();
                if (oldRow != null) {
                    for (int i = oldRepeatIndex + 1; i < oldList.size(); ++i) {
                        OdfTableRow row = oldList.get(i);
                        if (row == null) continue;
                        int colNum = this.getColumnCount();
                        for (int j = 0; j < colNum; ++j) {
                            OdfTableCell cell = row.getCellByIndex(j);
                            updateCellList.add(cell);
                        }
                        row.mnRepeatedIndex = i - 1;
                    }
                    oldList.remove(oldRow);
                    if (newElement != null) {
                        int j;
                        int colNum = this.getColumnCount();
                        OdfTableCell[] oldCells = new OdfTableCell[colNum];
                        for (int j2 = 0; j2 < colNum; ++j2) {
                            oldCells[j2] = oldRow.getCellByIndex(j2);
                        }
                        oldRow.maRowElement = newElement;
                        oldRow.mnRepeatedIndex = newRepeatIndex;
                        int size = newRepeatIndex > 7 ? newRepeatIndex + 1 : 8;
                        Vector<OdfTableRow> list = new Vector<OdfTableRow>(size);
                        list.setSize(newRepeatIndex + 1);
                        list.set(newRepeatIndex, oldRow);
                        this.mRowRepository.put(newElement, list);
                        OdfTableCell[] newCells = new OdfTableCell[colNum];
                        for (j = 0; j < colNum; ++j) {
                            newCells[j] = oldRow.getCellByIndex(j);
                        }
                        for (j = 0; j < colNum; ++j) {
                            this.updateCellRepository(oldCells[j].getOdfElement(), oldCells[j].mnRepeatedColIndex, oldCells[j].mnRepeatedRowIndex, newCells[j].getOdfElement(), newCells[j].mnRepeatedColIndex, newCells[j].mnRepeatedRowIndex);
                        }
                        for (j = 0; j < updateCellList.size(); ++j) {
                            OdfTableCell cell = (OdfTableCell)updateCellList.get(j);
                            if (cell.mnRepeatedRowIndex <= oldRepeatIndex) continue;
                            --cell.mnRepeatedRowIndex;
                        }
                    } else {
                        oldRow.maRowElement = null;
                    }
                }
            } else {
                OdfTableRow oldRow = oldList.get(oldRepeatIndex);
                if (oldRow != null) {
                    oldList.remove(oldRow);
                    oldList.add(oldRepeatIndex, null);
                    oldRow.mnRepeatedIndex = newRepeatIndex;
                    if (newRepeatIndex >= oldList.size()) {
                        oldList.setSize(newRepeatIndex + 1);
                    }
                    oldList.set(newRepeatIndex, oldRow);
                } else {
                    this.getRowInstance(newElement, newRepeatIndex);
                }
            }
        }
    }

    void updateCellRepository(TableTableCellElementBase oldElement, int oldRepeatColIndex, int oldRepeatRowIndex, TableTableCellElementBase newElement, int newRepeatColIndex, int newRepeatRowIndex) {
        if (this.mCellRepository.containsKey(oldElement)) {
            int i;
            OdfTableCell oldCell = null;
            Vector<OdfTableCell> oldList = this.mCellRepository.get(oldElement);
            for (i = 0; i < oldList.size(); ++i) {
                if (oldList.get(i).getOdfElement() != oldElement || oldList.get((int)i).mnRepeatedColIndex != oldRepeatColIndex || oldList.get((int)i).mnRepeatedRowIndex != oldRepeatRowIndex) continue;
                oldCell = oldList.get(i);
                break;
            }
            if (oldElement != newElement) {
                if (oldCell != null) {
                    for (i = 0; i < oldList.size(); ++i) {
                        OdfTableCell cell = oldList.get(i);
                        if (cell == null || cell.getOdfElement() != oldElement || cell.mnRepeatedRowIndex != oldRepeatRowIndex || cell.mnRepeatedColIndex <= oldRepeatColIndex) continue;
                        --cell.mnRepeatedColIndex;
                    }
                    oldList.remove(oldCell);
                    if (oldList.size() == 0) {
                        this.mCellRepository.remove(oldElement);
                    }
                    if (newElement != null) {
                        oldCell.mCellElement = newElement;
                        oldCell.mnRepeatedColIndex = newRepeatColIndex;
                        oldCell.mnRepeatedRowIndex = newRepeatRowIndex;
                        if (this.mCellRepository.containsKey(newElement)) {
                            Vector<OdfTableCell> list = this.mCellRepository.get(newElement);
                            boolean bReplaced = false;
                            for (int i2 = 0; i2 < list.size(); ++i2) {
                                OdfTableCell cell = list.get(i2);
                                if (cell == null || cell.getOdfElement() != newElement || cell.mnRepeatedColIndex != newRepeatColIndex || cell.mnRepeatedRowIndex != newRepeatRowIndex) continue;
                                list.remove(i2);
                                list.add(i2, oldCell);
                                bReplaced = true;
                                break;
                            }
                            if (!bReplaced) {
                                list.add(oldCell);
                            }
                        } else {
                            Vector<OdfTableCell> list = new Vector<OdfTableCell>();
                            list.add(oldCell);
                            this.mCellRepository.put(newElement, list);
                        }
                    } else {
                        oldCell.mCellElement = null;
                        oldCell.mnRepeatedColIndex = 0;
                        oldCell.mnRepeatedRowIndex = 0;
                    }
                }
            } else if (oldCell != null) {
                oldCell.mnRepeatedColIndex = newRepeatColIndex;
                oldCell.mnRepeatedRowIndex = newRepeatRowIndex;
            } else {
                this.getCellInstance(newElement, newRepeatColIndex, newRepeatRowIndex);
            }
        }
    }

    void updateRepositoryWhenCellElementChanged(int startRow, int endRow, int startClm, int endClm, TableTableCellElement newCellEle) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startClm; j < endClm; ++j) {
                OdfTableCell cell = this.getCellByPosition(j, i);
                this.updateCellRepository(cell.getOdfElement(), cell.mnRepeatedColIndex, cell.mnRepeatedRowIndex, newCellEle, cell.mnRepeatedColIndex, cell.mnRepeatedRowIndex);
            }
        }
    }
}

