// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "fxjs/cjs_highlight.h"

const JSConstSpec CJS_Highlight::ConstSpecs[] = {
    {"n", JSConstSpec::String, 0, "none"},
    {"i", JSConstSpec::String, 0, "invert"},
    {"p", JSConstSpec::String, 0, "push"},
    {"o", JSConstSpec::String, 0, "outline"}};

int CJS_Highlight::ObjDefnID = -1;

// static
void CJS_Highlight::DefineJSObjects(CFXJS_Engine* pEngine) {
  ObjDefnID =
      pEngine->DefineObj("highlight", FXJSOBJTYPE_STATIC, nullptr, nullptr);
  DefineConsts(pEngine, ObjDefnID, ConstSpecs);
}

CJS_Highlight::CJS_Highlight(v8::Local<v8::Object> pObject,
                             CJS_Runtime* pRuntime)
    : CJS_Object(pObject, pRuntime) {}

CJS_Highlight::~CJS_Highlight() = default;
