//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 7>, 1100> ibeta_inva_data = { {
      { SC_(0.101913392427377402782440185546875e-4), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(0.6498233713152427462579302903941895526823485861809005407005756658138299437345439685916818979079350952e-4), SC_(0.1598220360006443400909761969445329244603859759388130816641624923434214075962489978723834186220509792e-5), SC_(0.1598250823507423266003361933591577902014719110010440833489018043541995851576985396009647692344594598e-5), SC_(0.6499023539055942142435327607856798948132754954188633069136984730655318067141056849740949064680308213e-4) }, 
      { SC_(0.1127331415773369371891021728515625e-4), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(0.3971461302443922423613753292972913694448775540766244520233346130148330830638824141461619735572445997e-4), SC_(0.3200361118082439458200937030865347915510238320387461167764804252841304593011303390960681217527273982e-5), SC_(0.3200210889570744035937464686925692217326089474042347373846591880760057034684133216576634448402269381e-5), SC_(0.3970804661143976120973144952058224085647966940391220340079248912116191892887943249201895859632245494e-4) }, 
      { SC_(0.113778432933031581342220306396484375e-4), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(0.1078981970343159393325856300516135956140969598440175633458632674725240047510167692675710778553847126e-5), SC_(0.0001200181935703441995121934466228033111754654801609287621930678605774967528649020200620769888673021826), SC_(0.0001199468547533371496891932800417754246696194915133685876058567801242730706768275318621189458708399548), SC_(0.1078921129179782267266584693661729948023960221141040813461658037144034851960955828005953048025067861e-5) }, 
      { SC_(0.1142846667789854109287261962890625e-4), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(0.4025899796795053338948240609285498211472682534957119282666669306536310006800286817936757572860013938e-4), SC_(0.3244356766903463719306913859577321911415693698681174694348315965945146265497858043549761761998515535e-5), SC_(0.3244305116814100828743022380284672509844786339827561909255756253408557410865952781989509881881736442e-5), SC_(0.402567403617356621571805857579531660366440062441234650794612972668478828468673367856838957420528343e-4) }, 
      { SC_(0.1145765054388903081417083740234375e-4), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(0.1191571750545867392537313798907431542344344095879200999308344375910813077398702631095528359741186503e-5), SC_(0.0001102067845592199693917010458194599552572103205410984424051016635846792835186985601306422395955097474), SC_(0.0001101436549179224812644413611401269090813984984476836579744033601646714018004549966518797920528872344), SC_(0.1191500741959144922072835433076419034115688201288730002114876689721036040236828451248448892509304819e-5) }, 
      { SC_(0.1184685606858693063259124755859375e-4), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(0.2340623363191603898370775227750571590200502357875341269550358518828489422976009146847049767670005029e-5), SC_(0.5997016652255219747886060771729383753308007448753449600990778600678820278172428956506474372626790804e-4), SC_(0.5995620164847073584050553181224642561226948778199420970812017399765536897356590939928613936314653308e-4), SC_(0.234051566405018175204269278558069354736428629628287051287220082664267809248151547790462782021755034e-5) }, 
      { SC_(0.12048656572005711495876312255859375e-4), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(0.2739744250951670275113298279765201756581440367980696202896543991551475858455303285016122111531160698e-5), SC_(0.5299670821761171764372900056596763966402488146854288536412386951147420756371449036647596214642744172e-4), SC_(0.5298047274004390572318749610229599999656628731752066034988441477464604972189618031020718116326084136e-4), SC_(0.2739553374006434941292646031005528692950850835558781259804553220755863034131702899478155309841849826e-5) }, 
      { SC_(0.13885271982871927320957183837890625e-4), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(0.1316761416595919370130125478806042690058228402723744932513555575390264383428267099674470556162378215e-5), SC_(0.0001464621138187770636368288091715451405788452187762438244322570896511463096988914144097451646517393708), SC_(0.0001463859922463820577136477421662789627417973019629595681808688398863611174765967906151751169713754156), SC_(0.1316696495791707946163884336944625169957551861831120145642154917636213029136344378330816865851253778e-5) }, 
      { SC_(0.139016165121574886143207550048828125e-4), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(0.9547673292113491262034069793405709241018001446440966950759890317490878173052656894523453165695624926e-4), SC_(0.2023635278368965262888447203152206885757241398427865002786378633252671147811944223712212058587588226e-5), SC_(0.2023754690333906934784743578875515210120065850224750194606142612432969845718622103368626791471648456e-5), SC_(0.9551543863643827044064851822439522331538353359186806068477116827790284692824136317548192394272389844e-4) }, 
      { SC_(0.143944707815535366535186767578125e-4), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(0.3272972153593272792294315950670347359831261283602618957436021027450675786174856995623862264110326696e-5), SC_(0.632990141303189719133353279896837410679405196953125322609425221598638065093292166662050411772898045e-4), SC_(0.6331140087531343209152630672946940443241052431215532098504247271212384333561961538316669124336267509e-4), SC_(0.3273117781877539280798489020583032342225811653678924427425569001005416493844068702682445156689086415e-5) }, 
      { SC_(0.14498580640065483748912811279296875e-4), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(0.3253742212386968781612656316620215840333726254656645874658994387373581238578087455806150295721983642e-4), SC_(0.6460170263304768607166472283634580938080587045554068917515889569677695568527422292732443965595733546e-5), SC_(0.6460389168964756781185792834191710616285016843656138451140030019016010603469220070557969454976470937e-5), SC_(0.3253989653200702274919661149423446286389104607980329666927131807017854240337258963755040377916930538e-4) }, 
      { SC_(0.150073101394809782505035400390625e-4), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(0.3368409504251561290464334473768649337939776230437629072347636411186828106568821467963048055712919614e-4), SC_(0.6687287839256708751603744004615321146312284138895378752133829995735298947731901687375615081162665865e-5), SC_(0.6686631150723913246638218241012310033772813288325333543118501948241656165404065320414326799591238772e-5), SC_(0.3367667217741028633923677261223016046989181571572493614821457869552722619328990219221837086365139157e-4) }, 
      { SC_(0.150358655446325428783893585205078125e-4), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(0.9590303934205324631565257968984418682325537068446175465533121391485224886714546031448674308598768754e-4), SC_(0.2358064976440925144147073399479359701859791978119588953669585750075394212334040246114720302574396224e-5), SC_(0.2357871747378977311589396746549307159106310325274719313965661500873802598080130111071124153255736699e-5), SC_(0.9585294284458174387238014758587531939522744711214339460244053261369492265424734665782500243897903548e-4) }, 
      { SC_(0.150794721776037476956844329833984375e-4), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(0.87651069540304628423081918011260974905033687777361892246598630128014121055416273931319481920790515e-5), SC_(0.259394507865675995744762355153851792156958953609180785329566058577092563181989551106130502682548618e-4), SC_(0.2594355203373817883698461757521940058816181951323031229743551991870650806867128742063568243515966938e-4), SC_(0.8765912509183101407045558460058661316022689816530705908193566381502601877100638232366285667845801709e-5) }, 
      { SC_(0.15419080227729864418506622314453125e-4), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(0.9830005405914737446060892363685712552152782311310204370882529948507189082695976623585226251217629048e-4), SC_(0.2417982090725863219268402865263656889157071672332778168735691070344962656880642022791761256750260214e-5), SC_(0.2418148323498376774634162885245152923095533505622569142619373610219681319883028827406881417407724923e-5), SC_(0.9834315167538787468882315193663229818124191644081977735590761688303094176815343087199599992309813292e-4) }, 
      { SC_(0.15675454051233828067779541015625e-4), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(0.0001076705852659451793853865643565345351084475810373544400849947491064482183831269674483630442891227277), SC_(0.2281884068014367922411896063517274399583263910072808042169062857538812657905414478059107182988935904e-5), SC_(0.2281950317358702456902944257528144442000952715480241963747411206463352849834574570250349766756506247e-5), SC_(0.0001076920590890716618082136667711265533451107466155867551262184847803119057614262957145136457318713641) }, 
      { SC_(0.15964558770065195858478546142578125e-4), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(0.1660278783926417628556777160282997881556780127471291513930816808973189010497802355733599800163014022e-5), SC_(0.0001535552230132099996415866651208432663272262371647920595961863118674016207241551750339476731435767165), SC_(0.0001534708524536018031472228456674893374691254721961681088171006888239037200588582248419618310759235827), SC_(0.1660183881247630944760800805383653749744450292432029092339200275943746932481995662921241116809458963e-5) }, 
      { SC_(0.16304524251609109342098236083984375e-4), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(0.0001119845795811380561590323350505600731783209229321913051109174418673719036122152799154205160023158248), SC_(0.2373436779571213434043230033533137782270002877418358817665203764904913082412060259067142704435236263e-5), SC_(0.237354842387939075315235443146445014249627692147638075678416887622432328868767915597108680961090348e-5), SC_(0.000112020767308378375840566420540839970686221727315573048682688015419168849250873387024663623743467003) }, 
      { SC_(0.16847467122715897858142852783203125e-4), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(0.1597675138409293700309435180784469739232620351573060252420737905448171241490589056171813734376102797e-5), SC_(0.0001777124009802608826555105463099742495952656042301109910545990701930609772354857022376451861750454172), SC_(0.0001776100511814565558783790404856355430494800495259308451582193538709656878082298741615995907450789185), SC_(0.1597587846781442995028519903465322758894812154787584197845211972613431887705001337520744293208672331e-5) }, 
      { SC_(0.1695460741757415235042572021484375e-4), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(0.1763240139192367764350577078574126894495994363862021385705968362952943728559008233251209625751048006e-5), SC_(0.0001630766663055383146731232183002331937355493105587993916536858283999468056902346280484683877950440511), SC_(0.0001629897543666882871856905079787663075585451963966648415370701491698237494062073781966706404486930145), SC_(0.1763142377412093970664774302592003086305568525455565300103669618366872409088556579141664191554965497e-5) }, 
      { SC_(0.1747490387060679495334625244140625e-4), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(0.1657205490431766653288219519839018968888546479296707296937718099328611521158562162673563617224824575e-5), SC_(0.0001843653172192470436245570152447584219034861068531324705290813556424203611303058551178626221584331899), SC_(0.0001841901877263695417504790356833842525593500782750209287429911099919852050415191801904617209210017375), SC_(0.1657056122824094680842979074245439365062200089255551812950422064402396188284924313740737229005812151e-5) }, 
      { SC_(0.17535277947899885475635528564453125e-4), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(0.3934966619007810949666151809439796625761525755030458189033923939964942952549970487522772045241080464e-4), SC_(0.7813004844990431736875950082152823956499576004090834911169966325316944097732757790249052538329811151e-5), SC_(0.7813738690758194900025805668521577972307954518890831563516466130616372853353627433972933369976640684e-5), SC_(0.3935796118240089581784673294734863779612840643384986837483979048055208451716421353815051705178379411e-4) }, 
      { SC_(0.18408363757771439850330352783203125e-4), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(0.413190619940077812148654535015486566874115279053224890650250082320279230593940677934502728871627653e-4), SC_(0.8202915653135443071254499739337398381484679516674675735681744216705620879155339990070901487941605462e-5), SC_(0.8201887319734426941626810875350578124969960624841708092206613535895147568423858458335946233424988906e-5), SC_(0.4130743831720140403888528190085862518549793340166449318755313043679828999244864499097442313882705138e-4) }, 
      { SC_(0.18476972400094382464885711669921875e-4), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(0.4201384439600644251053104632079237506043738636596261931248196434685644946603202793230914544377440928e-5), SC_(0.8126397026386215886651542276709895868768937306492302560360884768759675158597925655827266479096387219e-4), SC_(0.8125517728950502627429002710157205824390468918340600160614661299251014603828182049765221888131113477e-4), SC_(0.4201281061577421820783197564793080303433760475204983907383325171729662408543767121652412074421849459e-5) }, 
      { SC_(0.188413614523597061634063720703125e-4), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(0.1959325355297020363578709735205081489005841465141458833202328073060064509786535570182269488203029507e-5), SC_(0.0001811061752356389460411317471042204459395687458776959286883051694853308747407200099995726838851133313), SC_(0.0001812458202619194327877942786966132129058108017096176196569669856398224327521897110260232626958575267), SC_(0.1959482436961096719711616247435588685682221738468125091166271922921527043291465397235275320504613611e-5) }, 
      { SC_(0.2107691761921159923076629638671875e-4), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(0.1225241239187264825009764211955875258897297868460376024302188076770609420325092603027176276165366766e-4), SC_(0.3626239160751556290434742997831992959708278070633131067367582498349513466852599333852655125852709286e-4), SC_(0.3625564919740186963552562571870020329208486377184784542207294981490052513509927734762356423536143525e-4), SC_(0.1225108806079607767525873313671174611605835214332339844494379813354718156909820965558947094312656822e-4) }, 
      { SC_(0.21139929231139831244945526123046875e-4), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(0.7445424005511995784699762646393679460593641894751343859080360160163445376931758907303607614034943403e-4), SC_(0.6000934337592525703822380903559509073602805598582325653340608660629754049988915105032213733859598783e-5), SC_(0.6001537841428580831714414241213842473868528938690155575792282186554715597199669887229707506961242776e-5), SC_(0.744806181821288710790049603248064178623063301241309429365865781170238013410481498053972392674849107e-4) }, 
      { SC_(0.21881178327021189033985137939453125e-4), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(0.7030064695592503294379321334291782525624628718401090071478175971272319180953875918361989990662058161e-6), SC_(0.000680433408790795796174450941920224760470271545844913613812581829511441286136962923261563149635628371), SC_(0.0006816383524403125738205478920267709440633889813147698488369847423753318880307955631534483215490628142), SC_(0.7030464541940040306826432887696002152287957503165713898530421911671695975497943922636326372406277292e-6) }, 
      { SC_(0.2207652505603618919849395751953125e-4), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(0.7093267489958313617655411076647220580965067745466979468265996308573028236420898916203517281342503761e-6), SC_(0.0006878375209680518415074682718557288529112775750679937081097696644302117276651956603893729795562291429), SC_(0.0006863948246010225459965704062144854706611416602415553417409180733607150209945912939590819393521979177), SC_(0.7092788738597650047938966119408901401195989347345899706435732977553612043838800098859530559731074173e-6) }, 
      { SC_(0.22326681573758833110332489013671875e-4), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(0.7173083054047278961573086105989456570682970371481241164457775058369816945297721060741145426868129402e-6), SC_(0.000693942912935498829956857396157606370348546537206592030234785842678701243868966370280020480908629579), SC_(0.0006958626906144262117730660721150261927949691925324798724148496162036017461337244069162059120354551637), SC_(0.7173720149960007184761691510230992913810701569628749338454018943054075631179732635366688114307259779e-6) }, 
      { SC_(0.2266201772727072238922119140625e-4), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(0.50865640900563811040578585538425896390901308133766743979206080184643715388453320435027818374901322e-4), SC_(0.100982816851671950350693859125516786395303572402498931275714524570431032824868151884602981937137908e-4), SC_(0.1009720881828737167139054728609874889025984215452753747111233254517617475982037996874832643557244677e-4), SC_(0.5085351387632944702222922489915005671565119021049332470711886350858867443549552198328931369600286263e-4) }, 
      { SC_(0.22683978386339731514453887939453125e-4), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(0.1318698522993235404291049581649311906314614556114814299728980295577549538792211300846474409770948808e-4), SC_(0.3902912805113971506908034124486633931077505818656539319867288207104048954027700537346120246873829379e-4), SC_(0.3901822777290196984540792824500864923391559344906525230824706219396840273731015767295336174622369535e-4), SC_(0.1318484421051440417652129082851166337019965927998853709373406736412774414767937780490448907437483983e-4) }, 
      { SC_(0.2445176141918636858463287353515625e-4), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(0.5487859761900163762747084954799354210970641626017168407423497130042367756159359831502293499715552889e-4), SC_(0.1089542841273619103064479063049959787373964868348367609609252724695374466948878798013731510350866089e-4), SC_(0.1089501056795943250183776310536020170617764643484404075100156842743952907871713450931294774048917483e-4), SC_(0.5487387455313365105754924255934212400210288970603333727898204258073046691126084533527289281872830199e-4) }, 
      { SC_(0.252623358392156660556793212890625e-4), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(0.890129539343139967770160829095525943431784560670903983988785893010373488584644839837999734342948626e-4), SC_(0.7172059244091053201641934321224384940524070013532715204498324971811784071177762372289850469033361202e-5), SC_(0.717096341597920476321952821665978658486721279791323341028718652168102543160707702181951932136016795e-5), SC_(0.8896505796200621207023800930996934030424231938562897164028075477168542604684248744947650839939295238e-4) }, 
      { SC_(0.2568908166722394526004791259765625e-4), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(0.1493364228388761198868103012960216555521615069861854737692576411310621220937107845563958724742660352e-4), SC_(0.4419798758475023895735327751029698993886725670829036247837566511740367723006654535311087459305674045e-4), SC_(0.4418883964019194746511307212518646335035336565066635120057467883721722783530905753943472455339078922e-4), SC_(0.1493184545575728327293696761495400907010949868209154322194432086740408313397146743587930213474998263e-4) }, 
      { SC_(0.25949540940928272902965545654296875e-4), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(0.833752129308913926227065544146472406845103025298662684741757761591813072116316576684643502642406044e-6), SC_(0.0008080250712021588935636843618319216044074095370053430973447179539460888207197002140901276022886585513), SC_(0.0008072949866892362932227363258057324556110382324536584101469886216632396834785904508146734547370060029), SC_(0.833727900965832946366484503837774254714218421719028188929655567250670707436590493621241534283024996e-6) }, 
      { SC_(0.26349245672463439404964447021484375e-4), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(0.8466364767577101705041656379088328606682929696866996601715835907306009565163155963462777057378905459e-6), SC_(0.0008217383524891267147808657074642932639197756413278569617986441351832045839603697277804736879108315389), SC_(0.0008184703196926953221005729965523654463331457080779535722544658946622169287552131982983948790528471138), SC_(0.8465280074754858290845898675590495744821154291966347987500355737935889373616630579984128037962466383e-6) }, 
      { SC_(0.26870451620197854936122894287109375e-4), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(0.946444437644988818360272225751452306731640867117198717108507112191260513239046196095147736177089237e-4), SC_(0.7627812991634620294186676464363520233213603165895065321455626630421668048906382510818894684760093289e-5), SC_(0.7628238439007674063911316116300647303303176263313870094159838298732190696487000119447497438474351243e-5), SC_(0.9466303923140021714651724961108734016144139388324405538990070951992333616851896005363205762698802398e-4) }, 
      { SC_(0.268835065071471035480499267578125e-4), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(0.6113126863084787088457289906677467525110413791126532917750847089596573236804881284314940784568267815e-5), SC_(0.0001182559460698695797615048524864881859086198382920373342279857707435297713084980688408862368180844266), SC_(0.0001182051288172654974681882853882553301020971099172184006009819870759444049010912388143765810139804489), SC_(0.611252939053999760410806233135421286813983853577987950163594035763865307512923742836430598340441027e-5) }, 
      { SC_(0.27549775040824897587299346923828125e-4), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(0.0001893477408462106294074320900879226643871100023263037205115561730071509287610465638454357259233806003), SC_(0.4010791593533113309540302576424019167831640085268531054136632049359520852067803490958844908594391502e-5), SC_(0.4010195283491295339725313715084880993354774040867618843125923143774535327392436368308238190903145143e-5), SC_(0.0001891544725074944424934700773756200530891694008868235303248952972684288879040485141271922803862316192) }, 
      { SC_(0.2782344745355658233165740966796875e-4), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(0.98053175703819812994193648878362808684947290826447901513656769674336146899659396475525238726123611e-4), SC_(0.7899533755723317263058249404429585550531174064514826439436441347323297475962535766753879739769746682e-5), SC_(0.7897593757080017755148521385522924454636109738418695853971781157240078463021397410573821447747174936e-5), SC_(0.979683851737169718145826887102536930473526412140028532457741846483698224058281048838499990647368631e-4) }, 
      { SC_(0.2831956589943729341030120849609375e-4), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(0.0001807128500355753823381133911614513397534840719181196084363916797803173052691704569877960788396163323), SC_(0.4441657295761922140709867864006973368144886662570011429990927992326346788917481974041065341380935819e-5), SC_(0.4440656907905668223658768612069517333940390373243725058541634264484103674545691183646054275030648641e-5), SC_(0.0001804535176381618451843623788688497791433307522718198166903942132411527589674277518970122267289256125) }, 
      { SC_(0.289903473458252847194671630859375e-4), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(0.650710902067645306618348399485928752245514343944149274028194357417698907571013640606897690082437555e-4), SC_(0.1291832509929521729426377124614008429150947783437357616360744470823580078268035876092794947896497597e-4), SC_(0.1291672155153579622239022298497872348714061205196344194670340570703157417994651341126623468331848716e-4), SC_(0.6505296484263600260907975069090657647606675561221350847213411703515172191255206365674021677710829295e-4) }, 
      { SC_(0.29415024982881732285022735595703125e-4), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(0.5811234358198207450800993806631629303151425540852365644833470783451420157162290440018808753064778315e-5), SC_(0.0001488515305143899950575182712108765017570657330109018309339874773058195626187976323166915667047399717), SC_(0.0001489183753033729737471989110271469662848635755669504770040196845749576660108435797824519056477438717), SC_(0.5811749907096483210796389689348071701020036672332340561130020297426582622523885984046973793047679976e-5) }, 
      { SC_(0.2950275666080415248870849609375e-4), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(0.6623380221993247208019930424359414104038041590174729151384976635979790064065189777992871055265768185e-4), SC_(0.1314777037925794991119440542155738750204789395056345497336780326607275948595820297888322249112418291e-4), SC_(0.1314391553059617847412366001667108115797097450131451279379209510158565672886336310889986494966211983e-4), SC_(0.6619023049276094907128763980117686503596195890106753564355597736850868648837710801405105630844399857e-4) }, 
      { SC_(0.29590575650217942893505096435546875e-4), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(0.000203433014962122273190117813844365382505235828088797038561115557192062945317567248313629806578074863), SC_(0.4308080188976407900504114028660949748526650492436900018353486862351388736677364723641302637450417894e-5), SC_(0.4307076203395804963859360587104100187464861275392444319438609185919933707893530485586328696483245651e-5), SC_(0.0002031076322396604361969952554446488452402616888932689720993389015651322519170841426077553570975254419) }, 
      { SC_(0.29623561204061843454837799072265625e-4), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(0.3080924810706610237303050764635513096315325110851638504448014890019899956575033934196425233873095061e-5), SC_(0.0002850589955900025063662373612966783648213492266552838366800756691443373132161923271226636935957075431), SC_(0.0002846535881404838325986316558252667640434634797586114936540384908075569789055572942470704240780535328), SC_(0.3080468737319158755478716926130947075850078633467816863260277712535040345554296060678813950289927686e-5) }, 
      { SC_(0.3014650792465545237064361572265625e-4), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(0.9685611726034269567302767529566149272145550805472501402599516109565485288465686062001242921930814387e-6), SC_(0.000937553743647252344751891476657878098874788940315540755218482499127875990240046305873996286690214713), SC_(0.000939021816075265396636351157789778172035065393856256251574313535812872416891792259964934026111812558), SC_(0.9686098967137168600733425921678272637744767838900345931868288957453818204178845809255527684269389091e-6) }, 
      { SC_(0.3187526090187020599842071533203125e-4), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(0.1852696291685857457357315073207801440150982002201243768613274683982839926415680781181146885454979429e-4), SC_(0.5482680736076816768644663735168155194164600649527740485369223211776381933868044311399057957132246327e-4), SC_(0.548444241099086254738727348125985462130210044548636558491683436862552850783112176034983573950013397e-4), SC_(0.1853042320196973023008985160999208906513544085138395157496265838499190413528186023072183021354900623e-4) }, 
      { SC_(0.3188882328686304390430450439453125e-4), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(0.0002032543119596310553301405896679188132371701036431649527792241326790458271535289572477009291010567545), SC_(0.5000556678783997586305969641311482681169415216588265705980879093771896850334429547871013232540968869e-5), SC_(0.5001240213775232009499979525200205307308059663908028388320060836233035467217520960441062604146380964e-5), SC_(0.0002034315108953792758199239927083176955139118886499167457345368674516649642357124368884446145567680131) }, 
      { SC_(0.3529437162796966731548309326171875e-4), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(0.334668711481158310382864201238683999994953377693331472938495759388412406610894241884420799258679869e-5), SC_(0.0003718970079902761887180725266360519825237957106395637147904598652623756928502161132295004140302751295), SC_(0.0003724813343406066281170074014632226846885464741007649673452943231635509240584081956245248920742359135), SC_(0.334718555724405687468912312104506431322335724292228609704844847258008023222884926403088256226383157e-5) }, 
      { SC_(0.35590535844676196575164794921875e-4), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(0.8092364962626058971387777329974662793053155436195848130253390912228680487935829174541370681674672125e-5), SC_(0.0001564987306006350784741513611655931936391912560503291049953158992556549020303192697545696767780765783), SC_(0.0001565473400589923693543561401818386522298147177528987738128200768688989870191855013563440286317941196), SC_(0.8092936488646478221364595555409371457863964521249801481414381940135542555331922472631230919745223317e-5) }, 
      { SC_(0.358525212504900991916656494140625e-4), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(0.20844687451011136590747269054423102083114891865263584657577277623085775675276755464105169383266907e-4), SC_(0.6169845664756046759927677029260077598071799780328103734399992932114360141403149043363080644356838019e-4), SC_(0.6165709894511585698607333035031442599608339199757038280797489741936111162974087867686443533519286434e-4), SC_(0.2083656384622360415458051818461176884861844674516877112104729632163184264135688462654172771648842154e-4) }, 
      { SC_(0.3621911673690192401409149169921875e-4), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(0.715622830600402150373801155429084679312407478590444136027797946939538146649192881666443014702067829e-5), SC_(0.0001833836608381929002731263343690525082454731194682745651174395469830606430319153490173548780974203125), SC_(0.0001832644580959573118212493644025548596560770613361506362466167965423031598406626388253128495476174846), SC_(0.7155308913027607351885321925087420985680518149787182589803723400692611262818513974318565901900727854e-5) }, 
      { SC_(0.36229626857675611972808837890625e-4), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(0.0002489151071991312712219251562514838839987259822003081868789158856983302453776349412123024639467727405), SC_(0.5274161096362967097326890546094366203480554714964319857191218842470470923111278417311844369621734532e-5), SC_(0.5273923601134485382851466488835177827650248090313816544211293271055630918290066617193324424300311702e-5), SC_(0.0002488381337460890571114905006647637555498796404045683444483908547908880765605159396511223663522629821) }, 
      { SC_(0.3654422107501886785030364990234375e-4), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(0.1174239681209257287903920255058201768804754319692017274326367931233417179784426636316869634794923097e-5), SC_(0.001140439679545291180618400221953373680576307934412533253755008614576608998821398722776810171535312422), SC_(0.001134401351729823387627861697009741352117442576992655262878010344835588520111906552528854537112533879), SC_(0.1174039209987353664190953016304935836539205948195298965182057260723599992344448666978200620691381635e-5) }, 
      { SC_(0.3714940612553618848323822021484375e-4), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(0.3522925453120839810093317941666700181633091016452330925807149268651434472562206172652295885998710933e-5), SC_(0.0003918418922406417897504701554630934618695689303793030188219220359405019011050127873083974565982121899), SC_(0.0003916596403163398934069914479888173986109507791942366164935543168232942911715300723537070442620914786), SC_(0.3522769993663235962958405153699762345807639266950251933898917713941945409878978322196047753869038853e-5) }, 
      { SC_(0.372543800040148198604583740234375e-4), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(0.3874348794125427934772825022304143860206054078629718646935921526088911760939142118698632307471465003e-5), SC_(0.0003583098752942973148036806697776396483126888718748938412705267378337452735106320846391130650311862246), SC_(0.0003581561962695791365037188216195937964009669686703897765083661711096644994928229459553268406092436155), SC_(0.3874175908733848840336201417178945974351929284870057469034209089839110570591777145169367075736679818e-5) }, 
      { SC_(0.3779314647545106709003448486328125e-4), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(0.0001331814976678436654315347384146145169027135888339945489605187547650885953609588005186881963743583815), SC_(0.1072995571637988332297425260561994721515753211016623173930219749676165305564069151925957055995059916e-4), SC_(0.1072759923695647185855014006442149912677035770900783728316650087451105820084200967451616929488861594e-4), SC_(0.0001330785052706702311447141588373059982898486155111689403266268581808696014081646724245733321436670056) }, 
      { SC_(0.382418438675813376903533935546875e-4), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(0.0002628276285484336299767013896941186356245223424130048721776353272058491867610893187302408299177512699), SC_(0.5567361590127487474932271033846264844294059512941866064088445041626864563042198637591038957910390724e-5), SC_(0.55665706258129317646086374799782008520134092008783646068466435927055796775859302823300926652942055e-5), SC_(0.0002625712812124782972678637920348277642027760054079639608401196824514763270858124553995823530924423339) }, 
      { SC_(0.3837459371425211429595947265625e-4), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(0.7582821625080839612032035561287500592755963594537405304261867929302571182223530377386706394107043065e-5), SC_(0.0001943894768805810373890328598053098725189834332536906136424622971583813284699138233692895305099148783), SC_(0.0001940788951957159217794850251007846481121299165415322058706255653243368855273269685275979381935745513), SC_(0.7580425998843848344523147683764117545646587007761683271864219795833308857745130614327296913554518139e-5) }, 
      { SC_(0.3903355900547467172145843505859375e-4), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(0.000248811931171924303097074017331930977549130825328788022482046111128107018654852163552969456069016622), SC_(0.6121008731467766961429008675021842895888539700632916094143356754714032848915534116696402295943139619e-5), SC_(0.6121704815976624053481575816584612839235163672228226981702230997690571251845496040850101081585313373e-5), SC_(0.0002489923798000819614324329933836323584074829840881254928639020411384369090983914610564545664409647762) }, 
      { SC_(0.396258910768665373325347900390625e-4), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(0.0002527886180749468975582478667275317600302641706876646403779468959986541078158293168556945861713046048), SC_(0.6214669927782665295845879816904181335852056684086615330592635916594100096400724146075050934581868741e-5), SC_(0.6213826126408925807709955132330719813542783931604436464504958272859630765161845122786755951013444245e-5), SC_(0.0002525698780871932443318924570278475720100008300455106048693807822908205527222693339298576711402123677) }, 
      { SC_(0.3972529884777031838893890380859375e-4), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(0.0001399734135959657615749670077862426786855345719909520953277153663994036852338398254828833226403499639), SC_(0.1127813171528823904108889200139561720442919728927588747467277880831437403844220118129640503198497491e-4), SC_(0.1127642798650091529565029198654553173942054605343197564548530621152924749008604305706271535179151935e-4), SC_(0.0001398989497682749051561538735112771911833212861396007509166681535491430781425727648086943252253069286) }, 
      { SC_(0.401874640374444425106048583984375e-4), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(0.3811520771244874434986685877854805178161514255151044751275863363812852789337826626040889945992589875e-5), SC_(0.000424464853159359672539108439099911590515843300316876142689042035475253353157934305272873908214964275), SC_(0.0004231135275376316309018438119765103852103412484110428194820240772674319081893265078741003012078556596), SC_(0.3810367894043645634993544966559904047601701926961464406225481857505256617255346190679210030265796775e-5) }, 
      { SC_(0.40309605537913739681243896484375e-4), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(0.0002770338459887154821043027547341379068999133461002177518815253645060877019962868142763117977149232309), SC_(0.5868376952807819771631206037721353995509092393513798572156480504862962038434052997853297705588290919e-5), SC_(0.586757430488588465904540907119938033358110828141204588838241634334497602785075785202586455790973593e-5), SC_(0.0002767737138005214244224369805903843640978933915774662720268648642971326604828716791953880506979829728) }, 
      { SC_(0.40550003177486360073089599609375e-4), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(0.9221383541185385527071505347711305334073609188547831431795810381611541876815897604170816444571643867e-5), SC_(0.0001784225744705667366572404048423593518640987024181764506653385753338845891606617219747420953620206093), SC_(0.0001782459059669590640973236656968130937068139343259696285197210796573183830249220207787643743703212391), SC_(0.9219306272056024770526250341522686774968400708814518488076151893227605440341301349083913982056866625e-5) }, 
      { SC_(0.4062067091581411659717559814453125e-4), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(0.2361586416612142765167657724232481876044448984711401910548666563310675470204152396834488262662831502e-4), SC_(0.6989870191822309501590244914585875365637039298281482236837247945120091995705186808922997281219795252e-4), SC_(0.6986232500712854377771990268662503700276363018605166064224390664819853908331923783597492759107980643e-4), SC_(0.2360871892386272804023742756735058475086480569354863641324236235878508678528295765944955761546011429e-4) }, 
      { SC_(0.416882903664372861385345458984375e-4), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(0.8235974455593445911405146006618804503537150786217471538037669794419437999849551793474063150862847525e-5), SC_(0.0002109633201853242788013013609367533099276023085052167873112257616448341623333035838175300692246854712), SC_(0.0002110495102733607506178648141757545694755033480799157366436290302466839560536228597944544471132132855), SC_(0.8236639232670506078779882271770848971094258901739735798432350780407629819534105862391760471150363673e-5) }, 
      { SC_(0.417589981225319206714630126953125e-4), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(0.9496921942868397774928083117809299049060198868240026509483639861642207692921348127015378609059052339e-5), SC_(0.000183793622849589591519464130760858388758822503117413262759668701527523735632668428880691387562338024), SC_(0.0001835090487283306025864238304854438353083438156425424352176445044026575411241058657571863006146399162), SC_(0.94935757863258569721736626750633000330132939437093285670733958895041788449395900847669303252036035e-5) }, 
      { SC_(0.418079944211058318614959716796875e-4), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(0.8260930887237697635703629251530276995383458924199043185217112489290530777891870979959804140737674819e-5), SC_(0.0002117386770922218938778977059549827654528037792577460458245869628782455014551249883070447676100452006), SC_(0.0002114860793186596913251503690363209350311538278300630340515448836543526571792432670516647491861023175), SC_(0.825898255062919023497137926133831328068152276718729520089188760652213380239712521146579798917277992e-5) }, 
      { SC_(0.41891194996424019336700439453125e-4), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(0.0002672580772464280834387835177261683554333391003925167941187361298047257964312323483449979045327579778), SC_(0.6570015874911677852991147155769095087831099396134650142218317812857351099001103797395426482146189012e-5), SC_(0.6568983357998512282989153671221192972190527205900471274006054677239799624693055695014758295207730505e-5), SC_(0.0002669904202815672441007644560925001252685662217767570596816678913107167904651157165957011100207069448) }, 
      { SC_(0.419171410612761974334716796875e-4), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(0.0002673344539664826544830023949265944543834585415163680058638252998427230552458372819721645229817547963), SC_(0.6573741447549158401827307949597513428673980315769496227763967641364506755866433294118600662890872146e-5), SC_(0.6573395601852054412524224246058366885108447332157582172173745576427461079033680978983409154677512139e-5), SC_(0.0002672447991051494561443093974867643439852284495652962537701368637858193673100862193199529829148406933) }, 
      { SC_(0.419242351199500262737274169921875e-4), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(0.4359648990857360968457850959275638726930411180413406439514126709572761377802994022841270206481115263e-5), SC_(0.0004029119932621287786817915438890523411401294701723266867346196525797978337120966313606922986132096147), SC_(0.000403363695063904962190884042747369349698072714192785428011538900039117579063948836349719913467349434), SC_(0.4360157171227938769130953482480864809714506340287621610381940912250592595386969752850955249856049252e-5) }, 
      { SC_(0.42011219193227589130401611328125e-4), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(0.398365875389748086067594984574926103122424092163820681261821293888386818704532410505625329319693876e-5), SC_(0.0004427496097812887629342565494196398042609936726978499756025798858999363342404635333463243921447617748), SC_(0.0004432905604739046992982032529045909208954888136842027099726537655216774312378322522875616264388831833), SC_(0.3984120207345006607471835039298619515401643465507314101897690767888569205126449848553576877622352788e-5) }, 
      { SC_(0.42301238863728940486907958984375e-4), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(0.1359312285631717405765719764754432879298433141872203473491768204084252166481082667074835409202659733e-5), SC_(0.001322770284214019311266028223026786426814204964907018865994860472202591169776984008490446332498675915), SC_(0.001310486155027356254175059061847320924004706627649203113102286794081523390268033220762090836305952094), SC_(0.1358904290590029756357039625534474695327782626001325911953513390786900374680684792030214741988228517e-5) }, 
      { SC_(0.4258894841768778860569000244140625e-4), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(0.0002923727175992187097072324063572122281873818920445524545523996736343568483402998666015737243354548483), SC_(0.6199202728657121287860294157207493768526502246677205153768156458033776349926581840189623125411836906e-5), SC_(0.6200368486309552990494441974479535977590161622302554029804318767901992518975120433440979854133094438e-5), SC_(0.0002927505205138241042939799378270048006362426290581269656849944911883353888399107582462319808565045767) }, 
      { SC_(0.4287613046471960842609405517578125e-4), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(0.0002736005609371116740934446346383807883994554019329649154401293129654193696486224835917280006180529407), SC_(0.6724714946598353108604209750095634498110311557378527040647332006303207748387537139582107125767957104e-5), SC_(0.6723205274650179116383367890937312914547011559695121606852824371478288731715983720819865058745831178e-5), SC_(0.0002732092231257790268174597230550865313435228841157994369594310251112640003102040123737900571003825121) }, 
      { SC_(0.429383144364692270755767822265625e-4), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(0.0002951871426825850774652811213602975227694883238053606607213237100556477926747288032321448398104395386), SC_(0.625133964407058758729958389915785470264601714850173720559120297173978857798896409142158760570980548e-5), SC_(0.6249947873920316731049296847404811990146085607625249042021344063918397615033829998096559220177231572e-5), SC_(0.0002947360999508463607421314785967943325312487891553412005078791654256464696187216773838770425023682609) }, 
      { SC_(0.43400345020927488803863525390625e-4), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(0.9737546356411772858815761148723142658680196764939313624916403283726718956034998433777427720684088909e-4), SC_(0.193359945263856182080740899210274730978708676013881994787139874064917121012631036802046294189002552e-4), SC_(0.193406703850189794318864764252352038963320280879465640007318762448784007139045861846700412258005705e-4), SC_(0.9742831485160613946649925070301100139166116428196682180981417827542011842497424047528003841433063084e-4) }, 
      { SC_(0.4396517397253774106502532958984375e-4), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(0.2555737297050327732879912199536217424843662361167263445470896038691825802662053742369044239689368231e-4), SC_(0.7563902759524491048297961944420370219641549207869752324504714818651299615778215644771520442760890863e-4), SC_(0.7562921356848258359363085061105523944725186738456345342531210308663029772315087657568196416885188712e-4), SC_(0.2555544528720085703045622323101251616812775750121709056348015611755392314027485821695442452317734633e-4) }, 
      { SC_(0.44897155021317303180694580078125e-4), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(0.1020972164335333093746384534509558451020030799598262889432301185755970533162847347689491637965180734e-4), SC_(0.0001975300770535911466529686335618625592438273286161183846295716778620471956468554791941990798125217633), SC_(0.0001973749051272532073018902945796867844222243547901783596417609313463205064511125533649345645266318893), SC_(0.1020789713165616732718992958541079899941190516864817046164224698442083512222849997375228089428791878e-4) }, 
      { SC_(0.451372252427972853183746337890625e-4), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(0.4693848308540837540357349901497797420301751198644436746938134174928936841206590257174281422703954793e-5), SC_(0.0004338653679695448440896845237135758059105578769286399783940175945138625973774304866543838516733037706), SC_(0.0004342014985530507699185936466877065273956190624499587475124769477851387595961452019798943887272603883), SC_(0.4694226470129197592867180943433770922115432774065666425419309493058538316907827520358207133084764014e-5) }, 
      { SC_(0.4623167842510156333446502685546875e-4), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(0.0001627899373883332953355500854947409232699196618945185574711176530257777285625146763875059731569504793), SC_(0.1312281999627725384291635817883158631609386454912993763857337497501910339283135844005364200287657758e-4), SC_(0.1312582226588685124077599211471582581035896269949814728916430732314139908585264498329781814332734407e-4), SC_(0.0001629211525080439210776925228530380753762870192936540093105038735844335096768297115431784405849873145) }, 
      { SC_(0.4653503492590971291065216064453125e-4), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.9192885264228692528465342139170784257762724654002939835989391759980294565623066824745139187674729396e-5), SC_(0.0002354104089749605681705801204811526139134785494863533470838002640668959054962174997071624475842675403), SC_(0.0002356664156279290969419471474527824867290800163849996007105809082959941701716734747162651567320649712), SC_(0.9194859907026727166515089596177643447034146067523739091582921061059466010917643198373011475987596635e-5) }, 
      { SC_(0.4662941864808090031147003173828125e-4), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(0.271034859748330543299467141564696764378543528840279951724699212188796829622195181695578843911900881e-4), SC_(0.8020924684247691731227513113946002872217415179106548564667689430284057541288956845889122239961699278e-4), SC_(0.802256963797925266614736917954635868298332104936897130348048794925366385611901713215031757611023427e-4), SC_(0.2710671702275360513593076051930826356567260133305662402772955988837599610528011150701838448746380766e-4) }, 
      { SC_(0.4683499355451203882694244384765625e-4), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(0.487146237178181554587212318661557004310316434724941427126803753825404519744302961138507113960848931e-5), SC_(0.0004511298431015401501407905847806664230291628895163866444771853374329232554732691810202978585921411905), SC_(0.0004495910311651689894990419519375488400419183539690480123228780111507198923313479242801392051140887671), SC_(0.4869730843881540701560223661763496130541171657655986546097443364920920251647023825442028115831946582e-5) }, 
      { SC_(0.4735972834168933331966400146484375e-4), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(0.9357094110799297748771688080382237087202097609464772747832427503425533013240054223119232783858773965e-5), SC_(0.0002397498705632709927028532294121414748395724944152825583367397352330504008406143634655995705518023924), SC_(0.0002396752202649676178365562364264534722136969233368876455476423270300955325997706360352920886660356934), SC_(0.9356518329645430340521248874374301586136299014971171767385032033893097877182413517605198241863413943e-5) }, 
      { SC_(0.4800888200406916439533233642578125e-4), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(0.9486293130537240293019020990621570498546971830110215017603530746847008151087663087602744968641911984e-5), SC_(0.0002431583845362453627527339890165639825140333193024518463820418379276158828997663021780855524279614603), SC_(0.0002428383555565714915545939765478691678392247069249386713079219050858849481864346186662746684342535718), SC_(0.9483824625236211925039267431161740626202193066263335434740075413999272809047544426116841360498061596e-5) }, 
      { SC_(0.4828667806577868759632110595703125e-4), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(0.2806574743222954132692682948032431902916971557228481355445937737870222764933937963932332368864520776e-4), SC_(0.8305474948680240934749188506853071213155279523592107112818885644872291519023106636393336077778390691e-4), SC_(0.8308222617362700688054535492436845961930767088568431874460505082794737249151473830543884795109330118e-4), SC_(0.2807114447101831607879970994154196465985869465619816841131624307095052578717030752083948428691192546e-4) }, 
      { SC_(0.4830027683055959641933441162109375e-4), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(0.9541606813047840442386154654480050301917809479205896274649634260045011059989644096542563158358241456e-5), SC_(0.0002443406625539862643165418508972938379047444759964632387390065316381275198772264868932789036573019498), SC_(0.0002446058045955930792445903662596014924392399923709357820226968750494269073125819334257497827728686596), SC_(0.9543651929233396774255803162705789260662646472671800879229219567832483104947522194069221731873039283e-5) }, 
      { SC_(0.483796975458972156047821044921875e-4), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(0.4587610627160134673476089995180841208777933356042412034760809468037086810281697868860875410177485989e-5), SC_(0.0005099470789756504524604856061457235313033840493468601377519196502979957645801215886101587165995191203), SC_(0.0005104076095482251201628617394868616311256684589507692973500722820572287960069422146802337226757725803), SC_(0.4588003491540980437457431498384093462658418210894358752813412226854877690969371199712147077613066467e-5) }, 
      { SC_(0.4859554246650077402591705322265625e-4), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.4607821279273959895046143379227484904987323903508556657828606638307356792555904036795875761144821787e-5), SC_(0.0005119216205287973639328373668888416096098353069010860370773884735558239108652431977747054675315365616), SC_(0.0005129864379865652688517267803149382041179674252981043977864395124559011058027548607784836105038463601), SC_(0.4608729690976125089654047731079353927065796663554935514797505616986321603978405052105329247774635191e-5) }, 
      { SC_(0.487077995785512030124664306640625e-4), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.1564800697584426815889336398833279554271786403834427280748428627664099827845350155595858798448336407e-5), SC_(0.001511618060874094676960606990973025037564770007652950940578185834881132178603846066474040849464360098), SC_(0.001520396002249337567401185168074406124040865261851098914524089987356935403515312951217039207102123766), SC_(0.1565092194945395167906877010179066620340027044377575627760468958690500225107340155880367933529184078e-5) }, 
      { SC_(0.4875471131526865065097808837890625e-4), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(0.1108467034810653491650022834099504629119757833141758920296277811061084492033840475146003803723111001e-4), SC_(0.0002143088826447072971447015931534088261266859553865288017122812245598555158399761917317260583501600844), SC_(0.0002145263203253872943867436322372944465858778993298042014414382771934095078533188597877313463025901607), SC_(0.1108722703345267143350600649172118161272250738408366900524888449219541160436653530228597715656989435e-4) }, 
      { SC_(0.4882370922132395207881927490234375e-4), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(0.0001719383946546632111589085728103270761793274136639261241960607158471653216039992757975343817498004006), SC_(0.1385905685644647646552262297584915430316629538689963730897527540588429868660592160287599814392828758e-4), SC_(0.1386124475492540011909882340716498124557758390876994284228229423599337940419504280672822537816881797e-4), SC_(0.0001720340179417960170520997341581410822757311438214274982081583217226077338521427107594557960830168111) }, 
      { SC_(0.4924438326270319521427154541015625e-4), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(0.0001104952270407104526648801587554743584632436031943432616807561720496495624058899633068121820708094879), SC_(0.2194035303442761925592178434884285706029285061371932948107504802178282546192507936902772697479266338e-4), SC_(0.2194428656113691584206458946463702504805339345470808593205753824217365193321376920319874413718815067e-4), SC_(0.0001105396876592719756512357904848541487562173170351406835695798370357038929647139215689734591967975841) }, 
      { SC_(0.4971525049768388271331787109375e-4), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(0.1130308024185962490776683440169859084423218493300793812294337780489160390788583060465049589726167707e-4), SC_(0.0002185332614250133919110843086090241414986059147575471380797191831726709422142700747914347815455633164), SC_(0.0002187506170966123859925751409128137961760943659826336446395337722875414011727198318431089358717637573), SC_(0.1130563596620277551701605354750907427584486998175442872678269614935224303012323869484544034808335726e-4) }, 
      { SC_(0.497627406730316579341888427734375e-4), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(0.1598974104578574350299870596159203437568004871185469331443812283735434709879594319993158918405655173e-5), SC_(0.001552848311230202417938806611295285597363443034881567204386302197148470747520843174855312597223377679), SC_(0.001544828161719114949706704349635345118470687038806404625428773900305503846138112772482211151625011047), SC_(0.1598707775924615223950767585377418458960476119334124578536284753771992111750385424604308392521289813e-5) }, 
      { SC_(0.49858455895446240901947021484375e-4), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(0.518449221406693951160208441389314759727194633963344607852915172195843493114207659610431336089841735e-5), SC_(0.0004789626793582555053376038816277797353297935960218366724982723705286910454205928491654858461225783187), SC_(0.0004799025164090402980607389422768713119205554211935881971907099209698103135165330954082491318777284531), SC_(0.5185549657637433355439705396013704688349145864239730769325914365200222944032532720663027908244958958e-5) }, 
      { SC_(0.0001011273707263171672821044921875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(0.0002268132730507297685874050553477347049488244147365113187114414767187265700956165408038329311255980695), SC_(0.4504765974744563175640886827542764176184060515434901763384686162640065316875378147702800816295231279e-4), SC_(0.4507304504083886534212962270590986666996744845379495480464380871203724278512496668900459715253739861e-4), SC_(0.0002271001785260447359230173625332838896769428582897019000317254765797043335499076232846513637729578929) }, 
      { SC_(0.000104760823887772858142852783203125), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(0.2070640306316728648778801757305760041025288749008371161990530685296687430059973167819801770165158998e-4), SC_(0.0005314094056280443189923384476823210563258150518833866791092260888149145414456310812881313340435378643), SC_(0.0005290957525369397622719800668366073236642412097413685464743628253783315719569614747617423550156425643), SC_(0.2068855086362382858592477666649717496745599822833524079701299313668734767535924072084568936613393908e-4) }, 
      { SC_(0.0001054156527970917522907257080078125), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(0.1096337350085481482561580158512433616552802643202944586359176229213701384878477982522347837621976319e-4), SC_(0.001014277107084296962956321700738732007373659436462855898639659296666253084189151474307106550351633019), SC_(0.001013047269438163746258980723315483983575854962019680213405535897876506084787214068540859927161380212), SC_(0.1096198932655766001728678488095417614755389151945930217073951140270279871671486798644902705917866296e-4) }, 
      { SC_(0.000107109561213292181491851806640625), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.3440648248250097202378072942311606222088266530649374823800380469394685725873408845205471324661959242e-5), SC_(0.003312649881486066018395948540877921813925212851695707968032571735953329909255623670369180122204776196), SC_(0.003355033148371425580458412135052401817948826634895370502538741988878229941058332367910946855398822576), SC_(0.344205777229861497998358163416730012826502942895860216447419555965944336018292238473074767036231842e-5) }, 
      { SC_(0.0001215800511999987065792083740234375), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(0.0004288326102216283908097947755523339611619649290750272544205330780272123739257919398924483123620829011), SC_(0.3452702834203833526428025950000808228538405521905320242231151883404379787075288963877257513221671415e-4), SC_(0.3450164949656775496296603307663308465402515614660721179700799536348575657427681784302171951204315389e-4), SC_(0.0004277236716637147859840724813811219848146721182638319082432256463175687844111992020432440196266597349) }, 
      { SC_(0.000127038147184066474437713623046875), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(0.0008113057702163408927158146738113896715616011940512329969147944229489708864379280648437545345705773154), SC_(0.1992724193598808039030133771477333035872537735667348588324930664453711290470082760469378701184315602e-4), SC_(0.1991774713339675508570975640812428284823204703071944215069186049643398647901813622008514143176551954e-4), SC_(0.0008088454876693076215882030741764466058018896973466432237458239053617888107867207823044579194513312126) }, 
      { SC_(0.000130341722979210317134857177734375), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(0.0008975394862470428415719822495482818762326765328338686112689928412539237384363017849701695900302995671), SC_(0.1898086366278054163921845136641307518306887392765479098869401214934275201949793253054120177371932999e-4), SC_(0.1896751748178769173253997762963876442905197116450653710099048874548949805632964628738741192577036646e-4), SC_(0.0008932165490699014529087719792944177684261658719414460559135855170658038614592949467257421032839692116) }, 
      { SC_(0.000147599072079174220561981201171875), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(0.1399234219395638557035746021462247785786531027310898557620121026978661793055038639752936729542780342e-4), SC_(0.00155138619325106008387012572235828461219134529752895808594494331185247324319616592672860148619643046), SC_(0.001561594325397608366781859988061837959171671733509917027725944623874527900194208840053173254046004888), SC_(0.1400105838564947515874060140793157724654840660678364351282654105106006779977214457794798025032313473e-4) }, 
      { SC_(0.00015196247841231524944305419921875), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(0.00104820079384729066992001745453236040978608955409682423124815692133968314468033095214733366186966599), SC_(0.221348228856751055572813549033367760083969793206555302516240993596725942272576184614320157936871391e-4), SC_(0.2210834842176737419331468126177078686248641962859661018383260042838259605218282802632135458459947076e-4), SC_(0.001039628143905790632048147504262394494849206869496147267551924429910265649161734817901801541740235336) }, 
      { SC_(0.000155449772137217223644256591796875), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(0.9034307226810278888555398556015211340624801756555615948272030289894486613819391471132648485210246561e-4), SC_(0.0002673318180946087359322836014479161285526497161124251118707365640817397252800851285760278574978917847), SC_(0.0002675145950025281703633923298023736769097312896570280693324743143342383444359293964750682326887030999), SC_(0.90378976844026885140702045473597588440193420309636379953272818753383334083941720904634311854663931e-4) }, 
      { SC_(0.00015971760149113833904266357421875), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(0.3155034276543071830766935179651175043901170841858968294396165221273859288712045321850052431370975337e-4), SC_(0.0008077828935494931392722447595962058403500848506697909427414540461874101018749122844264808872119039325), SC_(0.0008090473702000029063176194641496430046270094835022924688937799679770271964125021190317397942196778198), SC_(0.3156009960703240467585688081101616926574833676169075214095500961430437372366170389442034571109336371e-4) }, 
      { SC_(0.000161775373271666467189788818359375), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(0.001035826388431694871985842182063311753554748455771067212252714519349415936274137428611968301553665604), SC_(0.2538641562699566563447613075987228212704442579809702988423786481332952375659386306079443030417608625e-4), SC_(0.2535377585304712144109845336833219457920871092187850431218488622271734003704537887014111533529091165e-4), SC_(0.001027372569660989388988256115406698138903576547808151756959429505457325563277083274300252098859613566) }, 
      { SC_(0.000163223026902414858341217041015625), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(0.0003661590444336414194176541722604462930797188800295888590698810715360386384803057900073988166939767668), SC_(0.7271507437438483340122539224567366272354957006018910388077921127350146697328328973712333803911096863e-4), SC_(0.7274281406920059230833502321650241405781595898337159399439177200739003740447163696997595146626816578e-4), SC_(0.000366472540687974378069064507217743169253357172848741650823304978563957102526814228726221030897899524) }, 
      { SC_(0.000165044693858362734317779541015625), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.3259527401903009729995096702723528633507607798497138805125103516321711865504441536506482006106413289e-4), SC_(0.0008337721689126418782913520261192301641658938256230202517122291127742461772789422860996466181915790448), SC_(0.0008369905339435550365324647782769630076933651386292286880178100722906117934688697925076369689434990028), SC_(0.3262010993299942077577515136519552409897857163411267856863950747900031818048806836392554179256219366e-4) }, 
      { SC_(0.000178638103534467518329620361328125), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(0.0006300231952475930124061177945878599124745296730220835651334596689110627860335790232816256730403857647), SC_(0.5072929324682157789115445132048743540954797491763110669420054647381423202649369044114498463736461087e-4), SC_(0.5069484604426229758847560262795004106419160891516721839309801993604927673964251143154889040597419477e-4), SC_(0.0006285181591206903731736867338723500420664254263869877036268425957378520516831272256597314171468682904) }, 
      { SC_(0.000183227224624715745449066162109375), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(0.1906340756078685813256975861052677446467853846753006649441206602394239358909804576663676042192455665e-4), SC_(0.001769668290739368274143947179637360635976542816919789731727691236509036817695090037907652131672237009), SC_(0.001754180790594056980780356569660060146852837867501581240595281834717634740497937590744064478137370465), SC_(0.1904596239294069501413143566092736930674453335679110797386070814300132497130605631048099038117949605e-4) }, 
      { SC_(0.000186895136721432209014892578125), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(0.6005434342873929259235837105472010260891960969135825495296108485588844773263482111075717621559164571e-5), SC_(0.005835753212813880809149221102849630885873166704363251154472283807361205049627932150074672148918803835), SC_(0.005798022146499808194651141910961480026480765560011905114828468776298116098612959010886028689162020159), SC_(0.6004177706865073544125590352218706135767610039282490834027143885936074424371728390348301819352601802e-5) }, 
      { SC_(0.000189524769666604697704315185546875), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.1796557336849424692406689104239024765042200608881835430567416773207369351937657695650617424210018888e-4), SC_(0.001990536826966493253315051683042278792028707191318027292195549897452750247261475093835552047207745187), SC_(0.002006711597590013401468703070801418094985605078070170586988046382869058180996736843814479970234253117), SC_(0.1797938886665816111546207376864229930174199752137438773157899254619837324332664336338806422215765779e-4) }, 
      { SC_(0.000192062419955618679523468017578125), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(0.1997007380345636519012160688272475471637170882029111666252191043746287267689696888742591242751196805e-4), SC_(0.001843807506980603671910012661453293630246677421382519941082616949309752626351766791791862337382784091), SC_(0.001849886532593573661400070780424759454463589645352740043764274373971661127987937804375430892260244928), SC_(0.1997691988091226273460600578579558897018813604631722104139605589613363641308977901057466319976176573e-4) }, 
      { SC_(0.000197409986867569386959075927734375), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(0.3900706360637590516902273089490055676836659797941738015420465207351832978989531839463733334366443528e-4), SC_(0.0009998438062383963525237765700999987873909040812122100127871297772411769242332000262853333271107510088), SC_(0.0009985476058982296857755428868738502293145281410579577337735183707460690623522229547159518794838218807), SC_(0.3899706079065217173064727949837970492261591351984637334928227588688388724755060897533033646258837033e-4) }, 
      { SC_(0.000200433540157973766326904296875), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(0.0001165642314418571438389116095687185770191676611571831362232739210917131854532007760838612648063807577), SC_(0.0003450881684597984545156629598176929030554551944722181493887808541498995149099971654672742212976212382), SC_(0.000344531487435080587996581184991597633920947595793743173624605084058687394370650230150985102917571564), SC_(0.0001164548718999400529978420153763543470374657904952870508703195121377721699401880120697912615042150656) }, 
      { SC_(0.000201712871785275638103485107421875), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(0.0007109042855208672692538902711334912070110787837516007451110452757843093305609955137856181973799623699), SC_(0.5727061104613274714542049308897648944869824870715266511519647624714834977020930613184931928804865712e-4), SC_(0.572545235827381566062517813619571365490522965500461926942728769806135449199767354030399344334521915e-4), SC_(0.0007102014146053586763907906294401428093280820267823791138216723776108529989928551629380979730701541429) }, 
      { SC_(0.000202038048882968723773956298828125), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(0.0007108808926444719356634987182083699554158792625978663878279211571974254969136901098044989130778896454), SC_(0.5733615341286943712697625965154707052145159439326207586623199515848775799831762052599797332031959775e-4), SC_(0.5737361337797812046604936866005020558298800055335654839638296104323537966261206910309005804658440484e-4), SC_(0.0007125174871506509349505481393702467360696219336826099095913940262100527406319603549591505150740922423) }, 
      { SC_(0.000203003306523896753787994384765625), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(0.1924718010450550229023175498820066784330245913282683806285094421893851361583588241405063661912026142e-4), SC_(0.002136678418804191267904907570735248742576863787107086309129399014490157978220828417534601309275736972), SC_(0.002144776427362447724408202397112009715809050375738611512084552874053238342123567205623277779639912253), SC_(0.1925409633864863319843539312795525201712575488316262216828048330209748226943561612442767334413659919e-4) }, 
      { SC_(0.000210410027648322284221649169921875), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(0.001440804674824610988291691632840996289761731049708915148272424152850586843963735450399613160983432033), SC_(0.3061572431983649706261203447126196012225155910812601040505811721265421170403108706519152693941726595e-4), SC_(0.3064417401603668808802807582223496681778532339549808274361332335177087031050603830397626468513232021e-4), SC_(0.001450016164851483680185481592900009868606747040496359440797799118358783824823278697042315245629082662) }, 
      { SC_(0.000214335610507987439632415771484375), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(0.001477997488472159646052737312392763691576347016285258607148142605842248686744642168868722194265860389), SC_(0.312187456224776987649473684162860543114761774934996700758830153187252639356599966353895365505881486e-4), SC_(0.3118407266380842401907943809128651196217467856703703336348098522270126372090931364029407685777491463e-4), SC_(0.001466771980973752402680274074427599623882226607395130714492195433404032667978066352521438934507585175) }, 
      { SC_(0.0002199326991103589534759521484375), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(0.5001608351274270893703392798431617026252099183275884172228310913200082179174858165729284452585968016e-4), SC_(0.0009678605988457752144452083032164797821729283457598996140995264725241813998825669561062054839138795176), SC_(0.0009666157400708285158900537971923846587515681259239920530646072737550145478127978933092866732951670127), SC_(0.5000143914881696063981774695669227545964322214387942346487170888175636125875308590856421699092665313e-4) }, 
      { SC_(0.000232979291467927396297454833984375), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(0.0005230815968609494976281337878106819851742104964906414082701161800901835643057670673524705854858947704), SC_(0.0001038299171161096079630431831740582227835121849788182116698311698748978744288527389672623612117561919), SC_(0.0001037919911170713629739843869327555111210098165546314444992157149260172464283771120936892764664033519), SC_(0.0005226530177447886164249969574338553974054237430458171773473869344648631756615047480272558858843731446) }, 
      { SC_(0.000234849067055620253086090087890625), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(0.2229024031621209938634983040363196929411598636080722514734088454622462069214146924812490443572142186e-4), SC_(0.002499814581105344975577808935270930593479405256770362320696562085232347994691079726326344279956966904), SC_(0.002453773264816199734106719361238482117004294927134517313327669702559073064273543792564964543589845889), SC_(0.2225087815463859344730942071506737921998357743807069041937707394349041779386936585117871594862441809e-4) }, 
      { SC_(0.00023615430109202861785888671875), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(0.0001371786846136696899948808921591789205255835606376989488924596918945743817217009847082704008465958583), SC_(0.0004057780271157213643952443714081323388332040336502463760437278469647185263249436573929658975169706634), SC_(0.0004067445484245712015744438470375293236424613083352330101994249099379818820378950203886193818585259962), SC_(0.0001373685651801585256186166545654584138440136668410770944830630576400151867648451099212417799550544612) }, 
      { SC_(0.0002399935037828981876373291015625), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(0.001653233361136885377885830322738934006543735483220431993709111065666807028123234624736817270230025187), SC_(0.34950716956410311160520895370610476274118422360034597794203676550808716078043576007696616082179271e-4), SC_(0.3492227040914839022681018334364188583990406425776886430535009886486121589834748840566852504622011467e-4), SC_(0.001644023643355722952751783376047726070374890257773336744371598345870131991874261085075856384232070772) }, 
      { SC_(0.000240663808654062449932098388671875), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(0.00165830611818981375944631992167832683930988216739257888059037878058213628937575066620072958510777371), SC_(0.3504973269091630012324327311511173870573293831586235372952919096441580651775282654359243305163955462e-4), SC_(0.3501841276553943704240425034855202811616579822932515373643701001770774600020330332513490619599819498e-4), SC_(0.001648166406725010000161911507685863160267096533180304455512293776263284518578135432447247423207174993) }, 
      { SC_(0.000241104964516125619411468505859375), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(0.0005421017331489480678951816991201867214304656555888446465177476479792268681231829481978319406118369193), SC_(0.0001075198334736502549993260711427108076180287078580280917962893812101869108274042665560389665945267138), SC_(0.0001073434773598673640730252295858532758351079932866425953319352959079046722753038651965655088978780395), SC_(0.0005401090178847103534643769074786781050599628535574273823686007395044371171846809162442532479660383518) }, 
      { SC_(0.000242538066231645643711090087890625), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(0.2523861606086595170329409521684736727660127347762931744225363832476065910675930735592789997472933436e-4), SC_(0.00234641889313599165992023803249929262627737916687108757522625703559890973765564563680853015330643168), SC_(0.002318191857840801937676566846928506986690904401550113902072425111003894653739537657788977372098010517), SC_(0.252068048552960374518687430188528727010683246438838590455520187232225082832407639816861101246863538e-4) }, 
      { SC_(0.0002521783462725579738616943359375), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(0.4985665041899420931468863251165785292058279934723079747433164534318480434543778350089449436467575384e-4), SC_(0.001280833919691630171430140778500200970923663133281056271651875090106135745971244611167459222879422837), SC_(0.001272013431302424598534011556059701199519215138200630761854617981620939291506723220145175284556605091), SC_(0.4978855580908831208497442923937496301971592989550846796338826902901933841963114719996412089795524488e-4) }, 
      { SC_(0.0002549183554947376251220703125), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(0.5802625958503400373158044098702703524714311254311155645383095475724643824174515927645516566800226911e-4), SC_(0.001126424944152534663277111363436506286318768728705908922840294396853161091051104672054287064946586942), SC_(0.001115833226481153512785853377898053180422880528046586792718353201570977358087862291399243904019389172), SC_(0.5790160020679423329005978128683442950862551983914145112368974718007248362860374511903202268712175193e-4) }, 
      { SC_(0.00025542793446220457553863525390625), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(0.821415692023273265224411124131827465895902746524856249735709645537346294184518905536911725823013859e-5), SC_(0.008179778387059270264352324148427679679085972255787036171203077258586479603903819254993332604898902236), SC_(0.007734694110517225954722949462244548257442448728658934477073558934645217372989743687040211363470684257), SC_(0.8199284499517940503635883186874152962237044027953805304639711887391396900402825483406303642852697041e-5) }, 
      { SC_(0.00025692817871458828449249267578125), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(0.0005777041526425997517254635399151714486456613040073246365056627241047891271651779038869998725848137648), SC_(0.0001145783825179985300970890476438674053235295980654114720007243381955348227449777774563324061635134145), SC_(0.0001143859656309264650070815161758663360138202787871767027380348038363163050370228476504051993300482981), SC_(0.000575530001551711469685597804256943101429992122300633247571376643966306979729857926203994492446814401) }, 
      { SC_(0.00025796328554861247539520263671875), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(0.0005806073777632786664135843880424342427095766844645986583735045672671988537776626953224350090866533571), SC_(0.0001150907980054630680853892124249445253801267000339447731671428849822581378922494929967775725995595079), SC_(0.0001147961914870638212129410232192844430915884023355681062735357819032905750337435054983288386889947696), SC_(0.0005772788720788034982441467727093006763849964660518542663903522804462058224676482117294865734320346352) }, 
      { SC_(0.0002616834244690835475921630859375), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(0.001676267209840469901204826496043136841524500638498841809198855487886544872126264929502309565080003078), SC_(0.4106723517894600553977870875927418356284588224510317149647179954074231612576655876886537303633382388e-4), SC_(0.4100872157540957141451331606467085637231547963967193391070547213646338574109449281418806160243702785e-4), SC_(0.001661117500203170815562506357884220748671767103026243854949469646819636497237129267605616226860164456) }, 
      { SC_(0.000265066628344357013702392578125), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(0.2755540429520417974501524132166046657676913688437806213892828316374403852666651463455528132795031429e-4), SC_(0.002539857432693927657970826521223207358316855724563925528714350143973311962776949855658676682700042182), SC_(0.002557881606896473596401089301557166040084293845804098208976124030979904686648676518027787026083789816), SC_(0.2757571461771687541561344079217174565255283224545622873586041295027257596452073785078407638063745421e-4) }, 
      { SC_(0.0002692660200409591197967529296875), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(0.8648297216061751156798189097376185475222585040164280224487602289210095736547958424161629007239918228e-5), SC_(0.008290743463719080706429435288114183393365038820581547150357890568078448226639919648533230110600342516), SC_(0.008472124264970794221542431608210700614510825925812144853332756945776894750370213391644356853761552154), SC_(0.8654351056757429380787619925790998784894620047797700543327918435122876142551756580911552733649202069e-5) }, 
      { SC_(0.00028241312247700989246368408203125), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(0.9068636862122686321502159121352223958287529498763257304023878292044618583276545364357688440493681464e-5), SC_(0.008640035396379330004908329777007757080328106697504352312818265938845772641507133064268722898535885972), SC_(0.008945165553850494460715224378001237159857916787367570663486974067062594705865710550319899050190112315), SC_(0.9078828146614938746353686104813225627955142465149656228438244091317085019741290371808098344788547802e-5) }, 
      { SC_(0.0002877562656067311763763427734375), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(0.0001675310712897910117700121415390567915555540353017200932772983086941511734434907183187088008631070327), SC_(0.000496367412647784423347008357225483467449872251133917949311192560124091988283396621391989919381327176), SC_(0.0004937051787461425528426447146347102261109332859557527848729597497988449517644148393151390541774243973), SC_(0.0001670079871553428219513260537639812292271888900614708452693003865673448700578212414198343089467576793) }, 
      { SC_(0.0002893155324272811412811279296875), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(0.2744842948667532487034102066236040045532470315127823168950794401837220883626580430849496644022773233e-4), SC_(0.003066033729472275290026783801019525079402955885148133213707597682659936075291261116890422109147920419), SC_(0.003035924219663829269392644310945387089474312323772279402202511853172801447214539945447046682847083169), SC_(0.2742269319745298993903012333790533294733390671842651336143080543778357446177998451375416225685982602e-4) }, 
      { SC_(0.0002993456437252461910247802734375), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(0.002047414025675023709988539490832280525679906470066817718770978932169883282494740451098439061328446143), SC_(0.4354887554051094918576806232669585920941237420544123856803290544853148114773971728896941269897720274e-4), SC_(0.4360422916552334830173845437914835276260489850564965886937830805539078461438064422703927423795155176e-4), SC_(0.002065328086064729421182928543504598934894376166013348548151353652673525872283641156340998105217789053) }, 
      { SC_(0.00030238283216021955013275146484375), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(0.00017566565728245500677764554131968311669347771072506376352426848999340136078053394952308152017824448), SC_(0.0005196569468253478149205889182622131793788417659672984463187518141330784535000202243233278033726945059), SC_(0.0005207339009658372294070030390415453961397850227588362167502936147636125344570546625907325120362531547), SC_(0.0001758772415067925478261199571218335777147731916818454154077265317519240184139934204847339754869593142) }, 
      { SC_(0.0003109485842287540435791015625), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(0.999781359290938356105999677303506412435402141627357907282613856130982765563930065822862486415163191e-5), SC_(0.00990030895182829105918652356117963105593979792558446433731229221406376202919919349902733575088722318), SC_(0.009466252584933207122861035482144139470835025120241186772575991491643297254378410532538678131637855503), SC_(0.9983303065416729589923804614847525916406889287531443289174687562044207658936804476056044597040942485e-5) }, 
      { SC_(0.00031231902539730072021484375), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(0.0001817585223413142032007810501544179877444930358946680233498722362468058953642677820860438565401169132), SC_(0.0005383650473814283714159810352217421782947394008916052651961442552720793634112741205604983151247145487), SC_(0.0005362160194024868514865273980016187169473602995010779402948562686031974740422896981089276013248278623), SC_(0.0001813362889498750441046195050638018401281153643081560743015654753402861573215805368669401047091227919) }, 
      { SC_(0.00031888621742837131023406982421875), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(0.001121999694097462011548242581469157934411496004546156533242341501089328321023536772039926980728124667), SC_(0.9049598052006638942633426221653670816973803086879367740669577595188294370557559320420876305035403674e-4), SC_(0.905558837583469852893189156674957617602951624945156327299704910512994155812858653548253422381642354e-4), SC_(0.001124616162241124456613433957097880534237223373573312173556839058773305453684169371341063623920432532) }, 
      { SC_(0.0003198894555680453777313232421875), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(0.6323946219539540500654865642285259766148611231207153476812083614268460616017358769633053899853030561e-4), SC_(0.001624227881571833296499178941572125206240491132069416087630074111606184737426907710792091526373264215), SC_(0.00161406096996548646294435962980722462935022307864563328320357381108414535389934938557886458157871431), SC_(0.6316096059933547833001620707005857613680581190847468782154892277549277254127764834362606591317440617e-4) }, 
      { SC_(0.00032462298986501991748809814453125), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(0.7388005664594334719110248889993772564617668131459262407591033128994902832456440010593486609228157979e-4), SC_(0.001433331350287553795080014481053507666182608689960332104326612135619186843798395569469080520629030593), SC_(0.001422024144580621504883621552261066872117213757451641720093737252305498858530786405500290300050027905), SC_(0.7374696955161047256371453655837128403512492240614953289999154780438149658863199717499268535242028146e-4) }, 
      { SC_(0.00032712865504436194896697998046875), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(0.3104650020406313282637221820311055687708265516067461426351520519194641957091752148225909983010339478e-4), SC_(0.003479324303766134164731732845116479912878526838829613025879340847087427575408906880049068770467368166), SC_(0.003420537043917818424061522018949686713119113874171842050279648809125302671917140797914354035583438321), SC_(0.3099622170897086715405381834407145463494075770328414380129073135657323485684646909476957700139755147e-4) }, 
      { SC_(0.0003275294438935816287994384765625), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(0.001159653032570633283265496261978586945698374698339432150735795399089708034777045703379489483883742752), SC_(0.9311410353718132085511152710928386925799736061572497590681737111775533150092424587996087409923767577e-4), SC_(0.9284538416633000706684285114297553943083277813525600484704844879594634228748849551977478658336515702e-4), SC_(0.001147920271635161049341825658610978667085189483261675705914088031060542126184381305646381925420621476) }, 
      { SC_(0.0003295018686912953853607177734375), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(0.0007380292272540569071904089923354018734155178844985397604545768925295367660520567701054358317859497976), SC_(0.0001466900951404596120037907769707497347869801717837719120323880182084622230403144031414429654335128906), SC_(0.0001469491155177602003965384687869711575941158507006708905960295777285362828859443953911938184705568349), SC_(0.0007409557066705828772682803164240954440533823385415124606845185689357900943697168298245898887333435751) }, 
      { SC_(0.0003323826822452247142791748046875), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(0.002115286426982160413183239481718462592722484236410142976720622572433915312895810837291520059936791102), SC_(0.5210903444874990483441722953581382075189367835041015335788006861780606172574901054675248035894876841e-4), SC_(0.5214142942354255616373231810852240272907227322606279497286440410816322834901108612314688518433950889e-4), SC_(0.002123673313741037675925380318655612157150994724208880007655136433847121146627803766244508832638397386) }, 
      { SC_(0.0003341056290082633495330810546875), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(0.0001943779152086574058234148383995650368093348131115098902175010739435338093724076280980229122496239904), SC_(0.0005756159947458861330649876293371327438070112488115501319798334090382285665501685143585576108118393931), SC_(0.0005739229241102373356217986023453836770187815245022565749972001708519622035845947173349284243865890229), SC_(0.0001940452716286839209731808154721856833770169564998227856009728939685434117993179055899587406859969863) }, 
      { SC_(0.00033410708419978618621826171875), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(0.659602677633504467098674190142373564177139981283665170154795014327357813752907991157657941261202968e-4), SC_(0.001684781520074534177336342375774363121609820567585907012748046164075346249572130667736759648975554492), SC_(0.001697450340579366722147068988398130755762728395680327682608758830493027598747228825552271763429578473), SC_(0.6605809677093912885675432799056808586036091295939990234802301693732097100626209055387535340304140548e-4) }, 
      { SC_(0.00033712954609654843807220458984375), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(0.7673198539176342121999154534236011836453931261270542999005390764669387581358974232423381942917603879e-4), SC_(0.001489031026464053054434737062010173877862105018409875853117979097017812324189164145060457824624028718), SC_(0.00147633971056037809908678134173460002692945401062354687676723197072457153726536105085368648117192593), SC_(0.7658259780342301257282246703690424477835745633848626191997494093219055754488823995476693779885533085e-4) }, 
      { SC_(0.00033780143712647259235382080078125), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(0.7686166266790239584329017865992379690248097155171537148941213880021354164423115867736687121288396261e-4), SC_(0.001490010400404577787200191391672360588573798844721463331884138191122658978849612053294575839101929823), SC_(0.001481237254373783485178683256667803391082802581072622261243866147098203341066022096491960358005953283), SC_(0.767584084281454126864248492666950194288019451908401337096083450812150286830404422316824975326149813e-4) }, 
      { SC_(0.000346417888067662715911865234375), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(0.6848344614603044117934068299369051773836418442244329855102852670430254354259612224133169256554603219e-4), SC_(0.001758863375947105704332414228570283215167895078038366740612491758763006717572443039795819231082672151), SC_(0.001747974633574594365792295929799066662902161018245537882908076291595175828681614382534122859114610512), SC_(0.683993646450635881785478673190563139849350769752272796310113340012995205607591969690837122795723782e-4) }, 
      { SC_(0.0003575843875296413898468017578125), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(0.3715866227377179051960562016734922269079787936264774387366809061733062760879713604303497657118659252e-4), SC_(0.003413594010214759680029138532367394858946057856146844551382191785159770560439699582758162189362749138), SC_(0.003463744950002668857985820579100979866841147539188246434792383382103111911761401119438268055803768631), SC_(0.3721522398903367195036209465905190799925440543009703820385341402819796605264881507651986277379395206e-4) }, 
      { SC_(0.000362039194442331790924072265625), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(0.0002102170740062947512833514453900627854325351270218051523152534713216688169093515562053545167125194081), SC_(0.000621644037481925543465527229840055538608648320908687796498602283588491643481666769141746947098162378), SC_(0.0006240062235283806466147874315885809636845030367756705186532963790801446844920030057276076735988696235), SC_(0.0002106811997495993486999103208760614963810263796692963557867984048967071497756659478914590452967797421) }, 
      { SC_(0.00037188109126873314380645751953125), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(0.00130576083396162409288630636553882094864844554067233136610910610417139241506912552802257820087961337), SC_(0.0001054731768662731181296121969910383870149108646940442056750016958777738009938267698332071198110593537), SC_(0.0001056673670268265831538161930502433245495292327591272784470245058847775145910021844952745350686876708), SC_(0.00131424059078500705747414845504142041596371246827912469724516782538785297723662686551622378489550495) }, 
      { SC_(0.0003719279193319380283355712890625), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(0.002386431908097015187425943091958790421450718003732678551083126321527823323530172164429782824897561427), SC_(0.5838365417734472841014213185332862349379008708166806046505723919528013468564289138873400005486512473e-4), SC_(0.5827009476078217758504928930120539045715540494642062058280981226429528594715973928062169291091438752e-4), SC_(0.002357046841686479294559286227079091516780193999332019530762598846954548542351374941236274685752835037) }, 
      { SC_(0.0003780931583605706691741943359375), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(0.1215555062280437782079819399507679907362468834541745213263400147283354976912765042683468400212862047e-4), SC_(0.01200168051087055324068291562501226421831085178610527497765805041151606452964222069019428087659845723), SC_(0.01154241581866780625827403900983535567458418600034130125837862755914283146685272126185859162771393691), SC_(0.1214018005342248138513115171737355018592000913922432189436171669094377891488475622156924212118719025e-4) }, 
      { SC_(0.00037963068461976945400238037109375), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(0.7496029716966575008531516587118666490947618472330567448579266970601485871936223887254265868312512196e-4), SC_(0.001915966070260468653670708309083776664651569418948694879526317386427972322002361840923503902772119834), SC_(0.001927082263997676846695368430766598437544016996136626678702680184585150844235036723352387704740645087), SC_(0.7504614244569459671210532790498531121229619638907988938732730184261230380108380759322612174477626951e-4) }, 
      { SC_(0.00038230969221331179141998291015625), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(0.002424698119903794547671257799815547682342270190827344088118750584487285587873506232159829287867550584), SC_(0.5990388586512212598434258936528203139380448343356072212782365141091238427601075632469573762368221281e-4), SC_(0.6000604486451228384084365508640475220481190289045899476681718351642645016427572894506979054718714817e-4), SC_(0.002451134334445301762727371946607993793018690855129079549414901467451604113944701358657121207664100314) }, 
      { SC_(0.00038428153493441641330718994140625), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(0.872994227800991103806900064781182085219791187290149716450065525722528925598788952026695489886821339e-4), SC_(0.001683308765518597689966333328899499486327066578068514792755735659850835434542314719891145613688787173), SC_(0.001696796877530000858230519666718228453642060449328318815155923513656361473405209091859962377774310814), SC_(0.8745820214474159617302759902026164246875259918932184496488830583964280308490297194549284024425736932e-4) }, 
      { SC_(0.00039078187546692788600921630859375), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(0.4069961376983106090826200306594605739681743990980570494409895556224007745897547012006041181658729274e-4), SC_(0.003811939867106956709725477129067490435832641221373431971568100346865364755451832724297813464770800842), SC_(0.003705203033833278548134351952264074951314826333221450998099485347898422937212707771764446790106671192), SC_(0.4057911615456531185681560503508881733333428988840803782377781742570200414238586157543569564817966353e-4) }, 
      { SC_(0.0003931194660253822803497314453125), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(0.4091117067777540381863503871497797241418423317084630820161979764142528837808366553620241139314196501e-4), SC_(0.003805845495979772429904763309058088250488158661715991769184998972836499360801091759852797696892456377), SC_(0.00375484673414790434699754371249683400781397880066491279769223182677820035757431046670676640534336839), SC_(0.4085364390813468450331453134601893483738538205145145142359785426407229838401153713956481095207209303e-4) }, 
      { SC_(0.0004005068331025540828704833984375), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(0.002740392254950158936887987185534328347734765362779443165233719773762275502798626486216205780104837741), SC_(0.5826918766013963348176951634640356649230039714786269060052913928403658029900287648242454915996213317e-4), SC_(0.5833653116998624627778977112133294534090907288150345599697171860133791977096695395131417271442343884e-4), SC_(0.002762178109802308466241632700775026527053510323810251939847337558664272167235861562860763767742996375) }, 
      { SC_(0.000401491648517549037933349609375), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(0.0002337177523525441743048802967268920429094460252063270730455203849659387248616086052448744283372737953), SC_(0.0006924037935655123530875341545384324778347009469420368648765748539847302181796653564583573078298809782), SC_(0.0006889921827608865012383374696493435794917803124680620366872628387665419560893855664432211784200546609), SC_(0.0002330473954870517447265454341859771377735639578256684416463712680661980315212079947718275456394454963) }, 
      { SC_(0.00040288010495714843273162841796875), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(0.001425052549065087082659623856987651002499527514910457588209324131633681420296162528282003424661482849), SC_(0.0001145042192987924301675062636204474057088145408600051799157549829497934626933037795627901384886657052), SC_(0.0001142365431108919718742068644675349307046022618420796329423374105941639739418506537011166204552592469), SC_(0.001413365482118340693274902038024867381373813042209384768002387953866480713530962140800227349658556371) }, 
      { SC_(0.00040469245868735015392303466796875), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(0.9198290888998629592401943934478629851484411718286417968882541077342059845606064451136412221006846604e-4), SC_(0.001776654375403298857356356626640279584364547474461060158120164716092751039677069528392378416103424706), SC_(0.001782930305105866049586325871140792488252372092883920001971376517343305047962956557571207068787459028), SC_(0.9205678018320168913950473916084790640270756239649681232418090898689690436803387558415968497841429691e-4) }, 
      { SC_(0.00040956688462756574153900146484375), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(0.002597151714760409586008110316396422541516237976204946696049163826908528977550968332184973585496570622), SC_(0.6417316745962089487000186995559225437153434815096994567268493206335222932839899913981967035277117163e-4), SC_(0.6428588127234192269414331214710336421556193212612127960168164738858017142311444761289493905368036967e-4), SC_(0.002626315890078606433652755347889780529487707381101654092976048913786815120071557650210943761168836498) }, 
      { SC_(0.00041155910002999007701873779296875), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(0.4282882626979436035472486492236380347394581937172656972424384953215471646644366687647322894464015635e-4), SC_(0.003983166892564107183903106198130198811644611783517500402772462776654241619934337671278672815761914359), SC_(0.003932120716646300415460672195598032164723013517471945954494036625123564484599033678313483630611647923), SC_(0.4277124109084882840044516088504462195512253374021496432692205705306303457769082599494295051292462791e-4) }, 
      { SC_(0.0004116668715141713619232177734375), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(0.8142705860900798905962240774789837490692126528200616638324138624316347536168276730475243765419331492e-4), SC_(0.002095960759745676999414954732769902209956851898418538742559036776670228687470515053490692800009446453), SC_(0.002071518207459379164884736195965239355753126673400677616053439762526791878458858888689766453886743027), SC_(0.8123823129082408581823521689802304886525875083388921591816920072609297909979468784708398871574400402e-4) }, 
      { SC_(0.00041743903420865535736083984375), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(0.0009389035622706013929404072761599010044676239452116767226592975584921769301103556661601336076724018559), SC_(0.0001861846605369751307325683997515539025141426218386572079880217548540765269055408723353127650737443466), SC_(0.0001858207975095769018375349127162573907939319455234041998748030348647687933414059910169995308775761027), SC_(0.0009347929882955082574431974009241212989905902750552220971481279280846245251893111542597123051605652936) }, 
      { SC_(0.0004232702194713056087493896484375), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(0.4397984840097120315094317762040667530481296363380535113044404677337263456301269699720814705693030337e-4), SC_(0.004036631279247960666797216830226534646263016800266675982872860658973768013115144953208864512550591872), SC_(0.004104149520816017796648950089517611738985091990648181067087950254772190773263978685933495684089991362), SC_(0.4405603305721754604637568092815861811916412532285531673844607300957414621381420991702962019178188352e-4) }, 
      { SC_(0.00042389382724650204181671142578125), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(0.1361459058321553538474232331117209469298269616298073938594264353306791299309154554608497397583277002e-4), SC_(0.01304966594128641329573668755925912906726562545160952089267214860610467647948695153912822394840517409), SC_(0.01333723524563792102296791742818470666912298081122034149411635804344561383203139527159697555829657188), SC_(0.1362422126806105578124883205220796334447728630077965895599889839263782679884386289042045054744237357e-4) }, 
      { SC_(0.00042571392259560525417327880859375), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(0.0002475525975035215171003084577432117025037316483311701376443223202439613636316260739590247994760054287), SC_(0.0007328235534329556702312646963271666028195303529181130220260257001296802134092730457269626186614300829), SC_(0.0007319040631614181041227699708467987970511294850742885335291908668826600416041324326813865551783318414), SC_(0.0002473719345747698733355238652419253008887414988820712387313373209736775176911153439205514345037784398) }, 
      { SC_(0.000428336323238909244537353515625), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(0.0009596225702282524097431516077107738088498896648745889745232731347689035045330009326840238164166682236), SC_(0.000190709549995607105154304809585545934897595499540083275696559821413123680646704089071857143917853236), SC_(0.0001910070306639892460254693948878368055826443872194940986278711438282806553068502044717708980209806577), SC_(0.0009629832627716060811992227248609862992375332830765182061629033095885149194683861560288391275128236708) }, 
      { SC_(0.000428498373366892337799072265625), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(0.002721555994643353443171650742855128171054301904873564054590311666458759951451096162154481428047750227), SC_(0.6715646974728962424702398871090259958323614413494646977155737651923998095828841623620306318530069581e-4), SC_(0.6724032614391533242431214727641692952385787644875480462173282537833343234582378636421479615453957128e-4), SC_(0.002743254754714854881406702532935949007418024006114125615942559516374694269466675787999520691756165034) }, 
      { SC_(0.000432331464253365993499755859375), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(0.001527765144597753548706480155606687249066147613622073622517718026181513504689430776833940328373690763), SC_(0.0001228414577584055563507993808569816673385985752258772410802412204893037654023183498914884673882503917), SC_(0.0001226206083220527166933786814170694228057294144752756003045351139374536603218546793058698783654328766), SC_(0.001518122315711718777386957836905898095712097844241787014002329749801224147995642591281335209760505694) }, 
      { SC_(0.00043628693674691021442413330078125), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(0.003002598864254667806876187217212785261094805688874636729651941858939064030903439311093218919940718811), SC_(0.6352866843068472331284442001272902140530174429763337311360891730316850208943413270440468577099254014e-4), SC_(0.6349423887927978100804738942252415931999746657062958201402698221459256345373564869286512423447691922e-4), SC_(0.002991461387562920632565594792412264854042779557838337529186547618158382723755267671009383344035489322) }, 
      { SC_(0.00043938713497482240200042724609375), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(0.0009881850832753946433778595439093159292725343368198877150838546639691489345877370610194208710289861564), SC_(0.0001959664600177965960007160492093113854419663186186977964943359949823361160505827976902299091005070492), SC_(0.0001955982723523693908273575453595438637130774098483785184616336288223705609455713920409123791904462283), SC_(0.0009840257335189732057372409723182958228659453132784492010255642297445761179845884232266572814537391992) }, 
      { SC_(0.000450702966190874576568603515625), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(0.0001023769121156293282353209349058446191905930796105832641075042368780425523238060928365767367370697321), SC_(0.00197326336812876648232222818372072668756827478280345343324164148624180307404219644308539503822239231), SC_(0.001991095617038957953799962690608018732047432537377550248964648045848108959436916886052183641477616293), SC_(0.0001025868735857180284409707597282163304420404387861135949132429184853447419619500639543212471319993583) }, 
      { SC_(0.00045636130380444228649139404296875), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(0.4324917237287118164879006240402756735964384972245211879828199924587930692432892655100043395471732823e-4), SC_(0.004780817554635916090993657800428441598766960385398423077831585065213587133874020110098777398812827865), SC_(0.004844420946973155134239779230819718094521301581100139088619314401105072776208630561836457158207919636), SC_(0.4330360585463811275777371826437181602547574623867105236061817479003759545405833252380294154258264002e-4) }, 
      { SC_(0.000462945899926126003265380859375), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(0.002966989645167870404521799768179458546529331763231555315199125162867356496026381271441291152154549402), SC_(0.7265814168659742242347218815300625651930288305079053324076705575290466369456291289704427246817142871e-4), SC_(0.7254301471341328155341217242735822620972158470865953122710741590764513999311116841537931231663108266e-4), SC_(0.002937205733929282143438586911680994254418180055578065784095402083531914959259149695059614574647723411) }, 
      { SC_(0.00046687744907103478908538818359375), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(0.443103218559764227893163219228776389012579435867226661749179192308548018681707414755743906838441791e-4), SC_(0.004966558959346943889565665255643931402948493826076394353897565386519999763422844472095137899856169214), SC_(0.00488085004454569345362707017563105704599438743967270123162925689987751938477687849413480400010806635), SC_(0.4423695333898552788066803260316648087632325254032500032675344426778365993595417541124604067596864073e-4) }, 
      { SC_(0.00047170542529784142971038818359375), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(0.4474397748143215045165071537517055728344052878485855248893141028708702903252910923273784641510956642e-4), SC_(0.004988856211804054667951251350659530914970787808356156879360357642928363998692189586697228681479509765), SC_(0.004959577334631913427098765104188994512330572908957253819393352948255480928990470141290316624805842577), SC_(0.4471892160551452960831336020670071849549777868157432862203861834927209369832199233376891035589019426e-4) }, 
      { SC_(0.00047360430471599102020263671875), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(0.4496640109703729778455874460387358401913869687140902881183137931839317689832621401579419299049810815e-4), SC_(0.005059203070062722613206979650197111671939285612160827461895974926777305656983755264188050483623657951), SC_(0.004931147496234772637344530222195827870925328537568266577972802171357367074839607808313214707874896859), SC_(0.4485673717328137605587866666701120095677508383054131394677341064208849414765668177760970857769492755e-4) }, 
      { SC_(0.000476029585115611553192138671875), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(0.0001081610754351824422720969783900341476136752120406342128280560448206570131351254334711360371538184605), SC_(0.002086780177798348902199800793022319937560955662753891090603384633350844365008489668061285133910604171), SC_(0.00210030144757346689771619405122743480701683705332526470131694261890294914295020560146229638453560196), SC_(0.0001083202729703048057004590808949178598255796745372446112172281638923324228590840342585417427240765912) }, 
      { SC_(0.00048200701712630689144134521484375), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(0.0001096958492561847081004162517480564422542546497661641531072169540953070646182244585237776974428835787), SC_(0.002127992070036396535922156174441825275557341139385021696213308283722321894670028628138766818946645589), SC_(0.002111687121899470391162874275266193843119625341047024809589255982973379656409936090179697427517615501), SC_(0.0001095038656983614534638058339270834053658220658018201001524165498853833129480315174794414489491803387) }, 
      { SC_(0.00048371657612733542919158935546875), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(0.003312664538724669745579633061767605177213142625680491926032076072980428570087380425543362814929929861), SC_(0.7038439243990383599014064796399771235826669128112340567534312371761934588537497215936783135261547383e-4), SC_(0.7044745271405814602927450328815042737857296888163345336366846793080907953557396444457149114069220224e-4), SC_(0.003333058190791941089041169145886197170695143370413312922737022047963311636682015975672953062152189691) }, 
      { SC_(0.00048389760195277631282806396484375), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(0.001697704960227248190914930374520728638562950077697114723606925182037817102596089848738614542922924691), SC_(0.0001372117572510410892181144020725898073659365880987973106367830109148281713935918504154571668634783014), SC_(0.0001375278157874462079915869647454577664257243593778054553459545243018128265864477319709860044118954218), SC_(0.001711502491081576132792516991266810544726440792608846474728716449420025138688630310800347357690669368) }, 
      { SC_(0.0004859865293838083744049072265625), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(0.1563285783998417237169009049099777188933825824001728242831274023514699614295514988093936071849648503e-4), SC_(0.01569704711323356196208714128301081739232230753870340580979270520733843494833791801737835357527267414), SC_(0.01459809757679858726137980842088867804649925301902225950400257364354814508191176076611259698628770595), SC_(0.1559597416293518446992219371821265116092970064605010562083358734873714145687608864508575357024963854e-4) }, 
      { SC_(0.000494983862154185771942138671875), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(0.1591551344027877934027090153219733211136925477169449145974226391517001886478058367868460666136320301e-4), SC_(0.01577176879136673476130963938066177739923623581721967909450995542091441619745772982406385527420016664), SC_(0.01505478607985431542241821212443225121863865633520092399472925813669289253647726361196758371836306281), SC_(0.1589145510088823949472293554314856476174333267181755923994427477890601546875903111851713332889609222e-4) }, 
      { SC_(0.0004954086034558713436126708984375), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(0.003165268035554394065060057511806985498415085236020801337548985901551121168169437785470368861860921132), SC_(0.777155912988843048018491000660009520307768641074188598838863201772979664536633795076406446929623045e-4), SC_(0.7766730035763363021068086294359619120461971678047108496432131411481676796146782664514995319207375083e-4), SC_(0.00315277448737759248383573660342860649227696965674948978254234320483531363445886209318509114086035576) }, 
      { SC_(0.00101853697560727596282958984375), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(0.0005925803746345629547106776096649376646692505451191806893607766560269323862711823580922583396422511818), SC_(0.001754838404946687777818351708150695374644610627759963940309395629076380192998489227095350575436197902), SC_(0.001749581011059653261371483780553934368720850650939376732407580703317981687962115313441253231464671646), SC_(0.0005915468983143173542382251476611841183068594487132678695466862725065175904378285479620594045417511459) }, 
      { SC_(0.001032375730574131011962890625), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(0.0001076390674052197389247160585226586014245621610848857713861454158527560247061734534614222964315899342), SC_(0.01017763500942114729278227098550676567002800908609246753362595274983569917663128117742209787847906989), SC_(0.009689506287469657696840822824785475393897527578939639974614168437970709957564413122118672888792186374), SC_(0.0001070857004619479588308935362977336059958778714200867710225794108685387211285314667138965142250329979) }, 
      { SC_(0.001137269311584532260894775390625), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(0.0002587907008515375706861949702693025042649568323993192036831467273304047862628448062663563865758000379), SC_(0.005018129312664660631592408207830560712154160091525691860346118463615308953902119996468082376889345596), SC_(0.004984960137888043539353675726304094959491624173365855556521810033852543534113281131526656067228858901), SC_(0.000258399433370571477554298273539343552029093368694434223398056884905025827394359639913060799186487353) }, 
      { SC_(0.001161884400062263011932373046875), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(0.00264170136769283749038291757092050726981559933057743068942978353440014141420418968595049139217760423), SC_(0.0005207127486756710320205493608155344077033090032623958152030468618300551653208784304529063383217427348), SC_(0.0005147444953259243709905128913375807702228023207477763012762049701748095348776862853749381102865891407), SC_(0.002574378764445748802705283647382566755559269190336148095273482745929717109206354388538803990050037431) }, 
      { SC_(0.001180238090455532073974609375), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(0.0001229757739551393390214955349681945840945481782454214557033081302165830387905463294978224778730396376), SC_(0.01156103589706383226124328677058326838336984497284539041686838472799199885465752322646342903504281615), SC_(0.01114381027446497385477244860327792325562596090656055757843380866925363717516095269201350699251338579), SC_(0.000122502513839536354359635098535062891140589746728999398868934734298392832302903110595470500324149964) }, 
      { SC_(0.00130386673845350742340087890625), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(0.009282111042023573687248527243520332744292469265213234601260038392373615130303051186430017827285845458), SC_(0.0001907847763974083396530823590844720172033675564729164969573377978452940298890577144570020374682224871), SC_(0.0001888384957691689099289437715636565126344919189332149369771889610016231410091758286544877450206741438), SC_(0.00865611344694814663143992381114790183963462968283330974459138165918301710550249470981791950723128414) }, 
      { SC_(0.00131022813729941844940185546875), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(0.002968966118700025452859780589224394307075657131215508160323773565249749771831242695196594069752245929), SC_(0.0005863206252863972857919510018345256755944813561389300489849889247944018524329551554728640551245355367), SC_(0.0005813233114837676948264087770639434894144938428490610422305519999541002901158571065953107020600341721), SC_(0.002912590203641142399398031005893019765880325362687559700989453855592043598610611658329003705609178928) }, 
      { SC_(0.00131270219571888446807861328125), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(0.0002590205269953961806502164766998557127429653617105839669905216185818691967463236276190165917344830235), SC_(0.006601872434039314872536358963716443549886863343367331784111431439398612382616417998674598343167735552), SC_(0.006686856586804397950181202167941982186967290239499342868217839753398401031596113509507685936653546676), SC_(0.0002596789517524428791643178205074931271611480489480781181967068683569801335446545399946556573549920025) }, 
      { SC_(0.001335285487584769725799560546875), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(0.004668293176285757850971492124305466197008320000922982042904078099621338933331578917103398761060534321), SC_(0.0003782477224096322425351524778375265471081849968860543669039569149954177207818541889034004375699934118), SC_(0.0003798821810258763894587382913265276093187015245721903371737271809980317845173330012304876008862796108), SC_(0.004739505471115503320484003513490290099889603680713964250209726031423364818261293103394601568149279356) }, 
      { SC_(0.001337743364274501800537109375), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(0.004754707610568156596024302926299117801002575462773493019820598577032946800546715734791347084197278436), SC_(0.0003807280561840173934134707343111593157317168894612983044950471743557138081661105873511042557987655646), SC_(0.0003787985298547706837399056002395838342066376324035986502298432101208541008730153863874230271034469352), SC_(0.004670645745487267624940732414483907987371026523787860480033165220522179117445327695353543303171344545) }, 
      { SC_(0.00138142076320946216583251953125), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(0.0001440163866062187298648400015373718991966051187812677665727373907165285309474476092917149037540240831), SC_(0.01360284702905286755447968040314351673593209011569153276845046495832530920752953839785163688019254276), SC_(0.01297806014924962050746054052749395335192275031009249654499208450398316755270473743782310375427945392), SC_(0.0001433066480669546035849136775836489960836794697880990317177979312965933422233405742148136310876636903) }, 
      { SC_(0.0014266110956668853759765625), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(0.009858877564329991308883488739728390399211014741475720991421523751547728058827797320375821323129338955), SC_(0.0002078599291700553329873539244636882731290660773915637313127029321907353341524640822410745581651549097), SC_(0.000207492094885482824704757642443740460150304197590148442984394293953227197142121544467231098909732548), SC_(0.009740463349430731285862949657024790252580288606138100000416830744213917289028975630150856392261576499) }, 
      { SC_(0.001478188787586987018585205078125), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(0.4735407853401678479931449081420441219501616601894238432847758331054007351467014963909698654694045242e-4), SC_(0.04228500053412282795710019090497326614927435710713059537476653916954982621681962514525157983150580291), SC_(0.0504433410350218694389860828340814225736433955029699725241195653258108640587565515363037003882693894), SC_(0.4763299535226907492120899973154375318461174268397757721287713540574208989198440358576702211662878201e-4) }, 
      { SC_(0.001493275747634470462799072265625), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(0.0008751058333752799665001455647751892487586365548725812935687119714871437227737843248890381493252933349), SC_(0.002605156629911852022968249701108827961682369773742050328886248750222868760865380712511853747352898415), SC_(0.00253370282003757099684066509895335525357001827757336396733466137791516304702560859851869912087021882), SC_(0.0008610476993096574057129679040730923411777215581061561433764610141779759591448874622460899582844639528) }, 
      { SC_(0.001531984074972569942474365234375), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(0.003465998142554625555900662292119476634339863616241175966131473050649391564632028810525614013499787062), SC_(0.0006850779254107689166834039692630317689862097433524515184293129791162755214533514454736220111776012884), SC_(0.0006801834160417256343682607004880543677877598014946213313137857753292593578692005027692203149863999207), SC_(0.003410790222941630598962971773440688510848334764410617921213390321365685842044701338039612319167151086) }, 
      { SC_(0.00154427415691316127777099609375), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(0.01090553749126714397183675519155829096111524241814946746404257095720853101809311299193217743281973707), SC_(0.0002257061712400335075204855837333040942915523856362056264045617515971247345765171046367033236029436641), SC_(0.0002239086574085424433345462033837216542975011885492657806553288473846498986763915113958373304496730641), SC_(0.01032765439313783030067965335811704147713277952764453260667157563073297864966398854739331657989794842) }, 
      { SC_(0.001552005298435688018798828125), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(0.0001620533644978919012952393122011078715844935852394571791596083164394130682618157879255082594678963378), SC_(0.01551907513330891429394715737523907320879210452543957523553168417323886797408425230290865552808061929), SC_(0.01437551749438262730135036973520654780045688118819407158510153780243683684478156454498964474725597829), SC_(0.0001607524503293982382830157314247713420904990097114066171716544693533357782691936208682765957825047142) }, 
      { SC_(0.00157981924712657928466796875), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(0.0001504006933475380548915120572871358367866244666813423739975403297627009295512256027124024949780080434), SC_(0.01736703343760202047410773340708259522791264017128435600913986142853123330682799174318499635188562615), SC_(0.01601071634146948120731943095811590045610668347742815782016647427133897733327140213826127727721582105), SC_(0.0001492294721514972035136404836815645641741811828046409558839140603163192642110885456440944259635664406) }, 
      { SC_(0.001582155935466289520263671875), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(0.0001504566672478268960907870323153716991037710884375140329815655416481705155776302870154552549813174836), SC_(0.01718505145648600424637118320317784343719547353921002332977594753927245860594689254020735002575189275), SC_(0.0162101410868439495200464815794066967186395488734264053984714099853784846012339763737462126413061859), SC_(0.0001496149157127572384963600707507254384407416017296731503728339281880926298133532449228678752842731446) }, 
      { SC_(0.0016095121391117572784423828125), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(0.0001522914153511947857235946867975694438583092011810609713109566464520076876523295923494790702022420138), SC_(0.01658799319788774090154427914309328135017237044809687200291128537144671438652582885897018161239663358), SC_(0.01737134983124913746866221000166983387418651381143987852944917783013174495380557470990504189455234591), SC_(0.0001529678487905202270143066594835321460809146548340490050365440912047177170217554405054392638712132182) }, 
      { SC_(0.0016487292014062404632568359375), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(0.01105252348163104062917045764769083663616813330880394930773720805493147988018728163048659175238349612), SC_(0.000239140749108611820032524104632560169959446550150650977367671547856179651778263935224417321322887926), SC_(0.0002408851701375959818047187721108506684465747301330425092473996282799002610302013510758738538729622331), SC_(0.01161315863871924403322930477552815841800259789591912190569077707292445990763994542627746844613967884) }, 
      { SC_(0.00166259496472775936126708984375), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(0.0001571121929074422714517234034769884390969095319361781859977416053465603708591615806423163844988144312), SC_(0.01691689168983768565381162697981677418635857970909385582721660798514232769081291328202152408394557518), SC_(0.01819519617316506993718818577052327421700816815955410190824702731224499109948124117728792167991029212), SC_(0.0001582166170828787785076684644060971480825022749609577227440712150546131648653470369417223883190437059) }, 
      { SC_(0.001727388123981654644012451171875), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(0.001008567389240741500997416837717979099268649226781399136050369325158550370767008508176483563481594559), SC_(0.002994388251855182413532325280483025467576192480443088701104774480037396850581013705707815606457519556), SC_(0.002949264791293905948941308430486799944779947075171599484814519590489201435688283160130458982173063021), SC_(0.0009996909466152114072398367622315512416687349040368804970048365321059663071378788545345866646646487913) }, 
      { SC_(0.001735631260089576244354248046875), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(0.0003453669217074619016047955448003629705812157743008392760131165739934622091151447812035666730112891873), SC_(0.009112162408671202924638527142931862890155890025680493427059956838283424152977392614399132958386711918), SC_(0.008482774504527491110326133037061875743533203749837115914905032246040291978243383754641012486257704211), SC_(0.0003404769876972207329971451770357874078640577104880156988604201111686424081304759577174013160369368964) }, 
      { SC_(0.00179820484481751918792724609375), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(0.0004110115688218799627252708253232933935271591964708675409196943466258756225729427814216046192454905822), SC_(0.008091968201655280548170845218926003228422547198847900655481112274697106291842542074301590442896304625), SC_(0.007733225172383586982131166969052850812487948482487220448103600510870375952483418293328785127109283143), SC_(0.000406768207380464317444442611962011859613844205108857952401919172022031650971362369652579376272988428) }, 
      { SC_(0.001915907836519181728363037109375), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(0.001109471732010866747060304501976706220459200406171200242262195152161816418019131666091038909189008569), SC_(0.00327455650094320190550114756828014991795076376475609075152962377813528801235896123377920242969407473), SC_(0.00331764946339401323897874487217942527829039698292624621569656895210245292329541399128342468704576688), SC_(0.001117949618054621990644914161239180655471425623281238527303716730664640251240413563145260831555467667) }, 
      { SC_(0.00195966451428830623626708984375), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(0.007118569647620113474946414681173497097630715288801469942232016221817665864177182157871557289301622071), SC_(0.0005611490058385444638494144378229119831462970381673864171653801552983236334247427053924812425416890082), SC_(0.000551550627594995407819675000127881046286712363481617603910264934341801175576632526697023102520096727), SC_(0.006701417519555523966132886782703948394415923155871747931189397993564652430041140108540665408099907693) }, 
      { SC_(0.00195981003344058990478515625), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(0.0001872235404192355339711985846832336688039040111416282021920106691778282424794686178616842968767169637), SC_(0.02238434914416615105846538447712317987509768166060714413216176333853139905239126004242116090703682306), SC_(0.01922090441596452309975080378188713821204132080868357718684817543679182174842430970292852206493629736), SC_(0.000184487936027742050389596669461715589055417303723461247975787339877577335947726231267649973574958601) }, 
      { SC_(0.0020118239335715770721435546875), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(0.0004613550663170065876534085411757398927634744611587706975108592971524718138052402295499625524619509997), SC_(0.009188175443188340301565300744669477628689342887369854575958026072943666016494738671087143836389538247), SC_(0.008534042146926434505731594090880203907757601990617842033017197056351832593167847181570517714220834107), SC_(0.0004536085163103076367810482307421662883406073419322984722185853558448394095049599657847039919701614613) }, 
      { SC_(0.00203948165290057659149169921875), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(0.0004043985858842940486523057156392832768160508551793531718844321687455532692324912307388483374530248861), SC_(0.01051322982109013075067806040426402863474356119656555069635790440484791700602633082864229693209505395), SC_(0.01013872640114819839656038308035003521837564413060251025422251631210885820136071215133639306882436006), SC_(0.0004014888097294212014118433167237553565367218373184927297515569594508798122768240818617459579337934179) }, 
      { SC_(0.002051885239779949188232421875), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(0.007106712056734232859929004289309463811830494051815327146058746454865361123365125841016782161117266385), SC_(0.0005796693287500822712217121036223525558166278987439836167402027011171038689733414112798326630788353199), SC_(0.0005853428869472806191742308760938704667564313246553374076381468309926274572653482875776879134766138745), SC_(0.007353423620977223307440874369845854361293893842214936759880181110209918885739662185244316625152777136) }, 
      { SC_(0.0020552114583551883697509765625), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(0.0004076699626404374877550207501771832020863936862869307542608498932538986045316968028385804096765317177), SC_(0.01061462524611053778648235653384676901738200482336848703208377065654067693066040889298162655174760203), SC_(0.01019830682109873960576893885290703857492391870040292933890806533294857866036736949549625661789110626), SC_(0.0004044349133677749509929370138237730071969395638153173693565510471961562479625655240597602987452488882) }, 
      { SC_(0.0021306932903826236724853515625), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(0.6870227199299201514731646057624228867747299820690680478865501191598869627743437700133150027864862925e-4), SC_(0.07400615787312898684148634145037605530008289525544811398276751195511011701036279198353976640477289565), SC_(0.05994697932020012469595127371355923709683411761463128490547574016116968114881726970408702527289256178), SC_(0.6821483905832786090172422084771790510682476612388623892830920848172137447660612927367015407061385018e-4) }, 
      { SC_(0.00224486016668379306793212890625), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(0.001296068985467225125663854876780203188136785771140631864189564044556263876823986739842225468452977125), SC_(0.003817184387588443574312549141339928531533570924179245470249104526770582289387906834615035544086587107), SC_(0.003907630197376691500596507305169972944117776346105101257187273320384951563714493143788365340541046755), SC_(0.00131386997964273194992335842520321620834016729208429022578018519613533294017254217018148648217727031) }, 
      { SC_(0.0023608789779245853424072265625), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(0.005224764872746287770485185045399017879038282255233278811135036092005287784067571552515300160583978879), SC_(0.001045369548194306626312043938645319745249152734626454288760011963646924467105535765035272968321705365), SC_(0.001058635286926974673884417898670101942016476718607869167243611010062182512647507204798182082387882362), SC_(0.005374219243648521539601265100351264756088004250450656398883847997855601127014689618265355680084932713) }, 
      { SC_(0.00238493341021239757537841796875), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(0.005414058841024210222560600074590393979678166785238037320452068830570623192814692902855013451058944267), SC_(0.001068119837501127542418844497515894143268945066060152366383140285819285716837233097823329255107654474), SC_(0.001057295840678694163611560780432133021892958891726486780664226077157729461313742754328821534064546372), SC_(0.00529210423727156603404701549257083223374533219619785045960124184330210488851447000695859751926218226) }, 
      { SC_(0.00240380945615470409393310546875), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(0.001409882805901157918801535127012175543298004297589043549478238369377975628408979167513709987686503508), SC_(0.004199656850480846833962141968868974668498229157916199725859666296413705605979234477724074326783687345), SC_(0.004072966644460681729528640038899793435082625570700318834534133245497929429130215378365379376616887641), SC_(0.001384942557473480533328075644932616403328853956694903594733003054577047099516639035238278491798799732) }, 
      { SC_(0.00245274580083787441253662109375), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(0.7891349136899068955539310194076180017831921354327080192923516783156840365794237853152727617868473452e-4), SC_(0.07921486870594835837934409589190967095656565659116210869548309811720712595427736777470429342606821128), SC_(0.07310005448254868112884068379643351651090106186341179137693894360778388814400471638703941182323860704), SC_(0.7869741513641802995041523911810910172433024235363807499100591740763972562852919762063037547869623284e-4) }, 
      { SC_(0.00252933171577751636505126953125), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(0.8176697403229846266996555559818052247312725307487871931995466375193087388597217615371536971201537311e-4), SC_(0.09596486245645832601613165324922389448241541200909795681753546187043478114424789653612903741344631286), SC_(0.06687166277723126655712653770877860947472700843533668378566018831471479452487565894471839231925399609), SC_(0.8076976155818566188200010653149334944213560145099305236844467544341042297260284973868512495922231136e-4) }, 
      { SC_(0.00259913061745464801788330078125), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(0.001520067751211551339572558495816009679672913288882670915638925799959214216233949624001915549155607752), SC_(0.004518373436744513666270709289848389247866145188543191237153696345080066531469783801325525298034473756), SC_(0.004425228466684745435015285852748977262164483960456492500063335815761430104991857878370363371656137107), SC_(0.00150173168326552212642919280547006687235028831089530128861375799288953502553634610428189579268880318) }, 
      { SC_(0.00260723219253122806549072265625), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(0.0002489101865233414701442716989412672290137679079074799140808081003051673837453106142682406816917045624), SC_(0.02954308319512612653158981438616114551204126619558100680828383098831281876526511490145298898289847989), SC_(0.02572521366743994856090903647893548239243425780262236454883034511057954011800490821490321266981802963), SC_(0.0002455935562448443356200641537673976673302727956459651108919673874189800750032523569272491602736845398) }, 
      { SC_(0.00272565521299839019775390625), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(0.01938520765072576202724597178265211687262054356203580656880757876442051696763735559633171169638282632), SC_(0.0003987956028435003361721201271586710141248235127166386070697689756487316877021409289795622103021771366), SC_(0.0003947872175884600309793906852484537103747921121072609210617831933463975585222214603098379646099954832), SC_(0.01810334279938381931128823669355197108636973690639396381283588277331401574555715816219786513729514353) }, 
      { SC_(0.00274447002448141574859619140625), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(0.006056182145129587252051872974852053158724422038147329605079457472650369722048922706308490376993996581), SC_(0.001213632446615582803058301542981651467526654640805420221241792645396979955513617661667967659216677489), SC_(0.001232270579548774859698766195055391640423388819849071341129929649908867799477870368558698415520158551), SC_(0.006266051295508174804206619137941073538417575759369688082466002379135884571498145475297696226807445655) }, 
      { SC_(0.0027546673081815242767333984375), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(0.006314170372857970195598035738085482991662205293733613893650362818380394426338529085782886044245673977), SC_(0.001239001777917300051613210339477138675364560904178188770350777185829667896050832493977993016324968082), SC_(0.001216054202747964571605837938218053226911930904709252523838331382953158058370349009989511543937151372), SC_(0.006055816399815454243329048874623880954753765013074811180870495948668386990074323428693805621437385383) }, 
      { SC_(0.0027707130648195743560791015625), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(0.000262104430290475204294819873990060066070198795712059137872310022051934006194445221571089029765575049), SC_(0.0284829023537967868027220908225985228077585734557867329113407528703829106743524682477069995182722935), SC_(0.02995829732820479477409138497931028903536921634843238608377997290628435494686947874856357861233492208), SC_(0.0002633902345461780216522843102520318126465307270884154480466209515290205674856143530439460447664217544) }, 
      { SC_(0.00279033766128122806549072265625), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(0.0006327284693754996617598174553209619156211537948962261635590581468696242087627947314699098265574271522), SC_(0.01212442468865691193319803685140885215904541008535379956716338013252106472099709363139833743517991665), SC_(0.01242000246339807173580640204852718192752101711719638390595196040211037293065701473269317997342214435), SC_(0.0006362330133689262336125012767214384405652412176309097590065325086545036369673988359423661924072254077) }, 
      { SC_(0.00280216638930141925811767578125), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(0.01873471184644263214831399372400528667778729951327181861558705985721939647574761000999541688170589151), SC_(0.0004062818099544652355815992662683225409294881481717220441280801335407607003924784105794183457577484454), SC_(0.0004095716129569350005387960022707172935315632344924709279238162401998117836699226641773248061881056227), SC_(0.01978638694199411872506318533951199432680646522644982211123961980480429087192307837552360366191522331) }, 
      { SC_(0.0028498969040811061859130859375), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(0.01786987926962185929628938564704404882124922957239158839849385425856191638101970196934422099530285818), SC_(0.0004457463375791328195820228220991629200067451831113465652186667519566533952039012365147814486258529655), SC_(0.0004481229403938996328610196613726301421502182903763890836600815409956970278157903318499060295529884435), SC_(0.0184780870607023541630008050365153949343951843331203298758901467899466557452160812937372492186995772) }, 
      { SC_(0.00288782711140811443328857421875), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(0.01772692499825995466527968010823040174872983738773370527318501734754856284724545764096875624410442287), SC_(0.0004500992902763719404747648851145663806595508928434459953090609785753693889916708101905928031715858243), SC_(0.0004556899006472704926805835534832413865657588281452094921729816570017864622753137717572893517975821741), SC_(0.01915736874454824538695657974676928729363841066577843420066477919905729656928861957250354779710725636) }, 
      { SC_(0.002994176931679248809814453125), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(0.01931551636686231859527567673968910669430062011678539805076195031053397497345362909213581776265066184), SC_(0.0004704404919143927196325103297800574494693634254826751891917705137544545866738103914835736625848682102), SC_(0.0004686800749980965671823011652807706604819460041715330759490587952799144935052643358660984492411006415), SC_(0.01886530049018224193615956894046589655407168305021311443223766754151269257790528268076592032766869205) }, 
      { SC_(0.0030127600766718387603759765625), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(0.9642152022317753636135411891420575190140961805839305281435483282867538916850529826006358902259837271e-4), SC_(0.08394157556254607512655778117320333592469559912913244580399498350761619072063917820635958023385614635), SC_(0.1052292664877069133735332012376543006343271529225817722499775716152364731174717901558872086675919346), SC_(0.9717778976186564953249784861048065926325400959866478477751439751460511970403884350076772101224355568e-4) }, 
      { SC_(0.00301908398978412151336669921875), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(0.00031758907510219221862995676915533470921465751433759260206217105555629420667326060937939058891316705), SC_(0.03254602898466956153960586197558335126181592456720088258539928912410153246745715396981520381623087147), SC_(0.02626670002911664482832527518002429480075937498962745535956132710501585282714208232688011306548657335), SC_(0.0003104188995408078327003572424026432567324576705377824495839301585816278205470332938765608621026034175) }, 
      { SC_(0.0030219941399991512298583984375), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(0.0006839643276855344270283645163363485701253589911812701245265458916819484734218649243115640313611261006), SC_(0.01302516477118017788610859433779101108262711609275261153453706281106162678718577372428226041760839953), SC_(0.01356458095992091850036601130091971134088283263388002379929520189060333082177480561866952054676410557), SC_(0.0006903652429189556915195684913787245388926887808359637951616551016100522483628744847414319729675699564) }, 
      { SC_(0.00305299810133874416351318359375), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(0.0006083969978636710117789362912703426290491014244790208883199858340278807157835215318542180353677371515), SC_(0.01614696973026614289503064543169563664448273027160980388107546081341388459710785294386659185953421263), SC_(0.01481884945825778130073800693449117343585743455802551601747283122470214147791322629862742999749477065), SC_(0.0005980403073383179035314536243269016112733232871739591492618047427118209753362387884032899816927690054) }, 
      { SC_(0.0031141326762735843658447265625), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.000610878293322511900695291319624966682812351795161455118053452353293794762711981837269684563466581295), SC_(0.01521745224691819349892909417017587242304171527932366670132341089430486098958888816373846820162703948), SC_(0.01634786415528652869052206043883371375875295846265269775123589334714398007108891997295832122176842911), SC_(0.0006196947247621228728740821259553915760236832091883181681563578892313236765558558625650154150382501207) }, 
      { SC_(0.00311936787329614162445068359375), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(0.0007043081568435755081373062629901681851335464429313542551823057381000075619648936013224183883231639624), SC_(0.01330909393881365636914883677537138035220558620058755821128248104456440855210036079489910754790751819), SC_(0.01415404204707865060921089983319914207559651593371262218267234555119030005121506838881378951709964089), SC_(0.0007143390706133690218177953375292843282989800152531278646098873676588065014423387056561628575290728824) }, 
      { SC_(0.003135732375085353851318359375), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(0.0211268391312315984155097803704270590714718415460595894942712301946251893295445438084092245991676113), SC_(0.0004959764563662260297783981974245690260870439169117967933532270199063579862292845435539728255733459551), SC_(0.0004875989725315172761120570751842438713829985590686703844211809075683642108404209055633556273588605796), SC_(0.01898496883451912386287578120142775526843614823248382486551719169856036554666304559216558977396443989) }, 
      { SC_(0.003153369762003421783447265625), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(0.01098192320768268477011043068070146831508041601056138440919582252774957190791300885963823877972753961), SC_(0.0008922771466529449040664028496179251269283143010469695145900222675547911748090362811839349949401435057), SC_(0.0008981196840788991910558995682275336299757746274004139581308607114386730651525082915921140214831983871), SC_(0.0112354122853567410181588063522092656289579265702459150620201068377967745095883099570388646320484642) }, 
      { SC_(0.00318636768497526645660400390625), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(0.007092037747383447419392354044273328113474760754763841089806980027765056744707271107444218088364606031), SC_(0.001414540068821894016648708774112695720066076520600524057157250983384544145825158282240143874997014757), SC_(0.001425078504182808341048340431940918269717165928839102184463058594025851430224344844322825559775880892), SC_(0.007210668323114678000460174907713526631386541364731883353270145939062377227700393438103716383572335648) }, 
      { SC_(0.00319944065995514392852783203125), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(0.0006376178512371612839972516126806479405071933549224774880805580281681783547604265484848020126522759045), SC_(0.0169260706401302343127659780346757686430018567123410618005967267195269428941337787166321816018841013), SC_(0.01552536289204371964171954539646318468979817554733144460952746639545900383675177480494132441113487452), SC_(0.0006266903598101507516082577986288005206650644749482114517519529392005988515506188961003464271538089257) }, 
      { SC_(0.00323307514190673828125), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(0.0003347241672218041569141818846735813181734335798902756757024117882797300175994527050203462970107371006), SC_(0.02982064799625215935374883314198754320064896591778741776447571690381294349256265562901975032561201585), SC_(0.03244076823480306683438089255200834270636592202040046014729721841335229868582225911911852839057954565), SC_(0.0003377383849700619920805955055158831704964382308083636057544104154274968913111630418807223620423371708) }, 
      { SC_(0.00331881828606128692626953125), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(0.001952263606727426646844080643859500879037523997662953323659387087407900410980404615429746417934511403), SC_(0.005827616053002127197091819685287394389318607251891499771255173386866971583088048697401991617277320409), SC_(0.005596020034590851823632254481790495449654427295744842940317654389831514281005027837391702003872077627), SC_(0.001906637696717975323983541243700381302796233092564924680349525799521163849465749652613607996727191189) }, 
      { SC_(0.0034079276956617832183837890625), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(0.02232489274741262443397457885590853844407666586092148788372689230887387006763753529911090665433486466), SC_(0.0004925497659151255048136651360235947018609501607947687371646450511680272738837804460852368957656344192), SC_(0.0004997034200973949372141354050832402269218622378013406364375267511609289914245794082021333667443501884), SC_(0.0246059377356717672548500910382603691324362638720578805019604220587111721837605019085952652072871553) }, 
      { SC_(0.00341692590154707431793212890625), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(0.0001094728927907746333953215120304560326833587512874651427250145474269853000179354157016088064553879087), SC_(0.09770186462231986751671024415151997288029053779787130373709577835108047009775894115804449042681065088), SC_(0.1149334879981090914866573418859588400964589373269625662027294967631745476278881126312156763744051644), SC_(0.0001100972864692030407171515128460508774369987925528083026731114549614509171565818803155318330441092195) }, 
      { SC_(0.00348144001327455043792724609375), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(0.0003593978110274520526206089592154128700350287442320386330636516681668884946807633352605141735970814106), SC_(0.03131371236856295330592184270401366503996284703042175087613378643159052255240398876763295168983987533), SC_(0.0359610617707342011511836217040898582026469107096791447164040569507978656998007313747506452477461326), SC_(0.0003647441404259276116950444119644750692102963602411196171887803778656788830765520203146864162755904271) }, 
      { SC_(0.00348822050727903842926025390625), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(0.01275585141826719218541663265490512741300227707035527399662791432389657228453156752139416712620645818), SC_(0.001000750499815473336280902200005439220509999458760260090859033268239648860450725256395160952399910034), SC_(0.0009799384614682634332091137196895437675321662583824351872057814735640361438807049822335504430047789778), SC_(0.01185393664899816722874549196161822196802741795226206469829412131561894139332140861651103143646604391) }, 
      { SC_(0.00350953754968941211700439453125), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(0.0008058284704345638723615605540846328243730906783149447659457867814552340837876845014059332173897147666), SC_(0.01611548937310748494212484742669976909952559612423185729268654663555018234640047617328680729671084263), SC_(0.01481104179431115717523340342150288779468464218708560285099781482903212380884969815251730469265373651), SC_(0.0007903254948234622637525333105134825109465327029843352757543766024542345301189503139171772123935265133) }, 
      { SC_(0.00361631624400615692138671875), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(0.002080184239023735482002792055673855935861896371092389474032661197751552718238643508086777169604136822), SC_(0.006110739005248383950669306439352829421097735420196674890655938061473398055828398587503306398684123191), SC_(0.006335755000794774900128431912928451459570789692124225335046604921012660333247114116976240400504909289), SC_(0.002124520451340113497636898240101707061780335609946476576884953399917054975251171541142297349618272285) }, 
      { SC_(0.0036404780112206935882568359375), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(0.0001176190162828142796919835562358368451738412776284996984226357491541201142479737741581516117146868513), SC_(0.13375109687433513233028355937577969564534232189098013422636242229127511452734023113269086024188664), SC_(0.09744974284158095352188877935330705683845912247258624885493115031112457237662766230313605563814431583), SC_(0.0001163208881819670378389987473076391469754184060045994311735363658366982673715884200927029709902036158) }, 
      { SC_(0.00371807883493602275848388671875), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(0.02468614193022871270607342842884049496465784514517844802155026485330299596567489124363919561125985557), SC_(0.0005868079025337075887954296538657033343393218180899980285094250004785306343969125457926993842882629915), SC_(0.0005794033271650021637353321245876570150511986309565485745859056936761039879406059107114927946302410459), SC_(0.02279836041760338336531354446167315872319913552655935257543506882741064385169060682929113739675759652) }, 
      { SC_(0.0037211482413113117218017578125), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(0.0001206018963412346014580711495519039062312204520217402039072940650374111522739657760598365865174449545), SC_(0.1532830212093457144850631377033191871582991329996181592238131314430630989871588013717791560832019151), SC_(0.09308045347748283560586661646669308932922096162216609626734055443748417919289669514332833391914478182), SC_(0.0001185301498298987121625676887178156998754857185468017043955725530198932241469816417273597061702649087) }, 
      { SC_(0.00375685817562043666839599609375), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(0.0007361246479805081800904282635252534121057612205513917713934295691275921249144388954258087706961243164), SC_(0.0182591254502963388181167707814056911629621235294640727653357873481865519582458765100300428217484715), SC_(0.01983661816300623051034273396582372485234644437199610619780943033218568271197450725921151480975607977), SC_(0.0007484530875816556755608967318503544556569242217968724089022798741632429907961676207081151000279151001) }, 
      { SC_(0.003864402882754802703857421875), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(0.000398737135363371131796201231241977337745101869577512163984707029708975738907702417703668949324946984), SC_(0.03461228651027143175734397498367676907185252182441368714347793940002534169959834210711583630906519019), SC_(0.0401029795331966720958054601152191822443256906600227828047180869302026230462933995695120012539394022), SC_(0.0004050679971412699851665671517481397677597593315107915165247988125373442459223964779688758339882087361) }, 
      { SC_(0.0038819736801087856292724609375), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(0.02390414495543709914383675889292610600060281319628293079268649415434303468278817911169845228709311604), SC_(0.0006053745653404944483856633187152979893021755563125674461591733710648857082056520266042101358563737225), SC_(0.0006122365604067884676138035323451249429526896677387886807175698781547692471487119142744186107407136841), SC_(0.02565208843635257456163994938290390240617487768092878858164130615863406127063049464742981357232558574) }, 
      { SC_(0.0039926064200699329376220703125), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.000375584714498191206445422207948705425139896229703232728597170610019465854898345666548341006742642778), SC_(0.03889838313331470932893435581711608915252211730608495694799098268582336707100116273875476775892413014), SC_(0.04586869426123557695170032102179290116042335334629739940377913677030286554937370955754171004496920643), SC_(0.0003816953220928993363207438927229411164872738111054462153457569864167164363362141076992714679297743105) }, 
      { SC_(0.00399976409971714019775390625), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(0.02675157710999086872516739040612296103390359550452774747162265103027615404881776703843582201932630538), SC_(0.0006319809233457020850924984445278219185555061114936908742079127729647897442676629231613571786042988956), SC_(0.0006226017269530103839941922677320570896173066199854304610172183312044398218746235258283155481055379519), SC_(0.02436286367913812323328967428500426684722115773700129637696446239960116704659118990171926494654849509) }, 
      { SC_(0.0040496853180229663848876953125), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(0.02871370049870523378772009649487724613361662578853574971698483754975500855345802627078381605355830338), SC_(0.0006454037292007677589808944001170232672622210325702650965063953294552931206342695716005731997878584997), SC_(0.0006250461496238079357763624508112208426821720537656844191040241130984824244803367378696567932477611825), SC_(0.02350765370657507793336223731216544336874569926140598416137264520520731436280648418156084386229106656) }, 
      { SC_(0.004099641926586627960205078125), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(0.0008121268552233394388696207283878958448077052219208639638888825387013057035003856697366189457662519581), SC_(0.0210225196560526573314809410853452106280732971683039302620545622142027252670870036051333330815481645), SC_(0.02047310802809249649555777733951725994202093072744679110207536994298988566975586684224572535600289925), SC_(0.0008078269489589894446940592209128735678507667505462768319697329437430596461455017941987211674816946285) }, 
      { SC_(0.00417713820934295654296875), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(0.01420533792476112029780472751021414018073260293344462319529739556311233888392629435368548577089680437), SC_(0.001173734135199743591029873118431741075914972049889287638098256804326652074607601874203485531940220424), SC_(0.001198137642100826248039201393860175588490538293326377857170215026065984329474853933805946163270155394), SC_(0.01526143704929164816304737644832228140398757396254513330167322385814984247472574685118098751034673765) }, 
      { SC_(0.00420027412474155426025390625), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(0.0004010321344370415499008329910999874946318741408664075550749617886126057069156606356686924401939346321), SC_(0.0475503598466156434352391054021083061337531494979756041314863400371146349150990835319290756542079804), SC_(0.04140347128231742774123750396091372861616329481375711247039766688970655999374370861962095172098593129), SC_(0.0003956254281546922252217349272485982683626456823973041423348406755725497087590827516138878617553438228) }, 
      { SC_(0.00420844554901123046875), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(0.02881251515529661433168928288222623801512241277204114163761279338776193261419249446181370896959874273), SC_(0.0006672970021797166588719848514814483434962873846207642293817895179300307716578335128796849061486458011), SC_(0.0006528128467069563925709636085858137549434762391767841438862673883728734571717775577408647293226865679), SC_(0.02512251235372927576301814224361794801367716192456082171248515928671559631015414720623785319893131072) }, 
      { SC_(0.0042692129500210285186767578125), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(0.0004058772245405687063147437538036641128767589264227195980321835286764011206316939476804627466642511993), SC_(0.04614445525127272249496322301398686848111425269006187223422860401788792307267994740805200585123254817), SC_(0.04382675494033614637950036523711367566574131959943345690825654813739248572736797783165480040798901192), SC_(0.0004038307568683789516112548826483292635753351775345331248441455803326256386213326326401403860494376839) }, 
      { SC_(0.004290419630706310272216796875), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(0.0001399632387238186693974065640202984714003641883129084131214699035582115165207636132668161833708337585), SC_(0.2329576814808180601070191736184727838061560375778227144831617636262622812289328544369947592280903671), SC_(0.09512513101186267981408388533697905854961902332098868513716567265781652792344650363680482180237388637), SC_(0.0001357854679419984990438280323876903548444110387321117690193944538269367096057078850210601298048910038) }, 
      { SC_(0.004303268156945705413818359375), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(0.02877657075069992431389253436396661818001976135278651268543550869250671648616964734991656499518677752), SC_(0.0006239677435767832684629685015485333448077419986136404248041959632050483686790508125498922925760795788), SC_(0.0006289430603993545807288619281641392846856408469327525341393636739838486508502048315942520082343193813), SC_(0.03035482540141414417440173291266326655987121507326131535090310310238307643142224907882085247524360209) }, 
      { SC_(0.004412124864757061004638671875), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(0.03293260790277727842014326233360748855180404848011589805704590596553579922008088940312631284820468429), SC_(0.0006499816767973958540640653871018992270531217589503619960646235756787915158494428283814767878372823181), SC_(0.0006347542286513792579128488775533547016356852794060922079182281536262677044377018358642877754400583572), SC_(0.0280894445322034125210053324809348503691162082439563265987433762768004925165962422224803778268298313) }, 
      { SC_(0.0044178036041557788848876953125), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(0.0004576364689404675874944607214646443946549065385935513604214765805537777225103129176430575376323068001), SC_(0.04093505227633406281295032181323281835840126174222596878922661342362018033841408177756276275969052628), SC_(0.04404365729567804311466111364282457110484580128604492813194581920777014357168428777310237455424637464), SC_(0.0004612466567768787819418244432219985879075389519186355642594091321748388169182073187712197277150328497) }, 
      { SC_(0.0044235005043447017669677734375), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(0.001013949141443466750007202231102368046601735520053278767451887440850508707842408630781470099847663816), SC_(0.02015132527374030499063827691120709249662764494575937094400010376284732914285415090873108484130799965), SC_(0.01879934298307449367261882729581193430519321137560585178723836220040271300991192022614633346372740424), SC_(0.0009978395162250639346505611753579163015319371078446367410150108734671735628848230346219357749453519183) }, 
      { SC_(0.0044507128186523914337158203125), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(0.001001515164087838812320997239080574287733511241854421746080219661053269416327501947673198242298683806), SC_(0.01872404071198721134182136335189499753526874443368165205781970756861388484643719564480918545110425511), SC_(0.02050447801546347089426205825796743939166598403415275591678374352542414105377441000254261697403755105), SC_(0.001022727706104920473798484883540462952379728071239865982922320048417290833868637017442635681731133386) }, 
      { SC_(0.0044747791253030300140380859375), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(0.03237218292240737285729654499967178010843033868968340636585369287552337891134093715277825972861571462), SC_(0.0006563725227377736018251066808464873307684854253238905488903791774924122837942895348774211969677212822), SC_(0.0006465196689743171131972823225329246352208504560325682212049499753454265845356920538192681042322288911), SC_(0.02924646751230102154104103688868645296590948967227170385281734013702174939457725568389343122325630189) }, 
      { SC_(0.0044771688990294933319091796875), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(0.01651622445659130722816745475605178282734133770301329803848653730106193309004538279478478224294625723), SC_(0.001287642717481076413220941803711125510257838294198747423186214402152632647389668435486856244214636192), SC_(0.001254732774131969712174284802781025909305662489133095607374668717783163650005882000835541548591854595), SC_(0.01509279408902183807061433983588664332439251233537968932582783515632267623431579084714206077116151031) }, 
      { SC_(0.0046425904147326946258544921875), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(0.01691967600604988111238526966795147993298016583459780661636317275796527475024312946295010242009189473), SC_(0.001330752239470408492127062844944419128700721230449627521999961882785927595605888790971907277968899417), SC_(0.001305391564688661412545903237482637453732564679348385154155250551437031231675120508392136690153717797), SC_(0.01582325795073697647583540154148254750338380410811935378076878125871172316045916757222805059984571776) }, 
      { SC_(0.0046503101475536823272705078125), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(0.01024373235576927796817875458437496953006478189786434407424928954091831303979265083736168764095499883), SC_(0.002054795250952058226632120794345581115473346362742725097995408785938037028464550203907911936199869866), SC_(0.002089700282245997272078401426468990369233180489480501425781500006856301337540029827500632399269394954), SC_(0.01063587629335489797662773909327137996938082248280470233218135022450416628629678160899621604409534422) }, 
      { SC_(0.00465334951877593994140625), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(0.0009129851917489685092132302014928177755489952703848921847629376981141677457822385324456228147657306575), SC_(0.02275651791106777942982442698706570247416463027554541958189487018886721679090845770667499814353906919), SC_(0.0243953472771326312876583125227383959721616601717665787102078030358681778313419509827563774546875153), SC_(0.0009258343331131238265616647311444164166029345176013346840270801074276982007425115351614461546807586858) }, 
      { SC_(0.0047099716030061244964599609375), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(0.02819890377004604864695152531103667336448259522604494827062373771866775954172475279450708275555791503), SC_(0.0007309892519231042362386066656146820862855926091170663072809026177198870267804040248575062326041027083), SC_(0.0007464316460093945003963377336700983383641524409999891295678453880018526862486603296820523886479544828), SC_(0.03212352570359733843566396936576341805769994596255538968588717794982501615523202451637291585366741375) }, 
      { SC_(0.0048475922085344791412353515625), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(0.01727499741971682195807353286707968014925033131537771723708768081857936465891946213206716902840845598), SC_(0.001380805980963717390445595254854897231228998803873342115815256087349876211004974755538149548935210914), SC_(0.001371553329170824481646108234491483539683989666855997171405308569764307227149013453372943286767035837), SC_(0.01687518491845671307600993794708933219084504207901010289236096008801176283575989097548649617118706066) }, 
      { SC_(0.0049080080352723598480224609375), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(0.0005119155148766558099753932997207878442934543315924047852632484386438932579281671895854628350427706521), SC_(0.04843711624190700826613115658268010355553857835171237829800151770580834534176853288643946188189435725), SC_(0.04587457126249629049661837285260402278132388402815335773545277771742733042995786595414521677277265107), SC_(0.0005089260938491112624514261052036212360477898760017818122876038091362480282231976656573663299469029234) }, 
      { SC_(0.0049197026528418064117431640625), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(0.0111356525735984252584750522524504909244577860652630918762834290403184918352769188555425846854414403), SC_(0.002200601458732039152192708974625387460380357074449716775816119361555242025429801673881414412694579516), SC_(0.002183769825239864423766759852296831604914006219191074315121728441996698503779613069228721789537669723), SC_(0.01094660606290030737803158484392282900145309766936023174656609476278387183714987503776043552837755811) }, 
      { SC_(0.0049294424243271350860595703125), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(0.001131923796328531714113045421649982168095956708597940508742518139922546737751509001098736885969382245), SC_(0.02263312566179686641827607009844624721787139446027838141394814487832094659829223748291775376018365899), SC_(0.02079834586945544652736362162911352126713628861831554042298747182641182444306464959028024803318247814), SC_(0.001110032069108768540276527647286190976358379482142549013990644068364628168727478358682584223227917011) }, 
      { SC_(0.0049535180442035198211669921875), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.0001576656979820959167348648635540726479184180616888719730157136871438366330324369855085527445586819828), SC_(0.1218672878265076218866710105133962810452115653865605075193175343828622993331317284642847469213617119), SC_(0.2060867448978263951680718789244824634590272371358456139135133957518085315972311822225662118300732395), SC_(0.0001606682459654409092269843518990005862401434209588742958589661960710366879012652326900108181713635946) }, 
      { SC_(0.0049845390021800994873046875), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(0.002879239394510544667782484458281546813417547279605187329396415430214537562027050290440444682068537255), SC_(0.008482647024313575035553797342157762283974067020775076426001124788871732862987373008927816364164858631), SC_(0.008668814839858442687930462716923175237948229852199355536315545713988303119299497412783662215227999457), SC_(0.002915955995126560664875650661124036862292715806402692252904398832439823913185250267727315445185323897) }, 
      { SC_(0.010616137646138668060302734375), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(0.002112023508321281487578779946326657131473183644009861173457282010607555772016054591925455304923035268), SC_(0.05547399626405179434248429230156671430174134216926147685526350934067080375133657083174702096946096507), SC_(0.05190332151584308655572214778843534006617701733935871639388508976381230060077850308044155901906361843), SC_(0.002083342654981698038570427212854277495977145705618843594426452145804185560985768691227067507206502993) }, 
      { SC_(0.0113307423889636993408203125), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(0.001151910141343384713992684229201654765554206266428984183831296629954770014707408100448631630512616816), SC_(0.09043103445522207002378632712034048966620920634977149862822615428634650889829669058245369402646694942), SC_(0.1360638508609459150330336133469524851665593429198623321389314512737193852162148145970571983447220557), SC_(0.001205994435297884161896539092049135089872305189168448474687901118529910132850675409903219709318070895) }, 
      { SC_(0.0117209516465663909912109375), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(0.001119322680684044376722905520824944903173669466309560984209987407478600859938609282465179516401361831), SC_(0.1309963531331121907080760638804231471122823591973164490011172427462664297305255825947726210722446679), SC_(0.1148507487768494138122361474429976941671133464170624600403309702874562342171108752352550369570320251), SC_(0.001103982387272425043140188868059123586042882610006900817183220523479502515500372213041441893423361038) }, 
      { SC_(0.011917770840227603912353515625), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(0.001209045763118627825094678783122378982531794836697894580724272254249938327498593200677182232417485351), SC_(0.09373742801389498256206197843295275110179124553045392965206589463425981683031860220827466182450255403), SC_(0.146354062128223726572964062014965256121117993519397018911137044724308029837867074180968617890663905), SC_(0.001271247480468386779638107444153749251904396780554583845603248471632393812238952687789874595616144795) }, 
      { SC_(0.0119861774146556854248046875), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(0.03838127998149145129872170872019569672845032814205014234849938639771012950827014449605209047768508894), SC_(0.003305808330954805489614176526750032202565708773117506704521826306506211320448683133349866483780208146), SC_(0.003505225489079338818655307085872339633947380420080482137232980221992833329966149690627730532294263447), SC_(0.04690233280016794288296583978505569647549457793926147319853139500576861045500348806111796121365529247) }, 
      { SC_(0.012126102112233638763427734375), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(0.02777875767986249374485705560362618428319320612824682970586211621675628581616231764561739576441952956), SC_(0.005454857898478912728625263688067011434798309221857603238942010831967565727852796014053322265294398356), SC_(0.005353324906580887321530705589136488165553613721901261397478241447114491100364465746130819944903371805), SC_(0.02664963873398616021924175384676688651777322777767011915720115200228752932657731156725903605784073843) }, 
      { SC_(0.012391182594001293182373046875), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(0.001162534557609169772592513980152295159211310562832811346696880892313199710315607607459777747928822702), SC_(0.1173065505246238218759358810041850064084340249766154516851590505880838921246321227513010559918647335), SC_(0.1441559493855170854200478279160785085654823152503246752353747738575547086941622209733702314263373458), SC_(0.001188065127553673120288963891661484320052833128527314996190195703374723814157033398415997404811062639) }, 
      { SC_(0.013245030306279659271240234375), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(0.001297973002800871118280059452868439283950211672744006536652437125165102163363198158348505151619959631), SC_(0.2000067116563888510956450570467300230659532393808729083618787221402451205789970230586191431739808275), SC_(0.1069199931544777127482838195779759389663501647437765611697271399112502124201369022526735135454944768), SC_(0.00121649612461961028605021786667832490574537004927224024227061809230381980801142228668594118215805948) }, 
      { SC_(0.013858181424438953399658203125), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(0.001289898506631192168146973791002865185455682969400798428054134596894116082720155763098723095564235867), SC_(0.1229925314229710051302962484901241593526726042689880166866199345084593367320466694972397986487820972), SC_(0.1755194971730264558214570786473797072475819344696540352410265380810162581278639024618515238514938677), SC_(0.001339566350478553874990697962950679921040112781618515003893445108293921361623714806464932925526930816) }, 
      { SC_(0.01432247646152973175048828125), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(0.1372140714911115706030304052623633728809317606531530236662601516193444446922147054783942197191100004), SC_(0.002378151740108463913377813259256240003027844378312138092851925670724413199797191343653302324394253102), SC_(0.002126215445042360048756129183203300658175076199570434962114028242948491544708561738350240196485323362), SC_(0.06910170070502194140713924344439795054451883382190756098610629835759939873698956510745021074854737447) }, 
      { SC_(0.0144481100142002105712890625), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.001331571932050110282552710598444131709860106321376519797816609419098273406597735609995925051657010064), SC_(0.1193330210624601257949431964584092036469747887956239035748749472616078463139455490593791161137998202), SC_(0.2065766870448660287010206537310455389530994419603458670042081630308838745559718560696694769488955657), SC_(0.001410902469955384158130773377937000581918429375190762493770926346484438708027853772034715084086434293) }, 
      { SC_(0.0151938609778881072998046875), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(0.003551702135618542765992031581724484209941322906146581336873982910834420123554184358065804110535478937), SC_(0.07527628883216611963959364828844091361846145942105444909913173401690044606241043452863102276749035856), SC_(0.05989659649686985949843518683549841703205229331205398548862486071561160227194679467960357270164584599), SC_(0.003363432129330754003507390364983384248754985683414217292653217437739827150209877958981619536429222648) }, 
      { SC_(0.0152789317071437835693359375), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(0.09581376427477749518500718399935351567110915437751486401420343746505465030167900950882716285491320677), SC_(0.002193862475152359088844471358975990104649668494433815445460831050269288456109181709571414939516972618), SC_(0.002256047694668280177473148802158738386573331569016293988175747603555315722589868565209198731631924537), SC_(0.1143574831341657640326619709378027277770520653424173168907512346309198510885389472559570034510074822) }, 
      { SC_(0.0165148861706256866455078125), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.0005145816851960784695468784306893290903101432804648440742223389685171809172455354187186950553524625066), SC_(0.2914647358520523261562725119109108019284778149341213523493016690503925921376975712674541174647834819), SC_(1.058684485624552169538441537169542706529703753476825571923859964633744371818189270379681812969757968), SC_(0.0005476589503878475944540127115327223970119983393798626883349308823364303846738489097262594627341807151) }, 
      { SC_(0.0167596004903316497802734375), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(0.1388242105123624353777075527805218219080441071465965968078579921805445421218704271026963589809747023), SC_(0.002510243749100574418410823834347499689858700199939593137346529456586773569494826757485183050591675637), SC_(0.002373413885609438776718688135000173425523576907245677015912518795943994867623267400239613983548188966), SC_(0.09743994742882585811010137710250059594099756620983924545238461522374975691569540201162490803724362945) }, 
      { SC_(0.01734044589102268218994140625), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(0.1640407637785896270638160631135308086194321967549615821956199068691082855376325828926151576335959281), SC_(0.002640606449099242103713781348638401181390333866092790858400463762618492019806153920663824646385045611), SC_(0.002417158046777019773375338143842504444597868485850624945564490379588684582128157771489074639969539654), SC_(0.09330658328398850924231502748469417666382169111485901948906652079336797201032752560902305909315063516) }, 
      { SC_(0.01755820028483867645263671875), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(0.003589485652671322884931490057760785480815606176488057313638291348014464437307013313873922053616137227), SC_(0.1053008250155263766192768910776764556776040130629251881684642743255567906516739187309358764473086328), SC_(0.0765266459796313905092675103765873598129329602736607839369762351514147868275614861887858390647194188), SC_(0.003356530831910971488568663705900760970277530829112985298258157467712053059150169223933957208229067558) }, 
      { SC_(0.018412075936794281005859375), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(0.03852497668826396318107703708513028717193054527461341587128767965347302804947990869757971602330551041), SC_(0.007943910634451456024527056085405933472285813350189894097424687619055425868329422198658050557917983027), SC_(0.008483640200561196599930113728908808248807520999319721070256785402699616408886962690698146966419290373), SC_(0.04449015389324653702120373740297664064531593376707116632040443913951272128838162674970863697765113616) }, 
      { SC_(0.01893679797649383544921875), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(0.0005941056125949009923100335456190882993178090905788611293208068141382249893748732270940963548640733784), SC_(0.3607213254069625898295593664578571009068865141097548062302644531741270789301000598286582458215777153), SC_(0.8946384478601655296612058742980993665292853019651580863486410128074429885149745454550066086600214468), SC_(0.0006236413372225641906860502296868167362581710730446370983658058684640195532108085951376892109969442133) }, 
      { SC_(0.01939119584858417510986328125), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(0.1421224522338530605427667504914786561536175974094020090732735611824034583846897200072509469615850975), SC_(0.002857494255285400355127118286741356787680485600043076658661383826740480983411698059034429681980749922), SC_(0.002790466090724389385683922469399353791154404067037157973473347718584207246043964323394395365168820716), SC_(0.1227668395283908208052777327391205344831777346841882602649120123143942176081927764050038058703219411) }, 
      { SC_(0.0196676515042781829833984375), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(0.01101225285386242979479731177233329436739739751210045561681884417500612867995777192244599296431762092), SC_(0.03176615508599503758310878047792979993708449649050512211657735408847827114652639797740557591126724525), SC_(0.03616029071517966865461620414152070024146481963997273997093824190315121884530230087334761746078266594), SC_(0.01188847770438372940087578016255250719073080754777660295152237310317859237032074780634709020864205999) }, 
      { SC_(0.019913904368877410888671875), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(0.0006158138515870745199402058453585301535690117830813117070809288133549519045620871526659948735441764714), SC_(0.3225928715092053912503435714712253490902592560967639590882583496761590968436424258153958181847136065), SC_(1.418228381212478609595436442400552050954062530778966940472883632293768309510907342329038498539864849), SC_(0.0006657108688131401238596419682401943806322583801231575936479002230515007951428429538988839476625210879) }, 
      { SC_(0.02033183537423610687255859375), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(0.0502619756977379227368029805323177462745204324642235705857336725422245802552305658937435316224287307), SC_(0.00946284333710422093991758395604269229761720072901778606362533592785638088044580906023753359508653729), SC_(0.008690277608166491707232456388268898677214592074949389460402573687554006931541585161397472051024758495), SC_(0.04172657358567874607647899949346800786545701444901861141032431760713474179419693066846550165570931848) }, 
      { SC_(0.02091011963784694671630859375), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(0.004609240243900981846193833658030160575176447016643479364501273132976143442940660866133994916253497129), SC_(0.081066285899794593589286920572981891527321278385244740992852671560503053154161376316645705279018668), SC_(0.1052644654619323104943364866349924338309725843348520176178268260978114579934145154135570348245696861), SC_(0.004911077131452255880078727294095255378162007571076627393525095050260820240567309694907654559384031592) }, 
      { SC_(0.0215121991932392120361328125), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(0.05403251681846242687736981033631862929741988253529052656775078067239043960516885723945700712061289122), SC_(0.01008192844736101354506800983889402007406324053977279658758747296788553642239369552527752876952284446), SC_(0.009136158315162736840092410157945403102429732886229154083294446557994345170233610574682843737511759853), SC_(0.04357963142587144642022386585570706127446946422352738582203435103635517877666935660030353025191384743) }, 
      { SC_(0.0218528322875499725341796875), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(0.09017316369521818953551228041860684984896143381700029427576618645445020557605740492032143214193298608), SC_(0.006492938465181155471968431423133901944612515059061820532253562004230261785361522650110881087736054693), SC_(0.005939627553356763510782969337912161244084037701022527356378047930821547329620248306059154539686370468), SC_(0.06692227764208166339640610250585876484059980274648383237332759224606032238369455048814989328700893042) }, 
      { SC_(0.02207309193909168243408203125), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(0.004774959069469925388382248845521203745949174107447543212149596658838397716605972061871583239604101645), SC_(0.08018428477292062924473296231739048918274020558545574229602300298873105493894283470040937417175269019), SC_(0.1222925321673624544429904158289521157889062677060659756095259769565456824179590240521918822753771596), SC_(0.005288696595934619440415414148344862768562324104613626648172169433724121649878172098543568520042725151) }, 
      { SC_(0.02214455790817737579345703125), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(0.05910378166699715379231111698957062485184135150890211681654693248938322364200739717086772670245085726), SC_(0.01064473933321484525291456973646339706587016497044767067618495313053956769825146163032814338178297765), SC_(0.009190966920541765427831040967687010674529396907466714329924441850153059102465333007497545855243545084), SC_(0.04287707799267004307940596946906553750607782282307801507399251087731461434456513600215207883724524158) }, 
      { SC_(0.02225398086011409759521484375), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(0.3140345925765806329800351071205836311614644078577593204692615696960014255360678626185717438026913579), SC_(0.003537659663389931578792346853823415843931504538522376789760987790004031873931336255790637322068615094), SC_(0.002982173630883867911357543886673398441321702748891476129482994581448654212493489319635849159627699254), SC_(0.1016133269206466884666525906420047424252194383658120411039133511663604917309154698588787907010503448) }, 
      { SC_(0.02250031940639019012451171875), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(0.0007507339112044250499748993251615590217005934004298441621534080931884597697916500612480538254788877639), SC_(1.347347345295463469134771067462478083375509272678347922688002666649310286155687915955880303753576755), SC_(0.3704042385898502383956125040349704546258364180600608362810430083338403834183958126999569027653483105), SC_(0.0006971952309695862794046441494391461631117726496950438677228894345646695871695174003034148005091491894) }, 
      { SC_(0.0229004286229610443115234375), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(0.005288101065074893748384709688162272679709437977695805721116554840449898381423061473817891846698081354), SC_(0.1065601621849043230137865541521560456658036127405513335823148701484904868821341572608209506513860809), SC_(0.09433260573901814150894577086600431190973302115031746517657120542903575524814593748621701680997602606), SC_(0.005132254780639389078051218570880541295308295002025573088103066605004895372578853125779595768708821397) }, 
      { SC_(0.02350877784192562103271484375), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(0.07002672354413696112508557059593286963233794269369147987168012525608501046327645986542012604843500413), SC_(0.006328219095783399844421211829641109227489389677446534137329255386673034071582822278386630233822983827), SC_(0.007058532504938449855345980335605467196781396490887626120523142835505653643706089919087070654563524739), SC_(0.1008776687831422729251911685356435817384985410421438352831095623879792141056486602082053474433945655) }, 
      { SC_(0.02375358156859874725341796875), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(0.005130372158707232393661309004066194586265569030743610991993481070130656259106123801641925921476589368), SC_(0.08581596961835884442180403025493769155909949698488543554699459928516277782514237344359634179371849737), SC_(0.1324242846256142873892287367176175027627996986354723103972031000991337872370600023496816392954958688), SC_(0.005701655366526250763753414786850942907269775320516286368068453624531770763113716576479924567581747788) }, 
      { SC_(0.02375719137489795684814453125), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(0.06372120133503982376020558287319339893160195070871964896953449489580183283033231791494522764393855797), SC_(0.01144645015190361422014819856490650437932077894220964055772938004797293122911355082098403023885466845), SC_(0.009840741255147564620788231484075257763735688141776133629007976855247333096313159244905997619114330657), SC_(0.04582142016967750150138613988387715493574416897301404274524167004853662074423992934639601946785996181) }, 
      { SC_(0.024126343429088592529296875), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(0.08947916045245299273215810535651273041514810938600198521000715116141068318521792690376030586180348904), SC_(0.006966241573198924545767333381043209974117124263887001797213162569719341826604454221389420412041725569), SC_(0.006740769396263917270688799873226800291444695670686439867154878540719962219643293246094823370655505331), SC_(0.08023945024405955185937015135747674395323548410120240474400162836571062448845929982491359490134085977) }, 
      { SC_(0.0244344286620616912841796875), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(0.002788880026879036925622409933881986717452721422038577751729770566924670686538782252113278770325694296), SC_(0.7149357872093885069719122642387208548802758327341235949254527133528664349255625842235675216781502168), SC_(0.137787542557768044425251045080272362465189652839695447871988511494674289158927493247129587537275299), SC_(0.002328382092204826982575166772383358181154254927065748092143900047025833148980792013679309141209834614) }, 
      { SC_(0.02473938465118408203125), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(0.1131457356866582782678369721560935341754147118572819468434454129359342198382097684128593878317446491), SC_(0.007548809136849245799383678720678709084135128866758613562239283203823804454983078750584095737030387455), SC_(0.006562292628346543347507469650167703650973097321117033356309873172374818427752910338892467693860080755), SC_(0.07078034191922688050613029589888073055731817330090376838004263830861249277917517708432565487031402387) }, 
      { SC_(0.02476987056434154510498046875), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(0.004644454484357400101255291664427589349758840756135053284818376740557877785957451994400258610311661525), SC_(0.1001916581977313085090636698104319677753737512060477984570983361986969589180619707894849007349831559), SC_(0.165283142794613609032479291996623444883788407158262116871475285509527941097453753533497407350112386), SC_(0.005170932300018973038845080732870326983308707979365033993123411096307679619662434359448017744419721997) }, 
      { SC_(0.02514001913368701934814453125), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(0.000839486380207278125800957659845770799478904220338350124948970617085773325091272544979307669493020543), SC_(1.393333631178966777749389491366973331762689893955119411480458254292817281518308025159879063229063961), SC_(0.4093486799508905093612929591506528742520967682846743994636333333222442184861522136186194217097599142), SC_(0.0007785339018770595380705305669283536228350385449364860130700157233151973836129978887508455479125807915) }, 
      { SC_(0.02517675422132015228271484375), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(0.0008579887756176109617043185243969359999424438521548133832834163792969084980330439523430100680447035179), SC_(2.442439848372919779668994445395510741986032738145232239313806311731334985075609002238780222386032837), SC_(0.3454996252128440621292565977307336512481735899164092544575038981398036095616881556757543017823412129), SC_(0.0007647257113765459743246905080367095467593649615775772798398082447138321125144043862149620332091952887) }, 
      { SC_(0.02542841993272304534912109375), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(0.2517249441969383041501235382489129732118984385574208311807932827527150404128788583905922584826062248), SC_(0.004263122860197314478019210184366268747635868511739287317775536751955014570520397559419993364341077604), SC_(0.003743703802686832524259193840992488603262477336067126299414022235047232486258570571327977083927130109), SC_(0.1184569034168601298868036176344884634317728906437541915383396856163171287113380668218846871500935292) }, 
      { SC_(0.0255895517766475677490234375), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(0.07926091648291024577683869782691236073130431936019576425008651906654200624615972315320983223228349476), SC_(0.006984138117773679666426420039061706423095533328371419617989978609994860594592411295241623492474860472), SC_(0.007571786946769201904138897381797057225467969041757711677251246708587172416843573962159335837740274678), SC_(0.1035684605182080744848584043922513059111377850580132431833735778043527606468276914412961071129282158) }, 
      { SC_(0.02574359439313411712646484375), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(0.0786951674158526799172926395560260812732831471095963650492273966011488133867087758849646353089918269), SC_(0.01306136206310969994314241633475619701543997052886144775708086137016616036063247726571368116204868267), SC_(0.0102028043018070703913007752777219906088666507805276859860731464364197835463731223228610021766618424), SC_(0.04574544959241313334646275719995251588094652585438349779689309066228115969088806177066975068263899277) }, 
      { SC_(0.026156485080718994140625), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(0.004977245873620174281567066797008850840998598022215944109225659842879662427656205057003205159659328994), SC_(0.1116907174063995728317635980614223832408450655619071674665183311032742979714241329957038219781155461), SC_(0.1591528732180754601877152469638586487763897786525368309537485407458179332048451265588436944010199161), SC_(0.005376227785300201063195295968050055781066478344400659700142143376843502826965121244860505838298762756) }, 
      { SC_(0.0261992551386356353759765625), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(0.002768507703196894882209492933420982505294652055016908958996293335672953763145688831533542833495197839), SC_(0.2759419078316806997229840807156574040599241086404966392171130786181531800109544263574058810447491574), SC_(0.2176061013273731817056945775550888827644616206808367467867337675512716120775904005826417599487835205), SC_(0.002684621853535589212298172576357510898966754506052163526758295631798703073707435476872158074750793005) }, 
      { SC_(0.026690684258937835693359375), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(0.135503999553429010618478223648124849511234408323048557782311939503048237453578732594905447599088962), SC_(0.003674032023439464211597714076124620690543821833790609617982112900699980326470174689011994638120828467), SC_(0.004121875179188232511426887594234328395010053129548179363259212842507408722770236902507877429370817722), SC_(0.2729972006826442551322209338943898221076463950639993026542911808671054501584714960139718712909986131) }, 
      { SC_(0.02740982733666896820068359375), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(0.0008617561206547490224417154693155757741508352777069575979294452920224626522224834240735047372042343103), SC_(0.519918403319124309022327084951344494386587461361552435537778742388905521187136687582583287421479238), SC_(1.018295416007988075317065148546815398705875438331882613116810302336396929619911452576359370367197773), SC_(0.0009012832990178408337866583925052848860649324764853151302033701079068006022318298575876969110198050632) }, 
      { SC_(0.02743434347212314605712890625), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(0.005858057605116539835882346194458928566255948998268873070578915176035656837779297272455468679491653736), SC_(0.2093033790372794682794046268326295432722186585787305807216121981210312967735778204412312401151785863), SC_(0.103337847332142257004527154726416027730891166511222475559606778209195203554560134077572230668239177), SC_(0.005039194007429733825470393171980328514433361731558915781833951402114854165900674533671382981351854516) }, 
      { SC_(0.0278713516891002655029296875), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(0.00284049287599803010278320801160542703605708967194278756603835105023100739438161567304595237461799669), SC_(0.6297004798806324526619089287910565168464590439762739946384032442144028349491237271312948007876467646), SC_(0.1824116183408740992594899505448771653532699340687105473308322539927734864890056942393368423874972808), SC_(0.00246919238599822926317759735135174552587997684074050986357064415193340480690348473419096431459918439) }, 
      { SC_(0.02803694643080234527587890625), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(0.002782809174473135344263483676684655836046035587167170598881951477151851503205326449216257132516988548), SC_(0.4403183993669007263402159683152932591766985379003029199127418828321319441584679550157263212494836704), SC_(0.2092729178501225479206211823819091348637754538667294750476236872869057670545728099873124812242972683), SC_(0.002546180511008799512908366403617467059373775362308342445231767097134085806539057952571764480445351692) }, 
      { SC_(0.02833987772464752197265625), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(0.3026032275298495229891040831718741113706710169753121391873097853086319882620090362134567796331190333), SC_(0.004802423266713908287308636342235706517391488430248186125384052198996304015074334600949547782124008943), SC_(0.004132453993618890679182978393980120229572664830564238811370400367823100956761108757331459198585500683), SC_(0.1271719378753392132313631705185974686048279952228403464975381274587428330090658879040379158806556518) }, 
      { SC_(0.02947166375815868377685546875), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(0.01913975981900103524640010886547692464251310348463783017845545828997307792345381938639021633881005613), SC_(0.0615266302898037776092362808553214406398701190896414291616484757196625761343147622816317610090519644), SC_(0.04308642574851321096904804512286787428765926078792260334801992430316385902970918453234801471701681403), SC_(0.01549132990754464365235389519902698027173359337874645629272353330742798729169997687001584475984988345) }, 
      { SC_(0.02954470925033092498779296875), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(0.003318570222684691307100620026247043539729149122606816852278494340185463753024078352501024562755145556), SC_(0.5993958632898252300355393743756711427250297042751178605897007880051553118502684347908810176020121292), SC_(0.1777543356088508107233577974592363113073767131805230765146421044666053256682691681113171481040514138), SC_(0.002857774351710869179039288391999456656326764675142055967880170503862407412785630816820757627846674469) }, 
      { SC_(0.02957010455429553985595703125), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(0.1478859503758492042998338230315008977098427294666611623911058924890853780551300220143046347661657872), SC_(0.004056747908275574777537685603398543569297888830251909861784108077178514776666520036476073753191518947), SC_(0.004584207178786338420118150998787485617018469621154415082226803948360887652238823701511946591279851913), SC_(0.3076420382407919748560171810099829560515959043809164073643905032152003573934403962162229344254181641) }, 
      { SC_(0.02961205877363681793212890625), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(0.1614180040660873967491598470800770928976704792107183019719625158276143387641804648357278498320922935), SC_(0.004524027704123676152545950947673697673766679092468848268230953955433828704286396195670162800414227973), SC_(0.004775439992062482626272816952186730302792313920551584547031192713102190319706588751222163063846164799), SC_(0.2169725936458954096965838381220435060463199192113133538290920640222796764489597799631050181218343177) }, 
      { SC_(0.02963456325232982635498046875), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(0.002648721228229968652286672235768094117646760892328203521942351847861009007416269862457122821732209999), SC_(0.2026107371472923546065106915313989350738403842210224280844134739215763270774090313240622490998111955), SC_(0.5684626696196959505045757202979573546610648015471266212944223359510944161455137022496116001429625465), SC_(0.002992019036439246196441430397337266242233516304833399766505249208773356249186184598101876816077601781) }, 
      { SC_(0.02969768084585666656494140625), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(0.002969817854541045184510883764864711271842218943108862357376538244534307656237624111148514616940146988), SC_(0.2113709322155150732700219542950964257373674213686716798508415292278431343147296600108223738925431675), SC_(0.3911442453857074347993830217163876976501179058823148329488621646068068084748732355721735772722474332), SC_(0.003219188066779575615538194174809339244064727637482087374662752814888280428157161772821196724723208229) }, 
      { SC_(0.0297330729663372039794921875), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(0.003246678244133880716081144066368944896694991276219725103897270549019323953290757477376724738857964663), SC_(0.423193632309431384702816663234822553269596173406797067333609731833436111972239694702926407269414183), SC_(0.2037261282652855690633702593274626856166687049053872261688760750368203399980376291029855850230363885), SC_(0.002952774086155515975603315743175823472578315711221220322450350750905792698893962485376824927051572367) }, 
      { SC_(0.0303403474390506744384765625), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(0.1831218855224908054855239370257537612279258178390873497416724750004720424233121452020684459477630124), SC_(0.009862255130936258933377663149228020591846873173102251335550260343794208198537404197797319076480123368), SC_(0.007619586785437185371542498884581822202715095503931581526427643477020520941294733348976658996239315679), SC_(0.07575924423809121845645937200576610799146356910952168665662740771770793667665139654929864223366074498) }, 
      { SC_(0.03043086268007755279541015625), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(0.02095128665899062361189527805659784479306315268221007682915336605326528869288470731905853230797492209), SC_(0.07096815287997825837340559860786886254484312172283463517705227493809661484452165442854564537015375277), SC_(0.04148307772136617859926067456702398117994854636612457465190029958215352363689223612856895496789006279), SC_(0.01526206095454161016608722487316923701361042393420978544829140416104435579614332459762968632373317263) }, 
      { SC_(0.0317622460424900054931640625), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(0.1472112245970466461324399865325238028031046171462119121996403147196526431422021841382079160975570854), SC_(0.004672112495196692777832118304155705176366467434290073952444279813691118597874340430891383457156950419), SC_(0.005333026954802980899402016881011019533028965666666400509300476539303338384999043009212160686380076272), SC_(0.3076490899172316311093945598447743376120478787294184522808530746100829033993747618560368462452943176) }, 
      { SC_(0.031880356371402740478515625), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(0.3178480097782493215906390695875709233037362962950307710811180739367460647089381054848228526677991788), SC_(0.004924978167259097007623383455663495650209165138998429490118117164134550402039354495718930816208459459), SC_(0.004388943904498601543544858345544209070074036808030725220080662261742710937008559536171797062840878162), SC_(0.1616229566303338501261994026334262684445948843079622374366186652980535749248251177911811313147983194) }, 
      { SC_(0.0321152471005916595458984375), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(0.2234602357021440644154288211250685038258804004022485248453475150555247345561213708532777730873020303), SC_(0.00514103925341353022470775698261938583315516266478371893267742937143462970282401160611933367649622007), SC_(0.00494288611070639498307478822043590623916715490127896429444274433850437392928186304391567266378748785), SC_(0.1809309027344170827573266277018987128174699755733655799453292413332668648567232259386168076308874054) }, 
      { SC_(0.033008344471454620361328125), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(0.006328921827220988526916085097223050176261383022015536064809629491191906423482501310557582869785097015), SC_(0.1446508793379422453346833830275764009429620670313502688168191560129861017962404701283032532114195807), SC_(0.1906109220735727480349650236144234932812158216528483306710607618374503622810454158262117005769241661), SC_(0.006735006962376906530585563393771557220320834909662667742449438091818680348000434012367435539005951275) }, 
      { SC_(0.0349374227225780487060546875), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(0.008518057361922908430656516853214535414078278336720966411169304148944278369635834723735356128646386359), SC_(0.2057945086178069618138967512975070811490594220562262573953833072740722195475672001035631651083249034), SC_(0.1206258576597633954423994636949656885205074484929751854997607632665560968269518287291986891685706252), SC_(0.007444648302012061063898571086816873863073965838672911708265650879409879947837718072052604917722017082) }, 
      { SC_(0.0350247435271739959716796875), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(0.02310794068409677224294615779567006065762266146708083760410905638459009761852387282753963070704780297), SC_(0.07514656162477883322735742833652963345421215571010885581936518199826412383762899269461379759357422098), SC_(0.05021433446384141513558374119096771803821010719038732070455995320168130224110667614755958857104830112), SC_(0.01817571325541923812755775124659125708232928669958056149724908552734222507657426153473387910501776998) }, 
      { SC_(0.035909838974475860595703125), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(0.007562857590236357966646262698934616691765447371915518854753324583298254985185923048305252243772366412), SC_(0.2444085450620448342137461773445576332337710519948949870914455920012033220215297535856475131266809123), SC_(0.1411709969614690596329195484089602811285373601552309182527630984482336089537556958094223815944833827), SC_(0.006684703521754546986816014765911076949329918084380369534812545562451672846548278841968191255055047669) }, 
      { SC_(0.0359646193683147430419921875), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(0.1594061091585341570454655145158220214545206247514187209177863491950754836230370406938943585134611188), SC_(0.01093424740891574806760451332935380931320549243965337483012485530351871792503947641574396727466712731), SC_(0.009579896850861123823178641146281375050355287050504473604013319253581246396538168371644610202447585242), SC_(0.1038799433542594508410502027717308355784456354868261373253074068410898984153654472007040626338916372) }, 
      { SC_(0.0360787473618984222412109375), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(0.007934489164089557518802200286416296249365576020687992660628325405022435632743861286783433228904130882), SC_(0.1379342239771178048370648277797514048275633034221340375868066368757072030444643982258898218295067458), SC_(0.1807228087866566619894249627068373442588488227210446753002574315867284852397289454540978938034466508), SC_(0.008505084011826562383824530131417870086858571654338420036890861603277807468286214429402732154719418254) }, 
      { SC_(0.0367714054882526397705078125), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(0.004193314472131709702971369817668816773695063932296115838583375039944674334980880059599131593995816125), SC_(0.8139534321114322358685847518450061066516987699416026230332236740748782284168618804797803107984756661), SC_(0.2083824573388769706787050536480630603903054403890950682566772706183719822409128980503401983766446762), SC_(0.003510489019123171796177989462296769876942088483416048364814364069985020171605963883159068299921303488) }, 
      { SC_(0.037471018731594085693359375), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(0.003798751267722835972223742423292468170745903400298026481631890129856993404525408434205891137053008792), SC_(0.6827253504294537813493140947661719225257402937571505747353259899077723678605902021186495516527419696), SC_(0.2510580037378620016151574424029543491396099696902702811672897682104839834953521094065541923553195521), SC_(0.003338927483932264213223244096113137642618315416281178940661496011329204760456293970989815240801794682) }, 
      { SC_(0.0387387983500957489013671875), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(0.3741696909315425230643849252524613322806270816708375133414500267906690391815431038975859389850203109), SC_(0.006534821065405187328444822526202478110563628914154135314723431173229494668094382029008442398408103008), SC_(0.00567786564475436063186766534039546439865471098995370928313652414490239704130203613526906912244058067), SC_(0.1766448849265176889072472415984355927485431735797579025454637258700334621766121410872380364710589264) }, 
      { SC_(0.03926889598369598388671875), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(0.0250241720277836622781930209863155848752025963655078616416099072673171291268438852158115740524562542), SC_(0.07892776424040155053998551066300453155399874825727930092897470296900960095734244612777944900732305454), SC_(0.05886868959387045513228296698783771936059988903165381880794059905688884215728060961902274508705604697), SC_(0.02098810946949484319208478021372196657198026645869652004370407757684673291309937960835174432181224037) }, 
      { SC_(0.0397877134382724761962890625), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(0.02561621461568709070477552017508153733665596224980927132507963072380669073032829839274598579801322625), SC_(0.0814540016707166695103933407705846910621610440802029507369133641919255996515698683229104621829426713), SC_(0.05884865654142969446467307962654923205776690551005702564066604367806609871679386761839320590040446642), SC_(0.02107971351821546505831042868860378486122683348780738086515931639133903945576056737728220474077077862) }, 
      { SC_(0.0402315966784954071044921875), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(0.001425747724167975720493494800328868057679745368955193798755998930071638872453430716334619394565288935), SC_(4.494029128935478790472393104705824412658234196579777158387180161475872668027659956555933568904973385), SC_(0.4314682003315202072943510893409066584700502597498677457042856375106197803270934185675771537106503812), SC_(0.00118027378805266523213468314244974341149782163133521291708306960044785818720207656527690060634066865) }, 
      { SC_(0.04030014574527740478515625), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(0.004053799861753535303479117154659685882740442294237248296434989557122036501302414010624334165737717811), SC_(0.2927509460951234947532781646702674452479035958348658491466472174640391925872082742581655486486279131), SC_(0.4725230899946899722867894539962241178501346095692612956515517044157591638753692214829878671007893139), SC_(0.00434674949539593457867807294478540622891155385977070971238980729935302384694319779983413004731279957) }, 
      { SC_(0.0410285107791423797607421875), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(0.2284127512365577672838224650541874815681617945867235662698087797729337358018560845110532694057092764), SC_(0.01319816133807068346182903680692294658052960348918949799602850766223021515166572536070506556972540587), SC_(0.01040418588604829628559665692022923758347673525487771702789024459080988100427227906984554422418706929), SC_(0.1047093942022668184194412577836473384727514215939289357758289518468534389134627842733152236003898268) }, 
      { SC_(0.0412090979516506195068359375), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(0.009109214639920416789577628609343507544898356182636452687002361176828147795353304511420469945851479596), SC_(0.3723600384209244418045816616965754315958932238018430830005487493779627405050918144482713623384290687), SC_(0.1413243003122251880772973174502773486262010784291858957726553079884579324019585212355181275403375186), SC_(0.007349134899890753338498191950624067514308700553727449853910172285784276373777289645875540285921609971) }, 
      { SC_(0.041210077702999114990234375), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(0.2084183110366820464355155446176629922567272531868851252691779136915382578107399798358839313071218148), SC_(0.005676949995045641255297791666789724778581854344548509172145546631344836590638939402190859169860764289), SC_(0.006368551513613920604467771286172126217266721241497971051769034715324514224422190696728261379873821706), SC_(0.3918969906573540922210940274610888530897315218361241215328899402779001494760441888554553935795173721) }, 
      { SC_(0.0417932569980621337890625), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(0.004642374251397235785302892628293935019234260634679073745854576281651035426816823775789731809291972103), SC_(2.70680134250766235255497884395047882982827115434722412176272165663640748743321884230613481574160978), SC_(0.2018323549543535469982760169899891911257662002503138310700306276484458188334579386694169824588639579), SC_(0.003436001876000478084320257164505375638950900078286485970478883099022375747335005670242709657309995688) }, 
      { SC_(0.0423654876649379730224609375), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(0.4008003025151388719034690313223232080658578399054111160259692333921040670756646107647418719707486644), SC_(0.007146306850798136633440811774846219356073526877899292805314467827420541430952448790796397164211620501), SC_(0.006212188787932585429877015730563727792187735315417296430011696189568806013528771988830620156950962751), SC_(0.1931861170898885929197158697902114502575073872919825842057163329305800366719783728023538220238160126) }, 
      { SC_(0.0424749553203582763671875), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(0.004767720361759734257510272481198874637604490579586862025576407235299346706397320439048338685158479534), SC_(0.7165412841473400820268971248925288020998670856211887056107531726184707559760789316731163976380099765), SC_(0.2561780255339710272349691691035925178666222849535150415557231678222332331247385802585041131977486777), SC_(0.004116472442434012176631539445176019060311689855021131459215976437250524387253005761839112841263035389) }, 
      { SC_(0.0426307618618011474609375), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(0.01092003782194551023966116093568357874165905609420305406601692861180214928430781842800175572852698906), SC_(0.3206853841677833593408678392929862737104963924590840311250541416182242089483348072810141075737822856), SC_(0.1299112672307460846574874275834687715076899529008865318283717682787340554988572467034343797953500574), SC_(0.008700969007012528427983020786739407448481819599729649827444760612679633982484479320990909749849766258) }, 
      { SC_(0.0427051074802875518798828125), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(0.01007901212667252054016192011031518128634574280042405608429575288787780079781849433070534519744725025), SC_(0.6496440485868828142494935492676425053346976791643123944581359727635546222615012239760400912448936969), SC_(0.1262396959797012100344289618184149397963356514323414254208471391596792219880284853093463742653574388), SC_(0.007209052406185238025582485285187558666560366274224890580662194183743746879889301124659782532785993011) }, 
      { SC_(0.0428477637469768524169921875), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(0.02583352277498553693110660806039064766422633892472894427779997475278192905407960325424771722238563069), SC_(0.07806175611327931634902374911748283833894552787324698365132199973078391463622480718532399535687016804), SC_(0.06949360657774007380245059705831631432238157647335956339529084536270405426348101422518151232436231715), SC_(0.02408214105287188563849192778717285371598076536745778788964897373362567679841412876671363028287146863) }, 
      { SC_(0.0429382137954235076904296875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(0.07749880067086367126037124013152674912384913917103165552044349548764479311733605914275361731281913283), SC_(0.01717313692776002093284292179682671471823278012320965235562999882169124920800037438414274884907324238), SC_(0.02157850015504807887707156893632163949547331428010676505928711164185575356236381662016204099137551146), SC_(0.1262539707847640009072191915245950643024138684879992935909521520626691837481544818715361618006324657) }, 
      { SC_(0.044807471334934234619140625), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(0.01234054288779427706990057455982754904600886924335151510153060391538595674086906615031660929600283996), SC_(0.5470076231687137076984685429289288676955267079820679109494263459509885440943468816695277738706329551), SC_(0.117723721271034667248350336756134713222561587496343828233598892272393874536636024165516957343929819), SC_(0.008615244299013225741068925272602494655625062228228616460344700382775375047437182688320737984338431778) }, 
      { SC_(0.045094557106494903564453125), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(0.2105042293498638458683160882962397054002437129046319412285648930232339965156150711001533091366015294), SC_(0.006656374154677401068849287034475571281783168095462679867093400459340335805270966585499695263608864779), SC_(0.007554801198760006627545034213772525607306847031435802174586982320912358699056614252806400500583608579), SC_(0.4008489757479044340484638399769416290979046497520792996437886525709220275300337821384427328665722002) }, 
      { SC_(0.0455090440809726715087890625), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(0.08188239436428669013936604454487887878645330039755350356706463114033227568193823479628238730237720148), SC_(0.01817186356892590911123116238308960543532166154987010367468272775645803092153450681535266589192160564), SC_(0.02292084250853601645526208614585393204033738943914232091809666816334626782296210043593649872765049471), SC_(0.1342453743908993308844463216847166867519475795199708462437256344163591428061026027294988907896374514) }, 
      { SC_(0.0460021533071994781494140625), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(0.02371565563211131740132019797329595840461401392019786712368447089908231673203840294360466548696318837), SC_(0.0652775475006455742694611124041639287635923777115286999069654725230570576445278664702484509345833892), SC_(0.09986220342996806852642420280370664288368899192085943580578736157013194767407830365252935804321482472), SC_(0.03062110159866315206580615485801626653048360234223975396383893557766932492080300020907111634206026693) }, 
      { SC_(0.04610864818096160888671875), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(0.02365643518405579979197904590375370725189213387088338613311055107420784059199254630156580409929516854), SC_(0.06496267539645609712910587590739150293344982352258497194248832916707382474812298091497097781426213935), SC_(0.1012058325022869071582340175982666062188731364238542798810748349763865294406031607251519137643081574), SC_(0.03087552055265205699932948394479055192725910810911699076016867391577833091668436984440804092704140789) }, 
      { SC_(0.0463373474776744842529296875), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(0.001529462299123062501984892920651928665046607533210528862052051494120450351987152957999051420086926977), SC_(1.349751613405869074793793996040580304413225789873298346071158995872110393364226041698802015127148887), SC_(0.7949663729649308255464306591675852179754653718355913171259935349091047746254778846213689145584689958), SC_(0.001454489377384756758268869568892846379779993599498624627331994374936747305658197704581929014740752363) }, 
      { SC_(0.0464225970208644866943359375), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(0.0120834216270369079065061536301428560689638902483903486160983104164747782168849286290658398930171472), SC_(0.3773125799178865892343838019245303992926113762390594662535018032201120653291199816804070253438163847), SC_(0.1365467424354302989344015561456290262891355362247043484705567844513716964997446752988938079684757946), SC_(0.009349999679777188793593691983996723010480504483870187167158987966608551668659714040050373461618023948) }, 
      { SC_(0.0466847121715545654296875), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(0.001770877404087565900308145754703849747244338755224034235667843673331625500496242357887285155198935479), SC_(14.06570731667322417390446441669635384541582274607488221715422457342519541344256407076501704015706702), SC_(0.3746739589819988157950014168613403788483615887788460705078046768850902383452027696094544885955080483), SC_(0.001291048906681220171982920411470939391440296140166736184045636542119350143351667662053673744887057595) }, 
      { SC_(0.0471754372119903564453125), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(0.7641840588886738258308804266379474108491853622887437732761187183148550386764212168022526296510391563), SC_(0.00780504576313570246530175819563667241026825405418195849691426399875694172819685056908876543515873048), SC_(0.006117042252686400865981443131570151019629119625182508279879949940358784383991016269992267828007554214), SC_(0.1914694887983086396074248703802183734296601468118086328578052010521613743522763059863557972478486686) }, 
      { SC_(0.047682024538516998291015625), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(0.1442935325604409989984376664227294051297615719513705050600960685366822397228362069832070438471621943), SC_(0.01293913443692453217746076217268972320142231672089668604878080269831675497620419794005805754528954369), SC_(0.0142278247687856690352414167404378839889909673976280509625966256311007495363902534525273538741927888), SC_(0.1937997222603077373590168907766980821457466739118780875833679968300186684342359737441899321256314407) }, 
      { SC_(0.0477914921939373016357421875), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.008540418492323756700922738500819539195586729140024556645635395524464778463707868710481776360562356182), SC_(0.1646337714222846825086679472910647514820006600602047533004900441637570151171593193622349660068041455), SC_(0.4117153289219301483904071270429777882583980881948353734156275332843534434018339220036189678195105231), SC_(0.01054873156591916338222405800829012701597896933631356042408023817626961457172174363311164210110696295) }, 
      { SC_(0.0481977351009845733642578125), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(0.09668251359118980982051150044590409833591165214027606946283326294150509914472309766296550568555032827), SC_(0.02040410597582108560416499904675859706182494842975136190506906464289319912886291148084268107959910281), SC_(0.02271802735435804943015307914192286997826134568970211099024502057865337413820599622563762781212470387), SC_(0.1211119023846372287055028229472084696607546203120857413374692855906785352539854690695391031133923945) }, 
      { SC_(0.0482453815639019012451171875), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(0.02651778710183433002062194108350675323735329083133127905349602889180057527975378002974686225282000767), SC_(0.07548077628369215175823396217783488545566965228942268526137389353261239829354279101538030577088139837), SC_(0.09155499358405678346417569990669032976531191422468550258086727410914250795105169214674079832516644408), SC_(0.02981120517902814552656034863177667119803601449281314493604299410521202494981835046980078236992417681) }, 
      { SC_(0.049268923699855804443359375), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(0.1999380557723815402203975115742897578977182058573888309453971871376623866525054025900627453880678288), SC_(0.006991295459053210006462127503016552646605659713136889405433937224444250845044240946876714706238711241), SC_(0.008627913352812385077688134345284009478194294919743863636247224006362502155195005766767501466703948502), SC_(0.5917614413038263179730401176770668642228600358949262341349124266190437769958280688904864440517397174) }, 
      { SC_(0.106608234345912933349609375), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(0.1567325643271680311535733637586558140791593157977635586959483946756543376445197242922900697126026757), SC_(0.03782426354021814680716865622704482674033603206697483301399473814771904813205392550741452680232008597), SC_(0.06335579447932831083982526698996407606482333171321923642202925066957820527492431559921475447966192018), SC_(0.4361347539567126929327157331775634674115317265853072757810256548275583381209291286775922559495418449) }, 
      { SC_(0.10738034546375274658203125), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(0.1759192983713781141043066769517775019760585826370542061318767416504370223832855481118928679300018927), SC_(0.04080796323362845774958761527530762895319458941827213970164610878166397120289541083420009727475295614), SC_(0.05810539132436820005825664291995771132855890598687949355855247904364881717596193907702508407437789061), SC_(0.3487210624182838987415042086690349225060853737803191218074520751091216216261217023740464734556238907) }, 
      { SC_(0.111688114702701568603515625), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(0.03037679974482926103278479138428022758696205701861913013277296321339794010523056547519172356624841158), SC_(1.932588098527513538581138109877072842174917737104913328406143817955643194925642938431842135804732537), SC_(0.2636062669689901535208420550102702950564544900703742063874630749578958664612685986605952787942003469), SC_(0.01712288208894043956612917069389446165092235639340202237845176005988010707177286796851451398019346241) }, 
      { SC_(0.11682164669036865234375), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(0.4513235201572444596117277207890380739375196370672582204972802775097572566681329122361374491421635749), SC_(0.06848164012132792551555554896344558172847713023389468667883891939752547367578761882224252022139852402), SC_(0.04191138451469484200781214488750085772980920959306046052713352064203583027603311740599152626132502201), SC_(0.1744603340349361032921633565986441705616304061946545421262583260968045549699521705099494361582863131) }, 
      { SC_(0.1342063248157501220703125), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(3.588307946573231373626775683465310069959065284174762418538970363780855045986436132343834422948273051), SC_(0.02820475181306502621262024828089263232791977875848052295169252083362195525678105157278061774168208064), SC_(0.01470785056797163618017195806194651953122590503605145715998395078831580494723740556930354602780639839), SC_(0.3503210943189998645314144471260459566550335533975495123108503438210433911020760389288775227568359864) }, 
      { SC_(0.1359292566776275634765625), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(0.9407867644887073093774673317890893064097389177058100102744421562037389085998730899025334377102129589), SC_(0.02336001901077547167516797095781308340872465938495659285140959769644224476180882905791706018224057667), SC_(0.0200059640635205521548159818892054592756548956386650525038764251254035074826968321274462212820113728), SC_(0.5719117129470558717393200745110269847865325393825565542568112911872562691672936402109551122281647563) }, 
      { SC_(0.14029540121555328369140625), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(9.25148413514499363442345633394371607270462817390666064741956249089129509663568581340893347143248045), SC_(0.03910985054278708181330450092674781780748502626858075360592918133744662040401699211931873238431951032), SC_(0.01454270405788597483889606272201573861960804324695689358324678299213322458076096955131105125382808288), SC_(0.2774100162539929668842349515400432450358708213429336130826989978442689414779919106321120762166213844) }, 
      { SC_(0.14444768428802490234375), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(0.1171799187628517878675618214158759788692474503148068905578982787967318873036954843728137675329312737), SC_(0.4128935649414521291834604678758992573350563731135872641626922249822850658987362076741279931299778992), SC_(0.1687561587451158466824119713935487496417830269568175697384448706357212954110770619237172878947394865), SC_(0.06518078631594027584147851966957900883785205478506916144962661913157770469730498733075363496779378625) }, 
      { SC_(0.14527700841426849365234375), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(0.006570671869295905862258967919361869165887875963306630374932389574338515373797473280643234108987956835), SC_(11.55503129323370262362327917848264671824344178928888008812663042056471245871471260661875457790960825), SC_(0.7579669783910274507805102918151384496845008500171340187837144526404847579516859235244656981666097637), SC_(0.003568233293858479270927986043780159277584852037229656680731549272506360371516849237002671717838674548) }, 
      { SC_(0.14696706831455230712890625), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(3.698194715947182065363727115133775742385304084868662869332481745687085754647866200009931251808651877), SC_(0.03148618367896110825834837611978572071427317480892859224516914473365210837499199729210864360861313416), SC_(0.01594573916841151447647430905429558683414835271066297960133851313237223165502146753860547938265955592), SC_(0.3746984045940881440389540597209025488898057003574254117954272944689938954810464089789362323975889072) }, 
      { SC_(0.15349455177783966064453125), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(0.006262010105553504898176125752626159064208885123007827259004250042516020275137077722640097149038666485), SC_(5.986553403382404908638466667683106369247399329168017986715031896699972855254008739249338192335366597), SC_(0.9977343813141447382403536008323877728894372605311758191870116185470348235225403163446163928037488437), SC_(0.004097865523327224858703401453030975734542657002010229132462195909112630460986670340018172934993319546) }, 
      { SC_(0.156057536602020263671875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(0.1998384709419830669108227968548851541383199187977057365230621379149812593298016449703465251167683914), SC_(0.05061250162542556176148527575234304204559298238803822511460216152020456691664649805264480855236401173), SC_(0.10792083994111361810123895550131266291021887887927533131980006886073900217804926011752411569162112), SC_(0.8120019003385529302207735052411964706121773141496108896336143865626659500220119837862201228111819854) }, 
      { SC_(0.15913160145282745361328125), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(0.2653362400442073543259467149463693337232425840687907271937285013333792301808930508723185142603973274), SC_(0.06166759125346304607538673176272428753151522930783132321479690295096229540806041222124899128472728525), SC_(0.08513816897135487045888867084502305226577984860749304212448244117378615120260825299659910674927257665), SC_(0.4690832441691759568402239536046592958490589370906780462193790817898539933231606177529938655841451647) }, 
      { SC_(0.16493140161037445068359375), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(0.02255360580417725157352688449987446148050052392937124412456795189006035436060617892571966053254062313), SC_(2.95910072893030203491316448073082293355042405844814237129115381752843978548540651375317548947948793), SC_(0.5949478347155782418666456485132150449226332971716880135721179602575298903989999695382162222854428364), SC_(0.01393696938253300220970285605574765890824036296573998884373388532612687491491918344632434018536943153) }, 
      { SC_(0.1670223176479339599609375), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(0.02351816543060251568008249037715356668869454629797718284390781312849996182584820670019178996095855586), SC_(3.349513488781095958281188384206002264278993628345407389282475329306614436961446358143378498686426183), SC_(0.5726851106349176410789533160276907374720031997836776845239410879110430804619872617965250357258725878), SC_(0.01380955919095858953982953901373599986249620908763410821406449463960742478126766518403924874828772815) }, 
      { SC_(0.1682832241058349609375), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(0.0834453363191590562481412048785105244349574912780997856813932502291447998437889969961407569810909484), SC_(0.2221402859221980777461457706478252889633131939493953014300787345390172916486285117330868021670878506), SC_(0.3789564496983569538101059775732376092761197036133949350116650794207948688770146010884259284184270413), SC_(0.1201047195472814773661320384159746313942609418101230204992464026855954794745819853307685084226550381) }, 
      { SC_(0.17262919247150421142578125), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(1.264457137270341612043654684838913214204864470966782920720361710029967325397066877759146957363467585), SC_(0.1411949074760561126909204476926972554868058007819541220733313986614467364540136459798438714778505255), SC_(0.05115233781514846905330138921545154045141094580831962715417739911170790079313556195152143973112255186), SC_(0.1949802458617219806348262253574654327876816047595175936910970403341909936303597951660069556896565433) }, 
      { SC_(0.17392651736736297607421875), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(0.03880318414822584617414562932131981710172342991359172175158826397284092733442999973589393719725516935), SC_(0.9686378346856790410924956693371976263645973553799834718262312450793609664046938660354155986481830891), SC_(0.5784625289065969928202716191418746894407878681815775684420323188654476979859069282772575021205005023), SC_(0.03177766184015551196818393495732671761969087526509279704983895836883950781679821517653023735286013278) }, 
      { SC_(0.17779815196990966796875), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(0.01534630206986761454840064917756299342877269410162682833128101526852771450773322019921545939710037981), SC_(0.6673656057506811352318855987063274792844201511498435048913043094251471177173656597746843079063089669), SC_(2.658212028226008028797946147346298603009699205395810802174391892731526416047596765187879914349346872), SC_(0.02380030142349148955059659139451385983031771687815030288279990487021355576267873093519424956251760334) }, 
      { SC_(0.1779057085514068603515625), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(0.6484161651339239924119072947711949203586438637141321912093852378307882841848209235851709562697896043), SC_(0.02296920820563775787957143198873663134721193414623208215240172152985436498389007304290044423609625831), SC_(0.03075835141717243999727145136703722387537842471162302655273941369707225139422858997919481373789323108), SC_(1.489785437194774845029663544641891047976911317260466091950061103796799197608959510492777220061137905) }, 
      { SC_(0.1799491345882415771484375), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(0.02996105513497351115562180736653317260263164303143817426124847792239712986226237569412673930404575858), SC_(0.3466937095415031907290115367450401732673767258671159569150333389640457557787893302677164682400525349), SC_(2.244285859635075165290025100479706760817900876463124698225786766078543113903496547798197702440144202), SC_(0.06298061975471712930905827239831871389223628611218764574400768321998496000947847252340729302092198459) }, 
      { SC_(0.1830969154834747314453125), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(0.5599295501711028246024346591035573923764031457156879946099177109629126057795794356153224634609901702), SC_(0.0218916165082336459935878185752034799421187950916691250605662943235327552811871463014410987932226042), SC_(0.03487119110160166693407696682083682512126357286914844423955063804498412783498037152979313407152386301), SC_(2.093591021834377481672376445765874418342028050860795386613966375439127781346633301245951475700782519) }, 
      { SC_(0.18550910055637359619140625), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(0.01158521515777004768577504504022649492824433585919066539340514573820013563346959519616306842745287435), SC_(41.25496491480639322275980458426365328814399602203458269531939206684212911445813271062245200803251678), SC_(0.6159105224517543252237621536592261773494157536097394788114183584088141882931541815190439494489748348), SC_(0.003715087445192071632684209564267992486558523619669263931076463040137106730659292475671070106345671317) }, 
      { SC_(0.18869869410991668701171875), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(0.02514142197042129167276431927542216663170726334634813258906949753883607368508611947354271572978760359), SC_(3.996969718865251515439078700108259003504137059592513445720086302782312435913080124368025602582316432), SC_(0.6384721982698123051331763889955658051920003442372498913044410088686266719549778502827552151996552406), SC_(0.01393688900118479032787808400522081164622070520246520939838575796661961647067397282342858994726861256) }, 
      { SC_(0.190368711948394775390625), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(0.430854724096346600149287051936351322165161270069252559577917351200586787322476481129654592133694338), SC_(0.04692145742568572086991390344713641052916520502272279259416142644507152532992629525104030744354837644), SC_(0.06603753546189706541662023035636257026277147738603785397181423373031701215693667480352169268947748878), SC_(0.8934552544132016984342820939141693261854805722457584286602659650676899654525527289259612200631373714) }, 
      { SC_(0.19106571376323699951171875), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(0.03307983663401155247216674973753886778953112475460929951814632186610420545816120834640429236257339152), SC_(0.5568145422000900350992022164526521157715684951727418865733405502597042328854223840019911645753365084), SC_(1.238335247790126848304715250227057148576467613841538559044325833882928393613924284771524839914363228), SC_(0.04570770745805918132344055786520391370405003967633571776819545047603370439330572161233591126170722287) }, 
      { SC_(0.1921952664852142333984375), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(0.03071435509882302729237966328973344943351962293240663635341018254669711411512373339518302233730403171), SC_(0.4773146695980315742280023967202386171893147420606277007887722226919221803169665469179849162803717452), SC_(1.684783406368456491694020097414461345343107595515817186381651990824799442315698499540055784561411249), SC_(0.05091117788458086466656128046359282344374794934310849019741205802190062081673443140918467555169220577) }, 
      { SC_(0.19491343200206756591796875), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(0.08975118324744511366389606065830703945005345580674708661358320341762876953568837731790191490004584747), SC_(11.01240298062212497177164082430408406775595962902307943953066734311206066220169501828192219040103701), SC_(0.2823359416748046362659571728503672398399626518627210160109768565597650673365902664572085903762395455), SC_(0.02247270243923577935864068254577338462537652979139704697496036244086475527566746129488647069741306988) }, 
      { SC_(0.1958009898662567138671875), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(0.03879486314792486040011568442393446311125140611475505090916888538115716208194742791014501013534608605), SC_(0.514417986056485913950867567497352413379065140706601271626247041610577664454171425173392667495687012), SC_(1.123410235930126839857782387448508730978514826582558083812908461161235770645469707472902967386615397), SC_(0.05436094036170120235467119557887476411925951051908047266477921601012707848737035581693885009396934108) }, 
      { SC_(0.1960303783416748046875), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(0.4627535620558420859940076021474555566973398310196167373095014682172362724830107758656696425199895035), SC_(0.02264469801580615133856848733110126392269357524826444228276242403831719396349970969952479655578667452), SC_(0.04705416497192420698806088696369508262599738705376049666236896874015752223749039012359840448804723789), SC_(3.348476388150844427961717451914713315270386804304976253214132454956128970253559332046384398557585614) }, 
      { SC_(0.19765530526638031005859375), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(0.01031540696873367775299446729501299000055322934370363083699711529114998302919995300532284720129755989), SC_(15.23479912600383824970352417378362454538252222771183062106680959612386625666956410229228747528429323), SC_(0.8245507430661171279054073189649909934802180266077262154677995508807875915835447083526935110408970532), SC_(0.00445849201464564644814052194384209355002131743314783669215055930787480145157504147385587067142998) }, 
      { SC_(0.2032258808612823486328125), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(0.05778204493591628886180499918961650153804360139989373487335624985590981715958279418013821349622701968), SC_(2.102260175759754103954893131956446792713589419162590693629053292640922107747553712356053959951085891), SC_(0.4596293046491174226923624293963072714954690901302332159238328241110734130697400137319914871365686715), SC_(0.03096230048258507462675445922773912515539272003310537332893557458577595639490609736300400195514593193) }, 
      { SC_(0.20488469302654266357421875), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(1.652833161614253691455757364401426171890609194741862271402389319321206981897975086084297705870564972), SC_(0.08927759525079291061370770124299067582594595123178598306405239824502968712652031334618836805899007059), SC_(0.0430088660578378219085179647198176274402137312960716371124460185306258524448294975426415112290712452), SC_(0.350987418520083405807865412038775216062495007958744318973987460017500322604597639966878780732035451) }, 
      { SC_(0.20499289035797119140625), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(2.949237292104481314513216471174561670369006918895372315183106284401066403115460835543910369818403765), SC_(0.1100900400729786763767087301550453285994483315423781939958643117684897784267898808862694888643335171), SC_(0.03806701892739010932407138370429013310315400596623165264844361772196409835050207933771021887858997205), SC_(0.2915305236078727342925070694904897234345744613605892963122414440910211266460930772492267586052121976) }, 
      { SC_(0.20636825263500213623046875), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(0.03702487301279202648947159789419458657254163494624774439553521694304213792780516634398221182058982187), SC_(7.657143598136202200206304641280877903268770138867704140321197113306785825457931941581947447852893807), SC_(0.5126326817979785691924112804450683107930986774501763399820243921533105328517420453440411066417722353), SC_(0.01462667572773032394149082047025216942751830038940312080497259480071759425271601643838427200516049975) }, 
      { SC_(0.2126509249210357666015625), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(0.1260376960531365067103344526240290769811171426008817561765822313354617657585958947477836190211744987), SC_(10.59509459675885702447100089347499586415791292071795147739080068973136320775751412047309782836006103), SC_(0.2709600872520535829446077941498530423519706292612814935437508080622964990863466050227111653445967096), SC_(0.02705396199245387046253891786244219742955880573450671808692939625271771837679988146740972645597000085) }, 
      { SC_(0.2186703383922576904296875), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(2.979879749338123516593077057801305367183978120308164235747779915436450052942990551189673155487313938), SC_(0.1190753718072954115995721153761123827713660323059707778987454302998690688369757650845510170547946484), SC_(0.04042843186361656204366700949502455232063186567725376312737241460695449012886557293289807735965379234), SC_(0.3082709390593868826189222079090225550159568943908059468485567411673487084080192290016464476332497462) }, 
      { SC_(0.2204985320568084716796875), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(0.4092587100931235050972656843475775586316731024614413086141334068955505881940817705895592792350796005), SC_(0.0488177065424932162550086674698327641622269852915892499555071310305436786514291410959136432318611644), SC_(0.0893673518386801380570924782491472801350230382253114031596582038402254995300156471599580416951410324), SC_(1.392691374165411571366979978831338886577891490182599175351264923821489640031987232126623333463565402) }, 
      { SC_(0.2244409024715423583984375), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(1.522035556155868687999143709380055087028588275547460424242862193436312183212634979293192766197540452), SC_(0.03814362755106738426439863160041958624384654505378954242564637143335925195309715316049573700721797869), SC_(0.02996794136007899568802928307472154154247796183069243161849261674833273112467890664399127059513125978), SC_(0.8401096320800888072576369838202393605187867633311113553311527893944965036955050161371267591031274535) }, 
      { SC_(0.2275113165378570556640625), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(0.3041530499768992097252951322986219241290945759852974036750060516540959829019497670296038320744171769), SC_(1.314040413313792251243830092551866638160654641656249430532054523551899748520793301905352653286017834), SC_(0.1926215414946084208037290348513104012890495535618141420101657710800874233168820727989772845228896563), SC_(0.07964025310067381762375979671858851011758505382551570768382124452511663763543894705640192599376347996) }, 
      { SC_(0.22998543083667755126953125), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(5.625201757915013841796252593736216121458147204532329945266168385138205378603712437535060381694462243), SC_(0.06665469002511883220647129512392266118401853987484335860503172602390527634230187571377691953050488297), SC_(0.02386276468141475568467844856767591826257080644034600811136607510573540246214604485760317916864056356), SC_(0.4471351560034542720760835619631861184782937285061898268115971356687786573558617840066620921847126142) }, 
      { SC_(0.23773117363452911376953125), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(5.471400415489481497144964859844085111195509285421728419828545507429867897288978342961917608628501819), SC_(0.4026267347119045616199327463336423094114588216942213687460346681116584842583358993546843109966508113), SC_(0.05326568793540949098208746818452521088070890164557998812836585460768818136816327305575934930687968338), SC_(0.1883774920709930235621430492136464700882964591474572763921218046790975768832056145822070593616608769) }, 
      { SC_(0.24029083549976348876953125), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(0.01601698814763699879568949751807492369337102735581336495106419471303001577449831747136436477189565259), SC_(0.6481730579135987302571070569891286755127134576466776509505570986682557264654204890260957708808725855), SC_(6.344758533361419638276249988627875896861910671776214562385992211223577431542101617587943992599665701), SC_(0.03812283021836072610131079801369921465929443495165737724379046008101556738623611953571280020223340679) }, 
      { SC_(0.2418552339076995849609375), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(3.038838669056817988425492136933878539931187587167605084003282583670104881680711603057299734785102679), SC_(0.05772754986701292660979688051580745890278445917762529556388947572931512200419062639195098128333310449), SC_(0.0284981582640204095290199560224804957738445430134855720230451488763992134327458669165228002080329188), SC_(0.5798827251909632933876465456390022469445978766828289948521055194471741123802483751435568561275909928) }, 
      { SC_(0.2514437735080718994140625), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(0.3624160700808419571136430125899347711898590172173148388449889150935824351694541453407118087627416978), SC_(0.04742707869974894675634998192429947463621100149010806827903161942970298729627859175299179343238964074), SC_(0.1338668399562766364855549866920264529347583242769805415861902785546849235449344562497540592912396937), SC_(2.693843532214945068812178436389628110952753617096288683166139793372755541351682777532161468802598795) }, 
      { SC_(0.2554460465908050537109375), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(0.03949531384828945711802742582135537335170986959948512551049806209849577389804379370913616352795729265), SC_(0.4279713790228354510811102051413024006938082571728690575102191666849150123336646580590695842012391651), SC_(3.184975298414231229033371397763003009598825979485253660573120735025212682447597726318639349568270628), SC_(0.1044983710085031357441094510259632236232053340062544116301830760637171144063472801422217312553766619) }, 
      { SC_(0.26348793506622314453125), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(0.03864453788812224853108653216887021932148311162731323539277695952849939893710860602631414392476072779), SC_(4.647675243900434604292452979890196177407263809725117636874156830256956675378662005885832653138443064), SC_(0.7868031288310236449696014685229907771036464223319661728227546440508601201692747021201516815820703609), SC_(0.01869897991627170970220862488184332599041659275625860269300387112247529520257423040028253860398915593) }, 
      { SC_(0.268076002597808837890625), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(0.1306731340914987370686211591941985192827408066198449112073302803318125702203905715584371794656154797), SC_(4.784619444987424034491648627990828541475187531268869974745693461454316440100962866893789611881062428), SC_(0.3911256586350903140946271087860993418046562242626827535376031601732409623472652440568322832741967876), SC_(0.03780004506811991411257176053513818131766194631988765716536695423749595948897365955594997040281948338) }, 
      { SC_(0.269666731357574462890625), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(0.1125370603223801146552785324260270652746164365873474690386769750448430533860940814400703827077482619), SC_(5.454241302747206587000805387418929063235437450830919216622397085731446859460139394953531412251167071), SC_(0.4248553124965974398650329195448848813035797221262484761365369607157495446615616084586864849289450729), SC_(0.03323704597940122778533415875548312256972508318629072780854666331885644672925958083265820755838670624) }, 
      { SC_(0.2720829546451568603515625), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(0.1961470202978315365295344549972123882064815875426098981669763368503750318984904502951138764591499257), SC_(0.5764189152088617689964977292027773008861796199354374552178046675226980310829398280179286912263310493), SC_(0.3568031213098443981445049551115661349182777762016427610609594439221978815185949783439212876214323391), SC_(0.1367965525117247935302670380964661560603823134813902945372590448149661985766947093483139093638631161) }, 
      { SC_(0.27427947521209716796875), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(0.02234719562152443316345573721510555624944264227308030819000024569821690925734533799346636441914303467), SC_(1.060603536276598445911666277344791006386712750719556233504840639140312098819067974300574121249237389), SC_(2.807496539055626932518245831257506258798524615902870804367157162007190584388490732712614745207261991), SC_(0.03375398348408625096693767200345926593994009060484576638757826838735112936490605811932091546401704602) }, 
      { SC_(0.27554798126220703125), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(2.10131429690467149379616363913507906203458222872716112360905429286846974461783761204022507524362389), SC_(0.131746185855178578989079355305977359745050003709281150745298677283910913620036746141438874614648577), SC_(0.05570651721168184980217589558253289313793331244143724595347320939160540452709060037750731589549757636), SC_(0.4363412743350187079626892012634152707000010288921146511876049849167019250888661628459414395915373137) }, 
      { SC_(0.2764894068241119384765625), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(0.811170450843472717751599678489656197579623458728220780527534755115022422595332671920532074262837567), SC_(0.03688465784233834585584581535420793330961086620446353528840587602469142755544446558857516721277261015), SC_(0.05693341073190290983502078892902014640309204748472874686352433498184252923741179722249800612200083267), SC_(2.04824666730572653491030496578141391754698538368440908475060075598089438329370122555930205842113224) }, 
      { SC_(0.2798224389553070068359375), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(3.901445549540783325184176936807095170503938394096880371937075448158132176481385378196305493599018121), SC_(0.07466887548611482153756810863610947701355987777501107474303505548837790854566550291743507983674399687), SC_(0.03106739953298483501540999272028210734158542114520093868633360533148416407099252779596062816259329192), SC_(0.5964208354105115862939830610764406479065290004848740503812857834838636217826923635197973359363396783) }, 
      { SC_(0.2835395336151123046875), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(0.08153103505150606833292894538721815868079617588255441958120910871108259691927223528222153514569523378), SC_(29.9688520047490287072378703996955043037346899138252130459435910163683310421268086238995868066332934), SC_(0.4674740751236775489076610051232875609261741690255262879972128754679178721762738288979844377717126597), SC_(0.01392864826398735078436915796404251191714011297064431283098897784845650887900772466533404671601548023) }, 
      { SC_(0.2883693277835845947265625), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(0.1176925721788946128844502678763569830215129446443745149550231376009819739886329311519079767375937639), SC_(0.2912587454229143378272700502547082027187993043928808277522837771509082304330893236020022923157446796), SC_(0.9356628026655173451386003096690406467510217260191621832195481377788762258687291471965229499117869288), SC_(0.2842262773922173705994887689165584379461897790293983876912063182718976893016496508681015962945091122) }, 
      { SC_(0.289206027984619140625), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(0.008024150332068848802623033303038730177640325922908483860288699907866703272888553915071043221948635642), SC_(1.735572327342960528842407495095513988787239800386109977892873958170662880526169053319400220269003283), SC_(4.930172747416480606137777340766022909815855014007765652424542512069643007011281756807287182865975827), SC_(0.01211017273986694337200905557782475306999438873923663572102832536558207697347255731270582979040369887) }, 
      { SC_(0.2906552255153656005859375), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.006448771003544518556894457924616103702184188022356318282672273386602696914553023273608791322895671056), SC_(1.112354411075430623918773405996035338356176312163194054353975322771699096832081734632527306207059438), SC_(12.00224633093284733951565041977310428936327956708757213973575139405451401931546812993339619991808082), SC_(0.01644279448668091322487554020817717370428591777827854420163939163298399095786845181660860432334091101) }, 
      { SC_(0.295443594455718994140625), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(12.92627307515295392312128329537280292674722274256765884348612799396828996353487761968223163640949981), SC_(0.354262757496482790937599214597000782578167426647966866810871966106485445262063024324746277856615039), SC_(0.04011649748656197471702419385777386053862383867043423154500360232777881161952944243885753873028466394), SC_(0.2743561361618335806497959962679247406005330977211301828367506793717254590370439404249147266793640164) }, 
      { SC_(0.303143322467803955078125), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(0.06178055571475793277911396728907485182029364447411893093553010121331589257379283842595579584440443035), SC_(10.35016286164185348989925603037539295762267084485771309412111984742551689369384090741364772133316531), SC_(0.6458579936628943824554916046259240813023364896575480502999128923004882673799872966943023044363033217), SC_(0.01778640542345983133310110585936828188405692973890816850671115126539986925198678452811024085902730251) }, 
      { SC_(0.3131302297115325927734375), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.03945798523885219335718864477339598883338636223858411608656066677678711750410620823076022518966061376), SC_(0.5035626317688077165615913320479528627750722171681037126360863986648100970442863460265071451190186543), SC_(4.727761994657049109409044418852039569502048468964297415541493748116507567709694117089959023060382099), SC_(0.1285375504947178381011131105784474460265058739690465020164299098603388810169870753843217199251250781) }, 
      { SC_(0.3160552084445953369140625), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(0.7254524199712537546985463266222117975092495520727172508391609364449824636445025557985703024858922177), SC_(0.03713658628390279403423714476016659439215001379864903566573126915080488654420671313696355982300562353), SC_(0.0791669745625378249138297954570974827335411515968750613964438028349781488376878794028410058911065065), SC_(3.226261505993510239026381741066779179969926801601607938625428465173470070976401691534726163453680651) }, 
      { SC_(0.3175221979618072509765625), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(0.5738836831222739389205083442783384579251482860717503958078861228649784158882712460150477343109155299), SC_(0.0319790808378734552710080303995487050948228558722789689159350545944689797186141066280412524440671657), SC_(0.1020861424402957971955458388936978290458158964081195355893333176274736341602122613819542035216242073), SC_(5.694795206899077926491933544956833489862048158920116497332679695731065613454231007812859487362588454) }, 
      { SC_(0.3200625479221343994140625), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(0.1092441374112056598914314589476835009875361428110898086622567693450142243007387596130954555351998358), SC_(0.2610791853784550830302634862492854426088682425280605009023773799791212970912393864982006539995094504), SC_(1.645275529407670635641143985399952793550161255654537260224427266811292355231074271821358775627838152), SC_(0.4530326776697856175579428750780746847053726066233006337280078650452151535007228037936796291577282067) }, 
      { SC_(0.3314100205898284912109375), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(1.430229868186074212881531893767329770428446669039661015207124333704826495419429804380715463901486714), SC_(6.888523882696478316104024647887648098095027164403148154584330670989440975961238465923720908856018283), SC_(0.1834880384127827248309647583386839256762479790530689472986730902371448840496590271381652147170633887), SC_(0.07996262103180438829740342796208942450841999751940709267227124404283820588271002067823628208277187883) }, 
      { SC_(0.3337529003620147705078125), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(0.04380769499557251945894654432568658851066412020506682756784281516085097304835803587823155765489489422), SC_(2.51309762271313882067146887525386547444248098452343856646752323469162581033858327029100396885687202), SC_(1.285100804888122172306801279447288973232919027859349716712338361252810408950944938657704545356030221), SC_(0.03148036232006793459142151329953731546133128493276814165628122528801670034598387390176811490509696352) }, 
      { SC_(0.3348178863525390625), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.02077413644383653491251424251715716742071557239091639946047110322164191598047452584563078841112011177), SC_(0.7683600401256854517223643880077508236855515268120647218998545786872751956507600752305915875457058403), SC_(7.696026761756438083004464533456182047792336072056029216075761659890413667183831603680356965506814842), SC_(0.06333802383757089012648340366807011925614574565778007718560397644624514033792559631238070144790711158) }, 
      { SC_(0.3379584252834320068359375), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(4.854457026040178131512972198841411099037084160769971662687873391402027347779820924019892017809100206), SC_(0.09288520916281080494861659017046253634838396606126749684026871266708092841357653006911042538474132044), SC_(0.0334017174183008499881747504395002681435780091302745306712451707793309709865014619039837674899641785), SC_(0.6814616330047728939353728064366049454960797071658708075293337853581648861166988310221643053816647472) }, 
      { SC_(0.341137230396270751953125), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(0.4430134202378674128536942127950721658685355554538078823750661133095368577099392032204570300337533361), SC_(1.508489979242231024813832765737565819385936568131400236918859793398840204420461021710201902630282826), SC_(0.2905002369773682052908911348892732139287239257128118564024358338460159141063743064269920318628097996), SC_(0.1211099338920461522415789644625541363689481324679495648198548736660302709496214788858332727061783401) }, 
      { SC_(0.348990023136138916015625), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(0.04334740108671491362694435183074290066800719539750712903239534054858965603027143815681116585403496298), SC_(0.5440542358343976918320479331655531330973564903522912763680493017266071114150931775246781541682855862), SC_(4.924639656115933271876516848290949028698813868257294220498082662738987596013268197139139947721292677), SC_(0.1504199518079572781691210318434280599024291026374895515382375665776767224105132151621890648246974848) }, 
      { SC_(0.3532254695892333984375), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(0.1038663444377167321249028266442823053261284798096841554972096972138582625070518979489988053003247019), SC_(1.610467470987764753957815129020488228413402160016408701774147729537085666597713103047405194577659833), SC_(0.8559271874431444457944914778917254111628781227360554299755879019483827867921496081214441085963812897), SC_(0.07145745113367943706071653703197102981727832356029906485421134665152174506116945987763403436946647312) }, 
      { SC_(0.357727229595184326171875), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(0.6300914688420887914562217338134098359736532516003092708450729196615629379990284161215025951213746805), SC_(0.03241236038638579850613646715751209832080469723145850770104840275225828384094393007777618428302211633), SC_(0.115936729297915488709349185283151003920059796602345930456956336901467287108987051666542888822357964), SC_(6.659606541276310299903571293745505006845721858339084065393418447002017521602909309296318322679262697) }, 
      { SC_(0.357820212841033935546875), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(0.9718582957147785042841204829939345119777946778160083975291897219870807012802123351906640500790305077), SC_(0.2088620014622945202702568499009378822867857175724403282659531724571710079399851900914971072877814059), SC_(0.1373196312202766112050885538380019515276091743217013142652427119764103781908841231643249329949721789), SC_(0.5454015990564563027630886713792351019359701411417544554669000338059108806888907144495165762375666368) }, 
      { SC_(0.36231195926666259765625), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(3.641144711481077690028035696597515508712121772834017229270618420271671619343004124607429221705676565), SC_(0.5238419461514128499765103646919729834906471847656674510853688728979228072413925135605654809412760154), SC_(0.08509334056676867915641851765527586804295415555368293295351717192504855054228984711687588304504409032), SC_(0.3002841655488905422145495190710556505091453859362984722082712810238960358398557684157702422262765722) }, 
      { SC_(0.372162640094757080078125), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(1.964984710540506538249901753981680561303380547990589452187489379946449852526043096776903913215001752), SC_(0.3487762648064955693316560180958838632373838851328916423548524979525188303136001534134377684338565752), SC_(0.1059322580413916355411742993193714127594168316750233257310169048246880829891546141896393082084365025), SC_(0.3872676098271575367031634004037115308177281340405686095864558182285178850306796076678070471583020263) }, 
      { SC_(0.3829286098480224609375), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(0.1736107149333914219648067660629720454202348545565967072368263727845844252461897790475957585138108318), SC_(3.532378654353265969860206607569255622225819771363845061473163430742922119471151381341083873474381177), SC_(0.6007865120537144420986879555992729744236699736471124434353488677459365534190727968830083695013229349), SC_(0.05822841151278409158055984574864716365374344083072258110689812870005284769876924380645439169660439755) }, 
      { SC_(0.38448631763458251953125), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(0.1602160184131685710826387696881486884036538237546955037103994515423271724485963216123416934758487946), SC_(4.416335719828284242329945210114967558020659035274468933043668845590797312357965038775627726162227443), SC_(0.6185160987600060724263371658097224211108240518689414063952471475747276784420988253061912565713537345), SC_(0.04926174599232379578503726442706015331507290355233477246151314611939634101403924070233875395381329706) }, 
      { SC_(0.390661776065826416015625), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(0.016430173339383890180594559573034532985150198113525961969363351633524804479591241444216627126254248), SC_(4.685615222345205677907699236757519185348840199008330404507096823381406218761309263891883376101320398), SC_(2.278039636851141097781739242760226884734164748198420012235599361120728453376731632051746352283350714), SC_(0.01146850902057415348751507103085676245903027757064201169937232242331393529852903014247542047653331033) }, 
      { SC_(0.392132341861724853515625), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(29.98578403841162113068120771318567270628952796422977138781047178607071705547670203055950127562429637), SC_(0.2988888330168795405817126669064617931399165258071879653761072537203873771320550166826647473504882885), SC_(0.02506223274136495670301751206770462963823363116397664363107839810511508538763383643473501818940588134), SC_(0.4327649417414710947998234579565313259781697405094963336516421503729808944682354805014298910631805041) }, 
      { SC_(0.405172526836395263671875), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(0.3036963589745750152918788963553177829455919859204301396986238138859216367497710396754023790912797779), SC_(8.078002709684296936638589792307709417390414531115972356309075078053497182692040884243578929157821162), SC_(0.4628780127600571078413951044851607035114113230072719086705328007319496344128670566273416711265386115), SC_(0.04855137173751300383091342654632369951573641307330426666424434861194037344315488008087583429453673436) }, 
      { SC_(0.41187572479248046875), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(0.02638505759066038530348323320851701173939672788613869515727293537503263062179700909157214462781665501), SC_(0.8066060717537576699029957939955550757613965556378237074348585632281383629520910744708329768022371282), SC_(8.537905712586634201157356658589688669548932586870301498940632205271107450120814158721678800081172884), SC_(0.1007028444363077360813121971046639919847851450940387474609011263896571648846935632336779418838730483) }, 
      { SC_(0.4127636849880218505859375), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(0.1227653861842280274998252888989414384941329948340793993208311418494668825480204925648299425006292218), SC_(12.45940096301951172815903657933305153299649670835565507817423699725458665338628458364874928249131179), SC_(0.702847618272622753479595939408644643094148313176143520249148558793712198835525953322303088501611864), SC_(0.02389778373144462111172791814193958737807443705060041598458104887930331253463516451093496539941518079) }, 
      { SC_(0.4189456403255462646484375), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(0.2169887929834269599745794141981431731669968833906501648306676392874319663081212481595882962417517989), SC_(4.33260432960366002500421044120773776189024803297208578890804958338620724260972357531444862839489071), SC_(0.5982656783009382972892826151180138963747436526927469086697439282909168503149167587163550027425749745), SC_(0.05992074855303405238447168153586702097541479611438284726807107089790067207042193252230379782746152307) }, 
      { SC_(0.419861257076263427734375), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(0.0361231514469032644739118373777392866468231598325321758283850498567479095775047595615065023476886435), SC_(1.270503408508838269219626907332511746826844397155298227392506965882528954853101035442013725109655588), SC_(3.583422438095202584407945402142100471847737510547609963508254802488155365122928251862497348250021178), SC_(0.06562176411279833455001172237891077460520205312911119744294573458619573092124512732859981304187267524) }, 
      { SC_(0.420405864715576171875), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(1.05614170726357390214328399743844440177303477850171963260186661128522791919617034760068248602287795), SC_(3.711631314399999724297894534256478123670470042750752332412940935597231544504648065947185722407417657), SC_(0.2644268328668949040582204684285194749945904954889903516543849594179084459504679541907221992805624799), SC_(0.114548812660366699755722814087837956320447031281597441384993658839662719948132489247457174451222835) }, 
      { SC_(0.4246321618556976318359375), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(0.1291535034728801434847854391315965657326240209996475434457137984137591432589560375375078000191635032), SC_(0.301240411486755923724312779985930981326114900972436022840000322966302795141938870763018312972052771), SC_(2.596011048561817218025982501369747386381054244296173876631488435515360461251278190556359611185707298), SC_(0.7862254959075856781320702765928282294939077741213461698321185690169550380519739836860032454319883882) }, 
      { SC_(0.4324857294559478759765625), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(0.02927591832613120555466334762877961919994588176111887115150926864029444400558487497890814402577480561), SC_(12.13386368758314384940187339235134807177173875452325827353201121731843753220154098429317528374130544), SC_(1.404654882086107221097555780866495883083052427654022582801579621322373079130463467773724416309612614), SC_(0.0091798634059494302631990121698536185991456084651133490994868194903598975714599223167895509569891971) }, 
      { SC_(0.4377235472202301025390625), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(0.02977878571244932542522372748274162602107932861776721061269246460290690530375544930316572771013952156), SC_(1.093957085088248684281977614266314505471737216195722238244952348968662793220465105656736025100957576), SC_(5.577258275423017040453888267989551063104355704485680015015305162176408170047334106821728429244686186), SC_(0.0773823299999660503847307421125167152003861814038840612745795110627662160236265245576477556967585584) }, 
      { SC_(0.4503771364688873291015625), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(0.504278773468822769590298180205443701615107300030645041914873527465912482907260617752467074741492937), SC_(0.07263840637530736106822170508146011970575912077991731493622449144023696783900216315973828565985246711), SC_(0.3622093381465554137051271346827188692786531162047859506949594507926226292380153153192111869545465397), SC_(4.838652370158587363848635389398677900605916079696168579456516019760483221516717100188767695583314747) }, 
      { SC_(0.4543992578983306884765625), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(0.01058779277198366622428645384125702078520171007474573325402143225584218531335138199480628554789113726), SC_(1.676436275641431622365237536878064015307341142739428819240264743349473532299691457421184598386783688), SC_(9.064095307221154963606361663266686017390869947652985153812776332052695729929840064683144204543153623), SC_(0.02720231895098953280988150859969137079255199602732359835176071494766486460807712641866858144580778563) }, 
      { SC_(0.460073292255401611328125), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(0.07178600556277649986358282978908849568426905290098951620891031647768047787291337320554163158594276241), SC_(0.7256946344131610570914547392216204847966985737096911845720103357567629297710647719288931045921502015), SC_(3.480339625520318013942482864490550605544637715217178085135558442548697692657425548772576537870335212), SC_(0.2099488039649351796619160522414933988431776093368843668704723680008756020924309148902573557423869295) }, 
      { SC_(0.461952388286590576171875), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(0.06094626109870637178223630212475307040528508402520956710090952195564961543404434116533046497279511309), SC_(3.264937866919093032608460422284911481264954322006806235972335303918061660361755813696275126936526417), SC_(1.606598389820871046407780232517955524730436693198969781385978894717891063335780995792640143946612975), SC_(0.03958173719419811041073893504655577775583671713795951388463222617181197812361196193071006006691615416) }, 
      { SC_(0.4693518579006195068359375), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(1.758317401616840078427905723536414986465564639049912111905708033865066277512063154634711843805932712), SC_(0.187800787621347746216831275610560776493145289407332641985261501844156276198968058636841550946847725), SC_(0.1161832129382042439226811316484574138671494096171573567264260918717623090493917574823443666247204525), SC_(0.9027824538910037148493471283500298672927443042347325062792636850794431662785830483893853619949497863) }, 
      { SC_(0.471541702747344970703125), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(0.1542769780489241427732313940921220413600662398998852236423154085470310119789111618108095340897760719), SC_(15.75979864645052402061252944707357540871257849544481410698392652634133086012893654106784764544082307), SC_(0.7481758904009601584661294046135022957441785692010720234212659834685453370322731634550343202347000152), SC_(0.02328353394150255219943629039595637630530860715861482310245665786541454468079063062791552867700512582) }, 
      { SC_(0.4756006300449371337890625), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(0.7365536439838779299830611278932377830062529920253289815452392553106722849116831953479968925661868809), SC_(0.04036154004003123214079604793689287999663403663044616502792322545345539857516669836166576621715794383), SC_(0.1905370113415376025702453678146905144485588084136012358459501766706615651663869555932908993232975435), SC_(7.905349549560925035963785417479872617937936051170280351275767833277681754635511991404529849940759901) }, 
      { SC_(0.4795700013637542724609375), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(0.02879620694943085151851879493080322772314171721861423573381737942999436857679813016024254862678171752), SC_(0.8381925311868619315686634398154647562327105148034720233721990318894925467878011657615863982632720409), SC_(10.22990382105470768989973237093926559499433499508635582768830228472639622803918417838359220084146026), SC_(0.1399776107694737613649220008673972473229787378248542987775861896774573531172091549750982009370293543) }, 
      { SC_(0.487456142902374267578125), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(0.3588610400718649204552693145186657856333760371935713182776966780084834276342625744831022454584944008), SC_(43.67560439310114641717478422468818496975280183525576152515703729787850522543308029738728612120567634), SC_(0.5400928160858633410505343552985447673227010890563610052848974901082643660941536296782093851718195545), SC_(0.02032052122210200958933072192025837222984020313387506139895052702595202493141398178444727929202841538) }, 
      { SC_(0.4918993413448333740234375), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(5.845434709170928883749413809858382646545928535148869239682566938610208530717297824307087287403874219), SC_(0.1652201295513301527318834218222332074427923597958865130990786930741008473973381060800884092495041709), SC_(0.04619898671410076118795482731780784942716788132212188282575729767538876939955227513958761618561120137), SC_(0.8641447370553294236566994874888791228395124458566323964192483671339427544634948170511445268447113003) }, 
      { SC_(0.496043980121612548828125), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(0.0093375043373035554211225803488158479211987390269864630311111081789561598929381018637107743405404934), SC_(1.308132809082890285613761094936556799049913083232082100705561555260754511319274340109486423283205166), SC_(17.2620147349978607693371391749824675802309197384797654759399339042605883248052821035459303421680288), SC_(0.04364413653338842182950138265725023328848726420484131608364211755443050667460829235918659320140359827) }, 
      { SC_(0.497413933277130126953125), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(12.48439306635283409096612516175082563364337838314700548864780709243630073581175853247437172361248638), SC_(0.3072976336714965066442263720914633304947524305236553684160683809222452191606540561615680803946510102), SC_(0.03894444934631105682300736644674837056683523131651810042362053384935049257532099916683198319693040403), SC_(0.6113396553914765300292770320177825677147210791254761860304904572255135564259603464516313525476960828) }, 
      { SC_(1.00639164447784423828125), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(2.583164309309920482833333398727618346147032762483864288619764591544064383339897146240172937738442203), SC_(0.8111178595770546378471579416062443537453114246705573110205627813572050729200112085960855891645824903), SC_(0.3706052728893315845269273053811098995621037229880648602060601706064801893711544926664415473594304037), SC_(1.181611165535138473814776004734852654438225685518536343785544264218072573010315951540676040915266589) }, 
      { SC_(1.050155162811279296875), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(0.4819085298281465812563929484926377552267754320888637443813044242085395977994969023199729155766272268), SC_(3.820834612547489594965939161755255531029834436366769946729063755832002994049753133222820289062063766), SC_(1.739357522640581752577837680062192113154652492540169051524030693517045226331416928389018402667089423), SC_(0.216039045314031665562083905675991730318385204313716350870210112881282961223468642766198903403136737) }, 
      { SC_(1.07226502895355224609375), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(0.1441737138829000704541773981592190756211938493379739424182687240481471516312917034598487672520626168), SC_(1.161968094607912482190971620672735787194370295163888087048117509935103711835388678035385423347996497), SC_(7.146380065523985034547022938260507304470949898419094090293105635200511971768115333301618905196238622), SC_(0.9292691330654647109357122868072676335456833415980597645306912673472478706060747891611500702017706147) }, 
      { SC_(1.11469662189483642578125), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(2.506184101751583272911522973461969624219773799022270250762044815118024532773837141090563100305955546), SC_(21.78168366371772885602790648480888089735618468474863008167562682355359445232152299472708715137877426), SC_(0.7720191481685578921383614600216736662089386639331014019255794519384299894474916262368960759706125981), SC_(0.07872543789298592751892831094575998673049933400772137398635371078936678549571237953249431063488720143) }, 
      { SC_(1.1221637725830078125), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(12.48839371165030356036334590704994956157379329878561472492389868561459047691368472143401550418601258), SC_(0.9593205697877590326715623370432958592938410082062975395347372135262203536518212855467120495710885707), SC_(0.08255214355362097285700942796670653039599854587441912537389697592029351584978468274104212170732939352), SC_(1.210675621922532705003033620258773977902250676193118494316899182009190701818713827708363244346804381) }, 
      { SC_(1.1509554386138916015625), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(1.471476471565864033767870992232690869010682519964523296630200763943607081526970142930229251382476878), SC_(0.1021024820779126096567643380375310495488037642665867027917610985248602815866238280320545852011337357), SC_(0.716195835556761493329791092660330704094168640983741485283981909302450625948537716587320208983871324), SC_(9.165631926816083701947760662497046515383041430847142494116546093612897662057664057861891112258252509) }, 
      { SC_(1.261780261993408203125), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(0.7993900169642160722375341125566742814244300283067860633692210690594716456478223718996746269635829686), SC_(13.57688677425490941323922162740246347417404809687663003445194410410056197107218763550430986789271112), SC_(1.565565293440512242125127227929271664322010025899950664390933601581310119541224730322244822173420906), SC_(0.07143576530198148857550924210702214891802051703071464087812478583854350768851063475813800166325122064) }, 
      { SC_(1.3947961330413818359375), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(0.1319662345934989574012203579389327688904675327908240246505884567228021610207582486107540119380898089), SC_(9.064842723568148608974029477230197640426377051563561622681743838297572674270431483493258817294337208), SC_(4.063702048236550760479865515803520315921188975340123794419973638871664684244324586790591041236672428), SC_(0.04844816146855192319582157375251675334646810156473207911579231150239059235160753959156366263564753038) }, 
      { SC_(1.3948490619659423828125), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(0.08189444393120079733034338955049356879048404371297857206839655806032383896008214742508832279401452457), SC_(1.910906026493639740778725361529673160824282389181433120667100228307682290960333576732163761810380086), SC_(12.28935738935472130084740579675314181337408481586848085888630945517240683439004249480531905548551759), SC_(0.7313348554415135956514906626740754042289279515014362113791672524506511839347700083364762209393396151) }, 
      { SC_(1.4270474910736083984375), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(5.780738136753213054714509575659986463277419166701176084015382393301543620865205694589001933043298712), SC_(0.5368040895693119969788633666596125946565735524867685734734115641443969290573433032235816897044946914), SC_(0.2070920941435322226106658266120723432266375817207153428752940053104515368073046670035450992841223535), SC_(2.55697628410344779140698336327664928586190833536300660508147162561779675523265553989356277489265823) }, 
      { SC_(1.5162646770477294921875), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(1.344575373553505311730675256220311419565124212610845710397021394343638336588812970743553757624881365), SC_(0.4655917767307797996070603660520504180732509877746496121569027618472112922008580871500545116792071928), SC_(1.788943652850099836974596445115616715811048200041835036255213740320215749002422854034301913837538682), SC_(4.696701324279856239851520275163444970654202126117514172474711934558318282113129577094469070550108214) }, 
      { SC_(1.54621255397796630859375), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(0.2430096220272475538431341554092756171199149225849619307039468661426361250618184918575778552704206274), SC_(1.99879547025123787418798171011557442050137861356168536001798285636587657187077256489120383024861221), SC_(6.836152836510254591868603991945422485316148414477255077031948694958699991661321768556483487419433476), SC_(1.016422149253109971409413809940151154300795194628031281004683040350923016635835281610254273772290918) }, 
      { SC_(1.60629665851593017578125), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(0.07095025305466215587284866465122819745671477073385186942480752344206674116710707664156528380958992057), SC_(1.462167865942088845956391896226229073934385924064470856264567873737217043645431723994685150640984064), SC_(22.77950022148668981604318196389780228433677971329955867005432474497948682445306657507565992153201716), SC_(1.963513169368834353427158764211207306663912464164969946423072455275798878521021206919466802055853554) }, 
      { SC_(1.671708583831787109375), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(97.93744556459864881905096079484231062876551255070498620194881661120418836411609927878338697778861183), SC_(13.49500939766188294028728215418002726664587198980540979448687777622699647677752181275317899388639596), SC_(0.04948347937788816061201652394482274337325020389859045482366771300715141517832311878000375679616328546), SC_(0.7070113979200805425946667343245425835879428903231221607510505220879604934479407785475102349080881073) }, 
      { SC_(1.68060910701751708984375), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(1.280547872356325902993529219287252629771032390801150137184797878532458347673007010198934623585206981), SC_(0.1075337957061317341840082236043699781838638598521225297351573619808522342289837094616455503635146907), SC_(2.862645204297701283718802697311945474109948344199986565539221931049071794365845353510285601456920391), SC_(20.55648230544560391217000392873182602964554710377640816982535159118663034779353764172453850889990701) }, 
      { SC_(1.731689929962158203125), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(34.91924234199382841307410216031548541117003317337900648975021265618216444177618526936934152595033486), SC_(4.825435152180760823301156170724075506386739838200411866990241695700100163546683418180599953718414184), SC_(0.07867621218928683553787673950382233504667035436473931912136063763411206152952118058330449527512266445), SC_(1.064088430783969169465660550941206901050925496717500929057756972208657171799654391573095265589956315) }, 
      { SC_(1.75962197780609130859375), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(0.1488893467206690983885000920026130649785085460870246033715223730297664355723385839781012673913899804), SC_(1.081450118592211850584880731200312341883493665034165599648926454621152607462080420188911921577389173), SC_(20.01523064570746770513555753925820303990313181253065519599342193729496933217583375333045411469735505), SC_(4.276669902857975535711042160820902529578969647028121187093074706200926046762020507509388169123624833) }, 
      { SC_(1.791239261627197265625), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(1.556177829935897434862448619184652225195615152425073369561404435110802055674794917298813499355671629), SC_(17.91597014951130578426174681547246916023527931439357157575119935679290159590649566566079659513339768), SC_(1.920221386679661955989906872450590901742184949711866132880181644424982700387849028158730412515147687), SC_(0.09011693368305316313058712783667136165340528769030468945380923185442827152725505822358524696933334351) }, 
      { SC_(1.90620529651641845703125), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(0.8134584673643854168066407376530464185726313764654502416078387322817246837576405470190126746845990832), SC_(0.2772193829685320856328428268169219489132366167303053781960668934232821345960544570840178711556218616), SC_(7.25649112453215621105088579480374050070734972878105479917349713674272238042573936424251454151563249), SC_(16.40273584303819100160763506879003950332393616170159632053723811461443937788194676098840633123781613) }, 
      { SC_(1.92305755615234375), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(0.05989098510759025549660741640672545782777257521685023129068397120427659820771493293842851086212088968), SC_(4.009776240520559439337258675296156662772183644460808361729420621592383153308495330257454723404660907), SC_(13.61887123975641635007543342623586971641183100081400551527945332597897945505428475341803500296524834), SC_(0.3689886375674207838665869298591646285962753677358928297995563416857725090305235316312560574463033593) }, 
      { SC_(1.9263775348663330078125), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.1410485147984004171437615169718987873899450279134959453634305969907181979248009125097646346673986752), SC_(1.203044334770010847175515429934876777507227966605250801288254321527590226507904695566210202755401024), SC_(22.70493998037175256419005759181450414994370713916733184001249649085996484640998307999112085587474292), SC_(4.572274846261589537594579695226528662273307739636039702857509971355488798703241128786500233998819253) }, 
      { SC_(1.9296014308929443359375), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(72.8090810113904232207951434601216319785321116384279121384422695847817937768509449215541396007798302), SC_(33.1763969493199051656456675566159691125270666373451758034133477988499218352333365901057146066519393), SC_(0.1415071545232367377252437834121282060041400478847934231213824715900917353252017225834938568300874175), SC_(0.4357597881926646501007939629430372689224798314125735661036757033657317437798057614251859332190462341) }, 
      { SC_(1.9597280025482177734375), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(30.51653998313078434115723095148348589774253147817209957014448555523313803076948640345715068638848628), SC_(8.966808428670668615647970598191174195733840083160772118637330929702325868563831672214722463450832849), SC_(0.1548185312526636378137303934123127774811578425928171785795479690322778708247955045113608382840691688), SC_(0.8438815022451979657859020085481361541852159379653761300877106099356351185312840993976491016450123214) }, 
      { SC_(1.9800770282745361328125), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(37.87045387429045111009503532101453837732076328784514140064737059463483750740507938669329773870266854), SC_(6.47866363509068248114558598566564468231339097547229852210529140812124379673349108022420902163703531), SC_(0.09218186157788265031756276989920883576728962447470827811047785973824268912966045053584825517682740108), SC_(1.096520379544903780601680576957821177669724159266257903442791268759625095058567155691124779922244272) }, 
      { SC_(2.015772342681884765625), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(3.930928884783387053285926897414468984252200849047597637179838418969438753357035051537235827725268661), SC_(16.79651567636131713791254305046818521138202890223663605003103679414973775485457492584002684958226436), SC_(1.361773301910556457637921304722680156103887390120148551305197758180527290243283418410986116410168702), SC_(0.200384091921042131236296443074980179031172403053229788433149101020854184100269310754887826474908758) }, 
      { SC_(2.047484874725341796875), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(2.672657604077981070403970193040082354472901960179440139490023710902456645911573655217119293941952183), SC_(0.2594182685417545882794169238496182544065691906800388257885689975439310937308492141367746619452496744), SC_(1.309903258132699709277962700205583714561514507898330105056784375571398858485533442608314586796403644), SC_(9.421167234448753594747047743752558733497491009402249909866825942897156945755462779060836242089666261) }, 
      { SC_(2.05790615081787109375), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(1.183601757089906857270692389615690875879127086933406057189741814071084168171518754741337194140929189), SC_(29.49137810290674909870221199581406428599662895265115961224836143382545568943577545652985201047332573), SC_(2.592119496128930839526131222476143580181033312800965808015246664723648251901096872112123829148669532), SC_(0.03325764023294514766853549107639217410175005880023681630595776860279968599887224947801787364383784809) }, 
      { SC_(2.1463463306427001953125), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(0.8435450618509920190399363331729189111759944429972861364079809028991475651362802233877571758037500538), SC_(8.592945449027186106856543981571353559472024960840473157697028638850512483650397318729437633263745263), SC_(3.688709209572174957330306383648171532118799292863726515504643107420833155418599577092736672838383523), SC_(0.2653980409202751840611362376487067287794202214971913103597945568261195550518944896477844877861940504) }, 
      { SC_(2.1678431034088134765625), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(0.4014071308999764975345127438827833411472041917044899006507950157455554915543097148897195742117373917), SC_(2.345492605606358952701238312764235355223658186515451953680621074037260655257765602528850741950742887), SC_(8.459839376488632787650669301187430137703523937780489872252324803493101141514965098361212258576703022), SC_(1.923115818098125625251193451035526247944417997864148849269505016120361510960456283380702793770107077) }, 
      { SC_(2.1962072849273681640625), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(0.9187243308455876307436683159633605969225513248037198972969586546277005968362673250096199096674563693), SC_(0.3214969808239116242653646408742528344553980711005926956740735986263313645819443488329492330010287595), SC_(8.199659419580172326041720562457431561494935044278255209325402290790322089662888374611510183828245738), SC_(17.49390836739623818042107919547668822471541901877611577277910438827384976048376782512062223101223779) }, 
      { SC_(2.240623950958251953125), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(3.383031119203994496112794342642480614152273735106610346187024666962094322947197986655684614146841013), SC_(62.47802914959336497597432003191008678941764071302291529579465727984564206148244758241167942272984408), SC_(1.899048043892279237256477179782019576546101811888663008620201420835012761232419116561394209778213946), SC_(0.02229629946863944760912244328172500929706628783717463033360813768507734246888022568175153021266692758) }, 
      { SC_(2.272928714752197265625), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(11.09714852149634706997911845573998328162065347459511819184389839917370494174350697463351698038476189), SC_(181.8040176669067718575748984540346780811321823684117509263624949406470806881170703836129663760424218), SC_(1.2750632535879094634975130846750825594033932572731329180347529107453569279136031286608000734648438), SC_(0.01343717090119828656936983688897221142133728254818679479817531739937246958819994160770590086266313625) }, 
      { SC_(2.2901318073272705078125), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(20.39891390495796208624544823608773582352537034306049615900718202296299357426961293395517680859642494), SC_(138.3152658195656175342400748607141000686919315435277264978038872922665187087885747168286980410851988), SC_(0.8953560081984017883856316923398713304610192678564092702259760940117134755501321289792810583153042931), SC_(0.0419453780326811077239743591807798429763033992073178175288351904038888183648917768960603736693951748) }, 
      { SC_(2.311191082000732421875), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(2.806957722661207494513680793565351035184651651193492219780377706796782311612994763014949639281424349), SC_(0.321051717780296296369297571665655811767178572517923471320109478969763644292470642737634093208122655), SC_(1.686617665244106427078583035664462330046359118097679008445842972592872793443783020495185410515165495), SC_(10.07151554500278891113255730731871321417734672981026331678274758500572617140039710824880643797674495) }, 
      { SC_(2.3320209980010986328125), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(30.17392836791466138225920226433884249511703994454058695694616773756996092574027968501708771813087871), SC_(14.67795296032780265266633959573733107052238856851010670988401546262965022159933109338819178767063308), SC_(0.2515237865533353091854526745529551008338694721917042646255422959923853901188547219973095982122152806), SC_(0.7346953748020346980752183886924881396431369495226387951038883952978441428834114292553640835545138954) }, 
      { SC_(2.336652278900146484375), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(7.063548142910021255237550337937577893954347485193616490351766712078603197684051224820109153794064557), SC_(11.67963911847162107254247534959577955933734812410084033607073355908285648661673211472155934728148791), SC_(1.030287669167634459651613919103381614714804742700734988026350463138043983475413236189580040884631538), SC_(0.5231443583273954762922956957802205482337057973599644621445679438063906453645512047181401228955337916) }, 
      { SC_(2.341427326202392578125), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(2.258742845403549052090496107755989821343725441005563415164774042104937612606951733317612881182911768), SC_(0.5206780088506455827226984816033452837131479596226830167583861299139619399875505769529235789088172852), SC_(2.465753451449959073292624069163699513495910783521908756802101201724944418056248717158080996798358947), SC_(8.316266722006382197488740334564248700292899320197703544001169234730549409023199069812286979771103428) }, 
      { SC_(2.421394824981689453125), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(13.45933571113832955686167676264275533027794732473112356471320906053745177269611767487516923181608495), SC_(6.464988528280701263939076260557789979154327451084538102185969844542680894484715484293745756677389912), SC_(0.4445805230025789356574239291141222939825207869914379909311955213515609656941731598626787696056438121), SC_(1.210999952349985200839594398450205087541940105990924052121127944323929709004988367290577001916606792) }, 
      { SC_(2.46974658966064453125), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(0.1812631819488254293315678795742584691678317304650571037635701565471600534847787362649214110693968691), SC_(1.42299451707172020452329811815370681360375211668876480333196197119287834704135067870881773918512547), SC_(25.93275250977447975972110689916701190878334583248021608283947334604747892532398447699566186068442411), SC_(6.375752055465192420962510265207923170258258870482855741148881217052466796943697003410067753842489549) }, 
      { SC_(2.5390207767486572265625), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(20.01265570017142774116924587377499975589319782293093031839816047481855399744250132462701145118175168), SC_(4.018642370310534141611017418151004965466327507264058562307146131911524276310034524327266888654146687), SC_(0.2003941235331129416818017298328648112677190693010765790826016114145566340923820454329112771705500769), SC_(1.941215444579243436931895940346914268393676624257155764455662756748584651934859556566829780325368932) }, 
      { SC_(2.58206081390380859375), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(0.4432076207602274762372646158866698282663620217305173612330996052442495012153546784142856694354579657), SC_(0.8805051225017589962263676596525830634881481060143527764099528816230405636978876623328377961142348), SC_(18.43455876769000146961760514039385047293728954305008836658588851393615374388106772690890862327263159), SC_(11.5433937882210387835043676693487728987982626226848079030610485041529975335366574855901370297015484) }, 
      { SC_(2.60607814788818359375), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(3.926227989748608343157257439867671470036980909483144410391428581987462211501047918257402319077349181), SC_(26.1263389910151109156033793131486018666697450257551070028273433858847209552516887480564050828035964), SC_(2.088615480081908604957389339075916558576742213280596991301898648731622686480805468069936093799521361), SC_(0.1280230688229933990993533916612090460930910905817330549098567689009733709935211533895383084324246833) }, 
      { SC_(2.60628604888916015625), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(0.1018448882355728420015688282476001318372802957501206687614120534606109117380480919058905020698968573), SC_(1.773469277790847511918471920482343673438097318236129671738465543032529742892812236708981650672788174), SC_(34.91200735121754609055525545308650930604074348539859152472440840753148130145658020299724464093941729), SC_(5.435344034372304348211379660221222956484723626629014623055318599119155624250180088283833742325420235) }, 
      { SC_(2.653162479400634765625), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(0.03402397494624916667200349893010483783658202154834833151077445313920044973231341107190237978526154636), SC_(2.480333245006478382760763315169584331137857595482959505106784635608828472092012931881534268210314835), SC_(46.18497313428005988415650660830666103563542650697560085295077487999114172227752234949217321681314033), SC_(3.092308411604439696438156138131688638169460540771492364413801526516741718313715880521869262702349414) }, 
      { SC_(2.6959133148193359375), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(23.94855598585706047619442987905253261389460263209411819118345898516160267237369739281337326532905054), SC_(5.136401556631397570856782099949577724893508946770767700647476204150678915985486470971228509568151528), SC_(0.1904990842166798133533503374564147685326498502776445054681783577994022214301001700241845605902193229), SC_(1.850550260293175458768864340875495731107756561524244345302371827521411295206847669282137806975107403) }, 
      { SC_(2.8843536376953125), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(29.61670107567073442080574748884869233716157632919463400813537869910313008368409498039353342044474303), SC_(168.7078460811229830830900728810523639906650712662255960396842286555963701027772214848943744776737507), SC_(1.002411731869276399512482413329718951918007217070757361392774981469306785875856479096958789415725069), SC_(0.0431799187954493334380701646437612632235360675360748740609130045387069639833256173511740190894190521) }, 
      { SC_(2.890100955963134765625), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(33.86679471907637984113795050682953829640848201025247212190333792353168812839241597885164113396730178), SC_(17.79554833290217214070335235970517477186727649493416258433407032901092383189298018156684018367377573), SC_(0.3064467347005833633625004766718934196221058218345628252522311243878108063228527287381528358490859358), SC_(0.8646494972009318672393867213805464197057591897696454847331823534843512750058694090911378620017242538) }, 
      { SC_(2.919688701629638671875), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(6.515124026900758826318944632759172231932748850175691230056289511822919465169369593872004447068092387), SC_(23.88167824462119552841223291078268424252658838760737079891824973695340637368384149725208775801180538), SC_(1.778104429000833542889499467752066478849259790577024155119246752946559520670502009479099954403458944), SC_(0.2505906787353307283625935614142520211534184644861723274762894150271637119547850736369401366703704598) }, 
      { SC_(2.9536075592041015625), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(9.624576685854849558487676124400217337000345550832827022835328883804636719382637060511646193139355496), SC_(53.04770499822952612439139452862175521431708252224727726779212785099416906647159701488341414593491224), SC_(1.59247545261098354279365783715688872951989833800499977917464392709709240241583151650245952212083294), SC_(0.08994136722689350642551717243292319137967073648569052768088480863204162963644812820947027841225309656) }, 
      { SC_(2.9555909633636474609375), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(0.1050587032170490286257280301728763256795676956656159247915200109613879197139985680424160463144507266), SC_(1.94318074796452454244157034778783090511386319271486609432012494787467315965387631712210447234913174), SC_(39.26022199561925383200297052558804001884165349124967184842851789726691498761190095980233316832606528), SC_(6.490855877921184953220605255257781224581269082678785809474314467505682629042524854598143664974942495) }, 
      { SC_(2.959605693817138671875), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(10.20445053389312812319500056334566674919378170983586356900531369190087197438162463974914474638842098), SC_(59.42724715720617867392507966761287308057733743600056027636731241550111664018232593529842507799132167), SC_(1.571812752708347428933260624214768828869716106065118746119078466024241365962998632142829314122192475), SC_(0.07785853582163706167475514666605562093326547626324984193512586547630389365245809661406319275749839311) }, 
      { SC_(2.9766957759857177734375), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(3.795494240079260421268817777419055904914460240718869179304921988043922807785975296932981107552477173), SC_(6.152652362701812384495902004572921244157076754389275875984983694082456668006621635754742602490756824), SC_(2.422491168203587399144995263368603556723562359472166369856292335037471035989919715052532038212264525), SC_(1.380142363807201986147299288359247841985518292171120629252578805701457105057516833971339808347935275) }, 
      { SC_(3.0000896453857421875), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(11.04550449148392114032266984944040465284551283988868808831025514608502485028696425384577913140849195), SC_(17.11335890336174907838363993901072071662747864769624967821530732829680381315721975551341841261443704), SC_(1.118993825319365221748201635578189662659630830476957292637367551615732831797081039086060364922552052), SC_(0.5832658480436440196847548856398053755797384304763678601726552537147192054445633229873301874570470342) }, 
      { SC_(3.0018866062164306640625), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(43.12128539161953056111098501164123701175976947955350627788141294966977124322208251270037852162431805), SC_(143.8504164825333342581432253984862333352074613418615639205492583672660921545049220700349090410034173), SC_(0.770130964388065194534532914260537859457356890052276072378276480654749169282954295011449245821978492), SC_(0.08678498289426542935860931911888119278884224788146471128195945797171134900499843746248457102763914771) }, 
      { SC_(3.0078976154327392578125), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(9.727572784815910580934978505764503444393932952939500595465223602633436576272021891060535886173958697), SC_(1.931377340502386407892792197201147007254728531567762583391430779232941487220610520173377197868238363), SC_(0.5933364708483050288356539839866376082848737501081854346829614467302515310493457951512439021745020478), SC_(4.027886418368107244315634680694939280724341021446770685442741103232922706776079936207967791918822846) }, 
      { SC_(3.009449481964111328125), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(15.39532628651131227727452427425226042907252508118556663771534057470049043438257477665184870157652211), SC_(47.69771286054781816989805773890276442182757343408642857062477804306704863346367661812506854710026647), SC_(1.150816761833153386112498971933973465626994008717736324864543650733841838041642038398942765353341717), SC_(0.1725573971542103598831034026167758082443884495331686786160558819792543981074012916405297187918204404) }, 
      { SC_(3.0554368495941162109375), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(2.507560281234090915474223065704972270210142322980503975931083811270048758418402142638599209087984984), SC_(33.26847163484310614022786890923724704104304548473717703009955290769607887284075925940343648929910238), SC_(3.355752875098805463933432940823354608613204569034323128162181651614806041376795473458180548911690945), SC_(0.05803262924450953347753868414665746106145801016463026292076400466230689715299343239787932359492546609) }, 
      { SC_(3.058078289031982421875), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(6.11624648405469027123118984971024349595660251860309560001900742712493365021618901190234275668792063), SC_(69.99202017693598130464270156801102536837989667237139169477606796763944252117582607834735285075314836), SC_(2.241903514539417862823299123585391838747017871479427230267815565609299682558336588503304275140805654), SC_(0.03033925706442268647245346686169010451243912902681488277136282806298818244750798824726974933202380348) }, 
      { SC_(3.0845432281494140625), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(0.4833726109529862368697631998082476396865919472114488024338503057747153308653479649495666103192920257), SC_(0.944080382650503146894849799306557810913878834708901092489152240707387553879934106966483698838372148), SC_(23.65318799914549221937113895869190303891011443290017751616232778623141523428353218790878686609994971), SC_(15.46983430760853064487834397871803457670082982068347954420018080606454079260011950541283363795436296) }, 
      { SC_(3.187222957611083984375), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(1.356020073359699748463879702844081899985595313131936826674460319639231875380491041253933504852395193), SC_(0.289582463790103190625165420607769363482057202939789803279804527907373032283932762316699449761937343), SC_(11.90473847257463618762930319032834444308874332217674508749702900137939017929086367894212892938430636), SC_(30.9364699358896633525608533050952593667186464444339215359044190442961303442596560515915040456473774) }, 
      { SC_(3.3068859577178955078125), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(11.20254139189865259459016100609649720388838827574478803064750044066982159959557325090504144156629517), SC_(59.09339718546666284907231128357702080822062559254567629587275284009911207409487272115581798008147119), SC_(1.729388941400656315627099871910155143990472864844059409137997208907795199657405016215709990750539093), SC_(0.09076555534644585075370381177589519718647521984036762469241606098568455480116889257720052609275830288) }, 
      { SC_(3.33138561248779296875), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(0.2341983317479666106725364393349507481272337425989925871859238167523093089076296440722382337041355467), SC_(2.968809660378935081316114735394381074032694124021392772548155013939928268215315013043773364066828815), SC_(22.36009730397223077918748210973351700917030777845071296386634044595192038178474537053735976900611046), SC_(4.049276465791344105058178490375047239706352384292295622354132575489353693314081017996081061605907837) }, 
      { SC_(3.3842318058013916015625), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(13.30330977513927171593217787760742969537345240079563129934889611581249614371309143350493900697053613), SC_(64.3980492474164283994914921721505428138505496201558367875916228622007162634757215889164850562435892), SC_(1.623143285386896535166171896127955190309689421607867573185787345733747799378486577561877431237876903), SC_(0.09444125580814425731416801731089246103706108508588727690639483112858612212947632860817975493561592918) }, 
      { SC_(3.42371273040771484375), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(1.775792312241347043890492271535084810485025953722197400217776240038784989902401437130217797258424534), SC_(0.1887482662422198259853966702110969182064070651135908041384889530248392417441297736817772954255901555), SC_(10.28119871317598416348072660149403433821137539146641334349986463604642603558174580879232133198683378), SC_(38.80789692162145664031993356719790959226149607354790230176322045332468620418052812117420095837552814) }, 
      { SC_(3.4394664764404296875), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(54.97137102886041115506621054099677834235256878531503367997450364008510949874872719077815417747605576), SC_(14.21135647956247617780522387080934379486027869711292455340497222796837141925397790112169807258007452), SC_(0.1382203985182986282608409790162784475978619521050592853359937917259188997239302338715079633576289395), SC_(1.528803899539608575915924702488039497485159171181208051386897338004534027648250041765715875909607148) }, 
      { SC_(3.4436647891998291015625), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(17.0350371843189475833245842758803442743812833591160973278118724271866831887566051941092792167839248), SC_(48.92064675911398497772608551581697812933278127600881536455643850692951991333172947080466624605723158), SC_(1.292568018222769442101267031740257909347622160566655499054104710268690601907117674145555637333995456), SC_(0.2033132546578282410309974710419268389085454916459866182322228030377977449016020141178414210624372272) }, 
      { SC_(3.470665454864501953125), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(46.24751271410537436386288838049135490051726894284972820157053054606413316511050370114341206362436425), SC_(18.82016658755047229583144030589815150489606548805988281581860599185660757863744942371297579231328107), SC_(0.2457338217992512157126686992628688126598713090720928888671464969252390062478268872884264948754936971), SC_(1.182929720710810155314299926442977371366219837241884031805734614690130158719653488255610072339048168) }, 
      { SC_(3.4962403774261474609375), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(1.921257934390581025258980988319815648754047440761404110670514194511603475551375515016510485734680478), SC_(0.1918251614537868754854858414651283953156539515261841477615434592581683449987619738184330555829643097), SC_(9.528656514543854005017426223319287183055337209554478365194185512347122803118963319352495563835412419), SC_(37.44287048782228271720256595122310725093101903547956837516173584458692069690352083385875279278924882) }, 
      { SC_(3.5458743572235107421875), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(0.2819848154788845843881149181050840073789997853435906091030785693017399755806218755026646502826212014), SC_(1.647529187129869629270687143667627043013376346152319383073011748783009667392114954697536003065119853), SC_(33.6745031918699490887747743279554112043295699495290993084563061054932370542493175617525587237342688), SC_(11.67957889829377116034037653506821058863561906015503564336587486969252663409053560471505676677529419) }, 
      { SC_(3.61502933502197265625), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(9.419013731408885203184972757873982589610898357264750241889510103418932035647172626957065456556059329), SC_(3.421170875179892928709904560936395815627829607190522805874942019499152507428078185428651602451254665), SC_(1.121762387568952939937515405709689303440779465579510124102012791680908583512022946621194530100292151), SC_(3.768218619889613240403971148894293231620116028762311227041891848271740880991496944749250102239983925) }, 
      { SC_(3.71654224395751953125), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(1.550693287866117859540735338430534579644808615552639612132840720001159043282014734158020837544033292), SC_(0.3509681281664295351048808180164346792349555514487466578623095279136663041480429359029968262945354923), SC_(13.61817949025468028250238842890051717007228772036093341035292541143599244232311121767849957842796639), SC_(32.95307958089382809763551849990447992195212590464869849202730311435622100239999967641374740072049275) }, 
      { SC_(3.7189118862152099609375), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(1.372405948845613683589387850847296191671789848484687323393953407826505743427932716856485560765207867), SC_(2.360028114308886974576720922841952075629843256560000625422536307743272973336999210932864083623735935), SC_(9.713927424244366950219282413582968028459447172890239590925983586035031211159733626633420999769753266), SC_(6.379975022473435941380545054282097361601552932609986051822554355453767789865379319100031898568608305) }, 
      { SC_(3.7592051029205322265625), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(23.27095147028188951113737789071480089256816092593445372274778021269105840196986315731017562549256409), SC_(13.05823264144558664826459688739108623660513882387618506810168061952888740986802835964194834860658155), SC_(0.5913166539727959436119725561737792255987830432535022282335891214036950774381846430859084081750782128), SC_(1.485630497220265253690656955611726255916811555408670378566672415436437699624322294506161193720416606) }, 
      { SC_(3.794983386993408203125), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(8.28482146918193673164121147941323694909634345749594920728479009565450706552174140797201279075158293), SC_(25.94815165339764153917407741665948547781433123191634933945243840912283426489566202048816919747417279), SC_(2.267952261245468867617635739911470515828048516567574073237840563787754229774057090492355834802748524), SC_(0.3710307502379167562711708187272790426441726166823888000199731594566579060512281783131708861538616412) }, 
      { SC_(3.8507778644561767578125), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(91.25515666405600194917176818954397631134909332825403807885260047597960480767668669991768070346233061), SC_(131.1140540515188102157945709375258296254676082223959522836866010766650452519411318991364918078316085), SC_(0.4995388844428405668067506008072913437155675104382968091651976979492628742302683071722892125763562345), SC_(0.2419153868209094487520824679101208435556829942277621139450797500980623538273840842020405724384560328) }, 
      { SC_(3.86014842987060546875), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(2.207599179479753013924854118572093463818381662212789338973521699912659827345703938928368220394660628), SC_(13.32775209098056253581399292518579105572736349309500454617663266224841591486285412164194609765804866), SC_(5.486916368051866531360213131328265820273925297750955317832557047315092041252711239444599373159744555), SC_(0.6006453082954876928834260140181716074865809480167155732167594487231881355862273298839510603116135407) }, 
      { SC_(3.87988376617431640625), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(9.044878482914593881787994341715088316317395572477460008437100284596824279870311125461901921826879424), SC_(25.45981250614900009419540921694575908444187486491325717335585126127291012364120611667562613913525961), SC_(2.187051683318218201567441916928173770045291852790942463683906589322228097063264014609191991303193594), SC_(0.4231175398391724798402612864816239337462359617258089474766354732483391852690359466517577155251079753) }, 
      { SC_(3.884910106658935546875), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(0.4414868789434461966773122364048660050219734854185813108660403438221473008358579556438162695055457786), SC_(4.53450538806547378487101716085113920679653900103380796485022587210759530891283369527881962871697246), SC_(16.95962927473961405007699983298854995942110088466428530976190600271008868865801488888786300380788235), SC_(3.027906851178664691847930411226231528713361313223827007351966779559484021737942070310641052614246081) }, 
      { SC_(3.9762971401214599609375), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(27.98779086616150129448721341029854306524824354552247155278102050065368079803993464750758258652668381), SC_(11.78323522449240618280346609538662409923629713996210910620737425063359073680710999684347969932304999), SC_(0.4524632502401674344934653194803029610370979622274248782848782084165856325738339106728445882914369634), SC_(1.865903625245375497962284306527664926376633177454906150107415546323073962339848507010213630043059373) }, 
      { SC_(3.9876167774200439453125), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(68.52513029556652732593725381019071025290982522491204883982734185193405110645551569674490096065687766), SC_(176.6975417993779916619115130661361212790368639205345171124564489045754360768756475013841759817139924), SC_(0.8116228653580829270932696952202697997695762407544453605375909972042637334709905457676250301277844852), SC_(0.1141256296587110902908878673174876082397664656031777963840697170188095558072105035312212848351253691) }, 
      { SC_(4.06741619110107421875), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(0.11058170791870314683720171739646651930335210092997438513177500758673680273792382492710866983734791), SC_(4.430862615511827327608336963740428209309698855717493239189473697501352378552289632256791026441186762), SC_(32.73812277904138847853124293616128240603268758044853924099196876900174755797700000114382673344413414), SC_(3.45270364378382770542710440410931830835818834081454604427475890239798627286749909434358772201738243) }, 
      { SC_(4.07697296142578125), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.0572767918169409844884476826327158521145058973281251600098518420968398458795231979356549384154341283), SC_(3.135200160884670678898283784330342489068308703702522545787461616947402194349354168880612135985801146), SC_(57.28912236576164160705283815889990202508681605307380601566867357112375697249913505602483972932027733), SC_(6.862238628639709759685761941038552117841604598680905761505385266144783875275783203232398419946279875) }, 
      { SC_(4.116207122802734375), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(3.45199204373876928592685332171823391595167941275640065433297014779299276336249056698436294135879122), SC_(11.63819665658896046297828661984973970054640784825934164927467616458546521075482779349619562827299295), SC_(4.670907938081481576672730118774980288220366466202968301771235790438007527843679739946268245130490495), SC_(1.063057696642834287907005157919704881299537532938898048819539071022927541317282663530847814179315484) }, 
      { SC_(4.18473529815673828125), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(0.5130657208901011972248562535723258251878958911765055234843038137344377176617078088830347069873525666), SC_(2.795386234258756627320801657600123785812683545901062802810212308592172787636614555502130733146159595), SC_(22.80897761124047373328162084736766625595389662708604314242183178588675377712205359202180869452319051), SC_(7.550251995535043985976020502998414789801050165962480840592389889483538212384627869198170202815479934) }, 
      { SC_(4.221957683563232421875), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(21.53226451487621872020833162652878884240575263021983258737786472367949269748207170174470292011448168), SC_(60.35993364081558519531686402188154680061441178917461253870034422144737922962405238220348665318944693), SC_(1.521544162984732115078035377355689214806475878530771103328573750236168651678357368773714322096662541), SC_(0.2141135363809613559296153970982644892893379926767766510345788221376406288996500030436816134047657624) }, 
      { SC_(4.388438701629638671875), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(0.5665626448958895848194140176333102516128612849658766111629790078406436924108525209311628771906472454), SC_(4.78637234389647820546638629482872896219447723995900771229854411193072131685676707594501517803836056), SC_(18.18919919267989458485197833155880580701022264886589863007891018632139367243189125311092835320353725), SC_(3.83536090705402927757517520340794163108531483164561710373621366389227572475725043371933843308216297) }, 
      { SC_(4.4377689361572265625), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(33.34767344213198744028704992125616118119944980266486879121872481779687063564078187116743893202516529), SC_(47.11614395346362513764746781784907131565162414063957671672648505109064219019257521566881838488063135), SC_(0.9732588448331172437115224369816230123666184017998670297919090471018512685472204161536936901854127666), SC_(0.5081670538555120175376198950282186252895667383804745217908672922768706511853712124222050658377212978) }, 
      { SC_(4.53587436676025390625), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(3.170296071544009935717888371957955138066638581713202761957548010505402746068075253218509082232922059), SC_(0.4787016445281691012310808242224585131764746602258098078493233907704942820356303353316281790412159077), SC_(7.746151665153463748709958173810476077543558617955152524725452100507023915390665159317633490972136553), SC_(25.78079473919568063782015431557301231658257570614611064764612426264057062821301890499473841496281248) }, 
      { SC_(4.54067230224609375), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(2.60492196657290569900233276429314817145963761894442328036886573551718410681777795333807266532239689), SC_(0.7241425953973008406366501193555858363337261577308327231231086230917089162750738648949718859471350275), SC_(9.681718064089381245591881434425978842620856879553817582611451278452681518148986262146200958353256869), SC_(22.23157029289075200462438461281464430962203903333065195261614183610990443733845225511908663924528189) }, 
      { SC_(4.546047687530517578125), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(37.60914394921168612776183525252742519490281915273397288747497180693191705861184964299015177545106904), SC_(52.84474009653989400869296589975201577554635038799231879992385291497861393217917951338522780638685563), SC_(0.9353572393025890685288930375626827967774109691276250948344795576072498191727727332578886203279303935), SC_(0.4862471711854050610169617323852671448120136181061949923720430905146073135784196665611298916270104597) }, 
      { SC_(4.563690185546875), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(27.59761866261354764229786144328231107077957064250309192610204752370950958589761374337049332761845305), SC_(12.23399037923180144412326821906533967277298100836880476045262055817300896946832268296640542635097227), SC_(0.5909093854984993382779130763433060235952357526238536472863148576307037850602929066240366477871400309), SC_(2.240798797184627933962261995972836082692486279543097707564311607621820377479841327163449787998819319) }, 
      { SC_(4.61488246917724609375), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(32.80875585737473339036392370466625977569570816998626801123937309470972480239728692638109180490986788), SC_(9.766584570531657616944488285790857304032670723738633929468875206480406617004290928821550720682333558), SC_(0.3670246431972060783343039884339422306430996193539977564398598377596397845245050421485298200592618222), SC_(2.828254011004884566488621816168162018172044015861884899590084315271904973340811460495837737248374821) }, 
      { SC_(4.61888885498046875), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(9.744109248917483186750829901971991131237311579811333869454692662752036777254385151444367038071262055), SC_(41.15848751531096914855272275462565791084754256962971249898741189302370612999460856000113321796262596), SC_(2.932379431725073225903177952856152674923233561861514790609823585102746854087238596784643586274031625), SC_(0.2248907518849285416193076357680881258448873715888198182247990392828062141737065950463269067506252082) }, 
      { SC_(4.653147220611572265625), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(1.154125340275498968089001615116200906708892145733200629575815396511521403549186042481209972429636168), SC_(1.992967449080759211516569705413698116636519464988692578482404016629457150290061602020713534063878342), SC_(18.50894199839147538012690458232075540027430269119545669478888915788610932773112826238895523557142242), SC_(12.92876556720551210187993247755675900674629693085612042297433994431030358917912904201750960834391883) }, 
      { SC_(4.73700237274169921875), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(70.14357718758049051192501765344483455430714461117038658496621915272413494954334503286033325038770703), SC_(23.3959073540470641903977585942064940805153252999181995889319636384791300938695151655319151656004587), SC_(0.1953484631853641004343154069813907342521376611170922620752365756551429150020036523567817434698567206), SC_(1.757408228108331267611257853425549699820137165073273579826397261467089757622916315762847847541753764) }, 
      { SC_(4.83688640594482421875), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(2.295932409640882289799152098065839162065474271482517136855914461479020684875065541582617434586680994), SC_(1.02756456437565408262557372134864065547629420486845778535032191504253290730215176530318648473807666), SC_(12.32408972422848726282830014680997154627855290737633477827040240563449326256407752206097715480438861), SC_(20.77054313809302498600696904679672759965812440419428867070968905275071051752881638109328190105748568) }, 
      { SC_(4.85198974609375), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(227.8655071408183526867888236083017003926146139606226493300479692172091738784179874972346295100860969), SC_(79.66213156407033103977342661537533183490226442394108171987313800132566003755349906794150002673454034), SC_(0.09166434197154445712315551377609788036731878785778703993751211979968400907994839844371319511997977591), SC_(1.021401565575375043135359773416469005777594092605070944783531697695588946566978480269355287850634035) }, 
      { SC_(4.8523540496826171875), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(2.209489163715041711990500148328484328739834555135030675667321237957160120944781824784807073588581553), SC_(0.2515076560373709682991119672445639271494254705532960955023142236618652445207141720140446617194967282), SC_(16.71107902516606099630295691561401484308374084105093310840354272728136330564230908473151663341147491), SC_(52.43583877204720905779907785271603277843332506631010522916265337477121091711599502316034133839650505) }, 
      { SC_(4.914722442626953125), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(201.1428316744417266499437112948203060172112384943150994674684839159725332522985703349056572008168366), SC_(97.33995875639838693074907321834144290417790695592857502968740081843969878953403141693230800708582768), SC_(0.1551434529134858595872813737403112009423620293988039800337409424085729407318443861249927114312728048), SC_(0.8038770401801449650505227704337354748485839114566545975691205830485975523276992698345985768021887533) }, 
      { SC_(4.95192813873291015625), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.1929639413034934567341833501296052259965848694113459417811550783422651103343539445514062162310566491), SC_(2.653655500393700690640143455513344193991783486124502518300746892451030706712087354008253112648102856), SC_(54.20541298395837741110738931809574517411127235547271076521310210285251051639135335867955077596873664), SC_(13.83876805848048149771840476086483041600951777988644448551796370314482034848056602861751008631045033) }, 
      { SC_(10.6194858551025390625), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(46.62476812276821799352553528547800106089795346878515483554008926587672417084525578070535148827538667), SC_(58.61220906665902977380700677218612070377327760152467402182582705573891501588339764706926831008405122), SC_(2.904693982311437012659024201958672138593562104745200715739083932819993068170985057883983958185178892), SC_(1.859912346979196681708421745282080517910777775322703307514587827913475970374446615642010808819505575) }, 
      { SC_(11.69724559783935546875), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(1.539596983366854335803792002379721850189772810152123651507310378231250838717167405138365749286813406), SC_(2.46049124960131771626195423021568219710831056185803845631680473452581886336413428753359361974487239), SC_(87.05409813765025522185613886607753588654448313547857380747899758520768998642143169793059012796151521), SC_(70.32496404256882944090492703442699279302119652905911626208164834352507038793850940435580869950954628) }, 
      { SC_(12.1070804595947265625), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(112.1507394266185938839487958197978020217049001510876391027113527208705013114350580145970481686519262), SC_(137.7076263367302169087793072805726686027546370194822875169911358374876874009002250110437798239401788), SC_(1.823860443617584870539945835426236435900774869457832598101843014037878761050408913393541369398985239), SC_(1.085315079450033636942955764407667056030970835100975022553227980372788406596874114858925655491574261) }, 
      { SC_(12.384754180908203125), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(3.950181654257633412908052130546384331198506116820105393997884097762184882109143001719628522326915375), SC_(0.7685899663158799230131324935686509249455137377559214092151180419031913366923231178321481481971847052), SC_(57.18892323713363509017713749177520022353536626135274925911388012117312951203417423151623053268495903), SC_(115.4413915322317727635606952552851756933365345346951699607171032376282986751456724144738434468339837) }, 
      { SC_(12.41884708404541015625), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(12.24220288334904901654971143605045642168581087987131170153138813242779078605378541364853742003182907), SC_(32.74954707674408020693840984822056153877869090309120902596089607721437093618978963800835227885656898), SC_(12.55489029800108219363078360111578731270547995736490515831346371038118290160968656594257202928529976), SC_(3.499667716234346195376614505540425951985513331942632982784677598381358409035891389275307126682421649) }, 
      { SC_(12.62097835540771484375), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(3.044758098973278106720766769871880704627718855529452640584589058246404526338603955329203204231323122), SC_(1.565209041213996999023548049249157995769015149087644976976988364970147901150100087564278655385128949), SC_(67.25037259879672018950443860914582965566838840768149137238020217754486607147078349138100142387650858), SC_(91.29217120221677912090025740181855919703124773435904872636249463589405241767682675110823944274651527) }, 
      { SC_(12.857818603515625), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(0.9635816607025133537873958247656970792166663577439649788839404569531763589002576305805414374214878535), SC_(3.739844067227890329882969385772155181405518552425861125757979188653759391764897218287246089469697924), SC_(114.0518913220037220529753616240222080296826349189588415760977616326991332713443151134212512283622713), SC_(63.35877725898257196705144961650162750026766286560900344491452492817306267481737956176125363473574094) }, 
      { SC_(13.0601596832275390625), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(1.790690952864929097178963570772900539401631875169635884556221942219978473916976558804309836326162787), SC_(12.42449887458272559948214279964310914528176355461792540098433767281542467562614614247076424463802587), SC_(50.09826857378336226342684927917355145965327228464172664588532954634660233412903913026917613393266561), SC_(14.03551620861964114857293605813760491766523227360511146310141293612166813129816520424543245091611688) }, 
      { SC_(13.3387928009033203125), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(3.618449205523146665370698992477852143182980702531197514153703392284264468274125984126868837444389333), SC_(9.232865512360567758395055854075604841870435132322951258209882721206108925650176201287255942275605504), SC_(39.86615686842815602644094398486204809458550965150169803720222877052838269312461349448444332024085714), SC_(20.91465474822146633269982920331289981255216738813697251356837721745072620345733524942250333760498403) }, 
      { SC_(13.86920070648193359375), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(4.496875261872881219301204001086784098962709025733989412553662238685013418716988807039819141432639599), SC_(0.9732106765117811334595775320036216049072184828371411955918395764210663469883408560751653962615342478), SC_(60.83686758487330255194213700222871907908456645558327218895378427619377767324534628924260113362149332), SC_(118.4193419829058868585580996426885314891349859909965298373255864900318762396402781016900268766746516) }, 
      { SC_(14.248653411865234375), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(181.532492343145035381796825576651487262205945297348526457420921148201092036125375703041018063249852), SC_(95.52234431626245336390649016797321550851051048748556242943619164645858319963369404341707171914061678), SC_(0.616859866802133699868560516626903883836786889684832505536493662641082520263905160730867141054641388), SC_(3.445323951828881218591691245864685978052688601767291818256906403642671027845740921918322419616540742) }, 
      { SC_(15.2488727569580078125), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(363.7209329034753286231809906498845855980897019117576237104385108340147217336357727176695190542675786), SC_(582.3670141469865955341406873301977645223856111256323765984404202512911264698897972382288112070933063), SC_(1.531162184495920655466773278118173226301692848699343144095881538929867428781910689919703630341368631), SC_(0.2841660277089306833890091349766062384036640827045007761302343739166365138856989566805635214134540416) }, 
      { SC_(15.3268413543701171875), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(3.382486114581517850754781165157900906863290662400888250387427222104778013436566784522463000775462208), SC_(11.81609183730423764965037317544232157899631189414114122785158941557885906293026657427235660257681674), SC_(49.92408785054692533688684153185878059270990985714289308905660862450798090412665160349927799525418901), SC_(21.43212324047167323500141819098537576847353888333281355752649326947394413418067944956112692868515166) }, 
      { SC_(15.6886882781982421875), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(2.793819919411284806258879727682365184185197903098841621638705521795695005757596903789850134326370784), SC_(7.003904587954034304952184019984000749665108643947876205366573875463999310889314401678483670622129), SC_(69.50144874378058941280648594714452106399067672983331427211762308903334511464002140033913349351814147), SC_(41.50192270313647589498433290908285968256701548161860955794531593333656584615040328738725290160786343) }, 
      { SC_(15.994617462158203125), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(0.9326755425147712141881307910833768399264908379056873096801960070859414654255130135208634132015396595), SC_(5.456125073003492417272392633184626200137673107751335584601563776419967546622448793532797692454268916), SC_(141.4663792609320609242890884576520166664086307138299238757584936283568834847055747628289187421869464), SC_(67.42761403133463049527351988251592378340121490714506024600241375607023159545134646928942914768687862) }, 
      { SC_(16.66793060302734375), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(120.2206309937141316157111179930925529157413442872624088361889171286242954157350190704795559369207085), SC_(237.6828903041904529948120761798071966430151195298549944390507248215375296885284851633425444922729122), SC_(3.894322219639685648661597290145303035579560537002362827079247098242681570047558257087365069075701472), SC_(0.5415150077528866870892596944932433799377563786793215423005217809877088247783160604932795810307001765) }, 
      { SC_(16.686737060546875), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(55.99398617130766329625959594897436964195265744047328563985047776458648526903967514793050814977537145), SC_(117.0900724191169227447543304301298773781295878549208215062847821850802751187876318916238422430311778), SC_(6.644954302866249211352597982747686925817364769700102961160570368774710569223706837522246034092071433), SC_(1.34646840636943395617250606843828251015456434128747167463778745211199656397669089177772544656638728) }, 
      { SC_(16.88471221923828125), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(48.35018081005866300406579611080953004491862732082461683063000734467518280321173692779066503719758859), SC_(132.7209118915414668254532361066518917113280404426374040894686695412595734284102360729223942251202783), SC_(8.058771653949806162378703119402744590683159972588172850639684190940871099915320784741015545323119272), SC_(0.7918175841692319383800052046731514460957025252390602816609239799376404172607654157365553186156609953) }, 
      { SC_(16.935543060302734375), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(39.90809211224714638235705882076796076327418002132294282235410083601872740672840441444725430716944217), SC_(19.80577232219898425661481049778122609724103853132072392272660372453038741203554507639194060975654742), SC_(6.007835683455320409590153548743425139662563476417002892264152814948876475584906839564003661903693189), SC_(14.89663193816195304949590386752824970670173245218807870663337609078449578811231953861961440710172852) }, 
      { SC_(17.2327480316162109375), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(51.10307601896460749895113181419668666483330318393972944837899353784174456220331680695189966147380589), SC_(103.8527012777873687833145279871668411853437028749799997350844588309540295358749969075146516695202762), SC_(7.42657228228316174863231915336946345977890892330952809861346024803299808746741546451678096849036391), SC_(1.764127152287852079731870023294779180510181098795404950653651485738649272949185263638374304950461687) }, 
      { SC_(17.563365936279296875), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(22.53341279568851121942054117301274982163651667970554656573800915777491187189254475291043692112653733), SC_(38.60404266911530930947560626708938108501845581414759969290660862007293503720771077773384155334654444), SC_(14.19169416363482337342900956325645718979114239663329275595184921608207155909521754532458417403233377), SC_(7.082379531433653123909367004149745916494152222956678627843741272940489035351584930022755406359582903) }, 
      { SC_(17.8042964935302734375), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(0.5944221560402486182021852733237556417057752313777285502400835262501178056365410981287455860817600329), SC_(7.10335279955879289634874696908608451346497431141744150486749878988636235194776695095086228405639685), SC_(173.3429443010197630600108788077456741581245735053672718674223165423207210285146240091185726757877463), SC_(66.02974055269282931482713147555357523152519781806935297071612775795670309024192313454225942141134824) }, 
      { SC_(17.812992095947265625), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(190.4029619361730347710979198027601633872500408661004701340419034362381396166498573093539035944205641), SC_(148.1391980116046285542711012913145120213640150230786693862887526007942518950974978621332762429936178), SC_(1.489283599368783599167661478672265645006918955504048737288285241630691475460049988002394715452202654), SC_(2.892280838448316235031053013687670979097771314158346803239516606945033758807105140616196794879978201) }, 
      { SC_(17.92473602294921875), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(155.5741398029092339356529322463970442108577536602421824804214925915834236551926746273082038516344733), SC_(184.198113808093989861397704730670281147687763056282746745100012755530056019062004503904225621025139), SC_(2.650359522157118685397688514295120773388075660289477866799633533480321714758375128646753616433853905), SC_(1.699262427692390265657577777220511900594113752238781888125710444865989342262715868782751802483223625) }, 
      { SC_(18.1678867340087890625), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(121.4711620456880651036038430898764312043695416652576412028960840998408532703937558251699343345766169), SC_(233.8453425709142083041560491267914963331461661770552636187606446813369517169115143836670226856046122), SC_(4.378237855117111293099905836875646200447900225780281402803922429211950392196865585167661566371068578), SC_(0.6854922294313873400976432496790025629291654194235690554003170818950073411965845482659377700845646064) }, 
      { SC_(19.2755451202392578125), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(1.830365717538657004470110864943858485107729842486418279066061432078556391100704752817142500160793124), SC_(5.118534376787943318058938650240085012143347713742226240538753404449176848633212810309861020843989197), SC_(149.6848091076373397148129185302799410419577815950658064846920671964920424367982862529246957701301509), SC_(96.24000162738770699642856332902935146434426527354911841416817167578631315448681359696718716174093772) }, 
      { SC_(19.772785186767578125), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(10.83887713529849095609393032219051048042351066993921798935962502254944135614487726719697385626309956), SC_(7.305897992607398824184480399234026759727783113791983460835071301000304327644101121155562808321403838), SC_(38.24066073317813427844704504340219920099704238059917001309218859436006553700329898281430189213100022), SC_(50.14305867796921179251149665774490664814925359664472993607423264957049659639228669132079137803297674) }, 
      { SC_(20.764774322509765625), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(154.6088770714692407730274191006075857301768743269941794577487845985918955576848162714472991673795216), SC_(290.6160525265263167872896868178454200655399537353700594015835180651436293343900183904398136459039498), SC_(4.580363853987163131037776072120281957289574463072060545813406859963434579875226227282591655829098483), SC_(0.6908804945321297639298383960615623399932278788629861590950845457559483337480770458985301754319132096) }, 
      { SC_(21.106563568115234375), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(20.20924124826140441797839491642328027846719120470020347327267160811458215607399575642684145612891772), SC_(57.06929365235523974728646401762776918461985821258421179978641937144067081811142040179963082661744245), SC_(21.80606783705819298334682539530690731918874859141980004792808859814672526492781112710409544133762905), SC_(5.523420773303192171600899320095332230414733929791237943057481923113802678994394833294200082135555758) }, 
      { SC_(21.58757781982421875), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(6.068433736904012487161502152113863743239826347576872609039367525134239323810081549603137192304218845), SC_(1.789156969140553399413105714198712854215352296477723475402746651944718289641895032198609343233890157), SC_(103.8361090901102457764444182564340813187858743557652282669866099573124333407011679286267599547357978), SC_(173.4452149425767567275870985030680060749953951735881361274273501557745680062962061314974520568949523) }, 
      { SC_(21.679363250732421875), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(139.9805289563747010386101836269632713226103185130609824999277602518399343537731904561160635793596097), SC_(81.59550684636310878839406817630558062354339057317887619869919856446375831910258093425628915834693798), SC_(2.308727987891800907565552025979815125699356473855014112220117287493364376975617855317144625814757014), SC_(7.393989849858268547528612096545960795382122563555603193994432363997464349094193402530344290081766926) }, 
      { SC_(21.735530853271484375), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(78.13151129217892494011415516948134131970084564795670108996187247842139486936729977282178691436398319), SC_(145.6023279643067832952070994071691896860093338716593124965397261592820553083261960939841013012011419), SC_(7.898701747592230445830281076283049799854171976667918634295375976075180672348981326699279243830300709), SC_(2.029670966830710140430411163514750267378330869883019019366919384805860299723741869673605070900929775) }, 
      { SC_(23.57973480224609375), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(163.707375294215522934525259625992479473220499502888795979882674321069649501686451892005151530669518), SC_(296.5283069387127246394938993183297910943224438285376571054954261423988024029388440028161229592732739), SC_(5.311621817871067610124125572744451357312084477202907290445470929894524478135959516099440942336543904), SC_(0.9351264014931196604172011697909774532294501575903743152608155638291801491839648756011727436923818364) }, 
      { SC_(24.37297821044921875), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(136.0695019211836817928683953663587674797443396245832222731010307782139593357169010893890601246893064), SC_(108.8893952260030561658776464838216764157490231458942827632484372380406583426852179122465395559538626), SC_(3.949321870823009323594655822383642084162345005803819344098937256930999355792740352967666719842162825), SC_(6.325091462234082849033515012813321084587380371666448857826815526696050179688993826809110565244060665) }, 
      { SC_(24.896389007568359375), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(276.9861736906710835118429206907767577188332005979057779430777707182797917858060182946823056749715854), SC_(200.0635824259768627813261240105418311568989741368323313383590054977847440401116821956751985057244097), SC_(1.723034579335585201800729495709953964227665593707517806131892772356992229999331158966448361181513863), SC_(4.276834038333928043641826147394470024665077684639179793855919667778007138835042140660722900260225175) }, 
      { SC_(25.63751220703125), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(52.65843518795990332500019947242707537030208921554823291891486247337103156850132618414092509080970729), SC_(35.94613190528851072728562852850723997910135167847394904067193376315477803848230691849487337047865856), SC_(11.55543798967779587331648690866868741907814796318605050975356242817924362223638312205089344669260301), SC_(18.9534466038674462056002721889179830726857596370818094790521668184542131586471087364055704727384066) }, 
      { SC_(25.698760986328125), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(296.5604044694502132172080505570309205498525699213090770398051531176107796613489127429912268787858374), SC_(240.9392549198779841902114973513591665899149958514305675535558577832653983024447124385893454531672337), SC_(1.975415607913045374087514711531436772654757980614365358364506890646140917916542151134324808529811121), SC_(3.585403022004378375279951248857294469671031100290341632575663086457525333328257869561111251404594739) }, 
      { SC_(25.8792724609375), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(31.1733307027073326008585640882037530793104250496326852001201266859299149797888057617254316497697281), SC_(59.9478913501180863833866778950518110580926267415175014299632163274084563961953628981499094463754538), SC_(22.17184214335283322183785783956420199437806841206275996067701217888157651516657734558360862158741321), SC_(9.441426374055163174843241541078425110983583626083679754031974015137332249758077032876695789144169377) }, 
      { SC_(25.970310211181640625), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(143.3445097827530417831874044392022077248506602518896421986826337664432531429158381657462052622425431), SC_(87.06578126697941693218114420259785232979039880613427275121892512361592677830488638662897542435063445), SC_(3.444074231349646995725849445773731824808201626886741065791789038562598566326214800614227967460323903), SC_(9.51002531197923020128533097931097137304444939462058233360064964344569304422086456415445325393397691) }, 
      { SC_(26.671977996826171875), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(107.9088331167616684348164526715054097679132177791828764741279613195195280803094997240520891937121154), SC_(124.8062885742347960550899935516819881165175647810258360879692458678196358754174169103112426395211732), SC_(7.259673092052271430155793246896781864375805238278321498220284326843121861211680112806645019671138618), SC_(5.433834254892187987066234085639193259215342692045594709935268465663626020340500231212301910487311923) }, 
      { SC_(26.7097644805908203125), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(673.0932332156213009606132720443433003206467335524177743600951509035313624815256726739993207789281472), SC_(989.4964180167964938649461629389496857430010582564670515333576831180395232410413579023778990505602774), SC_(2.216256361804377053597371466483471226957351503633778588483728071984259936929552178348091944340224365), SC_(0.4319065118440003657713106032065408479528988324626957965312500662248006462780326605522955460964026163) }, 
      { SC_(26.8887348175048828125), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(11.59702870293561813260076652995980364117775037651114761886207497605853956237993062393714449297497012), SC_(4.778012017036602308142826635259539312968738598671480705580835187374238054679549559122187032811395428), SC_(72.86362770380371760563481348450809791429568202234673427380911283675312547912342770783323990885831464), SC_(118.1395932718532667770448651191593707422554610439131503262227051745751274787158437807781211113045761) }, 
      { SC_(26.9134235382080078125), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(1027.288237969557238949385987073952687087780105134797691183274208186174049065887009365481098265992949), SC_(655.3701219258082386333443573927149833121901308696263171110030698105714978795131376858798300416848498), SC_(0.3480482111517524509961413642799799453708768072005177014013044217425284023631851326976818505302562294), SC_(2.437382295644241494683144331490885273130071395594221473278021044675882347747674381827400407098127609) }, 
      { SC_(27.2660465240478515625), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(159.8306602750777487080762422578196965178869915011512890506247391882669972929803311572910929846050657), SC_(115.6718729833107324647686586357078655427548218855913298718815531222956485772552962584538102369136284), SC_(3.859543854374947126575904206867758071962496903622875041404648351209056993673607493296818338665637743), SC_(7.71804082870491457716766432360624810270419991710695419635902559872085723463510548118945554347648852) }, 
      { SC_(27.29566192626953125), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(15.72711589969584415430328270398033523517122921207108172773228260500015097937420618867963000235845305), SC_(9.337421747368266683559384075744955486276437150355533010995615757895484870324290109595367605297462402), SC_(50.62462707271006446098824627209829827977148785228127047306161470988855773880190469150032745986522119), SC_(72.14555493988593787961583293034965352102377818758491042328316995786455797767929531205186436328067065) }, 
      { SC_(27.47731781005859375), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(17.40071082939551330320692191512088450153221074877852022941942981583447933323905686041914966215967005), SC_(8.218168595858337141850005695377393678280863782088178741346421233478815233425840326908299446724197329), SC_(46.88882800294396594202601155760518808840667170093935281779612042782459239166206870488527038673240168), SC_(77.83056433825470119575478282977442450579838787351372549332674653575388198848182782372322849217337204) }, 
      { SC_(28.15190887451171875), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(17.95495019736495995710265643244437029983371063343788814121601667434734162245560039994837425918286809), SC_(8.321647115919770528167781420352564098380786694545458703998992068781276856506548801109359702189709835), SC_(47.72467774500609281880954230827698107859599900285757739658235688375090145906322304268951072987369189), SC_(80.18580417970501035379729394318490500313182872999018757249285529829667728661642299604421815200174092) }, 
      { SC_(28.9092845916748046875), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(3.373533329379834240366232662000235161521128174039532916006616539366343809246093181666188951743438001), SC_(15.34723983523333790916734521130570535004059370365007018738751937780038971190878997948909465814273494), SC_(145.5201281566754341584660143220548182475341764455133228115983880822297617790098577316903366522435652), SC_(65.77820006020079908763089576580201176883097960285516341611360819416366791578720418541060471203235245) }, 
      { SC_(29.5875072479248046875), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(231.6054129005473742162741396169450909850166825967632724687718327916016870847551502627054515259427347), SC_(338.0757239791595872222210311903426853257806011936382554573841366511490740771233105254706115633253933), SC_(5.329179628451910923599135358133954047736169254485620309713471485638160029462860975215675495052128532), SC_(1.795660635757890718959957044135083248323382182528965033023889549409983067568700747699778127476534612) }, 
      { SC_(29.71158599853515625), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(347.1920773130290592006677813152636880239422465539581747572050606196448458153058916606559849530239069), SC_(226.6388454491784313906057995285706448538095614426728253063309299620606670065877247894640222422195814), SC_(1.630994138519755787209834920774941542029422632935837565995273125604061549785953164032561493127548037), SC_(5.627339424785318329213794984325549291894470552177493105932581341305307389699271802945514640656759394) }, 
      { SC_(30.2367763519287109375), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(9.987753565808207573249770899949921904458587643911420066980829899578192354435533043096709921973761612), SC_(17.83164452686693415516527347347866454156463445345517235185562770604447692646966724342499440882420766), SC_(81.38798268311312002527602373635129958682926190587613661079991294621036383888943586211226088287940731), SC_(54.96970855451221446566945849759698087723372466884741835519744033725411152225469952196983397062721177) }, 
      { SC_(30.600948333740234375), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(89.02734026140783971124097096005440452992442727746528145321767779318800106429321230935609900018040433), SC_(189.2005063746169244878730091297527571157536280500932804181628838051302846293262169606954988656552796), SC_(13.44783868899797270828654431464699149386117727611869794902188159710256526091718627307181689020751905), SC_(2.684786119003034017424993792122996113821159834711398321630872120924620362931783483783748312047968943) }, 
      { SC_(30.74379730224609375), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(11.6685909171227898451735180118375641333272418165546912189506577262092820787718469380003559097004855), SC_(6.569245490099816870840218033533715824681728421406034392952174110181374336016951636188142328885822159), SC_(91.34372918332200815594870027673633963705046145065934520553178405501958896519221070943128497878368809), SC_(125.1571388063301605797936848002244806491721072863822275657382629429887142917141043395664035515346567) }, 
      { SC_(30.865993499755859375), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(2.133156485990465871164828309651720020146901962351325788232875062585084566162281875497965189753368598), SC_(8.222972568011908781534794865523876698205390745367095593579388264700870999970509166535032568078893897), SC_(270.0006862025979836112452129651417958364857881763741821822411980659525835909615915170742572999576481), SC_(159.257585896942939307794487170543389642361913746907116950240328321676798132880505795603388537731619) }, 
      { SC_(31.07503509521484375), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(157.2484359682899151878174069211660021553217373993576115494736939844650961470667259473828859263263646), SC_(115.7471198693180411750772318937970828106958854458998608916066268297955414097169786936447141650682039), SC_(5.223103024433953889637671032615729385075438927310275936650989945408552485430598878137602455097784578), SC_(9.705845612576798986369314977041315554202276536436011630437299639840995182763322258356704924497035948) }, 
      { SC_(31.3888397216796875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(6.037161156281143575970404882812764533686253650141293124878922958387262059828799770652715516316302736), SC_(3.770807322159472539107031601779500131912552950616207151241787266065259827159765313441743397666768366), SC_(193.7791535108533861456504592736935923548323574429070338023854811421602792088190771259542528136763307), SC_(234.7946997268759321169409582063558050101011870907858499309684249663175406990148023439210095577192045) }, 
      { SC_(31.9148349761962890625), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(1126.024955249817207094644423180542964209459260137410237255621317759336772039144891176815335900391212), SC_(853.0196421755868507716280810983261297043794588993801246484827080660357414761789733426467791488650649), SC_(0.6603259026109087168993569084886374881045322724871285839718436457628282538760241829655521048500120605), SC_(2.205700360337156269075306112098205951951237118912628475191341605761145435868428965598769202713216692) }, 
      { SC_(32.175212860107421875), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(694.5818603716252480096076529388921493679792143828103587487995879372831990437752099206842671445067135), SC_(1361.373220401429722367144971816995344335282675780932724394687055444926980099275619543173321648068733), SC_(3.793410371844672660907853516796263861746861117908289752502434754406017642509649292484709044116816809), SC_(0.1268163582302537594221782621948841626053213145135651607594019382130865048963722980809657940996873821) }, 
      { SC_(32.558597564697265625), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(1213.662708844915057658152877027570547469546865011548198489976555317652872792511404025206626572348726), SC_(818.5185251256095958474112422538160560403299079620830067529857751781287095325566278570419511443267275), SC_(0.4536425007550423468763118002758527253472404967718031328868260383494817239349090860017210775086585585), SC_(2.675857704379721424565988860575176165273901848931630448216264045158990536966900674182587359468776879) }, 
      { SC_(32.6710968017578125), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(788.388975189689982613891758277124106030914368406103179459415779107285313785116234494784780372308277), SC_(1261.71878583952528782511514984563406269345133509057360701154476202470710243975961203328186701464095), SC_(2.98545658569659957585069857358201501087082353610305334943989918734090244484857957473408633009520505), SC_(0.3379444158272305866899966893873384435407859680984206553854551751713565757801711974611370710415788568) }, 
      { SC_(33.93475341796875), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(1140.560268947105557532665457934103940422107149118980254446017894882525179564324145962666586252479297), SC_(957.0664436452048675998421556437868198325924823376517040546007193294735200600093678733876463694538085), SC_(0.9178909185686543187839312722758505100178685611406342745523113104218692907565950240991330548816980384), SC_(1.960330119629183835499539226974098601784253576447953933534104909314216745991908522234835184002591299) }, 
      { SC_(34.650890350341796875), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(231.4592887548705219610483205451790732146083573362146693101059401861357387348943650923527714614317209), SC_(452.6045077088745735101893276730009852394861380514646375569306275093189365947081743729472770656014382), SC_(8.251805963032146013015889055838903679260452993894922233715780724282170555819430161506974556094461026), SC_(0.9794122123685907154145068455029923659830641971062756758992795674270146173383005539124215384366617008) }, 
      { SC_(34.68819427490234375), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(65.96665584879040303160271966732787234917637810492055203216224975498966138546339028139885006313698296), SC_(53.27524450192347265934535102000135055632795622712411255172274772194283333303509218356466685633925301), SC_(17.58293016124649809553174896215573076284095324157099410971718607048822609361847690656556528064545888), SC_(23.20336156432988896417710468915813901408707104301281838225546590341060345347163726980147041712775011) }, 
      { SC_(34.691165924072265625), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(127.1757678586787487166393127562427618832374478453672913870063008282729084561065215385055188012035242), SC_(178.3156306410173318236131132849301207935247380790009378086660297440536163667783146477375096928961999), SC_(11.10061282309582551466524412750579100532918668502614019932068016138261681997116446724223331457033284), SC_(5.576504129865716884995170324036583352907056652807808191710444962675833630961014006893889248021353129) }, 
      { SC_(35.11893463134765625), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(117.1826809909542592160118515462956801748998158883711190980663613720684141043452162721305486011058526), SC_(195.5039441689973438719191416307562532724506840318744268862507037645264017977320614563653209389127336), SC_(12.91698925812911053507412692354964893379218106580441099008309577350480877933006722203950044950271693), SC_(4.469932521882334392991668471935856785874466041214785419433271532716650480471477349301159547641084659) }, 
      { SC_(35.72724151611328125), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(6.12500385568253644616004953814236737968917843385597017050333963296263069438383346294392642712969155), SC_(15.54195408898059987519274805672839395053795433610573044220416877238339882054574152947906701808360425), SC_(158.5801944184751646312639403410348386782512609545671140452568803733662927456510384210503522851274589), SC_(96.08174498903758431180549905636467566962553775265077487951781107456840267065807559734297973972763893) }, 
      { SC_(35.959659576416015625), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(7.19416782594551919695112595998477134903317247312224984387052214799279686337928990453282311519860767), SC_(14.19388230141781029130440876100283441710930427125529287679846979522712839922004589285123944883823192), SC_(150.310994705745805654920640551827254747931613736977944127508482834106576122244405321068603627964152), SC_(103.8967924163298129077345826071078471883266219625164984785216841701832458079718158874128603626845135) }, 
      { SC_(36.274394989013671875), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(131.494070225751125323455381551388657752584543142222816609636718107002375095120211532460643721941487), SC_(188.4028806526922790734194118430870775041154001324303304138139779216285282873089839773105130360595912), SC_(11.808016943646340414480993916461022690049293507309283871429987010481576717053547611758374413135394), SC_(5.661111945476101229010828395633623955552440402292154862047056524231662551929683426767053140867199761) }, 
      { SC_(36.38420867919921875), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(15.02749057228711918097126680315771984256483118496336269104379749793389805554105642793223833807926388), SC_(6.786280595682785238691595857990412862072943503207447466027966179064787488230869182584699674388200663), SC_(101.7370083544581480909425825521213151919545033682744288521577042381926049365940078270635744821942349), SC_(156.4026090580755323974465885677322836169494029959213538538616413591071675638204190627826257192048765) }, 
      { SC_(36.68456268310546875), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(1.842606700634786517234231583266204543058315354022263019451300157604416203510962512721980487227776704), SC_(10.92376953508881611608237666900691146908238850718644732926312901344287879718739079830195046934475384), SC_(341.3778128356799127068984813131270564306723670149991648923593893220074044667093646881367966040926671), SC_(175.7695695091001147473195482457223865617281169761910940147768994419224518146875225983595680325143024) }, 
      { SC_(37.27887725830078125), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(7.732593601645518776783442034107796950970976284774057629536598625549596208060112553032694345956632882), SC_(3.938984287745861281427002635827937406680298841102135282341717575602913756051066482798944038833062034), SC_(221.2500719344984273848310601553822269232567501983330813595449037169186202997493856118192501115938104), SC_(289.9119661020876839523629457680891649237667657150206595472954067388757016693144217872603071760379402) }, 
      { SC_(38.1889495849609375), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(3.225336709448726186898227383847432972149269346751231462466689167642805077863470899297192170290007336), SC_(10.0731277295278872855620870957292122545627792314789083609729690803368181278535984983070941697563822), SC_(301.2215608049969871468445983725277562798198013018273552555781392108550921630024227079874995631998759), SC_(190.1560925334928184244931726154679413332778615036042764305520309316998515729421770622994841185540748) }, 
      { SC_(38.556156158447265625), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(81.70213080569314733999505180837673992764320928863617391644671488307746945657363630402643028773165151), SC_(52.2682496103505037571714231702011160327253421729455853727551653401453491409513129355548625397518019), SC_(16.47224367326681624431522678911714301911001711655786004141726905549919649574500888656433587526048898), SC_(29.50396363723810023794296189797133300563131235559204169391713860087041824815555582989870855611376394) }, 
      { SC_(38.8975830078125), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(4.024372001971316538723742209101198878787389994564226454147044515432391713801157537483623998119169849), SC_(9.14984540902593628033163922513163254346539272086435222041787117402582869289062137696748453718454848), SC_(289.910240275172281117213495756788798699297877880426077591623819058825827475589632244408761713446841), SC_(206.929305158493389822502504105502251008177412815885366826538459657711112531840626147543010314288687) }, 
      { SC_(39.514324188232421875), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(349.7210987951098235751452053166464107845758397450310210810859385555134957530408797368472879003994192), SC_(484.2876117687940882896356599663321346193045483010149718445093046319508858711303239042686596903536915), SC_(6.181066694271747190763987836181017438665945605253805393665713746950307627959435454071401482424666388), SC_(2.286462607613130871831134692355474300788019664843827690167993710581442601471032139376158839711670035) }, 
      { SC_(42.013225555419921875), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(7.357962908703120890080691025529686572899882205681624085079722033681591395670201940120109708310953915), SC_(17.94348183656237237900084481855742839585780566867114226261991760272830431545668315163434302363051491), SC_(184.7523273957284436070799921357303176489062295949533763158337443240103029920987380144222813260249762), SC_(114.5295900384050778365417801713698012509631941111294589374388133515255197818913113918407418941674984) }, 
      { SC_(42.13457489013671875), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(59.32480397701952383737825857623582998913144841012881989401589137945458127868643251987992905629895652), SC_(86.57014050572077134196620423393425141963219040815345830401598024740835485600522178913147838538132727), SC_(31.00602804421600333471199295726383650998561515024034041072746320703352965562584954433807981460606323), SC_(18.94132155859245008638532154610843233920204064822499540975440765924410087428365844188763413335795617) }, 
      { SC_(42.644683837890625), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(183.7214441287681875013055785886324015546349252581857251528942202141713625135451947435372795901871801), SC_(248.2411971321515751189899426553538643385879402323894558567634829351966071082315935233857962680190482), SC_(11.70041545680687669507911778484847745012545312846727503681266379191732754364351698125830974423924052), SC_(6.055082216222754128288150861685598372576354204985556371215917060946938990528914528902395031259767313) }, 
      { SC_(42.70188140869140625), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(6.065864894428919846255422403474404277172456166169785307498986866277191332219732892342833520496263316), SC_(7.933693231116349249368313726244466863990892221025625100512737807753868235279117588799131367380289446), SC_(285.8558649175522280345022791064744287830573312791471550987680933786746954889498906033978068108755913), SC_(255.6771685691396985756898248454205276987604491255916972039496622948744316776090454311914288476077072) }, 
      { SC_(42.72594451904296875), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(9.229802184871117831984171618459280827878421823327322869075598061095094148515591436644941755765544646), SC_(4.987144869997566303119508385050578372383162122268872024378814864265954450939870785053309997601646861), SC_(237.7053919847620909855902386993529363667507879363970449430734060710698608481120187830764452018316709), SC_(306.315586985719144078542355443875463053036900190357922391832320581758617138324536659811608293713591) }, 
      { SC_(42.98526763916015625), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(258.2760108727117033254561702978919926378393235822365080648722573112860338187950532460184760181397007), SC_(178.649569253299246700463360594851530401350435883108029221117382435600484367500513122799988704172378), SC_(5.559311097624799120240432452812342922915997652603478148006962931740917605178663229807337683909739398), SC_(12.52251251183067907712597836267235810573075743042771419043960075316415250639888392442741843575231064) }, 
      { SC_(43.01255035400390625), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(17.61506313634091526446762076616292105789144526656385765644413835391695567684443681402804961489898876), SC_(21.15597184383051709808895442380968044545851956204490968935442761984667633435590936524088837762290749), SC_(102.1802639539759693197177655163195576646296523923116295087684175740072770289479126759471681552783789), SC_(90.2643724057879691379425596332008410114545016628721043816585310953060053559189035256452971516822485) }, 
      { SC_(43.255191802978515625), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(69.46792805384106385680742369204119603197238235177624767877492108914692671696199888262425637803620181), SC_(79.04772786978050482815591277951001017475015796691865289061080091215614423704850824509970343687858023), SC_(27.44555365808183057553122914258137324266791739891869513498591970200073664861418149813435157169983849), SC_(23.20233410508766674388434156694629609403611184454540384989338313866243881834435805577641947564982852) }, 
      { SC_(44.32396697998046875), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(231.3425117863516977723747420362228684293282073317892983104245512680863506584091014109380697563866045), SC_(160.2106457880249056019437592239918053490868005009131003378181562118530330933260499175587864502935861), SC_(6.786128897239722039712389045812521253466988925521636893197155520100632880487967865081724365663415313), SC_(14.47203122729279333721724937148725935487915485833022318959914050211932858675419825683839784147197955) }, 
      { SC_(44.572296142578125), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(368.2644863486033665245159786985651544758494408214475296912451947693066913872777527218517283314406467), SC_(488.6067311101184866486724539340896061868394392984076581051888259747835068108988503761922354306997618), SC_(7.096537263914493452496587327225807829598414829775894614238814553473851980611184897654127270392452855), SC_(3.088520213000541054861370800541603680561685543852129509590410508717532204862999777536806079790908753) }, 
      { SC_(44.8722076416015625), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(4.559201571521498632698940330245228973792070295970284951430342722293846122439079477610345447498179826), SC_(9.416001698884002935205947290389476516482387344139919683109647128375900637241090197210020458052353375), SC_(352.1964349068445435814476597738733121816860922359298848199087749965375835714941985725588072727151347), SC_(264.3261346627681184957966634339812230744765839738658105201837930320554991816519240186688104564850899) }, 
      { SC_(45.1220245361328125), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(558.3757805143213583498363755624008396613487020342373899812815572854575922741400906623851092286258093), SC_(395.8285691763136380460660282561783731175990206669344602813970641826595162220838360082802584281542073), SC_(2.466365833866221205994471892802264954591311633950854178810462013583715938408101484175597515690143845), SC_(7.17139123598312037692605535889769546735540761103305716141022989493346671721429020054564885745027995) }, 
      { SC_(46.27776336669921875), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(14.20450996404819782484579998542747005461654795019058937983661627611278345275036180899310316786746217), SC_(28.4970724773255835842553238682906929366199446607211075073706227051492977986004106458639779766429314), SC_(129.0915803193427588897581952425529760989126587576074163495849410229810070721635404350767026287084637), SC_(80.96273831761853055179384828736258049214750606170592837774425576375667906870260799184238282657826896) }, 
      { SC_(46.35746002197265625), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(219.7008343363325426025704496292179406956440004924320128382229680887278094495648462101855382346724689), SC_(186.6058294281756206174109148541254194771472424130524635195319795165695651932772398021348856733745328), SC_(9.067325301758941963492174641485113351165377828543152949280609830299903639511315388024760597799416802), SC_(12.64764821146605269846619547274853017526179729962303279538020149598681946711271668157507283905105049) }, 
      { SC_(46.8132781982421875), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(550.4465636702744431794797510578218723472613922348161613226059452083394061924141290568161307632422876), SC_(434.8623533603567532693348239343337091665020735244628257810480934335954150341032897520459347632002092), SC_(3.177983614415857089523749995689016916204352023294760744084911178318234797026793493400288477764907385), SC_(6.53103288601021548191290276008184723691841728708316481967554475230041295837999337703482311692841143) }, 
      { SC_(47.3841094970703125), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(3.892938469623463717004659255650690074094687953265726732689559542977095141267482617286477956642232973), SC_(11.21795560788362064437635988211454947117193903749508041517644179114472570757097970964529135179887136), SC_(394.1579333643454918785511340307237840845342830085986614458337575687933645861483057379867536073273776), SC_(261.4300978944464495819478860811672798582366706629261203450681471859480082804058918763649757628349537) }, 
      { SC_(47.442203521728515625), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(15.84179319144746498636172901395807301721892379214155837623653359254621368183319378667656052418041184), SC_(11.70000309654910847366832100783493819147686751473655123257616438921113948778986962515384426683051642), SC_(152.9019519198172267756189213201200317543915350353912845954598977374197168017851534263858320971495674), SC_(180.3310556707890576306302490577379194791135510136437127803202505288261707689643621091420496579289908) }, 
      { SC_(47.70948028564453125), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(1402.528707149857487002304906891836981077628185885415791621813572889193829963651206945172139662813678), SC_(1549.669458846395403200411277453274505252741213034972692228002740465419133370928026186704752327673258), SC_(2.281753936372337092331939389675328501638786704300350939078713288072108853506843091665212646791999822), SC_(1.443921329170737502535743087184574673500937629132470363050521027118126658646621424943114214626790297) }, 
      { SC_(47.86309051513671875), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(436.3893927707672567834611843280737617830486360909714313811142087912223024658414205102779191515112893), SC_(572.6160391653656225153598792669508517694918904426348642853495104060059340997907187373137892550144977), SC_(6.971538040004644803458346575964716102543095265454941864095093891329481811853818593286639136473121629), SC_(3.021661778643111922321304243251473837732978540188407466768358642050005130449084190465096565476512156) }, 
      { SC_(48.065219879150390625), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(595.4117073227723449533125467849070835777070280623349814020211731933966391171909563802034035994756202), SC_(421.523123997286810865318812910651509265678231285229972170763471476031485616005536578041529300992359), SC_(2.598981534421809483785146787130978826167194743286903552724566243870596224928688570815533159106657035), SC_(7.633377361871606593010715366369611783550890714831378619409254693461454094250052025918781799017228578) }, 
      { SC_(48.098876953125), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(10.63615339407081332143173864200525392565687208597199552807977819247279833278390604968509612617010822), SC_(4.456611136712141593793322381687962936059276934503471452231120374472548260529123822892721651970980862), SC_(275.5042888569730417816033172429887568721797047999237442132821049489903314149189707928672434521267292), SC_(387.3567043329957414098861709254124351140334667601584962087299948829958050576852240531854026892510041) }, 
      { SC_(48.875091552734375), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(381.4724871353794281720218760997562660697015873067373002381378589339266263416664624861988450367236576), SC_(668.5390527452110553306224945261783191207974524551221505261353300072545402140352483106373278585102836), SC_(9.76434843811437617083146392761831746201463559062912374444099465320027735283675723167971225137031866), SC_(1.509818388333623611532217108240071626734106748319922957551453257196441889542419735565180001182033611) }, 
      { SC_(48.91898345947265625), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(12.73415595202046151401853362446381214471869379339386163225141879255185631285272050863053512743808709), SC_(15.5746901992121589222780259650570376197828215452240133220614723606445343561268337506700650327721432), SC_(181.0399623828816149227178847605424252191566652867143697081344706372024727912598134215172488667095522), SC_(162.2313782331933126745578926558775753423996116073304943605533211520623860835530855743699596720209364) }, 
      { SC_(49.3220977783203125), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(1243.060864475900746671436925097810221791579292458245987408188312898315358107120955536980062730815788), SC_(1846.175780379155412847331360237426639742249345560239703671193203867388826763641965042892312131135795), SC_(3.922978885713150669659674306010768247608152738389562045065938204283395292412448762554482611556910926), SC_(0.5385482293323451520225625618371040367701342047523152006118897279738921866884358684650688404227408729) }, 
      { SC_(49.362548828125), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(212.4737992879818322934383804815274158491625568101733306727861917601197480784761338974212904978555458), SC_(288.0389537887184346041851960544414169480996920107346397151709977792932708368670577794128169147862061), SC_(13.54648754461968048520780348169600057889427251471303611821745710726016275800753614579094448568911921), SC_(6.932803710825690918203417652352281327875243209331748203508945698761835926183500711935436724209433827) }, 
      { SC_(103.325775146484375), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(21.97389448941670222248567020705331215019872315437900184198079593931150124504277673936365081099751934), SC_(38.07259575860679779242921534004175731391524192423682954872094472952000341725465947504309813010392099), SC_(418.7425994599546872250231399904757140418349952003233844624185597505718948366009931180466674956687027), SC_(312.1648088128356617744535690689729030066224521774119565098701186930868937621105661972686567860749941) }, 
      { SC_(107.284698486328125), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(407.2290003326116600872978526660331840915477635633688112440309455779953868204624728687744171018554648), SC_(539.8056867822541706589912850714929697642989294647650872616018600676905602395785203020437342703375266), SC_(32.24704497393093908489008145949222538766206358217075852822601621309325588581912739235360831038564379), SC_(17.89669967351317254385805349090999167641866842074907937788248739209427542345291414035283906484822742) }, 
      { SC_(109.005035400390625), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(3772.282277203543116787453364528610588076242700912668577342105269480732107501576251064882248841135809), SC_(3020.453491855641820307157834268971855832226472454388908572176192169861996414174270627806794985634397), SC_(1.913570807744456913063128809942609802646007155515840848331844805803600712629872199489517701823642169), SC_(6.193411472120475949363002111748308935491577937203911145922702059934431806713839745179973725838346427) }, 
      { SC_(113.0403289794921875), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(39.96959311346417183888912515302143633169351117965129138557698279987094999502032609731353880553998017), SC_(25.36732330058696863022855522854699158096660369601054925645706447573607312338898213775683659108577602), SC_(350.7752640151416475340835285583164019726848504768743970825670094717936145219338465133802867422979991), SC_(447.4211331526261579963153279365989148732943966946585169111909846099106268785942841569031776902138977) }, 
      { SC_(119.59328460693359375), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(4105.004305751122872442489361603611578189505341623723774116676274492440187483109023986568530279507823), SC_(3344.951936033866128701981355288427610091421760598874267448752291890423391232141102130105505888143294), SC_(2.211737658995726603805706266985699859333429671561190693096250750309457076478692790799181575521988376), SC_(6.543850236179192450385520827301412877546179774479878684673509806300474782627504015595429147046503349) }, 
      { SC_(125.01729583740234375), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(43.45675451614305492069668615283714707274142487401516726522336551822477789401144370310390992997382599), SC_(28.63349561243403070871525417339746443234891656272413315596770415599350459593387592297156605875142714), SC_(392.1206077758479852226455267673260826467749057463992018319509313640610420011442446233970973748506518), SC_(490.2163640024335405257862843082438900100182902616217086343450635145462324807518535672740425053434949) }, 
      { SC_(131.226776123046875), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(695.054270307638730997858590879464352311488875841007536422787945877908147515963924797663744101478954), SC_(631.5852943486871519268229905766045747169599697452838857543377781283989328316625576115968725611725924), SC_(23.46732906134538599564067472218014001767130823721903187626951033349579437015469025921600824252483925), SC_(29.03553505462285520897895491073821521163374724450361605672400302048362870640521094981982262287190337) }, 
      { SC_(135.981170654296875), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(32.75904481522422495330452474211738978426219788798687552190100690042090117908328300213152677731257134), SC_(45.34198365983442113546026072571402136201372701062556694180113415947432870111166955218590967230218555), SC_(520.86848597522276622673791460646032801857814495958778985648783299001672156309875784208761148725568), SC_(437.6143087941969829127067120166660330299151673073976395397954191911816000760133727951973256601060304) }, 
      { SC_(143.10760498046875), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(1215.043390374096568231975302569708219200042944807713136220906541178930891550310587016800437658958593), SC_(1543.926313934720519695231892598954371891374324796655829750039887613480602543214130206981784481246568), SC_(21.05206803133158319695184646973969197449902541877063614334681348440879509432330979128217167865092404), SC_(10.05809542689197710480985541335726750548295707854584385868231691349319687038209103428396022867964415) }, 
      { SC_(148.2446441650390625), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(720.5278794446234040556825495100209961652268688967842005411944805201898821297400974822532775816903876), SC_(585.3783736175863012292973355700496445748436347967737394337219988638620119032962390580336127496961696), SC_(26.96200710964733677153883520803911223560063678001518883043363370936823538296181984651781365156961372), SC_(41.5998317233999297285852592091202708982558684666796365545578328780579768022336488504370436868462943) }, 
      { SC_(148.2595672607421875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(24.404712822597589824766344355975149857813343324342965432929941923251280785353398294266968481809422), SC_(19.43625903484029103724890196706669987525285540564261844331307898213903739746828751196070945740995351), SC_(972.3361350584072226176601091651977475234177232195332104589996877047660506351091331252931485388657063), SC_(1061.900339807891321687470263810984063432680105558026853494626702475412162496718044434535417938907304) }, 
      { SC_(151.20574951171875), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(22.25054453795977591395581644210810485481344426427299113728176440261841682559668053534376500512292672), SC_(25.7850728493645215277039555545699818264916801309143835037404239732975628916929596653533043029856419), SC_(991.1386490514142905308341333089592533333393575768508620515189774646836564008121159533810177573519073), SC_(934.1658258569610375908294861385072190582363605291677523318244897757290001471387882668118389647214393) }, 
      { SC_(152.6246337890625), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(47.36007909137128620647730276787966615849770250122219855340148147379447052011926629057263033716063702), SC_(39.90225927792664937361568644799655268755073732359162377329912268783468404887931914464986871891508392), SC_(512.4641017245204412556070879404142145034369640018946558228854651922623335031056346204455298682898762), SC_(561.7974997215675246088471439382022387693706593596546785422103069115287605351538528768882548146122923) }, 
      { SC_(162.561981201171875), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(62.96350304258288721557836653364241974084359917082848288138398709172461249726674042420708722070141707), SC_(82.87298241403695021368174509557336635807983614603976186680547687943854044573477580008301198877112049), SC_(398.7664733425657526689845325498769442570769904930833006473733247545833775325028359320817744700900869), SC_(331.804974707550969078183141646968468556263948349599591178057441315398800627232519845202837500255561) }, 
      { SC_(164.593902587890625), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(4728.022311967372053700323826542754035483897737979030628706985550970577795504125187833487135113775719), SC_(5517.634432953992609387457782635680811629948742078933356002221167444046310209069933713022202328082828), SC_(8.035052157886608476314515037616510107312356989644633148822500180230736053287134365996701253277099235), SC_(3.519420425558593287107644005130930207861307060424141972850640226183271065005948987721618410617997641) }, 
      { SC_(168.44842529296875), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(19.59493585801309508754879622373461082005050493937544099596662262194125859806634195670605582970003758), SC_(34.61314846240350835906774973677506192563923341007968354127706294101558375759277031997406229735911083), SC_(1197.714133844687195957497407638790642096172233005609561629337228377722824594778073815953510985998359), SC_(955.4665396926961844780805173917281944513815361741166673964739682548443515753794561238136561258597742) }, 
      { SC_(169.2652130126953125), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(305.2161589943650495891798192300531764930434209821852638566574974858932558987792026016240174014858481), SC_(277.0555066297074191064611684759660860960308828186439310881486412720537461152745845152018203644466519), SC_(92.38240738840138729833537122107237037554046225530176462594311297619266614465588131435634124314695837), SC_(104.860832162553632331863542370197383731613395212489060615070322056192278969219670702857145349116607) }, 
      { SC_(171.25299072265625), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(31.54009458212083487539247999959879553037739793391483125523690870853855777943931772973380147168615255), SC_(22.99232990103363811719437424161646155417393799675308163029460557912007571599000646849311617927446981), SC_(1022.679813289357792761423266683136181285603688941873451137688129316415172177962689880389660825736944), SC_(1160.474028332943487207445896119798201920057155615896442435965759509382513933007225067563665607657873) }, 
      { SC_(171.5064697265625), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(4784.028578562401876926658893396610335464222835638776569740915633559648473653897718466992841720815186), SC_(5911.012714309651000573920675306905276225188262434411426078786328310834104210509914727409886962171698), SC_(9.378578329918138538306765929602536704250608945730315971059415635480227817474715053742551651565622755), SC_(2.947416101676390912481303942183432206665871818286345778807420573367337319786574163315048971644739292) }, 
      { SC_(174.1903839111328125), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(34.03500437662265211350620160199366347102815041215297978689893871484664731650541314746096993451582035), SC_(21.69116152002681802477754326627650860869712399595712501493163198485123325938368859530378459351126154), SC_(1012.209403578403754194463045733610586261794405341428648388414058076909012620896829382796418849639697), SC_(1211.249746907149728311880200392977231576573973749614980688574998922528391128168554338058503200026009) }, 
      { SC_(176.173309326171875), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(39.84078252494188805936703743691895960747164510926965033904734787515514353463575477797774183038810927), SC_(61.63095543196728633860657258878414995693521378312866346533892666570252467198812472509305052460476953), SC_(694.3238394720051559977014443840989762203724285593736707062273335024061347965791792450333057899766473), SC_(550.1427629160809502902808756968543441567197906982286580390175031744779657632402122518322800283404274) }, 
      { SC_(176.369476318359375), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(293.5508679121795908715834712386810597084531948805729090124710482508565873401288874756656150784110103), SC_(312.9619944224489074000540220597168455472383472975597156358398511028788016179989241963490300913835829), SC_(107.0028012636122103327393828687247395975836368909642543941566323591186510824809911920978280789096843), SC_(98.40129161972980099308913080816436003451386421388396986487959707785032575734784630836664255459074957) }, 
      { SC_(181.503875732421875), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(1623.370656741570624567381858535217364475946578203634186306414366191483145052306238642316333058463085), SC_(1866.927937510533279074679253179591823425140280611758113031936686049597200368058551653950149093183126), SC_(23.41154530991247630217765947881206172720091908847360111160595458486518295592093927156371187182316778), SC_(15.25842106475171849237489715944190190948431291861967293724594888199102888591275829321139947122904714) }, 
      { SC_(190.475067138671875), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(814.0224401229362030695108220496262845736139483380619107040930817615847066432141759987828777418210129), SC_(859.4610264865083361881941520815624600846368352029116105693630322473058296208786100550965569201739374), SC_(46.05749464804333256350522201132095229799934976740541214253406353979112639594413822938331975632027846), SC_(41.13340604689229391907201243067321100715755739241479575608405456808048258590746487392338714881128697) }, 
      { SC_(193.4701690673828125), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(366.5705686743556279395159957569563336519575466078190970138820568155812666767890098417924993903140237), SC_(300.4026436258091488280203591524684386202216191987346944989090304968555782288270021828083899214097002), SC_(98.37842037817299637700714661566285740278060965869233130720433805464683391598838130616237569346020916), SC_(127.6972610871578750540798195419293255461067917554134645230478502403006396736554285810299480626175383) }, 
      { SC_(193.9062347412109375), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(886.002779673454645480659624543360725129420960516241184577270551086245796717924109715305754712393302), SC_(818.1059802082073334931632411071625175874052829276919671380589607799544944681666411884929570636895002), SC_(40.72993844452654102974473195181251123177646679038599552224270911141602919168706292018086915106348174), SC_(48.08759012759707584769585012752847376934748966568406045495322609095670462765670669334195167332782907) }, 
      { SC_(197.0894622802734375), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(21.8247393835528268489781849931471906339964451388080696985702551630797263422286717188809573920201805), SC_(36.87156048635983696363963703907722063942665599248309421037843237009500833795364336090466858228405251), SC_(1491.851326483519096933769067479143679746825386958796018571901014893712657678904599532897971816894002), SC_(1220.516898297884838908581865684496840563157687855986976939625932088768029018968083203682826661405652) }, 
      { SC_(200.7224578857421875), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(1106.434975018364327744394373643647347671353030462914409324513407240402347819806626320375111147501661), SC_(927.6030951716653935089745019658844380655371438965486252786257247747117570543714464509742153495668945), SC_(32.38152477465950475616964668299246906207503324151116137998891803250833493688028347216115466605882321), SC_(48.07101966048470296061629223900709405759328354435936461665826266990518482274223045330409405282315384) }, 
      { SC_(201.12933349609375), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(69.70173589960107286742970454129049271332289566553991236774740515369963548108859518868969591928297263), SC_(112.0987830155088914956165509693461743887167239217937711481192516488535696870207670792340163159963336), SC_(525.4620875757469345106125986537596317891894043933138973581384372504262902250993173635587338506187438), SC_(382.8421288697287662543285719923741775878145504733891041455595800306688536496795677954996293634936977) }, 
      { SC_(204.29119873046875), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(2001.104746865907147594894337177767206503171680378209357205228083244906502963541247521434810325620613), SC_(2308.135972422315028456759403299073792573982905676012629798352586369436705378530911689793172920311114), SC_(24.33666989315372983191618436052980735879433222482251183914475329564835413069587457837061068575667672), SC_(15.38773694746192933457987094934341460016258173372849250945913251020899332069423338509900384358300429) }, 
      { SC_(206.11236572265625), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(966.2419522741706228186277543812202187212000281994287593275218233490362418782493464495117149759070434), SC_(1121.056380120702855221132698611266712562195306934163054271232567625389623790136415792505537926709325), SC_(48.00136401975943102274669598273257379482929147228965592146645587710093840760660136441194448245951944), SC_(34.41729013048803074981063264962854416301457627036937376294684909189966858398677893496840772433918257) }, 
      { SC_(216.17626953125), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(1156.453080342381443799121706583166715841245979608913512225325794915965585252517630586089335919837899), SC_(1031.393387520100410738917501257883405975171647082562500684032379387613144435201216237069881389880601), SC_(37.62676863972903244150342894735865910778834820323589749569836057318114941555451527631659189250251457), SC_(48.6015299010517717767668131525015616701585686807751243035908911881045565635947476244439787798648218) }, 
      { SC_(220.5819854736328125), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(39.57793101064435352581401676686736475767463378379434462962817745835375641536988915560427860910812039), SC_(25.77256390125002003624154540666567278363159526793815505032746471604131802498529076857480195346324771), SC_(1392.076217458888334669494257979969758760180762978603454861931792117075326109303884387251550052043676), SC_(1640.941412998269925083432568645742286703625578089648145344493381693102930709469089317118091840750932) }, 
      { SC_(224.19598388671875), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(39.89818919917766403217472529572618911155367341641981191325753031166843312804149358153368655868693852), SC_(26.46596589908248691512049990098956878037272638591822510482066242713301188149424951991690761033359353), SC_(1420.052691315027799612488161951441677889310129930166713443237793138141358807954269836297641153669029), SC_(1662.178384222810327023068024713383272447715630407721706162366759118795980418070841378818130680874144) }, 
      { SC_(225.070770263671875), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(38.82709919792273626287523667008234156881620535403735201133858806194341099164976617025332928443059962), SC_(32.43635227801528421225886610654419829608821452204881509370532747689423609265290639095237090958799469), SC_(1382.482626194690883135076297420551616048241008759227356443906714297794481859419962209323171081518341), SC_(1485.465053717320625552316716595217714668041493091950857986888208703696594185628670234428910913878109) }, 
      { SC_(225.087554931640625), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(6836.543035851444960877768400228850546299261199238070309767332505165091763524097308053878598311694302), SC_(7157.158047769440095246439379124203393707008223998873680351187533170802333984012331488178751768158945), SC_(8.492036940861554059553133971119102400947388565282491781954451133700438670466958564703633541311050248), SC_(6.652258546427684181689569769512961129129420593860811050317004498938715201150160793307704356541485878) }, 
      { SC_(230.6797027587890625), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(2514.191872443207997468413563749323978423133771791102008458932990024782402318100893608942553699204649), SC_(2346.456307849133560973496699259845564245546100760428536151011217287288257252427490231032002247494249), SC_(19.77980540235530490062892338439562745205873176899057538632359023912351147223280821056959264240436239), SC_(24.67180024287662429457965594658369237304983319450243790843125659305757610275014044104386896519599722) }, 
      { SC_(230.694671630859375), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(2282.543945316942095114109722843035801678356714205415462364607907924491418918300373356243690754786784), SC_(2582.477155830624272297103984281123336758274449350473082392520927201983062725966111360301132994720639), SC_(26.70914140259581995878811616853837491629216097566000854152500151536742069876875076086532126288134179), SC_(17.96445887378479529154920807094741448952807052389272125154415671408025323662689737505569892443425944) }, 
      { SC_(234.3191680908203125), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(88.99441162093508021935373961535934439506817893839687420402184929070450882357543864983072597687262626), SC_(121.2818799539855396276066601461873554045893776471952097970737916796156953255346757296329396310744533), SC_(581.3360549237584583594164850394777895981838849613649539495931895372408172059574398931181472302049755), SC_(472.7482621016447438920246490950294622002929386539893514121094071251985351760111927807590435383830802) }, 
      { SC_(237.550811767578125), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(2229.147174762132853882894476504420941158353907423928126549925065413476193972318476912441540968466606), SC_(2334.394493125107703249830426426196159011604302000650451462521681198552725698533267642485915252685465), SC_(26.78792633565545749490392524510681229551809281881237151197549615063749728451511009602713088692909676), SC_(23.26200152065299903820602131001681151581635480292021279861886063513306815326986293943469149009423895) }, 
      { SC_(247.5666046142578125), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(125.292032852699846566209280966441922942445540712947286082587092231534759204785331004728035690388022), SC_(96.5187966937572343217527318126070574781038166304862556898083278400632720494170718994927148981570203), SC_(507.9979084990267760665061116950904614767919392976158843078917502546244625910566253336934272947208758), SC_(604.7618388083372713539145956635522997666075351036483440973546563159348537921187336548149695924669735) }, 
      { SC_(249.925048828125), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(2114.407897057942783090216283454152130146661331775295316113760830022577400774245359445977752452514567), SC_(2709.777456061689708868544361792494340066962877663465536956301215536379556113062938823855393118434672), SC_(36.94830331297740411040132316541589163869405698911242179158149722677333288276400833902623214953850161), SC_(17.03494481408905741549646839918847605250894758248469083470026769165886509080242049438126545758794689) }, 
      { SC_(250.508880615234375), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(457.4436802672169865361084400244208722433533802648263824906595550823481215793642306954738880435110705), SC_(404.86064798243372413254366779818947015545004966458759905733322251974223470371083603479708755554752), SC_(134.3194462824449339373967042758198809220419066845289526928536893762005821791540476012212791309962631), SC_(157.6206249355053559221707911155155973070616837261996650099312171444268926430033006868069198306861873) }, 
      { SC_(253.8476409912109375), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(1041.233341411654618394711059776702505038030907328264433426045667284206903102276024986404478573090013), SC_(1192.385485053352237366563600389422171056705043363264791496292305686963542946282094685968172341680399), SC_(66.39769286082464441678476349846856422934758813135146394930542265672060866351496526596452913704553562), SC_(50.01814157291283744380179363809114395190926364904292030681634598903038800099419088595843469326113193) }, 
      { SC_(270.103729248046875), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(8802.040583685499610468485654417072010802739878162215723282731085274129942027675735021790879199337915), SC_(8003.886587673852899986907513796155260912039377051119550156579414738757300919304554820127184794405606), SC_(6.814392105912656872004561114920031185281182908438931383657734953855664996235859916547920867194069536), SC_(11.39347760073148436532277947402665218917797491892457588041160452149187409716634144846319260066041449) }, 
      { SC_(271.30120849609375), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(432.49636041964890457998194009003690641890005635226467227211651635296973322303795628197986815746154), SC_(501.8775679265435196363793632111744488858852784730548590129099666466003820531768043541240251117043715), SC_(173.5580176003695246219317065370715615270630074264939284398720068435500393139325769600829940837228071), SC_(142.8132477835673203095152287685362531290993344716258671481436487179484068647678412544382664042292636) }, 
      { SC_(271.650634765625), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(7510.192565223906150959421557467010215187367416860042619268777697968764973337565020042489841306850181), SC_(9452.849510122382906877051037935296485256470288164312367809757934923008166697149784497510913828277336), SC_(15.21943696141201283121903650215554561837684120957978179688782227865602274103037785265141725547066638), SC_(4.127446580565579064339310432324127060645902140980792310388358860284413091193653591290448482770003404) }, 
      { SC_(282.604156494140625), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(62.47217429765029490497237265772040571454968912480079901486654495714667785228625331798081133558194935), SC_(100.2754358914360903999527402086647235937777965766183058327091127996348085761058681544544541968571664), SC_(1124.376786067755040841126187414450214072492148087937235456250899250758131699059118306507996609022307), SC_(874.262745801029337557356268453765177544730083127928779716668251866300127457920071188783359000198141) }, 
      { SC_(284.290374755859375), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(137.4350845252340104376360650998239815104490230687171160672819991169876226649570995570229230689398781), SC_(116.6548813190166719645839640071123204927496241157909589551539659836141438152543539004746730691494391), SC_(603.2096474495792579025263801022910852595449814492824280127920869854852986802612782286369740906145692), SC_(673.0873272180518740885073470199538203764319506389013785552121225141449254710572544567598477220360471) }, 
      { SC_(289.107666015625), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(1379.170386032963036056057467075610739726228293042048969958685097699807050979634067168531390995175076), SC_(1547.748211357701918310916056340534996079524269910192898476298075415794849580259759270019232525739132), SC_(64.97025070838179086041501303586135285355462404143006123046504163708423003874422641481127056464888135), SC_(50.1745843220360218614668810020625781890857994377690899121309329207453327883735205678813872316502933) }, 
      { SC_(291.19830322265625), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(1206.421854872057615152825528257532521052853289900948909547711370701832547668297551730052156051588605), SC_(1355.24421770664948490469952202015806834660070214495625865135034439624331670566795307005504005474174), SC_(74.72942395368054411822919722638786103750360948352569685667357069576631042009910419268067843376786276), SC_(58.60076468756929624994803583965469706851145322413151074856114153741053607925311857414154545066872891) }, 
      { SC_(292.808807373046875), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(454.4698002779212714754795779720293806887877501938277182651427250538535998360393175723241637442005439), SC_(555.2444054280294274342076260599944193757735531653364940501414098336432665299798507623002086382805316), SC_(193.3416431197058655689945443912695000138682167118555679109416798905355876259149195899866589415561013), SC_(148.6868322417619683094062062628313195568906586011991895211289044512788896941196868330371668210917848) }, 
      { SC_(295.273590087890625), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(8484.036853532861862831864526995190482667532383810867147394499950374516575744042407934615975602725099), SC_(9912.698466931445135259424331045006737989225579816970964548144570824231175751662751316733495080263829), SC_(14.20939908193095054374956404735830386490792756530647881560407548313344249343969991242951641749495597), SC_(6.024418457776440926407140862685079081591940916168380556713860944684306536133953362834625552593641253) }, 
      { SC_(296.70086669921875), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(8745.543843289821079785526154189935142812120335121153517082820185359937223241139523599573235534365089), SC_(9720.47240224067254081505112737969811612727888950757700482424577356875594869771231133313302627648454), SC_(12.7930993037119493752522942952395437922272217351119623305271985343324485308986443046407418586828492), SC_(7.199755852417057740871259943788458146442246858410469494498352134152935956292101710421208220197293712) }, 
      { SC_(299.14776611328125), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(121.3107401866732967703978488044686587427043757704825828770314114435617901167300955721457889812748294), SC_(146.1528733300425636612484199163065394315923424675759435781348537163121672639253995085848839654086084), SC_(713.4543853449983803522606301741160012891634266257858254747411054074484345056035266465726328968800706), SC_(629.9172050719709568767512741849105414959563989214414678272966274142323610976249895766485840238752165) }, 
      { SC_(311.905181884765625), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(146.336336031304469824008430114477471069012893499900243765278297615667000721140000183075498837948816), SC_(132.1487062225310558513385862728465378412324277284301577781343062918365371368308899531880395405574316), SC_(675.9592450795484129520223185898638085139214768041090869403561819830571841751899260702988037142388762), SC_(723.6662730378020760465755420219699825269883161878156506911019924804490976356619692018380957163323413) }, 
      { SC_(312.839019775390625), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(1405.931274583914387098978809447555937292104259311709252288576425179659856511389576564301257620275644), SC_(1771.134161564664899250968029949568552106429390532189789367143788341784140439083343783215228677013232), SC_(78.90298667232884442244779517534814080800239082936845147512316489024976845216409349985595450849881847), SC_(46.86486053969143564203698101037546868875367765261867410894332596028263141149312057564341073140479121) }, 
      { SC_(315.65057373046875), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(39.37995588389156633706584969707704629195064793222744739008366865693717556987278237295283481619341171), SC_(53.49792683420493109885010436754280386819873401030080173271013492970179671596537577675972986320318029), SC_(2295.903644510357717396271114250463288315687186429335140604711248164424042562459805330095094415879518), SC_(2041.5211439262672240167257506839333338482138271861824509471446921226127876056520829807636424466458) }, 
      { SC_(324.47991943359375), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(100.856345243934846363864500842371758499561535399107448529684874495193805042671185699169374758294781), SC_(84.1570964692384855853514473611695466605990268636285865959576387881931568879768889653035602791258143), SC_(1087.743547754023658361536135615896624042922235941205706958544648166616505237201323320129502127784761), SC_(1198.181815581476969007735843476342037433433442654760427459009523093186543349791717686827239307751267) }, 
      { SC_(333.194549560546875), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(1346.176112527422109546505207241340449464455485265043886936043930741073763882625242940713260739623836), SC_(1588.316339240183298848929030811101837904137456235381012091783966840392144835977404123205668807855419), SC_(89.58955622458038562641582201001953219143315981964910133312332908225644228019691609493218749060319764), SC_(63.35012204092930480526069113333274060472674752585414509093745767180039627384981271996653701826577571) }, 
      { SC_(333.627716064453125), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(3028.751415709655177123458002086500071999447659478751686037603215103631746193904028185435428092932816), SC_(3388.143293052493315644456775833956063826393920062428316190573012475050812569181833721372500873532995), SC_(41.20504317614261600457836090391118485226469178147885170667241449214567114013332563834728120999105786), SC_(29.16505507927335344059048971995867182095812611616661040524482356638660128005435016444175060795990962) }, 
      { SC_(334.70599365234375), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(3162.92388757197258646916411067078956348536293315146732173619910142868436325310368340776777936723137), SC_(3915.440987700839395741157856807271129447424815785617934485631025080984024037679948186150478958811241), SC_(43.69599357623374539810817162535279816127667131612327225930115313819102127259602605570324417898712665), SC_(21.7693027874799169330956976157306072573857019199025679054455276436359963572513495615599389659333804) }, 
      { SC_(335.802978515625), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(1545.227389642540360868966850625193700313976048170330939665460930011462468638903139136753034226143156), SC_(1408.080686522361810610659229932920569751521561026454639383938876874000132178124796262866812159221078), SC_(69.32377165370401158773414011194002219476849021524749284401392745357517631779186863174676496068332912), SC_(84.18846659259708247469386553892803673113084363234540002661316492698394116171672120030549940270861351) }, 
      { SC_(337.74249267578125), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(3289.187795832962523973528212763347852270057774515634966532783405519356192898799870951301952284889652), SC_(3841.282142968288495776899463624455077391000346890754511385763123911437510369658428525721548780900484), SC_(40.74647739505881665679909824348889690077097645117880083660031099968993936860388518066664847682016055), SC_(24.64871348714462778550455372650569219678686452267221557851804861360512537374905091018508070874471843) }, 
      { SC_(338.39239501953125), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(546.878867170107210312150549529798315065125689981471032792885096657529177264657878692612726762771313), SC_(618.1137093421739861535116836695956159773218982076082643882203395372321703938204246540310506133479035), SC_(212.9154427112635113837700226353764226915934607470039391910354176058372479362020205781958559784314997), SC_(181.3482856660621334160302556732614936611395850003628547582051510373187714063974438396074631862965365) }, 
      { SC_(346.83636474609375), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(1719.511538897616566823907623379639858096541193399363100849098868730297781164645651372978543503245611), SC_(1789.248769777842621426987960699477492405949708745091008503011377889328843581173850191379978682371384), SC_(71.87882171439820423908528261239808463907633231224486207300553938640542071828395377969463261954717824), SC_(65.75687395624046089305431485010262930906883015169114659060392297066439898692612154826812401336530598) }, 
      { SC_(353.721343994140625), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(174.7778118616485955879705653568741280996644055917097787435613026287744565080115051207119184410299718), SC_(141.577595726140260709488254259377591336185184702585539997155419947649592747149579939937722167352736), SC_(738.7163099340652773328093403726727404872460461954948535110216339203781073073155710375881194930307801), SC_(850.358799256948133519670506221762251666495016710863087814815542069578508751523471852463810977274628) }, 
      { SC_(357.90582275390625), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(663.0816874204673996415430280189818232246176724606008445559017741393571608315913088274210795779621546), SC_(569.7872335737714884321037286659692534766889048043562266451466186329687641671093007881349612208458477), SC_(187.9833427637078760855769565607796369597614013485473992449613482625296649596293712334766090533060398), SC_(229.3255649149565038867122753843098014700516017703344072604787951463412891670113842054952311275427367) }, 
      { SC_(361.889434814453125), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(1948.509860557045950453462287770571982749732308036970447283300584119568291981066858518330114176862879), SC_(1716.699086540586494047665521432144536789372153637936133299999016347700111450387985576135766978126724), SC_(61.87388551103362288920880384469305071557391863184221633713560145187074947250655886681620357136314236), SC_(82.22028487835620589867131753878758252682887923319270984367106014769690556902644063254718433274521098) }, 
      { SC_(363.684234619140625), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(3561.673817008735080394783918271515872507485621712037169587768380722843983106682618498704971164690265), SC_(4115.004178156809921563631525549943554912772611216858733689167560594770860474895199366564922495840498), SC_(43.2009663646756273408522913363072785907862960247877824671285010971684386454930648277658447749939088), SC_(27.06466217652195220543554309800970465205620438823475656095553371694477229714542666037219797663800722) }, 
      { SC_(366.535552978515625), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(51.02506388502765548192380105068456134018310440888078190574253479594372080855461883914531293433941324), SC_(56.30815026898999673288736625181957733098918382249983859725454461743984344010583603680769968877558175), SC_(2563.794666433529480133005455195284372304139238046977059284021192079342434162376504975398143685652115), SC_(2468.630460345498239893313431649222149999103615687858166863443546067246631854662852665526225108839762) }, 
      { SC_(366.611175537109375), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(67.34812251175341524886193853458834072505940853233000439890388740658914325318966251329380325656557055), SC_(48.76937843088548995608091742561176797398149681779577166457326444855579872793963012440904761787361479), SC_(2189.246426091506302467512005207846953288705757017452886236809313558317529097791926734443614453086277), SC_(2488.610094486888930834725042796047545631423930709322834523798522098990605249484275424621173763799046) }, 
      { SC_(367.670135498046875), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(93.59242350066664551026833407413371594575800545721498215102387817803690288475497259044397296827166526), SC_(116.1303568166698677317707521356461249459803547230933435079831478649229701802982342176225761427363856), SC_(1370.111075545371796791889527743317490400715411521826866601906509285442917820898149225799267996227747), SC_(1221.059146845386804921155480681475607195317412654987604601212842605253088897945553613448601348146952) }, 
      { SC_(369.6851806640625), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(47.8757726690580143235293742265520689805388855147185688437671693593691965536602519887832724835335558), SC_(69.39436126225418563616982701211094525988713762059196053151021978544898566579823710798462839287808575), SC_(2532.896564490541714630811334031349702964064262218337424235979445711384917204602123051348334375804289), SC_(2186.13332410174469226536229833639556334219695450027794347432152056747534584923637400477806100871947) }, 
      { SC_(379.242218017578125), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(45.07400273953580350807251878046086509091071582473074489616426489067127998106530572433192915799881398), SC_(66.70877556218067503334226717142823819362146325499223763926085402899940556522875801864040239695048623), SC_(2802.700199993964812733940593257541985924204421680919468496450550652161473840716202987844607331625187), SC_(2412.849145052937022535313415888608227730257478133782444857496738696626764004693361840756100391867812) }, 
      { SC_(380.439483642578125), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(61.90766700962656263114597926383475839639758594669826907290433525831228607051842985009505179644909275), SC_(49.67874752183953052587079439595631932881452062380494902273151525905181847829834867863299424504571915), SC_(2502.744625568256308790281242233875773695611295676024745308025443911945223869484601449928551128637892), SC_(2723.043393172230730740887177566341642985046160245851613789036993276698598959810819569338646619547638) }, 
      { SC_(382.8638916015625), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(1789.505083970077316191456024760650600248724495453225701527500175121150265715354130453922156721370349), SC_(1579.76575550454285859133413459242488671308036832628902782469512850606351150134099290632044300748805), SC_(76.2415680648598284849226540605029136076143054967134306674164612651041423555993056813287080118789139), SC_(98.97346330603744268503635697810835887413518526863882687760428520850156333754581524350145649751738068) }, 
      { SC_(390.75726318359375), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(617.0424658455831017991520845637385330945416158979271196283360176419331374546568612299820725736850731), SC_(729.4924295746440946343112411303648220570537314097683876465643704908808062259987283912350190588100054), SC_(252.8207787524392662640087322438529187841609854989161539780313623830737644775600278852506227341243388), SC_(202.9902432222450277698391546117515006756236064890018730845340580449854363335234585349328958093600527) }, 
      { SC_(392.099517822265625), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(3923.163436648163918413593946540454369288671212079467363098400515512337129031956981953019205523491982), SC_(3615.826956425655255579966130049502830945521149367103737584346023474891234309682044885280101396046095), SC_(36.04410677042899835666509487585152042231822105876308482809929630695766488685782132501680217579370856), SC_(46.34295170668300261499086577714818654010633713224779238838283545895564079794012342858941270866299297) }, 
      { SC_(395.1163330078125), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(50.71360271146617684433421711782866823167344096145353949303304798406476398021881764413023971089228759), SC_(65.23702500594041976473015345126457181605725289765341099575798656162238878063839011962123258168195225), SC_(2845.05459213286614940564620936353562227460543925912119988075807071370821271000635985486984758403813), SC_(2583.415014071389821296011695228558543583108824252461565212922155022733276140440216172124556131628648) }, 
      { SC_(395.719024658203125), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(47.32426205541540674102328695956963030538073304126416635889358323886419563774379578185220325455174845), SC_(78.87747182277674350577219487238775960807051929823283521236262523387361138240769829783758751527181109), SC_(2783.832052405102223263173583582781010784034188041570100221619732335604161444581931051675822962313634), SC_(2275.216757533219319979032054458820405916006639679033405894754861517638167059623567626499046649278372) }, 
      { SC_(398.9324951171875), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(1577.606068152680244284397169358422214936696725033407142692364735025557564500667234095772359717744658), SC_(1940.395415720048919212500313658132653704494589200664053406250924198242163885311425200428265623387757), SC_(111.4657311386874009248856462526213250604949532416569990800224737495174122361791999460295844705337453), SC_(72.15647576887895039092163511174426793617333940972135085602254545139862606821267880187633397227480452) }, 
      { SC_(407.98626708984375), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(13010.61873731764361948401300279799291626481901277799876457661691891724665262475279500487697128551346), SC_(12371.13114696534000672637902315121001572770704988700024503600087013735335890883316392193248630261706), SC_(11.63671404777102399158269653441348790259322723876296502505732648370216036832179562923281523446356231), SC_(15.31140280549697716422289956741796464252078436789173337434334035359535711253419676614153157154488502) }, 
      { SC_(409.160369873046875), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(4034.718151929356092247832750985247049738761173816991439922649506325788929740825800499129737907598317), SC_(3830.091517871982073298751996440251522662569759769788849094510334047698622950038333212962979038363109), SC_(39.47032919394069376252723987510003233695303487055724596155856828129690203325822222801088521652599295), SC_(46.3282857166945204982106981605864612070106378710264204564808638998835148640011076542768002415431661) }, 
      { SC_(427.104248046875), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(4424.084954863841617892678229819086278754371221162315470256451089231057036186861633321180834090503736), SC_(4578.260219741607965253728115464639646551207257087947151096350964831831037381168346917514888107723223), SC_(43.07551920721382776353832171502803025711868369686219192642243047263630220580676883198862654057970767), SC_(38.57622265829423676159737800260217581047447894960445035265712292445722298213463911326162709158760066) }, 
      { SC_(429.1436767578125), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(47.75313271333614446755883415168502775940184888189273962328278168434253264027696460219883854354320496), SC_(79.25754505904035138291492894476978734191575651323155070061163561905573038210001532229883448840485699), SC_(3238.463097036761444923587098025101976389989910336516238208191901512506041057285508929437962519570382), SC_(2670.639173644051940315884830789554781433394971531439866614277535381484601783350124887003109263052275) }, 
      { SC_(429.75054931640625), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(2020.950292077043754769386974746114313056984012325870675209004428841216158163136277452771358933750427), SC_(2333.606785660090782900952341278349883472752940293149407944201102371706515762618417784231294734726322), SC_(99.32525411299787707293942005607653807312209703034907121913300655197337661936118830252134257720930323), SC_(71.88308869235661592572371432416689295428542440984630398804838243558376667971496302546809665496716774) }, 
      { SC_(439.23553466796875), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(4887.527087937533386421685306171177772243151666534635341344174243280012321165694300841769661026542709), SC_(4378.748113850272960847194243584191085014083868677519680137230422090502989597457709845286745989538136), SC_(34.77261112633111782951027025316670624727234419555754319735003296312722708582758602583490058445586495), SC_(49.61555992049993277965523818905519052855851577841961939741887878589348738918118706198665336525624636) }, 
      { SC_(442.209136962890625), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(174.8359720111596511794193683075323945252587730064883122349464715386892168461071276521254576325051664), SC_(220.7821620121725094584207371118093575991622262601403443526816336924419407678500482662847470040618152), SC_(1070.967594753974698055179672291618377187807774938159666531131944791764897553056113804301325286017454), SC_(916.4652253813452614389564386045963419039591947903569192517661577391761216766909552864410877589024941) }, 
      { SC_(451.029205322265625), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(692.6102255413889896876705554965273547539237798023925214286499767511877922255770543372131579102025492), SC_(863.882887211379240558307311462178158915251864708299181261265706152358004619264903846705456763477112), SC_(301.5175765983297941763227998715122517042737776194072826614511319238976353121358567469468402737084935), SC_(225.623050067534099838113179527382685575005130425794064220483964199508721138717702085891607564105874) }, 
      { SC_(451.861480712890625), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(4944.163840150241246804857601946750963029327554753849054302303658295258991669243111788292577240889388), SC_(4583.830722857148785837350102805196283988685161752401093506552305944209974937745606135107804758961995), SC_(38.01089652369126696522498351159070014397594700966177865432327739286076209701308423582695247754713549), SC_(48.52537262261828673929327384515162545539449808268674576211240307174402228925761548412458792808718487) }, 
      { SC_(452.690185546875), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(63.34022061072115219148710699550937258631431548703904437513539652053700954230335412025212485663563007), SC_(79.55713639787763354297244899488419896918719724533135942214443752598261851032026592279842636914831423), SC_(3017.304410882430209491767820719968493030366303700984228314665299980273985878494458803167783770442401), SC_(2756.053444685623136829167723206430736604615728648851031941341506100644185105830324405071012525769458) }, 
      { SC_(452.74658203125), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(124.4529555834645897242791817031765960032619080891188209516177374719826358320804453768227107976767711), SC_(133.1367520647264867239134360212966670089446855560962787715878610198615297636483765825814653123749023), SC_(1622.866922169130162746409563064360704943477707966019700516253329432366968551557804912634808307384271), SC_(1565.444836555024046358462536341685864602125517127331247428338725271960364982857405309261337426201983) }, 
      { SC_(459.7744140625), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(4660.66545439009552725495521634643059211339375799816954723699065546990876327892765784709837081384697), SC_(4184.014441039647970329146903245895806316197272623581471740923232975148933641564883641639522130850474), SC_(40.37066332972148169633170932583635883024949081733766145789850684308210268946184104400868944882492323), SC_(56.34244440148797851371601592996958480887544797964525143548941419898224842710278826664565790798208131) }, 
      { SC_(462.52325439453125), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(5149.549819107952513515117346122390319761679611753876697520682649808944612315659697364079456192634281), SC_(4608.533926407965404419674842051226657123824854946959096223596085480978406768320106105319743838504573), SC_(36.52830740965119590739038062524104980364964040542323295733852272525859727886108415289161009234311235), SC_(52.31208007676055370532270685429733209300262612214472041671559530002317735231373439378289856786843204) }, 
      { SC_(462.843414306640625), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(4167.784498011248233115229943929640265049734181076822361336904416563190890113134991651560961654185535), SC_(4739.41770053446386221761683733583898674467514607856192309538827372731265488180539687199521511328825), SC_(58.35641122812820348079142739107146984595383156817928092136198498970045806280361102759592662818864396), SC_(39.20446095986093207668853370478562691553090821914289707731672316040947736766945950706170210452829907) }, 
      { SC_(492.655181884765625), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(213.7163267907811063294899388502208491585852435877779182608664300180966572706309780899695340881293691), SC_(225.7599788609761650551173008028267204910774521636122259875868859608200957675348274266359889392991309), SC_(1125.586522195453651556044776932726942417383096085771927485055203385675405662962632974915483785999178), SC_(1085.091098842709231953786263736985874913153970688202052517194019050847181285101301557719561447461236) }, 
      { SC_(493.06536865234375), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(4998.512185100025332340592655111530142157304769618074262613145525110059317461123098713406398636512812), SC_(4487.012581972380974152943989769857775521509310441279926648897616111619166845553891728541171341015169), SC_(43.26661841967829257187321998901628385500857637803461259524672767362211181102166552485306614206253561), SC_(60.4067051084654297645538080246012244200113295389038425017941951589130004380413384724137122067029151) }, 
      { SC_(498.589996337890625), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(2362.846346836048738898201402633377683519885489938773730470232781066977575848066965212094475223834004), SC_(2688.114105745821636727999747441686140683583405698874606278769264956832188326078086074505528138209638), SC_(113.4514453547298190098392978838521665869923997946879503799132885176682063399520420312739536964553747), SC_(84.89990119088916732525899215621681255619760479316504388804282239418201261173366599346609151034910197) }, 
      { SC_(499.632171630859375), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(69.57472278514389983368819307486136084453023706880082529311812220077013413438766063180478213196545707), SC_(88.11031931376305743206406035007084646183724517440687614687760559941879154126114400963854969518644174), SC_(3335.646384912552614686643159303318652030759700998694574551473665471858590549295810043156573401756398), SC_(3037.048334890587526131161687620165937940480960648224517229104877787732426058224521274862778894963672) }, 
      { SC_(1026.861328125), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(31608.83614930885289474697226412551865968613240670788057576718305965962200679370727178500806214240532), SC_(32294.0914996241888579677791436581189088671969311174160208685419351768697694692277121099143546055188), SC_(35.30618961983656741634232913120486923780152024440041145706806568742334996559079461624319321826134955), SC_(31.36310677881512185821610072989837507130131338865548847460414089609920414736490612389345994085271605) }, 
      { SC_(1134.4154052734375), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(173.3580082473593736460856027782425709179740111534235143931618273161285723348607452305903032009751961), SC_(183.0586542649772004098164840613033692815628286612191541634300752809824198623914065277112943719761654), SC_(7310.316799268878369228461514290132636196318798514598498989498557500883805675641562260004953482421488), SC_(7154.09276119671282029784512975549439484471516195334137426795237500746730288219320812831827330233356) }, 
      { SC_(1221.7657470703125), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(11923.1602058252052697006014455337368301024067465147965676434261132832966374152387653002849196637678), SC_(11569.45456882427670818542161700923428673771021737008930230047321771981613354080820754849524781011091), SC_(121.4766279426787501508411684280501985196703515708572783575690121386925965995059868580945580566094526), SC_(133.3360423211526888221398407211822515586865195721484490516827649409358021419983044675466479515078448) }, 
      { SC_(1271.539306640625), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(2118.736916300550516293845273469887836769617043436527868598789129528422807611340288578216933835912942), SC_(2256.876171734688270462303075682037027974285334767749751254730236002532651619714400351698519851719081), SC_(770.1685027347285607598618560346597989884385043495392381011098336189232290537302400602501527703801766), SC_(708.9486823049943727632288284003561254069161605917485461453268248998388169409186080262982671343219368) }, 
      { SC_(1271.970947265625), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(11743.79422921862530566909250244067357191622878159754974430458051367987252313934683555076367653667575), SC_(12725.16944755979835072015069197465752282853357897935795406172664831270136371817031637411189054810463), SC_(149.4004577458615290905937564318935195772685055625890123185249350669554773421280419652996488761359209), SC_(116.5006265848404506200151431700455597244239152234510863145449494478464857099624350830758731471819975) }, 
      { SC_(1275.2244873046875), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(185.6599257323253021928917819596261733370160858128728934328003731608433386494870164061549668526806941), SC_(215.2865569492879952081738922081401494447490550396184014471084803659341585114915406620222409050952784), SC_(8370.573132170469734459859472438324683901103052925446179842102502254544436780869582647212094384279239), SC_(7893.434657905049365894200239012587514205378549846968934562080205101696731964071293986429098488896563) }, 
      { SC_(1276.5601806640625), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(2095.478516796558370025259701268306285314420815574143401294513809400750897068026478112544677968135423), SC_(2298.783438800619021799703543554979454395604828427216647729932784642449423319487946810053623137650805), SC_(787.8611244549649377892450879900167038102797146911297249367127178837321696744395677378969817454925689), SC_(697.7623178022901029462182119812822745434234470909263380845389806337108373091811941545095071850420795) }, 
      { SC_(1288.7210693359375), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(219.4684798719154106044935461522804523014701222453181604983033837749104862706876763611808246941821828), SC_(185.8258946493965707300616213529478377127635892714339844639526908487632328475271563827546008737087583), SC_(7947.75532951882989193120341488861962226219487636486593689305939778530383593849727645635886878801641), SC_(8489.578384566865085715468679025142262237167127004978744628240791384939283283509082607119066568165662) }, 
      { SC_(1315.3695068359375), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(533.1220999258876873210905541529751975379245296348721336030121963852183557028395001085688732593894658), SC_(641.6440989726394619879599346652363861002723353855707745401173234284103415162511035614289499097551634), SC_(3137.249070739157721954253130512094273415994584768998626418674661383765542928887220220476070531126694), SC_(2772.356857010449231484886294428576290912623752517266360880314396959472311528564336106722399137262248) }, 
      { SC_(1363.293212890625), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(2318.133491180470093205583946000372662574047996210738170703553128442590056259005807089617092215349493), SC_(2372.153850125309068097292464197554964602506843748174702096992576934973529010760339366573357532022792), SC_(804.6164996057099402280098731693002740762518466014131821194729551280347421718631618517106409575094551), SC_(780.6758544508049020395663520363405836790782541339209389062864337996680587704485087334074646728129178) }, 
      { SC_(1376.9173583984375), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(212.4943716244307978659427851547808672294973109842197625545448698801952818740704506540350113921145587), SC_(189.2122342759299347318590951596674887983557015120851650199335656479287709414713817966019470170224042), SC_(9248.497731066434578432761855709903225598784934725662314354875724357685535883130849545298613105926671), SC_(9667.745649261675389876265105382946890936852344857672249687731115050236101244852475420780445542946098) }, 
      { SC_(1377.7630615234375), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(5823.079532283042567297205416128525014108430245257308766181055600999891375867689728676655332170240713), SC_(6298.787560901300524216197991423683616994591825310937295454236727417683558906912656969407505110758094), SC_(339.7418820892733674281113454984054758177053577415774293179646316780573841051587006268450073468259782), SC_(288.1695136969406472000485805058286994784971025982660699896718091303969944475971103693941347018332238) }, 
      { SC_(1422.516845703125), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(604.8445080129181348118303844543657410403781323432537636838083118671423131703095219515025453807988178), SC_(663.8139133393862227871918006483813945582060099007758156567185678686455595157403956749827296093822609), SC_(3292.093129893641156170123055204962775879866603789370904662063842281232162942761342547840316654012868), SC_(3093.823734078890640240295798125071761499817178040533058578342329785221459530226570809346360786707863) }, 
      { SC_(1481.5267333984375), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(6170.493614918986711627996872395521480585677856514114504402499273274617307716839674142722094445550635), SC_(6869.75566924579817676976096507088323998027843877319222976449143139781964013757812379553107731410276), SC_(375.8754818484921243627373196910539214014539095249114150878716086636067332022705295582792126633383102), SC_(300.0709186626737450973152344173967588407787580154346821537980958275694130081280728558694015231579983) }, 
      { SC_(1523.2218017578125), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(6528.860031868747435919809865018760882766261712341944114648641054911987522000459320882297358520280378), SC_(6869.397661591384233017597857702690919485482507238666826111700422298418597529074191679426831978849837), SC_(365.2652544518813892144526239177454873231346743393358146415081523599198705463670259720607769124629355), SC_(328.3453756896366541161615031925415971883024259923254103658327913902158755616928335307103519942757685) }, 
      { SC_(1614.6268310546875), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(2660.432701441477190171871481566154837767690859488317789986375047137203065680736036291921417933971837), SC_(2897.178671137243753017615426545376270500801122934370130679776786122772293955430129131149652138562141), SC_(991.830382948216165736103019027050313774695878752124422129282170935729138416535516789521223948894547), SC_(886.9107994157055477417680168353030822249993974713259458839750009494372399191518081287363557590713803) }, 
      { SC_(1896.16015625), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(20363.70834462134137434239375395291392050363224106250406125707197335589676774182817620971404477885728), SC_(19625.34584715480479922027250013546917432057347703333542001033960165135456441139593485149080076132949), SC_(169.45116594342828085171052759207340133841555731668778179926868295179549287408330975279264332653559), SC_(191.0089193628395284168942840096743704830437550486887608859290859894542314390192286542875595394545467) }, 
      { SC_(1904.90966796875), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(19199.58081862881296035433880156860442518423769099104589827511085321262782062111444069224258384790575), SC_(20995.25337920444084800810420716274561482167870352888546101270341659963652302695757830090062699451505), SC_(207.8408579104269362816993156801219016532731558665295778985086249647931953828573055814162225308454283), SC_(155.4237499610972652118706949199131481545496875209721935436179922586935606741651096659907363895910117) }, 
      { SC_(1922.52783203125), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(58594.20759044544379481232595490290881113021559994960589646163776520863183717276216408107749923586841), SC_(61077.1289708110748898877334337430633268272956275026314218396114176342011326150605316007542712371481), SC_(69.37943023466209340983297850127711967709169153820505118377517405268921348102469148516909607615002354), SC_(55.08881977268509471007013299853045625383068052609015015254984987140034146254561400942434502974302806) }, 
      { SC_(1962.828125), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(9602.809179357350664125672173865985757927340721899558744423994554112793441197791407322467013297339737), SC_(10271.17552933055346177057165055437722086615095257279100438232843507267246130280622015490640672812995), SC_(417.8359774598862960318594854043040931553954922200023913693822896612510007618507970592983743533187318), SC_(359.1488906510053056835719651004827191575694089966733689609947156631213473124134387805309770702311586) }, 
      { SC_(1982.2989501953125), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(513.7780774715714873606891421161091232712982779506162263057477289537784573275941973258937527218104601), SC_(613.9923740660703134577023053000035813640107114121113456215655353597895503644739794042505897282632678), SC_(7317.971266868942129673755508641197646778482067771587847536734898983647807822548784368438030572952648), SC_(6655.345061135015289902187529424717548594164824149809235766993267633601124774751448717777949244183883) }, 
      { SC_(2019.1607666015625), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(21859.56113311816445775056964280634964008544078681383187604822665261093647736107766404564136848980149), SC_(20728.87102118628184066815097430635491855291711838753696916510939178091114490879383475343517894899561), SC_(175.5292817643466460485851254875413614644256554520386737185853379759999409626232645374647184498565487), SC_(208.5405194423211921284898941221192072753296482204301440450583975192606385351458297707344212790470427) }, 
      { SC_(2048.1953125), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(9251.20971345051803552385542919682620509920644603256580039854796152539958224800801562305783210383776), SC_(8765.928546011383120017882902844149353933431808465032898855742152811408403922629457324547095962590473), SC_(439.9675276089564282345620419582006122320914377255432673974350477563177149794180439777777658536928814), SC_(492.5806860336903037924547888786738716457424866696128620891053314963687244415557006002663304987645478) }, 
      { SC_(2065.885986328125), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(3458.662796429088132312367407716319649252271145451106260841633102165741744577981271096800243172738622), SC_(3650.227348577038303937504531285108600629428070470879925268495063953454869731189697431144904240410794), SC_(1243.804167604069128310925257071596305672916602167986277706312714508470992360777140961598393016450172), SC_(1158.906809422989128464880636463428461129440127118210628024947965349256165564667810274415674365039852) }, 
      { SC_(2072.70556640625), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(10265.38318315518898845358942614991005156671393550921442420152212544243931838017337893892015691586266), SC_(10716.99338750929566740824122638791434417455078025233796840641382459133199162939126577793689660545368), SC_(429.7838594902798127810436323936769521883025239242143898502415388944936983833084605188997361865765053), SC_(390.1280127511312491786485865322973976562427316453830664889929831259065697233670534667272722461581228) }, 
      { SC_(2124.02099609375), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(9598.229566565963612177038847172146331826154699673419943085391633079590206868517767644948420818603268), SC_(9086.145396432300226517540160492754277933228953478543245760909097678354104723436180116358335621640877), SC_(455.7776094326929438720060004440493557572199537220836569838918998844710993054280727400270946755867808), SC_(511.2967304153520131354764790783378955694765545052463852983584950158520324608972111594521964620728995) }, 
      { SC_(2156.25830078125), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(21093.89996888117841651158188116938988084034330950933875421409854977928918047338879291028201828842734), SC_(20372.91190578621449750288600409842112056662341962675643131107894130939082712218349910553402011055402), SC_(212.5692259399876803167305714449903246376385420553017540476290708446939378337069811685794096939280976), SC_(236.7451271530506905235640335894616690075729738333352594130854955246190872325682834017613145786244124) }, 
      { SC_(2184.67041015625), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(317.0855348780022904563401479433632386132025010041499940239868323514802225050198440869566883131576844), SC_(369.4469945814056476954950483680338432913071164079010809921040172300776423727177809662786587314903685), SC_(14354.6068023458093745646943390123248391746471007856008115498303536345243192703624114226579174696277), SC_(13511.36142449849499129927761807839548108318022646624746781366390775295458958413114304267617654457991) }, 
      { SC_(2215.301025390625), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(22895.7020627922112562861224848447750401262012685645771014549501342248604792483306191140001739639334), SC_(23825.76687931359948701203051252604519115928795271964998065986908341174371152572870487205084524377908), SC_(224.113453369522194812703586103227472878156344286251876506176321313818364973939950976877700699083709), SC_(196.9582594579764818725310529785198001529204989351435519131187218203989613585054713719176013205394199) }, 
      { SC_(2278.39892578125), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(330.3093363169321981561227811660905141121626754291594116478286845144344852818934523384949060911619389), SC_(385.6753493259975451336828889106468460369714404446190331885792569790400076098529044456729502219973835), SC_(14976.7561566632634308638620176265216695794332082225963846453656325736207354993225242467259186259035), SC_(14085.12555433669264594918118666381200191191561855656826967564790609726758926225746280891862347289148) }, 
      { SC_(2300.5830078125), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(1012.297100527306716285743550880069207040463867221952404918278996140379913534218848817783159265080053), SC_(1038.332822224316501680214815942731567646231196889643666942025391144688101970435057100955980982698429), SC_(5206.576372676284830007433345628836078495967919041068613464368699130566434606094363189746144110242431), SC_(5119.03996731367514477174757293709359677327382099960040836173567439890047080236720277990149844432214) }, 
      { SC_(2301.3115234375), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(323.8534510025471106497096732332831742236159827834071625750989691634056811313844760139812525252802504), SC_(400.0279308254527683442625208614184979813812602577568202012944261759244882737640163317685855874907153), SC_(15294.16267189381777616609292064877133499758688034132854584981201879775909695058139778927067716696143), SC_(14067.36185574406330131750042633987603678465564140426920223337041655944570907627837646643210303471958) }, 
      { SC_(2329.3564453125), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(1081.103887309762769386858877705003012042670398266287862660675257543978214538994065096364443796272835), SC_(995.8591220124759793541846652440699188465640393175150678364559657417976694725346288027457202053993425), SC_(5085.081749479358502862481057881606481136995440639167551127230590786626698258113386774119000815697952), SC_(5371.691349135836687332420883386269734813410383379892343139563435665993896082129624214132546240033442) }, 
      { SC_(2377.849609375), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(24346.00580533710281740164748165583772438088403429184287288645150104594026638706215090611918108859287), SC_(25811.45522789718636331315913947191511170897645059951749442402520940820145702817116685586176127773763), SC_(247.5514599848224159955932850275540018909187363672441373890346215470110176262085818773271263546286169), SC_(204.7666354391795897067750658638523605120161878553199948335508239623282292045113240047126090889911353) }, 
      { SC_(2547.084716796875), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(77112.40032345642789410119758670079899542544747247365036064094958804090803134667563824217177964414615), SC_(81458.87384838597199528395341595235259116905082836131452429706435654503889100148419460880290409288463), SC_(94.99559083939884639438943964758777822703572065161201781421334411537462428927732256785286482539786063), SC_(69.97984168684320558559239638240707936679492143940367552959801702879133635374269666878795460095361317) }, 
      { SC_(2578.910888671875), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(398.7821747037804567182529813053597771522900399530220030082157837346000623302685901714115366568237648), SC_(353.1463505714364636023496757518115822843104349675768115650781087411334235263313422079065045541515348), SC_(17305.78085880500912954307359993248817208804885642615777085587722174304373820028791750484217514534844), SC_(18127.51463880514671477993287305459984566367206209886591091976012321283577213033209720148720248411397) }, 
      { SC_(2630.47705078125), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(736.5415759091229693359482883178104457667955546670780643047018720078727753429502033408005566819289677), SC_(757.4834155928172852992203733164491630951313685079707686989621954505457653814999911252929603392873856), SC_(9334.649684833673818522272987995615912087116994516295211938225615312617907409926501537897336018475737), SC_(9196.190412992344286031416903687015959737257998729830833434728827598898098801000004787687743544258539) }, 
      { SC_(2663.05029296875), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(12951.27857835106074430395457674031972064319978760129499971208513930820803655385852942906191096199162), SC_(14017.10467995264752180750216793567681216169663496957538441616008818674389845110530493073845945233714), SC_(574.0047265190206833276944674750788548774510124385325967565847376452678674116092263748566730385637647), SC_(480.4184965537028701741496247414199149110188202259944103730020684272396354909598434543329774643861339) }, 
      { SC_(2691.542724609375), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(416.5349357601709247450444236882137352537031132537401712745582280283529075761162910013623435741570764), SC_(368.2242670914994517922879230367381662576074379825182805950706801491808152344522992118002211114223669), SC_(18055.63457958616423676215550494079126606577640928770494346315546606120652532901561699164672795763294), SC_(18925.53113942826556277160519611531027515394324858004300896656487180698279638448970097319245078156746) }, 
      { SC_(2693.811767578125), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(4720.686264562995907699326934413627665184054906884118530030120468465122750196814815242686141593580684), SC_(4548.138294053761031294353409181548364393815949760088856724418860431056762065647910922659336394035828), SC_(1527.996669636697964339342434489555204367762592045848604275602144980633643225787955847374212069540215), SC_(1604.466713457626912613430534229819716118571671510989763158396731016189675078566092108053038362833346) }, 
      { SC_(2760.340576171875), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(12336.18536593846975649823219930178435851703880253544227417507381657911372985841379837860123018638965), SC_(11942.79067939964307164819525377058315446521038652052686778175749482940254626394011379419558283929346), SC_(606.7265531659415595281054726093236175086846302089655296967083498712439722973629284056307556162212444), SC_(649.3788932623859260984260027275065674963909800157577955813759353310805326694996981060328185774451608) }, 
      { SC_(2795.807373046875), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(88859.97170004038285534582609522655488079883583344358853734887471886648169145080171561670440208821863), SC_(85180.34851931669382430340367676805151961053937900501103254758951717609348571408452169275275289820399), SC_(79.77416085411405739066968594179471220322427130133072339803192488428703133288089870427848763738794578), SC_(100.9551592374177221903206172156992203170780017402001112451595288776430698946245322161879812147221076) }, 
      { SC_(2829.697509765625), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(12192.6140703942231784167097041691793727534349062374595044291190274202478592276618938412768572519238), SC_(12697.58028624137573263264289487727258108186975509770005834957913474559334744673410385237390985021871), SC_(671.2845928867268565245933580850459473282799537226101261565427507093861736415738877630866730109435594), SC_(616.5358088306068174219300403352158696551842831950857541518065108158320293990995721200903259223649671) }, 
      { SC_(2835.7451171875), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(5005.807502837797939987040770585195884503841621539816173436913215808506936332431768797921549897800399), SC_(4752.276817905799078368394742051379301470825092759586604423117320920914741146981659969203839331143166), SC_(1592.779525463234202402688950856942300328458013489378130339268088929632987720032668836638716692895865), SC_(1705.13936548282982185200142219879908015234901018097458667747721751610682523654263200207522747516752) }, 
      { SC_(2883.697021484375), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(398.9155588508555198812059964470485956749777166368291607253855213117565878069402993313946710683643522), SC_(441.6372547562010593011384265067682838539616817776291923923095073419606746941569099315675356833076503), SC_(20194.33253111993539506429959784496596672339172513763501988205945661919546484118093688558874235662173), SC_(19425.08571573793236299728741506211673519126187088776421549507489295847926781824108933679748256855208) }, 
      { SC_(2898.87353515625), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(28474.99125550603017031478937559673803720612164426238858361922452474675331452064095530452676375324054), SC_(27277.77960012643484427690528243495559996317597689358411412133125464063540708059358265557145000144428), SC_(281.937841209606823774468124127753699918567678653923926065466477059541573349758647303814089745092726), SC_(322.0827410580158991338761623459570631845036302995265325173166524501770034914588483094392848102645349) }, 
      { SC_(2933.500732421875), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(13032.63527477788347524237290787787375875548213590162760467269042628091117199072913196037927326576124), SC_(12768.30816513223669333687338228910197154932694472567845671248782589177562409333509100645230387396191), SC_(653.0144294126801281868524046287907549743330370864338589473924509755329150007061371073748963499362277), SC_(681.6733439485398777987129207666541176796108749020948238661730633523235849658383334476926492510569853) }, 
      { SC_(2962.476806640625), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(27766.44318321441906320933480150171594409202488289733881325297026661055543533480083957074880521020287), SC_(29213.02898818093720787777179681513317739803388581279856528885779209983606189564069974199579494772038), SC_(332.9822527064490053871363197512536686954724745778561170967378439831980478469699738484864165087485209), SC_(284.4762292406444127594186605544730418450246183901626857694724936541582747641192127907352615975518456) }, 
      { SC_(3040.435546875), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(95497.12235066088857300395644467523627547514888925997449660293877627875224715531696770910223820708586), SC_(93750.69657043990476643040436600600559064993676594082672425301369815882728473773358606680663589170241), SC_(93.02660504715751094225505405082108140491690427053511133331253396709855100310294953925251302080454643), SC_(103.0812709605640751212429171902146022212077077370061432507698235133165137311364714948295625901596267) }, 
      { SC_(3064.19140625), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(840.3917162999570696351166831935200889379505268428070146967590088599188294896626902277910307856719428), SC_(900.239622180410458724659461109015245500305792593525279015801354863257555020060135211536678115402996), SC_(10991.98865092433797140234230771111482149326337082741759666260236062258012639567232083981645616495512), SC_(10596.2960167699992587039285783001832184224091403817646040506133825064334347671383946673386365706328) }, 
      { SC_(3072.20849609375), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(15901.20212130464605548509345591754107121408003920018671989293918191750395303846028900770408732764017), SC_(15201.04476836399283987279797869037796193137432747667064520666091459632414149923382304023043835630544), SC_(576.8016099928482434015923794574792676057307250217350204020320224686346603276643862075150086932035671), SC_(638.2833479056123752217683132590462117693782719447600091356476096948062264838807672757652907463036956) }, 
      { SC_(3108.171142578125), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(5124.523443419883586922336843525470786723621155157916068606324714796386249405109898940309672012048917), SC_(5574.233015020495193381201339364284913636617279746644407399791757018811216235619060130950457241622008), SC_(1907.784235887149222730130639007528194462984436378834955972415168440475769840624399990773170095060619), SC_(1708.483276005997693498631806198228543992087035029022674603846496923186234601066182704988655931861384) }, 
      { SC_(3108.571044921875), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(13578.31886970092281219476168254326036125422292893640969976098935604926296097866349676995072542567875), SC_(13762.05666321979661906717366278841474570547550747325209080280501363722190875045901574212009667591983), SC_(717.0793180192847766386947262123911265393244041527617453755697300157705212439060246384848785208558591), SC_(697.1579854064259190912257553911239468120329786466596941260451547688157279690986636881663369099421847) }, 
      { SC_(3115.6826171875), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(467.7792809092810002842071337674623360103684805918406236739107287920003904026855039863973122855659549), SC_(510.3548450370784789968739515208412749339102806388434642036552591786579897093203673914085291239930861), SC_(20210.37059804908186355029886532967756834169998749957780501161875997529235767724717382969309681612137), SC_(19524.76261577142309001384044745293230501233538127031523847036532628175963856171907569956816928694329) }, 
      { SC_(3123.457275390625), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(925.7420188905863974601328603986732891817340322556946164393312437145253625380252879901881194483754819), SC_(848.7987819590366047136353853152014431269029820856314633980589988654129125158454723710850245193063488), SC_(10749.21861621273317687909589030056899097278302504650225347742543214012239204637306922215470296842614), SC_(11257.94207210566111160783769976104758657959862844324343937840190499797305647724849411780472117391177) }, 
      { SC_(3125.335693359375), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(1427.434047215684814949043472836788539764045834233226778897383849264081722420154490398841703288450775), SC_(1358.482879778817395345098240542607440697615601652786359633511159125587992168443430449973801464816583), SC_(6898.294995253303845503437370396124143235358013489988412680384289860243673608114862155286873271634382), SC_(7130.119822855911091540576828924772956348567704028619652998339791643994914926988285141796147759253452) }, 
      { SC_(3394.0947265625), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(486.3513072100110654196406497424250542970213039181852196533871853410749040960767618959475036277875278), SC_(502.4421044695454226447389582970190348391980745284630905760725969730109944494841426600785030145132569), SC_(23458.65697440542895547965320245519786601554871209590846551828252000642927993753796389053116400566587), SC_(23168.93571071351589171187846361203241009962833598469530508971232042540966271611471478056004271962619) }, 
      { SC_(3408.681884765625), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(104294.2381631042834383156027524668959668440830671043692261716340857490033616797560743118194333208905), SC_(107891.0908766782543744381872962409375233295600333359133866106654342551585917791534738444705552587973), SC_(120.3628809822731259342810525243768950299429774740513831666435294303429077235289153071425505018670674), SC_(99.65588189480128769403311589950289776386348405129120626958208228613055099927388209934763375550382995) }, 
      { SC_(3443.83447265625), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(1471.134976374060359606351751795741502589045487876209308074202957884979488201950379290899949891929506), SC_(1599.412413217180274564260992152815670428437526794922769204283072723165192618105909384967669787554093), SC_(7945.805427369155482204204744902926473460410311429017703288511318901427908867638449841859426571476539), SC_(7514.513750545199233241251691121139200779745671353180403093349535963110400248744927671295546824332682) }, 
      { SC_(3454.9765625), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(32690.62462673566027943521478305762700414466786486291460075294314144288042650718500173830637005417623), SC_(33754.20953191077076485449072955759266927029019747389688481931591736586193529353266858135835444702825), SC_(377.5924436560152478524206451414965046380416365849343046743092994940682528436366564594424052907914847), SC_(341.9270374467629768847714188086251371616944391369732643023640985269746387026405167725178007442060052) }, 
      { SC_(3524.479736328125), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(1040.528617740045531981643363952666578960157673340359222339764012502716631544870200347444714404612819), SC_(961.6512664615008181643001348018417537078578399860042005732102706443662195971763220237926226254375236), SC_(12155.34645323483563531419504857640819712677629677742624185765582278967918040757714680374079342649746), SC_(12676.85481302594916147439799059684765225094977371149289142847227318119338703964371187329129926722719) }, 
      { SC_(3533.453125), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(567.1420217370540532728094947365485319512100999027333644509719721334283497584994799766888219557476808), SC_(541.7827596092501995011977456012118510279559972712754779498808733814010390984677495283028737631155622), SC_(22326.08665262487227381866574858167657775353192232625421181516312628985892524642264672465911575344943), SC_(22734.4468265125877956584626142631176904557178612493713985267399289809753873374288150912675530333736) }, 
      { SC_(3538.008056640625), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(470.7893569248683810683283073800024803399349932831827653374337557755617459009014306128464016161492464), SC_(561.3508966130831583355575274308616771262527113625594577277720970731675067339949081619464187215958633), SC_(25126.01702814302565762205568285627297951981181132739006401886062081139478773685158184353110750476763), SC_(23495.29472981044843248082723610512899462964330374840585370286223395180121351417611445794903952172573) }, 
      { SC_(3550.83642578125), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(17859.88977164279366128002228702638528636283002177003001554127094231455598055550596817981149785681812), SC_(18083.1364485607118300057279491941203376228922354672034575844589805485665904128659846515075691488453), SC_(711.6307160752809156686439325440165380056894177654574189445556838970559565314310863656918477694114672), SC_(692.0265848379957916202035753593691916585508387383523031496958862124397587246669756924929483975891123) }, 
      { SC_(3554.123046875), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(577.2888621899850162541987754154628928239639501061335632913702496067591540211577018689724819498740238), SC_(538.2676951767989907921220347627573780162921683155764874998817722206409135428196725474717154830029636), SC_(22348.66837895792819198574419777237466727297934894965173204074812586917255226976952832072969190199003), SC_(22977.03060049387543045010712867669621071000865470703251818224839972212547369335901376419602562637665) }, 
      { SC_(3617.78271484375), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(1055.316500776711420492883783407991447378021393231771359654998014770703759503117277264900913870607265), SC_(999.5130730402271361854430643098935414652314485275539252930754752366279557545499588403278487384297889), SC_(12559.46263278724829574952845682425395725578573217445827443649863228418181709985585833194772917211184), SC_(12928.41192120285109354431411872383704559780757972961694327962908566899948268399713197732102573041699) }, 
      { SC_(3671.330810546875), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(38486.34036561348154337883616958585515577838467628391415942353397516923181127408778283596477118027461), SC_(38938.54151532175652641667403554097149057612414954910381919925571088683906119102044951930455959316067), SC_(355.0757254040590212407553928629750323619962305415193842805449587519271266704742497351099184694221307), SC_(341.8715501171483852124281168183388699212990186957760996821444319645541583106604510273968682848165652) }, 
      { SC_(3687.232666015625), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(35245.95959019947754660117212891885673461545130053172235085514924017694044953943516530738718510307152), SC_(35660.92405761113949947966983760780157053717773045399615981123319844457179259331190482206727773341085), SC_(390.7324681263452413618751402019992896730581684480968081616905063182600054985063840135908620928651867), SC_(376.8169816648394888820677773282606040373105224747952769793200780184940110426796816670954960385694568) }, 
      { SC_(3701.328369140625), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(116675.4985654682379568023690078299574253490384023697373659051628866370053269332595325814972171541324), SC_(113719.0809665258278662739098460057142003408508636004179990878411139221112476172367868776373540115931), SC_(110.8376553266589551615729901506388872483458560825132528554970018754162735871713483224525207135371132), SC_(127.8588624190566771064551924704664623495371757032506442715883216861375038583817343913210414119329308) }, 
      { SC_(3704.4892578125), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(36324.5884854703078715857955642606729169804749353204997472155975128465373624979640009411249288535912), SC_(34922.1672457882447906872392610054454603244746489346066766850572217274325538217030698642066004629152), SC_(362.2945303555000527507069519908386054799049642473899066573217381150677209803024347257666013152891042), SC_(409.3217475060679417908875547825552458590574822406236860087477007826429631431352832244058329730771046) }, 
      { SC_(3725.08544921875), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(1596.128116009816580933771843485511513749051883336084047853776855011664551335540224637205261081668959), SC_(1724.980394931751343656736059254946050478696653728227537319710981452285951368878678178562648265253685), SC_(8577.859028083824611963944562471368432310608212950993024453657322253636731391678502233486659657295688), SC_(8144.635634124177865451253864526094457632965249621894331850025085860140289796529005206642903515316198) }, 
      { SC_(3731.865966796875), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(1619.380438553609204745746743692823943241501512883487941669355391132068631253597908381986368876690399), SC_(1707.185475270520436049813762021486700483560135388533103227751638637100408450496536501813241467654567), SC_(8523.222615594906809246026178056249320611084827840535230898825839347464891864443947049877187756760203), SC_(8228.00852311530211841289085331673616162245227235542797778847280291349274638348039732268508995315419) }, 
      { SC_(3780.56201171875), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(35748.51751538208303407763227965357083411010376745539901241868065019142246244654274693348474315410464), SC_(36958.87989233572022934115263729018154526910185727724434462456708791768741204340084292391698034704998), SC_(413.9423130978068912641788302622277627316690160978248395885023931987713772946140923754426907894773154), SC_(373.3548377176385781580195040093271383107220959649477042758295806239296750187117956849330799736742633) }, 
      { SC_(3783.79736328125), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(517.2950608437267295862186447900332232310683225598674463389095680299206065384736651691491685523745017), SC_(585.7075698320949727907423758652126859529444217848514357778031122744278011124099277135977527011899013), SC_(26611.0212782695323708137093896124630960951155497717899784989800723823249123382075476895219764134891), SC_(25379.18604498029331330144854861743950033308224740982723759583749916783644585345269772269450252958977) }, 
      { SC_(3792.58740234375), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(6591.128003457674785039028718343512882142704242680304745925482055957693868366686877737934010311728157), SC_(6457.682822888634305625261886104928985376465664602028881653504583004078959332451273344503319196847181), SC_(2175.243549470730468169184888528086973393535383455401734148923154840478636256808683161320984013365293), SC_(2234.384230022114987704180026912677050571521012973610074065118738421565384709912519750590120566041921) }, 
      { SC_(3799.551513671875), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(626.3581615561903982332854508757282555551739592598592131520533985404268691715888547769618003496649305), SC_(566.4868865613071606100793572064124254151046944541145943485462822345281117351522205096949614148487984), SC_(23747.4183181848367193890498061860447345610325872862731141954761865206504813433460496670950697027453), SC_(24711.54245716296738127343450568866735819621025937194455238632153563030689219404357536464538588704505) }, 
      { SC_(3847.523193359375), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(117179.7643742660319631897893015759799513350972554159096580517762016456355709892376007204024781277128), SC_(122339.2522881899764090905886800191168969965409812988148500612196649305865258406370989389919787007711), SC_(139.0985657761886544820520132834950359760837685621612587894425764988707901979909535629414299642095902), SC_(109.3968271900495611689921513946180158235425902367218298839989885700871296768602940917074493987800168) }, 
      { SC_(3873.435791015625), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(1049.153290779399775473643622471935308621524866763161344930765694393508944308535790377217910767421777), SC_(1151.487396364904972576613411090428062728209579036335838927382242781272274649542495874093394921575647), SC_(13984.49391745635445079123109276753165786129331416576508739374170115610900121490390296154615550000091), SC_(13307.8959057568197153741546838092876067765025165161793786687469813561628792905858735409004270205172) }, 
      { SC_(3897.815673828125), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(1057.635678289890236370688560025288936049150529009310666293441530515324781753094624541450152923421224), SC_(1156.781860734214828108580865863484445170104757911845339330790165224436474885188562137241272406117424), SC_(14059.66805891109961994147000770126941000746325052088125050486393759894659847450327116054019901663459), SC_(13404.14843492921641133674085711218787826073676186776753765554577847859729782597028758279000339469037) }, 
      { SC_(3899.623779296875), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(19284.9556146596597041664657759291090651918419149642212220181308516691346596197331184157305268574004), SC_(20194.85442592516839847783106368289840817566404686281388477017589106918846225964450766737448980091817), SC_(811.0638678400973907420038288321430390658261018350949045263122522590758367431078767906814437072719702), SC_(731.1639099035747503252329195750147869995039527931765905957167404397504604695150567828505526549366348) }, 
      { SC_(3994.020751953125), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(548.1348168205265672106061742773811076754607241000101431961460371021076233126395175479630142181866871), SC_(616.0197009585751482564788531717984528469681184148996933852821416385909355336641618074246866871523364), SC_(28050.07391481178782764873591685125806242743170478662543410246009134269721563197931096160600466213568), SC_(26827.74770371970395314731888911706957882376520210493174459976680865166983961526991055397580426007734) }, 
      { SC_(3994.4365234375), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(1805.509306560469768728344213701524858944126718612004385405827674704054631304370874261709404256528734), SC_(1754.701664163835064099285236572450196253325089580727137545790375093280455816039983662440064844649044), SC_(8878.978166452342529126429041088080824010868057625304663194878380108169500394022484243863110194219254), SC_(9049.800676983262530946299567793152952881284643314939629074820047639487574450497043229345401204540519) }, 
      { SC_(4025.12646484375), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(20548.39861337284453407887355524345514599178945423057366661339379140903847654375993951170224959618488), SC_(20196.39739066332879974801256339508147540503742769107654074459112572750247869559983883202286049506747), SC_(780.1100086953790788332083601157626867329489004218554405344868255935055645683308703731749410100255388), SC_(811.0206263935392715961519254946080508566851898793621448087802955847171107967000798122804140289692535) }, 
      { SC_(4105.81494140625), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(611.1376839762589380156240717394528043530475483492573023049059231285328959306733738356977125025353828), SC_(584.928459493257936570339799540139002584618215124108022681798371890897249612469795388319854163073643), SC_(27967.28632381957970983965345852551206717772698455216508483548200202242779536807913407960064404290943), SC_(28439.19101335974411077099367119712969975108397314449505081169457951881553087371528492529387682797113) }, 
      { SC_(4115.20849609375), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(7238.436014348527728690689591975510215507536509472122633119039083565980878341243021553391480627093991), SC_(6921.95062465115233070830484576092663970812726014417726765794399639667088726561624921400934600830195), SC_(2322.597447968572967827613327519553806585659549546053841572218848280179773471988000429251114656933562), SC_(2462.858144032493441774340528824858247424702639021223457795031918462454413151796870762543612077697068) }, 
      { SC_(4122.0791015625), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(130615.2618960837098676362999128085950224825335337889675339296819625267872096704399962801812318762953), SC_(125985.393450960210576575174259083205967520434528827653206555808057585055438306650166444004056158834), SC_(119.6653057335890988199371065462335558582725789402235513367132624850418756921738153852844822730649573), SC_(146.3200609628370262774357052990418319636252605289653389654945178372665254857480868771805479462789068) }, 
      { SC_(4160.4072265625), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(42939.74039416990204733955679980583612886369079041472152103477488602271698069599292229570940474144093), SC_(44811.93162084253259874748771393025162117202620212300496586514148717534457835099737951467246722739903), SC_(422.5053989034261616523687823448606250046495208383606440250830047414795176323405399867291497087677334), SC_(367.8401705111568846969880012774115395896906947231268149747057464325516852776295724622620369407351186) }, 
      { SC_(4279.9248046875), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(1177.003701411724031928643035642102028143454719227840869738769843578108977701658807829124854440945531), SC_(1253.953137356027552100698083630968705042176670986473720680972758101950995480094768046783197535548306), SC_(15331.25580220269089474174538365248755653503220750001102041774100418337007008454584819123335656397892), SC_(14822.49832257971428733248291587210481590371055397298641903533418490866035657389758248806150354494282) }, 
      { SC_(4377.56884765625), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(45451.79991602598577620629492239849816403320166787782488631990429599232608226093715137996541294838298), SC_(46874.18021025042409970195903596027790532349008360222265620889683337608403564757015540939587893389346), SC_(436.3774751061069579052143713087591829646375377065546844133450923321894736000692320185439069917872725), SC_(394.8448252090620394600807316787647076551875318680628059403508009603960360847132646729182893816608804) }, 
      { SC_(4501.486328125), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(19353.72267371161712724758273129503161688018886611399194997356077863438124900705435409241548379950984), SC_(20244.09412004358315313049857677874062148281412929526359097085531310874529932207447008466482787632029), SC_(1072.532441666411919597908283810337722866768246734322368248341963544101768250716329254089323582390704), SC_(975.9968775588556510460239980772617805219263617688692762593600669471426444036916859278360131412268257) }, 
      { SC_(4617.8994140625), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(43133.86563439555660896800494162340004560140758019923468291657990203995231556354343362283634199235651), SC_(45694.01918705688739309366936051892728156387223239492200805819623254633896829993155583847417774799562), SC_(524.1593659363923016125825894323536225251052816884700112786088811222609254504971758246461167896411048), SC_(438.313125518836992212244267977177904455244655199778888360512445362550362641287464466472800334432326) }, 
      { SC_(4673.10595703125), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(49654.71187793647676835505017350987372396477722562385100495629752213190276183425908804795790802984954), SC_(48899.16835166006538905026806898127923167425927112811617458398625144174467495371619097655070561461531), SC_(432.4672361447782733301830010010152212610965728882546193756522847452673074274997850501568842962242562), SC_(454.5292196435087442194571851204533925789504567647107869224710289657292836878329486124050748040222451) }, 
      { SC_(4740.85693359375), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(50830.96118306032964341131063579476729561975311176162642744531957888207700399058537456206628736272282), SC_(49158.89495727885771500695373963230065415530366932147103287808049672673050946374112595470618096690048), SC_(425.701757659897624976504849800962478293760613541218580389772557163825501248586635847497625617348295), SC_(474.5250621098279520427799486174726222222231168844975158114875508798554012661003104249233501987196276) }, 
      { SC_(4774.490234375), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(24460.04983246749566552424597092125106517403103886011932455512766696049882641571246197198713148426293), SC_(23871.85555236169930486859155100357809948207649120966168297150063097777054192244586026842645824508876), SC_(917.8693695746874588592339606088059552796204276385664247663713421868018768244212488458694261792936648), SC_(969.5210821099651807777912505742770645308917490681493055448393893289074327753351321727240397129332722) }, 
      { SC_(4830.77587890625), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(24076.46687662299964757490203978797019320418615871028717099948249970994514207074156420892331847811987), SC_(24826.55066694999042427632052160605174770735404266584940293204498669307714377810377293633362789243444), SC_(987.8327122675237180177598883052250742826614288200016574158362140703840975750605171645040849748476376), SC_(921.9650895186372218318899239705403103261700810862330249962773488380138715679403246771909334294077389) }, 
      { SC_(4874.59765625), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(2236.513200095954724571758998073419864698701490915767515125324274128068622216234166832142682097783827), SC_(2108.724032745424936662269357905554783819540344963952333535246116621368826670862176067438822901947478), SC_(10725.84126177431473132144924388731300048245391375048141046025978206516003580843616788950184907461091), SC_(11155.48755407666234924088410820412889448408214066657950652719097251129441168872646028543923061445426) }, 
      { SC_(4879.3486328125), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(25123.61850809423258770583310759051185679893893844806983609173407745019818152736552912419140308361677), SC_(24272.07484677989906703834958880502415234165816083022552071282370866380443331756986413381319771460055), SC_(927.167785124727006224532321105570357746941522089646642687167194333342224572921878066737371582020735), SC_(1001.944765627370547703968047236791630023122557107036406172184132076463216504973977428814822615486715) }, 
      { SC_(4899.017578125), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(688.0262109883990873496278990354407399319562764165705666858739602839382980583458774589398054870515937), SC_(739.2143359917528749336721174702127029734500396065007311700792267259246889257168676971142983671081382), SC_(34114.26609907617757023606563472974608211000565213623927927041995983458918489211392593495473960362763), SC_(33192.60722642155533639060907071105723096421355515909831910882650086142828793028445544485103692162167) }, 
      { SC_(4937.810546875), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(149569.6734316671685382839624019062207950068379777018179856855774050861951838184453066762175322014601), SC_(157854.9288664658972066983425931870500521762009857332079081347997211276640455917021527088223717812945), SC_(183.4343964890392210873115327971468024747680266258967172920739333113091618042779834096396757353620414), SC_(135.7413149593243264610018230549835721860577818947780473688424757841595851994009547106297407173928447) }, 
      { SC_(4978.021484375), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(1434.805576831681872452836742678239146190096210422112715547292555222890340110428849969568262305384355), SC_(1392.139908415175775957307276808206939545749318805954573246638355498619133495160220858780290976673759), SC_(17394.01075359417170652277120025637470951877966379945091844919246487987684333028695817472219714629556), SC_(17676.09581614330822864954072979806587098482897253976723791920703972967019748623879020046757872346336) }, 
      { SC_(10046.0419921875), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(1494.292352586634304941583404504613290889728157025276845524145442563137640794021004281337942735925888), SC_(1431.389049873478982013802026654409672314190046158357071155786584300523865686252416751725877318008587), SC_(68443.72182098357578397110141346311072724811203318596677034853345661249508916126083888932441832878295), SC_(69576.2867717511622976438372554257219762698791823158257174961530417172745788822623162553931066366201) }, 
      { SC_(10120.048828125), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(1419.826288757160867166597782956809997622614224890344430533852949941290015000887364073662196283263872), SC_(1527.892345728858408258654830982694696718266930636111982725884451702228609829366760516488232067079004), SC_(70494.05381489395439178977988125289404935975894418648376405566253427011326629649796155192766409849381), SC_(68548.32205061363518064614600565208488234709287936147818638572047446573504289488581163673186045061556) }, 
      { SC_(10332.970703125), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(52581.7228910022511056348313181218445765554714383960374366477447593154152110901231890867244792806336), SC_(52017.72247789648702231900532061843219751736818356087704391539819797287153988062406069200029712526942), SC_(2017.034703810037533650560661649260329378397951712861354169140992499675177133211875329868437555119822), SC_(2066.562791574679717039193616201427291164270075272701388135904110417459603284490539932849952380919705) }, 
      { SC_(10447.703125), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(326788.3878574515940063031175567968708852593448623607447712370951361733517698665420760798064495835743), SC_(323550.8740075619464751478473537640147113853026960332979094582656208163084428802327715272557797640873), SC_(326.722550112099030652288237953751760511719927700637124875226877714628972701147545875981861005314904), SC_(345.3659003635556880858422531752683088776284134319765086814689231551164959057981848189496413085073596) }, 
      { SC_(10595.6689453125), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(18339.40319258272686535691833933449237514660113205861116729168815000742777096825596470058838603169034), SC_(18116.34737201608225117923522133441891030865963201522677980937188263850788134745770623112636619302065), SC_(6109.933080363848563780428214773126754319644057473669315901095982036797452088099920931192400729106733), SC_(6208.788160604477690353261524716771414133526713936566883123179201493366502669049888384892949305488414) }, 
      { SC_(11038.3544921875), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(55107.33810844249078971178082138239056812188272045335334453835675328880823146666225646756382507540298), SC_(56638.23018900094786813471344295850434515631945667148235044782610852931975491141027271146649062619356), SC_(2248.722274929615376093568789974370234312592293212432798699136194046171878360394989021009281316622639), SC_(2114.286865009130019564786476501404560107266425180811459271007432364767535961933183284840296979485885) }, 
      { SC_(11430.5087890625), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(1731.2377483782604039147592677389050078168265007204530215662964480189490590222260971118320194367279), SC_(1855.268104533124512633314372252914321013209202973774761237771017527141400746597979057062516706557016), SC_(73889.06496726901219736525422793929843490487131305813046756272832698849627473834248488681378098405066), SC_(71891.84982323727201427419210809464141905496634682526306998642341787105055057058582392075853188896575) }, 
      { SC_(12749.54296875), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(132811.9148157434074170854795972345346011292727857654121047219965087062987465727841341894393980805942), SC_(136089.3938163978649395027422317817244732297392431752605475057971562104498458311191054606874352093025), SC_(1257.526115877530435475789021286890488612526208921978966454039529312879441966119426248230578163485371), SC_(1161.820829227161231014760042100616578216350795800294826956687964585629822058071741601556976924608078) }, 
      { SC_(12770.5009765625), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(394270.924352706367795337795315668515250333763427650841185039313472899201763105561445480112334076579), SC_(400670.684017550468096661290376304531429654250140740437211078807535462951525002285241697280958050824), SC_(429.1984194187851625129130468429111054838489999802700678251799353946647710905321109089452580387274398), SC_(392.3452164236406230463508607562054959767197369797638280199591075243961053368820397885836222013011632) }, 
      { SC_(13448.689453125), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(22670.63030135889001750335444714824625299374628795299072352385515979683082163701868435633646681174309), SC_(23606.10471596922800005827688625402540138028615936333047683786904904684260976433311084016751515006894), SC_(8026.242287298425709638186415102644005289655554545504219543539775236332828089726342274954139649685972), SC_(7611.654677191720715602642165219837200287113295416251360748278700101627694012973976498740109514313899) }, 
      { SC_(13644.5390625), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(23129.95333194877490668738311635035985053060275864398539163867821558444861511930084752979453079469782), SC_(23818.22921849752671511304900574499638332879662171848998817328889810058400193733691902105322243467175), SC_(8084.725790586895776194819373809813811781703559204864040882316239734432990581942579445566338253730034), SC_(7779.692234867518923316356056699266965110066596099221321908888589377536963150147838426518809218114878) }, 
      { SC_(14443.1748046875), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(137796.0922684243240711890240363287316848119280625892326623230837625988488632355652040662478495663364), SC_(139970.782721626646643286514791822228514557433768899838600415112870738837600064126878825240202035135), SC_(1538.940284705955545449786028593198703080713460952768701780059977701934095563227161147304094322257209), SC_(1466.010522465509760773739365370837759726045304118743923504236857073013733348418073630136610279737928) }, 
      { SC_(14775.849609375), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(141664.7156289821921088737006904193578433733474553677694014964667542910381216533605473710606713407568), SC_(142495.4339771319055401056188131494732410623491386141454954568470097657543462833563563980885916281753), SC_(1550.862872576647243139640104085034305713593086259208539426272591132869515025441460132188259744316638), SC_(1523.003981558589828946816040017848515598353780675616748127680908438196386036359184510273715870176228) }, 
      { SC_(14970.90625), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(142335.132983349074511862225721484940160868091464591397059774897397614447747984257291485360014539505), SC_(145587.1891565135233257444591873495183648796021280407587560359080151011792410999216953166396310225865), SC_(1612.073242311793752942663874363053367752887790387518968742263389235734143261339219020956133519753655), SC_(1503.013995966044253407524418314501442394897457034969151545173926684955594875393077969151355829277112) }, 
      { SC_(16108.84765625), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(4498.844806761642063819307907597779035830748079832192452404564574910732910640939236656961820743492948), SC_(4648.138170715701559982689626168198333230652285578055287554008387180033526050840523876147276985694075), SC_(57238.91482581621456814820965706587476576635873609095764450263754101765079310111485420715992986094236), SC_(56251.86814824867944418019773187520868252942157846377646336630046328524516001831289894518433990325669) }, 
      { SC_(17034.9765625), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(4926.345766064106783485243756996049194218006312224697991547113348065606960051895017467132506043433831), SC_(4746.642614936294865975511282653067571302546129688185947630536217657041774661462462239407733229910937), SC_(59414.19023496309376812952790633519245583444093002670850029369632948351012384042317384978461210612199), SC_(60602.29038927773506939889750748022002064711156249881300876600784716592875337154701475152114507349336) }, 
      { SC_(17546.48046875), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(30088.47297045603260725097965720013399645144392934691468309929255996776564122526018690837552281955441), SC_(30282.30068870999502543855780119334334659249850902381754767481070987224564908740645013563070104713563), SC_(10242.68261443224018921388872150731139940893223159351795062496693628649079100096961944274629678015994), SC_(10156.78090616983499743640580812647677149156826601875483371075028426304979356636740292999496751718698) }, 
      { SC_(17669.810546875), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(7955.667371412900512805930467590884788655227063429758251261931461710092864067153251337344258361469098), SC_(7791.708097608452526315737693377456774783204659564062608541542141989640674521728963840024856152116131), SC_(39380.24055858404006376759625531522401149539740072723446685277827921172431345747315363885894762626806), SC_(39931.49041165372085478882244770121102645343886727938110482808303892992193842320892095062912748839097) }, 
      { SC_(18238.22265625), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(189558.4822939888881268410087764627781056701306971113871336250489469538870383584208675071616948021644), SC_(195114.9823343049952880433577334344760361957006182024568270921403277200610882330594323996773996961701), SC_(1811.63397378875311658579768865819224049839506983125602153045664769530101850312575325216941321308559), SC_(1649.37942453676657959930800580637807967895953132711898094592276988760665788414541672926021628597658) }, 
      { SC_(18357.396484375), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(91896.48199948787110301310502187156546688786590802373758870893499996758194067924580665745520090470442), SC_(93940.60757484442349784180140446911557451626631021099399320618073430323095583296715329144714571849502), SC_(3717.301323058413288037663265972636687273005521020841145368158262829136408080769760116037444012759191), SC_(3537.794935331230886629151295630367339346952290207327080212704845230230021438800786657243651807547198) }, 
      { SC_(18604.361328125), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(2866.022647176290995391821598132417794943198341795127722470956226765701447252308091848801077923442214), SC_(2970.071199134840646275696648165193003354127141144496311394719394704674055274846139143701202745757207), SC_(119470.683468804915990587597903743415586279458726612860135222208672677071387209972403742788322935346), SC_(117795.2518052123701120084007937141599419419866066286626764617603416813190142483083741143059033686454) }, 
      { SC_(18625.171875), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(5214.010138940239323688081978992562583452095246676924435583480570832513610445181328736427741947536213), SC_(5361.572020188983690700979417926116239544599578791340592041746066094551027290552138110349700585830616), SC_(66096.9863249108105661468209566804516077809230767744656682555793299622917929490944422486215382474756), SC_(65121.38845647630376344789184908770375990449423811423853775822204100877253644619566244896940530272937) }, 
      { SC_(19449.22265625), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(188102.9565273540024344640528081633094065659405544525112813948870491606770495139362066201857552876709), SC_(185937.4437250577999981349024118326598545144632239576166047615954826782428934216508190447641001227261), SC_(1986.724596848545149281148532633966171131555009409113818364364130005433946165884648674745415380775948), SC_(2059.347113589551386631170355963994166131162010376232233856751110853847286049418225075875041544221752) }, 
      { SC_(19713.984375), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(8674.864634768267780933690072175478440543205215569682150239923688178204669894422720571914523708551392), SC_(8894.423441258421407302074610804910485808967896306392500753220470355222820422927312209607128417469898), SC_(44612.95254131689895463286568574997051293254855196397774140778484158338060265304784263180195587424227), SC_(43874.77064939893227385217737728086350234330703842865645913662758507522386331662529390618614912935738) }, 
      { SC_(19903.40234375), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(3042.932836711340823479819657834625485860428751986658903199484769465186775683394950880451012633789612), SC_(3201.0062646870896803865919808573139354916076610222863865825616672341097263992816072915827584000259), SC_(128191.2692097337612922589348565431324395515535564492033766965129427240669000178259077705803774795109), SC_(125645.9001005432365678010299707974421286458443315117918825839344633159945885466423015426497096808632) }, 
      { SC_(20257.640625), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(626119.6209727537340065379817162492457975646204363772562424305379112143878984165833807489416714623542), SC_(634888.4512803063536593315052390107089476725255474739728344084041266345892286942580527959050112866557), SC_(676.6028869977859794242901043261238686678391393512046128134515678789862940866733565490450010361425001), SC_(626.1057625575726934936117060101380453016551218793915018894939499888439355602758697908094623364986072) }, 
      { SC_(20762.462890625), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(36074.23233717695161918957718667506822176416336858438195330067030951624461692274035492446307369194562), SC_(35363.32760568586822807209080110989879266264229055563681787237731188316998975402094731080141608845559), SC_(11912.03842565585159457370477994491682528769832188889038399391356646196192248415327003598802979315497), SC_(12227.10121892405579938761505859011149968591015977868135785510680850558887998736398798492479319700782) }, 
      { SC_(20906.6796875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(3073.352528738953487510485453080492415099457303974517032277386439109608711400320313794722262333668018), SC_(3014.206053122876637164283887636192130410616606735022160013436275139537310293158373743079919451047349), SC_(143083.0272051111602529776599070949916507917137323448460674645334446072189537734163383308351105257222), SC_(144147.9377468576235522222109663825220732460683601636705493775674067426409598382978099356091230567707) }, 
      { SC_(21347.755859375), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(9641.74562819818521372933791645227225668727127844833141374962531610337683855064213922109500961971617), SC_(9383.659854506748826394653653799945921584844634971363658619865576122565428850333231870943330741548308), SC_(47476.86062355669366406465293563727845371215212597747352120951990072408933567392581096193759548474286), SC_(48344.57461249197864774391745122702191318613423175168570648608347079925339207337865843091657348607342) }, 
      { SC_(21499.927734375), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(36678.17650589731154881997024774218212221144294835406349632278754237145789828360963914478460770082572), SC_(37296.21293926051386599879363905756120747766765983526147321351034138617575311994871067251073381216495), SC_(12635.07484607153737001284594301223441015843133967794836350479968561090220973800207478585906941977256), SC_(12361.16987971865465934470975737834498844024117513196643419839993096361274392741788413019049629431352) }, 
      { SC_(22186.541015625), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(3511.469396303025628220100087480027185836785861343825659797436232543197491143786408079995950884187664), SC_(3447.918906160248426131041966401185822649187906223737177540213314101085878312383210575943208599698802), SC_(140962.2432028715916277517603427461823361022481177176964463476189967593974411846015884805520318454832), SC_(141985.5549385355735320517091791994771691029368906472194167148320408877322214472461768155468182224975) }, 
      { SC_(22489.205078125), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(691145.4452450571304916685549865193210879608055133570712977722690726246082262765714569256669147182264), SC_(708827.4892535901073237952534168210255858166007457570991041345909354499292795894387015125669294818518), SC_(774.411979655699999766266848811452884153208417998358511002107229524342784930080980951827254216888835), SC_(672.5904506675453981147094980262857504780734226947778894384987914261310902271605589290467767663828811) }, 
      { SC_(22898.87109375), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(3641.006097446102460914754066333917081994870700277896020199867131637883570591976418667187771978034571), SC_(3541.950300939567705200122745252228780231426385573355586777089385747062498140481980862664580974080428), SC_(145219.4191622905609553161418641721329952556456190733403759585539263076891844618988098883213582041134), SC_(146814.4509096603176712694522672941378048422913292005478399366889617578690435774394465238678226798732) }, 
      { SC_(23129.458984375), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(223177.3051387342092379977672546016574536627010555071770007070076966586598700202509370741637612153555), SC_(221638.1089559473981010777353764872788805787871132907235012093170703052462167163374107295681042835256), SC_(2379.883657084782183523718616671002596475348207166556558955951519332376091705945982917719472466696153), SC_(2431.502278304372294039957246081777930616477404766210427550536559856448187549206316115219476488774874) }, 
      { SC_(23279.08984375), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(10212.36616665014266796723526526146562804977695481157264073767076724826042119923984877696493967739162), SC_(10534.49469953140586903029765567682183050204231004051268994211690258780527657742191353852651258589243), SC_(52787.13465099657055373660417051475320013188079098063353513569964064986765092932611219613227352742375), SC_(51704.10134708071027035792810393589444379175173581530598945025787667614400103881923006777176277418831) }, 
      { SC_(23644.984375), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(6586.671648324599474019367932863148685032075300372336430522805520828392866142910471622439887700440606), SC_(6839.525110243550415420036720743037475419322901548359483648257629373338918315611125682377706767352352), SC_(84129.23400240355022415360987755455422095810889695630975077874331726250285329151954781800233059000899), SC_(82457.50542246634742949124358709247743120369085180849512216932957026269042043710144035725828491574377) }, 
      { SC_(23722.47265625), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(731946.7070286633048947588268280741355086074995354970734140548661736569159571461530418303833868754573), SC_(744758.4967592552116033731653521396657337196339916566563225030622237882843884709610142516929829066642), SC_(799.704921323424220298972417542238468754113306810811560198778780284708279831763751616461344365832345), SC_(725.9259397852731689341229271225841631691939394302352225061413624505817433516425050241122010711132216) }, 
      { SC_(24008.72265625), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(251513.363564897533453795957415453371128430665846048998415974157088791282307685014021099964302605657), SC_(254844.5383779384729162068342083375769857719755186544413890767846991671370251536441155126538507272615), SC_(2325.855113113466242874894509252209920667183361985711720042349968657651175251588306904337367684382764), SC_(2228.579654488494400271496572109420030631590209194920462839958754684846920042854893519879766408876644) }, 
      { SC_(26300.078125), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(7515.447776669122578424009806597323326727148649799516524042019467069350995939059152968385511414285836), SC_(7417.375103322493005285526198812792326148602615762679817843685715219508772493923466416758142940307453), SC_(92319.84083765308597258538665730283437435822331938861428845928722974841952488583084516131449537441345), SC_(92968.24176084130095515244996823927740927526296140929947540623572289823512693884511892025607712941056) }, 
      { SC_(26646.341796875), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(835237.2419146386106276368258173164044644185021132716316195211620398774697976667733884192463392705904), SC_(823465.4278969709168683987208911552327917535055836670867769181712283413382383493681795188806928359747), SC_(822.7854745792962971101306702445873306700472265863240307503617249145759765866685482782638372008703838), SC_(890.5765180079745642545573871117240674711995700795652846560227403839676384449988828822103414575940857) }, 
      { SC_(26973.962890625), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(3861.821090498237702170654742591404414997767899172913147487715360623077539214928066915531800453324458), SC_(3992.498845562353688711000420749761142174440052775252985518578042284843749535245526829702276948819003), SC_(186472.3340453493748522213371715056996854355565181107609646725732776292740275872399003627056820266065), SC_(184119.5287952278395889200776958342997712362616575631439735165992934948958620714780239208031202129345) }, 
      { SC_(27029.15234375), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(118091.1104000621337072846690774638230735069987401372795948495853249796973924723508365456515293883863), SC_(119651.855082247779654969890558203157561148401144982238136613195407696664429239626997795219455812968), SC_(6231.045409015172925178035881377779287925695684999438764809559753093572885911595249706021094482489677), SC_(6061.820637072098041440523357168283620957822242503827921699414758928035697973571633813819683168996224) }, 
      { SC_(27337.189453125), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(856605.8428133950133125663245669908399151303627804356100997346673522448354425763942959863915424586345), SC_(845099.1879733139813067241800633557803883895153452726087136324401575759116073653230659612255528546483), SC_(845.7294712322744291974052875299347760979872638227445990319861351732817528490086209473879834802596491), SC_(911.9937043396315339960263667630649991015060890350419555594303365867040725645310938778057787394283412) }, 
      { SC_(27856.95703125), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(3929.168429593636240577782419535130627065916902014647007732620466835788767141737840740253442433104176), SC_(4183.31872304042130685306639119250649061279674069821899421921712029951485247528755106316942289270075), SC_(193655.7574167702815996984759287864539132002179546569246844483969542065898479063888308601550925189075), SC_(189079.8410543769399413237397721252991030105128129134516261182154870979970926681494283552800408485574) }, 
      { SC_(28005.509765625), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(266997.8692861986707027808762437294172318830381568114330094189778180038603751676817917827549685014712), SC_(271603.2441679815093918385445340819837579928115140343382662887682474490636415743566486262309234534239), SC_(2990.322647893525545565881525417259752378072435106252798448194338008720528329567097942405361893526147), SC_(2835.877135816976343305526565639631084130218485913062919044518506695004522365673711270815648255856422) }, 
      { SC_(28349.017578125), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(301068.3597190425486602922839037949435639580812700210875109784005601033986046315244362259863218462538), SC_(296831.3558960247457510114105775599836384489869066566000952424401067854695805539368093922670521910457), SC_(2627.010054970647463500724618619524308791792248682320665638334274265114073590884309228042826597518283), SC_(2750.737228187984999509902705436527546534220573775651314561549479262260953147125049463204397596695794) }, 
      { SC_(28436.65625), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(4046.499368597435984764498988975904267094161295668589617043739684769071486002415721502740379935117694), SC_(4234.066617994396608648719944029835644470515741736624032609900781602209602488855897522246447958501901), SC_(197034.5588954061010696656162926930378844288897445321427901699773658454966445258281194450075636865283), SC_(193657.4717236277873728079424001689855229159279292641363552024891531080024693937096961017370200413377) }, 
      { SC_(28497.966796875), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(4125.518692860784065878503845559119383815234296856921710899878932412642855251041986135393778157969018), SC_(4172.148530378460810922840020215063849459123377652375426938190474365218419839903903601895777148215613), SC_(196182.6835726074189950382390220922829683796734711360073588465254833446343608639382906926848240512647), SC_(195343.132829009391621859551106171085047662187623149905875753477521942176972166119385925599833134947) }, 
      { SC_(28760.623046875), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(4125.199712465956807676513869661795780864831571287790955683096454501444593207377699396978290185852782), SC_(4249.234550654099231233230832875521842715201953025193180057833236676226339973620450122321873121496657), SC_(198685.4938656575736198063967573040756568461427807656479693227881982667501963528808579085581133359404), SC_(196452.2941155723226773645084651985871126112360726169629929891106632942082449676429870808613584745146) }, 
      { SC_(28854.287109375), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(4455.018175802635931513713983069502438425351484272548651515124558927753271854717937859294802534076247), SC_(4595.986720117879577651081998365487101862445603016477118913024997378140600036904759489976050015649944), SC_(185128.1371134684265041712316561821324991525653105943096968607194187373223126201333909395018851825485), SC_(182858.213249074741815211138057531102376245121607290234469518546280007775817448672436201787879408207) }, 
      { SC_(28939.439453125), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(8180.907899846691347554093412291711649054081312520799493701695183926713301505196744714588731475454666), SC_(8250.375679848654153253012139955301170563365682890758255650549433829798749783107776015882577448351285), SC_(102170.9022261534758473800809280173167273252557137042544770603079575099000460565329010819111985090868), SC_(101711.6208570509774691718220852095856285777598413055589775175471391083321171432855192103234560131089) }, 
      { SC_(29454.84375), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(8476.262864964687159977632931606787057180404945629659792811769674628927254087603163549944410842304361), SC_(8248.22136683914438415955549014853742371132212517152172142777314374343078177060114250508466805696382), SC_(103004.4518187763410764549333807384788509604545439053408680449832955060016580596296657632694122137597), SC_(104512.1342536051326202341395322369581938028145840057002798686213456276403648151227704840824325610566) }, 
      { SC_(31329.1796875), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(332525.3908956773549323520259886747978271363378370499123505201266187484464375842673852717308976037037), SC_(328226.9387907561576819033686416134076193352472728743567636548698322732269327281565948362336142030601), SC_(2908.701363494035049126774603662167084208288464975188556480706234997278158158570582924426038136926556), SC_(3034.223156767790437869824617912700639002709403060221237614879250289563126501666902479866938897469011) }, 
      { SC_(31610.083984375), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(8833.029670851400523420352754020464117502140293845969559143687909380703228568593521371138077789571939), SC_(9115.391739827679289430328318246229279231392748925436255925132756999340292425595560318233213009402975), SC_(112284.439419806345297298125959604372008652245905375483231789620680362203255840315122280015808935771), SC_(110417.6192240784282032569247304060466891404365995542682997551636663233387982537486441467360879573581) }, 
      { SC_(31714.484375), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(14203.19361311374800434265983883310839913752810901804188434251500736802014537102940498365990341169104), SC_(14060.02344486661169439755589131906782196728160364321378993585458025661098967915290140578960890916139), SC_(70934.849956042435760825101917512996767599834904911637438132935678690345064641493080877155264675701), SC_(71416.20374021502209343188201452043989814831628556590513132431953645273982388755133060025394284480233) }, 
      { SC_(31863.724609375), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(139837.8616153272942642855173561667659899027548647425733032049971707621922013103892274319117395607133), SC_(140426.1504961139706915364922463507906377446949068935591466194580388362518131832497692885102816568318), SC_(7277.418693834746992408201302160217415270148336607304448311381914800846432154025185719079108333114307), SC_(7213.632949671190219037402990570061995151928160262857952927940480080236852096685290846572246670786763) }, 
      { SC_(33048.375), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(146353.9347301095882363216083377536757546713482284178448119588625091638382010273420289201028615840833), SC_(144333.8589324133221878646859836895761457432202014083104861368598449288360848482539431093120550284169), SC_(7405.667591629774894871265433336192027844156277139313006282648539922791931362107533903454561790096495), SC_(7624.695742377679245590164140654276856572263883666813073888136901633112193554796131367632921443466439) }, 
      { SC_(33515.08203125), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(167751.9774544492921513217338204778818800496436239687084295878371292103736940611155888881008471205803), SC_(171533.1968523944467844734858567580705862844451501557310556550564549012828110071617955014914169810039), SC_(6788.637106339344339268121789610546286227456414280044380626028150642152542994310585775612895536362828), SC_(6456.585648698405966654289200426258707377396720818041777548568422326612001773153598375795150592523076) }, 
      { SC_(33723.4765625), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(57493.64054483465536461522500665335058286020408478794080205701345108424359886104458344040475091036884), SC_(58538.70952852783742991301039191397212963284581856210374237202088350211482106757255412551925745644209), SC_(19835.38077471802735773626585497871434464346907363966183061583495459497719196867000864688695557284133), SC_(19372.22089989696982528179923290112494065646172306380514763011106651038433854630338711722482166151731) }, 
      { SC_(34292.15625), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(327926.3128351218774887923867276554005121569251748377989889342826167169218886784885299472954110163731), SC_(331571.7687512120721889857825715509584634451961919813172352417518386568124630899966188175606647152092), SC_(3627.823435606609302193169538748985980280897382957553165389095358679105646492616118594208018114259513), SC_(3505.568932125196121031308342436219247074314544065353093711658152431425677974207449248809109427192562) }, 
      { SC_(34295.5703125), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(15451.50495810307097665273815053534443686248667520048230063498151833035741724744097028682026710156997), SC_(15112.5350023285074230630406692489735346247377947354379918580444615633214431508717330415480506649299), SC_(76399.3007693658735323793234603711391824484155768439733865001392234109421821977505970328400502522363), SC_(77538.95544706223698969799662474920494823216274572402787393802197324742940953423094033689612327781581) }, 
      { SC_(34538.4296875), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(1066989.456061416133283082180139064410414217637297565566102457795654265233660146572095075158717524813), SC_(1082995.692171856477170061178001551596973930341788563356388997972385165489435917678033621400944260256), SC_(1156.434697413680254024722013281988370431784413023079824940982186957698804454588711881589073140658951), SC_(1064.258164301691081163701667553369426197673639974621046849886783221628310693341070786726845004855082) }, 
      { SC_(35431.46875), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(178983.579520004654160956589200673070997624948011519829955681698296217781130100333931603205979602729), SC_(179688.8170292860577153072404346546523798212719162486056482307845725327186761779127831970859468243358), SC_(7031.413701905884036758676015023435856828752624973002038718149086947830573999127339314909947990158288), SC_(6969.482210172865923218265951068533852037268580428900352787767103889674063189604520405995270309965617) }, 
      { SC_(35777.7109375), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(156092.9937513794130849140400316210777284038403196966100713101875083893007878375639653179168054856313), SC_(158603.2136976427715800328914129499683197448195836309037386241787708038806877271923200891563728173191), SC_(8272.004356893429567939957393558522330702244031640110574507942449733924812411533390506642238119621388), SC_(7999.832084761138988505925551227706534825907407594077018766005507319031742343768976155037707512811421) }, 
      { SC_(35904.70703125), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(182930.5468543900677219631896446929351999250821764214870026566091159188931540009366251280651127203685), SC_(180536.8636938817441921031551720026853850058369433663605762291213938378489931424959493216238731575306), SC_(6989.11861398603852399531814712761663320894939135537146036691377792153049649096437218416331486353808), SC_(7199.323103193675375297917281266377545772838191939371499122566006156098231310319857055764127824081481) }, 
      { SC_(35991.23046875), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(348197.3320864694631479022914385800903948071156878421285426430856759077796998406515840654884015919924), SC_(343978.6494027268963519328363313166301560516866100879705217775338017205564745769734571177978051574661), SC_(3672.704701435602345422132938389780485359866909089941150092407503334929502283367123576841845228128302), SC_(3814.182960409638084881586971491494100462842787535693278537122023050221763130622839413085178324557638) }, 
      { SC_(36208.53125), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(5357.029416019521141779723704061496853581703182028953957064722327977794199375017069146443462103066579), SC_(5186.004204264382102717026363679821265274285960645563796738483505784206582387694328102705951574517648), SC_(247193.1089786776436093081812546850497234179432369590155651613146588590268484226873771576619611011246), SC_(250272.3501716067367985988028958549237551018713789439696495397337790761245041080316138961502831142528) }, 
      { SC_(36477.7890625), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(386286.7974635178327904300899360602300114950096305222125572731797323350654137670081926749590128383147), SC_(383047.9902244575755014619193028360975736959646009740366876673909218972749557911744658181293322103547), SC_(3412.288206817822981378845695288112550086636852283132916338647265820340373231773970893047261862226128), SC_(3506.867044336457195051765064239029818100096639578696948198177480537955538580813487593572894036320653) }, 
      { SC_(36480.3828125), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(381829.262064878048157024759393637334551587341386450389334416016053901716831483470094923520684056254), SC_(387569.5385869845453648859692797780477956939463038163242137985174964947763923300842158950881085750663), SC_(3543.886937127134138864397463697195244393835939181625044543261043478244219104349912681518259884035455), SC_(3376.261596836504551156506674539919867421558034275100404894266909321395713398361603899321986085671375) }, 
      { SC_(36492.01171875), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(385871.82586146955889850893899478635688467654776120346833701749879688804749052004923201983263672677), SC_(383760.4245318356888531422607285328192715400600043725986514820515298392438128723134204434520159083074), SC_(3430.030658218313890221887444086255503323956259004870004605785232103273017307400012753090709993964819), SC_(3491.687347781136935586511158062714573869108435094177426736410032811855266225829671463812773415840687) }, 
      { SC_(37160.671875), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(188909.9983204872109825919488118944901036283486514150110720640078028233372755188646721013230622684356), SC_(187268.9805708234442903068120603707911863951982279508201615459658481695393515342882571190986675143192), SC_(7270.141129431672989462683204504123878802702269087749581574740768579331927796558564355957548318282573), SC_(7414.24948504495615457573449145877993840224807877321441080300894959725990625174098976737641382664383) }, 
      { SC_(37334.53125), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(164916.1877914371540034367592825717838295849317497537565439176669609379487413175228288740063903065055), SC_(163469.3205981778111914157936834751755363963138975119769904644354215785786563058268268370748703567814), SC_(8411.165836984873653329939024963966268435637911524340176478037270019173229410241151852867974918317469), SC_(8568.04367350621667502118039452688126436205086779207687411960376087595231868903973654635398035396344) }, 
      { SC_(38330.3046875), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(402268.9583272731630511991427627985238878364812682593744742827416643921138699398350535170225230752425), SC_(406137.9682163741663346496505603960046071694461135640321835250879577429872797366547415443777455007079), SC_(3691.78299859552445232615738303259384050133030098809279970346838065474366573151526047525099663742035), SC_(3578.801172677650399292759541634292592943374846827633524048721620065279898925539642122920431328288394) }, 
      { SC_(38371.265625), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(371231.2442087764801660934623214276296984905647479450160079704377577306859928306102042223739940599936), SC_(366717.5286279627649339806109629703016579616672539477918572317277953000746456129883515694465215149202), SC_(3915.286840772462049139963864731215026351362339782032241075394649976011677173005189371469704076174838), SC_(4066.659417728207187455169496124580706699572323332795324982851749754935260437811309446289686840938965) }, 
      { SC_(38870.3203125), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(11126.42385540831145440105224473756164959353235608083412644166015853719731674151721913598691994691599), SC_(10943.49642965996288229350666696333641946491837784920510009825504191296860851943048536253496637005559), SC_(136319.6737626222787128070307920899581242613763153489396699544221059392257612410884196144322347547252), SC_(137529.0853556864511050754948285836619801316427421008729358347624796911646218851261739224941501458513) }, 
      { SC_(38920.96875), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(10828.03212952944239099962639976417151583155913003832857371181856582237080884379921804041263686437489), SC_(11272.15250185403242383231648095048526311618385397221040809599525248583527462716859021790362327886181), SC_(138574.8019204102524079509925298580024678938713465189394173395430584671213634237091433972192931881351), SC_(135638.5237431522019687646102765026889875641724381206120317897116474339173361910499668515235314312073) }, 
      { SC_(39537.07421875), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(17563.18468844967168742479914817583648488027417980463512099444652315214996458563905137374297123693439), SC_(17671.12782606081120618339130222760565093475292300540551956257861468349595821280428674180660694244922), SC_(88912.82606341852338229665607294053276732403443052655041185253618875075517676246760012511827910941071), SC_(88549.9095387247009245736300865839718944108746037478466662001782408836703280909849708822858884598813) }, 
      { SC_(40236.98828125), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(17785.07449749824061871009955866379465369538930984808769961833799288446975100438176213838503128081445), SC_(18073.40706479004100024564638827892989413675565772852850762363611013042052319327555376736268386398047), SC_(90787.49230274484538760583071997992245638084046776152771533309883183333940942467702495507775703505488), SC_(89818.08666172057450204490603003312612791359363411487343908859007574994681462888871865749465040437439) }, 
      { SC_(40620.00390625), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(70214.59614634759207849087620430909175507827901445353332897835803949448395225034586806610320605099194), SC_(69544.51997904018008698586441892674480680869570000514808058576557512385335582693858893209710019294967), SC_(23463.77144943359265505365112064449924860149934206541133357097666432584510760526587504443998239012132), SC_(23760.73995113764908472532424175554977649636271730639983038243775425872644040076435561976368231411984) }, 
      { SC_(40806.390625), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(6498.056701801031069979639387611929684633486142115435754625338657947817282714090911725777105326469784), SC_(6301.829584884688356321484368049667505035617782636475933953151543143115736047564843596212027128878517), SC_(258628.1336306046687641682762939669331895466783514086712698431784809510351169377472737401218074761866), SC_(261787.8448509283123504132124995012464345533290557818973278974317526386234296139750290749626979635583) }, 
      { SC_(40811.41796875), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(429611.0809614916674016204096494871587880927982705815445271091662615680668794523145259858632753393983), SC_(431118.8379913383015193088380803811638619202211197912240888124258971205063060459713872923997274989898), SC_(3892.452324250216321819056729292352227969175208849249200552081366385166578909719244808612409327909488), SC_(3848.423068196693702345862109311643852708099986654170620536759922128701469589310584318323457617572553) }, 
      { SC_(41111.76171875), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(207082.6972786108411984727465209859865613145058775003576232202217555218313821463300058185728752304762), SC_(209094.1623405038575132951917544761569696373539902309159672535516979615350521043993502027976566978985), SC_(8211.176544261705108620032115197928991966399401640086153160345569939926201639091008004347692229339841), SC_(8034.536804216510786399098858221410976683558606544635168443601079249570373661691730222829040125340015) }, 
      { SC_(41389.5703125), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(6461.833101359079211799955781366027334508220277920937533122851625253656618372527132948694104412491983), SC_(6520.445748586937134152463389953264847913005350624887743010462461484494654334490997883956071859970948), SC_(264395.8839914776959180155376505645907767101763599648365292901037491424829258054669594168520600024352), SC_(263452.0867162633809756597142688714534455005168659957807922634796008595331809142486682789380566561132) }, 
      { SC_(42070.5234375), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(18440.15283779798233214515634914800334139361544241176707659629062626700809199358887617557005539919035), SC_(19053.98827477956234319265302665304024810873611907234112312266357143645428084452385437797723138196383), SC_(95452.06699885347935965053498934869880086420062717941330708376338799129358114874416722137884089203275), SC_(93388.28263737631700299413902645460497713170016380473855375883072992287480873917292631861157106082538) }, 
      { SC_(42258.04296875), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(6464.827293995152381738945995625612444376378380075119469314751637711217602117066655877754748928753996), SC_(6791.316487788793613944834840874476894360191607865046272170708732132059141620874011097379151190024626), SC_(272098.2364087555712152617470093089692268146909866499855606965212475010932819332116463122295074645885), SC_(266840.984414211661437493874378230390698983869704552433542913172580605994293124248687498508039977585) }, 
      { SC_(43316.66796875), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(1345964.665281131087180285153198289820104636264466282834530847700487446743089591493424542815257776196), SC_(1350416.131239459178696633812661546845367857821006859997478584705148384362464980355875060196188776269), SC_(1404.89402880184296233156710051974736687298466343244119840651152050516704125552158623357672398184947), SC_(1379.258302212056923681910192549801744744741683012766099036944559475833196266557645828417142126377827) }, 
      { SC_(43677.16796875), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(1364493.837362908888899200116294629697159360597665410690062882230669817979913667283821762955375352187), SC_(1354337.588568408407307144299878903858815188995689729016090958292429561280103400024302909712493398433), SC_(1374.498740468195854558416241642294967378991931896981281665147734039173319204051729832671766046787737), SC_(1432.987713454529529662439229036074116551524557368604227439803694327693333948625752884393628041109176) }, 
      { SC_(44282.89453125), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(76682.32462743760539011313270300646742423140566771695068799366746562466147421212743204742927656008124), SC_(75680.39008284406316265093668305417358564211656125097188627540486790506867595473554737042041351455734), SC_(25519.65039086562902051251047957351446206808544324496104199576301785511745408514783235489479871463999), SC_(25963.69389436453248854070636938889117256773648800686345467208696627525632075836899278976191162768937) }, 
      { SC_(45397.70703125), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(77686.12618586906950280780934249877829129474858608321857386079823966903588541631508264859717732881725), SC_(78511.6490323689141720794852289915602875971089607391627047341202877971906817015928589034449069125876), SC_(26572.48150330601906443520823376248069169872215846398917670291354031137048546815972590982844879556554), SC_(26206.62117141807493322823858364554952021429176126646934298273824191683352557983302697047356311641346) }, 
      { SC_(46000.8828125), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(200933.6980445687665869732672027859517711419344472213377991346942664941942678712786017526186051099329), SC_(203682.742270617458836063412027464574628372638496914061598043050412845999340422486868730157770187481), SC_(10609.48793865563282259724337066596176808425842360100940022887683962011959461114809563161610663992595), SC_(10311.42059395144837444502141343438725397898305392315689154697085013558408375208871248895508126121128) }, 
      { SC_(46548.78515625), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(205241.9165567726026795907648918696996637168604116658152239239910454073347525003695383439151015430608), SC_(204188.9150995661970489575945804447862500368922220911018144156229374368022359349405597147502397404132), SC_(10527.59242906184334616446912856133535414945652059731127983955957041139085305804647612816179289664684), SC_(10641.76514794620467707445716759896437999940796956987578518393153966385128646455295624487707003192284) }, 
      { SC_(46639.65234375), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(6890.588937571796135564609956289158458548221059732489292639100572250287921159647771912967698367210346), SC_(6689.454746416205382251859090520386870619383843399736032421404784729317919524591528182758887302418604), SC_(318578.0623304237179080014327774584606203868248845735186379166514097851754131951127287388768956145746), SC_(322199.3983838231419058742328196744945751720923162800184523925969203462037372878582402380782631095595) }, 
      { SC_(46696.97265625), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(20571.81885126567347089079745631859595264245093698873627932783616075763515959087399759959759719998799), SC_(21044.20799213985874183912646285945310749796326257848885322234807052687312211172843258244113418182308), SC_(105595.7825711617987874601683712096392867815336519071642155882661193992363391467984662142047169072872), SC_(104007.5581868686410388817584600766855690363774748451903157554856868081775651387580514240872346551653) }, 
      { SC_(46995.0390625), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(207841.9057479959287663841467052640990210584231871884201530783213626893116778444236446118925569886002), SC_(205517.2066108987966406004833848753217487359186207414875204824532212319129547443353282122287838257032), SC_(10560.35297348455385572781237061087983873820859430313161701114867462732282255730511125762729460569299), SC_(10812.41051673904673034824690650393875424045935950206973807116516934650784924194150997502117400108583) }, 
      { SC_(47380.875), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(241147.2904945180461724560498068462858628048717941176679402396107825988407254583050161095951707677979), SC_(238493.6597572441343836081598889150147320724969163820859784635365647419849577630624611221518537344086), SC_(9245.016956651717741230155195112108937020246622343696418865548818197031178877609950819531388788603351), SC_(9478.04941787491018056075471171906922605736129630477819528903480345450379881129064783602805371266204) }, 
      { SC_(47806.96484375), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(240796.7944465840286368210871366946566333870052798932156780710276064140293642607090005339850453302545), SC_(243156.5152094298174043645028063452520846439309480991639042042280198008779024951447855754490383243349), SC_(9549.26555225751428071128479072008227634083383790492332844071766380649829822882515099556966185472546), SC_(9342.043151529226927296638009444283484876691494192662682960776686978353444962241528203047522293977731) }, 
      { SC_(47988.5859375), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(209062.7585714042536193093735369786334454602106343495239897348383071737647024848139675580417754426088), SC_(213042.757071555086684203371273436383985225966076440532959407489512255684897665247168949985144734003), SC_(11128.61266063268237642738201257023834770745516254222770025730837654648533088051116815566969683530221), SC_(10697.07880369252665054281672360593417778175371048788864122220465681175887803002588941994440627664985) }, 
      { SC_(48837.765625), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(7763.010905464487198238728601664833652743688516002718068688165990011449307310390677380914940412936508), SC_(7555.843647964861067045381436709095303308406040961587892775373910602905446045210487321368116371857413), SC_(309752.8674453664171902143549729394593720713033607557548567842682687123404479431251192821754657106928), SC_(313088.7364274653741310413293176749457588968534389470312592802697444078010628051552709422438360318994) }, 
      { SC_(48956.60546875), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(466600.9108616601600255017448184093837782290180190190207303590758967509808191118318626939931973968863), SC_(474936.9132200669862092880477770202628972559699788914656277344517510668515054362124153215574789840109), SC_(5232.009874386690686045296674074426887061845728313790211684147448036618752399811803274178245188016422), SC_(4952.45344389526653244385982777121175164971819412300418928404118406340555501179055758541420019749557) }, 
      { SC_(49230.26953125), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(215541.0773721643386954741914127594454317087649341470888400595290151910030695859881235681671940537537), SC_(217477.2660125211989322721624261015459122511140238822954688890179549591520839634710880371840171867408), SC_(11299.50048169272184245390679951938327601707757362247817882695488085635758978877935478972199767587089), SC_(11089.56741203173973412983020328639045496599803939663088952648657317551914924439100547175931985442517) }, 
      { SC_(112950.4296875), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(1081652.599487618507259335449255037501127623123518564445447799835756793363241759698319225641519355623), SC_(1090585.276548455631300519416130507480573847462645755937295385748645147211048848783358279512741033367), SC_(11896.69069317165347781457823474077636874956154250217570225505264761709240155650483675324913546515522), SC_(11597.12130769712459377449641709502657243959208410290973406987469392135898130915769309713125119315928) }, 
      { SC_(117781.640625), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(1236886.520367178661774757541962513817707327959712511497208165510765161051664255133611363036792081518), SC_(1247200.899669897556133826970136802003401476623438659091045126743189363130662804745085402530909321293), SC_(11320.40560204276453110858497193693120401470335589224015320220706148489143418172815703449171128758979), SC_(11019.20614079371029033814973750629656949770927432968436237588339953076548449005907170929346184236181) }, 
      { SC_(120250.3828125), SC_(0.8350250720977783203125), SC_(0.905801355838775634765625), SC_(606125.976255634775937261848232967938461282572060515912851781216035274218666202810565471404061683602), SC_(611178.878924564037386275315826399953465035595127519354388658480226345149593615459825961595756631816), SC_(23980.26189691777237742837097391991925034532622145308117601288909264887636132879803847483654783006236), SC_(23536.53291485397911841924014195942715962236091155086490453000722405517052671553210096366342158728449) }, 
      { SC_(125436.546875), SC_(0.3082362115383148193359375), SC_(0.913384497165679931640625), SC_(55505.69055899452017638240331722218486566939931161779288410809517884265467830660031545310943511071138), SC_(56279.91861867008927405098362839667085216187059750112258867214566658855327754213663056584471025210283), SC_(282815.6716956292941137334704811980604866267637754096159584283168314930228896094508818884854244751906), SC_(280212.6342321809914228113764883411947198394326676230821856481503727682700288892014261457796991480856) }, 
      { SC_(130199.375), SC_(0.905801355838775634765625), SC_(0.81474220752716064453125), SC_(1248714.60707892330060888942260474614462738889657116344590779557588255487758761962110359714545986524), SC_(1255244.035673733311045926458695250466612897030412252275747474610592857998676365892898369949325650613), SC_(13650.00675432882640363916674557590513749593523213152292663240623147819449684796803703354364016596771), SC_(13431.0332464484433616240685177738109172523766641326770547559270142744625288263247550703993239078491) }, 
      { SC_(137528.015625), SC_(0.8350250720977783203125), SC_(0.221111953258514404296875), SC_(697680.0003595551300427761129858824651574838118973833996984479281497634284053475755492855449188375049), SC_(694523.0437224831308009878310850134941410420761419001348639153588500245798353414796269641505949262436), SC_(27033.03737479823656508596073019479219793787108954328939787411947186051153239011030668197038491634068), SC_(27310.2709256707483307225145026109416620298941304591446943393756804080667554726351528496707350774345) }, 
      { SC_(142319.3125), SC_(0.3082362115383148193359375), SC_(0.632396042346954345703125), SC_(63312.48204402967129425282290981042948077353637928273939264665282013169576617896783366496076233905619), SC_(63517.2804496215738581684730955733695461590565340035794724359787615800642589985581813096775108776738), SC_(319746.2404806578439328845400939808662827911671944283986791179607244961725193826345614646595274145212), SC_(319057.6865730374117315677966408702739859917514621454313625935594440829671104407701187022249250096772) }, 
      { SC_(143878.984375), SC_(0.3082362115383148193359375), SC_(0.8350250720977783203125), SC_(63813.52665973956807479360916687456455427520563009268605178589466059366007535313872258677488728078206), SC_(64406.67967628489633310440742300047480934760691369009957427130224414947015777788167304861168500729521), SC_(323900.1660319865573911060941116839019537540230187629669063531448769633835854032194756969690718553925), SC_(321905.922612671025928505331440292992008062833076735145596992340061644888049029373909888360945330357) }, 
      { SC_(147358.625), SC_(0.9688708782196044921875), SC_(0.3082362115383148193359375), SC_(4592500.230344453330898038197980766936298137199832739697213805848549766393425657384669342644897068763), SC_(4580341.275506799247604278102560427088954512804189941261703806985501137291640596021783054992734183534), SC_(4699.881503576720523740916925247353092204183662515767508815514218864880696047636842583010970764675982), SC_(4769.905181290702485300861380553693739200008970795880452545087226518670302945699996585189255650278272) }, 
      { SC_(147685.8125), SC_(0.1355634629726409912109375), SC_(0.12707412242889404296875), SC_(23347.74038465912432648973496099528804013085445703633834690556423122498799964400649410893882457254513), SC_(22974.43222264278701296473842300075008535752443042611834184235125329705734687064826955917867886646397), SC_(938731.7785880996827876993195023819357032806253381522481262141846229297205195189053128963862710147639), SC_(944742.8780819872310125241789360128316897187721857806186336643387286763196353112017530462462452955147) }, 
      { SC_(148346.234375), SC_(0.632396042346954345703125), SC_(0.81474220752716064453125), SC_(254457.0444837605181644826183460611516702997932081834158355406933486382773344908622555853741138245076), SC_(255949.3288856824804265584685573494554603444583308766145483732866787685992851380324769296127348456735), SC_(86562.93055375982365694876205551108843789601106705333688906853313112068258663706458115154094702426031), SC_(85901.57035905428097363763252815183184298621809302790840852450304250493450126023244231055795873542728) }, 
      { SC_(155549.6875), SC_(0.81474220752716064453125), SC_(0.913384497165679931640625), SC_(681474.2688786608998964084939848225688467467856287993767293205450267749591562722727971222025839474897), SC_(686708.3618082991181347356014431508229097262804613630992536292850088071392536749787150076894573903233), SC_(35653.67769817500165234997709006013682030980112309065432069186871648725649352940221357297951497852464), SC_(35086.16536538708297778080833542245453268747661981135538080352906411588108339619746234547568135439638) }, 
      { SC_(159998.890625), SC_(0.913384497165679931640625), SC_(0.221111953258514404296875), SC_(1690623.235567604616696147537390982520110977839506375857912920648400207877519479302870657381093738209), SC_(1683840.092574789675597111621575385665341192447184017777362887797075443717535059019018785260629491749), SC_(15073.9418481093359070076910528524987653972756599432402147148518434116531270071781016451446203140809), SC_(15272.0229416140443526477751473794588226761672490471443491140922803612385590665474846344495699403157) }, 
      { SC_(176811.34375), SC_(0.81474220752716064453125), SC_(0.8350250720977783203125), SC_(775600.206555497489354094057461560875683598320988069559079210597262741936169250807215938976556175988), SC_(779592.0456256300973775555834232317478983674412423153098125234884794531781441971802760222251093404508), SC_(40420.63182465306934612369089519088987098191831936264961667774490928886766467697797020819310796170595), SC_(39987.81207231479686929314322298528393658073174095318672081088588450669971027118438130360896961343675) }, 
      { SC_(177304.15625), SC_(0.221111953258514404296875), SC_(0.3082362115383148193359375), SC_(50461.0064152376849976478605636744774420820449422465614494873985700722622640365172636593267863509079), SC_(50206.36279767891946599426509746743137962523258536952711141649173792648561165623127439575831022434422), SC_(623728.601393983800766744263972714227241350210512326720453267925626136253464292909195668988225953746), SC_(625412.1560785122942395521375104450996051682351873541057157782951528187013876962176832375602640995598) }, 
      { SC_(178520.125), SC_(0.221111953258514404296875), SC_(0.905801355838775634765625), SC_(50343.74843028506891603687410138533646917258443811897042034790924081028212833637691601772077415729116), SC_(51014.77603102298783099121589687454362525070177712480854776172325297020295745314807815385250533741199), SC_(631073.9503887777980534242388933414920695099359309741408612814287744948755772382186728094443483460509), SC_(626637.5069529379570274491744317242703797551774376374621201631726366052243621254756423706942530464668) }, 
      { SC_(184873.484375), SC_(0.632396042346954345703125), SC_(0.905801355838775634765625), SC_(316818.9384593961274458845897410940686289876808786663374233391660172917204807907848131581992824571942), SC_(319265.8471300424791071146753722793480106024559666294030397161207782132494792175723677453931860342547), SC_(108007.6396747618384045414399373589076756447258379635971268796541111673092583713439251406305481948855), SC_(106923.2029766122488029528761914303955773177957303362324249149060304820897976858258852018385093891119) }, 
      { SC_(186855.453125), SC_(0.1355634629726409912109375), SC_(0.3082362115383148193359375), SC_(29395.76933875260682724232773038600731801406829852143141727553266586657658755642154894441817550448367), SC_(29211.33864518701996530302853183281440903310447940226328610568814473783347634894282413841358020360945), SC_(1190019.919541090547863245010098210987543018747544903831363072178700662539082483381411371365390384379), SC_(1192989.665425624586131255369690125566422645921360037696131468608998894548122613190038813650407653526) }, 
      { SC_(187470.65625), SC_(0.3082362115383148193359375), SC_(0.221111953258514404296875), SC_(83800.60490145457461403483349017784021505365603860211902968452888933836910424146510420326864759562106), SC_(83266.54263272475997404094364017892286443868473159576525648221529766517017798349958038925353950624571), SC_(419836.1995448889015467592468772604694048905272030081256786197974535196703898792725667907304611096933), SC_(421631.773360412697220488010786395955508532129572072240775789063662505136332815837975467287183006557) }, 
      { SC_(193457.484375), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(5995317.196494154477644972080658776994331491128990030939166862182334894354148374848120734589737852649), SC_(6047178.073247734211824771419210049212257050449622703255367064361922629812713716471285180225871322018), SC_(6365.921646535021074109435866709932039549066148708546798287703631332145154586539205956340400513031139), SC_(6067.255392436011875157822347067935417034411907366631340992828877684324697913015577971574772486229597) }, 
      { SC_(197114.140625), SC_(0.9688708782196044921875), SC_(0.221111953258514404296875), SC_(6145815.8219207039060787757501355567329405861810202805184563377128379723942774086673788506148393661), SC_(6124240.048910175398595818617525613794205183492424288111643883619059482070365315465346624477602659119), SC_(6271.434660829513837482801539880885241618375159195424539189474362296953889425552838489648092013260631), SC_(6395.690104221566109532473225557905278286027823491641679056156764303154022961903502041242189020198606) }, 
      { SC_(204858.109375), SC_(0.913384497165679931640625), SC_(0.8350250720977783203125), SC_(2155420.557639522766602761432821667387748377355246621383026270219587868949533873546436320487211575776), SC_(2165151.214688899442560737525268103389884253027756500085474735455015202991707678847858100539858331118), SC_(19569.0936015729763605073035719721343399453810536008735979447975590842426606521065505803631943037926), SC_(19284.93924226160102365420518229797971864360091486489842666201782658222051853366556762587917989248848) }, 
      { SC_(205911.609375), SC_(0.12707412242889404296875), SC_(0.8350250720977783203125), SC_(29795.05675034786498221521078016452999188066612569447962896100039605564552470042737899537099998063001), SC_(30156.11351944944694752828123442751854537469729864755648606354053901491106926604433192674496569741278), SC_(1417744.607110220797822569566176304005394577623221213774032282817803134507725780668675201409782031594), SC_(1411243.963133093372562173653960262691601639459814461258900386655669855886591982432216220493351257709) }, 
      { SC_(206355), SC_(0.913384497165679931640625), SC_(0.9688708782196044921875), SC_(2166735.093243837795479458170564757130720434354035514924890230875043450066260592474929652063892344593), SC_(2185425.540830431471549853011602604962373638575065115420630707047731718886115466880021264467520645776), SC_(19842.36490322337802921162329624891658848469094376744339553853360109464301933178436607534358310552714), SC_(19296.56789150453931566585738787683355120453435661453261618210727131067520952709263447786990018892586) }, 
      { SC_(207625.71875), SC_(0.12707412242889404296875), SC_(0.3082362115383148193359375), SC_(30318.15972970153382202726344123198691558650819300213899014185143968786134831706438216771315336884632), SC_(30131.76487635977489071213217766288693254709545255555207850313451323410070398788734179254367601549748), SC_(1424589.540083821216885596501659151530867148351982818696542907677370161854879206540976464080784699128), SC_(1427945.483897120881367376811012998428421376326405602717656820015697188691507029696379139220326008148) }, 
      { SC_(225226.28125), SC_(0.9688708782196044921875), SC_(0.81474220752716064453125), SC_(6996561.423447535250994982687400767105900707374666754407871173164711694300716749361037791550386917866), SC_(7023438.049885315338499042608424935170952977338613743637001821451996310858030481198281896087704644772), SC_(7314.214288274307862545305432507401478025457091416928157654214971517779070407126255168537027029906453), SC_(7159.431045316808352844709529286385591513443300171108172859672051279379228265650367204110741590684073) }, 
      { SC_(227229.640625), SC_(0.12707412242889404296875), SC_(0.913384497165679931640625), SC_(32813.99186204943243535354351061773216391574375148866049455691412136550930100372334146954611717289334), SC_(33344.212265012305745393183831213194924602823344403252760245536779579960660310046600205291662938842), SC_(1565712.256139740642345290181132259421094678207440879299493039148141702569889280504255689786716861691), SC_(1556165.90465112278108875907916179906223507897149612725397957669961720360144392149254996009621830847) }, 
      { SC_(233073.515625), SC_(0.3082362115383148193359375), SC_(0.9688708782196044921875), SC_(103131.8062467634741832787104146715199147841123440478778085911015666850156290105918053761594657475466), SC_(104576.6180788819132244386975585424694540489894877041129652913904997383321183416901575347675266434304), SC_(525510.3398477441377719049332835985135792212337409970021661034309700792808677354931334620953362972599), SC_(520652.7287797706911561940288193523444639283992290810420600622041166157503947023218890116475601099847) }, 
      { SC_(239085.046875), SC_(0.913384497165679931640625), SC_(0.12707412242889404296875), SC_(2527372.036912072887285112558472045042637672569133936605973296204742624450443545948072951051177261728), SC_(2515067.417094579546240921850125220216551630734619944893509177966210254171464264013134284302915875521), SC_(22493.13889779028804966705861320299040992106514013446631437331060878789191225052853715990841727482486), SC_(22852.45807012762835310539073854781235596258958546231333992217999066574280182784669528991234001721638) }, 
      { SC_(241035.796875), SC_(0.221111953258514404296875), SC_(0.81474220752716064453125), SC_(68160.64173608733093171683233054186997338347077306146681198687239814247613761526795583452553903037897), SC_(68691.49050325313274257172742058244455149038975395219669557806260158165763297866847398595736780478531), SC_(850826.7605395442776049805414109488731748008745547801870910058460567066722154314852476124448207410224), SC_(847317.0990695608321508457683093018470809503252103651704620207920443534901909154516166095178381177383) }, 
      { SC_(242244.359375), SC_(0.12707412242889404296875), SC_(0.905801355838775634765625), SC_(35000.43655894495429789415811908048271628322164757089404335518725542287260522136811961720667588969225), SC_(35529.17834272747050731851427876051456952725705587604976192612255079151929596011981159133486797466186), SC_(1668841.090170706333226063098306251050376889350253843286037701823382016219489310856594931812968492311), SC_(1659321.36171402668639142598219120942330563611865166484970964916562952391194436890844587740593084309) }, 
      { SC_(242825.703125), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(1065769.296676536289865514472990492691291536859081414346845561102952121573422795612471066076107191794), SC_(1070069.412079112637719264930061555530148808315896972993854177393322857120988508476780099940910653565), SC_(55447.79234391860621740875829888831055612043622827210769221920086093529732187977636836649293206304377), SC_(54981.54725703208869422343524973163197679353507309390783206705322877221359053238590332922915745535341) }, 
      { SC_(243691.296875), SC_(0.9688708782196044921875), SC_(0.913384497165679931640625), SC_(7563462.434647289237312547353334578260503933823126828019827811642651604332247100415561106156739791568), SC_(7605979.12767226081971843879976030288858439900782119307639579192153588944680504268697259124242795122), SC_(7952.704274174906145509230570275758081283002002564882702547968032628561117892398229282289800757766152), SC_(7707.849796957598629356707841766130202058867301213016129068608200033790140016675984509586175913132124) }, 
      { SC_(246326.46875), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(423396.8078584968127029181437202899347924966260828148948793217274049465820869252904421924877781351628), SC_(424123.049180965453242949231294204358345613912350286533731107166290279924636398064239775331237735264), SC_(143347.6249925096476838281106121913621595810227620545643485708828796279337663884811965790741623694398), SC_(143025.7646541547008903209685785338405430042486086644127273779859430788779349121352728781667774458203) }, 
      { SC_(246877.796875), SC_(0.8350250720977783203125), SC_(0.81474220752716064453125), SC_(1247114.222859766637108879157169941933216008346257054121191680922689888764610244878110528676680778634), SC_(1252043.372393010776124073063137399704263945782809126812756846398728101533463377049697575362395209437), SC_(48992.24278287514166928992794477408807316950857555248480460547055754355325519031810889031193088899611), SC_(48559.38089058660683480560627478610561630445308453877950800474837465119265043662330938977921627300365) }, 
      { SC_(257382.53125), SC_(0.905801355838775634765625), SC_(0.221111953258514404296875), SC_(2478893.429172905948896013319335438187829488814947364871828311654372186999831389771945089326822222008), SC_(2471015.667320199189676401927025725805586578776481471595433892268655481893646640249896944370324309837), SC_(26634.77014486736946359559412058466133942023525493848817876167154026241588731012764836610030135848447), SC_(26898.96225752623447145305510944157078585328144802836212860463195274052999049163991745675716698941848) }, 
      { SC_(261832), SC_(0.632396042346954345703125), SC_(0.12707412242889404296875), SC_(451697.5475303516217725143889204729449617550959117056049677987586067739619707083479340068394194993446), SC_(449172.9824580731447678123292938099907077591995543924064950186271649142167418360534930377881876832006), SC_(151640.8683059990454611479303231940671913975086056385600706824600808308415618150972913347688070164233), SC_(152759.7213697797079820071175257841139563290087992045782582164399792149137763555453651670550937829625) }, 
      { SC_(263861.90625), SC_(0.81474220752716064453125), SC_(0.1355634629726409912109375), SC_(1163189.025872030607167679269312251842795585781201367449552045484205494721048226813976563539421755402), SC_(1157680.564219582326618137322314053246817629046780880606298080712083086756770972548794054796260548865), SC_(59699.39427396414220587068539515616580440729803623597438781528606694729185716645964088427135658706248), SC_(60296.65571038371837830185771283718333484932690605794711744549928822007891031009033952442148617503092) }, 
      { SC_(276960.90625), SC_(0.9688708782196044921875), SC_(0.632396042346954345703125), SC_(8614566.375800805415908989350286209434347883312773472410357967030662793326643532260909203201947750669), SC_(8625822.435537026243615310880192057875290375677168197752334527418330864097757808101635080317163087208), SC_(8931.308905525455754799736235798861469612427846347587064475669415644813207540950850715788974705561087), SC_(8866.484812371488387899314323157447595495170888000014253481463485623920590603742826934888211211807169) }, 
      { SC_(279349.15625), SC_(0.632396042346954345703125), SC_(0.221111953258514404296875), SC_(481448.4518440565948681137878543502502203596595143133662073469313379650328906786241263642537431296636), SC_(479691.2179552938619269074086469408479359535385345853759374929155080633734068981535548028654577979679), SC_(161993.1529955977777074725788023539434000120927134948194886949498371412844435122554082745855054752543), SC_(162771.9352980793003877315969192164490917536557258868287418744811441942121769310743735087748139298372) }, 
      { SC_(282265.5), SC_(0.3082362115383148193359375), SC_(0.905801355838775634765625), SC_(125211.7805932034252774753657178636365220384618701522798585930019777362377721021952546165233796406228), SC_(126333.4864273390407232502435211144284273882471144713020000359785634264477079343646159502528825504791), SC_(635365.4402106566330235386034562157696911682269237750930928052313738659250769973127688335961017056331), SC_(631594.1466395817223846421117181747744937445247506707587725308191623885690452663007443216037115753017) }, 
      { SC_(291785.28125), SC_(0.1355634629726409912109375), SC_(0.8350250720977783203125), SC_(45534.96660765440362758601177992701983790609266298622336743590562602486080276112084385807318358430048), SC_(45983.25146871710328678097998468143491634043439198353282351570531623088717610245340757154077088469875), SC_(1864213.108741311215354541344373985389288948708650077422842312282575282984658913842306726812557323271), SC_(1856994.722806381606608180956873889775932980851348668918220387407090956542178587784280794645527031612) }, 
      { SC_(293941.34375), SC_(0.905801355838775634765625), SC_(0.12707412242889404296875), SC_(2832747.959224848166143631031677931150214894223179008512113187304690643878480986190241250874455214723), SC_(2820255.066010383675575499796485706672135479779607290234682063551815758196675904958993809923392799311), SC_(30359.4524766610336550715354556925956026957220976505167351907016807724918547000162506142038923700788), SC_(30778.41962105329733979076424976534058025754766717341884079905702211919636458734692833545460901598405) }, 
      { SC_(296495.6875), SC_(0.632396042346954345703125), SC_(0.9688708782196044921875), SC_(507873.2587340083938269249424266355474547841105725249822453109257416997145632293816835064878942264051), SC_(512265.6866232798258851194758049444652022589827089985819550232278438874161316992908846444962771348658), SC_(173323.9819039044453596629323430812812718290322399800764675781679714864803473671587235175571938154669), SC_(171377.3174644184670454647452242029054576022019216371796062642314349336692573036446568485486146610325) }, 
      { SC_(308021), SC_(0.905801355838775634765625), SC_(0.913384497165679931640625), SC_(2954254.747551480999324590981762621436413578554787570156142449927264548726709025966733101291165467725), SC_(2969528.137230925687551912216641148489900488822279914486053549944510666865334605598591928082285070844), SC_(32289.36641744920607200778535527307158156828817420678585677892308535464887704218332311455186905647384), SC_(31777.15140412893936442726289520925134490373595093450765021596119723019565585627853960782055128938878) }, 
      { SC_(308998.125), SC_(0.221111953258514404296875), SC_(0.913384497165679931640625), SC_(87262.55498473260819176138258587636801961776444960415535530268281027267990789738473031791929508239896), SC_(88176.63081646259915192475007802935608403590670261516811585884318024713963967858643965115302393570752), SC_(1091498.823235127579273023157190959709806756196671616653086127793259748674323841896416286437949589967), SC_(1085455.488433782355633106828547160496864312070448836375598658603234936499396746737302048471219611725) }, 
      { SC_(310161.75), SC_(0.8350250720977783203125), SC_(0.632396042346954345703125), SC_(1568847.673388556039613494183337025597370849688979221723202531817741719356670594645050530845689909551), SC_(1570934.262954429375087586724188506615425752385319627719752375962561808393163286231102803343812345106), SC_(61370.20742832602357704859623366560758414889485872763642474977081727727204627649068681892667897226325), SC_(61186.96986568450140317626753472574713341094613945653061259247756705282476911711531634162813819905281) }, 
      { SC_(312137.6875), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(1576878.970365746416694286229685446659873541900333670140112868108903335863155907151610317005989453528), SC_(1582908.583320214593273211608853231298979825449736172558787647806632150625851972415923291528601933858), SC_(61933.91693606407623196054019476561109907342265630407070191943874277570265350624221421412267834403994), SC_(61404.41586398241607560297433310173490129316273100522821591751836063141217453445838540886104013290133) }, 
      { SC_(316295.75), SC_(0.12707412242889404296875), SC_(0.221111953258514404296875), SC_(46220.90400529210620150897136647080422528553291151122463261087882455349840820256951723652970967208746), SC_(45867.93293440899164901743506522973242575434167441636115210576159645974322144943819841044175911130038), SC_(2169591.208886128302052484695751203087082101645213514084580077465618849792369163567800624559193449591), SC_(2175946.270732909907165359794716778895314928743576160824338666625250860886433843608205842999502598836) }, 
      { SC_(317554.375), SC_(0.221111953258514404296875), SC_(0.632396042346954345703125), SC_(90033.04060273467230905605319065414001746021325383083846860455475015180515354253059762217709408783856), SC_(90263.15888352355061321738038957081789169978608307063634799562724326016564280430674824674283709794463), SC_(1119375.736462412420923554505104383892750631615545554437761653515954969431999480851767479032917952163), SC_(1117854.329304232840712540734758740858229656103778392202793589023031823905720624761518304291744025866) }, 
      { SC_(317886.4375), SC_(0.221111953258514404296875), SC_(0.12707412242889404296875), SC_(90630.82443354701028807522828697754929575395012351151901693293681353526637308066598975227580307327418), SC_(89854.52766829629092682767728591666135664999960189912538791611289404425188736388690251133020049609434), SC_(1117220.135196560124442029283124304809357905708767331899869963678005540504371358797580036776211759508), SC_(1122352.554990593708430854648562942594580913961502052740447263387428345933768213462812811512502357135) }, 
      { SC_(321723.5), SC_(0.632396042346954345703125), SC_(0.3082362115383148193359375), SC_(554081.5345815403902082877244761858237751357905260840084510131026773105940639011036734933819904558671), SC_(552852.4027709140936416230835259308434869672796365177086220665985571991577469145901390406108376373183), SC_(186741.7336559851566403239203782226410809614576535342224972320122791547989686494252063988439898954125), SC_(187286.468272202516919868475786492264871297328228883354126379447703454399770903230482105437012647351) }, 
      { SC_(332899.65625), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(48730.32754251826879830553956066020858587915226490966369799790468934738582574416525028291655054922507), SC_(48192.9637591301135034863610981140121583621844762787005660188966277980529713495428599706805809011457), SC_(2281992.256784341901602782827074588837050962163846982757836419213369078182014078017672260966382513316), SC_(2291667.215578810334033920884968182532703896948661488892015779236954542358933456130371956039716811514) }, 
      { SC_(334436.8125), SC_(0.913384497165679931640625), SC_(0.632396042346954345703125), SC_(3524568.082528470676181247393437170874850815355423224630073326105177357475987894176764125298020989534), SC_(3528884.260529573008798321481127442847000177807618097717504274215894683237652927699558669493120389866), SC_(31777.7135921349086965329302743464601604163911534860576697395262939408862981977937532091814971773025), SC_(31651.67255381142332570718856212119178738178527013465969550079094646044397259248793209207776699429591) }, 
      { SC_(345572.71875), SC_(0.905801355838775634765625), SC_(0.9688708782196044921875), SC_(3311915.434437118035389009495063857237340312115973744898511944351669501877498900960664303594465635443), SC_(3334062.829675535655436152157399950978547794053967750511552211807320057961126204386837936997429525927), SC_(36310.14156055682209129791032315620320407474661924782117323674479421578147354264360440918767196645202), SC_(35567.39721779256874514082589242022685788043735227791225399723567313305619827016371503285086165529255) }, 
      { SC_(346211.125), SC_(0.913384497165679931640625), SC_(0.3082362115383148193359375), SC_(3654141.793919204403655661205256728142241957440300628141082731059101646371030520724430384909964128784), SC_(3647638.335075404317429590465118499304246355556741957528435133374997331846826100552307056828986259046), SC_(32736.31152462869372336881902388067142880163109079490329933368094812612616501240410087252461640885444), SC_(32926.22553779601002723222114818349052058721741836389935399858684148023420777147845265982712788234444) }, 
      { SC_(351158.5625), SC_(0.632396042346954345703125), SC_(0.913384497165679931640625), SC_(602359.9903241230222890344295450543738816497855916130211465949894836608221033545377580862469476139977), SC_(605851.7108319734397170084515456312135309963681938633425405004576931020533829124563886086041224327663), SC_(204898.6566054730005298914658559617725745700970030516376528675373070146858944610635348586868475096838), SC_(203351.1733149136882496804123086079935557800458596109300162068939862204311464333004548017559846177939) }, 
      { SC_(355726.78125), SC_(0.1355634629726409912109375), SC_(0.913384497165679931640625), SC_(55440.82921915017197465083996296448271754988227747041837504332409715916539882085302178395821504200151), SC_(56132.7710699567779689725449637710600164870011978837165054983358344306409921311989095091795577262597), SC_(2273907.471388275387755608087302583133561788028342946986353900067859844866888914376019490391315552378), SC_(2262765.663945573564692354193802400847630601049179129097784688737785611391441146638549948007102866955) }, 
      { SC_(358220.75), SC_(0.1355634629726409912109375), SC_(0.632396042346954345703125), SC_(56091.313247653561641695455703030259932188670787434400914737219052921114487246158484360069876791714), SC_(56263.74789148351516773025832715586215437395366640879574829839934075338591961016524267446947937807975), SC_(2285623.957280944594171390678882253940760051670866516603263650080804248558167997425315456849387897577), SC_(2282847.375877668156246186657191133270363547370955907011868023189259981816812437103437186287585113237) }, 
      { SC_(358924.59375), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(102170.4019312919894503834618387466999597419237968821230691300006437758947141510985188055573853921377), SC_(101614.5307882345306537662870202820788408181056673017577248435900030676705029618994987405810939552066), SC_(1262508.684682054152083147584206631197080420173051315117024616242383714815623593615703558807317707118), SC_(1266183.778858751988509967615086838122893847416317445818705554067240708768686919061079360526840996905) }, 
      { SC_(365052.03125), SC_(0.913384497165679931640625), SC_(0.81474220752716064453125), SC_(3843604.626440333861968920263367737813241993849038300591559421996640006275405054031257629750796115778), SC_(3855544.722969374682979777143209408666035393060939941482162083945667824899156251139928298611616027645), SC_(34792.38281555664201145460159180588707255975464719445774232409067770796933378217434599415371359382108), SC_(34443.70815672543740662161531034403501554508755136642570545106166276349027974639057390550991547842093) }, 
      { SC_(368572.4375), SC_(0.905801355838775634765625), SC_(0.632396042346954345703125), SC_(3542065.460260149411385270886084741307706916268417504480081622220062908906107060752292093192367729145), SC_(3546214.469516680883283470053127568488911782183896539823929176804429740337729327308907570782925933117), SC_(38399.5155835074088317071249514804110037334226039061858773903183552457884669390687462959627090949144), SC_(38260.37249760477013904757098205360288653431413888486725553565698698029975181911938448501444493496566) }, 
      { SC_(375118.4375), SC_(0.9688708782196044921875), SC_(0.8350250720977783203125), SC_(11656416.6360234852875487278228142980958881634879527015067015407743383106672200780063895076307730312), SC_(11694150.81018790682445109983431390984579720238410966332867625449163448846431059362241682170707525321), SC_(12161.43181686268692241000197960698453741446944119681644657106191957184070030312822179962139932315123), SC_(11944.1192363472566077536816013552527061809155775774540283937613984613057459804849492563740822674006) }, 
      { SC_(378506.53125), SC_(0.8350250720977783203125), SC_(0.12707412242889404296875), SC_(1919708.100485142557795799908885762925991788178026518816853197362795138532836647461619560354881283657), SC_(1911936.161015895098174256979990396123197210714941255264278179605529201134276962294326245316539776735), SC_(74440.40970981904715852378454862703503294222249752796752758888738833538118977930573966778512190560074), SC_(75122.91627978489219115922153786146222498399617581794801668597311773832263271299574401290245619122238) }, 
      { SC_(384877.0625), SC_(0.1355634629726409912109375), SC_(0.905801355838775634765625), SC_(60010.64080971663746323732083420095578865321449236646408366510806354560298926108087295548377879900594), SC_(60705.76941841389270002062961971523600119553646682702294336577956605406038546478739957944660765284426), SC_(2459813.075817912572146772192073738752465060654488888335638773873085909364597399239549772984287591304), SC_(2448619.955440930686947100183339089139090834469414874258319691729810802943269659597804468747457760763) }, 
      { SC_(388418.65625), SC_(0.221111953258514404296875), SC_(0.8350250720977783203125), SC_(109898.8285396631770619171160165523472036609787492231901122043988990909286049086344656297013300334291), SC_(110631.9324819272672273859985482291109656694473959329745132046387704078775734490651877267228077750225), SC_(1370665.801274758880587983631264261704591420639924597620488370856496192222479067322533907074464572922), SC_(1365818.94764615157152961221146653155607945140698345364852379175931800636495304103920739340747289743) }, 
      { SC_(394272.125), SC_(0.913384497165679931640625), SC_(0.1355634629726409912109375), SC_(4165334.607888850918822920011793465005251562626933917471278932922397731731829553085541136539177967975), SC_(4150085.737478205543804014503273503203130561557316542344283835930045288653755292794967256348040506247), SC_(37166.39541227051399406571339450287824492119078645050904982165640767804526445488066462736524326857898), SC_(37611.69284700221190722237697343787674598307233962002327423401202353196539299790225088436287745525046) }, 
      { SC_(396503.1875), SC_(0.905801355838775634765625), SC_(0.8350250720977783203125), SC_(3806523.100296438327446410684172772017718591821538959222253048174638610906055333548515287065490584753), SC_(3818919.048261108753055187252055998493454733654588059586855730332939465168553751743408124541931126592), SC_(41442.62333367288095028583966949178938823840108502791050816958617992365148331549867691653215392476267), SC_(41026.90719728913382755006468754845240971605407304321540204213544050243917923981018486134854815671988) }, 
      { SC_(398707.3125), SC_(0.12707412242889404296875), SC_(0.9688708782196044921875), SC_(57561.14731123631954040174691615980821869361971868350069170158066900820084788703028307221364410428346), SC_(58522.66861761582917467626701801603920895302547361088647082448857998042827379047023731829719192800156), SC_(2747551.548465486890836619679363710231524419820798007315309169395637143316712420256622179736780666364), SC_(2730239.845931648849818872543304302710242997924864241367346228242036303649657465666815223288938760236) }, 
      { SC_(401973.28125), SC_(0.9688708782196044921875), SC_(0.12707412242889404296875), SC_(12533985.58356930637465293251299489251466597293419745943433258661694200900655926905644279539555849902), SC_(12488263.5436539747416231523492022903689282612877723723167974925528872784191652492146121151460433124), SC_(12784.00708651220608115965288668810259209737905464060891806992311458898317426475469954850927124719016), SC_(13047.32205893441203067945408636963253437025550482249478832846799523816890240631411968166666632006088) }, 
      { SC_(403804.59375), SC_(0.81474220752716064453125), SC_(0.3082362115383148193359375), SC_(1777435.592903042182700197909787055518160996660563589394656374684781627936897121238596382253413773417), SC_(1774334.162909186862459437099410433108374088323048806859015082938597960781843676472685324672096024801), SC_(91650.11591624354787918842363217289844830211659392381360319333642553942787609611846726963010589962663), SC_(91986.39222182400007538726436351366267917251676963768415364529656626243962094824568893291121189489404) }, 
      { SC_(403959.59375), SC_(0.221111953258514404296875), SC_(0.1355634629726409912109375), SC_(115099.4929883859061786209975652795880795706854752319434061105734681299001653083167308694144331626131), SC_(114254.9760630674768191385269400626279449166633665079224011327223610294316745029570127871302317425694), SC_(1420195.441951416095516902363204077512664018024772210898654630652772412110228516010881042456811390486), SC_(1425778.893004168714038503841633163342227368041411695055870206981866020638784589296605307994850963072) }, 
      { SC_(405401.84375), SC_(0.632396042346954345703125), SC_(0.8350250720977783203125), SC_(696079.0488843015737452879182628757026130501564215373192009054579186063928136188028488445986637898546), SC_(698762.7974159608975819510449511372455540197597446737302988820402878269357574189652838471844382138037), SC_(236250.2341340432757729292000563420607817379022192453289454390440631324054427761147449349406046505737), SC_(235060.833039027409607458696841802209561589200596743952973291487543699934854658527004681940772299965) }, 
      { SC_(406948), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(181584.6425335446066115914249349549068358508185884516639660650175256843973559317479817145071040333459), SC_(181071.7856994489816650095973349629583225987488373491957115682545792971280211001761203470850140042408), SC_(912436.8909077809737432593088055301801669011979098087394858694193766092251408123922904750245147249777), SC_(914161.169529094990826246448946882583665803959032683547157871854242488330085627877570551917970022083) }, 
      { SC_(408714.375), SC_(0.81474220752716064453125), SC_(0.905801355838775634765625), SC_(1793382.808426413188927536578800593929967685298497215835461408368951803206496315555430815367766385682), SC_(1801577.070404655433280929566569081879172308620979657248249219780220698349264357843039279753414157698), SC_(93379.2454055821292752574016554827796146481782264701309453148786632000918842408819278373809103465414), SC_(92490.77277552127937840582717677107405538412488524870800061215531873948378440856188150966066027950148) }, 
      { SC_(408792.15625), SC_(0.81474220752716064453125), SC_(0.12707412242889404296875), SC_(1801373.66132175467832137104131971580273949781039258568872587215712564757699088201506092461675156164), SC_(1794268.96003102956724183638390190262875543490209128736773883666139285355179623470228563783262661808), SC_(92567.42308026508000435160706158059896344288258518085293166542929213367859091272993817128994228073659), SC_(93337.75883292126282308647530136656656176203103260139582288264183672411977043725839388324453717840386) }, 
      { SC_(432827.1875), SC_(0.221111953258514404296875), SC_(0.9688708782196044921875), SC_(122132.2797180468269275184806619553690906973583290750637763799135634119473145307325412606130922038921), SC_(123613.3281274628820648807712656406984001209880624117847176611009552969241896066055311446348754754715), SC_(1529574.983366214178393826620501215468627441772206445378945132220564382028053353063765028597599751922), SC_(1519783.157411033740577375127077593384257529197984651009955866894101676696503870820150983398741221697) }, 
      { SC_(433848.65625), SC_(0.8350250720977783203125), SC_(0.3082362115383148193359375), SC_(2197763.167982774743157488500835524133379230387517648534142427458110431323825435058097669839129081526), SC_(2194108.535707877848932375847575327408618589009719163624025802017481325560251407515673659671178213006), SC_(85554.82891792285130733217521034078612469375569378320836203115041493029855518595050817645800586969061), SC_(85875.76696194156447798584081659556002945608773676571535346933173112358550679540016685079716261765417) }, 
      { SC_(435303.96875), SC_(0.632396042346954345703125), SC_(0.1355634629726409912109375), SC_(750432.9935745530291548958581990736507495841323320107040789305017574728620162686917398947809384660427), SC_(747291.6230527108973954899557700426353050762020843514064452123797018082597728623307942518625116467402), SC_(252341.2550373633193785483907881377647372070700189902846995528046337924204145509462836390499909194006), SC_(253733.4680147803546979902040977118001568590059833385210343596772685918362843428637392999811502481556) }, 
      { SC_(437035.75), SC_(0.905801355838775634765625), SC_(0.1355634629726409912109375), SC_(4209827.931043624852220519537949412485010145736660499656475382647245920324487295693404372377653505472), SC_(4195127.205128112153652220813810721203440176037708746628269788526716780331272568068079790186739926963), SC_(45203.48921901838550576423751326271846637814980023825387384148010826704314267319921333207525130766991), SC_(45696.49944008680448185396398176431549681648587048657303327296834124950726938015292840866222071258737) }, 
      { SC_(437942.5), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(68990.15639068233795140590107730208352609742140150144831666746936335760245751973528520792249840012462), SC_(68369.78039815602113315416945807005125070153470406420533500177692336727965502694107788492827182977615), SC_(2787598.678894941073378843964515816821850304500862057788763854820767769644038876026552796156691573196), SC_(2797588.113694340018913742627594507445171030494627970176493469817100173161269938876695287565209439482) }, 
      { SC_(438464.6875), SC_(0.8350250720977783203125), SC_(0.1355634629726409912109375), SC_(2223338.044912987936475940295874189732295642371789392760096263916912761938024317766691971328718270096), SC_(2215265.553560989282538690162415779758128613019056704343901656876639657210396643920184748454831859803), SC_(86273.0550442960744629975989111233338250388556612939763488942071623209566814200836729682529918853192), SC_(86981.95516550206446460279269070127145314967438333676499337900809878568863551973518051166075249626345) }, 
      { SC_(442826.46875), SC_(0.12707412242889404296875), SC_(0.81474220752716064453125), SC_(64220.52123727686412772083291494428044503394834468397496541028758365571376222939501515299329019898606), SC_(64707.22763031229934428593603120980179998788862466100788896391577059765303131067167486838428452704166), SC_(3046343.715065845077854001163177997153729320145001161653770104266746456135277318795507669646536041623), SC_(3037580.81916373654114723975501711757767412568439943641582123414790598065532904749522900783990005693) }, 
      { SC_(444455.90625), SC_(0.8350250720977783203125), SC_(0.913384497165679931640625), SC_(2244598.615938371033696324056534336644121299576168690028505985276536634401629429955656423593562113675), SC_(2254656.801650994202881716472100139702080360588304592135313670593357739541123899443461454002715936083), SC_(88252.97153270402210024148568731464439353087969254980122792280750562320836557638811178935948670162), SC_(87369.69421479324978949378422290555317890407874358782578533391775032292925987731632272873316208837119) }, 
      { SC_(444787.5), SC_(0.3082362115383148193359375), SC_(0.81474220752716064453125), SC_(197709.5934359073641131507881276432404786019544584082153717812638337581749766345780086005392317002321), SC_(198668.2422420257082204876948613416059110626505691269749150555301634979900987830468440543026958174391), SC_(999832.9446635864547197253597936625232167091650862667347669846661495124634300890408636721178392580368), SC_(996609.8664928164750155069790992235633340893788583985190840616640940007517187997698141198643034122365) }, 
      { SC_(447784.125), SC_(0.905801355838775634765625), SC_(0.3082362115383148193359375), SC_(4309215.492501671925809832514318376984464865533985073180745237127437173031662507149488131990466382121), SC_(4302442.993796975461951818475657533432163014312795733466958314311460147985984586787016273725730126812), SC_(46454.01345314769379131891472489178239197720010843570996805398450530856087914723922026517728261068004), SC_(46681.13910932863514692673356251657298788786211149127194108456212408192478529014875518269720403989473) }, 
      { SC_(447976.40625), SC_(0.12707412242889404296875), SC_(0.632396042346954345703125), SC_(65120.97649742027261635798513850769877013435252223655251562328807365809347684518801175854233446230617), SC_(65305.8564311068669144896497768007874610303496876016522873232441124263575099188323450965313451394283), SC_(3079002.009777455847614095833427016491775436928079602959037554706864401189117120976234121602271559739), SC_(3075673.343007852414765473783587634909885248447311793172436329302049106864266224074483562352620124036) }, 
      { SC_(448846.15625), SC_(0.9688708782196044921875), SC_(0.905801355838775634765625), SC_(13942148.14815611659064722112747818128627692558477209845530274937530403703010314738619713308434710383), SC_(13997877.13137363238891165544798253008428157956288687495976169844140682358130508342293587223794208822), SC_(14582.20509558332364458183492591473653375236960659867288176623116326823028248461128186433315865346464), SC_(14261.25976832042826122812485513044218145263768128533306080932256002127144716956873137761320234726799) }, 
      { SC_(467754.28125), SC_(0.9688708782196044921875), SC_(0.1355634629726409912109375), SC_(14582307.27749050806862514534441144029293736814556627825608323590943974657212073974512771840178001964), SC_(14534709.85379777204144202250848456557271434486494359952219887901749931232339169351948582272785520112), SC_(14892.0869980069314749260353980304174964844718061074818482931435407581107499244785056336160375827793), SC_(15166.20253163388900385334372720029740009082048553955730836477017740142502713368416445237970556885013) }, 
      { SC_(473141.4375), SC_(0.81474220752716064453125), SC_(0.221111953258514404296875), SC_(2083396.177078763261310247756210796709050986068912986314606144732424519707190749275957193786929212863), SC_(2078245.423957970390429173580046940301627576838628045485422158201767188767913815871568210851554479025), SC_(107305.0550947709258110643640197054815587384906300543600549141575195933780408202908438136093287591433), SC_(107863.5317465997746516385261209267501517088116598822296362271288937537024663332026184699882279661038) }, 
      { SC_(475931.78125), SC_(0.1355634629726409912109375), SC_(0.221111953258514404296875), SC_(74863.22159423657178639135843064319186867849712135432679140745009910166430025378444104631149358051552), SC_(74411.62359846101533194367027997650975048798856694024723181729993473406725909453910573442714644750971), SC_(3031199.27574924233997859053704277970442582820164378907041604417813349570600051850022942680116940976), SC_(3038471.007954823489719352635939274579304822773919251533092003024823266976921005941089319124285500496) }, 
      { SC_(480505.75), SC_(0.913384497165679931640625), SC_(0.905801355838775634765625), SC_(5057009.137883346991297280272316655884843512474132092967659893246907363070814150415616505779213755808), SC_(5077130.008669136984101475927154584113851934847615921791753015711169641012846352004783223552006266754), SC_(45860.39578823761216780930027528343441271409993632576700986556608110936794777922189190471234767214715), SC_(45272.82619384517959483726844004670545212496499292353295676138585412022031957970747357936964957150843) }, 
      { SC_(481037.90625), SC_(0.3082362115383148193359375), SC_(0.1355634629726409912109375), SC_(214954.0730415459324272322098059261658344195921911048215227103731874995082410590810383910277671282622), SC_(213728.9433236639020931731891795221242722212174046095998104798208675703012870270153304541107798144009), SC_(1077517.795801841403487141321214750115179387272101781637533476788045360859794269288938283235224199637), SC_(1081636.810871830922880032963090014830142863695032235420818616239563778235210349598024972698342430219) }, 
      { SC_(485980.90625), SC_(0.1355634629726409912109375), SC_(0.81474220752716064453125), SC_(75947.50287755040088992558685298601037560620447249457062259186705941456229777606961809318551961112457), SC_(76479.30117347133042069077426985013802863207922409730304956347781449509840371152867686698312667407036), SC_(3103196.634482552348526388073690399281667050881158209209257160529514613456386016945448500178200416261), SC_(3094633.498847298449800834614348937260696174622946733336073730690861985736659159836937933593087681597) }, 
      { SC_(489096.34375), SC_(0.81474220752716064453125), SC_(0.632396042346954345703125), SC_(2149835.420432935738571504824669405535112026843128171823218720145168010286191521063636486128819640379), SC_(2152140.267058834375526429568585141743365314468040624002321395548815791537567896033314059219767174233), SC_(111336.990938262038284792110970236277584339209153903880265239957333478239591138095337997321244983344), SC_(111087.0851343228376540732483260823293660124553023808030297399680696356784984406728076454354233386814) }, 
      { SC_(490224.65625), SC_(0.8350250720977783203125), SC_(0.9688708782196044921875), SC_(2474059.781112585100225923474277388945644841132414541483235018154724374112161333898186161710511319547), SC_(2488521.187172101754693537105176727049011115863706614369301342646676606307103207412127159070864309253), SC_(97489.16520339287822299971952377074411630970076546169823169145986944645114749814051528899672166177443), SC_(96219.21150955986998802274923363974940278386581612184471409847771598317921003666209856647350389402225) }, 
      { SC_(492616.1875), SC_(0.81474220752716064453125), SC_(0.9688708782196044921875), SC_(2160097.330587066231445009615179450496605337977400732745848956148755035070499897025280043407966765649), SC_(2172849.060248862788069481343937878596794903922837153025629325486461452111332884974573767684987699383), SC_(112704.513279915547893306409021394612149255526474732330209037454571458216341356862770454420824870536), SC_(111321.8919149126350976334581215168831576517722380867094186255880986306392649715612321977436708934672) }, 
      { SC_(493067.15625), SC_(0.1355634629726409912109375), SC_(0.9688708782196044921875), SC_(76767.64922907893070937377260795058987611362823891825524085896234884328550113407276897167228036558757), SC_(77882.89867960827431192138690174915177255321134308258910288268085009341055734572331426861469361693711), SC_(3153086.514367219226967064126240311772170736384107525381665234442715424152190338059638973443194990823), SC_(3135128.509847232411063129274533589230908159139891303513987728335691375301577612946664126754477170654) }, 
      { SC_(497097), SC_(0.12707412242889404296875), SC_(0.1355634629726409912109375), SC_(72681.11415387065674957690132016868169191955575858086107661197432136383823238646114474079457781392721), SC_(72047.41954020240893325737182119598226364424389984420063381611270985375436608408806330762383061821211), SC_(3409065.827055807531678961859073645657230358185950103860885952543964343334592856668738573506077026751), SC_(3420475.169677388105656745142209467687699219296898877898752790493449083963329175908034795593158414778) }, 
      { SC_(497481.8125), SC_(0.3082362115383148193359375), SC_(0.12707412242889404296875), SC_(222314.1253130015627660072636473322752712891751839119915721545837501534862620518004663188386017641378), SC_(221023.1037330142642378955151286775664560624517786400554218612145985519782410506686001446831861587568), SC_(1114311.595597452012343496149547782092708841542094172969811686130629128619077973244337814566303316361), SC_(1118652.146040181182739176928249543706836426766938346914879802716806902165572254306413904435006003401) }
   } };
#undef SC_

