// Copyright 2014 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/cxfa_localemgr.h"

#include <time.h>

#include <memory>
#include <utility>

#include "core/fpdfapi/cpdf_modulemgr.h"
#include "core/fxcodec/codec/ccodec_flatemodule.h"
#include "core/fxcodec/fx_codec.h"
#include "fxjs/xfa/cjx_object.h"
#include "third_party/base/ptr_util.h"
#include "xfa/fxfa/parser/cxfa_acrobat.h"
#include "xfa/fxfa/parser/cxfa_common.h"
#include "xfa/fxfa/parser/cxfa_locale.h"
#include "xfa/fxfa/parser/cxfa_node.h"
#include "xfa/fxfa/parser/cxfa_nodelocale.h"
#include "xfa/fxfa/parser/cxfa_present.h"
#include "xfa/fxfa/parser/cxfa_xmllocale.h"
#include "xfa/fxfa/parser/xfa_utils.h"

#define FX_LANG_zh_HK 0x0c04
#define FX_LANG_zh_CN 0x0804
#define FX_LANG_zh_TW 0x0404
#define FX_LANG_nl_NL 0x0413
#define FX_LANG_en_GB 0x0809
#define FX_LANG_en_US 0x0409
#define FX_LANG_fr_FR 0x040c
#define FX_LANG_de_DE 0x0407
#define FX_LANG_it_IT 0x0410
#define FX_LANG_ja_JP 0x0411
#define FX_LANG_ko_KR 0x0412
#define FX_LANG_pt_BR 0x0416
#define FX_LANG_ru_RU 0x0419
#define FX_LANG_es_LA 0x080a
#define FX_LANG_es_ES 0x0c0a

namespace {

// These arrays are the hex encoded XML strings which define the locale.
// <locale name="en_US" desc="English(America)">
//   <calendarSymbols name="gregorian">
//     <monthNames>
//       <month>January</month>
//       <month>February</month>
//   ...
const uint8_t g_enUS_Locale[] = {
    0x78, 0x9C, 0x95, 0x56, 0xD1, 0x6E, 0x9B, 0x30, 0x14, 0x7D, 0x9F, 0xB4,
    0x7F, 0x40, 0xD6, 0x2A, 0xB5, 0x52, 0x56, 0x6F, 0x8F, 0xA9, 0x88, 0xA5,
    0x6C, 0x24, 0x9B, 0x3A, 0xD1, 0x55, 0x22, 0x55, 0xB5, 0xBE, 0x4C, 0x0E,
    0xDC, 0x05, 0x34, 0xB0, 0x23, 0x83, 0x37, 0x05, 0xED, 0xE3, 0x67, 0x07,
    0xC3, 0xC0, 0xF6, 0x24, 0xC2, 0x4B, 0x7C, 0xCF, 0x3D, 0xE7, 0xE6, 0xDE,
    0x63, 0x30, 0x84, 0x25, 0x4F, 0x69, 0x09, 0x01, 0xA3, 0x15, 0xAC, 0x10,
    0xB0, 0xEF, 0x4F, 0x09, 0x0A, 0x32, 0xA8, 0xD3, 0x15, 0xDA, 0xB0, 0x43,
    0x59, 0xD4, 0xF9, 0xF5, 0xBA, 0x02, 0x51, 0xA4, 0xF4, 0x06, 0x91, 0x50,
    0x53, 0x59, 0x46, 0x45, 0x72, 0xAA, 0xF6, 0xBC, 0xAC, 0x8D, 0xEA, 0x20,
    0xE0, 0xC0, 0x45, 0x41, 0x99, 0x62, 0x54, 0x9C, 0x35, 0xF9, 0x83, 0x82,
    0x6B, 0xB3, 0x26, 0xF7, 0x94, 0x49, 0x2A, 0x4E, 0x21, 0xEE, 0xC2, 0xD7,
    0xAF, 0x0C, 0xBE, 0x85, 0xBD, 0xF0, 0x26, 0x62, 0x2A, 0xD2, 0xDC, 0x41,
    0xD7, 0x47, 0x51, 0x94, 0x1E, 0xAE, 0xAB, 0xBF, 0x97, 0x0C, 0x3C, 0x60,
    0xE9, 0x32, 0xD7, 0xF2, 0x20, 0xEB, 0xC6, 0x81, 0x13, 0x38, 0x36, 0x50,
    0xED, 0x41, 0x38, 0x99, 0xAF, 0x69, 0xC3, 0x7D, 0xF8, 0x03, 0xFF, 0xE5,
    0x17, 0x44, 0x90, 0xDA, 0x09, 0x3C, 0xB2, 0xA8, 0xE7, 0x9D, 0xA3, 0x80,
    0xEE, 0xF7, 0x62, 0x85, 0xDE, 0xA3, 0x91, 0x73, 0x3E, 0xD7, 0x7C, 0x86,
    0xF9, 0xEC, 0x9A, 0x6B, 0x96, 0xCF, 0x2B, 0x9F, 0x55, 0x3E, 0x9F, 0x7C,
    0x0E, 0xF9, 0xDC, 0xF1, 0x19, 0xF3, 0x7F, 0x4F, 0x32, 0x7A, 0x32, 0xB7,
    0x90, 0x5A, 0x91, 0x44, 0xAA, 0x5B, 0x4E, 0x75, 0xAE, 0xD7, 0x5D, 0x92,
    0xC4, 0xDC, 0x81, 0x76, 0x12, 0x6A, 0x1B, 0x7B, 0x86, 0x8C, 0xB9, 0xE8,
    0x2E, 0x97, 0xC2, 0x01, 0xB7, 0xA2, 0xB0, 0xA1, 0x84, 0x36, 0x52, 0x8C,
    0x41, 0x3C, 0xF4, 0x35, 0xEA, 0x71, 0xB4, 0x6B, 0xA6, 0x59, 0xBB, 0x53,
    0xBB, 0x4D, 0xBB, 0x45, 0xBB, 0x39, 0xBB, 0x2F, 0xBB, 0x29, 0x7F, 0x3F,
    0xFA, 0x21, 0xCD, 0x0A, 0xA8, 0xFA, 0x67, 0xCF, 0x84, 0x64, 0x1D, 0x2B,
    0x77, 0xFB, 0x60, 0xC4, 0x23, 0x8F, 0x56, 0x02, 0x4F, 0x2B, 0x28, 0x04,
    0x04, 0x35, 0xD5, 0xD4, 0x8A, 0x7C, 0xF8, 0x18, 0x62, 0xFD, 0xDB, 0x25,
    0xC8, 0x3A, 0x1A, 0x42, 0x3C, 0x10, 0x75, 0x60, 0x9D, 0x11, 0x5D, 0xE3,
    0x0D, 0x3C, 0xD2, 0xA6, 0x01, 0xC1, 0xCE, 0x7B, 0x3A, 0x44, 0xE6, 0x00,
    0xF9, 0x21, 0xCB, 0x12, 0x91, 0x8D, 0xBA, 0x16, 0x41, 0xAC, 0xAE, 0x20,
    0x5A, 0x04, 0xDF, 0xD4, 0xA5, 0x27, 0x1C, 0xB8, 0x56, 0x21, 0x23, 0x2D,
    0x39, 0x3B, 0x20, 0x72, 0xA1, 0xA8, 0x82, 0xEC, 0xAC, 0xB9, 0x40, 0x52,
    0xE7, 0x5C, 0x34, 0x4A, 0x84, 0x23, 0xEC, 0xE1, 0xE3, 0xC9, 0x84, 0x0A,
    0x68, 0x8A, 0x6A, 0x34, 0xF1, 0x28, 0x9A, 0x4C, 0x9C, 0xDF, 0xC5, 0xF1,
    0x5D, 0x92, 0x04, 0xEB, 0xE0, 0x25, 0xC4, 0x23, 0x92, 0x55, 0x61, 0x32,
    0xEA, 0x65, 0x9A, 0xF3, 0xA4, 0x83, 0x64, 0x86, 0xC0, 0xCC, 0xA9, 0x25,
    0x1E, 0x3E, 0x9E, 0xCC, 0x65, 0x8C, 0xDA, 0x29, 0xAC, 0xDF, 0xEC, 0x4F,
    0xA7, 0x38, 0xFB, 0xF9, 0xB9, 0xAA, 0x93, 0x4D, 0xB4, 0xFD, 0xFD, 0x4C,
    0xF3, 0x2F, 0xED, 0x4B, 0x67, 0xCE, 0x98, 0xA4, 0x74, 0x4C, 0xEA, 0x53,
    0xF1, 0x9F, 0x43, 0x93, 0xD8, 0xB4, 0xA2, 0x30, 0xFD, 0xE2, 0x41, 0xA4,
    0x5D, 0xB4, 0xED, 0xF2, 0xB6, 0x6D, 0xDB, 0x10, 0x4F, 0x78, 0x4E, 0x21,
    0x23, 0x4C, 0xA5, 0x10, 0xC0, 0xD2, 0x13, 0x22, 0x6F, 0x3A, 0xE9, 0x72,
    0xF9, 0xE7, 0x7A, 0x58, 0xDE, 0xCC, 0xAC, 0x72, 0x04, 0x91, 0x02, 0x6B,
    0xCC, 0xDF, 0x5F, 0x79, 0x54, 0xD8, 0x9A, 0x62, 0x28, 0xD4, 0x0F, 0x3A,
    0x09, 0x4D, 0xD9, 0x0C, 0xD2, 0xA2, 0xA2, 0x6A, 0xF3, 0x6F, 0x7B, 0x7D,
    0x97, 0xB6, 0xD5, 0xC3, 0xBB, 0x95, 0xCB, 0x63, 0xA1, 0x37, 0x7E, 0x31,
    0x8B, 0x3F, 0x74, 0x7D, 0x35, 0x8B, 0x5E, 0x15, 0x4C, 0xD6, 0x88, 0xBC,
    0x9D, 0x45, 0x6E, 0x41, 0x70, 0x44, 0xDE, 0xB9, 0x5C, 0x3C, 0x1D, 0x5B,
    0x21, 0xFD, 0x16, 0x0C, 0x4E, 0x4C, 0x81, 0xFE, 0x66, 0x3B, 0x07, 0x6A,
    0x9B, 0xD4, 0xA9, 0x31, 0xC9, 0xBB, 0x25, 0x8C, 0xA2, 0xA8, 0xB9, 0x5E,
    0x20, 0xF2, 0x94, 0x44, 0xB3, 0x45, 0x63, 0xCB, 0x5D, 0x09, 0xB6, 0x7B,
    0xD5, 0x58, 0xF7, 0x55, 0xA4, 0x96, 0x7F, 0x01, 0x75, 0x37, 0x1B, 0x8B,
};
const uint8_t g_enGB_Locale[] = {
    0x78, 0x9C, 0x95, 0x56, 0xD1, 0x6E, 0xD3, 0x30, 0x14, 0x7D, 0x47, 0xE2,
    0x1F, 0xA2, 0x88, 0x49, 0x20, 0x6D, 0x33, 0x3C, 0x6E, 0xEA, 0x2C, 0x75,
    0xEB, 0xD6, 0x32, 0xC8, 0xA8, 0x48, 0xC5, 0xC4, 0x5E, 0x90, 0x9B, 0x78,
    0x8D, 0x59, 0x62, 0x57, 0x4E, 0xCC, 0x94, 0xFC, 0x02, 0x9F, 0xC0, 0x23,
    0xCF, 0x08, 0xF1, 0x01, 0xBC, 0xF0, 0x2F, 0x48, 0xFB, 0x0C, 0x6E, 0x1A,
    0x27, 0x4B, 0x1C, 0xAF, 0x64, 0x79, 0x89, 0xEF, 0xB9, 0xE7, 0xDC, 0xDE,
    0x7B, 0x9C, 0xB8, 0x19, 0xC5, 0x22, 0x20, 0x31, 0x75, 0x38, 0x49, 0xE8,
    0x91, 0x4B, 0xF9, 0xA7, 0xE9, 0xB1, 0xEB, 0x84, 0x34, 0x0D, 0x8E, 0xDC,
    0xBB, 0xAF, 0xBF, 0xEE, 0x7E, 0xFE, 0x78, 0x0E, 0xB7, 0xBF, 0xDF, 0x7E,
    0xBF, 0x70, 0xF1, 0xA8, 0x24, 0xF2, 0x90, 0x48, 0x3F, 0x4F, 0x96, 0x22,
    0x4E, 0xB5, 0x66, 0x25, 0xE9, 0x4A, 0x48, 0x46, 0x38, 0x30, 0x12, 0xC1,
    0xB3, 0xE8, 0x02, 0xE0, 0x54, 0xAF, 0xF1, 0x39, 0xE1, 0x8A, 0xC8, 0x7C,
    0x84, 0xAA, 0xF0, 0xE9, 0x13, 0x8D, 0x9F, 0xD1, 0xA5, 0xB4, 0x26, 0x3C,
    0x22, 0x83, 0xA8, 0x87, 0x8E, 0xD7, 0x92, 0xC5, 0x16, 0x6E, 0x5F, 0x7F,
    0xAE, 0x38, 0xB5, 0x80, 0x71, 0x9F, 0x39, 0x56, 0x2B, 0x95, 0x66, 0x3D,
    0xD8, 0xA7, 0xEB, 0x8C, 0x26, 0x4B, 0x2A, 0x7B, 0x99, 0x77, 0x41, 0x26,
    0x6C, 0xF8, 0x85, 0xF8, 0x62, 0x17, 0x4C, 0x68, 0x60, 0x26, 0x50, 0xCB,
    0xA2, 0x9A, 0xB7, 0x89, 0x1C, 0xB2, 0x5C, 0xCA, 0x23, 0xF7, 0x95, 0xDB,
    0x72, 0xCE, 0xE6, 0x9A, 0xCD, 0x30, 0x9B, 0x5D, 0x43, 0xCD, 0xB2, 0x79,
    0x65, 0xB3, 0xCA, 0xE6, 0x93, 0xCD, 0x21, 0x9B, 0x3B, 0x36, 0x63, 0x1E,
    0xF6, 0x24, 0x24, 0xB9, 0x7E, 0x84, 0x60, 0x85, 0x7D, 0x05, 0x8F, 0x1C,
    0x74, 0x5E, 0xAE, 0xAB, 0x24, 0xF6, 0x44, 0x0F, 0x5A, 0x28, 0x9A, 0x9A,
    0xD8, 0x25, 0x0D, 0x79, 0x1F, 0x5D, 0x44, 0x4A, 0xF6, 0xC0, 0x33, 0xC9,
    0x4C, 0xC8, 0x27, 0x99, 0x92, 0x6D, 0x10, 0x35, 0x7D, 0xB5, 0x7A, 0x6C,
    0xED, 0x9A, 0x6E, 0xD6, 0xEC, 0xD4, 0x6C, 0xD3, 0x6C, 0xD1, 0x6C, 0xCE,
    0xEC, 0xCB, 0x6C, 0xCA, 0xDE, 0x4F, 0x42, 0x61, 0x02, 0x46, 0x93, 0xFA,
    0xDD, 0xD3, 0x21, 0x1E, 0x7B, 0xE0, 0x6E, 0x1D, 0xB4, 0x78, 0x78, 0x6E,
    0x24, 0x50, 0xB7, 0x02, 0x20, 0x54, 0x12, 0x5D, 0x0D, 0x56, 0xF8, 0xF8,
    0x64, 0x84, 0xCA, 0x7B, 0x95, 0xC0, 0xE3, 0x49, 0x13, 0xA2, 0x86, 0x58,
    0x06, 0xC6, 0x19, 0x51, 0x35, 0x9E, 0xD1, 0x39, 0xC9, 0x32, 0x2A, 0xF9,
    0x66, 0x4F, 0x9B, 0x48, 0x1F, 0x20, 0xD7, 0x2A, 0x8E, 0x5D, 0x7C, 0x0A,
    0xD7, 0xAE, 0x33, 0x71, 0x3C, 0xB8, 0x9C, 0x8F, 0x70, 0x95, 0x03, 0x36,
    0x54, 0xA3, 0x8E, 0x56, 0xC6, 0x82, 0xAF, 0x5C, 0xFC, 0x38, 0x4D, 0x42,
    0x43, 0x2D, 0x19, 0xAA, 0x48, 0x23, 0x21, 0x33, 0xD0, 0x4C, 0x90, 0xE7,
    0x21, 0xAB, 0x06, 0x75, 0x46, 0x04, 0x20, 0x63, 0x49, 0x6B, 0xE4, 0x56,
    0xD4, 0x19, 0x79, 0x36, 0x3B, 0xF4, 0xBC, 0x43, 0xDF, 0x77, 0xAE, 0x46,
    0xA8, 0xC5, 0x31, 0x0A, 0x74, 0x66, 0x7D, 0x94, 0x64, 0x33, 0x6A, 0xAD,
    0x18, 0xC0, 0xD7, 0x83, 0x6E, 0x14, 0x3D, 0x3A, 0xEA, 0xCC, 0xA4, 0x8D,
    0x5A, 0x00, 0x56, 0xEF, 0xF4, 0x34, 0xF7, 0xC2, 0x9B, 0x59, 0x92, 0xFA,
    0xA7, 0x93, 0xB3, 0xDB, 0x4B, 0x12, 0xBD, 0x29, 0xAE, 0x2A, 0x63, 0xDA,
    0x24, 0xD0, 0x71, 0x55, 0x1E, 0x89, 0xF7, 0xEE, 0x74, 0x62, 0xDD, 0x09,
    0x60, 0xF0, 0x38, 0x06, 0x2E, 0x2E, 0x76, 0x8B, 0xE2, 0x60, 0xBF, 0x28,
    0x8A, 0x11, 0xEA, 0xF0, 0x7A, 0x85, 0xB4, 0x30, 0x50, 0x52, 0x52, 0x1E,
    0xE4, 0x2E, 0x7E, 0x56, 0x49, 0x0F, 0x0E, 0x06, 0x2A, 0xD7, 0x54, 0x06,
    0x94, 0x67, 0xFA, 0x27, 0x77, 0x2C, 0x2A, 0x64, 0x74, 0xDE, 0x14, 0xAA,
    0x87, 0xEB, 0x84, 0xBA, 0x6C, 0x48, 0x03, 0x96, 0x10, 0xD8, 0xEC, 0xFD,
    0x5A, 0x5F, 0xA5, 0x4D, 0x75, 0xF3, 0x67, 0x2A, 0xD4, 0x9A, 0x95, 0x3B,
    0xBD, 0x3B, 0x88, 0xDF, 0x74, 0xBD, 0x33, 0x88, 0x9E, 0x30, 0xAE, 0x52,
    0x17, 0xEF, 0x0D, 0x22, 0x17, 0x54, 0x0A, 0x17, 0xBF, 0xEC, 0x73, 0x51,
    0x77, 0x6C, 0x40, 0x6A, 0xDB, 0x1B, 0x27, 0xBA, 0x40, 0xFD, 0x7C, 0x6D,
    0x02, 0x17, 0xFF, 0xF9, 0x0E, 0xE7, 0x44, 0x87, 0xD0, 0xAF, 0xA1, 0x25,
    0x2C, 0x15, 0xE5, 0xC2, 0xC5, 0xD3, 0xE3, 0xF9, 0x60, 0x51, 0xDB, 0xF3,
    0xBE, 0x04, 0x99, 0xCD, 0x96, 0xEF, 0x42, 0xBE, 0xA6, 0xD7, 0x24, 0x28,
    0x0F, 0xBB, 0x7A, 0xA9, 0x6B, 0x79, 0x39, 0x7C, 0xDA, 0x84, 0xCE, 0x1C,
    0xAC, 0x40, 0x6D, 0x66, 0x9D, 0x66, 0x9C, 0x09, 0xFE, 0x60, 0xFA, 0x44,
    0x28, 0xC9, 0xA8, 0x74, 0xFC, 0x2C, 0xB4, 0xE6, 0xC7, 0x21, 0x7C, 0x50,
    0x38, 0x73, 0xF6, 0x1F, 0xC2, 0x0C, 0x3E, 0x96, 0xE8, 0xED, 0x16, 0xC2,
    0x58, 0x92, 0x25, 0xBC, 0x2E, 0x0F, 0x13, 0x16, 0x11, 0x61, 0xD6, 0xF4,
    0x1B, 0x51, 0xA8, 0x1B, 0xE2, 0x4C, 0x45, 0x16, 0xB1, 0xA0, 0x9C, 0x63,
    0xEF, 0xC3, 0x6B, 0xC7, 0xDB, 0x46, 0x85, 0x91, 0x83, 0x48, 0xD4, 0xD4,
    0xF7, 0x5B, 0x7E, 0x14, 0x98, 0xAB, 0x72, 0x32, 0xE7, 0xED, 0x16, 0x92,
    0x2F, 0x06, 0x90, 0xBC, 0x5C, 0xF1, 0xD5, 0x67, 0xB1, 0xE1, 0xE9, 0xE6,
    0xD0, 0xFD, 0x9E, 0x95, 0x51, 0xF5, 0x19, 0x0B, 0xCB, 0x7F, 0x8E, 0x69,
    0xAC, 0xD0};
const uint8_t g_zhCN_Locale[] = {
    0x78, 0x9C, 0xED, 0x56, 0x41, 0x4F, 0xD4, 0x40, 0x14, 0xBE, 0x9B, 0xF8,
    0x1F, 0x9A, 0x46, 0x52, 0x4D, 0x58, 0x46, 0x8F, 0x90, 0xD2, 0x64, 0x03,
    0x08, 0x06, 0xBB, 0x21, 0x96, 0x68, 0xE0, 0x62, 0xBA, 0xED, 0xB0, 0x2D,
    0x6C, 0x3B, 0x64, 0xB6, 0x0D, 0x6E, 0x4F, 0x18, 0x82, 0x82, 0xC2, 0x45,
    0x89, 0x9A, 0x80, 0xE1, 0x64, 0x3C, 0x28, 0x9E, 0x8C, 0x01, 0x22, 0xF1,
    0xCF, 0xB0, 0xCB, 0x91, 0xBF, 0xE0, 0x9B, 0xED, 0xB4, 0xB4, 0xDD, 0xD9,
    0xB5, 0x3F, 0xC0, 0x3D, 0xCD, 0xFB, 0xDE, 0xF7, 0x7D, 0xF3, 0xDE, 0xEB,
    0x74, 0xB6, 0x6A, 0x93, 0x58, 0x66, 0x13, 0x4B, 0xBE, 0xE9, 0xE1, 0x49,
    0x39, 0x72, 0x9E, 0x4F, 0xD5, 0x64, 0xC9, 0xC6, 0x2D, 0x6B, 0x52, 0xBE,
    0x3C, 0x3D, 0xE9, 0x7E, 0x78, 0x7D, 0xF7, 0xEA, 0xC7, 0xE6, 0xE5, 0xC5,
    0xFB, 0xEB, 0xDF, 0x7B, 0x10, 0x77, 0x0E, 0x2F, 0xEE, 0xC9, 0x9A, 0xCA,
    0x14, 0xBE, 0x6D, 0x52, 0xA3, 0xED, 0xD5, 0x49, 0xB3, 0xC5, 0xC5, 0x0D,
    0x8A, 0x1B, 0x84, 0xBA, 0xA6, 0x0F, 0x0C, 0x8F, 0xF8, 0x81, 0x53, 0x03,
    0xB8, 0xC5, 0xD7, 0xDA, 0xE5, 0xE9, 0x66, 0xF7, 0x68, 0x47, 0x45, 0x71,
    0x74, 0xFB, 0x56, 0x02, 0x9F, 0xEF, 0x09, 0xE1, 0xD3, 0x5D, 0x11, 0xDC,
    0x39, 0x3C, 0x14, 0x9B, 0x1C, 0x08, 0xD9, 0xDB, 0x27, 0x62, 0xEF, 0x2D,
    0x31, 0xFB, 0x9B, 0x90, 0x7D, 0xF6, 0x59, 0xC8, 0xDE, 0x7F, 0x39, 0x00,
    0x1E, 0xD0, 0x28, 0xCB, 0x14, 0x7B, 0x45, 0x99, 0x31, 0x25, 0xC4, 0x5E,
    0x24, 0x99, 0xF5, 0x3A, 0x9D, 0x94, 0x1F, 0xC8, 0xFF, 0xA7, 0x57, 0x7A,
    0x7A, 0xB6, 0xD9, 0xE6, 0x07, 0x0E, 0x56, 0x5A, 0xF7, 0xD3, 0x71, 0xF7,
    0xE8, 0xB8, 0xFB, 0xF1, 0x8B, 0x8A, 0x58, 0x18, 0xE7, 0x39, 0x0A, 0x7B,
    0x88, 0xD0, 0xF3, 0x3D, 0x21, 0x77, 0x57, 0x80, 0xC2, 0x24, 0x85, 0x0E,
    0x07, 0x22, 0xEE, 0xF6, 0x49, 0x8A, 0xA2, 0xB4, 0xC8, 0x4C, 0xC1, 0x99,
    0x87, 0xDD, 0x53, 0x15, 0x6A, 0x2E, 0x56, 0x5B, 0xAC, 0xB3, 0x58, 0x61,
    0xB1, 0xB6, 0x62, 0x55, 0x03, 0xEB, 0xF1, 0x30, 0x75, 0x6D, 0x17, 0x7B,
    0xC9, 0x6B, 0xCB, 0x43, 0xD8, 0xE0, 0x4D, 0x67, 0x9F, 0x0D, 0x3E, 0x01,
    0x32, 0x5C, 0x48, 0xBE, 0xED, 0x4B, 0xA2, 0xBC, 0x13, 0x20, 0x98, 0x9A,
    0xDC, 0x15, 0x56, 0x50, 0xC1, 0xF7, 0xCE, 0xF6, 0x56, 0x67, 0x77, 0x5F,
    0x45, 0x2C, 0x8C, 0xF3, 0x1C, 0x4D, 0x21, 0x94, 0x6A, 0x58, 0x50, 0xB8,
    0x71, 0xE2, 0x5E, 0x02, 0xBC, 0x60, 0x06, 0x01, 0xA6, 0x7E, 0xEF, 0x99,
    0xA7, 0x11, 0xBF, 0x8E, 0x56, 0xC2, 0x66, 0x53, 0xD6, 0x96, 0xE0, 0xA7,
    0x74, 0xCE, 0x7E, 0x2A, 0xBA, 0x02, 0xA7, 0x47, 0x99, 0x56, 0x60, 0xBC,
    0xCA, 0x0C, 0xFC, 0x58, 0xEF, 0xA9, 0xA4, 0xE0, 0xC7, 0x1D, 0x9A, 0xC4,
    0x6F, 0x0C, 0x70, 0x28, 0xA1, 0xF6, 0xB0, 0x1D, 0x8B, 0x2B, 0x7A, 0x65,
    0xBA, 0x04, 0xBF, 0xE5, 0x10, 0x1A, 0x30, 0x85, 0x90, 0x8F, 0x72, 0xED,
    0x02, 0x10, 0xB8, 0x5E, 0xA6, 0xFD, 0x4C, 0x94, 0x6B, 0xBF, 0xEA, 0x38,
    0x50, 0xEF, 0x2F, 0x45, 0xD7, 0x95, 0xCE, 0xCE, 0x2B, 0xC5, 0x30, 0x94,
    0xAB, 0xAF, 0xEF, 0x14, 0x69, 0x59, 0x45, 0x19, 0x45, 0xC1, 0x2E, 0xD7,
    0xBD, 0xD8, 0xA0, 0x84, 0xBC, 0xD7, 0x3E, 0xA8, 0x27, 0x74, 0x7D, 0xC2,
    0x30, 0x4A, 0x08, 0x78, 0xFF, 0x55, 0xA6, 0xE8, 0xA3, 0xA3, 0x5C, 0xBB,
    0x7C, 0x7E, 0x8B, 0x80, 0x25, 0x07, 0x62, 0xD6, 0xF4, 0x57, 0xD7, 0xE6,
    0xBC, 0x96, 0x31, 0x33, 0xFD, 0x70, 0xE3, 0xD9, 0x0B, 0x67, 0x3E, 0x5A,
    0x8E, 0x67, 0x96, 0x25, 0x81, 0xCE, 0x0F, 0xBD, 0x3A, 0xA6, 0x37, 0x83,
    0xCB, 0xC5, 0xBC, 0x12, 0xC0, 0xE0, 0x00, 0x5B, 0xB2, 0x16, 0x8D, 0x46,
    0xD1, 0xF8, 0x58, 0x14, 0x45, 0x2A, 0xCA, 0xF1, 0xFA, 0x8C, 0xB8, 0xD0,
    0x0A, 0x29, 0xC5, 0xBE, 0xD5, 0x96, 0xB5, 0x3B, 0xB1, 0x74, 0x7C, 0xBC,
    0xA4, 0x72, 0x1D, 0x53, 0x0B, 0xFB, 0x01, 0xDF, 0x72, 0x44, 0xA0, 0x42,
    0x85, 0xCA, 0x53, 0xA3, 0xA4, 0xB9, 0x5C, 0xC8, 0x6D, 0x6D, 0x6C, 0xB9,
    0x9E, 0x09, 0xE7, 0x60, 0x2C, 0xD1, 0xC7, 0xE9, 0xA2, 0x3A, 0xFD, 0x07,
    0x27, 0xE1, 0xBA, 0xCB, 0x1E, 0xFB, 0x68, 0x29, 0x7E, 0x5A, 0xF5, 0x48,
    0x29, 0xBA, 0xE7, 0xFA, 0x61, 0x4B, 0xD6, 0x2A, 0xA5, 0xC8, 0x11, 0xA6,
    0x44, 0xD6, 0xEE, 0xF7, 0x73, 0x51, 0xBE, 0x6D, 0x40, 0x92, 0xB1, 0xA7,
    0x93, 0xC8, 0x03, 0xC9, 0xF9, 0xEA, 0x05, 0xB2, 0x76, 0xFD, 0x07, 0xEE,
    0xD7, 0x3C, 0xA3, 0xDF, 0x84, 0x6B, 0xDC, 0x16, 0x61, 0x0B, 0x59, 0x9B,
    0xAA, 0x2D, 0x95, 0x16, 0x65, 0x87, 0xDE, 0x2F, 0x41, 0xC5, 0x6A, 0xD9,
    0xCB, 0xD0, 0x5E, 0xC7, 0x2B, 0xA6, 0xC5, 0xEE, 0xC7, 0x64, 0xC9, 0xBD,
    0xAA, 0x36, 0xA9, 0x63, 0xC9, 0x80, 0x57, 0x51, 0x32, 0x02, 0x5B, 0x7A,
    0x2C, 0xA3, 0x2C, 0x9F, 0x93, 0xF4, 0x36, 0x7C, 0x75, 0xD9, 0xD2, 0x02,
    0x0C, 0x4C, 0x98, 0x76, 0x7D, 0x97, 0xF8, 0x03, 0xD3, 0x53, 0x24, 0xA4,
    0x2E, 0xA6, 0xCC, 0x5F, 0x98, 0x8F, 0x4B, 0x58, 0x70, 0xFF, 0x41, 0x98,
    0xC3, 0x75, 0x8A, 0x37, 0x86, 0x10, 0xAA, 0xD4, 0xAC, 0xC3, 0x4B, 0x35,
    0x98, 0xB0, 0xE8, 0x98, 0xAE, 0x30, 0x3D, 0x4F, 0xA2, 0x70, 0xCD, 0x94,
    0x66, 0x49, 0xE0, 0xB8, 0x16, 0xEB, 0xA3, 0xF2, 0xF4, 0x91, 0xA4, 0x0F,
    0xA3, 0x42, 0xCB, 0x96, 0x43, 0x12, 0xEA, 0x93, 0x21, 0x9B, 0x02, 0x73,
    0xD8, 0x68, 0x39, 0xA9, 0x1D, 0xFA, 0x8D, 0x55, 0xD2, 0xE3, 0xF1, 0x7D,
    0xD1, 0xCD, 0x33, 0x63, 0x51, 0xFC, 0x15, 0x0D, 0xCB, 0xBF, 0xC0, 0xE4,
    0x3D, 0x40};
const uint8_t g_zhTW_Locale[] = {
    0x78, 0x9C, 0xED, 0x57, 0xCD, 0x4F, 0xD4, 0x40, 0x14, 0x3F, 0x63, 0xE2,
    0xFF, 0x30, 0x69, 0x20, 0xD5, 0x04, 0xA8, 0x1E, 0x21, 0xA5, 0xC9, 0xC6,
    0x45, 0x30, 0x58, 0x42, 0xEC, 0x46, 0x22, 0x17, 0x33, 0xDB, 0x0E, 0xDB,
    0xC2, 0xB6, 0x43, 0x66, 0xDB, 0xC0, 0xF6, 0x24, 0x12, 0x14, 0x14, 0x62,
    0xA2, 0xC4, 0x8F, 0x80, 0xE1, 0x64, 0x3C, 0x28, 0x89, 0x07, 0x0F, 0x2C,
    0x51, 0xFF, 0x1A, 0x76, 0x39, 0xFA, 0x2F, 0x38, 0xD3, 0x2F, 0xFA, 0xB1,
    0xB3, 0xD4, 0xC4, 0xA3, 0x7B, 0x9A, 0xF7, 0xDE, 0xEF, 0xF7, 0xE6, 0xBD,
    0xDF, 0xBC, 0x7D, 0xD9, 0x95, 0x9B, 0x58, 0x87, 0x4D, 0x04, 0x1C, 0x68,
    0xA3, 0x29, 0xC1, 0x37, 0x1F, 0xD7, 0x16, 0x05, 0x60, 0xA0, 0x96, 0x3E,
    0x25, 0x9C, 0x9F, 0x9E, 0xF4, 0xDE, 0x3E, 0xBF, 0x71, 0xD1, 0xD9, 0x3C,
    0xFF, 0xF9, 0xE6, 0xF7, 0x8F, 0xBD, 0xEE, 0xAB, 0x6F, 0xBD, 0xCE, 0xAF,
    0x9B, 0x82, 0x72, 0xFD, 0x1A, 0x00, 0x32, 0x63, 0x39, 0x06, 0x24, 0x5A,
    0xDB, 0xAE, 0xE3, 0x66, 0x2B, 0x4A, 0xD0, 0x20, 0xA8, 0x81, 0x89, 0x05,
    0x1D, 0x86, 0x1A, 0x02, 0xB2, 0x8D, 0x1D, 0xD7, 0x9C, 0xA7, 0xA1, 0x16,
    0xB3, 0x87, 0x42, 0x5B, 0x39, 0x3F, 0x7D, 0xD2, 0x3B, 0xDA, 0x91, 0xA5,
    0xD0, 0x4A, 0x07, 0xCE, 0xF6, 0x38, 0x81, 0xD3, 0xDD, 0xFE, 0x81, 0xEE,
    0xE1, 0x21, 0x2F, 0xD5, 0x01, 0x87, 0xB1, 0x7D, 0xC2, 0xBB, 0x63, 0x8B,
    0xC7, 0xF8, 0xC2, 0x61, 0x74, 0x3E, 0x72, 0x18, 0xFB, 0x9B, 0xDC, 0x00,
    0xB7, 0x79, 0x16, 0xCB, 0xF7, 0x0F, 0xA2, 0x73, 0x22, 0x61, 0x5A, 0x52,
    0x00, 0xEB, 0x75, 0x32, 0x25, 0xDC, 0x16, 0xFE, 0x6B, 0xFB, 0x8F, 0xB4,
    0x35, 0x60, 0x3B, 0x35, 0xAC, 0xD4, 0x52, 0x7A, 0xEF, 0x8F, 0x7B, 0x47,
    0xC7, 0xBD, 0x77, 0x9F, 0x64, 0x89, 0x99, 0x39, 0x3F, 0xBD, 0xAF, 0xBF,
    0xFF, 0x6C, 0x8F, 0x83, 0xDF, 0xED, 0xEB, 0xA7, 0x4A, 0x73, 0xF2, 0x1C,
    0xF4, 0xC7, 0x6F, 0x9F, 0x24, 0x7E, 0x10, 0x9C, 0xFA, 0x34, 0x91, 0x1B,
    0x8F, 0x80, 0x5D, 0xE8, 0xA3, 0xD8, 0x41, 0xB1, 0xF6, 0x62, 0xD5, 0xC5,
    0x7A, 0x8B, 0x95, 0x0E, 0xAC, 0xD1, 0x46, 0xC4, 0x32, 0x2C, 0x64, 0xA7,
    0x57, 0x43, 0xE4, 0xA2, 0xD7, 0xBD, 0xE8, 0xEE, 0xB3, 0x87, 0x8A, 0x1D,
    0xF9, 0xF0, 0xCB, 0x42, 0x18, 0x5C, 0x9A, 0xA9, 0x4B, 0x10, 0x81, 0xA9,
    0xFC, 0xD4, 0xA2, 0x35, 0x7D, 0xED, 0x6E, 0x6F, 0x75, 0x77, 0xF7, 0x65,
    0x89, 0x99, 0x39, 0x7F, 0xE2, 0x04, 0xC1, 0x29, 0xE6, 0xD2, 0x65, 0x27,
    0xE5, 0xB6, 0x5D, 0xE8, 0x35, 0xA0, 0x8B, 0x16, 0xA0, 0xEB, 0x22, 0xE2,
    0x24, 0xD2, 0x27, 0x9E, 0x68, 0x21, 0x2E, 0x7B, 0xCD, 0xA6, 0xA0, 0x3C,
    0xA2, 0x1F, 0xB1, 0xDB, 0xF9, 0x2E, 0xAA, 0x22, 0x9D, 0x41, 0xB1, 0x2A,
    0xD2, 0x87, 0x10, 0xA7, 0xE9, 0x87, 0xE9, 0x92, 0x50, 0x78, 0x39, 0x9A,
    0xD8, 0x69, 0x70, 0x72, 0x94, 0xE2, 0xDB, 0xC8, 0x08, 0xE9, 0x92, 0x2A,
    0x55, 0x4B, 0x31, 0x5A, 0x26, 0x26, 0x2E, 0x9F, 0x03, 0x40, 0xC6, 0x13,
    0xC9, 0xE1, 0x5A, 0x76, 0x4E, 0x8E, 0x94, 0x27, 0x23, 0x47, 0xC5, 0x34,
    0xC5, 0xDE, 0x87, 0xA7, 0xA2, 0xAA, 0x8A, 0xDD, 0x9D, 0x67, 0xA2, 0xA6,
    0x89, 0x17, 0x9F, 0x5F, 0x8B, 0x60, 0x49, 0x96, 0x52, 0x0C, 0x5E, 0x8A,
    0x50, 0x8D, 0xFE, 0x29, 0x4A, 0x25, 0x08, 0xE4, 0xA8, 0x00, 0x73, 0x52,
    0x55, 0x27, 0x35, 0xAD, 0x14, 0x25, 0xD2, 0x23, 0x24, 0xE5, 0x19, 0x4C,
    0x8D, 0x5C, 0xEF, 0xD1, 0x70, 0xD4, 0xA8, 0x37, 0x9E, 0x98, 0x19, 0xE8,
    0xAC, 0xAC, 0xCE, 0xDA, 0x2D, 0x6D, 0xBA, 0x7A, 0x77, 0x7D, 0x71, 0xC3,
    0x9C, 0xF3, 0x97, 0x42, 0x11, 0xD3, 0xA0, 0x80, 0xE9, 0x78, 0x76, 0x1D,
    0x91, 0xAC, 0x92, 0x19, 0x5F, 0x54, 0x14, 0xF5, 0xD1, 0x99, 0xD7, 0x05,
    0xC5, 0x1F, 0xF5, 0xFD, 0x89, 0x71, 0xDF, 0xF7, 0x65, 0x29, 0x83, 0xE3,
    0x53, 0x75, 0x8F, 0x10, 0xE4, 0xE8, 0x6D, 0x41, 0x19, 0x0E, 0xC9, 0x13,
    0x13, 0xA5, 0xB9, 0x6B, 0x88, 0xE8, 0xC8, 0x71, 0xA3, 0x6B, 0x47, 0x8A,
    0x3C, 0xA6, 0x47, 0xA1, 0x87, 0xA4, 0xAF, 0xCB, 0x56, 0x87, 0xB2, 0xAE,
    0x28, 0xBD, 0x81, 0x74, 0xCB, 0x86, 0x74, 0x48, 0xC6, 0xE3, 0x2C, 0x61,
    0x98, 0x4B, 0x68, 0x10, 0xEC, 0xAD, 0x59, 0x6C, 0x26, 0x46, 0x4B, 0x32,
    0x92, 0x0E, 0x46, 0x4A, 0x12, 0x6C, 0xCB, 0xF1, 0x5A, 0x82, 0x32, 0x56,
    0x12, 0xEE, 0x23, 0x82, 0x05, 0xE5, 0x56, 0x01, 0x7D, 0x29, 0x4C, 0xE6,
    0xBD, 0xE3, 0xC7, 0xC8, 0x28, 0x93, 0x75, 0xC6, 0x63, 0x18, 0x18, 0x82,
    0x32, 0x5F, 0x1B, 0xA6, 0x2B, 0x29, 0x83, 0x18, 0xC0, 0xB2, 0x5A, 0x98,
    0x1D, 0x04, 0xA5, 0xB6, 0x58, 0xFD, 0x0B, 0x5A, 0xFA, 0x21, 0x0A, 0xA4,
    0x60, 0x27, 0x16, 0xEA, 0x66, 0x4B, 0xA0, 0xBD, 0x86, 0x96, 0xA1, 0x1E,
    0xAF, 0xE0, 0xD8, 0x8C, 0x72, 0x56, 0x0C, 0x5C, 0x47, 0x40, 0xA5, 0xAF,
    0x05, 0x34, 0xD7, 0x00, 0xF7, 0x05, 0xA9, 0x2F, 0x4C, 0x6D, 0xD3, 0x9F,
    0x90, 0x06, 0x58, 0xA0, 0x32, 0x72, 0x00, 0x96, 0x63, 0x61, 0x67, 0x00,
    0xE0, 0x0E, 0xF6, 0x88, 0x85, 0x08, 0xBB, 0x85, 0x83, 0x08, 0x4B, 0x59,
    0xB0, 0xAE, 0x84, 0xCC, 0xA2, 0x3A, 0x41, 0xEB, 0x03, 0x21, 0x15, 0x02,
    0xEB, 0xF4, 0x8B, 0x38, 0x08, 0x52, 0x33, 0xA1, 0xC5, 0x01, 0xCC, 0x61,
    0xDF, 0x5B, 0x85, 0x60, 0x06, 0xBB, 0xA6, 0xA5, 0xB3, 0x9E, 0xC6, 0x1E,
    0xDE, 0x03, 0xEA, 0x60, 0x30, 0x15, 0x40, 0x37, 0x71, 0x0C, 0x7E, 0x30,
    0xF0, 0x6A, 0x0D, 0x5F, 0x21, 0x77, 0xF4, 0x2A, 0x6D, 0xCF, 0x69, 0xAC,
    0xE0, 0x00, 0x19, 0xDE, 0x1E, 0x2C, 0xB6, 0xD4, 0x7B, 0xCA, 0x52, 0xF8,
    0x67, 0x41, 0xF9, 0x03, 0x11, 0xC2, 0x4A, 0xC9};
const uint8_t g_zhHK_Locale[] = {
    0x78, 0x9C, 0xA5, 0x57, 0x4D, 0x4F, 0x13, 0x41, 0x18, 0x3E, 0x63, 0xE2,
    0x7F, 0x98, 0x6C, 0x20, 0x0B, 0x09, 0x50, 0x8A, 0x9F, 0x25, 0xCB, 0x26,
    0x44, 0x90, 0x9A, 0x5A, 0x43, 0x2C, 0xD1, 0xC8, 0xC5, 0x6C, 0x77, 0x87,
    0xEE, 0x42, 0x77, 0x87, 0x4C, 0xB7, 0xC1, 0x6E, 0x3C, 0x88, 0x04, 0xA5,
    0x5A, 0x2E, 0x4A, 0x54, 0x02, 0x86, 0x78, 0x50, 0x0F, 0x48, 0xBC, 0x78,
    0x68, 0x89, 0xC6, 0x3F, 0x43, 0x8B, 0x9E, 0xFC, 0x0B, 0xCE, 0xEC, 0x17,
    0xFB, 0x35, 0x6D, 0x8D, 0x3D, 0xCD, 0xFB, 0xBC, 0xCF, 0xF3, 0xCE, 0xFB,
    0x3E, 0x33, 0x3B, 0x01, 0xA1, 0x8C, 0x64, 0xA9, 0x0C, 0x81, 0x21, 0xE9,
    0x70, 0x9A, 0xB3, 0xD4, 0x87, 0xD9, 0x1C, 0x07, 0x14, 0x58, 0x91, 0xA7,
    0xB9, 0xD3, 0xE6, 0x71, 0xE7, 0xCD, 0xF3, 0xE1, 0xB3, 0xD6, 0xC6, 0xE9,
    0x8F, 0xD7, 0x7F, 0xBE, 0x37, 0x7E, 0x7F, 0xDA, 0xEB, 0x34, 0xBF, 0x9E,
    0xD5, 0x5B, 0xED, 0xED, 0xA3, 0x5F, 0x1F, 0x1A, 0x9D, 0xDD, 0x9F, 0xED,
    0xC6, 0xC9, 0x08, 0x27, 0x5E, 0xBC, 0x00, 0x80, 0x40, 0x8B, 0x18, 0x8A,
    0x84, 0x0B, 0x35, 0xBD, 0x88, 0xCA, 0x15, 0xB7, 0x5E, 0x09, 0xC3, 0x12,
    0xC2, 0x9A, 0x64, 0x50, 0xD6, 0x00, 0x10, 0x74, 0x64, 0x98, 0xEA, 0x1D,
    0x92, 0xAA, 0xD0, 0x78, 0xC0, 0x89, 0xC5, 0xD3, 0xE6, 0x93, 0xCE, 0xC1,
    0xB6, 0x90, 0x72, 0xA2, 0x60, 0xE2, 0xA4, 0xC1, 0x48, 0x34, 0xEB, 0xC9,
    0x89, 0xF6, 0xFE, 0x3E, 0xAB, 0xD4, 0x2E, 0x43, 0xB1, 0x75, 0xCC, 0xDA,
    0x63, 0x93, 0xA5, 0x38, 0x62, 0x28, 0x5A, 0xEF, 0x19, 0x8A, 0x9D, 0x0D,
    0x66, 0x82, 0x39, 0x3C, 0xCD, 0x45, 0xE7, 0x07, 0xEE, 0xDA, 0xB7, 0x30,
    0x68, 0x29, 0x90, 0x8A, 0x45, 0x3C, 0xCD, 0xA5, 0xB9, 0x60, 0x95, 0x74,
    0x72, 0xF1, 0xC9, 0x64, 0xF8, 0x52, 0x32, 0x7C, 0x39, 0x19, 0xBE, 0x92,
    0x0C, 0x5F, 0x4D, 0x86, 0xAF, 0x25, 0xC3, 0xD7, 0x93, 0xE1, 0x4C, 0x32,
    0x9C, 0x9E, 0x60, 0xE0, 0x8C, 0x39, 0xD3, 0x93, 0x3D, 0x0D, 0x54, 0xA4,
    0x5A, 0xE0, 0x46, 0x92, 0x48, 0xEC, 0xBC, 0x3B, 0xEC, 0x1C, 0x1C, 0x76,
    0xDE, 0x7E, 0x14, 0x52, 0x34, 0x8C, 0xE0, 0xE4, 0xC0, 0x92, 0xF1, 0x93,
    0x06, 0x83, 0x5F, 0x4F, 0xC4, 0xC9, 0x55, 0x65, 0xD4, 0xD9, 0x4D, 0xE6,
    0x6F, 0x1D, 0xFB, 0x38, 0xB0, 0x57, 0x09, 0x43, 0x44, 0xEE, 0x80, 0xAD,
    0x8E, 0xCD, 0x11, 0x9F, 0x20, 0xDE, 0x7B, 0xBC, 0xEB, 0x78, 0xBF, 0xF1,
    0x4E, 0xBB, 0xF6, 0xA8, 0x43, 0xAC, 0x29, 0x1A, 0xD4, 0x83, 0xDF, 0xBF,
    0x0B, 0x91, 0xED, 0x5E, 0xB4, 0x77, 0xE8, 0x41, 0x79, 0x40, 0x34, 0xFD,
    0x32, 0x96, 0x06, 0xE7, 0x61, 0x60, 0x13, 0x88, 0xA5, 0x40, 0x7D, 0x12,
    0x91, 0x9E, 0xBE, 0xB4, 0xB7, 0x36, 0xDB, 0xF5, 0x1D, 0x21, 0x45, 0xC3,
    0x08, 0xEE, 0x83, 0xC0, 0x5E, 0x79, 0x5A, 0xF2, 0xA2, 0xA5, 0x22, 0x4F,
    0x9A, 0x83, 0x2A, 0x92, 0x09, 0x17, 0x24, 0xD3, 0x84, 0xD8, 0xF0, 0xAD,
    0xF7, 0x11, 0xF7, 0xD5, 0x5B, 0xAE, 0x96, 0xCB, 0x9C, 0xF8, 0x80, 0xFC,
    0xF8, 0x76, 0xEB, 0x1B, 0x9F, 0xE7, 0xC9, 0x1D, 0xE4, 0x67, 0x79, 0x72,
    0x10, 0x3C, 0x98, 0x23, 0x3F, 0x6A, 0x8C, 0xAF, 0x61, 0x15, 0x29, 0x23,
    0xA3, 0xC4, 0x28, 0xD2, 0x97, 0x5E, 0x87, 0xCA, 0xFF, 0xC8, 0x2B, 0x2A,
    0xC2, 0x26, 0x2D, 0xD0, 0x53, 0x0E, 0x40, 0x08, 0x71, 0x7D, 0x32, 0x35,
    0x3D, 0xE2, 0x53, 0x00, 0x09, 0xF9, 0x34, 0xA3, 0xAA, 0x7C, 0x67, 0xEF,
    0x29, 0x9F, 0xCF, 0xF3, 0xED, 0xED, 0x67, 0x7C, 0xA1, 0xC0, 0x9F, 0x7D,
    0x7E, 0xC5, 0x83, 0x25, 0x21, 0x15, 0x50, 0xB0, 0x4A, 0x38, 0x2E, 0x25,
    0x97, 0xE8, 0xAB, 0x80, 0x6D, 0x13, 0xD1, 0x4F, 0xE5, 0xF3, 0x53, 0x85,
    0x42, 0x5F, 0x12, 0xD7, 0x9A, 0x19, 0xAA, 0x89, 0x0A, 0xA8, 0x19, 0x91,
    0xD1, 0xDD, 0x4B, 0xB3, 0x48, 0x50, 0xEF, 0x26, 0xCD, 0x4B, 0xC6, 0xCA,
    0x6A, 0x56, 0xAF, 0x14, 0xE6, 0x66, 0x6F, 0xAE, 0xDF, 0x7F, 0xA4, 0xE6,
    0xAC, 0x25, 0xC7, 0xC3, 0x20, 0xC9, 0x56, 0x1A, 0x55, 0xBD, 0x08, 0x71,
    0xD8, 0xC8, 0x10, 0xE6, 0xF6, 0x44, 0x30, 0xF2, 0x2D, 0xC8, 0x9C, 0x68,
    0x8D, 0x5A, 0x56, 0x66, 0xDC, 0xB2, 0x2C, 0x21, 0x15, 0xE2, 0xB1, 0xA5,
    0x72, 0x15, 0x63, 0x68, 0xC8, 0x35, 0x4E, 0x1C, 0x74, 0xC4, 0x99, 0xCC,
    0xE3, 0x61, 0x7F, 0x39, 0xD2, 0x77, 0x9D, 0x35, 0x88, 0x65, 0x68, 0x98,
    0x6E, 0x0B, 0x43, 0x71, 0x1D, 0xF5, 0x26, 0x36, 0x8F, 0x3F, 0xE3, 0xF9,
    0xD8, 0x03, 0x61, 0xC8, 0x2D, 0xAF, 0x40, 0x59, 0xD3, 0x25, 0x72, 0x5F,
    0xC6, 0xBD, 0x2A, 0x4E, 0x9A, 0x29, 0x28, 0x61, 0x54, 0x5D, 0xD3, 0xE8,
    0xF5, 0x18, 0xED, 0x53, 0xE1, 0x4F, 0x30, 0xD4, 0xA7, 0x40, 0xD7, 0x8C,
    0x6A, 0x85, 0x13, 0xC7, 0xFA, 0xA4, 0x5B, 0x10, 0x23, 0x4E, 0x9C, 0x88,
    0xB1, 0xCF, 0x8D, 0x09, 0x9D, 0xBD, 0x77, 0x30, 0x21, 0x67, 0xC2, 0xA0,
    0x77, 0x23, 0xED, 0x80, 0x13, 0xB3, 0xB9, 0x41, 0xF2, 0x6C, 0x85, 0x18,
    0x5D, 0x54, 0x5A, 0x05, 0xD1, 0x05, 0x95, 0xCD, 0xFE, 0x83, 0x2C, 0x78,
    0x10, 0x31, 0x91, 0xFD, 0x6E, 0xC6, 0xFA, 0xA6, 0xEF, 0x41, 0x6D, 0x0D,
    0x2E, 0x4B, 0xB2, 0xF7, 0x4C, 0x7B, 0xA1, 0x5B, 0x73, 0x46, 0x41, 0x45,
    0x08, 0xF2, 0xE4, 0xB4, 0x40, 0xC1, 0x54, 0xC0, 0x6D, 0x2E, 0x95, 0x48,
    0xCB, 0xD7, 0xC8, 0xDF, 0x92, 0x0A, 0x58, 0x20, 0x36, 0x32, 0x08, 0x9A,
    0xA1, 0x21, 0xA3, 0x0B, 0xE1, 0x06, 0xAA, 0x62, 0x0D, 0x62, 0xBA, 0x0B,
    0x83, 0xE1, 0xB4, 0xB2, 0xA0, 0xF5, 0xA4, 0x64, 0x61, 0x11, 0xC3, 0xF5,
    0xAE, 0x94, 0x19, 0x2C, 0x15, 0xC9, 0x47, 0xD9, 0x8D, 0xB2, 0xA8, 0x4A,
    0x1A, 0x83, 0x90, 0x43, 0x56, 0x75, 0x55, 0x02, 0xF3, 0xC8, 0x54, 0x35,
    0x99, 0xCE, 0x34, 0x76, 0xEF, 0x16, 0xC8, 0x77, 0x27, 0x13, 0x03, 0x64,
    0x15, 0x79, 0xE4, 0xBB, 0x5D, 0xB7, 0x2E, 0xA0, 0x1E, 0x76, 0xBB, 0xA7,
    0x52, 0xAB, 0x1A, 0xA5, 0x15, 0x64, 0x33, 0x9D, 0xDD, 0xED, 0x47, 0x2E,
    0x70, 0x9E, 0x42, 0xCA, 0xF9, 0x27, 0x42, 0xFC, 0x0B, 0xD9, 0x0E, 0x4B,
    0xED};
const uint8_t g_jaJP_Locale[] = {
    0x78, 0x9C, 0xED, 0x56, 0xCB, 0x6E, 0xD3, 0x40, 0x14, 0x5D, 0x17, 0x89,
    0x7F, 0x18, 0x59, 0x20, 0x83, 0xD4, 0xD6, 0x0D, 0xEF, 0x56, 0xAE, 0xA5,
    0x8A, 0x96, 0x86, 0x16, 0xA3, 0x08, 0x57, 0xA0, 0x76, 0x83, 0x26, 0xF6,
    0x34, 0x99, 0x36, 0x9E, 0xA9, 0x26, 0xB6, 0x4A, 0xBC, 0xE2, 0x21, 0x20,
    0x48, 0x74, 0x01, 0x1B, 0x04, 0x44, 0x62, 0x55, 0x40, 0x02, 0x04, 0x8B,
    0x6E, 0xD8, 0xD0, 0xAF, 0x49, 0x5A, 0x56, 0xFC, 0x02, 0x33, 0x7E, 0xC5,
    0x8E, 0xED, 0xE0, 0xEE, 0xF1, 0x22, 0x99, 0x7B, 0x7C, 0xCE, 0xF5, 0xBD,
    0xE7, 0x8E, 0x47, 0x56, 0x5B, 0xD4, 0x84, 0x2D, 0x04, 0x08, 0xB4, 0xD1,
    0xBC, 0xB4, 0x05, 0xEF, 0xAF, 0xD4, 0x24, 0x60, 0xA1, 0xB6, 0x39, 0x2F,
    0x0D, 0xDE, 0xEC, 0x1F, 0x7F, 0xFF, 0x76, 0x8E, 0xFF, 0x0D, 0x7A, 0x5F,
    0xCF, 0x4B, 0xDA, 0xE9, 0x53, 0x00, 0xA8, 0x82, 0x4C, 0x2C, 0xC8, 0x8C,
    0x8E, 0x5D, 0xA7, 0xAD, 0x76, 0xA8, 0x6B, 0x30, 0xD4, 0xA0, 0x0C, 0x43,
    0x22, 0x58, 0x13, 0x40, 0xB5, 0x29, 0x71, 0x9A, 0xB7, 0xF9, 0xAD, 0xB6,
    0x88, 0x27, 0x82, 0x58, 0xAB, 0x0C, 0x7A, 0x5D, 0x55, 0x09, 0xD6, 0x09,
    0xF8, 0x42, 0x3E, 0x7C, 0x31, 0x1F, 0xBE, 0x94, 0x0F, 0x5F, 0xCE, 0x87,
    0xAF, 0xE4, 0xC3, 0x57, 0xF3, 0xE1, 0x6B, 0xF9, 0xF0, 0x6C, 0x3E, 0x5C,
    0x99, 0x29, 0xC0, 0x0B, 0xFA, 0xAC, 0x8C, 0x34, 0x0A, 0xC2, 0x75, 0xEC,
    0x53, 0xD2, 0x37, 0x00, 0xEB, 0x75, 0x36, 0x2F, 0x55, 0xA4, 0xFF, 0x06,
    0x9E, 0xC4, 0x40, 0x0B, 0x76, 0x12, 0xDB, 0x8E, 0x47, 0x9A, 0xD8, 0xBE,
    0xEF, 0x7B, 0xFC, 0x57, 0x55, 0x44, 0x38, 0xC4, 0x7B, 0xDD, 0x5C, 0xFC,
    0xE8, 0xD1, 0x97, 0x7C, 0xFE, 0x8F, 0x83, 0x82, 0x3C, 0x9F, 0x73, 0xF1,
    0xDF, 0xCF, 0x5F, 0xE5, 0xE2, 0xFD, 0xDE, 0x87, 0x11, 0x1C, 0xF8, 0xAB,
    0x9C, 0x26, 0x46, 0xF6, 0x40, 0xD8, 0x4D, 0xB6, 0x8F, 0x6C, 0x07, 0xD9,
    0xDA, 0xB3, 0x55, 0x67, 0xEB, 0xCD, 0x56, 0x5A, 0x5C, 0xA3, 0x8D, 0x18,
    0xB6, 0x30, 0xB2, 0x93, 0x2F, 0x79, 0x08, 0x69, 0xFD, 0xBD, 0x6E, 0xFF,
    0xC5, 0x1E, 0x1F, 0x4E, 0x04, 0x64, 0x6F, 0xFF, 0x7A, 0x99, 0xBE, 0x0D,
    0x86, 0x61, 0xE2, 0x21, 0x88, 0xC1, 0x44, 0x7E, 0x1E, 0x69, 0x47, 0x07,
    0x0F, 0xFB, 0x4F, 0x9F, 0xF8, 0xD9, 0x45, 0x18, 0xE3, 0xC7, 0xFB, 0x87,
    0x83, 0x77, 0x1F, 0x63, 0x10, 0xF8, 0xAB, 0x48, 0xCB, 0x8F, 0x2D, 0x65,
    0xE4, 0xDC, 0x0A, 0x50, 0x0B, 0x3A, 0xA8, 0x06, 0x1D, 0x07, 0x31, 0x12,
    0x5B, 0x1F, 0x23, 0xE1, 0xD1, 0xB6, 0xE9, 0xB6, 0x5A, 0x92, 0xB6, 0xCE,
    0x2F, 0xB9, 0xFF, 0xF3, 0x40, 0xD6, 0x65, 0x6E, 0xB8, 0xBC, 0x28, 0xF3,
    0x41, 0xC8, 0x4B, 0xFC, 0x12, 0xBE, 0xC4, 0x92, 0xA2, 0x1C, 0x2D, 0x4A,
    0x1A, 0x05, 0x39, 0x4A, 0xE9, 0x6D, 0x64, 0x05, 0x72, 0x45, 0xD7, 0x95,
    0xC5, 0xC5, 0x52, 0x9A, 0x76, 0x93, 0x32, 0x47, 0xA8, 0xF2, 0x35, 0x00,
    0xA4, 0x90, 0xD0, 0x10, 0x07, 0xDB, 0x23, 0x86, 0x24, 0x90, 0x94, 0x21,
    0x55, 0x79, 0xF0, 0xF6, 0xB1, 0xAC, 0xEB, 0x72, 0xBF, 0xFB, 0x4C, 0x36,
    0x0C, 0xF9, 0xE8, 0xD3, 0x6B, 0x79, 0x43, 0x55, 0x12, 0xF4, 0x22, 0x7D,
    0x60, 0x46, 0x75, 0x4E, 0xD7, 0xE7, 0x0C, 0x63, 0xAE, 0x9C, 0xC6, 0x37,
    0x20, 0x94, 0x94, 0x12, 0x84, 0xDD, 0x0B, 0xC9, 0x28, 0x5F, 0x74, 0x3E,
    0xD2, 0x67, 0xB8, 0x15, 0xD6, 0x38, 0x1A, 0xED, 0x8F, 0x65, 0x48, 0xB6,
    0xB6, 0xAB, 0x76, 0xDB, 0x58, 0x5A, 0xBC, 0xB1, 0x7B, 0xEF, 0x41, 0x73,
    0xD5, 0xDB, 0x08, 0x0C, 0x4B, 0x92, 0x7C, 0x25, 0x71, 0xED, 0x3A, 0x62,
    0x69, 0xD7, 0x52, 0x58, 0x58, 0x12, 0xC7, 0xF8, 0x0E, 0x37, 0x25, 0xCD,
    0x9B, 0xF4, 0xBC, 0xD9, 0x69, 0xCF, 0xF3, 0x54, 0x25, 0xC5, 0x2B, 0x96,
    0x9A, 0x2E, 0x63, 0x88, 0x98, 0x1D, 0x49, 0x3B, 0xE3, 0x8B, 0x4B, 0x0B,
    0x77, 0x10, 0x33, 0x11, 0x71, 0xC2, 0x67, 0x9E, 0xCD, 0xEA, 0x84, 0x19,
    0x99, 0x06, 0xE2, 0xA6, 0x86, 0x7D, 0x4E, 0xA4, 0xA1, 0x30, 0xBD, 0x85,
    0x4C, 0x6C, 0x43, 0xBE, 0x1B, 0xA6, 0xA3, 0x2C, 0xC1, 0xED, 0x42, 0x41,
    0x83, 0x51, 0x77, 0x07, 0x8B, 0xF9, 0x4F, 0x96, 0x54, 0xC4, 0x1D, 0x9C,
    0x2D, 0x29, 0xB0, 0x31, 0x71, 0xDB, 0x92, 0x36, 0x55, 0x92, 0xEE, 0x21,
    0x46, 0x25, 0x6D, 0x26, 0xC3, 0x1E, 0x1A, 0x93, 0x1A, 0x76, 0x34, 0x89,
    0x94, 0x33, 0x69, 0x30, 0xDA, 0x81, 0x7E, 0x20, 0x69, 0x7F, 0x0E, 0xF9,
    0x89, 0x9D, 0x66, 0x8C, 0x51, 0xE1, 0x36, 0x15, 0x0B, 0x49, 0x5B, 0xA9,
    0xAD, 0x9F, 0x40, 0x96, 0x1C, 0x44, 0x46, 0xE4, 0x1F, 0x7F, 0x99, 0xBA,
    0xC5, 0xDB, 0xDE, 0xD9, 0x41, 0x9B, 0xD0, 0x8C, 0x4E, 0xDB, 0x28, 0x0C,
    0x73, 0xAE, 0x52, 0xCF, 0xDD, 0x86, 0x60, 0x99, 0x3A, 0x4D, 0x6C, 0x82,
    0x1A, 0xA3, 0x53, 0x77, 0x6F, 0x02, 0x5D, 0x52, 0xC6, 0x91, 0x75, 0x4C,
    0xCC, 0x26, 0x8D, 0xC8, 0x77, 0x0A, 0xC8, 0x7A, 0x87, 0x7F, 0x2A, 0x5A,
    0x82, 0x55, 0x44, 0xC0, 0x04, 0x53, 0x32, 0x86, 0x70, 0x9D, 0xBA, 0x0C,
    0x23, 0x06, 0x0C, 0xC7, 0x2A, 0x60, 0x2C, 0x58, 0xB4, 0x8E, 0x40, 0x0D,
    0xFF, 0x93, 0x52, 0x45, 0x75, 0x86, 0x76, 0xC7, 0x52, 0x16, 0x18, 0xAC,
    0xF3, 0x17, 0x77, 0x1C, 0x65, 0xAD, 0x09, 0xF1, 0x58, 0x02, 0x6F, 0xA9,
    0x21, 0x6A, 0x01, 0xB7, 0xC6, 0xD2, 0x0C, 0x5A, 0x8A, 0xA6, 0x77, 0x5C,
    0xD2, 0xD8, 0xA2, 0x3E, 0x33, 0x18, 0x89, 0x7F, 0xAA, 0x25, 0xE6, 0xA9,
    0x2A, 0xC1, 0x87, 0xBD, 0xF6, 0x17, 0x6C, 0x42, 0x08, 0x21};
const uint8_t g_koKR_Locale[] = {
    0x78, 0x9C, 0xED, 0x56, 0x4D, 0x6B, 0xD4, 0x40, 0x18, 0x3E, 0x57, 0xF0,
    0x3F, 0x0C, 0xC1, 0x12, 0x85, 0x76, 0xB7, 0xEB, 0x77, 0x4B, 0x1A, 0x28,
    0x6E, 0x6D, 0x65, 0x8D, 0x94, 0xA6, 0x58, 0xEC, 0x45, 0x66, 0x93, 0xE9,
    0x26, 0xED, 0x26, 0x53, 0x26, 0x09, 0x75, 0x73, 0xAE, 0x52, 0xF0, 0xE2,
    0xA1, 0x87, 0xEA, 0x6E, 0xB1, 0x07, 0x11, 0x2A, 0x88, 0x22, 0x22, 0x1E,
    0x14, 0x7F, 0x8D, 0x62, 0x6D, 0x8A, 0x7F, 0xC1, 0xC9, 0xE7, 0xE6, 0x63,
    0xB2, 0x4D, 0xEF, 0xEE, 0x61, 0x99, 0xF7, 0x99, 0xE7, 0x79, 0xF3, 0xBE,
    0xCF, 0x4C, 0x5E, 0x22, 0x74, 0xB1, 0x02, 0xBB, 0x08, 0x98, 0xD0, 0x40,
    0xB3, 0xDC, 0x26, 0x7E, 0xDC, 0x5A, 0xE6, 0x80, 0x8A, 0x2C, 0x65, 0x96,
    0xFB, 0x35, 0x38, 0x38, 0xFE, 0x34, 0xF8, 0xFD, 0xE1, 0xFD, 0xE5, 0xE3,
    0xD7, 0x47, 0x3F, 0xFB, 0xDF, 0xAF, 0x70, 0xE2, 0xC5, 0x0B, 0x00, 0x08,
    0x3E, 0xDF, 0x54, 0x21, 0x91, 0x7B, 0x46, 0x1B, 0x77, 0xAD, 0x48, 0xDA,
    0x21, 0xA8, 0x83, 0x89, 0x0E, 0x4D, 0x9F, 0x35, 0x06, 0x04, 0x03, 0x9B,
    0xB6, 0xF6, 0x80, 0x6E, 0x59, 0x7E, 0x3C, 0x16, 0xC6, 0x62, 0xC3, 0xEB,
    0xEF, 0x09, 0xF5, 0x70, 0x9D, 0x82, 0xAF, 0xB2, 0xE1, 0x6B, 0x6C, 0xF8,
    0x3A, 0x1B, 0xBE, 0xC1, 0x86, 0x6F, 0xB2, 0xE1, 0x5B, 0x6C, 0xF8, 0x36,
    0x1B, 0x9E, 0x66, 0xC3, 0x8D, 0xA9, 0x12, 0xBC, 0xA4, 0xCF, 0x46, 0xAE,
    0x51, 0x10, 0xAD, 0x13, 0x9F, 0xD2, 0xBE, 0x01, 0xD8, 0x6E, 0x93, 0x59,
    0xAE, 0xC1, 0xFD, 0x37, 0xF0, 0x3C, 0x06, 0xAA, 0xB0, 0x97, 0xBA, 0x76,
    0x34, 0x12, 0xBD, 0x83, 0x6F, 0xDE, 0xAB, 0x3D, 0xFA, 0x2F, 0xD4, 0xFD,
    0x70, 0x88, 0xF7, 0xF7, 0x98, 0xF8, 0xE9, 0x4B, 0x36, 0xEE, 0xED, 0xEE,
    0x33, 0xF1, 0x93, 0x77, 0x47, 0x4C, 0xFC, 0xCF, 0xD7, 0x5D, 0x76, 0xFE,
    0x67, 0x87, 0x39, 0x1C, 0x04, 0x2B, 0x46, 0x13, 0xB9, 0x3B, 0x10, 0x75,
    0x53, 0xEC, 0xA3, 0xD8, 0x41, 0xB1, 0xF6, 0x62, 0xD5, 0xC5, 0x7A, 0x8B,
    0x95, 0x96, 0xD7, 0x68, 0x20, 0xA2, 0xAB, 0x3A, 0x32, 0xD2, 0x2F, 0x79,
    0x04, 0x89, 0xDE, 0xFE, 0x1B, 0xEF, 0x70, 0x87, 0x1E, 0x4E, 0x0C, 0x14,
    0xB6, 0x4F, 0xFB, 0xB9, 0x6D, 0x30, 0x0C, 0x53, 0x0F, 0x41, 0x04, 0xA6,
    0xF2, 0xD3, 0x88, 0x56, 0xF9, 0xD1, 0xEB, 0xBF, 0x08, 0xB2, 0xFB, 0x61,
    0x82, 0x7B, 0x3B, 0x03, 0xBA, 0x95, 0x80, 0x20, 0x58, 0xC5, 0x5A, 0x3A,
    0xB6, 0xEA, 0xB9, 0xB9, 0x15, 0xA2, 0x2A, 0xB4, 0xD1, 0x12, 0xB4, 0x6D,
    0x44, 0xCC, 0xC4, 0xFA, 0x04, 0x89, 0x46, 0xDB, 0xBA, 0xD3, 0xED, 0x72,
    0xE2, 0x23, 0xFA, 0xE3, 0x4F, 0x9E, 0xEE, 0xF0, 0x40, 0xE2, 0xA9, 0xE3,
    0x3C, 0x68, 0xF2, 0xF4, 0x28, 0x78, 0x30, 0x4F, 0x7F, 0xBE, 0x35, 0x89,
    0xAA, 0x2C, 0x4D, 0x17, 0x9B, 0x9D, 0xD2, 0x34, 0x95, 0x32, 0x18, 0x48,
    0x0D, 0x13, 0xD4, 0x80, 0x24, 0xD5, 0x40, 0xB3, 0x59, 0x49, 0x65, 0x69,
    0x98, 0xD8, 0xBE, 0xAE, 0x4C, 0x05, 0x40, 0x06, 0x89, 0x9C, 0xB1, 0x75,
    0x23, 0xE7, 0x4C, 0x0A, 0xC9, 0x38, 0x33, 0x07, 0x34, 0x8D, 0xF7, 0x9E,
    0x0F, 0x68, 0x4B, 0x12, 0x7F, 0xF2, 0x85, 0xB6, 0x26, 0xCB, 0xBC, 0xF7,
    0x79, 0x97, 0x07, 0x6B, 0x42, 0x3D, 0x25, 0x2A, 0xCB, 0x12, 0x1A, 0x53,
    0x9A, 0xA5, 0x52, 0x8E, 0xC0, 0x1A, 0x9A, 0x62, 0x46, 0x92, 0x66, 0x64,
    0xB9, 0x92, 0x24, 0xF2, 0x25, 0x14, 0xE5, 0x15, 0xBE, 0x27, 0x39, 0x07,
    0xA2, 0xDB, 0xB2, 0x42, 0xD1, 0xF8, 0x0A, 0x2D, 0x40, 0x73, 0x63, 0x73,
    0xD1, 0xB0, 0xE4, 0xF9, 0xE6, 0xDD, 0xED, 0xD5, 0x27, 0x5A, 0xCB, 0x5D,
    0x0B, 0xAD, 0x4C, 0x93, 0x02, 0xA5, 0xE9, 0x18, 0x6D, 0x44, 0xB2, 0x7E,
    0x66, 0xB0, 0xA8, 0x28, 0x8A, 0xD1, 0x97, 0x40, 0xE1, 0x44, 0x77, 0xC2,
    0x75, 0xA7, 0x6B, 0xAE, 0xEB, 0x0A, 0xF5, 0x0C, 0xAF, 0x5C, 0xAA, 0x38,
    0x84, 0x20, 0x53, 0xE9, 0x71, 0xE2, 0xA5, 0x40, 0x5C, 0x59, 0xB8, 0x85,
    0x88, 0x82, 0x4C, 0x3B, 0x7A, 0xE6, 0x78, 0x51, 0xE7, 0x9B, 0x51, 0x68,
    0x20, 0x69, 0x6A, 0xD8, 0xE7, 0x58, 0x16, 0x8A, 0xD2, 0xAB, 0x48, 0xD1,
    0x0D, 0x48, 0xEF, 0x49, 0x2D, 0xCE, 0x12, 0x6E, 0x97, 0x0A, 0x3A, 0x04,
    0x3B, 0x5B, 0xBA, 0x7F, 0x27, 0x26, 0x2A, 0x2A, 0x92, 0x0E, 0xC6, 0x2B,
    0x0A, 0x0C, 0xDD, 0x74, 0x2C, 0x4E, 0x9C, 0xAC, 0x48, 0x77, 0x11, 0xC1,
    0x9C, 0x38, 0x55, 0x60, 0x0F, 0x8D, 0xC9, 0x1C, 0x76, 0x7C, 0x12, 0x19,
    0x67, 0xB2, 0x60, 0x7C, 0x07, 0x83, 0x80, 0x13, 0xFF, 0xFE, 0x78, 0x4B,
    0x07, 0x54, 0x86, 0x31, 0x42, 0xA5, 0x5B, 0xD8, 0x5F, 0x70, 0x62, 0x6B,
    0x79, 0xF5, 0x1C, 0xB2, 0xF4, 0x41, 0x14, 0x44, 0xC1, 0x84, 0x2C, 0xD4,
    0xED, 0xCF, 0x81, 0xDE, 0x16, 0x5A, 0x87, 0x4A, 0x3C, 0x90, 0xE3, 0x30,
    0xCA, 0x39, 0xA7, 0xE2, 0x36, 0x02, 0x52, 0xCF, 0x31, 0x3B, 0x1B, 0x18,
    0xC8, 0xB6, 0x0A, 0x24, 0xAE, 0xCE, 0x64, 0x4A, 0x3D, 0xFA, 0x75, 0xA8,
    0x82, 0x25, 0xEA, 0x64, 0x09, 0x41, 0x37, 0x75, 0x6C, 0x8E, 0x20, 0xDC,
    0xC1, 0x0E, 0xD1, 0x11, 0xF1, 0x9F, 0x52, 0xC2, 0x08, 0xAB, 0x59, 0xD2,
    0xCF, 0xA4, 0x2C, 0xA2, 0x36, 0x41, 0xDB, 0x23, 0x29, 0x73, 0x04, 0xB6,
    0xE9, 0x8B, 0x38, 0x8A, 0xB2, 0xA2, 0x41, 0xBD, 0x84, 0xD0, 0xC2, 0xAE,
    0xB3, 0x09, 0xC1, 0x02, 0xB6, 0x35, 0x5D, 0xF1, 0x7B, 0x9A, 0x7C, 0x78,
    0xAF, 0xD4, 0x9A, 0x88, 0x4C, 0x0D, 0x50, 0x34, 0x1C, 0x93, 0x97, 0x47,
    0x3E, 0x9A, 0x72, 0x3B, 0x81, 0xDD, 0xF7, 0x47, 0xD2, 0x64, 0x9C, 0xA1,
    0x05, 0x53, 0x2D, 0x75, 0x9E, 0x42, 0x3D, 0xFC, 0xFC, 0x17, 0xFF, 0x01,
    0xDC, 0xF1, 0x18, 0xD3};
const uint8_t g_esES_Locale[] = {
    0x78, 0x9C, 0x9D, 0x56, 0xCF, 0x6B, 0xD4, 0x40, 0x14, 0xBE, 0x0B, 0xFE,
    0x0F, 0x21, 0x58, 0x56, 0xA1, 0xDD, 0xD1, 0x63, 0xCB, 0x36, 0x50, 0xDA,
    0xDA, 0x95, 0x1A, 0x59, 0x9A, 0xAA, 0xD8, 0x8B, 0x4C, 0x92, 0xE9, 0xEE,
    0xB4, 0xC9, 0xCC, 0x32, 0x49, 0x2C, 0x9B, 0xA3, 0xE0, 0x41, 0x10, 0x0B,
    0xDE, 0x8A, 0x27, 0x0F, 0x1E, 0x04, 0x8B, 0x77, 0x51, 0x3C, 0xF4, 0x3F,
    0x11, 0x6A, 0xEB, 0xC9, 0x7F, 0xC1, 0x37, 0x9B, 0x49, 0x36, 0x3F, 0x66,
    0xD7, 0x60, 0x4E, 0xF3, 0xBE, 0xF7, 0x7D, 0x2F, 0xEF, 0x7D, 0x93, 0x4C,
    0xD2, 0x0B, 0xB8, 0x87, 0x03, 0x62, 0x30, 0x1C, 0x92, 0x75, 0x93, 0x44,
    0xCF, 0xB7, 0x1D, 0xD3, 0xF0, 0x49, 0xE4, 0xAD, 0x9B, 0xD7, 0x1F, 0x7F,
    0x5C, 0x9D, 0x9E, 0x5F, 0xBD, 0x3E, 0xBB, 0xFE, 0x72, 0x7E, 0xBB, 0x08,
    0xFE, 0x7C, 0x7B, 0x73, 0xF9, 0xFE, 0xFB, 0xEF, 0xB3, 0x57, 0xBF, 0xDE,
    0xBE, 0xBB, 0xFC, 0x7A, 0x7A, 0xC7, 0xB4, 0x7A, 0xB2, 0x00, 0xF3, 0xB1,
    0x70, 0x26, 0xA1, 0xCB, 0x83, 0x48, 0xD5, 0x1A, 0x0A, 0x32, 0xE4, 0x82,
    0x62, 0x06, 0x8C, 0x90, 0xB3, 0x78, 0xF4, 0x08, 0xE0, 0x48, 0xAD, 0x2D,
    0xC2, 0x88, 0xE0, 0x3D, 0x94, 0x05, 0x37, 0x6F, 0x28, 0xF4, 0x90, 0xB8,
    0x42, 0x87, 0x87, 0x58, 0xA4, 0x4D, 0x14, 0xBB, 0x82, 0x06, 0x1A, 0xEE,
    0xA4, 0x49, 0x3D, 0x4A, 0x18, 0xD5, 0xA1, 0x81, 0x06, 0xC5, 0x43, 0x1E,
    0xC5, 0x4D, 0x38, 0x22, 0xE3, 0x98, 0x92, 0x10, 0x1A, 0x6C, 0xA4, 0xB8,
    0x17, 0x27, 0x3A, 0x9C, 0xF1, 0x17, 0x73, 0x14, 0x3E, 0xF5, 0x1A, 0x19,
    0x54, 0x72, 0x29, 0x27, 0x4E, 0x23, 0x03, 0xBB, 0xAE, 0x58, 0x37, 0xEF,
    0x99, 0x25, 0xF3, 0x74, 0xD6, 0xE9, 0x6C, 0xD3, 0x99, 0xA6, 0xB3, 0x4C,
    0xE7, 0x98, 0xCE, 0x2F, 0x9D, 0x5B, 0x3A, 0xAB, 0x74, 0x1E, 0xE9, 0xFC,
    0xD1, 0x39, 0x33, 0xDF, 0x13, 0x1F, 0x4F, 0xD4, 0x53, 0x04, 0x2B, 0xCB,
    0xE7, 0x21, 0x65, 0xF2, 0xF6, 0x32, 0xC8, 0xB2, 0x56, 0x90, 0x30, 0x12,
    0x55, 0x10, 0x30, 0x21, 0xAE, 0x43, 0xF4, 0xE2, 0x93, 0xF0, 0x78, 0x50,
    0x83, 0x8F, 0x12, 0xF2, 0xA2, 0x06, 0xC1, 0xFE, 0x89, 0x7A, 0xC1, 0xE8,
    0xE2, 0x83, 0x8B, 0xFD, 0xD9, 0x6D, 0x51, 0xD1, 0x55, 0xA9, 0xC3, 0xD2,
    0x9E, 0xA9, 0x56, 0xEB, 0x6D, 0xD6, 0x9B, 0x6C, 0x74, 0x58, 0xEF, 0xAD,
    0xDE, 0x58, 0xA3, 0x29, 0x7D, 0x47, 0x21, 0x11, 0xD4, 0x87, 0x87, 0x2D,
    0x7F, 0xFD, 0x54, 0x68, 0x6D, 0xD8, 0xE0, 0x6E, 0x1E, 0x94, 0x78, 0xD6,
    0xA0, 0x96, 0x40, 0xD5, 0x0A, 0x80, 0x10, 0x81, 0x55, 0x35, 0x58, 0x59,
    0xB8, 0xBB, 0xD9, 0xED, 0x21, 0xB9, 0xCA, 0x52, 0x96, 0x5F, 0x06, 0x50,
    0x41, 0x96, 0x41, 0xED, 0xA8, 0xC8, 0xBA, 0x8F, 0xC9, 0x00, 0xC7, 0x31,
    0x18, 0x3D, 0xDD, 0xD7, 0x22, 0x52, 0xE7, 0xC8, 0x61, 0x12, 0x04, 0xA6,
    0xB5, 0x0D, 0x97, 0xB1, 0xD5, 0x81, 0xA3, 0xC9, 0xE8, 0xD8, 0x70, 0x65,
    0xAB, 0x67, 0x70, 0xC9, 0x69, 0x0B, 0x4D, 0xAD, 0xA0, 0x2A, 0x11, 0x70,
    0x36, 0x34, 0xAD, 0xFF, 0x55, 0x87, 0xC4, 0x07, 0xF1, 0x16, 0xB2, 0x6D,
    0xD4, 0x52, 0x11, 0x8D, 0xB8, 0x88, 0x67, 0x9A, 0x86, 0x02, 0x55, 0x66,
    0x06, 0x20, 0xA6, 0x61, 0xC9, 0x83, 0x52, 0x54, 0xF1, 0xA0, 0xDF, 0xEF,
    0xF4, 0xA1, 0xFD, 0x0E, 0x5C, 0x0E, 0x9C, 0xD2, 0x07, 0x3D, 0x54, 0x62,
    0xD6, 0xCA, 0x54, 0x26, 0xEF, 0xF7, 0xD7, 0x6C, 0x7B, 0xCD, 0x71, 0x5A,
    0x49, 0xA6, 0xE3, 0x2A, 0x41, 0x0B, 0xBA, 0x9A, 0x55, 0x0A, 0x1A, 0x6C,
    0x54, 0x99, 0x4B, 0x59, 0xB5, 0x0F, 0x58, 0xBE, 0xFD, 0x3B, 0x89, 0x1D,
    0x1F, 0x8F, 0xC2, 0xC8, 0xD9, 0xDE, 0xBA, 0x7F, 0xF2, 0x14, 0x8F, 0x76,
    0xD3, 0x83, 0xCC, 0x9C, 0x32, 0x09, 0x74, 0x2C, 0x09, 0x5D, 0x22, 0x66,
    0x0E, 0x55, 0x62, 0xD5, 0x08, 0x60, 0xF0, 0x9C, 0x7A, 0xA6, 0x95, 0x2E,
    0xA7, 0xE9, 0x6A, 0x37, 0x4D, 0xD3, 0x1E, 0xAA, 0xF0, 0x1A, 0x85, 0x94,
    0xD0, 0x4B, 0x84, 0x20, 0xCC, 0x9B, 0xE4, 0xCA, 0xD5, 0x55, 0xE3, 0x56,
    0x4B, 0xE9, 0x98, 0x08, 0x8F, 0xB0, 0x58, 0x29, 0x97, 0x34, 0x2A, 0x54,
    0x6B, 0xBD, 0x28, 0x94, 0x4F, 0x57, 0x09, 0x55, 0x59, 0x9F, 0x78, 0x34,
    0xC4, 0xB0, 0xE3, 0xCB, 0xB9, 0x3E, 0x4B, 0xD7, 0xD5, 0xC5, 0x97, 0x96,
    0x27, 0x63, 0x2A, 0x37, 0xBA, 0xDB, 0x8A, 0x5F, 0x74, 0xBD, 0xD4, 0x8A,
    0x0E, 0x87, 0x6C, 0x12, 0x99, 0xD6, 0x4A, 0x2B, 0x72, 0x0A, 0x9F, 0x6F,
    0xD3, 0xBA, 0xDB, 0xE4, 0xA2, 0xEA, 0xD8, 0x80, 0xE4, 0xBE, 0x17, 0x4E,
    0x54, 0x81, 0xFC, 0xF9, 0x9A, 0x06, 0xA6, 0xF5, 0xF3, 0xE5, 0x67, 0x38,
    0x3E, 0x2A, 0x8C, 0x66, 0x11, 0xA5, 0xA1, 0x11, 0x97, 0x0B, 0x38, 0x35,
    0x1E, 0xEF, 0xB5, 0x16, 0x95, 0x4D, 0x6F, 0x4A, 0x50, 0xBD, 0x5B, 0xF9,
    0x32, 0x4C, 0xC6, 0xE4, 0x10, 0x7B, 0xF2, 0x1C, 0xCC, 0x97, 0xAA, 0x96,
    0x3D, 0x81, 0x1F, 0x1F, 0xDF, 0x18, 0x80, 0x17, 0xA8, 0xCC, 0xCC, 0xD3,
    0x14, 0xFE, 0x46, 0xD8, 0xDC, 0xF4, 0x26, 0x4F, 0x04, 0x7C, 0x77, 0x0C,
    0x27, 0xF6, 0xB5, 0xF9, 0x0D, 0x9F, 0xBB, 0xC4, 0x18, 0xD0, 0x7F, 0x10,
    0xFA, 0xF2, 0x67, 0xEA, 0x64, 0x01, 0x61, 0x43, 0x60, 0x17, 0x5E, 0x98,
    0xF9, 0x84, 0xFD, 0x11, 0xA6, 0xDA, 0xF4, 0x2E, 0x4F, 0x93, 0x63, 0x6C,
    0xEC, 0xF0, 0x78, 0x44, 0x3D, 0x39, 0xC7, 0xCA, 0x93, 0x07, 0x86, 0xBD,
    0x88, 0x0A, 0x23, 0x7B, 0x23, 0x9E, 0x53, 0xF7, 0x16, 0xDC, 0x14, 0x98,
    0x43, 0x39, 0x99, 0xF1, 0x70, 0x01, 0xC9, 0xE1, 0x2D, 0x48, 0xF6, 0x24,
    0x61, 0xC3, 0x23, 0x3E, 0xE5, 0xA9, 0xE6, 0xD0, 0x6C, 0xCF, 0x64, 0x94,
    0xFD, 0xFC, 0xC2, 0xF2, 0x2F, 0x7C, 0xDC, 0xCC, 0x2F,
};
const uint8_t g_esLA_Locale[] = {
    0x78, 0x9C, 0x9D, 0x56, 0xCD, 0x4E, 0xDC, 0x30, 0x10, 0x3E, 0x53, 0xA9,
    0xEF, 0x60, 0x45, 0x45, 0x80, 0x04, 0x9B, 0xF6, 0xB8, 0x28, 0x44, 0x5A,
    0x01, 0xA5, 0x15, 0x0D, 0x5A, 0x75, 0x51, 0x4B, 0xB9, 0x54, 0x4E, 0x62,
    0x36, 0x86, 0xC4, 0x5E, 0x39, 0x09, 0x68, 0xA3, 0xBE, 0x40, 0x4F, 0x3D,
    0xF4, 0xD4, 0x63, 0x2B, 0x21, 0xB5, 0x07, 0xD4, 0x47, 0xE8, 0x81, 0x67,
    0x41, 0xF0, 0x18, 0x9D, 0xFC, 0x6E, 0x12, 0x3B, 0xE9, 0xD2, 0x9C, 0x3C,
    0xDF, 0x7C, 0x9F, 0x77, 0xE6, 0xB3, 0x33, 0x1B, 0xC3, 0xE7, 0x0E, 0xF6,
    0x09, 0x62, 0x38, 0x20, 0x3B, 0x1A, 0x09, 0x3F, 0x5A, 0x27, 0x1A, 0x72,
    0x49, 0xE8, 0xEC, 0x68, 0x0F, 0xD7, 0x7F, 0xEE, 0xBF, 0xDC, 0xDC, 0x7F,
    0xFE, 0xF6, 0xF0, 0xFB, 0x66, 0xFD, 0xEE, 0xC7, 0x4F, 0x88, 0xEF, 0xBE,
    0x5E, 0x6F, 0x68, 0xE6, 0xD3, 0x27, 0x08, 0x19, 0xA9, 0x8A, 0xB9, 0x58,
    0x4C, 0xE6, 0x81, 0xCD, 0xFD, 0xB0, 0xD8, 0x60, 0x2A, 0xC8, 0x94, 0x0B,
    0x8A, 0x59, 0xCA, 0x5A, 0x41, 0x46, 0xC0, 0x59, 0xE4, 0x1D, 0x41, 0x2A,
    0x4C, 0xE3, 0x95, 0x3C, 0x36, 0x09, 0x23, 0x82, 0x1B, 0x7A, 0x1E, 0xD4,
    0xF0, 0x33, 0x62, 0x0B, 0x75, 0x26, 0xC0, 0x22, 0x51, 0xE1, 0xD8, 0x16,
    0xD4, 0x57, 0xF2, 0xE7, 0x2A, 0xFA, 0x79, 0xCC, 0xA8, 0x1A, 0xF7, 0x95,
    0x38, 0x9E, 0xF2, 0x30, 0x52, 0x25, 0x42, 0x32, 0x8B, 0x28, 0x09, 0xA0,
    0x5C, 0x45, 0x92, 0x3B, 0x51, 0xAC, 0xCE, 0x30, 0x7E, 0xD9, 0xA9, 0x72,
    0xA9, 0x23, 0xE5, 0x50, 0xB1, 0xAE, 0x1C, 0xAC, 0x3B, 0x8A, 0xB0, 0x6D,
    0x8B, 0x1D, 0xED, 0x85, 0xD6, 0xB2, 0x56, 0x6D, 0xAC, 0xDA, 0x54, 0xB5,
    0xA5, 0x6A, 0x43, 0xD5, 0x7E, 0xAA, 0xDD, 0x54, 0x7B, 0xA9, 0x36, 0x52,
    0xED, 0xA0, 0xDA, 0x3D, 0xB5, 0x6F, 0xFD, 0x8E, 0xB9, 0x78, 0x5E, 0xBB,
    0x81, 0x10, 0x99, 0x2E, 0x0F, 0x28, 0x4B, 0xCB, 0x49, 0x83, 0x0A, 0xF5,
    0x63, 0x46, 0xC2, 0x16, 0x06, 0x16, 0x45, 0x32, 0x48, 0x6F, 0x7F, 0x09,
    0x87, 0xFB, 0x52, 0xE2, 0x3C, 0x26, 0x97, 0x12, 0x08, 0x27, 0x2E, 0xE4,
    0x8D, 0xC3, 0xDB, 0xEF, 0x36, 0x76, 0x17, 0x25, 0xA0, 0x6C, 0xA5, 0xA8,
    0xBA, 0x75, 0xCA, 0x45, 0xF9, 0x72, 0xE9, 0x72, 0xE1, 0x8A, 0xAA, 0xE5,
    0x7A, 0xE5, 0x62, 0x15, 0x85, 0x76, 0x57, 0x19, 0x10, 0x41, 0x5D, 0xB8,
    0xB6, 0xF5, 0x57, 0xBC, 0x80, 0xCC, 0x91, 0x05, 0x67, 0x51, 0x06, 0xCD,
    0xD4, 0xB8, 0x95, 0x42, 0x8B, 0xB0, 0xB6, 0x39, 0x11, 0xB8, 0xB6, 0x2F,
    0x44, 0x26, 0x1E, 0xEC, 0x0E, 0x0C, 0x3D, 0x5D, 0x55, 0x90, 0x5B, 0x87,
    0x50, 0xB6, 0x2A, 0x45, 0x30, 0xA5, 0xF4, 0xD6, 0x98, 0xCA, 0x51, 0x17,
    0x47, 0x64, 0x8C, 0xA3, 0x08, 0x0E, 0xA6, 0x72, 0xBB, 0x42, 0x8A, 0x49,
    0x76, 0x16, 0xFB, 0xBE, 0x66, 0xEE, 0xC3, 0x83, 0xF6, 0xD6, 0x60, 0x22,
    0xA2, 0x35, 0x0B, 0x9E, 0x7C, 0xF5, 0x01, 0x9E, 0xD4, 0x89, 0x4A, 0xD3,
    0xB5, 0x89, 0xCF, 0xD9, 0x54, 0x33, 0xFF, 0x5F, 0x1F, 0x10, 0x17, 0xE4,
    0x7B, 0xBA, 0x65, 0xE9, 0x4B, 0x6B, 0x42, 0x8F, 0x8B, 0x68, 0xA1, 0x6A,
    0x6B, 0x10, 0x6A, 0x20, 0x85, 0x23, 0x11, 0x0D, 0x5A, 0x8E, 0xD4, 0x90,
    0x86, 0x23, 0x9E, 0xB7, 0x6D, 0x59, 0xDB, 0x93, 0x09, 0x1A, 0xA1, 0x53,
    0x43, 0xAF, 0xB1, 0xBA, 0x64, 0xB9, 0x07, 0x8F, 0x96, 0x65, 0xAD, 0x2F,
    0x54, 0x4B, 0x69, 0x8A, 0xD6, 0x33, 0x95, 0x2C, 0x49, 0x3B, 0x6F, 0xF5,
    0x59, 0xDC, 0x85, 0x63, 0x40, 0xCB, 0x0B, 0x72, 0x10, 0x5B, 0xD1, 0x85,
    0x17, 0x84, 0x93, 0xFD, 0xBD, 0x97, 0x57, 0xEF, 0xB1, 0x77, 0x98, 0x9C,
    0xE6, 0x86, 0xD5, 0x49, 0x99, 0x92, 0xC5, 0x81, 0x4D, 0x44, 0xD3, 0xB5,
    0x06, 0x56, 0x54, 0x05, 0x18, 0xDC, 0x6D, 0x47, 0x33, 0x93, 0xCD, 0x24,
    0x19, 0x0E, 0x92, 0x24, 0x31, 0xF4, 0x06, 0xAF, 0x5B, 0xEA, 0xC4, 0x42,
    0x10, 0xE6, 0xCC, 0x35, 0xF3, 0x59, 0x2E, 0x1E, 0x0E, 0x3F, 0xAD, 0x57,
    0xCB, 0x8D, 0xA5, 0xF7, 0x99, 0x11, 0xE1, 0x10, 0x16, 0x15, 0x25, 0xAC,
    0xCA, 0xBA, 0xD4, 0x1B, 0xA9, 0x9F, 0xAA, 0xC7, 0x45, 0xDB, 0x2B, 0x4D,
    0xA8, 0xD8, 0xDE, 0x25, 0x0E, 0x0D, 0x30, 0x5C, 0x8E, 0x41, 0xB9, 0x4B,
    0x9E, 0xEE, 0x14, 0x4C, 0x05, 0x8F, 0x67, 0x34, 0xBD, 0x17, 0x9B, 0x4B,
    0x2A, 0xAA, 0x0E, 0x56, 0x97, 0x14, 0xC0, 0x84, 0x8F, 0x43, 0xCD, 0xDC,
    0x5A, 0x92, 0x9E, 0xC0, 0x77, 0x87, 0x66, 0x3E, 0x97, 0xD8, 0x0B, 0x63,
    0x1A, 0x67, 0x5F, 0x1E, 0x4C, 0xC3, 0x99, 0x26, 0x58, 0xDE, 0xC9, 0x2C,
    0x80, 0x03, 0x84, 0x59, 0xD4, 0xC8, 0xF7, 0x68, 0x68, 0xC8, 0xD3, 0x85,
    0x66, 0x5A, 0x27, 0x47, 0x8F, 0x90, 0xD5, 0x8F, 0x41, 0x12, 0x65, 0xC3,
    0x50, 0xAA, 0x3A, 0x7D, 0xF5, 0xE7, 0x33, 0x72, 0x86, 0x9D, 0x72, 0xE8,
    0x96, 0x61, 0xB1, 0xA7, 0x35, 0x87, 0xAF, 0x39, 0x17, 0x8D, 0xC1, 0x1D,
    0x5D, 0x4D, 0xA0, 0xF0, 0x49, 0xC5, 0x7A, 0x08, 0xBB, 0x3C, 0x16, 0xF0,
    0x17, 0x88, 0x26, 0x91, 0xDB, 0xC1, 0x18, 0xB9, 0xDC, 0x26, 0x68, 0x4C,
    0xFF, 0x49, 0x79, 0x95, 0x7E, 0x1F, 0x5E, 0xF5, 0x52, 0x46, 0x02, 0xDB,
    0xF0, 0xAE, 0xF5, 0x51, 0x8E, 0x3D, 0x4C, 0x3B, 0x08, 0x87, 0x3C, 0x89,
    0x2F, 0x30, 0x3A, 0xE0, 0x91, 0x47, 0x9D, 0xB4, 0xA7, 0xAD, 0x77, 0xAF,
    0x91, 0xD5, 0x4F, 0x06, 0x03, 0x1C, 0x8F, 0x97, 0xE4, 0xB7, 0xBD, 0x3F,
    0x0D, 0xDC, 0x69, 0xDA, 0x25, 0x7A, 0xD3, 0x4B, 0x9B, 0xF0, 0xA5, 0x68,
    0xD6, 0x3C, 0x66, 0xD3, 0x73, 0x9E, 0x31, 0xF3, 0x22, 0xB3, 0x11, 0x57,
    0x3B, 0x4F, 0x43, 0xCF, 0x3F, 0xEF, 0xCD, 0xBF, 0xC4, 0xB5, 0xD4, 0x04};
const uint8_t g_deDE_Loacale[] = {
    0x78, 0x9C, 0x95, 0x56, 0x4D, 0x6F, 0xD4, 0x30, 0x10, 0xBD, 0x23, 0xF1,
    0x1F, 0xAC, 0x88, 0xAA, 0x20, 0xB5, 0x1B, 0x38, 0xB6, 0xDA, 0x46, 0x5A,
    0x75, 0xFB, 0x41, 0x4B, 0xCA, 0xAA, 0x69, 0x41, 0xF4, 0x82, 0xBC, 0x89,
    0xBB, 0x71, 0x9B, 0xD8, 0x2B, 0xC7, 0x69, 0xB5, 0x39, 0xF2, 0x37, 0xB8,
    0x72, 0x04, 0x71, 0xE4, 0x04, 0x17, 0xFE, 0x09, 0x52, 0x25, 0x7E, 0x06,
    0x93, 0x8D, 0x93, 0x26, 0xB6, 0xBB, 0x0D, 0xB9, 0xAC, 0xE7, 0xCD, 0x7B,
    0xB3, 0x33, 0xCF, 0x89, 0x93, 0x61, 0xC2, 0x43, 0x9C, 0x10, 0xC4, 0x70,
    0x4A, 0x76, 0x9C, 0x88, 0x7C, 0x1C, 0xEF, 0x39, 0x28, 0x22, 0x59, 0xB8,
    0xE3, 0xDC, 0xFD, 0xFA, 0xF1, 0xF7, 0xFB, 0xB7, 0xE7, 0xF0, 0x73, 0xF7,
    0xF9, 0xE7, 0x0B, 0xC7, 0x1B, 0x96, 0x44, 0x16, 0x61, 0x11, 0x2C, 0xD2,
    0x29, 0x4F, 0x32, 0xA5, 0x99, 0x09, 0x32, 0xE3, 0x82, 0x62, 0x06, 0x8C,
    0x94, 0x33, 0x19, 0x9F, 0x00, 0x9C, 0xA9, 0xB5, 0x77, 0x84, 0x59, 0x8E,
    0xC5, 0xD0, 0xAD, 0xA2, 0xA7, 0x4F, 0x14, 0xBC, 0x4F, 0xA6, 0xC2, 0x86,
    0xFB, 0xBF, 0xBF, 0x88, 0xC2, 0x40, 0x47, 0x73, 0x41, 0x13, 0x93, 0x8B,
    0xA9, 0x81, 0x1D, 0xE5, 0xCC, 0x06, 0x26, 0x26, 0x38, 0xCA, 0x67, 0x79,
    0x26, 0x0D, 0x38, 0x20, 0x73, 0x49, 0xD2, 0x29, 0x31, 0x5B, 0x7B, 0x7B,
    0x2D, 0xB9, 0x0D, 0x3F, 0xE1, 0x37, 0x76, 0xC1, 0x98, 0x14, 0x7A, 0xC2,
    0x6D, 0x19, 0x54, 0xF3, 0x96, 0x11, 0xC2, 0xD3, 0xA9, 0xD8, 0x71, 0x5E,
    0x39, 0x2D, 0xDF, 0x6C, 0xA6, 0x99, 0x26, 0xD8, 0xED, 0xEA, 0x6B, 0x96,
    0xCD, 0x2B, 0x9B, 0x55, 0x36, 0x9F, 0x6C, 0x0E, 0xD9, 0xDC, 0xB1, 0x19,
    0xF3, 0xB0, 0x27, 0x11, 0x5E, 0xA8, 0x1B, 0x08, 0x56, 0x5E, 0xC0, 0x19,
    0x93, 0x18, 0xFE, 0xBE, 0x0C, 0xAA, 0xAC, 0xE7, 0x73, 0x03, 0x1A, 0x53,
    0xC2, 0x32, 0x83, 0x47, 0xA5, 0xBC, 0xE5, 0x61, 0xDC, 0x65, 0x42, 0x41,
    0x22, 0x0C, 0xEE, 0xBE, 0x20, 0x54, 0xC7, 0x02, 0x9C, 0x76, 0x78, 0x6E,
    0xD3, 0x5A, 0xAB, 0xCD, 0xD6, 0xC6, 0x55, 0xFD, 0x6A, 0xAD, 0x6A, 0x6D,
    0x6A, 0x0D, 0x6A, 0xAD, 0x69, 0x2D, 0x69, 0xDD, 0xD8, 0x1B, 0x49, 0x89,
    0xA0, 0x11, 0x25, 0x69, 0xFD, 0xD4, 0xA9, 0xD0, 0x1B, 0xF9, 0xE0, 0x6C,
    0x1D, 0xB4, 0x78, 0xDE, 0x44, 0x4B, 0xB8, 0xDD, 0x0A, 0x80, 0x10, 0x81,
    0x55, 0x35, 0x58, 0x79, 0x37, 0x03, 0xB4, 0x1B, 0x8B, 0xC1, 0xD0, 0x2D,
    0x83, 0x2A, 0xEB, 0x31, 0x0D, 0x73, 0x1B, 0x49, 0x19, 0x68, 0xE7, 0x44,
    0x35, 0x81, 0x24, 0x13, 0x2C, 0x25, 0x11, 0x6C, 0xB9, 0xB3, 0x4D, 0xA4,
    0x0E, 0x91, 0xCB, 0x3C, 0x49, 0x1C, 0x6F, 0x0F, 0xAE, 0x0D, 0x34, 0x1E,
    0x20, 0x1F, 0x2E, 0xF4, 0x01, 0xAE, 0x72, 0xD6, 0x86, 0xAB, 0x15, 0x52,
    0xD2, 0x84, 0xB3, 0x99, 0xE3, 0xFD, 0xA7, 0x28, 0x25, 0x11, 0x68, 0xC6,
    0x03, 0xDF, 0x1F, 0xF4, 0x54, 0x64, 0x31, 0x17, 0xF2, 0x5E, 0x63, 0x28,
    0xDC, 0xCE, 0x88, 0x00, 0x48, 0x9A, 0xB6, 0x46, 0x6E, 0x45, 0x9D, 0x91,
    0x0F, 0xB7, 0x7D, 0x7F, 0x1D, 0x9D, 0xC7, 0x02, 0xAD, 0x5F, 0x0C, 0xDD,
    0x16, 0x4B, 0x2B, 0xD1, 0x19, 0xF6, 0xB0, 0x54, 0x6D, 0x07, 0x01, 0xEA,
    0x23, 0x59, 0x8E, 0x5A, 0x2B, 0x7A, 0xF0, 0xD5, 0xA0, 0x4B, 0x85, 0x41,
    0x77, 0x3B, 0x53, 0x29, 0xA3, 0xCE, 0x00, 0xAB, 0xF7, 0xFA, 0xE0, 0xCA,
    0x97, 0xD7, 0x87, 0x69, 0x16, 0xEC, 0x8D, 0xF7, 0x6F, 0xDF, 0xE3, 0xF8,
    0xB8, 0xB8, 0xA8, 0xAC, 0x69, 0x93, 0x40, 0xC7, 0xF2, 0xF2, 0x68, 0xBC,
    0xF7, 0xA7, 0x13, 0xAB, 0x4E, 0x00, 0x83, 0x5B, 0x33, 0x74, 0xBC, 0x62,
    0xA3, 0x28, 0xB6, 0x06, 0x45, 0x01, 0xC7, 0x46, 0x87, 0x67, 0x14, 0x52,
    0xC2, 0x30, 0x17, 0x82, 0xB0, 0x70, 0x51, 0x2B, 0xB7, 0xB6, 0xD0, 0xB3,
    0x9E, 0xD2, 0x39, 0x11, 0x21, 0x61, 0x52, 0x29, 0xD7, 0x2C, 0x2A, 0x57,
    0x6B, 0xBD, 0x29, 0x54, 0x4F, 0xD7, 0x09, 0x9B, 0x17, 0x6B, 0x48, 0x53,
    0x0C, 0xFB, 0xBD, 0x51, 0xEB, 0xAB, 0xB4, 0xAE, 0x6E, 0xDE, 0xA9, 0x3C,
    0x9F, 0xD3, 0x72, 0xAB, 0x07, 0xBD, 0xF8, 0x4D, 0xD7, 0x6B, 0xBD, 0xE8,
    0x29, 0x65, 0x79, 0xE6, 0x78, 0x9B, 0xBD, 0xC8, 0x05, 0x11, 0xDC, 0xF1,
    0x5E, 0x9A, 0x5C, 0xB7, 0x3B, 0x36, 0x20, 0xB5, 0xEF, 0x8D, 0x13, 0x5D,
    0xA0, 0xBE, 0xC1, 0x96, 0x81, 0xE3, 0xFD, 0xF9, 0xF4, 0x15, 0xCE, 0x8A,
    0x0E, 0xC3, 0x2C, 0xA2, 0x34, 0x34, 0xE3, 0xE5, 0x02, 0x8E, 0x88, 0xF3,
    0xD3, 0xDE, 0xA2, 0xB6, 0xE9, 0xA6, 0xC4, 0xD5, 0xBB, 0x2D, 0x9F, 0x86,
    0xC5, 0x9C, 0x5C, 0xE2, 0xB0, 0x3C, 0xFA, 0xEA, 0xA5, 0xAA, 0xE5, 0x2F,
    0xE0, 0x13, 0x27, 0x42, 0x13, 0xF0, 0xC2, 0x6D, 0x33, 0xEB, 0x34, 0x65,
    0x94, 0xB3, 0x07, 0xD3, 0xBB, 0x3C, 0x17, 0x94, 0x08, 0x14, 0xC8, 0xC8,
    0x9A, 0x1F, 0x45, 0xF0, 0x69, 0x81, 0x26, 0xF4, 0x11, 0xC2, 0x21, 0x7C,
    0x35, 0x91, 0xDB, 0x15, 0x84, 0x91, 0xC0, 0x53, 0x78, 0x60, 0x1E, 0x26,
    0x9C, 0xC5, 0x98, 0x5A, 0xD3, 0xC7, 0xBC, 0xC8, 0xAF, 0x31, 0x3A, 0xE0,
    0x32, 0xA6, 0x61, 0x39, 0xC7, 0xE6, 0xBB, 0xD7, 0xC8, 0x5F, 0x45, 0x85,
    0x91, 0xC3, 0x98, 0xD7, 0xD4, 0xD3, 0x15, 0x7F, 0x0A, 0xCC, 0x59, 0x39,
    0x19, 0x7A, 0xB3, 0x82, 0x04, 0x6F, 0xFA, 0xC7, 0x49, 0xFE, 0x22, 0x67,
    0xB3, 0x2B, 0xBE, 0xE4, 0xA9, 0xE6, 0xDC, 0xFB, 0x3D, 0x2B, 0xA3, 0xEA,
    0x73, 0x16, 0x96, 0xFF, 0x00, 0x29, 0x27, 0xAF, 0x17,
};
const uint8_t g_frFR_Locale[] = {
    0x78, 0x9C, 0x95, 0x56, 0x4D, 0x6F, 0xD3, 0x40, 0x10, 0xBD, 0x23, 0xF1,
    0x1F, 0x56, 0x16, 0x55, 0x41, 0x6A, 0xBD, 0x70, 0x4C, 0x95, 0x5A, 0xAA,
    0xFA, 0x15, 0x28, 0x46, 0x51, 0x53, 0x40, 0xF4, 0x82, 0x36, 0xF6, 0x36,
    0xDE, 0xD4, 0xDE, 0x8D, 0xD6, 0x76, 0x4A, 0x7C, 0xE4, 0x3F, 0x70, 0xE2,
    0xC2, 0xB5, 0x12, 0x88, 0x03, 0x47, 0xC4, 0x85, 0xFE, 0x13, 0x24, 0x10,
    0x3F, 0x83, 0x71, 0xBC, 0x76, 0xED, 0x5D, 0x27, 0xB8, 0xBE, 0x64, 0xE7,
    0xCD, 0x7B, 0xE3, 0x99, 0xB7, 0xF6, 0xC6, 0xFD, 0x50, 0x78, 0x24, 0xA4,
    0x88, 0x93, 0x88, 0xEE, 0x5A, 0x17, 0xF2, 0xED, 0xD1, 0xA9, 0x85, 0x7C,
    0x1A, 0x7B, 0xBB, 0xD6, 0x9F, 0x6F, 0x1F, 0xFE, 0x7E, 0xFD, 0xF2, 0x10,
    0x7E, 0x7E, 0x7F, 0xFC, 0xF1, 0xC8, 0x72, 0xFA, 0x39, 0x91, 0xFB, 0x44,
    0x8E, 0x16, 0xD1, 0x58, 0x84, 0xB1, 0xD2, 0x4C, 0x24, 0x9D, 0x08, 0xC9,
    0x08, 0x07, 0x46, 0x24, 0x78, 0x12, 0xBC, 0x00, 0x38, 0x56, 0x6B, 0x67,
    0x4A, 0xF8, 0x9C, 0x51, 0xD9, 0xC7, 0x45, 0x78, 0xFF, 0x9E, 0xC2, 0x2F,
    0x6E, 0xAE, 0xE7, 0xB2, 0x2D, 0x11, 0x11, 0x19, 0x1B, 0x20, 0x01, 0x6E,
    0xD8, 0x42, 0x65, 0x06, 0x36, 0x4D, 0x19, 0x6F, 0x03, 0xC3, 0x90, 0x26,
    0x66, 0x59, 0x71, 0xF3, 0xDD, 0x44, 0x63, 0x3A, 0x4B, 0x68, 0x34, 0x96,
    0xD4, 0xC8, 0x08, 0x2F, 0x11, 0x6D, 0x38, 0x17, 0xF3, 0x76, 0x81, 0x7F,
    0x73, 0xED, 0xE9, 0x19, 0x5C, 0x33, 0xA9, 0x24, 0x2E, 0x23, 0x44, 0xC6,
    0x63, 0xB9, 0x6B, 0x3D, 0xB1, 0xEA, 0xDE, 0xD9, 0xED, 0xCE, 0x99, 0xF0,
    0x2A, 0xDF, 0xDA, 0x98, 0x77, 0xB0, 0xCD, 0x94, 0xAF, 0x36, 0xCD, 0xE4,
    0x82, 0x61, 0x26, 0x08, 0x6E, 0x99, 0x60, 0xEE, 0x94, 0xBD, 0xDA, 0x25,
    0x9F, 0x2C, 0xD4, 0x63, 0x05, 0x2B, 0xC7, 0x67, 0x11, 0xE1, 0x5E, 0x00,
    0xAE, 0xE6, 0x51, 0x91, 0x76, 0xC2, 0x94, 0xFB, 0xAC, 0x81, 0x80, 0x25,
    0x3A, 0x42, 0xA5, 0x27, 0xA9, 0x06, 0x4E, 0x69, 0xAA, 0x21, 0x73, 0x78,
    0xCC, 0x0D, 0x5A, 0x0C, 0xF7, 0xAF, 0x41, 0xB8, 0x6A, 0xA9, 0xD6, 0x5E,
    0x6D, 0x0B, 0x55, 0x9F, 0xB6, 0xDE, 0xA3, 0xAD, 0xB7, 0x68, 0xEB, 0x1D,
    0xDA, 0x7A, 0x77, 0xB6, 0xDE, 0x9C, 0xAD, 0x37, 0x66, 0xB7, 0xB7, 0x05,
    0xC5, 0x98, 0xCF, 0x68, 0x54, 0xBE, 0x91, 0x2A, 0x74, 0xF6, 0x5C, 0xF0,
    0xB7, 0x0C, 0x6A, 0x3C, 0x67, 0xA8, 0x25, 0x70, 0xB3, 0x02, 0x20, 0x54,
    0x12, 0x55, 0x0D, 0x56, 0xF0, 0x7C, 0xD9, 0xE8, 0x99, 0xBD, 0xBD, 0x0F,
    0xF7, 0xCF, 0xC3, 0x22, 0xEF, 0x90, 0x99, 0x8E, 0xE2, 0x4A, 0x96, 0x07,
    0xDA, 0x39, 0x52, 0xCC, 0x91, 0xD0, 0x21, 0x49, 0x12, 0x2A, 0xF9, 0x72,
    0x8F, 0xAB, 0xA8, 0x3C, 0x98, 0xD2, 0x30, 0xB4, 0x9C, 0x43, 0xB8, 0xD0,
    0x01, 0x72, 0xE1, 0x42, 0x6F, 0xE0, 0xCA, 0xA7, 0xAD, 0x98, 0x5A, 0x19,
    0x25, 0x0C, 0x05, 0x9F, 0x58, 0xCE, 0xDD, 0x34, 0xB0, 0xCF, 0x4A, 0x82,
    0x3A, 0xF1, 0xE3, 0x40, 0xC8, 0x04, 0x14, 0x07, 0xD8, 0x75, 0x71, 0x8B,
    0x02, 0x37, 0xA6, 0x03, 0x20, 0x61, 0x51, 0x6D, 0xDA, 0x5A, 0xD4, 0x98,
    0x76, 0x30, 0xD8, 0x44, 0x01, 0xDA, 0x84, 0x2E, 0xCE, 0xFB, 0xB8, 0x46,
    0xD2, 0x2A, 0x34, 0x06, 0x1D, 0x0C, 0x76, 0x5C, 0x77, 0x67, 0x34, 0xEA,
    0x24, 0x59, 0xCE, 0x59, 0x2A, 0x3A, 0xF0, 0xD5, 0x9C, 0x4B, 0x85, 0x41,
    0xC7, 0x8D, 0xA1, 0x94, 0x4F, 0x67, 0x80, 0x95, 0xBB, 0x7C, 0x4C, 0xDC,
    0xE9, 0xE5, 0x20, 0x8A, 0x47, 0x87, 0x07, 0x47, 0x57, 0xAF, 0xDF, 0x05,
    0x27, 0xD9, 0x79, 0xE1, 0x4C, 0x9D, 0x04, 0x3A, 0x9E, 0x46, 0x63, 0x2A,
    0x6F, 0xED, 0x69, 0xC4, 0xAA, 0x13, 0xC0, 0xE0, 0xC1, 0xF4, 0x2C, 0x27,
    0xDB, 0xCA, 0xB2, 0x9E, 0x9D, 0x65, 0x59, 0x1F, 0x37, 0x78, 0x46, 0x21,
    0x25, 0xF4, 0x52, 0x29, 0x29, 0xF7, 0x16, 0xA5, 0xB2, 0xD7, 0x43, 0x0F,
    0x3A, 0x4A, 0x67, 0x70, 0x76, 0x50, 0x9E, 0x28, 0xE5, 0x46, 0x8B, 0x0A,
    0x6B, 0xAD, 0x57, 0x85, 0xCA, 0xE9, 0x1A, 0xA1, 0x2A, 0xEB, 0x53, 0x0F,
    0x4E, 0x33, 0xD8, 0xEE, 0xAD, 0x52, 0x5F, 0xA4, 0x75, 0x75, 0xF5, 0x6F,
    0x2B, 0xD2, 0x19, 0xCB, 0xB7, 0xFA, 0xE7, 0xA7, 0x4E, 0x82, 0xAA, 0xED,
    0x8D, 0x4E, 0xF4, 0x88, 0xF1, 0x34, 0xB6, 0x9C, 0xED, 0x4E, 0xE4, 0x8C,
    0x4A, 0x61, 0x39, 0x8F, 0x4D, 0x2E, 0x6E, 0xCE, 0x0D, 0x48, 0x69, 0x7C,
    0x65, 0x45, 0x13, 0x28, 0x9F, 0xB0, 0x65, 0x60, 0x39, 0xBF, 0xDE, 0x7F,
    0x86, 0x63, 0xA2, 0xC1, 0x30, 0x8B, 0x28, 0x0D, 0x8B, 0x45, 0xBE, 0x80,
    0xD3, 0xE1, 0xE5, 0x69, 0x67, 0x51, 0xDD, 0x75, 0x53, 0x82, 0xF5, 0x6E,
    0xF3, 0xD7, 0x61, 0x31, 0xA3, 0x17, 0xC4, 0xCB, 0x4F, 0xBE, 0x72, 0xA9,
    0x6A, 0xB9, 0x0B, 0xF8, 0xFA, 0xF1, 0xD1, 0x10, 0xBC, 0xC0, 0x75, 0x66,
    0x99, 0x66, 0x9C, 0x09, 0xBE, 0x32, 0xBD, 0x2F, 0xD2, 0xFC, 0x3B, 0x08,
    0x8D, 0x12, 0xBF, 0x35, 0xBF, 0xE7, 0x8B, 0x31, 0x45, 0x43, 0xF6, 0x1F,
    0xC2, 0x80, 0xC2, 0x57, 0xC6, 0xD5, 0x1A, 0xC2, 0x9E, 0x24, 0x63, 0x78,
    0x63, 0x56, 0x13, 0xCE, 0x02, 0xC2, 0x5A, 0xD3, 0x27, 0x22, 0x4B, 0x2F,
    0x09, 0x3A, 0x16, 0x49, 0xC0, 0xBC, 0x7C, 0x8E, 0xED, 0x57, 0x4F, 0x91,
    0xBB, 0x8E, 0x0A, 0x23, 0x7B, 0x81, 0x28, 0xA9, 0xA7, 0x6B, 0x6E, 0x0A,
    0xCC, 0x49, 0x3E, 0x19, 0x7A, 0xBE, 0x86, 0x34, 0x12, 0x1D, 0x48, 0xEE,
    0x22, 0xE5, 0x93, 0xA9, 0x58, 0xF2, 0x54, 0x73, 0xF8, 0x76, 0xCF, 0xF2,
    0xA8, 0xF8, 0xD2, 0x85, 0xE5, 0x3F, 0x5D, 0x49, 0xBE, 0x1B};
const uint8_t g_itIT_Locale[] = {
    0x78, 0x9C, 0x95, 0x56, 0xD1, 0x6A, 0xD4, 0x40, 0x14, 0x7D, 0x17, 0xFC,
    0x87, 0x21, 0x58, 0x50, 0x68, 0x3B, 0xFA, 0xD8, 0x92, 0x06, 0x4A, 0x5B,
    0xBB, 0xA5, 0x46, 0x96, 0xEE, 0xAA, 0xD8, 0x17, 0x99, 0x64, 0xA6, 0xD9,
    0xB1, 0xC9, 0xCC, 0x32, 0x49, 0x5A, 0x92, 0x47, 0xF1, 0xC1, 0x37, 0x7F,
    0x42, 0x10, 0x41, 0xF1, 0x23, 0xFC, 0x13, 0xA1, 0xE2, 0x67, 0x78, 0xB3,
    0x99, 0xA4, 0xC9, 0x64, 0xBA, 0xA6, 0x79, 0xD9, 0xB9, 0xE7, 0x9E, 0x73,
    0x73, 0xEF, 0x99, 0x64, 0x36, 0x6E, 0x2C, 0x43, 0x12, 0x33, 0x24, 0x48,
    0xC2, 0xF6, 0x1C, 0x9E, 0xBD, 0x3B, 0x99, 0x3B, 0x88, 0xB2, 0x34, 0xDC,
    0x73, 0xFE, 0x7C, 0xFC, 0x7C, 0xF3, 0xE5, 0xEB, 0xCD, 0xA7, 0x6F, 0x7F,
    0x7F, 0xFE, 0x78, 0xDC, 0x06, 0x4F, 0x1C, 0xCF, 0xAD, 0x14, 0x82, 0x12,
    0x35, 0x2B, 0x92, 0x40, 0xC6, 0xA9, 0x16, 0x47, 0x8A, 0x45, 0x52, 0x71,
    0x22, 0x80, 0x91, 0x48, 0x91, 0x2D, 0x5E, 0x02, 0x9C, 0xEA, 0xB5, 0x17,
    0x31, 0x21, 0x08, 0x97, 0x2E, 0xAE, 0xC3, 0x87, 0x0F, 0x34, 0x7E, 0xC1,
    0x82, 0x40, 0xD9, 0x12, 0x09, 0x51, 0xE5, 0x10, 0x25, 0x4B, 0xC5, 0x63,
    0x66, 0x21, 0x47, 0x91, 0xA5, 0x46, 0xC4, 0xF3, 0x48, 0x0C, 0xE1, 0x38,
    0x8F, 0x62, 0x0B, 0x9B, 0x44, 0x32, 0xCD, 0x86, 0x70, 0xCA, 0xB2, 0x8C,
    0x25, 0x81, 0x1A, 0xDE, 0x55, 0x66, 0x99, 0xB4, 0xE1, 0x42, 0x5E, 0xD9,
    0x05, 0x94, 0x87, 0x66, 0x02, 0x77, 0xAC, 0x6A, 0x78, 0xAB, 0x08, 0x11,
    0x30, 0x66, 0xCF, 0x79, 0xE6, 0x74, 0x1C, 0xB4, 0xB9, 0x67, 0x33, 0xCE,
    0x66, 0x9B, 0xCD, 0x33, 0x9B, 0x61, 0x36, 0xB7, 0x6C, 0x56, 0xD9, 0x7C,
    0xB2, 0x39, 0x64, 0x73, 0xC7, 0x66, 0xCC, 0xDD, 0x9E, 0x50, 0x52, 0xE8,
    0x47, 0x09, 0x56, 0x1E, 0x95, 0x09, 0x13, 0x3C, 0x24, 0x2E, 0xAE, 0xA2,
    0x3A, 0x0D, 0x3D, 0x0A, 0x46, 0x7F, 0x7D, 0xEF, 0x61, 0xE0, 0x43, 0x36,
    0x04, 0x99, 0x0A, 0x65, 0x3C, 0x80, 0xE1, 0xE1, 0xB9, 0x1A, 0x80, 0x57,
    0x4C, 0x30, 0x65, 0x82, 0x29, 0x09, 0x48, 0xF5, 0x90, 0x68, 0x08, 0xB7,
    0xCD, 0x75, 0x1A, 0xED, 0x6C, 0x9D, 0xEE, 0xD8, 0x6C, 0xD6, 0x6C, 0xD4,
    0xEC, 0xD1, 0x6C, 0xCE, 0xEC, 0xCB, 0x6C, 0xC9, 0xDE, 0x0F, 0x14, 0xE2,
    0x94, 0xB3, 0xA4, 0x79, 0x11, 0x75, 0xE8, 0xED, 0xFB, 0x60, 0x71, 0x13,
    0x74, 0x78, 0xDE, 0xD4, 0x48, 0xE0, 0x7E, 0x05, 0x40, 0x98, 0x22, 0xBA,
    0x1A, 0xAC, 0x3C, 0x72, 0xE0, 0xE2, 0xEA, 0xB7, 0x4E, 0x78, 0xF4, 0x36,
    0xC4, 0x2D, 0xB1, 0x0A, 0x8C, 0x03, 0xA3, 0x6E, 0x3C, 0x63, 0x53, 0x02,
    0x6F, 0x96, 0x12, 0xAB, 0x8D, 0x6D, 0x23, 0x7D, 0x9A, 0x5C, 0xE4, 0x71,
    0xEC, 0x78, 0x47, 0x70, 0xA1, 0x43, 0xE4, 0xC3, 0x85, 0xDE, 0xC2, 0x55,
    0xCD, 0xD7, 0x32, 0x8D, 0x32, 0x5A, 0x18, 0x4B, 0x11, 0x39, 0xDE, 0xE1,
    0xFD, 0x44, 0x09, 0xA3, 0x95, 0x06, 0x83, 0x04, 0x8F, 0x12, 0xA4, 0x0B,
    0xA9, 0x32, 0x2D, 0xB1, 0x29, 0x70, 0x6F, 0x3E, 0x00, 0x32, 0x9E, 0x74,
    0xE6, 0xED, 0x44, 0xBD, 0x79, 0x27, 0x93, 0x5D, 0xDF, 0xDF, 0x9D, 0xCD,
    0xD0, 0xB9, 0x8B, 0x3B, 0x1C, 0xA3, 0x40, 0x6F, 0xD2, 0xFB, 0x28, 0x56,
    0x63, 0x36, 0xF7, 0x18, 0xC1, 0xD7, 0x53, 0xAE, 0x14, 0x03, 0x3A, 0xEE,
    0x8D, 0xA4, 0x5D, 0x9A, 0x03, 0xD6, 0xEC, 0xF2, 0x71, 0xE1, 0xD3, 0xCB,
    0x49, 0x92, 0xCE, 0x8E, 0x0E, 0x9F, 0x5F, 0xBF, 0x21, 0x8B, 0xD3, 0xF2,
    0xBC, 0xF6, 0xA5, 0x4B, 0x02, 0x9D, 0xC8, 0x93, 0x80, 0xA9, 0x5B, 0x73,
    0x7A, 0xB1, 0xEE, 0x04, 0x30, 0x78, 0x14, 0x43, 0xC7, 0x2B, 0x37, 0xCB,
    0x72, 0x67, 0xBB, 0x2C, 0x4B, 0x17, 0xF7, 0x78, 0x83, 0x42, 0x5A, 0x18,
    0xE6, 0x4A, 0x31, 0x11, 0x16, 0x8E, 0xF7, 0x08, 0xD5, 0xDA, 0x9D, 0x9D,
    0x91, 0xD2, 0x25, 0x9C, 0x15, 0x4C, 0x64, 0xFA, 0x9E, 0x1B, 0x16, 0x15,
    0x36, 0x5A, 0x6F, 0x0B, 0x35, 0xD3, 0xF5, 0x42, 0x5D, 0x96, 0xB2, 0x90,
    0x27, 0x04, 0x36, 0x7B, 0xB3, 0xD1, 0xD7, 0x69, 0x53, 0xDD, 0xFE, 0xAD,
    0xCA, 0x7C, 0xC9, 0xAB, 0x9D, 0xDE, 0x1E, 0xC5, 0x6F, 0xBB, 0xDE, 0x18,
    0x45, 0x4F, 0xB8, 0xC8, 0x53, 0xC7, 0xDB, 0x1A, 0x45, 0x2E, 0x99, 0x92,
    0x8E, 0xF7, 0x74, 0xC8, 0xC5, 0xFD, 0xB1, 0x01, 0x69, 0x7C, 0x6F, 0x9D,
    0xE8, 0x03, 0xCD, 0x03, 0xB6, 0x0A, 0x1C, 0xEF, 0xF7, 0x07, 0x38, 0x65,
    0xFB, 0x8C, 0x61, 0x91, 0xE6, 0x23, 0x25, 0x95, 0xD5, 0x02, 0x0E, 0x87,
    0x57, 0x67, 0xA3, 0x45, 0x5D, 0xD3, 0x87, 0x12, 0x6C, 0x76, 0x5B, 0xBD,
    0x0D, 0xC5, 0x92, 0x5D, 0x90, 0xB0, 0x3A, 0xEA, 0x9A, 0xA5, 0xAE, 0xE5,
    0x17, 0xF0, 0x95, 0x43, 0xD1, 0x14, 0xBC, 0xC0, 0x5D, 0x66, 0x93, 0xE6,
    0x82, 0x4B, 0x71, 0x67, 0xFA, 0x40, 0xE6, 0x8A, 0x33, 0x85, 0x66, 0x19,
    0xB5, 0xE6, 0xF7, 0xA9, 0x0C, 0x18, 0x9A, 0xF2, 0xFF, 0x10, 0x26, 0x0C,
    0xBE, 0x23, 0xAE, 0xD7, 0x10, 0xF6, 0x15, 0x09, 0xE0, 0x85, 0xB9, 0x9B,
    0x30, 0x5F, 0x10, 0x6E, 0x4D, 0x9F, 0xCA, 0x32, 0xBF, 0x24, 0xE8, 0x58,
    0x66, 0x0B, 0x1E, 0x56, 0x73, 0x6C, 0xBD, 0x3E, 0x41, 0xFE, 0x3A, 0x2A,
    0x8C, 0x1C, 0x2E, 0x64, 0x43, 0x3D, 0x5B, 0x73, 0x53, 0x60, 0x46, 0xD5,
    0x64, 0xE8, 0xC5, 0x1A, 0xD2, 0x4C, 0x8E, 0x20, 0xF9, 0x45, 0x2E, 0xA2,
    0xF7, 0x72, 0xC5, 0xD3, 0xCD, 0xE1, 0xDB, 0x3D, 0xAB, 0xA2, 0xFA, 0xD3,
    0x16, 0x96, 0xFF, 0x00, 0x20, 0x8B, 0xBE, 0xF7};
const uint8_t g_ptBR_Locale[] = {
    0x78, 0x9C, 0x9D, 0x56, 0x3D, 0x6F, 0xD4, 0x40, 0x10, 0xAD, 0x83, 0xC4,
    0x7F, 0x58, 0x59, 0x89, 0x0E, 0xA4, 0x24, 0x86, 0x92, 0xC8, 0x67, 0xE9,
    0x92, 0x0B, 0x39, 0x94, 0x18, 0x9D, 0xCE, 0x11, 0x88, 0x34, 0x68, 0x6D,
    0xEF, 0xD9, 0x9B, 0xD8, 0xBB, 0xC7, 0xDA, 0x4E, 0xB0, 0x6B, 0x1A, 0x3A,
    0x28, 0x29, 0x53, 0x20, 0x2A, 0x44, 0x83, 0x44, 0x49, 0x91, 0xDF, 0x82,
    0xB8, 0x9F, 0xC1, 0xFA, 0xF3, 0xFC, 0xB1, 0x36, 0x06, 0x37, 0xDE, 0x99,
    0x79, 0x6F, 0x3D, 0xF3, 0x76, 0x76, 0x64, 0xC5, 0xA5, 0x26, 0x74, 0x11,
    0x20, 0xD0, 0x43, 0x63, 0x69, 0x15, 0xBC, 0x3E, 0x5C, 0x48, 0xC0, 0x42,
    0xBE, 0x39, 0x96, 0xD6, 0x1F, 0x6F, 0xD7, 0x1F, 0xDE, 0xFD, 0x7E, 0xFF,
    0x69, 0xFD, 0xED, 0xEB, 0x83, 0x5F, 0x3F, 0xBE, 0xAF, 0x3F, 0xFF, 0x7C,
    0x28, 0xA9, 0xF7, 0xEF, 0x01, 0xA0, 0x24, 0x14, 0x62, 0x41, 0xA6, 0x47,
    0x9E, 0x41, 0x5D, 0x3F, 0x67, 0xDB, 0x0C, 0xD9, 0x94, 0x61, 0x48, 0x12,
    0xD4, 0x16, 0x50, 0x3C, 0x4A, 0x02, 0xE7, 0x39, 0x0F, 0xF9, 0x89, 0xBD,
    0x95, 0xD9, 0xEA, 0x25, 0x24, 0x08, 0x33, 0xAA, 0xC8, 0x99, 0x59, 0x89,
    0x2C, 0xD1, 0x35, 0x62, 0x1D, 0x31, 0x0F, 0xB2, 0xBB, 0x2F, 0xA2, 0x00,
    0x34, 0x18, 0x76, 0x85, 0x04, 0x2C, 0x82, 0x5F, 0x86, 0xC4, 0x11, 0xFB,
    0x5D, 0xA1, 0x1F, 0xDA, 0xD4, 0x0F, 0x44, 0x01, 0x1F, 0x05, 0xC8, 0x33,
    0x84, 0xB9, 0xD2, 0x30, 0x08, 0xC5, 0x11, 0x42, 0xAF, 0xBB, 0x48, 0x16,
    0x8A, 0x9B, 0x21, 0x90, 0xAF, 0x4B, 0x09, 0xAB, 0x92, 0x02, 0x68, 0x18,
    0x6C, 0x2C, 0x3D, 0x96, 0x1A, 0xDA, 0x8A, 0x75, 0x15, 0x2B, 0x2A, 0x96,
    0x53, 0x2C, 0xA6, 0x58, 0x4B, 0xB1, 0x92, 0x62, 0x1D, 0xC5, 0x22, 0x8A,
    0xF5, 0x13, 0x6B, 0x27, 0x96, 0xAD, 0x5F, 0x31, 0x0B, 0x46, 0x95, 0x16,
    0xE4, 0x96, 0x6A, 0x51, 0x0F, 0x93, 0x24, 0x9D, 0xC4, 0x28, 0xBD, 0x3E,
    0xB2, 0x43, 0xDE, 0xD2, 0x7B, 0x4B, 0xDE, 0x80, 0xB0, 0x11, 0x0B, 0x10,
    0x6F, 0x3E, 0x71, 0xE8, 0x4D, 0x08, 0x59, 0xD0, 0x15, 0xC2, 0xA4, 0x23,
    0xE4, 0xA3, 0xB7, 0x5D, 0x91, 0xBB, 0x5B, 0x03, 0x5A, 0x9B, 0xE4, 0x40,
    0xBA, 0x12, 0xD4, 0xD3, 0x38, 0xFF, 0xBC, 0xB0, 0x76, 0x51, 0xED, 0x52,
    0xDA, 0x15, 0xB4, 0x13, 0x6F, 0xE7, 0x2B, 0xC8, 0xB3, 0x3B, 0x49, 0x0F,
    0x31, 0x6C, 0x61, 0xE4, 0x55, 0x2F, 0x7F, 0xEE, 0x52, 0x27, 0x1A, 0x3F,
    0xA4, 0xC2, 0xA8, 0x87, 0xE6, 0x8D, 0x10, 0xD8, 0x98, 0x95, 0xCD, 0x11,
    0x83, 0x95, 0x7D, 0xB9, 0xA5, 0x1E, 0x1E, 0x29, 0x72, 0xF2, 0x2E, 0x1D,
    0x93, 0x69, 0xE9, 0x00, 0xE9, 0xAA, 0x20, 0xF0, 0xD9, 0x25, 0x37, 0x86,
    0x57, 0xE6, 0xB5, 0x60, 0x80, 0xE6, 0x30, 0xE0, 0xF2, 0x90, 0x52, 0xE8,
    0xD2, 0x93, 0xCF, 0xB7, 0x65, 0xE8, 0xBA, 0x92, 0x7A, 0xCC, 0x9F, 0x5D,
    0x30, 0x1D, 0xF1, 0x29, 0x09, 0x46, 0x1A, 0x7F, 0xB2, 0xD5, 0x2B, 0xFE,
    0x24, 0x32, 0x94, 0xA4, 0xAE, 0x5D, 0x5C, 0x4A, 0x6C, 0x49, 0xFD, 0x7F,
    0xBE, 0x87, 0x2C, 0x4E, 0x9F, 0xCA, 0x9A, 0x26, 0x0F, 0xE6, 0xF8, 0x0E,
    0x65, 0xC1, 0x86, 0xD5, 0xE4, 0x00, 0x50, 0xF3, 0xE4, 0x92, 0x04, 0xD8,
    0x6B, 0x48, 0x52, 0xF1, 0xD4, 0x24, 0x99, 0xCD, 0x46, 0x0E, 0x2F, 0x65,
    0xC4, 0xEF, 0xD5, 0x48, 0xD7, 0x47, 0xFE, 0x08, 0x5C, 0x28, 0x72, 0x05,
    0xDC, 0xC5, 0xCE, 0xA4, 0x48, 0xC9, 0x19, 0x77, 0x38, 0x35, 0x55, 0x61,
    0x36, 0x3B, 0xD0, 0xB4, 0x03, 0x5D, 0x1F, 0xC4, 0xC8, 0x35, 0x48, 0x39,
    0x4D, 0x42, 0x22, 0x40, 0xA3, 0xDC, 0xBC, 0x27, 0xCE, 0xB9, 0xB7, 0x68,
    0x94, 0x93, 0x48, 0xB3, 0xAE, 0x66, 0x9E, 0xAF, 0x1F, 0x4F, 0x9F, 0xDE,
    0xBC, 0x84, 0xCE, 0x69, 0x7C, 0x91, 0xE9, 0x56, 0x05, 0xA5, 0x4C, 0x12,
    0x7A, 0x06, 0x62, 0x75, 0xF1, 0x6A, 0xBE, 0x3C, 0x27, 0xEE, 0xE3, 0xFD,
    0x6D, 0x4A, 0x6A, 0xBC, 0x1B, 0xC7, 0x4F, 0xF6, 0xE3, 0x98, 0x0F, 0xB3,
    0x1A, 0xAE, 0x9B, 0x6A, 0x86, 0x8C, 0x21, 0x62, 0x46, 0x92, 0xBA, 0x0D,
    0x0A, 0xF6, 0x60, 0xF2, 0x0A, 0x31, 0x13, 0x91, 0x20, 0xFF, 0xEE, 0x4E,
    0x9B, 0x97, 0x08, 0xD2, 0x2A, 0xA2, 0x2C, 0x6C, 0x53, 0xEB, 0x56, 0xDD,
    0x95, 0x6F, 0x6F, 0x21, 0x13, 0x7B, 0x90, 0x37, 0xC6, 0x6E, 0xB1, 0x4B,
    0x16, 0xEE, 0x24, 0xD8, 0x8C, 0x86, 0x2B, 0x9C, 0x34, 0xC3, 0xFE, 0x40,
    0x46, 0x59, 0xC1, 0xCE, 0x40, 0x02, 0xEF, 0xAF, 0xD0, 0x97, 0xD4, 0xBD,
    0x81, 0xF0, 0x18, 0x31, 0x2A, 0xA9, 0x8F, 0x5A, 0xE8, 0x8D, 0x30, 0xB5,
    0x03, 0x2F, 0x4E, 0xA3, 0xA6, 0x4C, 0xDD, 0x59, 0xB4, 0x61, 0x6A, 0x48,
    0xEA, 0x62, 0x9B, 0x4F, 0xA2, 0x1A, 0xA0, 0x87, 0x84, 0x7D, 0x9A, 0x2C,
    0x24, 0xF5, 0x70, 0x71, 0xF6, 0x0F, 0xB4, 0xEA, 0x39, 0xB4, 0x48, 0xE9,
    0x28, 0x6C, 0xA5, 0x9D, 0xDC, 0xFB, 0x68, 0x85, 0x96, 0xD0, 0x2C, 0xC6,
    0x6D, 0x61, 0xE6, 0x7B, 0x6A, 0x11, 0xFF, 0xC3, 0xB3, 0xC0, 0x9C, 0xCB,
    0x23, 0x8B, 0x01, 0x98, 0x60, 0x4A, 0x7A, 0x00, 0x47, 0x34, 0x64, 0x18,
    0x31, 0xA0, 0x07, 0x56, 0x07, 0x62, 0x62, 0x51, 0x03, 0x81, 0x39, 0xFE,
    0x2B, 0x64, 0x86, 0x0C, 0x86, 0x6E, 0x7A, 0x21, 0x13, 0x06, 0x0D, 0x7E,
    0xC3, 0xFA, 0x20, 0xE7, 0x0E, 0xC4, 0x1D, 0x80, 0x53, 0x1A, 0x87, 0x57,
    0x10, 0x9C, 0xD0, 0xC0, 0xC1, 0x66, 0x52, 0xD3, 0xDE, 0x8B, 0x67, 0x40,
    0xEB, 0x07, 0x73, 0x01, 0x4C, 0x87, 0x16, 0xE0, 0x45, 0xEF, 0xA7, 0x39,
    0xD6, 0x4E, 0xAA, 0x04, 0x67, 0xBD, 0x30, 0x9D, 0x0E, 0x82, 0x69, 0x51,
    0x48, 0xEC, 0x4B, 0x9A, 0x22, 0xB3, 0x24, 0xD3, 0xC1, 0x56, 0x39, 0x4F,
    0x45, 0xCE, 0xFE, 0xF7, 0xD5, 0x3F, 0x30, 0xBB, 0xD9, 0x9B};
const uint8_t g_nlNL_Locale[] = {
    0x78, 0x9C, 0x95, 0x56, 0x4D, 0x4F, 0xDC, 0x30, 0x10, 0x3D, 0x53, 0xA9,
    0xFF, 0xC1, 0x8A, 0x8A, 0x68, 0x25, 0x96, 0x2D, 0x47, 0x50, 0x88, 0xB4,
    0x05, 0x0A, 0x15, 0x04, 0xAD, 0x58, 0xDA, 0xAA, 0x5C, 0x2A, 0x6F, 0x62,
    0x76, 0xBD, 0x24, 0xF6, 0xCA, 0x89, 0x41, 0xC9, 0xB1, 0x52, 0x8F, 0xFD,
    0x27, 0xAD, 0xDA, 0x5B, 0xFF, 0x4F, 0xA5, 0x4A, 0xFC, 0x8C, 0x8E, 0xF3,
    0x45, 0x12, 0x3B, 0x69, 0xC8, 0x05, 0xCF, 0x9B, 0xF7, 0xBC, 0x33, 0xCF,
    0xCE, 0x10, 0x3B, 0xE0, 0x1E, 0x0E, 0x08, 0x62, 0x38, 0x24, 0x07, 0x16,
    0x0B, 0x3E, 0x5F, 0x9C, 0x5B, 0xC8, 0x27, 0x91, 0x77, 0x60, 0x3D, 0x7C,
    0xFB, 0xFD, 0xF7, 0xEB, 0xAF, 0x87, 0x9F, 0x3F, 0x5E, 0xE6, 0xAB, 0x57,
    0x96, 0xF3, 0xFC, 0x19, 0x42, 0xB6, 0xE2, 0x33, 0x1F, 0x8B, 0x59, 0x12,
    0xCE, 0x79, 0x10, 0x15, 0xD2, 0x85, 0x20, 0x0B, 0x2E, 0x28, 0x66, 0x8A,
    0xB5, 0x81, 0xEC, 0x90, 0xB3, 0x78, 0x79, 0x01, 0xA9, 0x48, 0xC5, 0x1B,
    0x79, 0xEC, 0xAC, 0x30, 0x93, 0x58, 0x50, 0x7B, 0x9C, 0x87, 0xB5, 0xCC,
    0x0D, 0x99, 0x8B, 0x8E, 0x54, 0x88, 0xB1, 0x88, 0x0D, 0x38, 0x5E, 0x0B,
    0x1A, 0x98, 0xF8, 0xC4, 0xB4, 0xCB, 0x4A, 0x32, 0x33, 0x1C, 0x98, 0x60,
    0x2C, 0x17, 0x32, 0x8A, 0x65, 0x64, 0x48, 0x45, 0x64, 0x1D, 0x93, 0x70,
    0x4E, 0x84, 0x21, 0xC7, 0x6F, 0x63, 0x6E, 0xCE, 0x30, 0x7E, 0xD7, 0x25,
    0xF2, 0x89, 0xD7, 0x4E, 0xA1, 0x62, 0x5D, 0x19, 0x58, 0x37, 0x14, 0xE1,
    0xF9, 0x5C, 0x1C, 0x58, 0xBB, 0x56, 0xCB, 0x59, 0xB3, 0xAB, 0x26, 0x83,
    0xBA, 0xEC, 0x7C, 0x8A, 0x99, 0x66, 0x2F, 0xCD, 0x56, 0x9A, 0x5D, 0x34,
    0xFB, 0x67, 0xF6, 0xCE, 0x6C, 0x5B, 0xBF, 0x63, 0x3E, 0x4E, 0x6A, 0x17,
    0x10, 0x22, 0x27, 0xE5, 0x70, 0x71, 0xA1, 0x1A, 0xB5, 0xAE, 0x40, 0xB8,
    0x5E, 0x06, 0xD4, 0xA7, 0x2C, 0xD2, 0xD1, 0x7B, 0x4E, 0x4C, 0xB0, 0x0F,
    0xFB, 0x12, 0xA1, 0xE3, 0x77, 0x82, 0xAE, 0x74, 0x34, 0xC5, 0x71, 0x93,
    0x8C, 0xB2, 0x95, 0xA1, 0xF2, 0xD6, 0x49, 0xE7, 0x2D, 0x68, 0xE5, 0x6B,
    0x95, 0x6B, 0x45, 0x6B, 0xE5, 0x6A, 0x75, 0x6A, 0x25, 0x76, 0x17, 0x17,
    0x12, 0x41, 0x7D, 0x4A, 0xC2, 0xFA, 0xCB, 0x5D, 0x40, 0xCE, 0xC4, 0x85,
    0x63, 0x28, 0x83, 0x66, 0x6A, 0xDA, 0x4A, 0xA1, 0xC7, 0xB0, 0xB6, 0x39,
    0x11, 0xB8, 0xB6, 0x2F, 0x44, 0xCE, 0x9B, 0x43, 0x7B, 0xAC, 0xFE, 0x56,
    0xC0, 0xE4, 0xA8, 0x02, 0x50, 0xB6, 0x2A, 0x05, 0x30, 0x9B, 0xC6, 0xAD,
    0xE1, 0x94, 0xA3, 0x3E, 0x18, 0x3E, 0xC5, 0x31, 0xB8, 0xCE, 0x2A, 0x83,
    0x2B, 0xA4, 0x98, 0x5F, 0x37, 0x32, 0x08, 0x2C, 0xE7, 0x18, 0x1E, 0x74,
    0x84, 0x5C, 0x78, 0xD0, 0x27, 0x78, 0x54, 0xEF, 0x15, 0xB3, 0x4B, 0x1A,
    0x70, 0xB6, 0xB0, 0x9C, 0xA7, 0xAA, 0x42, 0xE2, 0x83, 0x68, 0x04, 0x9A,
    0xD1, 0x60, 0x4D, 0xB4, 0xE4, 0x22, 0xCE, 0x54, 0x23, 0x5D, 0x81, 0x50,
    0x03, 0x29, 0x7A, 0x8F, 0x69, 0xD8, 0xEA, 0xBD, 0x86, 0x34, 0x7A, 0x3F,
    0xDD, 0x77, 0xDD, 0xFD, 0xD9, 0x6C, 0x0B, 0x49, 0x29, 0xB6, 0xD0, 0xB5,
    0x3D, 0xAE, 0x11, 0xBB, 0x94, 0x79, 0xEB, 0x85, 0x72, 0xA0, 0x26, 0x6B,
    0xBC, 0x90, 0x0C, 0x12, 0x14, 0x5D, 0x2B, 0x49, 0x9B, 0xAF, 0x7A, 0x6E,
    0x75, 0x58, 0x9C, 0xF7, 0x15, 0xA0, 0xE5, 0x25, 0x38, 0x49, 0x5C, 0xFF,
    0xF6, 0x34, 0x8C, 0x66, 0xC7, 0x47, 0x6F, 0xEF, 0x3F, 0xE2, 0xE5, 0x59,
    0x7A, 0x9D, 0x5B, 0x55, 0x27, 0x65, 0x4A, 0x26, 0xD5, 0x20, 0x6E, 0xFA,
    0xD5, 0xC0, 0xCA, 0x7F, 0x94, 0x52, 0xDD, 0x5D, 0xCF, 0x72, 0xD2, 0xED,
    0x34, 0xDD, 0xDB, 0x49, 0xD3, 0xD4, 0x1E, 0x37, 0x78, 0xDD, 0x52, 0x4F,
    0x0A, 0x41, 0x98, 0x97, 0x58, 0xCE, 0x0B, 0x94, 0xAB, 0xF7, 0xF6, 0xA2,
    0xC1, 0xEA, 0x35, 0x11, 0x1E, 0x61, 0x71, 0xF1, 0xC3, 0x9B, 0xBA, 0x4E,
    0x39, 0xA2, 0x75, 0x51, 0x75, 0xF6, 0xD8, 0xEC, 0x46, 0x13, 0x2A, 0xB6,
    0x87, 0x99, 0x4A, 0x43, 0x0C, 0x97, 0x61, 0xBB, 0xDC, 0x25, 0x4F, 0x77,
    0x0A, 0x16, 0x82, 0xCB, 0x35, 0x55, 0x97, 0x60, 0x67, 0xA0, 0xA2, 0xEA,
    0x60, 0x73, 0xA0, 0x20, 0xA4, 0x4C, 0x46, 0x96, 0x33, 0x1A, 0x48, 0x4F,
    0x89, 0xE0, 0x96, 0xF3, 0x5A, 0x63, 0x3F, 0x1A, 0xD3, 0x38, 0xF1, 0xF2,
    0x38, 0x1A, 0xCE, 0x34, 0xC1, 0xF2, 0x1A, 0x66, 0x81, 0xE5, 0xFC, 0xF9,
    0xF2, 0x1D, 0xE6, 0x4C, 0x83, 0xD1, 0xA3, 0xA2, 0x11, 0x57, 0x0B, 0x18,
    0x2D, 0xEF, 0x2F, 0x9F, 0x20, 0xAB, 0x1F, 0x84, 0x26, 0xCA, 0x06, 0x9D,
    0x56, 0xB7, 0x7A, 0xD9, 0x93, 0x35, 0xB9, 0xC1, 0x5E, 0x39, 0x4C, 0xCB,
    0xB0, 0xD8, 0xD3, 0x4D, 0xE0, 0xFB, 0xCC, 0x47, 0x53, 0xF0, 0x67, 0x6C,
    0x26, 0x50, 0x46, 0x39, 0xEB, 0x21, 0x1C, 0x72, 0x29, 0x28, 0x11, 0x68,
    0x16, 0xFB, 0x1D, 0x8C, 0x89, 0x0F, 0xDF, 0x3F, 0x68, 0x4A, 0xFF, 0x4B,
    0x39, 0x85, 0xEF, 0x3D, 0x72, 0xDF, 0x4B, 0x99, 0x08, 0x3C, 0x87, 0x77,
    0xAC, 0x8F, 0x72, 0xB5, 0xC4, 0xB4, 0x83, 0x70, 0xC6, 0x53, 0x79, 0x8B,
    0xD1, 0x09, 0x8F, 0x97, 0xD4, 0x53, 0x3D, 0x8D, 0x3E, 0xBC, 0x43, 0x6E,
    0x3F, 0x19, 0x0C, 0xF0, 0x96, 0xBC, 0x24, 0x5F, 0xF6, 0xFE, 0x34, 0x70,
    0x17, 0xAA, 0x4B, 0x74, 0xDE, 0x4B, 0x9B, 0xF1, 0x41, 0x34, 0x37, 0x91,
    0x6C, 0xB1, 0xE2, 0x19, 0x33, 0x2F, 0x32, 0x1B, 0x6D, 0xB5, 0xF3, 0xB4,
    0xC7, 0xF9, 0xA7, 0xBA, 0xF3, 0x0F, 0xD5, 0xFA, 0xC0, 0xFA};
const uint8_t g_ruRU_Locale[] = {
    0x78, 0x9C, 0xAD, 0x57, 0x4D, 0x4F, 0x13, 0x41, 0x18, 0x3E, 0x63, 0xE2,
    0x7F, 0x98, 0x6C, 0x24, 0x68, 0x02, 0xAD, 0x1E, 0x25, 0x65, 0x13, 0x22,
    0x0A, 0x06, 0xD7, 0x90, 0x16, 0x34, 0x72, 0x31, 0xDB, 0xDD, 0xA1, 0x5D,
    0xE8, 0xEE, 0x90, 0xE9, 0x6E, 0xB0, 0x7B, 0x2A, 0x85, 0xE8, 0x05, 0x25,
    0xE1, 0xA0, 0x47, 0xF4, 0xE4, 0xC9, 0x50, 0xBE, 0x12, 0x82, 0xB6, 0x24,
    0xFE, 0x82, 0xD9, 0xFF, 0x60, 0xD4, 0x9F, 0xE1, 0x3B, 0xFB, 0xD1, 0xEE,
    0xB7, 0xC5, 0xD8, 0x1E, 0x3A, 0xF3, 0x3E, 0xCF, 0xF3, 0xCE, 0xFB, 0xB5,
    0xD3, 0xB6, 0xD4, 0x20, 0x8A, 0xDC, 0xC0, 0xC8, 0x90, 0x75, 0x3C, 0x23,
    0x50, 0xEB, 0x65, 0x79, 0x45, 0x40, 0x2A, 0x6E, 0x2A, 0x33, 0xC2, 0x8F,
    0xAB, 0xDD, 0xDF, 0x47, 0x5F, 0x6E, 0xC3, 0xC7, 0xAF, 0xDE, 0x87, 0x9F,
    0xEF, 0x8F, 0xEE, 0x08, 0xE2, 0xCD, 0x1B, 0x08, 0x95, 0x38, 0xDF, 0x50,
    0x65, 0x5A, 0x69, 0xE9, 0x55, 0xD2, 0x68, 0xFA, 0xD2, 0x1A, 0xC5, 0x35,
    0x42, 0x35, 0xD9, 0xE0, 0xAC, 0x31, 0x54, 0xD2, 0x89, 0x61, 0xD6, 0x9F,
    0x02, 0xD4, 0xE4, 0xFB, 0x31, 0x6F, 0x2F, 0x3A, 0xFB, 0xAC, 0xC7, 0x4E,
    0x58, 0xD7, 0x69, 0x3B, 0xFB, 0xA5, 0xA2, 0x67, 0x0B, 0xC3, 0xBB, 0xEC,
    0x9C, 0x9D, 0x38, 0x6D, 0xD6, 0x65, 0x5F, 0x53, 0x09, 0xEC, 0x9B, 0xAB,
    0xED, 0xB0, 0x6E, 0x1A, 0xD8, 0x65, 0x57, 0xA0, 0x3D, 0xCF, 0xD3, 0xA6,
    0x02, 0x17, 0xCE, 0x3B, 0xD6, 0xCB, 0x86, 0x32, 0xDC, 0x75, 0x21, 0x91,
    0x53, 0x67, 0xC7, 0xD9, 0xCE, 0x08, 0xC7, 0xD9, 0x86, 0x50, 0x7A, 0x4E,
    0x07, 0x72, 0x3E, 0xCE, 0xC8, 0x97, 0xF5, 0xD9, 0x65, 0x3E, 0xA1, 0xC7,
    0xFA, 0x79, 0xF0, 0x19, 0x1C, 0x71, 0x09, 0x91, 0xC4, 0x09, 0xC8, 0x5F,
    0x0F, 0x1A, 0x10, 0x6E, 0x08, 0x92, 0xAB, 0x55, 0x3A, 0x23, 0xDC, 0x13,
    0x92, 0x9D, 0x29, 0xE4, 0x34, 0x25, 0x0D, 0x1B, 0xA1, 0x1F, 0x99, 0xB2,
    0xFF, 0xDD, 0x8A, 0xD4, 0xD8, 0xFD, 0x1E, 0xA4, 0x06, 0xE1, 0x16, 0x3F,
    0x15, 0xF1, 0xAB, 0x9E, 0x8A, 0xB9, 0x25, 0x2F, 0xE4, 0xD7, 0x5A, 0x95,
    0x5B, 0xA1, 0xD1, 0x87, 0x9D, 0x08, 0x01, 0xF6, 0x21, 0x98, 0x4B, 0x3E,
    0x9F, 0x7E, 0x50, 0x7B, 0xEC, 0xBC, 0x54, 0xE4, 0xD8, 0x90, 0x74, 0x05,
    0x31, 0xF5, 0x00, 0x3C, 0x73, 0x87, 0x78, 0x0F, 0xD6, 0x17, 0xEC, 0x32,
    0x4E, 0x3A, 0x81, 0x72, 0xF7, 0xC1, 0x4F, 0x1A, 0x08, 0xC3, 0xD8, 0x76,
    0xF5, 0xDD, 0x38, 0xF0, 0x06, 0xCE, 0xED, 0x40, 0x14, 0xE7, 0x40, 0x38,
    0x4D, 0x9C, 0xEB, 0xEC, 0x03, 0x08, 0x0E, 0x9D, 0xD7, 0x49, 0xE5, 0xB6,
    0xB3, 0xC3, 0x8E, 0xE1, 0xDD, 0xF7, 0xDA, 0xEC, 0x83, 0xC8, 0x5D, 0xA5,
    0xE4, 0x1C, 0x9B, 0x2E, 0xD7, 0xFF, 0x81, 0xB3, 0x1D, 0x3F, 0xF2, 0x90,
    0xF5, 0xE2, 0xA6, 0x03, 0xA7, 0x13, 0x37, 0x7D, 0x72, 0xDA, 0x71, 0xD3,
    0xE7, 0x24, 0xEB, 0x30, 0x45, 0xC8, 0x8E, 0xB3, 0x43, 0xD5, 0x31, 0xD5,
    0x54, 0x0D, 0xEB, 0xE1, 0xEB, 0xC9, 0x37, 0x89, 0xB3, 0x12, 0xB4, 0x33,
    0xD8, 0x44, 0xA1, 0xA5, 0x18, 0x84, 0x86, 0xDB, 0x90, 0x73, 0x4C, 0xE5,
    0x90, 0x5F, 0xD8, 0xF1, 0x91, 0xE9, 0x23, 0xD6, 0x2B, 0x38, 0x6F, 0x61,
    0x6C, 0xB8, 0x61, 0x88, 0x44, 0x8D, 0xC8, 0x5D, 0x05, 0x6A, 0xB8, 0x6A,
    0x8B, 0xB1, 0xBB, 0xD6, 0xB3, 0xAA, 0xB2, 0x89, 0x97, 0x64, 0xD3, 0xC4,
    0xD4, 0x18, 0xD4, 0x7E, 0x60, 0xF1, 0xAF, 0xE3, 0x35, 0xAB, 0xD1, 0x10,
    0xC4, 0x39, 0x24, 0xC1, 0x0B, 0xBD, 0x80, 0x17, 0x9A, 0x80, 0x27, 0x64,
    0x82, 0x57, 0x62, 0x40, 0xCD, 0xD2, 0x36, 0x88, 0x51, 0xFB, 0x57, 0xAD,
    0x8E, 0x55, 0x90, 0xCE, 0x15, 0x24, 0xA9, 0xC0, 0x95, 0x23, 0x69, 0x9A,
    0x75, 0x42, 0xCD, 0xA1, 0x2A, 0xAE, 0x41, 0x28, 0x62, 0xF1, 0x8B, 0x60,
    0x6A, 0x7A, 0xAC, 0x08, 0x21, 0x4B, 0xA4, 0x08, 0x0B, 0xD3, 0x92, 0x34,
    0x5D, 0xA9, 0xA0, 0xD5, 0x52, 0x31, 0x44, 0xC9, 0xD2, 0x78, 0xC9, 0x5F,
    0x4F, 0xE3, 0x26, 0xED, 0x4B, 0x46, 0x12, 0xF8, 0x19, 0x73, 0x49, 0x9C,
    0xCF, 0xB3, 0x8D, 0xE5, 0xE6, 0xB7, 0x7C, 0x19, 0xAC, 0xC1, 0x1C, 0xCC,
    0xCB, 0xC6, 0xFA, 0xC6, 0x82, 0xDE, 0xAC, 0x3C, 0x9C, 0x7B, 0xB4, 0xF5,
    0xFC, 0x55, 0x7D, 0xD1, 0x5E, 0xF5, 0x8A, 0x14, 0x26, 0xB9, 0x4A, 0xC3,
    0xD2, 0xAB, 0x98, 0x46, 0x2B, 0x15, 0xB1, 0xF9, 0x21, 0x81, 0x0D, 0x66,
    0x59, 0x11, 0x44, 0x7B, 0xD2, 0xB6, 0xEF, 0x17, 0x6C, 0xDB, 0x2E, 0x15,
    0x23, 0xBC, 0x6C, 0xA9, 0x62, 0x51, 0x8A, 0x0D, 0xA5, 0x35, 0xD4, 0xDE,
    0x1A, 0x59, 0xBB, 0x89, 0xA9, 0x82, 0x0D, 0xD3, 0x97, 0x8E, 0x27, 0x75,
    0xBC, 0x1E, 0x89, 0x1C, 0x06, 0x79, 0x0D, 0x53, 0x1D, 0x8B, 0x9A, 0x7C,
    0xF7, 0x2A, 0x56, 0x34, 0x5D, 0x86, 0x21, 0x98, 0x0C, 0xBC, 0x78, 0x70,
    0xA6, 0xA0, 0x46, 0x89, 0xB5, 0xA9, 0xF1, 0x11, 0xF8, 0xFE, 0x71, 0x44,
    0xC9, 0x20, 0x85, 0xF1, 0x11, 0x05, 0xBA, 0x66, 0x58, 0x4D, 0x41, 0x9C,
    0x1A, 0x91, 0x6E, 0x63, 0x4A, 0x04, 0xF1, 0x6E, 0x82, 0x3D, 0xAC, 0x4C,
    0xA4, 0xE1, 0x41, 0x37, 0x22, 0xA5, 0x89, 0x1A, 0x83, 0x29, 0x74, 0x37,
    0x82, 0xE8, 0x7E, 0x47, 0x47, 0x19, 0x39, 0x2A, 0xAD, 0x49, 0xF8, 0x42,
    0x10, 0xCB, 0x2B, 0xE5, 0x6B, 0xC8, 0xC2, 0x9D, 0x48, 0x88, 0xDC, 0xAB,
    0x2E, 0x11, 0x37, 0x7F, 0xCA, 0x5B, 0x9B, 0x78, 0x4D, 0x56, 0x82, 0xBB,
    0x35, 0xD8, 0xFA, 0x3E, 0xA5, 0x16, 0xFC, 0xE0, 0x54, 0xD1, 0x12, 0xD4,
    0xA7, 0x98, 0x4E, 0xD0, 0x0C, 0x8D, 0x18, 0x39, 0x84, 0x07, 0xC4, 0xA2,
    0x1A, 0xA6, 0xA8, 0x62, 0xAA, 0x19, 0x8C, 0x59, 0x95, 0x54, 0x31, 0x5A,
    0xD2, 0xFE, 0x4A, 0x59, 0xC0, 0x55, 0x8A, 0xB7, 0x72, 0x29, 0xB3, 0x54,
    0xAE, 0xC2, 0x23, 0x96, 0x47, 0x59, 0xAE, 0xCB, 0x5A, 0x06, 0x61, 0x91,
    0xD8, 0xD6, 0x86, 0x8C, 0xE6, 0x89, 0x59, 0xD7, 0x14, 0x9E, 0xD3, 0xD4,
    0xB3, 0xC7, 0x48, 0xCA, 0x27, 0x43, 0x01, 0x94, 0x3A, 0x09, 0xC8, 0xE5,
    0xDC, 0xA3, 0x81, 0x5B, 0xE3, 0x59, 0xA2, 0x27, 0xB9, 0xB4, 0x0A, 0x19,
    0x89, 0x26, 0xB5, 0x2C, 0xA3, 0xB6, 0x4E, 0x5C, 0xA6, 0x17, 0xA4, 0x7B,
    0xB3, 0x85, 0xFA, 0x59, 0x2A, 0x7A, 0xFF, 0x3D, 0xC4, 0x3F, 0xDE, 0xCB,
    0x8B, 0xC4};

std::unique_ptr<LocaleIface> GetLocaleFromBuffer(
    pdfium::span<const uint8_t> src_span) {
  if (src_span.empty())
    return nullptr;

  std::unique_ptr<uint8_t, FxFreeDeleter> output;
  uint32_t dwSize;
  CCodec_ModuleMgr* pCodecMgr = CPDF_ModuleMgr::Get()->GetCodecModule();
  pCodecMgr->GetFlateModule()->FlateOrLZWDecode(false, src_span, true, 0, 0, 0,
                                                0, 0, &output, &dwSize);
  if (!output)
    return nullptr;

  return CXFA_XMLLocale::Create(pdfium::make_span(output.get(), dwSize));
}

uint16_t GetLanguage(WideString wsLanguage) {
  if (wsLanguage.GetLength() < 2)
    return FX_LANG_en_US;

  wsLanguage.MakeLower();
  uint32_t dwIDFirst = wsLanguage[0] << 8 | wsLanguage[1];
  uint32_t dwIDSecond =
      wsLanguage.GetLength() >= 5 ? wsLanguage[3] << 8 | wsLanguage[4] : 0;
  switch (dwIDFirst) {
    case FXBSTR_ID(0, 0, 'z', 'h'):
      if (dwIDSecond == FXBSTR_ID(0, 0, 'c', 'n'))
        return FX_LANG_zh_CN;
      if (dwIDSecond == FXBSTR_ID(0, 0, 't', 'w'))
        return FX_LANG_zh_TW;
      if (dwIDSecond == FXBSTR_ID(0, 0, 'h', 'k'))
        return FX_LANG_zh_HK;
      break;
    case FXBSTR_ID(0, 0, 'j', 'a'):
      return FX_LANG_ja_JP;
    case FXBSTR_ID(0, 0, 'k', 'o'):
      return FX_LANG_ko_KR;
    case FXBSTR_ID(0, 0, 'e', 'n'):
      return dwIDSecond == FXBSTR_ID(0, 0, 'g', 'b') ? FX_LANG_en_GB
                                                     : FX_LANG_en_US;
    case FXBSTR_ID(0, 0, 'd', 'e'):
      return FX_LANG_de_DE;
    case FXBSTR_ID(0, 0, 'f', 'r'):
      return FX_LANG_fr_FR;
    case FXBSTR_ID(0, 0, 'e', 's'):
      return dwIDSecond == FXBSTR_ID(0, 0, 'e', 's') ? FX_LANG_es_ES
                                                     : FX_LANG_es_LA;
    case FXBSTR_ID(0, 0, 'i', 't'):
      return FX_LANG_it_IT;
    case FXBSTR_ID(0, 0, 'p', 't'):
      return FX_LANG_pt_BR;
    case FXBSTR_ID(0, 0, 'n', 'l'):
      return FX_LANG_nl_NL;
    case FXBSTR_ID(0, 0, 'r', 'u'):
      return FX_LANG_ru_RU;
  }
  return FX_LANG_en_US;
}

}  // namespace

CXFA_LocaleMgr::CXFA_LocaleMgr(CXFA_Node* pLocaleSet, WideString wsDeflcid)
    : m_pDefLocale(GetLocaleByName(wsDeflcid)),
      m_dwDeflcid(GetLanguage(wsDeflcid)) {
  if (!pLocaleSet)
    return;

  for (CXFA_Node* pNodeLocale = pLocaleSet->GetFirstChild(); pNodeLocale;
       pNodeLocale = pNodeLocale->GetNextSibling()) {
    m_LocaleArray.push_back(pdfium::MakeUnique<CXFA_NodeLocale>(pNodeLocale));
  }
}

CXFA_LocaleMgr::~CXFA_LocaleMgr() {}

LocaleIface* CXFA_LocaleMgr::GetDefLocale() {
  if (m_pDefLocale)
    return m_pDefLocale.Get();

  if (!m_LocaleArray.empty())
    return m_LocaleArray[0].get();

  if (!m_XMLLocaleArray.empty())
    return m_XMLLocaleArray[0].get();

  std::unique_ptr<LocaleIface> locale(GetLocale(m_dwDeflcid));
  m_pDefLocale = locale.get();
  if (locale)
    m_XMLLocaleArray.push_back(std::move(locale));

  return m_pDefLocale.Get();
}

std::unique_ptr<LocaleIface> CXFA_LocaleMgr::GetLocale(uint16_t lcid) {
  switch (lcid) {
    case FX_LANG_zh_CN:
      return GetLocaleFromBuffer(g_zhCN_Locale);
    case FX_LANG_zh_TW:
      return GetLocaleFromBuffer(g_zhTW_Locale);
    case FX_LANG_zh_HK:
      return GetLocaleFromBuffer(g_zhHK_Locale);
    case FX_LANG_ja_JP:
      return GetLocaleFromBuffer(g_jaJP_Locale);
    case FX_LANG_ko_KR:
      return GetLocaleFromBuffer(g_koKR_Locale);
    case FX_LANG_en_GB:
      return GetLocaleFromBuffer(g_enGB_Locale);
    case FX_LANG_es_LA:
      return GetLocaleFromBuffer(g_esLA_Locale);
    case FX_LANG_es_ES:
      return GetLocaleFromBuffer(g_esES_Locale);
    case FX_LANG_de_DE:
      return GetLocaleFromBuffer(g_deDE_Loacale);
    case FX_LANG_fr_FR:
      return GetLocaleFromBuffer(g_frFR_Locale);
    case FX_LANG_it_IT:
      return GetLocaleFromBuffer(g_itIT_Locale);
    case FX_LANG_pt_BR:
      return GetLocaleFromBuffer(g_ptBR_Locale);
    case FX_LANG_nl_NL:
      return GetLocaleFromBuffer(g_nlNL_Locale);
    case FX_LANG_ru_RU:
      return GetLocaleFromBuffer(g_ruRU_Locale);
    case FX_LANG_en_US:
    default:
      return GetLocaleFromBuffer(g_enUS_Locale);
  }
}

LocaleIface* CXFA_LocaleMgr::GetLocaleByName(const WideString& wsLocaleName) {
  for (size_t i = 0; i < m_LocaleArray.size(); i++) {
    LocaleIface* pLocale = m_LocaleArray[i].get();
    if (pLocale->GetName() == wsLocaleName)
      return pLocale;
  }
  if (wsLocaleName.GetLength() < 2)
    return nullptr;
  for (size_t i = 0; i < m_XMLLocaleArray.size(); i++) {
    LocaleIface* pLocale = m_XMLLocaleArray[i].get();
    if (pLocale->GetName() == wsLocaleName)
      return pLocale;
  }

  std::unique_ptr<LocaleIface> pLocale(GetLocale(GetLanguage(wsLocaleName)));
  LocaleIface* pRetLocale = pLocale.get();
  if (pLocale)
    m_XMLLocaleArray.push_back(std::move(pLocale));
  return pRetLocale;
}

void CXFA_LocaleMgr::SetDefLocale(LocaleIface* pLocale) {
  m_pDefLocale = pLocale;
}

WideString CXFA_LocaleMgr::GetConfigLocaleName(CXFA_Node* pConfig) {
  if (m_hasSetLocaleName)
    return m_wsConfigLocale;

  m_hasSetLocaleName = true;
  m_wsConfigLocale.clear();
  if (!pConfig)
    return m_wsConfigLocale;

  CXFA_Node* pChildfConfig =
      pConfig->GetFirstChildByClass<CXFA_Acrobat>(XFA_Element::Acrobat);
  if (!pChildfConfig) {
    pChildfConfig =
        pConfig->GetFirstChildByClass<CXFA_Present>(XFA_Element::Present);
  }
  CXFA_Common* pCommon = pChildfConfig
                             ? pChildfConfig->GetFirstChildByClass<CXFA_Common>(
                                   XFA_Element::Common)
                             : nullptr;
  CXFA_Locale* pLocale =
      pCommon ? pCommon->GetFirstChildByClass<CXFA_Locale>(XFA_Element::Locale)
              : nullptr;
  if (pLocale) {
    m_wsConfigLocale = pLocale->JSObject()
                           ->TryCData(XFA_Attribute::Value, false)
                           .value_or(WideString());
  }
  return m_wsConfigLocale;
}
