/* test-sound-menu.c generated by valac 0.14.2, the Vala compiler
 * generated from test-sound-menu.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Conor Curran <conor.curran@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <unity-internal.h>
#include <gio/gio.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TEST_TYPE_SOUND_MENU_SUITE (unity_test_sound_menu_suite_get_type ())
#define UNITY_TEST_SOUND_MENU_SUITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TEST_TYPE_SOUND_MENU_SUITE, UnityTestSoundMenuSuite))
#define UNITY_TEST_SOUND_MENU_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TEST_TYPE_SOUND_MENU_SUITE, UnityTestSoundMenuSuiteClass))
#define UNITY_TEST_IS_SOUND_MENU_SUITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TEST_TYPE_SOUND_MENU_SUITE))
#define UNITY_TEST_IS_SOUND_MENU_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TEST_TYPE_SOUND_MENU_SUITE))
#define UNITY_TEST_SOUND_MENU_SUITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TEST_TYPE_SOUND_MENU_SUITE, UnityTestSoundMenuSuiteClass))

typedef struct _UnityTestSoundMenuSuite UnityTestSoundMenuSuite;
typedef struct _UnityTestSoundMenuSuiteClass UnityTestSoundMenuSuiteClass;
typedef struct _UnityTestSoundMenuSuitePrivate UnityTestSoundMenuSuitePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityTestParamSpecSoundMenuSuite UnityTestParamSpecSoundMenuSuite;
#define _unity_test_sound_menu_suite_unref0(var) ((var == NULL) ? NULL : (var = (unity_test_sound_menu_suite_unref (var), NULL)))

struct _UnityTestSoundMenuSuite {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityTestSoundMenuSuitePrivate * priv;
};

struct _UnityTestSoundMenuSuiteClass {
	GTypeClass parent_class;
	void (*finalize) (UnityTestSoundMenuSuite *self);
};

struct _UnityTestParamSpecSoundMenuSuite {
	GParamSpec parent_instance;
};


static gpointer unity_test_sound_menu_suite_parent_class = NULL;

gpointer unity_test_sound_menu_suite_ref (gpointer instance);
void unity_test_sound_menu_suite_unref (gpointer instance);
GParamSpec* unity_test_param_spec_sound_menu_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_test_value_set_sound_menu_suite (GValue* value, gpointer v_object);
void unity_test_value_take_sound_menu_suite (GValue* value, gpointer v_object);
gpointer unity_test_value_get_sound_menu_suite (const GValue* value);
GType unity_test_sound_menu_suite_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_TEST_SOUND_MENU_SUITE_DUMMY_PROPERTY
};
UnityTestSoundMenuSuite* unity_test_sound_menu_suite_new (void);
UnityTestSoundMenuSuite* unity_test_sound_menu_suite_construct (GType object_type);
void unity_test_sound_menu_suite_test_stability (void);
static void _unity_test_sound_menu_suite_test_stability_gtest_data_func (gpointer self);
void unity_test_sound_menu_suite_test_metadata_updates (void);
static void _unity_test_sound_menu_suite_test_metadata_updates_gtest_data_func (gpointer self);
void unity_test_sound_menu_suite_test_playback_status_updates (void);
static void _unity_test_sound_menu_suite_test_playback_status_updates_gtest_data_func (gpointer self);
void unity_test_sound_menu_suite_test_current_playlist (void);
static void _unity_test_sound_menu_suite_test_current_playlist_gtest_data_func (gpointer self);
void unity_test_sound_menu_suite_test_track_specific_items (void);
static void _unity_test_sound_menu_suite_test_track_specific_items_gtest_data_func (gpointer self);
void unity_test_sound_menu_suite_test_player_specific_items (void);
static void _unity_test_sound_menu_suite_test_player_specific_items_gtest_data_func (gpointer self);
static void unity_test_sound_menu_suite_finalize (UnityTestSoundMenuSuite* obj);
gint unity_test_main (gchar** args, int args_length1);


static void _unity_test_sound_menu_suite_test_stability_gtest_data_func (gpointer self) {
	unity_test_sound_menu_suite_test_stability ();
}


static void _unity_test_sound_menu_suite_test_metadata_updates_gtest_data_func (gpointer self) {
	unity_test_sound_menu_suite_test_metadata_updates ();
}


static void _unity_test_sound_menu_suite_test_playback_status_updates_gtest_data_func (gpointer self) {
	unity_test_sound_menu_suite_test_playback_status_updates ();
}


static void _unity_test_sound_menu_suite_test_current_playlist_gtest_data_func (gpointer self) {
	unity_test_sound_menu_suite_test_current_playlist ();
}


static void _unity_test_sound_menu_suite_test_track_specific_items_gtest_data_func (gpointer self) {
	unity_test_sound_menu_suite_test_track_specific_items ();
}


static void _unity_test_sound_menu_suite_test_player_specific_items_gtest_data_func (gpointer self) {
	unity_test_sound_menu_suite_test_player_specific_items ();
}


UnityTestSoundMenuSuite* unity_test_sound_menu_suite_construct (GType object_type) {
	UnityTestSoundMenuSuite* self = NULL;
	self = (UnityTestSoundMenuSuite*) g_type_create_instance (object_type);
	g_test_add_data_func ("/Unit/SoundMenu/Player/SanityCheck", NULL, _unity_test_sound_menu_suite_test_stability_gtest_data_func);
	g_test_add_data_func ("/Unit/SoundMenu/Player/MetadataUpdates", NULL, _unity_test_sound_menu_suite_test_metadata_updates_gtest_data_func);
	g_test_add_data_func ("/Unit/SoundMenu/Player/PlaybackStatusUpdates", NULL, _unity_test_sound_menu_suite_test_playback_status_updates_gtest_data_func);
	g_test_add_data_func ("/Unit/SoundMenu/Player/CurrentPlaylist", NULL, _unity_test_sound_menu_suite_test_current_playlist_gtest_data_func);
	g_test_add_data_func ("/Unit/SoundMenu/Player/TrackSpecificItems", NULL, _unity_test_sound_menu_suite_test_track_specific_items_gtest_data_func);
	g_test_add_data_func ("/Unit/SoundMenu/Player/PlayerSpecificItems", NULL, _unity_test_sound_menu_suite_test_player_specific_items_gtest_data_func);
	return self;
}


UnityTestSoundMenuSuite* unity_test_sound_menu_suite_new (void) {
	return unity_test_sound_menu_suite_construct (UNITY_TEST_TYPE_SOUND_MENU_SUITE);
}


void unity_test_sound_menu_suite_test_stability (void) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* player;
	_tmp0_ = unity_music_player_new ("rhythmbox.desktop");
	player = _tmp0_;
	g_assert (UNITY_IS_MUSIC_PLAYER (player));
	_g_object_unref0 (player);
}


void unity_test_sound_menu_suite_test_metadata_updates (void) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* player;
	UnityTrackMetadata* _tmp1_;
	UnityTrackMetadata* metadata;
	UnityTrackMetadata* _tmp2_;
	UnityTrackMetadata* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	UnityTrackMetadata* _tmp8_;
	UnityTrackMetadata* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	UnityTrackMetadata* _tmp14_;
	UnityTrackMetadata* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	_tmp0_ = unity_music_player_new ("rhythmbox.desktop");
	player = _tmp0_;
	_tmp1_ = unity_track_metadata_new ();
	metadata = _tmp1_;
	unity_track_metadata_set_artist (metadata, "Autechre");
	unity_track_metadata_set_album (metadata, "LP5");
	unity_track_metadata_set_title (metadata, "Rae");
	unity_music_player_set_current_track (player, metadata);
	_tmp2_ = unity_music_player_get_current_track (player);
	_tmp3_ = _tmp2_;
	_tmp4_ = unity_track_metadata_get_artist (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = unity_track_metadata_get_artist (metadata);
	_tmp7_ = _tmp6_;
	g_assert (g_strcmp0 (_tmp5_, _tmp7_) == 0);
	_tmp8_ = unity_music_player_get_current_track (player);
	_tmp9_ = _tmp8_;
	_tmp10_ = unity_track_metadata_get_title (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = unity_track_metadata_get_title (metadata);
	_tmp13_ = _tmp12_;
	g_assert (g_strcmp0 (_tmp11_, _tmp13_) == 0);
	_tmp14_ = unity_music_player_get_current_track (player);
	_tmp15_ = _tmp14_;
	_tmp16_ = unity_track_metadata_get_album (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = unity_track_metadata_get_album (metadata);
	_tmp19_ = _tmp18_;
	g_assert (g_strcmp0 (_tmp17_, _tmp19_) == 0);
	_g_object_unref0 (metadata);
	_g_object_unref0 (player);
}


void unity_test_sound_menu_suite_test_playback_status_updates (void) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* player;
	UnityPlaybackState _tmp1_;
	UnityPlaybackState _tmp2_;
	_tmp0_ = unity_music_player_new ("rhythmbox.desktop");
	player = _tmp0_;
	unity_music_player_set_playback_state (player, UNITY_PLAYBACK_STATE_PLAYING);
	_tmp1_ = unity_music_player_get_playback_state (player);
	_tmp2_ = _tmp1_;
	g_assert (_tmp2_ == UNITY_PLAYBACK_STATE_PLAYING);
	_g_object_unref0 (player);
}


void unity_test_sound_menu_suite_test_current_playlist (void) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* player;
	UnityPlaylist* _tmp1_;
	UnityPlaylist* pl;
	UnityPlaylist* _tmp2_;
	UnityMusicPlayer* _tmp7_;
	UnityPlaylist* _tmp8_;
	UnityMusicPlayer* _tmp9_;
	UnityPlaylist* _tmp10_;
	UnityPlaylist* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	UnityPlaylist* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	UnityMusicPlayer* _tmp17_;
	UnityPlaylist* _tmp18_;
	UnityPlaylist* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	UnityPlaylist* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	UnityMusicPlayer* _tmp25_;
	UnityPlaylist* _tmp26_;
	UnityPlaylist* _tmp27_;
	GIcon* _tmp28_;
	GIcon* _tmp29_;
	UnityPlaylist* _tmp30_;
	GIcon* _tmp31_;
	GIcon* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = unity_music_player_new ("rhythmbox.desktop");
	player = _tmp0_;
	_tmp1_ = unity_playlist_new ("fake-pl-id");
	pl = _tmp1_;
	_tmp2_ = pl;
	unity_playlist_set_name (_tmp2_, "yellow swans like");
	{
		GIcon* _tmp3_ = NULL;
		GIcon* _tmp4_;
		UnityPlaylist* _tmp5_;
		GIcon* _tmp6_;
		_tmp3_ = g_icon_new_for_string ("audio-volume-high", &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp5_ = pl;
		_tmp6_ = _tmp4_;
		unity_playlist_set_icon (_tmp5_, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("test-sound-menu.vala:81: Unable to load Icon from name provided - unab" \
"le to complete test");
		_g_error_free0 (e);
		_g_object_unref0 (pl);
		_g_object_unref0 (player);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pl);
		_g_object_unref0 (player);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = player;
	_tmp8_ = pl;
	unity_music_player_set_current_playlist (_tmp7_, _tmp8_);
	_tmp9_ = player;
	_tmp10_ = unity_music_player_get_current_playlist (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = unity_playlist_get_name (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = pl;
	_tmp15_ = unity_playlist_get_name (_tmp14_);
	_tmp16_ = _tmp15_;
	g_assert (g_strcmp0 (_tmp13_, _tmp16_) == 0);
	_tmp17_ = player;
	_tmp18_ = unity_music_player_get_current_playlist (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = unity_playlist_get_id (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = pl;
	_tmp23_ = unity_playlist_get_id (_tmp22_);
	_tmp24_ = _tmp23_;
	g_assert (g_strcmp0 (_tmp21_, _tmp24_) == 0);
	_tmp25_ = player;
	_tmp26_ = unity_music_player_get_current_playlist (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = unity_playlist_get_icon (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = pl;
	_tmp31_ = unity_playlist_get_icon (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_icon_equal (_tmp29_, _tmp32_);
	g_assert (_tmp33_);
	_g_object_unref0 (pl);
	_g_object_unref0 (player);
}


void unity_test_sound_menu_suite_test_track_specific_items (void) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* player;
	DbusmenuMenuitem* _tmp1_;
	DbusmenuMenuitem* menuitem;
	DbusmenuMenuitem* _tmp2_;
	DbusmenuMenuitem* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	_tmp0_ = unity_music_player_new ("rhythmbox.desktop");
	player = _tmp0_;
	_tmp1_ = dbusmenu_menuitem_new ();
	menuitem = _tmp1_;
	unity_music_player_set_track_menu (player, menuitem);
	_tmp2_ = unity_music_player_get_track_menu (player);
	_tmp3_ = _tmp2_;
	_tmp4_ = dbusmenu_menuitem_get_id (_tmp3_);
	_tmp5_ = dbusmenu_menuitem_get_id (menuitem);
	g_assert (_tmp4_ == _tmp5_);
	_g_object_unref0 (menuitem);
	_g_object_unref0 (player);
}


void unity_test_sound_menu_suite_test_player_specific_items (void) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* player;
	DbusmenuMenuitem* _tmp1_;
	DbusmenuMenuitem* menuitem;
	DbusmenuMenuitem* _tmp2_;
	DbusmenuMenuitem* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	_tmp0_ = unity_music_player_new ("rhythmbox.desktop");
	player = _tmp0_;
	_tmp1_ = dbusmenu_menuitem_new ();
	menuitem = _tmp1_;
	unity_music_player_set_player_menu (player, menuitem);
	_tmp2_ = unity_music_player_get_player_menu (player);
	_tmp3_ = _tmp2_;
	_tmp4_ = dbusmenu_menuitem_get_id (_tmp3_);
	_tmp5_ = dbusmenu_menuitem_get_id (menuitem);
	g_assert (_tmp4_ == _tmp5_);
	_g_object_unref0 (menuitem);
	_g_object_unref0 (player);
}


static void unity_test_value_sound_menu_suite_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_test_value_sound_menu_suite_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_test_sound_menu_suite_unref (value->data[0].v_pointer);
	}
}


static void unity_test_value_sound_menu_suite_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_test_sound_menu_suite_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_test_value_sound_menu_suite_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_test_value_sound_menu_suite_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityTestSoundMenuSuite* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_test_sound_menu_suite_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_test_value_sound_menu_suite_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityTestSoundMenuSuite** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_test_sound_menu_suite_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_test_param_spec_sound_menu_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityTestParamSpecSoundMenuSuite* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TEST_TYPE_SOUND_MENU_SUITE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_test_value_get_sound_menu_suite (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TEST_TYPE_SOUND_MENU_SUITE), NULL);
	return value->data[0].v_pointer;
}


void unity_test_value_set_sound_menu_suite (GValue* value, gpointer v_object) {
	UnityTestSoundMenuSuite* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TEST_TYPE_SOUND_MENU_SUITE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TEST_TYPE_SOUND_MENU_SUITE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_test_sound_menu_suite_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_test_sound_menu_suite_unref (old);
	}
}


void unity_test_value_take_sound_menu_suite (GValue* value, gpointer v_object) {
	UnityTestSoundMenuSuite* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TEST_TYPE_SOUND_MENU_SUITE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TEST_TYPE_SOUND_MENU_SUITE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_test_sound_menu_suite_unref (old);
	}
}


static void unity_test_sound_menu_suite_class_init (UnityTestSoundMenuSuiteClass * klass) {
	unity_test_sound_menu_suite_parent_class = g_type_class_peek_parent (klass);
	UNITY_TEST_SOUND_MENU_SUITE_CLASS (klass)->finalize = unity_test_sound_menu_suite_finalize;
}


static void unity_test_sound_menu_suite_instance_init (UnityTestSoundMenuSuite * self) {
	self->ref_count = 1;
}


static void unity_test_sound_menu_suite_finalize (UnityTestSoundMenuSuite* obj) {
	UnityTestSoundMenuSuite * self;
	self = UNITY_TEST_SOUND_MENU_SUITE (obj);
}


GType unity_test_sound_menu_suite_get_type (void) {
	static volatile gsize unity_test_sound_menu_suite_type_id__volatile = 0;
	if (g_once_init_enter (&unity_test_sound_menu_suite_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_test_value_sound_menu_suite_init, unity_test_value_sound_menu_suite_free_value, unity_test_value_sound_menu_suite_copy_value, unity_test_value_sound_menu_suite_peek_pointer, "p", unity_test_value_sound_menu_suite_collect_value, "p", unity_test_value_sound_menu_suite_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityTestSoundMenuSuiteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_test_sound_menu_suite_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityTestSoundMenuSuite), 0, (GInstanceInitFunc) unity_test_sound_menu_suite_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_test_sound_menu_suite_type_id;
		unity_test_sound_menu_suite_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityTestSoundMenuSuite", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_test_sound_menu_suite_type_id__volatile, unity_test_sound_menu_suite_type_id);
	}
	return unity_test_sound_menu_suite_type_id__volatile;
}


gpointer unity_test_sound_menu_suite_ref (gpointer instance) {
	UnityTestSoundMenuSuite* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_test_sound_menu_suite_unref (gpointer instance) {
	UnityTestSoundMenuSuite* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_TEST_SOUND_MENU_SUITE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint unity_test_main (gchar** args, int args_length1) {
	gint result = 0;
	UnityTestSoundMenuSuite* sound_menu_test_suite = NULL;
	UnityTestSoundMenuSuite* _tmp0_;
	g_setenv ("XDG_DATA_HOME", TESTDIR "/data", TRUE);
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = unity_test_sound_menu_suite_new ();
	_unity_test_sound_menu_suite_unref0 (sound_menu_test_suite);
	sound_menu_test_suite = _tmp0_;
	g_test_run ();
	result = 0;
	_unity_test_sound_menu_suite_unref0 (sound_menu_test_suite);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return unity_test_main (argv, argc);
}



