.\" zip_fdopen.mdoc \-- open zip archive using existing file descriptor
.\" Copyright (C) 2009-2010 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FDOPEN 3 "February 1, 2010" NiH
.SH "NAME"
zip_fdopen \- open zip archive using open file descriptor
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
struct zip *
zip_fdopen(int fd, int flags, int *errorp);
.SH "DESCRIPTION"
The zip archive specified by the open file descriptor
\fBfd\fR
is opened and a pointer to a
.PP
struct zip,
used to manipulate the archive, is returned.
In contrast to
zip_open(3),
using
.Nm zip_fdopen
the archive can only be opened in read-only mode.
The
\fBfd\fR
argument may not be used any longer after calling
.Nm zip_fdopen.
The
.Fa flags
are specified by
.I or'ing
the following values, or 0 for none of them.
.RS
.TP 15
\fBZIP_CHECKCONS\fR
Perform additional consistency checks on the archive, and error if
they fail.
.RE
.PP
If an error occurs and
\fBerrorp\fR
is
.No non-\fBNULL,\fR
it will be set to the corresponding error code.
.SH "RETURN VALUES"
Upon successful completion
zip_fdopen
returns a
.PP
struct zip
pointer, and
\fBfd\fR
should not be used any longer, nor passed to
close(2).
Otherwise,
\fBNULL\fR
is returned and
\fB*errorp\fR
is set to indicate the error.
In the error case,
\fBfd\fR
remains unchanged.
.SH "ERRORS"
The file specified by
\fBfd\fR
is prepared for use by
libzip(3)
unless:
.RS
.TP 4
[ZIP_ER_INCONS]
Inconsistencies were found in the file specified by
\fBpath\fR
and
\fBZIP_CHECKCONS\fR
was specified.
.TP 4
[ZIP_ER_INVAL]
The
\fBflags\fR
argument is invalid.
Not all
zip_open(3)
flags are allowed for
.Nm zip_fdopen,
see
DESCRIPTION.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.TP 4
[ZIP_ER_NOZIP]
The file specified by
\fBfd\fR
is not a zip archive.
.TP 4
[ZIP_ER_OPEN]
The file specified by
\fBfd\fR
could not be prepared for use by
libzip(3).
.TP 4
[ZIP_ER_READ]
A read error occurred; see
.Va errno
for details.
.TP 4
[ZIP_ER_SEEK]
The file specified by
\fBfd\fR
does not allow seeks.
.RE
.SH "SEE ALSO"
libzip(3),
zip_close(3),
zip_error_to_str(3),
zip_open(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
