/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.InfoType;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;

public class InfoValue {
    private InfoType type;
    private Object value;

    public InfoValue() {
        this.type = null;
        this.value = null;
    }

    public InfoValue(InfoType infoType) {
        this.type = infoType;
        this.value = null;
    }

    public InfoValue(InfoType infoType, Object object) {
        this.type = infoType;
        this.value = object;
    }

    public InfoType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) throws ClassCastException {
        if (this.type == null || object == null) {
            this.value = object;
            return;
        }
        if (!InfoValue.isValueConsistentWithType(this.type, object)) {
            throw new ClassCastException("Unmatched InfoType " + this.type + " for the value " + object);
        }
        this.value = object;
    }

    private static boolean isValueConsistentWithType(InfoType infoType, Object object) {
        if (infoType == null || object == null) {
            return true;
        }
        if (infoType.equals(InfoType.STR)) {
            return object instanceof String;
        }
        if (infoType.equals(InfoType.INT2)) {
            return object instanceof Short;
        }
        if (infoType.equals(InfoType.INT4) || infoType.equals(InfoType.BYTE4)) {
            return object instanceof Integer;
        }
        if (infoType.equals(InfoType.INT8) || infoType.equals(InfoType.BYTE8)) {
            return object instanceof Long;
        }
        if (infoType.equals(InfoType.FLT4)) {
            return object instanceof Float;
        }
        if (infoType.equals(InfoType.FLT8)) {
            return object instanceof Double;
        }
        return false;
    }

    public int getByteSize() {
        if (this.value != null) {
            if (this.value instanceof String) {
                return 3 + ((String)this.value).length();
            }
            if (this.value instanceof Short) {
                return 3;
            }
            if (this.value instanceof Integer) {
                return 5;
            }
            if (this.value instanceof Long) {
                return 9;
            }
            if (this.value instanceof Float) {
                return 5;
            }
            if (this.value instanceof Double) {
                return 9;
            }
        }
        return 0;
    }

    public void writeValue(MixedDataOutput mixedDataOutput) throws IOException {
        if (this.type.equals(InfoType.STR)) {
            mixedDataOutput.writeString((String)this.value);
        } else if (this.type.equals(InfoType.INT8) || this.type.equals(InfoType.BYTE8)) {
            mixedDataOutput.writeLong((Long)this.value);
        } else if (this.type.equals(InfoType.INT4) || this.type.equals(InfoType.BYTE4)) {
            mixedDataOutput.writeInt((Integer)this.value);
        } else if (this.type.equals(InfoType.INT2)) {
            mixedDataOutput.writeShort(((Short)this.value).shortValue());
        } else if (this.type.equals(InfoType.FLT4)) {
            mixedDataOutput.writeFloat(((Float)this.value).floatValue());
        } else if (this.type.equals(InfoType.FLT8)) {
            mixedDataOutput.writeDouble((Double)this.value);
        } else {
            throw new IOException("Unknown InfoType = " + this.type);
        }
    }

    public void readValue(MixedDataInput mixedDataInput) throws IOException {
        if (this.type.equals(InfoType.STR)) {
            this.value = mixedDataInput.readString();
        } else if (this.type.equals(InfoType.INT8) || this.type.equals(InfoType.BYTE8)) {
            this.value = new Long(mixedDataInput.readLong());
        } else if (this.type.equals(InfoType.INT4) || this.type.equals(InfoType.BYTE4)) {
            this.value = new Integer(mixedDataInput.readInt());
        } else if (this.type.equals(InfoType.INT2)) {
            this.value = new Short(mixedDataInput.readShort());
        } else if (this.type.equals(InfoType.FLT4)) {
            this.value = new Float(mixedDataInput.readFloat());
        } else if (this.type.equals(InfoType.FLT8)) {
            this.value = new Double(mixedDataInput.readDouble());
        } else {
            throw new IOException("Unknown InfoType = " + this.type);
        }
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        this.type.writeObject(mixedDataOutput);
        this.writeValue(mixedDataOutput);
    }

    public InfoValue(MixedDataInput mixedDataInput) throws IOException {
        this();
        this.readObject(mixedDataInput);
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        this.type = new InfoType(mixedDataInput);
        this.readValue(mixedDataInput);
    }

    public String toString() {
        if (this.type.equals(InfoType.STR)) {
            return (String)this.value;
        }
        if (this.type.equals(InfoType.BYTE4)) {
            return Integer.toHexString((Integer)this.value);
        }
        if (this.type.equals(InfoType.BYTE8)) {
            return Long.toHexString((Long)this.value);
        }
        return this.value.toString();
    }
}

