#! /usr/bin/python

import re, sys, fileinput

skip_packages = ('openoffice.org-gcj', 'openoffice.org-core', 'openoffice.org-report-builder-bin', 'openoffice.org-base-core', 'openoffice.org-dev', 'openoffice.org-dev-doc', 'openoffice.org-dbg', 'openoffice.org-help-sk', 'openoffice.org-evolution', 'openoffice.org-nlpsolver', 'openoffice.org-hyphenation-show')
#lp#772387
nodep_packages = ('openoffice.org-dmaths', 'openoffice.org-zemberek', 'openoffice.org-l10n-be-by', 'openoffice.org-l10n-ns', 'openoffice.org-sdbc-postgresql', 'openoffice.org-style-andromeda', 'openoffice.org-report-builder')

arch_packages = { 
    'openoffice.org-base': 'amd64 i386 powerpc',
    'openoffice.org-filter-binfilter': 'amd64 i386 powerpc',
    }

def gen_transitonal_packages():
    skip = True
    copy_fields = ('Section', 'Architecture', 'Priority', 'Description')
    copy_fields = ('Section', 'Priority', 'Description')
    pkgs = {}
    for line in fileinput.input():
        if line == '\n':
            skip = True
        if ':' in line:
            f, v = line.split(':', 1)
            v = v.strip()
            if f == 'Package':
                if v.startswith('libreoffice-') or v.endswith('-libreoffice'):
                    n = v.replace('libreoffice', 'openoffice.org')
                    p =  {'Depends': v}
                    pkgs[n] = p
                    skip = False
                elif v.startswith('mythes-'):
                    n = v.replace('mythes', 'openoffice.org-thesaurus')
                    p =  {'Depends': v}
                    pkgs[n] = p
                    skip = False
                elif v.startswith('hyphen-'):
                    n = v.replace('hyphen', 'openoffice.org-hyphenation')
                    p =  {'Depends': v}
                    pkgs[n] = p
                    skip = False
                else:
                    skip = True
            if not skip and f in copy_fields:
                p[f] = v
                
    for p, attrs in pkgs.iteritems():
        if p in skip_packages:
            continue
        print "Package: %s" % p
        print "Architecture:", arch_packages.get(p, 'all')
        for f, v in attrs.items():
            if f in ('Depends', 'Description'):
                continue
	    if f in ('Priority'):
		v = v.replace('optional', 'extra');
            print "%s: %s" % (f, v)
        if p not in nodep_packages:
            print "Depends: %s" % attrs['Depends']
        print "Description: %s" % attrs['Description']
        print " This is a transitional package, replacing the OpenOffice.org packaging"
        print " with the LibreOffice packaging."
        print " ."
        print " It can be safely removed after an upgrade."
        print

def main():
    gen_transitonal_packages()

main()
