/* CircleEffect.c generated by valac 0.40.4, the Vala compiler
 * generated from CircleEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_CIRCLE_EFFECT_DESCRIPTOR (circle_effect_descriptor_get_type ())
#define CIRCLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptor))
#define CIRCLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptorClass))
#define IS_CIRCLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCLE_EFFECT_DESCRIPTOR))
#define IS_CIRCLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCLE_EFFECT_DESCRIPTOR))
#define CIRCLE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptorClass))

typedef struct _CircleEffectDescriptor CircleEffectDescriptor;
typedef struct _CircleEffectDescriptorClass CircleEffectDescriptorClass;
typedef struct _CircleEffectDescriptorPrivate CircleEffectDescriptorPrivate;
enum  {
	CIRCLE_EFFECT_DESCRIPTOR_0_PROPERTY,
	CIRCLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* circle_effect_descriptor_properties[CIRCLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CIRCLE_EFFECT (circle_effect_get_type ())
#define CIRCLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCLE_EFFECT, CircleEffect))
#define CIRCLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCLE_EFFECT, CircleEffectClass))
#define IS_CIRCLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCLE_EFFECT))
#define IS_CIRCLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCLE_EFFECT))
#define CIRCLE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCLE_EFFECT, CircleEffectClass))

typedef struct _CircleEffect CircleEffect;
typedef struct _CircleEffectClass CircleEffectClass;
typedef struct _CircleEffectPrivate CircleEffectPrivate;
enum  {
	CIRCLE_EFFECT_0_PROPERTY,
	CIRCLE_EFFECT_NUM_PROPERTIES
};
static GParamSpec* circle_effect_properties[CIRCLE_EFFECT_NUM_PROPERTIES];

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _CircleEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	CircleEffectDescriptorPrivate * priv;
};

struct _CircleEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _CircleEffect {
	GObject parent_instance;
	CircleEffectPrivate * priv;
};

struct _CircleEffectClass {
	GObjectClass parent_class;
};


static gpointer circle_effect_descriptor_parent_class = NULL;
static gpointer circle_effect_parent_class = NULL;
static SpitTransitionsEffectIface * circle_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType circle_effect_descriptor_get_type (void) G_GNUC_CONST;
CircleEffectDescriptor* circle_effect_descriptor_new (GFile* resource_directory);
CircleEffectDescriptor* circle_effect_descriptor_construct (GType object_type,
                                                            GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type,
                                                                        GFile* resource_directory);
static const gchar* circle_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* circle_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* circle_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                             SpitHostInterface* host);
CircleEffect* circle_effect_new (void);
CircleEffect* circle_effect_construct (GType object_type);
GType circle_effect_get_type (void) G_GNUC_CONST;
#define CIRCLE_EFFECT_DESIRED_FPS 25
#define CIRCLE_EFFECT_MIN_FPS 15
static void circle_effect_real_get_fps (SpitTransitionsEffect* base,
                                 gint* desired_fps,
                                 gint* min_fps);
static void circle_effect_real_start (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion);
static gboolean circle_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void circle_effect_real_paint (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion,
                               cairo_t* ctx,
                               gint width,
                               gint height,
                               gint frame_number);
static void circle_effect_real_advance (SpitTransitionsEffect* base,
                                 SpitTransitionsVisuals* visuals,
                                 SpitTransitionsMotion* motion,
                                 gint frame_number);
static void circle_effect_real_cancel (SpitTransitionsEffect* base);


CircleEffectDescriptor*
circle_effect_descriptor_construct (GType object_type,
                                    GFile* resource_directory)
{
	CircleEffectDescriptor * self = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = (CircleEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return self;
#line 152 "CircleEffect.c"
}


CircleEffectDescriptor*
circle_effect_descriptor_new (GFile* resource_directory)
{
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return circle_effect_descriptor_construct (TYPE_CIRCLE_EFFECT_DESCRIPTOR, resource_directory);
#line 161 "CircleEffect.c"
}


static const gchar*
circle_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	CircleEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	result = "org.yorba.shotwell.transitions.circle";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return result;
#line 176 "CircleEffect.c"
}


static const gchar*
circle_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	CircleEffectDescriptor * self;
	const gchar* result = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	result = _ ("Circle");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return result;
#line 191 "CircleEffect.c"
}


static SpitTransitionsEffect*
circle_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                      SpitHostInterface* host)
{
	CircleEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	CircleEffect* _tmp0_;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_tmp0_ = circle_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return result;
#line 212 "CircleEffect.c"
}


static void
circle_effect_descriptor_class_init (CircleEffectDescriptorClass * klass)
{
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	circle_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor *)) circle_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor *)) circle_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor *, SpitHostInterface*)) circle_effect_descriptor_real_create;
#line 227 "CircleEffect.c"
}


static void
circle_effect_descriptor_instance_init (CircleEffectDescriptor * self)
{
}


GType
circle_effect_descriptor_get_type (void)
{
	static volatile gsize circle_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&circle_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CircleEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circle_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CircleEffectDescriptor), 0, (GInstanceInitFunc) circle_effect_descriptor_instance_init, NULL };
		GType circle_effect_descriptor_type_id;
		circle_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "CircleEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&circle_effect_descriptor_type_id__volatile, circle_effect_descriptor_type_id);
	}
	return circle_effect_descriptor_type_id__volatile;
}


CircleEffect*
circle_effect_construct (GType object_type)
{
	CircleEffect * self = NULL;
#line 32 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = (CircleEffect*) g_object_new (object_type, NULL);
#line 32 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return self;
#line 259 "CircleEffect.c"
}


CircleEffect*
circle_effect_new (void)
{
#line 32 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return circle_effect_construct (TYPE_CIRCLE_EFFECT);
#line 268 "CircleEffect.c"
}


static void
circle_effect_real_get_fps (SpitTransitionsEffect* base,
                            gint* desired_fps,
                            gint* min_fps)
{
	CircleEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT, CircleEffect);
#line 36 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_vala_desired_fps = CIRCLE_EFFECT_DESIRED_FPS;
#line 37 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_vala_min_fps = CIRCLE_EFFECT_MIN_FPS;
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	if (desired_fps) {
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 290 "CircleEffect.c"
	}
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	if (min_fps) {
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		*min_fps = _vala_min_fps;
#line 296 "CircleEffect.c"
	}
}


static void
circle_effect_real_start (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion)
{
	CircleEffect * self;
#line 40 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT, CircleEffect);
#line 40 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 40 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 313 "CircleEffect.c"
}


static gboolean
circle_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	CircleEffect * self;
	gboolean result = FALSE;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT, CircleEffect);
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	result = TRUE;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	return result;
#line 328 "CircleEffect.c"
}


static void
circle_effect_real_paint (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion,
                          cairo_t* ctx,
                          gint width,
                          gint height,
                          gint frame_number)
{
	CircleEffect * self;
	gdouble alpha = 0.0;
	gint radius = 0;
	gdouble _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT, CircleEffect);
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 49 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_tmp0_ = alpha;
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	radius = (gint) (_tmp0_ * fmax ((gdouble) width, (gdouble) height));
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_tmp1_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_tmp2_ = _tmp1_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	if (_tmp2_ != NULL) {
#line 369 "CircleEffect.c"
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkRectangle _tmp5_ = {0};
		GdkRectangle _tmp6_;
		gint _tmp7_;
		GdkRectangle _tmp8_ = {0};
		GdkRectangle _tmp9_;
		gint _tmp10_;
		gdouble _tmp11_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp3_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp4_ = _tmp3_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp5_);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp6_ = _tmp5_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp7_ = _tmp6_.x;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp8_);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp9_ = _tmp8_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp10_ = _tmp9_.y;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp4_, (gdouble) _tmp7_, (gdouble) _tmp10_);
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp11_ = alpha;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		cairo_paint_with_alpha (ctx, 1 - _tmp11_);
#line 401 "CircleEffect.c"
	}
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_tmp12_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	_tmp13_ = _tmp12_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	if (_tmp13_ != NULL) {
#line 409 "CircleEffect.c"
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_;
		gint _tmp18_;
		GdkRectangle _tmp19_ = {0};
		GdkRectangle _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp14_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp15_ = _tmp14_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp16_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp17_ = _tmp16_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp18_ = _tmp17_.x;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp19_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp20_ = _tmp19_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp21_ = _tmp20_.y;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp15_, (gdouble) _tmp18_, (gdouble) _tmp21_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		_tmp22_ = radius;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		cairo_arc (ctx, (gdouble) (((gint) width) / 2), (gdouble) (((gint) height) / 2), (gdouble) _tmp22_, (gdouble) 0, 2 * G_PI);
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		cairo_clip (ctx);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
		cairo_paint (ctx);
#line 445 "CircleEffect.c"
	}
}


static void
circle_effect_real_advance (SpitTransitionsEffect* base,
                            SpitTransitionsVisuals* visuals,
                            SpitTransitionsMotion* motion,
                            gint frame_number)
{
	CircleEffect * self;
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT, CircleEffect);
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 463 "CircleEffect.c"
}


static void
circle_effect_real_cancel (SpitTransitionsEffect* base)
{
	CircleEffect * self;
#line 69 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CIRCLE_EFFECT, CircleEffect);
#line 473 "CircleEffect.c"
}


static void
circle_effect_class_init (CircleEffectClass * klass)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	circle_effect_parent_class = g_type_class_peek_parent (klass);
#line 482 "CircleEffect.c"
}


static void
circle_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	circle_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	iface->get_fps = (void (*) (SpitTransitionsEffect *, gint*, gint*)) circle_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	iface->start = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*)) circle_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect *)) circle_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	iface->paint = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) circle_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	iface->advance = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) circle_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CircleEffect.vala"
	iface->cancel = (void (*) (SpitTransitionsEffect *)) circle_effect_real_cancel;
#line 503 "CircleEffect.c"
}


static void
circle_effect_instance_init (CircleEffect * self)
{
}


GType
circle_effect_get_type (void)
{
	static volatile gsize circle_effect_type_id__volatile = 0;
	if (g_once_init_enter (&circle_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CircleEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circle_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CircleEffect), 0, (GInstanceInitFunc) circle_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) circle_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType circle_effect_type_id;
		circle_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "CircleEffect", &g_define_type_info, 0);
		g_type_add_interface_static (circle_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&circle_effect_type_id__volatile, circle_effect_type_id);
	}
	return circle_effect_type_id__volatile;
}



