# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""A QApplication that starts a single instance."""

import sys

from PyQt4 import QtNetwork, QtGui, QtCore


class UniqueApplication(QtGui.QApplication):

    """A QApplication that can only be started once.

    Also, the new instance notifies the old one to show
    its window.
    """

    new_instance = QtCore.pyqtSignal()

    def __init__(self, argv, key):
        super(UniqueApplication, self).__init__(argv)
        self.key = key
        self.server = QtNetwork.QLocalServer(self)
        self.server.newConnection.connect(self.new_instance.emit)
        self.aboutToQuit.connect(self.cleanup)
        # Try to connect to existing app
        socket = QtNetwork.QLocalSocket()
        socket.connectToServer(key, QtCore.QIODevice.WriteOnly)
        if socket.waitForConnected(500):
            # Connected, exit
            sys.exit()

        # Not connected, start server
        self.ready = self.server.listen(key)

    def cleanup(self):
        """Remove the socket when we die."""
        self.server.removeServer(self.key)
