# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""System notification area icon."""

from PyQt4 import QtGui
from twisted.internet.defer import inlineCallbacks
from ubuntuone.platform.tools import SyncDaemonTool

from ubuntuone.controlpanel.gui import (
    RESTORE_LABEL,
    QUIT_LABEL,
)


class TrayIcon(QtGui.QSystemTrayIcon):

    """System notification icon."""

    def __init__(self, window=None, close_callback=lambda: None):
        super(TrayIcon, self).__init__(None)
        self.setIcon(QtGui.QIcon(":/icon.png"))
        self.setVisible(True)
        self.window = window
        self.activated.connect(self.on_activated)
        self.context_menu = QtGui.QMenu()
        self.restore = QtGui.QAction(RESTORE_LABEL, self,
            triggered=self.restore_window)
        self.quit = QtGui.QAction(QUIT_LABEL, self,
            triggered=self.stop)
        self.context_menu.addAction(self.restore)
        self.context_menu.addSeparator()
        self.context_menu.addAction(self.quit)
        self.setContextMenu(self.context_menu)

        self.close_callback = close_callback

    def on_activated(self, reason):
        """The user activated the icon."""
        if reason == self.Trigger:  # Left-click
            self.restore_window()

    def restore_window(self):
        """Show the main window."""
        if self.window is None:
            # pylint: disable=W0404
            from ubuntuone.controlpanel.gui.qt.gui import MainWindow
            # pylint: enable=W0404
            self.window = MainWindow(close_callback=self.delete_window)
        self.window.show()
        self.window.activateWindow()

    def delete_window(self):
        """Close and remove the main window."""
        if self.window is not None:
            self.window.close()
            self.window = None

    @inlineCallbacks
    def stop(self, *args, **kwargs):
        """Stop the application."""
        # Stop syncdaemon
        # pylint: disable=W0702
        # Really, if it fails we can't do anything about it.
        try:
            st = SyncDaemonTool()
            yield st.quit()
        except:
            # Maybe it was not running?
            pass
        self.close_callback()
