# -*- coding: utf-8 -*-

# Authors: Natalia B Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the GoToWebButton widget."""

from ubuntuone.controlpanel.gui import qt
from ubuntuone.controlpanel.gui.qt import gotoweb as gui
from ubuntuone.controlpanel.gui.qt.tests import (
    BaseTestCase,
)


class GoToWebButtonTestCase(BaseTestCase):
    """The test suite for the GoToWebButton."""

    class_ui = gui.GoToWebButton

    def test_uri_default(self):
        """The uri uses the default."""
        self.assertEqual(self.ui.uri, self.class_ui.uri)

    def test_text_default(self):
        """The text uses the default."""
        if self.class_ui.legend is not None:
            self.assertEqual(self.ui.text(), self.class_ui.legend)
        else:
            self.assertEqual(self.ui.text(), '')

    def test_uri_can_be_set(self):
        """The uri can be set."""
        uri = 'something'
        self.ui.uri = uri
        self.assertEqual(self.ui.uri, uri)

    def test_cursor_pointer(self):
        """The cursor is PointingHandCursor."""
        self.assertEqual(self.ui.cursor().shape(),
                         gui.QtCore.Qt.PointingHandCursor)

    def test_open_uri_when_clicked(self):
        """When clicking the button, the uri is opened."""
        expected_iri = 'foo-bar-baz'
        self.patch(self.ui.backend, 'build_signed_iri', lambda i: expected_iri)
        self.patch(qt, 'uri_hook', self._set_called)
        self.ui.uri = 'yadda-yadda-yoo'

        self.ui.click()

        self.assertEqual(self._called, ((expected_iri,), {}))

    def test_do_nothing_on_clicked_if_uri_is_none(self):
        """When clicking the button, if the uri is None, do nothing."""
        self.patch(qt, 'uri_hook', self._set_called)
        self.ui.uri = None
        self.ui.click()

        self.assertEqual(self._called, False)


class GetStorageButtonTestCase(GoToWebButtonTestCase):
    """The test suite for the GetStorageButton widget."""

    class_ui = gui.GetStorageButton

    def test_uri(self):
        """The default uri is correct."""
        self.assertEqual(self.ui.uri, gui.GET_STORAGE_LINK)

    def test_text(self):
        """The default legend is correct."""
        self.assertEqual(self.ui.text(), gui.GET_MORE_STORAGE)
