#!/usr/bin/env python
# setup.py - Build system for Ubuntu SSO Client package
#
# Author: Natalia B. Bidart <natalia.bidart@canonical.com>
#         Eric Casteleijn <eric.casteleijn@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""setup.py"""

import sys

try:
    import DistUtilsExtra.auto
except ImportError:
    print >> sys.stderr, 'To build this program you need '\
                         'https://launchpad.net/python-distutils-extra'
    sys.exit(1)

DistUtilsExtra.auto.setup(
    name='ubuntuone-couch',
    version='0.3.0',
    license='GPL v3',
    author='Eric Casteleijn',
    author_email='eric.casteleijn@canonical.com',
    description='Ubuntu One CouchDB',
    long_description="Library and command line utilities to access a user's"
                     " CouchDB data on the Ubuntu One servers.",
    url='https://launchpad.net/ubuntuone-couch',
    packages=['ubuntuone', 'ubuntuone.couch'],
    extra_path='ubuntuone-couch',
    scripts=['bin/u1couchquery', 'bin/u1oauthrequest'])
