/* main-window.c generated by valac 0.16.0, the Vala compiler
 * generated from main-window.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <lightdm.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;

#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__monitor_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__monitor_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_ENTRY (user_entry_get_type ())
#define USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_ENTRY, UserEntry))
#define USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_ENTRY, UserEntryClass))
#define IS_USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_ENTRY))
#define IS_USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_ENTRY))
#define USER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_ENTRY, UserEntryClass))

typedef struct _UserEntry UserEntry;
typedef struct _UserEntryClass UserEntryClass;
typedef struct _UserEntryPrivate UserEntryPrivate;
typedef struct _MonitorPrivate MonitorPrivate;
#define _monitor_unref0(var) ((var == NULL) ? NULL : (var = (monitor_unref (var), NULL)))

#define USER_LIST_TYPE_SCROLL_TARGET (user_list_scroll_target_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
	UserList* user_list;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _MainWindowPrivate {
	GList* monitors;
	Background* background;
	MenuBar* menubar;
	GtkBox* login_box;
	guint change_background_timeout;
};

struct _UserEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserEntryPrivate * priv;
	gchar* name;
	PangoLayout* layout;
	gchar* background;
	gboolean is_active;
	gboolean has_messages;
	GList* keyboard_layouts;
	gchar* session;
	cairo_surface_t* label_in_box_surface;
	cairo_surface_t* label_out_of_box_surface;
};

struct _UserEntryClass {
	GTypeClass parent_class;
	void (*finalize) (UserEntry *self);
};

struct _Monitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _MonitorClass {
	GTypeClass parent_class;
	void (*finalize) (Monitor *self);
};

typedef enum  {
	USER_LIST_SCROLL_TARGET_START,
	USER_LIST_SCROLL_TARGET_END,
	USER_LIST_SCROLL_TARGET_UP,
	USER_LIST_SCROLL_TARGET_DOWN
} UserListScrollTarget;


static gpointer main_window_parent_class = NULL;
extern gboolean unity_greeter_test_mode;

GType main_window_get_type (void) G_GNUC_CONST;
GType user_list_get_type (void) G_GNUC_CONST;
gpointer monitor_ref (gpointer instance);
void monitor_unref (gpointer instance);
GParamSpec* param_spec_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_monitor (GValue* value, gpointer v_object);
void value_take_monitor (GValue* value, gpointer v_object);
gpointer value_get_monitor (const GValue* value);
GType monitor_get_type (void) G_GNUC_CONST;
GType background_get_type (void) G_GNUC_CONST;
GType menu_bar_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY
};
static void _monitor_unref0_ (gpointer var);
static void _g_list_free__monitor_unref0_ (GList* self);
static void main_window_monitors_changed_cb (MainWindow* self, GdkScreen* screen);
static gboolean main_window_monitor_is_unique_position (MainWindow* self, GdkScreen* screen, gint n);
Monitor* monitor_new (gint x, gint y, gint width, gint height);
Monitor* monitor_construct (GType object_type, gint x, gint y, gint width, gint height);
void background_set_monitors (Background* self, GList* monitors);
static void main_window_move_to_monitor (MainWindow* self, Monitor* monitor);
static gboolean main_window_change_background_timeout_cb (MainWindow* self);
gboolean menu_bar_get_high_contrast (MenuBar* self);
gboolean ug_settings_get_boolean (const gchar* key);
#define UG_SETTINGS_KEY_DRAW_USER_BACKGROUNDS "draw-user-backgrounds"
gpointer user_entry_ref (gpointer instance);
void user_entry_unref (gpointer instance);
GParamSpec* param_spec_user_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_entry (GValue* value, gpointer v_object);
void value_take_user_entry (GValue* value, gpointer v_object);
gpointer value_get_user_entry (const GValue* value);
GType user_entry_get_type (void) G_GNUC_CONST;
UserEntry* user_list_get_selected_entry (UserList* self);
void background_set_current_background (Background* self, const gchar* value);
static void main_window_change_background (MainWindow* self);
const gchar* background_get_current_background (Background* self);
static gboolean _main_window_change_background_timeout_cb_gsource_func (gpointer self);
static gboolean main_window_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
void background_set_active_monitor (Background* self, Monitor* monitor);
static gboolean main_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
void user_list_cancel_authentication (UserList* self);
GType user_list_scroll_target_get_type (void) G_GNUC_CONST;
void user_list_scroll (UserList* self, UserListScrollTarget target);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static GObject * main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
gchar* ug_settings_get_string (const gchar* key);
#define UG_SETTINGS_KEY_BACKGROUND_COLOR "background-color"
void unity_greeter_add_style_class (GtkWidget* widget);
Background* background_new (cairo_surface_t* target_surface);
Background* background_construct (GType object_type, cairo_surface_t* target_surface);
#define UG_SETTINGS_KEY_DRAW_GRID "draw-grid"
void background_set_draw_grid (Background* self, gboolean value);
#define UG_SETTINGS_KEY_BACKGROUND "background"
void background_set_default_background (Background* self, const gchar* value);
void background_set_logo (Background* self, const gchar* version_logo, const gchar* background_logo);
#define UG_SETTINGS_KEY_LOGO "logo"
#define UG_SETTINGS_KEY_BACKGROUND_LOGO "background-logo"
MenuBar* menu_bar_new (Background* bg, GtkAccelGroup* ag);
MenuBar* menu_bar_construct (GType object_type, Background* bg, GtkAccelGroup* ag);
static void _main_window___lambda7_ (MainWindow* self);
static void __main_window___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
UserList* user_list_new (Background* bg, MenuBar* mb);
UserList* user_list_construct (GType object_type, Background* bg, MenuBar* mb);
static void _main_window___lambda8_ (MainWindow* self);
static void __main_window___lambda8__user_list_user_displayed_start (UserList* _sender, gpointer self);
static void _main_window___lambda9_ (MainWindow* self);
void menu_bar_set_layouts (MenuBar* self, GList* layouts);
static void __main_window___lambda9__user_list_user_displayed_done (UserList* _sender, gpointer self);
static void _main_window_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self);
static void main_window_finalize (GObject* obj);


static void _monitor_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (monitor_unref (var), NULL));
}


static void _g_list_free__monitor_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _monitor_unref0_, NULL);
	g_list_free (self);
}


static void main_window_monitors_changed_cb (MainWindow* self, GdkScreen* screen) {
	GdkScreen* _tmp0_;
	gint _tmp1_ = 0;
	GdkScreen* _tmp2_;
	gint _tmp3_ = 0;
	Background* _tmp34_;
	GList* _tmp35_;
	GdkScreen* _tmp36_;
	gint _tmp37_ = 0;
	GdkScreen* _tmp38_;
	gint _tmp39_ = 0;
	GList* _tmp40_;
	gconstpointer _tmp41_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_width (_tmp0_);
	_tmp2_ = screen;
	_tmp3_ = gdk_screen_get_height (_tmp2_);
	g_debug ("main-window.vala:98: Screen is %dx%d pixels", _tmp1_, _tmp3_);
	__g_list_free__monitor_unref0_0 (self->priv->monitors);
	self->priv->monitors = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GdkScreen* _tmp8_;
				gint _tmp9_ = 0;
				GdkRectangle geometry = {0};
				GdkScreen* _tmp10_;
				gint _tmp11_;
				GdkRectangle _tmp12_ = {0};
				gint _tmp13_;
				GdkRectangle _tmp14_;
				gint _tmp15_;
				GdkRectangle _tmp16_;
				gint _tmp17_;
				GdkRectangle _tmp18_;
				gint _tmp19_;
				GdkRectangle _tmp20_;
				gint _tmp21_;
				GdkScreen* _tmp22_;
				gint _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = screen;
				_tmp9_ = gdk_screen_get_n_monitors (_tmp8_);
				if (!(_tmp7_ < _tmp9_)) {
					break;
				}
				_tmp10_ = screen;
				_tmp11_ = i;
				gdk_screen_get_monitor_geometry (_tmp10_, _tmp11_, &_tmp12_);
				geometry = _tmp12_;
				_tmp13_ = i;
				_tmp14_ = geometry;
				_tmp15_ = _tmp14_.width;
				_tmp16_ = geometry;
				_tmp17_ = _tmp16_.height;
				_tmp18_ = geometry;
				_tmp19_ = _tmp18_.x;
				_tmp20_ = geometry;
				_tmp21_ = _tmp20_.y;
				g_debug ("main-window.vala:104: Monitor %d is %dx%d pixels at %d,%d", _tmp13_, _tmp15_, _tmp17_, _tmp19_, _tmp21_);
				_tmp22_ = screen;
				_tmp23_ = i;
				_tmp24_ = main_window_monitor_is_unique_position (self, _tmp22_, _tmp23_);
				if (_tmp24_) {
					GdkRectangle _tmp25_;
					gint _tmp26_;
					GdkRectangle _tmp27_;
					gint _tmp28_;
					GdkRectangle _tmp29_;
					gint _tmp30_;
					GdkRectangle _tmp31_;
					gint _tmp32_;
					Monitor* _tmp33_;
					_tmp25_ = geometry;
					_tmp26_ = _tmp25_.x;
					_tmp27_ = geometry;
					_tmp28_ = _tmp27_.y;
					_tmp29_ = geometry;
					_tmp30_ = _tmp29_.width;
					_tmp31_ = geometry;
					_tmp32_ = _tmp31_.height;
					_tmp33_ = monitor_new (_tmp26_, _tmp28_, _tmp30_, _tmp32_);
					self->priv->monitors = g_list_append (self->priv->monitors, _tmp33_);
				}
			}
		}
	}
	_tmp34_ = self->priv->background;
	_tmp35_ = self->priv->monitors;
	background_set_monitors (_tmp34_, _tmp35_);
	_tmp36_ = screen;
	_tmp37_ = gdk_screen_get_width (_tmp36_);
	_tmp38_ = screen;
	_tmp39_ = gdk_screen_get_height (_tmp38_);
	gtk_window_resize ((GtkWindow*) self, _tmp37_, _tmp39_);
	gtk_window_move ((GtkWindow*) self, 0, 0);
	_tmp40_ = self->priv->monitors;
	_tmp41_ = g_list_nth_data (_tmp40_, (guint) 0);
	main_window_move_to_monitor (self, (Monitor*) _tmp41_);
}


static gboolean main_window_monitor_is_unique_position (MainWindow* self, GdkScreen* screen, gint n) {
	gboolean result = FALSE;
	GdkRectangle g0 = {0};
	GdkScreen* _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (screen != NULL, FALSE);
	_tmp0_ = screen;
	_tmp1_ = n;
	gdk_screen_get_monitor_geometry (_tmp0_, _tmp1_, &_tmp2_);
	g0 = _tmp2_;
	{
		gint _tmp3_;
		gint i;
		_tmp3_ = n;
		i = _tmp3_ + 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GdkScreen* _tmp8_;
				gint _tmp9_ = 0;
				GdkRectangle g1 = {0};
				GdkScreen* _tmp10_;
				gint _tmp11_;
				GdkRectangle _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				GdkRectangle _tmp14_;
				gint _tmp15_;
				GdkRectangle _tmp16_;
				gint _tmp17_;
				gboolean _tmp22_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = screen;
				_tmp9_ = gdk_screen_get_n_monitors (_tmp8_);
				if (!(_tmp7_ < _tmp9_)) {
					break;
				}
				_tmp10_ = screen;
				_tmp11_ = i;
				gdk_screen_get_monitor_geometry (_tmp10_, _tmp11_, &_tmp12_);
				g1 = _tmp12_;
				_tmp14_ = g0;
				_tmp15_ = _tmp14_.x;
				_tmp16_ = g1;
				_tmp17_ = _tmp16_.x;
				if (_tmp15_ == _tmp17_) {
					GdkRectangle _tmp18_;
					gint _tmp19_;
					GdkRectangle _tmp20_;
					gint _tmp21_;
					_tmp18_ = g0;
					_tmp19_ = _tmp18_.y;
					_tmp20_ = g1;
					_tmp21_ = _tmp20_.y;
					_tmp13_ = _tmp19_ == _tmp21_;
				} else {
					_tmp13_ = FALSE;
				}
				_tmp22_ = _tmp13_;
				if (_tmp22_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean main_window_change_background_timeout_cb (MainWindow* self) {
	gboolean result = FALSE;
	gchar* new_background_file = NULL;
	gboolean _tmp0_ = FALSE;
	MenuBar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp5_;
	Background* _tmp11_;
	const gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->menubar;
	_tmp2_ = menu_bar_get_high_contrast (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = ug_settings_get_boolean (UG_SETTINGS_KEY_DRAW_USER_BACKGROUNDS);
		_tmp0_ = !_tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		_g_free0 (new_background_file);
		new_background_file = NULL;
	} else {
		UserList* _tmp6_;
		UserEntry* _tmp7_;
		UserEntry* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = self->user_list;
		_tmp7_ = user_list_get_selected_entry (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->background;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (new_background_file);
		new_background_file = _tmp10_;
	}
	_tmp11_ = self->priv->background;
	_tmp12_ = new_background_file;
	background_set_current_background (_tmp11_, _tmp12_);
	self->priv->change_background_timeout = (guint) 0;
	result = FALSE;
	_g_free0 (new_background_file);
	return result;
}


static gboolean _main_window_change_background_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = main_window_change_background_timeout_cb (self);
	return result;
}


static void main_window_change_background (MainWindow* self) {
	Background* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background;
	_tmp1_ = background_get_current_background (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		guint _tmp3_;
		_tmp3_ = self->priv->change_background_timeout;
		if (_tmp3_ == ((guint) 0)) {
			guint _tmp4_ = 0U;
			_tmp4_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _main_window_change_background_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->change_background_timeout = _tmp4_;
		}
	} else {
		main_window_change_background_timeout_cb (self);
	}
}


static gpointer _monitor_ref0 (gpointer self) {
	return self ? monitor_ref (self) : NULL;
}


static gboolean main_window_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MainWindow * self;
	gboolean result = FALSE;
	GdkEventMotion _tmp0_;
	gdouble _tmp1_;
	gint x;
	GdkEventMotion _tmp2_;
	gdouble _tmp3_;
	gint y;
	GdkEventMotion _tmp4_;
	GdkWindow* _tmp5_;
	GdkWindow* _tmp6_ = NULL;
	GList* _tmp22_;
	self = (MainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.x;
	x = (gint) (_tmp1_ + 0.5);
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.y;
	y = (gint) (_tmp3_ + 0.5);
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.window;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
	if (_tmp5_ != _tmp6_) {
		gint w_x = 0;
		gint w_y = 0;
		GdkWindow* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GdkEventMotion _tmp14_;
		GdkWindow* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_get_origin (_tmp7_, &_tmp8_, &_tmp9_);
		w_x = _tmp8_;
		w_y = _tmp9_;
		_tmp10_ = x;
		_tmp11_ = w_x;
		x = _tmp10_ - _tmp11_;
		_tmp12_ = y;
		_tmp13_ = w_y;
		y = _tmp12_ - _tmp13_;
		_tmp14_ = *event;
		_tmp15_ = _tmp14_.window;
		gdk_window_get_origin (_tmp15_, &_tmp16_, &_tmp17_);
		w_x = _tmp16_;
		w_y = _tmp17_;
		_tmp18_ = x;
		_tmp19_ = w_x;
		x = _tmp18_ + _tmp19_;
		_tmp20_ = y;
		_tmp21_ = w_y;
		y = _tmp20_ + _tmp21_;
	}
	_tmp22_ = self->priv->monitors;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp22_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Monitor* _tmp23_;
			Monitor* m = NULL;
			_tmp23_ = _monitor_ref0 ((Monitor*) m_it->data);
			m = _tmp23_;
			{
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gint _tmp27_;
				Monitor* _tmp28_;
				gint _tmp29_;
				gboolean _tmp35_;
				gboolean _tmp39_;
				gboolean _tmp45_;
				_tmp27_ = x;
				_tmp28_ = m;
				_tmp29_ = _tmp28_->x;
				if (_tmp27_ >= _tmp29_) {
					gint _tmp30_;
					Monitor* _tmp31_;
					gint _tmp32_;
					Monitor* _tmp33_;
					gint _tmp34_;
					_tmp30_ = x;
					_tmp31_ = m;
					_tmp32_ = _tmp31_->x;
					_tmp33_ = m;
					_tmp34_ = _tmp33_->width;
					_tmp26_ = _tmp30_ <= (_tmp32_ + _tmp34_);
				} else {
					_tmp26_ = FALSE;
				}
				_tmp35_ = _tmp26_;
				if (_tmp35_) {
					gint _tmp36_;
					Monitor* _tmp37_;
					gint _tmp38_;
					_tmp36_ = y;
					_tmp37_ = m;
					_tmp38_ = _tmp37_->y;
					_tmp25_ = _tmp36_ >= _tmp38_;
				} else {
					_tmp25_ = FALSE;
				}
				_tmp39_ = _tmp25_;
				if (_tmp39_) {
					gint _tmp40_;
					Monitor* _tmp41_;
					gint _tmp42_;
					Monitor* _tmp43_;
					gint _tmp44_;
					_tmp40_ = y;
					_tmp41_ = m;
					_tmp42_ = _tmp41_->y;
					_tmp43_ = m;
					_tmp44_ = _tmp43_->height;
					_tmp24_ = _tmp40_ <= (_tmp42_ + _tmp44_);
				} else {
					_tmp24_ = FALSE;
				}
				_tmp45_ = _tmp24_;
				if (_tmp45_) {
					Monitor* _tmp46_;
					_tmp46_ = m;
					main_window_move_to_monitor (self, _tmp46_);
					_monitor_unref0 (m);
					break;
				}
				_monitor_unref0 (m);
			}
		}
	}
	result = FALSE;
	return result;
}


static void main_window_move_to_monitor (MainWindow* self, Monitor* monitor) {
	GtkBox* _tmp0_;
	Monitor* _tmp1_;
	gint _tmp2_;
	Monitor* _tmp3_;
	gint _tmp4_;
	Background* _tmp5_;
	Monitor* _tmp6_;
	Background* _tmp7_;
	GtkBox* _tmp8_;
	Monitor* _tmp9_;
	gint _tmp10_;
	Monitor* _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = self->priv->login_box;
	_tmp1_ = monitor;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = monitor;
	_tmp4_ = _tmp3_->height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, _tmp2_, _tmp4_);
	_tmp5_ = self->priv->background;
	_tmp6_ = monitor;
	background_set_active_monitor (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->background;
	_tmp8_ = self->priv->login_box;
	_tmp9_ = monitor;
	_tmp10_ = _tmp9_->x;
	_tmp11_ = monitor;
	_tmp12_ = _tmp11_->y;
	gtk_fixed_move ((GtkFixed*) _tmp7_, (GtkWidget*) _tmp8_, _tmp10_, _tmp12_);
}


static gboolean main_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MainWindow * self;
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	self = (MainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case GDK_KEY_Escape:
		{
			UserList* _tmp2_;
			_tmp2_ = self->user_list;
			user_list_cancel_authentication (_tmp2_);
			break;
		}
		case GDK_KEY_Page_Up:
		case GDK_KEY_KP_Page_Up:
		{
			UserList* _tmp3_;
			_tmp3_ = self->user_list;
			user_list_scroll (_tmp3_, USER_LIST_SCROLL_TARGET_START);
			break;
		}
		case GDK_KEY_Page_Down:
		case GDK_KEY_KP_Page_Down:
		{
			UserList* _tmp4_;
			_tmp4_ = self->user_list;
			user_list_scroll (_tmp4_, USER_LIST_SCROLL_TARGET_END);
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_KP_Up:
		{
			UserList* _tmp5_;
			_tmp5_ = self->user_list;
			user_list_scroll (_tmp5_, USER_LIST_SCROLL_TARGET_UP);
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_KP_Down:
		{
			UserList* _tmp6_;
			_tmp6_ = self->user_list;
			user_list_scroll (_tmp6_, USER_LIST_SCROLL_TARGET_DOWN);
			break;
		}
		case GDK_KEY_F10:
		{
			MenuBar* _tmp7_;
			_tmp7_ = self->priv->menubar;
			gtk_menu_shell_select_first ((GtkMenuShell*) _tmp7_, FALSE);
			break;
		}
		default:
		{
			GdkEventKey _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = *event;
			_tmp9_ = GTK_WIDGET_CLASS (main_window_parent_class)->key_press_event ((GtkWidget*) GTK_WINDOW (self), &_tmp8_);
			result = _tmp9_;
			return result;
		}
	}
	result = TRUE;
	return result;
}


MainWindow* main_window_construct (GType object_type) {
	MainWindow * self = NULL;
	self = (MainWindow*) g_object_new (object_type, NULL);
	return self;
}


MainWindow* main_window_new (void) {
	return main_window_construct (TYPE_MAIN_WINDOW);
}


static void _main_window___lambda7_ (MainWindow* self) {
	main_window_change_background (self);
}


static void __main_window___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_main_window___lambda7_ (self);
}


static void _main_window___lambda8_ (MainWindow* self) {
	main_window_change_background (self);
}


static void __main_window___lambda8__user_list_user_displayed_start (UserList* _sender, gpointer self) {
	_main_window___lambda8_ (self);
}


static void _main_window___lambda9_ (MainWindow* self) {
	MenuBar* _tmp0_;
	UserList* _tmp1_;
	UserEntry* _tmp2_;
	UserEntry* _tmp3_;
	GList* _tmp4_;
	_tmp0_ = self->priv->menubar;
	_tmp1_ = self->user_list;
	_tmp2_ = user_list_get_selected_entry (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->keyboard_layouts;
	menu_bar_set_layouts (_tmp0_, _tmp4_);
	main_window_change_background (self);
}


static void __main_window___lambda9__user_list_user_displayed_done (UserList* _sender, gpointer self) {
	_main_window___lambda9_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _main_window_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self) {
	main_window_monitors_changed_cb (self, _sender);
}


static GObject * main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MainWindow * self;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	GtkAccelGroup* _tmp2_;
	GtkAccelGroup* accel_group;
	GtkAccelGroup* _tmp3_;
	GdkRGBA bg_color = {0};
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GdkRGBA _tmp6_;
	AtkObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GdkWindow* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_;
	cairo_surface_t* _tmp12_ = NULL;
	Background* _tmp13_;
	Background* _tmp14_;
	Background* _tmp15_;
	gboolean _tmp16_ = FALSE;
	Background* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	Background* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	Background* _tmp25_;
	Background* _tmp26_;
	Background* _tmp27_;
	GtkBox* _tmp28_;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	Background* _tmp31_;
	GtkBox* _tmp32_;
	Background* _tmp33_;
	GtkAccelGroup* _tmp34_;
	MenuBar* _tmp35_;
	MenuBar* _tmp36_;
	MenuBar* _tmp37_;
	MenuBar* _tmp38_;
	GtkBox* _tmp39_;
	MenuBar* _tmp40_;
	MenuBar* _tmp41_;
	Background* _tmp42_;
	MenuBar* _tmp43_;
	UserList* _tmp44_;
	UserList* _tmp45_;
	UserList* _tmp46_;
	UserList* _tmp47_;
	UserList* _tmp48_;
	UserList* _tmp49_;
	GtkBox* _tmp50_;
	UserList* _tmp51_;
	UserList* _tmp52_;
	gboolean _tmp53_;
	parent_class = G_OBJECT_CLASS (main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MAIN_WINDOW (obj);
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_POINTER_MOTION_MASK);
	_tmp2_ = gtk_accel_group_new ();
	accel_group = _tmp2_;
	_tmp3_ = accel_group;
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp3_);
	memset (&bg_color, 0, sizeof (GdkRGBA));
	_tmp4_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_COLOR);
	_tmp5_ = _tmp4_;
	gdk_rgba_parse (&bg_color, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = bg_color;
	gtk_widget_override_background_color ((GtkWidget*) self, GTK_STATE_FLAG_NORMAL, &_tmp6_);
	_tmp7_ = gtk_widget_get_accessible ((GtkWidget*) self);
	_tmp8_ = _ ("Login Screen");
	atk_object_set_name (_tmp7_, _tmp8_);
	gtk_window_set_has_resize_grip ((GtkWindow*) self, FALSE);
	unity_greeter_add_style_class ((GtkWidget*) self);
	gtk_widget_realize ((GtkWidget*) self);
	_tmp9_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp10_ = gdk_cairo_create (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = cairo_get_target (_tmp11_);
	_tmp13_ = background_new (_tmp12_);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp14_;
	_cairo_destroy0 (_tmp11_);
	_tmp15_ = self->priv->background;
	_tmp16_ = ug_settings_get_boolean (UG_SETTINGS_KEY_DRAW_GRID);
	background_set_draw_grid (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->background;
	_tmp18_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND);
	_tmp19_ = _tmp18_;
	background_set_default_background (_tmp17_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = self->priv->background;
	_tmp21_ = ug_settings_get_string (UG_SETTINGS_KEY_LOGO);
	_tmp22_ = _tmp21_;
	_tmp23_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_LOGO);
	_tmp24_ = _tmp23_;
	background_set_logo (_tmp20_, _tmp22_, _tmp24_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp25_ = self->priv->background;
	gtk_widget_show ((GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->background;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->background;
	unity_greeter_add_style_class ((GtkWidget*) _tmp27_);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp29_ = g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->login_box);
	self->priv->login_box = _tmp29_;
	_tmp30_ = self->priv->login_box;
	gtk_widget_show ((GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->background;
	_tmp32_ = self->priv->login_box;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->background;
	_tmp34_ = accel_group;
	_tmp35_ = menu_bar_new (_tmp33_, _tmp34_);
	_tmp36_ = g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp36_;
	_tmp37_ = self->priv->menubar;
	g_signal_connect_object ((GObject*) _tmp37_, "notify::high-contrast", (GCallback) __main_window___lambda7__g_object_notify, self, 0);
	_tmp38_ = self->priv->menubar;
	gtk_widget_show ((GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->login_box;
	_tmp40_ = self->priv->menubar;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->menubar;
	unity_greeter_add_style_class ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->background;
	_tmp43_ = self->priv->menubar;
	_tmp44_ = user_list_new (_tmp42_, _tmp43_);
	_tmp45_ = g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->user_list);
	self->user_list = _tmp45_;
	_tmp46_ = self->user_list;
	g_object_set ((GtkWidget*) _tmp46_, "expand", TRUE, NULL);
	_tmp47_ = self->user_list;
	g_signal_connect_object (_tmp47_, "user-displayed-start", (GCallback) __main_window___lambda8__user_list_user_displayed_start, self, 0);
	_tmp48_ = self->user_list;
	g_signal_connect_object (_tmp48_, "user-displayed-done", (GCallback) __main_window___lambda9__user_list_user_displayed_done, self, 0);
	_tmp49_ = self->user_list;
	gtk_widget_show ((GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->login_box;
	_tmp51_ = self->user_list;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = self->user_list;
	unity_greeter_add_style_class ((GtkWidget*) _tmp52_);
	_tmp53_ = unity_greeter_test_mode;
	if (_tmp53_) {
		Monitor* _tmp54_;
		Monitor* _tmp55_;
		Background* _tmp56_;
		GList* _tmp57_;
		GList* _tmp58_;
		gconstpointer _tmp59_ = NULL;
		__g_list_free__monitor_unref0_0 (self->priv->monitors);
		self->priv->monitors = NULL;
		_tmp54_ = monitor_new (0, 0, 800, 600);
		self->priv->monitors = g_list_append (self->priv->monitors, _tmp54_);
		_tmp55_ = monitor_new (800, 120, 640, 480);
		self->priv->monitors = g_list_append (self->priv->monitors, _tmp55_);
		_tmp56_ = self->priv->background;
		_tmp57_ = self->priv->monitors;
		background_set_monitors (_tmp56_, _tmp57_);
		_tmp58_ = self->priv->monitors;
		_tmp59_ = g_list_nth_data (_tmp58_, (guint) 0);
		main_window_move_to_monitor (self, (Monitor*) _tmp59_);
		gtk_window_resize ((GtkWindow*) self, 800 + 640, 600);
	} else {
		GdkScreen* _tmp60_ = NULL;
		GdkScreen* _tmp61_;
		GdkScreen* screen;
		GdkScreen* _tmp62_;
		GdkScreen* _tmp63_;
		_tmp60_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp61_ = _g_object_ref0 (_tmp60_);
		screen = _tmp61_;
		_tmp62_ = screen;
		g_signal_connect_object (_tmp62_, "monitors-changed", (GCallback) _main_window_monitors_changed_cb_gdk_screen_monitors_changed, self, 0);
		_tmp63_ = screen;
		main_window_monitors_changed_cb (self, _tmp63_);
		_g_object_unref0 (screen);
	}
	_g_object_unref0 (accel_group);
	return obj;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	GTK_WIDGET_CLASS (klass)->motion_notify_event = main_window_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = main_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->constructor = main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->change_background_timeout = (guint) 0;
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = MAIN_WINDOW (obj);
	_g_object_unref0 (self->user_list);
	__g_list_free__monitor_unref0_0 (self->priv->monitors);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->login_box);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}



