// -*- Mode: C++; indent-tabs-mode: nil; tab-width: 2 -*-
/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jason Smith <jason.smith@canonical.com>
 */

#ifndef UNITY_DECAYMULATOR_H
#define UNITY_DECAYMULATOR_H

#include <Nux/Nux.h>
#include <glib.h>

namespace unity
{
namespace ui
{

class Decaymulator
{
public:
  typedef std::shared_ptr<Decaymulator> Ptr;

  nux::Property<int> rate_of_decay;
  nux::Property<int> value;

  Decaymulator();
  ~Decaymulator();

private:
  void OnValueChanged(int value);
  static gboolean OnDecayTimeout (gpointer value);

  guint on_decay_handle;
};

}
}

#endif
