/**
 * @file geis_xcb_backend.h
 * @brief the XCB-based grail back end
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef GEIS_BACKEND_XCB_BACKEND_H_
#define GEIS_BACKEND_XCB_BACKEND_H_

#include "geis/geis.h"
#include "geis_xcb_backend_token.h"

typedef struct GeisXcbBackend *GeisXcbBackend;


/**
 * Gets the GEIS instance for a back end.
 */
Geis geis_xcb_backend_geis(GeisXcbBackend be);

/**
 * Sets a token as active in the back end.
 */
void geis_xcb_backend_add_token(GeisXcbBackend be, XcbBackendToken token);

/**
 * Removes a token as active in the back end.
 */
void geis_xcb_backend_remove_token(GeisXcbBackend be, XcbBackendToken token);

/**
 * Actually selects XCB events for all active tokens in the back end.
 */
void geis_xcb_backend_select_events(GeisXcbBackend be,
                                    uint16_t       device,
                                    xcb_window_t   window);

#endif /* GEIS_BACKEND_XCB_BACKEND_H_ */
