/**
 * @file gtest_geis_fixture.h
 * @brief A GTest fixture for testing the full uTouch stack through GEIS.
 */
/*
 *  Copyright 2012 Canonical Ltd.
 *
 *  This program is free software: you can redistribute it and/or modify it 
 *  under the terms of the GNU General Public License version 3, as published 
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranties of 
 *  MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along 
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef GTEST_GEIS_FIXTURE_H_
#define GTEST_GEIS_FIXTURE_H_

#include "geis/geis.h"
#include <gtest/gtest.h>
#include <xorg/gtest/test.h>


/**
 * Fixture for testing expected attributes.
 */
class GTestGeisFixture
: public xorg::testing::Test
{
public:
  void
  SetUp();

  void
  TearDown();

  int
  geis_fd();

private:
  /** Setup of teh GEIS instance:  override for special treatment. */
  virtual void
  setup_geis();

protected:
  Geis  geis_;
};


#endif /* GTEST_GEIS_FIXTURE_H_ */

