/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "grail-bits.h"

static const int grail_bits_in_byte[256] =
{
	0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
	3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,
};

static const int grail_first_set_bit[256] =
{
	-1,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
	5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
};

void GRAIL_PUBLIC grail_mask_set_mask(grail_mask_t *a, const grail_mask_t *b,
				      int bytes)
{
	while (bytes--)
		*a++ |= *b++;
}

void GRAIL_PUBLIC grail_mask_clear_mask(grail_mask_t *a, const grail_mask_t *b,
					int bytes)
{
	while (bytes--)
		*a++ &= ~*b++;
}

int GRAIL_PUBLIC grail_mask_count(const grail_mask_t *mask, int bytes)
{
	int count = 0;
	while (bytes--)
		count += grail_bits_in_byte[*mask++];
	return count;
}

int GRAIL_PUBLIC grail_mask_get_first(const grail_mask_t *mask, int bytes)
{
	int k;
	for (k = 0; k < bytes; k++)
		if (mask[k])
			return (k << 3) | grail_first_set_bit[mask[k]];
	return -1;
}

int GRAIL_PUBLIC grail_mask_get_next(int i, const grail_mask_t *mask, int bytes)
{
	int k = ++i >> 3;
	if (k < bytes) {
		i = grail_first_set_bit[mask[k] & (~0 << (i & 7))];
		if (i >= 0)
			return (k << 3) | i;
		while (++k < bytes) {
			i = grail_first_set_bit[mask[k]];
			if (i >= 0)
				return (k << 3) | i;
		}
	}
	return -1;
}
