#!/usr/bin/env python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2010-2011 Bryce Harrington bryce@canonical.com
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import re
import glob
import DistUtilsExtra.auto

from xdiagnose import info

changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

DistUtilsExtra.auto.setup(
    name             = info.PROGNAME,
    version          = version,
    url              = info.URL,
    author           = info.LEAD_DEVELOPER.name,
    author_email     = info.LEAD_DEVELOPER.email,
    description      = info.SHORT_DESCRIPTION,
    long_description = info.DESCRIPTION,
    license          = info.LICENSE_URL,
    platforms        = ['any'],
    requires         = ['gobject', 'pygtk'],
    packages     = [
        'xdiagnose',
        'xdiagnose/utils',
        ],
    package_data = {
        },
    data_files   = [
        ('share/xdiagnose/icons',         ['data/icons/microscope.svg']),
        ('share/xdiagnose/workloads',     glob.glob('data/workloads/*')),
        ('share/xdiagnose',               glob.glob('data/failsafe*')),
        ],
    scripts      = [
        'bin/dpkg-log-summary',
        'bin/xdiagnose',
        'bin/xrandr-tool',
        'bin/xpci',
        ],
    )
