/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

public final class UriUtils {
    public static String extractScheme(String uri) {
        int colonPos = uri.indexOf(58);
        if (colonPos < 0) {
            return null;
        }
        String scheme = uri.substring(0, colonPos);
        if (scheme.indexOf(47) >= 0 || scheme.indexOf(35) >= 0) {
            return null;
        }
        return scheme;
    }

    public static boolean isSafeUri(String uri) {
        String scheme = UriUtils.extractScheme(uri);
        if (scheme == null) {
            return true;
        }
        String schemeLc = scheme.toLowerCase();
        return "http".equals(schemeLc) || "https".equals(schemeLc) || "ftp".equals(schemeLc) || "mailto".equals(schemeLc) || "MAILTO".equals(scheme.toUpperCase());
    }

    public static String sanitizeUri(String uri) {
        if (UriUtils.isSafeUri(uri)) {
            return uri;
        }
        return "#";
    }

    private UriUtils() {
    }
}

