/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AttachVolume
extends BaseCmd {
    private static final String DEVICE_DESC = "A device name as which to expose VOLUME inside INSTANCE.";
    private static final String INSTANCE_DESC = "A running instance to which to attach VOLUME.";
    private static final String INSTANCE_ARG = "INSTANCE";
    private static final String DEVICE_ARG = "DEVICE";

    public AttachVolume(String[] args) {
        super("ec2attvol", "ec2-attach-volume");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)INSTANCE_ARG);
        OptionBuilder.withDescription((String)INSTANCE_DESC);
        result.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"device");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)DEVICE_ARG);
        OptionBuilder.withDescription((String)DEVICE_DESC);
        result.addOption(OptionBuilder.create((String)"d"));
        return result;
    }

    protected String getOptionString() {
        return "VOLUME -i INSTANCE -d DEVICE";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Attach an available volume to an instance as a specific device.");
        System.out.println("     The VOLUME parameter specifies an available volume to attach.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("instance");
        this.printOption("device");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("VOLUME");
        this.assertOptionSet("instance");
        this.assertOptionSet("device");
        this.warnIfTooManyNonOptions();
        String volumeId = this.getNonOptions()[0];
        String instanceId = this.getOptionValue("instance");
        String device = this.getOptionValue("device");
        RequestResultPair rsp = jec2.attachVolume(volumeId, instanceId, device);
        if (rsp.getResponse() != null) {
            out.output(System.out, (AttachmentDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new AttachVolume(args).invoke();
    }
}

