/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.Jec2Impl;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ConfirmProductInstance
extends BaseCmd {
    private static final String INSTANCE_DESC = "Confirm the INSTANCE is running with the PRODUCT_CODE.";
    private static final String INSTANCE_ARG = "INSTANCE_ID";

    public ConfirmProductInstance(String[] args) {
        super("ec2cpi", "ec2-confirm-product-instance");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)INSTANCE_DESC);
        OptionBuilder.withArgName((String)INSTANCE_ARG);
        result.addOption(OptionBuilder.create((String)"i"));
        return result;
    }

    protected String getOptionString() {
        return "PRODUCT_CODE -i INSTANCE_ID";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Confirms if instance with id INSTANCE_ID is running with PRODUCT_CODE attached.");
        System.out.println("     PRODUCT_CODE is a DevPay product code, and must be owned by you.");
        System.out.println("     INSTANCE_ID is an instance id.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("instance");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] nonOpts = this.getNonOptions();
        if (nonOpts.length == 0) {
            throw new MissingNonOption("PRODUCT_CODE");
        }
        if (nonOpts.length > 1) {
            throw new InvalidArgumentCombination("Too many PRODUCT_CODEs specified");
        }
        String productCode = nonOpts[0];
        String instanceId = this.getOptionValue("instance");
        Jec2Impl.ConfirmProductInstanceResult res = jec2.confirmProductInstance(productCode, instanceId);
        out.output(System.out, productCode, instanceId, res.confirmed, res.ownerId);
        return true;
    }

    public static void main(String[] args) {
        new ConfirmProductInstance(args).invoke();
    }
}

