/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.OfferingType;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.Tenancy;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeReservedInstancesOfferings
extends BaseCmd {
    private static final String PRODUCT_DESCRIPTION_ARG = "DESCRIPTION";
    private static final String PRODUCT_DESCRIPTION = "description";
    private static final String TYPE_ARG = "INSTANCE-TYPE";
    private static final String TYPE = "type";
    private static final String ZONE_ARG = "ZONE";
    private static final String ZONE = "availability-zone";
    private static final String OFFERING_TYPE = "offering-type";
    private static final String OFFERING_TYPE_ARG = "OFFERING-TYPE";
    private static final String[] OFFERING_TYPE_DESC = new String[]{"Specifies the offering type. It can be Traditional or AlwaysOn (case-sensitive).", " - Traditional: Provides the most flexibility with elasticity.", " - AlwaysOn: Rewards longer usage with lower prices."};
    private static final String[] TENANCY_DESC = new String[]{"Specifies the tenancy of the instances, which can be default or dedicated.", " - default: Tenancy is not restricted.", " - dedicated: The instance will run on single-tenant hardware,", "   additional charges will apply."};

    public DescribeReservedInstancesOfferings(String[] args) {
        super("ec2drio", "ec2-describe-reserved-instances-offerings");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)ZONE);
        OptionBuilder.withDescription((String)this.joinDescription("Find offerings in the specifed availability zone."));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)ZONE_ARG);
        result.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withLongOpt((String)TYPE);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Find offerings for the specified instance type."));
        OptionBuilder.withArgName((String)TYPE_ARG);
        result.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)PRODUCT_DESCRIPTION);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Find offerings containing the following product description"));
        OptionBuilder.withArgName((String)PRODUCT_DESCRIPTION_ARG);
        result.addOption(OptionBuilder.create((String)"d"));
        result.addOption(DescribeReservedInstancesOfferings.createOptionWithArgs(null, "tenancy", TENANCY_DESC, "TENANCY"));
        result.addOption(DescribeReservedInstancesOfferings.createOptionWithArgs(null, OFFERING_TYPE, OFFERING_TYPE_DESC, OFFERING_TYPE_ARG));
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        result.addOption(OptionBuilder.create((String)"F"));
        return result;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe available reserved instances offerings");
        System.out.println("     If all parameters are unspecified, all available reserved instances offerings will be listed.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption(ZONE);
        this.printOption(TYPE);
        this.printOption(PRODUCT_DESCRIPTION);
        this.printOption("tenancy");
        this.printOption(OFFERING_TYPE);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        OfferingType offeringType;
        Tenancy tenancy;
        if (this.isOptionSet("tenancy")) {
            String value = this.getOptionValue("tenancy");
            tenancy = Tenancy.toTenancy((String)value);
            if (null == tenancy) {
                throw new InvalidArgument("tenancy", value);
            }
        } else {
            tenancy = null;
        }
        if (this.isOptionSet(OFFERING_TYPE)) {
            String value = this.getOptionValue(OFFERING_TYPE);
            offeringType = OfferingType.toOfferingType((String)value);
            if (null == offeringType) {
                throw new InvalidArgument(OFFERING_TYPE, value);
            }
        } else {
            offeringType = null;
        }
        RequestResultPair rsp = jec2.describeReservedInstancesOfferings(Arrays.asList(this.getNonOptions()), this.getOptionValue(ZONE), this.getOptionValue(TYPE), this.getOptionValue(PRODUCT_DESCRIPTION), tenancy, offeringType, this.getFilters(true));
        out.outputReservedInstanceOfferings(System.out, (List)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected String getOptionString() {
        return "[OFFERING [OFFERING [...]]] [-z ZONE] [-t INSTANCE-TYPE] [-d DESCRIPTION] [--tenancy TENANCY] [--offering-type OFFERING-TYPE]";
    }

    public static void main(String[] args) {
        new DescribeReservedInstancesOfferings(args).invoke();
    }
}

