/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeRouteTables
extends BaseCmd {
    public DescribeRouteTables(String[] args) {
        super("ec2drtb", "ec2-describe-route-tables");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    public String getOptionString() {
        return "[ROUTE_TABLE [ROUTE_TABLE [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your route tables.");
        System.out.println("     ROUTE_TABLE is the route table(s) to describe.");
        System.out.println("     If unspecified then all route tables will be returned.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        String[] routeTableIdSet = this.getNonOptions();
        RequestResultPair result = jec2.describeRouteTables(routeTableIdSet, this.getFilters(true));
        out.output(System.out, (List)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new DescribeRouteTables(args).invoke();
    }
}

