/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkAclAssociationDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ReplaceNetworkAclAssociation
extends BaseCmd {
    private static final String[] NETWORK_ACL_DESC = new String[]{"The new network acl to associate."};

    public ReplaceNetworkAclAssociation(String[] args) {
        super("ec2repnaclassoc", "ec2-replace-network-acl-association");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"network-acl");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"NETWORK_ACL");
        OptionBuilder.withDescription((String)ReplaceNetworkAclAssociation.joinDescription(NETWORK_ACL_DESC));
        options.addOption(OptionBuilder.create((String)"a"));
        return options;
    }

    public String getOptionString() {
        return "ASSOCIATION -a NETWORK_ACL";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Replace a network acl association with a new network ACL. ");
        System.out.println("     ASSOCIATION is the ID of the association to replace.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("network-acl");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("ASSOCIATION");
        this.warnIfTooManyNonOptions();
        String assocId = this.getNonOptions()[0];
        if (assocId == null || "".equals(assocId)) {
            throw new MissingNonOption("association");
        }
        String aclId = this.getOptionValue("network-acl");
        if (aclId == null || "".equals(aclId)) {
            throw new MissingArgument("network-acl");
        }
        RequestResultPair result = jec2.replaceNetworkAclAssociation(assocId, aclId);
        NetworkAclAssociationDescription desc = new NetworkAclAssociationDescription((String)result.getResponse(), aclId, null);
        out.output(System.out, desc);
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new ReplaceNetworkAclAssociation(args).invoke();
    }
}

