/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.ServerCertListByPathRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListServerCertificatesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListServerCertificatesResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ServerCertificateMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMServerCertListByPathDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMServerCertListByPathDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof ServerCertListByPathRequest) {
            ServerCertListByPathRequest listRequest = (ServerCertListByPathRequest)request;
            LOG.debug((Object)("Listing server certificates: " + listRequest));
            ListServerCertificatesRequest listSCRequest = new ListServerCertificatesRequest();
            listSCRequest.setPathPrefix(listRequest.getPathPrefix());
            ListServerCertificatesResult listSCResult = this.getClient().listServerCertificates(listSCRequest);
            for (ServerCertificateMetadata scMetadata : listSCResult.getServerCertificateMetadataList()) {
                LOG.info((Object)scMetadata.getArn());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

