/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDCodec;
import htsjdk.tribble.bed.BEDFeature;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Converts a BED file to an Picard Interval List.", usageShort="Converts a BED file to an Picard Interval List.", programGroup=Intervals.class)
public class BedToIntervalList
extends CommandLineProgram {
    @Option(shortName="I", doc="The input BED file")
    public File INPUT;
    @Option(shortName="SD", doc="The sequence dictionary")
    public File SEQUENCE_DICTIONARY;
    @Option(shortName="O", doc="The output Picard Interval List")
    public File OUTPUT;
    final Log LOG = Log.getInstance(this.getClass());

    public static void main(String[] args) {
        new BedToIntervalList().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        try {
            SamReader samReader = SamReaderFactory.makeDefault().open(this.SEQUENCE_DICTIONARY);
            SAMFileHeader header = samReader.getFileHeader();
            IntervalList intervalList = new IntervalList(header);
            CloserUtil.close((Object)samReader);
            AbstractFeatureReader bedReader = AbstractFeatureReader.getFeatureReader((String)this.INPUT.getAbsolutePath(), (FeatureCodec)new BEDCodec(BEDCodec.StartOffset.ZERO), (boolean)false);
            CloseableTribbleIterator iterator = bedReader.iterator();
            ProgressLogger progressLogger = new ProgressLogger(this.LOG, 1000000);
            while (iterator.hasNext()) {
                SAMSequenceRecord sequenceRecord;
                BEDFeature bedFeature = (BEDFeature)iterator.next();
                String sequenceName = bedFeature.getChr();
                int start = bedFeature.getStart() + 1;
                int end = bedFeature.getEnd();
                String name = bedFeature.getName();
                if (name.isEmpty()) {
                    name = null;
                }
                if (null == (sequenceRecord = header.getSequenceDictionary().getSequence(sequenceName))) {
                    throw new PicardException(String.format("Sequence '%s' was not found in the sequence dictionary", sequenceName));
                }
                if (start < 1) {
                    throw new PicardException(String.format("Start on sequence '%s' was less than one: %d", sequenceName, start));
                }
                if (sequenceRecord.getSequenceLength() < start) {
                    throw new PicardException(String.format("Start on sequence '%s' was past the end: %d < %d", sequenceName, sequenceRecord.getSequenceLength(), start));
                }
                if (end < 1) {
                    throw new PicardException(String.format("End on sequence '%s' was less than one: %d", sequenceName, end));
                }
                if (sequenceRecord.getSequenceLength() < end) {
                    throw new PicardException(String.format("End on sequence '%s' was past the end: %d < %d", sequenceName, sequenceRecord.getSequenceLength(), end));
                }
                if (end < start - 1) {
                    throw new PicardException(String.format("On sequence '%s', end < start-1: %d <= %d", sequenceName, end, start));
                }
                Interval interval = new Interval(sequenceName, start, end, bedFeature.getStrand() == Strand.POSITIVE, name);
                intervalList.add(interval);
                progressLogger.record(sequenceName, start);
            }
            CloserUtil.close((Object)bedReader);
            intervalList.uniqued().write(this.OUTPUT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }
}

