/* StateEntry.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.conjecture.history;

import be.ugent.caagt.swirl.dnd.LocalTransferHandler;

import java.awt.GridLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JPanel;

import org.grinvin.conjecture.filter.GraphFilter;
import org.grinvin.generators.graphs.GraphGeneratorInstance;
import org.grinvin.gui.components.FilterListComponent;
import org.grinvin.gui.components.GraphListComponent;
import org.grinvin.gui.components.InvariantListComponent;
import org.grinvin.invariants.Invariant;
import org.grinvin.list.graphs.DefaultGraphListModel;
import org.grinvin.list.invariants.DefaultInvariantListModel;
import org.grinvin.gui.components.GeneratorInstanceListComponent;
import org.grinvin.list.DefaultFilterListModel;
import org.grinvin.list.generators.DefaultGraphGeneratorInstanceListModel;
import org.grinvin.list.FilterListModel;
import org.grinvin.list.generators.GraphGeneratorInstanceListModel;
import org.grinvin.list.graphs.GraphList;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.graphs.GraphListModel;
import org.grinvin.list.invariants.InvariantList;
import org.grinvin.list.invariants.InvariantListModel;


/**
 * Implementation of {@link ConjectureHistoryEntry} that holds the state of the input for a conjecturing engine.
 */
public class StateEntry extends AbstractConjectureHistoryEntry<StateEntry> {
    
    public static final String TYPE = "STATE";
    
    private GraphListModel graphListModel;
    
    private InvariantListModel invariantListModel;
    
    private GraphGeneratorInstanceListModel generatorInstanceListModel;
    
    private FilterListModel filterListModel;
    
    /** Creates a new instance of StateEntry */
    public StateEntry(GraphList graphList, InvariantList invariantList, GraphGeneratorInstanceListModel generatorInstanceList, FilterListModel filterListModel) {
        super();
        this.graphListModel = new DefaultGraphListModel();
        this.invariantListModel = new DefaultInvariantListModel();
        this.generatorInstanceListModel = new DefaultGraphGeneratorInstanceListModel();
        this.filterListModel = new DefaultFilterListModel();
        this.graphListModel.addAll(graphList);
        this.invariantListModel.addAll(invariantList);
        this.generatorInstanceListModel.addAll(generatorInstanceList);
        this.filterListModel.addAll(filterListModel);
    }
    
    public StateEntry() {
        super();
    }
    
    public String toString(){
        StringBuffer string = new StringBuffer(Long.toString(getTimeStamp()));
        string.append("\nInvariants:");
        for(Invariant inv : invariantListModel)
            string.append("\n    " + inv.getName());
        string.append("\nGraphs:");
        for(GraphListElement gle : graphListModel)
            string.append("\n    " + gle);
        string.append("\nGenerators:");
        for(GraphGeneratorInstance geninst : generatorInstanceListModel)
            string.append("\n    " + geninst);
        string.append("\nFilters:");
        for(GraphFilter filter : filterListModel)
            string.append("\n    " + filter);
        return string.toString();
    }
    
    public JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1,3));
        panel.setName(DateFormat.getDateTimeInstance().format(new Date(getTimeStamp())));
        InvariantListComponent inv = new InvariantListComponent(invariantListModel, LocalTransferHandler.COPY, LocalTransferHandler.NONE);
        inv.setIsReadOnly(true);
        inv.setPaintWatermark(false);
        panel.add(inv);
        GraphListComponent graph = new GraphListComponent(graphListModel, LocalTransferHandler.COPY, LocalTransferHandler.NONE);
        graph.setIsReadOnly(true);
        graph.setPaintWatermark(false);
        panel.add(graph);
        GeneratorInstanceListComponent gen = new GeneratorInstanceListComponent(generatorInstanceListModel, LocalTransferHandler.COPY, LocalTransferHandler.NONE);
        gen.setIsReadOnly(true);
        gen.setPaintWatermark(false);
        panel.add(gen);
        FilterListComponent fil = new FilterListComponent(filterListModel, LocalTransferHandler.COPY, LocalTransferHandler.NONE);
        fil.setIsReadOnly(true);
        fil.setPaintWatermark(false);
        panel.add(fil);
        return panel;
    }
    
    public StateEntryDelegate getDelegate() {
        return new StateEntryDelegate();
    }
    
    public String getType() {
        return TYPE;
    }
    
    public GraphListModel getGraphListModel() {
        return graphListModel;
    }
    
    void setGraphListModel(GraphListModel graphListModel) {
        this.graphListModel = graphListModel;
    }
    
    public InvariantListModel getInvariantListModel() {
        return invariantListModel;
    }
    
    void setInvariantListModel(InvariantListModel invariantListModel) {
        this.invariantListModel = invariantListModel;
    }
    
    public GraphGeneratorInstanceListModel getGeneratorInstanceListModel() {
        return generatorInstanceListModel;
    }
    
    void setGeneratorInstanceListModel(GraphGeneratorInstanceListModel generatorInstanceListModel) {
        this.generatorInstanceListModel = generatorInstanceListModel;
    }
    
    public FilterListModel getFilterListModel() {
        return filterListModel;
    }

    void setFilterListModel(FilterListModel filterListModel) {
        this.filterListModel = filterListModel;
    }
    
}
