/* EmbeddingListener.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphs;

import java.util.EventListener;

/**
 * Listens to changes in an embedding. Note that changes to the peer graph
 * of the embedding are not propagated to the embedding.<p>
 *
 * <b>Note:</b> It is the responsibility of
 * the listener to keep track of the embedding being listened
 * to. This embedding is not handed to the listener as a parameter 
 * of the various methods.
 *
 * @see org.grinvin.graphs.GraphListener
 */
public interface EmbeddingListener extends EventListener {
    
    /**
     * Called after a vertex was given new coordinates.
     */
    public void vertexCoordinatesChanged (Vertex vertex);
    
    /**
     * Called when the dimension of the embedding was changed, and as a 
     * consequence that all coordinates have changed as well.
     */
    public void dimensionChanged (int oldDimension);
    
    /**
     * Called after a major change in the embedding. For instance when the
     * coordinates of all vertices change at the same time. Note that
     * also the peer of the embedding may have changed.
     * @see #dimensionChanged
     */
    public void embeddingChanged ();
    
}
